/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.metrics;

import io.sentry.MeasurementUnit;
import io.sentry.metrics.Metric;
import io.sentry.metrics.MetricType;
import io.sentry.util.Random;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@ApiStatus.Internal
public final class MetricsHelper {
    public static final long FLUSHER_SLEEP_TIME_MS = 5000L;
    public static final int MAX_TOTAL_WEIGHT = 100000;
    private static final int ROLLUP_IN_SECONDS = 10;
    private static final Pattern UNIT_PATTERN = Pattern.compile("\\W+");
    private static final Pattern NAME_PATTERN = Pattern.compile("[^\\w\\-.]+");
    private static final Pattern TAG_KEY_PATTERN = Pattern.compile("[^\\w\\-./]+");
    private static final char TAGS_PAIR_DELIMITER = ',';
    private static final char TAGS_KEY_VALUE_DELIMITER = '=';
    private static final char TAGS_ESCAPE_CHAR = '\\';
    private static long FLUSH_SHIFT_MS = (long)(new Random().nextFloat() * 10000.0f);

    public static long getTimeBucketKey(long timestampMs) {
        long seconds = timestampMs / 1000L;
        long bucketKey = seconds / 10L * 10L;
        if (timestampMs >= 0L) {
            return bucketKey;
        }
        return bucketKey - 1L;
    }

    public static long getCutoffTimestampMs(long nowMs) {
        return nowMs - 10000L - FLUSH_SHIFT_MS;
    }

    @NotNull
    public static String sanitizeUnit(@NotNull String unit) {
        return UNIT_PATTERN.matcher(unit).replaceAll("");
    }

    @NotNull
    public static String sanitizeName(@NotNull String input) {
        return NAME_PATTERN.matcher(input).replaceAll("_");
    }

    @NotNull
    public static String sanitizeTagKey(@NotNull String input) {
        return TAG_KEY_PATTERN.matcher(input).replaceAll("");
    }

    @NotNull
    public static String sanitizeTagValue(@NotNull String input) {
        StringBuilder output = new StringBuilder(input.length());
        for (int idx = 0; idx < input.length(); ++idx) {
            char ch = input.charAt(idx);
            if (ch == '\n') {
                output.append("\\n");
                continue;
            }
            if (ch == '\r') {
                output.append("\\r");
                continue;
            }
            if (ch == '\t') {
                output.append("\\t");
                continue;
            }
            if (ch == '\\') {
                output.append("\\\\");
                continue;
            }
            if (ch == '|') {
                output.append("\\u{7c}");
                continue;
            }
            if (ch == ',') {
                output.append("\\u{2c}");
                continue;
            }
            output.append(ch);
        }
        return output.toString();
    }

    @NotNull
    public static String getMetricBucketKey(@NotNull MetricType type, @NotNull String metricKey, @Nullable MeasurementUnit unit, @Nullable Map<String, String> tags) {
        @NotNull String typePrefix = type.statsdCode;
        @NotNull String serializedTags = MetricsHelper.getTagsKey(tags);
        @NotNull String unitName = MetricsHelper.getUnitName(unit);
        return String.format("%s_%s_%s_%s", typePrefix, metricKey, unitName, serializedTags);
    }

    @NotNull
    private static String getUnitName(@Nullable MeasurementUnit unit) {
        return unit != null ? unit.apiName() : "none";
    }

    @NotNull
    private static String getTagsKey(@Nullable Map<String, String> tags) {
        if (tags == null || tags.isEmpty()) {
            return "";
        }
        @NotNull StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, String> tag : tags.entrySet()) {
            @NotNull String key = MetricsHelper.escapeString(tag.getKey());
            @NotNull String value = MetricsHelper.escapeString(tag.getValue());
            if (builder.length() > 0) {
                builder.append(',');
            }
            builder.append(key).append('=').append(value);
        }
        return builder.toString();
    }

    @NotNull
    private static String escapeString(@NotNull String input) {
        StringBuilder escapedString = new StringBuilder(input.length());
        for (int idx = 0; idx < input.length(); ++idx) {
            char ch = input.charAt(idx);
            if (ch == ',' || ch == '=') {
                escapedString.append('\\');
            }
            escapedString.append(ch);
        }
        return escapedString.toString();
    }

    @NotNull
    public static String getExportKey(@NotNull MetricType type, @NotNull String key, @Nullable MeasurementUnit unit) {
        @NotNull String unitName = MetricsHelper.getUnitName(unit);
        return String.format("%s:%s@%s", type.statsdCode, key, unitName);
    }

    public static double convertNanosTo(@NotNull MeasurementUnit.Duration unit, long durationNanos) {
        switch (unit) {
            case NANOSECOND: {
                return durationNanos;
            }
            case MICROSECOND: {
                return (double)durationNanos / 1000.0;
            }
            case MILLISECOND: {
                return (double)durationNanos / 1000000.0;
            }
            case SECOND: {
                return (double)durationNanos / 1.0E9;
            }
            case MINUTE: {
                return (double)durationNanos / 6.0E10;
            }
            case HOUR: {
                return (double)durationNanos / 3.6E12;
            }
            case DAY: {
                return (double)durationNanos / 8.64E13;
            }
            case WEEK: {
                return (double)durationNanos / 8.64E13 / 7.0;
            }
        }
        throw new IllegalArgumentException("Unknown Duration unit: " + unit.name());
    }

    public static void encodeMetrics(long timestamp, @NotNull Collection<Metric> metrics, @NotNull StringBuilder writer) {
        for (Metric metric : metrics) {
            writer.append(MetricsHelper.sanitizeName(metric.getKey()));
            writer.append("@");
            @Nullable MeasurementUnit unit = metric.getUnit();
            @NotNull String unitName = MetricsHelper.getUnitName(unit);
            String sanitizeUnitName = MetricsHelper.sanitizeUnit(unitName);
            writer.append(sanitizeUnitName);
            for (Object value : metric.serialize()) {
                writer.append(":");
                writer.append(value);
            }
            writer.append("|");
            writer.append(metric.getType().statsdCode);
            @Nullable Map<String, String> tags = metric.getTags();
            if (tags != null) {
                writer.append("|#");
                boolean first = true;
                for (Map.Entry<String, String> tag : tags.entrySet()) {
                    @NotNull String tagKey = MetricsHelper.sanitizeTagKey(tag.getKey());
                    if (first) {
                        first = false;
                    } else {
                        writer.append(",");
                    }
                    writer.append(tagKey);
                    writer.append(":");
                    writer.append(MetricsHelper.sanitizeTagValue(tag.getValue()));
                }
            }
            writer.append("|T");
            writer.append(timestamp);
            writer.append("\n");
        }
    }

    @NotNull
    public static Map<String, String> mergeTags(@Nullable Map<String, String> tags, @NotNull Map<String, String> defaultTags) {
        if (tags == null) {
            return Collections.unmodifiableMap(defaultTags);
        }
        @NotNull HashMap<String, String> enrichedTags = new HashMap<String, String>(tags);
        for (Map.Entry<String, String> defaultTag : defaultTags.entrySet()) {
            @NotNull String key = defaultTag.getKey();
            if (enrichedTags.containsKey(key)) continue;
            enrichedTags.put(key, defaultTag.getValue());
        }
        return enrichedTags;
    }

    @TestOnly
    public static void setFlushShiftMs(long flushShiftMs) {
        FLUSH_SHIFT_MS = flushShiftMs;
    }
}

