/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.stack;

import gov.nist.javax.sip.SipStackImpl;
import gov.nist.javax.sip.message.SIPRequest;
import gov.nist.javax.sip.message.SIPResponse;
import gov.nist.javax.sip.stack.MessageChannel;
import gov.nist.javax.sip.stack.SIPMessageValve;
import java.io.IOException;
import javax.sip.SipStack;
import javax.sip.message.Response;

public class CongestionControlMessageValve
implements SIPMessageValve {
    protected SipStackImpl sipStack;
    protected int serverTransactionTableHighwaterMark;
    protected int dropResponseStatus;

    public boolean processRequest(SIPRequest request, MessageChannel messageChannel) {
        boolean undropableMethod;
        String requestMethod = request.getMethod();
        boolean bl = undropableMethod = requestMethod.equals("BYE") || requestMethod.equals("ACK") || requestMethod.equals("PRACK") || requestMethod.equals("CANCEL");
        if (!undropableMethod && this.serverTransactionTableHighwaterMark <= this.sipStack.getServerTransactionTableSize()) {
            if (this.dropResponseStatus > 0) {
                SIPResponse response = request.createResponse(this.dropResponseStatus);
                try {
                    messageChannel.sendMessage(response);
                }
                catch (IOException e) {
                    this.sipStack.getStackLogger().logError("Failed to send congestion control error response" + response, e);
                }
            }
            return false;
        }
        return true;
    }

    public boolean processResponse(Response response, MessageChannel messageChannel) {
        return true;
    }

    public void destroy() {
        this.sipStack.getStackLogger().logInfo("Destorying the congestion control valve " + this);
    }

    public void init(SipStack stack) {
        this.sipStack = (SipStackImpl)stack;
        this.sipStack.getStackLogger().logInfo("Initializing congestion control valve");
        String serverTransactionsString = this.sipStack.getConfigurationProperties().getProperty("gov.nist.javax.sip.MAX_SERVER_TRANSACTIONS", "10000");
        this.serverTransactionTableHighwaterMark = new Integer(serverTransactionsString);
        String dropResponseStatusString = this.sipStack.getConfigurationProperties().getProperty("DROP_RESPONSE_STATUS", "503");
        this.dropResponseStatus = new Integer(dropResponseStatusString);
    }
}

