/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.maven.staging;

import com.sonatype.nexus.staging.client.StagingRuleFailures;
import com.sonatype.nexus.staging.client.StagingRuleFailuresException;
import org.apache.maven.plugin.logging.Log;
import org.slf4j.Logger;
import org.sonatype.nexus.client.core.exception.NexusClientErrorResponseException;

public class ErrorDumper {
    public static void dumpErrors(Logger log, StagingRuleFailuresException e) {
        ErrorDumper.dumpErrors((Writer)new PlexusLoggerWriter(log), e);
    }

    public static void dumpErrors(Logger log, NexusClientErrorResponseException e) {
        ErrorDumper.dumpErrors((Writer)new PlexusLoggerWriter(log), e);
    }

    public static void dumpErrors(Log log, StagingRuleFailuresException e) {
        ErrorDumper.dumpErrors((Writer)new MojoLoggerWriter(log), e);
    }

    public static void dumpErrors(Log log, NexusClientErrorResponseException e) {
        ErrorDumper.dumpErrors((Writer)new MojoLoggerWriter(log), e);
    }

    public static void dumpErrors(Writer writer, StagingRuleFailuresException e) {
        writer.writeln("");
        writer.writeln("Nexus Staging Rules Failure Report");
        writer.writeln("==================================");
        writer.writeln("");
        for (StagingRuleFailures failure : e.getFailures()) {
            writer.writeln(String.format("Repository \"%s\" failures", failure.getRepositoryId()));
            for (StagingRuleFailures.RuleFailure ruleFailure : failure.getFailures()) {
                writer.writeln(String.format("  Rule \"%s\" failures", ruleFailure.getRuleName()));
                for (String message : ruleFailure.getMessages()) {
                    writer.writeln(String.format("    * %s", ErrorDumper.unfick(message)));
                }
            }
            writer.writeln("");
        }
        writer.writeln("");
    }

    public static void dumpErrors(Writer writer, NexusClientErrorResponseException e) {
        writer.writeln("");
        writer.writeln(String.format("Nexus Error Response: %s - %s", e.getResponseCode(), e.getReasonPhrase()));
        for (NexusClientErrorResponseException.ErrorMessage errorEntry : e.errors()) {
            writer.writeln(String.format("  %s - %s", ErrorDumper.unfick(errorEntry.getId()), ErrorDumper.unfick(errorEntry.getMessage())));
        }
        writer.writeln("");
    }

    protected static String unfick(String str) {
        if (str != null) {
            return str.replace("&quot;", "").replace("&lt;b&gt;", "").replace("&lt;/b&gt;", "");
        }
        return str;
    }

    public static class MojoLoggerWriter
    implements Writer {
        private final Log logger;

        public MojoLoggerWriter(Log logger) {
            this.logger = logger;
        }

        @Override
        public void writeln(String string) {
            this.logger.error((CharSequence)string);
        }
    }

    public static class PlexusLoggerWriter
    implements Writer {
        private final Logger logger;

        public PlexusLoggerWriter(Logger logger) {
            this.logger = logger;
        }

        @Override
        public void writeln(String string) {
            this.logger.error(string);
        }
    }

    public static interface Writer {
        public void writeln(String var1);
    }
}

