/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.client.internal.rest.jersey.subsystem.repository.maven;

import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.client.core.subsystem.repository.Repository;
import org.sonatype.nexus.client.core.subsystem.repository.maven.MavenM1VirtualRepository;
import org.sonatype.nexus.client.internal.rest.jersey.subsystem.repository.JerseyVirtualRepositoryFactory;
import org.sonatype.nexus.client.internal.rest.jersey.subsystem.repository.maven.JerseyMavenM1VirtualRepository;
import org.sonatype.nexus.client.rest.jersey.JerseyNexusClient;
import org.sonatype.nexus.rest.model.RepositoryBaseResource;
import org.sonatype.nexus.rest.model.RepositoryShadowResource;

@Named
@Singleton
public class JerseyMavenM1VirtualRepositoryFactory
extends JerseyVirtualRepositoryFactory {
    @Override
    public int canAdapt(RepositoryBaseResource resource) {
        int score = super.canAdapt(resource);
        if (score > 0 && "m2-m1-shadow".equals(resource.getProvider())) {
            ++score;
        }
        return score;
    }

    @Override
    public JerseyMavenM1VirtualRepository adapt(JerseyNexusClient nexusClient, RepositoryBaseResource resource) {
        return new JerseyMavenM1VirtualRepository(nexusClient, (RepositoryShadowResource)resource);
    }

    @Override
    public boolean canCreate(Class<? extends Repository> type) {
        return MavenM1VirtualRepository.class.equals(type);
    }

    @Override
    public JerseyMavenM1VirtualRepository create(JerseyNexusClient nexusClient, String id) {
        return new JerseyMavenM1VirtualRepository(nexusClient, id);
    }
}

