/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.ice;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import org.ice4j.Transport;
import org.ice4j.TransportAddress;
import org.ice4j.ice.Agent;
import org.ice4j.ice.AgentConfig;
import org.ice4j.ice.Candidate;
import org.ice4j.ice.CandidatePair;
import org.ice4j.ice.CandidatePairState;
import org.ice4j.ice.CandidatePrioritizer;
import org.ice4j.ice.CandidateType;
import org.ice4j.ice.CheckList;
import org.ice4j.ice.CheckListState;
import org.ice4j.ice.ComponentSocket;
import org.ice4j.ice.IceMediaStream;
import org.ice4j.ice.KeepAliveStrategy;
import org.ice4j.ice.LocalCandidate;
import org.ice4j.ice.RemoteCandidate;
import org.ice4j.ice.UPNPCandidate;
import org.ice4j.ice.harvest.AbstractUdpListener;
import org.ice4j.socket.IceSocketWrapper;
import org.ice4j.socket.IceUdpSocketWrapper;
import org.ice4j.socket.MultiplexingDatagramSocket;
import org.ice4j.util.Buffer;
import org.ice4j.util.BufferHandler;
import org.ice4j.util.BufferPool;
import org.jetbrains.annotations.NotNull;
import org.jitsi.utils.logging2.Logger;

public class Component
implements PropertyChangeListener,
BufferHandler {
    public static final int RTP = 1;
    public static final int RTCP = 2;
    private final int componentID;
    private final IceMediaStream parentStream;
    private final List<LocalCandidate> localCandidates = new LinkedList<LocalCandidate>();
    private final List<RemoteCandidate> remoteCandidates = new LinkedList<RemoteCandidate>();
    private final List<RemoteCandidate> remoteUpdateCandidates = new LinkedList<RemoteCandidate>();
    private final CandidatePrioritizer candidatePrioritizer = new CandidatePrioritizer();
    private LocalCandidate defaultCandidate = null;
    private CandidatePair selectedPair;
    private Candidate<?> defaultRemoteCandidate = null;
    private final Logger logger;
    private final ComponentSocket componentSocket;
    private final MultiplexingDatagramSocket socket;
    @Deprecated
    private final IceSocketWrapper socketWrapper;
    private final KeepAliveStrategy keepAliveStrategy;
    private final Set<CandidatePair> keepAlivePairs = Collections.newSetFromMap(new ConcurrentHashMap());
    private BufferHandler bufferCallback = null;

    protected Component(int componentID, IceMediaStream mediaStream, KeepAliveStrategy keepAliveStrategy, Logger parentLogger) {
        this(componentID, mediaStream, keepAliveStrategy, true, parentLogger);
    }

    protected Component(int componentID, IceMediaStream mediaStream, KeepAliveStrategy keepAliveStrategy, boolean useComponentSocket, Logger parentLogger) {
        this.componentID = componentID;
        this.parentStream = mediaStream;
        this.keepAliveStrategy = Objects.requireNonNull(keepAliveStrategy, "keepAliveStrategy");
        this.logger = parentLogger.createChildLogger(this.getClass().getName(), Collections.singletonMap("componentId", Integer.toString(componentID)));
        if (useComponentSocket) {
            try {
                this.componentSocket = new ComponentSocket(this, this.logger);
                this.socket = new MultiplexingDatagramSocket(this.componentSocket);
                this.socketWrapper = new IceUdpSocketWrapper(this.socket);
            }
            catch (SocketException se) {
                throw new RuntimeException(se);
            }
        } else {
            this.componentSocket = null;
            this.socket = null;
            this.socketWrapper = null;
        }
        mediaStream.addPairChangeListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addLocalCandidate(LocalCandidate candidate) {
        Agent agent = this.getParentStream().getParentAgent();
        agent.getFoundationsRegistry().assignFoundation(candidate);
        candidate.computePriority();
        List<LocalCandidate> list = this.localCandidates;
        synchronized (list) {
            LocalCandidate redundantCandidate = this.findRedundant(candidate);
            if (redundantCandidate != null) {
                return false;
            }
            this.localCandidates.add(candidate);
            Collections.sort(this.localCandidates);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LocalCandidate> getLocalCandidates() {
        List<LocalCandidate> list = this.localCandidates;
        synchronized (list) {
            return new ArrayList<LocalCandidate>(this.localCandidates);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int countLocalHostCandidates() {
        List<LocalCandidate> list = this.localCandidates;
        synchronized (list) {
            int count = 0;
            for (Candidate candidate : this.localCandidates) {
                if (candidate.getType() != CandidateType.HOST_CANDIDATE || candidate.isVirtual()) continue;
                ++count;
            }
            return count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLocalCandidateCount() {
        List<LocalCandidate> list = this.localCandidates;
        synchronized (list) {
            return this.localCandidates.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRemoteCandidate(RemoteCandidate candidate) {
        this.logger.info((Object)("Add remote candidate for " + this.toShortString() + ": " + candidate.toRedactedShortString()));
        List<RemoteCandidate> list = this.remoteCandidates;
        synchronized (list) {
            this.remoteCandidates.add(candidate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUpdateRemoteCandidates(RemoteCandidate candidate) {
        this.logger.info((Object)("Update remote candidate for " + this.toShortString() + ": " + candidate.getTransportAddress()));
        LinkedList<RemoteCandidate> existingCandidates = new LinkedList<RemoteCandidate>();
        List<RemoteCandidate> list = this.remoteCandidates;
        synchronized (list) {
            existingCandidates.addAll(this.remoteCandidates);
        }
        list = this.remoteUpdateCandidates;
        synchronized (list) {
            existingCandidates.addAll(this.remoteUpdateCandidates);
            TransportAddress transportAddress = candidate.getTransportAddress();
            CandidateType type = candidate.getType();
            for (RemoteCandidate existingCandidate : existingCandidates) {
                if (!transportAddress.equals(existingCandidate.getTransportAddress()) || type != existingCandidate.getType()) continue;
                this.logger.info((Object)("Not adding duplicate remote candidate: " + candidate.getTransportAddress()));
                return;
            }
            this.remoteUpdateCandidates.add(candidate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRemoteCandidates() {
        Vector<CandidatePair> checkList;
        LinkedList<RemoteCandidate> newRemoteCandidates;
        List<RemoteCandidate> list = this.remoteUpdateCandidates;
        synchronized (list) {
            if (this.remoteUpdateCandidates.size() == 0) {
                return;
            }
            newRemoteCandidates = new LinkedList<RemoteCandidate>(this.remoteUpdateCandidates);
            List<LocalCandidate> localCnds = this.getLocalCandidates();
            LocalCandidate upnpBase = null;
            for (LocalCandidate lc : localCnds) {
                if (!(lc instanceof UPNPCandidate)) continue;
                upnpBase = (LocalCandidate)lc.getBase();
            }
            checkList = new Vector<CandidatePair>();
            for (LocalCandidate localCnd : localCnds) {
                if (localCnd == upnpBase) continue;
                for (RemoteCandidate remoteCnd : this.remoteUpdateCandidates) {
                    if (!localCnd.canReach(remoteCnd) || remoteCnd.getTransportAddress().getPort() == 0) continue;
                    CandidatePair pair = this.getParentStream().getParentAgent().createCandidatePair(localCnd, remoteCnd);
                    checkList.add(pair);
                }
            }
            this.remoteUpdateCandidates.clear();
        }
        list = this.remoteCandidates;
        synchronized (list) {
            this.remoteCandidates.addAll(newRemoteCandidates);
        }
        Collections.sort(checkList, CandidatePair.comparator);
        this.parentStream.pruneCheckList(checkList);
        if (this.parentStream.getCheckList().getState().equals((Object)CheckListState.RUNNING)) {
            CheckList streamCheckList;
            CheckList checkList2 = streamCheckList = this.parentStream.getCheckList();
            synchronized (checkList2) {
                for (CandidatePair pair : checkList) {
                    CandidatePair existingPair = streamCheckList.findPairMatching(pair.getLocalCandidate(), pair.getRemoteCandidate());
                    if (existingPair != null) {
                        this.logger.info((Object)("existing Pair updated: " + existingPair.toRedactedShortString() + " to " + pair.toRedactedShortString() + "."));
                        existingPair.setRemoteCandidate(pair.getRemoteCandidate());
                        existingPair.computePriority();
                        continue;
                    }
                    streamCheckList.add(pair);
                    this.logger.info((Object)("new Pair added: " + pair.toRedactedShortString() + "."));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RemoteCandidate> getRemoteCandidates() {
        List<RemoteCandidate> list = this.remoteCandidates;
        synchronized (list) {
            return new ArrayList<RemoteCandidate>(this.remoteCandidates);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRemoteCandidates(List<RemoteCandidate> candidates) {
        List<RemoteCandidate> list = this.remoteCandidates;
        synchronized (list) {
            this.remoteCandidates.addAll(candidates);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRemoteCandidateCount() {
        List<RemoteCandidate> list = this.remoteCandidates;
        synchronized (list) {
            return this.remoteCandidates.size();
        }
    }

    public IceMediaStream getParentStream() {
        return this.parentStream;
    }

    public int getComponentID() {
        return this.componentID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuffer buff = new StringBuffer("Component id=").append(this.getComponentID());
        buff.append(" parent stream=").append(this.getParentStream().getName());
        int localCandidatesCount = this.getLocalCandidateCount();
        if (localCandidatesCount > 0) {
            buff.append("\n").append(localCandidatesCount).append(" Local candidates:");
            buff.append("\ndefault candidate: ").append(this.getDefaultCandidate());
            List<LocalCandidate> list = this.localCandidates;
            synchronized (list) {
                for (Candidate list2 : this.localCandidates) {
                    buff.append('\n').append(list2.toString());
                }
            }
        } else {
            buff.append("\nno local candidates.");
        }
        int remoteCandidatesCount = this.getRemoteCandidateCount();
        if (remoteCandidatesCount > 0) {
            buff.append("\n").append(remoteCandidatesCount).append(" Remote candidates:");
            Candidate<?> defaultRemoteCandidate = this.getDefaultRemoteCandidate();
            buff.append("\ndefault remote candidate: ");
            if (defaultRemoteCandidate != null) {
                buff.append(defaultRemoteCandidate.toRedactedString());
            } else {
                buff.append("null");
            }
            List<RemoteCandidate> list = this.remoteCandidates;
            synchronized (list) {
                for (RemoteCandidate cand : this.remoteCandidates) {
                    buff.append("\n").append(cand.toRedactedString());
                }
            }
        } else {
            buff.append("\nno remote candidates.");
        }
        return buff.toString();
    }

    public String toShortString() {
        return this.parentStream.getName() + "." + this.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    protected void prioritizeCandidates() {
        List<LocalCandidate> list = this.localCandidates;
        synchronized (list) {
            LocalCandidate[] candidates = new LocalCandidate[this.localCandidates.size()];
            this.localCandidates.toArray(candidates);
            for (LocalCandidate cand : candidates) {
                cand.computePriority();
            }
            Arrays.sort(candidates, this.candidatePrioritizer);
            this.localCandidates.clear();
            for (LocalCandidate cand : candidates) {
                this.localCandidates.add(cand);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    protected void eliminateRedundantCandidates() {
        List<LocalCandidate> list = this.localCandidates;
        synchronized (list) {
            for (int i = 0; i < this.localCandidates.size(); ++i) {
                LocalCandidate cand = this.localCandidates.get(i);
                int j = i + 1;
                while (j < this.localCandidates.size()) {
                    LocalCandidate cand2 = this.localCandidates.get(j);
                    if (cand != cand2 && cand.getTransportAddress().equals(cand2.getTransportAddress()) && ((LocalCandidate)cand.getBase()).equals(cand2.getBase()) && cand.getPriority() >= cand2.getPriority()) {
                        this.localCandidates.remove(j);
                        this.logger.trace(() -> "eliminating redundant cand: " + cand2);
                        continue;
                    }
                    ++j;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LocalCandidate findRedundant(LocalCandidate cand) {
        List<LocalCandidate> list = this.localCandidates;
        synchronized (list) {
            for (LocalCandidate redundantCand : this.localCandidates) {
                if (cand == redundantCand || !cand.getTransportAddress().equals(redundantCand.getTransportAddress()) || !((LocalCandidate)cand.getBase()).equals(redundantCand.getBase())) continue;
                return redundantCand;
            }
        }
        return null;
    }

    public LocalCandidate getDefaultCandidate() {
        return this.defaultCandidate;
    }

    public Candidate<?> getDefaultRemoteCandidate() {
        return this.defaultRemoteCandidate;
    }

    public void setDefaultRemoteCandidate(Candidate<?> candidate) {
        this.defaultRemoteCandidate = candidate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void selectDefaultCandidate() {
        List<LocalCandidate> list = this.localCandidates;
        synchronized (list) {
            for (LocalCandidate cand : this.localCandidates) {
                if (this.defaultCandidate != null && this.defaultCandidate.getDefaultPreference() >= cand.getDefaultPreference()) continue;
                this.defaultCandidate = cand;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void free() {
        List<LocalCandidate> list = this.localCandidates;
        synchronized (list) {
            CandidateType[] candidateTypes;
            for (CandidateType candidateType : candidateTypes = new CandidateType[]{CandidateType.RELAYED_CANDIDATE, CandidateType.PEER_REFLEXIVE_CANDIDATE, CandidateType.SERVER_REFLEXIVE_CANDIDATE}) {
                Iterator<LocalCandidate> localCandidateIter = this.localCandidates.iterator();
                while (localCandidateIter.hasNext()) {
                    LocalCandidate localCandidate = localCandidateIter.next();
                    if (!candidateType.equals((Object)localCandidate.getType())) continue;
                    this.free(localCandidate);
                    localCandidateIter.remove();
                }
            }
            Iterator<LocalCandidate> localCandidateIter = this.localCandidates.iterator();
            while (localCandidateIter.hasNext()) {
                LocalCandidate localCandidate = localCandidateIter.next();
                this.free(localCandidate);
                localCandidateIter.remove();
            }
        }
        this.getParentStream().removePairStateChangeListener(this);
        this.keepAlivePairs.clear();
        if (this.componentSocket != null) {
            this.componentSocket.close();
        }
        if (this.socket != null) {
            this.socket.close();
        }
    }

    private void free(LocalCandidate localCandidate) {
        try {
            localCandidate.free();
        }
        catch (Throwable t) {
            if (t instanceof ThreadDeath) {
                throw (ThreadDeath)t;
            }
            this.logger.info(() -> "Failed to free LocalCandidate: " + localCandidate);
        }
    }

    public LocalCandidate findLocalCandidate(TransportAddress localAddress) {
        return this.findLocalCandidate(localAddress, null);
    }

    public LocalCandidate findLocalCandidate(TransportAddress address, LocalCandidate base) {
        for (LocalCandidate localCandidate : this.localCandidates) {
            if (!localCandidate.getTransportAddress().equals(address) || base != null && !base.equals(localCandidate.getBase())) continue;
            return localCandidate;
        }
        for (LocalCandidate localCandidate : this.localCandidates) {
            if (!localCandidate.getTransportAddress().equals(address)) continue;
            this.logger.warn((Object)("Returning a candidate matching the address, while no candidates match both address (" + address + ") and base (" + base + "): " + localCandidate + " with base " + localCandidate.getBase()));
            return localCandidate;
        }
        return null;
    }

    public RemoteCandidate findRemoteCandidate(TransportAddress remoteAddress) {
        for (RemoteCandidate remoteCnd : this.remoteCandidates) {
            if (!remoteCnd.getTransportAddress().equals(remoteAddress)) continue;
            return remoteCnd;
        }
        return null;
    }

    protected void setSelectedPair(CandidatePair pair) {
        if (this.keepAliveStrategy == KeepAliveStrategy.SELECTED_ONLY) {
            this.keepAlivePairs.clear();
        }
        this.keepAlivePairs.add(pair);
        this.selectedPair = pair;
    }

    public CandidatePair getSelectedPair() {
        return this.selectedPair;
    }

    public String getName() {
        if (this.componentID == 1) {
            return "RTP";
        }
        if (this.componentID == 2) {
            return "RTCP";
        }
        return Integer.toString(this.componentID);
    }

    public static Component build(int componentID, IceMediaStream mediaStream, Logger parentLogger) {
        return new Component(componentID, mediaStream, KeepAliveStrategy.SELECTED_ONLY, AgentConfig.config.getUseComponentSocket(), parentLogger);
    }

    public ComponentSocket getComponentSocket() {
        return this.componentSocket;
    }

    public MultiplexingDatagramSocket getSocket() {
        return this.socket;
    }

    public IceSocketWrapper getSocketWrapper() {
        return this.socketWrapper;
    }

    Set<CandidatePair> getKeepAlivePairs() {
        return this.keepAlivePairs;
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        CandidatePairState newState;
        String propertyName = event.getPropertyName();
        if (!(event.getSource() instanceof CandidatePair)) {
            return;
        }
        CandidatePair pair = (CandidatePair)event.getSource();
        if (!this.equals(pair.getParentComponent())) {
            return;
        }
        boolean addToKeepAlive = false;
        if (this.keepAliveStrategy == KeepAliveStrategy.SELECTED_ONLY) {
            return;
        }
        if ("PairStateChanged".equals(propertyName) && CandidatePairState.SUCCEEDED.equals((Object)(newState = (CandidatePairState)((Object)event.getNewValue())))) {
            if (this.keepAliveStrategy == KeepAliveStrategy.ALL_SUCCEEDED) {
                addToKeepAlive = true;
            } else if (this.keepAliveStrategy == KeepAliveStrategy.SELECTED_AND_TCP) {
                Transport transport = pair.getLocalCandidate().getTransport();
                addToKeepAlive = transport == Transport.TCP || transport == Transport.SSLTCP;
                addToKeepAlive &= pair.getRemoteCandidate().getTransportAddress().getPort() != 9;
            }
        }
        if (addToKeepAlive && !this.keepAlivePairs.contains(pair)) {
            this.keepAlivePairs.add(pair);
        }
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void send(byte[] buffer, int offset, int length) throws IOException {
        IceSocketWrapper socket;
        LocalCandidate localCandidate;
        CandidatePair pair = this.getSelectedPair();
        if (pair == null) {
            this.logger.debug((Object)"No selected pair, will try valid for sending");
            pair = this.parentStream.getValidPair(this);
            if (pair == null) {
                throw new IOException("No valid pair.");
            }
        }
        if ((localCandidate = pair.getLocalCandidate()) != null && localCandidate.getBase() != null) {
            localCandidate = (LocalCandidate)localCandidate.getBase();
        }
        TransportAddress remoteAddress = pair.getRemoteCandidate().getTransportAddress();
        IceSocketWrapper iceSocketWrapper = socket = localCandidate == null ? null : localCandidate.getCandidateIceSocketWrapper(remoteAddress);
        if (socket == null) {
            throw new IOException("No socket found to send on.");
        }
        DatagramPacket p = new DatagramPacket(buffer, offset, length);
        p.setSocketAddress(remoteAddress);
        socket.send(p);
    }

    @Override
    public void handleBuffer(@NotNull Buffer buffer) {
        BufferHandler bufferCallback = this.bufferCallback;
        if (bufferCallback == null) {
            this.logger.warn((Object)("The push API is used while no buffer callback has been set, dropping a packet (use-push-api=" + AbstractUdpListener.USE_PUSH_API + ")."));
            BufferPool.returnBuffer.invoke((Object)buffer);
            return;
        }
        try {
            bufferCallback.handleBuffer(buffer);
        }
        catch (Exception e) {
            this.logger.warn((Object)"Buffer handling failed", (Throwable)e);
            BufferPool.returnBuffer.invoke((Object)buffer);
        }
    }

    public void setBufferCallback(BufferHandler bufferCallback) {
        this.bufferCallback = bufferCallback;
    }
}

