/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.enforcer.rules;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rules.AbstractStandardEnforcerRule;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Model;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.settings.Profile;
import org.apache.maven.settings.Repository;
import org.apache.maven.settings.RepositoryBase;
import org.codehaus.plexus.util.StringUtils;

@Named(value="requireNoRepositories")
public final class RequireNoRepositories
extends AbstractStandardEnforcerRule {
    private static final String VERSION = " version:";
    private boolean banRepositories = true;
    private boolean banPluginRepositories = true;
    private List<String> allowedRepositories;
    private List<String> allowedPluginRepositories;
    private boolean allowSnapshotRepositories = false;
    private boolean allowSnapshotPluginRepositories = false;
    private final MavenSession session;

    @Inject
    public RequireNoRepositories(MavenSession session) {
        this.session = Objects.requireNonNull(session);
    }

    public void setBanRepositories(boolean banRepositories) {
        this.banRepositories = banRepositories;
    }

    public void setBanPluginRepositories(boolean banPluginRepositories) {
        this.banPluginRepositories = banPluginRepositories;
    }

    public void setAllowedRepositories(List<String> allowedRepositories) {
        this.allowedRepositories = allowedRepositories;
    }

    public void setAllowedPluginRepositories(List<String> allowedPluginRepositories) {
        this.allowedPluginRepositories = allowedPluginRepositories;
    }

    public void setAllowSnapshotRepositories(boolean allowSnapshotRepositories) {
        this.allowSnapshotRepositories = allowSnapshotRepositories;
    }

    public void setAllowSnapshotPluginRepositories(boolean allowSnapshotPluginRepositories) {
        this.allowSnapshotPluginRepositories = allowSnapshotPluginRepositories;
    }

    public void execute() throws EnforcerRuleException {
        Collection<String> reposIdsFromSettings;
        if (this.banRepositories) {
            reposIdsFromSettings = this.getRepoIdsFromSettings(Profile::getRepositories);
            if (!reposIdsFromSettings.isEmpty()) {
                this.getLog().debug(() -> "Allow repositories from settings: " + reposIdsFromSettings);
            }
            this.allowedRepositories = Optional.ofNullable(this.allowedRepositories).orElseGet(ArrayList::new);
            this.allowedRepositories.addAll(reposIdsFromSettings);
        }
        if (this.banPluginRepositories) {
            reposIdsFromSettings = this.getRepoIdsFromSettings(Profile::getPluginRepositories);
            if (!reposIdsFromSettings.isEmpty()) {
                this.getLog().debug(() -> "Allow plugin repositories from settings: " + reposIdsFromSettings);
            }
            this.allowedPluginRepositories = Optional.ofNullable(this.allowedPluginRepositories).orElseGet(ArrayList::new);
            this.allowedPluginRepositories.addAll(reposIdsFromSettings);
        }
        List sortedProjects = this.session.getProjectDependencyGraph().getSortedProjects();
        ArrayList<Model> models = new ArrayList<Model>();
        for (MavenProject mavenProject : sortedProjects) {
            this.getLog().debug((CharSequence)("Scanning project: " + mavenProject.getGroupId() + ":" + mavenProject.getArtifactId() + VERSION + mavenProject.getVersion()));
            models.add(mavenProject.getOriginalModel());
        }
        ArrayList<Model> badModels = new ArrayList<Model>();
        StringBuilder newMsg = new StringBuilder();
        newMsg.append("Some poms have repositories defined:" + System.lineSeparator());
        for (Model model : models) {
            List<String> bannedRepos;
            List repos;
            if (this.banRepositories && (repos = model.getRepositories()) != null && !repos.isEmpty() && !(bannedRepos = RequireNoRepositories.findBannedRepositories(repos, this.allowedRepositories, this.allowSnapshotRepositories)).isEmpty()) {
                badModels.add(model);
                newMsg.append(model.getGroupId() + ":" + model.getArtifactId() + VERSION + model.getVersion() + " has repositories " + bannedRepos);
            }
            if (!this.banPluginRepositories || (repos = model.getPluginRepositories()) == null || repos.isEmpty() || (bannedRepos = RequireNoRepositories.findBannedRepositories(repos, this.allowedPluginRepositories, this.allowSnapshotPluginRepositories)).isEmpty()) continue;
            badModels.add(model);
            newMsg.append(model.getGroupId() + ":" + model.getArtifactId() + VERSION + model.getVersion() + " has plugin repositories " + bannedRepos);
        }
        if (!badModels.isEmpty()) {
            if (StringUtils.isNotEmpty((String)this.getMessage())) {
                newMsg.append(this.getMessage());
            }
            throw new EnforcerRuleException(newMsg.toString());
        }
    }

    private Collection<String> getRepoIdsFromSettings(Function<Profile, List<Repository>> getRepositoriesFunc) {
        List activeProfileIds = Optional.ofNullable(this.session.getProjectBuildingRequest()).map(ProjectBuildingRequest::getActiveProfileIds).orElse(Collections.emptyList());
        List inactiveProfileIds = Optional.ofNullable(this.session.getProjectBuildingRequest()).map(ProjectBuildingRequest::getInactiveProfileIds).orElse(Collections.emptyList());
        return this.session.getSettings().getProfiles().stream().filter(p -> activeProfileIds.contains(p.getId())).filter(p -> !inactiveProfileIds.contains(p.getId())).map(getRepositoriesFunc).flatMap(Collection::stream).map(RepositoryBase::getId).collect(Collectors.toSet());
    }

    private static List<String> findBannedRepositories(List<org.apache.maven.model.Repository> repos, List<String> allowedRepos, boolean allowSnapshots) {
        ArrayList<String> bannedRepos = new ArrayList<String>(allowedRepos.size());
        for (org.apache.maven.model.Repository r : repos) {
            if (allowedRepos.contains(r.getId()) || allowSnapshots && r.getReleases() != null && !r.getReleases().isEnabled()) continue;
            bannedRepos.add(r.getId());
        }
        return bannedRepos;
    }

    public String toString() {
        return String.format("RequireNoRepositories[message=%s, banRepositories=%b, allowSnapshotRepositories=%b, allowedRepositories=%s, banPluginRepositories=%b, allowSnapshotPluginRepositories=%b, allowedPluginRepositories=%s]", this.getMessage(), this.banRepositories, this.allowSnapshotRepositories, this.allowedRepositories, this.banPluginRepositories, this.allowSnapshotPluginRepositories, this.allowedPluginRepositories);
    }
}

