/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.enforcer.rules;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rules.AbstractStandardEnforcerRule;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Profile;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.StringUtils;

@Named(value="requireProfileIdsExist")
public final class RequireProfileIdsExist
extends AbstractStandardEnforcerRule {
    private final MavenSession session;

    @Inject
    public RequireProfileIdsExist(MavenSession session) {
        this.session = Objects.requireNonNull(session);
    }

    public void execute() throws EnforcerRuleException {
        ArrayList profileIds = new ArrayList();
        profileIds.addAll(this.session.getProjectBuildingRequest().getActiveProfileIds());
        profileIds.addAll(this.session.getProjectBuildingRequest().getInactiveProfileIds());
        Iterator iterator = this.session.getProjects().iterator();
        while (iterator.hasNext()) {
            MavenProject project;
            MavenProject currentProject = project = (MavenProject)iterator.next();
            do {
                for (Profile profile : currentProject.getModel().getProfiles()) {
                    profileIds.remove(profile.getId());
                    if (!profileIds.isEmpty()) continue;
                    return;
                }
            } while ((currentProject = currentProject.getParent()) != null);
        }
        for (org.apache.maven.settings.Profile profile : this.session.getSettings().getProfiles()) {
            profileIds.remove(profile.getId());
        }
        if (profileIds.isEmpty()) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        if (profileIds.size() > 1) {
            sb.append("The requested profiles don't exist: ");
        } else {
            sb.append("The requested profile doesn't exist: ");
        }
        sb.append(StringUtils.join(profileIds.iterator(), (String)", "));
        throw new EnforcerRuleException(sb.toString());
    }
}

