/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.colormath;

import com.github.ajalt.colormath.Ansi256;
import com.github.ajalt.colormath.CMYK;
import com.github.ajalt.colormath.ConvertibleColor;
import com.github.ajalt.colormath.ExtensionsKt;
import com.github.ajalt.colormath.HSL;
import com.github.ajalt.colormath.HSV;
import com.github.ajalt.colormath.LAB;
import com.github.ajalt.colormath.RGB;
import com.github.ajalt.colormath.XYZ;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00d6\u0001J\b\u0010\u000e\u001a\u00020\u0000H\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0016"}, d2={"Lcom/github/ajalt/colormath/Ansi16;", "Lcom/github/ajalt/colormath/ConvertibleColor;", "code", "", "(I)V", "getCode", "()I", "component1", "copy", "equals", "", "other", "", "hashCode", "toAnsi16", "toAnsi256", "Lcom/github/ajalt/colormath/Ansi256;", "toRGB", "Lcom/github/ajalt/colormath/RGB;", "toString", "", "Companion", "colorconversion"})
public final class Ansi16
implements ConvertibleColor {
    private final int code;
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public RGB toRGB() {
        int color = this.code % 10;
        if (color == 0 || color == 7) {
            double c = this.code > 50 ? (double)color + 3.5 : (double)color;
            int v = ExtensionsKt.roundToInt(c / 10.5 * (double)255);
            return new RGB(v, v, v);
        }
        double mul = this.code > 50 ? 1.0 : 0.5;
        double r = (double)(color % 2) * mul * (double)255;
        double g = (double)(color / 2 % 2) * mul * (double)255;
        double b = (double)(color / 4 % 2) * mul * (double)255;
        return new RGB(ExtensionsKt.roundToInt(r), ExtensionsKt.roundToInt(g), ExtensionsKt.roundToInt(b));
    }

    @Override
    @NotNull
    public Ansi16 toAnsi16() {
        return this;
    }

    @Override
    @NotNull
    public Ansi256 toAnsi256() {
        return this.code >= 90 ? new Ansi256(this.code - 90 + 8) : new Ansi256(this.code - 30);
    }

    public final int getCode() {
        return this.code;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Ansi16(int code) {
        int n = this.code = code;
        if (30 <= n) {
            if (37 >= n) return;
        }
        n = this.code;
        if (40 <= n) {
            if (47 >= n) return;
        }
        n = this.code;
        if (90 <= n) {
            if (97 >= n) return;
        }
        n = this.code;
        if (100 <= n && 107 >= n) {
            return;
        }
        int n2 = 0;
        n = n2;
        if (n != 0) return;
        String string = "code not valid: " + this.code;
        throw (Throwable)new IllegalArgumentException(string.toString());
    }

    @Override
    @NotNull
    public String toHex(boolean withNumberSign) {
        return ConvertibleColor.DefaultImpls.toHex(this, withNumberSign);
    }

    @Override
    @NotNull
    public HSL toHSL() {
        return ConvertibleColor.DefaultImpls.toHSL(this);
    }

    @Override
    @NotNull
    public HSV toHSV() {
        return ConvertibleColor.DefaultImpls.toHSV(this);
    }

    @Override
    @NotNull
    public CMYK toCMYK() {
        return ConvertibleColor.DefaultImpls.toCMYK(this);
    }

    @Override
    @NotNull
    public XYZ toXYZ() {
        return ConvertibleColor.DefaultImpls.toXYZ(this);
    }

    @Override
    @NotNull
    public LAB toLAB() {
        return ConvertibleColor.DefaultImpls.toLAB(this);
    }

    public final int component1() {
        return this.code;
    }

    @NotNull
    public final Ansi16 copy(int code) {
        return new Ansi16(code);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ Ansi16 copy$default(Ansi16 ansi16, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = ansi16.code;
        }
        return ansi16.copy(n);
    }

    public String toString() {
        return "Ansi16(code=" + this.code + ")";
    }

    public int hashCode() {
        return this.code;
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof Ansi16)) break block3;
                Ansi16 ansi16 = (Ansi16)object;
                if (!(this.code == ansi16.code)) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b!\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u0006R\u0011\u0010\r\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0006R\u0011\u0010\u000f\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0006R\u0011\u0010\u0011\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0006R\u0011\u0010\u0013\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0006R\u0011\u0010\u0015\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0006R\u0011\u0010\u0017\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0006R\u0011\u0010\u0019\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0006R\u0011\u0010\u001b\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0006R\u0011\u0010\u001d\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u0006R\u0011\u0010\u001f\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b \u0010\u0006R\u0011\u0010!\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u0006R\u0011\u0010#\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u0006\u00a8\u0006%"}, d2={"Lcom/github/ajalt/colormath/Ansi16$Companion;", "", "()V", "black", "Lcom/github/ajalt/colormath/Ansi16;", "getBlack", "()Lcom/github/ajalt/colormath/Ansi16;", "blue", "getBlue", "brightBlack", "getBrightBlack", "brightBlue", "getBrightBlue", "brightCyan", "getBrightCyan", "brightGreen", "getBrightGreen", "brightPurple", "getBrightPurple", "brightRed", "getBrightRed", "brightWhite", "getBrightWhite", "brightYellow", "getBrightYellow", "cyan", "getCyan", "green", "getGreen", "purple", "getPurple", "red", "getRed", "white", "getWhite", "yellow", "getYellow", "colorconversion"})
    public static final class Companion {
        @NotNull
        public final Ansi16 getBlack() {
            return new Ansi16(30);
        }

        @NotNull
        public final Ansi16 getRed() {
            return new Ansi16(31);
        }

        @NotNull
        public final Ansi16 getGreen() {
            return new Ansi16(32);
        }

        @NotNull
        public final Ansi16 getYellow() {
            return new Ansi16(33);
        }

        @NotNull
        public final Ansi16 getBlue() {
            return new Ansi16(34);
        }

        @NotNull
        public final Ansi16 getPurple() {
            return new Ansi16(35);
        }

        @NotNull
        public final Ansi16 getCyan() {
            return new Ansi16(36);
        }

        @NotNull
        public final Ansi16 getWhite() {
            return new Ansi16(37);
        }

        @NotNull
        public final Ansi16 getBrightBlack() {
            return new Ansi16(90);
        }

        @NotNull
        public final Ansi16 getBrightRed() {
            return new Ansi16(91);
        }

        @NotNull
        public final Ansi16 getBrightGreen() {
            return new Ansi16(92);
        }

        @NotNull
        public final Ansi16 getBrightYellow() {
            return new Ansi16(93);
        }

        @NotNull
        public final Ansi16 getBrightBlue() {
            return new Ansi16(94);
        }

        @NotNull
        public final Ansi16 getBrightPurple() {
            return new Ansi16(95);
        }

        @NotNull
        public final Ansi16 getBrightCyan() {
            return new Ansi16(96);
        }

        @NotNull
        public final Ansi16 getBrightWhite() {
            return new Ansi16(97);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

