/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.sisu.charger.internal;

import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.sonatype.sisu.charger.ExceptionHandler;
import org.sonatype.sisu.charger.internal.Charge;
import org.sonatype.sisu.charger.internal.Check;

public class ChargeWrapper<E>
implements Callable<E>,
ExceptionHandler {
    private final Charge<E> charge;
    private final Callable<? extends E> callable;
    private final ExceptionHandler exceptionHandler;
    private Future<E> future;

    public ChargeWrapper(Charge<E> charge, Callable<? extends E> callable, ExceptionHandler exceptionHandler) {
        this.charge = Check.notNull(charge, "Charge is null!");
        this.callable = Check.notNull(callable, "Callable is null!");
        this.exceptionHandler = Check.notNull(exceptionHandler, "ExceptionHander is null!");
    }

    protected void setFuture(Future<E> future) {
        this.future = Check.notNull(future, "Future is null!");
    }

    public Future<E> getFuture() {
        return this.future;
    }

    @Override
    public E call() throws Exception {
        try {
            if (!this.charge.isDone()) {
                E e = this.callable.call();
                return e;
            }
            throw new InterruptedException("Charge itself was done before call() was made!");
        }
        finally {
            this.charge.checkIsDone(this);
        }
    }

    @Override
    public boolean handle(Exception ex) {
        return this.exceptionHandler.handle(ex);
    }
}

