/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.spice.zapper.fs;

import java.io.File;
import java.io.IOException;
import org.sonatype.spice.zapper.Path;

public class AbstractDirectory {
    private final File root;

    public AbstractDirectory(File root) throws IOException {
        if (!root.isDirectory()) {
            throw new IOException(String.format("Supplied file %s is a not an existing directory!", root.getAbsolutePath()));
        }
        this.root = root.getAbsoluteFile();
    }

    public File getRoot() {
        return this.root;
    }

    protected File getFile(Path path) throws IOException {
        File result = new File(this.getRoot(), path.stringValue()).getAbsoluteFile();
        if (!result.getAbsolutePath().startsWith(this.root.getAbsolutePath())) {
            throw new IOException(String.format("Path %s was about to escape sandbox %s!", path, this.root.getAbsolutePath()));
        }
        return result;
    }
}

