/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.spice.zapper.internal;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.sonatype.spice.zapper.Range;

public class RangeInputStream
extends FilterInputStream {
    private final Range range;
    private long allowedToRead;
    private boolean allowedToClose;

    public RangeInputStream(InputStream wrappedStream, Range range, boolean doSkip, boolean allowedToClose) throws IOException {
        super(wrappedStream);
        if (range == null) {
            throw new NullPointerException("Range is null!");
        }
        this.range = range;
        this.allowedToRead = range.getLength();
        this.allowedToClose = allowedToClose;
        if (doSkip && range.getOffset() > 0L) {
            super.skip(range.getOffset());
        }
    }

    public Range getRange() {
        return this.range;
    }

    public int available() throws IOException {
        return this.mathMin(super.available(), this.allowedToRead);
    }

    public int read() throws IOException {
        if (this.allowedToRead <= 0L) {
            return -1;
        }
        int result = super.read();
        if (result >= 0) {
            --this.allowedToRead;
        }
        return result;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.allowedToRead <= 0L) {
            return -1;
        }
        int lenToRead = this.mathMin(len, this.allowedToRead);
        int result = super.read(b, off, lenToRead);
        if (result >= 0) {
            this.allowedToRead -= (long)result;
        }
        return result;
    }

    public long skip(long n) throws IOException {
        long result = super.skip(Math.min(n, this.allowedToRead));
        if (result >= 0L) {
            this.allowedToRead -= result;
        }
        return result;
    }

    public void close() throws IOException {
        if (this.allowedToClose) {
            super.close();
        }
    }

    protected long getAllowedToRead() {
        return this.allowedToRead;
    }

    protected int mathMin(int a, long b) {
        if (b < Integer.MAX_VALUE) {
            return Math.min(a, (int)b);
        }
        return a;
    }
}

