/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.siterenderer;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.maven.doxia.Doxia;
import org.apache.maven.doxia.module.site.SiteModule;
import org.apache.maven.doxia.module.site.manager.SiteModuleManager;
import org.apache.maven.doxia.module.site.manager.SiteModuleNotFoundException;
import org.apache.maven.doxia.module.xhtml.decoration.render.RenderingContext;
import org.apache.maven.doxia.parser.ParseException;
import org.apache.maven.doxia.parser.Parser;
import org.apache.maven.doxia.parser.manager.ParserNotFoundException;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.site.decoration.DecorationModel;
import org.apache.maven.doxia.siterenderer.DocumentRenderer;
import org.apache.maven.doxia.siterenderer.DoxiaDocumentRenderer;
import org.apache.maven.doxia.siterenderer.ModuleReference;
import org.apache.maven.doxia.siterenderer.Renderer;
import org.apache.maven.doxia.siterenderer.RendererException;
import org.apache.maven.doxia.siterenderer.SiteRenderingContext;
import org.apache.maven.doxia.siterenderer.sink.SiteRendererSink;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.codehaus.plexus.i18n.I18N;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.Os;
import org.codehaus.plexus.util.PathTool;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.velocity.SiteResourceLoader;
import org.codehaus.plexus.velocity.VelocityComponent;

public class DefaultSiteRenderer
extends AbstractLogEnabled
implements Renderer {
    private VelocityComponent velocity;
    private SiteModuleManager siteModuleManager;
    private Doxia doxia;
    private I18N i18n;
    private static final String RESOURCE_DIR = "org/apache/maven/doxia/siterenderer/resources";
    private static final String DEFAULT_TEMPLATE = "org/apache/maven/doxia/siterenderer/resources/default-site.vm";
    private static final String SKIN_TEMPLATE_LOCATION = "META-INF/maven/site.vm";

    public void render(Collection documents, SiteRenderingContext siteRenderingContext, File outputDirectory) throws RendererException, IOException {
        this.renderModule(documents, siteRenderingContext, outputDirectory);
        Iterator i = siteRenderingContext.getSiteDirectories().iterator();
        while (i.hasNext()) {
            File siteDirectory = (File)i.next();
            this.copyResources(siteRenderingContext, new File(siteDirectory, "resources"), outputDirectory);
        }
    }

    public Map locateDocumentFiles(SiteRenderingContext siteRenderingContext) throws IOException, RendererException {
        LinkedHashMap files = new LinkedHashMap();
        Map moduleExcludes = siteRenderingContext.getModuleExcludes();
        Iterator i = siteRenderingContext.getSiteDirectories().iterator();
        while (i.hasNext()) {
            File siteDirectory = (File)i.next();
            if (!siteDirectory.exists()) continue;
            Iterator j = this.siteModuleManager.getSiteModules().iterator();
            while (j.hasNext()) {
                SiteModule module = (SiteModule)j.next();
                File moduleBasedir = new File(siteDirectory, module.getSourceDirectory());
                if (moduleExcludes != null && moduleExcludes.containsKey(module.getParserId())) {
                    this.addModuleFiles(moduleBasedir, module, (String)moduleExcludes.get(module.getParserId()), files);
                    continue;
                }
                this.addModuleFiles(moduleBasedir, module, null, files);
            }
        }
        i = siteRenderingContext.getModules().iterator();
        while (i.hasNext()) {
            ModuleReference module = (ModuleReference)i.next();
            try {
                if (moduleExcludes != null && moduleExcludes.containsKey(module.getParserId())) {
                    this.addModuleFiles(module.getBasedir(), this.siteModuleManager.getSiteModule(module.getParserId()), (String)moduleExcludes.get(module.getParserId()), files);
                    continue;
                }
                this.addModuleFiles(module.getBasedir(), this.siteModuleManager.getSiteModule(module.getParserId()), null, files);
            }
            catch (SiteModuleNotFoundException e) {
                throw new RendererException("Unable to find module: " + e.getMessage(), e);
            }
        }
        return files;
    }

    private void addModuleFiles(File moduleBasedir, SiteModule module, String excludes, Map files) throws IOException, RendererException {
        if (moduleBasedir.exists()) {
            ArrayList docs = new ArrayList();
            docs.addAll(FileUtils.getFileNames((File)moduleBasedir, (String)("**/*." + module.getExtension()), (String)excludes, (boolean)false));
            docs.addAll(FileUtils.getFileNames((File)moduleBasedir, (String)("**/*." + module.getExtension() + ".vm"), (String)excludes, (boolean)false));
            Iterator k = docs.iterator();
            while (k.hasNext()) {
                String key;
                String doc = (String)k.next();
                RenderingContext context = new RenderingContext(moduleBasedir, doc, module.getParserId(), module.getExtension());
                if (doc.endsWith(".vm")) {
                    context.setAttribute("velocity", "true");
                }
                if (files.containsKey(key = context.getOutputName())) {
                    DocumentRenderer renderer = (DocumentRenderer)files.get(key);
                    RenderingContext originalContext = renderer.getRenderingContext();
                    File originalDoc = new File(originalContext.getBasedir(), originalContext.getInputName());
                    throw new RendererException("Files '" + doc + "' clashes with existing '" + originalDoc + "'.");
                }
                Iterator iter = files.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry entry = iter.next();
                    if (!entry.getKey().toString().toLowerCase().equals(key.toLowerCase())) continue;
                    DocumentRenderer renderer = (DocumentRenderer)files.get(entry.getKey());
                    RenderingContext originalContext = renderer.getRenderingContext();
                    File originalDoc = new File(originalContext.getBasedir(), originalContext.getInputName());
                    if (Os.isFamily((String)"windows")) {
                        throw new RendererException("Files '" + doc + "' clashes with existing '" + originalDoc + "'.");
                    }
                    this.getLogger().warn("Files '" + doc + "' could clashes with existing '" + originalDoc + "'.");
                }
                files.put(key, new DoxiaDocumentRenderer(context));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderModule(Collection docs, SiteRenderingContext siteRenderingContext, File outputDirectory) throws IOException, RendererException {
        Iterator i = docs.iterator();
        while (i.hasNext()) {
            DocumentRenderer docRenderer = (DocumentRenderer)i.next();
            RenderingContext renderingContext = docRenderer.getRenderingContext();
            File outputFile = new File(outputDirectory, docRenderer.getOutputName());
            File inputFile = new File(renderingContext.getBasedir(), renderingContext.getInputName());
            boolean modified = false;
            if (!outputFile.exists() || inputFile.lastModified() > outputFile.lastModified()) {
                modified = true;
            }
            if (modified || docRenderer.isOverwrite()) {
                if (!outputFile.getParentFile().exists()) {
                    outputFile.getParentFile().mkdirs();
                }
                this.getLogger().debug("Generating " + outputFile);
                OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), siteRenderingContext.getOutputEncoding());
                try {
                    docRenderer.renderDocument(writer, this, siteRenderingContext);
                    continue;
                }
                finally {
                    IOUtil.close((Writer)writer);
                    continue;
                }
            }
            this.getLogger().debug(inputFile + " unchanged, not regenerating...");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderDocument(Writer writer, RenderingContext renderingContext, SiteRenderingContext context) throws RendererException, FileNotFoundException, UnsupportedEncodingException {
        SiteRendererSink sink = new SiteRendererSink(renderingContext);
        File doc = new File(renderingContext.getBasedir(), renderingContext.getInputName());
        try {
            Object reader;
            block16: {
                reader = null;
                Parser parser = this.doxia.getParser(renderingContext.getParserId());
                if (renderingContext.getAttribute("velocity") != null) {
                    String resource = doc.getAbsolutePath();
                    try {
                        SiteResourceLoader.setResource((String)resource);
                        Context vc = this.createContext(sink, context);
                        StringWriter sw = new StringWriter();
                        this.velocity.getEngine().mergeTemplate(resource, context.getInputEncoding(), vc, (Writer)sw);
                        reader = new StringReader(sw.toString());
                    }
                    catch (Exception e) {
                        if (this.getLogger().isDebugEnabled()) {
                            this.getLogger().error("Error parsing " + resource + " as a velocity template, using as text.", (Throwable)e);
                            break block16;
                        }
                        this.getLogger().error("Error parsing " + resource + " as a velocity template, using as text.");
                    }
                } else {
                    switch (parser.getType()) {
                        case 2: {
                            reader = ReaderFactory.newXmlReader((File)doc);
                            break;
                        }
                        default: {
                            reader = ReaderFactory.newReader((File)doc, (String)context.getInputEncoding());
                        }
                    }
                }
            }
            this.doxia.parse((Reader)reader, renderingContext.getParserId(), (Sink)sink);
            this.generateDocument(writer, sink, context);
        }
        catch (ParserNotFoundException e) {
            throw new RendererException("Error getting a parser for " + doc + ": " + e.getMessage());
        }
        catch (ParseException e) {
            this.getLogger().error("Error parsing " + doc + ": line [" + e.getLineNumber() + "] " + e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            this.getLogger().error("Error parsing " + doc + " to detect encoding", (Throwable)e);
        }
        finally {
            sink.flush();
            sink.close();
        }
    }

    private Context createContext(SiteRendererSink sink, SiteRenderingContext siteRenderingContext) {
        VelocityContext context = new VelocityContext();
        RenderingContext renderingContext = sink.getRenderingContext();
        context.put("relativePath", (Object)renderingContext.getRelativePath());
        context.put("authors", (Object)sink.getAuthors());
        String title = "";
        if (siteRenderingContext.getDecoration().getName() != null) {
            title = siteRenderingContext.getDecoration().getName();
        } else if (siteRenderingContext.getDefaultWindowTitle() != null) {
            title = siteRenderingContext.getDefaultWindowTitle();
        }
        if (title.length() > 0) {
            title = title + " - ";
        }
        title = title + sink.getTitle();
        context.put("title", (Object)title);
        context.put("bodyContent", (Object)sink.getBody());
        context.put("decoration", (Object)siteRenderingContext.getDecoration());
        context.put("currentDate", (Object)new Date());
        Locale locale = siteRenderingContext.getLocale();
        context.put("dateFormat", (Object)DateFormat.getDateInstance(2, locale));
        String currentFileName = renderingContext.getOutputName().replace('\\', '/');
        context.put("currentFileName", (Object)currentFileName);
        context.put("alignedFileName", (Object)PathTool.calculateLink((String)currentFileName, (String)renderingContext.getRelativePath()));
        context.put("locale", (Object)locale);
        Map templateProperties = siteRenderingContext.getTemplateProperties();
        if (templateProperties != null) {
            Iterator i = templateProperties.keySet().iterator();
            while (i.hasNext()) {
                String key = (String)i.next();
                context.put(key, templateProperties.get(key));
            }
        }
        context.put("PathTool", (Object)new PathTool());
        context.put("FileUtils", (Object)new FileUtils());
        context.put("StringUtils", (Object)new StringUtils());
        context.put("i18n", (Object)this.i18n);
        return context;
    }

    public void generateDocument(Writer writer, SiteRendererSink sink, SiteRenderingContext siteRenderingContext) throws RendererException {
        Context context = this.createContext(sink, siteRenderingContext);
        this.writeTemplate(writer, context, siteRenderingContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeTemplate(Writer writer, Context context, SiteRenderingContext siteContext) throws RendererException {
        ClassLoader old = null;
        if (siteContext.getTemplateClassLoader() != null) {
            old = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(siteContext.getTemplateClassLoader());
        }
        try {
            this.processTemplate(siteContext.getTemplateName(), context, writer);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            IOUtil.close((Writer)writer);
            if (old != null) {
                Thread.currentThread().setContextClassLoader(old);
            }
            throw throwable;
        }
        IOUtil.close((Writer)writer);
        if (old != null) {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    private void processTemplate(String templateName, Context context, Writer writer) throws RendererException {
        Template template;
        try {
            template = this.velocity.getEngine().getTemplate(templateName);
        }
        catch (Exception e) {
            throw new RendererException("Could not find the template '" + templateName);
        }
        try {
            template.merge(context, writer);
        }
        catch (Exception e) {
            throw new RendererException("Error while generating code.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SiteRenderingContext createContextForSkin(File skinFile, Map attributes, DecorationModel decoration, String defaultWindowTitle, Locale locale) throws IOException {
        SiteRenderingContext context = new SiteRenderingContext();
        ZipFile zipFile = new ZipFile(skinFile);
        try {
            if (zipFile.getEntry(SKIN_TEMPLATE_LOCATION) != null) {
                context.setTemplateName(SKIN_TEMPLATE_LOCATION);
                context.setTemplateClassLoader(new URLClassLoader(new URL[]{skinFile.toURL()}));
            } else {
                context.setTemplateName(DEFAULT_TEMPLATE);
                context.setTemplateClassLoader(this.getClass().getClassLoader());
                context.setUsingDefaultTemplate(true);
            }
        }
        finally {
            this.closeZipFile(zipFile);
        }
        context.setTemplateProperties(attributes);
        context.setLocale(locale);
        context.setDecoration(decoration);
        context.setDefaultWindowTitle(defaultWindowTitle);
        context.setSkinJarFile(skinFile);
        return context;
    }

    public SiteRenderingContext createContextForTemplate(File templateFile, File skinFile, Map attributes, DecorationModel decoration, String defaultWindowTitle, Locale locale) throws MalformedURLException {
        SiteRenderingContext context = new SiteRenderingContext();
        context.setTemplateName(templateFile.getName());
        context.setTemplateClassLoader(new URLClassLoader(new URL[]{templateFile.getParentFile().toURI().toURL()}));
        context.setTemplateProperties(attributes);
        context.setLocale(locale);
        context.setDecoration(decoration);
        context.setDefaultWindowTitle(defaultWindowTitle);
        context.setSkinJarFile(skinFile);
        return context;
    }

    private void closeZipFile(ZipFile zipFile) {
        try {
            zipFile.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyResources(SiteRenderingContext siteRenderingContext, File resourcesDirectory, File outputDirectory) throws IOException {
        File siteCssFile;
        InputStream resourceList;
        if (siteRenderingContext.getSkinJarFile() != null) {
            ZipFile file = new ZipFile(siteRenderingContext.getSkinJarFile());
            try {
                Enumeration<? extends ZipEntry> e = file.entries();
                while (e.hasMoreElements()) {
                    ZipEntry entry = e.nextElement();
                    if (entry.getName().startsWith("META-INF/")) continue;
                    File destFile = new File(outputDirectory, entry.getName());
                    if (!entry.isDirectory()) {
                        destFile.getParentFile().mkdirs();
                        this.copyFileFromZip(file, entry, destFile);
                        continue;
                    }
                    destFile.mkdirs();
                }
            }
            finally {
                file.close();
            }
        }
        if (siteRenderingContext.isUsingDefaultTemplate() && (resourceList = this.getClass().getClassLoader().getResourceAsStream("org/apache/maven/doxia/siterenderer/resources/resources.txt")) != null) {
            LineNumberReader reader = new LineNumberReader(new InputStreamReader(resourceList));
            String line = reader.readLine();
            while (line != null) {
                InputStream is = this.getClass().getClassLoader().getResourceAsStream("org/apache/maven/doxia/siterenderer/resources/" + line);
                if (is == null) {
                    throw new IOException("The resource " + line + " doesn't exist.");
                }
                File outputFile = new File(outputDirectory, line);
                if (!outputFile.getParentFile().exists()) {
                    outputFile.getParentFile().mkdirs();
                }
                FileOutputStream w = new FileOutputStream(outputFile);
                IOUtil.copy((InputStream)is, (OutputStream)w);
                IOUtil.close((InputStream)is);
                IOUtil.close((OutputStream)w);
                line = reader.readLine();
            }
        }
        if (resourcesDirectory != null && resourcesDirectory.exists()) {
            this.copyDirectory(resourcesDirectory, outputDirectory);
        }
        if (!(siteCssFile = new File(outputDirectory, "/css/site.css")).exists()) {
            File cssDirectory = new File(outputDirectory, "/css/");
            boolean created = cssDirectory.mkdirs();
            if (created && this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("The directory '" + cssDirectory.getAbsolutePath() + "' did not exist. It was created.");
            }
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("The file '" + siteCssFile.getAbsolutePath() + "' does not exists. Creating an empty file.");
            }
            FileWriter w = new FileWriter(siteCssFile);
            w.write("/* You can override this file with your own styles */");
            IOUtil.close((Writer)w);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFileFromZip(ZipFile file, ZipEntry entry, File destFile) throws IOException {
        FileOutputStream fos = new FileOutputStream(destFile);
        try {
            IOUtil.copy((InputStream)file.getInputStream(entry), (OutputStream)fos);
        }
        finally {
            IOUtil.close((OutputStream)fos);
        }
    }

    protected void copyDirectory(File source, File destination) throws IOException {
        if (source.exists()) {
            DirectoryScanner scanner = new DirectoryScanner();
            String[] includedResources = new String[]{"**/**"};
            scanner.setIncludes(includedResources);
            scanner.addDefaultExcludes();
            scanner.setBasedir(source);
            scanner.scan();
            List<String> includedFiles = Arrays.asList(scanner.getIncludedFiles());
            Iterator<String> j = includedFiles.iterator();
            while (j.hasNext()) {
                String name = j.next();
                File sourceFile = new File(source, name);
                File destinationFile = new File(destination, name);
                FileUtils.copyFile((File)sourceFile, (File)destinationFile);
            }
        }
    }
}

