/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.assembly.io;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugins.assembly.io.FileLocation;

class URLLocation
extends FileLocation {
    private final URL url;
    private final String tempFilePrefix;
    private final String tempFileSuffix;
    private final boolean tempFileDeleteOnExit;

    URLLocation(URL url, String specification, String tempFilePrefix, String tempFileSuffix, boolean tempFileDeleteOnExit) {
        super(specification);
        this.url = url;
        this.tempFilePrefix = tempFilePrefix;
        this.tempFileSuffix = tempFileSuffix;
        this.tempFileDeleteOnExit = tempFileDeleteOnExit;
    }

    @Override
    protected void initFile() throws IOException {
        if (this.unsafeGetFile() == null) {
            File tempFile = Files.createTempFile(this.tempFilePrefix, this.tempFileSuffix, new FileAttribute[0]).toFile();
            if (this.tempFileDeleteOnExit) {
                tempFile.deleteOnExit();
            }
            IOUtils.copy((URL)this.url, (File)tempFile);
            this.setFile(tempFile);
        }
    }
}

