/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.obrplugin;

import java.net.URI;
import java.util.Arrays;
import java.util.List;
import org.apache.felix.obrplugin.AbstractFileMojo;
import org.apache.felix.obrplugin.Config;
import org.apache.felix.obrplugin.ObrUpdate;
import org.apache.felix.obrplugin.ObrUtils;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="install-file", requiresProject=false)
@Execute(phase=LifecyclePhase.INSTALL)
public final class ObrInstallFile
extends AbstractFileMojo {
    @Parameter(property="obrRepository")
    private String obrRepository;
    @Parameter
    private List supportedProjectTypes = Arrays.asList("jar", "bundle");
    @Parameter(defaultValue="${localRepository}", readonly=true, required=true)
    private ArtifactRepository localRepository;

    public void execute() throws MojoExecutionException {
        MavenProject project = this.getProject();
        String projectType = project.getPackaging();
        if (!this.supportedProjectTypes.contains(projectType)) {
            this.getLog().warn((CharSequence)("Ignoring project type " + projectType + " - supportedProjectTypes = " + this.supportedProjectTypes));
            return;
        }
        if ("NONE".equalsIgnoreCase(this.obrRepository) || "false".equalsIgnoreCase(this.obrRepository)) {
            this.getLog().info((CharSequence)"Local OBR update disabled (enable with -DobrRepository)");
            return;
        }
        Log log = this.getLog();
        String mavenRepository = this.localRepository.getBasedir();
        URI repositoryXml = ObrUtils.findRepositoryXml(mavenRepository, this.obrRepository);
        URI obrXmlFile = ObrUtils.toFileURI(this.obrXml);
        URI bundleJar = null == this.file ? ObrUtils.getArtifactURI(this.localRepository, project.getArtifact()) : this.file.toURI();
        Config userConfig = new Config();
        ObrUpdate update = new ObrUpdate(repositoryXml, obrXmlFile, project, mavenRepository, userConfig, log);
        update.parseRepositoryXml();
        update.updateRepository(bundleJar, null, null);
        update.writeRepositoryXml();
    }
}

