/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.util;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.util.Objects;
import org.apache.maven.doxia.parser.ParseException;
import org.apache.maven.doxia.util.ByLineSource;

public class ByLineReaderSource
implements ByLineSource {
    private LineNumberReader reader;
    private int lineNumber;
    private String lastLine;
    private boolean ungetted = false;
    private String name;

    public ByLineReaderSource(Reader in) {
        this(in, "");
    }

    public ByLineReaderSource(Reader in, String name) {
        this.reader = new LineNumberReader(in);
        this.name = name;
        this.lineNumber = -1;
    }

    @Override
    public final String getNextLine() throws ParseException {
        String line;
        if (this.reader == null) {
            return null;
        }
        if (this.ungetted) {
            this.ungetted = false;
            return this.lastLine;
        }
        try {
            line = this.reader.readLine();
            if (line == null) {
                this.reader.close();
                this.reader = null;
            } else {
                this.lineNumber = this.reader.getLineNumber();
            }
        }
        catch (IOException e) {
            throw new ParseException(e, this.lineNumber, 0);
        }
        this.lastLine = line;
        return line;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final int getLineNumber() {
        return this.lineNumber;
    }

    @Override
    public final void close() {
        if (this.reader == null) {
            return;
        }
        try {
            this.reader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.reader = null;
    }

    @Override
    public final void ungetLine() {
        if (this.ungetted) {
            throw new IllegalStateException("we support only one level of ungetLine()");
        }
        this.ungetted = true;
    }

    @Override
    public final void unget(String s) {
        Objects.requireNonNull(s, "s cannot be null");
        if (s.length() != 0) {
            this.ungetLine();
            this.lastLine = s;
        }
    }
}

