/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.util;

import java.io.IOException;
import java.io.StringReader;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.maven.doxia.markup.XmlMarkup;
import org.apache.maven.doxia.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class XmlValidator {
    private static final Logger LOGGER = LoggerFactory.getLogger(XmlValidator.class);
    private XMLReader xmlReader;
    private boolean validate = true;
    private DefaultHandler defaultHandler;
    private EntityResolver entityResolver;

    public boolean isValidate() {
        return this.validate;
    }

    public void setValidate(boolean validate) {
        this.validate = validate;
    }

    public DefaultHandler getDefaultHandler() {
        return this.defaultHandler;
    }

    public void setDefaultHandler(DefaultHandler defaultHandler) {
        this.defaultHandler = defaultHandler;
    }

    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    public void validate(String content) throws ParseException {
        try {
            this.getXmlReader().parse(new InputSource(new StringReader(content)));
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new ParseException("Error validating the model", e);
        }
    }

    public XMLReader getXmlReader() throws SAXException, ParserConfigurationException {
        if (this.xmlReader == null) {
            SAXParserFactory parserFactory = SAXParserFactory.newInstance();
            parserFactory.setNamespaceAware(true);
            SAXParser parser = parserFactory.newSAXParser();
            parser.setProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
            parser.setProperty("http://apache.org/xml/properties/locale", Locale.ROOT);
            this.xmlReader = parser.getXMLReader();
            this.xmlReader.setFeature("http://xml.org/sax/features/validation", this.isValidate());
            this.xmlReader.setFeature("http://apache.org/xml/features/validation/dynamic", this.isValidate());
            this.xmlReader.setFeature("http://apache.org/xml/features/validation/schema", this.isValidate());
            this.xmlReader.setErrorHandler(this.getDefaultHandler());
            this.xmlReader.setEntityResolver(this.getEntityResolver());
        }
        return this.xmlReader;
    }

    public static class MessagesErrorHandler
    extends DefaultHandler {
        private static final int TYPE_UNKNOWN = 0;
        private static final int TYPE_WARNING = 1;
        private static final int TYPE_ERROR = 2;
        private static final int TYPE_FATAL = 3;
        private static final String EOL = XmlMarkup.EOL;
        private static final Pattern ELEMENT_TYPE_PATTERN = Pattern.compile("Element type \".*\" must be declared.", 32);

        @Override
        public void warning(SAXParseException e) throws SAXException {
            this.processException(1, e);
        }

        @Override
        public void error(SAXParseException e) throws SAXException {
            Matcher m = ELEMENT_TYPE_PATTERN.matcher(e.getMessage());
            if (!m.find()) {
                this.processException(2, e);
            }
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            this.processException(3, e);
        }

        private void processException(int type, SAXParseException e) throws SAXException {
            StringBuilder message = new StringBuilder();
            switch (type) {
                case 1: {
                    message.append("Warning:");
                    break;
                }
                case 2: {
                    message.append("Error:");
                    break;
                }
                case 3: {
                    message.append("Fatal error:");
                    break;
                }
                default: {
                    message.append("Unknown:");
                }
            }
            message.append(EOL);
            message.append("  Public ID: ").append(e.getPublicId()).append(EOL);
            message.append("  System ID: ").append(e.getSystemId()).append(EOL);
            message.append("  Line number: ").append(e.getLineNumber()).append(EOL);
            message.append("  Column number: ").append(e.getColumnNumber()).append(EOL);
            message.append("  Message: ").append(e.getMessage()).append(EOL);
            String logMessage = message.toString();
            switch (type) {
                case 1: {
                    LOGGER.warn(logMessage);
                    break;
                }
                default: {
                    throw new SAXException(logMessage);
                }
            }
        }
    }
}

