; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=aarch64-- | FileCheck %s --check-prefixes=CHECK,CHECK-SD
; RUN: llc < %s -mtriple=aarch64-- -global-isel -global-isel-abort=2 2>&1 | FileCheck %s --check-prefixes=CHECK,CHECK-GI

declare i4 @llvm.usub.sat.i4(i4, i4)
declare i8 @llvm.usub.sat.i8(i8, i8)
declare i16 @llvm.usub.sat.i16(i16, i16)
declare i32 @llvm.usub.sat.i32(i32, i32)
declare i64 @llvm.usub.sat.i64(i64, i64)

define i32 @func32(i32 %x, i32 %y, i32 %z) nounwind {
; CHECK-SD-LABEL: func32:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    mul w8, w1, w2
; CHECK-SD-NEXT:    subs w8, w0, w8
; CHECK-SD-NEXT:    csel w0, wzr, w8, lo
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: func32:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    mul w8, w1, w2
; CHECK-GI-NEXT:    subs w8, w0, w8
; CHECK-GI-NEXT:    cset w9, lo
; CHECK-GI-NEXT:    tst w9, #0x1
; CHECK-GI-NEXT:    csel w0, wzr, w8, ne
; CHECK-GI-NEXT:    ret
  %a = mul i32 %y, %z
  %tmp = call i32 @llvm.usub.sat.i32(i32 %x, i32 %a)
  ret i32 %tmp
}

define i64 @func64(i64 %x, i64 %y, i64 %z) nounwind {
; CHECK-SD-LABEL: func64:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    subs x8, x0, x2
; CHECK-SD-NEXT:    csel x0, xzr, x8, lo
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: func64:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    subs x8, x0, x2
; CHECK-GI-NEXT:    cset w9, lo
; CHECK-GI-NEXT:    tst w9, #0x1
; CHECK-GI-NEXT:    csel x0, xzr, x8, ne
; CHECK-GI-NEXT:    ret
  %a = mul i64 %y, %z
  %tmp = call i64 @llvm.usub.sat.i64(i64 %x, i64 %z)
  ret i64 %tmp
}

define i16 @func16(i16 %x, i16 %y, i16 %z) nounwind {
; CHECK-SD-LABEL: func16:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    mul w8, w1, w2
; CHECK-SD-NEXT:    and w9, w0, #0xffff
; CHECK-SD-NEXT:    subs w8, w9, w8, uxth
; CHECK-SD-NEXT:    csel w0, wzr, w8, lo
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: func16:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    mul w8, w1, w2
; CHECK-GI-NEXT:    and w9, w0, #0xffff
; CHECK-GI-NEXT:    sub w8, w9, w8, uxth
; CHECK-GI-NEXT:    cmp w8, w8, uxth
; CHECK-GI-NEXT:    csel w0, wzr, w8, ne
; CHECK-GI-NEXT:    ret
  %a = mul i16 %y, %z
  %tmp = call i16 @llvm.usub.sat.i16(i16 %x, i16 %a)
  ret i16 %tmp
}

define i8 @func8(i8 %x, i8 %y, i8 %z) nounwind {
; CHECK-SD-LABEL: func8:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    mul w8, w1, w2
; CHECK-SD-NEXT:    and w9, w0, #0xff
; CHECK-SD-NEXT:    subs w8, w9, w8, uxtb
; CHECK-SD-NEXT:    csel w0, wzr, w8, lo
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: func8:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    mul w8, w1, w2
; CHECK-GI-NEXT:    and w9, w0, #0xff
; CHECK-GI-NEXT:    sub w8, w9, w8, uxtb
; CHECK-GI-NEXT:    cmp w8, w8, uxtb
; CHECK-GI-NEXT:    csel w0, wzr, w8, ne
; CHECK-GI-NEXT:    ret
  %a = mul i8 %y, %z
  %tmp = call i8 @llvm.usub.sat.i8(i8 %x, i8 %a)
  ret i8 %tmp
}

define i4 @func4(i4 %x, i4 %y, i4 %z) nounwind {
; CHECK-SD-LABEL: func4:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    mul w8, w1, w2
; CHECK-SD-NEXT:    and w9, w0, #0xf
; CHECK-SD-NEXT:    and w8, w8, #0xf
; CHECK-SD-NEXT:    subs w8, w9, w8
; CHECK-SD-NEXT:    csel w0, wzr, w8, lo
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: func4:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    mul w8, w1, w2
; CHECK-GI-NEXT:    and w9, w0, #0xf
; CHECK-GI-NEXT:    and w8, w8, #0xf
; CHECK-GI-NEXT:    sub w8, w9, w8
; CHECK-GI-NEXT:    and w9, w8, #0xf
; CHECK-GI-NEXT:    cmp w8, w9
; CHECK-GI-NEXT:    csel w0, wzr, w8, ne
; CHECK-GI-NEXT:    ret
  %a = mul i4 %y, %z
  %tmp = call i4 @llvm.usub.sat.i4(i4 %x, i4 %a)
  ret i4 %tmp
}
;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; CHECK: {{.*}}
