; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -passes=constraint-elimination -S %s | FileCheck %s

target datalayout = "e-m:o-p270:32:32-p271:32:32-p272:64:64-i64:64-f80:128-n8:16:32:64-S128"


declare void @use(i1)

define void @test_phi_not_in_loop_header() {
; CHECK-LABEL: @test_phi_not_in_loop_header(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[OUTER_HEADER:%.*]]
; CHECK:       outer.header:
; CHECK-NEXT:    [[IV:%.*]] = phi i32 [ 1, [[ENTRY:%.*]] ], [ [[IV_NEXT:%.*]], [[OUTER_LATCH:%.*]] ]
; CHECK-NEXT:    br label [[INNER_HEADER:%.*]]
; CHECK:       inner.header:
; CHECK-NEXT:    [[CMP2_I:%.*]] = icmp eq i32 [[IV]], 3
; CHECK-NEXT:    br i1 [[CMP2_I]], label [[OUTER_LATCH]], label [[INNER_LATCH:%.*]]
; CHECK:       inner.latch:
; CHECK-NEXT:    [[C:%.*]] = icmp uge i32 [[IV]], 1
; CHECK-NEXT:    call void @use(i1 [[C]])
; CHECK-NEXT:    br label [[INNER_HEADER]]
; CHECK:       outer.latch:
; CHECK-NEXT:    [[IV_NEXT]] = add i32 [[IV]], 1
; CHECK-NEXT:    br label [[OUTER_HEADER]]
;
entry:
  br label %outer.header

outer.header:
  %iv = phi i32 [ 1, %entry ], [ %iv.next, %outer.latch ]
  br label %inner.header

inner.header:
  %cmp2.i = icmp eq i32 %iv, 3
  br i1 %cmp2.i, label %outer.latch, label %inner.latch

inner.latch:
  %c = icmp uge i32 %iv, 1
  call void @use(i1 %c)
  br label %inner.header

outer.latch:
  %iv.next = add i32 %iv, 1
  br label %outer.header
}

define void @multiple_successor_to_header_same_incoming(i8 %len.n, i16 %a, i1 %c.0) {
; CHECK-LABEL: @multiple_successor_to_header_same_incoming(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[LEN:%.*]] = zext i8 [[LEN_N:%.*]] to i16
; CHECK-NEXT:    [[LEN_NEG:%.*]] = icmp uge i16 [[LEN]], [[A:%.*]]
; CHECK-NEXT:    br i1 [[LEN_NEG]], label [[EXIT:%.*]], label [[LOOP_PH_1:%.*]]
; CHECK:       loop.ph.1:
; CHECK-NEXT:    br i1 [[C_0:%.*]], label [[LOOP_PH_2:%.*]], label [[LOOP_PH_3:%.*]]
; CHECK:       loop.ph.2:
; CHECK-NEXT:    br label [[LOOP_HEADER:%.*]]
; CHECK:       loop.ph.3:
; CHECK-NEXT:    br label [[LOOP_HEADER]]
; CHECK:       loop.header:
; CHECK-NEXT:    [[IV:%.*]] = phi i16 [ 0, [[LOOP_PH_2]] ], [ 0, [[LOOP_PH_3]] ], [ [[IV_NEXT:%.*]], [[LOOP_LATCH:%.*]] ]
; CHECK-NEXT:    [[C:%.*]] = icmp eq i16 [[IV]], [[LEN]]
; CHECK-NEXT:    br i1 [[C]], label [[EXIT]], label [[FOR_BODY:%.*]]
; CHECK:       for.body:
; CHECK-NEXT:    [[T_2:%.*]] = icmp ult i16 [[IV]], [[A]]
; CHECK-NEXT:    [[AND:%.*]] = and i1 true, [[T_2]]
; CHECK-NEXT:    br i1 [[AND]], label [[LOOP_LATCH]], label [[EXIT]]
; CHECK:       loop.latch:
; CHECK-NEXT:    call void @use(i16 [[IV]])
; CHECK-NEXT:    [[IV_NEXT]] = add nuw nsw i16 [[IV]], 1
; CHECK-NEXT:    br label [[LOOP_HEADER]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  %len = zext i8 %len.n to i16
  %len.neg = icmp uge i16 %len, %a
  br i1 %len.neg, label %exit, label %loop.ph.1

loop.ph.1:
  br i1 %c.0, label %loop.ph.2, label %loop.ph.3

loop.ph.2:
  br label %loop.header

loop.ph.3:
  br label %loop.header

loop.header:
  %iv = phi i16 [ 0, %loop.ph.2 ], [ 0, %loop.ph.3 ], [ %iv.next, %loop.latch ]
  %c = icmp eq i16 %iv, %len
  br i1 %c, label %exit, label %for.body

for.body:
  %t.1 = icmp uge i16 %iv, 0
  %t.2 = icmp ult i16 %iv, %a
  %and = and i1 %t.1, %t.2
  br i1 %and, label %loop.latch, label %exit

loop.latch:
  call void @use(i16 %iv)
  %iv.next = add nuw nsw i16 %iv, 1
  br label %loop.header

exit:
  ret void
}

define void @multiple_successor_to_header_different_incoming(i8 %len.n, i16 %a, i1 %c.0) {
; CHECK-LABEL: @multiple_successor_to_header_different_incoming(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[LEN:%.*]] = zext i8 [[LEN_N:%.*]] to i16
; CHECK-NEXT:    [[LEN_NEG:%.*]] = icmp uge i16 [[LEN]], [[A:%.*]]
; CHECK-NEXT:    br i1 [[LEN_NEG]], label [[EXIT:%.*]], label [[LOOP_PH_1:%.*]]
; CHECK:       loop.ph.1:
; CHECK-NEXT:    br i1 [[C_0:%.*]], label [[LOOP_PH_2:%.*]], label [[LOOP_PH_3:%.*]]
; CHECK:       loop.ph.2:
; CHECK-NEXT:    br label [[LOOP_HEADER:%.*]]
; CHECK:       loop.ph.3:
; CHECK-NEXT:    br label [[LOOP_HEADER]]
; CHECK:       loop.header:
; CHECK-NEXT:    [[IV:%.*]] = phi i16 [ 0, [[LOOP_PH_2]] ], [ 1, [[LOOP_PH_3]] ], [ [[IV_NEXT:%.*]], [[LOOP_LATCH:%.*]] ]
; CHECK-NEXT:    [[C:%.*]] = icmp eq i16 [[IV]], [[LEN]]
; CHECK-NEXT:    br i1 [[C]], label [[EXIT]], label [[FOR_BODY:%.*]]
; CHECK:       for.body:
; CHECK-NEXT:    [[T_2:%.*]] = icmp ult i16 [[IV]], [[A]]
; CHECK-NEXT:    [[AND:%.*]] = and i1 true, [[T_2]]
; CHECK-NEXT:    br i1 [[AND]], label [[LOOP_LATCH]], label [[EXIT]]
; CHECK:       loop.latch:
; CHECK-NEXT:    call void @use(i16 [[IV]])
; CHECK-NEXT:    [[IV_NEXT]] = add nuw nsw i16 [[IV]], 1
; CHECK-NEXT:    br label [[LOOP_HEADER]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  %len = zext i8 %len.n to i16
  %len.neg = icmp uge i16 %len, %a
  br i1 %len.neg, label %exit, label %loop.ph.1

loop.ph.1:
  br i1 %c.0, label %loop.ph.2, label %loop.ph.3

loop.ph.2:
  br label %loop.header

loop.ph.3:
  br label %loop.header

loop.header:
  %iv = phi i16 [ 0, %loop.ph.2 ], [ 1, %loop.ph.3 ], [ %iv.next, %loop.latch ]
  %c = icmp eq i16 %iv, %len
  br i1 %c, label %exit, label %for.body

for.body:
  %t.1 = icmp uge i16 %iv, 0
  %t.2 = icmp ult i16 %iv, %a
  %and = and i1 %t.1, %t.2
  br i1 %and, label %loop.latch, label %exit

loop.latch:
  call void @use(i16 %iv)
  %iv.next = add nuw nsw i16 %iv, 1
  br label %loop.header

exit:
  ret void
}
