add_library(FileServiceHeaderPaths INTERFACE)
add_library(MEGA::FileServiceHeaderPaths ALIAS FileServiceHeaderPaths)

target_include_directories(FileServiceHeaderPaths INTERFACE
                                                  src/file_service
)

target_link_libraries(SDKlib PRIVATE FileServiceHeaderPaths)

target_sources(SDKlib PRIVATE
                      include/mega/file_service/file.h
                      include/mega/file_service/file_callbacks.h
                      include/mega/file_service/file_context_badge_forward.h
                      include/mega/file_service/file_context_forward.h
                      include/mega/file_service/file_context_pointer.h
                      include/mega/file_service/file_event.h
                      include/mega/file_service/file_event_emitter_forward.h
                      include/mega/file_service/file_event_forward.h
                      include/mega/file_service/file_event_observer.h
                      include/mega/file_service/file_event_observer_id.h
                      include/mega/file_service/file_event_observer_result.h
                      include/mega/file_service/file_event_observer_result_forward.h
                      include/mega/file_service/file_flush_event.h
                      include/mega/file_service/file_flush_event_forward.h
                      include/mega/file_service/file_forward.h
                      include/mega/file_service/file_id.h
                      include/mega/file_service/file_id_forward.h
                      include/mega/file_service/file_info.h
                      include/mega/file_service/file_info_context_forward.h
                      include/mega/file_service/file_info_context_pointer.h
                      include/mega/file_service/file_info_forward.h
                      include/mega/file_service/file_location.h
                      include/mega/file_service/file_location_forward.h
                      include/mega/file_service/file_move_event.h
                      include/mega/file_service/file_move_event_forward.h
                      include/mega/file_service/file_range.h
                      include/mega/file_service/file_range_forward.h
                      include/mega/file_service/file_range_vector.h
                      include/mega/file_service/file_read_result.h
                      include/mega/file_service/file_remove_event.h
                      include/mega/file_service/file_remove_event_forward.h
                      include/mega/file_service/file_result.h
                      include/mega/file_service/file_result_forward.h
                      include/mega/file_service/file_result_or.h
                      include/mega/file_service/file_result_or_forward.h
                      include/mega/file_service/file_service.h
                      include/mega/file_service/file_service_callbacks.h
                      include/mega/file_service/file_service_context_badge.h
                      include/mega/file_service/file_service_context_badge_forward.h
                      include/mega/file_service/file_service_context_forward.h
                      include/mega/file_service/file_service_context_pointer.h
                      include/mega/file_service/file_service_forward.h
                      include/mega/file_service/file_service_options.h
                      include/mega/file_service/file_service_options_forward.h
                      include/mega/file_service/file_service_result.h
                      include/mega/file_service/file_service_result_forward.h
                      include/mega/file_service/file_service_result_or.h
                      include/mega/file_service/file_service_result_or_forward.h
                      include/mega/file_service/file_touch_event.h
                      include/mega/file_service/file_touch_event_forward.h
                      include/mega/file_service/file_truncate_event.h
                      include/mega/file_service/file_truncate_event_forward.h
                      include/mega/file_service/file_write_event.h
                      include/mega/file_service/file_write_event_forward.h
                      include/mega/file_service/file_write_result.h
                      include/mega/file_service/sink.h
                      include/mega/file_service/sink_forward.h
                      include/mega/file_service/source.h
                      include/mega/file_service/source_forward.h
)

target_sources(SDKlib PRIVATE
                      src/file_service/mega/file_service/avl_tree.h
                      src/file_service/mega/file_service/avl_tree_forward.h
                      src/file_service/mega/file_service/avl_tree_iterator.h
                      src/file_service/mega/file_service/avl_tree_node.h
                      src/file_service/mega/file_service/avl_tree_traits.h
                      src/file_service/mega/file_service/buffer.h
                      src/file_service/mega/file_service/buffer_forward.h
                      src/file_service/mega/file_service/buffer_pointer.h
                      src/file_service/mega/file_service/database_builder.h
                      src/file_service/mega/file_service/displaced_buffer.h
                      src/file_service/mega/file_service/displaced_buffer_forward.h
                      src/file_service/mega/file_service/displaced_buffer_pointer.h
                      src/file_service/mega/file_service/file_access.h
                      src/file_service/mega/file_service/file_append_request.h
                      src/file_service/mega/file_service/file_append_request_forward.h
                      src/file_service/mega/file_service/file_buffer.h
                      src/file_service/mega/file_service/file_buffer_forward.h
                      src/file_service/mega/file_service/file_buffer_pointer.h
                      src/file_service/mega/file_service/file_context.h
                      src/file_service/mega/file_service/file_context_badge.h
                      src/file_service/mega/file_service/file_event_emitter.h
                      src/file_service/mega/file_service/file_event_vector.h
                      src/file_service/mega/file_service/file_fetch_request.h
                      src/file_service/mega/file_service/file_fetch_request_forward.h
                      src/file_service/mega/file_service/file_flush_request.h
                      src/file_service/mega/file_service/file_flush_request_forward.h
                      src/file_service/mega/file_service/file_id_vector.h
                      src/file_service/mega/file_service/file_info_context.h
                      src/file_service/mega/file_service/file_info_context_badge.h
                      src/file_service/mega/file_service/file_info_context_badge_forward.h
                      src/file_service/mega/file_service/file_range_context.h
                      src/file_service/mega/file_service/file_range_context_forward.h
                      src/file_service/mega/file_service/file_range_context_manager.h
                      src/file_service/mega/file_service/file_range_context_manager_forward.h
                      src/file_service/mega/file_service/file_range_context_pointer.h
                      src/file_service/mega/file_service/file_range_context_pointer_map.h
                      src/file_service/mega/file_service/file_range_map.h
                      src/file_service/mega/file_service/file_range_set.h
                      src/file_service/mega/file_service/file_range_traits.h
                      src/file_service/mega/file_service/file_range_tree.h
                      src/file_service/mega/file_service/file_range_tree_node.h
                      src/file_service/mega/file_service/file_range_tree_traits.h
                      src/file_service/mega/file_service/file_read_request.h
                      src/file_service/mega/file_service/file_read_request_forward.h
                      src/file_service/mega/file_service/file_read_request_set.h
                      src/file_service/mega/file_service/file_read_write_state.h
                      src/file_service/mega/file_service/file_reclaim_request.h
                      src/file_service/mega/file_service/file_reclaim_request_forward.h
                      src/file_service/mega/file_service/file_remove_request.h
                      src/file_service/mega/file_service/file_remove_request_forward.h
                      src/file_service/mega/file_service/file_request.h
                      src/file_service/mega/file_service/file_request_list.h
                      src/file_service/mega/file_service/file_request_tags.h
                      src/file_service/mega/file_service/file_service_context.h
                      src/file_service/mega/file_service/file_service_queries.h
                      src/file_service/mega/file_service/file_size_info.h
                      src/file_service/mega/file_service/file_size_info_forward.h
                      src/file_service/mega/file_service/file_storage.h
                      src/file_service/mega/file_service/file_touch_request.h
                      src/file_service/mega/file_service/file_touch_request_forward.h
                      src/file_service/mega/file_service/file_truncate_request.h
                      src/file_service/mega/file_service/file_truncate_request_forward.h
                      src/file_service/mega/file_service/file_write_request.h
                      src/file_service/mega/file_service/file_write_request_forward.h
                      src/file_service/mega/file_service/from_file_id_map.h
                      src/file_service/mega/file_service/logger.h
                      src/file_service/mega/file_service/logging.h
                      src/file_service/mega/file_service/memory_buffer.h
                      src/file_service/mega/file_service/sparse_file_buffer.h
                      src/file_service/mega/file_service/type_traits.h
)

target_sources(SDKlib PRIVATE
                      src/file_service/buffer.cpp
                      src/file_service/database_builder.cpp
                      src/file_service/displaced_buffer.cpp
                      src/file_service/file.cpp
                      src/file_service/file_access.cpp
                      src/file_service/file_buffer.cpp
                      src/file_service/file_context.cpp
                      src/file_service/file_event_emitter.cpp
                      src/file_service/file_id.cpp
                      src/file_service/file_info.cpp
                      src/file_service/file_info_context.cpp
                      src/file_service/file_range.cpp
                      src/file_service/file_range_context.cpp
                      src/file_service/file_read_request_set.cpp
                      src/file_service/file_read_write_state.cpp
                      src/file_service/file_result.cpp
                      src/file_service/file_service.cpp
                      src/file_service/file_service_context.cpp
                      src/file_service/file_service_queries.cpp
                      src/file_service/file_service_result.cpp
                      src/file_service/file_storage.cpp
                      src/file_service/logger.cpp
                      src/file_service/memory_buffer.cpp
                      src/file_service/sparse_file_buffer.cpp
)
