#pragma once

#include <mega/common/error_or_forward.h>
#include <mega/common/testing/client_forward.h>
#include <mega/common/testing/cloud_path_forward.h>
#include <mega/types.h>

namespace mega
{
namespace common
{
namespace testing
{

class CloudPath
{
    NodeHandle mHandle;
    std::string mPath;

public:
    CloudPath() = default;

    CloudPath(const CloudPath& other) = default;

    CloudPath(CloudPath&& other) = default;

    CloudPath(const std::string& path);

    CloudPath(const char* path);

    CloudPath(NodeHandle handle);

    ~CloudPath() = default;

    CloudPath& operator=(const CloudPath& rhs) = default;

    CloudPath& operator=(CloudPath&& rhs) = default;

    ErrorOr<NodeHandle> resolve(const Client& client) const;
}; // CloudPath

} // testing
} // common
} // mega
