---
title: "Grafana Mimir version 2.13 release notes"
menuTitle: "V2.13 release notes"
description: "Release notes for Grafana Mimir version 2.13"
weight: 1100
---

# Grafana Mimir version 2.13 release notes

<!-- vale Grafana.GoogleWill = NO -->
<!-- vale Grafana.Timeless = NO -->
<!-- Release notes are often future focused -->

Grafana Labs is excited to announce version 2.13 of Grafana Mimir.

The highlights that follow include the top features, enhancements, and bug fixes in this release.
For the complete list of changes, refer to the [CHANGELOG](https://github.com/grafana/mimir/blob/main/CHANGELOG.md).

## Features and enhancements

- **Improved CPU performance in processing queries with regular expressions** that contain many alternations (for example `foo|bar|baz|...`).

- **Improved OTLP ingestion performance** by using native translation, which reduces memory usage in the distributor by up to 30% and CPU usage by up to 8%.

- Configurable S3 bucket lookup type improves interoperability with **S3-compatible providers, such as Tencent and Alibaba**. Configure lookup type via `-<prefix>.s3.bucket-lookup-type` or `-common.storage.s3-bucket-lookup-type`.

- **Configuration of TLS for S3 buckets** is now possible via `-<prefix>.s3.http.*` and `-common.storage.s3.http.*` configuration options.

- **Mimirtool can now verify the validity of a Mimir runtime configuration** file with the `mimirtool runtime-config verify` command.

- **Active series are now updated along with owned series.** This means the number of active series for a tenant is more accurate after scaling out ingesters. As a result, ingesters now more precisely enforce tenants' series limits. This feature is only enabled when `-ingester.track-ingester-owned-series` or `-ingester.use-ingester-owned-series-for-limits` are enabled.

- **Store-gateway can be configured to explicitly disable or enable tenants**. This is useful in cases where compaction slows down for a tenant to temporarily exclude another tenant while compaction catches up without affecting other tenants.

- **Remote read (`/prometheus/api/v1/read`) is becoming a first-class endpoint in Mimir** with support in `query stats` logs and query blocking in the query-frontend. More coming in future releases.

Additionally, the following previously experimental features are now considered stable:

- Rules tenant federation via the `source_tenants` field in rule groups.
- Enabling recording, and alerting rules evaluation on a per-tenant basis.
- Limiting the number of tenants a federated query can query.

## Important changes

In Grafana Mimir 2.13 the following behavior has changed:

- The default Docker image `grafana/mimir` is now based on the distroless image `gcr.io/distroless/static-debian12`.
  See [Debugging distroless container images](https://grafana.com/docs/mimir/latest/manage/mimir-runbooks/#debugging-distroless-container-images-in-kubernetes) for more details on how to
  work with distroless images.

- Error logs in the ingester are now sampled at 10% by default. Sampled log lines contain `(sampled 1/10)`. The `cortex_discarded_samples_total` metric still tracks all discarded samples.

- Anonymous usage statistics now include actual CPU usage instead of available CPU cores.

- Continuous-test is no longer a standalone binary and is now part of Mimir as its own target. The published Docker image has been updated to use the new packaging.

The following deprecated configuration options are removed in Grafana Mimir 2.13:

- The configuration option `-log.buffered`, which was deprecated in 2.11 and is now enabled by default.

## Experimental features

Grafana Mimir 2.13 includes new features that are considered experimental and disabled by default.
Use them with caution and report any issues you encounter:

- Experimental support for server-side circuit breakers in ingesters on read and write requests. This can be enabled using `-ingester.push-circuit-breaker.enabled` and `-ingester.read-circuit-breaker.enabled` options and further configured via the `-ingester.push-circuit-breaker.*` and `-ingester.read-circuit-breaker.*` options.

The following configuration options are deprecated and will be removed in a future Grafana Mimir release:

- `evaluation_delay` field in the rule group configuration has been deprecated. Please use `query_offset` instead.

## Bug fixes

- OTLP ingestion: translate all HTTP 5xx errors into one of 502, 503, or 504, so that the otel-collector retries the failed requests.
- OTLP ingestion: return properly formatted protobuf error messages when ingestion fails.
- OTLP ingestion: generate `target_info` metric only when there are metrics in the request and there is at least one configured identifying label.
- OTLP ingestion: don't discard timeseries paired with invalid exemplars. Instead, try to ingest the timeseries and discard only the invalid exemplars.
- Subqueries: `@ end()` and `@ start()` now work correctly with queries split by time.
- Native histograms: order exemplars before ingestion to improve success rate when ingesting multiple exemplars.
- Native histograms: return HTTP 400 on invalid native histogram samples instead of HTTP 500. The metric `cortex_discarded_samples_total{reason="invalid-native-histogram"}` is now incremented on invalid histogram samples.

### Helm chart improvements

The Grafana Mimir and Grafana Enterprise Metrics Helm charts are released independently.
Refer to the [Grafana Mimir Helm chart documentation](/docs/helm-charts/mimir-distributed/latest/).

### v2.13.1

- [BUGFIX] Upgrade Go to 1.22.9 to address [CVE-2024-34156](https://nvd.nist.gov/vuln/detail/CVE-2024-34156). [PR 10097](https://github.com/grafana/mimir/pull/10097)
- [BUGFIX] Update module google.golang.org/grpc to v1.64.1 to address [GHSA-xr7q-jx4m-x55m](https://github.com/advisories/GHSA-xr7q-jx4m-x55m). [PR 8717](https://github.com/grafana/mimir/pull/8717)
