define("tiny_recordrtc/lame.all",["exports"],(function(_exports){function lamejs(){function new_byte(count){return new Int8Array(count)}function new_short(count){return new Int16Array(count)}function new_int(count){return new Int32Array(count)}function new_float(count){return new Float32Array(count)}function new_double(count){return new Float64Array(count)}function new_float_n(args){if(1==args.length)return new_float(args[0]);var sz=args[0];args=args.slice(1);for(var A=[],i=0;i<sz;i++)A.push(new_float_n(args));return A}function new_int_n(args){if(1==args.length)return new_int(args[0]);var sz=args[0];args=args.slice(1);for(var A=[],i=0;i<sz;i++)A.push(new_int_n(args));return A}function new_short_n(args){if(1==args.length)return new_short(args[0]);var sz=args[0];args=args.slice(1);for(var A=[],i=0;i<sz;i++)A.push(new_short_n(args));return A}function new_array_n(args){if(1==args.length)return new Array(args[0]);var sz=args[0];args=args.slice(1);for(var A=[],i=0;i<sz;i++)A.push(new_array_n(args));return A}var Arrays={fill:function(a,fromIndex,toIndex,val){if(2==arguments.length)for(var i=0;i<a.length;i++)a[i]=arguments[1];else for(i=fromIndex;i<toIndex;i++)a[i]=val}},System={arraycopy:function(src,srcPos,dest,destPos,length){for(var srcEnd=srcPos+length;srcPos<srcEnd;)dest[destPos++]=src[srcPos++]}},Util={};function ShortBlock(ordinal){this.ordinal=ordinal}Util.SQRT2=1.4142135623730951,Util.FAST_LOG10=function(x){return Math.log10(x)},Util.FAST_LOG10_X=function(x,y){return Math.log10(x)*y},ShortBlock.short_block_allowed=new ShortBlock(0),ShortBlock.short_block_coupled=new ShortBlock(1),ShortBlock.short_block_dispensed=new ShortBlock(2),ShortBlock.short_block_forced=new ShortBlock(3);var Float={};function VbrMode(ordinal){this.ordinal=ordinal}Float.MAX_VALUE=34028235e31,VbrMode.vbr_off=new VbrMode(0),VbrMode.vbr_mt=new VbrMode(1),VbrMode.vbr_rh=new VbrMode(2),VbrMode.vbr_abr=new VbrMode(3),VbrMode.vbr_mtrh=new VbrMode(4),VbrMode.vbr_default=VbrMode.vbr_mtrh;function MPEGMode(ordinal){var _ordinal=ordinal;this.ordinal=function(){return _ordinal}}function Version(){this.getLameVersion=function(){return"3.98.4"},this.getLameShortVersion=function(){return"3.98.4"},this.getLameVeryShortVersion=function(){return"LAME3.98r"},this.getPsyVersion=function(){return"0.93"},this.getLameUrl=function(){return"http://www.mp3dev.org/"},this.getLameOsBitness=function(){return"32bits"}}function GainAnalysis(){GainAnalysis.YULE_ORDER,GainAnalysis.MAX_SAMP_FREQ;var RMS_WINDOW_TIME_NUMERATOR=GainAnalysis.RMS_WINDOW_TIME_NUMERATOR,RMS_WINDOW_TIME_DENOMINATOR=GainAnalysis.RMS_WINDOW_TIME_DENOMINATOR,ABYule=(GainAnalysis.MAX_SAMPLES_PER_WINDOW,[[.038575994352,-3.84664617118067,-.02160367184185,7.81501653005538,-.00123395316851,-11.34170355132042,-9291677959e-14,13.05504219327545,-.01655260341619,-12.28759895145294,.02161526843274,9.4829380631979,-.02074045215285,-5.87257861775999,.00594298065125,2.75465861874613,.00306428023191,-.86984376593551,.00012025322027,.13919314567432,.00288463683916],[.0541865640643,-3.47845948550071,-.02911007808948,6.36317777566148,-.00848709379851,-8.54751527471874,-.00851165645469,9.4769360780128,-.00834990904936,-8.81498681370155,.02245293253339,6.85401540936998,-.02596338512915,-4.39470996079559,.01624864962975,2.19611684890774,-.00240879051584,-.75104302451432,.00674613682247,.13149317958808,-.00187763777362],[.15457299681924,-2.37898834973084,-.09331049056315,2.84868151156327,-.06247880153653,-2.64577170229825,.02163541888798,2.23697657451713,-.05588393329856,-1.67148153367602,.04781476674921,1.00595954808547,.00222312597743,-.45953458054983,.03174092540049,.16378164858596,-.01390589421898,-.05032077717131,.00651420667831,.0234789740702,-.00881362733839],[.30296907319327,-1.61273165137247,-.22613988682123,1.0797749225997,-.08587323730772,-.2565625775407,.03282930172664,-.1627671912044,-.00915702933434,-.22638893773906,-.02364141202522,.39120800788284,-.00584456039913,-.22138138954925,.06276101321749,.04500235387352,-828086748e-14,.02005851806501,.00205861885564,.00302439095741,-.02950134983287],[.33642304856132,-1.49858979367799,-.2557224142557,.87350271418188,-.11828570177555,.12205022308084,.11921148675203,-.80774944671438,-.07834489609479,.47854794562326,-.0046997791438,-.12453458140019,-.0058950022444,-.04067510197014,.05724228140351,.08333755284107,.00832043980773,-.04237348025746,-.0163538138454,.02977207319925,-.0176017656815],[.4491525660845,-.62820619233671,-.14351757464547,.29661783706366,-.22784394429749,-.372563729424,-.01419140100551,.00213767857124,.04078262797139,-.42029820170918,-.12398163381748,.22199650564824,.04097565135648,.00613424350682,.10478503600251,.06747620744683,-.01863887810927,.05784820375801,-.03193428438915,.03222754072173,.00541907748707],[.56619470757641,-1.04800335126349,-.75464456939302,.29156311971249,.1624213774223,-.26806001042947,.16744243493672,.00819999645858,-.18901604199609,.45054734505008,.3093178284183,-.33032403314006,-.27562961986224,.0673936833311,.00647310677246,-.04784254229033,.08647503780351,.01639907836189,-.0378898455484,.01807364323573,-.00588215443421],[.58100494960553,-.51035327095184,-.53174909058578,-.31863563325245,-.14289799034253,-.20256413484477,.17520704835522,.1472815413433,.02377945217615,.38952639978999,.15558449135573,-.23313271880868,-.25344790059353,-.05246019024463,.01628462406333,-.02505961724053,.06920467763959,.02442357316099,-.03721611395801,.01818801111503,-.00749618797172],[.53648789255105,-.2504987195602,-.42163034350696,-.43193942311114,-.00275953611929,-.03424681017675,.04267842219415,-.04678328784242,-.10214864179676,.26408300200955,.14590772289388,.15113130533216,-.02459864859345,-.17556493366449,-.11202315195388,-.18823009262115,-.04060034127,.05477720428674,.0478866554818,.0470440968812,-.02217936801134]]),ABButter=[[.98621192462708,-1.97223372919527,-1.97242384925416,.97261396931306,.98621192462708],[.98500175787242,-1.96977855582618,-1.97000351574484,.9702284756635,.98500175787242],[.97938932735214,-1.95835380975398,-1.95877865470428,.95920349965459,.97938932735214],[.97531843204928,-1.95002759149878,-1.95063686409857,.95124613669835,.97531843204928],[.97316523498161,-1.94561023566527,-1.94633046996323,.94705070426118,.97316523498161],[.96454515552826,-1.92783286977036,-1.92909031105652,.93034775234268,.96454515552826],[.96009142950541,-1.91858953033784,-1.92018285901082,.92177618768381,.96009142950541],[.95856916599601,-1.9154210807478,-1.91713833199203,.91885558323625,.95856916599601],[.94597685600279,-1.88903307939452,-1.89195371200558,.89487434461664,.94597685600279]];function filterYule(input,inputPos,output,outputPos,nSamples,kernel){for(;0!=nSamples--;)output[outputPos]=1e-10+input[inputPos+0]*kernel[0]-output[outputPos-1]*kernel[1]+input[inputPos-1]*kernel[2]-output[outputPos-2]*kernel[3]+input[inputPos-2]*kernel[4]-output[outputPos-3]*kernel[5]+input[inputPos-3]*kernel[6]-output[outputPos-4]*kernel[7]+input[inputPos-4]*kernel[8]-output[outputPos-5]*kernel[9]+input[inputPos-5]*kernel[10]-output[outputPos-6]*kernel[11]+input[inputPos-6]*kernel[12]-output[outputPos-7]*kernel[13]+input[inputPos-7]*kernel[14]-output[outputPos-8]*kernel[15]+input[inputPos-8]*kernel[16]-output[outputPos-9]*kernel[17]+input[inputPos-9]*kernel[18]-output[outputPos-10]*kernel[19]+input[inputPos-10]*kernel[20],++outputPos,++inputPos}function filterButter(input,inputPos,output,outputPos,nSamples,kernel){for(;0!=nSamples--;)output[outputPos]=input[inputPos+0]*kernel[0]-output[outputPos-1]*kernel[1]+input[inputPos-1]*kernel[2]-output[outputPos-2]*kernel[3]+input[inputPos-2]*kernel[4],++outputPos,++inputPos}function fsqr(d){return d*d}this.InitGainAnalysis=function(rgData,samplefreq){return function(rgData,samplefreq){for(var i=0;i<MAX_ORDER;i++)rgData.linprebuf[i]=rgData.lstepbuf[i]=rgData.loutbuf[i]=rgData.rinprebuf[i]=rgData.rstepbuf[i]=rgData.routbuf[i]=0;switch(0|samplefreq){case 48e3:rgData.reqindex=0;break;case 44100:rgData.reqindex=1;break;case 32e3:rgData.reqindex=2;break;case 24e3:rgData.reqindex=3;break;case 22050:rgData.reqindex=4;break;case 16e3:rgData.reqindex=5;break;case 12e3:rgData.reqindex=6;break;case 11025:rgData.reqindex=7;break;case 8e3:rgData.reqindex=8;break;default:return INIT_GAIN_ANALYSIS_ERROR}return rgData.sampleWindow=0|(samplefreq*RMS_WINDOW_TIME_NUMERATOR+RMS_WINDOW_TIME_DENOMINATOR-1)/RMS_WINDOW_TIME_DENOMINATOR,rgData.lsum=0,rgData.rsum=0,rgData.totsamp=0,Arrays.ill(rgData.A,0),INIT_GAIN_ANALYSIS_OK}(rgData,samplefreq)!=INIT_GAIN_ANALYSIS_OK?INIT_GAIN_ANALYSIS_ERROR:(rgData.linpre=MAX_ORDER,rgData.rinpre=MAX_ORDER,rgData.lstep=MAX_ORDER,rgData.rstep=MAX_ORDER,rgData.lout=MAX_ORDER,rgData.rout=MAX_ORDER,Arrays.fill(rgData.B,0),INIT_GAIN_ANALYSIS_OK)},this.AnalyzeSamples=function(rgData,left_samples,left_samplesPos,right_samples,right_samplesPos,num_samples,num_channels){var curleft,curleftBase,curright,currightBase,batchsamples,cursamples,cursamplepos;if(0==num_samples)return GAIN_ANALYSIS_OK;switch(cursamplepos=0,batchsamples=num_samples,num_channels){case 1:right_samples=left_samples,right_samplesPos=left_samplesPos;break;case 2:break;default:return GAIN_ANALYSIS_ERROR}for(num_samples<MAX_ORDER?(System.arraycopy(left_samples,left_samplesPos,rgData.linprebuf,MAX_ORDER,num_samples),System.arraycopy(right_samples,right_samplesPos,rgData.rinprebuf,MAX_ORDER,num_samples)):(System.arraycopy(left_samples,left_samplesPos,rgData.linprebuf,MAX_ORDER,MAX_ORDER),System.arraycopy(right_samples,right_samplesPos,rgData.rinprebuf,MAX_ORDER,MAX_ORDER));batchsamples>0;){cursamples=batchsamples>rgData.sampleWindow-rgData.totsamp?rgData.sampleWindow-rgData.totsamp:batchsamples,cursamplepos<MAX_ORDER?(curleft=rgData.linpre+cursamplepos,curleftBase=rgData.linprebuf,curright=rgData.rinpre+cursamplepos,currightBase=rgData.rinprebuf,cursamples>MAX_ORDER-cursamplepos&&(cursamples=MAX_ORDER-cursamplepos)):(curleft=left_samplesPos+cursamplepos,curleftBase=left_samples,curright=right_samplesPos+cursamplepos,currightBase=right_samples),filterYule(curleftBase,curleft,rgData.lstepbuf,rgData.lstep+rgData.totsamp,cursamples,ABYule[rgData.reqindex]),filterYule(currightBase,curright,rgData.rstepbuf,rgData.rstep+rgData.totsamp,cursamples,ABYule[rgData.reqindex]),filterButter(rgData.lstepbuf,rgData.lstep+rgData.totsamp,rgData.loutbuf,rgData.lout+rgData.totsamp,cursamples,ABButter[rgData.reqindex]),filterButter(rgData.rstepbuf,rgData.rstep+rgData.totsamp,rgData.routbuf,rgData.rout+rgData.totsamp,cursamples,ABButter[rgData.reqindex]),curleft=rgData.lout+rgData.totsamp,curleftBase=rgData.loutbuf,curright=rgData.rout+rgData.totsamp,currightBase=rgData.routbuf;for(var i=cursamples%8;0!=i--;)rgData.lsum+=fsqr(curleftBase[curleft++]),rgData.rsum+=fsqr(currightBase[curright++]);for(i=cursamples/8;0!=i--;)rgData.lsum+=fsqr(curleftBase[curleft+0])+fsqr(curleftBase[curleft+1])+fsqr(curleftBase[curleft+2])+fsqr(curleftBase[curleft+3])+fsqr(curleftBase[curleft+4])+fsqr(curleftBase[curleft+5])+fsqr(curleftBase[curleft+6])+fsqr(curleftBase[curleft+7]),curleft+=8,rgData.rsum+=fsqr(currightBase[curright+0])+fsqr(currightBase[curright+1])+fsqr(currightBase[curright+2])+fsqr(currightBase[curright+3])+fsqr(currightBase[curright+4])+fsqr(currightBase[curright+5])+fsqr(currightBase[curright+6])+fsqr(currightBase[curright+7]),curright+=8;if(batchsamples-=cursamples,cursamplepos+=cursamples,rgData.totsamp+=cursamples,rgData.totsamp==rgData.sampleWindow){var val=10*GainAnalysis.STEPS_per_dB*Math.log10((rgData.lsum+rgData.rsum)/rgData.totsamp*.5+1e-37),ival=val<=0?0:0|val;ival>=rgData.A.length&&(ival=rgData.A.length-1),rgData.A[ival]++,rgData.lsum=rgData.rsum=0,System.arraycopy(rgData.loutbuf,rgData.totsamp,rgData.loutbuf,0,MAX_ORDER),System.arraycopy(rgData.routbuf,rgData.totsamp,rgData.routbuf,0,MAX_ORDER),System.arraycopy(rgData.lstepbuf,rgData.totsamp,rgData.lstepbuf,0,MAX_ORDER),System.arraycopy(rgData.rstepbuf,rgData.totsamp,rgData.rstepbuf,0,MAX_ORDER),rgData.totsamp=0}if(rgData.totsamp>rgData.sampleWindow)return GAIN_ANALYSIS_ERROR}return num_samples<MAX_ORDER?(System.arraycopy(rgData.linprebuf,num_samples,rgData.linprebuf,0,MAX_ORDER-num_samples),System.arraycopy(rgData.rinprebuf,num_samples,rgData.rinprebuf,0,MAX_ORDER-num_samples),System.arraycopy(left_samples,left_samplesPos,rgData.linprebuf,MAX_ORDER-num_samples,num_samples),System.arraycopy(right_samples,right_samplesPos,rgData.rinprebuf,MAX_ORDER-num_samples,num_samples)):(System.arraycopy(left_samples,left_samplesPos+num_samples-MAX_ORDER,rgData.linprebuf,0,MAX_ORDER),System.arraycopy(right_samples,right_samplesPos+num_samples-MAX_ORDER,rgData.rinprebuf,0,MAX_ORDER)),GAIN_ANALYSIS_OK},this.GetTitleGain=function(rgData){for(var retval=function(Array,len){var i,elems=0;for(i=0;i<len;i++)elems+=Array[i];if(0==elems)return GAIN_NOT_ENOUGH_SAMPLES;var upper=0|Math.ceil(elems*(1-.95));for(i=len;i-- >0&&!((upper-=Array[i])<=0););return 64.82-i/GainAnalysis.STEPS_per_dB}(rgData.A,rgData.A.length),i=0;i<rgData.A.length;i++)rgData.B[i]+=rgData.A[i],rgData.A[i]=0;for(i=0;i<MAX_ORDER;i++)rgData.linprebuf[i]=rgData.lstepbuf[i]=rgData.loutbuf[i]=rgData.rinprebuf[i]=rgData.rstepbuf[i]=rgData.routbuf[i]=0;return rgData.totsamp=0,rgData.lsum=rgData.rsum=0,retval}}function Presets(){function VBRPresets(qual,comp,compS,y,shThreshold,shThresholdS,adj,adjShort,lower,curve,sens,inter,joint,mod,fix){this.vbr_q=qual,this.quant_comp=comp,this.quant_comp_s=compS,this.expY=y,this.st_lrm=shThreshold,this.st_s=shThresholdS,this.masking_adj=adj,this.masking_adj_short=adjShort,this.ath_lower=lower,this.ath_curve=curve,this.ath_sensitivity=sens,this.interch=inter,this.safejoint=joint,this.sfb21mod=mod,this.msfix=fix}function ABRPresets(kbps,comp,compS,joint,fix,shThreshold,shThresholdS,bass,sc,mask,lower,curve,interCh,sfScale){this.quant_comp=comp,this.quant_comp_s=compS,this.safejoint=joint,this.nsmsfix=fix,this.st_lrm=shThreshold,this.st_s=shThresholdS,this.nsbass=bass,this.scale=sc,this.masking_adj=mask,this.ath_lower=lower,this.ath_curve=curve,this.interch=interCh,this.sfscale=sfScale}var lame;this.setModules=function(_lame){lame=_lame};var vbr_old_switch_map=[new VBRPresets(0,9,9,0,5.2,125,-4.2,-6.3,4.8,1,0,0,2,21,.97),new VBRPresets(1,9,9,0,5.3,125,-3.6,-5.6,4.5,1.5,0,0,2,21,1.35),new VBRPresets(2,9,9,0,5.6,125,-2.2,-3.5,2.8,2,0,0,2,21,1.49),new VBRPresets(3,9,9,1,5.8,130,-1.8,-2.8,2.6,3,-4,0,2,20,1.64),new VBRPresets(4,9,9,1,6,135,-.7,-1.1,1.1,3.5,-8,0,2,0,1.79),new VBRPresets(5,9,9,1,6.4,140,.5,.4,-7.5,4,-12,2e-4,0,0,1.95),new VBRPresets(6,9,9,1,6.6,145,.67,.65,-14.7,6.5,-19,4e-4,0,0,2.3),new VBRPresets(7,9,9,1,6.6,145,.8,.75,-19.7,8,-22,6e-4,0,0,2.7),new VBRPresets(8,9,9,1,6.6,145,1.2,1.15,-27.5,10,-23,7e-4,0,0,0),new VBRPresets(9,9,9,1,6.6,145,1.6,1.6,-36,11,-25,8e-4,0,0,0),new VBRPresets(10,9,9,1,6.6,145,2,2,-36,12,-25,8e-4,0,0,0)],vbr_psy_switch_map=[new VBRPresets(0,9,9,0,4.2,25,-7,-4,7.5,1,0,0,2,26,.97),new VBRPresets(1,9,9,0,4.2,25,-5.6,-3.6,4.5,1.5,0,0,2,21,1.35),new VBRPresets(2,9,9,0,4.2,25,-4.4,-1.8,2,2,0,0,2,18,1.49),new VBRPresets(3,9,9,1,4.2,25,-3.4,-1.25,1.1,3,-4,0,2,15,1.64),new VBRPresets(4,9,9,1,4.2,25,-2.2,.1,0,3.5,-8,0,2,0,1.79),new VBRPresets(5,9,9,1,4.2,25,-1,1.65,-7.7,4,-12,2e-4,0,0,1.95),new VBRPresets(6,9,9,1,4.2,25,-0,2.47,-7.7,6.5,-19,4e-4,0,0,2),new VBRPresets(7,9,9,1,4.2,25,.5,2,-14.5,8,-22,6e-4,0,0,2),new VBRPresets(8,9,9,1,4.2,25,1,2.4,-22,10,-23,7e-4,0,0,2),new VBRPresets(9,9,9,1,4.2,25,1.5,2.95,-30,11,-25,8e-4,0,0,2),new VBRPresets(10,9,9,1,4.2,25,2,2.95,-36,12,-30,8e-4,0,0,2)];function apply_vbr_preset(gfp,a,enforce){var vbr_preset=gfp.VBR==VbrMode.vbr_rh?vbr_old_switch_map:vbr_psy_switch_map,x=gfp.VBR_q_frac,p=vbr_preset[a],q=vbr_preset[a+1],set=p;p.st_lrm=p.st_lrm+x*(q.st_lrm-p.st_lrm),p.st_s=p.st_s+x*(q.st_s-p.st_s),p.masking_adj=p.masking_adj+x*(q.masking_adj-p.masking_adj),p.masking_adj_short=p.masking_adj_short+x*(q.masking_adj_short-p.masking_adj_short),p.ath_lower=p.ath_lower+x*(q.ath_lower-p.ath_lower),p.ath_curve=p.ath_curve+x*(q.ath_curve-p.ath_curve),p.ath_sensitivity=p.ath_sensitivity+x*(q.ath_sensitivity-p.ath_sensitivity),p.interch=p.interch+x*(q.interch-p.interch),p.msfix=p.msfix+x*(q.msfix-p.msfix),function(gfp,VBR_q){var ret=0;0>VBR_q&&(ret=-1,VBR_q=0);9<VBR_q&&(ret=-1,VBR_q=9);gfp.VBR_q=VBR_q,gfp.VBR_q_frac=0}(gfp,set.vbr_q),0!=enforce?gfp.quant_comp=set.quant_comp:Math.abs(gfp.quant_comp- -1)>0||(gfp.quant_comp=set.quant_comp),0!=enforce?gfp.quant_comp_short=set.quant_comp_s:Math.abs(gfp.quant_comp_short- -1)>0||(gfp.quant_comp_short=set.quant_comp_s),0!=set.expY&&(gfp.experimentalY=0!=set.expY),0!=enforce?gfp.internal_flags.nsPsy.attackthre=set.st_lrm:Math.abs(gfp.internal_flags.nsPsy.attackthre- -1)>0||(gfp.internal_flags.nsPsy.attackthre=set.st_lrm),0!=enforce?gfp.internal_flags.nsPsy.attackthre_s=set.st_s:Math.abs(gfp.internal_flags.nsPsy.attackthre_s- -1)>0||(gfp.internal_flags.nsPsy.attackthre_s=set.st_s),0!=enforce?gfp.maskingadjust=set.masking_adj:Math.abs(gfp.maskingadjust-0)>0||(gfp.maskingadjust=set.masking_adj),0!=enforce?gfp.maskingadjust_short=set.masking_adj_short:Math.abs(gfp.maskingadjust_short-0)>0||(gfp.maskingadjust_short=set.masking_adj_short),0!=enforce?gfp.ATHlower=-set.ath_lower/10:Math.abs(10*-gfp.ATHlower-0)>0||(gfp.ATHlower=-set.ath_lower/10),0!=enforce?gfp.ATHcurve=set.ath_curve:Math.abs(gfp.ATHcurve- -1)>0||(gfp.ATHcurve=set.ath_curve),0!=enforce?gfp.athaa_sensitivity=set.ath_sensitivity:Math.abs(gfp.athaa_sensitivity- -1)>0||(gfp.athaa_sensitivity=set.ath_sensitivity),set.interch>0&&(0!=enforce?gfp.interChRatio=set.interch:Math.abs(gfp.interChRatio- -1)>0||(gfp.interChRatio=set.interch)),set.safejoint>0&&(gfp.exp_nspsytune=gfp.exp_nspsytune|set.safejoint),set.sfb21mod>0&&(gfp.exp_nspsytune=gfp.exp_nspsytune|set.sfb21mod<<20),0!=enforce?gfp.msfix=set.msfix:Math.abs(gfp.msfix- -1)>0||(gfp.msfix=set.msfix),0==enforce&&(gfp.VBR_q=a,gfp.VBR_q_frac=x)}var abr_switch_map=[new ABRPresets(8,9,9,0,0,6.6,145,0,.95,0,-30,11,.0012,1),new ABRPresets(16,9,9,0,0,6.6,145,0,.95,0,-25,11,.001,1),new ABRPresets(24,9,9,0,0,6.6,145,0,.95,0,-20,11,.001,1),new ABRPresets(32,9,9,0,0,6.6,145,0,.95,0,-15,11,.001,1),new ABRPresets(40,9,9,0,0,6.6,145,0,.95,0,-10,11,9e-4,1),new ABRPresets(48,9,9,0,0,6.6,145,0,.95,0,-10,11,9e-4,1),new ABRPresets(56,9,9,0,0,6.6,145,0,.95,0,-6,11,8e-4,1),new ABRPresets(64,9,9,0,0,6.6,145,0,.95,0,-2,11,8e-4,1),new ABRPresets(80,9,9,0,0,6.6,145,0,.95,0,0,8,7e-4,1),new ABRPresets(96,9,9,0,2.5,6.6,145,0,.95,0,1,5.5,6e-4,1),new ABRPresets(112,9,9,0,2.25,6.6,145,0,.95,0,2,4.5,5e-4,1),new ABRPresets(128,9,9,0,1.95,6.4,140,0,.95,0,3,4,2e-4,1),new ABRPresets(160,9,9,1,1.79,6,135,0,.95,-2,5,3.5,0,1),new ABRPresets(192,9,9,1,1.49,5.6,125,0,.97,-4,7,3,0,0),new ABRPresets(224,9,9,1,1.25,5.2,125,0,.98,-6,9,2,0,0),new ABRPresets(256,9,9,1,.97,5.2,125,0,1,-8,10,1,0,0),new ABRPresets(320,9,9,1,.9,5.2,125,0,1,-10,12,0,0,0)];function apply_abr_preset(gfp,preset,enforce){var actual_bitrate=preset,r=lame.nearestBitrateFullIndex(preset);if(gfp.VBR=VbrMode.vbr_abr,gfp.VBR_mean_bitrate_kbps=actual_bitrate,gfp.VBR_mean_bitrate_kbps=Math.min(gfp.VBR_mean_bitrate_kbps,320),gfp.VBR_mean_bitrate_kbps=Math.max(gfp.VBR_mean_bitrate_kbps,8),gfp.brate=gfp.VBR_mean_bitrate_kbps,gfp.VBR_mean_bitrate_kbps>320&&(gfp.disable_reservoir=!0),abr_switch_map[r].safejoint>0&&(gfp.exp_nspsytune=2|gfp.exp_nspsytune),abr_switch_map[r].sfscale>0&&(gfp.internal_flags.noise_shaping=2),Math.abs(abr_switch_map[r].nsbass)>0){var k=int(4*abr_switch_map[r].nsbass);k<0&&(k+=64),gfp.exp_nspsytune=gfp.exp_nspsytune|k<<2}return 0!=enforce?gfp.quant_comp=abr_switch_map[r].quant_comp:Math.abs(gfp.quant_comp- -1)>0||(gfp.quant_comp=abr_switch_map[r].quant_comp),0!=enforce?gfp.quant_comp_short=abr_switch_map[r].quant_comp_s:Math.abs(gfp.quant_comp_short- -1)>0||(gfp.quant_comp_short=abr_switch_map[r].quant_comp_s),0!=enforce?gfp.msfix=abr_switch_map[r].nsmsfix:Math.abs(gfp.msfix- -1)>0||(gfp.msfix=abr_switch_map[r].nsmsfix),0!=enforce?gfp.internal_flags.nsPsy.attackthre=abr_switch_map[r].st_lrm:Math.abs(gfp.internal_flags.nsPsy.attackthre- -1)>0||(gfp.internal_flags.nsPsy.attackthre=abr_switch_map[r].st_lrm),0!=enforce?gfp.internal_flags.nsPsy.attackthre_s=abr_switch_map[r].st_s:Math.abs(gfp.internal_flags.nsPsy.attackthre_s- -1)>0||(gfp.internal_flags.nsPsy.attackthre_s=abr_switch_map[r].st_s),0!=enforce?gfp.scale=abr_switch_map[r].scale:Math.abs(gfp.scale- -1)>0||(gfp.scale=abr_switch_map[r].scale),0!=enforce?gfp.maskingadjust=abr_switch_map[r].masking_adj:Math.abs(gfp.maskingadjust-0)>0||(gfp.maskingadjust=abr_switch_map[r].masking_adj),abr_switch_map[r].masking_adj>0?0!=enforce?gfp.maskingadjust_short=.9*abr_switch_map[r].masking_adj:Math.abs(gfp.maskingadjust_short-0)>0||(gfp.maskingadjust_short=.9*abr_switch_map[r].masking_adj):0!=enforce?gfp.maskingadjust_short=1.1*abr_switch_map[r].masking_adj:Math.abs(gfp.maskingadjust_short-0)>0||(gfp.maskingadjust_short=1.1*abr_switch_map[r].masking_adj),0!=enforce?gfp.ATHlower=-abr_switch_map[r].ath_lower/10:Math.abs(10*-gfp.ATHlower-0)>0||(gfp.ATHlower=-abr_switch_map[r].ath_lower/10),0!=enforce?gfp.ATHcurve=abr_switch_map[r].ath_curve:Math.abs(gfp.ATHcurve- -1)>0||(gfp.ATHcurve=abr_switch_map[r].ath_curve),0!=enforce?gfp.interChRatio=abr_switch_map[r].interch:Math.abs(gfp.interChRatio- -1)>0||(gfp.interChRatio=abr_switch_map[r].interch),preset}this.apply_preset=function(gfp,preset,enforce){switch(preset){case Lame.R3MIX:preset=Lame.V3,gfp.VBR=VbrMode.vbr_mtrh;break;case Lame.MEDIUM:preset=Lame.V4,gfp.VBR=VbrMode.vbr_rh;break;case Lame.MEDIUM_FAST:preset=Lame.V4,gfp.VBR=VbrMode.vbr_mtrh;break;case Lame.STANDARD:preset=Lame.V2,gfp.VBR=VbrMode.vbr_rh;break;case Lame.STANDARD_FAST:preset=Lame.V2,gfp.VBR=VbrMode.vbr_mtrh;break;case Lame.EXTREME:preset=Lame.V0,gfp.VBR=VbrMode.vbr_rh;break;case Lame.EXTREME_FAST:preset=Lame.V0,gfp.VBR=VbrMode.vbr_mtrh;break;case Lame.INSANE:return preset=320,gfp.preset=preset,apply_abr_preset(gfp,preset,enforce),gfp.VBR=VbrMode.vbr_off,preset}switch(gfp.preset=preset,preset){case Lame.V9:return apply_vbr_preset(gfp,9,enforce),preset;case Lame.V8:return apply_vbr_preset(gfp,8,enforce),preset;case Lame.V7:return apply_vbr_preset(gfp,7,enforce),preset;case Lame.V6:return apply_vbr_preset(gfp,6,enforce),preset;case Lame.V5:return apply_vbr_preset(gfp,5,enforce),preset;case Lame.V4:return apply_vbr_preset(gfp,4,enforce),preset;case Lame.V3:return apply_vbr_preset(gfp,3,enforce),preset;case Lame.V2:return apply_vbr_preset(gfp,2,enforce),preset;case Lame.V1:return apply_vbr_preset(gfp,1,enforce),preset;case Lame.V0:return apply_vbr_preset(gfp,0,enforce),preset}return 8<=preset&&preset<=320?apply_abr_preset(gfp,preset,enforce):(gfp.preset=0,preset)}}function Takehiro(){var qupvt=null;function Bits(b){this.bits=0|b}this.qupvt=null,this.setModules=function(_qupvt){this.qupvt=_qupvt,qupvt=_qupvt};var subdv_table=[[0,0],[0,0],[0,0],[0,0],[0,0],[0,1],[1,1],[1,1],[1,2],[2,2],[2,3],[2,3],[3,4],[3,4],[3,4],[4,5],[4,5],[4,6],[5,6],[5,6],[5,7],[6,7],[6,7]];function quantize_lines_xrpow_01(l,istep,xr,xrPos,ix,ixPos){var compareval0=.5946/istep;for(l>>=1;0!=l--;)ix[ixPos++]=compareval0>xr[xrPos++]?0:1,ix[ixPos++]=compareval0>xr[xrPos++]?0:1}function quantize_lines_xrpow(l,istep,xr,xrPos,ix,ixPos){var remaining=(l>>=1)%2;for(l>>=1;0!=l--;){var x0,x1,x2,x3,rx0,rx1,rx2,rx3;x0=xr[xrPos++]*istep,x1=xr[xrPos++]*istep,rx0=0|x0,x2=xr[xrPos++]*istep,rx1=0|x1,x3=xr[xrPos++]*istep,rx2=0|x2,x0+=qupvt.adj43[rx0],rx3=0|x3,x1+=qupvt.adj43[rx1],ix[ixPos++]=0|x0,x2+=qupvt.adj43[rx2],ix[ixPos++]=0|x1,x3+=qupvt.adj43[rx3],ix[ixPos++]=0|x2,ix[ixPos++]=0|x3}0!=remaining&&(rx0=0|(x0=xr[xrPos++]*istep),rx1=0|(x1=xr[xrPos++]*istep),x0+=qupvt.adj43[rx0],x1+=qupvt.adj43[rx1],ix[ixPos++]=0|x0,ix[ixPos++]=0|x1)}var huf_tbl_noESC=[1,2,5,7,7,10,10,13,13,13,13,13,13,13,13];function choose_table(ix,ixPos,endPos,s){var max=function(ix,ixPos,endPos){var max1=0,max2=0;do{var x1=ix[ixPos++],x2=ix[ixPos++];max1<x1&&(max1=x1),max2<x2&&(max2=x2)}while(ixPos<endPos);return max1<max2&&(max1=max2),max1}(ix,ixPos,endPos);switch(max){case 0:return max;case 1:return function(ix,ixPos,end,s){var sum1=0,hlen1=Tables.ht[1].hlen;do{var x=2*ix[ixPos+0]+ix[ixPos+1];ixPos+=2,sum1+=hlen1[x]}while(ixPos<end);return s.bits+=sum1,1}(ix,ixPos,endPos,s);case 2:case 3:return function(ix,ixPos,end,t1,s){var sum2,hlen,sum=0,xlen=Tables.ht[t1].xlen;hlen=2==t1?Tables.table23:Tables.table56;do{var x=ix[ixPos+0]*xlen+ix[ixPos+1];ixPos+=2,sum+=hlen[x]}while(ixPos<end);return sum2=65535&sum,(sum>>=16)>sum2&&(sum=sum2,t1++),s.bits+=sum,t1}(ix,ixPos,endPos,huf_tbl_noESC[max-1],s);case 4:case 5:case 6:case 7:case 8:case 9:case 10:case 11:case 12:case 13:case 14:case 15:return function(ix,ixPos,end,t1,s){var sum1=0,sum2=0,sum3=0,xlen=Tables.ht[t1].xlen,hlen1=Tables.ht[t1].hlen,hlen2=Tables.ht[t1+1].hlen,hlen3=Tables.ht[t1+2].hlen;do{var x=ix[ixPos+0]*xlen+ix[ixPos+1];ixPos+=2,sum1+=hlen1[x],sum2+=hlen2[x],sum3+=hlen3[x]}while(ixPos<end);var t=t1;return sum1>sum2&&(sum1=sum2,t++),sum1>sum3&&(sum1=sum3,t=t1+2),s.bits+=sum1,t}(ix,ixPos,endPos,huf_tbl_noESC[max-1],s);default:if(max>QuantizePVT.IXMAX_VAL)return s.bits=QuantizePVT.LARGE_BITS,-1;var choice2,choice;for(max-=15,choice2=24;choice2<32&&!(Tables.ht[choice2].linmax>=max);choice2++);for(choice=choice2-8;choice<24&&!(Tables.ht[choice].linmax>=max);choice++);return function(ix,ixPos,end,t1,t2,s){var sum2,linbits=65536*Tables.ht[t1].xlen+Tables.ht[t2].xlen,sum=0;do{var x=ix[ixPos++],y=ix[ixPos++];0!=x&&(x>14&&(x=15,sum+=linbits),x*=16),0!=y&&(y>14&&(y=15,sum+=linbits),x+=y),sum+=Tables.largetbl[x]}while(ixPos<end);return sum2=65535&sum,(sum>>=16)>sum2&&(sum=sum2,t1=t2),s.bits+=sum,t1}(ix,ixPos,endPos,choice,choice2,s)}}function recalc_divide_sub(gfc,cod_info2,gi,ix,r01_bits,r01_div,r0_tbl,r1_tbl){for(var bigv=cod_info2.big_values,r2=2;r2<Encoder.SBMAX_l+1;r2++){var a2=gfc.scalefac_band.l[r2];if(a2>=bigv)break;var bits=r01_bits[r2-2]+cod_info2.count1bits;if(gi.part2_3_length<=bits)break;var bi=new Bits(bits),r2t=choose_table(ix,a2,bigv,bi);bits=bi.bits,gi.part2_3_length<=bits||(gi.assign(cod_info2),gi.part2_3_length=bits,gi.region0_count=r01_div[r2-2],gi.region1_count=r2-2-r01_div[r2-2],gi.table_select[0]=r0_tbl[r2-2],gi.table_select[1]=r1_tbl[r2-2],gi.table_select[2]=r2t)}}this.noquant_count_bits=function(gfc,gi,prev_noise){var ix=gi.l3_enc,i=Math.min(576,gi.max_nonzero_coeff+2>>1<<1);for(null!=prev_noise&&(prev_noise.sfb_count1=0);i>1&&0==(ix[i-1]|ix[i-2]);i-=2);gi.count1=i;for(var a1=0,a2=0;i>3;i-=4){var p;if((2147483647&(ix[i-1]|ix[i-2]|ix[i-3]|ix[i-4]))>1)break;p=2*(2*(2*ix[i-4]+ix[i-3])+ix[i-2])+ix[i-1],a1+=Tables.t32l[p],a2+=Tables.t33l[p]}var bits=a1;if(gi.count1table_select=0,a1>a2&&(bits=a2,gi.count1table_select=1),gi.count1bits=bits,gi.big_values=i,0==i)return bits;if(gi.block_type==Encoder.SHORT_TYPE)(a1=3*gfc.scalefac_band.s[3])>gi.big_values&&(a1=gi.big_values),a2=gi.big_values;else if(gi.block_type==Encoder.NORM_TYPE){if(a1=gi.region0_count=gfc.bv_scf[i-2],a2=gi.region1_count=gfc.bv_scf[i-1],a2=gfc.scalefac_band.l[a1+a2+2],a1=gfc.scalefac_band.l[a1+1],a2<i){var bi=new Bits(bits);gi.table_select[2]=choose_table(ix,a2,i,bi),bits=bi.bits}}else gi.region0_count=7,gi.region1_count=Encoder.SBMAX_l-1-7-1,(a1=gfc.scalefac_band.l[8])>(a2=i)&&(a1=a2);if(a1=Math.min(a1,i),a2=Math.min(a2,i),0<a1){bi=new Bits(bits);gi.table_select[0]=choose_table(ix,0,a1,bi),bits=bi.bits}if(a1<a2){bi=new Bits(bits);gi.table_select[1]=choose_table(ix,a1,a2,bi),bits=bi.bits}if(2==gfc.use_best_huffman&&(gi.part2_3_length=bits,best_huffman_divide(gfc,gi),bits=gi.part2_3_length),null!=prev_noise&&gi.block_type==Encoder.NORM_TYPE){for(var sfb=0;gfc.scalefac_band.l[sfb]<gi.big_values;)sfb++;prev_noise.sfb_count1=sfb}return bits},this.count_bits=function(gfc,xr,gi,prev_noise){var ix=gi.l3_enc,w=QuantizePVT.IXMAX_VAL/qupvt.IPOW20(gi.global_gain);if(gi.xrpow_max>w)return QuantizePVT.LARGE_BITS;if(function(xp,pi,istep,codInfo,prevNoise){var sfb,sfbmax,prev_data_use,j=0,accumulate=0,accumulate01=0,xpPos=0,iData=pi,iDataPos=0,acc_iData=iData,acc_iDataPos=0,acc_xp=xp,acc_xpPos=0;for(prev_data_use=null!=prevNoise&&codInfo.global_gain==prevNoise.global_gain,sfbmax=codInfo.block_type==Encoder.SHORT_TYPE?38:21,sfb=0;sfb<=sfbmax;sfb++){var step=-1;if((prev_data_use||codInfo.block_type==Encoder.NORM_TYPE)&&(step=codInfo.global_gain-(codInfo.scalefac[sfb]+(0!=codInfo.preflag?qupvt.pretab[sfb]:0)<<codInfo.scalefac_scale+1)-8*codInfo.subblock_gain[codInfo.window[sfb]]),prev_data_use&&prevNoise.step[sfb]==step)0!=accumulate&&(quantize_lines_xrpow(accumulate,istep,acc_xp,acc_xpPos,acc_iData,acc_iDataPos),accumulate=0),0!=accumulate01&&(quantize_lines_xrpow_01(accumulate01,istep,acc_xp,acc_xpPos,acc_iData,acc_iDataPos),accumulate01=0);else{var usefullsize,l=codInfo.width[sfb];if(j+codInfo.width[sfb]>codInfo.max_nonzero_coeff&&(usefullsize=codInfo.max_nonzero_coeff-j+1,Arrays.fill(pi,codInfo.max_nonzero_coeff,576,0),(l=usefullsize)<0&&(l=0),sfb=sfbmax+1),0==accumulate&&0==accumulate01&&(acc_iData=iData,acc_iDataPos=iDataPos,acc_xp=xp,acc_xpPos=xpPos),null!=prevNoise&&prevNoise.sfb_count1>0&&sfb>=prevNoise.sfb_count1&&prevNoise.step[sfb]>0&&step>=prevNoise.step[sfb]?(0!=accumulate&&(quantize_lines_xrpow(accumulate,istep,acc_xp,acc_xpPos,acc_iData,acc_iDataPos),accumulate=0,acc_iData=iData,acc_iDataPos=iDataPos,acc_xp=xp,acc_xpPos=xpPos),accumulate01+=l):(0!=accumulate01&&(quantize_lines_xrpow_01(accumulate01,istep,acc_xp,acc_xpPos,acc_iData,acc_iDataPos),accumulate01=0,acc_iData=iData,acc_iDataPos=iDataPos,acc_xp=xp,acc_xpPos=xpPos),accumulate+=l),l<=0){0!=accumulate01&&(quantize_lines_xrpow_01(accumulate01,istep,acc_xp,acc_xpPos,acc_iData,acc_iDataPos),accumulate01=0),0!=accumulate&&(quantize_lines_xrpow(accumulate,istep,acc_xp,acc_xpPos,acc_iData,acc_iDataPos),accumulate=0);break}}sfb<=sfbmax&&(iDataPos+=codInfo.width[sfb],xpPos+=codInfo.width[sfb],j+=codInfo.width[sfb])}0!=accumulate&&(quantize_lines_xrpow(accumulate,istep,acc_xp,acc_xpPos,acc_iData,acc_iDataPos),accumulate=0),0!=accumulate01&&(quantize_lines_xrpow_01(accumulate01,istep,acc_xp,acc_xpPos,acc_iData,acc_iDataPos),accumulate01=0)}(xr,ix,qupvt.IPOW20(gi.global_gain),gi,prev_noise),0!=(2&gfc.substep_shaping))for(var j=0,gain=gi.global_gain+gi.scalefac_scale,roundfac=.634521682242439/qupvt.IPOW20(gain),sfb=0;sfb<gi.sfbmax;sfb++){var k,width=gi.width[sfb];if(0==gfc.pseudohalf[sfb])j+=width;else for(k=j,j+=width;k<j;++k)ix[k]=xr[k]>=roundfac?ix[k]:0}return this.noquant_count_bits(gfc,gi,prev_noise)},this.best_huffman_divide=function(gfc,gi){var cod_info2=new GrInfo,ix=gi.l3_enc,r01_bits=new_int(23),r01_div=new_int(23),r0_tbl=new_int(23),r1_tbl=new_int(23);if(gi.block_type!=Encoder.SHORT_TYPE||1!=gfc.mode_gr){cod_info2.assign(gi),gi.block_type==Encoder.NORM_TYPE&&(!function(gfc,cod_info,ix,r01_bits,r01_div,r0_tbl,r1_tbl){for(var bigv=cod_info.big_values,r0=0;r0<=22;r0++)r01_bits[r0]=QuantizePVT.LARGE_BITS;for(r0=0;r0<16;r0++){var a1=gfc.scalefac_band.l[r0+1];if(a1>=bigv)break;var r0bits=0,bi=new Bits(r0bits),r0t=choose_table(ix,0,a1,bi);r0bits=bi.bits;for(var r1=0;r1<8;r1++){var a2=gfc.scalefac_band.l[r0+r1+2];if(a2>=bigv)break;var bits=r0bits,r1t=choose_table(ix,a1,a2,bi=new Bits(bits));bits=bi.bits,r01_bits[r0+r1]>bits&&(r01_bits[r0+r1]=bits,r01_div[r0+r1]=r0,r0_tbl[r0+r1]=r0t,r1_tbl[r0+r1]=r1t)}}}(gfc,gi,ix,r01_bits,r01_div,r0_tbl,r1_tbl),recalc_divide_sub(gfc,cod_info2,gi,ix,r01_bits,r01_div,r0_tbl,r1_tbl));var i=cod_info2.big_values;if(!(0==i||(ix[i-2]|ix[i-1])>1||(i=gi.count1+2)>576)){cod_info2.assign(gi),cod_info2.count1=i;for(var a1=0,a2=0;i>cod_info2.big_values;i-=4){var p=2*(2*(2*ix[i-4]+ix[i-3])+ix[i-2])+ix[i-1];a1+=Tables.t32l[p],a2+=Tables.t33l[p]}if(cod_info2.big_values=i,cod_info2.count1table_select=0,a1>a2&&(a1=a2,cod_info2.count1table_select=1),cod_info2.count1bits=a1,cod_info2.block_type==Encoder.NORM_TYPE)recalc_divide_sub(gfc,cod_info2,gi,ix,r01_bits,r01_div,r0_tbl,r1_tbl);else{if(cod_info2.part2_3_length=a1,(a1=gfc.scalefac_band.l[8])>i&&(a1=i),a1>0){var bi=new Bits(cod_info2.part2_3_length);cod_info2.table_select[0]=choose_table(ix,0,a1,bi),cod_info2.part2_3_length=bi.bits}if(i>a1){bi=new Bits(cod_info2.part2_3_length);cod_info2.table_select[1]=choose_table(ix,a1,i,bi),cod_info2.part2_3_length=bi.bits}gi.part2_3_length>cod_info2.part2_3_length&&gi.assign(cod_info2)}}}};var slen1_n=[1,1,1,1,8,2,2,2,4,4,4,8,8,8,16,16],slen2_n=[1,2,4,8,1,2,4,8,2,4,8,2,4,8,4,8],slen1_tab=[0,0,0,0,3,1,1,1,2,2,2,3,3,3,4,4],slen2_tab=[0,1,2,3,0,1,2,3,1,2,3,1,2,3,2,3];Takehiro.slen1_tab=slen1_tab,Takehiro.slen2_tab=slen2_tab,this.best_scalefac_store=function(gfc,gr,ch,l3_side){var sfb,i,j,l,gi=l3_side.tt[gr][ch],recalc=0;for(j=0,sfb=0;sfb<gi.sfbmax;sfb++){var width=gi.width[sfb];for(j+=width,l=-width;l<0&&0==gi.l3_enc[l+j];l++);0==l&&(gi.scalefac[sfb]=recalc=-2)}if(0==gi.scalefac_scale&&0==gi.preflag){var s=0;for(sfb=0;sfb<gi.sfbmax;sfb++)gi.scalefac[sfb]>0&&(s|=gi.scalefac[sfb]);if(0==(1&s)&&0!=s){for(sfb=0;sfb<gi.sfbmax;sfb++)gi.scalefac[sfb]>0&&(gi.scalefac[sfb]>>=1);gi.scalefac_scale=recalc=1}}if(0==gi.preflag&&gi.block_type!=Encoder.SHORT_TYPE&&2==gfc.mode_gr){for(sfb=11;sfb<Encoder.SBPSY_l&&!(gi.scalefac[sfb]<qupvt.pretab[sfb]&&-2!=gi.scalefac[sfb]);sfb++);if(sfb==Encoder.SBPSY_l){for(sfb=11;sfb<Encoder.SBPSY_l;sfb++)gi.scalefac[sfb]>0&&(gi.scalefac[sfb]-=qupvt.pretab[sfb]);gi.preflag=recalc=1}}for(i=0;i<4;i++)l3_side.scfsi[ch][i]=0;for(2==gfc.mode_gr&&1==gr&&l3_side.tt[0][ch].block_type!=Encoder.SHORT_TYPE&&l3_side.tt[1][ch].block_type!=Encoder.SHORT_TYPE&&(!function(ch,l3_side){for(var sfb,gi=l3_side.tt[1][ch],g0=l3_side.tt[0][ch],i=0;i<Tables.scfsi_band.length-1;i++){for(sfb=Tables.scfsi_band[i];sfb<Tables.scfsi_band[i+1]&&!(g0.scalefac[sfb]!=gi.scalefac[sfb]&&gi.scalefac[sfb]>=0);sfb++);if(sfb==Tables.scfsi_band[i+1]){for(sfb=Tables.scfsi_band[i];sfb<Tables.scfsi_band[i+1];sfb++)gi.scalefac[sfb]=-1;l3_side.scfsi[ch][i]=1}}var s1=0,c1=0;for(sfb=0;sfb<11;sfb++)-1!=gi.scalefac[sfb]&&(c1++,s1<gi.scalefac[sfb]&&(s1=gi.scalefac[sfb]));for(var s2=0,c2=0;sfb<Encoder.SBPSY_l;sfb++)-1!=gi.scalefac[sfb]&&(c2++,s2<gi.scalefac[sfb]&&(s2=gi.scalefac[sfb]));for(i=0;i<16;i++)if(s1<slen1_n[i]&&s2<slen2_n[i]){var c=slen1_tab[i]*c1+slen2_tab[i]*c2;gi.part2_length>c&&(gi.part2_length=c,gi.scalefac_compress=i)}}(ch,l3_side),recalc=0),sfb=0;sfb<gi.sfbmax;sfb++)-2==gi.scalefac[sfb]&&(gi.scalefac[sfb]=0);0!=recalc&&(2==gfc.mode_gr?this.scale_bitcount(gi):this.scale_bitcount_lsf(gfc,gi))};var scale_short=[0,18,36,54,54,36,54,72,54,72,90,72,90,108,108,126],scale_mixed=[0,18,36,54,51,35,53,71,52,70,88,69,87,105,104,122],scale_long=[0,10,20,30,33,21,31,41,32,42,52,43,53,63,64,74];this.scale_bitcount=function(cod_info){var k,sfb,tab,max_slen1=0,max_slen2=0,scalefac=cod_info.scalefac;if(cod_info.block_type==Encoder.SHORT_TYPE)tab=scale_short,0!=cod_info.mixed_block_flag&&(tab=scale_mixed);else if(tab=scale_long,0==cod_info.preflag){for(sfb=11;sfb<Encoder.SBPSY_l&&!(scalefac[sfb]<qupvt.pretab[sfb]);sfb++);if(sfb==Encoder.SBPSY_l)for(cod_info.preflag=1,sfb=11;sfb<Encoder.SBPSY_l;sfb++)scalefac[sfb]-=qupvt.pretab[sfb]}for(sfb=0;sfb<cod_info.sfbdivide;sfb++)max_slen1<scalefac[sfb]&&(max_slen1=scalefac[sfb]);for(;sfb<cod_info.sfbmax;sfb++)max_slen2<scalefac[sfb]&&(max_slen2=scalefac[sfb]);for(cod_info.part2_length=QuantizePVT.LARGE_BITS,k=0;k<16;k++)max_slen1<slen1_n[k]&&max_slen2<slen2_n[k]&&cod_info.part2_length>tab[k]&&(cod_info.part2_length=tab[k],cod_info.scalefac_compress=k);return cod_info.part2_length==QuantizePVT.LARGE_BITS};var max_range_sfac_tab=[[15,15,7,7],[15,15,7,0],[7,3,0,0],[15,31,31,0],[7,7,7,0],[3,3,0,0]];this.scale_bitcount_lsf=function(gfc,cod_info){var table_number,row_in_table,partition,nr_sfb,window,over,i,sfb,max_sfac=new_int(4),scalefac=cod_info.scalefac;for(table_number=0!=cod_info.preflag?2:0,i=0;i<4;i++)max_sfac[i]=0;if(cod_info.block_type==Encoder.SHORT_TYPE){row_in_table=1;var partition_table=qupvt.nr_of_sfb_block[table_number][row_in_table];for(sfb=0,partition=0;partition<4;partition++)for(nr_sfb=partition_table[partition]/3,i=0;i<nr_sfb;i++,sfb++)for(window=0;window<3;window++)scalefac[3*sfb+window]>max_sfac[partition]&&(max_sfac[partition]=scalefac[3*sfb+window])}else{row_in_table=0;partition_table=qupvt.nr_of_sfb_block[table_number][row_in_table];for(sfb=0,partition=0;partition<4;partition++)for(nr_sfb=partition_table[partition],i=0;i<nr_sfb;i++,sfb++)scalefac[sfb]>max_sfac[partition]&&(max_sfac[partition]=scalefac[sfb])}for(over=!1,partition=0;partition<4;partition++)max_sfac[partition]>max_range_sfac_tab[table_number][partition]&&(over=!0);if(!over){var slen1,slen2,slen3,slen4;for(cod_info.sfb_partition_table=qupvt.nr_of_sfb_block[table_number][row_in_table],partition=0;partition<4;partition++)cod_info.slen[partition]=log2tab[max_sfac[partition]];switch(slen1=cod_info.slen[0],slen2=cod_info.slen[1],slen3=cod_info.slen[2],slen4=cod_info.slen[3],table_number){case 0:cod_info.scalefac_compress=(5*slen1+slen2<<4)+(slen3<<2)+slen4;break;case 1:cod_info.scalefac_compress=400+(5*slen1+slen2<<2)+slen3;break;case 2:cod_info.scalefac_compress=500+3*slen1+slen2;break;default:System.err.printf("intensity stereo not implemented yet\n")}}if(!over)for(cod_info.part2_length=0,partition=0;partition<4;partition++)cod_info.part2_length+=cod_info.slen[partition]*cod_info.sfb_partition_table[partition];return over};var log2tab=[0,1,2,2,3,3,3,3,4,4,4,4,4,4,4,4];this.huffman_init=function(gfc){for(var i=2;i<=576;i+=2){for(var bv_index,scfb_anz=0;gfc.scalefac_band.l[++scfb_anz]<i;);for(bv_index=subdv_table[scfb_anz][0];gfc.scalefac_band.l[bv_index+1]>i;)bv_index--;for(bv_index<0&&(bv_index=subdv_table[scfb_anz][0]),gfc.bv_scf[i-2]=bv_index,bv_index=subdv_table[scfb_anz][1];gfc.scalefac_band.l[bv_index+gfc.bv_scf[i-2]+2]>i;)bv_index--;bv_index<0&&(bv_index=subdv_table[scfb_anz][1]),gfc.bv_scf[i-1]=bv_index}}}function Reservoir(){var bs;this.setModules=function(_bs){bs=_bs},this.ResvFrameBegin=function(gfp,mean_bits){var maxmp3buf,gfc=gfp.internal_flags,l3_side=gfc.l3_side,frameLength=bs.getframebits(gfp);mean_bits.bits=(frameLength-8*gfc.sideinfo_len)/gfc.mode_gr;var resvLimit=2048*gfc.mode_gr-8;gfp.brate>320?maxmp3buf=8*int(1e3*gfp.brate/(gfp.out_samplerate/1152)/8+.5):(maxmp3buf=11520,gfp.strict_ISO&&(maxmp3buf=8*int(32e4/(gfp.out_samplerate/1152)/8+.5))),gfc.ResvMax=maxmp3buf-frameLength,gfc.ResvMax>resvLimit&&(gfc.ResvMax=resvLimit),(gfc.ResvMax<0||gfp.disable_reservoir)&&(gfc.ResvMax=0);var fullFrameBits=mean_bits.bits*gfc.mode_gr+Math.min(gfc.ResvSize,gfc.ResvMax);return fullFrameBits>maxmp3buf&&(fullFrameBits=maxmp3buf),l3_side.resvDrain_pre=0,null!=gfc.pinfo&&(gfc.pinfo.mean_bits=mean_bits.bits/2,gfc.pinfo.resvsize=gfc.ResvSize),fullFrameBits},this.ResvMaxBits=function(gfp,mean_bits,targ_bits,cbr){var add_bits,gfc=gfp.internal_flags,ResvSize=gfc.ResvSize,ResvMax=gfc.ResvMax;0!=cbr&&(ResvSize+=mean_bits),0!=(1&gfc.substep_shaping)&&(ResvMax*=.9),targ_bits.bits=mean_bits,10*ResvSize>9*ResvMax?(add_bits=ResvSize-9*ResvMax/10,targ_bits.bits+=add_bits,gfc.substep_shaping|=128):(add_bits=0,gfc.substep_shaping&=127,gfp.disable_reservoir||0!=(1&gfc.substep_shaping)||(targ_bits.bits-=.1*mean_bits));var extra_bits=ResvSize<6*gfc.ResvMax/10?ResvSize:6*gfc.ResvMax/10;return(extra_bits-=add_bits)<0&&(extra_bits=0),extra_bits},this.ResvAdjust=function(gfc,gi){gfc.ResvSize-=gi.part2_3_length+gi.part2_length},this.ResvFrameEnd=function(gfc,mean_bits){var over_bits,l3_side=gfc.l3_side;gfc.ResvSize+=mean_bits*gfc.mode_gr;var stuffingBits=0;l3_side.resvDrain_post=0,l3_side.resvDrain_pre=0,0!=(over_bits=gfc.ResvSize%8)&&(stuffingBits+=over_bits),(over_bits=gfc.ResvSize-stuffingBits-gfc.ResvMax)>0&&(stuffingBits+=over_bits);var mdb_bytes=Math.min(8*l3_side.main_data_begin,stuffingBits)/8;l3_side.resvDrain_pre+=8*mdb_bytes,stuffingBits-=8*mdb_bytes,gfc.ResvSize-=8*mdb_bytes,l3_side.main_data_begin-=mdb_bytes,l3_side.resvDrain_post+=stuffingBits,gfc.ResvSize-=stuffingBits}}function BitStream(){var self=this,ga=null,mpg=null,ver=null,vbr=null;this.setModules=function(_ga,_mpg,_ver,_vbr){ga=_ga,mpg=_mpg,ver=_ver,vbr=_vbr};var buf=null,totbit=0,bufByteIdx=0,bufBitIdx=0;function putheader_bits(gfc){System.arraycopy(gfc.header[gfc.w_ptr].buf,0,buf,bufByteIdx,gfc.sideinfo_len),bufByteIdx+=gfc.sideinfo_len,totbit+=8*gfc.sideinfo_len,gfc.w_ptr=gfc.w_ptr+1&LameInternalFlags.MAX_HEADER_BUF-1}function putbits2(gfc,val,j){for(;j>0;){var k;0==bufBitIdx&&(bufBitIdx=8,bufByteIdx++,gfc.header[gfc.w_ptr].write_timing==totbit&&putheader_bits(gfc),buf[bufByteIdx]=0),j-=k=Math.min(j,bufBitIdx),bufBitIdx-=k,buf[bufByteIdx]|=val>>j<<bufBitIdx,totbit+=k}}function putbits_noheaders(gfc,val,j){for(;j>0;){var k;0==bufBitIdx&&(bufBitIdx=8,bufByteIdx++,buf[bufByteIdx]=0),j-=k=Math.min(j,bufBitIdx),bufBitIdx-=k,buf[bufByteIdx]|=val>>j<<bufBitIdx,totbit+=k}}function drain_into_ancillary(gfp,remainingBits){var i,gfc=gfp.internal_flags;if(remainingBits>=8&&(putbits2(gfc,76,8),remainingBits-=8),remainingBits>=8&&(putbits2(gfc,65,8),remainingBits-=8),remainingBits>=8&&(putbits2(gfc,77,8),remainingBits-=8),remainingBits>=8&&(putbits2(gfc,69,8),remainingBits-=8),remainingBits>=32){var version=ver.getLameShortVersion();if(remainingBits>=32)for(i=0;i<version.length&&remainingBits>=8;++i)remainingBits-=8,putbits2(gfc,version.charAt(i),8)}for(;remainingBits>=1;remainingBits-=1)putbits2(gfc,gfc.ancillary_flag,1),gfc.ancillary_flag^=gfp.disable_reservoir?0:1}function writeheader(gfc,val,j){for(var ptr=gfc.header[gfc.h_ptr].ptr;j>0;){var k=Math.min(j,8-(7&ptr));j-=k,gfc.header[gfc.h_ptr].buf[ptr>>3]|=val>>j<<8-(7&ptr)-k,ptr+=k}gfc.header[gfc.h_ptr].ptr=ptr}function CRC_update(value,crc){value<<=8;for(var i=0;i<8;i++)0!=(65536&((crc<<=1)^(value<<=1)))&&(crc^=32773);return crc}function huffman_coder_count1(gfc,gi){var i,h=Tables.ht[gi.count1table_select+32],bits=0,ix=gi.big_values,xr=gi.big_values;for(i=(gi.count1-gi.big_values)/4;i>0;--i){var huffbits=0,p=0;0!=gi.l3_enc[ix+0]&&(p+=8,gi.xr[xr+0]<0&&huffbits++),0!=gi.l3_enc[ix+1]&&(p+=4,huffbits*=2,gi.xr[xr+1]<0&&huffbits++),0!=gi.l3_enc[ix+2]&&(p+=2,huffbits*=2,gi.xr[xr+2]<0&&huffbits++),0!=gi.l3_enc[ix+3]&&(p++,huffbits*=2,gi.xr[xr+3]<0&&huffbits++),ix+=4,xr+=4,putbits2(gfc,huffbits+h.table[p],h.hlen[p]),bits+=h.hlen[p]}return bits}function Huffmancode(gfc,tableindex,start,end,gi){var h=Tables.ht[tableindex],bits=0;if(0==tableindex)return bits;for(var i=start;i<end;i+=2){var cbits=0,xbits=0,linbits=h.xlen,xlen=h.xlen,ext=0,x1=gi.l3_enc[i],x2=gi.l3_enc[i+1];if(0!=x1&&(gi.xr[i]<0&&ext++,cbits--),tableindex>15){if(x1>14)ext|=x1-15<<1,xbits=linbits,x1=15;if(x2>14)ext<<=linbits,ext|=x2-15,xbits+=linbits,x2=15;xlen=16}0!=x2&&(ext<<=1,gi.xr[i+1]<0&&ext++,cbits--),x1=x1*xlen+x2,xbits-=cbits,cbits+=h.hlen[x1],putbits2(gfc,h.table[x1],cbits),putbits2(gfc,ext,xbits),bits+=cbits+xbits}return bits}function ShortHuffmancodebits(gfc,gi){var region1Start=3*gfc.scalefac_band.s[3];region1Start>gi.big_values&&(region1Start=gi.big_values);var bits=Huffmancode(gfc,gi.table_select[0],0,region1Start,gi);return bits+=Huffmancode(gfc,gi.table_select[1],region1Start,gi.big_values,gi)}function LongHuffmancodebits(gfc,gi){var bigvalues,bits,region1Start,region2Start;bigvalues=gi.big_values;var i=gi.region0_count+1;return region1Start=gfc.scalefac_band.l[i],i+=gi.region1_count+1,region1Start>bigvalues&&(region1Start=bigvalues),(region2Start=gfc.scalefac_band.l[i])>bigvalues&&(region2Start=bigvalues),bits=Huffmancode(gfc,gi.table_select[0],0,region1Start,gi),bits+=Huffmancode(gfc,gi.table_select[1],region1Start,region2Start,gi),bits+=Huffmancode(gfc,gi.table_select[2],region2Start,bigvalues,gi)}function TotalBytes(){this.total=0}function compute_flushbits(gfp,total_bytes_output){var flushbits,remaining_headers,bitsPerFrame,last_ptr,first_ptr,gfc=gfp.internal_flags;return first_ptr=gfc.w_ptr,-1==(last_ptr=gfc.h_ptr-1)&&(last_ptr=LameInternalFlags.MAX_HEADER_BUF-1),flushbits=gfc.header[last_ptr].write_timing-totbit,total_bytes_output.total=flushbits,flushbits>=0&&(remaining_headers=1+last_ptr-first_ptr,last_ptr<first_ptr&&(remaining_headers=1+last_ptr-first_ptr+LameInternalFlags.MAX_HEADER_BUF),flushbits-=8*remaining_headers*gfc.sideinfo_len),flushbits+=bitsPerFrame=self.getframebits(gfp),total_bytes_output.total+=bitsPerFrame,total_bytes_output.total%8!=0?total_bytes_output.total=1+total_bytes_output.total/8:total_bytes_output.total=total_bytes_output.total/8,total_bytes_output.total+=bufByteIdx+1,flushbits<0&&System.err.println("strange error flushing buffer ... \n"),flushbits}this.getframebits=function(gfp){var bit_rate,gfc=gfp.internal_flags;return bit_rate=0!=gfc.bitrate_index?Tables.bitrate_table[gfp.version][gfc.bitrate_index]:gfp.brate,8*(0|72e3*(gfp.version+1)*bit_rate/gfp.out_samplerate+gfc.padding)},this.CRC_writeheader=function(gfc,header){var crc=65535;crc=CRC_update(255&header[2],crc),crc=CRC_update(255&header[3],crc);for(var i=6;i<gfc.sideinfo_len;i++)crc=CRC_update(255&header[i],crc);header[4]=byte(crc>>8),header[5]=byte(255&crc)},this.flush_bitstream=function(gfp){var l3_side,flushbits,gfc=gfp.internal_flags,last_ptr=gfc.h_ptr-1;if(-1==last_ptr&&(last_ptr=LameInternalFlags.MAX_HEADER_BUF-1),l3_side=gfc.l3_side,!((flushbits=compute_flushbits(gfp,new TotalBytes))<0)){if(drain_into_ancillary(gfp,flushbits),gfc.ResvSize=0,l3_side.main_data_begin=0,gfc.findReplayGain){var RadioGain=ga.GetTitleGain(gfc.rgdata);gfc.RadioGain=0|Math.floor(10*RadioGain+.5)}gfc.findPeakSample&&(gfc.noclipGainChange=0|Math.ceil(20*Math.log10(gfc.PeakSample/32767)*10),gfc.noclipGainChange>0&&(EQ(gfp.scale,1)||EQ(gfp.scale,0))?gfc.noclipScale=Math.floor(32767/gfc.PeakSample*100)/100:gfc.noclipScale=-1)}},this.add_dummy_byte=function(gfp,val,n){for(var i,gfc=gfp.internal_flags;n-- >0;)for(putbits_noheaders(0,val,8),i=0;i<LameInternalFlags.MAX_HEADER_BUF;++i)gfc.header[i].write_timing+=8},this.format_bitstream=function(gfp){var l3_side,gfc=gfp.internal_flags;l3_side=gfc.l3_side;var bitsPerFrame=this.getframebits(gfp);drain_into_ancillary(gfp,l3_side.resvDrain_pre),function(gfp,bitsPerFrame){var l3_side,gr,ch,gfc=gfp.internal_flags;if(l3_side=gfc.l3_side,gfc.header[gfc.h_ptr].ptr=0,Arrays.fill(gfc.header[gfc.h_ptr].buf,0,gfc.sideinfo_len,0),gfp.out_samplerate<16e3?writeheader(gfc,4094,12):writeheader(gfc,4095,12),writeheader(gfc,gfp.version,1),writeheader(gfc,1,2),writeheader(gfc,gfp.error_protection?0:1,1),writeheader(gfc,gfc.bitrate_index,4),writeheader(gfc,gfc.samplerate_index,2),writeheader(gfc,gfc.padding,1),writeheader(gfc,gfp.extension,1),writeheader(gfc,gfp.mode.ordinal(),2),writeheader(gfc,gfc.mode_ext,2),writeheader(gfc,gfp.copyright,1),writeheader(gfc,gfp.original,1),writeheader(gfc,gfp.emphasis,2),gfp.error_protection&&writeheader(gfc,0,16),1==gfp.version){for(writeheader(gfc,l3_side.main_data_begin,9),2==gfc.channels_out?writeheader(gfc,l3_side.private_bits,3):writeheader(gfc,l3_side.private_bits,5),ch=0;ch<gfc.channels_out;ch++){var band;for(band=0;band<4;band++)writeheader(gfc,l3_side.scfsi[ch][band],1)}for(gr=0;gr<2;gr++)for(ch=0;ch<gfc.channels_out;ch++)writeheader(gfc,(gi=l3_side.tt[gr][ch]).part2_3_length+gi.part2_length,12),writeheader(gfc,gi.big_values/2,9),writeheader(gfc,gi.global_gain,8),writeheader(gfc,gi.scalefac_compress,4),gi.block_type!=Encoder.NORM_TYPE?(writeheader(gfc,1,1),writeheader(gfc,gi.block_type,2),writeheader(gfc,gi.mixed_block_flag,1),14==gi.table_select[0]&&(gi.table_select[0]=16),writeheader(gfc,gi.table_select[0],5),14==gi.table_select[1]&&(gi.table_select[1]=16),writeheader(gfc,gi.table_select[1],5),writeheader(gfc,gi.subblock_gain[0],3),writeheader(gfc,gi.subblock_gain[1],3),writeheader(gfc,gi.subblock_gain[2],3)):(writeheader(gfc,0,1),14==gi.table_select[0]&&(gi.table_select[0]=16),writeheader(gfc,gi.table_select[0],5),14==gi.table_select[1]&&(gi.table_select[1]=16),writeheader(gfc,gi.table_select[1],5),14==gi.table_select[2]&&(gi.table_select[2]=16),writeheader(gfc,gi.table_select[2],5),writeheader(gfc,gi.region0_count,4),writeheader(gfc,gi.region1_count,3)),writeheader(gfc,gi.preflag,1),writeheader(gfc,gi.scalefac_scale,1),writeheader(gfc,gi.count1table_select,1)}else for(writeheader(gfc,l3_side.main_data_begin,8),writeheader(gfc,l3_side.private_bits,gfc.channels_out),gr=0,ch=0;ch<gfc.channels_out;ch++){var gi;writeheader(gfc,(gi=l3_side.tt[gr][ch]).part2_3_length+gi.part2_length,12),writeheader(gfc,gi.big_values/2,9),writeheader(gfc,gi.global_gain,8),writeheader(gfc,gi.scalefac_compress,9),gi.block_type!=Encoder.NORM_TYPE?(writeheader(gfc,1,1),writeheader(gfc,gi.block_type,2),writeheader(gfc,gi.mixed_block_flag,1),14==gi.table_select[0]&&(gi.table_select[0]=16),writeheader(gfc,gi.table_select[0],5),14==gi.table_select[1]&&(gi.table_select[1]=16),writeheader(gfc,gi.table_select[1],5),writeheader(gfc,gi.subblock_gain[0],3),writeheader(gfc,gi.subblock_gain[1],3),writeheader(gfc,gi.subblock_gain[2],3)):(writeheader(gfc,0,1),14==gi.table_select[0]&&(gi.table_select[0]=16),writeheader(gfc,gi.table_select[0],5),14==gi.table_select[1]&&(gi.table_select[1]=16),writeheader(gfc,gi.table_select[1],5),14==gi.table_select[2]&&(gi.table_select[2]=16),writeheader(gfc,gi.table_select[2],5),writeheader(gfc,gi.region0_count,4),writeheader(gfc,gi.region1_count,3)),writeheader(gfc,gi.scalefac_scale,1),writeheader(gfc,gi.count1table_select,1)}gfp.error_protection&&CRC_writeheader(gfc,gfc.header[gfc.h_ptr].buf);var old=gfc.h_ptr;gfc.h_ptr=old+1&LameInternalFlags.MAX_HEADER_BUF-1,gfc.header[gfc.h_ptr].write_timing=gfc.header[old].write_timing+bitsPerFrame,gfc.h_ptr==gfc.w_ptr&&System.err.println("Error: MAX_HEADER_BUF too small in bitstream.c \n")}(gfp,bitsPerFrame);var bits=8*gfc.sideinfo_len;if(bits+=function(gfp){var gr,ch,sfb,data_bits,tot_bits=0,gfc=gfp.internal_flags,l3_side=gfc.l3_side;if(1==gfp.version)for(gr=0;gr<2;gr++)for(ch=0;ch<gfc.channels_out;ch++){var gi=l3_side.tt[gr][ch],slen1=Takehiro.slen1_tab[gi.scalefac_compress],slen2=Takehiro.slen2_tab[gi.scalefac_compress];for(data_bits=0,sfb=0;sfb<gi.sfbdivide;sfb++)-1!=gi.scalefac[sfb]&&(putbits2(gfc,gi.scalefac[sfb],slen1),data_bits+=slen1);for(;sfb<gi.sfbmax;sfb++)-1!=gi.scalefac[sfb]&&(putbits2(gfc,gi.scalefac[sfb],slen2),data_bits+=slen2);gi.block_type==Encoder.SHORT_TYPE?data_bits+=ShortHuffmancodebits(gfc,gi):data_bits+=LongHuffmancodebits(gfc,gi),tot_bits+=data_bits+=huffman_coder_count1(gfc,gi)}else for(gr=0,ch=0;ch<gfc.channels_out;ch++){var i,sfb_partition,scale_bits=0;if(data_bits=0,sfb=0,sfb_partition=0,(gi=l3_side.tt[gr][ch]).block_type==Encoder.SHORT_TYPE){for(;sfb_partition<4;sfb_partition++){var sfbs=gi.sfb_partition_table[sfb_partition]/3,slen=gi.slen[sfb_partition];for(i=0;i<sfbs;i++,sfb++)putbits2(gfc,Math.max(gi.scalefac[3*sfb+0],0),slen),putbits2(gfc,Math.max(gi.scalefac[3*sfb+1],0),slen),putbits2(gfc,Math.max(gi.scalefac[3*sfb+2],0),slen),scale_bits+=3*slen}data_bits+=ShortHuffmancodebits(gfc,gi)}else{for(;sfb_partition<4;sfb_partition++)for(sfbs=gi.sfb_partition_table[sfb_partition],slen=gi.slen[sfb_partition],i=0;i<sfbs;i++,sfb++)putbits2(gfc,Math.max(gi.scalefac[sfb],0),slen),scale_bits+=slen;data_bits+=LongHuffmancodebits(gfc,gi)}tot_bits+=scale_bits+(data_bits+=huffman_coder_count1(gfc,gi))}return tot_bits}(gfp),drain_into_ancillary(gfp,l3_side.resvDrain_post),bits+=l3_side.resvDrain_post,l3_side.main_data_begin+=(bitsPerFrame-bits)/8,compute_flushbits(gfp,new TotalBytes)!=gfc.ResvSize&&System.err.println("Internal buffer inconsistency. flushbits <> ResvSize"),8*l3_side.main_data_begin!=gfc.ResvSize&&(System.err.printf("bit reservoir error: \nl3_side.main_data_begin: %d \nResvoir size:             %d \nresv drain (post)         %d \nresv drain (pre)          %d \nheader and sideinfo:      %d \ndata bits:                %d \ntotal bits:               %d (remainder: %d) \nbitsperframe:             %d \n",8*l3_side.main_data_begin,gfc.ResvSize,l3_side.resvDrain_post,l3_side.resvDrain_pre,8*gfc.sideinfo_len,bits-l3_side.resvDrain_post-8*gfc.sideinfo_len,bits,bits%8,bitsPerFrame),System.err.println("This is a fatal error.  It has several possible causes:"),System.err.println("90%%  LAME compiled with buggy version of gcc using advanced optimizations"),System.err.println(" 9%%  Your system is overclocked"),System.err.println(" 1%%  bug in LAME encoding library"),gfc.ResvSize=8*l3_side.main_data_begin),totbit>1e9){var i;for(i=0;i<LameInternalFlags.MAX_HEADER_BUF;++i)gfc.header[i].write_timing-=totbit;totbit=0}return 0},this.copy_buffer=function(gfc,buffer,bufferPos,size,mp3data){var minimum=bufByteIdx+1;if(minimum<=0)return 0;if(0!=size&&minimum>size)return-1;if(System.arraycopy(buf,0,buffer,bufferPos,minimum),bufByteIdx=-1,bufBitIdx=0,0!=mp3data){var crc=new_int(1);if(crc[0]=gfc.nMusicCRC,vbr.updateMusicCRC(crc,buffer,bufferPos,minimum),gfc.nMusicCRC=crc[0],minimum>0&&(gfc.VBR_seek_table.nBytesWritten+=minimum),gfc.decode_on_the_fly)for(var i,pcm_buf=new_float_n([2,1152]),mp3_in=minimum,samples_out=-1;0!=samples_out;)if(samples_out=mpg.hip_decode1_unclipped(gfc.hip,buffer,bufferPos,mp3_in,pcm_buf[0],pcm_buf[1]),mp3_in=0,-1==samples_out&&(samples_out=0),samples_out>0){if(gfc.findPeakSample){for(i=0;i<samples_out;i++)pcm_buf[0][i]>gfc.PeakSample?gfc.PeakSample=pcm_buf[0][i]:-pcm_buf[0][i]>gfc.PeakSample&&(gfc.PeakSample=-pcm_buf[0][i]);if(gfc.channels_out>1)for(i=0;i<samples_out;i++)pcm_buf[1][i]>gfc.PeakSample?gfc.PeakSample=pcm_buf[1][i]:-pcm_buf[1][i]>gfc.PeakSample&&(gfc.PeakSample=-pcm_buf[1][i])}if(gfc.findReplayGain&&ga.AnalyzeSamples(gfc.rgdata,pcm_buf[0],0,pcm_buf[1],0,samples_out,gfc.channels_out)==GainAnalysis.GAIN_ANALYSIS_ERROR)return-6}}return minimum},this.init_bit_stream_w=function(gfc){buf=new_byte(Lame.LAME_MAXMP3BUFFER),gfc.h_ptr=gfc.w_ptr=0,gfc.header[gfc.h_ptr].write_timing=0,bufByteIdx=-1,bufBitIdx=0,totbit=0}}function VBRTag(){var lame,bs,v;this.setModules=function(_lame,_bs,_v){lame=_lame,bs=_bs,v=_v};var NUMTOCENTRIES=VBRTag.NUMTOCENTRIES,MAXFRAMESIZE=VBRTag.MAXFRAMESIZE,LAMEHEADERSIZE=NUMTOCENTRIES+4+4+4+4+4+9+1+1+8+1+1+3+1+1+2+4+2+2,crc16Lookup=[0,49345,49537,320,49921,960,640,49729,50689,1728,1920,51009,1280,50625,50305,1088,52225,3264,3456,52545,3840,53185,52865,3648,2560,51905,52097,2880,51457,2496,2176,51265,55297,6336,6528,55617,6912,56257,55937,6720,7680,57025,57217,8e3,56577,7616,7296,56385,5120,54465,54657,5440,55041,6080,5760,54849,53761,4800,4992,54081,4352,53697,53377,4160,61441,12480,12672,61761,13056,62401,62081,12864,13824,63169,63361,14144,62721,13760,13440,62529,15360,64705,64897,15680,65281,16320,16e3,65089,64001,15040,15232,64321,14592,63937,63617,14400,10240,59585,59777,10560,60161,11200,10880,59969,60929,11968,12160,61249,11520,60865,60545,11328,58369,9408,9600,58689,9984,59329,59009,9792,8704,58049,58241,9024,57601,8640,8320,57409,40961,24768,24960,41281,25344,41921,41601,25152,26112,42689,42881,26432,42241,26048,25728,42049,27648,44225,44417,27968,44801,28608,28288,44609,43521,27328,27520,43841,26880,43457,43137,26688,30720,47297,47489,31040,47873,31680,31360,47681,48641,32448,32640,48961,32e3,48577,48257,31808,46081,29888,30080,46401,30464,47041,46721,30272,29184,45761,45953,29504,45313,29120,28800,45121,20480,37057,37249,20800,37633,21440,21120,37441,38401,22208,22400,38721,21760,38337,38017,21568,39937,23744,23936,40257,24320,40897,40577,24128,23040,39617,39809,23360,39169,22976,22656,38977,34817,18624,18816,35137,19200,35777,35457,19008,19968,36545,36737,20288,36097,19904,19584,35905,17408,33985,34177,17728,34561,18368,18048,34369,33281,17088,17280,33601,16640,33217,32897,16448];function extractInteger(buf,bufPos){var x=255&buf[bufPos+0];return x<<=8,x|=255&buf[bufPos+1],x<<=8,x|=255&buf[bufPos+2],x<<=8,x|=255&buf[bufPos+3]}function createInteger(buf,bufPos,value){buf[bufPos+0]=255&value>>24,buf[bufPos+1]=255&value>>16,buf[bufPos+2]=255&value>>8,buf[bufPos+3]=255&value}function createShort(buf,bufPos,value){buf[bufPos+0]=255&value>>8,buf[bufPos+1]=255&value}function shiftInBitsValue(x,n,v){return 255&(x<<n|v&~(-1<<n))}function setLameTagFrameHeader(gfp,buffer){var gfc=gfp.internal_flags;buffer[0]=shiftInBitsValue(buffer[0],8,255),buffer[1]=shiftInBitsValue(buffer[1],3,7),buffer[1]=shiftInBitsValue(buffer[1],1,gfp.out_samplerate<16e3?0:1),buffer[1]=shiftInBitsValue(buffer[1],1,gfp.version),buffer[1]=shiftInBitsValue(buffer[1],2,1),buffer[1]=shiftInBitsValue(buffer[1],1,gfp.error_protection?0:1),buffer[2]=shiftInBitsValue(buffer[2],4,gfc.bitrate_index),buffer[2]=shiftInBitsValue(buffer[2],2,gfc.samplerate_index),buffer[2]=shiftInBitsValue(buffer[2],1,0),buffer[2]=shiftInBitsValue(buffer[2],1,gfp.extension),buffer[3]=shiftInBitsValue(buffer[3],2,gfp.mode.ordinal()),buffer[3]=shiftInBitsValue(buffer[3],2,gfc.mode_ext),buffer[3]=shiftInBitsValue(buffer[3],1,gfp.copyright),buffer[3]=shiftInBitsValue(buffer[3],1,gfp.original),buffer[3]=shiftInBitsValue(buffer[3],2,gfp.emphasis),buffer[0]=255;var bitrate,bbyte,abyte=241&buffer[1];bitrate=1==gfp.version?128:gfp.out_samplerate<16e3?32:64,gfp.VBR==VbrMode.vbr_off&&(bitrate=gfp.brate),bbyte=gfp.free_format?0:255&16*lame.BitrateIndex(bitrate,gfp.version,gfp.out_samplerate),1==gfp.version?(buffer[1]=255&(10|abyte),abyte=13&buffer[2],buffer[2]=255&(bbyte|abyte)):(buffer[1]=255&(2|abyte),abyte=13&buffer[2],buffer[2]=255&(bbyte|abyte))}function crcUpdateLookup(value,crc){return crc=crc>>8^crc16Lookup[255&(crc^value)]}this.addVbrFrame=function(gfp){var gfc=gfp.internal_flags,kbps=Tables.bitrate_table[gfp.version][gfc.bitrate_index];!function(v,bitrate){if(v.nVbrNumFrames++,v.sum+=bitrate,v.seen++,!(v.seen<v.want)&&(v.pos<v.size&&(v.bag[v.pos]=v.sum,v.pos++,v.seen=0),v.pos==v.size)){for(var i=1;i<v.size;i+=2)v.bag[i/2]=v.bag[i];v.want*=2,v.pos/=2}}(gfc.VBR_seek_table,kbps)},this.getVbrTag=function(buf){var pTagData=new VBRTagData,bufPos=0;pTagData.flags=0;var hId=buf[bufPos+1]>>3&1,hSrIndex=buf[bufPos+2]>>2&3,hMode=buf[bufPos+3]>>6&3,hBitrate=buf[bufPos+2]>>4&15;if(hBitrate=Tables.bitrate_table[hId][hBitrate],buf[bufPos+1]>>4==14?pTagData.samprate=Tables.samplerate_table[2][hSrIndex]:pTagData.samprate=Tables.samplerate_table[hId][hSrIndex],!function(buf,bufPos){return new String(buf,bufPos,"Xing".length(),null).equals("Xing")||new String(buf,bufPos,"Info".length(),null).equals("Info")}(buf,bufPos+=0!=hId?3!=hMode?36:21:3!=hMode?21:13))return null;bufPos+=4,pTagData.hId=hId;var head_flags=pTagData.flags=extractInteger(buf,bufPos);if(bufPos+=4,0!=(1&head_flags)&&(pTagData.frames=extractInteger(buf,bufPos),bufPos+=4),0!=(2&head_flags)&&(pTagData.bytes=extractInteger(buf,bufPos),bufPos+=4),0!=(4&head_flags)){if(null!=pTagData.toc)for(var i=0;i<NUMTOCENTRIES;i++)pTagData.toc[i]=buf[bufPos+i];bufPos+=NUMTOCENTRIES}pTagData.vbrScale=-1,0!=(8&head_flags)&&(pTagData.vbrScale=extractInteger(buf,bufPos),bufPos+=4),pTagData.headersize=72e3*(hId+1)*hBitrate/pTagData.samprate;var encDelay=buf[(bufPos+=21)+0]<<4;encDelay+=buf[bufPos+1]>>4;var encPadding=(15&buf[bufPos+1])<<8;return(encDelay<0||encDelay>3e3)&&(encDelay=-1),((encPadding+=255&buf[bufPos+2])<0||encPadding>3e3)&&(encPadding=-1),pTagData.encDelay=encDelay,pTagData.encPadding=encPadding,pTagData},this.InitVbrTag=function(gfp){var kbps_header,gfc=gfp.internal_flags;kbps_header=1==gfp.version?128:gfp.out_samplerate<16e3?32:64,gfp.VBR==VbrMode.vbr_off&&(kbps_header=gfp.brate);var totalFrameSize=72e3*(gfp.version+1)*kbps_header/gfp.out_samplerate,headerSize=gfc.sideinfo_len+LAMEHEADERSIZE;if(gfc.VBR_seek_table.TotalFrameSize=totalFrameSize,totalFrameSize<headerSize||totalFrameSize>MAXFRAMESIZE)gfp.bWriteVbrTag=!1;else{gfc.VBR_seek_table.nVbrNumFrames=0,gfc.VBR_seek_table.nBytesWritten=0,gfc.VBR_seek_table.sum=0,gfc.VBR_seek_table.seen=0,gfc.VBR_seek_table.want=1,gfc.VBR_seek_table.pos=0,null==gfc.VBR_seek_table.bag&&(gfc.VBR_seek_table.bag=new int[400],gfc.VBR_seek_table.size=400);var buffer=new_byte(MAXFRAMESIZE);setLameTagFrameHeader(gfp,buffer);for(var n=gfc.VBR_seek_table.TotalFrameSize,i=0;i<n;++i)bs.add_dummy_byte(gfp,255&buffer[i],1)}},this.updateMusicCRC=function(crc,buffer,bufferPos,size){for(var i=0;i<size;++i)crc[0]=crcUpdateLookup(buffer[bufferPos+i],crc[0])},this.getLameTagFrame=function(gfp,buffer){var gfc=gfp.internal_flags;if(!gfp.bWriteVbrTag)return 0;if(gfc.Class_ID!=Lame.LAME_ID)return 0;if(gfc.VBR_seek_table.pos<=0)return 0;if(buffer.length<gfc.VBR_seek_table.TotalFrameSize)return gfc.VBR_seek_table.TotalFrameSize;Arrays.fill(buffer,0,gfc.VBR_seek_table.TotalFrameSize,0),setLameTagFrameHeader(gfp,buffer);var toc=new_byte(NUMTOCENTRIES);if(gfp.free_format)for(var i=1;i<NUMTOCENTRIES;++i)toc[i]=255&255*i/100;else!function(v,t){if(!(v.pos<=0))for(var i=1;i<NUMTOCENTRIES;++i){var j=i/NUMTOCENTRIES,indx=0|Math.floor(j*v.pos);indx>v.pos-1&&(indx=v.pos-1);var seek_point=0|256*v.bag[indx]/v.sum;seek_point>255&&(seek_point=255),t[i]=255&seek_point}}(gfc.VBR_seek_table,toc);var streamIndex=gfc.sideinfo_len;gfp.error_protection&&(streamIndex-=2),gfp.VBR==VbrMode.vbr_off?(buffer[streamIndex++]=255&"Info".charAt(0),buffer[streamIndex++]=255&"Info".charAt(1),buffer[streamIndex++]=255&"Info".charAt(2),buffer[streamIndex++]=255&"Info".charAt(3)):(buffer[streamIndex++]=255&"Xing".charAt(0),buffer[streamIndex++]=255&"Xing".charAt(1),buffer[streamIndex++]=255&"Xing".charAt(2),buffer[streamIndex++]=255&"Xing".charAt(3)),createInteger(buffer,streamIndex,15),createInteger(buffer,streamIndex+=4,gfc.VBR_seek_table.nVbrNumFrames),streamIndex+=4;var streamSize=gfc.VBR_seek_table.nBytesWritten+gfc.VBR_seek_table.TotalFrameSize;createInteger(buffer,streamIndex,0|streamSize),streamIndex+=4,System.arraycopy(toc,0,buffer,streamIndex,toc.length),streamIndex+=toc.length,gfp.error_protection&&bs.CRC_writeheader(gfc,buffer);var crc=0;for(i=0;i<streamIndex;i++)crc=crcUpdateLookup(buffer[i],crc);return streamIndex+=function(gfp,musicLength,streamBuffer,streamBufferPos,crc){var revMethod,misc,musicCRC,flags,abrBitrate,gfc=gfp.internal_flags,bytesWritten=0,encDelay=gfp.encoder_delay,encPadding=gfp.encoder_padding,quality=100-10*gfp.VBR_q-gfp.quality,version=v.getLameVeryShortVersion(),vbrTypeTranslator=[1,5,3,2,4,0,3],lowpass=0|(gfp.lowpassfreq/100+.5>255?255:gfp.lowpassfreq/100+.5),peakSignalAmplitude=0,radioReplayGain=0,noiseShaping=gfp.internal_flags.noise_shaping,stereoMode=0,nonOptimal=0,sourceFreq=0,expNPsyTune=0!=(1&gfp.exp_nspsytune),safeJoint=0!=(2&gfp.exp_nspsytune),noGapMore=!1,noGapPrevious=!1,noGapCount=gfp.internal_flags.nogap_total,noGapCurr=gfp.internal_flags.nogap_current,athType=gfp.ATHtype;switch(gfp.VBR){case vbr_abr:abrBitrate=gfp.VBR_mean_bitrate_kbps;break;case vbr_off:abrBitrate=gfp.brate;break;default:abrBitrate=gfp.VBR_min_bitrate_kbps}switch(revMethod=0+(gfp.VBR.ordinal()<vbrTypeTranslator.length?vbrTypeTranslator[gfp.VBR.ordinal()]:0),gfc.findReplayGain&&(gfc.RadioGain>510&&(gfc.RadioGain=510),gfc.RadioGain<-510&&(gfc.RadioGain=-510),radioReplayGain=8192,radioReplayGain|=3072,gfc.RadioGain>=0?radioReplayGain|=gfc.RadioGain:(radioReplayGain|=512,radioReplayGain|=-gfc.RadioGain)),gfc.findPeakSample&&(peakSignalAmplitude=Math.abs(0|gfc.PeakSample/32767*Math.pow(2,23)+.5)),-1!=noGapCount&&(noGapCurr>0&&(noGapPrevious=!0),noGapCurr<noGapCount-1&&(noGapMore=!0)),flags=athType+((expNPsyTune?1:0)<<4)+((safeJoint?1:0)<<5)+((noGapMore?1:0)<<6)+((noGapPrevious?1:0)<<7),quality<0&&(quality=0),gfp.mode){case MONO:stereoMode=0;break;case STEREO:stereoMode=1;break;case DUAL_CHANNEL:stereoMode=2;break;case JOINT_STEREO:stereoMode=gfp.force_ms?4:3;break;case NOT_SET:default:stereoMode=7}sourceFreq=gfp.in_samplerate<=32e3?0:48e3==gfp.in_samplerate?2:gfp.in_samplerate>48e3?3:1,(gfp.short_blocks==ShortBlock.short_block_forced||gfp.short_blocks==ShortBlock.short_block_dispensed||-1==gfp.lowpassfreq&&-1==gfp.highpassfreq||gfp.scale_left<gfp.scale_right||gfp.scale_left>gfp.scale_right||gfp.disable_reservoir&&gfp.brate<320||gfp.noATH||gfp.ATHonly||0==athType||gfp.in_samplerate<=32e3)&&(nonOptimal=1),misc=noiseShaping+(stereoMode<<2)+(nonOptimal<<5)+(sourceFreq<<6),musicCRC=gfc.nMusicCRC,createInteger(streamBuffer,streamBufferPos+bytesWritten,quality),bytesWritten+=4;for(var j=0;j<9;j++)streamBuffer[streamBufferPos+bytesWritten+j]=255&version.charAt(j);streamBuffer[streamBufferPos+(bytesWritten+=9)]=255&revMethod,streamBuffer[streamBufferPos+ ++bytesWritten]=255&lowpass,createInteger(streamBuffer,streamBufferPos+ ++bytesWritten,peakSignalAmplitude),createShort(streamBuffer,streamBufferPos+(bytesWritten+=4),radioReplayGain),createShort(streamBuffer,streamBufferPos+(bytesWritten+=2),0),streamBuffer[streamBufferPos+(bytesWritten+=2)]=255&flags,streamBuffer[streamBufferPos+ ++bytesWritten]=abrBitrate>=255?255:255&abrBitrate,streamBuffer[streamBufferPos+ ++bytesWritten]=255&encDelay>>4,streamBuffer[streamBufferPos+bytesWritten+1]=255&(encDelay<<4)+(encPadding>>8),streamBuffer[streamBufferPos+bytesWritten+2]=255&encPadding,streamBuffer[streamBufferPos+(bytesWritten+=3)]=255&misc,bytesWritten++,streamBuffer[streamBufferPos+bytesWritten++]=0,createShort(streamBuffer,streamBufferPos+bytesWritten,gfp.preset),createInteger(streamBuffer,streamBufferPos+(bytesWritten+=2),musicLength),createShort(streamBuffer,streamBufferPos+(bytesWritten+=4),musicCRC),bytesWritten+=2;for(var i=0;i<bytesWritten;i++)crc=crcUpdateLookup(streamBuffer[streamBufferPos+i],crc);return createShort(streamBuffer,streamBufferPos+bytesWritten,crc),bytesWritten+2}(gfp,streamSize,buffer,streamIndex,crc),gfc.VBR_seek_table.TotalFrameSize},this.putVbrTag=function(gfp,stream){if(gfp.internal_flags.VBR_seek_table.pos<=0)return-1;if(stream.seek(stream.length()),0==stream.length())return-1;var id3v2TagSize=function(fpStream){fpStream.seek(0);var id3v2Header=new_byte(10);return fpStream.readFully(id3v2Header),new String(id3v2Header,"ISO-8859-1").startsWith("ID3")?0:((127&id3v2Header[6])<<21|(127&id3v2Header[7])<<14|(127&id3v2Header[8])<<7|127&id3v2Header[9])+id3v2Header.length}(stream);stream.seek(id3v2TagSize);var buffer=new_byte(MAXFRAMESIZE),bytes=getLameTagFrame(gfp,buffer);return bytes>buffer.length?-1:(bytes<1||stream.write(buffer,0,bytes),0)}}function HuffCodeTab(len,max,tab,hl){this.xlen=len,this.linmax=max,this.table=tab,this.hlen=hl}MPEGMode.STEREO=new MPEGMode(0),MPEGMode.JOINT_STEREO=new MPEGMode(1),MPEGMode.DUAL_CHANNEL=new MPEGMode(2),MPEGMode.MONO=new MPEGMode(3),MPEGMode.NOT_SET=new MPEGMode(4),GainAnalysis.STEPS_per_dB=100,GainAnalysis.MAX_dB=120,GainAnalysis.GAIN_NOT_ENOUGH_SAMPLES=-24601,GainAnalysis.GAIN_ANALYSIS_ERROR=0,GainAnalysis.GAIN_ANALYSIS_OK=1,GainAnalysis.INIT_GAIN_ANALYSIS_ERROR=0,GainAnalysis.INIT_GAIN_ANALYSIS_OK=1,GainAnalysis.YULE_ORDER=10,GainAnalysis.MAX_ORDER=GainAnalysis.YULE_ORDER,GainAnalysis.MAX_SAMP_FREQ=48e3,GainAnalysis.RMS_WINDOW_TIME_NUMERATOR=1,GainAnalysis.RMS_WINDOW_TIME_DENOMINATOR=20,GainAnalysis.MAX_SAMPLES_PER_WINDOW=GainAnalysis.MAX_SAMP_FREQ*GainAnalysis.RMS_WINDOW_TIME_NUMERATOR/GainAnalysis.RMS_WINDOW_TIME_DENOMINATOR+1,BitStream.EQ=function(a,b){return Math.abs(a)>Math.abs(b)?Math.abs(a-b)<=1e-6*Math.abs(a):Math.abs(a-b)<=1e-6*Math.abs(b)},BitStream.NEQ=function(a,b){return!BitStream.EQ(a,b)},VBRTag.NUMTOCENTRIES=100,VBRTag.MAXFRAMESIZE=2880;var Tables={};function MeanBits(meanBits){this.bits=meanBits}function VBRQuantize(){this.setModules=function(_qupvt,_tk){_qupvt,_tk}}function CalcNoiseResult(){this.over_noise=0,this.tot_noise=0,this.max_noise=0,this.over_count=0,this.over_SSD=0,this.bits=0}function LameGlobalFlags(){this.class_id=0,this.num_samples=0,this.num_channels=0,this.in_samplerate=0,this.out_samplerate=0,this.scale=0,this.scale_left=0,this.scale_right=0,this.analysis=!1,this.bWriteVbrTag=!1,this.decode_only=!1,this.quality=0,this.mode=MPEGMode.STEREO,this.force_ms=!1,this.free_format=!1,this.findReplayGain=!1,this.decode_on_the_fly=!1,this.write_id3tag_automatic=!1,this.brate=0,this.compression_ratio=0,this.copyright=0,this.original=0,this.extension=0,this.emphasis=0,this.error_protection=0,this.strict_ISO=!1,this.disable_reservoir=!1,this.quant_comp=0,this.quant_comp_short=0,this.experimentalY=!1,this.experimentalZ=0,this.exp_nspsytune=0,this.preset=0,this.VBR=null,this.VBR_q_frac=0,this.VBR_q=0,this.VBR_mean_bitrate_kbps=0,this.VBR_min_bitrate_kbps=0,this.VBR_max_bitrate_kbps=0,this.VBR_hard_min=0,this.lowpassfreq=0,this.highpassfreq=0,this.lowpasswidth=0,this.highpasswidth=0,this.maskingadjust=0,this.maskingadjust_short=0,this.ATHonly=!1,this.ATHshort=!1,this.noATH=!1,this.ATHtype=0,this.ATHcurve=0,this.ATHlower=0,this.athaa_type=0,this.athaa_loudapprox=0,this.athaa_sensitivity=0,this.short_blocks=null,this.useTemporal=!1,this.interChRatio=0,this.msfix=0,this.tune=!1,this.tune_value_a=0,this.version=0,this.encoder_delay=0,this.encoder_padding=0,this.framesize=0,this.frameNum=0,this.lame_allocated_gfp=0,this.internal_flags=null}function ReplayGain(){this.linprebuf=new_float(2*GainAnalysis.MAX_ORDER),this.linpre=0,this.lstepbuf=new_float(GainAnalysis.MAX_SAMPLES_PER_WINDOW+GainAnalysis.MAX_ORDER),this.lstep=0,this.loutbuf=new_float(GainAnalysis.MAX_SAMPLES_PER_WINDOW+GainAnalysis.MAX_ORDER),this.lout=0,this.rinprebuf=new_float(2*GainAnalysis.MAX_ORDER),this.rinpre=0,this.rstepbuf=new_float(GainAnalysis.MAX_SAMPLES_PER_WINDOW+GainAnalysis.MAX_ORDER),this.rstep=0,this.routbuf=new_float(GainAnalysis.MAX_SAMPLES_PER_WINDOW+GainAnalysis.MAX_ORDER),this.rout=0,this.sampleWindow=0,this.totsamp=0,this.lsum=0,this.rsum=0,this.freqindex=0,this.first=0,this.A=new_int(0|GainAnalysis.STEPS_per_dB*GainAnalysis.MAX_dB),this.B=new_int(0|GainAnalysis.STEPS_per_dB*GainAnalysis.MAX_dB)}function CBRNewIterationLoop(_quantize){var quantize=_quantize;this.quantize=quantize,this.iteration_loop=function(gfp,pe,ms_ener_ratio,ratio){var max_bits,gfc=gfp.internal_flags,l3_xmin=new_float(L3Side.SFBMAX),xrpow=new_float(576),targ_bits=new_int(2),mean_bits=0,l3_side=gfc.l3_side,mb=new MeanBits(mean_bits);this.quantize.rv.ResvFrameBegin(gfp,mb),mean_bits=mb.bits;for(var gr=0;gr<gfc.mode_gr;gr++){max_bits=this.quantize.qupvt.on_pe(gfp,pe,targ_bits,mean_bits,gr,gr),gfc.mode_ext==Encoder.MPG_MD_MS_LR&&(this.quantize.ms_convert(gfc.l3_side,gr),this.quantize.qupvt.reduce_side(targ_bits,ms_ener_ratio[gr],mean_bits,max_bits));for(var ch=0;ch<gfc.channels_out;ch++){var adjust,masking_lower_db,cod_info=l3_side.tt[gr][ch];cod_info.block_type!=Encoder.SHORT_TYPE?(adjust=0,masking_lower_db=gfc.PSY.mask_adjust-adjust):(adjust=0,masking_lower_db=gfc.PSY.mask_adjust_short-adjust),gfc.masking_lower=Math.pow(10,.1*masking_lower_db),this.quantize.init_outer_loop(gfc,cod_info),this.quantize.init_xrpow(gfc,cod_info,xrpow)&&(this.quantize.qupvt.calc_xmin(gfp,ratio[gr][ch],cod_info,l3_xmin),this.quantize.outer_loop(gfp,cod_info,l3_xmin,xrpow,ch,targ_bits[ch])),this.quantize.iteration_finish_one(gfc,gr,ch)}}this.quantize.rv.ResvFrameEnd(gfc,mean_bits)}}function ATH(){this.useAdjust=0,this.aaSensitivityP=0,this.adjust=0,this.adjustLimit=0,this.decay=0,this.floor=0,this.l=new_float(Encoder.SBMAX_l),this.s=new_float(Encoder.SBMAX_s),this.psfb21=new_float(Encoder.PSFB21),this.psfb12=new_float(Encoder.PSFB12),this.cb_l=new_float(Encoder.CBANDS),this.cb_s=new_float(Encoder.CBANDS),this.eql_w=new_float(Encoder.BLKSIZE/2)}function ScaleFac(arrL,arrS,arr21,arr12){this.l=new_int(1+Encoder.SBMAX_l),this.s=new_int(1+Encoder.SBMAX_s),this.psfb21=new_int(1+Encoder.PSFB21),this.psfb12=new_int(1+Encoder.PSFB12);var l=this.l,s=this.s;4==arguments.length&&(this.arrL=arguments[0],this.arrS=arguments[1],this.arr21=arguments[2],this.arr12=arguments[3],System.arraycopy(this.arrL,0,l,0,Math.min(this.arrL.length,this.l.length)),System.arraycopy(this.arrS,0,s,0,Math.min(this.arrS.length,this.s.length)),System.arraycopy(this.arr21,0,this.psfb21,0,Math.min(this.arr21.length,this.psfb21.length)),System.arraycopy(this.arr12,0,this.psfb12,0,Math.min(this.arr12.length,this.psfb12.length)))}function QuantizePVT(){var tak=null,rv=null,psy=null;this.setModules=function(_tk,_rv,_psy){tak=_tk,rv=_rv,psy=_psy},this.IPOW20=function(x){return ipow20[x]};var PRECALC_SIZE=QuantizePVT.IXMAX_VAL+2,Q_MAX=QuantizePVT.Q_MAX,Q_MAX2=QuantizePVT.Q_MAX2;QuantizePVT.LARGE_BITS;this.nr_of_sfb_block=[[[6,5,5,5],[9,9,9,9],[6,9,9,9]],[[6,5,7,3],[9,9,12,6],[6,9,12,6]],[[11,10,0,0],[18,18,0,0],[15,18,0,0]],[[7,7,7,0],[12,12,12,0],[6,15,12,0]],[[6,6,6,3],[12,9,9,6],[6,12,9,6]],[[8,8,5,0],[15,12,9,0],[6,18,9,0]]];var pretab=[0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,2,2,3,3,3,2,0];this.pretab=pretab,this.sfBandIndex=[new ScaleFac([0,6,12,18,24,30,36,44,54,66,80,96,116,140,168,200,238,284,336,396,464,522,576],[0,4,8,12,18,24,32,42,56,74,100,132,174,192],[0,0,0,0,0,0,0],[0,0,0,0,0,0,0]),new ScaleFac([0,6,12,18,24,30,36,44,54,66,80,96,114,136,162,194,232,278,332,394,464,540,576],[0,4,8,12,18,26,36,48,62,80,104,136,180,192],[0,0,0,0,0,0,0],[0,0,0,0,0,0,0]),new ScaleFac([0,6,12,18,24,30,36,44,54,66,80,96,116,140,168,200,238,284,336,396,464,522,576],[0,4,8,12,18,26,36,48,62,80,104,134,174,192],[0,0,0,0,0,0,0],[0,0,0,0,0,0,0]),new ScaleFac([0,4,8,12,16,20,24,30,36,44,52,62,74,90,110,134,162,196,238,288,342,418,576],[0,4,8,12,16,22,30,40,52,66,84,106,136,192],[0,0,0,0,0,0,0],[0,0,0,0,0,0,0]),new ScaleFac([0,4,8,12,16,20,24,30,36,42,50,60,72,88,106,128,156,190,230,276,330,384,576],[0,4,8,12,16,22,28,38,50,64,80,100,126,192],[0,0,0,0,0,0,0],[0,0,0,0,0,0,0]),new ScaleFac([0,4,8,12,16,20,24,30,36,44,54,66,82,102,126,156,194,240,296,364,448,550,576],[0,4,8,12,16,22,30,42,58,78,104,138,180,192],[0,0,0,0,0,0,0],[0,0,0,0,0,0,0]),new ScaleFac([0,6,12,18,24,30,36,44,54,66,80,96,116,140,168,200,238,284,336,396,464,522,576],[0,4,8,12,18,26,36,48,62,80,104,134,174,192],[0,0,0,0,0,0,0],[0,0,0,0,0,0,0]),new ScaleFac([0,6,12,18,24,30,36,44,54,66,80,96,116,140,168,200,238,284,336,396,464,522,576],[0,4,8,12,18,26,36,48,62,80,104,134,174,192],[0,0,0,0,0,0,0],[0,0,0,0,0,0,0]),new ScaleFac([0,12,24,36,48,60,72,88,108,132,160,192,232,280,336,400,476,566,568,570,572,574,576],[0,8,16,24,36,52,72,96,124,160,162,164,166,192],[0,0,0,0,0,0,0],[0,0,0,0,0,0,0])];var pow20=new_float(Q_MAX+Q_MAX2+1),ipow20=new_float(Q_MAX),pow43=new_float(PRECALC_SIZE),adj43=new_float(PRECALC_SIZE);function ATHmdct(gfp,f){var ath=psy.ATHformula(f,gfp);return ath-=100,ath=Math.pow(10,ath/10+gfp.ATHlower)}function StartLine(j){this.s=j}this.adj43=adj43,this.iteration_init=function(gfp){var i,gfc=gfp.internal_flags,l3_side=gfc.l3_side;if(0==gfc.iteration_init_init){for(gfc.iteration_init_init=1,l3_side.main_data_begin=0,function(gfp){for(var ATH_l=gfp.internal_flags.ATH.l,ATH_psfb21=gfp.internal_flags.ATH.psfb21,ATH_s=gfp.internal_flags.ATH.s,ATH_psfb12=gfp.internal_flags.ATH.psfb12,gfc=gfp.internal_flags,samp_freq=gfp.out_samplerate,sfb=0;sfb<Encoder.SBMAX_l;sfb++){var start=gfc.scalefac_band.l[sfb],end=gfc.scalefac_band.l[sfb+1];ATH_l[sfb]=Float.MAX_VALUE;for(var i=start;i<end;i++){var ATH_f=ATHmdct(gfp,i*samp_freq/1152);ATH_l[sfb]=Math.min(ATH_l[sfb],ATH_f)}}for(sfb=0;sfb<Encoder.PSFB21;sfb++)for(start=gfc.scalefac_band.psfb21[sfb],end=gfc.scalefac_band.psfb21[sfb+1],ATH_psfb21[sfb]=Float.MAX_VALUE,i=start;i<end;i++)ATH_f=ATHmdct(gfp,i*samp_freq/1152),ATH_psfb21[sfb]=Math.min(ATH_psfb21[sfb],ATH_f);for(sfb=0;sfb<Encoder.SBMAX_s;sfb++){for(start=gfc.scalefac_band.s[sfb],end=gfc.scalefac_band.s[sfb+1],ATH_s[sfb]=Float.MAX_VALUE,i=start;i<end;i++)ATH_f=ATHmdct(gfp,i*samp_freq/384),ATH_s[sfb]=Math.min(ATH_s[sfb],ATH_f);ATH_s[sfb]*=gfc.scalefac_band.s[sfb+1]-gfc.scalefac_band.s[sfb]}for(sfb=0;sfb<Encoder.PSFB12;sfb++){for(start=gfc.scalefac_band.psfb12[sfb],end=gfc.scalefac_band.psfb12[sfb+1],ATH_psfb12[sfb]=Float.MAX_VALUE,i=start;i<end;i++)ATH_f=ATHmdct(gfp,i*samp_freq/384),ATH_psfb12[sfb]=Math.min(ATH_psfb12[sfb],ATH_f);ATH_psfb12[sfb]*=gfc.scalefac_band.s[13]-gfc.scalefac_band.s[12]}if(gfp.noATH){for(sfb=0;sfb<Encoder.SBMAX_l;sfb++)ATH_l[sfb]=1e-20;for(sfb=0;sfb<Encoder.PSFB21;sfb++)ATH_psfb21[sfb]=1e-20;for(sfb=0;sfb<Encoder.SBMAX_s;sfb++)ATH_s[sfb]=1e-20;for(sfb=0;sfb<Encoder.PSFB12;sfb++)ATH_psfb12[sfb]=1e-20}gfc.ATH.floor=10*Math.log10(ATHmdct(gfp,-1))}(gfp),pow43[0]=0,i=1;i<PRECALC_SIZE;i++)pow43[i]=Math.pow(i,4/3);for(i=0;i<PRECALC_SIZE-1;i++)adj43[i]=i+1-Math.pow(.5*(pow43[i]+pow43[i+1]),.75);for(adj43[i]=.5,i=0;i<Q_MAX;i++)ipow20[i]=Math.pow(2,-.1875*(i-210));for(i=0;i<=Q_MAX+Q_MAX2;i++)pow20[i]=Math.pow(2,.25*(i-210-Q_MAX2));var bass,alto,treble,sfb21;for(tak.huffman_init(gfc),(i=gfp.exp_nspsytune>>2&63)>=32&&(i-=64),bass=Math.pow(10,i/4/10),(i=gfp.exp_nspsytune>>8&63)>=32&&(i-=64),alto=Math.pow(10,i/4/10),(i=gfp.exp_nspsytune>>14&63)>=32&&(i-=64),treble=Math.pow(10,i/4/10),(i=gfp.exp_nspsytune>>20&63)>=32&&(i-=64),sfb21=treble*Math.pow(10,i/4/10),i=0;i<Encoder.SBMAX_l;i++){f=i<=6?bass:i<=13?alto:i<=20?treble:sfb21,gfc.nsPsy.longfact[i]=f}for(i=0;i<Encoder.SBMAX_s;i++){var f;f=i<=5?bass:i<=10?alto:i<=11?treble:sfb21,gfc.nsPsy.shortfact[i]=f}}},this.on_pe=function(gfp,pe,targ_bits,mean_bits,gr,cbr){var bits,ch,gfc=gfp.internal_flags,tbits=0,add_bits=new_int(2),mb=new MeanBits(tbits),extra_bits=rv.ResvMaxBits(gfp,mean_bits,mb,cbr),max_bits=(tbits=mb.bits)+extra_bits;for(max_bits>LameInternalFlags.MAX_BITS_PER_GRANULE&&(max_bits=LameInternalFlags.MAX_BITS_PER_GRANULE),bits=0,ch=0;ch<gfc.channels_out;++ch)targ_bits[ch]=Math.min(LameInternalFlags.MAX_BITS_PER_CHANNEL,tbits/gfc.channels_out),add_bits[ch]=0|targ_bits[ch]*pe[gr][ch]/700-targ_bits[ch],add_bits[ch]>3*mean_bits/4&&(add_bits[ch]=3*mean_bits/4),add_bits[ch]<0&&(add_bits[ch]=0),add_bits[ch]+targ_bits[ch]>LameInternalFlags.MAX_BITS_PER_CHANNEL&&(add_bits[ch]=Math.max(0,LameInternalFlags.MAX_BITS_PER_CHANNEL-targ_bits[ch])),bits+=add_bits[ch];if(bits>extra_bits)for(ch=0;ch<gfc.channels_out;++ch)add_bits[ch]=extra_bits*add_bits[ch]/bits;for(ch=0;ch<gfc.channels_out;++ch)targ_bits[ch]+=add_bits[ch],extra_bits-=add_bits[ch];for(bits=0,ch=0;ch<gfc.channels_out;++ch)bits+=targ_bits[ch];if(bits>LameInternalFlags.MAX_BITS_PER_GRANULE){for(ch=0;ch<gfc.channels_out;++ch)targ_bits[ch]*=LameInternalFlags.MAX_BITS_PER_GRANULE,targ_bits[ch]/=bits,targ_bits[ch]}return max_bits},this.reduce_side=function(targ_bits,ms_ener_ratio,mean_bits,max_bits){var fac=.33*(.5-ms_ener_ratio)/.5;fac<0&&(fac=0),fac>.5&&(fac=.5);var move_bits=0|.5*fac*(targ_bits[0]+targ_bits[1]);move_bits>LameInternalFlags.MAX_BITS_PER_CHANNEL-targ_bits[0]&&(move_bits=LameInternalFlags.MAX_BITS_PER_CHANNEL-targ_bits[0]),move_bits<0&&(move_bits=0),targ_bits[1]>=125&&(targ_bits[1]-move_bits>125?(targ_bits[0]<mean_bits&&(targ_bits[0]+=move_bits),targ_bits[1]-=move_bits):(targ_bits[0]+=targ_bits[1]-125,targ_bits[1]=125)),(move_bits=targ_bits[0]+targ_bits[1])>max_bits&&(targ_bits[0]=max_bits*targ_bits[0]/move_bits,targ_bits[1]=max_bits*targ_bits[1]/move_bits)},this.athAdjust=function(a,x,athFloor){var o=90.30873362,u=Util.FAST_LOG10_X(x,10),v=a*a,w=0;return u-=athFloor,v>1e-20&&(w=1+Util.FAST_LOG10_X(v,10/o)),w<0&&(w=0),u*=w,u+=athFloor+o-94.82444863,Math.pow(10,.1*u)},this.calc_xmin=function(gfp,ratio,cod_info,pxmin){var gsfb,pxminPos=0,gfc=gfp.internal_flags,j=0,ath_over=0,ATH=gfc.ATH,xr=cod_info.xr,enable_athaa_fix=gfp.VBR==VbrMode.vbr_mtrh?1:0,masking_lower=gfc.masking_lower;for(gfp.VBR!=VbrMode.vbr_mtrh&&gfp.VBR!=VbrMode.vbr_mt||(masking_lower=1),gsfb=0;gsfb<cod_info.psy_lmax;gsfb++){rh1=(xmin=gfp.VBR==VbrMode.vbr_rh||gfp.VBR==VbrMode.vbr_mtrh?athAdjust(ATH.adjust,ATH.l[gsfb],ATH.floor):ATH.adjust*ATH.l[gsfb])/(width=cod_info.width[gsfb]),rh2=2220446049250313e-31,l=width>>1,en0=0;do{en0+=xa=xr[j]*xr[j],rh2+=xa<rh1?xa:rh1,en0+=xb=xr[++j]*xr[j],rh2+=xb<rh1?xb:rh1,j++}while(--l>0);if(en0>xmin&&ath_over++,gsfb==Encoder.SBPSY_l)rh2<(x=xmin*gfc.nsPsy.longfact[gsfb])&&(rh2=x);if(0!=enable_athaa_fix&&(xmin=rh2),!gfp.ATHonly)if((e=ratio.en.l[gsfb])>0)x=en0*ratio.thm.l[gsfb]*masking_lower/e,0!=enable_athaa_fix&&(x*=gfc.nsPsy.longfact[gsfb]),xmin<x&&(xmin=x);pxmin[pxminPos++]=0!=enable_athaa_fix?xmin:xmin*gfc.nsPsy.longfact[gsfb]}var max_nonzero=575;if(cod_info.block_type!=Encoder.SHORT_TYPE)for(var k=576;0!=k--&&BitStream.EQ(xr[k],0);)max_nonzero=k;cod_info.max_nonzero_coeff=max_nonzero;for(var sfb=cod_info.sfb_smin;gsfb<cod_info.psymax;sfb++,gsfb+=3){var width,b,tmpATH;for(tmpATH=gfp.VBR==VbrMode.vbr_rh||gfp.VBR==VbrMode.vbr_mtrh?athAdjust(ATH.adjust,ATH.s[sfb],ATH.floor):ATH.adjust*ATH.s[sfb],width=cod_info.width[gsfb],b=0;b<3;b++){var xmin,rh1,rh2,e,x,en0=0,l=width>>1;rh1=tmpATH/width,rh2=2220446049250313e-31;do{var xa,xb;en0+=xa=xr[j]*xr[j],rh2+=xa<rh1?xa:rh1,en0+=xb=xr[++j]*xr[j],rh2+=xb<rh1?xb:rh1,j++}while(--l>0);if(en0>tmpATH&&ath_over++,sfb==Encoder.SBPSY_s)rh2<(x=tmpATH*gfc.nsPsy.shortfact[sfb])&&(rh2=x);if(xmin=0!=enable_athaa_fix?rh2:tmpATH,!gfp.ATHonly&&!gfp.ATHshort)if((e=ratio.en.s[sfb][b])>0)x=en0*ratio.thm.s[sfb][b]*masking_lower/e,0!=enable_athaa_fix&&(x*=gfc.nsPsy.shortfact[sfb]),xmin<x&&(xmin=x);pxmin[pxminPos++]=0!=enable_athaa_fix?xmin:xmin*gfc.nsPsy.shortfact[sfb]}gfp.useTemporal&&(pxmin[pxminPos-3]>pxmin[pxminPos-3+1]&&(pxmin[pxminPos-3+1]+=(pxmin[pxminPos-3]-pxmin[pxminPos-3+1])*gfc.decay),pxmin[pxminPos-3+1]>pxmin[pxminPos-3+2]&&(pxmin[pxminPos-3+2]+=(pxmin[pxminPos-3+1]-pxmin[pxminPos-3+2])*gfc.decay))}return ath_over},this.calc_noise_core=function(cod_info,startline,l,step){var noise=0,j=startline.s,ix=cod_info.l3_enc;if(j>cod_info.count1)for(;0!=l--;){temp=cod_info.xr[j],j++,noise+=temp*temp,temp=cod_info.xr[j],j++,noise+=temp*temp}else if(j>cod_info.big_values){var ix01=new_float(2);for(ix01[0]=0,ix01[1]=step;0!=l--;){temp=Math.abs(cod_info.xr[j])-ix01[ix[j]],j++,noise+=temp*temp,temp=Math.abs(cod_info.xr[j])-ix01[ix[j]],j++,noise+=temp*temp}}else for(;0!=l--;){var temp;temp=Math.abs(cod_info.xr[j])-pow43[ix[j]]*step,j++,noise+=temp*temp,temp=Math.abs(cod_info.xr[j])-pow43[ix[j]]*step,j++,noise+=temp*temp}return startline.s=j,noise},this.calc_noise=function(cod_info,l3_xmin,distort,res,prev_noise){var sfb,l,distortPos=0,l3_xminPos=0,over=0,over_noise_db=0,tot_noise_db=0,max_noise=-20,j=0,scalefac=cod_info.scalefac,scalefacPos=0;for(res.over_SSD=0,sfb=0;sfb<cod_info.psymax;sfb++){var tmp,s=cod_info.global_gain-(scalefac[scalefacPos++]+(0!=cod_info.preflag?pretab[sfb]:0)<<cod_info.scalefac_scale+1)-8*cod_info.subblock_gain[cod_info.window[sfb]],noise=0;if(null!=prev_noise&&prev_noise.step[sfb]==s)noise=prev_noise.noise[sfb],j+=cod_info.width[sfb],distort[distortPos++]=noise/l3_xmin[l3_xminPos++],noise=prev_noise.noise_log[sfb];else{var usefullsize,step=pow20[s+QuantizePVT.Q_MAX2];if(l=cod_info.width[sfb]>>1,j+cod_info.width[sfb]>cod_info.max_nonzero_coeff)l=(usefullsize=cod_info.max_nonzero_coeff-j+1)>0?usefullsize>>1:0;var sl=new StartLine(j);noise=this.calc_noise_core(cod_info,sl,l,step),j=sl.s,null!=prev_noise&&(prev_noise.step[sfb]=s,prev_noise.noise[sfb]=noise),noise=distort[distortPos++]=noise/l3_xmin[l3_xminPos++],noise=Util.FAST_LOG10(Math.max(noise,1e-20)),null!=prev_noise&&(prev_noise.noise_log[sfb]=noise)}if(null!=prev_noise&&(prev_noise.global_gain=cod_info.global_gain),tot_noise_db+=noise,noise>0)tmp=Math.max(0|10*noise+.5,1),res.over_SSD+=tmp*tmp,over++,over_noise_db+=noise;max_noise=Math.max(max_noise,noise)}return res.over_count=over,res.tot_noise=tot_noise_db,res.over_noise=over_noise_db,res.max_noise=max_noise,over},this.set_pinfo=function(gfp,cod_info,ratio,gr,ch){var sfb,sfb2,l,en0,en1,gfc=gfp.internal_flags,ifqstep=0==cod_info.scalefac_scale?.5:1,scalefac=cod_info.scalefac,l3_xmin=new_float(L3Side.SFBMAX),xfsf=new_float(L3Side.SFBMAX),noise=new CalcNoiseResult;calc_xmin(gfp,ratio,cod_info,l3_xmin),calc_noise(cod_info,l3_xmin,xfsf,noise,null);var j=0;for(sfb2=cod_info.sfb_lmax,cod_info.block_type!=Encoder.SHORT_TYPE&&0==cod_info.mixed_block_flag&&(sfb2=22),sfb=0;sfb<sfb2;sfb++){var start=gfc.scalefac_band.l[sfb],bw=(end=gfc.scalefac_band.l[sfb+1])-start;for(en0=0;j<end;j++)en0+=cod_info.xr[j]*cod_info.xr[j];en0/=bw,en1=1e15,gfc.pinfo.en[gr][ch][sfb]=en1*en0,gfc.pinfo.xfsf[gr][ch][sfb]=en1*l3_xmin[sfb]*xfsf[sfb]/bw,ratio.en.l[sfb]>0&&!gfp.ATHonly?en0/=ratio.en.l[sfb]:en0=0,gfc.pinfo.thr[gr][ch][sfb]=en1*Math.max(en0*ratio.thm.l[sfb],gfc.ATH.l[sfb]),gfc.pinfo.LAMEsfb[gr][ch][sfb]=0,0!=cod_info.preflag&&sfb>=11&&(gfc.pinfo.LAMEsfb[gr][ch][sfb]=-ifqstep*pretab[sfb]),sfb<Encoder.SBPSY_l&&(gfc.pinfo.LAMEsfb[gr][ch][sfb]-=ifqstep*scalefac[sfb])}if(cod_info.block_type==Encoder.SHORT_TYPE)for(sfb2=sfb,sfb=cod_info.sfb_smin;sfb<Encoder.SBMAX_s;sfb++){start=gfc.scalefac_band.s[sfb],bw=(end=gfc.scalefac_band.s[sfb+1])-start;for(var end,i=0;i<3;i++){for(en0=0,l=start;l<end;l++)en0+=cod_info.xr[j]*cod_info.xr[j],j++;en0=Math.max(en0/bw,1e-20),en1=1e15,gfc.pinfo.en_s[gr][ch][3*sfb+i]=en1*en0,gfc.pinfo.xfsf_s[gr][ch][3*sfb+i]=en1*l3_xmin[sfb2]*xfsf[sfb2]/bw,ratio.en.s[sfb][i]>0?en0/=ratio.en.s[sfb][i]:en0=0,(gfp.ATHonly||gfp.ATHshort)&&(en0=0),gfc.pinfo.thr_s[gr][ch][3*sfb+i]=en1*Math.max(en0*ratio.thm.s[sfb][i],gfc.ATH.s[sfb]),gfc.pinfo.LAMEsfb_s[gr][ch][3*sfb+i]=-2*cod_info.subblock_gain[i],sfb<Encoder.SBPSY_s&&(gfc.pinfo.LAMEsfb_s[gr][ch][3*sfb+i]-=ifqstep*scalefac[sfb2]),sfb2++}}gfc.pinfo.LAMEqss[gr][ch]=cod_info.global_gain,gfc.pinfo.LAMEmainbits[gr][ch]=cod_info.part2_3_length+cod_info.part2_length,gfc.pinfo.LAMEsfbits[gr][ch]=cod_info.part2_length,gfc.pinfo.over[gr][ch]=noise.over_count,gfc.pinfo.max_noise[gr][ch]=10*noise.max_noise,gfc.pinfo.over_noise[gr][ch]=10*noise.over_noise,gfc.pinfo.tot_noise[gr][ch]=10*noise.tot_noise,gfc.pinfo.over_SSD[gr][ch]=noise.over_SSD}}function CalcNoiseData(){this.global_gain=0,this.sfb_count1=0,this.step=new_int(39),this.noise=new_float(39),this.noise_log=new_float(39)}function GrInfo(){this.xr=new_float(576),this.l3_enc=new_int(576),this.scalefac=new_int(L3Side.SFBMAX),this.xrpow_max=0,this.part2_3_length=0,this.big_values=0,this.count1=0,this.global_gain=0,this.scalefac_compress=0,this.block_type=0,this.mixed_block_flag=0,this.table_select=new_int(3),this.subblock_gain=new_int(4),this.region0_count=0,this.region1_count=0,this.preflag=0,this.scalefac_scale=0,this.count1table_select=0,this.part2_length=0,this.sfb_lmax=0,this.sfb_smin=0,this.psy_lmax=0,this.sfbmax=0,this.psymax=0,this.sfbdivide=0,this.width=new_int(L3Side.SFBMAX),this.window=new_int(L3Side.SFBMAX),this.count1bits=0,this.sfb_partition_table=null,this.slen=new_int(4),this.max_nonzero_coeff=0;var self=this;function clone_int(array){return new Int32Array(array)}this.assign=function(other){var array;self.xr=(array=other.xr,new Float32Array(array)),self.l3_enc=clone_int(other.l3_enc),self.scalefac=clone_int(other.scalefac),self.xrpow_max=other.xrpow_max,self.part2_3_length=other.part2_3_length,self.big_values=other.big_values,self.count1=other.count1,self.global_gain=other.global_gain,self.scalefac_compress=other.scalefac_compress,self.block_type=other.block_type,self.mixed_block_flag=other.mixed_block_flag,self.table_select=clone_int(other.table_select),self.subblock_gain=clone_int(other.subblock_gain),self.region0_count=other.region0_count,self.region1_count=other.region1_count,self.preflag=other.preflag,self.scalefac_scale=other.scalefac_scale,self.count1table_select=other.count1table_select,self.part2_length=other.part2_length,self.sfb_lmax=other.sfb_lmax,self.sfb_smin=other.sfb_smin,self.psy_lmax=other.psy_lmax,self.sfbmax=other.sfbmax,self.psymax=other.psymax,self.sfbdivide=other.sfbdivide,self.width=clone_int(other.width),self.window=clone_int(other.window),self.count1bits=other.count1bits,self.sfb_partition_table=other.sfb_partition_table.slice(0),self.slen=clone_int(other.slen),self.max_nonzero_coeff=other.max_nonzero_coeff}}Tables.t1HB=[1,1,1,0],Tables.t2HB=[1,2,1,3,1,1,3,2,0],Tables.t3HB=[3,2,1,1,1,1,3,2,0],Tables.t5HB=[1,2,6,5,3,1,4,4,7,5,7,1,6,1,1,0],Tables.t6HB=[7,3,5,1,6,2,3,2,5,4,4,1,3,3,2,0],Tables.t7HB=[1,2,10,19,16,10,3,3,7,10,5,3,11,4,13,17,8,4,12,11,18,15,11,2,7,6,9,14,3,1,6,4,5,3,2,0],Tables.t8HB=[3,4,6,18,12,5,5,1,2,16,9,3,7,3,5,14,7,3,19,17,15,13,10,4,13,5,8,11,5,1,12,4,4,1,1,0],Tables.t9HB=[7,5,9,14,15,7,6,4,5,5,6,7,7,6,8,8,8,5,15,6,9,10,5,1,11,7,9,6,4,1,14,4,6,2,6,0],Tables.t10HB=[1,2,10,23,35,30,12,17,3,3,8,12,18,21,12,7,11,9,15,21,32,40,19,6,14,13,22,34,46,23,18,7,20,19,33,47,27,22,9,3,31,22,41,26,21,20,5,3,14,13,10,11,16,6,5,1,9,8,7,8,4,4,2,0],Tables.t11HB=[3,4,10,24,34,33,21,15,5,3,4,10,32,17,11,10,11,7,13,18,30,31,20,5,25,11,19,59,27,18,12,5,35,33,31,58,30,16,7,5,28,26,32,19,17,15,8,14,14,12,9,13,14,9,4,1,11,4,6,6,6,3,2,0],Tables.t12HB=[9,6,16,33,41,39,38,26,7,5,6,9,23,16,26,11,17,7,11,14,21,30,10,7,17,10,15,12,18,28,14,5,32,13,22,19,18,16,9,5,40,17,31,29,17,13,4,2,27,12,11,15,10,7,4,1,27,12,8,12,6,3,1,0],Tables.t13HB=[1,5,14,21,34,51,46,71,42,52,68,52,67,44,43,19,3,4,12,19,31,26,44,33,31,24,32,24,31,35,22,14,15,13,23,36,59,49,77,65,29,40,30,40,27,33,42,16,22,20,37,61,56,79,73,64,43,76,56,37,26,31,25,14,35,16,60,57,97,75,114,91,54,73,55,41,48,53,23,24,58,27,50,96,76,70,93,84,77,58,79,29,74,49,41,17,47,45,78,74,115,94,90,79,69,83,71,50,59,38,36,15,72,34,56,95,92,85,91,90,86,73,77,65,51,44,43,42,43,20,30,44,55,78,72,87,78,61,46,54,37,30,20,16,53,25,41,37,44,59,54,81,66,76,57,54,37,18,39,11,35,33,31,57,42,82,72,80,47,58,55,21,22,26,38,22,53,25,23,38,70,60,51,36,55,26,34,23,27,14,9,7,34,32,28,39,49,75,30,52,48,40,52,28,18,17,9,5,45,21,34,64,56,50,49,45,31,19,12,15,10,7,6,3,48,23,20,39,36,35,53,21,16,23,13,10,6,1,4,2,16,15,17,27,25,20,29,11,17,12,16,8,1,1,0,1],Tables.t15HB=[7,12,18,53,47,76,124,108,89,123,108,119,107,81,122,63,13,5,16,27,46,36,61,51,42,70,52,83,65,41,59,36,19,17,15,24,41,34,59,48,40,64,50,78,62,80,56,33,29,28,25,43,39,63,55,93,76,59,93,72,54,75,50,29,52,22,42,40,67,57,95,79,72,57,89,69,49,66,46,27,77,37,35,66,58,52,91,74,62,48,79,63,90,62,40,38,125,32,60,56,50,92,78,65,55,87,71,51,73,51,70,30,109,53,49,94,88,75,66,122,91,73,56,42,64,44,21,25,90,43,41,77,73,63,56,92,77,66,47,67,48,53,36,20,71,34,67,60,58,49,88,76,67,106,71,54,38,39,23,15,109,53,51,47,90,82,58,57,48,72,57,41,23,27,62,9,86,42,40,37,70,64,52,43,70,55,42,25,29,18,11,11,118,68,30,55,50,46,74,65,49,39,24,16,22,13,14,7,91,44,39,38,34,63,52,45,31,52,28,19,14,8,9,3,123,60,58,53,47,43,32,22,37,24,17,12,15,10,2,1,71,37,34,30,28,20,17,26,21,16,10,6,8,6,2,0],Tables.t16HB=[1,5,14,44,74,63,110,93,172,149,138,242,225,195,376,17,3,4,12,20,35,62,53,47,83,75,68,119,201,107,207,9,15,13,23,38,67,58,103,90,161,72,127,117,110,209,206,16,45,21,39,69,64,114,99,87,158,140,252,212,199,387,365,26,75,36,68,65,115,101,179,164,155,264,246,226,395,382,362,9,66,30,59,56,102,185,173,265,142,253,232,400,388,378,445,16,111,54,52,100,184,178,160,133,257,244,228,217,385,366,715,10,98,48,91,88,165,157,148,261,248,407,397,372,380,889,884,8,85,84,81,159,156,143,260,249,427,401,392,383,727,713,708,7,154,76,73,141,131,256,245,426,406,394,384,735,359,710,352,11,139,129,67,125,247,233,229,219,393,743,737,720,885,882,439,4,243,120,118,115,227,223,396,746,742,736,721,712,706,223,436,6,202,224,222,218,216,389,386,381,364,888,443,707,440,437,1728,4,747,211,210,208,370,379,734,723,714,1735,883,877,876,3459,865,2,377,369,102,187,726,722,358,711,709,866,1734,871,3458,870,434,0,12,10,7,11,10,17,11,9,13,12,10,7,5,3,1,3],Tables.t24HB=[15,13,46,80,146,262,248,434,426,669,653,649,621,517,1032,88,14,12,21,38,71,130,122,216,209,198,327,345,319,297,279,42,47,22,41,74,68,128,120,221,207,194,182,340,315,295,541,18,81,39,75,70,134,125,116,220,204,190,178,325,311,293,271,16,147,72,69,135,127,118,112,210,200,188,352,323,306,285,540,14,263,66,129,126,119,114,214,202,192,180,341,317,301,281,262,12,249,123,121,117,113,215,206,195,185,347,330,308,291,272,520,10,435,115,111,109,211,203,196,187,353,332,313,298,283,531,381,17,427,212,208,205,201,193,186,177,169,320,303,286,268,514,377,16,335,199,197,191,189,181,174,333,321,305,289,275,521,379,371,11,668,184,183,179,175,344,331,314,304,290,277,530,383,373,366,10,652,346,171,168,164,318,309,299,287,276,263,513,375,368,362,6,648,322,316,312,307,302,292,284,269,261,512,376,370,364,359,4,620,300,296,294,288,282,273,266,515,380,374,369,365,361,357,2,1033,280,278,274,267,264,259,382,378,372,367,363,360,358,356,0,43,20,19,17,15,13,11,9,7,6,4,7,5,3,1,3],Tables.t32HB=[1,10,8,20,12,20,16,32,14,12,24,0,28,16,24,16],Tables.t33HB=[15,28,26,48,22,40,36,64,14,24,20,32,12,16,8,0],Tables.t1l=[1,4,3,5],Tables.t2l=[1,4,7,4,5,7,6,7,8],Tables.t3l=[2,3,7,4,4,7,6,7,8],Tables.t5l=[1,4,7,8,4,5,8,9,7,8,9,10,8,8,9,10],Tables.t6l=[3,4,6,8,4,4,6,7,5,6,7,8,7,7,8,9],Tables.t7l=[1,4,7,9,9,10,4,6,8,9,9,10,7,7,9,10,10,11,8,9,10,11,11,11,8,9,10,11,11,12,9,10,11,12,12,12],Tables.t8l=[2,4,7,9,9,10,4,4,6,10,10,10,7,6,8,10,10,11,9,10,10,11,11,12,9,9,10,11,12,12,10,10,11,11,13,13],Tables.t9l=[3,4,6,7,9,10,4,5,6,7,8,10,5,6,7,8,9,10,7,7,8,9,9,10,8,8,9,9,10,11,9,9,10,10,11,11],Tables.t10l=[1,4,7,9,10,10,10,11,4,6,8,9,10,11,10,10,7,8,9,10,11,12,11,11,8,9,10,11,12,12,11,12,9,10,11,12,12,12,12,12,10,11,12,12,13,13,12,13,9,10,11,12,12,12,13,13,10,10,11,12,12,13,13,13],Tables.t11l=[2,4,6,8,9,10,9,10,4,5,6,8,10,10,9,10,6,7,8,9,10,11,10,10,8,8,9,11,10,12,10,11,9,10,10,11,11,12,11,12,9,10,11,12,12,13,12,13,9,9,9,10,11,12,12,12,9,9,10,11,12,12,12,12],Tables.t12l=[4,4,6,8,9,10,10,10,4,5,6,7,9,9,10,10,6,6,7,8,9,10,9,10,7,7,8,8,9,10,10,10,8,8,9,9,10,10,10,11,9,9,10,10,10,11,10,11,9,9,9,10,10,11,11,12,10,10,10,11,11,11,11,12],Tables.t13l=[1,5,7,8,9,10,10,11,10,11,12,12,13,13,14,14,4,6,8,9,10,10,11,11,11,11,12,12,13,14,14,14,7,8,9,10,11,11,12,12,11,12,12,13,13,14,15,15,8,9,10,11,11,12,12,12,12,13,13,13,13,14,15,15,9,9,11,11,12,12,13,13,12,13,13,14,14,15,15,16,10,10,11,12,12,12,13,13,13,13,14,13,15,15,16,16,10,11,12,12,13,13,13,13,13,14,14,14,15,15,16,16,11,11,12,13,13,13,14,14,14,14,15,15,15,16,18,18,10,10,11,12,12,13,13,14,14,14,14,15,15,16,17,17,11,11,12,12,13,13,13,15,14,15,15,16,16,16,18,17,11,12,12,13,13,14,14,15,14,15,16,15,16,17,18,19,12,12,12,13,14,14,14,14,15,15,15,16,17,17,17,18,12,13,13,14,14,15,14,15,16,16,17,17,17,18,18,18,13,13,14,15,15,15,16,16,16,16,16,17,18,17,18,18,14,14,14,15,15,15,17,16,16,19,17,17,17,19,18,18,13,14,15,16,16,16,17,16,17,17,18,18,21,20,21,18],Tables.t15l=[3,5,6,8,8,9,10,10,10,11,11,12,12,12,13,14,5,5,7,8,9,9,10,10,10,11,11,12,12,12,13,13,6,7,7,8,9,9,10,10,10,11,11,12,12,13,13,13,7,8,8,9,9,10,10,11,11,11,12,12,12,13,13,13,8,8,9,9,10,10,11,11,11,11,12,12,12,13,13,13,9,9,9,10,10,10,11,11,11,11,12,12,13,13,13,14,10,9,10,10,10,11,11,11,11,12,12,12,13,13,14,14,10,10,10,11,11,11,11,12,12,12,12,12,13,13,13,14,10,10,10,11,11,11,11,12,12,12,12,13,13,14,14,14,10,10,11,11,11,11,12,12,12,13,13,13,13,14,14,14,11,11,11,11,12,12,12,12,12,13,13,13,13,14,15,14,11,11,11,11,12,12,12,12,13,13,13,13,14,14,14,15,12,12,11,12,12,12,13,13,13,13,13,13,14,14,15,15,12,12,12,12,12,13,13,13,13,14,14,14,14,14,15,15,13,13,13,13,13,13,13,13,14,14,14,14,15,15,14,15,13,13,13,13,13,13,13,14,14,14,14,14,15,15,15,15],Tables.t16_5l=[1,5,7,9,10,10,11,11,12,12,12,13,13,13,14,11,4,6,8,9,10,11,11,11,12,12,12,13,14,13,14,11,7,8,9,10,11,11,12,12,13,12,13,13,13,14,14,12,9,9,10,11,11,12,12,12,13,13,14,14,14,15,15,13,10,10,11,11,12,12,13,13,13,14,14,14,15,15,15,12,10,10,11,11,12,13,13,14,13,14,14,15,15,15,16,13,11,11,11,12,13,13,13,13,14,14,14,14,15,15,16,13,11,11,12,12,13,13,13,14,14,15,15,15,15,17,17,13,11,12,12,13,13,13,14,14,15,15,15,15,16,16,16,13,12,12,12,13,13,14,14,15,15,15,15,16,15,16,15,14,12,13,12,13,14,14,14,14,15,16,16,16,17,17,16,13,13,13,13,13,14,14,15,16,16,16,16,16,16,15,16,14,13,14,14,14,14,15,15,15,15,17,16,16,16,16,18,14,15,14,14,14,15,15,16,16,16,18,17,17,17,19,17,14,14,15,13,14,16,16,15,16,16,17,18,17,19,17,16,14,11,11,11,12,12,13,13,13,14,14,14,14,14,14,14,12],Tables.t16l=[1,5,7,9,10,10,11,11,12,12,12,13,13,13,14,10,4,6,8,9,10,11,11,11,12,12,12,13,14,13,14,10,7,8,9,10,11,11,12,12,13,12,13,13,13,14,14,11,9,9,10,11,11,12,12,12,13,13,14,14,14,15,15,12,10,10,11,11,12,12,13,13,13,14,14,14,15,15,15,11,10,10,11,11,12,13,13,14,13,14,14,15,15,15,16,12,11,11,11,12,13,13,13,13,14,14,14,14,15,15,16,12,11,11,12,12,13,13,13,14,14,15,15,15,15,17,17,12,11,12,12,13,13,13,14,14,15,15,15,15,16,16,16,12,12,12,12,13,13,14,14,15,15,15,15,16,15,16,15,13,12,13,12,13,14,14,14,14,15,16,16,16,17,17,16,12,13,13,13,13,14,14,15,16,16,16,16,16,16,15,16,13,13,14,14,14,14,15,15,15,15,17,16,16,16,16,18,13,15,14,14,14,15,15,16,16,16,18,17,17,17,19,17,13,14,15,13,14,16,16,15,16,16,17,18,17,19,17,16,13,10,10,10,11,11,12,12,12,13,13,13,13,13,13,13,10],Tables.t24l=[4,5,7,8,9,10,10,11,11,12,12,12,12,12,13,10,5,6,7,8,9,10,10,11,11,11,12,12,12,12,12,10,7,7,8,9,9,10,10,11,11,11,11,12,12,12,13,9,8,8,9,9,10,10,10,11,11,11,11,12,12,12,12,9,9,9,9,10,10,10,10,11,11,11,12,12,12,12,13,9,10,9,10,10,10,10,11,11,11,11,12,12,12,12,12,9,10,10,10,10,10,11,11,11,11,12,12,12,12,12,13,9,11,10,10,10,11,11,11,11,12,12,12,12,12,13,13,10,11,11,11,11,11,11,11,11,11,12,12,12,12,13,13,10,11,11,11,11,11,11,11,12,12,12,12,12,13,13,13,10,12,11,11,11,11,12,12,12,12,12,12,13,13,13,13,10,12,12,11,11,11,12,12,12,12,12,12,13,13,13,13,10,12,12,12,12,12,12,12,12,12,12,13,13,13,13,13,10,12,12,12,12,12,12,12,12,13,13,13,13,13,13,13,10,13,12,12,12,12,12,12,13,13,13,13,13,13,13,13,10,9,9,9,9,9,9,9,9,9,9,9,10,10,10,10,6],Tables.t32l=[1,5,5,7,5,8,7,9,5,7,7,9,7,9,9,10],Tables.t33l=[4,5,5,6,5,6,6,7,5,6,6,7,6,7,7,8],Tables.ht=[new HuffCodeTab(0,0,null,null),new HuffCodeTab(2,0,Tables.t1HB,Tables.t1l),new HuffCodeTab(3,0,Tables.t2HB,Tables.t2l),new HuffCodeTab(3,0,Tables.t3HB,Tables.t3l),new HuffCodeTab(0,0,null,null),new HuffCodeTab(4,0,Tables.t5HB,Tables.t5l),new HuffCodeTab(4,0,Tables.t6HB,Tables.t6l),new HuffCodeTab(6,0,Tables.t7HB,Tables.t7l),new HuffCodeTab(6,0,Tables.t8HB,Tables.t8l),new HuffCodeTab(6,0,Tables.t9HB,Tables.t9l),new HuffCodeTab(8,0,Tables.t10HB,Tables.t10l),new HuffCodeTab(8,0,Tables.t11HB,Tables.t11l),new HuffCodeTab(8,0,Tables.t12HB,Tables.t12l),new HuffCodeTab(16,0,Tables.t13HB,Tables.t13l),new HuffCodeTab(0,0,null,Tables.t16_5l),new HuffCodeTab(16,0,Tables.t15HB,Tables.t15l),new HuffCodeTab(1,1,Tables.t16HB,Tables.t16l),new HuffCodeTab(2,3,Tables.t16HB,Tables.t16l),new HuffCodeTab(3,7,Tables.t16HB,Tables.t16l),new HuffCodeTab(4,15,Tables.t16HB,Tables.t16l),new HuffCodeTab(6,63,Tables.t16HB,Tables.t16l),new HuffCodeTab(8,255,Tables.t16HB,Tables.t16l),new HuffCodeTab(10,1023,Tables.t16HB,Tables.t16l),new HuffCodeTab(13,8191,Tables.t16HB,Tables.t16l),new HuffCodeTab(4,15,Tables.t24HB,Tables.t24l),new HuffCodeTab(5,31,Tables.t24HB,Tables.t24l),new HuffCodeTab(6,63,Tables.t24HB,Tables.t24l),new HuffCodeTab(7,127,Tables.t24HB,Tables.t24l),new HuffCodeTab(8,255,Tables.t24HB,Tables.t24l),new HuffCodeTab(9,511,Tables.t24HB,Tables.t24l),new HuffCodeTab(11,2047,Tables.t24HB,Tables.t24l),new HuffCodeTab(13,8191,Tables.t24HB,Tables.t24l),new HuffCodeTab(0,0,Tables.t32HB,Tables.t32l),new HuffCodeTab(0,0,Tables.t33HB,Tables.t33l)],Tables.largetbl=[65540,327685,458759,589832,655369,655370,720906,720907,786443,786444,786444,851980,851980,851980,917517,655370,262149,393222,524295,589832,655369,720906,720906,720907,786443,786443,786444,851980,917516,851980,917516,655370,458759,524295,589832,655369,720905,720906,786442,786443,851979,786443,851979,851980,851980,917516,917517,720905,589832,589832,655369,720905,720906,786442,786442,786443,851979,851979,917515,917516,917516,983052,983052,786441,655369,655369,720905,720906,786442,786442,851978,851979,851979,917515,917516,917516,983052,983052,983053,720905,655370,655369,720906,720906,786442,851978,851979,917515,851979,917515,917516,983052,983052,983052,1048588,786441,720906,720906,720906,786442,851978,851979,851979,851979,917515,917516,917516,917516,983052,983052,1048589,786441,720907,720906,786442,786442,851979,851979,851979,917515,917516,983052,983052,983052,983052,1114125,1114125,786442,720907,786443,786443,851979,851979,851979,917515,917515,983051,983052,983052,983052,1048588,1048589,1048589,786442,786443,786443,786443,851979,851979,917515,917515,983052,983052,983052,983052,1048588,983053,1048589,983053,851978,786444,851979,786443,851979,917515,917516,917516,917516,983052,1048588,1048588,1048589,1114125,1114125,1048589,786442,851980,851980,851979,851979,917515,917516,983052,1048588,1048588,1048588,1048588,1048589,1048589,983053,1048589,851978,851980,917516,917516,917516,917516,983052,983052,983052,983052,1114124,1048589,1048589,1048589,1048589,1179661,851978,983052,917516,917516,917516,983052,983052,1048588,1048588,1048589,1179661,1114125,1114125,1114125,1245197,1114125,851978,917517,983052,851980,917516,1048588,1048588,983052,1048589,1048589,1114125,1179661,1114125,1245197,1114125,1048589,851978,655369,655369,655369,720905,720905,786441,786441,786441,851977,851977,851977,851978,851978,851978,851978,655366],Tables.table23=[65538,262147,458759,262148,327684,458759,393222,458759,524296],Tables.table56=[65539,262148,458758,524296,262148,327684,524294,589831,458757,524294,589831,655368,524295,524295,589832,655369],Tables.bitrate_table=[[0,8,16,24,32,40,48,56,64,80,96,112,128,144,160,-1],[0,32,40,48,56,64,80,96,112,128,160,192,224,256,320,-1],[0,8,16,24,32,40,48,56,64,-1,-1,-1,-1,-1,-1,-1]],Tables.samplerate_table=[[22050,24e3,16e3,-1],[44100,48e3,32e3,-1],[11025,12e3,8e3,-1]],Tables.scfsi_band=[0,6,11,16,21],QuantizePVT.Q_MAX=257,QuantizePVT.Q_MAX2=116,QuantizePVT.LARGE_BITS=1e5,QuantizePVT.IXMAX_VAL=8206;var L3Side={};function Quantize(){var bs,rv,qupvt;this.rv=null,this.qupvt=null;var tk,vbr=new VBRQuantize;function BinSearchDirection(ordinal){this.ordinal=ordinal}function loop_break(cod_info){for(var sfb=0;sfb<cod_info.sfbmax;sfb++)if(cod_info.scalefac[sfb]+cod_info.subblock_gain[cod_info.window[sfb]]==0)return!1;return!0}function quant_compare(quant_comp,best,calc,gi,distort){var better;switch(quant_comp){default:case 9:best.over_count>0?(better=calc.over_SSD<=best.over_SSD,calc.over_SSD==best.over_SSD&&(better=calc.bits<best.bits)):better=calc.max_noise<0&&10*calc.max_noise+calc.bits<=10*best.max_noise+best.bits;break;case 0:better=calc.over_count<best.over_count||calc.over_count==best.over_count&&calc.over_noise<best.over_noise||calc.over_count==best.over_count&&BitStream.EQ(calc.over_noise,best.over_noise)&&calc.tot_noise<best.tot_noise;break;case 8:calc.max_noise=function(distort,gi){for(var noise,klemm_noise=1e-37,sfb=0;sfb<gi.psymax;sfb++)klemm_noise+=(noise=distort[sfb],Util.FAST_LOG10(.368+.632*noise*noise*noise));return Math.max(1e-20,klemm_noise)}(distort,gi);case 1:better=calc.max_noise<best.max_noise;break;case 2:better=calc.tot_noise<best.tot_noise;break;case 3:better=calc.tot_noise<best.tot_noise&&calc.max_noise<best.max_noise;break;case 4:better=calc.max_noise<=0&&best.max_noise>.2||calc.max_noise<=0&&best.max_noise<0&&best.max_noise>calc.max_noise-.2&&calc.tot_noise<best.tot_noise||calc.max_noise<=0&&best.max_noise>0&&best.max_noise>calc.max_noise-.2&&calc.tot_noise<best.tot_noise+best.over_noise||calc.max_noise>0&&best.max_noise>-.05&&best.max_noise>calc.max_noise-.1&&calc.tot_noise+calc.over_noise<best.tot_noise+best.over_noise||calc.max_noise>0&&best.max_noise>-.1&&best.max_noise>calc.max_noise-.15&&calc.tot_noise+calc.over_noise+calc.over_noise<best.tot_noise+best.over_noise+best.over_noise;break;case 5:better=calc.over_noise<best.over_noise||BitStream.EQ(calc.over_noise,best.over_noise)&&calc.tot_noise<best.tot_noise;break;case 6:better=calc.over_noise<best.over_noise||BitStream.EQ(calc.over_noise,best.over_noise)&&(calc.max_noise<best.max_noise||BitStream.EQ(calc.max_noise,best.max_noise)&&calc.tot_noise<=best.tot_noise);break;case 7:better=calc.over_count<best.over_count||calc.over_noise<best.over_noise}return 0==best.over_count&&(better=better&&calc.bits<best.bits),better}function balance_noise(gfp,cod_info,distort,xrpow,bRefine){var gfc=gfp.internal_flags;!function(gfp,cod_info,distort,xrpow,bRefine){var ifqstep34,gfc=gfp.internal_flags;ifqstep34=0==cod_info.scalefac_scale?1.2968395546510096:1.6817928305074292;for(var trigger=0,sfb=0;sfb<cod_info.sfbmax;sfb++)trigger<distort[sfb]&&(trigger=distort[sfb]);var noise_shaping_amp=gfc.noise_shaping_amp;switch(3==noise_shaping_amp&&(noise_shaping_amp=bRefine?2:1),noise_shaping_amp){case 2:break;case 1:trigger>1?trigger=Math.pow(trigger,.5):trigger*=.95;break;default:trigger>1?trigger=1:trigger*=.95}var j=0;for(sfb=0;sfb<cod_info.sfbmax;sfb++){var l,width=cod_info.width[sfb];if(j+=width,!(distort[sfb]<trigger)){if(0!=(2&gfc.substep_shaping)&&(gfc.pseudohalf[sfb]=0==gfc.pseudohalf[sfb]?1:0,0==gfc.pseudohalf[sfb]&&2==gfc.noise_shaping_amp))return;for(cod_info.scalefac[sfb]++,l=-width;l<0;l++)xrpow[j+l]*=ifqstep34,xrpow[j+l]>cod_info.xrpow_max&&(cod_info.xrpow_max=xrpow[j+l]);if(2==gfc.noise_shaping_amp)return}}}(gfp,cod_info,distort,xrpow,bRefine);var status=loop_break(cod_info);return!status&&(!(status=2==gfc.mode_gr?tk.scale_bitcount(cod_info):tk.scale_bitcount_lsf(gfc,cod_info))||(gfc.noise_shaping>1&&(Arrays.fill(gfc.pseudohalf,0),0==cod_info.scalefac_scale?(!function(cod_info,xrpow){for(var j=0,sfb=0;sfb<cod_info.sfbmax;sfb++){var width=cod_info.width[sfb],s=cod_info.scalefac[sfb];if(0!=cod_info.preflag&&(s+=qupvt.pretab[sfb]),j+=width,0!=(1&s)){s++;for(var l=-width;l<0;l++)xrpow[j+l]*=1.2968395546510096,xrpow[j+l]>cod_info.xrpow_max&&(cod_info.xrpow_max=xrpow[j+l])}cod_info.scalefac[sfb]=s>>1}cod_info.preflag=0,cod_info.scalefac_scale=1}(cod_info,xrpow),status=!1):cod_info.block_type==Encoder.SHORT_TYPE&&gfc.subblock_gain>0&&(status=function(gfc,cod_info,xrpow){var sfb,scalefac=cod_info.scalefac;for(sfb=0;sfb<cod_info.sfb_lmax;sfb++)if(scalefac[sfb]>=16)return!0;for(var window=0;window<3;window++){var s1=0,s2=0;for(sfb=cod_info.sfb_lmax+window;sfb<cod_info.sfbdivide;sfb+=3)s1<scalefac[sfb]&&(s1=scalefac[sfb]);for(;sfb<cod_info.sfbmax;sfb+=3)s2<scalefac[sfb]&&(s2=scalefac[sfb]);if(!(s1<16&&s2<8)){if(cod_info.subblock_gain[window]>=7)return!0;cod_info.subblock_gain[window]++;var j=gfc.scalefac_band.l[cod_info.sfb_lmax];for(sfb=cod_info.sfb_lmax+window;sfb<cod_info.sfbmax;sfb+=3){var width=cod_info.width[sfb],s=scalefac[sfb];if((s-=4>>cod_info.scalefac_scale)>=0)scalefac[sfb]=s,j+=3*width;else{scalefac[sfb]=0;var gain=210+(s<<cod_info.scalefac_scale+1);amp=qupvt.IPOW20(gain),j+=width*(window+1);for(var l=-width;l<0;l++)xrpow[j+l]*=amp,xrpow[j+l]>cod_info.xrpow_max&&(cod_info.xrpow_max=xrpow[j+l]);j+=width*(3-window-1)}}var amp=qupvt.IPOW20(202);for(j+=cod_info.width[sfb]*(window+1),l=-cod_info.width[sfb];l<0;l++)xrpow[j+l]*=amp,xrpow[j+l]>cod_info.xrpow_max&&(cod_info.xrpow_max=xrpow[j+l])}}return!1}(gfc,cod_info,xrpow)||loop_break(cod_info))),status||(status=2==gfc.mode_gr?tk.scale_bitcount(cod_info):tk.scale_bitcount_lsf(gfc,cod_info)),!status))}this.setModules=function(_bs,_rv,_qupvt,_tk){bs=_bs,rv=_rv,this.rv=_rv,qupvt=_qupvt,this.qupvt=_qupvt,tk=_tk,vbr.setModules(qupvt,tk)},this.ms_convert=function(l3_side,gr){for(var i=0;i<576;++i){var l=l3_side.tt[gr][0].xr[i],r=l3_side.tt[gr][1].xr[i];l3_side.tt[gr][0].xr[i]=(l+r)*(.5*Util.SQRT2),l3_side.tt[gr][1].xr[i]=(l-r)*(.5*Util.SQRT2)}},this.init_xrpow=function(gfc,cod_info,xrpow){var sum=0,upper=0|cod_info.max_nonzero_coeff;if(cod_info.xrpow_max=0,Arrays.fill(xrpow,upper,576,0),sum=function(cod_info,xrpow,upper,sum){sum=0;for(var i=0;i<=upper;++i){var tmp=Math.abs(cod_info.xr[i]);sum+=tmp,xrpow[i]=Math.sqrt(tmp*Math.sqrt(tmp)),xrpow[i]>cod_info.xrpow_max&&(cod_info.xrpow_max=xrpow[i])}return sum}(cod_info,xrpow,upper,sum),sum>1e-20){var j=0;0!=(2&gfc.substep_shaping)&&(j=1);for(var i=0;i<cod_info.psymax;i++)gfc.pseudohalf[i]=j;return!0}return Arrays.fill(cod_info.l3_enc,0,576,0),!1},this.init_outer_loop=function(gfc,cod_info){cod_info.part2_3_length=0,cod_info.big_values=0,cod_info.count1=0,cod_info.global_gain=210,cod_info.scalefac_compress=0,cod_info.table_select[0]=0,cod_info.table_select[1]=0,cod_info.table_select[2]=0,cod_info.subblock_gain[0]=0,cod_info.subblock_gain[1]=0,cod_info.subblock_gain[2]=0,cod_info.subblock_gain[3]=0,cod_info.region0_count=0,cod_info.region1_count=0,cod_info.preflag=0,cod_info.scalefac_scale=0,cod_info.count1table_select=0,cod_info.part2_length=0,cod_info.sfb_lmax=Encoder.SBPSY_l,cod_info.sfb_smin=Encoder.SBPSY_s,cod_info.psy_lmax=gfc.sfb21_extra?Encoder.SBMAX_l:Encoder.SBPSY_l,cod_info.psymax=cod_info.psy_lmax,cod_info.sfbmax=cod_info.sfb_lmax,cod_info.sfbdivide=11;for(var sfb=0;sfb<Encoder.SBMAX_l;sfb++)cod_info.width[sfb]=gfc.scalefac_band.l[sfb+1]-gfc.scalefac_band.l[sfb],cod_info.window[sfb]=3;if(cod_info.block_type==Encoder.SHORT_TYPE){var ixwork=new_float(576);cod_info.sfb_smin=0,cod_info.sfb_lmax=0,0!=cod_info.mixed_block_flag&&(cod_info.sfb_smin=3,cod_info.sfb_lmax=2*gfc.mode_gr+4),cod_info.psymax=cod_info.sfb_lmax+3*((gfc.sfb21_extra?Encoder.SBMAX_s:Encoder.SBPSY_s)-cod_info.sfb_smin),cod_info.sfbmax=cod_info.sfb_lmax+3*(Encoder.SBPSY_s-cod_info.sfb_smin),cod_info.sfbdivide=cod_info.sfbmax-18,cod_info.psy_lmax=cod_info.sfb_lmax;var ix=gfc.scalefac_band.l[cod_info.sfb_lmax];System.arraycopy(cod_info.xr,0,ixwork,0,576);for(sfb=cod_info.sfb_smin;sfb<Encoder.SBMAX_s;sfb++)for(var start=gfc.scalefac_band.s[sfb],end=gfc.scalefac_band.s[sfb+1],window=0;window<3;window++)for(var l=start;l<end;l++)cod_info.xr[ix++]=ixwork[3*l+window];var j=cod_info.sfb_lmax;for(sfb=cod_info.sfb_smin;sfb<Encoder.SBMAX_s;sfb++)cod_info.width[j]=cod_info.width[j+1]=cod_info.width[j+2]=gfc.scalefac_band.s[sfb+1]-gfc.scalefac_band.s[sfb],cod_info.window[j]=0,cod_info.window[j+1]=1,cod_info.window[j+2]=2,j+=3}cod_info.count1bits=0,cod_info.sfb_partition_table=qupvt.nr_of_sfb_block[0][0],cod_info.slen[0]=0,cod_info.slen[1]=0,cod_info.slen[2]=0,cod_info.slen[3]=0,cod_info.max_nonzero_coeff=575,Arrays.fill(cod_info.scalefac,0),function(gfc,cod_info){var ath=gfc.ATH,xr=cod_info.xr;if(cod_info.block_type!=Encoder.SHORT_TYPE)for(var stop=!1,gsfb=Encoder.PSFB21-1;gsfb>=0&&!stop;gsfb--){var start=gfc.scalefac_band.psfb21[gsfb],end=gfc.scalefac_band.psfb21[gsfb+1],ath21=qupvt.athAdjust(ath.adjust,ath.psfb21[gsfb],ath.floor);gfc.nsPsy.longfact[21]>1e-12&&(ath21*=gfc.nsPsy.longfact[21]);for(var j=end-1;j>=start;j--){if(!(Math.abs(xr[j])<ath21)){stop=!0;break}xr[j]=0}}else for(var block=0;block<3;block++)for(stop=!1,gsfb=Encoder.PSFB12-1;gsfb>=0&&!stop;gsfb--){end=(start=3*gfc.scalefac_band.s[12]+(gfc.scalefac_band.s[13]-gfc.scalefac_band.s[12])*block+(gfc.scalefac_band.psfb12[gsfb]-gfc.scalefac_band.psfb12[0]))+(gfc.scalefac_band.psfb12[gsfb+1]-gfc.scalefac_band.psfb12[gsfb]);var ath12=qupvt.athAdjust(ath.adjust,ath.psfb12[gsfb],ath.floor);for(gfc.nsPsy.shortfact[12]>1e-12&&(ath12*=gfc.nsPsy.shortfact[12]),j=end-1;j>=start;j--){if(!(Math.abs(xr[j])<ath12)){stop=!0;break}xr[j]=0}}}(gfc,cod_info)},BinSearchDirection.BINSEARCH_NONE=new BinSearchDirection(0),BinSearchDirection.BINSEARCH_UP=new BinSearchDirection(1),BinSearchDirection.BINSEARCH_DOWN=new BinSearchDirection(2),this.trancate_smallspectrums=function(gfc,gi,l3_xmin,work){var distort=new_float(L3Side.SFBMAX);if((0!=(4&gfc.substep_shaping)||gi.block_type!=Encoder.SHORT_TYPE)&&0==(128&gfc.substep_shaping)){qupvt.calc_noise(gi,l3_xmin,distort,new CalcNoiseResult,null);for(var j=0;j<576;j++){var xr=0;0!=gi.l3_enc[j]&&(xr=Math.abs(gi.xr[j])),work[j]=xr}j=0;var sfb=8;gi.block_type==Encoder.SHORT_TYPE&&(sfb=6);do{var allowedNoise,trancateThreshold,nsame,start,width=gi.width[sfb];if(j+=width,!(distort[sfb]>=1||(Arrays.sort(work,j-width,width),BitStream.EQ(work[j-1],0)))){allowedNoise=(1-distort[sfb])*l3_xmin[sfb],trancateThreshold=0,start=0;do{var noise;for(nsame=1;start+nsame<width&&!BitStream.NEQ(work[start+j-width],work[start+j+nsame-width]);nsame++);if(allowedNoise<(noise=work[start+j-width]*work[start+j-width]*nsame)){0!=start&&(trancateThreshold=work[start+j-width-1]);break}allowedNoise-=noise,start+=nsame}while(start<width);if(!BitStream.EQ(trancateThreshold,0))do{Math.abs(gi.xr[j-width])<=trancateThreshold&&(gi.l3_enc[j-width]=0)}while(--width>0)}}while(++sfb<gi.psymax);gi.part2_3_length=tk.noquant_count_bits(gfc,gi,null)}},this.outer_loop=function(gfp,cod_info,l3_xmin,xrpow,ch,targ_bits){var gfc=gfp.internal_flags,cod_info_w=new GrInfo,save_xrpow=new_float(576),distort=new_float(L3Side.SFBMAX),best_noise_info=new CalcNoiseResult,prev_noise=new CalcNoiseData,best_part2_3_length=9999999,bEndOfSearch=!1,bRefine=!1,best_ggain_pass1=0;if(function(gfc,cod_info,desired_rate,ch,xrpow){var nBits,CurrentStep=gfc.CurrentStep[ch],flagGoneOver=!1,start=gfc.OldValue[ch],Direction=BinSearchDirection.BINSEARCH_NONE;for(cod_info.global_gain=start,desired_rate-=cod_info.part2_length;;){var step;if(nBits=tk.count_bits(gfc,xrpow,cod_info,null),1==CurrentStep||nBits==desired_rate)break;nBits>desired_rate?(Direction==BinSearchDirection.BINSEARCH_DOWN&&(flagGoneOver=!0),flagGoneOver&&(CurrentStep/=2),Direction=BinSearchDirection.BINSEARCH_UP,step=CurrentStep):(Direction==BinSearchDirection.BINSEARCH_UP&&(flagGoneOver=!0),flagGoneOver&&(CurrentStep/=2),Direction=BinSearchDirection.BINSEARCH_DOWN,step=-CurrentStep),cod_info.global_gain+=step,cod_info.global_gain<0&&(cod_info.global_gain=0,flagGoneOver=!0),cod_info.global_gain>255&&(cod_info.global_gain=255,flagGoneOver=!0)}for(;nBits>desired_rate&&cod_info.global_gain<255;)cod_info.global_gain++,nBits=tk.count_bits(gfc,xrpow,cod_info,null);gfc.CurrentStep[ch]=start-cod_info.global_gain>=4?4:2,gfc.OldValue[ch]=cod_info.global_gain,cod_info.part2_3_length=nBits}(gfc,cod_info,targ_bits,ch,xrpow),0==gfc.noise_shaping)return 100;qupvt.calc_noise(cod_info,l3_xmin,distort,best_noise_info,prev_noise),best_noise_info.bits=cod_info.part2_3_length,cod_info_w.assign(cod_info);var age=0;for(System.arraycopy(xrpow,0,save_xrpow,0,576);!bEndOfSearch;){do{var search_limit,noise_info=new CalcNoiseResult,maxggain=255;if(search_limit=0!=(2&gfc.substep_shaping)?20:3,gfc.sfb21_extra){if(distort[cod_info_w.sfbmax]>1)break;if(cod_info_w.block_type==Encoder.SHORT_TYPE&&(distort[cod_info_w.sfbmax+1]>1||distort[cod_info_w.sfbmax+2]>1))break}if(!balance_noise(gfp,cod_info_w,distort,xrpow,bRefine))break;0!=cod_info_w.scalefac_scale&&(maxggain=254);var huff_bits=targ_bits-cod_info_w.part2_length;if(huff_bits<=0)break;for(;(cod_info_w.part2_3_length=tk.count_bits(gfc,xrpow,cod_info_w,prev_noise))>huff_bits&&cod_info_w.global_gain<=maxggain;)cod_info_w.global_gain++;if(cod_info_w.global_gain>maxggain)break;if(0==best_noise_info.over_count){for(;(cod_info_w.part2_3_length=tk.count_bits(gfc,xrpow,cod_info_w,prev_noise))>best_part2_3_length&&cod_info_w.global_gain<=maxggain;)cod_info_w.global_gain++;if(cod_info_w.global_gain>maxggain)break}if(qupvt.calc_noise(cod_info_w,l3_xmin,distort,noise_info,prev_noise),noise_info.bits=cod_info_w.part2_3_length,0!=(quant_compare(cod_info.block_type!=Encoder.SHORT_TYPE?gfp.quant_comp:gfp.quant_comp_short,best_noise_info,noise_info,cod_info_w,distort)?1:0))best_part2_3_length=cod_info.part2_3_length,best_noise_info=noise_info,cod_info.assign(cod_info_w),age=0,System.arraycopy(xrpow,0,save_xrpow,0,576);else if(0==gfc.full_outer_loop){if(++age>search_limit&&0==best_noise_info.over_count)break;if(3==gfc.noise_shaping_amp&&bRefine&&age>30)break;if(3==gfc.noise_shaping_amp&&bRefine&&cod_info_w.global_gain-best_ggain_pass1>15)break}}while(cod_info_w.global_gain+cod_info_w.scalefac_scale<255);3==gfc.noise_shaping_amp?bRefine?bEndOfSearch=!0:(cod_info_w.assign(cod_info),System.arraycopy(save_xrpow,0,xrpow,0,576),age=0,best_ggain_pass1=cod_info_w.global_gain,bRefine=!0):bEndOfSearch=!0}return gfp.VBR==VbrMode.vbr_rh||gfp.VBR==VbrMode.vbr_mtrh?System.arraycopy(save_xrpow,0,xrpow,0,576):0!=(1&gfc.substep_shaping)&&trancate_smallspectrums(gfc,cod_info,l3_xmin,xrpow),best_noise_info.over_count},this.iteration_finish_one=function(gfc,gr,ch){var l3_side=gfc.l3_side,cod_info=l3_side.tt[gr][ch];tk.best_scalefac_store(gfc,gr,ch,l3_side),1==gfc.use_best_huffman&&tk.best_huffman_divide(gfc,cod_info),rv.ResvAdjust(gfc,cod_info)},this.VBR_encode_granule=function(gfp,cod_info,l3_xmin,xrpow,ch,min_bits,max_bits){var dbits,gfc=gfp.internal_flags,bst_cod_info=new GrInfo,bst_xrpow=new_float(576),Max_bits=max_bits,real_bits=max_bits+1,this_bits=(max_bits+min_bits)/2,found=0,sfb21_extra=gfc.sfb21_extra;Arrays.fill(bst_cod_info.l3_enc,0);do{gfc.sfb21_extra=!(this_bits>Max_bits-42)&&sfb21_extra,outer_loop(gfp,cod_info,l3_xmin,xrpow,ch,this_bits)<=0?(found=1,real_bits=cod_info.part2_3_length,bst_cod_info.assign(cod_info),System.arraycopy(xrpow,0,bst_xrpow,0,576),dbits=(max_bits=real_bits-32)-min_bits,this_bits=(max_bits+min_bits)/2):(dbits=max_bits-(min_bits=this_bits+32),this_bits=(max_bits+min_bits)/2,0!=found&&(found=2,cod_info.assign(bst_cod_info),System.arraycopy(bst_xrpow,0,xrpow,0,576)))}while(dbits>12);gfc.sfb21_extra=sfb21_extra,2==found&&System.arraycopy(bst_cod_info.l3_enc,0,cod_info.l3_enc,0,576)},this.get_framebits=function(gfp,frameBits){var gfc=gfp.internal_flags;gfc.bitrate_index=gfc.VBR_min_bitrate;var bitsPerFrame=bs.getframebits(gfp);gfc.bitrate_index=1,bitsPerFrame=bs.getframebits(gfp);for(var i=1;i<=gfc.VBR_max_bitrate;i++){gfc.bitrate_index=i;var mb=new MeanBits(bitsPerFrame);frameBits[i]=rv.ResvFrameBegin(gfp,mb),bitsPerFrame=mb.bits}},this.VBR_old_prepare=function(gfp,pe,ms_ener_ratio,ratio,l3_xmin,frameBits,min_bits,max_bits,bands){var masking_lower_db,gfc=gfp.internal_flags,adjust=0,analog_silence=1,bits=0;gfc.bitrate_index=gfc.VBR_max_bitrate;var avg=rv.ResvFrameBegin(gfp,new MeanBits(0))/gfc.mode_gr;get_framebits(gfp,frameBits);for(var gr=0;gr<gfc.mode_gr;gr++){var mxb=qupvt.on_pe(gfp,pe,max_bits[gr],avg,gr,0);gfc.mode_ext==Encoder.MPG_MD_MS_LR&&(ms_convert(gfc.l3_side,gr),qupvt.reduce_side(max_bits[gr],ms_ener_ratio[gr],avg,mxb));for(var ch=0;ch<gfc.channels_out;++ch){var cod_info=gfc.l3_side.tt[gr][ch];cod_info.block_type!=Encoder.SHORT_TYPE?(adjust=1.28/(1+Math.exp(3.5-pe[gr][ch]/300))-.05,masking_lower_db=gfc.PSY.mask_adjust-adjust):(adjust=2.56/(1+Math.exp(3.5-pe[gr][ch]/300))-.14,masking_lower_db=gfc.PSY.mask_adjust_short-adjust),gfc.masking_lower=Math.pow(10,.1*masking_lower_db),init_outer_loop(gfc,cod_info),bands[gr][ch]=qupvt.calc_xmin(gfp,ratio[gr][ch],cod_info,l3_xmin[gr][ch]),0!=bands[gr][ch]&&(analog_silence=0),min_bits[gr][ch]=126,bits+=max_bits[gr][ch]}}for(gr=0;gr<gfc.mode_gr;gr++)for(ch=0;ch<gfc.channels_out;ch++)bits>frameBits[gfc.VBR_max_bitrate]&&(max_bits[gr][ch]*=frameBits[gfc.VBR_max_bitrate],max_bits[gr][ch]/=bits),min_bits[gr][ch]>max_bits[gr][ch]&&(min_bits[gr][ch]=max_bits[gr][ch]);return analog_silence},this.bitpressure_strategy=function(gfc,l3_xmin,min_bits,max_bits){for(var gr=0;gr<gfc.mode_gr;gr++)for(var ch=0;ch<gfc.channels_out;ch++){for(var gi=gfc.l3_side.tt[gr][ch],pxmin=l3_xmin[gr][ch],pxminPos=0,sfb=0;sfb<gi.psy_lmax;sfb++)pxmin[pxminPos++]*=1+.029*sfb*sfb/Encoder.SBMAX_l/Encoder.SBMAX_l;if(gi.block_type==Encoder.SHORT_TYPE)for(sfb=gi.sfb_smin;sfb<Encoder.SBMAX_s;sfb++)pxmin[pxminPos++]*=1+.029*sfb*sfb/Encoder.SBMAX_s/Encoder.SBMAX_s,pxmin[pxminPos++]*=1+.029*sfb*sfb/Encoder.SBMAX_s/Encoder.SBMAX_s,pxmin[pxminPos++]*=1+.029*sfb*sfb/Encoder.SBMAX_s/Encoder.SBMAX_s;max_bits[gr][ch]=0|Math.max(min_bits[gr][ch],.9*max_bits[gr][ch])}},this.VBR_new_prepare=function(gfp,pe,ratio,l3_xmin,frameBits,max_bits){var maximum_framebits,gfc=gfp.internal_flags,analog_silence=1,avg=0,bits=0;if(gfp.free_format){gfc.bitrate_index=0;mb=new MeanBits(avg);maximum_framebits=rv.ResvFrameBegin(gfp,mb),avg=mb.bits,frameBits[0]=maximum_framebits}else{gfc.bitrate_index=gfc.VBR_max_bitrate;var mb=new MeanBits(avg);rv.ResvFrameBegin(gfp,mb),avg=mb.bits,get_framebits(gfp,frameBits),maximum_framebits=frameBits[gfc.VBR_max_bitrate]}for(var gr=0;gr<gfc.mode_gr;gr++){qupvt.on_pe(gfp,pe,max_bits[gr],avg,gr,0),gfc.mode_ext==Encoder.MPG_MD_MS_LR&&ms_convert(gfc.l3_side,gr);for(var ch=0;ch<gfc.channels_out;++ch){var cod_info=gfc.l3_side.tt[gr][ch];gfc.masking_lower=Math.pow(10,.1*gfc.PSY.mask_adjust),init_outer_loop(gfc,cod_info),0!=qupvt.calc_xmin(gfp,ratio[gr][ch],cod_info,l3_xmin[gr][ch])&&(analog_silence=0),bits+=max_bits[gr][ch]}}for(gr=0;gr<gfc.mode_gr;gr++)for(ch=0;ch<gfc.channels_out;ch++)bits>maximum_framebits&&(max_bits[gr][ch]*=maximum_framebits,max_bits[gr][ch]/=bits);return analog_silence},this.calc_target_bits=function(gfp,pe,ms_ener_ratio,targ_bits,analog_silence_bits,max_frame_bits){var res_factor,gr,ch,totbits,gfc=gfp.internal_flags,l3_side=gfc.l3_side,mean_bits=0;gfc.bitrate_index=gfc.VBR_max_bitrate;var mb=new MeanBits(mean_bits);for(max_frame_bits[0]=rv.ResvFrameBegin(gfp,mb),mean_bits=mb.bits,gfc.bitrate_index=1,mean_bits=bs.getframebits(gfp)-8*gfc.sideinfo_len,analog_silence_bits[0]=mean_bits/(gfc.mode_gr*gfc.channels_out),mean_bits=gfp.VBR_mean_bitrate_kbps*gfp.framesize*1e3,0!=(1&gfc.substep_shaping)&&(mean_bits*=1.09),mean_bits/=gfp.out_samplerate,mean_bits-=8*gfc.sideinfo_len,mean_bits/=gfc.mode_gr*gfc.channels_out,(res_factor=.93+.07*(11-gfp.compression_ratio)/5.5)<.9&&(res_factor=.9),res_factor>1&&(res_factor=1),gr=0;gr<gfc.mode_gr;gr++){var sum=0;for(ch=0;ch<gfc.channels_out;ch++){if(targ_bits[gr][ch]=int(res_factor*mean_bits),pe[gr][ch]>700){var add_bits=int((pe[gr][ch]-700)/1.4),cod_info=l3_side.tt[gr][ch];targ_bits[gr][ch]=int(res_factor*mean_bits),cod_info.block_type==Encoder.SHORT_TYPE&&add_bits<mean_bits/2&&(add_bits=mean_bits/2),add_bits>3*mean_bits/2?add_bits=3*mean_bits/2:add_bits<0&&(add_bits=0),targ_bits[gr][ch]+=add_bits}targ_bits[gr][ch]>LameInternalFlags.MAX_BITS_PER_CHANNEL&&(targ_bits[gr][ch]=LameInternalFlags.MAX_BITS_PER_CHANNEL),sum+=targ_bits[gr][ch]}if(sum>LameInternalFlags.MAX_BITS_PER_GRANULE)for(ch=0;ch<gfc.channels_out;++ch)targ_bits[gr][ch]*=LameInternalFlags.MAX_BITS_PER_GRANULE,targ_bits[gr][ch]/=sum}if(gfc.mode_ext==Encoder.MPG_MD_MS_LR)for(gr=0;gr<gfc.mode_gr;gr++)qupvt.reduce_side(targ_bits[gr],ms_ener_ratio[gr],mean_bits*gfc.channels_out,LameInternalFlags.MAX_BITS_PER_GRANULE);for(totbits=0,gr=0;gr<gfc.mode_gr;gr++)for(ch=0;ch<gfc.channels_out;ch++)targ_bits[gr][ch]>LameInternalFlags.MAX_BITS_PER_CHANNEL&&(targ_bits[gr][ch]=LameInternalFlags.MAX_BITS_PER_CHANNEL),totbits+=targ_bits[gr][ch];if(totbits>max_frame_bits[0])for(gr=0;gr<gfc.mode_gr;gr++)for(ch=0;ch<gfc.channels_out;ch++)targ_bits[gr][ch]*=max_frame_bits[0],targ_bits[gr][ch]/=totbits}}function NewMDCT(){var enwindow=[-.1482523854003001,32.308141959636465,296.40344946382766,883.1344870032432,11113.947376231741,1057.2713659324597,305.7402417275812,30.825928907280012,3.8533188138216365,59.42900443849514,709.5899960123345,5281.91112291017,-5829.66483675846,-817.6293103748613,-76.91656988279972,-4.594269939176596,.9063471690191471,.1960342806591213,-.15466694054279598,34.324387823855965,301.8067566458425,817.599602898885,11573.795901679885,1181.2520595540152,321.59731579894424,31.232021761053772,3.7107095756221318,53.650946155329365,684.167428119626,5224.56624370173,-6366.391851890084,-908.9766368219582,-89.83068876699639,-5.411397422890401,.8206787908286602,.3901806440322567,-.16070888947830023,36.147034243915876,304.11815768187864,732.7429163887613,11989.60988270091,1300.012278487897,335.28490093152146,31.48816102859945,3.373875931311736,47.232241542899175,652.7371796173471,5132.414255594984,-6909.087078780055,-1001.9990371107289,-103.62185754286375,-6.104916304710272,.7416505462720353,.5805693545089249,-.16636367662261495,37.751650073343995,303.01103387567713,627.9747488785183,12358.763425278165,1412.2779918482834,346.7496836825721,31.598286663170416,3.1598635433980946,40.57878626349686,616.1671130880391,5007.833007176154,-7454.040671756168,-1095.7960341867115,-118.24411666465777,-6.818469345853504,.6681786379192989,.7653668647301797,-.1716176790982088,39.11551877123304,298.3413246578966,503.5259106886539,12679.589408408976,1516.5821921214542,355.9850766329023,31.395241710249053,2.9164211881972335,33.79716964664243,574.8943997801362,4853.234992253242,-7997.57021486075,-1189.7624067269965,-133.6444792601766,-7.7202770609839915,.5993769336819237,.9427934736519954,-.17645823955292173,40.21879108166477,289.9982036694474,359.3226160751053,12950.259102786438,1612.1013903507662,362.85067106591504,31.045922092242872,2.822222032597987,26.988862316190684,529.8996541764288,4671.371946949588,-8535.899136645805,-1282.5898586244496,-149.58553632943463,-8.643494270763135,.5345111359507916,1.111140466039205,-.36174739330527045,41.04429910497807,277.5463268268618,195.6386023135583,13169.43812144731,1697.6433561479398,367.40983966190305,30.557037410382826,2.531473372857427,20.070154905927314,481.50208566532336,4464.970341588308,-9065.36882077239,-1373.62841526722,-166.1660487028118,-9.58289321133207,.4729647758913199,1.268786568327291,-.36970682634889585,41.393213350082036,261.2935935556502,12.935476055240873,13336.131683328815,1772.508612059496,369.76534388639965,29.751323653701338,2.4023193045459172,13.304795348228817,430.5615775526625,4237.0568611071185,-9581.931701634761,-1461.6913552409758,-183.12733958476446,-10.718010163869403,.41421356237309503,1.414213562373095,-.37677560326535325,41.619486213528496,241.05423794991074,-187.94665032361226,13450.063605744153,1836.153896465782,369.4908799925761,29.001847876923147,2.0714759319987186,6.779591200894186,377.7767837205709,3990.386575512536,-10081.709459700915,-1545.947424837898,-200.3762958015653,-11.864482073055006,.3578057213145241,1.546020906725474,-.3829366947518991,41.1516456456653,216.47684307105183,-406.1569483347166,13511.136535077321,1887.8076599260432,367.3025214564151,28.136213436723654,1.913880671464418,.3829366947518991,323.85365704338597,3728.1472257487526,-10561.233882199509,-1625.2025997821418,-217.62525175416,-13.015432208941645,.3033466836073424,1.66293922460509,-.5822628872992417,40.35639251440489,188.20071124269245,-640.2706748618148,13519.21490106562,1927.6022433578062,362.8197642637487,26.968821921868447,1.7463817695935329,-5.62650678237171,269.3016715297017,3453.386536448852,-11016.145278780888,-1698.6569643425091,-234.7658734267683,-14.16351421663124,.2504869601913055,1.76384252869671,-.5887180101749253,39.23429103868072,155.76096234403798,-889.2492977967378,13475.470561874661,1955.0535223723712,356.4450994756727,25.894952980042156,1.5695032905781554,-11.181939564328772,214.80884394039484,3169.1640829158237,-11443.321309975563,-1765.1588461316153,-251.68908574481912,-15.49755935939164,.198912367379658,1.847759065022573,-.7912582233652842,37.39369355329111,119.699486012458,-1151.0956593239027,13380.446257078214,1970.3952110853447,348.01959814116185,24.731487364283044,1.3850130831637748,-16.421408865300393,161.05030052864092,2878.3322807850063,-11838.991423510031,-1823.985884688674,-268.2854986386903,-16.81724543849939,.1483359875383474,1.913880671464418,-.7960642926861912,35.2322109610459,80.01928065061526,-1424.0212633405113,13235.794061869668,1973.804052543835,337.9908651258184,23.289159354463873,1.3934255946442087,-21.099669467133474,108.48348407242611,2583.700758091299,-12199.726194855148,-1874.2780658979746,-284.2467154529415,-18.11369784385905,.09849140335716425,1.961570560806461,-.998795456205172,32.56307803611191,36.958364584370486,-1706.075448829146,13043.287458812016,1965.3831106103316,326.43182772364605,22.175018750622293,1.198638339011324,-25.371248002043963,57.53505923036915,2288.41886619975,-12522.674544337233,-1914.8400385312243,-299.26241273417224,-19.37805630698734,.04912684976946725,1.990369453344394,.035780907*Util.SQRT2*.5/2384e-9,.017876148*Util.SQRT2*.5/2384e-9,.003134727*Util.SQRT2*.5/2384e-9,.002457142*Util.SQRT2*.5/2384e-9,971317e-9*Util.SQRT2*.5/2384e-9,218868e-9*Util.SQRT2*.5/2384e-9,101566e-9*Util.SQRT2*.5/2384e-9,13828e-9*Util.SQRT2*.5/2384e-9,12804.797818791945,1945.5515939597317,313.4244966442953,20.801593959731544,1995.1556208053692,9.000838926174497,-29.20218120805369],win=[[2382191739347913e-28,6423305872147834e-28,9400849094049688e-28,1122435026096556e-27,1183840321267481e-27,1122435026096556e-27,940084909404969e-27,6423305872147839e-28,2382191739347918e-28,5456116108943412e-27,4878985199565852e-27,4240448995017367e-27,3559909094758252e-27,2858043359288075e-27,2156177623817898e-27,1475637723558783e-27,8371015190102974e-28,2599706096327376e-28,-5456116108943412e-27,-4878985199565852e-27,-4240448995017367e-27,-3559909094758252e-27,-2858043359288076e-27,-2156177623817898e-27,-1475637723558783e-27,-8371015190102975e-28,-2599706096327376e-28,-2382191739347923e-28,-6423305872147843e-28,-9400849094049696e-28,-1122435026096556e-27,-1183840321267481e-27,-1122435026096556e-27,-9400849094049694e-28,-642330587214784e-27,-2382191739347918e-28],[2382191739347913e-28,6423305872147834e-28,9400849094049688e-28,1122435026096556e-27,1183840321267481e-27,1122435026096556e-27,9400849094049688e-28,6423305872147841e-28,2382191739347918e-28,5456116108943413e-27,4878985199565852e-27,4240448995017367e-27,3559909094758253e-27,2858043359288075e-27,2156177623817898e-27,1475637723558782e-27,8371015190102975e-28,2599706096327376e-28,-5461314069809755e-27,-4921085770524055e-27,-4343405037091838e-27,-3732668368707687e-27,-3093523840190885e-27,-2430835727329465e-27,-1734679010007751e-27,-974825365660928e-27,-2797435120168326e-28,0,0,0,0,0,0,-2283748241799531e-28,-4037858874020686e-28,-2146547464825323e-28],[.1316524975873958,.414213562373095,.7673269879789602,1.091308501069271,1.303225372841206,1.56968557711749,1.920982126971166,2.414213562373094,3.171594802363212,4.510708503662055,7.595754112725146,22.90376554843115,.984807753012208,.6427876096865394,.3420201433256688,.9396926207859084,-.1736481776669303,-.7660444431189779,.8660254037844387,.5,-.5144957554275265,-.4717319685649723,-.3133774542039019,-.1819131996109812,-.09457419252642064,-.04096558288530405,-.01419856857247115,-.003699974673760037,.8574929257125442,.8817419973177052,.9496286491027329,.9833145924917901,.9955178160675857,.9991605581781475,.999899195244447,.9999931550702802],[0,0,0,0,0,0,2283748241799531e-28,4037858874020686e-28,2146547464825323e-28,5461314069809755e-27,4921085770524055e-27,4343405037091838e-27,3732668368707687e-27,3093523840190885e-27,2430835727329466e-27,1734679010007751e-27,974825365660928e-27,2797435120168326e-28,-5456116108943413e-27,-4878985199565852e-27,-4240448995017367e-27,-3559909094758253e-27,-2858043359288075e-27,-2156177623817898e-27,-1475637723558782e-27,-8371015190102975e-28,-2599706096327376e-28,-2382191739347913e-28,-6423305872147834e-28,-9400849094049688e-28,-1122435026096556e-27,-1183840321267481e-27,-1122435026096556e-27,-9400849094049688e-28,-6423305872147841e-28,-2382191739347918e-28]],tantab_l=win[Encoder.SHORT_TYPE],cx=win[Encoder.SHORT_TYPE],ca=win[Encoder.SHORT_TYPE],cs=win[Encoder.SHORT_TYPE],order=[0,1,16,17,8,9,24,25,4,5,20,21,12,13,28,29,2,3,18,19,10,11,26,27,6,7,22,23,14,15,30,31];function window_subband(x1,x1Pos,a){for(var u,v,xr,wp=10,x2=x1Pos+238-14-286,i=-15;i<0;i++){var w,s,t;w=enwindow[wp+-10],s=x1[x2+-224]*w,t=x1[x1Pos+224]*w,w=enwindow[wp+-9],s+=x1[x2+-160]*w,t+=x1[x1Pos+160]*w,w=enwindow[wp+-8],s+=x1[x2+-96]*w,t+=x1[x1Pos+96]*w,w=enwindow[wp+-7],s+=x1[x2+-32]*w,t+=x1[x1Pos+32]*w,w=enwindow[wp+-6],s+=x1[x2+32]*w,t+=x1[x1Pos+-32]*w,w=enwindow[wp+-5],s+=x1[x2+96]*w,t+=x1[x1Pos+-96]*w,w=enwindow[wp+-4],s+=x1[x2+160]*w,t+=x1[x1Pos+-160]*w,w=enwindow[wp+-3],s+=x1[x2+224]*w,t+=x1[x1Pos+-224]*w,w=enwindow[wp+-2],s+=x1[x1Pos+-256]*w,t-=x1[x2+256]*w,w=enwindow[wp+-1],s+=x1[x1Pos+-192]*w,t-=x1[x2+192]*w,w=enwindow[wp+0],s+=x1[x1Pos+-128]*w,t-=x1[x2+128]*w,w=enwindow[wp+1],s+=x1[x1Pos+-64]*w,t-=x1[x2+64]*w,w=enwindow[wp+2],s+=x1[x1Pos+0]*w,t-=x1[x2+0]*w,w=enwindow[wp+3],s+=x1[x1Pos+64]*w,t-=x1[x2+-64]*w,w=enwindow[wp+4],s+=x1[x1Pos+128]*w,t-=x1[x2+-128]*w,w=enwindow[wp+5],s+=x1[x1Pos+192]*w,w=(t-=x1[x2+-192]*w)-(s*=enwindow[wp+6]),a[30+2*i]=t+s,a[31+2*i]=enwindow[wp+7]*w,wp+=18,x1Pos--,x2++}t=x1[x1Pos+-16]*enwindow[wp+-10],s=x1[x1Pos+-32]*enwindow[wp+-2],t+=(x1[x1Pos+-48]-x1[x1Pos+16])*enwindow[wp+-9],s+=x1[x1Pos+-96]*enwindow[wp+-1],t+=(x1[x1Pos+-80]+x1[x1Pos+48])*enwindow[wp+-8],s+=x1[x1Pos+-160]*enwindow[wp+0],t+=(x1[x1Pos+-112]-x1[x1Pos+80])*enwindow[wp+-7],s+=x1[x1Pos+-224]*enwindow[wp+1],t+=(x1[x1Pos+-144]+x1[x1Pos+112])*enwindow[wp+-6],s-=x1[x1Pos+32]*enwindow[wp+2],t+=(x1[x1Pos+-176]-x1[x1Pos+144])*enwindow[wp+-5],s-=x1[x1Pos+96]*enwindow[wp+3],t+=(x1[x1Pos+-208]+x1[x1Pos+176])*enwindow[wp+-4],s-=x1[x1Pos+160]*enwindow[wp+4],t+=(x1[x1Pos+-240]-x1[x1Pos+208])*enwindow[wp+-3],u=(s-=x1[x1Pos+224])-t,v=s+t,t=a[14],s=a[15]-t,a[31]=v+t,a[30]=u+s,a[15]=u-s,a[14]=v-t,xr=a[28]-a[0],a[0]+=a[28],a[28]=xr*enwindow[wp+-36+7],xr=a[29]-a[1],a[1]+=a[29],a[29]=xr*enwindow[wp+-36+7],xr=a[26]-a[2],a[2]+=a[26],a[26]=xr*enwindow[wp+-72+7],xr=a[27]-a[3],a[3]+=a[27],a[27]=xr*enwindow[wp+-72+7],xr=a[24]-a[4],a[4]+=a[24],a[24]=xr*enwindow[wp+-108+7],xr=a[25]-a[5],a[5]+=a[25],a[25]=xr*enwindow[wp+-108+7],xr=a[22]-a[6],a[6]+=a[22],a[22]=xr*Util.SQRT2,xr=a[23]-a[7],a[7]+=a[23],a[23]=xr*Util.SQRT2-a[7],a[7]-=a[6],a[22]-=a[7],a[23]-=a[22],xr=a[6],a[6]=a[31]-xr,a[31]=a[31]+xr,xr=a[7],a[7]=a[30]-xr,a[30]=a[30]+xr,xr=a[22],a[22]=a[15]-xr,a[15]=a[15]+xr,xr=a[23],a[23]=a[14]-xr,a[14]=a[14]+xr,xr=a[20]-a[8],a[8]+=a[20],a[20]=xr*enwindow[wp+-180+7],xr=a[21]-a[9],a[9]+=a[21],a[21]=xr*enwindow[wp+-180+7],xr=a[18]-a[10],a[10]+=a[18],a[18]=xr*enwindow[wp+-216+7],xr=a[19]-a[11],a[11]+=a[19],a[19]=xr*enwindow[wp+-216+7],xr=a[16]-a[12],a[12]+=a[16],a[16]=xr*enwindow[wp+-252+7],xr=a[17]-a[13],a[13]+=a[17],a[17]=xr*enwindow[wp+-252+7],xr=-a[20]+a[24],a[20]+=a[24],a[24]=xr*enwindow[wp+-216+7],xr=-a[21]+a[25],a[21]+=a[25],a[25]=xr*enwindow[wp+-216+7],xr=a[4]-a[8],a[4]+=a[8],a[8]=xr*enwindow[wp+-216+7],xr=a[5]-a[9],a[5]+=a[9],a[9]=xr*enwindow[wp+-216+7],xr=a[0]-a[12],a[0]+=a[12],a[12]=xr*enwindow[wp+-72+7],xr=a[1]-a[13],a[1]+=a[13],a[13]=xr*enwindow[wp+-72+7],xr=a[16]-a[28],a[16]+=a[28],a[28]=xr*enwindow[wp+-72+7],xr=-a[17]+a[29],a[17]+=a[29],a[29]=xr*enwindow[wp+-72+7],xr=Util.SQRT2*(a[2]-a[10]),a[2]+=a[10],a[10]=xr,xr=Util.SQRT2*(a[3]-a[11]),a[3]+=a[11],a[11]=xr,xr=Util.SQRT2*(-a[18]+a[26]),a[18]+=a[26],a[26]=xr-a[18],xr=Util.SQRT2*(-a[19]+a[27]),a[19]+=a[27],a[27]=xr-a[19],xr=a[2],a[19]-=a[3],a[3]-=xr,a[2]=a[31]-xr,a[31]+=xr,xr=a[3],a[11]-=a[19],a[18]-=xr,a[3]=a[30]-xr,a[30]+=xr,xr=a[18],a[27]-=a[11],a[19]-=xr,a[18]=a[15]-xr,a[15]+=xr,xr=a[19],a[10]-=xr,a[19]=a[14]-xr,a[14]+=xr,xr=a[10],a[11]-=xr,a[10]=a[23]-xr,a[23]+=xr,xr=a[11],a[26]-=xr,a[11]=a[22]-xr,a[22]+=xr,xr=a[26],a[27]-=xr,a[26]=a[7]-xr,a[7]+=xr,xr=a[27],a[27]=a[6]-xr,a[6]+=xr,xr=Util.SQRT2*(a[0]-a[4]),a[0]+=a[4],a[4]=xr,xr=Util.SQRT2*(a[1]-a[5]),a[1]+=a[5],a[5]=xr,xr=Util.SQRT2*(a[16]-a[20]),a[16]+=a[20],a[20]=xr,xr=Util.SQRT2*(a[17]-a[21]),a[17]+=a[21],a[21]=xr,xr=-Util.SQRT2*(a[8]-a[12]),a[8]+=a[12],a[12]=xr-a[8],xr=-Util.SQRT2*(a[9]-a[13]),a[9]+=a[13],a[13]=xr-a[9],xr=-Util.SQRT2*(a[25]-a[29]),a[25]+=a[29],a[29]=xr-a[25],xr=-Util.SQRT2*(a[24]+a[28]),a[24]-=a[28],a[28]=xr-a[24],xr=a[24]-a[16],a[24]=xr,xr=a[20]-xr,a[20]=xr,xr=a[28]-xr,a[28]=xr,xr=a[25]-a[17],a[25]=xr,xr=a[21]-xr,a[21]=xr,xr=a[29]-xr,a[29]=xr,xr=a[17]-a[1],a[17]=xr,xr=a[9]-xr,a[9]=xr,xr=a[25]-xr,a[25]=xr,xr=a[5]-xr,a[5]=xr,xr=a[21]-xr,a[21]=xr,xr=a[13]-xr,a[13]=xr,xr=a[29]-xr,a[29]=xr,xr=a[1]-a[0],a[1]=xr,xr=a[16]-xr,a[16]=xr,xr=a[17]-xr,a[17]=xr,xr=a[8]-xr,a[8]=xr,xr=a[9]-xr,a[9]=xr,xr=a[24]-xr,a[24]=xr,xr=a[25]-xr,a[25]=xr,xr=a[4]-xr,a[4]=xr,xr=a[5]-xr,a[5]=xr,xr=a[20]-xr,a[20]=xr,xr=a[21]-xr,a[21]=xr,xr=a[12]-xr,a[12]=xr,xr=a[13]-xr,a[13]=xr,xr=a[28]-xr,a[28]=xr,xr=a[29]-xr,a[29]=xr,xr=a[0],a[0]+=a[31],a[31]-=xr,xr=a[1],a[1]+=a[30],a[30]-=xr,xr=a[16],a[16]+=a[15],a[15]-=xr,xr=a[17],a[17]+=a[14],a[14]-=xr,xr=a[8],a[8]+=a[23],a[23]-=xr,xr=a[9],a[9]+=a[22],a[22]-=xr,xr=a[24],a[24]+=a[7],a[7]-=xr,xr=a[25],a[25]+=a[6],a[6]-=xr,xr=a[4],a[4]+=a[27],a[27]-=xr,xr=a[5],a[5]+=a[26],a[26]-=xr,xr=a[20],a[20]+=a[11],a[11]-=xr,xr=a[21],a[21]+=a[10],a[10]-=xr,xr=a[12],a[12]+=a[19],a[19]-=xr,xr=a[13],a[13]+=a[18],a[18]-=xr,xr=a[28],a[28]+=a[3],a[3]-=xr,xr=a[29],a[29]+=a[2],a[2]-=xr}function mdct_short(inout,inoutPos){for(var l=0;l<3;l++){var tc0,tc1,tc2,ts0,ts1,ts2;tc1=(ts0=inout[inoutPos+6]*win[Encoder.SHORT_TYPE][0]-inout[inoutPos+15])+(tc0=inout[inoutPos+0]*win[Encoder.SHORT_TYPE][2]-inout[inoutPos+9]),tc2=ts0-tc0,ts1=(ts0=inout[inoutPos+15]*win[Encoder.SHORT_TYPE][0]+inout[inoutPos+6])+(tc0=inout[inoutPos+9]*win[Encoder.SHORT_TYPE][2]+inout[inoutPos+0]),ts2=-ts0+tc0,tc0=2069978111953089e-26*(inout[inoutPos+3]*win[Encoder.SHORT_TYPE][1]-inout[inoutPos+12]),ts0=2069978111953089e-26*(inout[inoutPos+12]*win[Encoder.SHORT_TYPE][1]+inout[inoutPos+3]),inout[inoutPos+0]=190752519173728e-25*tc1+tc0,inout[inoutPos+15]=190752519173728e-25*-ts1+ts0,tc2=.8660254037844387*tc2*1907525191737281e-26,ts1=.5*ts1*1907525191737281e-26+ts0,inout[inoutPos+3]=tc2-ts1,inout[inoutPos+6]=tc2+ts1,tc1=.5*tc1*1907525191737281e-26-tc0,ts2=.8660254037844387*ts2*1907525191737281e-26,inout[inoutPos+9]=tc1+ts2,inout[inoutPos+12]=tc1-ts2,inoutPos++}}this.mdct_sub48=function(gfc,w0,w1){for(var out,outPos,_in,ct,st,tc1,tc2,tc3,tc4,ts5,ts6,ts7,ts8,ts1,ts2,ts3,ts4,tc5,tc6,tc7,tc8,wk=w0,wkPos=286,ch=0;ch<gfc.channels_out;ch++){for(var gr=0;gr<gfc.mode_gr;gr++){for(var band,gi=gfc.l3_side.tt[gr][ch],mdct_enc=gi.xr,mdct_encPos=0,samp=gfc.sb_sample[ch][1-gr],sampPos=0,k=0;k<9;k++)for(window_subband(wk,wkPos,samp[sampPos]),window_subband(wk,wkPos+32,samp[sampPos+1]),sampPos+=2,wkPos+=64,band=1;band<32;band+=2)samp[sampPos-1][band]*=-1;for(band=0;band<32;band++,mdct_encPos+=18){var type=gi.block_type,band0=gfc.sb_sample[ch][gr],band1=gfc.sb_sample[ch][1-gr];if(0!=gi.mixed_block_flag&&band<2&&(type=0),gfc.amp_filter[band]<1e-12)Arrays.fill(mdct_enc,mdct_encPos+0,mdct_encPos+18,0);else{if(gfc.amp_filter[band]<1)for(k=0;k<18;k++)band1[k][order[band]]*=gfc.amp_filter[band];if(type==Encoder.SHORT_TYPE){for(k=-3;k<0;k++){var w=win[Encoder.SHORT_TYPE][k+3];mdct_enc[mdct_encPos+3*k+9]=band0[9+k][order[band]]*w-band0[8-k][order[band]],mdct_enc[mdct_encPos+3*k+18]=band0[14-k][order[band]]*w+band0[15+k][order[band]],mdct_enc[mdct_encPos+3*k+10]=band0[15+k][order[band]]*w-band0[14-k][order[band]],mdct_enc[mdct_encPos+3*k+19]=band1[2-k][order[band]]*w+band1[3+k][order[band]],mdct_enc[mdct_encPos+3*k+11]=band1[3+k][order[band]]*w-band1[2-k][order[band]],mdct_enc[mdct_encPos+3*k+20]=band1[8-k][order[band]]*w+band1[9+k][order[band]]}mdct_short(mdct_enc,mdct_encPos)}else{var work=new_float(18);for(k=-9;k<0;k++){var a,b;a=win[type][k+27]*band1[k+9][order[band]]+win[type][k+36]*band1[8-k][order[band]],b=win[type][k+9]*band0[k+9][order[band]]-win[type][k+18]*band0[8-k][order[band]],work[k+9]=a-b*tantab_l[3+k+9],work[k+18]=a*tantab_l[3+k+9]+b}out=mdct_enc,outPos=mdct_encPos,ct=void 0,st=void 0,tc1=void 0,tc2=void 0,tc3=void 0,tc4=void 0,ts5=void 0,ts6=void 0,ts7=void 0,ts8=void 0,ts1=void 0,ts2=void 0,ts3=void 0,ts4=void 0,tc5=void 0,tc6=void 0,tc7=void 0,tc8=void 0,tc1=(_in=work)[17]-_in[9],tc3=_in[15]-_in[11],tc4=_in[14]-_in[12],ts5=_in[0]+_in[8],ts6=_in[1]+_in[7],ts7=_in[2]+_in[6],ts8=_in[3]+_in[5],out[outPos+17]=ts5+ts7-ts8-(ts6-_in[4]),st=(ts5+ts7-ts8)*cx[19]+(ts6-_in[4]),ct=(tc1-tc3-tc4)*cx[18],out[outPos+5]=ct+st,out[outPos+6]=ct-st,tc2=(_in[16]-_in[10])*cx[18],ts6=ts6*cx[19]+_in[4],ct=tc1*cx[12]+tc2+tc3*cx[13]+tc4*cx[14],st=-ts5*cx[16]+ts6-ts7*cx[17]+ts8*cx[15],out[outPos+1]=ct+st,out[outPos+2]=ct-st,ct=tc1*cx[13]-tc2-tc3*cx[14]+tc4*cx[12],st=-ts5*cx[17]+ts6-ts7*cx[15]+ts8*cx[16],out[outPos+9]=ct+st,out[outPos+10]=ct-st,ct=tc1*cx[14]-tc2+tc3*cx[12]-tc4*cx[13],st=ts5*cx[15]-ts6+ts7*cx[16]-ts8*cx[17],out[outPos+13]=ct+st,out[outPos+14]=ct-st,ts1=_in[8]-_in[0],ts3=_in[6]-_in[2],ts4=_in[5]-_in[3],tc5=_in[17]+_in[9],tc6=_in[16]+_in[10],tc7=_in[15]+_in[11],tc8=_in[14]+_in[12],out[outPos+0]=tc5+tc7+tc8+(tc6+_in[13]),ct=(tc5+tc7+tc8)*cx[19]-(tc6+_in[13]),st=(ts1-ts3+ts4)*cx[18],out[outPos+11]=ct+st,out[outPos+12]=ct-st,ts2=(_in[7]-_in[1])*cx[18],tc6=_in[13]-tc6*cx[19],ct=tc5*cx[15]-tc6+tc7*cx[16]+tc8*cx[17],st=ts1*cx[14]+ts2+ts3*cx[12]+ts4*cx[13],out[outPos+3]=ct+st,out[outPos+4]=ct-st,ct=-tc5*cx[17]+tc6-tc7*cx[15]-tc8*cx[16],st=ts1*cx[13]+ts2-ts3*cx[14]-ts4*cx[12],out[outPos+7]=ct+st,out[outPos+8]=ct-st,ct=-tc5*cx[16]+tc6-tc7*cx[17]-tc8*cx[15],st=ts1*cx[12]-ts2+ts3*cx[13]-ts4*cx[14],out[outPos+15]=ct+st,out[outPos+16]=ct-st}}if(type!=Encoder.SHORT_TYPE&&0!=band)for(k=7;k>=0;--k){var bu,bd;bu=mdct_enc[mdct_encPos+k]*ca[20+k]+mdct_enc[mdct_encPos+-1-k]*cs[28+k],bd=mdct_enc[mdct_encPos+k]*cs[28+k]-mdct_enc[mdct_encPos+-1-k]*ca[20+k],mdct_enc[mdct_encPos+-1-k]=bu,mdct_enc[mdct_encPos+k]=bd}}}if(wk=w1,wkPos=286,1==gfc.mode_gr)for(var i=0;i<18;i++)System.arraycopy(gfc.sb_sample[ch][1][i],0,gfc.sb_sample[ch][0][i],0,32)}}}function III_psy_ratio(){this.thm=new III_psy_xmin,this.en=new III_psy_xmin}function Encoder(){var FFTOFFSET=Encoder.FFTOFFSET,MPG_MD_MS_LR=Encoder.MPG_MD_MS_LR,bs=null;this.psy=null;var psy=null,vbr=null,qupvt=null;this.setModules=function(_bs,_psy,_qupvt,_vbr){bs=_bs,this.psy=_psy,psy=_psy,vbr=_vbr,qupvt=_qupvt};var newMDCT=new NewMDCT;this.lame_encode_mp3_frame=function(gfp,inbuf_l,inbuf_r,mp3buf,mp3bufPos,mp3buf_size){var mp3count,masking_LR=new_array_n([2,2]);masking_LR[0][0]=new III_psy_ratio,masking_LR[0][1]=new III_psy_ratio,masking_LR[1][0]=new III_psy_ratio,masking_LR[1][1]=new III_psy_ratio;var masking,masking_MS=new_array_n([2,2]);masking_MS[0][0]=new III_psy_ratio,masking_MS[0][1]=new III_psy_ratio,masking_MS[1][0]=new III_psy_ratio,masking_MS[1][1]=new III_psy_ratio;var pe_use,ch,gr,inbuf=[null,null],gfc=gfp.internal_flags,tot_ener=new_float_n([2,4]),ms_ener_ratio=[.5,.5],pe=[[0,0],[0,0]],pe_MS=[[0,0],[0,0]];if(inbuf[0]=inbuf_l,inbuf[1]=inbuf_r,0==gfc.lame_encode_frame_init&&function(gfp,inbuf){var ch,gr,gfc=gfp.internal_flags;if(0==gfc.lame_encode_frame_init){var i,j,primebuff0=new_float(2014),primebuff1=new_float(2014);for(gfc.lame_encode_frame_init=1,i=0,j=0;i<286+576*(1+gfc.mode_gr);++i)i<576*gfc.mode_gr?(primebuff0[i]=0,2==gfc.channels_out&&(primebuff1[i]=0)):(primebuff0[i]=inbuf[0][j],2==gfc.channels_out&&(primebuff1[i]=inbuf[1][j]),++j);for(gr=0;gr<gfc.mode_gr;gr++)for(ch=0;ch<gfc.channels_out;ch++)gfc.l3_side.tt[gr][ch].block_type=Encoder.SHORT_TYPE;newMDCT.mdct_sub48(gfc,primebuff0,primebuff1)}}(gfp,inbuf),gfc.padding=0,(gfc.slot_lag-=gfc.frac_SpF)<0&&(gfc.slot_lag+=gfp.out_samplerate,gfc.padding=1),0!=gfc.psymodel){var bufp=[null,null],bufpPos=0,blocktype=new_int(2);for(gr=0;gr<gfc.mode_gr;gr++){for(ch=0;ch<gfc.channels_out;ch++)bufp[ch]=inbuf[ch],bufpPos=576+576*gr-Encoder.FFTOFFSET;if(0!=(gfp.VBR==VbrMode.vbr_mtrh||gfp.VBR==VbrMode.vbr_mt?psy.L3psycho_anal_vbr(gfp,bufp,bufpPos,gr,masking_LR,masking_MS,pe[gr],pe_MS[gr],tot_ener[gr],blocktype):psy.L3psycho_anal_ns(gfp,bufp,bufpPos,gr,masking_LR,masking_MS,pe[gr],pe_MS[gr],tot_ener[gr],blocktype)))return-4;for(gfp.mode==MPEGMode.JOINT_STEREO&&(ms_ener_ratio[gr]=tot_ener[gr][2]+tot_ener[gr][3],ms_ener_ratio[gr]>0&&(ms_ener_ratio[gr]=tot_ener[gr][3]/ms_ener_ratio[gr])),ch=0;ch<gfc.channels_out;ch++){var cod_info=gfc.l3_side.tt[gr][ch];cod_info.block_type=blocktype[ch],cod_info.mixed_block_flag=0}}}else for(gr=0;gr<gfc.mode_gr;gr++)for(ch=0;ch<gfc.channels_out;ch++)gfc.l3_side.tt[gr][ch].block_type=Encoder.NORM_TYPE,gfc.l3_side.tt[gr][ch].mixed_block_flag=0,pe_MS[gr][ch]=pe[gr][ch]=700;if(function(gfc){var gr2_max,max_pow;if(0!=gfc.ATH.useAdjust)if(max_pow=gfc.loudness_sq[0][0],gr2_max=gfc.loudness_sq[1][0],2==gfc.channels_out?(max_pow+=gfc.loudness_sq[0][1],gr2_max+=gfc.loudness_sq[1][1]):(max_pow+=max_pow,gr2_max+=gr2_max),2==gfc.mode_gr&&(max_pow=Math.max(max_pow,gr2_max)),max_pow*=.5,(max_pow*=gfc.ATH.aaSensitivityP)>.03125)gfc.ATH.adjust>=1?gfc.ATH.adjust=1:gfc.ATH.adjust<gfc.ATH.adjustLimit&&(gfc.ATH.adjust=gfc.ATH.adjustLimit),gfc.ATH.adjustLimit=1;else{var adj_lim_new=31.98*max_pow+625e-6;gfc.ATH.adjust>=adj_lim_new?(gfc.ATH.adjust*=.075*adj_lim_new+.925,gfc.ATH.adjust<adj_lim_new&&(gfc.ATH.adjust=adj_lim_new)):gfc.ATH.adjustLimit>=adj_lim_new?gfc.ATH.adjust=adj_lim_new:gfc.ATH.adjust<gfc.ATH.adjustLimit&&(gfc.ATH.adjust=gfc.ATH.adjustLimit),gfc.ATH.adjustLimit=adj_lim_new}else gfc.ATH.adjust=1}(gfc),newMDCT.mdct_sub48(gfc,inbuf[0],inbuf[1]),gfc.mode_ext=Encoder.MPG_MD_LR_LR,gfp.force_ms)gfc.mode_ext=Encoder.MPG_MD_MS_LR;else if(gfp.mode==MPEGMode.JOINT_STEREO){var sum_pe_MS=0,sum_pe_LR=0;for(gr=0;gr<gfc.mode_gr;gr++)for(ch=0;ch<gfc.channels_out;ch++)sum_pe_MS+=pe_MS[gr][ch],sum_pe_LR+=pe[gr][ch];if(sum_pe_MS<=1*sum_pe_LR){var gi0=gfc.l3_side.tt[0],gi1=gfc.l3_side.tt[gfc.mode_gr-1];gi0[0].block_type==gi0[1].block_type&&gi1[0].block_type==gi1[1].block_type&&(gfc.mode_ext=Encoder.MPG_MD_MS_LR)}}if(gfc.mode_ext==MPG_MD_MS_LR?(masking=masking_MS,pe_use=pe_MS):(masking=masking_LR,pe_use=pe),gfp.analysis&&null!=gfc.pinfo)for(gr=0;gr<gfc.mode_gr;gr++)for(ch=0;ch<gfc.channels_out;ch++)gfc.pinfo.ms_ratio[gr]=gfc.ms_ratio[gr],gfc.pinfo.ms_ener_ratio[gr]=ms_ener_ratio[gr],gfc.pinfo.blocktype[gr][ch]=gfc.l3_side.tt[gr][ch].block_type,gfc.pinfo.pe[gr][ch]=pe_use[gr][ch],System.arraycopy(gfc.l3_side.tt[gr][ch].xr,0,gfc.pinfo.xr[gr][ch],0,576),gfc.mode_ext==MPG_MD_MS_LR&&(gfc.pinfo.ers[gr][ch]=gfc.pinfo.ers[gr][ch+2],System.arraycopy(gfc.pinfo.energy[gr][ch+2],0,gfc.pinfo.energy[gr][ch],0,gfc.pinfo.energy[gr][ch].length));if(gfp.VBR==VbrMode.vbr_off||gfp.VBR==VbrMode.vbr_abr){var i,f;for(i=0;i<18;i++)gfc.nsPsy.pefirbuf[i]=gfc.nsPsy.pefirbuf[i+1];for(f=0,gr=0;gr<gfc.mode_gr;gr++)for(ch=0;ch<gfc.channels_out;ch++)f+=pe_use[gr][ch];for(gfc.nsPsy.pefirbuf[18]=f,f=gfc.nsPsy.pefirbuf[9],i=0;i<9;i++)f+=(gfc.nsPsy.pefirbuf[i]+gfc.nsPsy.pefirbuf[18-i])*Encoder.fircoef[i];for(f=3350*gfc.mode_gr*gfc.channels_out/f,gr=0;gr<gfc.mode_gr;gr++)for(ch=0;ch<gfc.channels_out;ch++)pe_use[gr][ch]*=f}if(gfc.iteration_loop.iteration_loop(gfp,pe_use,ms_ener_ratio,masking),bs.format_bitstream(gfp),mp3count=bs.copy_buffer(gfc,mp3buf,mp3bufPos,mp3buf_size,1),gfp.bWriteVbrTag&&vbr.addVbrFrame(gfp),gfp.analysis&&null!=gfc.pinfo){for(ch=0;ch<gfc.channels_out;ch++){var j;for(j=0;j<FFTOFFSET;j++)gfc.pinfo.pcmdata[ch][j]=gfc.pinfo.pcmdata[ch][j+gfp.framesize];for(j=FFTOFFSET;j<1600;j++)gfc.pinfo.pcmdata[ch][j]=inbuf[ch][j-FFTOFFSET]}qupvt.set_frame_pinfo(gfp,masking)}return function(gfc){var gr,ch;for(gfc.bitrate_stereoMode_Hist[gfc.bitrate_index][4]++,gfc.bitrate_stereoMode_Hist[15][4]++,2==gfc.channels_out&&(gfc.bitrate_stereoMode_Hist[gfc.bitrate_index][gfc.mode_ext]++,gfc.bitrate_stereoMode_Hist[15][gfc.mode_ext]++),gr=0;gr<gfc.mode_gr;++gr)for(ch=0;ch<gfc.channels_out;++ch){var bt=0|gfc.l3_side.tt[gr][ch].block_type;0!=gfc.l3_side.tt[gr][ch].mixed_block_flag&&(bt=4),gfc.bitrate_blockType_Hist[gfc.bitrate_index][bt]++,gfc.bitrate_blockType_Hist[gfc.bitrate_index][5]++,gfc.bitrate_blockType_Hist[15][bt]++,gfc.bitrate_blockType_Hist[15][5]++}}(gfc),mp3count}}function VBRSeekInfo(){this.sum=0,this.seen=0,this.want=0,this.pos=0,this.size=0,this.bag=null,this.nVbrNumFrames=0,this.nBytesWritten=0,this.TotalFrameSize=0}function IIISideInfo(){this.tt=[[null,null],[null,null]],this.main_data_begin=0,this.private_bits=0,this.resvDrain_pre=0,this.resvDrain_post=0,this.scfsi=[new_int(4),new_int(4)];for(var gr=0;gr<2;gr++)for(var ch=0;ch<2;ch++)this.tt[gr][ch]=new GrInfo}function NsPsy(){this.last_en_subshort=new_float_n([4,9]),this.lastAttacks=new_int(4),this.pefirbuf=new_float(19),this.longfact=new_float(Encoder.SBMAX_l),this.shortfact=new_float(Encoder.SBMAX_s),this.attackthre=0,this.attackthre_s=0}function III_psy_xmin(){this.l=new_float(Encoder.SBMAX_l),this.s=new_float_n([Encoder.SBMAX_s,3]);var self=this;this.assign=function(iii_psy_xmin){System.arraycopy(iii_psy_xmin.l,0,self.l,0,Encoder.SBMAX_l);for(var i=0;i<Encoder.SBMAX_s;i++)for(var j=0;j<3;j++)self.s[i][j]=iii_psy_xmin.s[i][j]}}function LameInternalFlags(){function Header(){this.write_timing=0,this.ptr=0,this.buf=new_byte(40)}this.Class_ID=0,this.lame_encode_frame_init=0,this.iteration_init_init=0,this.fill_buffer_resample_init=0,this.mfbuf=new_float_n([2,LameInternalFlags.MFSIZE]),this.mode_gr=0,this.channels_in=0,this.channels_out=0,this.resample_ratio=0,this.mf_samples_to_encode=0,this.mf_size=0,this.VBR_min_bitrate=0,this.VBR_max_bitrate=0,this.bitrate_index=0,this.samplerate_index=0,this.mode_ext=0,this.lowpass1=0,this.lowpass2=0,this.highpass1=0,this.highpass2=0,this.noise_shaping=0,this.noise_shaping_amp=0,this.substep_shaping=0,this.psymodel=0,this.noise_shaping_stop=0,this.subblock_gain=0,this.use_best_huffman=0,this.full_outer_loop=0,this.l3_side=new IIISideInfo,this.ms_ratio=new_float(2),this.padding=0,this.frac_SpF=0,this.slot_lag=0,this.tag_spec=null,this.nMusicCRC=0,this.OldValue=new_int(2),this.CurrentStep=new_int(2),this.masking_lower=0,this.bv_scf=new_int(576),this.pseudohalf=new_int(L3Side.SFBMAX),this.sfb21_extra=!1,this.inbuf_old=new Array(2),this.blackfilt=new Array(2*LameInternalFlags.BPC+1),this.itime=new_double(2),this.sideinfo_len=0,this.sb_sample=new_float_n([2,2,18,Encoder.SBLIMIT]),this.amp_filter=new_float(32),this.header=new Array(LameInternalFlags.MAX_HEADER_BUF),this.h_ptr=0,this.w_ptr=0,this.ancillary_flag=0,this.ResvSize=0,this.ResvMax=0,this.scalefac_band=new ScaleFac,this.minval_l=new_float(Encoder.CBANDS),this.minval_s=new_float(Encoder.CBANDS),this.nb_1=new_float_n([4,Encoder.CBANDS]),this.nb_2=new_float_n([4,Encoder.CBANDS]),this.nb_s1=new_float_n([4,Encoder.CBANDS]),this.nb_s2=new_float_n([4,Encoder.CBANDS]),this.s3_ss=null,this.s3_ll=null,this.decay=0,this.thm=new Array(4),this.en=new Array(4),this.tot_ener=new_float(4),this.loudness_sq=new_float_n([2,2]),this.loudness_sq_save=new_float(2),this.mld_l=new_float(Encoder.SBMAX_l),this.mld_s=new_float(Encoder.SBMAX_s),this.bm_l=new_int(Encoder.SBMAX_l),this.bo_l=new_int(Encoder.SBMAX_l),this.bm_s=new_int(Encoder.SBMAX_s),this.bo_s=new_int(Encoder.SBMAX_s),this.npart_l=0,this.npart_s=0,this.s3ind=new_int_n([Encoder.CBANDS,2]),this.s3ind_s=new_int_n([Encoder.CBANDS,2]),this.numlines_s=new_int(Encoder.CBANDS),this.numlines_l=new_int(Encoder.CBANDS),this.rnumlines_l=new_float(Encoder.CBANDS),this.mld_cb_l=new_float(Encoder.CBANDS),this.mld_cb_s=new_float(Encoder.CBANDS),this.numlines_s_num1=0,this.numlines_l_num1=0,this.pe=new_float(4),this.ms_ratio_s_old=0,this.ms_ratio_l_old=0,this.ms_ener_ratio_old=0,this.blocktype_old=new_int(2),this.nsPsy=new NsPsy,this.VBR_seek_table=new VBRSeekInfo,this.ATH=null,this.PSY=null,this.nogap_total=0,this.nogap_current=0,this.decode_on_the_fly=!0,this.findReplayGain=!0,this.findPeakSample=!0,this.PeakSample=0,this.RadioGain=0,this.AudiophileGain=0,this.rgdata=null,this.noclipGainChange=0,this.noclipScale=0,this.bitrate_stereoMode_Hist=new_int_n([16,5]),this.bitrate_blockType_Hist=new_int_n([16,6]),this.pinfo=null,this.hip=null,this.in_buffer_nsamples=0,this.in_buffer_0=null,this.in_buffer_1=null,this.iteration_loop=null;for(var i=0;i<this.en.length;i++)this.en[i]=new III_psy_xmin;for(i=0;i<this.thm.length;i++)this.thm[i]=new III_psy_xmin;for(i=0;i<this.header.length;i++)this.header[i]=new Header}function FFT(){var window=new_float(Encoder.BLKSIZE),window_s=new_float(Encoder.BLKSIZE_s/2),costab=[.9238795325112867,.3826834323650898,.9951847266721969,.0980171403295606,.9996988186962042,.02454122852291229,.9999811752826011,.006135884649154475];function fht(fz,fzPos,n){var k4,fi,gi,tri=0,fn=fzPos+(n<<=1);k4=4;do{var s1,c1,i,k1,k2,k3,kx;kx=k4>>1,k3=(k2=k4<<1)+(k1=k4),k4=k2<<1,gi=(fi=fzPos)+kx;do{f1=fz[fi+0]-fz[fi+k1],f0=fz[fi+0]+fz[fi+k1],f3=fz[fi+k2]-fz[fi+k3],f2=fz[fi+k2]+fz[fi+k3],fz[fi+k2]=f0-f2,fz[fi+0]=f0+f2,fz[fi+k3]=f1-f3,fz[fi+k1]=f1+f3,f1=fz[gi+0]-fz[gi+k1],f0=fz[gi+0]+fz[gi+k1],f3=Util.SQRT2*fz[gi+k3],f2=Util.SQRT2*fz[gi+k2],fz[gi+k2]=f0-f2,fz[gi+0]=f0+f2,fz[gi+k3]=f1-f3,fz[gi+k1]=f1+f3,gi+=k4,fi+=k4}while(fi<fn);for(c1=costab[tri+0],s1=costab[tri+1],i=1;i<kx;i++){var c2,s2;c2=1-2*s1*s1,s2=2*s1*c1,fi=fzPos+i,gi=fzPos+k1-i;do{var a,b,g0,f0,f1,g1,f2,g2,f3,g3;b=s2*fz[fi+k1]-c2*fz[gi+k1],a=c2*fz[fi+k1]+s2*fz[gi+k1],f1=fz[fi+0]-a,f0=fz[fi+0]+a,g1=fz[gi+0]-b,g0=fz[gi+0]+b,b=s2*fz[fi+k3]-c2*fz[gi+k3],a=c2*fz[fi+k3]+s2*fz[gi+k3],f3=fz[fi+k2]-a,f2=fz[fi+k2]+a,g3=fz[gi+k2]-b,g2=fz[gi+k2]+b,b=s1*f2-c1*g3,a=c1*f2+s1*g3,fz[fi+k2]=f0-a,fz[fi+0]=f0+a,fz[gi+k3]=g1-b,fz[gi+k1]=g1+b,b=c1*g2-s1*f3,a=s1*g2+c1*f3,fz[gi+k2]=g0-a,fz[gi+0]=g0+a,fz[fi+k3]=f1-b,fz[fi+k1]=f1+b,gi+=k4,fi+=k4}while(fi<fn);c1=(c2=c1)*costab[tri+0]-s1*costab[tri+1],s1=c2*costab[tri+1]+s1*costab[tri+0]}tri+=2}while(k4<n)}var rv_tbl=[0,128,64,192,32,160,96,224,16,144,80,208,48,176,112,240,8,136,72,200,40,168,104,232,24,152,88,216,56,184,120,248,4,132,68,196,36,164,100,228,20,148,84,212,52,180,116,244,12,140,76,204,44,172,108,236,28,156,92,220,60,188,124,252,2,130,66,194,34,162,98,226,18,146,82,210,50,178,114,242,10,138,74,202,42,170,106,234,26,154,90,218,58,186,122,250,6,134,70,198,38,166,102,230,22,150,86,214,54,182,118,246,14,142,78,206,46,174,110,238,30,158,94,222,62,190,126,254];this.fft_short=function(gfc,x_real,chn,buffer,bufPos){for(var b=0;b<3;b++){var x=Encoder.BLKSIZE_s/2,k=65535&192*(b+1),j=Encoder.BLKSIZE_s/8-1;do{var f0,f1,f2,f3,w,i=255&rv_tbl[j<<2];f1=(f0=window_s[i]*buffer[chn][bufPos+i+k])-(w=window_s[127-i]*buffer[chn][bufPos+i+k+128]),f0+=w,f3=(f2=window_s[i+64]*buffer[chn][bufPos+i+k+64])-(w=window_s[63-i]*buffer[chn][bufPos+i+k+192]),f2+=w,x-=4,x_real[b][x+0]=f0+f2,x_real[b][x+2]=f0-f2,x_real[b][x+1]=f1+f3,x_real[b][x+3]=f1-f3,f1=(f0=window_s[i+1]*buffer[chn][bufPos+i+k+1])-(w=window_s[126-i]*buffer[chn][bufPos+i+k+129]),f0+=w,f3=(f2=window_s[i+65]*buffer[chn][bufPos+i+k+65])-(w=window_s[62-i]*buffer[chn][bufPos+i+k+193]),f2+=w,x_real[b][x+Encoder.BLKSIZE_s/2+0]=f0+f2,x_real[b][x+Encoder.BLKSIZE_s/2+2]=f0-f2,x_real[b][x+Encoder.BLKSIZE_s/2+1]=f1+f3,x_real[b][x+Encoder.BLKSIZE_s/2+3]=f1-f3}while(--j>=0);fht(x_real[b],x,Encoder.BLKSIZE_s/2)}},this.fft_long=function(gfc,y,chn,buffer,bufPos){var jj=Encoder.BLKSIZE/8-1,x=Encoder.BLKSIZE/2;do{var f0,f1,f2,f3,w,i=255&rv_tbl[jj];f1=(f0=window[i]*buffer[chn][bufPos+i])-(w=window[i+512]*buffer[chn][bufPos+i+512]),f0+=w,f3=(f2=window[i+256]*buffer[chn][bufPos+i+256])-(w=window[i+768]*buffer[chn][bufPos+i+768]),f2+=w,y[(x-=4)+0]=f0+f2,y[x+2]=f0-f2,y[x+1]=f1+f3,y[x+3]=f1-f3,f1=(f0=window[i+1]*buffer[chn][bufPos+i+1])-(w=window[i+513]*buffer[chn][bufPos+i+513]),f0+=w,f3=(f2=window[i+257]*buffer[chn][bufPos+i+257])-(w=window[i+769]*buffer[chn][bufPos+i+769]),f2+=w,y[x+Encoder.BLKSIZE/2+0]=f0+f2,y[x+Encoder.BLKSIZE/2+2]=f0-f2,y[x+Encoder.BLKSIZE/2+1]=f1+f3,y[x+Encoder.BLKSIZE/2+3]=f1-f3}while(--jj>=0);fht(y,x,Encoder.BLKSIZE/2)},this.init_fft=function(gfc){for(var i=0;i<Encoder.BLKSIZE;i++)window[i]=.42-.5*Math.cos(2*Math.PI*(i+.5)/Encoder.BLKSIZE)+.08*Math.cos(4*Math.PI*(i+.5)/Encoder.BLKSIZE);for(i=0;i<Encoder.BLKSIZE_s/2;i++)window_s[i]=.5*(1-Math.cos(2*Math.PI*(i+.5)/Encoder.BLKSIZE_s))}}function PsyModel(){var fft=new FFT,LOG10=2.302585092994046,VO_SCALE=1/217621504/(Encoder.BLKSIZE/2);function psycho_loudness_approx(energy,gfc){for(var loudness_power=0,i=0;i<Encoder.BLKSIZE/2;++i)loudness_power+=energy[i]*gfc.ATH.eql_w[i];return loudness_power*=VO_SCALE}function compute_ffts(gfp,fftenergy,fftenergy_s,wsamp_l,wsamp_lPos,wsamp_s,wsamp_sPos,gr_out,chn,buffer,bufPos){var gfc=gfp.internal_flags;if(chn<2)fft.fft_long(gfc,wsamp_l[wsamp_lPos],chn,buffer,bufPos),fft.fft_short(gfc,wsamp_s[wsamp_sPos],chn,buffer,bufPos);else if(2==chn){for(var j=Encoder.BLKSIZE-1;j>=0;--j){var l=wsamp_l[wsamp_lPos+0][j],r=wsamp_l[wsamp_lPos+1][j];wsamp_l[wsamp_lPos+0][j]=(l+r)*Util.SQRT2*.5,wsamp_l[wsamp_lPos+1][j]=(l-r)*Util.SQRT2*.5}for(var b=2;b>=0;--b)for(j=Encoder.BLKSIZE_s-1;j>=0;--j){l=wsamp_s[wsamp_sPos+0][b][j],r=wsamp_s[wsamp_sPos+1][b][j];wsamp_s[wsamp_sPos+0][b][j]=(l+r)*Util.SQRT2*.5,wsamp_s[wsamp_sPos+1][b][j]=(l-r)*Util.SQRT2*.5}}fftenergy[0]=wsamp_l[wsamp_lPos+0][0],fftenergy[0]*=fftenergy[0];for(j=Encoder.BLKSIZE/2-1;j>=0;--j){var re=wsamp_l[wsamp_lPos+0][Encoder.BLKSIZE/2-j],im=wsamp_l[wsamp_lPos+0][Encoder.BLKSIZE/2+j];fftenergy[Encoder.BLKSIZE/2-j]=.5*(re*re+im*im)}for(b=2;b>=0;--b){fftenergy_s[b][0]=wsamp_s[wsamp_sPos+0][b][0],fftenergy_s[b][0]*=fftenergy_s[b][0];for(j=Encoder.BLKSIZE_s/2-1;j>=0;--j){re=wsamp_s[wsamp_sPos+0][b][Encoder.BLKSIZE_s/2-j],im=wsamp_s[wsamp_sPos+0][b][Encoder.BLKSIZE_s/2+j];fftenergy_s[b][Encoder.BLKSIZE_s/2-j]=.5*(re*re+im*im)}}var totalenergy=0;for(j=11;j<Encoder.HBLKSIZE;j++)totalenergy+=fftenergy[j];if(gfc.tot_ener[chn]=totalenergy,gfp.analysis){for(j=0;j<Encoder.HBLKSIZE;j++)gfc.pinfo.energy[gr_out][chn][j]=gfc.pinfo.energy_save[chn][j],gfc.pinfo.energy_save[chn][j]=fftenergy[j];gfc.pinfo.pe[gr_out][chn]=gfc.pe[chn]}2==gfp.athaa_loudapprox&&chn<2&&(gfc.loudness_sq[gr_out][chn]=gfc.loudness_sq_save[chn],gfc.loudness_sq_save[chn]=psycho_loudness_approx(fftenergy,gfc))}var ma_max_i1,ma_max_i2,ma_max_m,tab=[1,.79433,.63096,.63096,.63096,.63096,.63096,.25119,.11749];var table1=[3.3246*3.3246,3.23837*3.23837,9.9500500969,9.0247369744,8.1854926609,7.0440875649,2.46209*2.46209,2.284*2.284,4.4892710641,1.96552*1.96552,1.82335*1.82335,1.69146*1.69146,2.4621061921,2.1508568964,1.37074*1.37074,1.31036*1.31036,1.5691069696,1.4555939904,1.16203*1.16203,1.2715945225,1.09428*1.09428,1.0659*1.0659,1.0779838276,1.0382591025,1],table2=[1.7782755904,1.35879*1.35879,1.38454*1.38454,1.39497*1.39497,1.40548*1.40548,1.3537*1.3537,1.6999465924,1.22321*1.22321,1.3169398564,1],table3=[5.5396212496,2.29259*2.29259,4.9868695969,2.12675*2.12675,2.02545*2.02545,1.87894*1.87894,1.74303*1.74303,1.61695*1.61695,2.2499700001,1.39148*1.39148,1.29083*1.29083,1.19746*1.19746,1.2339655056,1.0779838276];function mask_add(m1,m2,kk,b,gfc,shortblock){var ratio;if(m2>m1){if(!(m2<m1*ma_max_i2))return m1+m2;ratio=m2/m1}else{if(m1>=m2*ma_max_i2)return m1+m2;ratio=m1/m2}if(m1+=m2,b+3<=6){if(ratio>=ma_max_i1)return m1;var i=0|Util.FAST_LOG10_X(ratio,16);return m1*table2[i]}var f,r;i=0|Util.FAST_LOG10_X(ratio,16);return m2=0!=shortblock?gfc.ATH.cb_s[kk]*gfc.ATH.adjust:gfc.ATH.cb_l[kk]*gfc.ATH.adjust,m1<ma_max_m*m2?m1>m2?(f=1,i<=13&&(f=table3[i]),r=Util.FAST_LOG10_X(m1/m2,10/15),m1*((table1[i]-f)*r+f)):i>13?m1:m1*table3[i]:m1*table1[i]}var table2_=[1.7782755904,1.35879*1.35879,1.38454*1.38454,1.39497*1.39497,1.40548*1.40548,1.3537*1.3537,1.6999465924,1.22321*1.22321,1.3169398564,1];function vbrpsy_mask_add(m1,m2,b){var ratio;if(m1<0&&(m1=0),m2<0&&(m2=0),m1<=0)return m2;if(m2<=0)return m1;if(ratio=m2>m1?m2/m1:m1/m2,-2<=b&&b<=2){if(ratio>=ma_max_i1)return m1+m2;var i=0|Util.FAST_LOG10_X(ratio,16);return(m1+m2)*table2_[i]}return ratio<ma_max_i2?m1+m2:(m1<m2&&(m1=m2),m1)}function convert_partition2scalefac_s(gfc,eb,thr,chn,sblock){var sb,b,enn=0,thmm=0;for(sb=b=0;sb<Encoder.SBMAX_s;++b,++sb){for(var bo_s_sb=gfc.bo_s[sb],npart_s=gfc.npart_s,b_lim=bo_s_sb<npart_s?bo_s_sb:npart_s;b<b_lim;)enn+=eb[b],thmm+=thr[b],b++;if(gfc.en[chn].s[sb][sblock]=enn,gfc.thm[chn].s[sb][sblock]=thmm,b>=npart_s){++sb;break}var w_curr=gfc.PSY.bo_s_weight[sb],w_next=1-w_curr;enn=w_curr*eb[b],thmm=w_curr*thr[b],gfc.en[chn].s[sb][sblock]+=enn,gfc.thm[chn].s[sb][sblock]+=thmm,enn=w_next*eb[b],thmm=w_next*thr[b]}for(;sb<Encoder.SBMAX_s;++sb)gfc.en[chn].s[sb][sblock]=0,gfc.thm[chn].s[sb][sblock]=0}function convert_partition2scalefac_l(gfc,eb,thr,chn){var sb,b,enn=0,thmm=0;for(sb=b=0;sb<Encoder.SBMAX_l;++b,++sb){for(var bo_l_sb=gfc.bo_l[sb],npart_l=gfc.npart_l,b_lim=bo_l_sb<npart_l?bo_l_sb:npart_l;b<b_lim;)enn+=eb[b],thmm+=thr[b],b++;if(gfc.en[chn].l[sb]=enn,gfc.thm[chn].l[sb]=thmm,b>=npart_l){++sb;break}var w_curr=gfc.PSY.bo_l_weight[sb],w_next=1-w_curr;enn=w_curr*eb[b],thmm=w_curr*thr[b],gfc.en[chn].l[sb]+=enn,gfc.thm[chn].l[sb]+=thmm,enn=w_next*eb[b],thmm=w_next*thr[b]}for(;sb<Encoder.SBMAX_l;++sb)gfc.en[chn].l[sb]=0,gfc.thm[chn].l[sb]=0}function compute_masking_s(gfp,fftenergy_s,eb,thr,chn,sblock){var j,b,gfc=gfp.internal_flags;for(b=j=0;b<gfc.npart_s;++b){for(var ebb=0,m=0,n=gfc.numlines_s[b],i=0;i<n;++i,++j){var el=fftenergy_s[sblock][j];ebb+=el,m<el&&(m=el)}eb[b]=ebb}for(j=b=0;b<gfc.npart_s;b++){var kk=gfc.s3ind_s[b][0],ecb=gfc.s3_ss[j++]*eb[kk];for(++kk;kk<=gfc.s3ind_s[b][1];)ecb+=gfc.s3_ss[j]*eb[kk],++j,++kk;var x=2*gfc.nb_s1[chn][b];if(thr[b]=Math.min(ecb,x),gfc.blocktype_old[1&chn]==Encoder.SHORT_TYPE){x=16*gfc.nb_s2[chn][b];var y=thr[b];thr[b]=Math.min(x,y)}gfc.nb_s2[chn][b]=gfc.nb_s1[chn][b],gfc.nb_s1[chn][b]=ecb}for(;b<=Encoder.CBANDS;++b)eb[b]=0,thr[b]=0}function NS_INTERP(x,y,r){return r>=1?x:r<=0?y:y>0?Math.pow(x/y,r)*y:0}var regcoef_s=[11.8,13.6,17.2,32,46.5,51.3,57.5,67.1,71.5,84.6,97.6,130];function pecalc_s(mr,masking_lower){for(var pe_s=309.07,sb=0;sb<Encoder.SBMAX_s-1;sb++)for(var sblock=0;sblock<3;sblock++){var thm=mr.thm.s[sb][sblock];if(thm>0){var x=thm*masking_lower,en=mr.en.s[sb][sblock];en>x&&(pe_s+=en>1e10*x?regcoef_s[sb]*(10*LOG10):regcoef_s[sb]*Util.FAST_LOG10(en/x))}}return pe_s}var regcoef_l=[6.8,5.8,5.8,6.4,6.5,9.9,12.1,14.4,15,18.9,21.6,26.9,34.2,40.2,46.8,56.5,60.7,73.9,85.7,93.4,126.1];function pecalc_l(mr,masking_lower){for(var pe_l=281.0575,sb=0;sb<Encoder.SBMAX_l-1;sb++){var thm=mr.thm.l[sb];if(thm>0){var x=thm*masking_lower,en=mr.en.l[sb];en>x&&(pe_l+=en>1e10*x?regcoef_l[sb]*(10*LOG10):regcoef_l[sb]*Util.FAST_LOG10(en/x))}}return pe_l}function calc_energy(gfc,fftenergy,eb,max,avg){var b,j;for(b=j=0;b<gfc.npart_l;++b){var i,ebb=0,m=0;for(i=0;i<gfc.numlines_l[b];++i,++j){var el=fftenergy[j];ebb+=el,m<el&&(m=el)}eb[b]=ebb,max[b]=m,avg[b]=ebb*gfc.rnumlines_l[b]}}function calc_mask_index_l(gfc,max,avg,mask_idx){var last_tab_entry=tab.length-1,b=0,a=avg[b]+avg[b+1];a>0?((m=max[b])<max[b+1]&&(m=max[b+1]),(k=0|(a=20*(2*m-a)/(a*(gfc.numlines_l[b]+gfc.numlines_l[b+1]-1))))>last_tab_entry&&(k=last_tab_entry),mask_idx[b]=k):mask_idx[b]=0;for(b=1;b<gfc.npart_l-1;b++){var m,k;if((a=avg[b-1]+avg[b]+avg[b+1])>0)(m=max[b-1])<max[b]&&(m=max[b]),m<max[b+1]&&(m=max[b+1]),(k=0|(a=20*(3*m-a)/(a*(gfc.numlines_l[b-1]+gfc.numlines_l[b]+gfc.numlines_l[b+1]-1))))>last_tab_entry&&(k=last_tab_entry),mask_idx[b]=k;else mask_idx[b]=0}(a=avg[b-1]+avg[b])>0?((m=max[b-1])<max[b]&&(m=max[b]),(k=0|(a=20*(2*m-a)/(a*(gfc.numlines_l[b-1]+gfc.numlines_l[b]-1))))>last_tab_entry&&(k=last_tab_entry),mask_idx[b]=k):mask_idx[b]=0}var fircoef=[-1730326e-23,-.01703172,-1349528e-23,.0418072,-673278e-22,-.0876324,-30835e-21,.1863476,-1104424e-22,-.627638];function vbrpsy_compute_fft_l(gfp,buffer,bufPos,chn,gr_out,fftenergy,wsamp_l,wsamp_lPos){var gfc=gfp.internal_flags;if(chn<2)fft.fft_long(gfc,wsamp_l[wsamp_lPos],chn,buffer,bufPos);else if(2==chn)for(var j=Encoder.BLKSIZE-1;j>=0;--j){var l=wsamp_l[wsamp_lPos+0][j],r=wsamp_l[wsamp_lPos+1][j];wsamp_l[wsamp_lPos+0][j]=(l+r)*Util.SQRT2*.5,wsamp_l[wsamp_lPos+1][j]=(l-r)*Util.SQRT2*.5}fftenergy[0]=wsamp_l[wsamp_lPos+0][0],fftenergy[0]*=fftenergy[0];for(j=Encoder.BLKSIZE/2-1;j>=0;--j){var re=wsamp_l[wsamp_lPos+0][Encoder.BLKSIZE/2-j],im=wsamp_l[wsamp_lPos+0][Encoder.BLKSIZE/2+j];fftenergy[Encoder.BLKSIZE/2-j]=.5*(re*re+im*im)}var totalenergy=0;for(j=11;j<Encoder.HBLKSIZE;j++)totalenergy+=fftenergy[j];if(gfc.tot_ener[chn]=totalenergy,gfp.analysis){for(j=0;j<Encoder.HBLKSIZE;j++)gfc.pinfo.energy[gr_out][chn][j]=gfc.pinfo.energy_save[chn][j],gfc.pinfo.energy_save[chn][j]=fftenergy[j];gfc.pinfo.pe[gr_out][chn]=gfc.pe[chn]}}function vbrpsy_compute_fft_s(gfp,buffer,bufPos,chn,sblock,fftenergy_s,wsamp_s,wsamp_sPos){var gfc=gfp.internal_flags;if(0==sblock&&chn<2&&fft.fft_short(gfc,wsamp_s[wsamp_sPos],chn,buffer,bufPos),2==chn)for(var j=Encoder.BLKSIZE_s-1;j>=0;--j){var l=wsamp_s[wsamp_sPos+0][sblock][j],r=wsamp_s[wsamp_sPos+1][sblock][j];wsamp_s[wsamp_sPos+0][sblock][j]=(l+r)*Util.SQRT2*.5,wsamp_s[wsamp_sPos+1][sblock][j]=(l-r)*Util.SQRT2*.5}fftenergy_s[sblock][0]=wsamp_s[wsamp_sPos+0][sblock][0],fftenergy_s[sblock][0]*=fftenergy_s[sblock][0];for(j=Encoder.BLKSIZE_s/2-1;j>=0;--j){var re=wsamp_s[wsamp_sPos+0][sblock][Encoder.BLKSIZE_s/2-j],im=wsamp_s[wsamp_sPos+0][sblock][Encoder.BLKSIZE_s/2+j];fftenergy_s[sblock][Encoder.BLKSIZE_s/2-j]=.5*(re*re+im*im)}}function vbrpsy_compute_loudness_approximation_l(gfp,gr_out,chn,fftenergy){var gfc=gfp.internal_flags;2==gfp.athaa_loudapprox&&chn<2&&(gfc.loudness_sq[gr_out][chn]=gfc.loudness_sq_save[chn],gfc.loudness_sq_save[chn]=psycho_loudness_approx(fftenergy,gfc))}this.L3psycho_anal_ns=function(gfp,buffer,bufPos,gr_out,masking_ratio,masking_MS_ratio,percep_entropy,percep_MS_entropy,energy,blocktype_d){var numchn,chn,b,i,j,k,sb,sblock,pcfact,msfix,gfc=gfp.internal_flags,wsamp_L=new_float_n([2,Encoder.BLKSIZE]),wsamp_S=new_float_n([2,3,Encoder.BLKSIZE_s]),eb_l=new_float(Encoder.CBANDS+1),eb_s=new_float(Encoder.CBANDS+1),thr=new_float(Encoder.CBANDS+2),blocktype=new_int(2),uselongblock=new_int(2),ns_hpfsmpl=new_float_n([2,576]),mask_idx_l=new_int(Encoder.CBANDS+2),mask_idx_s=new_int(Encoder.CBANDS+2);for(Arrays.fill(mask_idx_s,0),numchn=gfc.channels_out,gfp.mode==MPEGMode.JOINT_STEREO&&(numchn=4),pcfact=gfp.VBR==VbrMode.vbr_off?0==gfc.ResvMax?0:gfc.ResvSize/gfc.ResvMax*.5:gfp.VBR==VbrMode.vbr_rh||gfp.VBR==VbrMode.vbr_mtrh||gfp.VBR==VbrMode.vbr_mt?.6:1,chn=0;chn<gfc.channels_out;chn++){var firbuf=buffer[chn],firbufPos=bufPos+576-350-21+192;for(i=0;i<576;i++){var sum1,sum2;for(sum1=firbuf[firbufPos+i+10],sum2=0,j=0;j<9;j+=2)sum1+=fircoef[j]*(firbuf[firbufPos+i+j]+firbuf[firbufPos+i+21-j]),sum2+=fircoef[j+1]*(firbuf[firbufPos+i+j+1]+firbuf[firbufPos+i+21-j-1]);ns_hpfsmpl[chn][i]=sum1+sum2}masking_ratio[gr_out][chn].en.assign(gfc.en[chn]),masking_ratio[gr_out][chn].thm.assign(gfc.thm[chn]),numchn>2&&(masking_MS_ratio[gr_out][chn].en.assign(gfc.en[chn+2]),masking_MS_ratio[gr_out][chn].thm.assign(gfc.thm[chn+2]))}for(chn=0;chn<numchn;chn++){var attackThreshold,en_subshort=new_float(12),en_short=[0,0,0,0],attack_intensity=new_float(12),ns_uselongblock=1,max=new_float(Encoder.CBANDS),avg=new_float(Encoder.CBANDS),ns_attacks=[0,0,0,0],fftenergy=new_float(Encoder.HBLKSIZE),fftenergy_s=new_float_n([3,Encoder.HBLKSIZE_s]);for(i=0;i<3;i++)en_subshort[i]=gfc.nsPsy.last_en_subshort[chn][i+6],attack_intensity[i]=en_subshort[i]/gfc.nsPsy.last_en_subshort[chn][i+4],en_short[0]+=en_subshort[i];if(2==chn)for(i=0;i<576;i++){var l,r;l=ns_hpfsmpl[0][i],r=ns_hpfsmpl[1][i],ns_hpfsmpl[0][i]=l+r,ns_hpfsmpl[1][i]=l-r}var pf=ns_hpfsmpl[1&chn],pfPos=0;for(i=0;i<9;i++){for(var pfe=pfPos+64,p=1;pfPos<pfe;pfPos++)p<Math.abs(pf[pfPos])&&(p=Math.abs(pf[pfPos]));gfc.nsPsy.last_en_subshort[chn][i]=en_subshort[i+3]=p,en_short[1+i/3]+=p,p>en_subshort[i+3-2]?p/=en_subshort[i+3-2]:p=en_subshort[i+3-2]>10*p?en_subshort[i+3-2]/(10*p):0,attack_intensity[i+3]=p}if(gfp.analysis){var x=attack_intensity[0];for(i=1;i<12;i++)x<attack_intensity[i]&&(x=attack_intensity[i]);gfc.pinfo.ers[gr_out][chn]=gfc.pinfo.ers_save[chn],gfc.pinfo.ers_save[chn]=x}for(attackThreshold=3==chn?gfc.nsPsy.attackthre_s:gfc.nsPsy.attackthre,i=0;i<12;i++)0==ns_attacks[i/3]&&attack_intensity[i]>attackThreshold&&(ns_attacks[i/3]=i%3+1);for(i=1;i<4;i++){(en_short[i-1]>en_short[i]?en_short[i-1]/en_short[i]:en_short[i]/en_short[i-1])<1.7&&(ns_attacks[i]=0,1==i&&(ns_attacks[0]=0))}for(0!=ns_attacks[0]&&0!=gfc.nsPsy.lastAttacks[chn]&&(ns_attacks[0]=0),3!=gfc.nsPsy.lastAttacks[chn]&&ns_attacks[0]+ns_attacks[1]+ns_attacks[2]+ns_attacks[3]==0||(ns_uselongblock=0,0!=ns_attacks[1]&&0!=ns_attacks[0]&&(ns_attacks[1]=0),0!=ns_attacks[2]&&0!=ns_attacks[1]&&(ns_attacks[2]=0),0!=ns_attacks[3]&&0!=ns_attacks[2]&&(ns_attacks[3]=0)),chn<2?uselongblock[chn]=ns_uselongblock:0==ns_uselongblock&&(uselongblock[0]=uselongblock[1]=0),energy[chn]=gfc.tot_ener[chn],compute_ffts(gfp,fftenergy,fftenergy_s,wsamp_L,1&chn,wsamp_S,1&chn,gr_out,chn,buffer,bufPos),calc_energy(gfc,fftenergy,eb_l,max,avg),calc_mask_index_l(gfc,max,avg,mask_idx_l),sblock=0;sblock<3;sblock++){var enn,thmm;for(compute_masking_s(gfp,fftenergy_s,eb_s,thr,chn,sblock),convert_partition2scalefac_s(gfc,eb_s,thr,chn,sblock),sb=0;sb<Encoder.SBMAX_s;sb++){if(thmm=gfc.thm[chn].s[sb][sblock],thmm*=.8,ns_attacks[sblock]>=2||1==ns_attacks[sblock+1]){var idx=0!=sblock?sblock-1:2;p=NS_INTERP(gfc.thm[chn].s[sb][idx],thmm,.6*pcfact);thmm=Math.min(thmm,p)}if(1==ns_attacks[sblock]){idx=0!=sblock?sblock-1:2,p=NS_INTERP(gfc.thm[chn].s[sb][idx],thmm,.3*pcfact);thmm=Math.min(thmm,p)}else if(0!=sblock&&3==ns_attacks[sblock-1]||0==sblock&&3==gfc.nsPsy.lastAttacks[chn]){idx=2!=sblock?sblock+1:0,p=NS_INTERP(gfc.thm[chn].s[sb][idx],thmm,.3*pcfact);thmm=Math.min(thmm,p)}enn=en_subshort[3*sblock+3]+en_subshort[3*sblock+4]+en_subshort[3*sblock+5],6*en_subshort[3*sblock+5]<enn&&(thmm*=.5,6*en_subshort[3*sblock+4]<enn&&(thmm*=.5)),gfc.thm[chn].s[sb][sblock]=thmm}}for(gfc.nsPsy.lastAttacks[chn]=ns_attacks[2],k=0,b=0;b<gfc.npart_l;b++){for(var kk=gfc.s3ind[b][0],eb2=eb_l[kk]*tab[mask_idx_l[kk]],ecb=gfc.s3_ll[k++]*eb2;++kk<=gfc.s3ind[b][1];)eb2=eb_l[kk]*tab[mask_idx_l[kk]],ecb=mask_add(ecb,gfc.s3_ll[k++]*eb2,kk,kk-b,gfc,0);ecb*=.158489319246111,gfc.blocktype_old[1&chn]==Encoder.SHORT_TYPE?thr[b]=ecb:thr[b]=NS_INTERP(Math.min(ecb,Math.min(2*gfc.nb_1[chn][b],16*gfc.nb_2[chn][b])),ecb,pcfact),gfc.nb_2[chn][b]=gfc.nb_1[chn][b],gfc.nb_1[chn][b]=ecb}for(;b<=Encoder.CBANDS;++b)eb_l[b]=0,thr[b]=0;convert_partition2scalefac_l(gfc,eb_l,thr,chn)}(gfp.mode!=MPEGMode.STEREO&&gfp.mode!=MPEGMode.JOINT_STEREO||gfp.interChRatio>0&&function(gfp,ratio){var gfc=gfp.internal_flags;if(gfc.channels_out>1){for(var sb=0;sb<Encoder.SBMAX_l;sb++){var l=gfc.thm[0].l[sb],r=gfc.thm[1].l[sb];gfc.thm[0].l[sb]+=r*ratio,gfc.thm[1].l[sb]+=l*ratio}for(sb=0;sb<Encoder.SBMAX_s;sb++)for(var sblock=0;sblock<3;sblock++)l=gfc.thm[0].s[sb][sblock],r=gfc.thm[1].s[sb][sblock],gfc.thm[0].s[sb][sblock]+=r*ratio,gfc.thm[1].s[sb][sblock]+=l*ratio}}(gfp,gfp.interChRatio),gfp.mode==MPEGMode.JOINT_STEREO)&&(!function(gfc){for(var sb=0;sb<Encoder.SBMAX_l;sb++)if(!(gfc.thm[0].l[sb]>1.58*gfc.thm[1].l[sb]||gfc.thm[1].l[sb]>1.58*gfc.thm[0].l[sb])){var mld=gfc.mld_l[sb]*gfc.en[3].l[sb],rmid=Math.max(gfc.thm[2].l[sb],Math.min(gfc.thm[3].l[sb],mld));mld=gfc.mld_l[sb]*gfc.en[2].l[sb];var rside=Math.max(gfc.thm[3].l[sb],Math.min(gfc.thm[2].l[sb],mld));gfc.thm[2].l[sb]=rmid,gfc.thm[3].l[sb]=rside}for(sb=0;sb<Encoder.SBMAX_s;sb++)for(var sblock=0;sblock<3;sblock++)gfc.thm[0].s[sb][sblock]>1.58*gfc.thm[1].s[sb][sblock]||gfc.thm[1].s[sb][sblock]>1.58*gfc.thm[0].s[sb][sblock]||(mld=gfc.mld_s[sb]*gfc.en[3].s[sb][sblock],rmid=Math.max(gfc.thm[2].s[sb][sblock],Math.min(gfc.thm[3].s[sb][sblock],mld)),mld=gfc.mld_s[sb]*gfc.en[2].s[sb][sblock],rside=Math.max(gfc.thm[3].s[sb][sblock],Math.min(gfc.thm[2].s[sb][sblock],mld)),gfc.thm[2].s[sb][sblock]=rmid,gfc.thm[3].s[sb][sblock]=rside)}(gfc),msfix=gfp.msfix,Math.abs(msfix)>0&&function(gfc,msfix,athadjust){var msfix2=msfix,athlower=Math.pow(10,athadjust);msfix*=2,msfix2*=2;for(var sb=0;sb<Encoder.SBMAX_l;sb++)ath=gfc.ATH.cb_l[gfc.bm_l[sb]]*athlower,(thmLR=Math.min(Math.max(gfc.thm[0].l[sb],ath),Math.max(gfc.thm[1].l[sb],ath)))*msfix<(thmM=Math.max(gfc.thm[2].l[sb],ath))+(thmS=Math.max(gfc.thm[3].l[sb],ath))&&(thmM*=f=thmLR*msfix2/(thmM+thmS),thmS*=f),gfc.thm[2].l[sb]=Math.min(thmM,gfc.thm[2].l[sb]),gfc.thm[3].l[sb]=Math.min(thmS,gfc.thm[3].l[sb]);for(athlower*=Encoder.BLKSIZE_s/Encoder.BLKSIZE,sb=0;sb<Encoder.SBMAX_s;sb++)for(var sblock=0;sblock<3;sblock++){var thmLR,thmM,thmS,ath,f;ath=gfc.ATH.cb_s[gfc.bm_s[sb]]*athlower,(thmLR=Math.min(Math.max(gfc.thm[0].s[sb][sblock],ath),Math.max(gfc.thm[1].s[sb][sblock],ath)))*msfix<(thmM=Math.max(gfc.thm[2].s[sb][sblock],ath))+(thmS=Math.max(gfc.thm[3].s[sb][sblock],ath))&&(thmM*=f=thmLR*msfix/(thmM+thmS),thmS*=f),gfc.thm[2].s[sb][sblock]=Math.min(gfc.thm[2].s[sb][sblock],thmM),gfc.thm[3].s[sb][sblock]=Math.min(gfc.thm[3].s[sb][sblock],thmS)}}(gfc,msfix,gfp.ATHlower*gfc.ATH.adjust));for(function(gfp,uselongblock,blocktype_d,blocktype){var gfc=gfp.internal_flags;gfp.short_blocks!=ShortBlock.short_block_coupled||0!=uselongblock[0]&&0!=uselongblock[1]||(uselongblock[0]=uselongblock[1]=0);for(var chn=0;chn<gfc.channels_out;chn++)blocktype[chn]=Encoder.NORM_TYPE,gfp.short_blocks==ShortBlock.short_block_dispensed&&(uselongblock[chn]=1),gfp.short_blocks==ShortBlock.short_block_forced&&(uselongblock[chn]=0),0!=uselongblock[chn]?gfc.blocktype_old[chn]==Encoder.SHORT_TYPE&&(blocktype[chn]=Encoder.STOP_TYPE):(blocktype[chn]=Encoder.SHORT_TYPE,gfc.blocktype_old[chn]==Encoder.NORM_TYPE&&(gfc.blocktype_old[chn]=Encoder.START_TYPE),gfc.blocktype_old[chn]==Encoder.STOP_TYPE&&(gfc.blocktype_old[chn]=Encoder.SHORT_TYPE)),blocktype_d[chn]=gfc.blocktype_old[chn],gfc.blocktype_old[chn]=blocktype[chn]}(gfp,uselongblock,blocktype_d,blocktype),chn=0;chn<numchn;chn++){var ppe,type,mr,ppePos=0;chn>1?(ppe=percep_MS_entropy,ppePos=-2,type=Encoder.NORM_TYPE,blocktype_d[0]!=Encoder.SHORT_TYPE&&blocktype_d[1]!=Encoder.SHORT_TYPE||(type=Encoder.SHORT_TYPE),mr=masking_MS_ratio[gr_out][chn-2]):(ppe=percep_entropy,ppePos=0,type=blocktype_d[chn],mr=masking_ratio[gr_out][chn]),type==Encoder.SHORT_TYPE?ppe[ppePos+chn]=pecalc_s(mr,gfc.masking_lower):ppe[ppePos+chn]=pecalc_l(mr,gfc.masking_lower),gfp.analysis&&(gfc.pinfo.pe[gr_out][chn]=ppe[ppePos+chn])}return 0};var fircoef_=[-1730326e-23,-.01703172,-1349528e-23,.0418072,-673278e-22,-.0876324,-30835e-21,.1863476,-1104424e-22,-.627638];function vbrpsy_skip_masking_s(gfc,chn,sblock){if(0==sblock)for(var b=0;b<gfc.npart_s;b++)gfc.nb_s2[chn][b]=gfc.nb_s1[chn][b],gfc.nb_s1[chn][b]=0}function vbrpsy_skip_masking_l(gfc,chn){for(var b=0;b<gfc.npart_l;b++)gfc.nb_2[chn][b]=gfc.nb_1[chn][b],gfc.nb_1[chn][b]=0}function vbrpsy_compute_masking_s(gfp,fftenergy_s,eb,thr,chn,sblock){var i,j,b,gfc=gfp.internal_flags,max=new float[Encoder.CBANDS],avg=new_float(Encoder.CBANDS),mask_idx_s=new int[Encoder.CBANDS];for(b=j=0;b<gfc.npart_s;++b){var ebb=0,m=0,n=gfc.numlines_s[b];for(i=0;i<n;++i,++j){var el=fftenergy_s[sblock][j];ebb+=el,m<el&&(m=el)}eb[b]=ebb,max[b]=m,avg[b]=ebb/n}for(;b<Encoder.CBANDS;++b)max[b]=0,avg[b]=0;for(function(gfc,max,avg,mask_idx){var last_tab_entry=tab.length-1,b=0,a=avg[b]+avg[b+1];for(a>0?((m=max[b])<max[b+1]&&(m=max[b+1]),(k=0|(a=20*(2*m-a)/(a*(gfc.numlines_s[b]+gfc.numlines_s[b+1]-1))))>last_tab_entry&&(k=last_tab_entry),mask_idx[b]=k):mask_idx[b]=0,b=1;b<gfc.npart_s-1;b++){var m,k;(a=avg[b-1]+avg[b]+avg[b+1])>0?((m=max[b-1])<max[b]&&(m=max[b]),m<max[b+1]&&(m=max[b+1]),(k=0|(a=20*(3*m-a)/(a*(gfc.numlines_s[b-1]+gfc.numlines_s[b]+gfc.numlines_s[b+1]-1))))>last_tab_entry&&(k=last_tab_entry),mask_idx[b]=k):mask_idx[b]=0}(a=avg[b-1]+avg[b])>0?((m=max[b-1])<max[b]&&(m=max[b]),(k=0|(a=20*(2*m-a)/(a*(gfc.numlines_s[b-1]+gfc.numlines_s[b]-1))))>last_tab_entry&&(k=last_tab_entry),mask_idx[b]=k):mask_idx[b]=0}(gfc,max,avg,mask_idx_s),j=b=0;b<gfc.npart_s;b++){var dd,dd_n,x,ecb,avg_mask,kk=gfc.s3ind_s[b][0],last=gfc.s3ind_s[b][1];for(dd=mask_idx_s[kk],dd_n=1,ecb=gfc.s3_ss[j]*eb[kk]*tab[mask_idx_s[kk]],++j,++kk;kk<=last;)dd+=mask_idx_s[kk],dd_n+=1,ecb=vbrpsy_mask_add(ecb,x=gfc.s3_ss[j]*eb[kk]*tab[mask_idx_s[kk]],kk-b),++j,++kk;ecb*=avg_mask=.5*tab[dd=(1+2*dd)/(2*dd_n)],thr[b]=ecb,gfc.nb_s2[chn][b]=gfc.nb_s1[chn][b],gfc.nb_s1[chn][b]=ecb,x=max[b],x*=gfc.minval_s[b],x*=avg_mask,thr[b]>x&&(thr[b]=x),gfc.masking_lower>1&&(thr[b]*=gfc.masking_lower),thr[b]>eb[b]&&(thr[b]=eb[b]),gfc.masking_lower<1&&(thr[b]*=gfc.masking_lower)}for(;b<Encoder.CBANDS;++b)eb[b]=0,thr[b]=0}function vbrpsy_compute_masking_l(gfc,fftenergy,eb_l,thr,chn){var b,max=new_float(Encoder.CBANDS),avg=new_float(Encoder.CBANDS),mask_idx_l=new_int(Encoder.CBANDS+2);calc_energy(gfc,fftenergy,eb_l,max,avg),calc_mask_index_l(gfc,max,avg,mask_idx_l);var k=0;for(b=0;b<gfc.npart_l;b++){var x,ecb,avg_mask,kk=gfc.s3ind[b][0],last=gfc.s3ind[b][1],dd=0,dd_n=0;for(dd=mask_idx_l[kk],dd_n+=1,ecb=gfc.s3_ll[k]*eb_l[kk]*tab[mask_idx_l[kk]],++k,++kk;kk<=last;)dd+=mask_idx_l[kk],dd_n+=1,ecb=vbrpsy_mask_add(ecb,x=gfc.s3_ll[k]*eb_l[kk]*tab[mask_idx_l[kk]],kk-b),++k,++kk;if(ecb*=avg_mask=.5*tab[dd=(1+2*dd)/(2*dd_n)],gfc.blocktype_old[1&chn]==Encoder.SHORT_TYPE){var ecb_limit=2*gfc.nb_1[chn][b];thr[b]=ecb_limit>0?Math.min(ecb,ecb_limit):Math.min(ecb,.3*eb_l[b])}else{var ecb_limit_2=16*gfc.nb_2[chn][b],ecb_limit_1=2*gfc.nb_1[chn][b];ecb_limit_2<=0&&(ecb_limit_2=ecb),ecb_limit_1<=0&&(ecb_limit_1=ecb),ecb_limit=gfc.blocktype_old[1&chn]==Encoder.NORM_TYPE?Math.min(ecb_limit_1,ecb_limit_2):ecb_limit_1,thr[b]=Math.min(ecb,ecb_limit)}gfc.nb_2[chn][b]=gfc.nb_1[chn][b],gfc.nb_1[chn][b]=ecb,x=max[b],x*=gfc.minval_l[b],x*=avg_mask,thr[b]>x&&(thr[b]=x),gfc.masking_lower>1&&(thr[b]*=gfc.masking_lower),thr[b]>eb_l[b]&&(thr[b]=eb_l[b]),gfc.masking_lower<1&&(thr[b]*=gfc.masking_lower)}for(;b<Encoder.CBANDS;++b)eb_l[b]=0,thr[b]=0}function vbrpsy_compute_MS_thresholds(eb,thr,cb_mld,ath_cb,athadjust,msfix,n){for(var rside,rmid,msfix2=2*msfix,athlower=msfix>0?Math.pow(10,athadjust):1,b=0;b<n;++b){var ebM=eb[2][b],ebS=eb[3][b],thmL=thr[0][b],thmR=thr[1][b],thmM=thr[2][b],thmS=thr[3][b];if(thmL<=1.58*thmR&&thmR<=1.58*thmL){var mld_m=cb_mld[b]*ebS,mld_s=cb_mld[b]*ebM;rmid=Math.max(thmM,Math.min(thmS,mld_m)),rside=Math.max(thmS,Math.min(thmM,mld_s))}else rmid=thmM,rside=thmS;if(msfix>0){var thmLR,thmMS,ath=ath_cb[b]*athlower;if(thmLR=Math.min(Math.max(thmL,ath),Math.max(thmR,ath)),(thmMS=(thmM=Math.max(rmid,ath))+(thmS=Math.max(rside,ath)))>0&&thmLR*msfix2<thmMS){var f=thmLR*msfix2/thmMS;thmM*=f,thmS*=f}rmid=Math.min(thmM,rmid),rside=Math.min(thmS,rside)}rmid>ebM&&(rmid=ebM),rside>ebS&&(rside=ebS),thr[2][b]=rmid,thr[3][b]=rside}}function s3_func_x(bark,hf_slope){var tempy;return(tempy=bark>=0?27*-bark:bark*hf_slope)<=-72?0:Math.exp(.2302585093*tempy)}function norm_s3_func_x(hf_slope){var lim_a,lim_b,x=0;for(x=0;s3_func_x(x,hf_slope)>1e-20;x-=1);for(l=x,h=0;Math.abs(h-l)>1e-12;)s3_func_x(x=(h+l)/2,hf_slope)>0?h=x:l=x;lim_a=l;var l,h;x=0;for(x=0;s3_func_x(x,hf_slope)>1e-20;x+=1);for(l=0,h=x;Math.abs(h-l)>1e-12;)s3_func_x(x=(h+l)/2,hf_slope)>0?l=x:h=x;lim_b=h;var i,sum=0,m=1e3;for(i=0;i<=m;++i){sum+=s3_func_x(x=lim_a+i*(lim_b-lim_a)/m,hf_slope)}return(m+1)/(sum*(lim_b-lim_a))}function freq2bark(freq){return freq<0&&(freq=0),freq*=.001,13*Math.atan(.76*freq)+3.5*Math.atan(freq*freq/56.25)}function init_numline(numlines,bo,bm,bval,bval_width,mld,bo_w,sfreq,blksize,scalepos,deltafreq,sbmax){var i,b_frq=new_float(Encoder.CBANDS+1),sample_freq_frac=sfreq/(sbmax>15?1152:384),partition=new_int(Encoder.HBLKSIZE);sfreq/=blksize;var j=0,ni=0;for(i=0;i<Encoder.CBANDS;i++){var j2;for(bark1=freq2bark(sfreq*j),b_frq[i]=sfreq*j,j2=j;freq2bark(sfreq*j2)-bark1<.34&&j2<=blksize/2;j2++);for(numlines[i]=j2-j,ni=i+1;j<j2;)partition[j++]=i;if(j>blksize/2){j=blksize/2,++i;break}}b_frq[i]=sfreq*j;for(var sfb=0;sfb<sbmax;sfb++){var i1,i2,start,end,arg;start=scalepos[sfb],end=scalepos[sfb+1],(i1=0|Math.floor(.5+deltafreq*(start-.5)))<0&&(i1=0),(i2=0|Math.floor(.5+deltafreq*(end-.5)))>blksize/2&&(i2=blksize/2),bm[sfb]=(partition[i1]+partition[i2])/2,bo[sfb]=partition[i2];var f_tmp=sample_freq_frac*end;bo_w[sfb]=(f_tmp-b_frq[bo[sfb]])/(b_frq[bo[sfb]+1]-b_frq[bo[sfb]]),bo_w[sfb]<0?bo_w[sfb]=0:bo_w[sfb]>1&&(bo_w[sfb]=1),arg=freq2bark(sfreq*scalepos[sfb]*deltafreq),arg=Math.min(arg,15.5)/15.5,mld[sfb]=Math.pow(10,1.25*(1-Math.cos(Math.PI*arg))-2.5)}j=0;for(var k=0;k<ni;k++){var bark1,bark2,w=numlines[k];bark1=freq2bark(sfreq*j),bark2=freq2bark(sfreq*(j+w-1)),bval[k]=.5*(bark1+bark2),bark1=freq2bark(sfreq*(j-.5)),bark2=freq2bark(sfreq*(j+w-.5)),bval_width[k]=bark2-bark1,j+=w}return ni}function init_s3_values(s3ind,npart,bval,bval_width,norm,use_old_s3){var j,bark,tempx,x,tempy,temp,s3=new_float_n([Encoder.CBANDS,Encoder.CBANDS]),numberOfNoneZero=0;if(use_old_s3)for(var i=0;i<npart;i++)for(j=0;j<npart;j++){var v=(bark=bval[i]-bval[j],tempx=void 0,x=void 0,tempy=void 0,temp=void 0,tempx=bark,x=(tempx*=tempx>=0?3:1.5)>=.5&&tempx<=2.5?8*((temp=tempx-.5)*temp-2*temp):0,((tempy=15.811389+7.5*(tempx+=.474)-17.5*Math.sqrt(1+tempx*tempx))<=-60?0:(tempx=Math.exp(.2302585093*(x+tempy)),tempx/=.6609193))*bval_width[j]);s3[i][j]=v*norm[i]}else for(j=0;j<npart;j++){var hf_slope=15+Math.min(21/bval[j],12),s3_x_norm=norm_s3_func_x(hf_slope);for(i=0;i<npart;i++){v=s3_x_norm*s3_func_x(bval[i]-bval[j],hf_slope)*bval_width[j];s3[i][j]=v*norm[i]}}for(i=0;i<npart;i++){for(j=0;j<npart&&!(s3[i][j]>0);j++);for(s3ind[i][0]=j,j=npart-1;j>0&&!(s3[i][j]>0);j--);s3ind[i][1]=j,numberOfNoneZero+=s3ind[i][1]-s3ind[i][0]+1}var p=new_float(numberOfNoneZero),k=0;for(i=0;i<npart;i++)for(j=s3ind[i][0];j<=s3ind[i][1];j++)p[k++]=s3[i][j];return p}function stereo_demask(f){var arg=freq2bark(f);return arg=Math.min(arg,15.5)/15.5,Math.pow(10,1.25*(1-Math.cos(Math.PI*arg))-2.5)}function ATHformula_GB(f,value){return f<-.3&&(f=3410),f/=1e3,f=Math.max(.1,f),3.64*Math.pow(f,-.8)-6.8*Math.exp(-.6*Math.pow(f-3.4,2))+6*Math.exp(-.15*Math.pow(f-8.7,2))+.001*(.6+.04*value)*Math.pow(f,4)}this.L3psycho_anal_vbr=function(gfp,buffer,bufPos,gr_out,masking_ratio,masking_MS_ratio,percep_entropy,percep_MS_entropy,energy,blocktype_d){var gfc=gfp.internal_flags,fftenergy=new_float(Encoder.HBLKSIZE),fftenergy_s=new_float_n([3,Encoder.HBLKSIZE_s]),wsamp_L=new_float_n([2,Encoder.BLKSIZE]),wsamp_S=new_float_n([2,3,Encoder.BLKSIZE_s]),eb=new_float_n([4,Encoder.CBANDS]),thr=new_float_n([4,Encoder.CBANDS]),sub_short_factor=new_float_n([4,3]),ns_attacks=[[0,0,0,0],[0,0,0,0],[0,0,0,0],[0,0,0,0]],uselongblock=new_int(2),n_chn_psy=gfp.mode==MPEGMode.JOINT_STEREO?4:gfc.channels_out;!function(gfp,buffer,bufPos,gr_out,masking_ratio,masking_MS_ratio,energy,sub_short_factor,ns_attacks,uselongblock){for(var ns_hpfsmpl=new_float_n([2,576]),gfc=gfp.internal_flags,n_chn_out=gfc.channels_out,n_chn_psy=gfp.mode==MPEGMode.JOINT_STEREO?4:n_chn_out,chn=0;chn<n_chn_out;chn++){firbuf=buffer[chn];for(var firbufPos=bufPos+576-350-21+192,i=0;i<576;i++){var sum1,sum2;sum1=firbuf[firbufPos+i+10],sum2=0;for(var j=0;j<9;j+=2)sum1+=fircoef_[j]*(firbuf[firbufPos+i+j]+firbuf[firbufPos+i+21-j]),sum2+=fircoef_[j+1]*(firbuf[firbufPos+i+j+1]+firbuf[firbufPos+i+21-j-1]);ns_hpfsmpl[chn][i]=sum1+sum2}masking_ratio[gr_out][chn].en.assign(gfc.en[chn]),masking_ratio[gr_out][chn].thm.assign(gfc.thm[chn]),n_chn_psy>2&&(masking_MS_ratio[gr_out][chn].en.assign(gfc.en[chn+2]),masking_MS_ratio[gr_out][chn].thm.assign(gfc.thm[chn+2]))}for(chn=0;chn<n_chn_psy;chn++){var attack_intensity=new_float(12),en_subshort=new_float(12),en_short=[0,0,0,0],pf=ns_hpfsmpl[1&chn],pfPos=0,attackThreshold=3==chn?gfc.nsPsy.attackthre_s:gfc.nsPsy.attackthre,ns_uselongblock=1;if(2==chn)for(i=0,j=576;j>0;++i,--j){var l=ns_hpfsmpl[0][i],r=ns_hpfsmpl[1][i];ns_hpfsmpl[0][i]=l+r,ns_hpfsmpl[1][i]=l-r}for(i=0;i<3;i++)en_subshort[i]=gfc.nsPsy.last_en_subshort[chn][i+6],attack_intensity[i]=en_subshort[i]/gfc.nsPsy.last_en_subshort[chn][i+4],en_short[0]+=en_subshort[i];for(i=0;i<9;i++){for(var pfe=pfPos+64,p=1;pfPos<pfe;pfPos++)p<Math.abs(pf[pfPos])&&(p=Math.abs(pf[pfPos]));gfc.nsPsy.last_en_subshort[chn][i]=en_subshort[i+3]=p,en_short[1+i/3]+=p,p>en_subshort[i+3-2]?p/=en_subshort[i+3-2]:p=en_subshort[i+3-2]>10*p?en_subshort[i+3-2]/(10*p):0,attack_intensity[i+3]=p}for(i=0;i<3;++i){var enn=en_subshort[3*i+3]+en_subshort[3*i+4]+en_subshort[3*i+5],factor=1;6*en_subshort[3*i+5]<enn&&(factor*=.5,6*en_subshort[3*i+4]<enn&&(factor*=.5)),sub_short_factor[chn][i]=factor}if(gfp.analysis){var x=attack_intensity[0];for(i=1;i<12;i++)x<attack_intensity[i]&&(x=attack_intensity[i]);gfc.pinfo.ers[gr_out][chn]=gfc.pinfo.ers_save[chn],gfc.pinfo.ers_save[chn]=x}for(i=0;i<12;i++)0==ns_attacks[chn][i/3]&&attack_intensity[i]>attackThreshold&&(ns_attacks[chn][i/3]=i%3+1);for(i=1;i<4;i++){var u=en_short[i-1],v=en_short[i];Math.max(u,v)<4e4&&u<1.7*v&&v<1.7*u&&(1==i&&ns_attacks[chn][0]<=ns_attacks[chn][i]&&(ns_attacks[chn][0]=0),ns_attacks[chn][i]=0)}ns_attacks[chn][0]<=gfc.nsPsy.lastAttacks[chn]&&(ns_attacks[chn][0]=0),3!=gfc.nsPsy.lastAttacks[chn]&&ns_attacks[chn][0]+ns_attacks[chn][1]+ns_attacks[chn][2]+ns_attacks[chn][3]==0||(ns_uselongblock=0,0!=ns_attacks[chn][1]&&0!=ns_attacks[chn][0]&&(ns_attacks[chn][1]=0),0!=ns_attacks[chn][2]&&0!=ns_attacks[chn][1]&&(ns_attacks[chn][2]=0),0!=ns_attacks[chn][3]&&0!=ns_attacks[chn][2]&&(ns_attacks[chn][3]=0)),chn<2?uselongblock[chn]=ns_uselongblock:0==ns_uselongblock&&(uselongblock[0]=uselongblock[1]=0),energy[chn]=gfc.tot_ener[chn]}}(gfp,buffer,bufPos,gr_out,masking_ratio,masking_MS_ratio,energy,sub_short_factor,ns_attacks,uselongblock),function(gfp,uselongblock){var gfc=gfp.internal_flags;gfp.short_blocks!=ShortBlock.short_block_coupled||0!=uselongblock[0]&&0!=uselongblock[1]||(uselongblock[0]=uselongblock[1]=0);for(var chn=0;chn<gfc.channels_out;chn++)gfp.short_blocks==ShortBlock.short_block_dispensed&&(uselongblock[chn]=1),gfp.short_blocks==ShortBlock.short_block_forced&&(uselongblock[chn]=0)}(gfp,uselongblock);for(var chn=0;chn<n_chn_psy;chn++){vbrpsy_compute_fft_l(gfp,buffer,bufPos,chn,gr_out,fftenergy,wsamp_L,ch01=1&chn),vbrpsy_compute_loudness_approximation_l(gfp,gr_out,chn,fftenergy),0!=uselongblock[ch01]?vbrpsy_compute_masking_l(gfc,fftenergy,eb[chn],thr[chn],chn):vbrpsy_skip_masking_l(gfc,chn)}uselongblock[0]+uselongblock[1]==2&&gfp.mode==MPEGMode.JOINT_STEREO&&vbrpsy_compute_MS_thresholds(eb,thr,gfc.mld_cb_l,gfc.ATH.cb_l,gfp.ATHlower*gfc.ATH.adjust,gfp.msfix,gfc.npart_l);for(chn=0;chn<n_chn_psy;chn++){0!=uselongblock[ch01=1&chn]&&convert_partition2scalefac_l(gfc,eb[chn],thr[chn],chn)}for(var sblock=0;sblock<3;sblock++){for(chn=0;chn<n_chn_psy;++chn){0!=uselongblock[ch01=1&chn]?vbrpsy_skip_masking_s(gfc,chn,sblock):(vbrpsy_compute_fft_s(gfp,buffer,bufPos,chn,sblock,fftenergy_s,wsamp_S,ch01),vbrpsy_compute_masking_s(gfp,fftenergy_s,eb[chn],thr[chn],chn,sblock))}uselongblock[0]+uselongblock[1]==0&&gfp.mode==MPEGMode.JOINT_STEREO&&vbrpsy_compute_MS_thresholds(eb,thr,gfc.mld_cb_s,gfc.ATH.cb_s,gfp.ATHlower*gfc.ATH.adjust,gfp.msfix,gfc.npart_s);for(chn=0;chn<n_chn_psy;++chn){0==uselongblock[ch01=1&chn]&&convert_partition2scalefac_s(gfc,eb[chn],thr[chn],chn,sblock)}}for(chn=0;chn<n_chn_psy;chn++){var ch01;if(0==uselongblock[ch01=1&chn])for(var sb=0;sb<Encoder.SBMAX_s;sb++){var new_thmm=new_float(3);for(sblock=0;sblock<3;sblock++){var thmm=gfc.thm[chn].s[sb][sblock];if(thmm*=.8,ns_attacks[chn][sblock]>=2||1==ns_attacks[chn][sblock+1]){var idx=0!=sblock?sblock-1:2,p=NS_INTERP(gfc.thm[chn].s[sb][idx],thmm,.36);thmm=Math.min(thmm,p)}else if(1==ns_attacks[chn][sblock]){idx=0!=sblock?sblock-1:2,p=NS_INTERP(gfc.thm[chn].s[sb][idx],thmm,.18);thmm=Math.min(thmm,p)}else if(0!=sblock&&3==ns_attacks[chn][sblock-1]||0==sblock&&3==gfc.nsPsy.lastAttacks[chn]){idx=2!=sblock?sblock+1:0,p=NS_INTERP(gfc.thm[chn].s[sb][idx],thmm,.18);thmm=Math.min(thmm,p)}thmm*=sub_short_factor[chn][sblock],new_thmm[sblock]=thmm}for(sblock=0;sblock<3;sblock++)gfc.thm[chn].s[sb][sblock]=new_thmm[sblock]}}for(chn=0;chn<n_chn_psy;chn++)gfc.nsPsy.lastAttacks[chn]=ns_attacks[chn][2];!function(gfp,uselongblock,blocktype_d){for(var gfc=gfp.internal_flags,chn=0;chn<gfc.channels_out;chn++){var blocktype=Encoder.NORM_TYPE;0!=uselongblock[chn]?gfc.blocktype_old[chn]==Encoder.SHORT_TYPE&&(blocktype=Encoder.STOP_TYPE):(blocktype=Encoder.SHORT_TYPE,gfc.blocktype_old[chn]==Encoder.NORM_TYPE&&(gfc.blocktype_old[chn]=Encoder.START_TYPE),gfc.blocktype_old[chn]==Encoder.STOP_TYPE&&(gfc.blocktype_old[chn]=Encoder.SHORT_TYPE)),blocktype_d[chn]=gfc.blocktype_old[chn],gfc.blocktype_old[chn]=blocktype}}(gfp,uselongblock,blocktype_d);for(chn=0;chn<n_chn_psy;chn++){var ppe,ppePos,type,mr;chn>1?(ppe=percep_MS_entropy,ppePos=-2,type=Encoder.NORM_TYPE,blocktype_d[0]!=Encoder.SHORT_TYPE&&blocktype_d[1]!=Encoder.SHORT_TYPE||(type=Encoder.SHORT_TYPE),mr=masking_MS_ratio[gr_out][chn-2]):(ppe=percep_entropy,ppePos=0,type=blocktype_d[chn],mr=masking_ratio[gr_out][chn]),type==Encoder.SHORT_TYPE?ppe[ppePos+chn]=pecalc_s(mr,gfc.masking_lower):ppe[ppePos+chn]=pecalc_l(mr,gfc.masking_lower),gfp.analysis&&(gfc.pinfo.pe[gr_out][chn]=ppe[ppePos+chn])}return 0},this.psymodel_init=function(gfp){var i,gfc=gfp.internal_flags,useOldS3=!0,bvl_a=13,snr_l_a=0,snr_l_b=0,snr_s_a=-8.25,snr_s_b=-4.5,bval=new_float(Encoder.CBANDS),bval_width=new_float(Encoder.CBANDS),norm=new_float(Encoder.CBANDS),sfreq=gfp.out_samplerate;switch(gfp.experimentalZ){default:case 0:useOldS3=!0;break;case 1:useOldS3=gfp.VBR!=VbrMode.vbr_mtrh&&gfp.VBR!=VbrMode.vbr_mt;break;case 2:useOldS3=!1;break;case 3:bvl_a=8,snr_l_a=-1.75,snr_l_b=-.0125,snr_s_a=-8.25,snr_s_b=-2.25}for(gfc.ms_ener_ratio_old=.25,gfc.blocktype_old[0]=gfc.blocktype_old[1]=Encoder.NORM_TYPE,i=0;i<4;++i){for(var j=0;j<Encoder.CBANDS;++j)gfc.nb_1[i][j]=1e20,gfc.nb_2[i][j]=1e20,gfc.nb_s1[i][j]=gfc.nb_s2[i][j]=1;for(var sb=0;sb<Encoder.SBMAX_l;sb++)gfc.en[i].l[sb]=1e20,gfc.thm[i].l[sb]=1e20;for(j=0;j<3;++j){for(sb=0;sb<Encoder.SBMAX_s;sb++)gfc.en[i].s[sb][j]=1e20,gfc.thm[i].s[sb][j]=1e20;gfc.nsPsy.lastAttacks[i]=0}for(j=0;j<9;j++)gfc.nsPsy.last_en_subshort[i][j]=10}for(gfc.loudness_sq_save[0]=gfc.loudness_sq_save[1]=0,gfc.npart_l=init_numline(gfc.numlines_l,gfc.bo_l,gfc.bm_l,bval,bval_width,gfc.mld_l,gfc.PSY.bo_l_weight,sfreq,Encoder.BLKSIZE,gfc.scalefac_band.l,Encoder.BLKSIZE/1152,Encoder.SBMAX_l),i=0;i<gfc.npart_l;i++){var snr=snr_l_a;bval[i]>=bvl_a&&(snr=snr_l_b*(bval[i]-bvl_a)/(24-bvl_a)+snr_l_a*(24-bval[i])/(24-bvl_a)),norm[i]=Math.pow(10,snr/10),gfc.numlines_l[i]>0?gfc.rnumlines_l[i]=1/gfc.numlines_l[i]:gfc.rnumlines_l[i]=0}gfc.s3_ll=init_s3_values(gfc.s3ind,gfc.npart_l,bval,bval_width,norm,useOldS3);var msfix;j=0;for(i=0;i<gfc.npart_l;i++){x=Float.MAX_VALUE;for(var k=0;k<gfc.numlines_l[i];k++,j++){var freq=sfreq*j/(1e3*Encoder.BLKSIZE);level=this.ATHformula(1e3*freq,gfp)-20,level=Math.pow(10,.1*level),x>(level*=gfc.numlines_l[i])&&(x=level)}gfc.ATH.cb_l[i]=x,(x=20*bval[i]/10-20)>6&&(x=100),x<-15&&(x=-15),x-=8,gfc.minval_l[i]=Math.pow(10,x/10)*gfc.numlines_l[i]}for(gfc.npart_s=init_numline(gfc.numlines_s,gfc.bo_s,gfc.bm_s,bval,bval_width,gfc.mld_s,gfc.PSY.bo_s_weight,sfreq,Encoder.BLKSIZE_s,gfc.scalefac_band.s,Encoder.BLKSIZE_s/384,Encoder.SBMAX_s),j=0,i=0;i<gfc.npart_s;i++){var x;snr=snr_s_a;bval[i]>=bvl_a&&(snr=snr_s_b*(bval[i]-bvl_a)/(24-bvl_a)+snr_s_a*(24-bval[i])/(24-bvl_a)),norm[i]=Math.pow(10,snr/10),x=Float.MAX_VALUE;for(k=0;k<gfc.numlines_s[i];k++,j++){var level;freq=sfreq*j/(1e3*Encoder.BLKSIZE_s);level=this.ATHformula(1e3*freq,gfp)-20,level=Math.pow(10,.1*level),x>(level*=gfc.numlines_s[i])&&(x=level)}gfc.ATH.cb_s[i]=x,x=7*bval[i]/12-7,bval[i]>12&&(x*=1+3.1*Math.log(1+x)),bval[i]<12&&(x*=1+2.3*Math.log(1-x)),x<-15&&(x=-15),x-=8,gfc.minval_s[i]=Math.pow(10,x/10)*gfc.numlines_s[i]}gfc.s3_ss=init_s3_values(gfc.s3ind_s,gfc.npart_s,bval,bval_width,norm,useOldS3),ma_max_i1=Math.pow(10,9/16),ma_max_i2=Math.pow(10,1.5),ma_max_m=Math.pow(10,1.5),fft.init_fft(gfc),gfc.decay=Math.exp(-1*LOG10/(.01*sfreq/192)),msfix=3.5,0!=(2&gfp.exp_nspsytune)&&(msfix=1),Math.abs(gfp.msfix)>0&&(msfix=gfp.msfix),gfp.msfix=msfix;for(var b=0;b<gfc.npart_l;b++)gfc.s3ind[b][1]>gfc.npart_l-1&&(gfc.s3ind[b][1]=gfc.npart_l-1);var frame_duration=576*gfc.mode_gr/sfreq;if(gfc.ATH.decay=Math.pow(10,-1.2*frame_duration),gfc.ATH.adjust=.01,gfc.ATH.adjustLimit=1,-1!=gfp.ATHtype){var freq_inc=gfp.out_samplerate/Encoder.BLKSIZE,eql_balance=0;for(freq=0,i=0;i<Encoder.BLKSIZE/2;++i)freq+=freq_inc,gfc.ATH.eql_w[i]=1/Math.pow(10,this.ATHformula(freq,gfp)/10),eql_balance+=gfc.ATH.eql_w[i];for(eql_balance=1/eql_balance,i=Encoder.BLKSIZE/2;--i>=0;)gfc.ATH.eql_w[i]*=eql_balance}for(b=j=0;b<gfc.npart_s;++b)for(i=0;i<gfc.numlines_s[b];++i)++j;for(b=j=0;b<gfc.npart_l;++b)for(i=0;i<gfc.numlines_l[b];++i)++j;for(j=0,i=0;i<gfc.npart_l;i++){freq=sfreq*(j+gfc.numlines_l[i]/2)/(1*Encoder.BLKSIZE);gfc.mld_cb_l[i]=stereo_demask(freq),j+=gfc.numlines_l[i]}for(;i<Encoder.CBANDS;++i)gfc.mld_cb_l[i]=1;for(j=0,i=0;i<gfc.npart_s;i++){freq=sfreq*(j+gfc.numlines_s[i]/2)/(1*Encoder.BLKSIZE_s);gfc.mld_cb_s[i]=stereo_demask(freq),j+=gfc.numlines_s[i]}for(;i<Encoder.CBANDS;++i)gfc.mld_cb_s[i]=1;return 0},this.ATHformula=function(f,gfp){var ath;switch(gfp.ATHtype){case 0:ath=ATHformula_GB(f,9);break;case 1:ath=ATHformula_GB(f,-1);break;case 2:default:ath=ATHformula_GB(f,0);break;case 3:ath=ATHformula_GB(f,1)+6;break;case 4:ath=ATHformula_GB(f,gfp.ATHcurve)}return ath}}function Lame(){var self=this;Lame.V9=410,Lame.V8=420,Lame.V7=430,Lame.V6=440,Lame.V5=450,Lame.V4=460,Lame.V3=470,Lame.V2=480,Lame.V1=490,Lame.V0=500,Lame.R3MIX=1e3,Lame.STANDARD=1001,Lame.EXTREME=1002,Lame.INSANE=1003,Lame.STANDARD_FAST=1004,Lame.EXTREME_FAST=1005,Lame.MEDIUM=1006,Lame.MEDIUM_FAST=1007;var ga,bs,p,qupvt,qu;Lame.LAME_MAXMP3BUFFER=147456;var vbr,id3,mpglib,psy=new PsyModel;function PSY(){this.mask_adjust=0,this.mask_adjust_short=0,this.bo_l_weight=new_float(Encoder.SBMAX_l),this.bo_s_weight=new_float(Encoder.SBMAX_s)}function LowPassHighPass(){this.lowerlimit=0}function BandPass(bitrate,lPass){this.lowpass=lPass}this.enc=new Encoder,this.setModules=function(_ga,_bs,_p,_qupvt,_qu,_vbr,_ver,_id3,_mpglib){ga=_ga,bs=_bs,p=_p,qupvt=_qupvt,qu=_qu,vbr=_vbr,_ver,id3=_id3,mpglib=_mpglib,this.enc.setModules(bs,psy,qupvt,vbr)};function filter_coef(x){return x>1?0:x<=0?1:Math.cos(Math.PI/2*x)}function SmpFrqIndex(sample_freq,gpf){switch(sample_freq){case 44100:return gpf.version=1,0;case 48e3:return gpf.version=1,1;case 32e3:return gpf.version=1,2;case 22050:case 11025:return gpf.version=0,0;case 24e3:case 12e3:return gpf.version=0,1;case 16e3:case 8e3:return gpf.version=0,2;default:return gpf.version=0,-1}}function FindNearestBitrate(bRate,version,samplerate){samplerate<16e3&&(version=2);for(var bitrate=Tables.bitrate_table[version][1],i=2;i<=14;i++)Tables.bitrate_table[version][i]>0&&Math.abs(Tables.bitrate_table[version][i]-bRate)<Math.abs(bitrate-bRate)&&(bitrate=Tables.bitrate_table[version][i]);return bitrate}function BitrateIndex(bRate,version,samplerate){samplerate<16e3&&(version=2);for(var i=0;i<=14;i++)if(Tables.bitrate_table[version][i]>0&&Tables.bitrate_table[version][i]==bRate)return i;return-1}function optimum_bandwidth(lh,bitrate){var freq_map=[new BandPass(8,2e3),new BandPass(16,3700),new BandPass(24,3900),new BandPass(32,5500),new BandPass(40,7e3),new BandPass(48,7500),new BandPass(56,1e4),new BandPass(64,11e3),new BandPass(80,13500),new BandPass(96,15100),new BandPass(112,15600),new BandPass(128,17e3),new BandPass(160,17500),new BandPass(192,18600),new BandPass(224,19400),new BandPass(256,19700),new BandPass(320,20500)],table_index=self.nearestBitrateFullIndex(bitrate);lh.lowerlimit=freq_map[table_index].lowpass}function calcNeeded(gfp){var mf_needed=Encoder.BLKSIZE+gfp.framesize-Encoder.FFTOFFSET;return mf_needed=Math.max(mf_needed,512+gfp.framesize-32)}function lame_encode_frame(gfp,inbuf_l,inbuf_r,mp3buf,mp3bufPos,mp3buf_size){var ret=self.enc.lame_encode_mp3_frame(gfp,inbuf_l,inbuf_r,mp3buf,mp3bufPos,mp3buf_size);return gfp.frameNum++,ret}function InOut(){this.n_in=0,this.n_out=0}function NumUsed(){this.num_used=0}function gcd(i,j){return 0!=j?gcd(j,i%j):i}function blackman(x,fcn,l){var wcn=Math.PI*fcn;(x/=l)<0&&(x=0),x>1&&(x=1);var x2=x-.5,bkwn=.42-.5*Math.cos(2*x*Math.PI)+.08*Math.cos(4*x*Math.PI);return Math.abs(x2)<1e-9?wcn/Math.PI:bkwn*Math.sin(l*wcn*x2)/(Math.PI*l*x2)}function fill_buffer_resample(gfp,outbuf,outbufPos,desired_len,inbuf,in_bufferPos,len,num_used,ch){var i,k,gfc=gfp.internal_flags,j=0,bpc=gfp.out_samplerate/gcd(gfp.out_samplerate,gfp.in_samplerate);bpc>LameInternalFlags.BPC&&(bpc=LameInternalFlags.BPC);var intratio=Math.abs(gfc.resample_ratio-Math.floor(.5+gfc.resample_ratio))<1e-4?1:0,fcn=1/gfc.resample_ratio;fcn>1&&(fcn=1);var filter_l=31;0==filter_l%2&&--filter_l;var BLACKSIZE=(filter_l+=intratio)+1;if(0==gfc.fill_buffer_resample_init){for(gfc.inbuf_old[0]=new_float(BLACKSIZE),gfc.inbuf_old[1]=new_float(BLACKSIZE),i=0;i<=2*bpc;++i)gfc.blackfilt[i]=new_float(BLACKSIZE);for(gfc.itime[0]=0,gfc.itime[1]=0,j=0;j<=2*bpc;j++){var sum=0,offset=(j-bpc)/(2*bpc);for(i=0;i<=filter_l;i++)sum+=gfc.blackfilt[j][i]=blackman(i-offset,fcn,filter_l);for(i=0;i<=filter_l;i++)gfc.blackfilt[j][i]/=sum}gfc.fill_buffer_resample_init=1}var inbuf_old=gfc.inbuf_old[ch];for(k=0;k<desired_len;k++){var time0,joff;if(time0=k*gfc.resample_ratio,filter_l+(j=0|Math.floor(time0-gfc.itime[ch]))-filter_l/2>=len)break;offset=time0-gfc.itime[ch]-(j+filter_l%2*.5);joff=0|Math.floor(2*offset*bpc+bpc+.5);var xvalue=0;for(i=0;i<=filter_l;++i){var j2=0|i+j-filter_l/2;xvalue+=(j2<0?inbuf_old[BLACKSIZE+j2]:inbuf[in_bufferPos+j2])*gfc.blackfilt[joff][i]}outbuf[outbufPos+k]=xvalue}if(num_used.num_used=Math.min(len,filter_l+j-filter_l/2),gfc.itime[ch]+=num_used.num_used-k*gfc.resample_ratio,num_used.num_used>=BLACKSIZE)for(i=0;i<BLACKSIZE;i++)inbuf_old[i]=inbuf[in_bufferPos+num_used.num_used+i-BLACKSIZE];else{var n_shift=BLACKSIZE-num_used.num_used;for(i=0;i<n_shift;++i)inbuf_old[i]=inbuf_old[i+num_used.num_used];for(j=0;i<BLACKSIZE;++i,++j)inbuf_old[i]=inbuf[in_bufferPos+j]}return k}function fill_buffer(gfp,mfbuf,in_buffer,in_bufferPos,nsamples,io){var gfc=gfp.internal_flags;if(gfc.resample_ratio<.9999||gfc.resample_ratio>1.0001)for(var ch=0;ch<gfc.channels_out;ch++){var numUsed=new NumUsed;io.n_out=fill_buffer_resample(gfp,mfbuf[ch],gfc.mf_size,gfp.framesize,in_buffer[ch],in_bufferPos,nsamples,numUsed,ch),io.n_in=numUsed.num_used}else{io.n_out=Math.min(gfp.framesize,nsamples),io.n_in=io.n_out;for(var i=0;i<io.n_out;++i)mfbuf[0][gfc.mf_size+i]=in_buffer[0][in_bufferPos+i],2==gfc.channels_out&&(mfbuf[1][gfc.mf_size+i]=in_buffer[1][in_bufferPos+i])}}this.lame_init=function(){var gfp=new LameGlobalFlags,ret=function(gfp){var gfc;return gfp.class_id=4294479419,gfc=gfp.internal_flags=new LameInternalFlags,gfp.mode=MPEGMode.NOT_SET,gfp.original=1,gfp.in_samplerate=44100,gfp.num_channels=2,gfp.num_samples=-1,gfp.bWriteVbrTag=!0,gfp.quality=-1,gfp.short_blocks=null,gfc.subblock_gain=-1,gfp.lowpassfreq=0,gfp.highpassfreq=0,gfp.lowpasswidth=-1,gfp.highpasswidth=-1,gfp.VBR=VbrMode.vbr_off,gfp.VBR_q=4,gfp.ATHcurve=-1,gfp.VBR_mean_bitrate_kbps=128,gfp.VBR_min_bitrate_kbps=0,gfp.VBR_max_bitrate_kbps=0,gfp.VBR_hard_min=0,gfc.VBR_min_bitrate=1,gfc.VBR_max_bitrate=13,gfp.quant_comp=-1,gfp.quant_comp_short=-1,gfp.msfix=-1,gfc.resample_ratio=1,gfc.OldValue[0]=180,gfc.OldValue[1]=180,gfc.CurrentStep[0]=4,gfc.CurrentStep[1]=4,gfc.masking_lower=1,gfc.nsPsy.attackthre=-1,gfc.nsPsy.attackthre_s=-1,gfp.scale=-1,gfp.athaa_type=-1,gfp.ATHtype=-1,gfp.athaa_loudapprox=-1,gfp.athaa_sensitivity=0,gfp.useTemporal=null,gfp.interChRatio=-1,gfc.mf_samples_to_encode=Encoder.ENCDELAY+Encoder.POSTDELAY,gfp.encoder_padding=0,gfc.mf_size=Encoder.ENCDELAY-Encoder.MDCTDELAY,gfp.findReplayGain=!1,gfp.decode_on_the_fly=!1,gfc.decode_on_the_fly=!1,gfc.findReplayGain=!1,gfc.findPeakSample=!1,gfc.RadioGain=0,gfc.AudiophileGain=0,gfc.noclipGainChange=0,gfc.noclipScale=-1,gfp.preset=0,gfp.write_id3tag_automatic=!0,0}(gfp);return 0!=ret?null:(gfp.lame_allocated_gfp=1,gfp)},this.nearestBitrateFullIndex=function(bitrate){var full_bitrate_table=[8,16,24,32,40,48,56,64,80,96,112,128,160,192,224,256,320],lower_range=0,lower_range_kbps=0,upper_range=0,upper_range_kbps=0;upper_range_kbps=full_bitrate_table[16],upper_range=16,lower_range_kbps=full_bitrate_table[16],lower_range=16;for(var b=0;b<16;b++)if(Math.max(bitrate,full_bitrate_table[b+1])!=bitrate){upper_range_kbps=full_bitrate_table[b+1],upper_range=b+1,lower_range_kbps=full_bitrate_table[b],lower_range=b;break}return upper_range_kbps-bitrate>bitrate-lower_range_kbps?lower_range:upper_range},this.lame_init_params=function(gfp){var lowpassfreq,input_samplefreq,suggested_samplefreq,gfc=gfp.internal_flags;if(gfc.Class_ID=0,null==gfc.ATH&&(gfc.ATH=new ATH),null==gfc.PSY&&(gfc.PSY=new PSY),null==gfc.rgdata&&(gfc.rgdata=new ReplayGain),gfc.channels_in=gfp.num_channels,1==gfc.channels_in&&(gfp.mode=MPEGMode.MONO),gfc.channels_out=gfp.mode==MPEGMode.MONO?1:2,gfc.mode_ext=Encoder.MPG_MD_MS_LR,gfp.mode==MPEGMode.MONO&&(gfp.force_ms=!1),gfp.VBR==VbrMode.vbr_off&&128!=gfp.VBR_mean_bitrate_kbps&&0==gfp.brate&&(gfp.brate=gfp.VBR_mean_bitrate_kbps),gfp.VBR==VbrMode.vbr_off||gfp.VBR==VbrMode.vbr_mtrh||gfp.VBR==VbrMode.vbr_mt||(gfp.free_format=!1),gfp.VBR==VbrMode.vbr_off&&0==gfp.brate&&BitStream.EQ(gfp.compression_ratio,0)&&(gfp.compression_ratio=11.025),gfp.VBR==VbrMode.vbr_off&&gfp.compression_ratio>0&&(0==gfp.out_samplerate&&(gfp.out_samplerate=map2MP3Frequency(int(.97*gfp.in_samplerate))),gfp.brate=0|16*gfp.out_samplerate*gfc.channels_out/(1e3*gfp.compression_ratio),gfc.samplerate_index=SmpFrqIndex(gfp.out_samplerate,gfp),gfp.free_format||(gfp.brate=FindNearestBitrate(gfp.brate,gfp.version,gfp.out_samplerate))),0!=gfp.out_samplerate&&(gfp.out_samplerate<16e3?(gfp.VBR_mean_bitrate_kbps=Math.max(gfp.VBR_mean_bitrate_kbps,8),gfp.VBR_mean_bitrate_kbps=Math.min(gfp.VBR_mean_bitrate_kbps,64)):gfp.out_samplerate<32e3?(gfp.VBR_mean_bitrate_kbps=Math.max(gfp.VBR_mean_bitrate_kbps,8),gfp.VBR_mean_bitrate_kbps=Math.min(gfp.VBR_mean_bitrate_kbps,160)):(gfp.VBR_mean_bitrate_kbps=Math.max(gfp.VBR_mean_bitrate_kbps,32),gfp.VBR_mean_bitrate_kbps=Math.min(gfp.VBR_mean_bitrate_kbps,320))),0==gfp.lowpassfreq){var lowpass=16e3;switch(gfp.VBR){case VbrMode.vbr_off:optimum_bandwidth(lh=new LowPassHighPass,gfp.brate),lowpass=lh.lowerlimit;break;case VbrMode.vbr_abr:var lh;optimum_bandwidth(lh=new LowPassHighPass,gfp.VBR_mean_bitrate_kbps),lowpass=lh.lowerlimit;break;case VbrMode.vbr_rh:var x=[19500,19e3,18600,18e3,17500,16e3,15600,14900,12500,1e4,3950];if(0<=gfp.VBR_q&&gfp.VBR_q<=9){var a=x[gfp.VBR_q],b=x[gfp.VBR_q+1],m=gfp.VBR_q_frac;lowpass=linear_int(a,b,m)}else lowpass=19500;break;default:x=[19500,19e3,18500,18e3,17500,16500,15500,14500,12500,9500,3950];if(0<=gfp.VBR_q&&gfp.VBR_q<=9){a=x[gfp.VBR_q],b=x[gfp.VBR_q+1],m=gfp.VBR_q_frac;lowpass=linear_int(a,b,m)}else lowpass=19500}gfp.mode!=MPEGMode.MONO||gfp.VBR!=VbrMode.vbr_off&&gfp.VBR!=VbrMode.vbr_abr||(lowpass*=1.5),gfp.lowpassfreq=0|lowpass}if(0==gfp.out_samplerate&&(2*gfp.lowpassfreq>gfp.in_samplerate&&(gfp.lowpassfreq=gfp.in_samplerate/2),gfp.out_samplerate=(lowpassfreq=0|gfp.lowpassfreq,input_samplefreq=gfp.in_samplerate,suggested_samplefreq=44100,input_samplefreq>=48e3?suggested_samplefreq=48e3:input_samplefreq>=44100?suggested_samplefreq=44100:input_samplefreq>=32e3?suggested_samplefreq=32e3:input_samplefreq>=24e3?suggested_samplefreq=24e3:input_samplefreq>=22050?suggested_samplefreq=22050:input_samplefreq>=16e3?suggested_samplefreq=16e3:input_samplefreq>=12e3?suggested_samplefreq=12e3:input_samplefreq>=11025?suggested_samplefreq=11025:input_samplefreq>=8e3&&(suggested_samplefreq=8e3),-1==lowpassfreq?suggested_samplefreq:(lowpassfreq<=15960&&(suggested_samplefreq=44100),lowpassfreq<=15250&&(suggested_samplefreq=32e3),lowpassfreq<=11220&&(suggested_samplefreq=24e3),lowpassfreq<=9970&&(suggested_samplefreq=22050),lowpassfreq<=7230&&(suggested_samplefreq=16e3),lowpassfreq<=5420&&(suggested_samplefreq=12e3),lowpassfreq<=4510&&(suggested_samplefreq=11025),lowpassfreq<=3970&&(suggested_samplefreq=8e3),input_samplefreq<suggested_samplefreq?input_samplefreq>44100?48e3:input_samplefreq>32e3?44100:input_samplefreq>24e3?32e3:input_samplefreq>22050?24e3:input_samplefreq>16e3?22050:input_samplefreq>12e3?16e3:input_samplefreq>11025?12e3:input_samplefreq>8e3?11025:8e3:suggested_samplefreq))),gfp.lowpassfreq=Math.min(20500,gfp.lowpassfreq),gfp.lowpassfreq=Math.min(gfp.out_samplerate/2,gfp.lowpassfreq),gfp.VBR==VbrMode.vbr_off&&(gfp.compression_ratio=16*gfp.out_samplerate*gfc.channels_out/(1e3*gfp.brate)),gfp.VBR==VbrMode.vbr_abr&&(gfp.compression_ratio=16*gfp.out_samplerate*gfc.channels_out/(1e3*gfp.VBR_mean_bitrate_kbps)),gfp.bWriteVbrTag||(gfp.findReplayGain=!1,gfp.decode_on_the_fly=!1,gfc.findPeakSample=!1),gfc.findReplayGain=gfp.findReplayGain,gfc.decode_on_the_fly=gfp.decode_on_the_fly,gfc.decode_on_the_fly&&(gfc.findPeakSample=!0),gfc.findReplayGain&&ga.InitGainAnalysis(gfc.rgdata,gfp.out_samplerate)==GainAnalysis.INIT_GAIN_ANALYSIS_ERROR)return gfp.internal_flags=null,-6;switch(gfc.decode_on_the_fly&&!gfp.decode_only&&(null!=gfc.hip&&mpglib.hip_decode_exit(gfc.hip),gfc.hip=mpglib.hip_decode_init()),gfc.mode_gr=gfp.out_samplerate<=24e3?1:2,gfp.framesize=576*gfc.mode_gr,gfp.encoder_delay=Encoder.ENCDELAY,gfc.resample_ratio=gfp.in_samplerate/gfp.out_samplerate,gfp.VBR){case VbrMode.vbr_mt:case VbrMode.vbr_rh:case VbrMode.vbr_mtrh:gfp.compression_ratio=[5.7,6.5,7.3,8.2,10,11.9,13,14,15,16.5][gfp.VBR_q];break;case VbrMode.vbr_abr:gfp.compression_ratio=16*gfp.out_samplerate*gfc.channels_out/(1e3*gfp.VBR_mean_bitrate_kbps);break;default:gfp.compression_ratio=16*gfp.out_samplerate*gfc.channels_out/(1e3*gfp.brate)}if(gfp.mode==MPEGMode.NOT_SET&&(gfp.mode=MPEGMode.JOINT_STEREO),gfp.highpassfreq>0?(gfc.highpass1=2*gfp.highpassfreq,gfp.highpasswidth>=0?gfc.highpass2=2*(gfp.highpassfreq+gfp.highpasswidth):gfc.highpass2=2*gfp.highpassfreq,gfc.highpass1/=gfp.out_samplerate,gfc.highpass2/=gfp.out_samplerate):(gfc.highpass1=0,gfc.highpass2=0),gfp.lowpassfreq>0?(gfc.lowpass2=2*gfp.lowpassfreq,gfp.lowpasswidth>=0?(gfc.lowpass1=2*(gfp.lowpassfreq-gfp.lowpasswidth),gfc.lowpass1<0&&(gfc.lowpass1=0)):gfc.lowpass1=2*gfp.lowpassfreq,gfc.lowpass1/=gfp.out_samplerate,gfc.lowpass2/=gfp.out_samplerate):(gfc.lowpass1=0,gfc.lowpass2=0),function(gfp){var gfc=gfp.internal_flags,lowpass_band=32,highpass_band=-1;if(gfc.lowpass1>0){for(var minband=999,band=0;band<=31;band++)(freq=band/31)>=gfc.lowpass2&&(lowpass_band=Math.min(lowpass_band,band)),gfc.lowpass1<freq&&freq<gfc.lowpass2&&(minband=Math.min(minband,band));gfc.lowpass1=999==minband?(lowpass_band-.75)/31:(minband-.75)/31,gfc.lowpass2=lowpass_band/31}if(gfc.highpass2>0&&gfc.highpass2<.75/31*.9&&(gfc.highpass1=0,gfc.highpass2=0,System.err.println("Warning: highpass filter disabled.  highpass frequency too small\n")),gfc.highpass2>0){var maxband=-1;for(band=0;band<=31;band++)(freq=band/31)<=gfc.highpass1&&(highpass_band=Math.max(highpass_band,band)),gfc.highpass1<freq&&freq<gfc.highpass2&&(maxband=Math.max(maxband,band));gfc.highpass1=highpass_band/31,gfc.highpass2=-1==maxband?(highpass_band+.75)/31:(maxband+.75)/31}for(band=0;band<32;band++){var fc1,fc2,freq=band/31;fc1=gfc.highpass2>gfc.highpass1?filter_coef((gfc.highpass2-freq)/(gfc.highpass2-gfc.highpass1+1e-20)):1,fc2=gfc.lowpass2>gfc.lowpass1?filter_coef((freq-gfc.lowpass1)/(gfc.lowpass2-gfc.lowpass1+1e-20)):1,gfc.amp_filter[band]=fc1*fc2}}(gfp),gfc.samplerate_index=SmpFrqIndex(gfp.out_samplerate,gfp),gfc.samplerate_index<0)return gfp.internal_flags=null,-1;if(gfp.VBR==VbrMode.vbr_off){if(gfp.free_format)gfc.bitrate_index=0;else if(gfp.brate=FindNearestBitrate(gfp.brate,gfp.version,gfp.out_samplerate),gfc.bitrate_index=BitrateIndex(gfp.brate,gfp.version,gfp.out_samplerate),gfc.bitrate_index<=0)return gfp.internal_flags=null,-1}else gfc.bitrate_index=1;gfp.analysis&&(gfp.bWriteVbrTag=!1),null!=gfc.pinfo&&(gfp.bWriteVbrTag=!1),bs.init_bit_stream_w(gfc);for(var k,j=gfc.samplerate_index+3*gfp.version+6*(gfp.out_samplerate<16e3?1:0),i=0;i<Encoder.SBMAX_l+1;i++)gfc.scalefac_band.l[i]=qupvt.sfBandIndex[j].l[i];for(i=0;i<Encoder.PSFB21+1;i++){var size=(gfc.scalefac_band.l[22]-gfc.scalefac_band.l[21])/Encoder.PSFB21,start=gfc.scalefac_band.l[21]+i*size;gfc.scalefac_band.psfb21[i]=start}gfc.scalefac_band.psfb21[Encoder.PSFB21]=576;for(i=0;i<Encoder.SBMAX_s+1;i++)gfc.scalefac_band.s[i]=qupvt.sfBandIndex[j].s[i];for(i=0;i<Encoder.PSFB12+1;i++){size=(gfc.scalefac_band.s[13]-gfc.scalefac_band.s[12])/Encoder.PSFB12,start=gfc.scalefac_band.s[12]+i*size;gfc.scalefac_band.psfb12[i]=start}for(gfc.scalefac_band.psfb12[Encoder.PSFB12]=192,1==gfp.version?gfc.sideinfo_len=1==gfc.channels_out?21:36:gfc.sideinfo_len=1==gfc.channels_out?13:21,gfp.error_protection&&(gfc.sideinfo_len+=2),function(gfp){var gfc=gfp.internal_flags;gfp.frameNum=0,gfp.write_id3tag_automatic&&id3.id3tag_write_v2(gfp),gfc.bitrate_stereoMode_Hist=new_int_n([16,5]),gfc.bitrate_blockType_Hist=new_int_n([16,6]),gfc.PeakSample=0,gfp.bWriteVbrTag&&vbr.InitVbrTag(gfp)}(gfp),gfc.Class_ID=4294479419,k=0;k<19;k++)gfc.nsPsy.pefirbuf[k]=700*gfc.mode_gr*gfc.channels_out;switch(-1==gfp.ATHtype&&(gfp.ATHtype=4),gfp.VBR){case VbrMode.vbr_mt:gfp.VBR=VbrMode.vbr_mtrh;case VbrMode.vbr_mtrh:null==gfp.useTemporal&&(gfp.useTemporal=!1),p.apply_preset(gfp,500-10*gfp.VBR_q,0),gfp.quality<0&&(gfp.quality=LAME_DEFAULT_QUALITY),gfp.quality<5&&(gfp.quality=0),gfp.quality>5&&(gfp.quality=5),gfc.PSY.mask_adjust=gfp.maskingadjust,gfc.PSY.mask_adjust_short=gfp.maskingadjust_short,gfp.experimentalY?gfc.sfb21_extra=!1:gfc.sfb21_extra=gfp.out_samplerate>44e3,gfc.iteration_loop=new VBRNewIterationLoop(qu);break;case VbrMode.vbr_rh:p.apply_preset(gfp,500-10*gfp.VBR_q,0),gfc.PSY.mask_adjust=gfp.maskingadjust,gfc.PSY.mask_adjust_short=gfp.maskingadjust_short,gfp.experimentalY?gfc.sfb21_extra=!1:gfc.sfb21_extra=gfp.out_samplerate>44e3,gfp.quality>6&&(gfp.quality=6),gfp.quality<0&&(gfp.quality=LAME_DEFAULT_QUALITY),gfc.iteration_loop=new VBROldIterationLoop(qu);break;default:var vbrmode;gfc.sfb21_extra=!1,gfp.quality<0&&(gfp.quality=LAME_DEFAULT_QUALITY),(vbrmode=gfp.VBR)==VbrMode.vbr_off&&(gfp.VBR_mean_bitrate_kbps=gfp.brate),p.apply_preset(gfp,gfp.VBR_mean_bitrate_kbps,0),gfp.VBR=vbrmode,gfc.PSY.mask_adjust=gfp.maskingadjust,gfc.PSY.mask_adjust_short=gfp.maskingadjust_short,vbrmode==VbrMode.vbr_off?gfc.iteration_loop=new CBRNewIterationLoop(qu):gfc.iteration_loop=new ABRIterationLoop(qu)}if(gfp.VBR!=VbrMode.vbr_off){if(gfc.VBR_min_bitrate=1,gfc.VBR_max_bitrate=14,gfp.out_samplerate<16e3&&(gfc.VBR_max_bitrate=8),0!=gfp.VBR_min_bitrate_kbps&&(gfp.VBR_min_bitrate_kbps=FindNearestBitrate(gfp.VBR_min_bitrate_kbps,gfp.version,gfp.out_samplerate),gfc.VBR_min_bitrate=BitrateIndex(gfp.VBR_min_bitrate_kbps,gfp.version,gfp.out_samplerate),gfc.VBR_min_bitrate<0))return-1;if(0!=gfp.VBR_max_bitrate_kbps&&(gfp.VBR_max_bitrate_kbps=FindNearestBitrate(gfp.VBR_max_bitrate_kbps,gfp.version,gfp.out_samplerate),gfc.VBR_max_bitrate=BitrateIndex(gfp.VBR_max_bitrate_kbps,gfp.version,gfp.out_samplerate),gfc.VBR_max_bitrate<0))return-1;gfp.VBR_min_bitrate_kbps=Tables.bitrate_table[gfp.version][gfc.VBR_min_bitrate],gfp.VBR_max_bitrate_kbps=Tables.bitrate_table[gfp.version][gfc.VBR_max_bitrate],gfp.VBR_mean_bitrate_kbps=Math.min(Tables.bitrate_table[gfp.version][gfc.VBR_max_bitrate],gfp.VBR_mean_bitrate_kbps),gfp.VBR_mean_bitrate_kbps=Math.max(Tables.bitrate_table[gfp.version][gfc.VBR_min_bitrate],gfp.VBR_mean_bitrate_kbps)}return gfp.tune&&(gfc.PSY.mask_adjust+=gfp.tune_value_a,gfc.PSY.mask_adjust_short+=gfp.tune_value_a),function(gfp){var gfc=gfp.internal_flags;switch(gfp.quality){default:case 9:gfc.psymodel=0,gfc.noise_shaping=0,gfc.noise_shaping_amp=0,gfc.noise_shaping_stop=0,gfc.use_best_huffman=0,gfc.full_outer_loop=0;break;case 8:gfp.quality=7;case 7:gfc.psymodel=1,gfc.noise_shaping=0,gfc.noise_shaping_amp=0,gfc.noise_shaping_stop=0,gfc.use_best_huffman=0,gfc.full_outer_loop=0;break;case 6:case 5:gfc.psymodel=1,0==gfc.noise_shaping&&(gfc.noise_shaping=1),gfc.noise_shaping_amp=0,gfc.noise_shaping_stop=0,-1==gfc.subblock_gain&&(gfc.subblock_gain=1),gfc.use_best_huffman=0,gfc.full_outer_loop=0;break;case 4:gfc.psymodel=1,0==gfc.noise_shaping&&(gfc.noise_shaping=1),gfc.noise_shaping_amp=0,gfc.noise_shaping_stop=0,-1==gfc.subblock_gain&&(gfc.subblock_gain=1),gfc.use_best_huffman=1,gfc.full_outer_loop=0;break;case 3:gfc.psymodel=1,0==gfc.noise_shaping&&(gfc.noise_shaping=1),gfc.noise_shaping_amp=1,gfc.noise_shaping_stop=1,-1==gfc.subblock_gain&&(gfc.subblock_gain=1),gfc.use_best_huffman=1,gfc.full_outer_loop=0;break;case 2:gfc.psymodel=1,0==gfc.noise_shaping&&(gfc.noise_shaping=1),0==gfc.substep_shaping&&(gfc.substep_shaping=2),gfc.noise_shaping_amp=1,gfc.noise_shaping_stop=1,-1==gfc.subblock_gain&&(gfc.subblock_gain=1),gfc.use_best_huffman=1,gfc.full_outer_loop=0;break;case 1:case 0:gfc.psymodel=1,0==gfc.noise_shaping&&(gfc.noise_shaping=1),0==gfc.substep_shaping&&(gfc.substep_shaping=2),gfc.noise_shaping_amp=2,gfc.noise_shaping_stop=1,-1==gfc.subblock_gain&&(gfc.subblock_gain=1),gfc.use_best_huffman=1,gfc.full_outer_loop=0}}(gfp),gfp.athaa_type<0?gfc.ATH.useAdjust=3:gfc.ATH.useAdjust=gfp.athaa_type,gfc.ATH.aaSensitivityP=Math.pow(10,gfp.athaa_sensitivity/-10),null==gfp.short_blocks&&(gfp.short_blocks=ShortBlock.short_block_allowed),gfp.short_blocks!=ShortBlock.short_block_allowed||gfp.mode!=MPEGMode.JOINT_STEREO&&gfp.mode!=MPEGMode.STEREO||(gfp.short_blocks=ShortBlock.short_block_coupled),gfp.quant_comp<0&&(gfp.quant_comp=1),gfp.quant_comp_short<0&&(gfp.quant_comp_short=0),gfp.msfix<0&&(gfp.msfix=0),gfp.exp_nspsytune=1|gfp.exp_nspsytune,gfp.internal_flags.nsPsy.attackthre<0&&(gfp.internal_flags.nsPsy.attackthre=PsyModel.NSATTACKTHRE),gfp.internal_flags.nsPsy.attackthre_s<0&&(gfp.internal_flags.nsPsy.attackthre_s=PsyModel.NSATTACKTHRE_S),gfp.scale<0&&(gfp.scale=1),gfp.ATHtype<0&&(gfp.ATHtype=4),gfp.ATHcurve<0&&(gfp.ATHcurve=4),gfp.athaa_loudapprox<0&&(gfp.athaa_loudapprox=2),gfp.interChRatio<0&&(gfp.interChRatio=0),null==gfp.useTemporal&&(gfp.useTemporal=!0),gfc.slot_lag=gfc.frac_SpF=0,gfp.VBR==VbrMode.vbr_off&&(gfc.slot_lag=gfc.frac_SpF=72e3*(gfp.version+1)*gfp.brate%gfp.out_samplerate|0),qupvt.iteration_init(gfp),psy.psymodel_init(gfp),0},this.lame_encode_flush=function(gfp,mp3buffer,mp3bufferPos,mp3buffer_size){var mp3count,mp3buffer_size_remaining,end_padding,frames_left,gfc=gfp.internal_flags,buffer=new_short_n([2,1152]),imp3=0,samples_to_encode=gfc.mf_samples_to_encode-Encoder.POSTDELAY,mf_needed=calcNeeded(gfp);if(gfc.mf_samples_to_encode<1)return 0;for(mp3count=0,gfp.in_samplerate!=gfp.out_samplerate&&(samples_to_encode+=16*gfp.out_samplerate/gfp.in_samplerate),(end_padding=gfp.framesize-samples_to_encode%gfp.framesize)<576&&(end_padding+=gfp.framesize),gfp.encoder_padding=end_padding,frames_left=(samples_to_encode+end_padding)/gfp.framesize;frames_left>0&&imp3>=0;){var bunch=mf_needed-gfc.mf_size,frame_num=gfp.frameNum;bunch*=gfp.in_samplerate,(bunch/=gfp.out_samplerate)>1152&&(bunch=1152),bunch<1&&(bunch=1),mp3buffer_size_remaining=mp3buffer_size-mp3count,0==mp3buffer_size&&(mp3buffer_size_remaining=0),mp3bufferPos+=imp3=this.lame_encode_buffer(gfp,buffer[0],buffer[1],bunch,mp3buffer,mp3bufferPos,mp3buffer_size_remaining),mp3count+=imp3,frames_left-=frame_num!=gfp.frameNum?1:0}if(gfc.mf_samples_to_encode=0,imp3<0)return imp3;if(mp3buffer_size_remaining=mp3buffer_size-mp3count,0==mp3buffer_size&&(mp3buffer_size_remaining=0),bs.flush_bitstream(gfp),(imp3=bs.copy_buffer(gfc,mp3buffer,mp3bufferPos,mp3buffer_size_remaining,1))<0)return imp3;if(mp3bufferPos+=imp3,mp3buffer_size_remaining=mp3buffer_size-(mp3count+=imp3),0==mp3buffer_size&&(mp3buffer_size_remaining=0),gfp.write_id3tag_automatic){if(id3.id3tag_write_v1(gfp),(imp3=bs.copy_buffer(gfc,mp3buffer,mp3bufferPos,mp3buffer_size_remaining,0))<0)return imp3;mp3count+=imp3}return mp3count},this.lame_encode_buffer=function(gfp,buffer_l,buffer_r,nsamples,mp3buf,mp3bufPos,mp3buf_size){var gfc=gfp.internal_flags,in_buffer=[null,null];if(4294479419!=gfc.Class_ID)return-3;if(0==nsamples)return 0;!function(gfc,nsamples){(null==gfc.in_buffer_0||gfc.in_buffer_nsamples<nsamples)&&(gfc.in_buffer_0=new_float(nsamples),gfc.in_buffer_1=new_float(nsamples),gfc.in_buffer_nsamples=nsamples)}(gfc,nsamples),in_buffer[0]=gfc.in_buffer_0,in_buffer[1]=gfc.in_buffer_1;for(var i=0;i<nsamples;i++)in_buffer[0][i]=buffer_l[i],gfc.channels_in>1&&(in_buffer[1][i]=buffer_r[i]);return function(gfp,buffer_l,buffer_r,nsamples,mp3buf,mp3bufPos,mp3buf_size){var ret,i,ch,mf_needed,mp3out,gfc=gfp.internal_flags,mp3size=0,mfbuf=[null,null],in_buffer=[null,null];if(4294479419!=gfc.Class_ID)return-3;if(0==nsamples)return 0;if((mp3out=bs.copy_buffer(gfc,mp3buf,mp3bufPos,mp3buf_size,0))<0)return mp3out;if(mp3bufPos+=mp3out,mp3size+=mp3out,in_buffer[0]=buffer_l,in_buffer[1]=buffer_r,BitStream.NEQ(gfp.scale,0)&&BitStream.NEQ(gfp.scale,1))for(i=0;i<nsamples;++i)in_buffer[0][i]*=gfp.scale,2==gfc.channels_out&&(in_buffer[1][i]*=gfp.scale);if(BitStream.NEQ(gfp.scale_left,0)&&BitStream.NEQ(gfp.scale_left,1))for(i=0;i<nsamples;++i)in_buffer[0][i]*=gfp.scale_left;if(BitStream.NEQ(gfp.scale_right,0)&&BitStream.NEQ(gfp.scale_right,1))for(i=0;i<nsamples;++i)in_buffer[1][i]*=gfp.scale_right;if(2==gfp.num_channels&&1==gfc.channels_out)for(i=0;i<nsamples;++i)in_buffer[0][i]=.5*(in_buffer[0][i]+in_buffer[1][i]),in_buffer[1][i]=0;mf_needed=calcNeeded(gfp),mfbuf[0]=gfc.mfbuf[0],mfbuf[1]=gfc.mfbuf[1];var in_bufferPos=0;for(;nsamples>0;){var in_buffer_ptr=[null,null],n_in=0,n_out=0;in_buffer_ptr[0]=in_buffer[0],in_buffer_ptr[1]=in_buffer[1];var inOut=new InOut;if(fill_buffer(gfp,mfbuf,in_buffer_ptr,in_bufferPos,nsamples,inOut),n_in=inOut.n_in,n_out=inOut.n_out,gfc.findReplayGain&&!gfc.decode_on_the_fly&&ga.AnalyzeSamples(gfc.rgdata,mfbuf[0],gfc.mf_size,mfbuf[1],gfc.mf_size,n_out,gfc.channels_out)==GainAnalysis.GAIN_ANALYSIS_ERROR)return-6;if(nsamples-=n_in,in_bufferPos+=n_in,gfc.channels_out,gfc.mf_size+=n_out,gfc.mf_samples_to_encode<1&&(gfc.mf_samples_to_encode=Encoder.ENCDELAY+Encoder.POSTDELAY),gfc.mf_samples_to_encode+=n_out,gfc.mf_size>=mf_needed){var buf_size=mp3buf_size-mp3size;if(0==mp3buf_size&&(buf_size=0),(ret=lame_encode_frame(gfp,mfbuf[0],mfbuf[1],mp3buf,mp3bufPos,buf_size))<0)return ret;for(mp3bufPos+=ret,mp3size+=ret,gfc.mf_size-=gfp.framesize,gfc.mf_samples_to_encode-=gfp.framesize,ch=0;ch<gfc.channels_out;ch++)for(i=0;i<gfc.mf_size;i++)mfbuf[ch][i]=mfbuf[ch][i+gfp.framesize]}}return mp3size}(gfp,in_buffer[0],in_buffer[1],nsamples,mp3buf,mp3bufPos,mp3buf_size)}}function GetAudio(){this.setModules=function(parse2,mpg2){parse2,mpg2}}function Parse(){this.setModules=function(ver2,id32,pre2){ver2,id32,pre2}}function MPGLib(){}function ID3Tag(){this.setModules=function(_bits,_ver){_bits,_ver}}function WavHeader(){this.dataOffset=0,this.dataLen=0,this.channels=0,this.sampleRate=0}function fourccToInt(fourcc){return fourcc.charCodeAt(0)<<24|fourcc.charCodeAt(1)<<16|fourcc.charCodeAt(2)<<8|fourcc.charCodeAt(3)}L3Side.SFBMAX=3*Encoder.SBMAX_s,Encoder.ENCDELAY=576,Encoder.POSTDELAY=1152,Encoder.MDCTDELAY=48,Encoder.FFTOFFSET=224+Encoder.MDCTDELAY,Encoder.DECDELAY=528,Encoder.SBLIMIT=32,Encoder.CBANDS=64,Encoder.SBPSY_l=21,Encoder.SBPSY_s=12,Encoder.SBMAX_l=22,Encoder.SBMAX_s=13,Encoder.PSFB21=6,Encoder.PSFB12=6,Encoder.BLKSIZE=1024,Encoder.HBLKSIZE=Encoder.BLKSIZE/2+1,Encoder.BLKSIZE_s=256,Encoder.HBLKSIZE_s=Encoder.BLKSIZE_s/2+1,Encoder.NORM_TYPE=0,Encoder.START_TYPE=1,Encoder.SHORT_TYPE=2,Encoder.STOP_TYPE=3,Encoder.MPG_MD_LR_LR=0,Encoder.MPG_MD_LR_I=1,Encoder.MPG_MD_MS_LR=2,Encoder.MPG_MD_MS_I=3,Encoder.fircoef=[-.1039435,-.1892065,5*-.0432472,-.155915,3898045e-23,.0467745*5,.50455,.756825,.187098*5],LameInternalFlags.MFSIZE=3456+Encoder.ENCDELAY-Encoder.MDCTDELAY,LameInternalFlags.MAX_HEADER_BUF=256,LameInternalFlags.MAX_BITS_PER_CHANNEL=4095,LameInternalFlags.MAX_BITS_PER_GRANULE=7680,LameInternalFlags.BPC=320,WavHeader.RIFF=fourccToInt("RIFF"),WavHeader.WAVE=fourccToInt("WAVE"),WavHeader.fmt_=fourccToInt("fmt "),WavHeader.data=fourccToInt("data"),WavHeader.readHeader=function(dataView){var w=new WavHeader,header=dataView.getUint32(0,!1);if(WavHeader.RIFF==header){dataView.getUint32(4,!0);if(WavHeader.WAVE==dataView.getUint32(8,!1)&&WavHeader.fmt_==dataView.getUint32(12,!1)){var fmtLen=dataView.getUint32(16,!0),pos=20;switch(fmtLen){case 16:case 18:w.channels=dataView.getUint16(pos+2,!0),w.sampleRate=dataView.getUint32(pos+4,!0);break;default:throw"extended fmt chunk not implemented"}pos+=fmtLen;for(var data=WavHeader.data,len=0;data!=header&&(header=dataView.getUint32(pos,!1),len=dataView.getUint32(pos+4,!0),data!=header);)pos+=len+8;return w.dataLen=len,w.dataOffset=pos+8,w}}},L3Side.SFBMAX=3*Encoder.SBMAX_s,lamejs.Mp3Encoder=function(channels,samplerate,kbps){3!=arguments.length&&(console.error("WARN: Mp3Encoder(channels, samplerate, kbps) not specified"),channels=1,samplerate=44100,kbps=128);var lame=new Lame,gaud=new GetAudio,ga=new GainAnalysis,bs=new BitStream,p=new Presets,qupvt=new QuantizePVT,qu=new Quantize,vbr=new VBRTag,ver=new Version,id3=new ID3Tag,rv=new Reservoir,tak=new Takehiro,parse=new Parse,mpg=new MPGLib;lame.setModules(ga,bs,p,qupvt,qu,vbr,ver,id3,mpg),bs.setModules(ga,mpg,ver,vbr),id3.setModules(bs,ver),p.setModules(lame),qu.setModules(bs,rv,qupvt,tak),qupvt.setModules(tak,rv,lame.enc.psy),rv.setModules(bs),tak.setModules(qupvt),vbr.setModules(lame,bs,ver),gaud.setModules(parse,mpg),parse.setModules(ver,id3,p);var gfp=lame.lame_init();gfp.num_channels=channels,gfp.in_samplerate=samplerate,gfp.brate=kbps,gfp.mode=MPEGMode.STEREO,gfp.quality=3,gfp.bWriteVbrTag=!1,gfp.disable_reservoir=!0,gfp.write_id3tag_automatic=!1,lame.lame_init_params(gfp);var maxSamples=1152,mp3buf_size=0|1.25*maxSamples+7200,mp3buf=new_byte(mp3buf_size);this.encodeBuffer=function(left,right){1==channels&&(right=left),left.length>maxSamples&&(maxSamples=left.length,mp3buf=new_byte(mp3buf_size=0|1.25*maxSamples+7200));var _sz=lame.lame_encode_buffer(gfp,left,right,left.length,mp3buf,0,mp3buf_size);return new Int8Array(mp3buf.subarray(0,_sz))},this.flush=function(){var _sz=lame.lame_encode_flush(gfp,mp3buf,0,mp3buf_size);return new Int8Array(mp3buf.subarray(0,_sz))}},lamejs.WavHeader=WavHeader}Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.default=void 0,lamejs();var _default=lamejs;return _exports.default=_default,_exports.default}));

//# sourceMappingURL=lame.all.min.js.map