<!--
.. title: Security advisory: CVE-2017-7650
.. slug: security-advisory-cve-2017-7650
.. date: 2017-05-29 12:41:48
.. tags: Security,Releases
.. category:
.. link:
.. description:
.. type: text
-->

A vulnerability exists in Mosquitto versions 0.15 to 1.4.11 inclusive known as
[CVE-2017-7650].

Pattern based ACLs can be bypassed by clients that set their username/client id
to '#' or '+'. This allows locally or remotely connected clients to access MQTT
topics that they do have the rights to. The same issue may be present in third
party authentication/access control plugins for Mosquitto.

The vulnerability only comes into effect where pattern based ACLs are in use,
or potentially where third party plugins are in use.

The issue is fixed in Mosquitto 1.4.12, which has just been released. Patches
for older versions are available at <https://mosquitto.org/files/cve/2017-7650>

The fix addresses the problem by restricting access for clients with a '#',
'+', or '/' in their username or client id. '/' has been included in the list
of characters disallowed because it also has a special meaning in a topic and
may represent an additional risk. The restriction placed on clients is that
they may not receive or send messages that are subject to a pattern based ACL
check, nor any message that is subject to a plugin check.

Thanks to Artem Zinenko from HackerDom CTF team for finding this vulnerability
and responsibly reporting it.

Complete list of fixes addressed in version 1.4.12:

# Broker

 * Fix mosquitto.db from becoming corrupted due to client messages being
   persisted with no stored message. Closes [#424].
 * Fix bridge not restarting properly. Closes [#428].
 * Fix uninitialised memory in `gets_quiet` on Windows. Closes [#426].
 * Fix building with `WITH_ADNS=no` for systems that don't use glibc. Closes
   [#415].
 * Fixes to readme.md.
 * Fix deprecation warning for OpenSSL 1.1. PR [#416].
 * Don't segfault on duplicate bridge names. Closes [#446].
 * Fix [CVE-2017-7650].

[CVE-2017-7650]: http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2017-7650
[#415]: https://github.com/eclipse/mosquitto/issues/415
[#416]: https://github.com/eclipse/mosquitto/issues/416
[#424]: https://github.com/eclipse/mosquitto/issues/424
[#428]: https://github.com/eclipse/mosquitto/issues/428
[#426]: https://github.com/eclipse/mosquitto/issues/426
[#446]: https://github.com/eclipse/mosquitto/issues/446
