// SPDX-License-Identifier: GPL-2.0-only
/*
 * getopt-support.h -- getopt support header
 * (C)Copyright 2000-2024 by Hiroshi Takekawa
 * This file is part of multiskkserv.
 *
 * Last Modified: Sat Feb 24 15:53:00 2024.
 */

#ifndef _GETOPT_SUPPORT_H
#define _GETOPT_SUPPORT_H

typedef enum _argument_requirement {
  _NO_ARGUMENT,
  _REQUIRED_ARGUMENT,
  _OPTIONAL_ARGUMENT
} ArgumentRequirement;

typedef struct _option {
  const char *longopt; /* not supported so far */
  char opt;
  ArgumentRequirement argreq;
  const char *description;
} Option;

char *gen_optstring(Option []);
void print_option_usage(Option []);

#endif
