
# Common
if (MSVC)
    add_compile_options(/W4)
    add_compile_definitions(_CRT_SECURE_NO_WARNINGS)
    add_compile_options(/wd4127) # disabled warning: C4127: conditional expression is constant
    add_compile_definitions(_SILENCE_STDEXT_ARR_ITERS_DEPRECATION_WARNING) # needed for VS 17.8.1 to suppress tons of C4996 warnings
    # either the above or the below, or even both
    #add_compile_options(/wd4996) # disabled warning: C4996, needed for VS 17.8.1 to suppress tons (some 1000) of them in VS' own code
else()
    add_compile_options(-Wall -Wextra) #-Wconversion
endif()

# Target
function(target_no_warning TARGET WNAME)

    # message(STATUS "target_no_warning TARGET: ${TARGET} WNAME: ${WNAME}" )

    set(MSVC_Warning)
    set(GCC_Warning ${WNAME})
    set(CLANG_Warning ${WNAME})

    if (WNAME STREQUAL "-Wno-multichar")
        set(MSVC_Warning )
    elseif(WNAME STREQUAL "-Wimplicit-fallthrough=0")
        set(CLANG_Warning "-Wno-implicit-fallthrough")
    elseif(WNAME STREQUAL "-Wno-unused-parameter")
        set(MSVC_Warning /wd4100)
    elseif(WNAME STREQUAL "-Wno-unused-variable")
        set(MSVC_Warning /wd4101 /wd4189)
    elseif(WNAME STREQUAL "-Wunused-const-variable=0")
    elseif(WNAME STREQUAL "-Wno-type-limits")
    elseif(WNAME STREQUAL "-Wno-unknown-pragmas")
    elseif(WNAME STREQUAL "-Wno-truncate")
        set(MSVC_Warning /wd4310 /wd4311)
        unset(GCC_Warning)
    elseif(WNAME STREQUAL "-Wno-uninitialized")
        set(MSVC_Warning /wd4701 /wd4703)
    elseif(WNAME STREQUAL "-Wno-float-conversion")
        set(MSVC_Warning /wd4244)
    elseif(WNAME STREQUAL "-Wno-deprecated")
        set(MSVC_Warning /wd4996)
    elseif(WNAME STREQUAL "-Wno-deprecated-declarations")
        set(MSVC_Warning /wd4996)
    elseif(WNAME STREQUAL "-Wno-conversion")
        set(MSVC_Warning /wd4244 /wd4267 /wd4245 /wd4057 /wd4334)
    elseif(WNAME STREQUAL "-Wno-cast-function-type")
        unset(CLANG_Warning)
    elseif(WNAME STREQUAL "-Wno-array-bounds")
    elseif(WNAME STREQUAL "-Wno-shift-negative-value")
    elseif(WNAME STREQUAL "-Wno-implicit-fallthrough")
    elseif(WNAME STREQUAL "-Wno-empty-body")
    elseif(WNAME STREQUAL "-Wno-attributes")
    elseif(WNAME STREQUAL "-Wc-no-absolute-value")
        set(GCC_Warning $<$<COMPILE_LANGUAGE:C>:-Wno-absolute-value>)
        set(CLANG_Warning $<$<COMPILE_LANGUAGE:C>:-Wno-absolute-value>)
    elseif(WNAME STREQUAL "-Wc-no-tautological-pointer-compare")
        set(GCC_Warning $<$<COMPILE_LANGUAGE:C>:-Wno-tautological-pointer-compare>)
        set(CLANG_Warning $<$<COMPILE_LANGUAGE:C>:-Wno-tautological-pointer-compare>)
    elseif(WNAME STREQUAL "-Wc-no-array-parameter")
        set(GCC_Warning $<$<COMPILE_LANGUAGE:C>:-Wno-array-parameter>)
        set(CLANG_Warning $<$<COMPILE_LANGUAGE:C>:-Wno-array-parameter>)
    elseif(WNAME STREQUAL "-Wno-unused-but-set-variable")
    elseif(WNAME STREQUAL "-Wno-sign-compare")
    elseif(WNAME STREQUAL "-Wno-attributes")
    elseif(WNAME STREQUAL "-Wno-restrict")
        unset(CLANG_Warning)
    elseif(WNAME STREQUAL "-w")
        set(MSVC_Warning /W0)

    # Only MSVC warnings
    elseif(WNAME STREQUAL "-WMSVC-no-translation-unit-is-empty")
        unset(GCC_Warning)
        unset(CLANG_Warning)
        set(MSVC_Warning /wd4206)
    elseif(WNAME STREQUAL "-WMSVC-no-nonstandard-extension-used")
        unset(GCC_Warning)
        unset(CLANG_Warning)
        set(MSVC_Warning /wd4201)
    elseif(WNAME STREQUAL "-WMSVC-no-assignment-within-conditional-expression")
        unset(GCC_Warning)
        unset(CLANG_Warning)
        set(MSVC_Warning /wd4706)
    elseif(WNAME STREQUAL "-WMSVC-no-hides-previous")
        unset(GCC_Warning)
        unset(CLANG_Warning)
        set(MSVC_Warning /wd4456 /wd4457 /wd4458 /wd4459)
    elseif(WNAME STREQUAL "-WMSVC-no-undefined-assuming-extern") # warning: C4013: 'read' undefined; assuming extern returning int
        unset(GCC_Warning)
        unset(CLANG_Warning)
        set(MSVC_Warning /wd4013)
    elseif(WNAME STREQUAL "-WMSVC-no-signed-unsigned-mismatch")
        unset(GCC_Warning)
        unset(CLANG_Warning)
        set(MSVC_Warning /wd4018)
    elseif(WNAME STREQUAL "-WMSVC-named-type-definition-in-parentheses")
        unset(GCC_Warning)
        unset(CLANG_Warning)
        set(MSVC_Warning /wd4115)
    elseif(WNAME STREQUAL "-WMSVC-no-unreachable")
        unset(GCC_Warning)
        unset(CLANG_Warning)
        set(MSVC_Warning /wd4702)
    elseif(WNAME STREQUAL "-WMSVC-no-benign-redefinition")
        unset(GCC_Warning)
        unset(CLANG_Warning)
        set(MSVC_Warning /wd5294)
    elseif(WNAME STREQUAL "-WMSVC-no-different-enum-types")
        unset(GCC_Warning)
        unset(CLANG_Warning)
        set(MSVC_Warning /wd5287)
    else()
        message(WARNING "Unknown warning: ${WNAME}, please add this warning to ${CMAKE_CURRENT_LIST_DIR}/SetupCompileWarnings.cmake")
    endif()

    if (CC_IS_MSVC)
        target_compile_options(${TARGET} PRIVATE ${MSVC_Warning})
    elseif(CC_IS_CLANG)
        target_compile_options(${TARGET} PRIVATE ${CLANG_Warning})
    else()
        target_compile_options(${TARGET} PRIVATE ${GCC_Warning})
    endif()

endfunction()
