/* Copyright (c) 2016, 2025, Oracle and/or its affiliates.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License, version 2.0,
as published by the Free Software Foundation.

This program is designed to work with certain software (including
but not limited to OpenSSL) that is licensed under separate terms,
as designated in a particular file or component or in included license
documentation.  The authors of MySQL hereby grant you an additional
permission to link the program and your derivative works with the
separately licensed software that they have either included with
the program or referenced in the documentation.

Without limiting anything contained in the foregoing, this file,
which is part of ODBC Driver for MySQL (Connector/ODBC), is also subject to the
Universal FOSS Exception, version 1.0, a copy of which can be found at
http://oss.oracle.com/licenses/universal-foss-exception.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License, version 2.0, for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA */


/*
  This header file contains weight tables and weight length table of
  UCA8.0.0, as well as some constant values and table of decomposition.
*/

#ifndef UCA900_DATA_H
#define UCA900_DATA_H

#include "m_ctype.h"
#include "str_uca_type.h"

#define MY_UCA_900_CE_SIZE 3
const uint16 CASE_FIRST_UPPER_MASK= 0x0100;
const uint16 CASE_FIRST_MIXED_MASK= 0x0200;
const uint16 CASE_FIRST_LOWER_MASK= 0x0300;

enum enum_char_category{
  CHAR_CATEGORY_CC= 1, CHAR_CATEGORY_CF, CHAR_CATEGORY_CO, CHAR_CATEGORY_CS,
  CHAR_CATEGORY_LL, CHAR_CATEGORY_LM, CHAR_CATEGORY_LO, CHAR_CATEGORY_LT,
  CHAR_CATEGORY_LU, CHAR_CATEGORY_MC, CHAR_CATEGORY_ME, CHAR_CATEGORY_MN,
  CHAR_CATEGORY_ND, CHAR_CATEGORY_NL, CHAR_CATEGORY_NO, CHAR_CATEGORY_PC,
  CHAR_CATEGORY_PD, CHAR_CATEGORY_PE, CHAR_CATEGORY_PF, CHAR_CATEGORY_PI,
  CHAR_CATEGORY_PO, CHAR_CATEGORY_PS, CHAR_CATEGORY_SC, CHAR_CATEGORY_SK,
  CHAR_CATEGORY_SM, CHAR_CATEGORY_SO, CHAR_CATEGORY_ZL, CHAR_CATEGORY_ZP,
  CHAR_CATEGORY_ZS
};

enum enum_decomp_tag{
  DECOMP_TAG_NONE,      DECOMP_TAG_CIRCLE,   DECOMP_TAG_COMPAT,
  DECOMP_TAG_FINAL,     DECOMP_TAG_FONT,     DECOMP_TAG_FRACTION,
  DECOMP_TAG_INITIAL,   DECOMP_TAG_ISOLATED, DECOMP_TAG_MEDIAL,
  DECOMP_TAG_NARROW,    DECOMP_TAG_NOBREAK,  DECOMP_TAG_SMALL,
  DECOMP_TAG_SQUARE,    DECOMP_TAG_SUB,      DECOMP_TAG_SUPER,
  DECOMP_TAG_VERTICAL,  DECOMP_TAG_WIDE
};

struct Unidata_decomp
{
  my_wc_t charcode;
  enum_char_category category;
  enum_decomp_tag    decomp_tag;
  my_wc_t dec_codes[MY_UCA_MAX_CONTRACTION];
};

Unidata_decomp uni_dec[]= {
  {0x00A0, CHAR_CATEGORY_ZS, DECOMP_TAG_NOBREAK,
   {0x0020, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x00A8, CHAR_CATEGORY_SK, DECOMP_TAG_COMPAT,
   {0x0020, 0x0308, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x00AA, CHAR_CATEGORY_LO, DECOMP_TAG_SUPER,
   {0x0061, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x00AF, CHAR_CATEGORY_SK, DECOMP_TAG_COMPAT,
   {0x0020, 0x0304, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x00B2, CHAR_CATEGORY_NO, DECOMP_TAG_SUPER,
   {0x0032, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x00B3, CHAR_CATEGORY_NO, DECOMP_TAG_SUPER,
   {0x0033, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x00B4, CHAR_CATEGORY_SK, DECOMP_TAG_COMPAT,
   {0x0020, 0x0301, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x00B5, CHAR_CATEGORY_LL, DECOMP_TAG_COMPAT,
   {0x03BC, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x00B8, CHAR_CATEGORY_SK, DECOMP_TAG_COMPAT,
   {0x0020, 0x0327, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x00B9, CHAR_CATEGORY_NO, DECOMP_TAG_SUPER,
   {0x0031, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x00BA, CHAR_CATEGORY_LO, DECOMP_TAG_SUPER,
   {0x006F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x00BC, CHAR_CATEGORY_NO, DECOMP_TAG_FRACTION,
   {0x0031, 0x2044, 0x0034, 0x0000, 0x0000, 0x0000}},
  {0x00BD, CHAR_CATEGORY_NO, DECOMP_TAG_FRACTION,
   {0x0031, 0x2044, 0x0032, 0x0000, 0x0000, 0x0000}},
  {0x00BE, CHAR_CATEGORY_NO, DECOMP_TAG_FRACTION,
   {0x0033, 0x2044, 0x0034, 0x0000, 0x0000, 0x0000}},
  {0x00C0, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0041, 0x0300, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x00C1, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0041, 0x0301, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x00C2, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0041, 0x0302, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x00C3, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0041, 0x0303, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x00C4, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0041, 0x0308, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x00C5, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0041, 0x030A, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x00C7, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0043, 0x0327, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x00C8, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0045, 0x0300, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x00C9, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0045, 0x0301, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x00CA, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0045, 0x0302, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x00CB, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0045, 0x0308, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x00CC, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0049, 0x0300, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x00CD, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0049, 0x0301, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x00CE, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0049, 0x0302, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x00CF, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0049, 0x0308, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x00D1, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x004E, 0x0303, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x00D2, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x004F, 0x0300, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x00D3, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x004F, 0x0301, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x00D4, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x004F, 0x0302, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x00D5, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x004F, 0x0303, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x00D6, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x004F, 0x0308, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x00D9, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0055, 0x0300, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x00DA, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0055, 0x0301, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x00DB, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0055, 0x0302, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x00DC, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0055, 0x0308, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x00DD, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0059, 0x0301, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x00E0, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0061, 0x0300, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x00E1, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0061, 0x0301, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x00E2, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0061, 0x0302, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x00E3, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0061, 0x0303, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x00E4, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0061, 0x0308, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x00E5, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0061, 0x030A, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x00E7, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0063, 0x0327, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x00E8, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0065, 0x0300, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x00E9, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0065, 0x0301, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x00EA, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0065, 0x0302, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x00EB, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0065, 0x0308, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x00EC, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0069, 0x0300, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x00ED, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0069, 0x0301, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x00EE, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0069, 0x0302, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x00EF, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0069, 0x0308, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x00F1, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x006E, 0x0303, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x00F2, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x006F, 0x0300, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x00F3, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x006F, 0x0301, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x00F4, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x006F, 0x0302, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x00F5, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x006F, 0x0303, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x00F6, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x006F, 0x0308, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x00F9, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0075, 0x0300, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x00FA, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0075, 0x0301, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x00FB, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0075, 0x0302, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x00FC, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0075, 0x0308, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x00FD, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0079, 0x0301, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x00FF, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0079, 0x0308, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0100, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0041, 0x0304, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0101, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0061, 0x0304, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0102, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0041, 0x0306, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0103, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0061, 0x0306, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0104, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0041, 0x0328, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0105, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0061, 0x0328, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0106, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0043, 0x0301, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0107, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0063, 0x0301, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0108, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0043, 0x0302, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0109, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0063, 0x0302, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x010A, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0043, 0x0307, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x010B, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0063, 0x0307, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x010C, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0043, 0x030C, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x010D, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0063, 0x030C, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x010E, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0044, 0x030C, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x010F, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0064, 0x030C, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0112, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0045, 0x0304, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0113, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0065, 0x0304, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0114, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0045, 0x0306, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0115, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0065, 0x0306, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0116, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0045, 0x0307, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0117, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0065, 0x0307, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0118, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0045, 0x0328, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0119, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0065, 0x0328, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x011A, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0045, 0x030C, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x011B, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0065, 0x030C, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x011C, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0047, 0x0302, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x011D, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0067, 0x0302, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x011E, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0047, 0x0306, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x011F, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0067, 0x0306, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0120, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0047, 0x0307, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0121, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0067, 0x0307, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0122, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0047, 0x0327, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0123, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0067, 0x0327, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0124, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0048, 0x0302, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0125, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0068, 0x0302, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0128, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0049, 0x0303, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0129, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0069, 0x0303, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x012A, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0049, 0x0304, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x012B, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0069, 0x0304, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x012C, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0049, 0x0306, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x012D, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0069, 0x0306, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x012E, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0049, 0x0328, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x012F, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0069, 0x0328, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0130, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0049, 0x0307, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0132, CHAR_CATEGORY_LU, DECOMP_TAG_COMPAT,
   {0x0049, 0x004A, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0133, CHAR_CATEGORY_LL, DECOMP_TAG_COMPAT,
   {0x0069, 0x006A, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0134, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x004A, 0x0302, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0135, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x006A, 0x0302, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0136, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x004B, 0x0327, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0137, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x006B, 0x0327, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0139, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x004C, 0x0301, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x013A, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x006C, 0x0301, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x013B, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x004C, 0x0327, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x013C, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x006C, 0x0327, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x013D, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x004C, 0x030C, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x013E, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x006C, 0x030C, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x013F, CHAR_CATEGORY_LU, DECOMP_TAG_COMPAT,
   {0x004C, 0x00B7, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0140, CHAR_CATEGORY_LL, DECOMP_TAG_COMPAT,
   {0x006C, 0x00B7, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0143, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x004E, 0x0301, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0144, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x006E, 0x0301, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0145, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x004E, 0x0327, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0146, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x006E, 0x0327, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0147, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x004E, 0x030C, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0148, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x006E, 0x030C, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0149, CHAR_CATEGORY_LL, DECOMP_TAG_COMPAT,
   {0x02BC, 0x006E, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x014C, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x004F, 0x0304, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x014D, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x006F, 0x0304, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x014E, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x004F, 0x0306, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x014F, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x006F, 0x0306, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0150, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x004F, 0x030B, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0151, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x006F, 0x030B, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0154, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0052, 0x0301, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0155, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0072, 0x0301, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0156, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0052, 0x0327, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0157, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0072, 0x0327, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0158, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0052, 0x030C, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0159, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0072, 0x030C, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x015A, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0053, 0x0301, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x015B, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0073, 0x0301, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x015C, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0053, 0x0302, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x015D, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0073, 0x0302, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x015E, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0053, 0x0327, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x015F, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0073, 0x0327, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0160, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0053, 0x030C, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0161, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0073, 0x030C, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0162, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0054, 0x0327, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0163, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0074, 0x0327, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0164, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0054, 0x030C, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0165, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0074, 0x030C, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0168, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0055, 0x0303, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0169, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0075, 0x0303, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x016A, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0055, 0x0304, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x016B, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0075, 0x0304, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x016C, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0055, 0x0306, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x016D, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0075, 0x0306, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x016E, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0055, 0x030A, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x016F, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0075, 0x030A, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0170, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0055, 0x030B, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0171, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0075, 0x030B, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0172, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0055, 0x0328, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0173, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0075, 0x0328, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0174, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0057, 0x0302, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0175, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0077, 0x0302, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0176, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0059, 0x0302, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0177, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0079, 0x0302, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0178, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0059, 0x0308, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0179, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x005A, 0x0301, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x017A, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x007A, 0x0301, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x017B, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x005A, 0x0307, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x017C, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x007A, 0x0307, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x017D, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x005A, 0x030C, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x017E, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x007A, 0x030C, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x017F, CHAR_CATEGORY_LL, DECOMP_TAG_COMPAT,
   {0x0073, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x01A0, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x004F, 0x031B, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x01A1, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x006F, 0x031B, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x01AF, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0055, 0x031B, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x01B0, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0075, 0x031B, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x01C4, CHAR_CATEGORY_LU, DECOMP_TAG_COMPAT,
   {0x0044, 0x017D, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x01C5, CHAR_CATEGORY_LT, DECOMP_TAG_COMPAT,
   {0x0044, 0x017E, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x01C6, CHAR_CATEGORY_LL, DECOMP_TAG_COMPAT,
   {0x0064, 0x017E, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x01C7, CHAR_CATEGORY_LU, DECOMP_TAG_COMPAT,
   {0x004C, 0x004A, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x01C8, CHAR_CATEGORY_LT, DECOMP_TAG_COMPAT,
   {0x004C, 0x006A, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x01C9, CHAR_CATEGORY_LL, DECOMP_TAG_COMPAT,
   {0x006C, 0x006A, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x01CA, CHAR_CATEGORY_LU, DECOMP_TAG_COMPAT,
   {0x004E, 0x004A, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x01CB, CHAR_CATEGORY_LT, DECOMP_TAG_COMPAT,
   {0x004E, 0x006A, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x01CC, CHAR_CATEGORY_LL, DECOMP_TAG_COMPAT,
   {0x006E, 0x006A, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x01CD, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0041, 0x030C, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x01CE, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0061, 0x030C, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x01CF, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0049, 0x030C, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x01D0, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0069, 0x030C, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x01D1, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x004F, 0x030C, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x01D2, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x006F, 0x030C, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x01D3, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0055, 0x030C, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x01D4, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0075, 0x030C, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x01D5, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0055, 0x0308, 0x0304, 0x0000, 0x0000, 0x0000}},
  {0x01D6, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0075, 0x0308, 0x0304, 0x0000, 0x0000, 0x0000}},
  {0x01D7, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0055, 0x0308, 0x0301, 0x0000, 0x0000, 0x0000}},
  {0x01D8, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0075, 0x0308, 0x0301, 0x0000, 0x0000, 0x0000}},
  {0x01D9, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0055, 0x0308, 0x030C, 0x0000, 0x0000, 0x0000}},
  {0x01DA, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0075, 0x0308, 0x030C, 0x0000, 0x0000, 0x0000}},
  {0x01DB, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0055, 0x0308, 0x0300, 0x0000, 0x0000, 0x0000}},
  {0x01DC, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0075, 0x0308, 0x0300, 0x0000, 0x0000, 0x0000}},
  {0x01DE, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0041, 0x0308, 0x0304, 0x0000, 0x0000, 0x0000}},
  {0x01DF, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0061, 0x0308, 0x0304, 0x0000, 0x0000, 0x0000}},
  {0x01E0, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0041, 0x0307, 0x0304, 0x0000, 0x0000, 0x0000}},
  {0x01E1, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0061, 0x0307, 0x0304, 0x0000, 0x0000, 0x0000}},
  {0x01E2, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x00C6, 0x0304, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x01E3, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x00E6, 0x0304, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x01E6, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0047, 0x030C, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x01E7, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0067, 0x030C, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x01E8, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x004B, 0x030C, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x01E9, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x006B, 0x030C, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x01EA, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x004F, 0x0328, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x01EB, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x006F, 0x0328, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x01EC, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x004F, 0x0328, 0x0304, 0x0000, 0x0000, 0x0000}},
  {0x01ED, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x006F, 0x0328, 0x0304, 0x0000, 0x0000, 0x0000}},
  {0x01EE, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x01B7, 0x030C, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x01EF, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0292, 0x030C, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x01F0, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x006A, 0x030C, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x01F1, CHAR_CATEGORY_LU, DECOMP_TAG_COMPAT,
   {0x0044, 0x005A, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x01F2, CHAR_CATEGORY_LT, DECOMP_TAG_COMPAT,
   {0x0044, 0x007A, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x01F3, CHAR_CATEGORY_LL, DECOMP_TAG_COMPAT,
   {0x0064, 0x007A, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x01F4, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0047, 0x0301, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x01F5, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0067, 0x0301, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x01F8, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x004E, 0x0300, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x01F9, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x006E, 0x0300, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x01FA, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0041, 0x030A, 0x0301, 0x0000, 0x0000, 0x0000}},
  {0x01FB, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0061, 0x030A, 0x0301, 0x0000, 0x0000, 0x0000}},
  {0x01FC, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x00C6, 0x0301, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x01FD, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x00E6, 0x0301, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x01FE, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x00D8, 0x0301, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x01FF, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x00F8, 0x0301, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0200, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0041, 0x030F, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0201, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0061, 0x030F, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0202, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0041, 0x0311, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0203, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0061, 0x0311, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0204, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0045, 0x030F, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0205, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0065, 0x030F, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0206, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0045, 0x0311, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0207, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0065, 0x0311, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0208, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0049, 0x030F, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0209, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0069, 0x030F, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x020A, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0049, 0x0311, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x020B, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0069, 0x0311, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x020C, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x004F, 0x030F, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x020D, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x006F, 0x030F, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x020E, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x004F, 0x0311, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x020F, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x006F, 0x0311, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0210, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0052, 0x030F, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0211, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0072, 0x030F, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0212, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0052, 0x0311, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0213, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0072, 0x0311, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0214, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0055, 0x030F, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0215, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0075, 0x030F, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0216, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0055, 0x0311, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0217, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0075, 0x0311, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0218, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0053, 0x0326, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0219, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0073, 0x0326, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x021A, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0054, 0x0326, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x021B, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0074, 0x0326, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x021E, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0048, 0x030C, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x021F, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0068, 0x030C, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0226, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0041, 0x0307, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0227, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0061, 0x0307, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0228, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0045, 0x0327, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0229, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0065, 0x0327, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x022A, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x004F, 0x0308, 0x0304, 0x0000, 0x0000, 0x0000}},
  {0x022B, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x006F, 0x0308, 0x0304, 0x0000, 0x0000, 0x0000}},
  {0x022C, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x004F, 0x0303, 0x0304, 0x0000, 0x0000, 0x0000}},
  {0x022D, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x006F, 0x0303, 0x0304, 0x0000, 0x0000, 0x0000}},
  {0x022E, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x004F, 0x0307, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x022F, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x006F, 0x0307, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0230, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x004F, 0x0307, 0x0304, 0x0000, 0x0000, 0x0000}},
  {0x0231, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x006F, 0x0307, 0x0304, 0x0000, 0x0000, 0x0000}},
  {0x0232, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0059, 0x0304, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0233, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0079, 0x0304, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x02B0, CHAR_CATEGORY_LM, DECOMP_TAG_SUPER,
   {0x0068, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x02B1, CHAR_CATEGORY_LM, DECOMP_TAG_SUPER,
   {0x0266, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x02B2, CHAR_CATEGORY_LM, DECOMP_TAG_SUPER,
   {0x006A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x02B3, CHAR_CATEGORY_LM, DECOMP_TAG_SUPER,
   {0x0072, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x02B4, CHAR_CATEGORY_LM, DECOMP_TAG_SUPER,
   {0x0279, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x02B5, CHAR_CATEGORY_LM, DECOMP_TAG_SUPER,
   {0x027B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x02B6, CHAR_CATEGORY_LM, DECOMP_TAG_SUPER,
   {0x0281, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x02B7, CHAR_CATEGORY_LM, DECOMP_TAG_SUPER,
   {0x0077, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x02B8, CHAR_CATEGORY_LM, DECOMP_TAG_SUPER,
   {0x0079, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x02D8, CHAR_CATEGORY_SK, DECOMP_TAG_COMPAT,
   {0x0020, 0x0306, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x02D9, CHAR_CATEGORY_SK, DECOMP_TAG_COMPAT,
   {0x0020, 0x0307, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x02DA, CHAR_CATEGORY_SK, DECOMP_TAG_COMPAT,
   {0x0020, 0x030A, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x02DB, CHAR_CATEGORY_SK, DECOMP_TAG_COMPAT,
   {0x0020, 0x0328, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x02DC, CHAR_CATEGORY_SK, DECOMP_TAG_COMPAT,
   {0x0020, 0x0303, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x02DD, CHAR_CATEGORY_SK, DECOMP_TAG_COMPAT,
   {0x0020, 0x030B, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x02E0, CHAR_CATEGORY_LM, DECOMP_TAG_SUPER,
   {0x0263, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x02E1, CHAR_CATEGORY_LM, DECOMP_TAG_SUPER,
   {0x006C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x02E2, CHAR_CATEGORY_LM, DECOMP_TAG_SUPER,
   {0x0073, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x02E3, CHAR_CATEGORY_LM, DECOMP_TAG_SUPER,
   {0x0078, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x02E4, CHAR_CATEGORY_LM, DECOMP_TAG_SUPER,
   {0x0295, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0340, CHAR_CATEGORY_MN, DECOMP_TAG_NONE,
   {0x0300, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0341, CHAR_CATEGORY_MN, DECOMP_TAG_NONE,
   {0x0301, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0343, CHAR_CATEGORY_MN, DECOMP_TAG_NONE,
   {0x0313, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0344, CHAR_CATEGORY_MN, DECOMP_TAG_NONE,
   {0x0308, 0x0301, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0374, CHAR_CATEGORY_LM, DECOMP_TAG_NONE,
   {0x02B9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x037A, CHAR_CATEGORY_LM, DECOMP_TAG_COMPAT,
   {0x0020, 0x0345, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x037E, CHAR_CATEGORY_PO, DECOMP_TAG_NONE,
   {0x003B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0384, CHAR_CATEGORY_SK, DECOMP_TAG_COMPAT,
   {0x0020, 0x0301, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0385, CHAR_CATEGORY_SK, DECOMP_TAG_NONE,
   {0x00A8, 0x0301, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0386, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0391, 0x0301, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0387, CHAR_CATEGORY_PO, DECOMP_TAG_NONE,
   {0x00B7, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0388, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0395, 0x0301, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0389, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0397, 0x0301, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x038A, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0399, 0x0301, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x038C, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x039F, 0x0301, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x038E, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x03A5, 0x0301, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x038F, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x03A9, 0x0301, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0390, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x03B9, 0x0308, 0x0301, 0x0000, 0x0000, 0x0000}},
  {0x03AA, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0399, 0x0308, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x03AB, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x03A5, 0x0308, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x03AC, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x03B1, 0x0301, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x03AD, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x03B5, 0x0301, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x03AE, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x03B7, 0x0301, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x03AF, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x03B9, 0x0301, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x03B0, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x03C5, 0x0308, 0x0301, 0x0000, 0x0000, 0x0000}},
  {0x03CA, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x03B9, 0x0308, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x03CB, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x03C5, 0x0308, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x03CC, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x03BF, 0x0301, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x03CD, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x03C5, 0x0301, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x03CE, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x03C9, 0x0301, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x03D0, CHAR_CATEGORY_LL, DECOMP_TAG_COMPAT,
   {0x03B2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x03D1, CHAR_CATEGORY_LL, DECOMP_TAG_COMPAT,
   {0x03B8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x03D2, CHAR_CATEGORY_LU, DECOMP_TAG_COMPAT,
   {0x03A5, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x03D3, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x03D2, 0x0301, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x03D4, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x03D2, 0x0308, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x03D5, CHAR_CATEGORY_LL, DECOMP_TAG_COMPAT,
   {0x03C6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x03D6, CHAR_CATEGORY_LL, DECOMP_TAG_COMPAT,
   {0x03C0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x03F0, CHAR_CATEGORY_LL, DECOMP_TAG_COMPAT,
   {0x03BA, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x03F1, CHAR_CATEGORY_LL, DECOMP_TAG_COMPAT,
   {0x03C1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x03F2, CHAR_CATEGORY_LL, DECOMP_TAG_COMPAT,
   {0x03C2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x03F4, CHAR_CATEGORY_LU, DECOMP_TAG_COMPAT,
   {0x0398, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x03F5, CHAR_CATEGORY_LL, DECOMP_TAG_COMPAT,
   {0x03B5, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x03F9, CHAR_CATEGORY_LU, DECOMP_TAG_COMPAT,
   {0x03A3, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0400, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0415, 0x0300, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0401, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0415, 0x0308, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0403, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0413, 0x0301, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0407, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0406, 0x0308, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x040C, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x041A, 0x0301, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x040D, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0418, 0x0300, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x040E, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0423, 0x0306, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0419, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0418, 0x0306, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0439, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0438, 0x0306, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0450, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0435, 0x0300, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0451, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0435, 0x0308, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0453, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0433, 0x0301, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0457, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0456, 0x0308, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x045C, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x043A, 0x0301, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x045D, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0438, 0x0300, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x045E, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0443, 0x0306, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0476, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0474, 0x030F, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0477, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0475, 0x030F, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x04C1, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0416, 0x0306, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x04C2, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0436, 0x0306, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x04D0, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0410, 0x0306, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x04D1, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0430, 0x0306, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x04D2, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0410, 0x0308, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x04D3, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0430, 0x0308, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x04D6, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0415, 0x0306, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x04D7, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0435, 0x0306, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x04DA, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x04D8, 0x0308, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x04DB, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x04D9, 0x0308, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x04DC, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0416, 0x0308, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x04DD, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0436, 0x0308, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x04DE, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0417, 0x0308, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x04DF, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0437, 0x0308, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x04E2, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0418, 0x0304, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x04E3, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0438, 0x0304, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x04E4, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0418, 0x0308, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x04E5, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0438, 0x0308, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x04E6, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x041E, 0x0308, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x04E7, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x043E, 0x0308, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x04EA, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x04E8, 0x0308, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x04EB, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x04E9, 0x0308, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x04EC, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x042D, 0x0308, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x04ED, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x044D, 0x0308, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x04EE, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0423, 0x0304, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x04EF, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0443, 0x0304, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x04F0, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0423, 0x0308, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x04F1, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0443, 0x0308, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x04F2, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0423, 0x030B, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x04F3, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0443, 0x030B, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x04F4, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0427, 0x0308, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x04F5, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0447, 0x0308, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x04F8, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x042B, 0x0308, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x04F9, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x044B, 0x0308, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0587, CHAR_CATEGORY_LL, DECOMP_TAG_COMPAT,
   {0x0565, 0x0582, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0622, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x0627, 0x0653, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0623, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x0627, 0x0654, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0624, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x0648, 0x0654, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0625, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x0627, 0x0655, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0626, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x064A, 0x0654, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0675, CHAR_CATEGORY_LO, DECOMP_TAG_COMPAT,
   {0x0627, 0x0674, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0676, CHAR_CATEGORY_LO, DECOMP_TAG_COMPAT,
   {0x0648, 0x0674, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0677, CHAR_CATEGORY_LO, DECOMP_TAG_COMPAT,
   {0x06C7, 0x0674, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0678, CHAR_CATEGORY_LO, DECOMP_TAG_COMPAT,
   {0x064A, 0x0674, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x06C0, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x06D5, 0x0654, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x06C2, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x06C1, 0x0654, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x06D3, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x06D2, 0x0654, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0929, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x0928, 0x093C, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0931, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x0930, 0x093C, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0934, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x0933, 0x093C, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0958, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x0915, 0x093C, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0959, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x0916, 0x093C, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x095A, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x0917, 0x093C, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x095B, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x091C, 0x093C, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x095C, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x0921, 0x093C, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x095D, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x0922, 0x093C, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x095E, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x092B, 0x093C, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x095F, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x092F, 0x093C, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x09CB, CHAR_CATEGORY_MC, DECOMP_TAG_NONE,
   {0x09C7, 0x09BE, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x09CC, CHAR_CATEGORY_MC, DECOMP_TAG_NONE,
   {0x09C7, 0x09D7, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x09DC, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x09A1, 0x09BC, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x09DD, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x09A2, 0x09BC, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x09DF, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x09AF, 0x09BC, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0A33, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x0A32, 0x0A3C, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0A36, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x0A38, 0x0A3C, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0A59, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x0A16, 0x0A3C, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0A5A, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x0A17, 0x0A3C, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0A5B, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x0A1C, 0x0A3C, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0A5E, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x0A2B, 0x0A3C, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0B48, CHAR_CATEGORY_MC, DECOMP_TAG_NONE,
   {0x0B47, 0x0B56, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0B4B, CHAR_CATEGORY_MC, DECOMP_TAG_NONE,
   {0x0B47, 0x0B3E, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0B4C, CHAR_CATEGORY_MC, DECOMP_TAG_NONE,
   {0x0B47, 0x0B57, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0B5C, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x0B21, 0x0B3C, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0B5D, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x0B22, 0x0B3C, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0B94, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x0B92, 0x0BD7, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0BCA, CHAR_CATEGORY_MC, DECOMP_TAG_NONE,
   {0x0BC6, 0x0BBE, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0BCB, CHAR_CATEGORY_MC, DECOMP_TAG_NONE,
   {0x0BC7, 0x0BBE, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0BCC, CHAR_CATEGORY_MC, DECOMP_TAG_NONE,
   {0x0BC6, 0x0BD7, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0C48, CHAR_CATEGORY_MN, DECOMP_TAG_NONE,
   {0x0C46, 0x0C56, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0CC0, CHAR_CATEGORY_MC, DECOMP_TAG_NONE,
   {0x0CBF, 0x0CD5, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0CC7, CHAR_CATEGORY_MC, DECOMP_TAG_NONE,
   {0x0CC6, 0x0CD5, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0CC8, CHAR_CATEGORY_MC, DECOMP_TAG_NONE,
   {0x0CC6, 0x0CD6, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0CCA, CHAR_CATEGORY_MC, DECOMP_TAG_NONE,
   {0x0CC6, 0x0CC2, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0CCB, CHAR_CATEGORY_MC, DECOMP_TAG_NONE,
   {0x0CC6, 0x0CC2, 0x0CD5, 0x0000, 0x0000, 0x0000}},
  {0x0D4A, CHAR_CATEGORY_MC, DECOMP_TAG_NONE,
   {0x0D46, 0x0D3E, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0D4B, CHAR_CATEGORY_MC, DECOMP_TAG_NONE,
   {0x0D47, 0x0D3E, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0D4C, CHAR_CATEGORY_MC, DECOMP_TAG_NONE,
   {0x0D46, 0x0D57, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0DDA, CHAR_CATEGORY_MC, DECOMP_TAG_NONE,
   {0x0DD9, 0x0DCA, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0DDC, CHAR_CATEGORY_MC, DECOMP_TAG_NONE,
   {0x0DD9, 0x0DCF, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0DDD, CHAR_CATEGORY_MC, DECOMP_TAG_NONE,
   {0x0DD9, 0x0DCF, 0x0DCA, 0x0000, 0x0000, 0x0000}},
  {0x0DDE, CHAR_CATEGORY_MC, DECOMP_TAG_NONE,
   {0x0DD9, 0x0DDF, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0E33, CHAR_CATEGORY_LO, DECOMP_TAG_COMPAT,
   {0x0E4D, 0x0E32, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0EB3, CHAR_CATEGORY_LO, DECOMP_TAG_COMPAT,
   {0x0ECD, 0x0EB2, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0EDC, CHAR_CATEGORY_LO, DECOMP_TAG_COMPAT,
   {0x0EAB, 0x0E99, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0EDD, CHAR_CATEGORY_LO, DECOMP_TAG_COMPAT,
   {0x0EAB, 0x0EA1, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0F0C, CHAR_CATEGORY_PO, DECOMP_TAG_NOBREAK,
   {0x0F0B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0F43, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x0F42, 0x0FB7, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0F4D, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x0F4C, 0x0FB7, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0F52, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x0F51, 0x0FB7, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0F57, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x0F56, 0x0FB7, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0F5C, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x0F5B, 0x0FB7, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0F69, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x0F40, 0x0FB5, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0F73, CHAR_CATEGORY_MN, DECOMP_TAG_NONE,
   {0x0F71, 0x0F72, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0F75, CHAR_CATEGORY_MN, DECOMP_TAG_NONE,
   {0x0F71, 0x0F74, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0F76, CHAR_CATEGORY_MN, DECOMP_TAG_NONE,
   {0x0FB2, 0x0F80, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0F77, CHAR_CATEGORY_MN, DECOMP_TAG_COMPAT,
   {0x0FB2, 0x0F81, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0F78, CHAR_CATEGORY_MN, DECOMP_TAG_NONE,
   {0x0FB3, 0x0F80, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0F79, CHAR_CATEGORY_MN, DECOMP_TAG_COMPAT,
   {0x0FB3, 0x0F81, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0F81, CHAR_CATEGORY_MN, DECOMP_TAG_NONE,
   {0x0F71, 0x0F80, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0F93, CHAR_CATEGORY_MN, DECOMP_TAG_NONE,
   {0x0F92, 0x0FB7, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0F9D, CHAR_CATEGORY_MN, DECOMP_TAG_NONE,
   {0x0F9C, 0x0FB7, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0FA2, CHAR_CATEGORY_MN, DECOMP_TAG_NONE,
   {0x0FA1, 0x0FB7, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0FA7, CHAR_CATEGORY_MN, DECOMP_TAG_NONE,
   {0x0FA6, 0x0FB7, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0FAC, CHAR_CATEGORY_MN, DECOMP_TAG_NONE,
   {0x0FAB, 0x0FB7, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x0FB9, CHAR_CATEGORY_MN, DECOMP_TAG_NONE,
   {0x0F90, 0x0FB5, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1026, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x1025, 0x102E, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x10FC, CHAR_CATEGORY_LM, DECOMP_TAG_SUPER,
   {0x10DC, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1B06, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x1B05, 0x1B35, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1B08, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x1B07, 0x1B35, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1B0A, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x1B09, 0x1B35, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1B0C, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x1B0B, 0x1B35, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1B0E, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x1B0D, 0x1B35, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1B12, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x1B11, 0x1B35, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1B3B, CHAR_CATEGORY_MC, DECOMP_TAG_NONE,
   {0x1B3A, 0x1B35, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1B3D, CHAR_CATEGORY_MC, DECOMP_TAG_NONE,
   {0x1B3C, 0x1B35, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1B40, CHAR_CATEGORY_MC, DECOMP_TAG_NONE,
   {0x1B3E, 0x1B35, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1B41, CHAR_CATEGORY_MC, DECOMP_TAG_NONE,
   {0x1B3F, 0x1B35, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1B43, CHAR_CATEGORY_MC, DECOMP_TAG_NONE,
   {0x1B42, 0x1B35, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D2C, CHAR_CATEGORY_LM, DECOMP_TAG_SUPER,
   {0x0041, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D2D, CHAR_CATEGORY_LM, DECOMP_TAG_SUPER,
   {0x00C6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D2E, CHAR_CATEGORY_LM, DECOMP_TAG_SUPER,
   {0x0042, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D30, CHAR_CATEGORY_LM, DECOMP_TAG_SUPER,
   {0x0044, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D31, CHAR_CATEGORY_LM, DECOMP_TAG_SUPER,
   {0x0045, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D32, CHAR_CATEGORY_LM, DECOMP_TAG_SUPER,
   {0x018E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D33, CHAR_CATEGORY_LM, DECOMP_TAG_SUPER,
   {0x0047, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D34, CHAR_CATEGORY_LM, DECOMP_TAG_SUPER,
   {0x0048, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D35, CHAR_CATEGORY_LM, DECOMP_TAG_SUPER,
   {0x0049, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D36, CHAR_CATEGORY_LM, DECOMP_TAG_SUPER,
   {0x004A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D37, CHAR_CATEGORY_LM, DECOMP_TAG_SUPER,
   {0x004B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D38, CHAR_CATEGORY_LM, DECOMP_TAG_SUPER,
   {0x004C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D39, CHAR_CATEGORY_LM, DECOMP_TAG_SUPER,
   {0x004D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D3A, CHAR_CATEGORY_LM, DECOMP_TAG_SUPER,
   {0x004E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D3C, CHAR_CATEGORY_LM, DECOMP_TAG_SUPER,
   {0x004F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D3D, CHAR_CATEGORY_LM, DECOMP_TAG_SUPER,
   {0x0222, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D3E, CHAR_CATEGORY_LM, DECOMP_TAG_SUPER,
   {0x0050, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D3F, CHAR_CATEGORY_LM, DECOMP_TAG_SUPER,
   {0x0052, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D40, CHAR_CATEGORY_LM, DECOMP_TAG_SUPER,
   {0x0054, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D41, CHAR_CATEGORY_LM, DECOMP_TAG_SUPER,
   {0x0055, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D42, CHAR_CATEGORY_LM, DECOMP_TAG_SUPER,
   {0x0057, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D43, CHAR_CATEGORY_LM, DECOMP_TAG_SUPER,
   {0x0061, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D44, CHAR_CATEGORY_LM, DECOMP_TAG_SUPER,
   {0x0250, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D45, CHAR_CATEGORY_LM, DECOMP_TAG_SUPER,
   {0x0251, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D46, CHAR_CATEGORY_LM, DECOMP_TAG_SUPER,
   {0x1D02, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D47, CHAR_CATEGORY_LM, DECOMP_TAG_SUPER,
   {0x0062, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D48, CHAR_CATEGORY_LM, DECOMP_TAG_SUPER,
   {0x0064, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D49, CHAR_CATEGORY_LM, DECOMP_TAG_SUPER,
   {0x0065, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D4A, CHAR_CATEGORY_LM, DECOMP_TAG_SUPER,
   {0x0259, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D4B, CHAR_CATEGORY_LM, DECOMP_TAG_SUPER,
   {0x025B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D4C, CHAR_CATEGORY_LM, DECOMP_TAG_SUPER,
   {0x025C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D4D, CHAR_CATEGORY_LM, DECOMP_TAG_SUPER,
   {0x0067, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D4F, CHAR_CATEGORY_LM, DECOMP_TAG_SUPER,
   {0x006B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D50, CHAR_CATEGORY_LM, DECOMP_TAG_SUPER,
   {0x006D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D51, CHAR_CATEGORY_LM, DECOMP_TAG_SUPER,
   {0x014B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D52, CHAR_CATEGORY_LM, DECOMP_TAG_SUPER,
   {0x006F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D53, CHAR_CATEGORY_LM, DECOMP_TAG_SUPER,
   {0x0254, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D54, CHAR_CATEGORY_LM, DECOMP_TAG_SUPER,
   {0x1D16, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D55, CHAR_CATEGORY_LM, DECOMP_TAG_SUPER,
   {0x1D17, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D56, CHAR_CATEGORY_LM, DECOMP_TAG_SUPER,
   {0x0070, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D57, CHAR_CATEGORY_LM, DECOMP_TAG_SUPER,
   {0x0074, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D58, CHAR_CATEGORY_LM, DECOMP_TAG_SUPER,
   {0x0075, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D59, CHAR_CATEGORY_LM, DECOMP_TAG_SUPER,
   {0x1D1D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D5A, CHAR_CATEGORY_LM, DECOMP_TAG_SUPER,
   {0x026F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D5B, CHAR_CATEGORY_LM, DECOMP_TAG_SUPER,
   {0x0076, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D5C, CHAR_CATEGORY_LM, DECOMP_TAG_SUPER,
   {0x1D25, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D5D, CHAR_CATEGORY_LM, DECOMP_TAG_SUPER,
   {0x03B2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D5E, CHAR_CATEGORY_LM, DECOMP_TAG_SUPER,
   {0x03B3, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D5F, CHAR_CATEGORY_LM, DECOMP_TAG_SUPER,
   {0x03B4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D60, CHAR_CATEGORY_LM, DECOMP_TAG_SUPER,
   {0x03C6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D61, CHAR_CATEGORY_LM, DECOMP_TAG_SUPER,
   {0x03C7, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D62, CHAR_CATEGORY_LM, DECOMP_TAG_SUB,
   {0x0069, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D63, CHAR_CATEGORY_LM, DECOMP_TAG_SUB,
   {0x0072, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D64, CHAR_CATEGORY_LM, DECOMP_TAG_SUB,
   {0x0075, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D65, CHAR_CATEGORY_LM, DECOMP_TAG_SUB,
   {0x0076, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D66, CHAR_CATEGORY_LM, DECOMP_TAG_SUB,
   {0x03B2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D67, CHAR_CATEGORY_LM, DECOMP_TAG_SUB,
   {0x03B3, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D68, CHAR_CATEGORY_LM, DECOMP_TAG_SUB,
   {0x03C1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D69, CHAR_CATEGORY_LM, DECOMP_TAG_SUB,
   {0x03C6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D6A, CHAR_CATEGORY_LM, DECOMP_TAG_SUB,
   {0x03C7, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D78, CHAR_CATEGORY_LM, DECOMP_TAG_SUPER,
   {0x043D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D9B, CHAR_CATEGORY_LM, DECOMP_TAG_SUPER,
   {0x0252, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D9C, CHAR_CATEGORY_LM, DECOMP_TAG_SUPER,
   {0x0063, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D9D, CHAR_CATEGORY_LM, DECOMP_TAG_SUPER,
   {0x0255, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D9E, CHAR_CATEGORY_LM, DECOMP_TAG_SUPER,
   {0x00F0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D9F, CHAR_CATEGORY_LM, DECOMP_TAG_SUPER,
   {0x025C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1DA0, CHAR_CATEGORY_LM, DECOMP_TAG_SUPER,
   {0x0066, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1DA1, CHAR_CATEGORY_LM, DECOMP_TAG_SUPER,
   {0x025F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1DA2, CHAR_CATEGORY_LM, DECOMP_TAG_SUPER,
   {0x0261, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1DA3, CHAR_CATEGORY_LM, DECOMP_TAG_SUPER,
   {0x0265, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1DA4, CHAR_CATEGORY_LM, DECOMP_TAG_SUPER,
   {0x0268, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1DA5, CHAR_CATEGORY_LM, DECOMP_TAG_SUPER,
   {0x0269, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1DA6, CHAR_CATEGORY_LM, DECOMP_TAG_SUPER,
   {0x026A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1DA7, CHAR_CATEGORY_LM, DECOMP_TAG_SUPER,
   {0x1D7B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1DA8, CHAR_CATEGORY_LM, DECOMP_TAG_SUPER,
   {0x029D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1DA9, CHAR_CATEGORY_LM, DECOMP_TAG_SUPER,
   {0x026D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1DAA, CHAR_CATEGORY_LM, DECOMP_TAG_SUPER,
   {0x1D85, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1DAB, CHAR_CATEGORY_LM, DECOMP_TAG_SUPER,
   {0x029F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1DAC, CHAR_CATEGORY_LM, DECOMP_TAG_SUPER,
   {0x0271, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1DAD, CHAR_CATEGORY_LM, DECOMP_TAG_SUPER,
   {0x0270, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1DAE, CHAR_CATEGORY_LM, DECOMP_TAG_SUPER,
   {0x0272, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1DAF, CHAR_CATEGORY_LM, DECOMP_TAG_SUPER,
   {0x0273, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1DB0, CHAR_CATEGORY_LM, DECOMP_TAG_SUPER,
   {0x0274, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1DB1, CHAR_CATEGORY_LM, DECOMP_TAG_SUPER,
   {0x0275, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1DB2, CHAR_CATEGORY_LM, DECOMP_TAG_SUPER,
   {0x0278, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1DB3, CHAR_CATEGORY_LM, DECOMP_TAG_SUPER,
   {0x0282, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1DB4, CHAR_CATEGORY_LM, DECOMP_TAG_SUPER,
   {0x0283, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1DB5, CHAR_CATEGORY_LM, DECOMP_TAG_SUPER,
   {0x01AB, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1DB6, CHAR_CATEGORY_LM, DECOMP_TAG_SUPER,
   {0x0289, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1DB7, CHAR_CATEGORY_LM, DECOMP_TAG_SUPER,
   {0x028A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1DB8, CHAR_CATEGORY_LM, DECOMP_TAG_SUPER,
   {0x1D1C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1DB9, CHAR_CATEGORY_LM, DECOMP_TAG_SUPER,
   {0x028B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1DBA, CHAR_CATEGORY_LM, DECOMP_TAG_SUPER,
   {0x028C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1DBB, CHAR_CATEGORY_LM, DECOMP_TAG_SUPER,
   {0x007A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1DBC, CHAR_CATEGORY_LM, DECOMP_TAG_SUPER,
   {0x0290, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1DBD, CHAR_CATEGORY_LM, DECOMP_TAG_SUPER,
   {0x0291, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1DBE, CHAR_CATEGORY_LM, DECOMP_TAG_SUPER,
   {0x0292, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1DBF, CHAR_CATEGORY_LM, DECOMP_TAG_SUPER,
   {0x03B8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1E00, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0041, 0x0325, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1E01, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0061, 0x0325, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1E02, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0042, 0x0307, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1E03, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0062, 0x0307, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1E04, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0042, 0x0323, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1E05, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0062, 0x0323, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1E06, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0042, 0x0331, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1E07, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0062, 0x0331, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1E08, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0043, 0x0327, 0x0301, 0x0000, 0x0000, 0x0000}},
  {0x1E09, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0063, 0x0327, 0x0301, 0x0000, 0x0000, 0x0000}},
  {0x1E0A, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0044, 0x0307, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1E0B, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0064, 0x0307, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1E0C, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0044, 0x0323, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1E0D, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0064, 0x0323, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1E0E, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0044, 0x0331, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1E0F, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0064, 0x0331, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1E10, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0044, 0x0327, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1E11, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0064, 0x0327, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1E12, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0044, 0x032D, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1E13, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0064, 0x032D, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1E14, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0045, 0x0304, 0x0300, 0x0000, 0x0000, 0x0000}},
  {0x1E15, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0065, 0x0304, 0x0300, 0x0000, 0x0000, 0x0000}},
  {0x1E16, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0045, 0x0304, 0x0301, 0x0000, 0x0000, 0x0000}},
  {0x1E17, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0065, 0x0304, 0x0301, 0x0000, 0x0000, 0x0000}},
  {0x1E18, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0045, 0x032D, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1E19, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0065, 0x032D, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1E1A, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0045, 0x0330, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1E1B, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0065, 0x0330, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1E1C, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0045, 0x0327, 0x0306, 0x0000, 0x0000, 0x0000}},
  {0x1E1D, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0065, 0x0327, 0x0306, 0x0000, 0x0000, 0x0000}},
  {0x1E1E, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0046, 0x0307, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1E1F, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0066, 0x0307, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1E20, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0047, 0x0304, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1E21, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0067, 0x0304, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1E22, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0048, 0x0307, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1E23, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0068, 0x0307, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1E24, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0048, 0x0323, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1E25, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0068, 0x0323, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1E26, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0048, 0x0308, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1E27, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0068, 0x0308, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1E28, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0048, 0x0327, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1E29, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0068, 0x0327, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1E2A, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0048, 0x032E, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1E2B, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0068, 0x032E, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1E2C, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0049, 0x0330, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1E2D, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0069, 0x0330, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1E2E, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0049, 0x0308, 0x0301, 0x0000, 0x0000, 0x0000}},
  {0x1E2F, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0069, 0x0308, 0x0301, 0x0000, 0x0000, 0x0000}},
  {0x1E30, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x004B, 0x0301, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1E31, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x006B, 0x0301, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1E32, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x004B, 0x0323, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1E33, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x006B, 0x0323, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1E34, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x004B, 0x0331, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1E35, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x006B, 0x0331, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1E36, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x004C, 0x0323, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1E37, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x006C, 0x0323, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1E38, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x004C, 0x0323, 0x0304, 0x0000, 0x0000, 0x0000}},
  {0x1E39, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x006C, 0x0323, 0x0304, 0x0000, 0x0000, 0x0000}},
  {0x1E3A, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x004C, 0x0331, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1E3B, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x006C, 0x0331, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1E3C, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x004C, 0x032D, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1E3D, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x006C, 0x032D, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1E3E, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x004D, 0x0301, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1E3F, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x006D, 0x0301, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1E40, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x004D, 0x0307, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1E41, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x006D, 0x0307, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1E42, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x004D, 0x0323, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1E43, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x006D, 0x0323, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1E44, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x004E, 0x0307, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1E45, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x006E, 0x0307, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1E46, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x004E, 0x0323, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1E47, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x006E, 0x0323, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1E48, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x004E, 0x0331, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1E49, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x006E, 0x0331, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1E4A, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x004E, 0x032D, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1E4B, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x006E, 0x032D, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1E4C, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x004F, 0x0303, 0x0301, 0x0000, 0x0000, 0x0000}},
  {0x1E4D, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x006F, 0x0303, 0x0301, 0x0000, 0x0000, 0x0000}},
  {0x1E4E, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x004F, 0x0303, 0x0308, 0x0000, 0x0000, 0x0000}},
  {0x1E4F, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x006F, 0x0303, 0x0308, 0x0000, 0x0000, 0x0000}},
  {0x1E50, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x004F, 0x0304, 0x0300, 0x0000, 0x0000, 0x0000}},
  {0x1E51, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x006F, 0x0304, 0x0300, 0x0000, 0x0000, 0x0000}},
  {0x1E52, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x004F, 0x0304, 0x0301, 0x0000, 0x0000, 0x0000}},
  {0x1E53, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x006F, 0x0304, 0x0301, 0x0000, 0x0000, 0x0000}},
  {0x1E54, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0050, 0x0301, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1E55, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0070, 0x0301, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1E56, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0050, 0x0307, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1E57, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0070, 0x0307, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1E58, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0052, 0x0307, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1E59, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0072, 0x0307, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1E5A, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0052, 0x0323, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1E5B, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0072, 0x0323, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1E5C, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0052, 0x0323, 0x0304, 0x0000, 0x0000, 0x0000}},
  {0x1E5D, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0072, 0x0323, 0x0304, 0x0000, 0x0000, 0x0000}},
  {0x1E5E, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0052, 0x0331, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1E5F, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0072, 0x0331, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1E60, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0053, 0x0307, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1E61, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0073, 0x0307, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1E62, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0053, 0x0323, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1E63, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0073, 0x0323, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1E64, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0053, 0x0301, 0x0307, 0x0000, 0x0000, 0x0000}},
  {0x1E65, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0073, 0x0301, 0x0307, 0x0000, 0x0000, 0x0000}},
  {0x1E66, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0053, 0x030C, 0x0307, 0x0000, 0x0000, 0x0000}},
  {0x1E67, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0073, 0x030C, 0x0307, 0x0000, 0x0000, 0x0000}},
  {0x1E68, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0053, 0x0323, 0x0307, 0x0000, 0x0000, 0x0000}},
  {0x1E69, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0073, 0x0323, 0x0307, 0x0000, 0x0000, 0x0000}},
  {0x1E6A, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0054, 0x0307, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1E6B, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0074, 0x0307, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1E6C, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0054, 0x0323, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1E6D, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0074, 0x0323, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1E6E, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0054, 0x0331, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1E6F, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0074, 0x0331, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1E70, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0054, 0x032D, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1E71, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0074, 0x032D, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1E72, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0055, 0x0324, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1E73, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0075, 0x0324, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1E74, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0055, 0x0330, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1E75, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0075, 0x0330, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1E76, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0055, 0x032D, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1E77, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0075, 0x032D, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1E78, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0055, 0x0303, 0x0301, 0x0000, 0x0000, 0x0000}},
  {0x1E79, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0075, 0x0303, 0x0301, 0x0000, 0x0000, 0x0000}},
  {0x1E7A, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0055, 0x0304, 0x0308, 0x0000, 0x0000, 0x0000}},
  {0x1E7B, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0075, 0x0304, 0x0308, 0x0000, 0x0000, 0x0000}},
  {0x1E7C, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0056, 0x0303, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1E7D, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0076, 0x0303, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1E7E, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0056, 0x0323, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1E7F, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0076, 0x0323, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1E80, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0057, 0x0300, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1E81, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0077, 0x0300, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1E82, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0057, 0x0301, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1E83, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0077, 0x0301, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1E84, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0057, 0x0308, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1E85, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0077, 0x0308, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1E86, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0057, 0x0307, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1E87, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0077, 0x0307, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1E88, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0057, 0x0323, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1E89, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0077, 0x0323, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1E8A, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0058, 0x0307, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1E8B, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0078, 0x0307, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1E8C, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0058, 0x0308, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1E8D, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0078, 0x0308, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1E8E, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0059, 0x0307, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1E8F, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0079, 0x0307, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1E90, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x005A, 0x0302, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1E91, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x007A, 0x0302, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1E92, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x005A, 0x0323, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1E93, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x007A, 0x0323, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1E94, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x005A, 0x0331, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1E95, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x007A, 0x0331, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1E96, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0068, 0x0331, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1E97, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0074, 0x0308, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1E98, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0077, 0x030A, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1E99, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0079, 0x030A, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1E9A, CHAR_CATEGORY_LL, DECOMP_TAG_COMPAT,
   {0x0061, 0x02BE, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1E9B, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x017F, 0x0307, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EA0, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0041, 0x0323, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EA1, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0061, 0x0323, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EA2, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0041, 0x0309, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EA3, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0061, 0x0309, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EA4, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0041, 0x0302, 0x0301, 0x0000, 0x0000, 0x0000}},
  {0x1EA5, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0061, 0x0302, 0x0301, 0x0000, 0x0000, 0x0000}},
  {0x1EA6, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0041, 0x0302, 0x0300, 0x0000, 0x0000, 0x0000}},
  {0x1EA7, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0061, 0x0302, 0x0300, 0x0000, 0x0000, 0x0000}},
  {0x1EA8, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0041, 0x0302, 0x0309, 0x0000, 0x0000, 0x0000}},
  {0x1EA9, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0061, 0x0302, 0x0309, 0x0000, 0x0000, 0x0000}},
  {0x1EAA, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0041, 0x0302, 0x0303, 0x0000, 0x0000, 0x0000}},
  {0x1EAB, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0061, 0x0302, 0x0303, 0x0000, 0x0000, 0x0000}},
  {0x1EAC, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0041, 0x0323, 0x0302, 0x0000, 0x0000, 0x0000}},
  {0x1EAD, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0061, 0x0323, 0x0302, 0x0000, 0x0000, 0x0000}},
  {0x1EAE, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0041, 0x0306, 0x0301, 0x0000, 0x0000, 0x0000}},
  {0x1EAF, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0061, 0x0306, 0x0301, 0x0000, 0x0000, 0x0000}},
  {0x1EB0, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0041, 0x0306, 0x0300, 0x0000, 0x0000, 0x0000}},
  {0x1EB1, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0061, 0x0306, 0x0300, 0x0000, 0x0000, 0x0000}},
  {0x1EB2, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0041, 0x0306, 0x0309, 0x0000, 0x0000, 0x0000}},
  {0x1EB3, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0061, 0x0306, 0x0309, 0x0000, 0x0000, 0x0000}},
  {0x1EB4, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0041, 0x0306, 0x0303, 0x0000, 0x0000, 0x0000}},
  {0x1EB5, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0061, 0x0306, 0x0303, 0x0000, 0x0000, 0x0000}},
  {0x1EB6, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0041, 0x0323, 0x0306, 0x0000, 0x0000, 0x0000}},
  {0x1EB7, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0061, 0x0323, 0x0306, 0x0000, 0x0000, 0x0000}},
  {0x1EB8, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0045, 0x0323, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EB9, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0065, 0x0323, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EBA, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0045, 0x0309, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EBB, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0065, 0x0309, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EBC, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0045, 0x0303, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EBD, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0065, 0x0303, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EBE, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0045, 0x0302, 0x0301, 0x0000, 0x0000, 0x0000}},
  {0x1EBF, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0065, 0x0302, 0x0301, 0x0000, 0x0000, 0x0000}},
  {0x1EC0, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0045, 0x0302, 0x0300, 0x0000, 0x0000, 0x0000}},
  {0x1EC1, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0065, 0x0302, 0x0300, 0x0000, 0x0000, 0x0000}},
  {0x1EC2, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0045, 0x0302, 0x0309, 0x0000, 0x0000, 0x0000}},
  {0x1EC3, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0065, 0x0302, 0x0309, 0x0000, 0x0000, 0x0000}},
  {0x1EC4, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0045, 0x0302, 0x0303, 0x0000, 0x0000, 0x0000}},
  {0x1EC5, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0065, 0x0302, 0x0303, 0x0000, 0x0000, 0x0000}},
  {0x1EC6, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0045, 0x0323, 0x0302, 0x0000, 0x0000, 0x0000}},
  {0x1EC7, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0065, 0x0323, 0x0302, 0x0000, 0x0000, 0x0000}},
  {0x1EC8, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0049, 0x0309, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EC9, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0069, 0x0309, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1ECA, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0049, 0x0323, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1ECB, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0069, 0x0323, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1ECC, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x004F, 0x0323, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1ECD, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x006F, 0x0323, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1ECE, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x004F, 0x0309, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1ECF, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x006F, 0x0309, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1ED0, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x004F, 0x0302, 0x0301, 0x0000, 0x0000, 0x0000}},
  {0x1ED1, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x006F, 0x0302, 0x0301, 0x0000, 0x0000, 0x0000}},
  {0x1ED2, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x004F, 0x0302, 0x0300, 0x0000, 0x0000, 0x0000}},
  {0x1ED3, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x006F, 0x0302, 0x0300, 0x0000, 0x0000, 0x0000}},
  {0x1ED4, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x004F, 0x0302, 0x0309, 0x0000, 0x0000, 0x0000}},
  {0x1ED5, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x006F, 0x0302, 0x0309, 0x0000, 0x0000, 0x0000}},
  {0x1ED6, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x004F, 0x0302, 0x0303, 0x0000, 0x0000, 0x0000}},
  {0x1ED7, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x006F, 0x0302, 0x0303, 0x0000, 0x0000, 0x0000}},
  {0x1ED8, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x004F, 0x0323, 0x0302, 0x0000, 0x0000, 0x0000}},
  {0x1ED9, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x006F, 0x0323, 0x0302, 0x0000, 0x0000, 0x0000}},
  {0x1EDA, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x004F, 0x031B, 0x0301, 0x0000, 0x0000, 0x0000}},
  {0x1EDB, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x006F, 0x031B, 0x0301, 0x0000, 0x0000, 0x0000}},
  {0x1EDC, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x004F, 0x031B, 0x0300, 0x0000, 0x0000, 0x0000}},
  {0x1EDD, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x006F, 0x031B, 0x0300, 0x0000, 0x0000, 0x0000}},
  {0x1EDE, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x004F, 0x031B, 0x0309, 0x0000, 0x0000, 0x0000}},
  {0x1EDF, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x006F, 0x031B, 0x0309, 0x0000, 0x0000, 0x0000}},
  {0x1EE0, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x004F, 0x031B, 0x0303, 0x0000, 0x0000, 0x0000}},
  {0x1EE1, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x006F, 0x031B, 0x0303, 0x0000, 0x0000, 0x0000}},
  {0x1EE2, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x004F, 0x031B, 0x0323, 0x0000, 0x0000, 0x0000}},
  {0x1EE3, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x006F, 0x031B, 0x0323, 0x0000, 0x0000, 0x0000}},
  {0x1EE4, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0055, 0x0323, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EE5, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0075, 0x0323, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EE6, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0055, 0x0309, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EE7, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0075, 0x0309, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EE8, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0055, 0x031B, 0x0301, 0x0000, 0x0000, 0x0000}},
  {0x1EE9, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0075, 0x031B, 0x0301, 0x0000, 0x0000, 0x0000}},
  {0x1EEA, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0055, 0x031B, 0x0300, 0x0000, 0x0000, 0x0000}},
  {0x1EEB, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0075, 0x031B, 0x0300, 0x0000, 0x0000, 0x0000}},
  {0x1EEC, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0055, 0x031B, 0x0309, 0x0000, 0x0000, 0x0000}},
  {0x1EED, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0075, 0x031B, 0x0309, 0x0000, 0x0000, 0x0000}},
  {0x1EEE, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0055, 0x031B, 0x0303, 0x0000, 0x0000, 0x0000}},
  {0x1EEF, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0075, 0x031B, 0x0303, 0x0000, 0x0000, 0x0000}},
  {0x1EF0, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0055, 0x031B, 0x0323, 0x0000, 0x0000, 0x0000}},
  {0x1EF1, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0075, 0x031B, 0x0323, 0x0000, 0x0000, 0x0000}},
  {0x1EF2, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0059, 0x0300, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EF3, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0079, 0x0300, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EF4, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0059, 0x0323, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EF5, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0079, 0x0323, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EF6, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0059, 0x0309, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EF7, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0079, 0x0309, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EF8, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0059, 0x0303, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EF9, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x0079, 0x0303, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F00, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x03B1, 0x0313, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F01, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x03B1, 0x0314, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F02, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x03B1, 0x0313, 0x0300, 0x0000, 0x0000, 0x0000}},
  {0x1F03, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x03B1, 0x0314, 0x0300, 0x0000, 0x0000, 0x0000}},
  {0x1F04, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x03B1, 0x0313, 0x0301, 0x0000, 0x0000, 0x0000}},
  {0x1F05, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x03B1, 0x0314, 0x0301, 0x0000, 0x0000, 0x0000}},
  {0x1F06, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x03B1, 0x0313, 0x0342, 0x0000, 0x0000, 0x0000}},
  {0x1F07, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x03B1, 0x0314, 0x0342, 0x0000, 0x0000, 0x0000}},
  {0x1F08, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0391, 0x0313, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F09, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0391, 0x0314, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F0A, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0391, 0x0313, 0x0300, 0x0000, 0x0000, 0x0000}},
  {0x1F0B, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0391, 0x0314, 0x0300, 0x0000, 0x0000, 0x0000}},
  {0x1F0C, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0391, 0x0313, 0x0301, 0x0000, 0x0000, 0x0000}},
  {0x1F0D, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0391, 0x0314, 0x0301, 0x0000, 0x0000, 0x0000}},
  {0x1F0E, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0391, 0x0313, 0x0342, 0x0000, 0x0000, 0x0000}},
  {0x1F0F, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0391, 0x0314, 0x0342, 0x0000, 0x0000, 0x0000}},
  {0x1F10, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x03B5, 0x0313, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F11, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x03B5, 0x0314, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F12, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x03B5, 0x0313, 0x0300, 0x0000, 0x0000, 0x0000}},
  {0x1F13, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x03B5, 0x0314, 0x0300, 0x0000, 0x0000, 0x0000}},
  {0x1F14, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x03B5, 0x0313, 0x0301, 0x0000, 0x0000, 0x0000}},
  {0x1F15, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x03B5, 0x0314, 0x0301, 0x0000, 0x0000, 0x0000}},
  {0x1F18, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0395, 0x0313, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F19, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0395, 0x0314, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F1A, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0395, 0x0313, 0x0300, 0x0000, 0x0000, 0x0000}},
  {0x1F1B, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0395, 0x0314, 0x0300, 0x0000, 0x0000, 0x0000}},
  {0x1F1C, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0395, 0x0313, 0x0301, 0x0000, 0x0000, 0x0000}},
  {0x1F1D, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0395, 0x0314, 0x0301, 0x0000, 0x0000, 0x0000}},
  {0x1F20, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x03B7, 0x0313, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F21, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x03B7, 0x0314, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F22, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x03B7, 0x0313, 0x0300, 0x0000, 0x0000, 0x0000}},
  {0x1F23, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x03B7, 0x0314, 0x0300, 0x0000, 0x0000, 0x0000}},
  {0x1F24, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x03B7, 0x0313, 0x0301, 0x0000, 0x0000, 0x0000}},
  {0x1F25, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x03B7, 0x0314, 0x0301, 0x0000, 0x0000, 0x0000}},
  {0x1F26, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x03B7, 0x0313, 0x0342, 0x0000, 0x0000, 0x0000}},
  {0x1F27, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x03B7, 0x0314, 0x0342, 0x0000, 0x0000, 0x0000}},
  {0x1F28, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0397, 0x0313, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F29, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0397, 0x0314, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F2A, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0397, 0x0313, 0x0300, 0x0000, 0x0000, 0x0000}},
  {0x1F2B, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0397, 0x0314, 0x0300, 0x0000, 0x0000, 0x0000}},
  {0x1F2C, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0397, 0x0313, 0x0301, 0x0000, 0x0000, 0x0000}},
  {0x1F2D, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0397, 0x0314, 0x0301, 0x0000, 0x0000, 0x0000}},
  {0x1F2E, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0397, 0x0313, 0x0342, 0x0000, 0x0000, 0x0000}},
  {0x1F2F, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0397, 0x0314, 0x0342, 0x0000, 0x0000, 0x0000}},
  {0x1F30, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x03B9, 0x0313, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F31, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x03B9, 0x0314, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F32, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x03B9, 0x0313, 0x0300, 0x0000, 0x0000, 0x0000}},
  {0x1F33, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x03B9, 0x0314, 0x0300, 0x0000, 0x0000, 0x0000}},
  {0x1F34, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x03B9, 0x0313, 0x0301, 0x0000, 0x0000, 0x0000}},
  {0x1F35, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x03B9, 0x0314, 0x0301, 0x0000, 0x0000, 0x0000}},
  {0x1F36, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x03B9, 0x0313, 0x0342, 0x0000, 0x0000, 0x0000}},
  {0x1F37, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x03B9, 0x0314, 0x0342, 0x0000, 0x0000, 0x0000}},
  {0x1F38, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0399, 0x0313, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F39, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0399, 0x0314, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F3A, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0399, 0x0313, 0x0300, 0x0000, 0x0000, 0x0000}},
  {0x1F3B, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0399, 0x0314, 0x0300, 0x0000, 0x0000, 0x0000}},
  {0x1F3C, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0399, 0x0313, 0x0301, 0x0000, 0x0000, 0x0000}},
  {0x1F3D, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0399, 0x0314, 0x0301, 0x0000, 0x0000, 0x0000}},
  {0x1F3E, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0399, 0x0313, 0x0342, 0x0000, 0x0000, 0x0000}},
  {0x1F3F, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0399, 0x0314, 0x0342, 0x0000, 0x0000, 0x0000}},
  {0x1F40, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x03BF, 0x0313, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F41, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x03BF, 0x0314, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F42, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x03BF, 0x0313, 0x0300, 0x0000, 0x0000, 0x0000}},
  {0x1F43, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x03BF, 0x0314, 0x0300, 0x0000, 0x0000, 0x0000}},
  {0x1F44, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x03BF, 0x0313, 0x0301, 0x0000, 0x0000, 0x0000}},
  {0x1F45, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x03BF, 0x0314, 0x0301, 0x0000, 0x0000, 0x0000}},
  {0x1F48, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x039F, 0x0313, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F49, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x039F, 0x0314, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F4A, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x039F, 0x0313, 0x0300, 0x0000, 0x0000, 0x0000}},
  {0x1F4B, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x039F, 0x0314, 0x0300, 0x0000, 0x0000, 0x0000}},
  {0x1F4C, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x039F, 0x0313, 0x0301, 0x0000, 0x0000, 0x0000}},
  {0x1F4D, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x039F, 0x0314, 0x0301, 0x0000, 0x0000, 0x0000}},
  {0x1F50, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x03C5, 0x0313, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F51, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x03C5, 0x0314, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F52, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x03C5, 0x0313, 0x0300, 0x0000, 0x0000, 0x0000}},
  {0x1F53, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x03C5, 0x0314, 0x0300, 0x0000, 0x0000, 0x0000}},
  {0x1F54, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x03C5, 0x0313, 0x0301, 0x0000, 0x0000, 0x0000}},
  {0x1F55, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x03C5, 0x0314, 0x0301, 0x0000, 0x0000, 0x0000}},
  {0x1F56, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x03C5, 0x0313, 0x0342, 0x0000, 0x0000, 0x0000}},
  {0x1F57, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x03C5, 0x0314, 0x0342, 0x0000, 0x0000, 0x0000}},
  {0x1F59, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x03A5, 0x0314, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F5B, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x03A5, 0x0314, 0x0300, 0x0000, 0x0000, 0x0000}},
  {0x1F5D, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x03A5, 0x0314, 0x0301, 0x0000, 0x0000, 0x0000}},
  {0x1F5F, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x03A5, 0x0314, 0x0342, 0x0000, 0x0000, 0x0000}},
  {0x1F60, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x03C9, 0x0313, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F61, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x03C9, 0x0314, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F62, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x03C9, 0x0313, 0x0300, 0x0000, 0x0000, 0x0000}},
  {0x1F63, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x03C9, 0x0314, 0x0300, 0x0000, 0x0000, 0x0000}},
  {0x1F64, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x03C9, 0x0313, 0x0301, 0x0000, 0x0000, 0x0000}},
  {0x1F65, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x03C9, 0x0314, 0x0301, 0x0000, 0x0000, 0x0000}},
  {0x1F66, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x03C9, 0x0313, 0x0342, 0x0000, 0x0000, 0x0000}},
  {0x1F67, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x03C9, 0x0314, 0x0342, 0x0000, 0x0000, 0x0000}},
  {0x1F68, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x03A9, 0x0313, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F69, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x03A9, 0x0314, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F6A, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x03A9, 0x0313, 0x0300, 0x0000, 0x0000, 0x0000}},
  {0x1F6B, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x03A9, 0x0314, 0x0300, 0x0000, 0x0000, 0x0000}},
  {0x1F6C, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x03A9, 0x0313, 0x0301, 0x0000, 0x0000, 0x0000}},
  {0x1F6D, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x03A9, 0x0314, 0x0301, 0x0000, 0x0000, 0x0000}},
  {0x1F6E, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x03A9, 0x0313, 0x0342, 0x0000, 0x0000, 0x0000}},
  {0x1F6F, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x03A9, 0x0314, 0x0342, 0x0000, 0x0000, 0x0000}},
  {0x1F70, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x03B1, 0x0300, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F71, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x03B1, 0x0301, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F72, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x03B5, 0x0300, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F73, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x03B5, 0x0301, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F74, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x03B7, 0x0300, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F75, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x03B7, 0x0301, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F76, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x03B9, 0x0300, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F77, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x03B9, 0x0301, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F78, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x03BF, 0x0300, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F79, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x03BF, 0x0301, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F7A, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x03C5, 0x0300, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F7B, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x03C5, 0x0301, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F7C, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x03C9, 0x0300, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F7D, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x03C9, 0x0301, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F80, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x03B1, 0x0313, 0x0345, 0x0000, 0x0000, 0x0000}},
  {0x1F81, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x03B1, 0x0314, 0x0345, 0x0000, 0x0000, 0x0000}},
  {0x1F82, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x03B1, 0x0313, 0x0300, 0x0345, 0x0000, 0x0000}},
  {0x1F83, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x03B1, 0x0314, 0x0300, 0x0345, 0x0000, 0x0000}},
  {0x1F84, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x03B1, 0x0313, 0x0301, 0x0345, 0x0000, 0x0000}},
  {0x1F85, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x03B1, 0x0314, 0x0301, 0x0345, 0x0000, 0x0000}},
  {0x1F86, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x03B1, 0x0313, 0x0342, 0x0345, 0x0000, 0x0000}},
  {0x1F87, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x03B1, 0x0314, 0x0342, 0x0345, 0x0000, 0x0000}},
  {0x1F88, CHAR_CATEGORY_LT, DECOMP_TAG_NONE,
   {0x0391, 0x0313, 0x0345, 0x0000, 0x0000, 0x0000}},
  {0x1F89, CHAR_CATEGORY_LT, DECOMP_TAG_NONE,
   {0x0391, 0x0314, 0x0345, 0x0000, 0x0000, 0x0000}},
  {0x1F8A, CHAR_CATEGORY_LT, DECOMP_TAG_NONE,
   {0x0391, 0x0313, 0x0300, 0x0345, 0x0000, 0x0000}},
  {0x1F8B, CHAR_CATEGORY_LT, DECOMP_TAG_NONE,
   {0x0391, 0x0314, 0x0300, 0x0345, 0x0000, 0x0000}},
  {0x1F8C, CHAR_CATEGORY_LT, DECOMP_TAG_NONE,
   {0x0391, 0x0313, 0x0301, 0x0345, 0x0000, 0x0000}},
  {0x1F8D, CHAR_CATEGORY_LT, DECOMP_TAG_NONE,
   {0x0391, 0x0314, 0x0301, 0x0345, 0x0000, 0x0000}},
  {0x1F8E, CHAR_CATEGORY_LT, DECOMP_TAG_NONE,
   {0x0391, 0x0313, 0x0342, 0x0345, 0x0000, 0x0000}},
  {0x1F8F, CHAR_CATEGORY_LT, DECOMP_TAG_NONE,
   {0x0391, 0x0314, 0x0342, 0x0345, 0x0000, 0x0000}},
  {0x1F90, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x03B7, 0x0313, 0x0345, 0x0000, 0x0000, 0x0000}},
  {0x1F91, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x03B7, 0x0314, 0x0345, 0x0000, 0x0000, 0x0000}},
  {0x1F92, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x03B7, 0x0313, 0x0300, 0x0345, 0x0000, 0x0000}},
  {0x1F93, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x03B7, 0x0314, 0x0300, 0x0345, 0x0000, 0x0000}},
  {0x1F94, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x03B7, 0x0313, 0x0301, 0x0345, 0x0000, 0x0000}},
  {0x1F95, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x03B7, 0x0314, 0x0301, 0x0345, 0x0000, 0x0000}},
  {0x1F96, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x03B7, 0x0313, 0x0342, 0x0345, 0x0000, 0x0000}},
  {0x1F97, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x03B7, 0x0314, 0x0342, 0x0345, 0x0000, 0x0000}},
  {0x1F98, CHAR_CATEGORY_LT, DECOMP_TAG_NONE,
   {0x0397, 0x0313, 0x0345, 0x0000, 0x0000, 0x0000}},
  {0x1F99, CHAR_CATEGORY_LT, DECOMP_TAG_NONE,
   {0x0397, 0x0314, 0x0345, 0x0000, 0x0000, 0x0000}},
  {0x1F9A, CHAR_CATEGORY_LT, DECOMP_TAG_NONE,
   {0x0397, 0x0313, 0x0300, 0x0345, 0x0000, 0x0000}},
  {0x1F9B, CHAR_CATEGORY_LT, DECOMP_TAG_NONE,
   {0x0397, 0x0314, 0x0300, 0x0345, 0x0000, 0x0000}},
  {0x1F9C, CHAR_CATEGORY_LT, DECOMP_TAG_NONE,
   {0x0397, 0x0313, 0x0301, 0x0345, 0x0000, 0x0000}},
  {0x1F9D, CHAR_CATEGORY_LT, DECOMP_TAG_NONE,
   {0x0397, 0x0314, 0x0301, 0x0345, 0x0000, 0x0000}},
  {0x1F9E, CHAR_CATEGORY_LT, DECOMP_TAG_NONE,
   {0x0397, 0x0313, 0x0342, 0x0345, 0x0000, 0x0000}},
  {0x1F9F, CHAR_CATEGORY_LT, DECOMP_TAG_NONE,
   {0x0397, 0x0314, 0x0342, 0x0345, 0x0000, 0x0000}},
  {0x1FA0, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x03C9, 0x0313, 0x0345, 0x0000, 0x0000, 0x0000}},
  {0x1FA1, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x03C9, 0x0314, 0x0345, 0x0000, 0x0000, 0x0000}},
  {0x1FA2, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x03C9, 0x0313, 0x0300, 0x0345, 0x0000, 0x0000}},
  {0x1FA3, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x03C9, 0x0314, 0x0300, 0x0345, 0x0000, 0x0000}},
  {0x1FA4, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x03C9, 0x0313, 0x0301, 0x0345, 0x0000, 0x0000}},
  {0x1FA5, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x03C9, 0x0314, 0x0301, 0x0345, 0x0000, 0x0000}},
  {0x1FA6, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x03C9, 0x0313, 0x0342, 0x0345, 0x0000, 0x0000}},
  {0x1FA7, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x03C9, 0x0314, 0x0342, 0x0345, 0x0000, 0x0000}},
  {0x1FA8, CHAR_CATEGORY_LT, DECOMP_TAG_NONE,
   {0x03A9, 0x0313, 0x0345, 0x0000, 0x0000, 0x0000}},
  {0x1FA9, CHAR_CATEGORY_LT, DECOMP_TAG_NONE,
   {0x03A9, 0x0314, 0x0345, 0x0000, 0x0000, 0x0000}},
  {0x1FAA, CHAR_CATEGORY_LT, DECOMP_TAG_NONE,
   {0x03A9, 0x0313, 0x0300, 0x0345, 0x0000, 0x0000}},
  {0x1FAB, CHAR_CATEGORY_LT, DECOMP_TAG_NONE,
   {0x03A9, 0x0314, 0x0300, 0x0345, 0x0000, 0x0000}},
  {0x1FAC, CHAR_CATEGORY_LT, DECOMP_TAG_NONE,
   {0x03A9, 0x0313, 0x0301, 0x0345, 0x0000, 0x0000}},
  {0x1FAD, CHAR_CATEGORY_LT, DECOMP_TAG_NONE,
   {0x03A9, 0x0314, 0x0301, 0x0345, 0x0000, 0x0000}},
  {0x1FAE, CHAR_CATEGORY_LT, DECOMP_TAG_NONE,
   {0x03A9, 0x0313, 0x0342, 0x0345, 0x0000, 0x0000}},
  {0x1FAF, CHAR_CATEGORY_LT, DECOMP_TAG_NONE,
   {0x03A9, 0x0314, 0x0342, 0x0345, 0x0000, 0x0000}},
  {0x1FB0, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x03B1, 0x0306, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1FB1, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x03B1, 0x0304, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1FB2, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x03B1, 0x0300, 0x0345, 0x0000, 0x0000, 0x0000}},
  {0x1FB3, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x03B1, 0x0345, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1FB4, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x03B1, 0x0301, 0x0345, 0x0000, 0x0000, 0x0000}},
  {0x1FB6, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x03B1, 0x0342, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1FB7, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x03B1, 0x0342, 0x0345, 0x0000, 0x0000, 0x0000}},
  {0x1FB8, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0391, 0x0306, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1FB9, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0391, 0x0304, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1FBA, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0391, 0x0300, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1FBB, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0391, 0x0301, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1FBC, CHAR_CATEGORY_LT, DECOMP_TAG_NONE,
   {0x0391, 0x0345, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1FBD, CHAR_CATEGORY_SK, DECOMP_TAG_COMPAT,
   {0x0020, 0x0313, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1FBE, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x03B9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1FBF, CHAR_CATEGORY_SK, DECOMP_TAG_COMPAT,
   {0x0020, 0x0313, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1FC0, CHAR_CATEGORY_SK, DECOMP_TAG_COMPAT,
   {0x0020, 0x0342, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1FC1, CHAR_CATEGORY_SK, DECOMP_TAG_NONE,
   {0x00A8, 0x0342, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1FC2, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x03B7, 0x0300, 0x0345, 0x0000, 0x0000, 0x0000}},
  {0x1FC3, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x03B7, 0x0345, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1FC4, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x03B7, 0x0301, 0x0345, 0x0000, 0x0000, 0x0000}},
  {0x1FC6, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x03B7, 0x0342, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1FC7, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x03B7, 0x0342, 0x0345, 0x0000, 0x0000, 0x0000}},
  {0x1FC8, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0395, 0x0300, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1FC9, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0395, 0x0301, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1FCA, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0397, 0x0300, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1FCB, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0397, 0x0301, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1FCC, CHAR_CATEGORY_LT, DECOMP_TAG_NONE,
   {0x0397, 0x0345, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1FCD, CHAR_CATEGORY_SK, DECOMP_TAG_NONE,
   {0x1FBF, 0x0300, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1FCE, CHAR_CATEGORY_SK, DECOMP_TAG_NONE,
   {0x1FBF, 0x0301, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1FCF, CHAR_CATEGORY_SK, DECOMP_TAG_NONE,
   {0x1FBF, 0x0342, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1FD0, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x03B9, 0x0306, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1FD1, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x03B9, 0x0304, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1FD2, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x03B9, 0x0308, 0x0300, 0x0000, 0x0000, 0x0000}},
  {0x1FD3, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x03B9, 0x0308, 0x0301, 0x0000, 0x0000, 0x0000}},
  {0x1FD6, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x03B9, 0x0342, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1FD7, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x03B9, 0x0308, 0x0342, 0x0000, 0x0000, 0x0000}},
  {0x1FD8, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0399, 0x0306, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1FD9, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0399, 0x0304, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1FDA, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0399, 0x0300, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1FDB, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0399, 0x0301, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1FDD, CHAR_CATEGORY_SK, DECOMP_TAG_NONE,
   {0x1FFE, 0x0300, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1FDE, CHAR_CATEGORY_SK, DECOMP_TAG_NONE,
   {0x1FFE, 0x0301, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1FDF, CHAR_CATEGORY_SK, DECOMP_TAG_NONE,
   {0x1FFE, 0x0342, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1FE0, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x03C5, 0x0306, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1FE1, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x03C5, 0x0304, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1FE2, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x03C5, 0x0308, 0x0300, 0x0000, 0x0000, 0x0000}},
  {0x1FE3, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x03C5, 0x0308, 0x0301, 0x0000, 0x0000, 0x0000}},
  {0x1FE4, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x03C1, 0x0313, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1FE5, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x03C1, 0x0314, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1FE6, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x03C5, 0x0342, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1FE7, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x03C5, 0x0308, 0x0342, 0x0000, 0x0000, 0x0000}},
  {0x1FE8, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x03A5, 0x0306, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1FE9, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x03A5, 0x0304, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1FEA, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x03A5, 0x0300, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1FEB, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x03A5, 0x0301, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1FEC, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x03A1, 0x0314, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1FED, CHAR_CATEGORY_SK, DECOMP_TAG_NONE,
   {0x00A8, 0x0300, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1FEE, CHAR_CATEGORY_SK, DECOMP_TAG_NONE,
   {0x00A8, 0x0301, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1FEF, CHAR_CATEGORY_SK, DECOMP_TAG_NONE,
   {0x0060, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1FF2, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x03C9, 0x0300, 0x0345, 0x0000, 0x0000, 0x0000}},
  {0x1FF3, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x03C9, 0x0345, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1FF4, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x03C9, 0x0301, 0x0345, 0x0000, 0x0000, 0x0000}},
  {0x1FF6, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x03C9, 0x0342, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1FF7, CHAR_CATEGORY_LL, DECOMP_TAG_NONE,
   {0x03C9, 0x0342, 0x0345, 0x0000, 0x0000, 0x0000}},
  {0x1FF8, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x039F, 0x0300, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1FF9, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x039F, 0x0301, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1FFA, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x03A9, 0x0300, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1FFB, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x03A9, 0x0301, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1FFC, CHAR_CATEGORY_LT, DECOMP_TAG_NONE,
   {0x03A9, 0x0345, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1FFD, CHAR_CATEGORY_SK, DECOMP_TAG_NONE,
   {0x00B4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1FFE, CHAR_CATEGORY_SK, DECOMP_TAG_COMPAT,
   {0x0020, 0x0314, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2000, CHAR_CATEGORY_ZS, DECOMP_TAG_NONE,
   {0x2002, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2001, CHAR_CATEGORY_ZS, DECOMP_TAG_NONE,
   {0x2003, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2002, CHAR_CATEGORY_ZS, DECOMP_TAG_COMPAT,
   {0x0020, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2003, CHAR_CATEGORY_ZS, DECOMP_TAG_COMPAT,
   {0x0020, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2004, CHAR_CATEGORY_ZS, DECOMP_TAG_COMPAT,
   {0x0020, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2005, CHAR_CATEGORY_ZS, DECOMP_TAG_COMPAT,
   {0x0020, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2006, CHAR_CATEGORY_ZS, DECOMP_TAG_COMPAT,
   {0x0020, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2007, CHAR_CATEGORY_ZS, DECOMP_TAG_NOBREAK,
   {0x0020, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2008, CHAR_CATEGORY_ZS, DECOMP_TAG_COMPAT,
   {0x0020, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2009, CHAR_CATEGORY_ZS, DECOMP_TAG_COMPAT,
   {0x0020, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x200A, CHAR_CATEGORY_ZS, DECOMP_TAG_COMPAT,
   {0x0020, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2011, CHAR_CATEGORY_PD, DECOMP_TAG_NOBREAK,
   {0x2010, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2017, CHAR_CATEGORY_PO, DECOMP_TAG_COMPAT,
   {0x0020, 0x0333, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2024, CHAR_CATEGORY_PO, DECOMP_TAG_COMPAT,
   {0x002E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2025, CHAR_CATEGORY_PO, DECOMP_TAG_COMPAT,
   {0x002E, 0x002E, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2026, CHAR_CATEGORY_PO, DECOMP_TAG_COMPAT,
   {0x002E, 0x002E, 0x002E, 0x0000, 0x0000, 0x0000}},
  {0x202F, CHAR_CATEGORY_ZS, DECOMP_TAG_NOBREAK,
   {0x0020, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2033, CHAR_CATEGORY_PO, DECOMP_TAG_COMPAT,
   {0x2032, 0x2032, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2034, CHAR_CATEGORY_PO, DECOMP_TAG_COMPAT,
   {0x2032, 0x2032, 0x2032, 0x0000, 0x0000, 0x0000}},
  {0x2036, CHAR_CATEGORY_PO, DECOMP_TAG_COMPAT,
   {0x2035, 0x2035, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2037, CHAR_CATEGORY_PO, DECOMP_TAG_COMPAT,
   {0x2035, 0x2035, 0x2035, 0x0000, 0x0000, 0x0000}},
  {0x203C, CHAR_CATEGORY_PO, DECOMP_TAG_COMPAT,
   {0x0021, 0x0021, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x203E, CHAR_CATEGORY_PO, DECOMP_TAG_COMPAT,
   {0x0020, 0x0305, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2047, CHAR_CATEGORY_PO, DECOMP_TAG_COMPAT,
   {0x003F, 0x003F, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2048, CHAR_CATEGORY_PO, DECOMP_TAG_COMPAT,
   {0x003F, 0x0021, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2049, CHAR_CATEGORY_PO, DECOMP_TAG_COMPAT,
   {0x0021, 0x003F, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2057, CHAR_CATEGORY_PO, DECOMP_TAG_COMPAT,
   {0x2032, 0x2032, 0x2032, 0x2032, 0x0000, 0x0000}},
  {0x205F, CHAR_CATEGORY_ZS, DECOMP_TAG_COMPAT,
   {0x0020, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2070, CHAR_CATEGORY_NO, DECOMP_TAG_SUPER,
   {0x0030, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2071, CHAR_CATEGORY_LM, DECOMP_TAG_SUPER,
   {0x0069, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2074, CHAR_CATEGORY_NO, DECOMP_TAG_SUPER,
   {0x0034, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2075, CHAR_CATEGORY_NO, DECOMP_TAG_SUPER,
   {0x0035, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2076, CHAR_CATEGORY_NO, DECOMP_TAG_SUPER,
   {0x0036, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2077, CHAR_CATEGORY_NO, DECOMP_TAG_SUPER,
   {0x0037, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2078, CHAR_CATEGORY_NO, DECOMP_TAG_SUPER,
   {0x0038, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2079, CHAR_CATEGORY_NO, DECOMP_TAG_SUPER,
   {0x0039, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x207A, CHAR_CATEGORY_SM, DECOMP_TAG_SUPER,
   {0x002B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x207B, CHAR_CATEGORY_SM, DECOMP_TAG_SUPER,
   {0x2212, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x207C, CHAR_CATEGORY_SM, DECOMP_TAG_SUPER,
   {0x003D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x207D, CHAR_CATEGORY_PS, DECOMP_TAG_SUPER,
   {0x0028, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x207E, CHAR_CATEGORY_PE, DECOMP_TAG_SUPER,
   {0x0029, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x207F, CHAR_CATEGORY_LM, DECOMP_TAG_SUPER,
   {0x006E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2080, CHAR_CATEGORY_NO, DECOMP_TAG_SUB,
   {0x0030, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2081, CHAR_CATEGORY_NO, DECOMP_TAG_SUB,
   {0x0031, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2082, CHAR_CATEGORY_NO, DECOMP_TAG_SUB,
   {0x0032, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2083, CHAR_CATEGORY_NO, DECOMP_TAG_SUB,
   {0x0033, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2084, CHAR_CATEGORY_NO, DECOMP_TAG_SUB,
   {0x0034, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2085, CHAR_CATEGORY_NO, DECOMP_TAG_SUB,
   {0x0035, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2086, CHAR_CATEGORY_NO, DECOMP_TAG_SUB,
   {0x0036, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2087, CHAR_CATEGORY_NO, DECOMP_TAG_SUB,
   {0x0037, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2088, CHAR_CATEGORY_NO, DECOMP_TAG_SUB,
   {0x0038, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2089, CHAR_CATEGORY_NO, DECOMP_TAG_SUB,
   {0x0039, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x208A, CHAR_CATEGORY_SM, DECOMP_TAG_SUB,
   {0x002B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x208B, CHAR_CATEGORY_SM, DECOMP_TAG_SUB,
   {0x2212, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x208C, CHAR_CATEGORY_SM, DECOMP_TAG_SUB,
   {0x003D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x208D, CHAR_CATEGORY_PS, DECOMP_TAG_SUB,
   {0x0028, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x208E, CHAR_CATEGORY_PE, DECOMP_TAG_SUB,
   {0x0029, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2090, CHAR_CATEGORY_LM, DECOMP_TAG_SUB,
   {0x0061, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2091, CHAR_CATEGORY_LM, DECOMP_TAG_SUB,
   {0x0065, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2092, CHAR_CATEGORY_LM, DECOMP_TAG_SUB,
   {0x006F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2093, CHAR_CATEGORY_LM, DECOMP_TAG_SUB,
   {0x0078, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2094, CHAR_CATEGORY_LM, DECOMP_TAG_SUB,
   {0x0259, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2095, CHAR_CATEGORY_LM, DECOMP_TAG_SUB,
   {0x0068, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2096, CHAR_CATEGORY_LM, DECOMP_TAG_SUB,
   {0x006B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2097, CHAR_CATEGORY_LM, DECOMP_TAG_SUB,
   {0x006C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2098, CHAR_CATEGORY_LM, DECOMP_TAG_SUB,
   {0x006D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2099, CHAR_CATEGORY_LM, DECOMP_TAG_SUB,
   {0x006E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x209A, CHAR_CATEGORY_LM, DECOMP_TAG_SUB,
   {0x0070, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x209B, CHAR_CATEGORY_LM, DECOMP_TAG_SUB,
   {0x0073, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x209C, CHAR_CATEGORY_LM, DECOMP_TAG_SUB,
   {0x0074, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x20A8, CHAR_CATEGORY_SC, DECOMP_TAG_COMPAT,
   {0x0052, 0x0073, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2100, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0061, 0x002F, 0x0063, 0x0000, 0x0000, 0x0000}},
  {0x2101, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0061, 0x002F, 0x0073, 0x0000, 0x0000, 0x0000}},
  {0x2102, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0043, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2103, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x00B0, 0x0043, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2105, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0063, 0x002F, 0x006F, 0x0000, 0x0000, 0x0000}},
  {0x2106, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0063, 0x002F, 0x0075, 0x0000, 0x0000, 0x0000}},
  {0x2107, CHAR_CATEGORY_LU, DECOMP_TAG_COMPAT,
   {0x0190, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2109, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x00B0, 0x0046, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x210A, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0067, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x210B, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0048, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x210C, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0048, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x210D, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0048, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x210E, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0068, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x210F, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0127, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2110, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0049, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2111, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0049, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2112, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x004C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2113, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x006C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2115, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x004E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2116, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x004E, 0x006F, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2119, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0050, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x211A, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0051, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x211B, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0052, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x211C, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0052, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x211D, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0052, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2120, CHAR_CATEGORY_SO, DECOMP_TAG_SUPER,
   {0x0053, 0x004D, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2121, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0054, 0x0045, 0x004C, 0x0000, 0x0000, 0x0000}},
  {0x2122, CHAR_CATEGORY_SO, DECOMP_TAG_SUPER,
   {0x0054, 0x004D, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2124, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x005A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2126, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x03A9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2128, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x005A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x212A, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x004B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x212B, CHAR_CATEGORY_LU, DECOMP_TAG_NONE,
   {0x0041, 0x030A, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x212C, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0042, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x212D, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0043, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x212F, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0065, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2130, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0045, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2131, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0046, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2133, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x004D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2134, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x006F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2135, CHAR_CATEGORY_LO, DECOMP_TAG_COMPAT,
   {0x05D0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2136, CHAR_CATEGORY_LO, DECOMP_TAG_COMPAT,
   {0x05D1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2137, CHAR_CATEGORY_LO, DECOMP_TAG_COMPAT,
   {0x05D2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2138, CHAR_CATEGORY_LO, DECOMP_TAG_COMPAT,
   {0x05D3, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2139, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0069, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x213B, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0046, 0x0041, 0x0058, 0x0000, 0x0000, 0x0000}},
  {0x213C, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03C0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x213D, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03B3, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x213E, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0393, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x213F, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x03A0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2140, CHAR_CATEGORY_SM, DECOMP_TAG_FONT,
   {0x2211, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2145, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0044, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2146, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0064, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2147, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0065, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2148, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0069, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2149, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x006A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2150, CHAR_CATEGORY_NO, DECOMP_TAG_FRACTION,
   {0x0031, 0x2044, 0x0037, 0x0000, 0x0000, 0x0000}},
  {0x2151, CHAR_CATEGORY_NO, DECOMP_TAG_FRACTION,
   {0x0031, 0x2044, 0x0039, 0x0000, 0x0000, 0x0000}},
  {0x2152, CHAR_CATEGORY_NO, DECOMP_TAG_FRACTION,
   {0x0031, 0x2044, 0x0031, 0x0030, 0x0000, 0x0000}},
  {0x2153, CHAR_CATEGORY_NO, DECOMP_TAG_FRACTION,
   {0x0031, 0x2044, 0x0033, 0x0000, 0x0000, 0x0000}},
  {0x2154, CHAR_CATEGORY_NO, DECOMP_TAG_FRACTION,
   {0x0032, 0x2044, 0x0033, 0x0000, 0x0000, 0x0000}},
  {0x2155, CHAR_CATEGORY_NO, DECOMP_TAG_FRACTION,
   {0x0031, 0x2044, 0x0035, 0x0000, 0x0000, 0x0000}},
  {0x2156, CHAR_CATEGORY_NO, DECOMP_TAG_FRACTION,
   {0x0032, 0x2044, 0x0035, 0x0000, 0x0000, 0x0000}},
  {0x2157, CHAR_CATEGORY_NO, DECOMP_TAG_FRACTION,
   {0x0033, 0x2044, 0x0035, 0x0000, 0x0000, 0x0000}},
  {0x2158, CHAR_CATEGORY_NO, DECOMP_TAG_FRACTION,
   {0x0034, 0x2044, 0x0035, 0x0000, 0x0000, 0x0000}},
  {0x2159, CHAR_CATEGORY_NO, DECOMP_TAG_FRACTION,
   {0x0031, 0x2044, 0x0036, 0x0000, 0x0000, 0x0000}},
  {0x215A, CHAR_CATEGORY_NO, DECOMP_TAG_FRACTION,
   {0x0035, 0x2044, 0x0036, 0x0000, 0x0000, 0x0000}},
  {0x215B, CHAR_CATEGORY_NO, DECOMP_TAG_FRACTION,
   {0x0031, 0x2044, 0x0038, 0x0000, 0x0000, 0x0000}},
  {0x215C, CHAR_CATEGORY_NO, DECOMP_TAG_FRACTION,
   {0x0033, 0x2044, 0x0038, 0x0000, 0x0000, 0x0000}},
  {0x215D, CHAR_CATEGORY_NO, DECOMP_TAG_FRACTION,
   {0x0035, 0x2044, 0x0038, 0x0000, 0x0000, 0x0000}},
  {0x215E, CHAR_CATEGORY_NO, DECOMP_TAG_FRACTION,
   {0x0037, 0x2044, 0x0038, 0x0000, 0x0000, 0x0000}},
  {0x215F, CHAR_CATEGORY_NO, DECOMP_TAG_FRACTION,
   {0x0031, 0x2044, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2160, CHAR_CATEGORY_NL, DECOMP_TAG_COMPAT,
   {0x0049, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2161, CHAR_CATEGORY_NL, DECOMP_TAG_COMPAT,
   {0x0049, 0x0049, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2162, CHAR_CATEGORY_NL, DECOMP_TAG_COMPAT,
   {0x0049, 0x0049, 0x0049, 0x0000, 0x0000, 0x0000}},
  {0x2163, CHAR_CATEGORY_NL, DECOMP_TAG_COMPAT,
   {0x0049, 0x0056, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2164, CHAR_CATEGORY_NL, DECOMP_TAG_COMPAT,
   {0x0056, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2165, CHAR_CATEGORY_NL, DECOMP_TAG_COMPAT,
   {0x0056, 0x0049, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2166, CHAR_CATEGORY_NL, DECOMP_TAG_COMPAT,
   {0x0056, 0x0049, 0x0049, 0x0000, 0x0000, 0x0000}},
  {0x2167, CHAR_CATEGORY_NL, DECOMP_TAG_COMPAT,
   {0x0056, 0x0049, 0x0049, 0x0049, 0x0000, 0x0000}},
  {0x2168, CHAR_CATEGORY_NL, DECOMP_TAG_COMPAT,
   {0x0049, 0x0058, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2169, CHAR_CATEGORY_NL, DECOMP_TAG_COMPAT,
   {0x0058, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x216A, CHAR_CATEGORY_NL, DECOMP_TAG_COMPAT,
   {0x0058, 0x0049, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x216B, CHAR_CATEGORY_NL, DECOMP_TAG_COMPAT,
   {0x0058, 0x0049, 0x0049, 0x0000, 0x0000, 0x0000}},
  {0x216C, CHAR_CATEGORY_NL, DECOMP_TAG_COMPAT,
   {0x004C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x216D, CHAR_CATEGORY_NL, DECOMP_TAG_COMPAT,
   {0x0043, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x216E, CHAR_CATEGORY_NL, DECOMP_TAG_COMPAT,
   {0x0044, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x216F, CHAR_CATEGORY_NL, DECOMP_TAG_COMPAT,
   {0x004D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2170, CHAR_CATEGORY_NL, DECOMP_TAG_COMPAT,
   {0x0069, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2171, CHAR_CATEGORY_NL, DECOMP_TAG_COMPAT,
   {0x0069, 0x0069, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2172, CHAR_CATEGORY_NL, DECOMP_TAG_COMPAT,
   {0x0069, 0x0069, 0x0069, 0x0000, 0x0000, 0x0000}},
  {0x2173, CHAR_CATEGORY_NL, DECOMP_TAG_COMPAT,
   {0x0069, 0x0076, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2174, CHAR_CATEGORY_NL, DECOMP_TAG_COMPAT,
   {0x0076, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2175, CHAR_CATEGORY_NL, DECOMP_TAG_COMPAT,
   {0x0076, 0x0069, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2176, CHAR_CATEGORY_NL, DECOMP_TAG_COMPAT,
   {0x0076, 0x0069, 0x0069, 0x0000, 0x0000, 0x0000}},
  {0x2177, CHAR_CATEGORY_NL, DECOMP_TAG_COMPAT,
   {0x0076, 0x0069, 0x0069, 0x0069, 0x0000, 0x0000}},
  {0x2178, CHAR_CATEGORY_NL, DECOMP_TAG_COMPAT,
   {0x0069, 0x0078, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2179, CHAR_CATEGORY_NL, DECOMP_TAG_COMPAT,
   {0x0078, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x217A, CHAR_CATEGORY_NL, DECOMP_TAG_COMPAT,
   {0x0078, 0x0069, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x217B, CHAR_CATEGORY_NL, DECOMP_TAG_COMPAT,
   {0x0078, 0x0069, 0x0069, 0x0000, 0x0000, 0x0000}},
  {0x217C, CHAR_CATEGORY_NL, DECOMP_TAG_COMPAT,
   {0x006C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x217D, CHAR_CATEGORY_NL, DECOMP_TAG_COMPAT,
   {0x0063, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x217E, CHAR_CATEGORY_NL, DECOMP_TAG_COMPAT,
   {0x0064, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x217F, CHAR_CATEGORY_NL, DECOMP_TAG_COMPAT,
   {0x006D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2189, CHAR_CATEGORY_NO, DECOMP_TAG_FRACTION,
   {0x0030, 0x2044, 0x0033, 0x0000, 0x0000, 0x0000}},
  {0x219A, CHAR_CATEGORY_SM, DECOMP_TAG_NONE,
   {0x2190, 0x0338, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x219B, CHAR_CATEGORY_SM, DECOMP_TAG_NONE,
   {0x2192, 0x0338, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x21AE, CHAR_CATEGORY_SM, DECOMP_TAG_NONE,
   {0x2194, 0x0338, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x21CD, CHAR_CATEGORY_SO, DECOMP_TAG_NONE,
   {0x21D0, 0x0338, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x21CE, CHAR_CATEGORY_SM, DECOMP_TAG_NONE,
   {0x21D4, 0x0338, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x21CF, CHAR_CATEGORY_SM, DECOMP_TAG_NONE,
   {0x21D2, 0x0338, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2204, CHAR_CATEGORY_SM, DECOMP_TAG_NONE,
   {0x2203, 0x0338, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2209, CHAR_CATEGORY_SM, DECOMP_TAG_NONE,
   {0x2208, 0x0338, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x220C, CHAR_CATEGORY_SM, DECOMP_TAG_NONE,
   {0x220B, 0x0338, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2224, CHAR_CATEGORY_SM, DECOMP_TAG_NONE,
   {0x2223, 0x0338, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2226, CHAR_CATEGORY_SM, DECOMP_TAG_NONE,
   {0x2225, 0x0338, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x222C, CHAR_CATEGORY_SM, DECOMP_TAG_COMPAT,
   {0x222B, 0x222B, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x222D, CHAR_CATEGORY_SM, DECOMP_TAG_COMPAT,
   {0x222B, 0x222B, 0x222B, 0x0000, 0x0000, 0x0000}},
  {0x222F, CHAR_CATEGORY_SM, DECOMP_TAG_COMPAT,
   {0x222E, 0x222E, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2230, CHAR_CATEGORY_SM, DECOMP_TAG_COMPAT,
   {0x222E, 0x222E, 0x222E, 0x0000, 0x0000, 0x0000}},
  {0x2241, CHAR_CATEGORY_SM, DECOMP_TAG_NONE,
   {0x223C, 0x0338, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2244, CHAR_CATEGORY_SM, DECOMP_TAG_NONE,
   {0x2243, 0x0338, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2247, CHAR_CATEGORY_SM, DECOMP_TAG_NONE,
   {0x2245, 0x0338, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2249, CHAR_CATEGORY_SM, DECOMP_TAG_NONE,
   {0x2248, 0x0338, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2260, CHAR_CATEGORY_SM, DECOMP_TAG_NONE,
   {0x003D, 0x0338, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2262, CHAR_CATEGORY_SM, DECOMP_TAG_NONE,
   {0x2261, 0x0338, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x226D, CHAR_CATEGORY_SM, DECOMP_TAG_NONE,
   {0x224D, 0x0338, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x226E, CHAR_CATEGORY_SM, DECOMP_TAG_NONE,
   {0x003C, 0x0338, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x226F, CHAR_CATEGORY_SM, DECOMP_TAG_NONE,
   {0x003E, 0x0338, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2270, CHAR_CATEGORY_SM, DECOMP_TAG_NONE,
   {0x2264, 0x0338, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2271, CHAR_CATEGORY_SM, DECOMP_TAG_NONE,
   {0x2265, 0x0338, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2274, CHAR_CATEGORY_SM, DECOMP_TAG_NONE,
   {0x2272, 0x0338, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2275, CHAR_CATEGORY_SM, DECOMP_TAG_NONE,
   {0x2273, 0x0338, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2278, CHAR_CATEGORY_SM, DECOMP_TAG_NONE,
   {0x2276, 0x0338, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2279, CHAR_CATEGORY_SM, DECOMP_TAG_NONE,
   {0x2277, 0x0338, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2280, CHAR_CATEGORY_SM, DECOMP_TAG_NONE,
   {0x227A, 0x0338, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2281, CHAR_CATEGORY_SM, DECOMP_TAG_NONE,
   {0x227B, 0x0338, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2284, CHAR_CATEGORY_SM, DECOMP_TAG_NONE,
   {0x2282, 0x0338, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2285, CHAR_CATEGORY_SM, DECOMP_TAG_NONE,
   {0x2283, 0x0338, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2288, CHAR_CATEGORY_SM, DECOMP_TAG_NONE,
   {0x2286, 0x0338, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2289, CHAR_CATEGORY_SM, DECOMP_TAG_NONE,
   {0x2287, 0x0338, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x22AC, CHAR_CATEGORY_SM, DECOMP_TAG_NONE,
   {0x22A2, 0x0338, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x22AD, CHAR_CATEGORY_SM, DECOMP_TAG_NONE,
   {0x22A8, 0x0338, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x22AE, CHAR_CATEGORY_SM, DECOMP_TAG_NONE,
   {0x22A9, 0x0338, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x22AF, CHAR_CATEGORY_SM, DECOMP_TAG_NONE,
   {0x22AB, 0x0338, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x22E0, CHAR_CATEGORY_SM, DECOMP_TAG_NONE,
   {0x227C, 0x0338, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x22E1, CHAR_CATEGORY_SM, DECOMP_TAG_NONE,
   {0x227D, 0x0338, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x22E2, CHAR_CATEGORY_SM, DECOMP_TAG_NONE,
   {0x2291, 0x0338, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x22E3, CHAR_CATEGORY_SM, DECOMP_TAG_NONE,
   {0x2292, 0x0338, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x22EA, CHAR_CATEGORY_SM, DECOMP_TAG_NONE,
   {0x22B2, 0x0338, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x22EB, CHAR_CATEGORY_SM, DECOMP_TAG_NONE,
   {0x22B3, 0x0338, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x22EC, CHAR_CATEGORY_SM, DECOMP_TAG_NONE,
   {0x22B4, 0x0338, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x22ED, CHAR_CATEGORY_SM, DECOMP_TAG_NONE,
   {0x22B5, 0x0338, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2329, CHAR_CATEGORY_PS, DECOMP_TAG_NONE,
   {0x3008, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x232A, CHAR_CATEGORY_PE, DECOMP_TAG_NONE,
   {0x3009, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2460, CHAR_CATEGORY_NO, DECOMP_TAG_CIRCLE,
   {0x0031, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2461, CHAR_CATEGORY_NO, DECOMP_TAG_CIRCLE,
   {0x0032, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2462, CHAR_CATEGORY_NO, DECOMP_TAG_CIRCLE,
   {0x0033, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2463, CHAR_CATEGORY_NO, DECOMP_TAG_CIRCLE,
   {0x0034, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2464, CHAR_CATEGORY_NO, DECOMP_TAG_CIRCLE,
   {0x0035, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2465, CHAR_CATEGORY_NO, DECOMP_TAG_CIRCLE,
   {0x0036, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2466, CHAR_CATEGORY_NO, DECOMP_TAG_CIRCLE,
   {0x0037, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2467, CHAR_CATEGORY_NO, DECOMP_TAG_CIRCLE,
   {0x0038, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2468, CHAR_CATEGORY_NO, DECOMP_TAG_CIRCLE,
   {0x0039, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2469, CHAR_CATEGORY_NO, DECOMP_TAG_CIRCLE,
   {0x0031, 0x0030, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x246A, CHAR_CATEGORY_NO, DECOMP_TAG_CIRCLE,
   {0x0031, 0x0031, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x246B, CHAR_CATEGORY_NO, DECOMP_TAG_CIRCLE,
   {0x0031, 0x0032, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x246C, CHAR_CATEGORY_NO, DECOMP_TAG_CIRCLE,
   {0x0031, 0x0033, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x246D, CHAR_CATEGORY_NO, DECOMP_TAG_CIRCLE,
   {0x0031, 0x0034, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x246E, CHAR_CATEGORY_NO, DECOMP_TAG_CIRCLE,
   {0x0031, 0x0035, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x246F, CHAR_CATEGORY_NO, DECOMP_TAG_CIRCLE,
   {0x0031, 0x0036, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2470, CHAR_CATEGORY_NO, DECOMP_TAG_CIRCLE,
   {0x0031, 0x0037, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2471, CHAR_CATEGORY_NO, DECOMP_TAG_CIRCLE,
   {0x0031, 0x0038, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2472, CHAR_CATEGORY_NO, DECOMP_TAG_CIRCLE,
   {0x0031, 0x0039, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2473, CHAR_CATEGORY_NO, DECOMP_TAG_CIRCLE,
   {0x0032, 0x0030, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2474, CHAR_CATEGORY_NO, DECOMP_TAG_COMPAT,
   {0x0028, 0x0031, 0x0029, 0x0000, 0x0000, 0x0000}},
  {0x2475, CHAR_CATEGORY_NO, DECOMP_TAG_COMPAT,
   {0x0028, 0x0032, 0x0029, 0x0000, 0x0000, 0x0000}},
  {0x2476, CHAR_CATEGORY_NO, DECOMP_TAG_COMPAT,
   {0x0028, 0x0033, 0x0029, 0x0000, 0x0000, 0x0000}},
  {0x2477, CHAR_CATEGORY_NO, DECOMP_TAG_COMPAT,
   {0x0028, 0x0034, 0x0029, 0x0000, 0x0000, 0x0000}},
  {0x2478, CHAR_CATEGORY_NO, DECOMP_TAG_COMPAT,
   {0x0028, 0x0035, 0x0029, 0x0000, 0x0000, 0x0000}},
  {0x2479, CHAR_CATEGORY_NO, DECOMP_TAG_COMPAT,
   {0x0028, 0x0036, 0x0029, 0x0000, 0x0000, 0x0000}},
  {0x247A, CHAR_CATEGORY_NO, DECOMP_TAG_COMPAT,
   {0x0028, 0x0037, 0x0029, 0x0000, 0x0000, 0x0000}},
  {0x247B, CHAR_CATEGORY_NO, DECOMP_TAG_COMPAT,
   {0x0028, 0x0038, 0x0029, 0x0000, 0x0000, 0x0000}},
  {0x247C, CHAR_CATEGORY_NO, DECOMP_TAG_COMPAT,
   {0x0028, 0x0039, 0x0029, 0x0000, 0x0000, 0x0000}},
  {0x247D, CHAR_CATEGORY_NO, DECOMP_TAG_COMPAT,
   {0x0028, 0x0031, 0x0030, 0x0029, 0x0000, 0x0000}},
  {0x247E, CHAR_CATEGORY_NO, DECOMP_TAG_COMPAT,
   {0x0028, 0x0031, 0x0031, 0x0029, 0x0000, 0x0000}},
  {0x247F, CHAR_CATEGORY_NO, DECOMP_TAG_COMPAT,
   {0x0028, 0x0031, 0x0032, 0x0029, 0x0000, 0x0000}},
  {0x2480, CHAR_CATEGORY_NO, DECOMP_TAG_COMPAT,
   {0x0028, 0x0031, 0x0033, 0x0029, 0x0000, 0x0000}},
  {0x2481, CHAR_CATEGORY_NO, DECOMP_TAG_COMPAT,
   {0x0028, 0x0031, 0x0034, 0x0029, 0x0000, 0x0000}},
  {0x2482, CHAR_CATEGORY_NO, DECOMP_TAG_COMPAT,
   {0x0028, 0x0031, 0x0035, 0x0029, 0x0000, 0x0000}},
  {0x2483, CHAR_CATEGORY_NO, DECOMP_TAG_COMPAT,
   {0x0028, 0x0031, 0x0036, 0x0029, 0x0000, 0x0000}},
  {0x2484, CHAR_CATEGORY_NO, DECOMP_TAG_COMPAT,
   {0x0028, 0x0031, 0x0037, 0x0029, 0x0000, 0x0000}},
  {0x2485, CHAR_CATEGORY_NO, DECOMP_TAG_COMPAT,
   {0x0028, 0x0031, 0x0038, 0x0029, 0x0000, 0x0000}},
  {0x2486, CHAR_CATEGORY_NO, DECOMP_TAG_COMPAT,
   {0x0028, 0x0031, 0x0039, 0x0029, 0x0000, 0x0000}},
  {0x2487, CHAR_CATEGORY_NO, DECOMP_TAG_COMPAT,
   {0x0028, 0x0032, 0x0030, 0x0029, 0x0000, 0x0000}},
  {0x2488, CHAR_CATEGORY_NO, DECOMP_TAG_COMPAT,
   {0x0031, 0x002E, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2489, CHAR_CATEGORY_NO, DECOMP_TAG_COMPAT,
   {0x0032, 0x002E, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x248A, CHAR_CATEGORY_NO, DECOMP_TAG_COMPAT,
   {0x0033, 0x002E, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x248B, CHAR_CATEGORY_NO, DECOMP_TAG_COMPAT,
   {0x0034, 0x002E, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x248C, CHAR_CATEGORY_NO, DECOMP_TAG_COMPAT,
   {0x0035, 0x002E, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x248D, CHAR_CATEGORY_NO, DECOMP_TAG_COMPAT,
   {0x0036, 0x002E, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x248E, CHAR_CATEGORY_NO, DECOMP_TAG_COMPAT,
   {0x0037, 0x002E, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x248F, CHAR_CATEGORY_NO, DECOMP_TAG_COMPAT,
   {0x0038, 0x002E, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2490, CHAR_CATEGORY_NO, DECOMP_TAG_COMPAT,
   {0x0039, 0x002E, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2491, CHAR_CATEGORY_NO, DECOMP_TAG_COMPAT,
   {0x0031, 0x0030, 0x002E, 0x0000, 0x0000, 0x0000}},
  {0x2492, CHAR_CATEGORY_NO, DECOMP_TAG_COMPAT,
   {0x0031, 0x0031, 0x002E, 0x0000, 0x0000, 0x0000}},
  {0x2493, CHAR_CATEGORY_NO, DECOMP_TAG_COMPAT,
   {0x0031, 0x0032, 0x002E, 0x0000, 0x0000, 0x0000}},
  {0x2494, CHAR_CATEGORY_NO, DECOMP_TAG_COMPAT,
   {0x0031, 0x0033, 0x002E, 0x0000, 0x0000, 0x0000}},
  {0x2495, CHAR_CATEGORY_NO, DECOMP_TAG_COMPAT,
   {0x0031, 0x0034, 0x002E, 0x0000, 0x0000, 0x0000}},
  {0x2496, CHAR_CATEGORY_NO, DECOMP_TAG_COMPAT,
   {0x0031, 0x0035, 0x002E, 0x0000, 0x0000, 0x0000}},
  {0x2497, CHAR_CATEGORY_NO, DECOMP_TAG_COMPAT,
   {0x0031, 0x0036, 0x002E, 0x0000, 0x0000, 0x0000}},
  {0x2498, CHAR_CATEGORY_NO, DECOMP_TAG_COMPAT,
   {0x0031, 0x0037, 0x002E, 0x0000, 0x0000, 0x0000}},
  {0x2499, CHAR_CATEGORY_NO, DECOMP_TAG_COMPAT,
   {0x0031, 0x0038, 0x002E, 0x0000, 0x0000, 0x0000}},
  {0x249A, CHAR_CATEGORY_NO, DECOMP_TAG_COMPAT,
   {0x0031, 0x0039, 0x002E, 0x0000, 0x0000, 0x0000}},
  {0x249B, CHAR_CATEGORY_NO, DECOMP_TAG_COMPAT,
   {0x0032, 0x0030, 0x002E, 0x0000, 0x0000, 0x0000}},
  {0x249C, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0028, 0x0061, 0x0029, 0x0000, 0x0000, 0x0000}},
  {0x249D, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0028, 0x0062, 0x0029, 0x0000, 0x0000, 0x0000}},
  {0x249E, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0028, 0x0063, 0x0029, 0x0000, 0x0000, 0x0000}},
  {0x249F, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0028, 0x0064, 0x0029, 0x0000, 0x0000, 0x0000}},
  {0x24A0, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0028, 0x0065, 0x0029, 0x0000, 0x0000, 0x0000}},
  {0x24A1, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0028, 0x0066, 0x0029, 0x0000, 0x0000, 0x0000}},
  {0x24A2, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0028, 0x0067, 0x0029, 0x0000, 0x0000, 0x0000}},
  {0x24A3, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0028, 0x0068, 0x0029, 0x0000, 0x0000, 0x0000}},
  {0x24A4, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0028, 0x0069, 0x0029, 0x0000, 0x0000, 0x0000}},
  {0x24A5, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0028, 0x006A, 0x0029, 0x0000, 0x0000, 0x0000}},
  {0x24A6, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0028, 0x006B, 0x0029, 0x0000, 0x0000, 0x0000}},
  {0x24A7, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0028, 0x006C, 0x0029, 0x0000, 0x0000, 0x0000}},
  {0x24A8, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0028, 0x006D, 0x0029, 0x0000, 0x0000, 0x0000}},
  {0x24A9, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0028, 0x006E, 0x0029, 0x0000, 0x0000, 0x0000}},
  {0x24AA, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0028, 0x006F, 0x0029, 0x0000, 0x0000, 0x0000}},
  {0x24AB, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0028, 0x0070, 0x0029, 0x0000, 0x0000, 0x0000}},
  {0x24AC, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0028, 0x0071, 0x0029, 0x0000, 0x0000, 0x0000}},
  {0x24AD, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0028, 0x0072, 0x0029, 0x0000, 0x0000, 0x0000}},
  {0x24AE, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0028, 0x0073, 0x0029, 0x0000, 0x0000, 0x0000}},
  {0x24AF, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0028, 0x0074, 0x0029, 0x0000, 0x0000, 0x0000}},
  {0x24B0, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0028, 0x0075, 0x0029, 0x0000, 0x0000, 0x0000}},
  {0x24B1, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0028, 0x0076, 0x0029, 0x0000, 0x0000, 0x0000}},
  {0x24B2, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0028, 0x0077, 0x0029, 0x0000, 0x0000, 0x0000}},
  {0x24B3, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0028, 0x0078, 0x0029, 0x0000, 0x0000, 0x0000}},
  {0x24B4, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0028, 0x0079, 0x0029, 0x0000, 0x0000, 0x0000}},
  {0x24B5, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0028, 0x007A, 0x0029, 0x0000, 0x0000, 0x0000}},
  {0x24B6, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x0041, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x24B7, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x0042, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x24B8, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x0043, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x24B9, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x0044, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x24BA, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x0045, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x24BB, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x0046, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x24BC, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x0047, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x24BD, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x0048, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x24BE, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x0049, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x24BF, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x004A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x24C0, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x004B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x24C1, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x004C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x24C2, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x004D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x24C3, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x004E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x24C4, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x004F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x24C5, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x0050, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x24C6, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x0051, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x24C7, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x0052, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x24C8, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x0053, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x24C9, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x0054, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x24CA, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x0055, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x24CB, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x0056, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x24CC, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x0057, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x24CD, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x0058, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x24CE, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x0059, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x24CF, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x005A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x24D0, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x0061, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x24D1, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x0062, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x24D2, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x0063, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x24D3, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x0064, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x24D4, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x0065, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x24D5, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x0066, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x24D6, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x0067, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x24D7, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x0068, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x24D8, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x0069, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x24D9, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x006A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x24DA, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x006B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x24DB, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x006C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x24DC, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x006D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x24DD, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x006E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x24DE, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x006F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x24DF, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x0070, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x24E0, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x0071, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x24E1, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x0072, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x24E2, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x0073, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x24E3, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x0074, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x24E4, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x0075, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x24E5, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x0076, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x24E6, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x0077, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x24E7, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x0078, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x24E8, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x0079, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x24E9, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x007A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x24EA, CHAR_CATEGORY_NO, DECOMP_TAG_CIRCLE,
   {0x0030, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2A0C, CHAR_CATEGORY_SM, DECOMP_TAG_COMPAT,
   {0x222B, 0x222B, 0x222B, 0x222B, 0x0000, 0x0000}},
  {0x2A74, CHAR_CATEGORY_SM, DECOMP_TAG_COMPAT,
   {0x003A, 0x003A, 0x003D, 0x0000, 0x0000, 0x0000}},
  {0x2A75, CHAR_CATEGORY_SM, DECOMP_TAG_COMPAT,
   {0x003D, 0x003D, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2A76, CHAR_CATEGORY_SM, DECOMP_TAG_COMPAT,
   {0x003D, 0x003D, 0x003D, 0x0000, 0x0000, 0x0000}},
  {0x2ADC, CHAR_CATEGORY_SM, DECOMP_TAG_NONE,
   {0x2ADD, 0x0338, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2C7C, CHAR_CATEGORY_LM, DECOMP_TAG_SUB,
   {0x006A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2C7D, CHAR_CATEGORY_LM, DECOMP_TAG_SUPER,
   {0x0056, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2D6F, CHAR_CATEGORY_LM, DECOMP_TAG_SUPER,
   {0x2D61, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2E9F, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x6BCD, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2EF3, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x9F9F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F00, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x4E00, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F01, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x4E28, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F02, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x4E36, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F03, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x4E3F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F04, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x4E59, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F05, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x4E85, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F06, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x4E8C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F07, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x4EA0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F08, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x4EBA, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F09, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x513F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F0A, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x5165, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F0B, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x516B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F0C, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x5182, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F0D, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x5196, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F0E, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x51AB, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F0F, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x51E0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F10, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x51F5, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F11, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x5200, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F12, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x529B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F13, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x52F9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F14, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x5315, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F15, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x531A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F16, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x5338, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F17, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x5341, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F18, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x535C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F19, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x5369, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F1A, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x5382, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F1B, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x53B6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F1C, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x53C8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F1D, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x53E3, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F1E, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x56D7, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F1F, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x571F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F20, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x58EB, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F21, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x5902, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F22, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x590A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F23, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x5915, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F24, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x5927, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F25, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x5973, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F26, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x5B50, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F27, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x5B80, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F28, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x5BF8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F29, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x5C0F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F2A, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x5C22, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F2B, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x5C38, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F2C, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x5C6E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F2D, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x5C71, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F2E, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x5DDB, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F2F, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x5DE5, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F30, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x5DF1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F31, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x5DFE, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F32, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x5E72, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F33, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x5E7A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F34, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x5E7F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F35, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x5EF4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F36, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x5EFE, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F37, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x5F0B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F38, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x5F13, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F39, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x5F50, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F3A, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x5F61, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F3B, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x5F73, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F3C, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x5FC3, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F3D, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x6208, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F3E, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x6236, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F3F, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x624B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F40, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x652F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F41, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x6534, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F42, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x6587, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F43, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x6597, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F44, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x65A4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F45, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x65B9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F46, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x65E0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F47, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x65E5, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F48, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x66F0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F49, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x6708, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F4A, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x6728, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F4B, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x6B20, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F4C, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x6B62, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F4D, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x6B79, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F4E, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x6BB3, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F4F, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x6BCB, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F50, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x6BD4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F51, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x6BDB, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F52, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x6C0F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F53, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x6C14, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F54, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x6C34, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F55, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x706B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F56, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x722A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F57, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x7236, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F58, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x723B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F59, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x723F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F5A, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x7247, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F5B, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x7259, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F5C, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x725B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F5D, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x72AC, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F5E, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x7384, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F5F, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x7389, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F60, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x74DC, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F61, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x74E6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F62, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x7518, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F63, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x751F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F64, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x7528, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F65, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x7530, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F66, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x758B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F67, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x7592, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F68, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x7676, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F69, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x767D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F6A, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x76AE, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F6B, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x76BF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F6C, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x76EE, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F6D, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x77DB, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F6E, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x77E2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F6F, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x77F3, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F70, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x793A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F71, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x79B8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F72, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x79BE, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F73, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x7A74, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F74, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x7ACB, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F75, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x7AF9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F76, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x7C73, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F77, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x7CF8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F78, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x7F36, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F79, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x7F51, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F7A, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x7F8A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F7B, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x7FBD, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F7C, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x8001, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F7D, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x800C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F7E, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x8012, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F7F, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x8033, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F80, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x807F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F81, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x8089, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F82, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x81E3, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F83, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x81EA, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F84, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x81F3, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F85, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x81FC, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F86, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x820C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F87, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x821B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F88, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x821F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F89, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x826E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F8A, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x8272, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F8B, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x8278, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F8C, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x864D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F8D, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x866B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F8E, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x8840, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F8F, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x884C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F90, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x8863, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F91, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x897E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F92, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x898B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F93, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x89D2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F94, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x8A00, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F95, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x8C37, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F96, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x8C46, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F97, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x8C55, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F98, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x8C78, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F99, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x8C9D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F9A, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x8D64, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F9B, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x8D70, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F9C, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x8DB3, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F9D, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x8EAB, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F9E, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x8ECA, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F9F, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x8F9B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2FA0, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x8FB0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2FA1, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x8FB5, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2FA2, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x9091, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2FA3, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x9149, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2FA4, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x91C6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2FA5, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x91CC, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2FA6, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x91D1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2FA7, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x9577, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2FA8, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x9580, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2FA9, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x961C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2FAA, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x96B6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2FAB, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x96B9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2FAC, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x96E8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2FAD, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x9751, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2FAE, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x975E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2FAF, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x9762, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2FB0, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x9769, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2FB1, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x97CB, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2FB2, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x97ED, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2FB3, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x97F3, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2FB4, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x9801, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2FB5, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x98A8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2FB6, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x98DB, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2FB7, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x98DF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2FB8, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x9996, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2FB9, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x9999, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2FBA, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x99AC, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2FBB, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x9AA8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2FBC, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x9AD8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2FBD, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x9ADF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2FBE, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x9B25, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2FBF, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x9B2F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2FC0, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x9B32, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2FC1, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x9B3C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2FC2, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x9B5A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2FC3, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x9CE5, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2FC4, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x9E75, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2FC5, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x9E7F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2FC6, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x9EA5, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2FC7, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x9EBB, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2FC8, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x9EC3, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2FC9, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x9ECD, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2FCA, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x9ED1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2FCB, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x9EF9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2FCC, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x9EFD, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2FCD, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x9F0E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2FCE, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x9F13, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2FCF, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x9F20, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2FD0, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x9F3B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2FD1, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x9F4A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2FD2, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x9F52, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2FD3, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x9F8D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2FD4, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x9F9C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2FD5, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x9FA0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3000, CHAR_CATEGORY_ZS, DECOMP_TAG_WIDE,
   {0x0020, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3036, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x3012, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3038, CHAR_CATEGORY_NL, DECOMP_TAG_COMPAT,
   {0x5341, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3039, CHAR_CATEGORY_NL, DECOMP_TAG_COMPAT,
   {0x5344, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x303A, CHAR_CATEGORY_NL, DECOMP_TAG_COMPAT,
   {0x5345, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x304C, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x304B, 0x3099, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x304E, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x304D, 0x3099, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3050, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x304F, 0x3099, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3052, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x3051, 0x3099, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3054, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x3053, 0x3099, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3056, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x3055, 0x3099, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3058, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x3057, 0x3099, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x305A, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x3059, 0x3099, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x305C, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x305B, 0x3099, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x305E, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x305D, 0x3099, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3060, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x305F, 0x3099, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3062, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x3061, 0x3099, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3065, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x3064, 0x3099, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3067, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x3066, 0x3099, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3069, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x3068, 0x3099, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3070, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x306F, 0x3099, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3071, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x306F, 0x309A, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3073, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x3072, 0x3099, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3074, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x3072, 0x309A, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3076, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x3075, 0x3099, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3077, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x3075, 0x309A, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3079, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x3078, 0x3099, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x307A, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x3078, 0x309A, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x307C, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x307B, 0x3099, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x307D, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x307B, 0x309A, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3094, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x3046, 0x3099, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x309B, CHAR_CATEGORY_SK, DECOMP_TAG_COMPAT,
   {0x0020, 0x3099, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x309C, CHAR_CATEGORY_SK, DECOMP_TAG_COMPAT,
   {0x0020, 0x309A, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x309E, CHAR_CATEGORY_LM, DECOMP_TAG_NONE,
   {0x309D, 0x3099, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x309F, CHAR_CATEGORY_LO, DECOMP_TAG_VERTICAL,
   {0x3088, 0x308A, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x30AC, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x30AB, 0x3099, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x30AE, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x30AD, 0x3099, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x30B0, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x30AF, 0x3099, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x30B2, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x30B1, 0x3099, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x30B4, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x30B3, 0x3099, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x30B6, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x30B5, 0x3099, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x30B8, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x30B7, 0x3099, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x30BA, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x30B9, 0x3099, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x30BC, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x30BB, 0x3099, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x30BE, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x30BD, 0x3099, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x30C0, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x30BF, 0x3099, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x30C2, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x30C1, 0x3099, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x30C5, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x30C4, 0x3099, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x30C7, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x30C6, 0x3099, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x30C9, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x30C8, 0x3099, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x30D0, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x30CF, 0x3099, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x30D1, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x30CF, 0x309A, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x30D3, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x30D2, 0x3099, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x30D4, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x30D2, 0x309A, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x30D6, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x30D5, 0x3099, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x30D7, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x30D5, 0x309A, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x30D9, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x30D8, 0x3099, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x30DA, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x30D8, 0x309A, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x30DC, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x30DB, 0x3099, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x30DD, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x30DB, 0x309A, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x30F4, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x30A6, 0x3099, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x30F7, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x30EF, 0x3099, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x30F8, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x30F0, 0x3099, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x30F9, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x30F1, 0x3099, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x30FA, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x30F2, 0x3099, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x30FE, CHAR_CATEGORY_LM, DECOMP_TAG_NONE,
   {0x30FD, 0x3099, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x30FF, CHAR_CATEGORY_LO, DECOMP_TAG_VERTICAL,
   {0x30B3, 0x30C8, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3131, CHAR_CATEGORY_LO, DECOMP_TAG_COMPAT,
   {0x1100, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3132, CHAR_CATEGORY_LO, DECOMP_TAG_COMPAT,
   {0x1101, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3133, CHAR_CATEGORY_LO, DECOMP_TAG_COMPAT,
   {0x11AA, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3134, CHAR_CATEGORY_LO, DECOMP_TAG_COMPAT,
   {0x1102, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3135, CHAR_CATEGORY_LO, DECOMP_TAG_COMPAT,
   {0x11AC, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3136, CHAR_CATEGORY_LO, DECOMP_TAG_COMPAT,
   {0x11AD, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3137, CHAR_CATEGORY_LO, DECOMP_TAG_COMPAT,
   {0x1103, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3138, CHAR_CATEGORY_LO, DECOMP_TAG_COMPAT,
   {0x1104, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3139, CHAR_CATEGORY_LO, DECOMP_TAG_COMPAT,
   {0x1105, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x313A, CHAR_CATEGORY_LO, DECOMP_TAG_COMPAT,
   {0x11B0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x313B, CHAR_CATEGORY_LO, DECOMP_TAG_COMPAT,
   {0x11B1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x313C, CHAR_CATEGORY_LO, DECOMP_TAG_COMPAT,
   {0x11B2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x313D, CHAR_CATEGORY_LO, DECOMP_TAG_COMPAT,
   {0x11B3, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x313E, CHAR_CATEGORY_LO, DECOMP_TAG_COMPAT,
   {0x11B4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x313F, CHAR_CATEGORY_LO, DECOMP_TAG_COMPAT,
   {0x11B5, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3140, CHAR_CATEGORY_LO, DECOMP_TAG_COMPAT,
   {0x111A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3141, CHAR_CATEGORY_LO, DECOMP_TAG_COMPAT,
   {0x1106, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3142, CHAR_CATEGORY_LO, DECOMP_TAG_COMPAT,
   {0x1107, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3143, CHAR_CATEGORY_LO, DECOMP_TAG_COMPAT,
   {0x1108, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3144, CHAR_CATEGORY_LO, DECOMP_TAG_COMPAT,
   {0x1121, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3145, CHAR_CATEGORY_LO, DECOMP_TAG_COMPAT,
   {0x1109, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3146, CHAR_CATEGORY_LO, DECOMP_TAG_COMPAT,
   {0x110A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3147, CHAR_CATEGORY_LO, DECOMP_TAG_COMPAT,
   {0x110B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3148, CHAR_CATEGORY_LO, DECOMP_TAG_COMPAT,
   {0x110C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3149, CHAR_CATEGORY_LO, DECOMP_TAG_COMPAT,
   {0x110D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x314A, CHAR_CATEGORY_LO, DECOMP_TAG_COMPAT,
   {0x110E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x314B, CHAR_CATEGORY_LO, DECOMP_TAG_COMPAT,
   {0x110F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x314C, CHAR_CATEGORY_LO, DECOMP_TAG_COMPAT,
   {0x1110, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x314D, CHAR_CATEGORY_LO, DECOMP_TAG_COMPAT,
   {0x1111, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x314E, CHAR_CATEGORY_LO, DECOMP_TAG_COMPAT,
   {0x1112, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x314F, CHAR_CATEGORY_LO, DECOMP_TAG_COMPAT,
   {0x1161, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3150, CHAR_CATEGORY_LO, DECOMP_TAG_COMPAT,
   {0x1162, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3151, CHAR_CATEGORY_LO, DECOMP_TAG_COMPAT,
   {0x1163, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3152, CHAR_CATEGORY_LO, DECOMP_TAG_COMPAT,
   {0x1164, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3153, CHAR_CATEGORY_LO, DECOMP_TAG_COMPAT,
   {0x1165, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3154, CHAR_CATEGORY_LO, DECOMP_TAG_COMPAT,
   {0x1166, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3155, CHAR_CATEGORY_LO, DECOMP_TAG_COMPAT,
   {0x1167, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3156, CHAR_CATEGORY_LO, DECOMP_TAG_COMPAT,
   {0x1168, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3157, CHAR_CATEGORY_LO, DECOMP_TAG_COMPAT,
   {0x1169, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3158, CHAR_CATEGORY_LO, DECOMP_TAG_COMPAT,
   {0x116A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3159, CHAR_CATEGORY_LO, DECOMP_TAG_COMPAT,
   {0x116B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x315A, CHAR_CATEGORY_LO, DECOMP_TAG_COMPAT,
   {0x116C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x315B, CHAR_CATEGORY_LO, DECOMP_TAG_COMPAT,
   {0x116D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x315C, CHAR_CATEGORY_LO, DECOMP_TAG_COMPAT,
   {0x116E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x315D, CHAR_CATEGORY_LO, DECOMP_TAG_COMPAT,
   {0x116F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x315E, CHAR_CATEGORY_LO, DECOMP_TAG_COMPAT,
   {0x1170, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x315F, CHAR_CATEGORY_LO, DECOMP_TAG_COMPAT,
   {0x1171, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3160, CHAR_CATEGORY_LO, DECOMP_TAG_COMPAT,
   {0x1172, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3161, CHAR_CATEGORY_LO, DECOMP_TAG_COMPAT,
   {0x1173, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3162, CHAR_CATEGORY_LO, DECOMP_TAG_COMPAT,
   {0x1174, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3163, CHAR_CATEGORY_LO, DECOMP_TAG_COMPAT,
   {0x1175, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3164, CHAR_CATEGORY_LO, DECOMP_TAG_COMPAT,
   {0x1160, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3165, CHAR_CATEGORY_LO, DECOMP_TAG_COMPAT,
   {0x1114, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3166, CHAR_CATEGORY_LO, DECOMP_TAG_COMPAT,
   {0x1115, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3167, CHAR_CATEGORY_LO, DECOMP_TAG_COMPAT,
   {0x11C7, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3168, CHAR_CATEGORY_LO, DECOMP_TAG_COMPAT,
   {0x11C8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3169, CHAR_CATEGORY_LO, DECOMP_TAG_COMPAT,
   {0x11CC, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x316A, CHAR_CATEGORY_LO, DECOMP_TAG_COMPAT,
   {0x11CE, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x316B, CHAR_CATEGORY_LO, DECOMP_TAG_COMPAT,
   {0x11D3, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x316C, CHAR_CATEGORY_LO, DECOMP_TAG_COMPAT,
   {0x11D7, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x316D, CHAR_CATEGORY_LO, DECOMP_TAG_COMPAT,
   {0x11D9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x316E, CHAR_CATEGORY_LO, DECOMP_TAG_COMPAT,
   {0x111C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x316F, CHAR_CATEGORY_LO, DECOMP_TAG_COMPAT,
   {0x11DD, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3170, CHAR_CATEGORY_LO, DECOMP_TAG_COMPAT,
   {0x11DF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3171, CHAR_CATEGORY_LO, DECOMP_TAG_COMPAT,
   {0x111D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3172, CHAR_CATEGORY_LO, DECOMP_TAG_COMPAT,
   {0x111E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3173, CHAR_CATEGORY_LO, DECOMP_TAG_COMPAT,
   {0x1120, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3174, CHAR_CATEGORY_LO, DECOMP_TAG_COMPAT,
   {0x1122, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3175, CHAR_CATEGORY_LO, DECOMP_TAG_COMPAT,
   {0x1123, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3176, CHAR_CATEGORY_LO, DECOMP_TAG_COMPAT,
   {0x1127, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3177, CHAR_CATEGORY_LO, DECOMP_TAG_COMPAT,
   {0x1129, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3178, CHAR_CATEGORY_LO, DECOMP_TAG_COMPAT,
   {0x112B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3179, CHAR_CATEGORY_LO, DECOMP_TAG_COMPAT,
   {0x112C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x317A, CHAR_CATEGORY_LO, DECOMP_TAG_COMPAT,
   {0x112D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x317B, CHAR_CATEGORY_LO, DECOMP_TAG_COMPAT,
   {0x112E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x317C, CHAR_CATEGORY_LO, DECOMP_TAG_COMPAT,
   {0x112F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x317D, CHAR_CATEGORY_LO, DECOMP_TAG_COMPAT,
   {0x1132, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x317E, CHAR_CATEGORY_LO, DECOMP_TAG_COMPAT,
   {0x1136, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x317F, CHAR_CATEGORY_LO, DECOMP_TAG_COMPAT,
   {0x1140, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3180, CHAR_CATEGORY_LO, DECOMP_TAG_COMPAT,
   {0x1147, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3181, CHAR_CATEGORY_LO, DECOMP_TAG_COMPAT,
   {0x114C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3182, CHAR_CATEGORY_LO, DECOMP_TAG_COMPAT,
   {0x11F1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3183, CHAR_CATEGORY_LO, DECOMP_TAG_COMPAT,
   {0x11F2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3184, CHAR_CATEGORY_LO, DECOMP_TAG_COMPAT,
   {0x1157, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3185, CHAR_CATEGORY_LO, DECOMP_TAG_COMPAT,
   {0x1158, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3186, CHAR_CATEGORY_LO, DECOMP_TAG_COMPAT,
   {0x1159, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3187, CHAR_CATEGORY_LO, DECOMP_TAG_COMPAT,
   {0x1184, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3188, CHAR_CATEGORY_LO, DECOMP_TAG_COMPAT,
   {0x1185, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3189, CHAR_CATEGORY_LO, DECOMP_TAG_COMPAT,
   {0x1188, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x318A, CHAR_CATEGORY_LO, DECOMP_TAG_COMPAT,
   {0x1191, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x318B, CHAR_CATEGORY_LO, DECOMP_TAG_COMPAT,
   {0x1192, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x318C, CHAR_CATEGORY_LO, DECOMP_TAG_COMPAT,
   {0x1194, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x318D, CHAR_CATEGORY_LO, DECOMP_TAG_COMPAT,
   {0x119E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x318E, CHAR_CATEGORY_LO, DECOMP_TAG_COMPAT,
   {0x11A1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3192, CHAR_CATEGORY_NO, DECOMP_TAG_SUPER,
   {0x4E00, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3193, CHAR_CATEGORY_NO, DECOMP_TAG_SUPER,
   {0x4E8C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3194, CHAR_CATEGORY_NO, DECOMP_TAG_SUPER,
   {0x4E09, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3195, CHAR_CATEGORY_NO, DECOMP_TAG_SUPER,
   {0x56DB, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3196, CHAR_CATEGORY_SO, DECOMP_TAG_SUPER,
   {0x4E0A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3197, CHAR_CATEGORY_SO, DECOMP_TAG_SUPER,
   {0x4E2D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3198, CHAR_CATEGORY_SO, DECOMP_TAG_SUPER,
   {0x4E0B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3199, CHAR_CATEGORY_SO, DECOMP_TAG_SUPER,
   {0x7532, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x319A, CHAR_CATEGORY_SO, DECOMP_TAG_SUPER,
   {0x4E59, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x319B, CHAR_CATEGORY_SO, DECOMP_TAG_SUPER,
   {0x4E19, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x319C, CHAR_CATEGORY_SO, DECOMP_TAG_SUPER,
   {0x4E01, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x319D, CHAR_CATEGORY_SO, DECOMP_TAG_SUPER,
   {0x5929, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x319E, CHAR_CATEGORY_SO, DECOMP_TAG_SUPER,
   {0x5730, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x319F, CHAR_CATEGORY_SO, DECOMP_TAG_SUPER,
   {0x4EBA, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3200, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0028, 0x1100, 0x0029, 0x0000, 0x0000, 0x0000}},
  {0x3201, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0028, 0x1102, 0x0029, 0x0000, 0x0000, 0x0000}},
  {0x3202, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0028, 0x1103, 0x0029, 0x0000, 0x0000, 0x0000}},
  {0x3203, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0028, 0x1105, 0x0029, 0x0000, 0x0000, 0x0000}},
  {0x3204, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0028, 0x1106, 0x0029, 0x0000, 0x0000, 0x0000}},
  {0x3205, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0028, 0x1107, 0x0029, 0x0000, 0x0000, 0x0000}},
  {0x3206, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0028, 0x1109, 0x0029, 0x0000, 0x0000, 0x0000}},
  {0x3207, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0028, 0x110B, 0x0029, 0x0000, 0x0000, 0x0000}},
  {0x3208, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0028, 0x110C, 0x0029, 0x0000, 0x0000, 0x0000}},
  {0x3209, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0028, 0x110E, 0x0029, 0x0000, 0x0000, 0x0000}},
  {0x320A, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0028, 0x110F, 0x0029, 0x0000, 0x0000, 0x0000}},
  {0x320B, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0028, 0x1110, 0x0029, 0x0000, 0x0000, 0x0000}},
  {0x320C, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0028, 0x1111, 0x0029, 0x0000, 0x0000, 0x0000}},
  {0x320D, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0028, 0x1112, 0x0029, 0x0000, 0x0000, 0x0000}},
  {0x320E, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0028, 0x1100, 0x1161, 0x0029, 0x0000, 0x0000}},
  {0x320F, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0028, 0x1102, 0x1161, 0x0029, 0x0000, 0x0000}},
  {0x3210, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0028, 0x1103, 0x1161, 0x0029, 0x0000, 0x0000}},
  {0x3211, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0028, 0x1105, 0x1161, 0x0029, 0x0000, 0x0000}},
  {0x3212, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0028, 0x1106, 0x1161, 0x0029, 0x0000, 0x0000}},
  {0x3213, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0028, 0x1107, 0x1161, 0x0029, 0x0000, 0x0000}},
  {0x3214, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0028, 0x1109, 0x1161, 0x0029, 0x0000, 0x0000}},
  {0x3215, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0028, 0x110B, 0x1161, 0x0029, 0x0000, 0x0000}},
  {0x3216, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0028, 0x110C, 0x1161, 0x0029, 0x0000, 0x0000}},
  {0x3217, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0028, 0x110E, 0x1161, 0x0029, 0x0000, 0x0000}},
  {0x3218, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0028, 0x110F, 0x1161, 0x0029, 0x0000, 0x0000}},
  {0x3219, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0028, 0x1110, 0x1161, 0x0029, 0x0000, 0x0000}},
  {0x321A, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0028, 0x1111, 0x1161, 0x0029, 0x0000, 0x0000}},
  {0x321B, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0028, 0x1112, 0x1161, 0x0029, 0x0000, 0x0000}},
  {0x321C, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0028, 0x110C, 0x116E, 0x0029, 0x0000, 0x0000}},
  {0x321D, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0028, 0x110B, 0x1169, 0x110C, 0x1165, 0x11AB}},
  {0x321E, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0028, 0x110B, 0x1169, 0x1112, 0x116E, 0x0029}},
  {0x3220, CHAR_CATEGORY_NO, DECOMP_TAG_COMPAT,
   {0x0028, 0x4E00, 0x0029, 0x0000, 0x0000, 0x0000}},
  {0x3221, CHAR_CATEGORY_NO, DECOMP_TAG_COMPAT,
   {0x0028, 0x4E8C, 0x0029, 0x0000, 0x0000, 0x0000}},
  {0x3222, CHAR_CATEGORY_NO, DECOMP_TAG_COMPAT,
   {0x0028, 0x4E09, 0x0029, 0x0000, 0x0000, 0x0000}},
  {0x3223, CHAR_CATEGORY_NO, DECOMP_TAG_COMPAT,
   {0x0028, 0x56DB, 0x0029, 0x0000, 0x0000, 0x0000}},
  {0x3224, CHAR_CATEGORY_NO, DECOMP_TAG_COMPAT,
   {0x0028, 0x4E94, 0x0029, 0x0000, 0x0000, 0x0000}},
  {0x3225, CHAR_CATEGORY_NO, DECOMP_TAG_COMPAT,
   {0x0028, 0x516D, 0x0029, 0x0000, 0x0000, 0x0000}},
  {0x3226, CHAR_CATEGORY_NO, DECOMP_TAG_COMPAT,
   {0x0028, 0x4E03, 0x0029, 0x0000, 0x0000, 0x0000}},
  {0x3227, CHAR_CATEGORY_NO, DECOMP_TAG_COMPAT,
   {0x0028, 0x516B, 0x0029, 0x0000, 0x0000, 0x0000}},
  {0x3228, CHAR_CATEGORY_NO, DECOMP_TAG_COMPAT,
   {0x0028, 0x4E5D, 0x0029, 0x0000, 0x0000, 0x0000}},
  {0x3229, CHAR_CATEGORY_NO, DECOMP_TAG_COMPAT,
   {0x0028, 0x5341, 0x0029, 0x0000, 0x0000, 0x0000}},
  {0x322A, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0028, 0x6708, 0x0029, 0x0000, 0x0000, 0x0000}},
  {0x322B, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0028, 0x706B, 0x0029, 0x0000, 0x0000, 0x0000}},
  {0x322C, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0028, 0x6C34, 0x0029, 0x0000, 0x0000, 0x0000}},
  {0x322D, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0028, 0x6728, 0x0029, 0x0000, 0x0000, 0x0000}},
  {0x322E, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0028, 0x91D1, 0x0029, 0x0000, 0x0000, 0x0000}},
  {0x322F, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0028, 0x571F, 0x0029, 0x0000, 0x0000, 0x0000}},
  {0x3230, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0028, 0x65E5, 0x0029, 0x0000, 0x0000, 0x0000}},
  {0x3231, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0028, 0x682A, 0x0029, 0x0000, 0x0000, 0x0000}},
  {0x3232, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0028, 0x6709, 0x0029, 0x0000, 0x0000, 0x0000}},
  {0x3233, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0028, 0x793E, 0x0029, 0x0000, 0x0000, 0x0000}},
  {0x3234, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0028, 0x540D, 0x0029, 0x0000, 0x0000, 0x0000}},
  {0x3235, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0028, 0x7279, 0x0029, 0x0000, 0x0000, 0x0000}},
  {0x3236, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0028, 0x8CA1, 0x0029, 0x0000, 0x0000, 0x0000}},
  {0x3237, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0028, 0x795D, 0x0029, 0x0000, 0x0000, 0x0000}},
  {0x3238, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0028, 0x52B4, 0x0029, 0x0000, 0x0000, 0x0000}},
  {0x3239, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0028, 0x4EE3, 0x0029, 0x0000, 0x0000, 0x0000}},
  {0x323A, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0028, 0x547C, 0x0029, 0x0000, 0x0000, 0x0000}},
  {0x323B, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0028, 0x5B66, 0x0029, 0x0000, 0x0000, 0x0000}},
  {0x323C, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0028, 0x76E3, 0x0029, 0x0000, 0x0000, 0x0000}},
  {0x323D, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0028, 0x4F01, 0x0029, 0x0000, 0x0000, 0x0000}},
  {0x323E, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0028, 0x8CC7, 0x0029, 0x0000, 0x0000, 0x0000}},
  {0x323F, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0028, 0x5354, 0x0029, 0x0000, 0x0000, 0x0000}},
  {0x3240, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0028, 0x796D, 0x0029, 0x0000, 0x0000, 0x0000}},
  {0x3241, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0028, 0x4F11, 0x0029, 0x0000, 0x0000, 0x0000}},
  {0x3242, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0028, 0x81EA, 0x0029, 0x0000, 0x0000, 0x0000}},
  {0x3243, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0028, 0x81F3, 0x0029, 0x0000, 0x0000, 0x0000}},
  {0x3244, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x554F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3245, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x5E7C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3246, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x6587, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3247, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x7B8F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3250, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x0050, 0x0054, 0x0045, 0x0000, 0x0000, 0x0000}},
  {0x3251, CHAR_CATEGORY_NO, DECOMP_TAG_CIRCLE,
   {0x0032, 0x0031, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3252, CHAR_CATEGORY_NO, DECOMP_TAG_CIRCLE,
   {0x0032, 0x0032, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3253, CHAR_CATEGORY_NO, DECOMP_TAG_CIRCLE,
   {0x0032, 0x0033, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3254, CHAR_CATEGORY_NO, DECOMP_TAG_CIRCLE,
   {0x0032, 0x0034, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3255, CHAR_CATEGORY_NO, DECOMP_TAG_CIRCLE,
   {0x0032, 0x0035, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3256, CHAR_CATEGORY_NO, DECOMP_TAG_CIRCLE,
   {0x0032, 0x0036, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3257, CHAR_CATEGORY_NO, DECOMP_TAG_CIRCLE,
   {0x0032, 0x0037, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3258, CHAR_CATEGORY_NO, DECOMP_TAG_CIRCLE,
   {0x0032, 0x0038, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3259, CHAR_CATEGORY_NO, DECOMP_TAG_CIRCLE,
   {0x0032, 0x0039, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x325A, CHAR_CATEGORY_NO, DECOMP_TAG_CIRCLE,
   {0x0033, 0x0030, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x325B, CHAR_CATEGORY_NO, DECOMP_TAG_CIRCLE,
   {0x0033, 0x0031, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x325C, CHAR_CATEGORY_NO, DECOMP_TAG_CIRCLE,
   {0x0033, 0x0032, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x325D, CHAR_CATEGORY_NO, DECOMP_TAG_CIRCLE,
   {0x0033, 0x0033, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x325E, CHAR_CATEGORY_NO, DECOMP_TAG_CIRCLE,
   {0x0033, 0x0034, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x325F, CHAR_CATEGORY_NO, DECOMP_TAG_CIRCLE,
   {0x0033, 0x0035, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3260, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x1100, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3261, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x1102, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3262, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x1103, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3263, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x1105, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3264, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x1106, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3265, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x1107, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3266, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x1109, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3267, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x110B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3268, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x110C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3269, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x110E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x326A, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x110F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x326B, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x1110, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x326C, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x1111, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x326D, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x1112, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x326E, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x1100, 0x1161, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x326F, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x1102, 0x1161, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3270, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x1103, 0x1161, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3271, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x1105, 0x1161, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3272, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x1106, 0x1161, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3273, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x1107, 0x1161, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3274, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x1109, 0x1161, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3275, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x110B, 0x1161, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3276, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x110C, 0x1161, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3277, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x110E, 0x1161, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3278, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x110F, 0x1161, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3279, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x1110, 0x1161, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x327A, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x1111, 0x1161, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x327B, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x1112, 0x1161, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x327C, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x110E, 0x1161, 0x11B7, 0x1100, 0x1169, 0x0000}},
  {0x327D, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x110C, 0x116E, 0x110B, 0x1174, 0x0000, 0x0000}},
  {0x327E, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x110B, 0x116E, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3280, CHAR_CATEGORY_NO, DECOMP_TAG_CIRCLE,
   {0x4E00, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3281, CHAR_CATEGORY_NO, DECOMP_TAG_CIRCLE,
   {0x4E8C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3282, CHAR_CATEGORY_NO, DECOMP_TAG_CIRCLE,
   {0x4E09, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3283, CHAR_CATEGORY_NO, DECOMP_TAG_CIRCLE,
   {0x56DB, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3284, CHAR_CATEGORY_NO, DECOMP_TAG_CIRCLE,
   {0x4E94, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3285, CHAR_CATEGORY_NO, DECOMP_TAG_CIRCLE,
   {0x516D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3286, CHAR_CATEGORY_NO, DECOMP_TAG_CIRCLE,
   {0x4E03, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3287, CHAR_CATEGORY_NO, DECOMP_TAG_CIRCLE,
   {0x516B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3288, CHAR_CATEGORY_NO, DECOMP_TAG_CIRCLE,
   {0x4E5D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3289, CHAR_CATEGORY_NO, DECOMP_TAG_CIRCLE,
   {0x5341, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x328A, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x6708, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x328B, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x706B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x328C, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x6C34, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x328D, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x6728, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x328E, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x91D1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x328F, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x571F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3290, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x65E5, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3291, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x682A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3292, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x6709, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3293, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x793E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3294, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x540D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3295, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x7279, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3296, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x8CA1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3297, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x795D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3298, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x52B4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3299, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x79D8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x329A, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x7537, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x329B, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x5973, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x329C, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x9069, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x329D, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x512A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x329E, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x5370, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x329F, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x6CE8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x32A0, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x9805, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x32A1, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x4F11, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x32A2, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x5199, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x32A3, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x6B63, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x32A4, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x4E0A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x32A5, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x4E2D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x32A6, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x4E0B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x32A7, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x5DE6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x32A8, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x53F3, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x32A9, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x533B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x32AA, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x5B97, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x32AB, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x5B66, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x32AC, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x76E3, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x32AD, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x4F01, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x32AE, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x8CC7, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x32AF, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x5354, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x32B0, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x591C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x32B1, CHAR_CATEGORY_NO, DECOMP_TAG_CIRCLE,
   {0x0033, 0x0036, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x32B2, CHAR_CATEGORY_NO, DECOMP_TAG_CIRCLE,
   {0x0033, 0x0037, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x32B3, CHAR_CATEGORY_NO, DECOMP_TAG_CIRCLE,
   {0x0033, 0x0038, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x32B4, CHAR_CATEGORY_NO, DECOMP_TAG_CIRCLE,
   {0x0033, 0x0039, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x32B5, CHAR_CATEGORY_NO, DECOMP_TAG_CIRCLE,
   {0x0034, 0x0030, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x32B6, CHAR_CATEGORY_NO, DECOMP_TAG_CIRCLE,
   {0x0034, 0x0031, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x32B7, CHAR_CATEGORY_NO, DECOMP_TAG_CIRCLE,
   {0x0034, 0x0032, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x32B8, CHAR_CATEGORY_NO, DECOMP_TAG_CIRCLE,
   {0x0034, 0x0033, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x32B9, CHAR_CATEGORY_NO, DECOMP_TAG_CIRCLE,
   {0x0034, 0x0034, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x32BA, CHAR_CATEGORY_NO, DECOMP_TAG_CIRCLE,
   {0x0034, 0x0035, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x32BB, CHAR_CATEGORY_NO, DECOMP_TAG_CIRCLE,
   {0x0034, 0x0036, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x32BC, CHAR_CATEGORY_NO, DECOMP_TAG_CIRCLE,
   {0x0034, 0x0037, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x32BD, CHAR_CATEGORY_NO, DECOMP_TAG_CIRCLE,
   {0x0034, 0x0038, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x32BE, CHAR_CATEGORY_NO, DECOMP_TAG_CIRCLE,
   {0x0034, 0x0039, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x32BF, CHAR_CATEGORY_NO, DECOMP_TAG_CIRCLE,
   {0x0035, 0x0030, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x32C0, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0031, 0x6708, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x32C1, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0032, 0x6708, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x32C2, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0033, 0x6708, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x32C3, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0034, 0x6708, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x32C4, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0035, 0x6708, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x32C5, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0036, 0x6708, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x32C6, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0037, 0x6708, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x32C7, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0038, 0x6708, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x32C8, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0039, 0x6708, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x32C9, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0031, 0x0030, 0x6708, 0x0000, 0x0000, 0x0000}},
  {0x32CA, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0031, 0x0031, 0x6708, 0x0000, 0x0000, 0x0000}},
  {0x32CB, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0031, 0x0032, 0x6708, 0x0000, 0x0000, 0x0000}},
  {0x32CC, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x0048, 0x0067, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x32CD, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x0065, 0x0072, 0x0067, 0x0000, 0x0000, 0x0000}},
  {0x32CE, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x0065, 0x0056, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x32CF, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x004C, 0x0054, 0x0044, 0x0000, 0x0000, 0x0000}},
  {0x32D0, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x30A2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x32D1, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x30A4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x32D2, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x30A6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x32D3, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x30A8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x32D4, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x30AA, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x32D5, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x30AB, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x32D6, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x30AD, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x32D7, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x30AF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x32D8, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x30B1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x32D9, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x30B3, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x32DA, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x30B5, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x32DB, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x30B7, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x32DC, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x30B9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x32DD, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x30BB, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x32DE, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x30BD, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x32DF, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x30BF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x32E0, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x30C1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x32E1, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x30C4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x32E2, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x30C6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x32E3, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x30C8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x32E4, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x30CA, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x32E5, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x30CB, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x32E6, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x30CC, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x32E7, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x30CD, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x32E8, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x30CE, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x32E9, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x30CF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x32EA, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x30D2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x32EB, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x30D5, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x32EC, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x30D8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x32ED, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x30DB, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x32EE, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x30DE, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x32EF, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x30DF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x32F0, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x30E0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x32F1, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x30E1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x32F2, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x30E2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x32F3, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x30E4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x32F4, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x30E6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x32F5, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x30E8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x32F6, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x30E9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x32F7, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x30EA, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x32F8, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x30EB, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x32F9, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x30EC, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x32FA, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x30ED, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x32FB, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x30EF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x32FC, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x30F0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x32FD, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x30F1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x32FE, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x30F2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3300, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x30A2, 0x30D1, 0x30FC, 0x30C8, 0x0000, 0x0000}},
  {0x3301, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x30A2, 0x30EB, 0x30D5, 0x30A1, 0x0000, 0x0000}},
  {0x3302, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x30A2, 0x30F3, 0x30DA, 0x30A2, 0x0000, 0x0000}},
  {0x3303, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x30A2, 0x30FC, 0x30EB, 0x0000, 0x0000, 0x0000}},
  {0x3304, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x30A4, 0x30CB, 0x30F3, 0x30B0, 0x0000, 0x0000}},
  {0x3305, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x30A4, 0x30F3, 0x30C1, 0x0000, 0x0000, 0x0000}},
  {0x3306, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x30A6, 0x30A9, 0x30F3, 0x0000, 0x0000, 0x0000}},
  {0x3307, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x30A8, 0x30B9, 0x30AF, 0x30FC, 0x30C9, 0x0000}},
  {0x3308, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x30A8, 0x30FC, 0x30AB, 0x30FC, 0x0000, 0x0000}},
  {0x3309, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x30AA, 0x30F3, 0x30B9, 0x0000, 0x0000, 0x0000}},
  {0x330A, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x30AA, 0x30FC, 0x30E0, 0x0000, 0x0000, 0x0000}},
  {0x330B, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x30AB, 0x30A4, 0x30EA, 0x0000, 0x0000, 0x0000}},
  {0x330C, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x30AB, 0x30E9, 0x30C3, 0x30C8, 0x0000, 0x0000}},
  {0x330D, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x30AB, 0x30ED, 0x30EA, 0x30FC, 0x0000, 0x0000}},
  {0x330E, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x30AC, 0x30ED, 0x30F3, 0x0000, 0x0000, 0x0000}},
  {0x330F, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x30AC, 0x30F3, 0x30DE, 0x0000, 0x0000, 0x0000}},
  {0x3310, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x30AE, 0x30AC, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3311, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x30AE, 0x30CB, 0x30FC, 0x0000, 0x0000, 0x0000}},
  {0x3312, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x30AD, 0x30E5, 0x30EA, 0x30FC, 0x0000, 0x0000}},
  {0x3313, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x30AE, 0x30EB, 0x30C0, 0x30FC, 0x0000, 0x0000}},
  {0x3314, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x30AD, 0x30ED, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3315, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x30AD, 0x30ED, 0x30B0, 0x30E9, 0x30E0, 0x0000}},
  {0x3316, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x30AD, 0x30ED, 0x30E1, 0x30FC, 0x30C8, 0x30EB}},
  {0x3317, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x30AD, 0x30ED, 0x30EF, 0x30C3, 0x30C8, 0x0000}},
  {0x3318, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x30B0, 0x30E9, 0x30E0, 0x0000, 0x0000, 0x0000}},
  {0x3319, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x30B0, 0x30E9, 0x30E0, 0x30C8, 0x30F3, 0x0000}},
  {0x331A, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x30AF, 0x30EB, 0x30BC, 0x30A4, 0x30ED, 0x0000}},
  {0x331B, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x30AF, 0x30ED, 0x30FC, 0x30CD, 0x0000, 0x0000}},
  {0x331C, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x30B1, 0x30FC, 0x30B9, 0x0000, 0x0000, 0x0000}},
  {0x331D, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x30B3, 0x30EB, 0x30CA, 0x0000, 0x0000, 0x0000}},
  {0x331E, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x30B3, 0x30FC, 0x30DD, 0x0000, 0x0000, 0x0000}},
  {0x331F, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x30B5, 0x30A4, 0x30AF, 0x30EB, 0x0000, 0x0000}},
  {0x3320, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x30B5, 0x30F3, 0x30C1, 0x30FC, 0x30E0, 0x0000}},
  {0x3321, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x30B7, 0x30EA, 0x30F3, 0x30B0, 0x0000, 0x0000}},
  {0x3322, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x30BB, 0x30F3, 0x30C1, 0x0000, 0x0000, 0x0000}},
  {0x3323, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x30BB, 0x30F3, 0x30C8, 0x0000, 0x0000, 0x0000}},
  {0x3324, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x30C0, 0x30FC, 0x30B9, 0x0000, 0x0000, 0x0000}},
  {0x3325, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x30C7, 0x30B7, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3326, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x30C9, 0x30EB, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3327, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x30C8, 0x30F3, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3328, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x30CA, 0x30CE, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3329, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x30CE, 0x30C3, 0x30C8, 0x0000, 0x0000, 0x0000}},
  {0x332A, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x30CF, 0x30A4, 0x30C4, 0x0000, 0x0000, 0x0000}},
  {0x332B, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x30D1, 0x30FC, 0x30BB, 0x30F3, 0x30C8, 0x0000}},
  {0x332C, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x30D1, 0x30FC, 0x30C4, 0x0000, 0x0000, 0x0000}},
  {0x332D, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x30D0, 0x30FC, 0x30EC, 0x30EB, 0x0000, 0x0000}},
  {0x332E, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x30D4, 0x30A2, 0x30B9, 0x30C8, 0x30EB, 0x0000}},
  {0x332F, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x30D4, 0x30AF, 0x30EB, 0x0000, 0x0000, 0x0000}},
  {0x3330, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x30D4, 0x30B3, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3331, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x30D3, 0x30EB, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3332, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x30D5, 0x30A1, 0x30E9, 0x30C3, 0x30C9, 0x0000}},
  {0x3333, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x30D5, 0x30A3, 0x30FC, 0x30C8, 0x0000, 0x0000}},
  {0x3334, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x30D6, 0x30C3, 0x30B7, 0x30A7, 0x30EB, 0x0000}},
  {0x3335, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x30D5, 0x30E9, 0x30F3, 0x0000, 0x0000, 0x0000}},
  {0x3336, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x30D8, 0x30AF, 0x30BF, 0x30FC, 0x30EB, 0x0000}},
  {0x3337, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x30DA, 0x30BD, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3338, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x30DA, 0x30CB, 0x30D2, 0x0000, 0x0000, 0x0000}},
  {0x3339, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x30D8, 0x30EB, 0x30C4, 0x0000, 0x0000, 0x0000}},
  {0x333A, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x30DA, 0x30F3, 0x30B9, 0x0000, 0x0000, 0x0000}},
  {0x333B, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x30DA, 0x30FC, 0x30B8, 0x0000, 0x0000, 0x0000}},
  {0x333C, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x30D9, 0x30FC, 0x30BF, 0x0000, 0x0000, 0x0000}},
  {0x333D, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x30DD, 0x30A4, 0x30F3, 0x30C8, 0x0000, 0x0000}},
  {0x333E, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x30DC, 0x30EB, 0x30C8, 0x0000, 0x0000, 0x0000}},
  {0x333F, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x30DB, 0x30F3, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3340, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x30DD, 0x30F3, 0x30C9, 0x0000, 0x0000, 0x0000}},
  {0x3341, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x30DB, 0x30FC, 0x30EB, 0x0000, 0x0000, 0x0000}},
  {0x3342, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x30DB, 0x30FC, 0x30F3, 0x0000, 0x0000, 0x0000}},
  {0x3343, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x30DE, 0x30A4, 0x30AF, 0x30ED, 0x0000, 0x0000}},
  {0x3344, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x30DE, 0x30A4, 0x30EB, 0x0000, 0x0000, 0x0000}},
  {0x3345, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x30DE, 0x30C3, 0x30CF, 0x0000, 0x0000, 0x0000}},
  {0x3346, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x30DE, 0x30EB, 0x30AF, 0x0000, 0x0000, 0x0000}},
  {0x3347, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x30DE, 0x30F3, 0x30B7, 0x30E7, 0x30F3, 0x0000}},
  {0x3348, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x30DF, 0x30AF, 0x30ED, 0x30F3, 0x0000, 0x0000}},
  {0x3349, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x30DF, 0x30EA, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x334A, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x30DF, 0x30EA, 0x30D0, 0x30FC, 0x30EB, 0x0000}},
  {0x334B, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x30E1, 0x30AC, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x334C, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x30E1, 0x30AC, 0x30C8, 0x30F3, 0x0000, 0x0000}},
  {0x334D, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x30E1, 0x30FC, 0x30C8, 0x30EB, 0x0000, 0x0000}},
  {0x334E, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x30E4, 0x30FC, 0x30C9, 0x0000, 0x0000, 0x0000}},
  {0x334F, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x30E4, 0x30FC, 0x30EB, 0x0000, 0x0000, 0x0000}},
  {0x3350, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x30E6, 0x30A2, 0x30F3, 0x0000, 0x0000, 0x0000}},
  {0x3351, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x30EA, 0x30C3, 0x30C8, 0x30EB, 0x0000, 0x0000}},
  {0x3352, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x30EA, 0x30E9, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3353, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x30EB, 0x30D4, 0x30FC, 0x0000, 0x0000, 0x0000}},
  {0x3354, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x30EB, 0x30FC, 0x30D6, 0x30EB, 0x0000, 0x0000}},
  {0x3355, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x30EC, 0x30E0, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3356, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x30EC, 0x30F3, 0x30C8, 0x30B2, 0x30F3, 0x0000}},
  {0x3357, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x30EF, 0x30C3, 0x30C8, 0x0000, 0x0000, 0x0000}},
  {0x3358, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0030, 0x70B9, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3359, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0031, 0x70B9, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x335A, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0032, 0x70B9, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x335B, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0033, 0x70B9, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x335C, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0034, 0x70B9, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x335D, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0035, 0x70B9, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x335E, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0036, 0x70B9, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x335F, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0037, 0x70B9, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3360, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0038, 0x70B9, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3361, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0039, 0x70B9, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3362, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0031, 0x0030, 0x70B9, 0x0000, 0x0000, 0x0000}},
  {0x3363, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0031, 0x0031, 0x70B9, 0x0000, 0x0000, 0x0000}},
  {0x3364, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0031, 0x0032, 0x70B9, 0x0000, 0x0000, 0x0000}},
  {0x3365, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0031, 0x0033, 0x70B9, 0x0000, 0x0000, 0x0000}},
  {0x3366, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0031, 0x0034, 0x70B9, 0x0000, 0x0000, 0x0000}},
  {0x3367, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0031, 0x0035, 0x70B9, 0x0000, 0x0000, 0x0000}},
  {0x3368, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0031, 0x0036, 0x70B9, 0x0000, 0x0000, 0x0000}},
  {0x3369, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0031, 0x0037, 0x70B9, 0x0000, 0x0000, 0x0000}},
  {0x336A, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0031, 0x0038, 0x70B9, 0x0000, 0x0000, 0x0000}},
  {0x336B, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0031, 0x0039, 0x70B9, 0x0000, 0x0000, 0x0000}},
  {0x336C, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0032, 0x0030, 0x70B9, 0x0000, 0x0000, 0x0000}},
  {0x336D, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0032, 0x0031, 0x70B9, 0x0000, 0x0000, 0x0000}},
  {0x336E, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0032, 0x0032, 0x70B9, 0x0000, 0x0000, 0x0000}},
  {0x336F, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0032, 0x0033, 0x70B9, 0x0000, 0x0000, 0x0000}},
  {0x3370, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0032, 0x0034, 0x70B9, 0x0000, 0x0000, 0x0000}},
  {0x3371, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x0068, 0x0050, 0x0061, 0x0000, 0x0000, 0x0000}},
  {0x3372, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x0064, 0x0061, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3373, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x0041, 0x0055, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3374, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x0062, 0x0061, 0x0072, 0x0000, 0x0000, 0x0000}},
  {0x3375, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x006F, 0x0056, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3376, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x0070, 0x0063, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3377, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x0064, 0x006D, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3378, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x0064, 0x006D, 0x00B2, 0x0000, 0x0000, 0x0000}},
  {0x3379, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x0064, 0x006D, 0x00B3, 0x0000, 0x0000, 0x0000}},
  {0x337A, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x0049, 0x0055, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x337B, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x5E73, 0x6210, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x337C, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x662D, 0x548C, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x337D, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x5927, 0x6B63, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x337E, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x660E, 0x6CBB, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x337F, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x682A, 0x5F0F, 0x4F1A, 0x793E, 0x0000, 0x0000}},
  {0x3380, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x0070, 0x0041, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3381, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x006E, 0x0041, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3382, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x03BC, 0x0041, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3383, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x006D, 0x0041, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3384, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x006B, 0x0041, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3385, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x004B, 0x0042, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3386, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x004D, 0x0042, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3387, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x0047, 0x0042, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3388, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x0063, 0x0061, 0x006C, 0x0000, 0x0000, 0x0000}},
  {0x3389, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x006B, 0x0063, 0x0061, 0x006C, 0x0000, 0x0000}},
  {0x338A, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x0070, 0x0046, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x338B, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x006E, 0x0046, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x338C, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x03BC, 0x0046, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x338D, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x03BC, 0x0067, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x338E, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x006D, 0x0067, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x338F, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x006B, 0x0067, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3390, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x0048, 0x007A, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3391, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x006B, 0x0048, 0x007A, 0x0000, 0x0000, 0x0000}},
  {0x3392, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x004D, 0x0048, 0x007A, 0x0000, 0x0000, 0x0000}},
  {0x3393, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x0047, 0x0048, 0x007A, 0x0000, 0x0000, 0x0000}},
  {0x3394, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x0054, 0x0048, 0x007A, 0x0000, 0x0000, 0x0000}},
  {0x3395, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x03BC, 0x2113, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3396, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x006D, 0x2113, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3397, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x0064, 0x2113, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3398, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x006B, 0x2113, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x3399, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x0066, 0x006D, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x339A, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x006E, 0x006D, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x339B, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x03BC, 0x006D, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x339C, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x006D, 0x006D, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x339D, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x0063, 0x006D, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x339E, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x006B, 0x006D, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x339F, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x006D, 0x006D, 0x00B2, 0x0000, 0x0000, 0x0000}},
  {0x33A0, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x0063, 0x006D, 0x00B2, 0x0000, 0x0000, 0x0000}},
  {0x33A1, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x006D, 0x00B2, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x33A2, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x006B, 0x006D, 0x00B2, 0x0000, 0x0000, 0x0000}},
  {0x33A3, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x006D, 0x006D, 0x00B3, 0x0000, 0x0000, 0x0000}},
  {0x33A4, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x0063, 0x006D, 0x00B3, 0x0000, 0x0000, 0x0000}},
  {0x33A5, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x006D, 0x00B3, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x33A6, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x006B, 0x006D, 0x00B3, 0x0000, 0x0000, 0x0000}},
  {0x33A7, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x006D, 0x2215, 0x0073, 0x0000, 0x0000, 0x0000}},
  {0x33A8, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x006D, 0x2215, 0x0073, 0x00B2, 0x0000, 0x0000}},
  {0x33A9, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x0050, 0x0061, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x33AA, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x006B, 0x0050, 0x0061, 0x0000, 0x0000, 0x0000}},
  {0x33AB, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x004D, 0x0050, 0x0061, 0x0000, 0x0000, 0x0000}},
  {0x33AC, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x0047, 0x0050, 0x0061, 0x0000, 0x0000, 0x0000}},
  {0x33AD, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x0072, 0x0061, 0x0064, 0x0000, 0x0000, 0x0000}},
  {0x33AE, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x0072, 0x0061, 0x0064, 0x2215, 0x0073, 0x0000}},
  {0x33AF, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x0072, 0x0061, 0x0064, 0x2215, 0x0073, 0x00B2}},
  {0x33B0, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x0070, 0x0073, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x33B1, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x006E, 0x0073, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x33B2, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x03BC, 0x0073, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x33B3, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x006D, 0x0073, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x33B4, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x0070, 0x0056, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x33B5, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x006E, 0x0056, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x33B6, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x03BC, 0x0056, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x33B7, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x006D, 0x0056, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x33B8, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x006B, 0x0056, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x33B9, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x004D, 0x0056, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x33BA, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x0070, 0x0057, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x33BB, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x006E, 0x0057, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x33BC, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x03BC, 0x0057, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x33BD, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x006D, 0x0057, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x33BE, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x006B, 0x0057, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x33BF, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x004D, 0x0057, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x33C0, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x006B, 0x03A9, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x33C1, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x004D, 0x03A9, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x33C2, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x0061, 0x002E, 0x006D, 0x002E, 0x0000, 0x0000}},
  {0x33C3, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x0042, 0x0071, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x33C4, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x0063, 0x0063, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x33C5, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x0063, 0x0064, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x33C6, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x0043, 0x2215, 0x006B, 0x0067, 0x0000, 0x0000}},
  {0x33C7, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x0043, 0x006F, 0x002E, 0x0000, 0x0000, 0x0000}},
  {0x33C8, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x0064, 0x0042, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x33C9, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x0047, 0x0079, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x33CA, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x0068, 0x0061, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x33CB, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x0048, 0x0050, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x33CC, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x0069, 0x006E, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x33CD, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x004B, 0x004B, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x33CE, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x004B, 0x004D, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x33CF, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x006B, 0x0074, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x33D0, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x006C, 0x006D, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x33D1, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x006C, 0x006E, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x33D2, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x006C, 0x006F, 0x0067, 0x0000, 0x0000, 0x0000}},
  {0x33D3, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x006C, 0x0078, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x33D4, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x006D, 0x0062, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x33D5, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x006D, 0x0069, 0x006C, 0x0000, 0x0000, 0x0000}},
  {0x33D6, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x006D, 0x006F, 0x006C, 0x0000, 0x0000, 0x0000}},
  {0x33D7, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x0050, 0x0048, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x33D8, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x0070, 0x002E, 0x006D, 0x002E, 0x0000, 0x0000}},
  {0x33D9, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x0050, 0x0050, 0x004D, 0x0000, 0x0000, 0x0000}},
  {0x33DA, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x0050, 0x0052, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x33DB, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x0073, 0x0072, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x33DC, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x0053, 0x0076, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x33DD, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x0057, 0x0062, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x33DE, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x0056, 0x2215, 0x006D, 0x0000, 0x0000, 0x0000}},
  {0x33DF, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x0041, 0x2215, 0x006D, 0x0000, 0x0000, 0x0000}},
  {0x33E0, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0031, 0x65E5, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x33E1, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0032, 0x65E5, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x33E2, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0033, 0x65E5, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x33E3, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0034, 0x65E5, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x33E4, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0035, 0x65E5, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x33E5, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0036, 0x65E5, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x33E6, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0037, 0x65E5, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x33E7, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0038, 0x65E5, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x33E8, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0039, 0x65E5, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x33E9, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0031, 0x0030, 0x65E5, 0x0000, 0x0000, 0x0000}},
  {0x33EA, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0031, 0x0031, 0x65E5, 0x0000, 0x0000, 0x0000}},
  {0x33EB, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0031, 0x0032, 0x65E5, 0x0000, 0x0000, 0x0000}},
  {0x33EC, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0031, 0x0033, 0x65E5, 0x0000, 0x0000, 0x0000}},
  {0x33ED, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0031, 0x0034, 0x65E5, 0x0000, 0x0000, 0x0000}},
  {0x33EE, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0031, 0x0035, 0x65E5, 0x0000, 0x0000, 0x0000}},
  {0x33EF, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0031, 0x0036, 0x65E5, 0x0000, 0x0000, 0x0000}},
  {0x33F0, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0031, 0x0037, 0x65E5, 0x0000, 0x0000, 0x0000}},
  {0x33F1, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0031, 0x0038, 0x65E5, 0x0000, 0x0000, 0x0000}},
  {0x33F2, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0031, 0x0039, 0x65E5, 0x0000, 0x0000, 0x0000}},
  {0x33F3, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0032, 0x0030, 0x65E5, 0x0000, 0x0000, 0x0000}},
  {0x33F4, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0032, 0x0031, 0x65E5, 0x0000, 0x0000, 0x0000}},
  {0x33F5, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0032, 0x0032, 0x65E5, 0x0000, 0x0000, 0x0000}},
  {0x33F6, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0032, 0x0033, 0x65E5, 0x0000, 0x0000, 0x0000}},
  {0x33F7, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0032, 0x0034, 0x65E5, 0x0000, 0x0000, 0x0000}},
  {0x33F8, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0032, 0x0035, 0x65E5, 0x0000, 0x0000, 0x0000}},
  {0x33F9, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0032, 0x0036, 0x65E5, 0x0000, 0x0000, 0x0000}},
  {0x33FA, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0032, 0x0037, 0x65E5, 0x0000, 0x0000, 0x0000}},
  {0x33FB, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0032, 0x0038, 0x65E5, 0x0000, 0x0000, 0x0000}},
  {0x33FC, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0032, 0x0039, 0x65E5, 0x0000, 0x0000, 0x0000}},
  {0x33FD, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0033, 0x0030, 0x65E5, 0x0000, 0x0000, 0x0000}},
  {0x33FE, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0033, 0x0031, 0x65E5, 0x0000, 0x0000, 0x0000}},
  {0x33FF, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x0067, 0x0061, 0x006C, 0x0000, 0x0000, 0x0000}},
  {0xA69C, CHAR_CATEGORY_LM, DECOMP_TAG_SUPER,
   {0x044A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xA69D, CHAR_CATEGORY_LM, DECOMP_TAG_SUPER,
   {0x044C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xA770, CHAR_CATEGORY_LM, DECOMP_TAG_SUPER,
   {0xA76F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xA7F8, CHAR_CATEGORY_LM, DECOMP_TAG_SUPER,
   {0x0126, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xA7F9, CHAR_CATEGORY_LM, DECOMP_TAG_SUPER,
   {0x0153, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xAB5C, CHAR_CATEGORY_LM, DECOMP_TAG_SUPER,
   {0xA727, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xAB5D, CHAR_CATEGORY_LM, DECOMP_TAG_SUPER,
   {0xAB37, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xAB5E, CHAR_CATEGORY_LM, DECOMP_TAG_SUPER,
   {0x026B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xAB5F, CHAR_CATEGORY_LM, DECOMP_TAG_SUPER,
   {0xAB52, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF900, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x8C48, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF901, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x66F4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF902, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x8ECA, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF903, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x8CC8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF904, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x6ED1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF905, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x4E32, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF906, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x53E5, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF907, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x9F9C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF908, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x9F9C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF909, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x5951, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF90A, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x91D1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF90B, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x5587, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF90C, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x5948, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF90D, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x61F6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF90E, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x7669, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF90F, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x7F85, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF910, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x863F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF911, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x87BA, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF912, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x88F8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF913, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x908F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF914, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x6A02, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF915, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x6D1B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF916, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x70D9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF917, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x73DE, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF918, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x843D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF919, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x916A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF91A, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x99F1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF91B, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x4E82, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF91C, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x5375, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF91D, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x6B04, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF91E, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x721B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF91F, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x862D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF920, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x9E1E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF921, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x5D50, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF922, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x6FEB, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF923, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x85CD, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF924, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x8964, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF925, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x62C9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF926, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x81D8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF927, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x881F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF928, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x5ECA, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF929, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x6717, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF92A, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x6D6A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF92B, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x72FC, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF92C, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x90CE, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF92D, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x4F86, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF92E, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x51B7, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF92F, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x52DE, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF930, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x64C4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF931, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x6AD3, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF932, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x7210, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF933, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x76E7, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF934, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x8001, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF935, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x8606, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF936, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x865C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF937, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x8DEF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF938, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x9732, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF939, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x9B6F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF93A, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x9DFA, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF93B, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x788C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF93C, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x797F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF93D, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x7DA0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF93E, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x83C9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF93F, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x9304, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF940, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x9E7F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF941, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x8AD6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF942, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x58DF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF943, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x5F04, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF944, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x7C60, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF945, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x807E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF946, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x7262, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF947, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x78CA, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF948, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x8CC2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF949, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x96F7, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF94A, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x58D8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF94B, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x5C62, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF94C, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x6A13, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF94D, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x6DDA, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF94E, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x6F0F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF94F, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x7D2F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF950, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x7E37, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF951, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x964B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF952, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x52D2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF953, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x808B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF954, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x51DC, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF955, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x51CC, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF956, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x7A1C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF957, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x7DBE, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF958, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x83F1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF959, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x9675, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF95A, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x8B80, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF95B, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x62CF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF95C, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x6A02, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF95D, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x8AFE, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF95E, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x4E39, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF95F, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x5BE7, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF960, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x6012, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF961, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x7387, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF962, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x7570, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF963, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x5317, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF964, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x78FB, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF965, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x4FBF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF966, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x5FA9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF967, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x4E0D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF968, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x6CCC, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF969, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x6578, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF96A, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x7D22, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF96B, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x53C3, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF96C, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x585E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF96D, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x7701, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF96E, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x8449, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF96F, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x8AAA, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF970, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x6BBA, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF971, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x8FB0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF972, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x6C88, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF973, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x62FE, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF974, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x82E5, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF975, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x63A0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF976, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x7565, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF977, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x4EAE, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF978, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x5169, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF979, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x51C9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF97A, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x6881, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF97B, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x7CE7, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF97C, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x826F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF97D, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x8AD2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF97E, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x91CF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF97F, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x52F5, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF980, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x5442, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF981, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x5973, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF982, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x5EEC, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF983, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x65C5, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF984, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x6FFE, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF985, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x792A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF986, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x95AD, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF987, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x9A6A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF988, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x9E97, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF989, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x9ECE, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF98A, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x529B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF98B, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x66C6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF98C, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x6B77, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF98D, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x8F62, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF98E, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x5E74, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF98F, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x6190, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF990, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x6200, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF991, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x649A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF992, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x6F23, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF993, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x7149, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF994, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x7489, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF995, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x79CA, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF996, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x7DF4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF997, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x806F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF998, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x8F26, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF999, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x84EE, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF99A, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x9023, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF99B, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x934A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF99C, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x5217, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF99D, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x52A3, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF99E, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x54BD, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF99F, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x70C8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF9A0, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x88C2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF9A1, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x8AAA, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF9A2, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x5EC9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF9A3, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x5FF5, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF9A4, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x637B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF9A5, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x6BAE, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF9A6, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x7C3E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF9A7, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x7375, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF9A8, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x4EE4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF9A9, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x56F9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF9AA, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x5BE7, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF9AB, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x5DBA, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF9AC, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x601C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF9AD, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x73B2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF9AE, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x7469, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF9AF, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x7F9A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF9B0, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x8046, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF9B1, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x9234, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF9B2, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x96F6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF9B3, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x9748, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF9B4, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x9818, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF9B5, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x4F8B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF9B6, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x79AE, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF9B7, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x91B4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF9B8, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x96B8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF9B9, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x60E1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF9BA, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x4E86, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF9BB, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x50DA, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF9BC, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x5BEE, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF9BD, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x5C3F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF9BE, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x6599, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF9BF, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x6A02, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF9C0, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x71CE, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF9C1, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x7642, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF9C2, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x84FC, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF9C3, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x907C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF9C4, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x9F8D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF9C5, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x6688, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF9C6, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x962E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF9C7, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x5289, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF9C8, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x677B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF9C9, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x67F3, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF9CA, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x6D41, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF9CB, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x6E9C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF9CC, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x7409, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF9CD, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x7559, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF9CE, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x786B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF9CF, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x7D10, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF9D0, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x985E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF9D1, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x516D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF9D2, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x622E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF9D3, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x9678, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF9D4, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x502B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF9D5, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x5D19, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF9D6, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x6DEA, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF9D7, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x8F2A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF9D8, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x5F8B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF9D9, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x6144, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF9DA, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x6817, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF9DB, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x7387, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF9DC, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x9686, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF9DD, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x5229, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF9DE, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x540F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF9DF, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x5C65, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF9E0, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x6613, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF9E1, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x674E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF9E2, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x68A8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF9E3, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x6CE5, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF9E4, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x7406, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF9E5, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x75E2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF9E6, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x7F79, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF9E7, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x88CF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF9E8, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x88E1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF9E9, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x91CC, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF9EA, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x96E2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF9EB, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x533F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF9EC, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x6EBA, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF9ED, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x541D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF9EE, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x71D0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF9EF, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x7498, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF9F0, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x85FA, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF9F1, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x96A3, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF9F2, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x9C57, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF9F3, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x9E9F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF9F4, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x6797, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF9F5, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x6DCB, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF9F6, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x81E8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF9F7, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x7ACB, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF9F8, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x7B20, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF9F9, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x7C92, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF9FA, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x72C0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF9FB, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x7099, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF9FC, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x8B58, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF9FD, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x4EC0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF9FE, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x8336, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xF9FF, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x523A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA00, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x5207, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA01, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x5EA6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA02, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x62D3, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA03, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x7CD6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA04, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x5B85, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA05, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x6D1E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA06, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x66B4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA07, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x8F3B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA08, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x884C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA09, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x964D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA0A, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x898B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA0B, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x5ED3, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA0C, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x5140, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA0D, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x55C0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA10, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x585A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA12, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x6674, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA15, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x51DE, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA16, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x732A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA17, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x76CA, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA18, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x793C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA19, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x795E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA1A, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x7965, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA1B, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x798F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA1C, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x9756, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA1D, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x7CBE, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA1E, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x7FBD, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA20, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x8612, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA22, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x8AF8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA25, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x9038, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA26, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x90FD, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA2A, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x98EF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA2B, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x98FC, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA2C, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x9928, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA2D, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x9DB4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA2E, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x90DE, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA2F, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x96B7, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA30, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x4FAE, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA31, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x50E7, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA32, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x514D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA33, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x52C9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA34, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x52E4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA35, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x5351, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA36, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x559D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA37, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x5606, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA38, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x5668, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA39, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x5840, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA3A, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x58A8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA3B, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x5C64, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA3C, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x5C6E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA3D, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x6094, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA3E, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x6168, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA3F, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x618E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA40, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x61F2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA41, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x654F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA42, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x65E2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA43, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x6691, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA44, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x6885, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA45, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x6D77, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA46, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x6E1A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA47, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x6F22, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA48, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x716E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA49, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x722B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA4A, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x7422, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA4B, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x7891, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA4C, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x793E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA4D, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x7949, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA4E, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x7948, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA4F, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x7950, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA50, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x7956, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA51, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x795D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA52, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x798D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA53, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x798E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA54, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x7A40, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA55, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x7A81, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA56, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x7BC0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA57, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x7DF4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA58, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x7E09, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA59, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x7E41, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA5A, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x7F72, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA5B, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x8005, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA5C, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x81ED, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA5D, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x8279, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA5E, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x8279, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA5F, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x8457, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA60, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x8910, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA61, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x8996, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA62, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x8B01, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA63, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x8B39, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA64, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x8CD3, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA65, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x8D08, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA66, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x8FB6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA67, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x9038, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA68, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x96E3, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA69, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x97FF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA6A, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x983B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA6B, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x6075, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA6C, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x242EE, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA6D, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x8218, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA70, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x4E26, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA71, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x51B5, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA72, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x5168, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA73, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x4F80, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA74, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x5145, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA75, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x5180, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA76, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x52C7, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA77, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x52FA, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA78, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x559D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA79, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x5555, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA7A, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x5599, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA7B, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x55E2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA7C, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x585A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA7D, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x58B3, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA7E, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x5944, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA7F, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x5954, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA80, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x5A62, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA81, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x5B28, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA82, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x5ED2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA83, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x5ED9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA84, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x5F69, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA85, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x5FAD, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA86, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x60D8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA87, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x614E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA88, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x6108, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA89, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x618E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA8A, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x6160, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA8B, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x61F2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA8C, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x6234, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA8D, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x63C4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA8E, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x641C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA8F, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x6452, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA90, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x6556, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA91, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x6674, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA92, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x6717, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA93, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x671B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA94, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x6756, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA95, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x6B79, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA96, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x6BBA, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA97, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x6D41, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA98, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x6EDB, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA99, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x6ECB, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA9A, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x6F22, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA9B, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x701E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA9C, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x716E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA9D, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x77A7, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA9E, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x7235, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFA9F, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x72AF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFAA0, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x732A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFAA1, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x7471, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFAA2, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x7506, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFAA3, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x753B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFAA4, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x761D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFAA5, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x761F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFAA6, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x76CA, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFAA7, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x76DB, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFAA8, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x76F4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFAA9, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x774A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFAAA, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x7740, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFAAB, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x78CC, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFAAC, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x7AB1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFAAD, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x7BC0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFAAE, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x7C7B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFAAF, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x7D5B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFAB0, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x7DF4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFAB1, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x7F3E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFAB2, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x8005, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFAB3, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x8352, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFAB4, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x83EF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFAB5, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x8779, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFAB6, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x8941, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFAB7, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x8986, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFAB8, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x8996, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFAB9, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x8ABF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFABA, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x8AF8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFABB, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x8ACB, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFABC, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x8B01, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFABD, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x8AFE, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFABE, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x8AED, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFABF, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x8B39, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFAC0, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x8B8A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFAC1, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x8D08, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFAC2, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x8F38, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFAC3, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x9072, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFAC4, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x9199, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFAC5, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x9276, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFAC6, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x967C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFAC7, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x96E3, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFAC8, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x9756, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFAC9, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x97DB, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFACA, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x97FF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFACB, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x980B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFACC, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x983B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFACD, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x9B12, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFACE, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x9F9C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFACF, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x2284A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFAD0, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x22844, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFAD1, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x233D5, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFAD2, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x3B9D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFAD3, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x4018, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFAD4, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x4039, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFAD5, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x25249, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFAD6, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x25CD0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFAD7, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x27ED3, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFAD8, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x9F43, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFAD9, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x9F8E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFB00, CHAR_CATEGORY_LL, DECOMP_TAG_COMPAT,
   {0x0066, 0x0066, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFB01, CHAR_CATEGORY_LL, DECOMP_TAG_COMPAT,
   {0x0066, 0x0069, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFB02, CHAR_CATEGORY_LL, DECOMP_TAG_COMPAT,
   {0x0066, 0x006C, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFB03, CHAR_CATEGORY_LL, DECOMP_TAG_COMPAT,
   {0x0066, 0x0066, 0x0069, 0x0000, 0x0000, 0x0000}},
  {0xFB04, CHAR_CATEGORY_LL, DECOMP_TAG_COMPAT,
   {0x0066, 0x0066, 0x006C, 0x0000, 0x0000, 0x0000}},
  {0xFB05, CHAR_CATEGORY_LL, DECOMP_TAG_COMPAT,
   {0x017F, 0x0074, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFB06, CHAR_CATEGORY_LL, DECOMP_TAG_COMPAT,
   {0x0073, 0x0074, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFB13, CHAR_CATEGORY_LL, DECOMP_TAG_COMPAT,
   {0x0574, 0x0576, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFB14, CHAR_CATEGORY_LL, DECOMP_TAG_COMPAT,
   {0x0574, 0x0565, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFB15, CHAR_CATEGORY_LL, DECOMP_TAG_COMPAT,
   {0x0574, 0x056B, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFB16, CHAR_CATEGORY_LL, DECOMP_TAG_COMPAT,
   {0x057E, 0x0576, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFB17, CHAR_CATEGORY_LL, DECOMP_TAG_COMPAT,
   {0x0574, 0x056D, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFB1D, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x05D9, 0x05B4, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFB1F, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x05F2, 0x05B7, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFB20, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x05E2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFB21, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x05D0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFB22, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x05D3, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFB23, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x05D4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFB24, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x05DB, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFB25, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x05DC, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFB26, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x05DD, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFB27, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x05E8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFB28, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x05EA, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFB29, CHAR_CATEGORY_SM, DECOMP_TAG_FONT,
   {0x002B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFB2A, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x05E9, 0x05C1, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFB2B, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x05E9, 0x05C2, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFB2C, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x05E9, 0x05BC, 0x05C1, 0x0000, 0x0000, 0x0000}},
  {0xFB2D, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x05E9, 0x05BC, 0x05C2, 0x0000, 0x0000, 0x0000}},
  {0xFB2E, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x05D0, 0x05B7, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFB2F, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x05D0, 0x05B8, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFB30, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x05D0, 0x05BC, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFB31, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x05D1, 0x05BC, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFB32, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x05D2, 0x05BC, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFB33, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x05D3, 0x05BC, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFB34, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x05D4, 0x05BC, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFB35, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x05D5, 0x05BC, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFB36, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x05D6, 0x05BC, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFB38, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x05D8, 0x05BC, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFB39, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x05D9, 0x05BC, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFB3A, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x05DA, 0x05BC, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFB3B, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x05DB, 0x05BC, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFB3C, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x05DC, 0x05BC, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFB3E, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x05DE, 0x05BC, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFB40, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x05E0, 0x05BC, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFB41, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x05E1, 0x05BC, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFB43, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x05E3, 0x05BC, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFB44, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x05E4, 0x05BC, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFB46, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x05E6, 0x05BC, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFB47, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x05E7, 0x05BC, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFB48, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x05E8, 0x05BC, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFB49, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x05E9, 0x05BC, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFB4A, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x05EA, 0x05BC, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFB4B, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x05D5, 0x05B9, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFB4C, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x05D1, 0x05BF, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFB4D, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x05DB, 0x05BF, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFB4E, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x05E4, 0x05BF, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFB4F, CHAR_CATEGORY_LO, DECOMP_TAG_COMPAT,
   {0x05D0, 0x05DC, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFB50, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0671, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFB51, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0671, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFB52, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x067B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFB53, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x067B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFB54, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x067B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFB55, CHAR_CATEGORY_LO, DECOMP_TAG_MEDIAL,
   {0x067B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFB56, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x067E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFB57, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x067E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFB58, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x067E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFB59, CHAR_CATEGORY_LO, DECOMP_TAG_MEDIAL,
   {0x067E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFB5A, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0680, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFB5B, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0680, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFB5C, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x0680, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFB5D, CHAR_CATEGORY_LO, DECOMP_TAG_MEDIAL,
   {0x0680, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFB5E, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x067A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFB5F, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x067A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFB60, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x067A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFB61, CHAR_CATEGORY_LO, DECOMP_TAG_MEDIAL,
   {0x067A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFB62, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x067F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFB63, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x067F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFB64, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x067F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFB65, CHAR_CATEGORY_LO, DECOMP_TAG_MEDIAL,
   {0x067F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFB66, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0679, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFB67, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0679, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFB68, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x0679, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFB69, CHAR_CATEGORY_LO, DECOMP_TAG_MEDIAL,
   {0x0679, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFB6A, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x06A4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFB6B, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x06A4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFB6C, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x06A4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFB6D, CHAR_CATEGORY_LO, DECOMP_TAG_MEDIAL,
   {0x06A4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFB6E, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x06A6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFB6F, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x06A6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFB70, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x06A6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFB71, CHAR_CATEGORY_LO, DECOMP_TAG_MEDIAL,
   {0x06A6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFB72, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0684, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFB73, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0684, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFB74, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x0684, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFB75, CHAR_CATEGORY_LO, DECOMP_TAG_MEDIAL,
   {0x0684, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFB76, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0683, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFB77, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0683, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFB78, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x0683, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFB79, CHAR_CATEGORY_LO, DECOMP_TAG_MEDIAL,
   {0x0683, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFB7A, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0686, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFB7B, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0686, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFB7C, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x0686, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFB7D, CHAR_CATEGORY_LO, DECOMP_TAG_MEDIAL,
   {0x0686, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFB7E, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0687, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFB7F, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0687, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFB80, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x0687, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFB81, CHAR_CATEGORY_LO, DECOMP_TAG_MEDIAL,
   {0x0687, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFB82, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x068D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFB83, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x068D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFB84, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x068C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFB85, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x068C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFB86, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x068E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFB87, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x068E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFB88, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0688, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFB89, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0688, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFB8A, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0698, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFB8B, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0698, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFB8C, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0691, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFB8D, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0691, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFB8E, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x06A9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFB8F, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x06A9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFB90, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x06A9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFB91, CHAR_CATEGORY_LO, DECOMP_TAG_MEDIAL,
   {0x06A9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFB92, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x06AF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFB93, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x06AF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFB94, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x06AF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFB95, CHAR_CATEGORY_LO, DECOMP_TAG_MEDIAL,
   {0x06AF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFB96, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x06B3, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFB97, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x06B3, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFB98, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x06B3, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFB99, CHAR_CATEGORY_LO, DECOMP_TAG_MEDIAL,
   {0x06B3, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFB9A, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x06B1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFB9B, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x06B1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFB9C, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x06B1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFB9D, CHAR_CATEGORY_LO, DECOMP_TAG_MEDIAL,
   {0x06B1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFB9E, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x06BA, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFB9F, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x06BA, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFBA0, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x06BB, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFBA1, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x06BB, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFBA2, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x06BB, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFBA3, CHAR_CATEGORY_LO, DECOMP_TAG_MEDIAL,
   {0x06BB, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFBA4, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x06C0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFBA5, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x06C0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFBA6, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x06C1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFBA7, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x06C1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFBA8, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x06C1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFBA9, CHAR_CATEGORY_LO, DECOMP_TAG_MEDIAL,
   {0x06C1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFBAA, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x06BE, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFBAB, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x06BE, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFBAC, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x06BE, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFBAD, CHAR_CATEGORY_LO, DECOMP_TAG_MEDIAL,
   {0x06BE, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFBAE, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x06D2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFBAF, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x06D2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFBB0, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x06D3, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFBB1, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x06D3, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFBD3, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x06AD, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFBD4, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x06AD, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFBD5, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x06AD, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFBD6, CHAR_CATEGORY_LO, DECOMP_TAG_MEDIAL,
   {0x06AD, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFBD7, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x06C7, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFBD8, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x06C7, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFBD9, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x06C6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFBDA, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x06C6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFBDB, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x06C8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFBDC, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x06C8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFBDD, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0677, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFBDE, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x06CB, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFBDF, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x06CB, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFBE0, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x06C5, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFBE1, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x06C5, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFBE2, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x06C9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFBE3, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x06C9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFBE4, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x06D0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFBE5, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x06D0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFBE6, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x06D0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFBE7, CHAR_CATEGORY_LO, DECOMP_TAG_MEDIAL,
   {0x06D0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFBE8, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x0649, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFBE9, CHAR_CATEGORY_LO, DECOMP_TAG_MEDIAL,
   {0x0649, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFBEA, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0626, 0x0627, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFBEB, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0626, 0x0627, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFBEC, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0626, 0x06D5, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFBED, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0626, 0x06D5, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFBEE, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0626, 0x0648, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFBEF, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0626, 0x0648, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFBF0, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0626, 0x06C7, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFBF1, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0626, 0x06C7, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFBF2, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0626, 0x06C6, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFBF3, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0626, 0x06C6, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFBF4, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0626, 0x06C8, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFBF5, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0626, 0x06C8, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFBF6, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0626, 0x06D0, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFBF7, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0626, 0x06D0, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFBF8, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x0626, 0x06D0, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFBF9, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0626, 0x0649, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFBFA, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0626, 0x0649, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFBFB, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x0626, 0x0649, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFBFC, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x06CC, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFBFD, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x06CC, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFBFE, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x06CC, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFBFF, CHAR_CATEGORY_LO, DECOMP_TAG_MEDIAL,
   {0x06CC, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC00, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0626, 0x062C, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC01, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0626, 0x062D, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC02, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0626, 0x0645, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC03, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0626, 0x0649, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC04, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0626, 0x064A, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC05, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0628, 0x062C, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC06, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0628, 0x062D, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC07, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0628, 0x062E, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC08, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0628, 0x0645, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC09, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0628, 0x0649, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC0A, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0628, 0x064A, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC0B, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x062A, 0x062C, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC0C, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x062A, 0x062D, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC0D, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x062A, 0x062E, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC0E, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x062A, 0x0645, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC0F, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x062A, 0x0649, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC10, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x062A, 0x064A, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC11, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x062B, 0x062C, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC12, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x062B, 0x0645, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC13, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x062B, 0x0649, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC14, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x062B, 0x064A, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC15, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x062C, 0x062D, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC16, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x062C, 0x0645, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC17, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x062D, 0x062C, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC18, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x062D, 0x0645, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC19, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x062E, 0x062C, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC1A, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x062E, 0x062D, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC1B, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x062E, 0x0645, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC1C, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0633, 0x062C, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC1D, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0633, 0x062D, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC1E, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0633, 0x062E, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC1F, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0633, 0x0645, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC20, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0635, 0x062D, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC21, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0635, 0x0645, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC22, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0636, 0x062C, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC23, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0636, 0x062D, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC24, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0636, 0x062E, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC25, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0636, 0x0645, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC26, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0637, 0x062D, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC27, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0637, 0x0645, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC28, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0638, 0x0645, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC29, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0639, 0x062C, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC2A, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0639, 0x0645, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC2B, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x063A, 0x062C, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC2C, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x063A, 0x0645, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC2D, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0641, 0x062C, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC2E, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0641, 0x062D, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC2F, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0641, 0x062E, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC30, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0641, 0x0645, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC31, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0641, 0x0649, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC32, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0641, 0x064A, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC33, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0642, 0x062D, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC34, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0642, 0x0645, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC35, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0642, 0x0649, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC36, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0642, 0x064A, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC37, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0643, 0x0627, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC38, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0643, 0x062C, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC39, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0643, 0x062D, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC3A, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0643, 0x062E, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC3B, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0643, 0x0644, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC3C, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0643, 0x0645, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC3D, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0643, 0x0649, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC3E, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0643, 0x064A, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC3F, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0644, 0x062C, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC40, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0644, 0x062D, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC41, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0644, 0x062E, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC42, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0644, 0x0645, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC43, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0644, 0x0649, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC44, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0644, 0x064A, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC45, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0645, 0x062C, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC46, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0645, 0x062D, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC47, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0645, 0x062E, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC48, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0645, 0x0645, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC49, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0645, 0x0649, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC4A, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0645, 0x064A, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC4B, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0646, 0x062C, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC4C, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0646, 0x062D, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC4D, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0646, 0x062E, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC4E, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0646, 0x0645, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC4F, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0646, 0x0649, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC50, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0646, 0x064A, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC51, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0647, 0x062C, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC52, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0647, 0x0645, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC53, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0647, 0x0649, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC54, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0647, 0x064A, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC55, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x064A, 0x062C, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC56, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x064A, 0x062D, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC57, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x064A, 0x062E, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC58, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x064A, 0x0645, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC59, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x064A, 0x0649, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC5A, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x064A, 0x064A, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC5B, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0630, 0x0670, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC5C, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0631, 0x0670, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC5D, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0649, 0x0670, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC5E, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0020, 0x064C, 0x0651, 0x0000, 0x0000, 0x0000}},
  {0xFC5F, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0020, 0x064D, 0x0651, 0x0000, 0x0000, 0x0000}},
  {0xFC60, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0020, 0x064E, 0x0651, 0x0000, 0x0000, 0x0000}},
  {0xFC61, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0020, 0x064F, 0x0651, 0x0000, 0x0000, 0x0000}},
  {0xFC62, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0020, 0x0650, 0x0651, 0x0000, 0x0000, 0x0000}},
  {0xFC63, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0020, 0x0651, 0x0670, 0x0000, 0x0000, 0x0000}},
  {0xFC64, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0626, 0x0631, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC65, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0626, 0x0632, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC66, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0626, 0x0645, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC67, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0626, 0x0646, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC68, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0626, 0x0649, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC69, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0626, 0x064A, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC6A, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0628, 0x0631, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC6B, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0628, 0x0632, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC6C, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0628, 0x0645, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC6D, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0628, 0x0646, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC6E, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0628, 0x0649, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC6F, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0628, 0x064A, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC70, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x062A, 0x0631, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC71, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x062A, 0x0632, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC72, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x062A, 0x0645, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC73, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x062A, 0x0646, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC74, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x062A, 0x0649, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC75, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x062A, 0x064A, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC76, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x062B, 0x0631, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC77, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x062B, 0x0632, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC78, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x062B, 0x0645, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC79, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x062B, 0x0646, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC7A, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x062B, 0x0649, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC7B, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x062B, 0x064A, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC7C, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0641, 0x0649, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC7D, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0641, 0x064A, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC7E, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0642, 0x0649, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC7F, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0642, 0x064A, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC80, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0643, 0x0627, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC81, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0643, 0x0644, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC82, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0643, 0x0645, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC83, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0643, 0x0649, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC84, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0643, 0x064A, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC85, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0644, 0x0645, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC86, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0644, 0x0649, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC87, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0644, 0x064A, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC88, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0645, 0x0627, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC89, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0645, 0x0645, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC8A, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0646, 0x0631, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC8B, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0646, 0x0632, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC8C, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0646, 0x0645, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC8D, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0646, 0x0646, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC8E, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0646, 0x0649, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC8F, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0646, 0x064A, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC90, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0649, 0x0670, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC91, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x064A, 0x0631, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC92, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x064A, 0x0632, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC93, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x064A, 0x0645, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC94, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x064A, 0x0646, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC95, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x064A, 0x0649, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC96, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x064A, 0x064A, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC97, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x0626, 0x062C, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC98, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x0626, 0x062D, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC99, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x0626, 0x062E, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC9A, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x0626, 0x0645, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC9B, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x0626, 0x0647, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC9C, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x0628, 0x062C, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC9D, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x0628, 0x062D, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC9E, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x0628, 0x062E, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFC9F, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x0628, 0x0645, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFCA0, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x0628, 0x0647, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFCA1, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x062A, 0x062C, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFCA2, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x062A, 0x062D, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFCA3, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x062A, 0x062E, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFCA4, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x062A, 0x0645, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFCA5, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x062A, 0x0647, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFCA6, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x062B, 0x0645, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFCA7, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x062C, 0x062D, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFCA8, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x062C, 0x0645, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFCA9, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x062D, 0x062C, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFCAA, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x062D, 0x0645, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFCAB, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x062E, 0x062C, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFCAC, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x062E, 0x0645, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFCAD, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x0633, 0x062C, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFCAE, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x0633, 0x062D, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFCAF, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x0633, 0x062E, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFCB0, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x0633, 0x0645, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFCB1, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x0635, 0x062D, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFCB2, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x0635, 0x062E, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFCB3, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x0635, 0x0645, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFCB4, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x0636, 0x062C, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFCB5, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x0636, 0x062D, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFCB6, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x0636, 0x062E, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFCB7, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x0636, 0x0645, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFCB8, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x0637, 0x062D, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFCB9, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x0638, 0x0645, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFCBA, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x0639, 0x062C, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFCBB, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x0639, 0x0645, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFCBC, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x063A, 0x062C, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFCBD, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x063A, 0x0645, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFCBE, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x0641, 0x062C, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFCBF, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x0641, 0x062D, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFCC0, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x0641, 0x062E, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFCC1, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x0641, 0x0645, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFCC2, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x0642, 0x062D, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFCC3, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x0642, 0x0645, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFCC4, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x0643, 0x062C, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFCC5, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x0643, 0x062D, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFCC6, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x0643, 0x062E, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFCC7, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x0643, 0x0644, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFCC8, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x0643, 0x0645, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFCC9, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x0644, 0x062C, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFCCA, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x0644, 0x062D, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFCCB, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x0644, 0x062E, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFCCC, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x0644, 0x0645, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFCCD, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x0644, 0x0647, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFCCE, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x0645, 0x062C, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFCCF, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x0645, 0x062D, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFCD0, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x0645, 0x062E, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFCD1, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x0645, 0x0645, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFCD2, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x0646, 0x062C, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFCD3, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x0646, 0x062D, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFCD4, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x0646, 0x062E, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFCD5, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x0646, 0x0645, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFCD6, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x0646, 0x0647, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFCD7, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x0647, 0x062C, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFCD8, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x0647, 0x0645, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFCD9, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x0647, 0x0670, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFCDA, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x064A, 0x062C, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFCDB, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x064A, 0x062D, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFCDC, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x064A, 0x062E, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFCDD, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x064A, 0x0645, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFCDE, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x064A, 0x0647, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFCDF, CHAR_CATEGORY_LO, DECOMP_TAG_MEDIAL,
   {0x0626, 0x0645, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFCE0, CHAR_CATEGORY_LO, DECOMP_TAG_MEDIAL,
   {0x0626, 0x0647, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFCE1, CHAR_CATEGORY_LO, DECOMP_TAG_MEDIAL,
   {0x0628, 0x0645, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFCE2, CHAR_CATEGORY_LO, DECOMP_TAG_MEDIAL,
   {0x0628, 0x0647, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFCE3, CHAR_CATEGORY_LO, DECOMP_TAG_MEDIAL,
   {0x062A, 0x0645, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFCE4, CHAR_CATEGORY_LO, DECOMP_TAG_MEDIAL,
   {0x062A, 0x0647, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFCE5, CHAR_CATEGORY_LO, DECOMP_TAG_MEDIAL,
   {0x062B, 0x0645, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFCE6, CHAR_CATEGORY_LO, DECOMP_TAG_MEDIAL,
   {0x062B, 0x0647, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFCE7, CHAR_CATEGORY_LO, DECOMP_TAG_MEDIAL,
   {0x0633, 0x0645, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFCE8, CHAR_CATEGORY_LO, DECOMP_TAG_MEDIAL,
   {0x0633, 0x0647, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFCE9, CHAR_CATEGORY_LO, DECOMP_TAG_MEDIAL,
   {0x0634, 0x0645, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFCEA, CHAR_CATEGORY_LO, DECOMP_TAG_MEDIAL,
   {0x0634, 0x0647, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFCEB, CHAR_CATEGORY_LO, DECOMP_TAG_MEDIAL,
   {0x0643, 0x0644, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFCEC, CHAR_CATEGORY_LO, DECOMP_TAG_MEDIAL,
   {0x0643, 0x0645, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFCED, CHAR_CATEGORY_LO, DECOMP_TAG_MEDIAL,
   {0x0644, 0x0645, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFCEE, CHAR_CATEGORY_LO, DECOMP_TAG_MEDIAL,
   {0x0646, 0x0645, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFCEF, CHAR_CATEGORY_LO, DECOMP_TAG_MEDIAL,
   {0x0646, 0x0647, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFCF0, CHAR_CATEGORY_LO, DECOMP_TAG_MEDIAL,
   {0x064A, 0x0645, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFCF1, CHAR_CATEGORY_LO, DECOMP_TAG_MEDIAL,
   {0x064A, 0x0647, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFCF2, CHAR_CATEGORY_LO, DECOMP_TAG_MEDIAL,
   {0x0640, 0x064E, 0x0651, 0x0000, 0x0000, 0x0000}},
  {0xFCF3, CHAR_CATEGORY_LO, DECOMP_TAG_MEDIAL,
   {0x0640, 0x064F, 0x0651, 0x0000, 0x0000, 0x0000}},
  {0xFCF4, CHAR_CATEGORY_LO, DECOMP_TAG_MEDIAL,
   {0x0640, 0x0650, 0x0651, 0x0000, 0x0000, 0x0000}},
  {0xFCF5, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0637, 0x0649, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFCF6, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0637, 0x064A, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFCF7, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0639, 0x0649, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFCF8, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0639, 0x064A, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFCF9, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x063A, 0x0649, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFCFA, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x063A, 0x064A, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFCFB, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0633, 0x0649, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFCFC, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0633, 0x064A, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFCFD, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0634, 0x0649, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFCFE, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0634, 0x064A, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFCFF, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x062D, 0x0649, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFD00, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x062D, 0x064A, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFD01, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x062C, 0x0649, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFD02, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x062C, 0x064A, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFD03, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x062E, 0x0649, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFD04, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x062E, 0x064A, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFD05, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0635, 0x0649, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFD06, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0635, 0x064A, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFD07, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0636, 0x0649, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFD08, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0636, 0x064A, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFD09, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0634, 0x062C, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFD0A, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0634, 0x062D, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFD0B, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0634, 0x062E, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFD0C, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0634, 0x0645, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFD0D, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0634, 0x0631, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFD0E, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0633, 0x0631, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFD0F, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0635, 0x0631, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFD10, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0636, 0x0631, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFD11, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0637, 0x0649, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFD12, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0637, 0x064A, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFD13, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0639, 0x0649, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFD14, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0639, 0x064A, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFD15, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x063A, 0x0649, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFD16, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x063A, 0x064A, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFD17, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0633, 0x0649, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFD18, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0633, 0x064A, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFD19, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0634, 0x0649, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFD1A, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0634, 0x064A, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFD1B, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x062D, 0x0649, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFD1C, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x062D, 0x064A, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFD1D, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x062C, 0x0649, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFD1E, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x062C, 0x064A, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFD1F, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x062E, 0x0649, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFD20, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x062E, 0x064A, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFD21, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0635, 0x0649, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFD22, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0635, 0x064A, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFD23, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0636, 0x0649, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFD24, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0636, 0x064A, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFD25, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0634, 0x062C, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFD26, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0634, 0x062D, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFD27, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0634, 0x062E, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFD28, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0634, 0x0645, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFD29, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0634, 0x0631, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFD2A, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0633, 0x0631, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFD2B, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0635, 0x0631, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFD2C, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0636, 0x0631, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFD2D, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x0634, 0x062C, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFD2E, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x0634, 0x062D, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFD2F, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x0634, 0x062E, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFD30, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x0634, 0x0645, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFD31, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x0633, 0x0647, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFD32, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x0634, 0x0647, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFD33, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x0637, 0x0645, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFD34, CHAR_CATEGORY_LO, DECOMP_TAG_MEDIAL,
   {0x0633, 0x062C, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFD35, CHAR_CATEGORY_LO, DECOMP_TAG_MEDIAL,
   {0x0633, 0x062D, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFD36, CHAR_CATEGORY_LO, DECOMP_TAG_MEDIAL,
   {0x0633, 0x062E, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFD37, CHAR_CATEGORY_LO, DECOMP_TAG_MEDIAL,
   {0x0634, 0x062C, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFD38, CHAR_CATEGORY_LO, DECOMP_TAG_MEDIAL,
   {0x0634, 0x062D, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFD39, CHAR_CATEGORY_LO, DECOMP_TAG_MEDIAL,
   {0x0634, 0x062E, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFD3A, CHAR_CATEGORY_LO, DECOMP_TAG_MEDIAL,
   {0x0637, 0x0645, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFD3B, CHAR_CATEGORY_LO, DECOMP_TAG_MEDIAL,
   {0x0638, 0x0645, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFD3C, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0627, 0x064B, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFD3D, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0627, 0x064B, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFD50, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x062A, 0x062C, 0x0645, 0x0000, 0x0000, 0x0000}},
  {0xFD51, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x062A, 0x062D, 0x062C, 0x0000, 0x0000, 0x0000}},
  {0xFD52, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x062A, 0x062D, 0x062C, 0x0000, 0x0000, 0x0000}},
  {0xFD53, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x062A, 0x062D, 0x0645, 0x0000, 0x0000, 0x0000}},
  {0xFD54, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x062A, 0x062E, 0x0645, 0x0000, 0x0000, 0x0000}},
  {0xFD55, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x062A, 0x0645, 0x062C, 0x0000, 0x0000, 0x0000}},
  {0xFD56, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x062A, 0x0645, 0x062D, 0x0000, 0x0000, 0x0000}},
  {0xFD57, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x062A, 0x0645, 0x062E, 0x0000, 0x0000, 0x0000}},
  {0xFD58, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x062C, 0x0645, 0x062D, 0x0000, 0x0000, 0x0000}},
  {0xFD59, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x062C, 0x0645, 0x062D, 0x0000, 0x0000, 0x0000}},
  {0xFD5A, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x062D, 0x0645, 0x064A, 0x0000, 0x0000, 0x0000}},
  {0xFD5B, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x062D, 0x0645, 0x0649, 0x0000, 0x0000, 0x0000}},
  {0xFD5C, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x0633, 0x062D, 0x062C, 0x0000, 0x0000, 0x0000}},
  {0xFD5D, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x0633, 0x062C, 0x062D, 0x0000, 0x0000, 0x0000}},
  {0xFD5E, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0633, 0x062C, 0x0649, 0x0000, 0x0000, 0x0000}},
  {0xFD5F, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0633, 0x0645, 0x062D, 0x0000, 0x0000, 0x0000}},
  {0xFD60, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x0633, 0x0645, 0x062D, 0x0000, 0x0000, 0x0000}},
  {0xFD61, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x0633, 0x0645, 0x062C, 0x0000, 0x0000, 0x0000}},
  {0xFD62, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0633, 0x0645, 0x0645, 0x0000, 0x0000, 0x0000}},
  {0xFD63, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x0633, 0x0645, 0x0645, 0x0000, 0x0000, 0x0000}},
  {0xFD64, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0635, 0x062D, 0x062D, 0x0000, 0x0000, 0x0000}},
  {0xFD65, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x0635, 0x062D, 0x062D, 0x0000, 0x0000, 0x0000}},
  {0xFD66, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0635, 0x0645, 0x0645, 0x0000, 0x0000, 0x0000}},
  {0xFD67, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0634, 0x062D, 0x0645, 0x0000, 0x0000, 0x0000}},
  {0xFD68, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x0634, 0x062D, 0x0645, 0x0000, 0x0000, 0x0000}},
  {0xFD69, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0634, 0x062C, 0x064A, 0x0000, 0x0000, 0x0000}},
  {0xFD6A, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0634, 0x0645, 0x062E, 0x0000, 0x0000, 0x0000}},
  {0xFD6B, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x0634, 0x0645, 0x062E, 0x0000, 0x0000, 0x0000}},
  {0xFD6C, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0634, 0x0645, 0x0645, 0x0000, 0x0000, 0x0000}},
  {0xFD6D, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x0634, 0x0645, 0x0645, 0x0000, 0x0000, 0x0000}},
  {0xFD6E, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0636, 0x062D, 0x0649, 0x0000, 0x0000, 0x0000}},
  {0xFD6F, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0636, 0x062E, 0x0645, 0x0000, 0x0000, 0x0000}},
  {0xFD70, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x0636, 0x062E, 0x0645, 0x0000, 0x0000, 0x0000}},
  {0xFD71, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0637, 0x0645, 0x062D, 0x0000, 0x0000, 0x0000}},
  {0xFD72, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x0637, 0x0645, 0x062D, 0x0000, 0x0000, 0x0000}},
  {0xFD73, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x0637, 0x0645, 0x0645, 0x0000, 0x0000, 0x0000}},
  {0xFD74, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0637, 0x0645, 0x064A, 0x0000, 0x0000, 0x0000}},
  {0xFD75, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0639, 0x062C, 0x0645, 0x0000, 0x0000, 0x0000}},
  {0xFD76, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0639, 0x0645, 0x0645, 0x0000, 0x0000, 0x0000}},
  {0xFD77, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x0639, 0x0645, 0x0645, 0x0000, 0x0000, 0x0000}},
  {0xFD78, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0639, 0x0645, 0x0649, 0x0000, 0x0000, 0x0000}},
  {0xFD79, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x063A, 0x0645, 0x0645, 0x0000, 0x0000, 0x0000}},
  {0xFD7A, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x063A, 0x0645, 0x064A, 0x0000, 0x0000, 0x0000}},
  {0xFD7B, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x063A, 0x0645, 0x0649, 0x0000, 0x0000, 0x0000}},
  {0xFD7C, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0641, 0x062E, 0x0645, 0x0000, 0x0000, 0x0000}},
  {0xFD7D, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x0641, 0x062E, 0x0645, 0x0000, 0x0000, 0x0000}},
  {0xFD7E, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0642, 0x0645, 0x062D, 0x0000, 0x0000, 0x0000}},
  {0xFD7F, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0642, 0x0645, 0x0645, 0x0000, 0x0000, 0x0000}},
  {0xFD80, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0644, 0x062D, 0x0645, 0x0000, 0x0000, 0x0000}},
  {0xFD81, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0644, 0x062D, 0x064A, 0x0000, 0x0000, 0x0000}},
  {0xFD82, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0644, 0x062D, 0x0649, 0x0000, 0x0000, 0x0000}},
  {0xFD83, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x0644, 0x062C, 0x062C, 0x0000, 0x0000, 0x0000}},
  {0xFD84, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0644, 0x062C, 0x062C, 0x0000, 0x0000, 0x0000}},
  {0xFD85, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0644, 0x062E, 0x0645, 0x0000, 0x0000, 0x0000}},
  {0xFD86, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x0644, 0x062E, 0x0645, 0x0000, 0x0000, 0x0000}},
  {0xFD87, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0644, 0x0645, 0x062D, 0x0000, 0x0000, 0x0000}},
  {0xFD88, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x0644, 0x0645, 0x062D, 0x0000, 0x0000, 0x0000}},
  {0xFD89, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x0645, 0x062D, 0x062C, 0x0000, 0x0000, 0x0000}},
  {0xFD8A, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x0645, 0x062D, 0x0645, 0x0000, 0x0000, 0x0000}},
  {0xFD8B, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0645, 0x062D, 0x064A, 0x0000, 0x0000, 0x0000}},
  {0xFD8C, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x0645, 0x062C, 0x062D, 0x0000, 0x0000, 0x0000}},
  {0xFD8D, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x0645, 0x062C, 0x0645, 0x0000, 0x0000, 0x0000}},
  {0xFD8E, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x0645, 0x062E, 0x062C, 0x0000, 0x0000, 0x0000}},
  {0xFD8F, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x0645, 0x062E, 0x0645, 0x0000, 0x0000, 0x0000}},
  {0xFD92, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x0645, 0x062C, 0x062E, 0x0000, 0x0000, 0x0000}},
  {0xFD93, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x0647, 0x0645, 0x062C, 0x0000, 0x0000, 0x0000}},
  {0xFD94, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x0647, 0x0645, 0x0645, 0x0000, 0x0000, 0x0000}},
  {0xFD95, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x0646, 0x062D, 0x0645, 0x0000, 0x0000, 0x0000}},
  {0xFD96, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0646, 0x062D, 0x0649, 0x0000, 0x0000, 0x0000}},
  {0xFD97, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0646, 0x062C, 0x0645, 0x0000, 0x0000, 0x0000}},
  {0xFD98, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x0646, 0x062C, 0x0645, 0x0000, 0x0000, 0x0000}},
  {0xFD99, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0646, 0x062C, 0x0649, 0x0000, 0x0000, 0x0000}},
  {0xFD9A, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0646, 0x0645, 0x064A, 0x0000, 0x0000, 0x0000}},
  {0xFD9B, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0646, 0x0645, 0x0649, 0x0000, 0x0000, 0x0000}},
  {0xFD9C, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x064A, 0x0645, 0x0645, 0x0000, 0x0000, 0x0000}},
  {0xFD9D, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x064A, 0x0645, 0x0645, 0x0000, 0x0000, 0x0000}},
  {0xFD9E, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0628, 0x062E, 0x064A, 0x0000, 0x0000, 0x0000}},
  {0xFD9F, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x062A, 0x062C, 0x064A, 0x0000, 0x0000, 0x0000}},
  {0xFDA0, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x062A, 0x062C, 0x0649, 0x0000, 0x0000, 0x0000}},
  {0xFDA1, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x062A, 0x062E, 0x064A, 0x0000, 0x0000, 0x0000}},
  {0xFDA2, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x062A, 0x062E, 0x0649, 0x0000, 0x0000, 0x0000}},
  {0xFDA3, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x062A, 0x0645, 0x064A, 0x0000, 0x0000, 0x0000}},
  {0xFDA4, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x062A, 0x0645, 0x0649, 0x0000, 0x0000, 0x0000}},
  {0xFDA5, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x062C, 0x0645, 0x064A, 0x0000, 0x0000, 0x0000}},
  {0xFDA6, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x062C, 0x062D, 0x0649, 0x0000, 0x0000, 0x0000}},
  {0xFDA7, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x062C, 0x0645, 0x0649, 0x0000, 0x0000, 0x0000}},
  {0xFDA8, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0633, 0x062E, 0x0649, 0x0000, 0x0000, 0x0000}},
  {0xFDA9, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0635, 0x062D, 0x064A, 0x0000, 0x0000, 0x0000}},
  {0xFDAA, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0634, 0x062D, 0x064A, 0x0000, 0x0000, 0x0000}},
  {0xFDAB, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0636, 0x062D, 0x064A, 0x0000, 0x0000, 0x0000}},
  {0xFDAC, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0644, 0x062C, 0x064A, 0x0000, 0x0000, 0x0000}},
  {0xFDAD, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0644, 0x0645, 0x064A, 0x0000, 0x0000, 0x0000}},
  {0xFDAE, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x064A, 0x062D, 0x064A, 0x0000, 0x0000, 0x0000}},
  {0xFDAF, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x064A, 0x062C, 0x064A, 0x0000, 0x0000, 0x0000}},
  {0xFDB0, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x064A, 0x0645, 0x064A, 0x0000, 0x0000, 0x0000}},
  {0xFDB1, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0645, 0x0645, 0x064A, 0x0000, 0x0000, 0x0000}},
  {0xFDB2, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0642, 0x0645, 0x064A, 0x0000, 0x0000, 0x0000}},
  {0xFDB3, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0646, 0x062D, 0x064A, 0x0000, 0x0000, 0x0000}},
  {0xFDB4, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x0642, 0x0645, 0x062D, 0x0000, 0x0000, 0x0000}},
  {0xFDB5, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x0644, 0x062D, 0x0645, 0x0000, 0x0000, 0x0000}},
  {0xFDB6, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0639, 0x0645, 0x064A, 0x0000, 0x0000, 0x0000}},
  {0xFDB7, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0643, 0x0645, 0x064A, 0x0000, 0x0000, 0x0000}},
  {0xFDB8, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x0646, 0x062C, 0x062D, 0x0000, 0x0000, 0x0000}},
  {0xFDB9, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0645, 0x062E, 0x064A, 0x0000, 0x0000, 0x0000}},
  {0xFDBA, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x0644, 0x062C, 0x0645, 0x0000, 0x0000, 0x0000}},
  {0xFDBB, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0643, 0x0645, 0x0645, 0x0000, 0x0000, 0x0000}},
  {0xFDBC, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0644, 0x062C, 0x0645, 0x0000, 0x0000, 0x0000}},
  {0xFDBD, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0646, 0x062C, 0x062D, 0x0000, 0x0000, 0x0000}},
  {0xFDBE, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x062C, 0x062D, 0x064A, 0x0000, 0x0000, 0x0000}},
  {0xFDBF, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x062D, 0x062C, 0x064A, 0x0000, 0x0000, 0x0000}},
  {0xFDC0, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0645, 0x062C, 0x064A, 0x0000, 0x0000, 0x0000}},
  {0xFDC1, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0641, 0x0645, 0x064A, 0x0000, 0x0000, 0x0000}},
  {0xFDC2, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0628, 0x062D, 0x064A, 0x0000, 0x0000, 0x0000}},
  {0xFDC3, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x0643, 0x0645, 0x0645, 0x0000, 0x0000, 0x0000}},
  {0xFDC4, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x0639, 0x062C, 0x0645, 0x0000, 0x0000, 0x0000}},
  {0xFDC5, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x0635, 0x0645, 0x0645, 0x0000, 0x0000, 0x0000}},
  {0xFDC6, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0633, 0x062E, 0x064A, 0x0000, 0x0000, 0x0000}},
  {0xFDC7, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0646, 0x062C, 0x064A, 0x0000, 0x0000, 0x0000}},
  {0xFDF0, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0635, 0x0644, 0x06D2, 0x0000, 0x0000, 0x0000}},
  {0xFDF1, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0642, 0x0644, 0x06D2, 0x0000, 0x0000, 0x0000}},
  {0xFDF2, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0627, 0x0644, 0x0644, 0x0647, 0x0000, 0x0000}},
  {0xFDF3, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0627, 0x0643, 0x0628, 0x0631, 0x0000, 0x0000}},
  {0xFDF4, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0645, 0x062D, 0x0645, 0x062F, 0x0000, 0x0000}},
  {0xFDF5, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0635, 0x0644, 0x0639, 0x0645, 0x0000, 0x0000}},
  {0xFDF6, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0631, 0x0633, 0x0648, 0x0644, 0x0000, 0x0000}},
  {0xFDF7, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0639, 0x0644, 0x064A, 0x0647, 0x0000, 0x0000}},
  {0xFDF8, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0648, 0x0633, 0x0644, 0x0645, 0x0000, 0x0000}},
  {0xFDF9, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0635, 0x0644, 0x0649, 0x0000, 0x0000, 0x0000}},
  {0xFDFA, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0635, 0x0644, 0x0649, 0x0020, 0x0627, 0x0644}},
  {0xFDFB, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x062C, 0x0644, 0x0020, 0x062C, 0x0644, 0x0627}},
  {0xFDFC, CHAR_CATEGORY_SC, DECOMP_TAG_ISOLATED,
   {0x0631, 0x06CC, 0x0627, 0x0644, 0x0000, 0x0000}},
  {0xFE10, CHAR_CATEGORY_PO, DECOMP_TAG_VERTICAL,
   {0x002C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFE11, CHAR_CATEGORY_PO, DECOMP_TAG_VERTICAL,
   {0x3001, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFE12, CHAR_CATEGORY_PO, DECOMP_TAG_VERTICAL,
   {0x3002, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFE13, CHAR_CATEGORY_PO, DECOMP_TAG_VERTICAL,
   {0x003A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFE14, CHAR_CATEGORY_PO, DECOMP_TAG_VERTICAL,
   {0x003B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFE15, CHAR_CATEGORY_PO, DECOMP_TAG_VERTICAL,
   {0x0021, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFE16, CHAR_CATEGORY_PO, DECOMP_TAG_VERTICAL,
   {0x003F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFE17, CHAR_CATEGORY_PS, DECOMP_TAG_VERTICAL,
   {0x3016, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFE18, CHAR_CATEGORY_PE, DECOMP_TAG_VERTICAL,
   {0x3017, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFE19, CHAR_CATEGORY_PO, DECOMP_TAG_VERTICAL,
   {0x2026, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFE30, CHAR_CATEGORY_PO, DECOMP_TAG_VERTICAL,
   {0x2025, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFE31, CHAR_CATEGORY_PD, DECOMP_TAG_VERTICAL,
   {0x2014, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFE32, CHAR_CATEGORY_PD, DECOMP_TAG_VERTICAL,
   {0x2013, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFE33, CHAR_CATEGORY_PC, DECOMP_TAG_VERTICAL,
   {0x005F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFE34, CHAR_CATEGORY_PC, DECOMP_TAG_VERTICAL,
   {0x005F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFE35, CHAR_CATEGORY_PS, DECOMP_TAG_VERTICAL,
   {0x0028, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFE36, CHAR_CATEGORY_PE, DECOMP_TAG_VERTICAL,
   {0x0029, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFE37, CHAR_CATEGORY_PS, DECOMP_TAG_VERTICAL,
   {0x007B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFE38, CHAR_CATEGORY_PE, DECOMP_TAG_VERTICAL,
   {0x007D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFE39, CHAR_CATEGORY_PS, DECOMP_TAG_VERTICAL,
   {0x3014, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFE3A, CHAR_CATEGORY_PE, DECOMP_TAG_VERTICAL,
   {0x3015, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFE3B, CHAR_CATEGORY_PS, DECOMP_TAG_VERTICAL,
   {0x3010, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFE3C, CHAR_CATEGORY_PE, DECOMP_TAG_VERTICAL,
   {0x3011, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFE3D, CHAR_CATEGORY_PS, DECOMP_TAG_VERTICAL,
   {0x300A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFE3E, CHAR_CATEGORY_PE, DECOMP_TAG_VERTICAL,
   {0x300B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFE3F, CHAR_CATEGORY_PS, DECOMP_TAG_VERTICAL,
   {0x3008, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFE40, CHAR_CATEGORY_PE, DECOMP_TAG_VERTICAL,
   {0x3009, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFE41, CHAR_CATEGORY_PS, DECOMP_TAG_VERTICAL,
   {0x300C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFE42, CHAR_CATEGORY_PE, DECOMP_TAG_VERTICAL,
   {0x300D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFE43, CHAR_CATEGORY_PS, DECOMP_TAG_VERTICAL,
   {0x300E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFE44, CHAR_CATEGORY_PE, DECOMP_TAG_VERTICAL,
   {0x300F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFE47, CHAR_CATEGORY_PS, DECOMP_TAG_VERTICAL,
   {0x005B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFE48, CHAR_CATEGORY_PE, DECOMP_TAG_VERTICAL,
   {0x005D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFE49, CHAR_CATEGORY_PO, DECOMP_TAG_COMPAT,
   {0x203E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFE4A, CHAR_CATEGORY_PO, DECOMP_TAG_COMPAT,
   {0x203E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFE4B, CHAR_CATEGORY_PO, DECOMP_TAG_COMPAT,
   {0x203E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFE4C, CHAR_CATEGORY_PO, DECOMP_TAG_COMPAT,
   {0x203E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFE4D, CHAR_CATEGORY_PC, DECOMP_TAG_COMPAT,
   {0x005F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFE4E, CHAR_CATEGORY_PC, DECOMP_TAG_COMPAT,
   {0x005F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFE4F, CHAR_CATEGORY_PC, DECOMP_TAG_COMPAT,
   {0x005F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFE50, CHAR_CATEGORY_PO, DECOMP_TAG_SMALL,
   {0x002C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFE51, CHAR_CATEGORY_PO, DECOMP_TAG_SMALL,
   {0x3001, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFE52, CHAR_CATEGORY_PO, DECOMP_TAG_SMALL,
   {0x002E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFE54, CHAR_CATEGORY_PO, DECOMP_TAG_SMALL,
   {0x003B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFE55, CHAR_CATEGORY_PO, DECOMP_TAG_SMALL,
   {0x003A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFE56, CHAR_CATEGORY_PO, DECOMP_TAG_SMALL,
   {0x003F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFE57, CHAR_CATEGORY_PO, DECOMP_TAG_SMALL,
   {0x0021, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFE58, CHAR_CATEGORY_PD, DECOMP_TAG_SMALL,
   {0x2014, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFE59, CHAR_CATEGORY_PS, DECOMP_TAG_SMALL,
   {0x0028, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFE5A, CHAR_CATEGORY_PE, DECOMP_TAG_SMALL,
   {0x0029, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFE5B, CHAR_CATEGORY_PS, DECOMP_TAG_SMALL,
   {0x007B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFE5C, CHAR_CATEGORY_PE, DECOMP_TAG_SMALL,
   {0x007D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFE5D, CHAR_CATEGORY_PS, DECOMP_TAG_SMALL,
   {0x3014, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFE5E, CHAR_CATEGORY_PE, DECOMP_TAG_SMALL,
   {0x3015, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFE5F, CHAR_CATEGORY_PO, DECOMP_TAG_SMALL,
   {0x0023, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFE60, CHAR_CATEGORY_PO, DECOMP_TAG_SMALL,
   {0x0026, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFE61, CHAR_CATEGORY_PO, DECOMP_TAG_SMALL,
   {0x002A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFE62, CHAR_CATEGORY_SM, DECOMP_TAG_SMALL,
   {0x002B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFE63, CHAR_CATEGORY_PD, DECOMP_TAG_SMALL,
   {0x002D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFE64, CHAR_CATEGORY_SM, DECOMP_TAG_SMALL,
   {0x003C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFE65, CHAR_CATEGORY_SM, DECOMP_TAG_SMALL,
   {0x003E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFE66, CHAR_CATEGORY_SM, DECOMP_TAG_SMALL,
   {0x003D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFE68, CHAR_CATEGORY_PO, DECOMP_TAG_SMALL,
   {0x005C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFE69, CHAR_CATEGORY_SC, DECOMP_TAG_SMALL,
   {0x0024, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFE6A, CHAR_CATEGORY_PO, DECOMP_TAG_SMALL,
   {0x0025, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFE6B, CHAR_CATEGORY_PO, DECOMP_TAG_SMALL,
   {0x0040, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFE70, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0020, 0x064B, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFE71, CHAR_CATEGORY_LO, DECOMP_TAG_MEDIAL,
   {0x0640, 0x064B, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFE72, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0020, 0x064C, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFE74, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0020, 0x064D, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFE76, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0020, 0x064E, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFE77, CHAR_CATEGORY_LO, DECOMP_TAG_MEDIAL,
   {0x0640, 0x064E, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFE78, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0020, 0x064F, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFE79, CHAR_CATEGORY_LO, DECOMP_TAG_MEDIAL,
   {0x0640, 0x064F, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFE7A, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0020, 0x0650, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFE7B, CHAR_CATEGORY_LO, DECOMP_TAG_MEDIAL,
   {0x0640, 0x0650, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFE7C, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0020, 0x0651, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFE7D, CHAR_CATEGORY_LO, DECOMP_TAG_MEDIAL,
   {0x0640, 0x0651, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFE7E, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0020, 0x0652, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFE7F, CHAR_CATEGORY_LO, DECOMP_TAG_MEDIAL,
   {0x0640, 0x0652, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFE80, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0621, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFE81, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0622, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFE82, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0622, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFE83, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0623, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFE84, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0623, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFE85, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0624, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFE86, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0624, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFE87, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0625, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFE88, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0625, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFE89, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0626, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFE8A, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0626, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFE8B, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x0626, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFE8C, CHAR_CATEGORY_LO, DECOMP_TAG_MEDIAL,
   {0x0626, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFE8D, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0627, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFE8E, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0627, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFE8F, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0628, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFE90, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0628, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFE91, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x0628, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFE92, CHAR_CATEGORY_LO, DECOMP_TAG_MEDIAL,
   {0x0628, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFE93, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0629, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFE94, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0629, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFE95, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x062A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFE96, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x062A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFE97, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x062A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFE98, CHAR_CATEGORY_LO, DECOMP_TAG_MEDIAL,
   {0x062A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFE99, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x062B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFE9A, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x062B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFE9B, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x062B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFE9C, CHAR_CATEGORY_LO, DECOMP_TAG_MEDIAL,
   {0x062B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFE9D, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x062C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFE9E, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x062C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFE9F, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x062C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFEA0, CHAR_CATEGORY_LO, DECOMP_TAG_MEDIAL,
   {0x062C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFEA1, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x062D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFEA2, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x062D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFEA3, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x062D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFEA4, CHAR_CATEGORY_LO, DECOMP_TAG_MEDIAL,
   {0x062D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFEA5, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x062E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFEA6, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x062E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFEA7, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x062E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFEA8, CHAR_CATEGORY_LO, DECOMP_TAG_MEDIAL,
   {0x062E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFEA9, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x062F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFEAA, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x062F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFEAB, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0630, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFEAC, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0630, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFEAD, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0631, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFEAE, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0631, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFEAF, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0632, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFEB0, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0632, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFEB1, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0633, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFEB2, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0633, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFEB3, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x0633, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFEB4, CHAR_CATEGORY_LO, DECOMP_TAG_MEDIAL,
   {0x0633, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFEB5, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0634, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFEB6, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0634, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFEB7, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x0634, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFEB8, CHAR_CATEGORY_LO, DECOMP_TAG_MEDIAL,
   {0x0634, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFEB9, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0635, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFEBA, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0635, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFEBB, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x0635, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFEBC, CHAR_CATEGORY_LO, DECOMP_TAG_MEDIAL,
   {0x0635, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFEBD, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0636, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFEBE, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0636, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFEBF, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x0636, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFEC0, CHAR_CATEGORY_LO, DECOMP_TAG_MEDIAL,
   {0x0636, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFEC1, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0637, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFEC2, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0637, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFEC3, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x0637, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFEC4, CHAR_CATEGORY_LO, DECOMP_TAG_MEDIAL,
   {0x0637, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFEC5, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0638, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFEC6, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0638, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFEC7, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x0638, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFEC8, CHAR_CATEGORY_LO, DECOMP_TAG_MEDIAL,
   {0x0638, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFEC9, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0639, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFECA, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0639, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFECB, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x0639, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFECC, CHAR_CATEGORY_LO, DECOMP_TAG_MEDIAL,
   {0x0639, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFECD, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x063A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFECE, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x063A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFECF, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x063A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFED0, CHAR_CATEGORY_LO, DECOMP_TAG_MEDIAL,
   {0x063A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFED1, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0641, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFED2, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0641, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFED3, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x0641, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFED4, CHAR_CATEGORY_LO, DECOMP_TAG_MEDIAL,
   {0x0641, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFED5, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0642, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFED6, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0642, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFED7, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x0642, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFED8, CHAR_CATEGORY_LO, DECOMP_TAG_MEDIAL,
   {0x0642, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFED9, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0643, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFEDA, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0643, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFEDB, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x0643, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFEDC, CHAR_CATEGORY_LO, DECOMP_TAG_MEDIAL,
   {0x0643, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFEDD, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0644, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFEDE, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0644, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFEDF, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x0644, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFEE0, CHAR_CATEGORY_LO, DECOMP_TAG_MEDIAL,
   {0x0644, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFEE1, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0645, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFEE2, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0645, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFEE3, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x0645, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFEE4, CHAR_CATEGORY_LO, DECOMP_TAG_MEDIAL,
   {0x0645, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFEE5, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0646, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFEE6, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0646, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFEE7, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x0646, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFEE8, CHAR_CATEGORY_LO, DECOMP_TAG_MEDIAL,
   {0x0646, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFEE9, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0647, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFEEA, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0647, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFEEB, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x0647, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFEEC, CHAR_CATEGORY_LO, DECOMP_TAG_MEDIAL,
   {0x0647, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFEED, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0648, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFEEE, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0648, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFEEF, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0649, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFEF0, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0649, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFEF1, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x064A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFEF2, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x064A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFEF3, CHAR_CATEGORY_LO, DECOMP_TAG_INITIAL,
   {0x064A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFEF4, CHAR_CATEGORY_LO, DECOMP_TAG_MEDIAL,
   {0x064A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFEF5, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0644, 0x0622, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFEF6, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0644, 0x0622, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFEF7, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0644, 0x0623, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFEF8, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0644, 0x0623, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFEF9, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0644, 0x0625, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFEFA, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0644, 0x0625, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFEFB, CHAR_CATEGORY_LO, DECOMP_TAG_ISOLATED,
   {0x0644, 0x0627, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFEFC, CHAR_CATEGORY_LO, DECOMP_TAG_FINAL,
   {0x0644, 0x0627, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF01, CHAR_CATEGORY_PO, DECOMP_TAG_WIDE,
   {0x0021, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF02, CHAR_CATEGORY_PO, DECOMP_TAG_WIDE,
   {0x0022, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF03, CHAR_CATEGORY_PO, DECOMP_TAG_WIDE,
   {0x0023, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF04, CHAR_CATEGORY_SC, DECOMP_TAG_WIDE,
   {0x0024, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF05, CHAR_CATEGORY_PO, DECOMP_TAG_WIDE,
   {0x0025, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF06, CHAR_CATEGORY_PO, DECOMP_TAG_WIDE,
   {0x0026, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF07, CHAR_CATEGORY_PO, DECOMP_TAG_WIDE,
   {0x0027, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF08, CHAR_CATEGORY_PS, DECOMP_TAG_WIDE,
   {0x0028, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF09, CHAR_CATEGORY_PE, DECOMP_TAG_WIDE,
   {0x0029, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF0A, CHAR_CATEGORY_PO, DECOMP_TAG_WIDE,
   {0x002A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF0B, CHAR_CATEGORY_SM, DECOMP_TAG_WIDE,
   {0x002B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF0C, CHAR_CATEGORY_PO, DECOMP_TAG_WIDE,
   {0x002C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF0D, CHAR_CATEGORY_PD, DECOMP_TAG_WIDE,
   {0x002D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF0E, CHAR_CATEGORY_PO, DECOMP_TAG_WIDE,
   {0x002E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF0F, CHAR_CATEGORY_PO, DECOMP_TAG_WIDE,
   {0x002F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF10, CHAR_CATEGORY_ND, DECOMP_TAG_WIDE,
   {0x0030, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF11, CHAR_CATEGORY_ND, DECOMP_TAG_WIDE,
   {0x0031, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF12, CHAR_CATEGORY_ND, DECOMP_TAG_WIDE,
   {0x0032, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF13, CHAR_CATEGORY_ND, DECOMP_TAG_WIDE,
   {0x0033, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF14, CHAR_CATEGORY_ND, DECOMP_TAG_WIDE,
   {0x0034, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF15, CHAR_CATEGORY_ND, DECOMP_TAG_WIDE,
   {0x0035, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF16, CHAR_CATEGORY_ND, DECOMP_TAG_WIDE,
   {0x0036, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF17, CHAR_CATEGORY_ND, DECOMP_TAG_WIDE,
   {0x0037, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF18, CHAR_CATEGORY_ND, DECOMP_TAG_WIDE,
   {0x0038, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF19, CHAR_CATEGORY_ND, DECOMP_TAG_WIDE,
   {0x0039, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF1A, CHAR_CATEGORY_PO, DECOMP_TAG_WIDE,
   {0x003A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF1B, CHAR_CATEGORY_PO, DECOMP_TAG_WIDE,
   {0x003B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF1C, CHAR_CATEGORY_SM, DECOMP_TAG_WIDE,
   {0x003C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF1D, CHAR_CATEGORY_SM, DECOMP_TAG_WIDE,
   {0x003D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF1E, CHAR_CATEGORY_SM, DECOMP_TAG_WIDE,
   {0x003E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF1F, CHAR_CATEGORY_PO, DECOMP_TAG_WIDE,
   {0x003F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF20, CHAR_CATEGORY_PO, DECOMP_TAG_WIDE,
   {0x0040, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF21, CHAR_CATEGORY_LU, DECOMP_TAG_WIDE,
   {0x0041, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF22, CHAR_CATEGORY_LU, DECOMP_TAG_WIDE,
   {0x0042, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF23, CHAR_CATEGORY_LU, DECOMP_TAG_WIDE,
   {0x0043, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF24, CHAR_CATEGORY_LU, DECOMP_TAG_WIDE,
   {0x0044, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF25, CHAR_CATEGORY_LU, DECOMP_TAG_WIDE,
   {0x0045, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF26, CHAR_CATEGORY_LU, DECOMP_TAG_WIDE,
   {0x0046, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF27, CHAR_CATEGORY_LU, DECOMP_TAG_WIDE,
   {0x0047, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF28, CHAR_CATEGORY_LU, DECOMP_TAG_WIDE,
   {0x0048, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF29, CHAR_CATEGORY_LU, DECOMP_TAG_WIDE,
   {0x0049, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF2A, CHAR_CATEGORY_LU, DECOMP_TAG_WIDE,
   {0x004A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF2B, CHAR_CATEGORY_LU, DECOMP_TAG_WIDE,
   {0x004B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF2C, CHAR_CATEGORY_LU, DECOMP_TAG_WIDE,
   {0x004C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF2D, CHAR_CATEGORY_LU, DECOMP_TAG_WIDE,
   {0x004D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF2E, CHAR_CATEGORY_LU, DECOMP_TAG_WIDE,
   {0x004E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF2F, CHAR_CATEGORY_LU, DECOMP_TAG_WIDE,
   {0x004F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF30, CHAR_CATEGORY_LU, DECOMP_TAG_WIDE,
   {0x0050, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF31, CHAR_CATEGORY_LU, DECOMP_TAG_WIDE,
   {0x0051, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF32, CHAR_CATEGORY_LU, DECOMP_TAG_WIDE,
   {0x0052, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF33, CHAR_CATEGORY_LU, DECOMP_TAG_WIDE,
   {0x0053, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF34, CHAR_CATEGORY_LU, DECOMP_TAG_WIDE,
   {0x0054, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF35, CHAR_CATEGORY_LU, DECOMP_TAG_WIDE,
   {0x0055, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF36, CHAR_CATEGORY_LU, DECOMP_TAG_WIDE,
   {0x0056, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF37, CHAR_CATEGORY_LU, DECOMP_TAG_WIDE,
   {0x0057, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF38, CHAR_CATEGORY_LU, DECOMP_TAG_WIDE,
   {0x0058, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF39, CHAR_CATEGORY_LU, DECOMP_TAG_WIDE,
   {0x0059, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF3A, CHAR_CATEGORY_LU, DECOMP_TAG_WIDE,
   {0x005A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF3B, CHAR_CATEGORY_PS, DECOMP_TAG_WIDE,
   {0x005B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF3C, CHAR_CATEGORY_PO, DECOMP_TAG_WIDE,
   {0x005C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF3D, CHAR_CATEGORY_PE, DECOMP_TAG_WIDE,
   {0x005D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF3E, CHAR_CATEGORY_SK, DECOMP_TAG_WIDE,
   {0x005E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF3F, CHAR_CATEGORY_PC, DECOMP_TAG_WIDE,
   {0x005F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF40, CHAR_CATEGORY_SK, DECOMP_TAG_WIDE,
   {0x0060, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF41, CHAR_CATEGORY_LL, DECOMP_TAG_WIDE,
   {0x0061, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF42, CHAR_CATEGORY_LL, DECOMP_TAG_WIDE,
   {0x0062, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF43, CHAR_CATEGORY_LL, DECOMP_TAG_WIDE,
   {0x0063, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF44, CHAR_CATEGORY_LL, DECOMP_TAG_WIDE,
   {0x0064, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF45, CHAR_CATEGORY_LL, DECOMP_TAG_WIDE,
   {0x0065, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF46, CHAR_CATEGORY_LL, DECOMP_TAG_WIDE,
   {0x0066, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF47, CHAR_CATEGORY_LL, DECOMP_TAG_WIDE,
   {0x0067, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF48, CHAR_CATEGORY_LL, DECOMP_TAG_WIDE,
   {0x0068, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF49, CHAR_CATEGORY_LL, DECOMP_TAG_WIDE,
   {0x0069, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF4A, CHAR_CATEGORY_LL, DECOMP_TAG_WIDE,
   {0x006A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF4B, CHAR_CATEGORY_LL, DECOMP_TAG_WIDE,
   {0x006B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF4C, CHAR_CATEGORY_LL, DECOMP_TAG_WIDE,
   {0x006C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF4D, CHAR_CATEGORY_LL, DECOMP_TAG_WIDE,
   {0x006D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF4E, CHAR_CATEGORY_LL, DECOMP_TAG_WIDE,
   {0x006E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF4F, CHAR_CATEGORY_LL, DECOMP_TAG_WIDE,
   {0x006F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF50, CHAR_CATEGORY_LL, DECOMP_TAG_WIDE,
   {0x0070, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF51, CHAR_CATEGORY_LL, DECOMP_TAG_WIDE,
   {0x0071, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF52, CHAR_CATEGORY_LL, DECOMP_TAG_WIDE,
   {0x0072, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF53, CHAR_CATEGORY_LL, DECOMP_TAG_WIDE,
   {0x0073, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF54, CHAR_CATEGORY_LL, DECOMP_TAG_WIDE,
   {0x0074, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF55, CHAR_CATEGORY_LL, DECOMP_TAG_WIDE,
   {0x0075, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF56, CHAR_CATEGORY_LL, DECOMP_TAG_WIDE,
   {0x0076, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF57, CHAR_CATEGORY_LL, DECOMP_TAG_WIDE,
   {0x0077, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF58, CHAR_CATEGORY_LL, DECOMP_TAG_WIDE,
   {0x0078, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF59, CHAR_CATEGORY_LL, DECOMP_TAG_WIDE,
   {0x0079, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF5A, CHAR_CATEGORY_LL, DECOMP_TAG_WIDE,
   {0x007A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF5B, CHAR_CATEGORY_PS, DECOMP_TAG_WIDE,
   {0x007B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF5C, CHAR_CATEGORY_SM, DECOMP_TAG_WIDE,
   {0x007C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF5D, CHAR_CATEGORY_PE, DECOMP_TAG_WIDE,
   {0x007D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF5E, CHAR_CATEGORY_SM, DECOMP_TAG_WIDE,
   {0x007E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF5F, CHAR_CATEGORY_PS, DECOMP_TAG_WIDE,
   {0x2985, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF60, CHAR_CATEGORY_PE, DECOMP_TAG_WIDE,
   {0x2986, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF61, CHAR_CATEGORY_PO, DECOMP_TAG_NARROW,
   {0x3002, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF62, CHAR_CATEGORY_PS, DECOMP_TAG_NARROW,
   {0x300C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF63, CHAR_CATEGORY_PE, DECOMP_TAG_NARROW,
   {0x300D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF64, CHAR_CATEGORY_PO, DECOMP_TAG_NARROW,
   {0x3001, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF65, CHAR_CATEGORY_PO, DECOMP_TAG_NARROW,
   {0x30FB, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF66, CHAR_CATEGORY_LO, DECOMP_TAG_NARROW,
   {0x30F2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF67, CHAR_CATEGORY_LO, DECOMP_TAG_NARROW,
   {0x30A1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF68, CHAR_CATEGORY_LO, DECOMP_TAG_NARROW,
   {0x30A3, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF69, CHAR_CATEGORY_LO, DECOMP_TAG_NARROW,
   {0x30A5, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF6A, CHAR_CATEGORY_LO, DECOMP_TAG_NARROW,
   {0x30A7, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF6B, CHAR_CATEGORY_LO, DECOMP_TAG_NARROW,
   {0x30A9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF6C, CHAR_CATEGORY_LO, DECOMP_TAG_NARROW,
   {0x30E3, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF6D, CHAR_CATEGORY_LO, DECOMP_TAG_NARROW,
   {0x30E5, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF6E, CHAR_CATEGORY_LO, DECOMP_TAG_NARROW,
   {0x30E7, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF6F, CHAR_CATEGORY_LO, DECOMP_TAG_NARROW,
   {0x30C3, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF70, CHAR_CATEGORY_LM, DECOMP_TAG_NARROW,
   {0x30FC, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF71, CHAR_CATEGORY_LO, DECOMP_TAG_NARROW,
   {0x30A2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF72, CHAR_CATEGORY_LO, DECOMP_TAG_NARROW,
   {0x30A4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF73, CHAR_CATEGORY_LO, DECOMP_TAG_NARROW,
   {0x30A6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF74, CHAR_CATEGORY_LO, DECOMP_TAG_NARROW,
   {0x30A8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF75, CHAR_CATEGORY_LO, DECOMP_TAG_NARROW,
   {0x30AA, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF76, CHAR_CATEGORY_LO, DECOMP_TAG_NARROW,
   {0x30AB, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF77, CHAR_CATEGORY_LO, DECOMP_TAG_NARROW,
   {0x30AD, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF78, CHAR_CATEGORY_LO, DECOMP_TAG_NARROW,
   {0x30AF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF79, CHAR_CATEGORY_LO, DECOMP_TAG_NARROW,
   {0x30B1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF7A, CHAR_CATEGORY_LO, DECOMP_TAG_NARROW,
   {0x30B3, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF7B, CHAR_CATEGORY_LO, DECOMP_TAG_NARROW,
   {0x30B5, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF7C, CHAR_CATEGORY_LO, DECOMP_TAG_NARROW,
   {0x30B7, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF7D, CHAR_CATEGORY_LO, DECOMP_TAG_NARROW,
   {0x30B9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF7E, CHAR_CATEGORY_LO, DECOMP_TAG_NARROW,
   {0x30BB, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF7F, CHAR_CATEGORY_LO, DECOMP_TAG_NARROW,
   {0x30BD, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF80, CHAR_CATEGORY_LO, DECOMP_TAG_NARROW,
   {0x30BF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF81, CHAR_CATEGORY_LO, DECOMP_TAG_NARROW,
   {0x30C1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF82, CHAR_CATEGORY_LO, DECOMP_TAG_NARROW,
   {0x30C4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF83, CHAR_CATEGORY_LO, DECOMP_TAG_NARROW,
   {0x30C6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF84, CHAR_CATEGORY_LO, DECOMP_TAG_NARROW,
   {0x30C8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF85, CHAR_CATEGORY_LO, DECOMP_TAG_NARROW,
   {0x30CA, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF86, CHAR_CATEGORY_LO, DECOMP_TAG_NARROW,
   {0x30CB, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF87, CHAR_CATEGORY_LO, DECOMP_TAG_NARROW,
   {0x30CC, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF88, CHAR_CATEGORY_LO, DECOMP_TAG_NARROW,
   {0x30CD, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF89, CHAR_CATEGORY_LO, DECOMP_TAG_NARROW,
   {0x30CE, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF8A, CHAR_CATEGORY_LO, DECOMP_TAG_NARROW,
   {0x30CF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF8B, CHAR_CATEGORY_LO, DECOMP_TAG_NARROW,
   {0x30D2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF8C, CHAR_CATEGORY_LO, DECOMP_TAG_NARROW,
   {0x30D5, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF8D, CHAR_CATEGORY_LO, DECOMP_TAG_NARROW,
   {0x30D8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF8E, CHAR_CATEGORY_LO, DECOMP_TAG_NARROW,
   {0x30DB, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF8F, CHAR_CATEGORY_LO, DECOMP_TAG_NARROW,
   {0x30DE, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF90, CHAR_CATEGORY_LO, DECOMP_TAG_NARROW,
   {0x30DF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF91, CHAR_CATEGORY_LO, DECOMP_TAG_NARROW,
   {0x30E0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF92, CHAR_CATEGORY_LO, DECOMP_TAG_NARROW,
   {0x30E1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF93, CHAR_CATEGORY_LO, DECOMP_TAG_NARROW,
   {0x30E2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF94, CHAR_CATEGORY_LO, DECOMP_TAG_NARROW,
   {0x30E4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF95, CHAR_CATEGORY_LO, DECOMP_TAG_NARROW,
   {0x30E6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF96, CHAR_CATEGORY_LO, DECOMP_TAG_NARROW,
   {0x30E8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF97, CHAR_CATEGORY_LO, DECOMP_TAG_NARROW,
   {0x30E9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF98, CHAR_CATEGORY_LO, DECOMP_TAG_NARROW,
   {0x30EA, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF99, CHAR_CATEGORY_LO, DECOMP_TAG_NARROW,
   {0x30EB, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF9A, CHAR_CATEGORY_LO, DECOMP_TAG_NARROW,
   {0x30EC, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF9B, CHAR_CATEGORY_LO, DECOMP_TAG_NARROW,
   {0x30ED, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF9C, CHAR_CATEGORY_LO, DECOMP_TAG_NARROW,
   {0x30EF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF9D, CHAR_CATEGORY_LO, DECOMP_TAG_NARROW,
   {0x30F3, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF9E, CHAR_CATEGORY_LM, DECOMP_TAG_NARROW,
   {0x3099, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFF9F, CHAR_CATEGORY_LM, DECOMP_TAG_NARROW,
   {0x309A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFFA0, CHAR_CATEGORY_LO, DECOMP_TAG_NARROW,
   {0x3164, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFFA1, CHAR_CATEGORY_LO, DECOMP_TAG_NARROW,
   {0x3131, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFFA2, CHAR_CATEGORY_LO, DECOMP_TAG_NARROW,
   {0x3132, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFFA3, CHAR_CATEGORY_LO, DECOMP_TAG_NARROW,
   {0x3133, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFFA4, CHAR_CATEGORY_LO, DECOMP_TAG_NARROW,
   {0x3134, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFFA5, CHAR_CATEGORY_LO, DECOMP_TAG_NARROW,
   {0x3135, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFFA6, CHAR_CATEGORY_LO, DECOMP_TAG_NARROW,
   {0x3136, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFFA7, CHAR_CATEGORY_LO, DECOMP_TAG_NARROW,
   {0x3137, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFFA8, CHAR_CATEGORY_LO, DECOMP_TAG_NARROW,
   {0x3138, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFFA9, CHAR_CATEGORY_LO, DECOMP_TAG_NARROW,
   {0x3139, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFFAA, CHAR_CATEGORY_LO, DECOMP_TAG_NARROW,
   {0x313A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFFAB, CHAR_CATEGORY_LO, DECOMP_TAG_NARROW,
   {0x313B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFFAC, CHAR_CATEGORY_LO, DECOMP_TAG_NARROW,
   {0x313C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFFAD, CHAR_CATEGORY_LO, DECOMP_TAG_NARROW,
   {0x313D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFFAE, CHAR_CATEGORY_LO, DECOMP_TAG_NARROW,
   {0x313E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFFAF, CHAR_CATEGORY_LO, DECOMP_TAG_NARROW,
   {0x313F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFFB0, CHAR_CATEGORY_LO, DECOMP_TAG_NARROW,
   {0x3140, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFFB1, CHAR_CATEGORY_LO, DECOMP_TAG_NARROW,
   {0x3141, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFFB2, CHAR_CATEGORY_LO, DECOMP_TAG_NARROW,
   {0x3142, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFFB3, CHAR_CATEGORY_LO, DECOMP_TAG_NARROW,
   {0x3143, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFFB4, CHAR_CATEGORY_LO, DECOMP_TAG_NARROW,
   {0x3144, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFFB5, CHAR_CATEGORY_LO, DECOMP_TAG_NARROW,
   {0x3145, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFFB6, CHAR_CATEGORY_LO, DECOMP_TAG_NARROW,
   {0x3146, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFFB7, CHAR_CATEGORY_LO, DECOMP_TAG_NARROW,
   {0x3147, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFFB8, CHAR_CATEGORY_LO, DECOMP_TAG_NARROW,
   {0x3148, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFFB9, CHAR_CATEGORY_LO, DECOMP_TAG_NARROW,
   {0x3149, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFFBA, CHAR_CATEGORY_LO, DECOMP_TAG_NARROW,
   {0x314A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFFBB, CHAR_CATEGORY_LO, DECOMP_TAG_NARROW,
   {0x314B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFFBC, CHAR_CATEGORY_LO, DECOMP_TAG_NARROW,
   {0x314C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFFBD, CHAR_CATEGORY_LO, DECOMP_TAG_NARROW,
   {0x314D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFFBE, CHAR_CATEGORY_LO, DECOMP_TAG_NARROW,
   {0x314E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFFC2, CHAR_CATEGORY_LO, DECOMP_TAG_NARROW,
   {0x314F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFFC3, CHAR_CATEGORY_LO, DECOMP_TAG_NARROW,
   {0x3150, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFFC4, CHAR_CATEGORY_LO, DECOMP_TAG_NARROW,
   {0x3151, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFFC5, CHAR_CATEGORY_LO, DECOMP_TAG_NARROW,
   {0x3152, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFFC6, CHAR_CATEGORY_LO, DECOMP_TAG_NARROW,
   {0x3153, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFFC7, CHAR_CATEGORY_LO, DECOMP_TAG_NARROW,
   {0x3154, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFFCA, CHAR_CATEGORY_LO, DECOMP_TAG_NARROW,
   {0x3155, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFFCB, CHAR_CATEGORY_LO, DECOMP_TAG_NARROW,
   {0x3156, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFFCC, CHAR_CATEGORY_LO, DECOMP_TAG_NARROW,
   {0x3157, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFFCD, CHAR_CATEGORY_LO, DECOMP_TAG_NARROW,
   {0x3158, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFFCE, CHAR_CATEGORY_LO, DECOMP_TAG_NARROW,
   {0x3159, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFFCF, CHAR_CATEGORY_LO, DECOMP_TAG_NARROW,
   {0x315A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFFD2, CHAR_CATEGORY_LO, DECOMP_TAG_NARROW,
   {0x315B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFFD3, CHAR_CATEGORY_LO, DECOMP_TAG_NARROW,
   {0x315C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFFD4, CHAR_CATEGORY_LO, DECOMP_TAG_NARROW,
   {0x315D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFFD5, CHAR_CATEGORY_LO, DECOMP_TAG_NARROW,
   {0x315E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFFD6, CHAR_CATEGORY_LO, DECOMP_TAG_NARROW,
   {0x315F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFFD7, CHAR_CATEGORY_LO, DECOMP_TAG_NARROW,
   {0x3160, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFFDA, CHAR_CATEGORY_LO, DECOMP_TAG_NARROW,
   {0x3161, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFFDB, CHAR_CATEGORY_LO, DECOMP_TAG_NARROW,
   {0x3162, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFFDC, CHAR_CATEGORY_LO, DECOMP_TAG_NARROW,
   {0x3163, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFFE0, CHAR_CATEGORY_SC, DECOMP_TAG_WIDE,
   {0x00A2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFFE1, CHAR_CATEGORY_SC, DECOMP_TAG_WIDE,
   {0x00A3, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFFE2, CHAR_CATEGORY_SM, DECOMP_TAG_WIDE,
   {0x00AC, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFFE3, CHAR_CATEGORY_SK, DECOMP_TAG_WIDE,
   {0x00AF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFFE4, CHAR_CATEGORY_SO, DECOMP_TAG_WIDE,
   {0x00A6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFFE5, CHAR_CATEGORY_SC, DECOMP_TAG_WIDE,
   {0x00A5, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFFE6, CHAR_CATEGORY_SC, DECOMP_TAG_WIDE,
   {0x20A9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFFE8, CHAR_CATEGORY_SO, DECOMP_TAG_NARROW,
   {0x2502, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFFE9, CHAR_CATEGORY_SM, DECOMP_TAG_NARROW,
   {0x2190, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFFEA, CHAR_CATEGORY_SM, DECOMP_TAG_NARROW,
   {0x2191, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFFEB, CHAR_CATEGORY_SM, DECOMP_TAG_NARROW,
   {0x2192, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFFEC, CHAR_CATEGORY_SM, DECOMP_TAG_NARROW,
   {0x2193, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFFED, CHAR_CATEGORY_SO, DECOMP_TAG_NARROW,
   {0x25A0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0xFFEE, CHAR_CATEGORY_SO, DECOMP_TAG_NARROW,
   {0x25CB, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1109A, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x11099, 0x110BA, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1109C, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x1109B, 0x110BA, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x110AB, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x110A5, 0x110BA, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1112E, CHAR_CATEGORY_MN, DECOMP_TAG_NONE,
   {0x11131, 0x11127, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1112F, CHAR_CATEGORY_MN, DECOMP_TAG_NONE,
   {0x11132, 0x11127, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1134B, CHAR_CATEGORY_MC, DECOMP_TAG_NONE,
   {0x11347, 0x1133E, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1134C, CHAR_CATEGORY_MC, DECOMP_TAG_NONE,
   {0x11347, 0x11357, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x114BB, CHAR_CATEGORY_MC, DECOMP_TAG_NONE,
   {0x114B9, 0x114BA, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x114BC, CHAR_CATEGORY_MC, DECOMP_TAG_NONE,
   {0x114B9, 0x114B0, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x114BE, CHAR_CATEGORY_MC, DECOMP_TAG_NONE,
   {0x114B9, 0x114BD, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x115BA, CHAR_CATEGORY_MC, DECOMP_TAG_NONE,
   {0x115B8, 0x115AF, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x115BB, CHAR_CATEGORY_MC, DECOMP_TAG_NONE,
   {0x115B9, 0x115AF, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D15E, CHAR_CATEGORY_SO, DECOMP_TAG_NONE,
   {0x1D157, 0x1D165, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D15F, CHAR_CATEGORY_SO, DECOMP_TAG_NONE,
   {0x1D158, 0x1D165, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D160, CHAR_CATEGORY_SO, DECOMP_TAG_NONE,
   {0x1D158, 0x1D165, 0x1D16E, 0x0000, 0x0000, 0x0000}},
  {0x1D161, CHAR_CATEGORY_SO, DECOMP_TAG_NONE,
   {0x1D158, 0x1D165, 0x1D16F, 0x0000, 0x0000, 0x0000}},
  {0x1D162, CHAR_CATEGORY_SO, DECOMP_TAG_NONE,
   {0x1D158, 0x1D165, 0x1D170, 0x0000, 0x0000, 0x0000}},
  {0x1D163, CHAR_CATEGORY_SO, DECOMP_TAG_NONE,
   {0x1D158, 0x1D165, 0x1D171, 0x0000, 0x0000, 0x0000}},
  {0x1D164, CHAR_CATEGORY_SO, DECOMP_TAG_NONE,
   {0x1D158, 0x1D165, 0x1D172, 0x0000, 0x0000, 0x0000}},
  {0x1D1BB, CHAR_CATEGORY_SO, DECOMP_TAG_NONE,
   {0x1D1B9, 0x1D165, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D1BC, CHAR_CATEGORY_SO, DECOMP_TAG_NONE,
   {0x1D1BA, 0x1D165, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D1BD, CHAR_CATEGORY_SO, DECOMP_TAG_NONE,
   {0x1D1B9, 0x1D165, 0x1D16E, 0x0000, 0x0000, 0x0000}},
  {0x1D1BE, CHAR_CATEGORY_SO, DECOMP_TAG_NONE,
   {0x1D1BA, 0x1D165, 0x1D16E, 0x0000, 0x0000, 0x0000}},
  {0x1D1BF, CHAR_CATEGORY_SO, DECOMP_TAG_NONE,
   {0x1D1B9, 0x1D165, 0x1D16F, 0x0000, 0x0000, 0x0000}},
  {0x1D1C0, CHAR_CATEGORY_SO, DECOMP_TAG_NONE,
   {0x1D1BA, 0x1D165, 0x1D16F, 0x0000, 0x0000, 0x0000}},
  {0x1D400, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0041, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D401, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0042, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D402, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0043, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D403, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0044, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D404, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0045, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D405, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0046, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D406, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0047, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D407, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0048, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D408, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0049, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D409, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x004A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D40A, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x004B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D40B, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x004C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D40C, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x004D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D40D, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x004E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D40E, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x004F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D40F, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0050, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D410, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0051, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D411, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0052, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D412, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0053, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D413, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0054, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D414, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0055, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D415, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0056, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D416, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0057, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D417, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0058, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D418, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0059, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D419, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x005A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D41A, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0061, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D41B, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0062, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D41C, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0063, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D41D, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0064, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D41E, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0065, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D41F, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0066, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D420, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0067, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D421, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0068, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D422, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0069, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D423, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x006A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D424, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x006B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D425, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x006C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D426, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x006D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D427, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x006E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D428, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x006F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D429, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0070, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D42A, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0071, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D42B, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0072, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D42C, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0073, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D42D, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0074, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D42E, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0075, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D42F, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0076, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D430, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0077, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D431, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0078, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D432, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0079, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D433, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x007A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D434, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0041, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D435, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0042, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D436, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0043, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D437, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0044, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D438, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0045, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D439, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0046, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D43A, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0047, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D43B, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0048, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D43C, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0049, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D43D, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x004A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D43E, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x004B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D43F, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x004C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D440, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x004D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D441, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x004E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D442, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x004F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D443, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0050, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D444, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0051, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D445, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0052, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D446, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0053, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D447, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0054, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D448, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0055, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D449, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0056, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D44A, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0057, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D44B, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0058, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D44C, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0059, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D44D, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x005A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D44E, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0061, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D44F, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0062, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D450, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0063, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D451, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0064, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D452, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0065, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D453, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0066, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D454, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0067, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D456, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0069, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D457, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x006A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D458, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x006B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D459, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x006C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D45A, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x006D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D45B, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x006E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D45C, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x006F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D45D, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0070, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D45E, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0071, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D45F, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0072, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D460, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0073, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D461, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0074, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D462, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0075, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D463, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0076, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D464, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0077, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D465, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0078, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D466, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0079, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D467, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x007A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D468, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0041, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D469, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0042, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D46A, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0043, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D46B, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0044, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D46C, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0045, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D46D, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0046, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D46E, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0047, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D46F, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0048, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D470, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0049, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D471, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x004A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D472, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x004B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D473, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x004C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D474, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x004D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D475, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x004E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D476, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x004F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D477, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0050, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D478, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0051, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D479, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0052, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D47A, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0053, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D47B, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0054, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D47C, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0055, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D47D, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0056, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D47E, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0057, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D47F, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0058, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D480, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0059, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D481, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x005A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D482, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0061, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D483, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0062, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D484, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0063, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D485, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0064, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D486, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0065, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D487, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0066, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D488, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0067, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D489, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0068, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D48A, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0069, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D48B, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x006A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D48C, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x006B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D48D, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x006C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D48E, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x006D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D48F, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x006E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D490, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x006F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D491, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0070, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D492, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0071, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D493, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0072, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D494, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0073, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D495, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0074, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D496, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0075, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D497, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0076, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D498, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0077, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D499, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0078, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D49A, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0079, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D49B, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x007A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D49C, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0041, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D49E, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0043, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D49F, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0044, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D4A2, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0047, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D4A5, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x004A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D4A6, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x004B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D4A9, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x004E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D4AA, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x004F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D4AB, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0050, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D4AC, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0051, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D4AE, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0053, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D4AF, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0054, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D4B0, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0055, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D4B1, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0056, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D4B2, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0057, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D4B3, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0058, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D4B4, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0059, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D4B5, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x005A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D4B6, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0061, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D4B7, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0062, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D4B8, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0063, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D4B9, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0064, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D4BB, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0066, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D4BD, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0068, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D4BE, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0069, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D4BF, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x006A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D4C0, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x006B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D4C1, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x006C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D4C2, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x006D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D4C3, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x006E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D4C5, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0070, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D4C6, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0071, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D4C7, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0072, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D4C8, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0073, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D4C9, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0074, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D4CA, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0075, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D4CB, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0076, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D4CC, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0077, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D4CD, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0078, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D4CE, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0079, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D4CF, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x007A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D4D0, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0041, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D4D1, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0042, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D4D2, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0043, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D4D3, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0044, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D4D4, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0045, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D4D5, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0046, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D4D6, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0047, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D4D7, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0048, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D4D8, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0049, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D4D9, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x004A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D4DA, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x004B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D4DB, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x004C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D4DC, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x004D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D4DD, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x004E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D4DE, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x004F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D4DF, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0050, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D4E0, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0051, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D4E1, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0052, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D4E2, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0053, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D4E3, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0054, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D4E4, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0055, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D4E5, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0056, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D4E6, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0057, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D4E7, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0058, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D4E8, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0059, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D4E9, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x005A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D4EA, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0061, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D4EB, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0062, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D4EC, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0063, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D4ED, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0064, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D4EE, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0065, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D4EF, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0066, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D4F0, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0067, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D4F1, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0068, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D4F2, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0069, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D4F3, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x006A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D4F4, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x006B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D4F5, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x006C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D4F6, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x006D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D4F7, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x006E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D4F8, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x006F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D4F9, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0070, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D4FA, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0071, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D4FB, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0072, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D4FC, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0073, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D4FD, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0074, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D4FE, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0075, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D4FF, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0076, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D500, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0077, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D501, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0078, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D502, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0079, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D503, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x007A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D504, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0041, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D505, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0042, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D507, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0044, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D508, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0045, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D509, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0046, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D50A, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0047, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D50D, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x004A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D50E, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x004B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D50F, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x004C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D510, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x004D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D511, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x004E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D512, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x004F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D513, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0050, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D514, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0051, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D516, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0053, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D517, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0054, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D518, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0055, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D519, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0056, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D51A, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0057, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D51B, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0058, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D51C, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0059, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D51E, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0061, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D51F, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0062, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D520, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0063, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D521, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0064, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D522, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0065, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D523, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0066, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D524, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0067, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D525, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0068, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D526, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0069, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D527, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x006A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D528, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x006B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D529, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x006C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D52A, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x006D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D52B, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x006E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D52C, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x006F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D52D, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0070, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D52E, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0071, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D52F, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0072, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D530, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0073, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D531, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0074, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D532, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0075, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D533, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0076, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D534, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0077, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D535, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0078, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D536, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0079, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D537, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x007A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D538, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0041, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D539, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0042, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D53B, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0044, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D53C, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0045, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D53D, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0046, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D53E, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0047, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D540, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0049, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D541, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x004A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D542, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x004B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D543, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x004C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D544, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x004D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D546, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x004F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D54A, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0053, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D54B, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0054, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D54C, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0055, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D54D, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0056, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D54E, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0057, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D54F, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0058, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D550, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0059, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D552, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0061, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D553, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0062, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D554, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0063, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D555, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0064, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D556, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0065, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D557, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0066, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D558, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0067, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D559, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0068, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D55A, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0069, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D55B, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x006A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D55C, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x006B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D55D, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x006C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D55E, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x006D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D55F, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x006E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D560, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x006F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D561, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0070, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D562, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0071, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D563, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0072, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D564, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0073, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D565, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0074, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D566, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0075, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D567, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0076, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D568, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0077, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D569, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0078, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D56A, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0079, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D56B, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x007A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D56C, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0041, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D56D, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0042, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D56E, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0043, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D56F, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0044, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D570, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0045, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D571, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0046, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D572, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0047, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D573, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0048, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D574, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0049, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D575, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x004A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D576, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x004B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D577, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x004C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D578, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x004D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D579, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x004E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D57A, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x004F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D57B, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0050, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D57C, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0051, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D57D, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0052, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D57E, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0053, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D57F, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0054, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D580, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0055, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D581, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0056, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D582, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0057, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D583, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0058, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D584, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0059, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D585, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x005A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D586, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0061, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D587, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0062, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D588, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0063, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D589, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0064, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D58A, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0065, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D58B, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0066, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D58C, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0067, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D58D, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0068, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D58E, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0069, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D58F, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x006A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D590, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x006B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D591, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x006C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D592, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x006D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D593, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x006E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D594, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x006F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D595, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0070, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D596, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0071, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D597, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0072, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D598, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0073, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D599, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0074, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D59A, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0075, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D59B, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0076, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D59C, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0077, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D59D, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0078, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D59E, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0079, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D59F, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x007A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D5A0, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0041, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D5A1, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0042, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D5A2, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0043, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D5A3, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0044, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D5A4, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0045, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D5A5, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0046, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D5A6, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0047, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D5A7, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0048, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D5A8, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0049, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D5A9, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x004A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D5AA, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x004B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D5AB, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x004C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D5AC, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x004D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D5AD, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x004E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D5AE, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x004F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D5AF, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0050, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D5B0, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0051, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D5B1, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0052, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D5B2, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0053, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D5B3, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0054, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D5B4, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0055, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D5B5, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0056, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D5B6, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0057, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D5B7, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0058, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D5B8, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0059, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D5B9, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x005A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D5BA, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0061, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D5BB, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0062, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D5BC, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0063, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D5BD, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0064, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D5BE, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0065, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D5BF, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0066, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D5C0, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0067, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D5C1, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0068, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D5C2, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0069, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D5C3, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x006A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D5C4, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x006B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D5C5, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x006C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D5C6, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x006D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D5C7, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x006E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D5C8, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x006F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D5C9, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0070, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D5CA, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0071, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D5CB, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0072, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D5CC, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0073, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D5CD, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0074, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D5CE, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0075, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D5CF, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0076, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D5D0, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0077, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D5D1, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0078, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D5D2, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0079, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D5D3, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x007A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D5D4, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0041, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D5D5, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0042, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D5D6, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0043, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D5D7, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0044, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D5D8, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0045, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D5D9, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0046, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D5DA, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0047, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D5DB, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0048, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D5DC, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0049, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D5DD, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x004A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D5DE, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x004B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D5DF, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x004C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D5E0, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x004D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D5E1, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x004E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D5E2, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x004F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D5E3, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0050, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D5E4, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0051, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D5E5, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0052, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D5E6, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0053, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D5E7, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0054, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D5E8, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0055, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D5E9, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0056, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D5EA, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0057, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D5EB, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0058, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D5EC, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0059, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D5ED, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x005A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D5EE, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0061, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D5EF, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0062, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D5F0, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0063, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D5F1, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0064, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D5F2, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0065, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D5F3, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0066, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D5F4, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0067, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D5F5, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0068, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D5F6, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0069, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D5F7, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x006A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D5F8, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x006B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D5F9, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x006C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D5FA, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x006D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D5FB, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x006E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D5FC, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x006F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D5FD, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0070, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D5FE, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0071, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D5FF, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0072, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D600, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0073, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D601, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0074, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D602, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0075, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D603, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0076, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D604, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0077, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D605, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0078, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D606, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0079, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D607, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x007A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D608, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0041, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D609, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0042, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D60A, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0043, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D60B, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0044, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D60C, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0045, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D60D, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0046, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D60E, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0047, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D60F, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0048, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D610, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0049, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D611, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x004A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D612, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x004B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D613, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x004C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D614, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x004D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D615, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x004E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D616, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x004F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D617, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0050, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D618, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0051, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D619, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0052, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D61A, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0053, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D61B, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0054, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D61C, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0055, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D61D, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0056, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D61E, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0057, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D61F, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0058, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D620, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0059, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D621, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x005A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D622, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0061, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D623, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0062, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D624, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0063, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D625, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0064, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D626, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0065, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D627, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0066, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D628, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0067, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D629, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0068, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D62A, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0069, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D62B, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x006A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D62C, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x006B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D62D, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x006C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D62E, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x006D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D62F, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x006E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D630, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x006F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D631, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0070, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D632, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0071, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D633, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0072, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D634, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0073, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D635, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0074, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D636, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0075, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D637, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0076, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D638, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0077, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D639, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0078, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D63A, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0079, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D63B, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x007A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D63C, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0041, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D63D, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0042, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D63E, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0043, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D63F, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0044, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D640, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0045, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D641, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0046, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D642, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0047, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D643, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0048, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D644, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0049, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D645, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x004A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D646, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x004B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D647, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x004C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D648, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x004D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D649, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x004E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D64A, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x004F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D64B, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0050, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D64C, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0051, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D64D, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0052, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D64E, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0053, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D64F, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0054, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D650, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0055, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D651, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0056, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D652, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0057, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D653, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0058, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D654, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0059, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D655, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x005A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D656, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0061, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D657, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0062, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D658, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0063, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D659, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0064, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D65A, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0065, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D65B, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0066, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D65C, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0067, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D65D, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0068, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D65E, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0069, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D65F, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x006A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D660, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x006B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D661, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x006C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D662, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x006D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D663, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x006E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D664, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x006F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D665, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0070, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D666, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0071, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D667, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0072, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D668, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0073, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D669, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0074, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D66A, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0075, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D66B, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0076, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D66C, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0077, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D66D, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0078, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D66E, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0079, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D66F, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x007A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D670, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0041, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D671, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0042, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D672, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0043, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D673, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0044, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D674, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0045, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D675, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0046, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D676, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0047, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D677, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0048, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D678, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0049, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D679, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x004A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D67A, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x004B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D67B, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x004C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D67C, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x004D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D67D, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x004E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D67E, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x004F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D67F, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0050, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D680, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0051, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D681, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0052, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D682, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0053, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D683, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0054, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D684, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0055, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D685, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0056, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D686, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0057, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D687, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0058, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D688, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0059, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D689, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x005A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D68A, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0061, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D68B, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0062, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D68C, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0063, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D68D, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0064, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D68E, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0065, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D68F, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0066, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D690, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0067, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D691, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0068, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D692, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0069, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D693, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x006A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D694, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x006B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D695, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x006C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D696, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x006D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D697, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x006E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D698, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x006F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D699, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0070, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D69A, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0071, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D69B, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0072, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D69C, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0073, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D69D, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0074, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D69E, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0075, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D69F, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0076, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D6A0, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0077, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D6A1, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0078, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D6A2, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0079, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D6A3, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x007A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D6A4, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0131, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D6A5, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x0237, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D6A8, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0391, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D6A9, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0392, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D6AA, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0393, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D6AB, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0394, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D6AC, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0395, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D6AD, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0396, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D6AE, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0397, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D6AF, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0398, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D6B0, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0399, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D6B1, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x039A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D6B2, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x039B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D6B3, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x039C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D6B4, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x039D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D6B5, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x039E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D6B6, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x039F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D6B7, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x03A0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D6B8, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x03A1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D6B9, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x03F4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D6BA, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x03A3, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D6BB, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x03A4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D6BC, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x03A5, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D6BD, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x03A6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D6BE, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x03A7, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D6BF, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x03A8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D6C0, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x03A9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D6C1, CHAR_CATEGORY_SM, DECOMP_TAG_FONT,
   {0x2207, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D6C2, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03B1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D6C3, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03B2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D6C4, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03B3, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D6C5, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03B4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D6C6, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03B5, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D6C7, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03B6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D6C8, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03B7, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D6C9, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03B8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D6CA, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03B9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D6CB, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03BA, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D6CC, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03BB, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D6CD, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03BC, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D6CE, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03BD, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D6CF, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03BE, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D6D0, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03BF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D6D1, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03C0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D6D2, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03C1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D6D3, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03C2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D6D4, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03C3, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D6D5, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03C4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D6D6, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03C5, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D6D7, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03C6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D6D8, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03C7, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D6D9, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03C8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D6DA, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03C9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D6DB, CHAR_CATEGORY_SM, DECOMP_TAG_FONT,
   {0x2202, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D6DC, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03F5, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D6DD, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03D1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D6DE, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03F0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D6DF, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03D5, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D6E0, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03F1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D6E1, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03D6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D6E2, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0391, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D6E3, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0392, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D6E4, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0393, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D6E5, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0394, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D6E6, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0395, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D6E7, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0396, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D6E8, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0397, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D6E9, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0398, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D6EA, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0399, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D6EB, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x039A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D6EC, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x039B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D6ED, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x039C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D6EE, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x039D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D6EF, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x039E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D6F0, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x039F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D6F1, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x03A0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D6F2, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x03A1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D6F3, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x03F4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D6F4, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x03A3, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D6F5, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x03A4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D6F6, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x03A5, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D6F7, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x03A6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D6F8, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x03A7, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D6F9, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x03A8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D6FA, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x03A9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D6FB, CHAR_CATEGORY_SM, DECOMP_TAG_FONT,
   {0x2207, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D6FC, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03B1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D6FD, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03B2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D6FE, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03B3, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D6FF, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03B4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D700, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03B5, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D701, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03B6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D702, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03B7, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D703, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03B8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D704, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03B9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D705, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03BA, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D706, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03BB, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D707, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03BC, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D708, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03BD, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D709, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03BE, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D70A, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03BF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D70B, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03C0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D70C, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03C1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D70D, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03C2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D70E, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03C3, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D70F, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03C4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D710, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03C5, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D711, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03C6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D712, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03C7, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D713, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03C8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D714, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03C9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D715, CHAR_CATEGORY_SM, DECOMP_TAG_FONT,
   {0x2202, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D716, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03F5, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D717, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03D1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D718, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03F0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D719, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03D5, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D71A, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03F1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D71B, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03D6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D71C, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0391, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D71D, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0392, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D71E, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0393, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D71F, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0394, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D720, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0395, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D721, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0396, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D722, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0397, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D723, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0398, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D724, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0399, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D725, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x039A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D726, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x039B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D727, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x039C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D728, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x039D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D729, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x039E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D72A, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x039F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D72B, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x03A0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D72C, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x03A1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D72D, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x03F4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D72E, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x03A3, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D72F, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x03A4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D730, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x03A5, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D731, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x03A6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D732, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x03A7, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D733, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x03A8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D734, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x03A9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D735, CHAR_CATEGORY_SM, DECOMP_TAG_FONT,
   {0x2207, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D736, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03B1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D737, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03B2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D738, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03B3, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D739, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03B4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D73A, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03B5, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D73B, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03B6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D73C, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03B7, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D73D, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03B8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D73E, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03B9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D73F, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03BA, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D740, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03BB, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D741, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03BC, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D742, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03BD, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D743, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03BE, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D744, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03BF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D745, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03C0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D746, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03C1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D747, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03C2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D748, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03C3, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D749, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03C4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D74A, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03C5, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D74B, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03C6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D74C, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03C7, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D74D, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03C8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D74E, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03C9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D74F, CHAR_CATEGORY_SM, DECOMP_TAG_FONT,
   {0x2202, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D750, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03F5, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D751, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03D1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D752, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03F0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D753, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03D5, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D754, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03F1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D755, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03D6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D756, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0391, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D757, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0392, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D758, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0393, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D759, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0394, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D75A, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0395, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D75B, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0396, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D75C, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0397, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D75D, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0398, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D75E, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0399, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D75F, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x039A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D760, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x039B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D761, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x039C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D762, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x039D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D763, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x039E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D764, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x039F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D765, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x03A0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D766, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x03A1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D767, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x03F4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D768, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x03A3, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D769, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x03A4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D76A, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x03A5, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D76B, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x03A6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D76C, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x03A7, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D76D, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x03A8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D76E, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x03A9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D76F, CHAR_CATEGORY_SM, DECOMP_TAG_FONT,
   {0x2207, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D770, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03B1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D771, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03B2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D772, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03B3, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D773, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03B4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D774, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03B5, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D775, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03B6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D776, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03B7, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D777, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03B8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D778, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03B9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D779, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03BA, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D77A, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03BB, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D77B, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03BC, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D77C, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03BD, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D77D, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03BE, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D77E, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03BF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D77F, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03C0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D780, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03C1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D781, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03C2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D782, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03C3, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D783, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03C4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D784, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03C5, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D785, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03C6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D786, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03C7, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D787, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03C8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D788, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03C9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D789, CHAR_CATEGORY_SM, DECOMP_TAG_FONT,
   {0x2202, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D78A, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03F5, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D78B, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03D1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D78C, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03F0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D78D, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03D5, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D78E, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03F1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D78F, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03D6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D790, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0391, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D791, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0392, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D792, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0393, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D793, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0394, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D794, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0395, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D795, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0396, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D796, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0397, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D797, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0398, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D798, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x0399, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D799, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x039A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D79A, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x039B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D79B, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x039C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D79C, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x039D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D79D, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x039E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D79E, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x039F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D79F, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x03A0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D7A0, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x03A1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D7A1, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x03F4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D7A2, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x03A3, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D7A3, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x03A4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D7A4, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x03A5, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D7A5, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x03A6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D7A6, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x03A7, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D7A7, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x03A8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D7A8, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x03A9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D7A9, CHAR_CATEGORY_SM, DECOMP_TAG_FONT,
   {0x2207, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D7AA, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03B1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D7AB, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03B2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D7AC, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03B3, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D7AD, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03B4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D7AE, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03B5, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D7AF, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03B6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D7B0, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03B7, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D7B1, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03B8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D7B2, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03B9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D7B3, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03BA, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D7B4, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03BB, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D7B5, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03BC, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D7B6, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03BD, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D7B7, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03BE, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D7B8, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03BF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D7B9, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03C0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D7BA, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03C1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D7BB, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03C2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D7BC, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03C3, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D7BD, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03C4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D7BE, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03C5, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D7BF, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03C6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D7C0, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03C7, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D7C1, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03C8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D7C2, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03C9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D7C3, CHAR_CATEGORY_SM, DECOMP_TAG_FONT,
   {0x2202, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D7C4, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03F5, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D7C5, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03D1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D7C6, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03F0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D7C7, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03D5, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D7C8, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03F1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D7C9, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03D6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D7CA, CHAR_CATEGORY_LU, DECOMP_TAG_FONT,
   {0x03DC, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D7CB, CHAR_CATEGORY_LL, DECOMP_TAG_FONT,
   {0x03DD, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D7CE, CHAR_CATEGORY_ND, DECOMP_TAG_FONT,
   {0x0030, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D7CF, CHAR_CATEGORY_ND, DECOMP_TAG_FONT,
   {0x0031, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D7D0, CHAR_CATEGORY_ND, DECOMP_TAG_FONT,
   {0x0032, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D7D1, CHAR_CATEGORY_ND, DECOMP_TAG_FONT,
   {0x0033, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D7D2, CHAR_CATEGORY_ND, DECOMP_TAG_FONT,
   {0x0034, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D7D3, CHAR_CATEGORY_ND, DECOMP_TAG_FONT,
   {0x0035, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D7D4, CHAR_CATEGORY_ND, DECOMP_TAG_FONT,
   {0x0036, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D7D5, CHAR_CATEGORY_ND, DECOMP_TAG_FONT,
   {0x0037, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D7D6, CHAR_CATEGORY_ND, DECOMP_TAG_FONT,
   {0x0038, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D7D7, CHAR_CATEGORY_ND, DECOMP_TAG_FONT,
   {0x0039, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D7D8, CHAR_CATEGORY_ND, DECOMP_TAG_FONT,
   {0x0030, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D7D9, CHAR_CATEGORY_ND, DECOMP_TAG_FONT,
   {0x0031, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D7DA, CHAR_CATEGORY_ND, DECOMP_TAG_FONT,
   {0x0032, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D7DB, CHAR_CATEGORY_ND, DECOMP_TAG_FONT,
   {0x0033, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D7DC, CHAR_CATEGORY_ND, DECOMP_TAG_FONT,
   {0x0034, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D7DD, CHAR_CATEGORY_ND, DECOMP_TAG_FONT,
   {0x0035, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D7DE, CHAR_CATEGORY_ND, DECOMP_TAG_FONT,
   {0x0036, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D7DF, CHAR_CATEGORY_ND, DECOMP_TAG_FONT,
   {0x0037, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D7E0, CHAR_CATEGORY_ND, DECOMP_TAG_FONT,
   {0x0038, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D7E1, CHAR_CATEGORY_ND, DECOMP_TAG_FONT,
   {0x0039, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D7E2, CHAR_CATEGORY_ND, DECOMP_TAG_FONT,
   {0x0030, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D7E3, CHAR_CATEGORY_ND, DECOMP_TAG_FONT,
   {0x0031, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D7E4, CHAR_CATEGORY_ND, DECOMP_TAG_FONT,
   {0x0032, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D7E5, CHAR_CATEGORY_ND, DECOMP_TAG_FONT,
   {0x0033, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D7E6, CHAR_CATEGORY_ND, DECOMP_TAG_FONT,
   {0x0034, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D7E7, CHAR_CATEGORY_ND, DECOMP_TAG_FONT,
   {0x0035, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D7E8, CHAR_CATEGORY_ND, DECOMP_TAG_FONT,
   {0x0036, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D7E9, CHAR_CATEGORY_ND, DECOMP_TAG_FONT,
   {0x0037, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D7EA, CHAR_CATEGORY_ND, DECOMP_TAG_FONT,
   {0x0038, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D7EB, CHAR_CATEGORY_ND, DECOMP_TAG_FONT,
   {0x0039, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D7EC, CHAR_CATEGORY_ND, DECOMP_TAG_FONT,
   {0x0030, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D7ED, CHAR_CATEGORY_ND, DECOMP_TAG_FONT,
   {0x0031, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D7EE, CHAR_CATEGORY_ND, DECOMP_TAG_FONT,
   {0x0032, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D7EF, CHAR_CATEGORY_ND, DECOMP_TAG_FONT,
   {0x0033, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D7F0, CHAR_CATEGORY_ND, DECOMP_TAG_FONT,
   {0x0034, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D7F1, CHAR_CATEGORY_ND, DECOMP_TAG_FONT,
   {0x0035, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D7F2, CHAR_CATEGORY_ND, DECOMP_TAG_FONT,
   {0x0036, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D7F3, CHAR_CATEGORY_ND, DECOMP_TAG_FONT,
   {0x0037, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D7F4, CHAR_CATEGORY_ND, DECOMP_TAG_FONT,
   {0x0038, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D7F5, CHAR_CATEGORY_ND, DECOMP_TAG_FONT,
   {0x0039, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D7F6, CHAR_CATEGORY_ND, DECOMP_TAG_FONT,
   {0x0030, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D7F7, CHAR_CATEGORY_ND, DECOMP_TAG_FONT,
   {0x0031, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D7F8, CHAR_CATEGORY_ND, DECOMP_TAG_FONT,
   {0x0032, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D7F9, CHAR_CATEGORY_ND, DECOMP_TAG_FONT,
   {0x0033, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D7FA, CHAR_CATEGORY_ND, DECOMP_TAG_FONT,
   {0x0034, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D7FB, CHAR_CATEGORY_ND, DECOMP_TAG_FONT,
   {0x0035, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D7FC, CHAR_CATEGORY_ND, DECOMP_TAG_FONT,
   {0x0036, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D7FD, CHAR_CATEGORY_ND, DECOMP_TAG_FONT,
   {0x0037, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D7FE, CHAR_CATEGORY_ND, DECOMP_TAG_FONT,
   {0x0038, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1D7FF, CHAR_CATEGORY_ND, DECOMP_TAG_FONT,
   {0x0039, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EE00, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x0627, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EE01, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x0628, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EE02, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x062C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EE03, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x062F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EE05, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x0648, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EE06, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x0632, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EE07, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x062D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EE08, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x0637, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EE09, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x064A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EE0A, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x0643, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EE0B, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x0644, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EE0C, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x0645, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EE0D, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x0646, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EE0E, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x0633, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EE0F, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x0639, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EE10, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x0641, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EE11, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x0635, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EE12, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x0642, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EE13, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x0631, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EE14, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x0634, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EE15, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x062A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EE16, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x062B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EE17, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x062E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EE18, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x0630, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EE19, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x0636, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EE1A, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x0638, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EE1B, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x063A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EE1C, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x066E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EE1D, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x06BA, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EE1E, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x06A1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EE1F, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x066F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EE21, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x0628, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EE22, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x062C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EE24, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x0647, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EE27, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x062D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EE29, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x064A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EE2A, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x0643, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EE2B, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x0644, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EE2C, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x0645, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EE2D, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x0646, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EE2E, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x0633, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EE2F, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x0639, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EE30, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x0641, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EE31, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x0635, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EE32, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x0642, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EE34, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x0634, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EE35, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x062A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EE36, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x062B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EE37, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x062E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EE39, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x0636, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EE3B, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x063A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EE42, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x062C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EE47, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x062D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EE49, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x064A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EE4B, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x0644, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EE4D, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x0646, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EE4E, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x0633, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EE4F, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x0639, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EE51, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x0635, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EE52, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x0642, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EE54, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x0634, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EE57, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x062E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EE59, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x0636, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EE5B, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x063A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EE5D, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x06BA, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EE5F, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x066F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EE61, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x0628, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EE62, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x062C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EE64, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x0647, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EE67, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x062D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EE68, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x0637, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EE69, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x064A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EE6A, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x0643, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EE6C, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x0645, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EE6D, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x0646, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EE6E, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x0633, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EE6F, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x0639, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EE70, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x0641, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EE71, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x0635, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EE72, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x0642, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EE74, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x0634, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EE75, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x062A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EE76, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x062B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EE77, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x062E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EE79, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x0636, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EE7A, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x0638, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EE7B, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x063A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EE7C, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x066E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EE7E, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x06A1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EE80, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x0627, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EE81, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x0628, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EE82, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x062C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EE83, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x062F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EE84, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x0647, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EE85, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x0648, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EE86, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x0632, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EE87, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x062D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EE88, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x0637, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EE89, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x064A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EE8B, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x0644, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EE8C, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x0645, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EE8D, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x0646, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EE8E, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x0633, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EE8F, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x0639, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EE90, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x0641, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EE91, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x0635, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EE92, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x0642, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EE93, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x0631, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EE94, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x0634, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EE95, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x062A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EE96, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x062B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EE97, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x062E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EE98, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x0630, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EE99, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x0636, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EE9A, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x0638, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EE9B, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x063A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EEA1, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x0628, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EEA2, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x062C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EEA3, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x062F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EEA5, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x0648, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EEA6, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x0632, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EEA7, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x062D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EEA8, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x0637, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EEA9, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x064A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EEAB, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x0644, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EEAC, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x0645, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EEAD, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x0646, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EEAE, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x0633, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EEAF, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x0639, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EEB0, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x0641, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EEB1, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x0635, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EEB2, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x0642, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EEB3, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x0631, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EEB4, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x0634, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EEB5, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x062A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EEB6, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x062B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EEB7, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x062E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EEB8, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x0630, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EEB9, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x0636, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EEBA, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x0638, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1EEBB, CHAR_CATEGORY_LO, DECOMP_TAG_FONT,
   {0x063A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F100, CHAR_CATEGORY_NO, DECOMP_TAG_COMPAT,
   {0x0030, 0x002E, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F101, CHAR_CATEGORY_NO, DECOMP_TAG_COMPAT,
   {0x0030, 0x002C, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F102, CHAR_CATEGORY_NO, DECOMP_TAG_COMPAT,
   {0x0031, 0x002C, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F103, CHAR_CATEGORY_NO, DECOMP_TAG_COMPAT,
   {0x0032, 0x002C, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F104, CHAR_CATEGORY_NO, DECOMP_TAG_COMPAT,
   {0x0033, 0x002C, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F105, CHAR_CATEGORY_NO, DECOMP_TAG_COMPAT,
   {0x0034, 0x002C, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F106, CHAR_CATEGORY_NO, DECOMP_TAG_COMPAT,
   {0x0035, 0x002C, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F107, CHAR_CATEGORY_NO, DECOMP_TAG_COMPAT,
   {0x0036, 0x002C, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F108, CHAR_CATEGORY_NO, DECOMP_TAG_COMPAT,
   {0x0037, 0x002C, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F109, CHAR_CATEGORY_NO, DECOMP_TAG_COMPAT,
   {0x0038, 0x002C, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F10A, CHAR_CATEGORY_NO, DECOMP_TAG_COMPAT,
   {0x0039, 0x002C, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F110, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0028, 0x0041, 0x0029, 0x0000, 0x0000, 0x0000}},
  {0x1F111, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0028, 0x0042, 0x0029, 0x0000, 0x0000, 0x0000}},
  {0x1F112, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0028, 0x0043, 0x0029, 0x0000, 0x0000, 0x0000}},
  {0x1F113, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0028, 0x0044, 0x0029, 0x0000, 0x0000, 0x0000}},
  {0x1F114, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0028, 0x0045, 0x0029, 0x0000, 0x0000, 0x0000}},
  {0x1F115, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0028, 0x0046, 0x0029, 0x0000, 0x0000, 0x0000}},
  {0x1F116, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0028, 0x0047, 0x0029, 0x0000, 0x0000, 0x0000}},
  {0x1F117, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0028, 0x0048, 0x0029, 0x0000, 0x0000, 0x0000}},
  {0x1F118, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0028, 0x0049, 0x0029, 0x0000, 0x0000, 0x0000}},
  {0x1F119, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0028, 0x004A, 0x0029, 0x0000, 0x0000, 0x0000}},
  {0x1F11A, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0028, 0x004B, 0x0029, 0x0000, 0x0000, 0x0000}},
  {0x1F11B, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0028, 0x004C, 0x0029, 0x0000, 0x0000, 0x0000}},
  {0x1F11C, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0028, 0x004D, 0x0029, 0x0000, 0x0000, 0x0000}},
  {0x1F11D, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0028, 0x004E, 0x0029, 0x0000, 0x0000, 0x0000}},
  {0x1F11E, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0028, 0x004F, 0x0029, 0x0000, 0x0000, 0x0000}},
  {0x1F11F, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0028, 0x0050, 0x0029, 0x0000, 0x0000, 0x0000}},
  {0x1F120, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0028, 0x0051, 0x0029, 0x0000, 0x0000, 0x0000}},
  {0x1F121, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0028, 0x0052, 0x0029, 0x0000, 0x0000, 0x0000}},
  {0x1F122, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0028, 0x0053, 0x0029, 0x0000, 0x0000, 0x0000}},
  {0x1F123, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0028, 0x0054, 0x0029, 0x0000, 0x0000, 0x0000}},
  {0x1F124, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0028, 0x0055, 0x0029, 0x0000, 0x0000, 0x0000}},
  {0x1F125, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0028, 0x0056, 0x0029, 0x0000, 0x0000, 0x0000}},
  {0x1F126, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0028, 0x0057, 0x0029, 0x0000, 0x0000, 0x0000}},
  {0x1F127, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0028, 0x0058, 0x0029, 0x0000, 0x0000, 0x0000}},
  {0x1F128, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0028, 0x0059, 0x0029, 0x0000, 0x0000, 0x0000}},
  {0x1F129, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x0028, 0x005A, 0x0029, 0x0000, 0x0000, 0x0000}},
  {0x1F12A, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x3014, 0x0053, 0x3015, 0x0000, 0x0000, 0x0000}},
  {0x1F12B, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x0043, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F12C, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x0052, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F12D, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x0043, 0x0044, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F12E, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x0057, 0x005A, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F130, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x0041, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F131, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x0042, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F132, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x0043, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F133, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x0044, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F134, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x0045, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F135, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x0046, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F136, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x0047, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F137, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x0048, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F138, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x0049, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F139, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x004A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F13A, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x004B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F13B, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x004C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F13C, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x004D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F13D, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x004E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F13E, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x004F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F13F, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x0050, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F140, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x0051, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F141, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x0052, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F142, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x0053, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F143, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x0054, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F144, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x0055, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F145, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x0056, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F146, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x0057, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F147, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x0058, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F148, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x0059, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F149, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x005A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F14A, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x0048, 0x0056, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F14B, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x004D, 0x0056, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F14C, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x0053, 0x0044, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F14D, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x0053, 0x0053, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F14E, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x0050, 0x0050, 0x0056, 0x0000, 0x0000, 0x0000}},
  {0x1F14F, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x0057, 0x0043, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F16A, CHAR_CATEGORY_SO, DECOMP_TAG_SUPER,
   {0x004D, 0x0043, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F16B, CHAR_CATEGORY_SO, DECOMP_TAG_SUPER,
   {0x004D, 0x0044, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F190, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x0044, 0x004A, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F200, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x307B, 0x304B, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F201, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x30B3, 0x30B3, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F202, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x30B5, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F210, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x624B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F211, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x5B57, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F212, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x53CC, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F213, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x30C7, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F214, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x4E8C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F215, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x591A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F216, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x89E3, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F217, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x5929, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F218, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x4EA4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F219, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x6620, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F21A, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x7121, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F21B, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x6599, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F21C, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x524D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F21D, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x5F8C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F21E, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x518D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F21F, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x65B0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F220, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x521D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F221, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x7D42, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F222, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x751F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F223, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x8CA9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F224, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x58F0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F225, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x5439, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F226, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x6F14, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F227, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x6295, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F228, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x6355, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F229, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x4E00, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F22A, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x4E09, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F22B, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x904A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F22C, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x5DE6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F22D, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x4E2D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F22E, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x53F3, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F22F, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x6307, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F230, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x8D70, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F231, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x6253, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F232, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x7981, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F233, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x7A7A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F234, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x5408, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F235, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x6E80, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F236, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x6709, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F237, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x6708, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F238, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x7533, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F239, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x5272, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F23A, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x55B6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F23B, CHAR_CATEGORY_SO, DECOMP_TAG_SQUARE,
   {0x914D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F240, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x3014, 0x672C, 0x3015, 0x0000, 0x0000, 0x0000}},
  {0x1F241, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x3014, 0x4E09, 0x3015, 0x0000, 0x0000, 0x0000}},
  {0x1F242, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x3014, 0x4E8C, 0x3015, 0x0000, 0x0000, 0x0000}},
  {0x1F243, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x3014, 0x5B89, 0x3015, 0x0000, 0x0000, 0x0000}},
  {0x1F244, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x3014, 0x70B9, 0x3015, 0x0000, 0x0000, 0x0000}},
  {0x1F245, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x3014, 0x6253, 0x3015, 0x0000, 0x0000, 0x0000}},
  {0x1F246, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x3014, 0x76D7, 0x3015, 0x0000, 0x0000, 0x0000}},
  {0x1F247, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x3014, 0x52DD, 0x3015, 0x0000, 0x0000, 0x0000}},
  {0x1F248, CHAR_CATEGORY_SO, DECOMP_TAG_COMPAT,
   {0x3014, 0x6557, 0x3015, 0x0000, 0x0000, 0x0000}},
  {0x1F250, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x5F97, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x1F251, CHAR_CATEGORY_SO, DECOMP_TAG_CIRCLE,
   {0x53EF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F800, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x4E3D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F801, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x4E38, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F802, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x4E41, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F803, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x20122, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F804, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x4F60, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F805, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x4FAE, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F806, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x4FBB, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F807, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x5002, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F808, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x507A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F809, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x5099, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F80A, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x50E7, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F80B, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x50CF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F80C, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x349E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F80D, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x2063A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F80E, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x514D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F80F, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x5154, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F810, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x5164, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F811, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x5177, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F812, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x2051C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F813, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x34B9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F814, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x5167, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F815, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x518D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F816, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x2054B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F817, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x5197, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F818, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x51A4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F819, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x4ECC, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F81A, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x51AC, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F81B, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x51B5, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F81C, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x291DF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F81D, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x51F5, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F81E, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x5203, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F81F, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x34DF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F820, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x523B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F821, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x5246, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F822, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x5272, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F823, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x5277, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F824, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x3515, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F825, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x52C7, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F826, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x52C9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F827, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x52E4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F828, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x52FA, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F829, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x5305, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F82A, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x5306, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F82B, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x5317, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F82C, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x5349, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F82D, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x5351, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F82E, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x535A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F82F, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x5373, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F830, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x537D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F831, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x537F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F832, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x537F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F833, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x537F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F834, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x20A2C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F835, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x7070, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F836, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x53CA, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F837, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x53DF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F838, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x20B63, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F839, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x53EB, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F83A, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x53F1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F83B, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x5406, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F83C, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x549E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F83D, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x5438, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F83E, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x5448, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F83F, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x5468, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F840, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x54A2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F841, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x54F6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F842, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x5510, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F843, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x5553, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F844, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x5563, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F845, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x5584, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F846, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x5584, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F847, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x5599, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F848, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x55AB, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F849, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x55B3, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F84A, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x55C2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F84B, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x5716, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F84C, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x5606, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F84D, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x5717, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F84E, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x5651, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F84F, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x5674, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F850, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x5207, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F851, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x58EE, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F852, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x57CE, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F853, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x57F4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F854, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x580D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F855, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x578B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F856, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x5832, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F857, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x5831, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F858, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x58AC, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F859, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x214E4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F85A, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x58F2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F85B, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x58F7, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F85C, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x5906, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F85D, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x591A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F85E, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x5922, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F85F, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x5962, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F860, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x216A8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F861, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x216EA, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F862, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x59EC, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F863, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x5A1B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F864, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x5A27, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F865, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x59D8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F866, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x5A66, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F867, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x36EE, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F868, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x36FC, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F869, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x5B08, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F86A, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x5B3E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F86B, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x5B3E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F86C, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x219C8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F86D, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x5BC3, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F86E, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x5BD8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F86F, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x5BE7, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F870, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x5BF3, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F871, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x21B18, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F872, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x5BFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F873, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x5C06, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F874, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x5F53, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F875, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x5C22, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F876, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x3781, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F877, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x5C60, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F878, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x5C6E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F879, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x5CC0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F87A, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x5C8D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F87B, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x21DE4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F87C, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x5D43, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F87D, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x21DE6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F87E, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x5D6E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F87F, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x5D6B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F880, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x5D7C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F881, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x5DE1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F882, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x5DE2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F883, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x382F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F884, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x5DFD, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F885, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x5E28, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F886, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x5E3D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F887, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x5E69, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F888, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x3862, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F889, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x22183, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F88A, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x387C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F88B, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x5EB0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F88C, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x5EB3, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F88D, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x5EB6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F88E, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x5ECA, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F88F, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x2A392, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F890, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x5EFE, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F891, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x22331, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F892, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x22331, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F893, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x8201, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F894, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x5F22, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F895, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x5F22, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F896, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x38C7, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F897, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x232B8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F898, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x261DA, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F899, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x5F62, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F89A, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x5F6B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F89B, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x38E3, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F89C, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x5F9A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F89D, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x5FCD, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F89E, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x5FD7, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F89F, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x5FF9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F8A0, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x6081, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F8A1, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x393A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F8A2, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x391C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F8A3, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x6094, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F8A4, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x226D4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F8A5, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x60C7, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F8A6, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x6148, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F8A7, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x614C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F8A8, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x614E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F8A9, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x614C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F8AA, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x617A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F8AB, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x618E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F8AC, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x61B2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F8AD, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x61A4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F8AE, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x61AF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F8AF, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x61DE, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F8B0, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x61F2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F8B1, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x61F6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F8B2, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x6210, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F8B3, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x621B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F8B4, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x625D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F8B5, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x62B1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F8B6, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x62D4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F8B7, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x6350, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F8B8, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x22B0C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F8B9, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x633D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F8BA, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x62FC, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F8BB, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x6368, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F8BC, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x6383, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F8BD, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x63E4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F8BE, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x22BF1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F8BF, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x6422, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F8C0, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x63C5, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F8C1, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x63A9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F8C2, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x3A2E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F8C3, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x6469, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F8C4, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x647E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F8C5, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x649D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F8C6, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x6477, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F8C7, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x3A6C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F8C8, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x654F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F8C9, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x656C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F8CA, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x2300A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F8CB, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x65E3, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F8CC, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x66F8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F8CD, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x6649, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F8CE, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x3B19, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F8CF, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x6691, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F8D0, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x3B08, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F8D1, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x3AE4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F8D2, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x5192, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F8D3, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x5195, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F8D4, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x6700, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F8D5, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x669C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F8D6, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x80AD, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F8D7, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x43D9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F8D8, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x6717, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F8D9, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x671B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F8DA, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x6721, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F8DB, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x675E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F8DC, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x6753, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F8DD, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x233C3, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F8DE, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x3B49, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F8DF, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x67FA, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F8E0, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x6785, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F8E1, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x6852, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F8E2, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x6885, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F8E3, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x2346D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F8E4, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x688E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F8E5, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x681F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F8E6, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x6914, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F8E7, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x3B9D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F8E8, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x6942, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F8E9, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x69A3, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F8EA, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x69EA, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F8EB, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x6AA8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F8EC, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x236A3, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F8ED, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x6ADB, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F8EE, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x3C18, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F8EF, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x6B21, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F8F0, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x238A7, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F8F1, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x6B54, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F8F2, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x3C4E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F8F3, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x6B72, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F8F4, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x6B9F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F8F5, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x6BBA, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F8F6, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x6BBB, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F8F7, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x23A8D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F8F8, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x21D0B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F8F9, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x23AFA, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F8FA, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x6C4E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F8FB, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x23CBC, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F8FC, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x6CBF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F8FD, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x6CCD, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F8FE, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x6C67, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F8FF, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x6D16, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F900, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x6D3E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F901, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x6D77, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F902, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x6D41, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F903, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x6D69, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F904, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x6D78, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F905, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x6D85, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F906, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x23D1E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F907, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x6D34, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F908, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x6E2F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F909, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x6E6E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F90A, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x3D33, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F90B, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x6ECB, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F90C, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x6EC7, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F90D, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x23ED1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F90E, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x6DF9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F90F, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x6F6E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F910, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x23F5E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F911, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x23F8E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F912, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x6FC6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F913, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x7039, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F914, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x701E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F915, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x701B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F916, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x3D96, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F917, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x704A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F918, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x707D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F919, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x7077, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F91A, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x70AD, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F91B, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x20525, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F91C, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x7145, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F91D, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x24263, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F91E, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x719C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F91F, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x243AB, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F920, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x7228, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F921, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x7235, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F922, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x7250, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F923, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x24608, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F924, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x7280, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F925, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x7295, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F926, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x24735, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F927, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x24814, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F928, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x737A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F929, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x738B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F92A, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x3EAC, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F92B, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x73A5, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F92C, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x3EB8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F92D, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x3EB8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F92E, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x7447, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F92F, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x745C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F930, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x7471, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F931, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x7485, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F932, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x74CA, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F933, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x3F1B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F934, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x7524, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F935, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x24C36, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F936, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x753E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F937, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x24C92, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F938, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x7570, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F939, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x2219F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F93A, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x7610, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F93B, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x24FA1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F93C, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x24FB8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F93D, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x25044, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F93E, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x3FFC, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F93F, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x4008, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F940, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x76F4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F941, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x250F3, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F942, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x250F2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F943, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x25119, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F944, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x25133, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F945, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x771E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F946, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x771F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F947, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x771F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F948, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x774A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F949, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x4039, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F94A, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x778B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F94B, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x4046, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F94C, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x4096, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F94D, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x2541D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F94E, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x784E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F94F, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x788C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F950, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x78CC, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F951, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x40E3, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F952, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x25626, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F953, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x7956, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F954, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x2569A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F955, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x256C5, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F956, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x798F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F957, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x79EB, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F958, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x412F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F959, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x7A40, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F95A, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x7A4A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F95B, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x7A4F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F95C, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x2597C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F95D, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x25AA7, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F95E, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x25AA7, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F95F, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x7AEE, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F960, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x4202, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F961, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x25BAB, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F962, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x7BC6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F963, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x7BC9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F964, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x4227, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F965, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x25C80, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F966, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x7CD2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F967, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x42A0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F968, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x7CE8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F969, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x7CE3, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F96A, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x7D00, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F96B, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x25F86, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F96C, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x7D63, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F96D, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x4301, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F96E, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x7DC7, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F96F, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x7E02, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F970, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x7E45, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F971, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x4334, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F972, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x26228, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F973, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x26247, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F974, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x4359, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F975, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x262D9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F976, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x7F7A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F977, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x2633E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F978, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x7F95, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F979, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x7FFA, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F97A, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x8005, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F97B, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x264DA, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F97C, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x26523, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F97D, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x8060, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F97E, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x265A8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F97F, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x8070, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F980, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x2335F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F981, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x43D5, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F982, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x80B2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F983, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x8103, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F984, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x440B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F985, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x813E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F986, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x5AB5, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F987, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x267A7, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F988, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x267B5, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F989, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x23393, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F98A, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x2339C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F98B, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x8201, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F98C, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x8204, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F98D, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x8F9E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F98E, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x446B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F98F, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x8291, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F990, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x828B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F991, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x829D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F992, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x52B3, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F993, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x82B1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F994, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x82B3, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F995, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x82BD, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F996, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x82E6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F997, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x26B3C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F998, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x82E5, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F999, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x831D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F99A, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x8363, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F99B, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x83AD, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F99C, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x8323, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F99D, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x83BD, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F99E, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x83E7, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F99F, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x8457, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F9A0, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x8353, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F9A1, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x83CA, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F9A2, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x83CC, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F9A3, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x83DC, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F9A4, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x26C36, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F9A5, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x26D6B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F9A6, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x26CD5, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F9A7, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x452B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F9A8, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x84F1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F9A9, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x84F3, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F9AA, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x8516, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F9AB, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x273CA, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F9AC, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x8564, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F9AD, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x26F2C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F9AE, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x455D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F9AF, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x4561, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F9B0, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x26FB1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F9B1, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x270D2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F9B2, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x456B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F9B3, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x8650, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F9B4, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x865C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F9B5, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x8667, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F9B6, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x8669, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F9B7, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x86A9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F9B8, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x8688, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F9B9, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x870E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F9BA, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x86E2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F9BB, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x8779, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F9BC, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x8728, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F9BD, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x876B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F9BE, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x8786, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F9BF, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x45D7, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F9C0, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x87E1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F9C1, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x8801, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F9C2, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x45F9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F9C3, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x8860, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F9C4, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x8863, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F9C5, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x27667, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F9C6, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x88D7, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F9C7, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x88DE, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F9C8, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x4635, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F9C9, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x88FA, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F9CA, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x34BB, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F9CB, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x278AE, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F9CC, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x27966, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F9CD, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x46BE, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F9CE, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x46C7, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F9CF, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x8AA0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F9D0, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x8AED, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F9D1, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x8B8A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F9D2, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x8C55, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F9D3, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x27CA8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F9D4, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x8CAB, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F9D5, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x8CC1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F9D6, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x8D1B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F9D7, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x8D77, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F9D8, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x27F2F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F9D9, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x20804, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F9DA, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x8DCB, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F9DB, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x8DBC, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F9DC, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x8DF0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F9DD, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x208DE, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F9DE, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x8ED4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F9DF, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x8F38, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F9E0, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x285D2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F9E1, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x285ED, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F9E2, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x9094, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F9E3, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x90F1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F9E4, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x9111, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F9E5, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x2872E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F9E6, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x911B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F9E7, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x9238, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F9E8, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x92D7, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F9E9, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x92D8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F9EA, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x927C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F9EB, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x93F9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F9EC, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x9415, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F9ED, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x28BFA, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F9EE, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x958B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F9EF, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x4995, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F9F0, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x95B7, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F9F1, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x28D77, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F9F2, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x49E6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F9F3, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x96C3, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F9F4, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x5DB2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F9F5, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x9723, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F9F6, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x29145, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F9F7, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x2921A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F9F8, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x4A6E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F9F9, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x4A76, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F9FA, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x97E0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F9FB, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x2940A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F9FC, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x4AB2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F9FD, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x29496, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F9FE, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x980B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2F9FF, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x980B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2FA00, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x9829, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2FA01, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x295B6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2FA02, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x98E2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2FA03, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x4B33, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2FA04, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x9929, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2FA05, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x99A7, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2FA06, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x99C2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2FA07, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x99FE, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2FA08, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x4BCE, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2FA09, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x29B30, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2FA0A, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x9B12, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2FA0B, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x9C40, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2FA0C, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x9CFD, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2FA0D, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x4CCE, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2FA0E, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x4CED, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2FA0F, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x9D67, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2FA10, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x2A0CE, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2FA11, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x4CF8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2FA12, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x2A105, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2FA13, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x2A20E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2FA14, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x2A291, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2FA15, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x9EBB, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2FA16, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x4D56, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2FA17, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x9EF9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2FA18, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x9EFE, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2FA19, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x9F05, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2FA1A, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x9F0F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2FA1B, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x9F16, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2FA1C, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x9F3B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
  {0x2FA1D, CHAR_CATEGORY_LO, DECOMP_TAG_NONE,
   {0x2A600, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}},
};

struct Combining_mark
{
  my_wc_t   charcode;
  int       ccc; //Canonical_Combining_Class
};

/*
  All the combining marks whose ccc value is greater than 0.
  Gerneral_Category is Mn.
*/
Combining_mark combining_marks[]= {
  {0x0300, 230}, {0x0301, 230}, {0x0302, 230}, {0x0303, 230},
  {0x0304, 230}, {0x0305, 230}, {0x0306, 230}, {0x0307, 230},
  {0x0308, 230}, {0x0309, 230}, {0x030A, 230}, {0x030B, 230},
  {0x030C, 230}, {0x030D, 230}, {0x030E, 230}, {0x030F, 230},
  {0x0310, 230}, {0x0311, 230}, {0x0312, 230}, {0x0313, 230},
  {0x0314, 230}, {0x0315, 232}, {0x0316, 220}, {0x0317, 220},
  {0x0318, 220}, {0x0319, 220}, {0x031A, 232}, {0x031B, 216},
  {0x031C, 220}, {0x031D, 220}, {0x031E, 220}, {0x031F, 220},
  {0x0320, 220}, {0x0321, 202}, {0x0322, 202}, {0x0323, 220},
  {0x0324, 220}, {0x0325, 220}, {0x0326, 220}, {0x0327, 202},
  {0x0328, 202}, {0x0329, 220}, {0x032A, 220}, {0x032B, 220},
  {0x032C, 220}, {0x032D, 220}, {0x032E, 220}, {0x032F, 220},
  {0x0330, 220}, {0x0331, 220}, {0x0332, 220}, {0x0333, 220},
  {0x0334, 1},   {0x0335, 1},   {0x0336, 1},   {0x0337, 1},
  {0x0338, 1},   {0x0339, 220}, {0x033A, 220}, {0x033B, 220},
  {0x033C, 220}, {0x033D, 230}, {0x033E, 230}, {0x033F, 230},
  {0x0340, 230}, {0x0341, 230}, {0x0342, 230}, {0x0343, 230},
  {0x0344, 230}, {0x0345, 240}, {0x0346, 230}, {0x0347, 220},
  {0x0348, 220}, {0x0349, 220}, {0x034A, 230}, {0x034B, 230},
  {0x034C, 230}, {0x034D, 220}, {0x034E, 220}, {0x0350, 230},
  {0x0351, 230}, {0x0352, 230}, {0x0353, 220}, {0x0354, 220},
  {0x0355, 220}, {0x0356, 220}, {0x0357, 230}, {0x0358, 232},
  {0x0359, 220}, {0x035A, 220}, {0x035B, 230}, {0x035C, 233},
  {0x035D, 234}, {0x035E, 234}, {0x035F, 233}, {0x0360, 234},
  {0x0361, 234}, {0x0362, 233}, {0x0363, 230}, {0x0364, 230},
  {0x0365, 230}, {0x0366, 230}, {0x0367, 230}, {0x0368, 230},
  {0x0369, 230}, {0x036A, 230}, {0x036B, 230}, {0x036C, 230},
  {0x036D, 230}, {0x036E, 230}, {0x036F, 230}, {0x0483, 230},
  {0x0484, 230}, {0x0485, 230}, {0x0486, 230}, {0x0487, 230},
  {0x0591, 220}, {0x0592, 230}, {0x0593, 230}, {0x0594, 230},
  {0x0595, 230}, {0x0596, 220}, {0x0597, 230}, {0x0598, 230},
  {0x0599, 230}, {0x059A, 222}, {0x059B, 220}, {0x059C, 230},
  {0x059D, 230}, {0x059E, 230}, {0x059F, 230}, {0x05A0, 230},
  {0x05A1, 230}, {0x05A2, 220}, {0x05A3, 220}, {0x05A4, 220},
  {0x05A5, 220}, {0x05A6, 220}, {0x05A7, 220}, {0x05A8, 230},
  {0x05A9, 230}, {0x05AA, 220}, {0x05AB, 230}, {0x05AC, 230},
  {0x05AD, 222}, {0x05AE, 228}, {0x05AF, 230}, {0x05B0, 10},
  {0x05B1, 11},  {0x05B2, 12},  {0x05B3, 13},  {0x05B4, 14},
  {0x05B5, 15},  {0x05B6, 16},  {0x05B7, 17},  {0x05B8, 18},
  {0x05B9, 19},  {0x05BA, 19},  {0x05BB, 20},  {0x05BC, 21},
  {0x05BD, 22},  {0x05BF, 23},  {0x05C1, 24},  {0x05C2, 25},
  {0x05C4, 230}, {0x05C5, 220}, {0x05C7, 18},  {0x0610, 230},
  {0x0611, 230}, {0x0612, 230}, {0x0613, 230}, {0x0614, 230},
  {0x0615, 230}, {0x0616, 230}, {0x0617, 230}, {0x0618, 30},
  {0x0619, 31},  {0x061A, 32},  {0x064B, 27},  {0x064C, 28},
  {0x064D, 29},  {0x064E, 30},  {0x064F, 31},  {0x0650, 32},
  {0x0651, 33},  {0x0652, 34},  {0x0653, 230}, {0x0654, 230},
  {0x0655, 220}, {0x0656, 220}, {0x0657, 230}, {0x0658, 230},
  {0x0659, 230}, {0x065A, 230}, {0x065B, 230}, {0x065C, 220},
  {0x065D, 230}, {0x065E, 230}, {0x065F, 220}, {0x0670, 35},
  {0x06D6, 230}, {0x06D7, 230}, {0x06D8, 230}, {0x06D9, 230},
  {0x06DA, 230}, {0x06DB, 230}, {0x06DC, 230}, {0x06DF, 230},
  {0x06E0, 230}, {0x06E1, 230}, {0x06E2, 230}, {0x06E3, 220},
  {0x06E4, 230}, {0x06E7, 230}, {0x06E8, 230}, {0x06EA, 220},
  {0x06EB, 230}, {0x06EC, 230}, {0x06ED, 220}, {0x0711, 36},
  {0x0730, 230}, {0x0731, 220}, {0x0732, 230}, {0x0733, 230},
  {0x0734, 220}, {0x0735, 230}, {0x0736, 230}, {0x0737, 220},
  {0x0738, 220}, {0x0739, 220}, {0x073A, 230}, {0x073B, 220},
  {0x073C, 220}, {0x073D, 230}, {0x073E, 220}, {0x073F, 230},
  {0x0740, 230}, {0x0741, 230}, {0x0742, 220}, {0x0743, 230},
  {0x0744, 220}, {0x0745, 230}, {0x0746, 220}, {0x0747, 230},
  {0x0748, 220}, {0x0749, 230}, {0x074A, 230}, {0x07EB, 230},
  {0x07EC, 230}, {0x07ED, 230}, {0x07EE, 230}, {0x07EF, 230},
  {0x07F0, 230}, {0x07F1, 230}, {0x07F2, 220}, {0x07F3, 230},
  {0x0816, 230}, {0x0817, 230}, {0x0818, 230}, {0x0819, 230},
  {0x081B, 230}, {0x081C, 230}, {0x081D, 230}, {0x081E, 230},
  {0x081F, 230}, {0x0820, 230}, {0x0821, 230}, {0x0822, 230},
  {0x0823, 230}, {0x0825, 230}, {0x0826, 230}, {0x0827, 230},
  {0x0829, 230}, {0x082A, 230}, {0x082B, 230}, {0x082C, 230},
  {0x082D, 230}, {0x0859, 220}, {0x085A, 220}, {0x085B, 220},
  {0x08D4, 230}, {0x08D5, 230}, {0x08D6, 230}, {0x08D7, 230},
  {0x08D8, 230}, {0x08D9, 230}, {0x08DA, 230}, {0x08DB, 230},
  {0x08DC, 230}, {0x08DD, 230}, {0x08DE, 230}, {0x08DF, 230},
  {0x08E0, 230}, {0x08E1, 230}, {0x08E3, 220}, {0x08E4, 230},
  {0x08E5, 230}, {0x08E6, 220}, {0x08E7, 230}, {0x08E8, 230},
  {0x08E9, 220}, {0x08EA, 230}, {0x08EB, 230}, {0x08EC, 230},
  {0x08ED, 220}, {0x08EE, 220}, {0x08EF, 220}, {0x08F0, 27},
  {0x08F1, 28},  {0x08F2, 29},  {0x08F3, 230}, {0x08F4, 230},
  {0x08F5, 230}, {0x08F6, 220}, {0x08F7, 230}, {0x08F8, 230},
  {0x08F9, 220}, {0x08FA, 220}, {0x08FB, 230}, {0x08FC, 230},
  {0x08FD, 230}, {0x08FE, 230}, {0x08FF, 230}, {0x093C, 7},
  {0x094D, 9},   {0x0951, 230}, {0x0952, 220}, {0x0953, 230},
  {0x0954, 230}, {0x09BC, 7},   {0x09CD, 9},   {0x0A3C, 7},
  {0x0A4D, 9},   {0x0ABC, 7},   {0x0ACD, 9},   {0x0B3C, 7},
  {0x0B4D, 9},   {0x0BCD, 9},   {0x0C4D, 9},   {0x0C55, 84},
  {0x0C56, 91},  {0x0CBC, 7},   {0x0CCD, 9},   {0x0D4D, 9},
  {0x0DCA, 9},   {0x0E38, 103}, {0x0E39, 103}, {0x0E3A, 9},
  {0x0E48, 107}, {0x0E49, 107}, {0x0E4A, 107}, {0x0E4B, 107},
  {0x0EB8, 118}, {0x0EB9, 118}, {0x0EC8, 122}, {0x0EC9, 122},
  {0x0ECA, 122}, {0x0ECB, 122}, {0x0F18, 220}, {0x0F19, 220},
  {0x0F35, 220}, {0x0F37, 220}, {0x0F39, 216}, {0x0F71, 129},
  {0x0F72, 130}, {0x0F74, 132}, {0x0F7A, 130}, {0x0F7B, 130},
  {0x0F7C, 130}, {0x0F7D, 130}, {0x0F80, 130}, {0x0F82, 230},
  {0x0F83, 230}, {0x0F84, 9},   {0x0F86, 230}, {0x0F87, 230},
  {0x0FC6, 220}, {0x1037, 7},   {0x1039, 9},   {0x103A, 9},
  {0x108D, 220}, {0x135D, 230}, {0x135E, 230}, {0x135F, 230},
  {0x1714, 9},   {0x1734, 9},   {0x17D2, 9},   {0x17DD, 230},
  {0x18A9, 228}, {0x1939, 222}, {0x193A, 230}, {0x193B, 220},
  {0x1A17, 230}, {0x1A18, 220}, {0x1A60, 9},   {0x1A75, 230},
  {0x1A76, 230}, {0x1A77, 230}, {0x1A78, 230}, {0x1A79, 230},
  {0x1A7A, 230}, {0x1A7B, 230}, {0x1A7C, 230}, {0x1A7F, 220},
  {0x1AB0, 230}, {0x1AB1, 230}, {0x1AB2, 230}, {0x1AB3, 230},
  {0x1AB4, 230}, {0x1AB5, 220}, {0x1AB6, 220}, {0x1AB7, 220},
  {0x1AB8, 220}, {0x1AB9, 220}, {0x1ABA, 220}, {0x1ABB, 230},
  {0x1ABC, 230}, {0x1ABD, 220}, {0x1B34, 7},   {0x1B6B, 230},
  {0x1B6C, 220}, {0x1B6D, 230}, {0x1B6E, 230}, {0x1B6F, 230},
  {0x1B70, 230}, {0x1B71, 230}, {0x1B72, 230}, {0x1B73, 230},
  {0x1BAB, 9},   {0x1BE6, 7},   {0x1C37, 7},   {0x1CD0, 230},
  {0x1CD1, 230}, {0x1CD2, 230}, {0x1CD4, 1},   {0x1CD5, 220},
  {0x1CD6, 220}, {0x1CD7, 220}, {0x1CD8, 220}, {0x1CD9, 220},
  {0x1CDA, 230}, {0x1CDB, 230}, {0x1CDC, 220}, {0x1CDD, 220},
  {0x1CDE, 220}, {0x1CDF, 220}, {0x1CE0, 230}, {0x1CE2, 1},
  {0x1CE3, 1},   {0x1CE4, 1},   {0x1CE5, 1},   {0x1CE6, 1},
  {0x1CE7, 1},   {0x1CE8, 1},   {0x1CED, 220}, {0x1CF4, 230},
  {0x1CF8, 230}, {0x1CF9, 230}, {0x1DC0, 230}, {0x1DC1, 230},
  {0x1DC2, 220}, {0x1DC3, 230}, {0x1DC4, 230}, {0x1DC5, 230},
  {0x1DC6, 230}, {0x1DC7, 230}, {0x1DC8, 230}, {0x1DC9, 230},
  {0x1DCA, 220}, {0x1DCB, 230}, {0x1DCC, 230}, {0x1DCD, 234},
  {0x1DCE, 214}, {0x1DCF, 220}, {0x1DD0, 202}, {0x1DD1, 230},
  {0x1DD2, 230}, {0x1DD3, 230}, {0x1DD4, 230}, {0x1DD5, 230},
  {0x1DD6, 230}, {0x1DD7, 230}, {0x1DD8, 230}, {0x1DD9, 230},
  {0x1DDA, 230}, {0x1DDB, 230}, {0x1DDC, 230}, {0x1DDD, 230},
  {0x1DDE, 230}, {0x1DDF, 230}, {0x1DE0, 230}, {0x1DE1, 230},
  {0x1DE2, 230}, {0x1DE3, 230}, {0x1DE4, 230}, {0x1DE5, 230},
  {0x1DE6, 230}, {0x1DE7, 230}, {0x1DE8, 230}, {0x1DE9, 230},
  {0x1DEA, 230}, {0x1DEB, 230}, {0x1DEC, 230}, {0x1DED, 230},
  {0x1DEE, 230}, {0x1DEF, 230}, {0x1DF0, 230}, {0x1DF1, 230},
  {0x1DF2, 230}, {0x1DF3, 230}, {0x1DF4, 230}, {0x1DF5, 230},
  {0x1DFB, 230}, {0x1DFC, 233}, {0x1DFD, 220}, {0x1DFE, 230},
  {0x1DFF, 220}, {0x20D0, 230}, {0x20D1, 230}, {0x20D2, 1},
  {0x20D3, 1},   {0x20D4, 230}, {0x20D5, 230}, {0x20D6, 230},
  {0x20D7, 230}, {0x20D8, 1},   {0x20D9, 1},   {0x20DA, 1},
  {0x20DB, 230}, {0x20DC, 230}, {0x20E1, 230}, {0x20E5, 1},
  {0x20E6, 1},   {0x20E7, 230}, {0x20E8, 220}, {0x20E9, 230},
  {0x20EA, 1},   {0x20EB, 1},   {0x20EC, 220}, {0x20ED, 220},
  {0x20EE, 220}, {0x20EF, 220}, {0x20F0, 230}, {0x2CEF, 230},
  {0x2CF0, 230}, {0x2CF1, 230}, {0x2D7F, 9},   {0x2DE0, 230},
  {0x2DE1, 230}, {0x2DE2, 230}, {0x2DE3, 230}, {0x2DE4, 230},
  {0x2DE5, 230}, {0x2DE6, 230}, {0x2DE7, 230}, {0x2DE8, 230},
  {0x2DE9, 230}, {0x2DEA, 230}, {0x2DEB, 230}, {0x2DEC, 230},
  {0x2DED, 230}, {0x2DEE, 230}, {0x2DEF, 230}, {0x2DF0, 230},
  {0x2DF1, 230}, {0x2DF2, 230}, {0x2DF3, 230}, {0x2DF4, 230},
  {0x2DF5, 230}, {0x2DF6, 230}, {0x2DF7, 230}, {0x2DF8, 230},
  {0x2DF9, 230}, {0x2DFA, 230}, {0x2DFB, 230}, {0x2DFC, 230},
  {0x2DFD, 230}, {0x2DFE, 230}, {0x2DFF, 230}, {0x302A, 218},
  {0x302B, 228}, {0x302C, 232}, {0x302D, 222}, {0x3099, 8},
  {0x309A, 8},   {0xA66F, 230}, {0xA674, 230}, {0xA675, 230},
  {0xA676, 230}, {0xA677, 230}, {0xA678, 230}, {0xA679, 230},
  {0xA67A, 230}, {0xA67B, 230}, {0xA67C, 230}, {0xA67D, 230},
  {0xA69E, 230}, {0xA69F, 230}, {0xA6F0, 230}, {0xA6F1, 230},
  {0xA806, 9},   {0xA8C4, 9},   {0xA8E0, 230}, {0xA8E1, 230},
  {0xA8E2, 230}, {0xA8E3, 230}, {0xA8E4, 230}, {0xA8E5, 230},
  {0xA8E6, 230}, {0xA8E7, 230}, {0xA8E8, 230}, {0xA8E9, 230},
  {0xA8EA, 230}, {0xA8EB, 230}, {0xA8EC, 230}, {0xA8ED, 230},
  {0xA8EE, 230}, {0xA8EF, 230}, {0xA8F0, 230}, {0xA8F1, 230},
  {0xA92B, 220}, {0xA92C, 220}, {0xA92D, 220}, {0xA9B3, 7},
  {0xAAB0, 230}, {0xAAB2, 230}, {0xAAB3, 230}, {0xAAB4, 220},
  {0xAAB7, 230}, {0xAAB8, 230}, {0xAABE, 230}, {0xAABF, 230},
  {0xAAC1, 230}, {0xAAF6, 9},   {0xABED, 9},   {0xFB1E, 26},
  {0xFE20, 230}, {0xFE21, 230}, {0xFE22, 230}, {0xFE23, 230},
  {0xFE24, 230}, {0xFE25, 230}, {0xFE26, 230}, {0xFE27, 220},
  {0xFE28, 220}, {0xFE29, 220}, {0xFE2A, 220}, {0xFE2B, 220},
  {0xFE2C, 220}, {0xFE2D, 220}, {0xFE2E, 230}, {0xFE2F, 230},
  {0x101FD, 220},{0x102E0, 220},{0x10376, 230},{0x10377, 230},
  {0x10378, 230},{0x10379, 230},{0x1037A, 230},{0x10A0D, 220},
  {0x10A0F, 230},{0x10A38, 230},{0x10A39, 1},  {0x10A3A, 220},
  {0x10A3F, 9},  {0x10AE5, 230},{0x10AE6, 220},{0x11046, 9},
  {0x1107F, 9},  {0x110B9, 9},  {0x110BA, 7},  {0x11100, 230},
  {0x11101, 230},{0x11102, 230},{0x11133, 9},  {0x11134, 9},
  {0x11173, 7},  {0x111CA, 7},  {0x11236, 7},  {0x112E9, 7},
  {0x112EA, 9},  {0x1133C, 7},  {0x11366, 230},{0x11367, 230},
  {0x11368, 230},{0x11369, 230},{0x1136A, 230},{0x1136B, 230},
  {0x1136C, 230},{0x11370, 230},{0x11371, 230},{0x11372, 230},
  {0x11373, 230},{0x11374, 230},{0x11442, 9},  {0x11446, 7},
  {0x114C2, 9},  {0x114C3, 7},  {0x115BF, 9},  {0x115C0, 7},
  {0x1163F, 9},  {0x116B7, 7},  {0x1172B, 9},  {0x11C3F, 9},
  {0x16AF0, 1},  {0x16AF1, 1},  {0x16AF2, 1},  {0x16AF3, 1},
  {0x16AF4, 1},  {0x16B30, 230},{0x16B31, 230},{0x16B32, 230},
  {0x16B33, 230},{0x16B34, 230},{0x16B35, 230},{0x16B36, 230},
  {0x1BC9E, 1},  {0x1D167, 1},  {0x1D168, 1},  {0x1D169, 1},
  {0x1D17B, 220},{0x1D17C, 220},{0x1D17D, 220},{0x1D17E, 220},
  {0x1D17F, 220},{0x1D180, 220},{0x1D181, 220},{0x1D182, 220},
  {0x1D185, 230},{0x1D186, 230},{0x1D187, 230},{0x1D188, 230},
  {0x1D189, 230},{0x1D18A, 220},{0x1D18B, 220},{0x1D1AA, 230},
  {0x1D1AB, 230},{0x1D1AC, 230},{0x1D1AD, 230},{0x1D242, 230},
  {0x1D243, 230},{0x1D244, 230},{0x1E000, 230},{0x1E001, 230},
  {0x1E002, 230},{0x1E003, 230},{0x1E004, 230},{0x1E005, 230},
  {0x1E006, 230},{0x1E008, 230},{0x1E009, 230},{0x1E00A, 230},
  {0x1E00B, 230},{0x1E00C, 230},{0x1E00D, 230},{0x1E00E, 230},
  {0x1E00F, 230},{0x1E010, 230},{0x1E011, 230},{0x1E012, 230},
  {0x1E013, 230},{0x1E014, 230},{0x1E015, 230},{0x1E016, 230},
  {0x1E017, 230},{0x1E018, 230},{0x1E01B, 230},{0x1E01C, 230},
  {0x1E01D, 230},{0x1E01E, 230},{0x1E01F, 230},{0x1E020, 230},
  {0x1E021, 230},{0x1E023, 230},{0x1E024, 230},{0x1E026, 230},
  {0x1E027, 230},{0x1E028, 230},{0x1E029, 230},{0x1E02A, 230},
  {0x1E8D0, 220},{0x1E8D1, 220},{0x1E8D2, 220},{0x1E8D3, 220},
  {0x1E8D4, 220},{0x1E8D5, 220},{0x1E8D6, 220},{0x1E944, 230},
  {0x1E945, 230},{0x1E946, 230},{0x1E947, 230},{0x1E948, 230},
  {0x1E949, 230},{0x1E94A, 7}
};

struct Char_grp_info
{
  enum_char_grp    group;
  Weight_boundary  grp_wt_bdy;
};

const uint16 START_WEIGHT_TO_REORDER= 0x1C47;

Char_grp_info char_grp_infos[]= {
  {CHARGRP_CORE,     {0,      0x1C46}}, //space, punctuation, symbol,
                                        //currency, digit and all
                                        //primary ignorable characters
  {CHARGRP_LATIN,    {0x1C47, 0x1FB5}},
  {CHARGRP_CYRILLIC, {0x2022, 0x21E1}},
  {CHARGRP_ARAB,     {0x22FD, 0x23D6}},
  {CHARGRP_KANA,     {0x3D5A, 0x3D8B}}
};

/*
  In UCA 9.0.0, every collation element has three weights.
  To make one character's weight data aligned with those
  who have more collation elements in same page, we have
  to add zero values. To track the real collation element
  number, add one additional number at the start to record it.
  Use the macros below to look up the weights for the first
  collation element for each level.
*/
#define UCA900_NUM_OF_CE(page, subcode) ((page)[(subcode)])
#define UCA900_WEIGHT_ADDR(page, level, subcode) \
  ((page) + 256 + (level) * 256 + (subcode))
#define UCA900_WEIGHT(page, level, subcode) \
  (page)[256 + (level) * 256 + (subcode)]
#define UCA900_DISTANCE_BETWEEN_LEVELS 256
#define UCA900_DISTANCE_BETWEEN_WEIGHTS (MY_UCA_900_CE_SIZE * 256)

uint16 uca900_p000[]= {
  /* Number of CEs for each character. */
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 1,
  2, 2, 2, 2, 2, 2, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 1, 2, 2, 2, 2, 2, 2, 1, 3,
  2, 2, 2, 2, 2, 2, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 1, 2, 2, 2, 2, 2, 2, 1, 2,

  /* Primary weight 1 for each character. */
  0x0000,   /* U+0000 */
  0x0000,   /* U+0001 */
  0x0000,   /* U+0002 */
  0x0000,   /* U+0003 */
  0x0000,   /* U+0004 */
  0x0000,   /* U+0005 */
  0x0000,   /* U+0006 */
  0x0000,   /* U+0007 */
  0x0000,   /* U+0008 */
  0x0201,   /* U+0009 */
  0x0202,   /* U+000A */
  0x0203,   /* U+000B */
  0x0204,   /* U+000C */
  0x0205,   /* U+000D */
  0x0000,   /* U+000E */
  0x0000,   /* U+000F */
  0x0000,   /* U+0010 */
  0x0000,   /* U+0011 */
  0x0000,   /* U+0012 */
  0x0000,   /* U+0013 */
  0x0000,   /* U+0014 */
  0x0000,   /* U+0015 */
  0x0000,   /* U+0016 */
  0x0000,   /* U+0017 */
  0x0000,   /* U+0018 */
  0x0000,   /* U+0019 */
  0x0000,   /* U+001A */
  0x0000,   /* U+001B */
  0x0000,   /* U+001C */
  0x0000,   /* U+001D */
  0x0000,   /* U+001E */
  0x0000,   /* U+001F */
  0x0209,   /* U+0020 */
  0x0260,   /* U+0021 */
  0x030C,   /* U+0022 */
  0x0398,   /* U+0023 */
  0x1C12,   /* U+0024 */
  0x0399,   /* U+0025 */
  0x0396,   /* U+0026 */
  0x0305,   /* U+0027 */
  0x0317,   /* U+0028 */
  0x0318,   /* U+0029 */
  0x038F,   /* U+002A */
  0x0616,   /* U+002B */
  0x0222,   /* U+002C */
  0x020D,   /* U+002D */
  0x0277,   /* U+002E */
  0x0394,   /* U+002F */
  0x1C3D,   /* U+0030 */
  0x1C3E,   /* U+0031 */
  0x1C3F,   /* U+0032 */
  0x1C40,   /* U+0033 */
  0x1C41,   /* U+0034 */
  0x1C42,   /* U+0035 */
  0x1C43,   /* U+0036 */
  0x1C44,   /* U+0037 */
  0x1C45,   /* U+0038 */
  0x1C46,   /* U+0039 */
  0x0239,   /* U+003A */
  0x0234,   /* U+003B */
  0x061A,   /* U+003C */
  0x061B,   /* U+003D */
  0x061C,   /* U+003E */
  0x0266,   /* U+003F */
  0x038E,   /* U+0040 */
  0x1C47,   /* U+0041 */
  0x1C60,   /* U+0042 */
  0x1C7A,   /* U+0043 */
  0x1C8F,   /* U+0044 */
  0x1CAA,   /* U+0045 */
  0x1CE5,   /* U+0046 */
  0x1CF4,   /* U+0047 */
  0x1D18,   /* U+0048 */
  0x1D32,   /* U+0049 */
  0x1D4C,   /* U+004A */
  0x1D65,   /* U+004B */
  0x1D77,   /* U+004C */
  0x1DAA,   /* U+004D */
  0x1DB9,   /* U+004E */
  0x1DDD,   /* U+004F */
  0x1E0C,   /* U+0050 */
  0x1E21,   /* U+0051 */
  0x1E33,   /* U+0052 */
  0x1E71,   /* U+0053 */
  0x1E95,   /* U+0054 */
  0x1EB5,   /* U+0055 */
  0x1EE3,   /* U+0056 */
  0x1EF5,   /* U+0057 */
  0x1EFF,   /* U+0058 */
  0x1F0B,   /* U+0059 */
  0x1F21,   /* U+005A */
  0x0319,   /* U+005B */
  0x0395,   /* U+005C */
  0x031A,   /* U+005D */
  0x0485,   /* U+005E */
  0x020B,   /* U+005F */
  0x0482,   /* U+0060 */
  0x1C47,   /* U+0061 */
  0x1C60,   /* U+0062 */
  0x1C7A,   /* U+0063 */
  0x1C8F,   /* U+0064 */
  0x1CAA,   /* U+0065 */
  0x1CE5,   /* U+0066 */
  0x1CF4,   /* U+0067 */
  0x1D18,   /* U+0068 */
  0x1D32,   /* U+0069 */
  0x1D4C,   /* U+006A */
  0x1D65,   /* U+006B */
  0x1D77,   /* U+006C */
  0x1DAA,   /* U+006D */
  0x1DB9,   /* U+006E */
  0x1DDD,   /* U+006F */
  0x1E0C,   /* U+0070 */
  0x1E21,   /* U+0071 */
  0x1E33,   /* U+0072 */
  0x1E71,   /* U+0073 */
  0x1E95,   /* U+0074 */
  0x1EB5,   /* U+0075 */
  0x1EE3,   /* U+0076 */
  0x1EF5,   /* U+0077 */
  0x1EFF,   /* U+0078 */
  0x1F0B,   /* U+0079 */
  0x1F21,   /* U+007A */
  0x031B,   /* U+007B */
  0x061E,   /* U+007C */
  0x031C,   /* U+007D */
  0x0620,   /* U+007E */
  0x0000,   /* U+007F */
  0x0000,   /* U+0080 */
  0x0000,   /* U+0081 */
  0x0000,   /* U+0082 */
  0x0000,   /* U+0083 */
  0x0000,   /* U+0084 */
  0x0206,   /* U+0085 */
  0x0000,   /* U+0086 */
  0x0000,   /* U+0087 */
  0x0000,   /* U+0088 */
  0x0000,   /* U+0089 */
  0x0000,   /* U+008A */
  0x0000,   /* U+008B */
  0x0000,   /* U+008C */
  0x0000,   /* U+008D */
  0x0000,   /* U+008E */
  0x0000,   /* U+008F */
  0x0000,   /* U+0090 */
  0x0000,   /* U+0091 */
  0x0000,   /* U+0092 */
  0x0000,   /* U+0093 */
  0x0000,   /* U+0094 */
  0x0000,   /* U+0095 */
  0x0000,   /* U+0096 */
  0x0000,   /* U+0097 */
  0x0000,   /* U+0098 */
  0x0000,   /* U+0099 */
  0x0000,   /* U+009A */
  0x0000,   /* U+009B */
  0x0000,   /* U+009C */
  0x0000,   /* U+009D */
  0x0000,   /* U+009E */
  0x0000,   /* U+009F */
  0x0209,   /* U+00A0 */
  0x0261,   /* U+00A1 */
  0x1C11,   /* U+00A2 */
  0x1C13,   /* U+00A3 */
  0x1C10,   /* U+00A4 */
  0x1C14,   /* U+00A5 */
  0x061F,   /* U+00A6 */
  0x0389,   /* U+00A7 */
  0x0489,   /* U+00A8 */
  0x0584,   /* U+00A9 */
  0x1C47,   /* U+00AA */
  0x0315,   /* U+00AB */
  0x061D,   /* U+00AC */
  0x0000,   /* U+00AD */
  0x0585,   /* U+00AE */
  0x0486,   /* U+00AF */
  0x04F6,   /* U+00B0 */
  0x0617,   /* U+00B1 */
  0x1C3F,   /* U+00B2 */
  0x1C40,   /* U+00B3 */
  0x0483,   /* U+00B4 */
  0x1FCB,   /* U+00B5 */
  0x038B,   /* U+00B6 */
  0x028B,   /* U+00B7 */
  0x048C,   /* U+00B8 */
  0x1C3E,   /* U+00B9 */
  0x1DDD,   /* U+00BA */
  0x0316,   /* U+00BB */
  0x1C3E,   /* U+00BC */
  0x1C3E,   /* U+00BD */
  0x1C40,   /* U+00BE */
  0x0267,   /* U+00BF */
  0x1C47,   /* U+00C0 */
  0x1C47,   /* U+00C1 */
  0x1C47,   /* U+00C2 */
  0x1C47,   /* U+00C3 */
  0x1C47,   /* U+00C4 */
  0x1C47,   /* U+00C5 */
  0x1C47,   /* U+00C6 */
  0x1C7A,   /* U+00C7 */
  0x1CAA,   /* U+00C8 */
  0x1CAA,   /* U+00C9 */
  0x1CAA,   /* U+00CA */
  0x1CAA,   /* U+00CB */
  0x1D32,   /* U+00CC */
  0x1D32,   /* U+00CD */
  0x1D32,   /* U+00CE */
  0x1D32,   /* U+00CF */
  0x1C8F,   /* U+00D0 */
  0x1DB9,   /* U+00D1 */
  0x1DDD,   /* U+00D2 */
  0x1DDD,   /* U+00D3 */
  0x1DDD,   /* U+00D4 */
  0x1DDD,   /* U+00D5 */
  0x1DDD,   /* U+00D6 */
  0x0619,   /* U+00D7 */
  0x1DDD,   /* U+00D8 */
  0x1EB5,   /* U+00D9 */
  0x1EB5,   /* U+00DA */
  0x1EB5,   /* U+00DB */
  0x1EB5,   /* U+00DC */
  0x1F0B,   /* U+00DD */
  0x1F50,   /* U+00DE */
  0x1E71,   /* U+00DF */
  0x1C47,   /* U+00E0 */
  0x1C47,   /* U+00E1 */
  0x1C47,   /* U+00E2 */
  0x1C47,   /* U+00E3 */
  0x1C47,   /* U+00E4 */
  0x1C47,   /* U+00E5 */
  0x1C47,   /* U+00E6 */
  0x1C7A,   /* U+00E7 */
  0x1CAA,   /* U+00E8 */
  0x1CAA,   /* U+00E9 */
  0x1CAA,   /* U+00EA */
  0x1CAA,   /* U+00EB */
  0x1D32,   /* U+00EC */
  0x1D32,   /* U+00ED */
  0x1D32,   /* U+00EE */
  0x1D32,   /* U+00EF */
  0x1C8F,   /* U+00F0 */
  0x1DB9,   /* U+00F1 */
  0x1DDD,   /* U+00F2 */
  0x1DDD,   /* U+00F3 */
  0x1DDD,   /* U+00F4 */
  0x1DDD,   /* U+00F5 */
  0x1DDD,   /* U+00F6 */
  0x0618,   /* U+00F7 */
  0x1DDD,   /* U+00F8 */
  0x1EB5,   /* U+00F9 */
  0x1EB5,   /* U+00FA */
  0x1EB5,   /* U+00FB */
  0x1EB5,   /* U+00FC */
  0x1F0B,   /* U+00FD */
  0x1F50,   /* U+00FE */
  0x1F0B,   /* U+00FF */

  /* Secondary weight 1 for each character. */
  0x0000,   /* U+0000 */
  0x0000,   /* U+0001 */
  0x0000,   /* U+0002 */
  0x0000,   /* U+0003 */
  0x0000,   /* U+0004 */
  0x0000,   /* U+0005 */
  0x0000,   /* U+0006 */
  0x0000,   /* U+0007 */
  0x0000,   /* U+0008 */
  0x0020,   /* U+0009 */
  0x0020,   /* U+000A */
  0x0020,   /* U+000B */
  0x0020,   /* U+000C */
  0x0020,   /* U+000D */
  0x0000,   /* U+000E */
  0x0000,   /* U+000F */
  0x0000,   /* U+0010 */
  0x0000,   /* U+0011 */
  0x0000,   /* U+0012 */
  0x0000,   /* U+0013 */
  0x0000,   /* U+0014 */
  0x0000,   /* U+0015 */
  0x0000,   /* U+0016 */
  0x0000,   /* U+0017 */
  0x0000,   /* U+0018 */
  0x0000,   /* U+0019 */
  0x0000,   /* U+001A */
  0x0000,   /* U+001B */
  0x0000,   /* U+001C */
  0x0000,   /* U+001D */
  0x0000,   /* U+001E */
  0x0000,   /* U+001F */
  0x0020,   /* U+0020 */
  0x0020,   /* U+0021 */
  0x0020,   /* U+0022 */
  0x0020,   /* U+0023 */
  0x0020,   /* U+0024 */
  0x0020,   /* U+0025 */
  0x0020,   /* U+0026 */
  0x0020,   /* U+0027 */
  0x0020,   /* U+0028 */
  0x0020,   /* U+0029 */
  0x0020,   /* U+002A */
  0x0020,   /* U+002B */
  0x0020,   /* U+002C */
  0x0020,   /* U+002D */
  0x0020,   /* U+002E */
  0x0020,   /* U+002F */
  0x0020,   /* U+0030 */
  0x0020,   /* U+0031 */
  0x0020,   /* U+0032 */
  0x0020,   /* U+0033 */
  0x0020,   /* U+0034 */
  0x0020,   /* U+0035 */
  0x0020,   /* U+0036 */
  0x0020,   /* U+0037 */
  0x0020,   /* U+0038 */
  0x0020,   /* U+0039 */
  0x0020,   /* U+003A */
  0x0020,   /* U+003B */
  0x0020,   /* U+003C */
  0x0020,   /* U+003D */
  0x0020,   /* U+003E */
  0x0020,   /* U+003F */
  0x0020,   /* U+0040 */
  0x0020,   /* U+0041 */
  0x0020,   /* U+0042 */
  0x0020,   /* U+0043 */
  0x0020,   /* U+0044 */
  0x0020,   /* U+0045 */
  0x0020,   /* U+0046 */
  0x0020,   /* U+0047 */
  0x0020,   /* U+0048 */
  0x0020,   /* U+0049 */
  0x0020,   /* U+004A */
  0x0020,   /* U+004B */
  0x0020,   /* U+004C */
  0x0020,   /* U+004D */
  0x0020,   /* U+004E */
  0x0020,   /* U+004F */
  0x0020,   /* U+0050 */
  0x0020,   /* U+0051 */
  0x0020,   /* U+0052 */
  0x0020,   /* U+0053 */
  0x0020,   /* U+0054 */
  0x0020,   /* U+0055 */
  0x0020,   /* U+0056 */
  0x0020,   /* U+0057 */
  0x0020,   /* U+0058 */
  0x0020,   /* U+0059 */
  0x0020,   /* U+005A */
  0x0020,   /* U+005B */
  0x0020,   /* U+005C */
  0x0020,   /* U+005D */
  0x0020,   /* U+005E */
  0x0020,   /* U+005F */
  0x0020,   /* U+0060 */
  0x0020,   /* U+0061 */
  0x0020,   /* U+0062 */
  0x0020,   /* U+0063 */
  0x0020,   /* U+0064 */
  0x0020,   /* U+0065 */
  0x0020,   /* U+0066 */
  0x0020,   /* U+0067 */
  0x0020,   /* U+0068 */
  0x0020,   /* U+0069 */
  0x0020,   /* U+006A */
  0x0020,   /* U+006B */
  0x0020,   /* U+006C */
  0x0020,   /* U+006D */
  0x0020,   /* U+006E */
  0x0020,   /* U+006F */
  0x0020,   /* U+0070 */
  0x0020,   /* U+0071 */
  0x0020,   /* U+0072 */
  0x0020,   /* U+0073 */
  0x0020,   /* U+0074 */
  0x0020,   /* U+0075 */
  0x0020,   /* U+0076 */
  0x0020,   /* U+0077 */
  0x0020,   /* U+0078 */
  0x0020,   /* U+0079 */
  0x0020,   /* U+007A */
  0x0020,   /* U+007B */
  0x0020,   /* U+007C */
  0x0020,   /* U+007D */
  0x0020,   /* U+007E */
  0x0000,   /* U+007F */
  0x0000,   /* U+0080 */
  0x0000,   /* U+0081 */
  0x0000,   /* U+0082 */
  0x0000,   /* U+0083 */
  0x0000,   /* U+0084 */
  0x0020,   /* U+0085 */
  0x0000,   /* U+0086 */
  0x0000,   /* U+0087 */
  0x0000,   /* U+0088 */
  0x0000,   /* U+0089 */
  0x0000,   /* U+008A */
  0x0000,   /* U+008B */
  0x0000,   /* U+008C */
  0x0000,   /* U+008D */
  0x0000,   /* U+008E */
  0x0000,   /* U+008F */
  0x0000,   /* U+0090 */
  0x0000,   /* U+0091 */
  0x0000,   /* U+0092 */
  0x0000,   /* U+0093 */
  0x0000,   /* U+0094 */
  0x0000,   /* U+0095 */
  0x0000,   /* U+0096 */
  0x0000,   /* U+0097 */
  0x0000,   /* U+0098 */
  0x0000,   /* U+0099 */
  0x0000,   /* U+009A */
  0x0000,   /* U+009B */
  0x0000,   /* U+009C */
  0x0000,   /* U+009D */
  0x0000,   /* U+009E */
  0x0000,   /* U+009F */
  0x0020,   /* U+00A0 */
  0x0020,   /* U+00A1 */
  0x0020,   /* U+00A2 */
  0x0020,   /* U+00A3 */
  0x0020,   /* U+00A4 */
  0x0020,   /* U+00A5 */
  0x0020,   /* U+00A6 */
  0x0020,   /* U+00A7 */
  0x0020,   /* U+00A8 */
  0x0020,   /* U+00A9 */
  0x0020,   /* U+00AA */
  0x0020,   /* U+00AB */
  0x0020,   /* U+00AC */
  0x0000,   /* U+00AD */
  0x0020,   /* U+00AE */
  0x0020,   /* U+00AF */
  0x0020,   /* U+00B0 */
  0x0020,   /* U+00B1 */
  0x0020,   /* U+00B2 */
  0x0020,   /* U+00B3 */
  0x0020,   /* U+00B4 */
  0x0020,   /* U+00B5 */
  0x0020,   /* U+00B6 */
  0x0020,   /* U+00B7 */
  0x0020,   /* U+00B8 */
  0x0020,   /* U+00B9 */
  0x0020,   /* U+00BA */
  0x0020,   /* U+00BB */
  0x0020,   /* U+00BC */
  0x0020,   /* U+00BD */
  0x0020,   /* U+00BE */
  0x0020,   /* U+00BF */
  0x0020,   /* U+00C0 */
  0x0020,   /* U+00C1 */
  0x0020,   /* U+00C2 */
  0x0020,   /* U+00C3 */
  0x0020,   /* U+00C4 */
  0x0020,   /* U+00C5 */
  0x0020,   /* U+00C6 */
  0x0020,   /* U+00C7 */
  0x0020,   /* U+00C8 */
  0x0020,   /* U+00C9 */
  0x0020,   /* U+00CA */
  0x0020,   /* U+00CB */
  0x0020,   /* U+00CC */
  0x0020,   /* U+00CD */
  0x0020,   /* U+00CE */
  0x0020,   /* U+00CF */
  0x0020,   /* U+00D0 */
  0x0020,   /* U+00D1 */
  0x0020,   /* U+00D2 */
  0x0020,   /* U+00D3 */
  0x0020,   /* U+00D4 */
  0x0020,   /* U+00D5 */
  0x0020,   /* U+00D6 */
  0x0020,   /* U+00D7 */
  0x0020,   /* U+00D8 */
  0x0020,   /* U+00D9 */
  0x0020,   /* U+00DA */
  0x0020,   /* U+00DB */
  0x0020,   /* U+00DC */
  0x0020,   /* U+00DD */
  0x0020,   /* U+00DE */
  0x0020,   /* U+00DF */
  0x0020,   /* U+00E0 */
  0x0020,   /* U+00E1 */
  0x0020,   /* U+00E2 */
  0x0020,   /* U+00E3 */
  0x0020,   /* U+00E4 */
  0x0020,   /* U+00E5 */
  0x0020,   /* U+00E6 */
  0x0020,   /* U+00E7 */
  0x0020,   /* U+00E8 */
  0x0020,   /* U+00E9 */
  0x0020,   /* U+00EA */
  0x0020,   /* U+00EB */
  0x0020,   /* U+00EC */
  0x0020,   /* U+00ED */
  0x0020,   /* U+00EE */
  0x0020,   /* U+00EF */
  0x0020,   /* U+00F0 */
  0x0020,   /* U+00F1 */
  0x0020,   /* U+00F2 */
  0x0020,   /* U+00F3 */
  0x0020,   /* U+00F4 */
  0x0020,   /* U+00F5 */
  0x0020,   /* U+00F6 */
  0x0020,   /* U+00F7 */
  0x0020,   /* U+00F8 */
  0x0020,   /* U+00F9 */
  0x0020,   /* U+00FA */
  0x0020,   /* U+00FB */
  0x0020,   /* U+00FC */
  0x0020,   /* U+00FD */
  0x0020,   /* U+00FE */
  0x0020,   /* U+00FF */

  /* Tertiary weight 1 for each character. */
  0x0000,   /* U+0000 */
  0x0000,   /* U+0001 */
  0x0000,   /* U+0002 */
  0x0000,   /* U+0003 */
  0x0000,   /* U+0004 */
  0x0000,   /* U+0005 */
  0x0000,   /* U+0006 */
  0x0000,   /* U+0007 */
  0x0000,   /* U+0008 */
  0x0002,   /* U+0009 */
  0x0002,   /* U+000A */
  0x0002,   /* U+000B */
  0x0002,   /* U+000C */
  0x0002,   /* U+000D */
  0x0000,   /* U+000E */
  0x0000,   /* U+000F */
  0x0000,   /* U+0010 */
  0x0000,   /* U+0011 */
  0x0000,   /* U+0012 */
  0x0000,   /* U+0013 */
  0x0000,   /* U+0014 */
  0x0000,   /* U+0015 */
  0x0000,   /* U+0016 */
  0x0000,   /* U+0017 */
  0x0000,   /* U+0018 */
  0x0000,   /* U+0019 */
  0x0000,   /* U+001A */
  0x0000,   /* U+001B */
  0x0000,   /* U+001C */
  0x0000,   /* U+001D */
  0x0000,   /* U+001E */
  0x0000,   /* U+001F */
  0x0002,   /* U+0020 */
  0x0002,   /* U+0021 */
  0x0002,   /* U+0022 */
  0x0002,   /* U+0023 */
  0x0002,   /* U+0024 */
  0x0002,   /* U+0025 */
  0x0002,   /* U+0026 */
  0x0002,   /* U+0027 */
  0x0002,   /* U+0028 */
  0x0002,   /* U+0029 */
  0x0002,   /* U+002A */
  0x0002,   /* U+002B */
  0x0002,   /* U+002C */
  0x0002,   /* U+002D */
  0x0002,   /* U+002E */
  0x0002,   /* U+002F */
  0x0002,   /* U+0030 */
  0x0002,   /* U+0031 */
  0x0002,   /* U+0032 */
  0x0002,   /* U+0033 */
  0x0002,   /* U+0034 */
  0x0002,   /* U+0035 */
  0x0002,   /* U+0036 */
  0x0002,   /* U+0037 */
  0x0002,   /* U+0038 */
  0x0002,   /* U+0039 */
  0x0002,   /* U+003A */
  0x0002,   /* U+003B */
  0x0002,   /* U+003C */
  0x0002,   /* U+003D */
  0x0002,   /* U+003E */
  0x0002,   /* U+003F */
  0x0002,   /* U+0040 */
  0x0008,   /* U+0041 */
  0x0008,   /* U+0042 */
  0x0008,   /* U+0043 */
  0x0008,   /* U+0044 */
  0x0008,   /* U+0045 */
  0x0008,   /* U+0046 */
  0x0008,   /* U+0047 */
  0x0008,   /* U+0048 */
  0x0008,   /* U+0049 */
  0x0008,   /* U+004A */
  0x0008,   /* U+004B */
  0x0008,   /* U+004C */
  0x0008,   /* U+004D */
  0x0008,   /* U+004E */
  0x0008,   /* U+004F */
  0x0008,   /* U+0050 */
  0x0008,   /* U+0051 */
  0x0008,   /* U+0052 */
  0x0008,   /* U+0053 */
  0x0008,   /* U+0054 */
  0x0008,   /* U+0055 */
  0x0008,   /* U+0056 */
  0x0008,   /* U+0057 */
  0x0008,   /* U+0058 */
  0x0008,   /* U+0059 */
  0x0008,   /* U+005A */
  0x0002,   /* U+005B */
  0x0002,   /* U+005C */
  0x0002,   /* U+005D */
  0x0002,   /* U+005E */
  0x0002,   /* U+005F */
  0x0002,   /* U+0060 */
  0x0002,   /* U+0061 */
  0x0002,   /* U+0062 */
  0x0002,   /* U+0063 */
  0x0002,   /* U+0064 */
  0x0002,   /* U+0065 */
  0x0002,   /* U+0066 */
  0x0002,   /* U+0067 */
  0x0002,   /* U+0068 */
  0x0002,   /* U+0069 */
  0x0002,   /* U+006A */
  0x0002,   /* U+006B */
  0x0002,   /* U+006C */
  0x0002,   /* U+006D */
  0x0002,   /* U+006E */
  0x0002,   /* U+006F */
  0x0002,   /* U+0070 */
  0x0002,   /* U+0071 */
  0x0002,   /* U+0072 */
  0x0002,   /* U+0073 */
  0x0002,   /* U+0074 */
  0x0002,   /* U+0075 */
  0x0002,   /* U+0076 */
  0x0002,   /* U+0077 */
  0x0002,   /* U+0078 */
  0x0002,   /* U+0079 */
  0x0002,   /* U+007A */
  0x0002,   /* U+007B */
  0x0002,   /* U+007C */
  0x0002,   /* U+007D */
  0x0002,   /* U+007E */
  0x0000,   /* U+007F */
  0x0000,   /* U+0080 */
  0x0000,   /* U+0081 */
  0x0000,   /* U+0082 */
  0x0000,   /* U+0083 */
  0x0000,   /* U+0084 */
  0x0002,   /* U+0085 */
  0x0000,   /* U+0086 */
  0x0000,   /* U+0087 */
  0x0000,   /* U+0088 */
  0x0000,   /* U+0089 */
  0x0000,   /* U+008A */
  0x0000,   /* U+008B */
  0x0000,   /* U+008C */
  0x0000,   /* U+008D */
  0x0000,   /* U+008E */
  0x0000,   /* U+008F */
  0x0000,   /* U+0090 */
  0x0000,   /* U+0091 */
  0x0000,   /* U+0092 */
  0x0000,   /* U+0093 */
  0x0000,   /* U+0094 */
  0x0000,   /* U+0095 */
  0x0000,   /* U+0096 */
  0x0000,   /* U+0097 */
  0x0000,   /* U+0098 */
  0x0000,   /* U+0099 */
  0x0000,   /* U+009A */
  0x0000,   /* U+009B */
  0x0000,   /* U+009C */
  0x0000,   /* U+009D */
  0x0000,   /* U+009E */
  0x0000,   /* U+009F */
  0x001B,   /* U+00A0 */
  0x0002,   /* U+00A1 */
  0x0002,   /* U+00A2 */
  0x0002,   /* U+00A3 */
  0x0002,   /* U+00A4 */
  0x0002,   /* U+00A5 */
  0x0002,   /* U+00A6 */
  0x0002,   /* U+00A7 */
  0x0002,   /* U+00A8 */
  0x0002,   /* U+00A9 */
  0x0014,   /* U+00AA */
  0x0002,   /* U+00AB */
  0x0002,   /* U+00AC */
  0x0000,   /* U+00AD */
  0x0002,   /* U+00AE */
  0x0002,   /* U+00AF */
  0x0002,   /* U+00B0 */
  0x0002,   /* U+00B1 */
  0x0014,   /* U+00B2 */
  0x0014,   /* U+00B3 */
  0x0002,   /* U+00B4 */
  0x0004,   /* U+00B5 */
  0x0002,   /* U+00B6 */
  0x0002,   /* U+00B7 */
  0x0002,   /* U+00B8 */
  0x0014,   /* U+00B9 */
  0x0014,   /* U+00BA */
  0x0002,   /* U+00BB */
  0x001E,   /* U+00BC */
  0x001E,   /* U+00BD */
  0x001E,   /* U+00BE */
  0x0002,   /* U+00BF */
  0x0008,   /* U+00C0 */
  0x0008,   /* U+00C1 */
  0x0008,   /* U+00C2 */
  0x0008,   /* U+00C3 */
  0x0008,   /* U+00C4 */
  0x0008,   /* U+00C5 */
  0x000A,   /* U+00C6 */
  0x0008,   /* U+00C7 */
  0x0008,   /* U+00C8 */
  0x0008,   /* U+00C9 */
  0x0008,   /* U+00CA */
  0x0008,   /* U+00CB */
  0x0008,   /* U+00CC */
  0x0008,   /* U+00CD */
  0x0008,   /* U+00CE */
  0x0008,   /* U+00CF */
  0x000A,   /* U+00D0 */
  0x0008,   /* U+00D1 */
  0x0008,   /* U+00D2 */
  0x0008,   /* U+00D3 */
  0x0008,   /* U+00D4 */
  0x0008,   /* U+00D5 */
  0x0008,   /* U+00D6 */
  0x0002,   /* U+00D7 */
  0x0008,   /* U+00D8 */
  0x0008,   /* U+00D9 */
  0x0008,   /* U+00DA */
  0x0008,   /* U+00DB */
  0x0008,   /* U+00DC */
  0x0008,   /* U+00DD */
  0x0008,   /* U+00DE */
  0x0004,   /* U+00DF */
  0x0002,   /* U+00E0 */
  0x0002,   /* U+00E1 */
  0x0002,   /* U+00E2 */
  0x0002,   /* U+00E3 */
  0x0002,   /* U+00E4 */
  0x0002,   /* U+00E5 */
  0x0004,   /* U+00E6 */
  0x0002,   /* U+00E7 */
  0x0002,   /* U+00E8 */
  0x0002,   /* U+00E9 */
  0x0002,   /* U+00EA */
  0x0002,   /* U+00EB */
  0x0002,   /* U+00EC */
  0x0002,   /* U+00ED */
  0x0002,   /* U+00EE */
  0x0002,   /* U+00EF */
  0x0004,   /* U+00F0 */
  0x0002,   /* U+00F1 */
  0x0002,   /* U+00F2 */
  0x0002,   /* U+00F3 */
  0x0002,   /* U+00F4 */
  0x0002,   /* U+00F5 */
  0x0002,   /* U+00F6 */
  0x0002,   /* U+00F7 */
  0x0002,   /* U+00F8 */
  0x0002,   /* U+00F9 */
  0x0002,   /* U+00FA */
  0x0002,   /* U+00FB */
  0x0002,   /* U+00FC */
  0x0002,   /* U+00FD */
  0x0002,   /* U+00FE */
  0x0002,   /* U+00FF */

  /* Primary weight 2 for each character. */
  0x0000,   /* U+0000 */
  0x0000,   /* U+0001 */
  0x0000,   /* U+0002 */
  0x0000,   /* U+0003 */
  0x0000,   /* U+0004 */
  0x0000,   /* U+0005 */
  0x0000,   /* U+0006 */
  0x0000,   /* U+0007 */
  0x0000,   /* U+0008 */
  0x0000,   /* U+0009 */
  0x0000,   /* U+000A */
  0x0000,   /* U+000B */
  0x0000,   /* U+000C */
  0x0000,   /* U+000D */
  0x0000,   /* U+000E */
  0x0000,   /* U+000F */
  0x0000,   /* U+0010 */
  0x0000,   /* U+0011 */
  0x0000,   /* U+0012 */
  0x0000,   /* U+0013 */
  0x0000,   /* U+0014 */
  0x0000,   /* U+0015 */
  0x0000,   /* U+0016 */
  0x0000,   /* U+0017 */
  0x0000,   /* U+0018 */
  0x0000,   /* U+0019 */
  0x0000,   /* U+001A */
  0x0000,   /* U+001B */
  0x0000,   /* U+001C */
  0x0000,   /* U+001D */
  0x0000,   /* U+001E */
  0x0000,   /* U+001F */
  0x0000,   /* U+0020 */
  0x0000,   /* U+0021 */
  0x0000,   /* U+0022 */
  0x0000,   /* U+0023 */
  0x0000,   /* U+0024 */
  0x0000,   /* U+0025 */
  0x0000,   /* U+0026 */
  0x0000,   /* U+0027 */
  0x0000,   /* U+0028 */
  0x0000,   /* U+0029 */
  0x0000,   /* U+002A */
  0x0000,   /* U+002B */
  0x0000,   /* U+002C */
  0x0000,   /* U+002D */
  0x0000,   /* U+002E */
  0x0000,   /* U+002F */
  0x0000,   /* U+0030 */
  0x0000,   /* U+0031 */
  0x0000,   /* U+0032 */
  0x0000,   /* U+0033 */
  0x0000,   /* U+0034 */
  0x0000,   /* U+0035 */
  0x0000,   /* U+0036 */
  0x0000,   /* U+0037 */
  0x0000,   /* U+0038 */
  0x0000,   /* U+0039 */
  0x0000,   /* U+003A */
  0x0000,   /* U+003B */
  0x0000,   /* U+003C */
  0x0000,   /* U+003D */
  0x0000,   /* U+003E */
  0x0000,   /* U+003F */
  0x0000,   /* U+0040 */
  0x0000,   /* U+0041 */
  0x0000,   /* U+0042 */
  0x0000,   /* U+0043 */
  0x0000,   /* U+0044 */
  0x0000,   /* U+0045 */
  0x0000,   /* U+0046 */
  0x0000,   /* U+0047 */
  0x0000,   /* U+0048 */
  0x0000,   /* U+0049 */
  0x0000,   /* U+004A */
  0x0000,   /* U+004B */
  0x0000,   /* U+004C */
  0x0000,   /* U+004D */
  0x0000,   /* U+004E */
  0x0000,   /* U+004F */
  0x0000,   /* U+0050 */
  0x0000,   /* U+0051 */
  0x0000,   /* U+0052 */
  0x0000,   /* U+0053 */
  0x0000,   /* U+0054 */
  0x0000,   /* U+0055 */
  0x0000,   /* U+0056 */
  0x0000,   /* U+0057 */
  0x0000,   /* U+0058 */
  0x0000,   /* U+0059 */
  0x0000,   /* U+005A */
  0x0000,   /* U+005B */
  0x0000,   /* U+005C */
  0x0000,   /* U+005D */
  0x0000,   /* U+005E */
  0x0000,   /* U+005F */
  0x0000,   /* U+0060 */
  0x0000,   /* U+0061 */
  0x0000,   /* U+0062 */
  0x0000,   /* U+0063 */
  0x0000,   /* U+0064 */
  0x0000,   /* U+0065 */
  0x0000,   /* U+0066 */
  0x0000,   /* U+0067 */
  0x0000,   /* U+0068 */
  0x0000,   /* U+0069 */
  0x0000,   /* U+006A */
  0x0000,   /* U+006B */
  0x0000,   /* U+006C */
  0x0000,   /* U+006D */
  0x0000,   /* U+006E */
  0x0000,   /* U+006F */
  0x0000,   /* U+0070 */
  0x0000,   /* U+0071 */
  0x0000,   /* U+0072 */
  0x0000,   /* U+0073 */
  0x0000,   /* U+0074 */
  0x0000,   /* U+0075 */
  0x0000,   /* U+0076 */
  0x0000,   /* U+0077 */
  0x0000,   /* U+0078 */
  0x0000,   /* U+0079 */
  0x0000,   /* U+007A */
  0x0000,   /* U+007B */
  0x0000,   /* U+007C */
  0x0000,   /* U+007D */
  0x0000,   /* U+007E */
  0x0000,   /* U+007F */
  0x0000,   /* U+0080 */
  0x0000,   /* U+0081 */
  0x0000,   /* U+0082 */
  0x0000,   /* U+0083 */
  0x0000,   /* U+0084 */
  0x0000,   /* U+0085 */
  0x0000,   /* U+0086 */
  0x0000,   /* U+0087 */
  0x0000,   /* U+0088 */
  0x0000,   /* U+0089 */
  0x0000,   /* U+008A */
  0x0000,   /* U+008B */
  0x0000,   /* U+008C */
  0x0000,   /* U+008D */
  0x0000,   /* U+008E */
  0x0000,   /* U+008F */
  0x0000,   /* U+0090 */
  0x0000,   /* U+0091 */
  0x0000,   /* U+0092 */
  0x0000,   /* U+0093 */
  0x0000,   /* U+0094 */
  0x0000,   /* U+0095 */
  0x0000,   /* U+0096 */
  0x0000,   /* U+0097 */
  0x0000,   /* U+0098 */
  0x0000,   /* U+0099 */
  0x0000,   /* U+009A */
  0x0000,   /* U+009B */
  0x0000,   /* U+009C */
  0x0000,   /* U+009D */
  0x0000,   /* U+009E */
  0x0000,   /* U+009F */
  0x0000,   /* U+00A0 */
  0x0000,   /* U+00A1 */
  0x0000,   /* U+00A2 */
  0x0000,   /* U+00A3 */
  0x0000,   /* U+00A4 */
  0x0000,   /* U+00A5 */
  0x0000,   /* U+00A6 */
  0x0000,   /* U+00A7 */
  0x0000,   /* U+00A8 */
  0x0000,   /* U+00A9 */
  0x0000,   /* U+00AA */
  0x0000,   /* U+00AB */
  0x0000,   /* U+00AC */
  0x0000,   /* U+00AD */
  0x0000,   /* U+00AE */
  0x0000,   /* U+00AF */
  0x0000,   /* U+00B0 */
  0x0000,   /* U+00B1 */
  0x0000,   /* U+00B2 */
  0x0000,   /* U+00B3 */
  0x0000,   /* U+00B4 */
  0x0000,   /* U+00B5 */
  0x0000,   /* U+00B6 */
  0x0000,   /* U+00B7 */
  0x0000,   /* U+00B8 */
  0x0000,   /* U+00B9 */
  0x0000,   /* U+00BA */
  0x0000,   /* U+00BB */
  0x0626,   /* U+00BC */
  0x0626,   /* U+00BD */
  0x0626,   /* U+00BE */
  0x0000,   /* U+00BF */
  0x0000,   /* U+00C0 */
  0x0000,   /* U+00C1 */
  0x0000,   /* U+00C2 */
  0x0000,   /* U+00C3 */
  0x0000,   /* U+00C4 */
  0x0000,   /* U+00C5 */
  0x0000,   /* U+00C6 */
  0x0000,   /* U+00C7 */
  0x0000,   /* U+00C8 */
  0x0000,   /* U+00C9 */
  0x0000,   /* U+00CA */
  0x0000,   /* U+00CB */
  0x0000,   /* U+00CC */
  0x0000,   /* U+00CD */
  0x0000,   /* U+00CE */
  0x0000,   /* U+00CF */
  0x0000,   /* U+00D0 */
  0x0000,   /* U+00D1 */
  0x0000,   /* U+00D2 */
  0x0000,   /* U+00D3 */
  0x0000,   /* U+00D4 */
  0x0000,   /* U+00D5 */
  0x0000,   /* U+00D6 */
  0x0000,   /* U+00D7 */
  0x0000,   /* U+00D8 */
  0x0000,   /* U+00D9 */
  0x0000,   /* U+00DA */
  0x0000,   /* U+00DB */
  0x0000,   /* U+00DC */
  0x0000,   /* U+00DD */
  0x0000,   /* U+00DE */
  0x0000,   /* U+00DF */
  0x0000,   /* U+00E0 */
  0x0000,   /* U+00E1 */
  0x0000,   /* U+00E2 */
  0x0000,   /* U+00E3 */
  0x0000,   /* U+00E4 */
  0x0000,   /* U+00E5 */
  0x0000,   /* U+00E6 */
  0x0000,   /* U+00E7 */
  0x0000,   /* U+00E8 */
  0x0000,   /* U+00E9 */
  0x0000,   /* U+00EA */
  0x0000,   /* U+00EB */
  0x0000,   /* U+00EC */
  0x0000,   /* U+00ED */
  0x0000,   /* U+00EE */
  0x0000,   /* U+00EF */
  0x0000,   /* U+00F0 */
  0x0000,   /* U+00F1 */
  0x0000,   /* U+00F2 */
  0x0000,   /* U+00F3 */
  0x0000,   /* U+00F4 */
  0x0000,   /* U+00F5 */
  0x0000,   /* U+00F6 */
  0x0000,   /* U+00F7 */
  0x0000,   /* U+00F8 */
  0x0000,   /* U+00F9 */
  0x0000,   /* U+00FA */
  0x0000,   /* U+00FB */
  0x0000,   /* U+00FC */
  0x0000,   /* U+00FD */
  0x0000,   /* U+00FE */
  0x0000,   /* U+00FF */

  /* Secondary weight 2 for each character. */
  0x0000,   /* U+0000 */
  0x0000,   /* U+0001 */
  0x0000,   /* U+0002 */
  0x0000,   /* U+0003 */
  0x0000,   /* U+0004 */
  0x0000,   /* U+0005 */
  0x0000,   /* U+0006 */
  0x0000,   /* U+0007 */
  0x0000,   /* U+0008 */
  0x0000,   /* U+0009 */
  0x0000,   /* U+000A */
  0x0000,   /* U+000B */
  0x0000,   /* U+000C */
  0x0000,   /* U+000D */
  0x0000,   /* U+000E */
  0x0000,   /* U+000F */
  0x0000,   /* U+0010 */
  0x0000,   /* U+0011 */
  0x0000,   /* U+0012 */
  0x0000,   /* U+0013 */
  0x0000,   /* U+0014 */
  0x0000,   /* U+0015 */
  0x0000,   /* U+0016 */
  0x0000,   /* U+0017 */
  0x0000,   /* U+0018 */
  0x0000,   /* U+0019 */
  0x0000,   /* U+001A */
  0x0000,   /* U+001B */
  0x0000,   /* U+001C */
  0x0000,   /* U+001D */
  0x0000,   /* U+001E */
  0x0000,   /* U+001F */
  0x0000,   /* U+0020 */
  0x0000,   /* U+0021 */
  0x0000,   /* U+0022 */
  0x0000,   /* U+0023 */
  0x0000,   /* U+0024 */
  0x0000,   /* U+0025 */
  0x0000,   /* U+0026 */
  0x0000,   /* U+0027 */
  0x0000,   /* U+0028 */
  0x0000,   /* U+0029 */
  0x0000,   /* U+002A */
  0x0000,   /* U+002B */
  0x0000,   /* U+002C */
  0x0000,   /* U+002D */
  0x0000,   /* U+002E */
  0x0000,   /* U+002F */
  0x0000,   /* U+0030 */
  0x0000,   /* U+0031 */
  0x0000,   /* U+0032 */
  0x0000,   /* U+0033 */
  0x0000,   /* U+0034 */
  0x0000,   /* U+0035 */
  0x0000,   /* U+0036 */
  0x0000,   /* U+0037 */
  0x0000,   /* U+0038 */
  0x0000,   /* U+0039 */
  0x0000,   /* U+003A */
  0x0000,   /* U+003B */
  0x0000,   /* U+003C */
  0x0000,   /* U+003D */
  0x0000,   /* U+003E */
  0x0000,   /* U+003F */
  0x0000,   /* U+0040 */
  0x0000,   /* U+0041 */
  0x0000,   /* U+0042 */
  0x0000,   /* U+0043 */
  0x0000,   /* U+0044 */
  0x0000,   /* U+0045 */
  0x0000,   /* U+0046 */
  0x0000,   /* U+0047 */
  0x0000,   /* U+0048 */
  0x0000,   /* U+0049 */
  0x0000,   /* U+004A */
  0x0000,   /* U+004B */
  0x0000,   /* U+004C */
  0x0000,   /* U+004D */
  0x0000,   /* U+004E */
  0x0000,   /* U+004F */
  0x0000,   /* U+0050 */
  0x0000,   /* U+0051 */
  0x0000,   /* U+0052 */
  0x0000,   /* U+0053 */
  0x0000,   /* U+0054 */
  0x0000,   /* U+0055 */
  0x0000,   /* U+0056 */
  0x0000,   /* U+0057 */
  0x0000,   /* U+0058 */
  0x0000,   /* U+0059 */
  0x0000,   /* U+005A */
  0x0000,   /* U+005B */
  0x0000,   /* U+005C */
  0x0000,   /* U+005D */
  0x0000,   /* U+005E */
  0x0000,   /* U+005F */
  0x0000,   /* U+0060 */
  0x0000,   /* U+0061 */
  0x0000,   /* U+0062 */
  0x0000,   /* U+0063 */
  0x0000,   /* U+0064 */
  0x0000,   /* U+0065 */
  0x0000,   /* U+0066 */
  0x0000,   /* U+0067 */
  0x0000,   /* U+0068 */
  0x0000,   /* U+0069 */
  0x0000,   /* U+006A */
  0x0000,   /* U+006B */
  0x0000,   /* U+006C */
  0x0000,   /* U+006D */
  0x0000,   /* U+006E */
  0x0000,   /* U+006F */
  0x0000,   /* U+0070 */
  0x0000,   /* U+0071 */
  0x0000,   /* U+0072 */
  0x0000,   /* U+0073 */
  0x0000,   /* U+0074 */
  0x0000,   /* U+0075 */
  0x0000,   /* U+0076 */
  0x0000,   /* U+0077 */
  0x0000,   /* U+0078 */
  0x0000,   /* U+0079 */
  0x0000,   /* U+007A */
  0x0000,   /* U+007B */
  0x0000,   /* U+007C */
  0x0000,   /* U+007D */
  0x0000,   /* U+007E */
  0x0000,   /* U+007F */
  0x0000,   /* U+0080 */
  0x0000,   /* U+0081 */
  0x0000,   /* U+0082 */
  0x0000,   /* U+0083 */
  0x0000,   /* U+0084 */
  0x0000,   /* U+0085 */
  0x0000,   /* U+0086 */
  0x0000,   /* U+0087 */
  0x0000,   /* U+0088 */
  0x0000,   /* U+0089 */
  0x0000,   /* U+008A */
  0x0000,   /* U+008B */
  0x0000,   /* U+008C */
  0x0000,   /* U+008D */
  0x0000,   /* U+008E */
  0x0000,   /* U+008F */
  0x0000,   /* U+0090 */
  0x0000,   /* U+0091 */
  0x0000,   /* U+0092 */
  0x0000,   /* U+0093 */
  0x0000,   /* U+0094 */
  0x0000,   /* U+0095 */
  0x0000,   /* U+0096 */
  0x0000,   /* U+0097 */
  0x0000,   /* U+0098 */
  0x0000,   /* U+0099 */
  0x0000,   /* U+009A */
  0x0000,   /* U+009B */
  0x0000,   /* U+009C */
  0x0000,   /* U+009D */
  0x0000,   /* U+009E */
  0x0000,   /* U+009F */
  0x0000,   /* U+00A0 */
  0x0000,   /* U+00A1 */
  0x0000,   /* U+00A2 */
  0x0000,   /* U+00A3 */
  0x0000,   /* U+00A4 */
  0x0000,   /* U+00A5 */
  0x0000,   /* U+00A6 */
  0x0000,   /* U+00A7 */
  0x0000,   /* U+00A8 */
  0x0000,   /* U+00A9 */
  0x0000,   /* U+00AA */
  0x0000,   /* U+00AB */
  0x0000,   /* U+00AC */
  0x0000,   /* U+00AD */
  0x0000,   /* U+00AE */
  0x0000,   /* U+00AF */
  0x0000,   /* U+00B0 */
  0x0000,   /* U+00B1 */
  0x0000,   /* U+00B2 */
  0x0000,   /* U+00B3 */
  0x0000,   /* U+00B4 */
  0x0000,   /* U+00B5 */
  0x0000,   /* U+00B6 */
  0x0000,   /* U+00B7 */
  0x0000,   /* U+00B8 */
  0x0000,   /* U+00B9 */
  0x0000,   /* U+00BA */
  0x0000,   /* U+00BB */
  0x0020,   /* U+00BC */
  0x0020,   /* U+00BD */
  0x0020,   /* U+00BE */
  0x0000,   /* U+00BF */
  0x0025,   /* U+00C0 */
  0x0024,   /* U+00C1 */
  0x0027,   /* U+00C2 */
  0x002D,   /* U+00C3 */
  0x002B,   /* U+00C4 */
  0x0029,   /* U+00C5 */
  0x0110,   /* U+00C6 */
  0x0030,   /* U+00C7 */
  0x0025,   /* U+00C8 */
  0x0024,   /* U+00C9 */
  0x0027,   /* U+00CA */
  0x002B,   /* U+00CB */
  0x0025,   /* U+00CC */
  0x0024,   /* U+00CD */
  0x0027,   /* U+00CE */
  0x002B,   /* U+00CF */
  0x0110,   /* U+00D0 */
  0x002D,   /* U+00D1 */
  0x0025,   /* U+00D2 */
  0x0024,   /* U+00D3 */
  0x0027,   /* U+00D4 */
  0x002D,   /* U+00D5 */
  0x002B,   /* U+00D6 */
  0x0000,   /* U+00D7 */
  0x002F,   /* U+00D8 */
  0x0025,   /* U+00D9 */
  0x0024,   /* U+00DA */
  0x0027,   /* U+00DB */
  0x002B,   /* U+00DC */
  0x0024,   /* U+00DD */
  0x0000,   /* U+00DE */
  0x0110,   /* U+00DF */
  0x0025,   /* U+00E0 */
  0x0024,   /* U+00E1 */
  0x0027,   /* U+00E2 */
  0x002D,   /* U+00E3 */
  0x002B,   /* U+00E4 */
  0x0029,   /* U+00E5 */
  0x0110,   /* U+00E6 */
  0x0030,   /* U+00E7 */
  0x0025,   /* U+00E8 */
  0x0024,   /* U+00E9 */
  0x0027,   /* U+00EA */
  0x002B,   /* U+00EB */
  0x0025,   /* U+00EC */
  0x0024,   /* U+00ED */
  0x0027,   /* U+00EE */
  0x002B,   /* U+00EF */
  0x0110,   /* U+00F0 */
  0x002D,   /* U+00F1 */
  0x0025,   /* U+00F2 */
  0x0024,   /* U+00F3 */
  0x0027,   /* U+00F4 */
  0x002D,   /* U+00F5 */
  0x002B,   /* U+00F6 */
  0x0000,   /* U+00F7 */
  0x002F,   /* U+00F8 */
  0x0025,   /* U+00F9 */
  0x0024,   /* U+00FA */
  0x0027,   /* U+00FB */
  0x002B,   /* U+00FC */
  0x0024,   /* U+00FD */
  0x0000,   /* U+00FE */
  0x002B,   /* U+00FF */

  /* Tertiary weight 2 for each character. */
  0x0000,   /* U+0000 */
  0x0000,   /* U+0001 */
  0x0000,   /* U+0002 */
  0x0000,   /* U+0003 */
  0x0000,   /* U+0004 */
  0x0000,   /* U+0005 */
  0x0000,   /* U+0006 */
  0x0000,   /* U+0007 */
  0x0000,   /* U+0008 */
  0x0000,   /* U+0009 */
  0x0000,   /* U+000A */
  0x0000,   /* U+000B */
  0x0000,   /* U+000C */
  0x0000,   /* U+000D */
  0x0000,   /* U+000E */
  0x0000,   /* U+000F */
  0x0000,   /* U+0010 */
  0x0000,   /* U+0011 */
  0x0000,   /* U+0012 */
  0x0000,   /* U+0013 */
  0x0000,   /* U+0014 */
  0x0000,   /* U+0015 */
  0x0000,   /* U+0016 */
  0x0000,   /* U+0017 */
  0x0000,   /* U+0018 */
  0x0000,   /* U+0019 */
  0x0000,   /* U+001A */
  0x0000,   /* U+001B */
  0x0000,   /* U+001C */
  0x0000,   /* U+001D */
  0x0000,   /* U+001E */
  0x0000,   /* U+001F */
  0x0000,   /* U+0020 */
  0x0000,   /* U+0021 */
  0x0000,   /* U+0022 */
  0x0000,   /* U+0023 */
  0x0000,   /* U+0024 */
  0x0000,   /* U+0025 */
  0x0000,   /* U+0026 */
  0x0000,   /* U+0027 */
  0x0000,   /* U+0028 */
  0x0000,   /* U+0029 */
  0x0000,   /* U+002A */
  0x0000,   /* U+002B */
  0x0000,   /* U+002C */
  0x0000,   /* U+002D */
  0x0000,   /* U+002E */
  0x0000,   /* U+002F */
  0x0000,   /* U+0030 */
  0x0000,   /* U+0031 */
  0x0000,   /* U+0032 */
  0x0000,   /* U+0033 */
  0x0000,   /* U+0034 */
  0x0000,   /* U+0035 */
  0x0000,   /* U+0036 */
  0x0000,   /* U+0037 */
  0x0000,   /* U+0038 */
  0x0000,   /* U+0039 */
  0x0000,   /* U+003A */
  0x0000,   /* U+003B */
  0x0000,   /* U+003C */
  0x0000,   /* U+003D */
  0x0000,   /* U+003E */
  0x0000,   /* U+003F */
  0x0000,   /* U+0040 */
  0x0000,   /* U+0041 */
  0x0000,   /* U+0042 */
  0x0000,   /* U+0043 */
  0x0000,   /* U+0044 */
  0x0000,   /* U+0045 */
  0x0000,   /* U+0046 */
  0x0000,   /* U+0047 */
  0x0000,   /* U+0048 */
  0x0000,   /* U+0049 */
  0x0000,   /* U+004A */
  0x0000,   /* U+004B */
  0x0000,   /* U+004C */
  0x0000,   /* U+004D */
  0x0000,   /* U+004E */
  0x0000,   /* U+004F */
  0x0000,   /* U+0050 */
  0x0000,   /* U+0051 */
  0x0000,   /* U+0052 */
  0x0000,   /* U+0053 */
  0x0000,   /* U+0054 */
  0x0000,   /* U+0055 */
  0x0000,   /* U+0056 */
  0x0000,   /* U+0057 */
  0x0000,   /* U+0058 */
  0x0000,   /* U+0059 */
  0x0000,   /* U+005A */
  0x0000,   /* U+005B */
  0x0000,   /* U+005C */
  0x0000,   /* U+005D */
  0x0000,   /* U+005E */
  0x0000,   /* U+005F */
  0x0000,   /* U+0060 */
  0x0000,   /* U+0061 */
  0x0000,   /* U+0062 */
  0x0000,   /* U+0063 */
  0x0000,   /* U+0064 */
  0x0000,   /* U+0065 */
  0x0000,   /* U+0066 */
  0x0000,   /* U+0067 */
  0x0000,   /* U+0068 */
  0x0000,   /* U+0069 */
  0x0000,   /* U+006A */
  0x0000,   /* U+006B */
  0x0000,   /* U+006C */
  0x0000,   /* U+006D */
  0x0000,   /* U+006E */
  0x0000,   /* U+006F */
  0x0000,   /* U+0070 */
  0x0000,   /* U+0071 */
  0x0000,   /* U+0072 */
  0x0000,   /* U+0073 */
  0x0000,   /* U+0074 */
  0x0000,   /* U+0075 */
  0x0000,   /* U+0076 */
  0x0000,   /* U+0077 */
  0x0000,   /* U+0078 */
  0x0000,   /* U+0079 */
  0x0000,   /* U+007A */
  0x0000,   /* U+007B */
  0x0000,   /* U+007C */
  0x0000,   /* U+007D */
  0x0000,   /* U+007E */
  0x0000,   /* U+007F */
  0x0000,   /* U+0080 */
  0x0000,   /* U+0081 */
  0x0000,   /* U+0082 */
  0x0000,   /* U+0083 */
  0x0000,   /* U+0084 */
  0x0000,   /* U+0085 */
  0x0000,   /* U+0086 */
  0x0000,   /* U+0087 */
  0x0000,   /* U+0088 */
  0x0000,   /* U+0089 */
  0x0000,   /* U+008A */
  0x0000,   /* U+008B */
  0x0000,   /* U+008C */
  0x0000,   /* U+008D */
  0x0000,   /* U+008E */
  0x0000,   /* U+008F */
  0x0000,   /* U+0090 */
  0x0000,   /* U+0091 */
  0x0000,   /* U+0092 */
  0x0000,   /* U+0093 */
  0x0000,   /* U+0094 */
  0x0000,   /* U+0095 */
  0x0000,   /* U+0096 */
  0x0000,   /* U+0097 */
  0x0000,   /* U+0098 */
  0x0000,   /* U+0099 */
  0x0000,   /* U+009A */
  0x0000,   /* U+009B */
  0x0000,   /* U+009C */
  0x0000,   /* U+009D */
  0x0000,   /* U+009E */
  0x0000,   /* U+009F */
  0x0000,   /* U+00A0 */
  0x0000,   /* U+00A1 */
  0x0000,   /* U+00A2 */
  0x0000,   /* U+00A3 */
  0x0000,   /* U+00A4 */
  0x0000,   /* U+00A5 */
  0x0000,   /* U+00A6 */
  0x0000,   /* U+00A7 */
  0x0000,   /* U+00A8 */
  0x0000,   /* U+00A9 */
  0x0000,   /* U+00AA */
  0x0000,   /* U+00AB */
  0x0000,   /* U+00AC */
  0x0000,   /* U+00AD */
  0x0000,   /* U+00AE */
  0x0000,   /* U+00AF */
  0x0000,   /* U+00B0 */
  0x0000,   /* U+00B1 */
  0x0000,   /* U+00B2 */
  0x0000,   /* U+00B3 */
  0x0000,   /* U+00B4 */
  0x0000,   /* U+00B5 */
  0x0000,   /* U+00B6 */
  0x0000,   /* U+00B7 */
  0x0000,   /* U+00B8 */
  0x0000,   /* U+00B9 */
  0x0000,   /* U+00BA */
  0x0000,   /* U+00BB */
  0x001E,   /* U+00BC */
  0x001E,   /* U+00BD */
  0x001E,   /* U+00BE */
  0x0000,   /* U+00BF */
  0x0002,   /* U+00C0 */
  0x0002,   /* U+00C1 */
  0x0002,   /* U+00C2 */
  0x0002,   /* U+00C3 */
  0x0002,   /* U+00C4 */
  0x0002,   /* U+00C5 */
  0x0004,   /* U+00C6 */
  0x0002,   /* U+00C7 */
  0x0002,   /* U+00C8 */
  0x0002,   /* U+00C9 */
  0x0002,   /* U+00CA */
  0x0002,   /* U+00CB */
  0x0002,   /* U+00CC */
  0x0002,   /* U+00CD */
  0x0002,   /* U+00CE */
  0x0002,   /* U+00CF */
  0x0004,   /* U+00D0 */
  0x0002,   /* U+00D1 */
  0x0002,   /* U+00D2 */
  0x0002,   /* U+00D3 */
  0x0002,   /* U+00D4 */
  0x0002,   /* U+00D5 */
  0x0002,   /* U+00D6 */
  0x0000,   /* U+00D7 */
  0x0002,   /* U+00D8 */
  0x0002,   /* U+00D9 */
  0x0002,   /* U+00DA */
  0x0002,   /* U+00DB */
  0x0002,   /* U+00DC */
  0x0002,   /* U+00DD */
  0x0000,   /* U+00DE */
  0x0004,   /* U+00DF */
  0x0002,   /* U+00E0 */
  0x0002,   /* U+00E1 */
  0x0002,   /* U+00E2 */
  0x0002,   /* U+00E3 */
  0x0002,   /* U+00E4 */
  0x0002,   /* U+00E5 */
  0x0004,   /* U+00E6 */
  0x0002,   /* U+00E7 */
  0x0002,   /* U+00E8 */
  0x0002,   /* U+00E9 */
  0x0002,   /* U+00EA */
  0x0002,   /* U+00EB */
  0x0002,   /* U+00EC */
  0x0002,   /* U+00ED */
  0x0002,   /* U+00EE */
  0x0002,   /* U+00EF */
  0x0004,   /* U+00F0 */
  0x0002,   /* U+00F1 */
  0x0002,   /* U+00F2 */
  0x0002,   /* U+00F3 */
  0x0002,   /* U+00F4 */
  0x0002,   /* U+00F5 */
  0x0002,   /* U+00F6 */
  0x0000,   /* U+00F7 */
  0x0002,   /* U+00F8 */
  0x0002,   /* U+00F9 */
  0x0002,   /* U+00FA */
  0x0002,   /* U+00FB */
  0x0002,   /* U+00FC */
  0x0002,   /* U+00FD */
  0x0000,   /* U+00FE */
  0x0002,   /* U+00FF */

  /* Primary weight 3 for each character. */
  0x0000,   /* U+0000 */
  0x0000,   /* U+0001 */
  0x0000,   /* U+0002 */
  0x0000,   /* U+0003 */
  0x0000,   /* U+0004 */
  0x0000,   /* U+0005 */
  0x0000,   /* U+0006 */
  0x0000,   /* U+0007 */
  0x0000,   /* U+0008 */
  0x0000,   /* U+0009 */
  0x0000,   /* U+000A */
  0x0000,   /* U+000B */
  0x0000,   /* U+000C */
  0x0000,   /* U+000D */
  0x0000,   /* U+000E */
  0x0000,   /* U+000F */
  0x0000,   /* U+0010 */
  0x0000,   /* U+0011 */
  0x0000,   /* U+0012 */
  0x0000,   /* U+0013 */
  0x0000,   /* U+0014 */
  0x0000,   /* U+0015 */
  0x0000,   /* U+0016 */
  0x0000,   /* U+0017 */
  0x0000,   /* U+0018 */
  0x0000,   /* U+0019 */
  0x0000,   /* U+001A */
  0x0000,   /* U+001B */
  0x0000,   /* U+001C */
  0x0000,   /* U+001D */
  0x0000,   /* U+001E */
  0x0000,   /* U+001F */
  0x0000,   /* U+0020 */
  0x0000,   /* U+0021 */
  0x0000,   /* U+0022 */
  0x0000,   /* U+0023 */
  0x0000,   /* U+0024 */
  0x0000,   /* U+0025 */
  0x0000,   /* U+0026 */
  0x0000,   /* U+0027 */
  0x0000,   /* U+0028 */
  0x0000,   /* U+0029 */
  0x0000,   /* U+002A */
  0x0000,   /* U+002B */
  0x0000,   /* U+002C */
  0x0000,   /* U+002D */
  0x0000,   /* U+002E */
  0x0000,   /* U+002F */
  0x0000,   /* U+0030 */
  0x0000,   /* U+0031 */
  0x0000,   /* U+0032 */
  0x0000,   /* U+0033 */
  0x0000,   /* U+0034 */
  0x0000,   /* U+0035 */
  0x0000,   /* U+0036 */
  0x0000,   /* U+0037 */
  0x0000,   /* U+0038 */
  0x0000,   /* U+0039 */
  0x0000,   /* U+003A */
  0x0000,   /* U+003B */
  0x0000,   /* U+003C */
  0x0000,   /* U+003D */
  0x0000,   /* U+003E */
  0x0000,   /* U+003F */
  0x0000,   /* U+0040 */
  0x0000,   /* U+0041 */
  0x0000,   /* U+0042 */
  0x0000,   /* U+0043 */
  0x0000,   /* U+0044 */
  0x0000,   /* U+0045 */
  0x0000,   /* U+0046 */
  0x0000,   /* U+0047 */
  0x0000,   /* U+0048 */
  0x0000,   /* U+0049 */
  0x0000,   /* U+004A */
  0x0000,   /* U+004B */
  0x0000,   /* U+004C */
  0x0000,   /* U+004D */
  0x0000,   /* U+004E */
  0x0000,   /* U+004F */
  0x0000,   /* U+0050 */
  0x0000,   /* U+0051 */
  0x0000,   /* U+0052 */
  0x0000,   /* U+0053 */
  0x0000,   /* U+0054 */
  0x0000,   /* U+0055 */
  0x0000,   /* U+0056 */
  0x0000,   /* U+0057 */
  0x0000,   /* U+0058 */
  0x0000,   /* U+0059 */
  0x0000,   /* U+005A */
  0x0000,   /* U+005B */
  0x0000,   /* U+005C */
  0x0000,   /* U+005D */
  0x0000,   /* U+005E */
  0x0000,   /* U+005F */
  0x0000,   /* U+0060 */
  0x0000,   /* U+0061 */
  0x0000,   /* U+0062 */
  0x0000,   /* U+0063 */
  0x0000,   /* U+0064 */
  0x0000,   /* U+0065 */
  0x0000,   /* U+0066 */
  0x0000,   /* U+0067 */
  0x0000,   /* U+0068 */
  0x0000,   /* U+0069 */
  0x0000,   /* U+006A */
  0x0000,   /* U+006B */
  0x0000,   /* U+006C */
  0x0000,   /* U+006D */
  0x0000,   /* U+006E */
  0x0000,   /* U+006F */
  0x0000,   /* U+0070 */
  0x0000,   /* U+0071 */
  0x0000,   /* U+0072 */
  0x0000,   /* U+0073 */
  0x0000,   /* U+0074 */
  0x0000,   /* U+0075 */
  0x0000,   /* U+0076 */
  0x0000,   /* U+0077 */
  0x0000,   /* U+0078 */
  0x0000,   /* U+0079 */
  0x0000,   /* U+007A */
  0x0000,   /* U+007B */
  0x0000,   /* U+007C */
  0x0000,   /* U+007D */
  0x0000,   /* U+007E */
  0x0000,   /* U+007F */
  0x0000,   /* U+0080 */
  0x0000,   /* U+0081 */
  0x0000,   /* U+0082 */
  0x0000,   /* U+0083 */
  0x0000,   /* U+0084 */
  0x0000,   /* U+0085 */
  0x0000,   /* U+0086 */
  0x0000,   /* U+0087 */
  0x0000,   /* U+0088 */
  0x0000,   /* U+0089 */
  0x0000,   /* U+008A */
  0x0000,   /* U+008B */
  0x0000,   /* U+008C */
  0x0000,   /* U+008D */
  0x0000,   /* U+008E */
  0x0000,   /* U+008F */
  0x0000,   /* U+0090 */
  0x0000,   /* U+0091 */
  0x0000,   /* U+0092 */
  0x0000,   /* U+0093 */
  0x0000,   /* U+0094 */
  0x0000,   /* U+0095 */
  0x0000,   /* U+0096 */
  0x0000,   /* U+0097 */
  0x0000,   /* U+0098 */
  0x0000,   /* U+0099 */
  0x0000,   /* U+009A */
  0x0000,   /* U+009B */
  0x0000,   /* U+009C */
  0x0000,   /* U+009D */
  0x0000,   /* U+009E */
  0x0000,   /* U+009F */
  0x0000,   /* U+00A0 */
  0x0000,   /* U+00A1 */
  0x0000,   /* U+00A2 */
  0x0000,   /* U+00A3 */
  0x0000,   /* U+00A4 */
  0x0000,   /* U+00A5 */
  0x0000,   /* U+00A6 */
  0x0000,   /* U+00A7 */
  0x0000,   /* U+00A8 */
  0x0000,   /* U+00A9 */
  0x0000,   /* U+00AA */
  0x0000,   /* U+00AB */
  0x0000,   /* U+00AC */
  0x0000,   /* U+00AD */
  0x0000,   /* U+00AE */
  0x0000,   /* U+00AF */
  0x0000,   /* U+00B0 */
  0x0000,   /* U+00B1 */
  0x0000,   /* U+00B2 */
  0x0000,   /* U+00B3 */
  0x0000,   /* U+00B4 */
  0x0000,   /* U+00B5 */
  0x0000,   /* U+00B6 */
  0x0000,   /* U+00B7 */
  0x0000,   /* U+00B8 */
  0x0000,   /* U+00B9 */
  0x0000,   /* U+00BA */
  0x0000,   /* U+00BB */
  0x1C41,   /* U+00BC */
  0x1C3F,   /* U+00BD */
  0x1C41,   /* U+00BE */
  0x0000,   /* U+00BF */
  0x0000,   /* U+00C0 */
  0x0000,   /* U+00C1 */
  0x0000,   /* U+00C2 */
  0x0000,   /* U+00C3 */
  0x0000,   /* U+00C4 */
  0x0000,   /* U+00C5 */
  0x1CAA,   /* U+00C6 */
  0x0000,   /* U+00C7 */
  0x0000,   /* U+00C8 */
  0x0000,   /* U+00C9 */
  0x0000,   /* U+00CA */
  0x0000,   /* U+00CB */
  0x0000,   /* U+00CC */
  0x0000,   /* U+00CD */
  0x0000,   /* U+00CE */
  0x0000,   /* U+00CF */
  0x0000,   /* U+00D0 */
  0x0000,   /* U+00D1 */
  0x0000,   /* U+00D2 */
  0x0000,   /* U+00D3 */
  0x0000,   /* U+00D4 */
  0x0000,   /* U+00D5 */
  0x0000,   /* U+00D6 */
  0x0000,   /* U+00D7 */
  0x0000,   /* U+00D8 */
  0x0000,   /* U+00D9 */
  0x0000,   /* U+00DA */
  0x0000,   /* U+00DB */
  0x0000,   /* U+00DC */
  0x0000,   /* U+00DD */
  0x0000,   /* U+00DE */
  0x1E71,   /* U+00DF */
  0x0000,   /* U+00E0 */
  0x0000,   /* U+00E1 */
  0x0000,   /* U+00E2 */
  0x0000,   /* U+00E3 */
  0x0000,   /* U+00E4 */
  0x0000,   /* U+00E5 */
  0x1CAA,   /* U+00E6 */
  0x0000,   /* U+00E7 */
  0x0000,   /* U+00E8 */
  0x0000,   /* U+00E9 */
  0x0000,   /* U+00EA */
  0x0000,   /* U+00EB */
  0x0000,   /* U+00EC */
  0x0000,   /* U+00ED */
  0x0000,   /* U+00EE */
  0x0000,   /* U+00EF */
  0x0000,   /* U+00F0 */
  0x0000,   /* U+00F1 */
  0x0000,   /* U+00F2 */
  0x0000,   /* U+00F3 */
  0x0000,   /* U+00F4 */
  0x0000,   /* U+00F5 */
  0x0000,   /* U+00F6 */
  0x0000,   /* U+00F7 */
  0x0000,   /* U+00F8 */
  0x0000,   /* U+00F9 */
  0x0000,   /* U+00FA */
  0x0000,   /* U+00FB */
  0x0000,   /* U+00FC */
  0x0000,   /* U+00FD */
  0x0000,   /* U+00FE */
  0x0000,   /* U+00FF */

  /* Secondary weight 3 for each character. */
  0x0000,   /* U+0000 */
  0x0000,   /* U+0001 */
  0x0000,   /* U+0002 */
  0x0000,   /* U+0003 */
  0x0000,   /* U+0004 */
  0x0000,   /* U+0005 */
  0x0000,   /* U+0006 */
  0x0000,   /* U+0007 */
  0x0000,   /* U+0008 */
  0x0000,   /* U+0009 */
  0x0000,   /* U+000A */
  0x0000,   /* U+000B */
  0x0000,   /* U+000C */
  0x0000,   /* U+000D */
  0x0000,   /* U+000E */
  0x0000,   /* U+000F */
  0x0000,   /* U+0010 */
  0x0000,   /* U+0011 */
  0x0000,   /* U+0012 */
  0x0000,   /* U+0013 */
  0x0000,   /* U+0014 */
  0x0000,   /* U+0015 */
  0x0000,   /* U+0016 */
  0x0000,   /* U+0017 */
  0x0000,   /* U+0018 */
  0x0000,   /* U+0019 */
  0x0000,   /* U+001A */
  0x0000,   /* U+001B */
  0x0000,   /* U+001C */
  0x0000,   /* U+001D */
  0x0000,   /* U+001E */
  0x0000,   /* U+001F */
  0x0000,   /* U+0020 */
  0x0000,   /* U+0021 */
  0x0000,   /* U+0022 */
  0x0000,   /* U+0023 */
  0x0000,   /* U+0024 */
  0x0000,   /* U+0025 */
  0x0000,   /* U+0026 */
  0x0000,   /* U+0027 */
  0x0000,   /* U+0028 */
  0x0000,   /* U+0029 */
  0x0000,   /* U+002A */
  0x0000,   /* U+002B */
  0x0000,   /* U+002C */
  0x0000,   /* U+002D */
  0x0000,   /* U+002E */
  0x0000,   /* U+002F */
  0x0000,   /* U+0030 */
  0x0000,   /* U+0031 */
  0x0000,   /* U+0032 */
  0x0000,   /* U+0033 */
  0x0000,   /* U+0034 */
  0x0000,   /* U+0035 */
  0x0000,   /* U+0036 */
  0x0000,   /* U+0037 */
  0x0000,   /* U+0038 */
  0x0000,   /* U+0039 */
  0x0000,   /* U+003A */
  0x0000,   /* U+003B */
  0x0000,   /* U+003C */
  0x0000,   /* U+003D */
  0x0000,   /* U+003E */
  0x0000,   /* U+003F */
  0x0000,   /* U+0040 */
  0x0000,   /* U+0041 */
  0x0000,   /* U+0042 */
  0x0000,   /* U+0043 */
  0x0000,   /* U+0044 */
  0x0000,   /* U+0045 */
  0x0000,   /* U+0046 */
  0x0000,   /* U+0047 */
  0x0000,   /* U+0048 */
  0x0000,   /* U+0049 */
  0x0000,   /* U+004A */
  0x0000,   /* U+004B */
  0x0000,   /* U+004C */
  0x0000,   /* U+004D */
  0x0000,   /* U+004E */
  0x0000,   /* U+004F */
  0x0000,   /* U+0050 */
  0x0000,   /* U+0051 */
  0x0000,   /* U+0052 */
  0x0000,   /* U+0053 */
  0x0000,   /* U+0054 */
  0x0000,   /* U+0055 */
  0x0000,   /* U+0056 */
  0x0000,   /* U+0057 */
  0x0000,   /* U+0058 */
  0x0000,   /* U+0059 */
  0x0000,   /* U+005A */
  0x0000,   /* U+005B */
  0x0000,   /* U+005C */
  0x0000,   /* U+005D */
  0x0000,   /* U+005E */
  0x0000,   /* U+005F */
  0x0000,   /* U+0060 */
  0x0000,   /* U+0061 */
  0x0000,   /* U+0062 */
  0x0000,   /* U+0063 */
  0x0000,   /* U+0064 */
  0x0000,   /* U+0065 */
  0x0000,   /* U+0066 */
  0x0000,   /* U+0067 */
  0x0000,   /* U+0068 */
  0x0000,   /* U+0069 */
  0x0000,   /* U+006A */
  0x0000,   /* U+006B */
  0x0000,   /* U+006C */
  0x0000,   /* U+006D */
  0x0000,   /* U+006E */
  0x0000,   /* U+006F */
  0x0000,   /* U+0070 */
  0x0000,   /* U+0071 */
  0x0000,   /* U+0072 */
  0x0000,   /* U+0073 */
  0x0000,   /* U+0074 */
  0x0000,   /* U+0075 */
  0x0000,   /* U+0076 */
  0x0000,   /* U+0077 */
  0x0000,   /* U+0078 */
  0x0000,   /* U+0079 */
  0x0000,   /* U+007A */
  0x0000,   /* U+007B */
  0x0000,   /* U+007C */
  0x0000,   /* U+007D */
  0x0000,   /* U+007E */
  0x0000,   /* U+007F */
  0x0000,   /* U+0080 */
  0x0000,   /* U+0081 */
  0x0000,   /* U+0082 */
  0x0000,   /* U+0083 */
  0x0000,   /* U+0084 */
  0x0000,   /* U+0085 */
  0x0000,   /* U+0086 */
  0x0000,   /* U+0087 */
  0x0000,   /* U+0088 */
  0x0000,   /* U+0089 */
  0x0000,   /* U+008A */
  0x0000,   /* U+008B */
  0x0000,   /* U+008C */
  0x0000,   /* U+008D */
  0x0000,   /* U+008E */
  0x0000,   /* U+008F */
  0x0000,   /* U+0090 */
  0x0000,   /* U+0091 */
  0x0000,   /* U+0092 */
  0x0000,   /* U+0093 */
  0x0000,   /* U+0094 */
  0x0000,   /* U+0095 */
  0x0000,   /* U+0096 */
  0x0000,   /* U+0097 */
  0x0000,   /* U+0098 */
  0x0000,   /* U+0099 */
  0x0000,   /* U+009A */
  0x0000,   /* U+009B */
  0x0000,   /* U+009C */
  0x0000,   /* U+009D */
  0x0000,   /* U+009E */
  0x0000,   /* U+009F */
  0x0000,   /* U+00A0 */
  0x0000,   /* U+00A1 */
  0x0000,   /* U+00A2 */
  0x0000,   /* U+00A3 */
  0x0000,   /* U+00A4 */
  0x0000,   /* U+00A5 */
  0x0000,   /* U+00A6 */
  0x0000,   /* U+00A7 */
  0x0000,   /* U+00A8 */
  0x0000,   /* U+00A9 */
  0x0000,   /* U+00AA */
  0x0000,   /* U+00AB */
  0x0000,   /* U+00AC */
  0x0000,   /* U+00AD */
  0x0000,   /* U+00AE */
  0x0000,   /* U+00AF */
  0x0000,   /* U+00B0 */
  0x0000,   /* U+00B1 */
  0x0000,   /* U+00B2 */
  0x0000,   /* U+00B3 */
  0x0000,   /* U+00B4 */
  0x0000,   /* U+00B5 */
  0x0000,   /* U+00B6 */
  0x0000,   /* U+00B7 */
  0x0000,   /* U+00B8 */
  0x0000,   /* U+00B9 */
  0x0000,   /* U+00BA */
  0x0000,   /* U+00BB */
  0x0020,   /* U+00BC */
  0x0020,   /* U+00BD */
  0x0020,   /* U+00BE */
  0x0000,   /* U+00BF */
  0x0000,   /* U+00C0 */
  0x0000,   /* U+00C1 */
  0x0000,   /* U+00C2 */
  0x0000,   /* U+00C3 */
  0x0000,   /* U+00C4 */
  0x0000,   /* U+00C5 */
  0x0020,   /* U+00C6 */
  0x0000,   /* U+00C7 */
  0x0000,   /* U+00C8 */
  0x0000,   /* U+00C9 */
  0x0000,   /* U+00CA */
  0x0000,   /* U+00CB */
  0x0000,   /* U+00CC */
  0x0000,   /* U+00CD */
  0x0000,   /* U+00CE */
  0x0000,   /* U+00CF */
  0x0000,   /* U+00D0 */
  0x0000,   /* U+00D1 */
  0x0000,   /* U+00D2 */
  0x0000,   /* U+00D3 */
  0x0000,   /* U+00D4 */
  0x0000,   /* U+00D5 */
  0x0000,   /* U+00D6 */
  0x0000,   /* U+00D7 */
  0x0000,   /* U+00D8 */
  0x0000,   /* U+00D9 */
  0x0000,   /* U+00DA */
  0x0000,   /* U+00DB */
  0x0000,   /* U+00DC */
  0x0000,   /* U+00DD */
  0x0000,   /* U+00DE */
  0x0020,   /* U+00DF */
  0x0000,   /* U+00E0 */
  0x0000,   /* U+00E1 */
  0x0000,   /* U+00E2 */
  0x0000,   /* U+00E3 */
  0x0000,   /* U+00E4 */
  0x0000,   /* U+00E5 */
  0x0020,   /* U+00E6 */
  0x0000,   /* U+00E7 */
  0x0000,   /* U+00E8 */
  0x0000,   /* U+00E9 */
  0x0000,   /* U+00EA */
  0x0000,   /* U+00EB */
  0x0000,   /* U+00EC */
  0x0000,   /* U+00ED */
  0x0000,   /* U+00EE */
  0x0000,   /* U+00EF */
  0x0000,   /* U+00F0 */
  0x0000,   /* U+00F1 */
  0x0000,   /* U+00F2 */
  0x0000,   /* U+00F3 */
  0x0000,   /* U+00F4 */
  0x0000,   /* U+00F5 */
  0x0000,   /* U+00F6 */
  0x0000,   /* U+00F7 */
  0x0000,   /* U+00F8 */
  0x0000,   /* U+00F9 */
  0x0000,   /* U+00FA */
  0x0000,   /* U+00FB */
  0x0000,   /* U+00FC */
  0x0000,   /* U+00FD */
  0x0000,   /* U+00FE */
  0x0000,   /* U+00FF */

  /* Tertiary weight 3 for each character. */
  0x0000,   /* U+0000 */
  0x0000,   /* U+0001 */
  0x0000,   /* U+0002 */
  0x0000,   /* U+0003 */
  0x0000,   /* U+0004 */
  0x0000,   /* U+0005 */
  0x0000,   /* U+0006 */
  0x0000,   /* U+0007 */
  0x0000,   /* U+0008 */
  0x0000,   /* U+0009 */
  0x0000,   /* U+000A */
  0x0000,   /* U+000B */
  0x0000,   /* U+000C */
  0x0000,   /* U+000D */
  0x0000,   /* U+000E */
  0x0000,   /* U+000F */
  0x0000,   /* U+0010 */
  0x0000,   /* U+0011 */
  0x0000,   /* U+0012 */
  0x0000,   /* U+0013 */
  0x0000,   /* U+0014 */
  0x0000,   /* U+0015 */
  0x0000,   /* U+0016 */
  0x0000,   /* U+0017 */
  0x0000,   /* U+0018 */
  0x0000,   /* U+0019 */
  0x0000,   /* U+001A */
  0x0000,   /* U+001B */
  0x0000,   /* U+001C */
  0x0000,   /* U+001D */
  0x0000,   /* U+001E */
  0x0000,   /* U+001F */
  0x0000,   /* U+0020 */
  0x0000,   /* U+0021 */
  0x0000,   /* U+0022 */
  0x0000,   /* U+0023 */
  0x0000,   /* U+0024 */
  0x0000,   /* U+0025 */
  0x0000,   /* U+0026 */
  0x0000,   /* U+0027 */
  0x0000,   /* U+0028 */
  0x0000,   /* U+0029 */
  0x0000,   /* U+002A */
  0x0000,   /* U+002B */
  0x0000,   /* U+002C */
  0x0000,   /* U+002D */
  0x0000,   /* U+002E */
  0x0000,   /* U+002F */
  0x0000,   /* U+0030 */
  0x0000,   /* U+0031 */
  0x0000,   /* U+0032 */
  0x0000,   /* U+0033 */
  0x0000,   /* U+0034 */
  0x0000,   /* U+0035 */
  0x0000,   /* U+0036 */
  0x0000,   /* U+0037 */
  0x0000,   /* U+0038 */
  0x0000,   /* U+0039 */
  0x0000,   /* U+003A */
  0x0000,   /* U+003B */
  0x0000,   /* U+003C */
  0x0000,   /* U+003D */
  0x0000,   /* U+003E */
  0x0000,   /* U+003F */
  0x0000,   /* U+0040 */
  0x0000,   /* U+0041 */
  0x0000,   /* U+0042 */
  0x0000,   /* U+0043 */
  0x0000,   /* U+0044 */
  0x0000,   /* U+0045 */
  0x0000,   /* U+0046 */
  0x0000,   /* U+0047 */
  0x0000,   /* U+0048 */
  0x0000,   /* U+0049 */
  0x0000,   /* U+004A */
  0x0000,   /* U+004B */
  0x0000,   /* U+004C */
  0x0000,   /* U+004D */
  0x0000,   /* U+004E */
  0x0000,   /* U+004F */
  0x0000,   /* U+0050 */
  0x0000,   /* U+0051 */
  0x0000,   /* U+0052 */
  0x0000,   /* U+0053 */
  0x0000,   /* U+0054 */
  0x0000,   /* U+0055 */
  0x0000,   /* U+0056 */
  0x0000,   /* U+0057 */
  0x0000,   /* U+0058 */
  0x0000,   /* U+0059 */
  0x0000,   /* U+005A */
  0x0000,   /* U+005B */
  0x0000,   /* U+005C */
  0x0000,   /* U+005D */
  0x0000,   /* U+005E */
  0x0000,   /* U+005F */
  0x0000,   /* U+0060 */
  0x0000,   /* U+0061 */
  0x0000,   /* U+0062 */
  0x0000,   /* U+0063 */
  0x0000,   /* U+0064 */
  0x0000,   /* U+0065 */
  0x0000,   /* U+0066 */
  0x0000,   /* U+0067 */
  0x0000,   /* U+0068 */
  0x0000,   /* U+0069 */
  0x0000,   /* U+006A */
  0x0000,   /* U+006B */
  0x0000,   /* U+006C */
  0x0000,   /* U+006D */
  0x0000,   /* U+006E */
  0x0000,   /* U+006F */
  0x0000,   /* U+0070 */
  0x0000,   /* U+0071 */
  0x0000,   /* U+0072 */
  0x0000,   /* U+0073 */
  0x0000,   /* U+0074 */
  0x0000,   /* U+0075 */
  0x0000,   /* U+0076 */
  0x0000,   /* U+0077 */
  0x0000,   /* U+0078 */
  0x0000,   /* U+0079 */
  0x0000,   /* U+007A */
  0x0000,   /* U+007B */
  0x0000,   /* U+007C */
  0x0000,   /* U+007D */
  0x0000,   /* U+007E */
  0x0000,   /* U+007F */
  0x0000,   /* U+0080 */
  0x0000,   /* U+0081 */
  0x0000,   /* U+0082 */
  0x0000,   /* U+0083 */
  0x0000,   /* U+0084 */
  0x0000,   /* U+0085 */
  0x0000,   /* U+0086 */
  0x0000,   /* U+0087 */
  0x0000,   /* U+0088 */
  0x0000,   /* U+0089 */
  0x0000,   /* U+008A */
  0x0000,   /* U+008B */
  0x0000,   /* U+008C */
  0x0000,   /* U+008D */
  0x0000,   /* U+008E */
  0x0000,   /* U+008F */
  0x0000,   /* U+0090 */
  0x0000,   /* U+0091 */
  0x0000,   /* U+0092 */
  0x0000,   /* U+0093 */
  0x0000,   /* U+0094 */
  0x0000,   /* U+0095 */
  0x0000,   /* U+0096 */
  0x0000,   /* U+0097 */
  0x0000,   /* U+0098 */
  0x0000,   /* U+0099 */
  0x0000,   /* U+009A */
  0x0000,   /* U+009B */
  0x0000,   /* U+009C */
  0x0000,   /* U+009D */
  0x0000,   /* U+009E */
  0x0000,   /* U+009F */
  0x0000,   /* U+00A0 */
  0x0000,   /* U+00A1 */
  0x0000,   /* U+00A2 */
  0x0000,   /* U+00A3 */
  0x0000,   /* U+00A4 */
  0x0000,   /* U+00A5 */
  0x0000,   /* U+00A6 */
  0x0000,   /* U+00A7 */
  0x0000,   /* U+00A8 */
  0x0000,   /* U+00A9 */
  0x0000,   /* U+00AA */
  0x0000,   /* U+00AB */
  0x0000,   /* U+00AC */
  0x0000,   /* U+00AD */
  0x0000,   /* U+00AE */
  0x0000,   /* U+00AF */
  0x0000,   /* U+00B0 */
  0x0000,   /* U+00B1 */
  0x0000,   /* U+00B2 */
  0x0000,   /* U+00B3 */
  0x0000,   /* U+00B4 */
  0x0000,   /* U+00B5 */
  0x0000,   /* U+00B6 */
  0x0000,   /* U+00B7 */
  0x0000,   /* U+00B8 */
  0x0000,   /* U+00B9 */
  0x0000,   /* U+00BA */
  0x0000,   /* U+00BB */
  0x001E,   /* U+00BC */
  0x001E,   /* U+00BD */
  0x001E,   /* U+00BE */
  0x0000,   /* U+00BF */
  0x0000,   /* U+00C0 */
  0x0000,   /* U+00C1 */
  0x0000,   /* U+00C2 */
  0x0000,   /* U+00C3 */
  0x0000,   /* U+00C4 */
  0x0000,   /* U+00C5 */
  0x000A,   /* U+00C6 */
  0x0000,   /* U+00C7 */
  0x0000,   /* U+00C8 */
  0x0000,   /* U+00C9 */
  0x0000,   /* U+00CA */
  0x0000,   /* U+00CB */
  0x0000,   /* U+00CC */
  0x0000,   /* U+00CD */
  0x0000,   /* U+00CE */
  0x0000,   /* U+00CF */
  0x0000,   /* U+00D0 */
  0x0000,   /* U+00D1 */
  0x0000,   /* U+00D2 */
  0x0000,   /* U+00D3 */
  0x0000,   /* U+00D4 */
  0x0000,   /* U+00D5 */
  0x0000,   /* U+00D6 */
  0x0000,   /* U+00D7 */
  0x0000,   /* U+00D8 */
  0x0000,   /* U+00D9 */
  0x0000,   /* U+00DA */
  0x0000,   /* U+00DB */
  0x0000,   /* U+00DC */
  0x0000,   /* U+00DD */
  0x0000,   /* U+00DE */
  0x0004,   /* U+00DF */
  0x0000,   /* U+00E0 */
  0x0000,   /* U+00E1 */
  0x0000,   /* U+00E2 */
  0x0000,   /* U+00E3 */
  0x0000,   /* U+00E4 */
  0x0000,   /* U+00E5 */
  0x0004,   /* U+00E6 */
  0x0000,   /* U+00E7 */
  0x0000,   /* U+00E8 */
  0x0000,   /* U+00E9 */
  0x0000,   /* U+00EA */
  0x0000,   /* U+00EB */
  0x0000,   /* U+00EC */
  0x0000,   /* U+00ED */
  0x0000,   /* U+00EE */
  0x0000,   /* U+00EF */
  0x0000,   /* U+00F0 */
  0x0000,   /* U+00F1 */
  0x0000,   /* U+00F2 */
  0x0000,   /* U+00F3 */
  0x0000,   /* U+00F4 */
  0x0000,   /* U+00F5 */
  0x0000,   /* U+00F6 */
  0x0000,   /* U+00F7 */
  0x0000,   /* U+00F8 */
  0x0000,   /* U+00F9 */
  0x0000,   /* U+00FA */
  0x0000,   /* U+00FB */
  0x0000,   /* U+00FC */
  0x0000,   /* U+00FD */
  0x0000,   /* U+00FE */
  0x0000,   /* U+00FF */
};

uint16 uca900_p001[]= {
  /* Number of CEs for each character. */
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 1, 2, 2, 2, 2, 2, 2, 1, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 2, 2, 2, 2,
  2, 2, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
  2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1,
  1, 1, 1, 1, 3, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 1, 3, 3,
  3, 3, 4, 4, 1, 1, 2, 2, 2, 2, 2, 2, 3, 3, 2, 2,
  2, 2, 2, 2, 2, 2, 1, 1, 2, 2, 3, 3, 4, 4, 3, 3,

  /* Primary weight 1 for each character. */
  0x1C47,   /* U+0100 */
  0x1C47,   /* U+0101 */
  0x1C47,   /* U+0102 */
  0x1C47,   /* U+0103 */
  0x1C47,   /* U+0104 */
  0x1C47,   /* U+0105 */
  0x1C7A,   /* U+0106 */
  0x1C7A,   /* U+0107 */
  0x1C7A,   /* U+0108 */
  0x1C7A,   /* U+0109 */
  0x1C7A,   /* U+010A */
  0x1C7A,   /* U+010B */
  0x1C7A,   /* U+010C */
  0x1C7A,   /* U+010D */
  0x1C8F,   /* U+010E */
  0x1C8F,   /* U+010F */
  0x1C8F,   /* U+0110 */
  0x1C8F,   /* U+0111 */
  0x1CAA,   /* U+0112 */
  0x1CAA,   /* U+0113 */
  0x1CAA,   /* U+0114 */
  0x1CAA,   /* U+0115 */
  0x1CAA,   /* U+0116 */
  0x1CAA,   /* U+0117 */
  0x1CAA,   /* U+0118 */
  0x1CAA,   /* U+0119 */
  0x1CAA,   /* U+011A */
  0x1CAA,   /* U+011B */
  0x1CF4,   /* U+011C */
  0x1CF4,   /* U+011D */
  0x1CF4,   /* U+011E */
  0x1CF4,   /* U+011F */
  0x1CF4,   /* U+0120 */
  0x1CF4,   /* U+0121 */
  0x1CF4,   /* U+0122 */
  0x1CF4,   /* U+0123 */
  0x1D18,   /* U+0124 */
  0x1D18,   /* U+0125 */
  0x1D18,   /* U+0126 */
  0x1D18,   /* U+0127 */
  0x1D32,   /* U+0128 */
  0x1D32,   /* U+0129 */
  0x1D32,   /* U+012A */
  0x1D32,   /* U+012B */
  0x1D32,   /* U+012C */
  0x1D32,   /* U+012D */
  0x1D32,   /* U+012E */
  0x1D32,   /* U+012F */
  0x1D32,   /* U+0130 */
  0x1D36,   /* U+0131 */
  0x1D32,   /* U+0132 */
  0x1D32,   /* U+0133 */
  0x1D4C,   /* U+0134 */
  0x1D4C,   /* U+0135 */
  0x1D65,   /* U+0136 */
  0x1D65,   /* U+0137 */
  0x1E2F,   /* U+0138 */
  0x1D77,   /* U+0139 */
  0x1D77,   /* U+013A */
  0x1D77,   /* U+013B */
  0x1D77,   /* U+013C */
  0x1D77,   /* U+013D */
  0x1D77,   /* U+013E */
  0x1D77,   /* U+013F */
  0x1D77,   /* U+0140 */
  0x1D77,   /* U+0141 */
  0x1D77,   /* U+0142 */
  0x1DB9,   /* U+0143 */
  0x1DB9,   /* U+0144 */
  0x1DB9,   /* U+0145 */
  0x1DB9,   /* U+0146 */
  0x1DB9,   /* U+0147 */
  0x1DB9,   /* U+0148 */
  0x1F7E,   /* U+0149 */
  0x1DD8,   /* U+014A */
  0x1DD8,   /* U+014B */
  0x1DDD,   /* U+014C */
  0x1DDD,   /* U+014D */
  0x1DDD,   /* U+014E */
  0x1DDD,   /* U+014F */
  0x1DDD,   /* U+0150 */
  0x1DDD,   /* U+0151 */
  0x1DDD,   /* U+0152 */
  0x1DDD,   /* U+0153 */
  0x1E33,   /* U+0154 */
  0x1E33,   /* U+0155 */
  0x1E33,   /* U+0156 */
  0x1E33,   /* U+0157 */
  0x1E33,   /* U+0158 */
  0x1E33,   /* U+0159 */
  0x1E71,   /* U+015A */
  0x1E71,   /* U+015B */
  0x1E71,   /* U+015C */
  0x1E71,   /* U+015D */
  0x1E71,   /* U+015E */
  0x1E71,   /* U+015F */
  0x1E71,   /* U+0160 */
  0x1E71,   /* U+0161 */
  0x1E95,   /* U+0162 */
  0x1E95,   /* U+0163 */
  0x1E95,   /* U+0164 */
  0x1E95,   /* U+0165 */
  0x1E9A,   /* U+0166 */
  0x1E9A,   /* U+0167 */
  0x1EB5,   /* U+0168 */
  0x1EB5,   /* U+0169 */
  0x1EB5,   /* U+016A */
  0x1EB5,   /* U+016B */
  0x1EB5,   /* U+016C */
  0x1EB5,   /* U+016D */
  0x1EB5,   /* U+016E */
  0x1EB5,   /* U+016F */
  0x1EB5,   /* U+0170 */
  0x1EB5,   /* U+0171 */
  0x1EB5,   /* U+0172 */
  0x1EB5,   /* U+0173 */
  0x1EF5,   /* U+0174 */
  0x1EF5,   /* U+0175 */
  0x1F0B,   /* U+0176 */
  0x1F0B,   /* U+0177 */
  0x1F0B,   /* U+0178 */
  0x1F21,   /* U+0179 */
  0x1F21,   /* U+017A */
  0x1F21,   /* U+017B */
  0x1F21,   /* U+017C */
  0x1F21,   /* U+017D */
  0x1F21,   /* U+017E */
  0x1E71,   /* U+017F */
  0x1C68,   /* U+0180 */
  0x1C71,   /* U+0181 */
  0x1C75,   /* U+0182 */
  0x1C75,   /* U+0183 */
  0x1F71,   /* U+0184 */
  0x1F71,   /* U+0185 */
  0x1DF0,   /* U+0186 */
  0x1C85,   /* U+0187 */
  0x1C85,   /* U+0188 */
  0x1C97,   /* U+0189 */
  0x1C9B,   /* U+018A */
  0x1CA0,   /* U+018B */
  0x1CA0,   /* U+018C */
  0x1F21,   /* U+018D */
  0x1CB8,   /* U+018E */
  0x1CBD,   /* U+018F */
  0x1CC2,   /* U+0190 */
  0x1CEE,   /* U+0191 */
  0x1CEE,   /* U+0192 */
  0x1D06,   /* U+0193 */
  0x1D10,   /* U+0194 */
  0x1D20,   /* U+0195 */
  0x1D47,   /* U+0196 */
  0x1D41,   /* U+0197 */
  0x1D6B,   /* U+0198 */
  0x1D6B,   /* U+0199 */
  0x1D82,   /* U+019A */
  0x1DA2,   /* U+019B */
  0x1ED4,   /* U+019C */
  0x1DC4,   /* U+019D */
  0x1DC8,   /* U+019E */
  0x1DFD,   /* U+019F */
  0x1DDD,   /* U+01A0 */
  0x1DDD,   /* U+01A1 */
  0x1D14,   /* U+01A2 */
  0x1D14,   /* U+01A3 */
  0x1E15,   /* U+01A4 */
  0x1E15,   /* U+01A5 */
  0x1E38,   /* U+01A6 */
  0x1F69,   /* U+01A7 */
  0x1F69,   /* U+01A8 */
  0x1E82,   /* U+01A9 */
  0x1E88,   /* U+01AA */
  0x1EA0,   /* U+01AB */
  0x1EA4,   /* U+01AC */
  0x1EA4,   /* U+01AD */
  0x1EA8,   /* U+01AE */
  0x1EB5,   /* U+01AF */
  0x1EB5,   /* U+01B0 */
  0x1EDE,   /* U+01B1 */
  0x1EEA,   /* U+01B2 */
  0x1F17,   /* U+01B3 */
  0x1F17,   /* U+01B4 */
  0x1F26,   /* U+01B5 */
  0x1F26,   /* U+01B6 */
  0x1F3E,   /* U+01B7 */
  0x1F43,   /* U+01B8 */
  0x1F43,   /* U+01B9 */
  0x1F48,   /* U+01BA */
  0x1F62,   /* U+01BB */
  0x1F6D,   /* U+01BC */
  0x1F6D,   /* U+01BD */
  0x1E95,   /* U+01BE */
  0x1F56,   /* U+01BF */
  0x1F99,   /* U+01C0 */
  0x1F9D,   /* U+01C1 */
  0x1FA1,   /* U+01C2 */
  0x1FA5,   /* U+01C3 */
  0x1C8F,   /* U+01C4 */
  0x1C8F,   /* U+01C5 */
  0x1C8F,   /* U+01C6 */
  0x1D77,   /* U+01C7 */
  0x1D77,   /* U+01C8 */
  0x1D77,   /* U+01C9 */
  0x1DB9,   /* U+01CA */
  0x1DB9,   /* U+01CB */
  0x1DB9,   /* U+01CC */
  0x1C47,   /* U+01CD */
  0x1C47,   /* U+01CE */
  0x1D32,   /* U+01CF */
  0x1D32,   /* U+01D0 */
  0x1DDD,   /* U+01D1 */
  0x1DDD,   /* U+01D2 */
  0x1EB5,   /* U+01D3 */
  0x1EB5,   /* U+01D4 */
  0x1EB5,   /* U+01D5 */
  0x1EB5,   /* U+01D6 */
  0x1EB5,   /* U+01D7 */
  0x1EB5,   /* U+01D8 */
  0x1EB5,   /* U+01D9 */
  0x1EB5,   /* U+01DA */
  0x1EB5,   /* U+01DB */
  0x1EB5,   /* U+01DC */
  0x1CB8,   /* U+01DD */
  0x1C47,   /* U+01DE */
  0x1C47,   /* U+01DF */
  0x1C47,   /* U+01E0 */
  0x1C47,   /* U+01E1 */
  0x1C47,   /* U+01E2 */
  0x1C47,   /* U+01E3 */
  0x1D01,   /* U+01E4 */
  0x1D01,   /* U+01E5 */
  0x1CF4,   /* U+01E6 */
  0x1CF4,   /* U+01E7 */
  0x1D65,   /* U+01E8 */
  0x1D65,   /* U+01E9 */
  0x1DDD,   /* U+01EA */
  0x1DDD,   /* U+01EB */
  0x1DDD,   /* U+01EC */
  0x1DDD,   /* U+01ED */
  0x1F3E,   /* U+01EE */
  0x1F3E,   /* U+01EF */
  0x1D4C,   /* U+01F0 */
  0x1C8F,   /* U+01F1 */
  0x1C8F,   /* U+01F2 */
  0x1C8F,   /* U+01F3 */
  0x1CF4,   /* U+01F4 */
  0x1CF4,   /* U+01F5 */
  0x1D20,   /* U+01F6 */
  0x1F56,   /* U+01F7 */
  0x1DB9,   /* U+01F8 */
  0x1DB9,   /* U+01F9 */
  0x1C47,   /* U+01FA */
  0x1C47,   /* U+01FB */
  0x1C47,   /* U+01FC */
  0x1C47,   /* U+01FD */
  0x1DDD,   /* U+01FE */
  0x1DDD,   /* U+01FF */

  /* Secondary weight 1 for each character. */
  0x0020,   /* U+0100 */
  0x0020,   /* U+0101 */
  0x0020,   /* U+0102 */
  0x0020,   /* U+0103 */
  0x0020,   /* U+0104 */
  0x0020,   /* U+0105 */
  0x0020,   /* U+0106 */
  0x0020,   /* U+0107 */
  0x0020,   /* U+0108 */
  0x0020,   /* U+0109 */
  0x0020,   /* U+010A */
  0x0020,   /* U+010B */
  0x0020,   /* U+010C */
  0x0020,   /* U+010D */
  0x0020,   /* U+010E */
  0x0020,   /* U+010F */
  0x0020,   /* U+0110 */
  0x0020,   /* U+0111 */
  0x0020,   /* U+0112 */
  0x0020,   /* U+0113 */
  0x0020,   /* U+0114 */
  0x0020,   /* U+0115 */
  0x0020,   /* U+0116 */
  0x0020,   /* U+0117 */
  0x0020,   /* U+0118 */
  0x0020,   /* U+0119 */
  0x0020,   /* U+011A */
  0x0020,   /* U+011B */
  0x0020,   /* U+011C */
  0x0020,   /* U+011D */
  0x0020,   /* U+011E */
  0x0020,   /* U+011F */
  0x0020,   /* U+0120 */
  0x0020,   /* U+0121 */
  0x0020,   /* U+0122 */
  0x0020,   /* U+0123 */
  0x0020,   /* U+0124 */
  0x0020,   /* U+0125 */
  0x0020,   /* U+0126 */
  0x0020,   /* U+0127 */
  0x0020,   /* U+0128 */
  0x0020,   /* U+0129 */
  0x0020,   /* U+012A */
  0x0020,   /* U+012B */
  0x0020,   /* U+012C */
  0x0020,   /* U+012D */
  0x0020,   /* U+012E */
  0x0020,   /* U+012F */
  0x0020,   /* U+0130 */
  0x0020,   /* U+0131 */
  0x0020,   /* U+0132 */
  0x0020,   /* U+0133 */
  0x0020,   /* U+0134 */
  0x0020,   /* U+0135 */
  0x0020,   /* U+0136 */
  0x0020,   /* U+0137 */
  0x0020,   /* U+0138 */
  0x0020,   /* U+0139 */
  0x0020,   /* U+013A */
  0x0020,   /* U+013B */
  0x0020,   /* U+013C */
  0x0020,   /* U+013D */
  0x0020,   /* U+013E */
  0x0020,   /* U+013F */
  0x0020,   /* U+0140 */
  0x0020,   /* U+0141 */
  0x0020,   /* U+0142 */
  0x0020,   /* U+0143 */
  0x0020,   /* U+0144 */
  0x0020,   /* U+0145 */
  0x0020,   /* U+0146 */
  0x0020,   /* U+0147 */
  0x0020,   /* U+0148 */
  0x0020,   /* U+0149 */
  0x0020,   /* U+014A */
  0x0020,   /* U+014B */
  0x0020,   /* U+014C */
  0x0020,   /* U+014D */
  0x0020,   /* U+014E */
  0x0020,   /* U+014F */
  0x0020,   /* U+0150 */
  0x0020,   /* U+0151 */
  0x0020,   /* U+0152 */
  0x0020,   /* U+0153 */
  0x0020,   /* U+0154 */
  0x0020,   /* U+0155 */
  0x0020,   /* U+0156 */
  0x0020,   /* U+0157 */
  0x0020,   /* U+0158 */
  0x0020,   /* U+0159 */
  0x0020,   /* U+015A */
  0x0020,   /* U+015B */
  0x0020,   /* U+015C */
  0x0020,   /* U+015D */
  0x0020,   /* U+015E */
  0x0020,   /* U+015F */
  0x0020,   /* U+0160 */
  0x0020,   /* U+0161 */
  0x0020,   /* U+0162 */
  0x0020,   /* U+0163 */
  0x0020,   /* U+0164 */
  0x0020,   /* U+0165 */
  0x0020,   /* U+0166 */
  0x0020,   /* U+0167 */
  0x0020,   /* U+0168 */
  0x0020,   /* U+0169 */
  0x0020,   /* U+016A */
  0x0020,   /* U+016B */
  0x0020,   /* U+016C */
  0x0020,   /* U+016D */
  0x0020,   /* U+016E */
  0x0020,   /* U+016F */
  0x0020,   /* U+0170 */
  0x0020,   /* U+0171 */
  0x0020,   /* U+0172 */
  0x0020,   /* U+0173 */
  0x0020,   /* U+0174 */
  0x0020,   /* U+0175 */
  0x0020,   /* U+0176 */
  0x0020,   /* U+0177 */
  0x0020,   /* U+0178 */
  0x0020,   /* U+0179 */
  0x0020,   /* U+017A */
  0x0020,   /* U+017B */
  0x0020,   /* U+017C */
  0x0020,   /* U+017D */
  0x0020,   /* U+017E */
  0x0020,   /* U+017F */
  0x0020,   /* U+0180 */
  0x0020,   /* U+0181 */
  0x0020,   /* U+0182 */
  0x0020,   /* U+0183 */
  0x0020,   /* U+0184 */
  0x0020,   /* U+0185 */
  0x0020,   /* U+0186 */
  0x0020,   /* U+0187 */
  0x0020,   /* U+0188 */
  0x0020,   /* U+0189 */
  0x0020,   /* U+018A */
  0x0020,   /* U+018B */
  0x0020,   /* U+018C */
  0x0020,   /* U+018D */
  0x0020,   /* U+018E */
  0x0020,   /* U+018F */
  0x0020,   /* U+0190 */
  0x0020,   /* U+0191 */
  0x0020,   /* U+0192 */
  0x0020,   /* U+0193 */
  0x0020,   /* U+0194 */
  0x0020,   /* U+0195 */
  0x0020,   /* U+0196 */
  0x0020,   /* U+0197 */
  0x0020,   /* U+0198 */
  0x0020,   /* U+0199 */
  0x0020,   /* U+019A */
  0x0020,   /* U+019B */
  0x0020,   /* U+019C */
  0x0020,   /* U+019D */
  0x0020,   /* U+019E */
  0x0020,   /* U+019F */
  0x0020,   /* U+01A0 */
  0x0020,   /* U+01A1 */
  0x0020,   /* U+01A2 */
  0x0020,   /* U+01A3 */
  0x0020,   /* U+01A4 */
  0x0020,   /* U+01A5 */
  0x0020,   /* U+01A6 */
  0x0020,   /* U+01A7 */
  0x0020,   /* U+01A8 */
  0x0020,   /* U+01A9 */
  0x0020,   /* U+01AA */
  0x0020,   /* U+01AB */
  0x0020,   /* U+01AC */
  0x0020,   /* U+01AD */
  0x0020,   /* U+01AE */
  0x0020,   /* U+01AF */
  0x0020,   /* U+01B0 */
  0x0020,   /* U+01B1 */
  0x0020,   /* U+01B2 */
  0x0020,   /* U+01B3 */
  0x0020,   /* U+01B4 */
  0x0020,   /* U+01B5 */
  0x0020,   /* U+01B6 */
  0x0020,   /* U+01B7 */
  0x0020,   /* U+01B8 */
  0x0020,   /* U+01B9 */
  0x0020,   /* U+01BA */
  0x0020,   /* U+01BB */
  0x0020,   /* U+01BC */
  0x0020,   /* U+01BD */
  0x0020,   /* U+01BE */
  0x0020,   /* U+01BF */
  0x0020,   /* U+01C0 */
  0x0020,   /* U+01C1 */
  0x0020,   /* U+01C2 */
  0x0020,   /* U+01C3 */
  0x0020,   /* U+01C4 */
  0x0020,   /* U+01C5 */
  0x0020,   /* U+01C6 */
  0x0020,   /* U+01C7 */
  0x0020,   /* U+01C8 */
  0x0020,   /* U+01C9 */
  0x0020,   /* U+01CA */
  0x0020,   /* U+01CB */
  0x0020,   /* U+01CC */
  0x0020,   /* U+01CD */
  0x0020,   /* U+01CE */
  0x0020,   /* U+01CF */
  0x0020,   /* U+01D0 */
  0x0020,   /* U+01D1 */
  0x0020,   /* U+01D2 */
  0x0020,   /* U+01D3 */
  0x0020,   /* U+01D4 */
  0x0020,   /* U+01D5 */
  0x0020,   /* U+01D6 */
  0x0020,   /* U+01D7 */
  0x0020,   /* U+01D8 */
  0x0020,   /* U+01D9 */
  0x0020,   /* U+01DA */
  0x0020,   /* U+01DB */
  0x0020,   /* U+01DC */
  0x0020,   /* U+01DD */
  0x0020,   /* U+01DE */
  0x0020,   /* U+01DF */
  0x0020,   /* U+01E0 */
  0x0020,   /* U+01E1 */
  0x0020,   /* U+01E2 */
  0x0020,   /* U+01E3 */
  0x0020,   /* U+01E4 */
  0x0020,   /* U+01E5 */
  0x0020,   /* U+01E6 */
  0x0020,   /* U+01E7 */
  0x0020,   /* U+01E8 */
  0x0020,   /* U+01E9 */
  0x0020,   /* U+01EA */
  0x0020,   /* U+01EB */
  0x0020,   /* U+01EC */
  0x0020,   /* U+01ED */
  0x0020,   /* U+01EE */
  0x0020,   /* U+01EF */
  0x0020,   /* U+01F0 */
  0x0020,   /* U+01F1 */
  0x0020,   /* U+01F2 */
  0x0020,   /* U+01F3 */
  0x0020,   /* U+01F4 */
  0x0020,   /* U+01F5 */
  0x0020,   /* U+01F6 */
  0x0020,   /* U+01F7 */
  0x0020,   /* U+01F8 */
  0x0020,   /* U+01F9 */
  0x0020,   /* U+01FA */
  0x0020,   /* U+01FB */
  0x0020,   /* U+01FC */
  0x0020,   /* U+01FD */
  0x0020,   /* U+01FE */
  0x0020,   /* U+01FF */

  /* Tertiary weight 1 for each character. */
  0x0008,   /* U+0100 */
  0x0002,   /* U+0101 */
  0x0008,   /* U+0102 */
  0x0002,   /* U+0103 */
  0x0008,   /* U+0104 */
  0x0002,   /* U+0105 */
  0x0008,   /* U+0106 */
  0x0002,   /* U+0107 */
  0x0008,   /* U+0108 */
  0x0002,   /* U+0109 */
  0x0008,   /* U+010A */
  0x0002,   /* U+010B */
  0x0008,   /* U+010C */
  0x0002,   /* U+010D */
  0x0008,   /* U+010E */
  0x0002,   /* U+010F */
  0x0008,   /* U+0110 */
  0x0002,   /* U+0111 */
  0x0008,   /* U+0112 */
  0x0002,   /* U+0113 */
  0x0008,   /* U+0114 */
  0x0002,   /* U+0115 */
  0x0008,   /* U+0116 */
  0x0002,   /* U+0117 */
  0x0008,   /* U+0118 */
  0x0002,   /* U+0119 */
  0x0008,   /* U+011A */
  0x0002,   /* U+011B */
  0x0008,   /* U+011C */
  0x0002,   /* U+011D */
  0x0008,   /* U+011E */
  0x0002,   /* U+011F */
  0x0008,   /* U+0120 */
  0x0002,   /* U+0121 */
  0x0008,   /* U+0122 */
  0x0002,   /* U+0123 */
  0x0008,   /* U+0124 */
  0x0002,   /* U+0125 */
  0x0008,   /* U+0126 */
  0x0002,   /* U+0127 */
  0x0008,   /* U+0128 */
  0x0002,   /* U+0129 */
  0x0008,   /* U+012A */
  0x0002,   /* U+012B */
  0x0008,   /* U+012C */
  0x0002,   /* U+012D */
  0x0008,   /* U+012E */
  0x0002,   /* U+012F */
  0x0008,   /* U+0130 */
  0x0002,   /* U+0131 */
  0x000A,   /* U+0132 */
  0x0004,   /* U+0133 */
  0x0008,   /* U+0134 */
  0x0002,   /* U+0135 */
  0x0008,   /* U+0136 */
  0x0002,   /* U+0137 */
  0x0002,   /* U+0138 */
  0x0008,   /* U+0139 */
  0x0002,   /* U+013A */
  0x0008,   /* U+013B */
  0x0002,   /* U+013C */
  0x0008,   /* U+013D */
  0x0002,   /* U+013E */
  0x0008,   /* U+013F */
  0x0002,   /* U+0140 */
  0x0008,   /* U+0141 */
  0x0002,   /* U+0142 */
  0x0008,   /* U+0143 */
  0x0002,   /* U+0144 */
  0x0008,   /* U+0145 */
  0x0002,   /* U+0146 */
  0x0008,   /* U+0147 */
  0x0002,   /* U+0148 */
  0x0004,   /* U+0149 */
  0x0008,   /* U+014A */
  0x0002,   /* U+014B */
  0x0008,   /* U+014C */
  0x0002,   /* U+014D */
  0x0008,   /* U+014E */
  0x0002,   /* U+014F */
  0x0008,   /* U+0150 */
  0x0002,   /* U+0151 */
  0x000A,   /* U+0152 */
  0x0004,   /* U+0153 */
  0x0008,   /* U+0154 */
  0x0002,   /* U+0155 */
  0x0008,   /* U+0156 */
  0x0002,   /* U+0157 */
  0x0008,   /* U+0158 */
  0x0002,   /* U+0159 */
  0x0008,   /* U+015A */
  0x0002,   /* U+015B */
  0x0008,   /* U+015C */
  0x0002,   /* U+015D */
  0x0008,   /* U+015E */
  0x0002,   /* U+015F */
  0x0008,   /* U+0160 */
  0x0002,   /* U+0161 */
  0x0008,   /* U+0162 */
  0x0002,   /* U+0163 */
  0x0008,   /* U+0164 */
  0x0002,   /* U+0165 */
  0x0008,   /* U+0166 */
  0x0002,   /* U+0167 */
  0x0008,   /* U+0168 */
  0x0002,   /* U+0169 */
  0x0008,   /* U+016A */
  0x0002,   /* U+016B */
  0x0008,   /* U+016C */
  0x0002,   /* U+016D */
  0x0008,   /* U+016E */
  0x0002,   /* U+016F */
  0x0008,   /* U+0170 */
  0x0002,   /* U+0171 */
  0x0008,   /* U+0172 */
  0x0002,   /* U+0173 */
  0x0008,   /* U+0174 */
  0x0002,   /* U+0175 */
  0x0008,   /* U+0176 */
  0x0002,   /* U+0177 */
  0x0008,   /* U+0178 */
  0x0008,   /* U+0179 */
  0x0002,   /* U+017A */
  0x0008,   /* U+017B */
  0x0002,   /* U+017C */
  0x0008,   /* U+017D */
  0x0002,   /* U+017E */
  0x0004,   /* U+017F */
  0x0002,   /* U+0180 */
  0x0008,   /* U+0181 */
  0x0008,   /* U+0182 */
  0x0002,   /* U+0183 */
  0x0008,   /* U+0184 */
  0x0002,   /* U+0185 */
  0x0008,   /* U+0186 */
  0x0008,   /* U+0187 */
  0x0002,   /* U+0188 */
  0x0008,   /* U+0189 */
  0x0008,   /* U+018A */
  0x0008,   /* U+018B */
  0x0002,   /* U+018C */
  0x0004,   /* U+018D */
  0x0008,   /* U+018E */
  0x0008,   /* U+018F */
  0x0008,   /* U+0190 */
  0x0008,   /* U+0191 */
  0x0002,   /* U+0192 */
  0x0008,   /* U+0193 */
  0x0008,   /* U+0194 */
  0x0002,   /* U+0195 */
  0x0008,   /* U+0196 */
  0x0008,   /* U+0197 */
  0x0008,   /* U+0198 */
  0x0002,   /* U+0199 */
  0x0002,   /* U+019A */
  0x0002,   /* U+019B */
  0x0008,   /* U+019C */
  0x0008,   /* U+019D */
  0x0002,   /* U+019E */
  0x0008,   /* U+019F */
  0x0008,   /* U+01A0 */
  0x0002,   /* U+01A1 */
  0x0008,   /* U+01A2 */
  0x0002,   /* U+01A3 */
  0x0008,   /* U+01A4 */
  0x0002,   /* U+01A5 */
  0x0008,   /* U+01A6 */
  0x0008,   /* U+01A7 */
  0x0002,   /* U+01A8 */
  0x0008,   /* U+01A9 */
  0x0002,   /* U+01AA */
  0x0002,   /* U+01AB */
  0x0008,   /* U+01AC */
  0x0002,   /* U+01AD */
  0x0008,   /* U+01AE */
  0x0008,   /* U+01AF */
  0x0002,   /* U+01B0 */
  0x0008,   /* U+01B1 */
  0x0008,   /* U+01B2 */
  0x0008,   /* U+01B3 */
  0x0002,   /* U+01B4 */
  0x0008,   /* U+01B5 */
  0x0002,   /* U+01B6 */
  0x0008,   /* U+01B7 */
  0x0008,   /* U+01B8 */
  0x0002,   /* U+01B9 */
  0x0002,   /* U+01BA */
  0x0002,   /* U+01BB */
  0x0008,   /* U+01BC */
  0x0002,   /* U+01BD */
  0x0004,   /* U+01BE */
  0x0002,   /* U+01BF */
  0x0002,   /* U+01C0 */
  0x0002,   /* U+01C1 */
  0x0002,   /* U+01C2 */
  0x0002,   /* U+01C3 */
  0x000A,   /* U+01C4 */
  0x000A,   /* U+01C5 */
  0x0004,   /* U+01C6 */
  0x000A,   /* U+01C7 */
  0x000A,   /* U+01C8 */
  0x0004,   /* U+01C9 */
  0x000A,   /* U+01CA */
  0x000A,   /* U+01CB */
  0x0004,   /* U+01CC */
  0x0008,   /* U+01CD */
  0x0002,   /* U+01CE */
  0x0008,   /* U+01CF */
  0x0002,   /* U+01D0 */
  0x0008,   /* U+01D1 */
  0x0002,   /* U+01D2 */
  0x0008,   /* U+01D3 */
  0x0002,   /* U+01D4 */
  0x0008,   /* U+01D5 */
  0x0002,   /* U+01D6 */
  0x0008,   /* U+01D7 */
  0x0002,   /* U+01D8 */
  0x0008,   /* U+01D9 */
  0x0002,   /* U+01DA */
  0x0008,   /* U+01DB */
  0x0002,   /* U+01DC */
  0x0002,   /* U+01DD */
  0x0008,   /* U+01DE */
  0x0002,   /* U+01DF */
  0x0008,   /* U+01E0 */
  0x0002,   /* U+01E1 */
  0x000A,   /* U+01E2 */
  0x0004,   /* U+01E3 */
  0x0008,   /* U+01E4 */
  0x0002,   /* U+01E5 */
  0x0008,   /* U+01E6 */
  0x0002,   /* U+01E7 */
  0x0008,   /* U+01E8 */
  0x0002,   /* U+01E9 */
  0x0008,   /* U+01EA */
  0x0002,   /* U+01EB */
  0x0008,   /* U+01EC */
  0x0002,   /* U+01ED */
  0x0008,   /* U+01EE */
  0x0002,   /* U+01EF */
  0x0002,   /* U+01F0 */
  0x000A,   /* U+01F1 */
  0x000A,   /* U+01F2 */
  0x0004,   /* U+01F3 */
  0x0008,   /* U+01F4 */
  0x0002,   /* U+01F5 */
  0x0008,   /* U+01F6 */
  0x0008,   /* U+01F7 */
  0x0008,   /* U+01F8 */
  0x0002,   /* U+01F9 */
  0x0008,   /* U+01FA */
  0x0002,   /* U+01FB */
  0x000A,   /* U+01FC */
  0x0004,   /* U+01FD */
  0x0008,   /* U+01FE */
  0x0002,   /* U+01FF */

  /* Primary weight 2 for each character. */
  0x0000,   /* U+0100 */
  0x0000,   /* U+0101 */
  0x0000,   /* U+0102 */
  0x0000,   /* U+0103 */
  0x0000,   /* U+0104 */
  0x0000,   /* U+0105 */
  0x0000,   /* U+0106 */
  0x0000,   /* U+0107 */
  0x0000,   /* U+0108 */
  0x0000,   /* U+0109 */
  0x0000,   /* U+010A */
  0x0000,   /* U+010B */
  0x0000,   /* U+010C */
  0x0000,   /* U+010D */
  0x0000,   /* U+010E */
  0x0000,   /* U+010F */
  0x0000,   /* U+0110 */
  0x0000,   /* U+0111 */
  0x0000,   /* U+0112 */
  0x0000,   /* U+0113 */
  0x0000,   /* U+0114 */
  0x0000,   /* U+0115 */
  0x0000,   /* U+0116 */
  0x0000,   /* U+0117 */
  0x0000,   /* U+0118 */
  0x0000,   /* U+0119 */
  0x0000,   /* U+011A */
  0x0000,   /* U+011B */
  0x0000,   /* U+011C */
  0x0000,   /* U+011D */
  0x0000,   /* U+011E */
  0x0000,   /* U+011F */
  0x0000,   /* U+0120 */
  0x0000,   /* U+0121 */
  0x0000,   /* U+0122 */
  0x0000,   /* U+0123 */
  0x0000,   /* U+0124 */
  0x0000,   /* U+0125 */
  0x0000,   /* U+0126 */
  0x0000,   /* U+0127 */
  0x0000,   /* U+0128 */
  0x0000,   /* U+0129 */
  0x0000,   /* U+012A */
  0x0000,   /* U+012B */
  0x0000,   /* U+012C */
  0x0000,   /* U+012D */
  0x0000,   /* U+012E */
  0x0000,   /* U+012F */
  0x0000,   /* U+0130 */
  0x0000,   /* U+0131 */
  0x1D4C,   /* U+0132 */
  0x1D4C,   /* U+0133 */
  0x0000,   /* U+0134 */
  0x0000,   /* U+0135 */
  0x0000,   /* U+0136 */
  0x0000,   /* U+0137 */
  0x0000,   /* U+0138 */
  0x0000,   /* U+0139 */
  0x0000,   /* U+013A */
  0x0000,   /* U+013B */
  0x0000,   /* U+013C */
  0x0000,   /* U+013D */
  0x0000,   /* U+013E */
  0x0000,   /* U+013F */
  0x0000,   /* U+0140 */
  0x0000,   /* U+0141 */
  0x0000,   /* U+0142 */
  0x0000,   /* U+0143 */
  0x0000,   /* U+0144 */
  0x0000,   /* U+0145 */
  0x0000,   /* U+0146 */
  0x0000,   /* U+0147 */
  0x0000,   /* U+0148 */
  0x1DB9,   /* U+0149 */
  0x0000,   /* U+014A */
  0x0000,   /* U+014B */
  0x0000,   /* U+014C */
  0x0000,   /* U+014D */
  0x0000,   /* U+014E */
  0x0000,   /* U+014F */
  0x0000,   /* U+0150 */
  0x0000,   /* U+0151 */
  0x0000,   /* U+0152 */
  0x0000,   /* U+0153 */
  0x0000,   /* U+0154 */
  0x0000,   /* U+0155 */
  0x0000,   /* U+0156 */
  0x0000,   /* U+0157 */
  0x0000,   /* U+0158 */
  0x0000,   /* U+0159 */
  0x0000,   /* U+015A */
  0x0000,   /* U+015B */
  0x0000,   /* U+015C */
  0x0000,   /* U+015D */
  0x0000,   /* U+015E */
  0x0000,   /* U+015F */
  0x0000,   /* U+0160 */
  0x0000,   /* U+0161 */
  0x0000,   /* U+0162 */
  0x0000,   /* U+0163 */
  0x0000,   /* U+0164 */
  0x0000,   /* U+0165 */
  0x0000,   /* U+0166 */
  0x0000,   /* U+0167 */
  0x0000,   /* U+0168 */
  0x0000,   /* U+0169 */
  0x0000,   /* U+016A */
  0x0000,   /* U+016B */
  0x0000,   /* U+016C */
  0x0000,   /* U+016D */
  0x0000,   /* U+016E */
  0x0000,   /* U+016F */
  0x0000,   /* U+0170 */
  0x0000,   /* U+0171 */
  0x0000,   /* U+0172 */
  0x0000,   /* U+0173 */
  0x0000,   /* U+0174 */
  0x0000,   /* U+0175 */
  0x0000,   /* U+0176 */
  0x0000,   /* U+0177 */
  0x0000,   /* U+0178 */
  0x0000,   /* U+0179 */
  0x0000,   /* U+017A */
  0x0000,   /* U+017B */
  0x0000,   /* U+017C */
  0x0000,   /* U+017D */
  0x0000,   /* U+017E */
  0x0000,   /* U+017F */
  0x0000,   /* U+0180 */
  0x0000,   /* U+0181 */
  0x0000,   /* U+0182 */
  0x0000,   /* U+0183 */
  0x0000,   /* U+0184 */
  0x0000,   /* U+0185 */
  0x0000,   /* U+0186 */
  0x0000,   /* U+0187 */
  0x0000,   /* U+0188 */
  0x0000,   /* U+0189 */
  0x0000,   /* U+018A */
  0x0000,   /* U+018B */
  0x0000,   /* U+018C */
  0x1EF5,   /* U+018D */
  0x0000,   /* U+018E */
  0x0000,   /* U+018F */
  0x0000,   /* U+0190 */
  0x0000,   /* U+0191 */
  0x0000,   /* U+0192 */
  0x0000,   /* U+0193 */
  0x0000,   /* U+0194 */
  0x0000,   /* U+0195 */
  0x0000,   /* U+0196 */
  0x0000,   /* U+0197 */
  0x0000,   /* U+0198 */
  0x0000,   /* U+0199 */
  0x0000,   /* U+019A */
  0x0000,   /* U+019B */
  0x0000,   /* U+019C */
  0x0000,   /* U+019D */
  0x0000,   /* U+019E */
  0x0000,   /* U+019F */
  0x0000,   /* U+01A0 */
  0x0000,   /* U+01A1 */
  0x0000,   /* U+01A2 */
  0x0000,   /* U+01A3 */
  0x0000,   /* U+01A4 */
  0x0000,   /* U+01A5 */
  0x0000,   /* U+01A6 */
  0x0000,   /* U+01A7 */
  0x0000,   /* U+01A8 */
  0x0000,   /* U+01A9 */
  0x0000,   /* U+01AA */
  0x0000,   /* U+01AB */
  0x0000,   /* U+01AC */
  0x0000,   /* U+01AD */
  0x0000,   /* U+01AE */
  0x0000,   /* U+01AF */
  0x0000,   /* U+01B0 */
  0x0000,   /* U+01B1 */
  0x0000,   /* U+01B2 */
  0x0000,   /* U+01B3 */
  0x0000,   /* U+01B4 */
  0x0000,   /* U+01B5 */
  0x0000,   /* U+01B6 */
  0x0000,   /* U+01B7 */
  0x0000,   /* U+01B8 */
  0x0000,   /* U+01B9 */
  0x0000,   /* U+01BA */
  0x0000,   /* U+01BB */
  0x0000,   /* U+01BC */
  0x0000,   /* U+01BD */
  0x1E71,   /* U+01BE */
  0x0000,   /* U+01BF */
  0x0000,   /* U+01C0 */
  0x0000,   /* U+01C1 */
  0x0000,   /* U+01C2 */
  0x0000,   /* U+01C3 */
  0x1F21,   /* U+01C4 */
  0x1F21,   /* U+01C5 */
  0x1F21,   /* U+01C6 */
  0x1D4C,   /* U+01C7 */
  0x1D4C,   /* U+01C8 */
  0x1D4C,   /* U+01C9 */
  0x1D4C,   /* U+01CA */
  0x1D4C,   /* U+01CB */
  0x1D4C,   /* U+01CC */
  0x0000,   /* U+01CD */
  0x0000,   /* U+01CE */
  0x0000,   /* U+01CF */
  0x0000,   /* U+01D0 */
  0x0000,   /* U+01D1 */
  0x0000,   /* U+01D2 */
  0x0000,   /* U+01D3 */
  0x0000,   /* U+01D4 */
  0x0000,   /* U+01D5 */
  0x0000,   /* U+01D6 */
  0x0000,   /* U+01D7 */
  0x0000,   /* U+01D8 */
  0x0000,   /* U+01D9 */
  0x0000,   /* U+01DA */
  0x0000,   /* U+01DB */
  0x0000,   /* U+01DC */
  0x0000,   /* U+01DD */
  0x0000,   /* U+01DE */
  0x0000,   /* U+01DF */
  0x0000,   /* U+01E0 */
  0x0000,   /* U+01E1 */
  0x0000,   /* U+01E2 */
  0x0000,   /* U+01E3 */
  0x0000,   /* U+01E4 */
  0x0000,   /* U+01E5 */
  0x0000,   /* U+01E6 */
  0x0000,   /* U+01E7 */
  0x0000,   /* U+01E8 */
  0x0000,   /* U+01E9 */
  0x0000,   /* U+01EA */
  0x0000,   /* U+01EB */
  0x0000,   /* U+01EC */
  0x0000,   /* U+01ED */
  0x0000,   /* U+01EE */
  0x0000,   /* U+01EF */
  0x0000,   /* U+01F0 */
  0x1F21,   /* U+01F1 */
  0x1F21,   /* U+01F2 */
  0x1F21,   /* U+01F3 */
  0x0000,   /* U+01F4 */
  0x0000,   /* U+01F5 */
  0x0000,   /* U+01F6 */
  0x0000,   /* U+01F7 */
  0x0000,   /* U+01F8 */
  0x0000,   /* U+01F9 */
  0x0000,   /* U+01FA */
  0x0000,   /* U+01FB */
  0x0000,   /* U+01FC */
  0x0000,   /* U+01FD */
  0x0000,   /* U+01FE */
  0x0000,   /* U+01FF */

  /* Secondary weight 2 for each character. */
  0x0032,   /* U+0100 */
  0x0032,   /* U+0101 */
  0x0026,   /* U+0102 */
  0x0026,   /* U+0103 */
  0x0031,   /* U+0104 */
  0x0031,   /* U+0105 */
  0x0024,   /* U+0106 */
  0x0024,   /* U+0107 */
  0x0027,   /* U+0108 */
  0x0027,   /* U+0109 */
  0x002E,   /* U+010A */
  0x002E,   /* U+010B */
  0x0028,   /* U+010C */
  0x0028,   /* U+010D */
  0x0028,   /* U+010E */
  0x0028,   /* U+010F */
  0x0039,   /* U+0110 */
  0x0039,   /* U+0111 */
  0x0032,   /* U+0112 */
  0x0032,   /* U+0113 */
  0x0026,   /* U+0114 */
  0x0026,   /* U+0115 */
  0x002E,   /* U+0116 */
  0x002E,   /* U+0117 */
  0x0031,   /* U+0118 */
  0x0031,   /* U+0119 */
  0x0028,   /* U+011A */
  0x0028,   /* U+011B */
  0x0027,   /* U+011C */
  0x0027,   /* U+011D */
  0x0026,   /* U+011E */
  0x0026,   /* U+011F */
  0x002E,   /* U+0120 */
  0x002E,   /* U+0121 */
  0x0030,   /* U+0122 */
  0x0030,   /* U+0123 */
  0x0027,   /* U+0124 */
  0x0027,   /* U+0125 */
  0x0039,   /* U+0126 */
  0x0039,   /* U+0127 */
  0x002D,   /* U+0128 */
  0x002D,   /* U+0129 */
  0x0032,   /* U+012A */
  0x0032,   /* U+012B */
  0x0026,   /* U+012C */
  0x0026,   /* U+012D */
  0x0031,   /* U+012E */
  0x0031,   /* U+012F */
  0x002E,   /* U+0130 */
  0x0000,   /* U+0131 */
  0x0020,   /* U+0132 */
  0x0020,   /* U+0133 */
  0x0027,   /* U+0134 */
  0x0027,   /* U+0135 */
  0x0030,   /* U+0136 */
  0x0030,   /* U+0137 */
  0x0000,   /* U+0138 */
  0x0024,   /* U+0139 */
  0x0024,   /* U+013A */
  0x0030,   /* U+013B */
  0x0030,   /* U+013C */
  0x0028,   /* U+013D */
  0x0028,   /* U+013E */
  0x0110,   /* U+013F */
  0x0110,   /* U+0140 */
  0x0039,   /* U+0141 */
  0x0039,   /* U+0142 */
  0x0024,   /* U+0143 */
  0x0024,   /* U+0144 */
  0x0030,   /* U+0145 */
  0x0030,   /* U+0146 */
  0x0028,   /* U+0147 */
  0x0028,   /* U+0148 */
  0x0020,   /* U+0149 */
  0x0000,   /* U+014A */
  0x0000,   /* U+014B */
  0x0032,   /* U+014C */
  0x0032,   /* U+014D */
  0x0026,   /* U+014E */
  0x0026,   /* U+014F */
  0x002C,   /* U+0150 */
  0x002C,   /* U+0151 */
  0x0110,   /* U+0152 */
  0x0110,   /* U+0153 */
  0x0024,   /* U+0154 */
  0x0024,   /* U+0155 */
  0x0030,   /* U+0156 */
  0x0030,   /* U+0157 */
  0x0028,   /* U+0158 */
  0x0028,   /* U+0159 */
  0x0024,   /* U+015A */
  0x0024,   /* U+015B */
  0x0027,   /* U+015C */
  0x0027,   /* U+015D */
  0x0030,   /* U+015E */
  0x0030,   /* U+015F */
  0x0028,   /* U+0160 */
  0x0028,   /* U+0161 */
  0x0030,   /* U+0162 */
  0x0030,   /* U+0163 */
  0x0028,   /* U+0164 */
  0x0028,   /* U+0165 */
  0x0000,   /* U+0166 */
  0x0000,   /* U+0167 */
  0x002D,   /* U+0168 */
  0x002D,   /* U+0169 */
  0x0032,   /* U+016A */
  0x0032,   /* U+016B */
  0x0026,   /* U+016C */
  0x0026,   /* U+016D */
  0x0029,   /* U+016E */
  0x0029,   /* U+016F */
  0x002C,   /* U+0170 */
  0x002C,   /* U+0171 */
  0x0031,   /* U+0172 */
  0x0031,   /* U+0173 */
  0x0027,   /* U+0174 */
  0x0027,   /* U+0175 */
  0x0027,   /* U+0176 */
  0x0027,   /* U+0177 */
  0x002B,   /* U+0178 */
  0x0024,   /* U+0179 */
  0x0024,   /* U+017A */
  0x002E,   /* U+017B */
  0x002E,   /* U+017C */
  0x0028,   /* U+017D */
  0x0028,   /* U+017E */
  0x0111,   /* U+017F */
  0x0000,   /* U+0180 */
  0x0000,   /* U+0181 */
  0x0000,   /* U+0182 */
  0x0000,   /* U+0183 */
  0x0000,   /* U+0184 */
  0x0000,   /* U+0185 */
  0x0000,   /* U+0186 */
  0x0000,   /* U+0187 */
  0x0000,   /* U+0188 */
  0x0000,   /* U+0189 */
  0x0000,   /* U+018A */
  0x0000,   /* U+018B */
  0x0000,   /* U+018C */
  0x0020,   /* U+018D */
  0x0000,   /* U+018E */
  0x0000,   /* U+018F */
  0x0000,   /* U+0190 */
  0x0000,   /* U+0191 */
  0x0000,   /* U+0192 */
  0x0000,   /* U+0193 */
  0x0000,   /* U+0194 */
  0x0000,   /* U+0195 */
  0x0000,   /* U+0196 */
  0x0000,   /* U+0197 */
  0x0000,   /* U+0198 */
  0x0000,   /* U+0199 */
  0x0000,   /* U+019A */
  0x0000,   /* U+019B */
  0x0000,   /* U+019C */
  0x0000,   /* U+019D */
  0x0000,   /* U+019E */
  0x0000,   /* U+019F */
  0x003F,   /* U+01A0 */
  0x003F,   /* U+01A1 */
  0x0000,   /* U+01A2 */
  0x0000,   /* U+01A3 */
  0x0000,   /* U+01A4 */
  0x0000,   /* U+01A5 */
  0x0000,   /* U+01A6 */
  0x0000,   /* U+01A7 */
  0x0000,   /* U+01A8 */
  0x0000,   /* U+01A9 */
  0x0000,   /* U+01AA */
  0x0000,   /* U+01AB */
  0x0000,   /* U+01AC */
  0x0000,   /* U+01AD */
  0x0000,   /* U+01AE */
  0x003F,   /* U+01AF */
  0x003F,   /* U+01B0 */
  0x0000,   /* U+01B1 */
  0x0000,   /* U+01B2 */
  0x0000,   /* U+01B3 */
  0x0000,   /* U+01B4 */
  0x0000,   /* U+01B5 */
  0x0000,   /* U+01B6 */
  0x0000,   /* U+01B7 */
  0x0000,   /* U+01B8 */
  0x0000,   /* U+01B9 */
  0x0000,   /* U+01BA */
  0x0000,   /* U+01BB */
  0x0000,   /* U+01BC */
  0x0000,   /* U+01BD */
  0x0020,   /* U+01BE */
  0x0000,   /* U+01BF */
  0x0000,   /* U+01C0 */
  0x0000,   /* U+01C1 */
  0x0000,   /* U+01C2 */
  0x0000,   /* U+01C3 */
  0x0020,   /* U+01C4 */
  0x0020,   /* U+01C5 */
  0x0020,   /* U+01C6 */
  0x0020,   /* U+01C7 */
  0x0020,   /* U+01C8 */
  0x0020,   /* U+01C9 */
  0x0020,   /* U+01CA */
  0x0020,   /* U+01CB */
  0x0020,   /* U+01CC */
  0x0028,   /* U+01CD */
  0x0028,   /* U+01CE */
  0x0028,   /* U+01CF */
  0x0028,   /* U+01D0 */
  0x0028,   /* U+01D1 */
  0x0028,   /* U+01D2 */
  0x0028,   /* U+01D3 */
  0x0028,   /* U+01D4 */
  0x002B,   /* U+01D5 */
  0x002B,   /* U+01D6 */
  0x002B,   /* U+01D7 */
  0x002B,   /* U+01D8 */
  0x002B,   /* U+01D9 */
  0x002B,   /* U+01DA */
  0x002B,   /* U+01DB */
  0x002B,   /* U+01DC */
  0x0000,   /* U+01DD */
  0x002B,   /* U+01DE */
  0x002B,   /* U+01DF */
  0x002E,   /* U+01E0 */
  0x002E,   /* U+01E1 */
  0x0110,   /* U+01E2 */
  0x0110,   /* U+01E3 */
  0x0000,   /* U+01E4 */
  0x0000,   /* U+01E5 */
  0x0028,   /* U+01E6 */
  0x0028,   /* U+01E7 */
  0x0028,   /* U+01E8 */
  0x0028,   /* U+01E9 */
  0x0031,   /* U+01EA */
  0x0031,   /* U+01EB */
  0x0031,   /* U+01EC */
  0x0031,   /* U+01ED */
  0x0028,   /* U+01EE */
  0x0028,   /* U+01EF */
  0x0028,   /* U+01F0 */
  0x0020,   /* U+01F1 */
  0x0020,   /* U+01F2 */
  0x0020,   /* U+01F3 */
  0x0024,   /* U+01F4 */
  0x0024,   /* U+01F5 */
  0x0000,   /* U+01F6 */
  0x0000,   /* U+01F7 */
  0x0025,   /* U+01F8 */
  0x0025,   /* U+01F9 */
  0x0029,   /* U+01FA */
  0x0029,   /* U+01FB */
  0x0110,   /* U+01FC */
  0x0110,   /* U+01FD */
  0x002F,   /* U+01FE */
  0x002F,   /* U+01FF */

  /* Tertiary weight 2 for each character. */
  0x0002,   /* U+0100 */
  0x0002,   /* U+0101 */
  0x0002,   /* U+0102 */
  0x0002,   /* U+0103 */
  0x0002,   /* U+0104 */
  0x0002,   /* U+0105 */
  0x0002,   /* U+0106 */
  0x0002,   /* U+0107 */
  0x0002,   /* U+0108 */
  0x0002,   /* U+0109 */
  0x0002,   /* U+010A */
  0x0002,   /* U+010B */
  0x0002,   /* U+010C */
  0x0002,   /* U+010D */
  0x0002,   /* U+010E */
  0x0002,   /* U+010F */
  0x0002,   /* U+0110 */
  0x0002,   /* U+0111 */
  0x0002,   /* U+0112 */
  0x0002,   /* U+0113 */
  0x0002,   /* U+0114 */
  0x0002,   /* U+0115 */
  0x0002,   /* U+0116 */
  0x0002,   /* U+0117 */
  0x0002,   /* U+0118 */
  0x0002,   /* U+0119 */
  0x0002,   /* U+011A */
  0x0002,   /* U+011B */
  0x0002,   /* U+011C */
  0x0002,   /* U+011D */
  0x0002,   /* U+011E */
  0x0002,   /* U+011F */
  0x0002,   /* U+0120 */
  0x0002,   /* U+0121 */
  0x0002,   /* U+0122 */
  0x0002,   /* U+0123 */
  0x0002,   /* U+0124 */
  0x0002,   /* U+0125 */
  0x0002,   /* U+0126 */
  0x0002,   /* U+0127 */
  0x0002,   /* U+0128 */
  0x0002,   /* U+0129 */
  0x0002,   /* U+012A */
  0x0002,   /* U+012B */
  0x0002,   /* U+012C */
  0x0002,   /* U+012D */
  0x0002,   /* U+012E */
  0x0002,   /* U+012F */
  0x0002,   /* U+0130 */
  0x0000,   /* U+0131 */
  0x000A,   /* U+0132 */
  0x0004,   /* U+0133 */
  0x0002,   /* U+0134 */
  0x0002,   /* U+0135 */
  0x0002,   /* U+0136 */
  0x0002,   /* U+0137 */
  0x0000,   /* U+0138 */
  0x0002,   /* U+0139 */
  0x0002,   /* U+013A */
  0x0002,   /* U+013B */
  0x0002,   /* U+013C */
  0x0002,   /* U+013D */
  0x0002,   /* U+013E */
  0x0002,   /* U+013F */
  0x0002,   /* U+0140 */
  0x0002,   /* U+0141 */
  0x0002,   /* U+0142 */
  0x0002,   /* U+0143 */
  0x0002,   /* U+0144 */
  0x0002,   /* U+0145 */
  0x0002,   /* U+0146 */
  0x0002,   /* U+0147 */
  0x0002,   /* U+0148 */
  0x0004,   /* U+0149 */
  0x0000,   /* U+014A */
  0x0000,   /* U+014B */
  0x0002,   /* U+014C */
  0x0002,   /* U+014D */
  0x0002,   /* U+014E */
  0x0002,   /* U+014F */
  0x0002,   /* U+0150 */
  0x0002,   /* U+0151 */
  0x0004,   /* U+0152 */
  0x0004,   /* U+0153 */
  0x0002,   /* U+0154 */
  0x0002,   /* U+0155 */
  0x0002,   /* U+0156 */
  0x0002,   /* U+0157 */
  0x0002,   /* U+0158 */
  0x0002,   /* U+0159 */
  0x0002,   /* U+015A */
  0x0002,   /* U+015B */
  0x0002,   /* U+015C */
  0x0002,   /* U+015D */
  0x0002,   /* U+015E */
  0x0002,   /* U+015F */
  0x0002,   /* U+0160 */
  0x0002,   /* U+0161 */
  0x0002,   /* U+0162 */
  0x0002,   /* U+0163 */
  0x0002,   /* U+0164 */
  0x0002,   /* U+0165 */
  0x0000,   /* U+0166 */
  0x0000,   /* U+0167 */
  0x0002,   /* U+0168 */
  0x0002,   /* U+0169 */
  0x0002,   /* U+016A */
  0x0002,   /* U+016B */
  0x0002,   /* U+016C */
  0x0002,   /* U+016D */
  0x0002,   /* U+016E */
  0x0002,   /* U+016F */
  0x0002,   /* U+0170 */
  0x0002,   /* U+0171 */
  0x0002,   /* U+0172 */
  0x0002,   /* U+0173 */
  0x0002,   /* U+0174 */
  0x0002,   /* U+0175 */
  0x0002,   /* U+0176 */
  0x0002,   /* U+0177 */
  0x0002,   /* U+0178 */
  0x0002,   /* U+0179 */
  0x0002,   /* U+017A */
  0x0002,   /* U+017B */
  0x0002,   /* U+017C */
  0x0002,   /* U+017D */
  0x0002,   /* U+017E */
  0x0004,   /* U+017F */
  0x0000,   /* U+0180 */
  0x0000,   /* U+0181 */
  0x0000,   /* U+0182 */
  0x0000,   /* U+0183 */
  0x0000,   /* U+0184 */
  0x0000,   /* U+0185 */
  0x0000,   /* U+0186 */
  0x0000,   /* U+0187 */
  0x0000,   /* U+0188 */
  0x0000,   /* U+0189 */
  0x0000,   /* U+018A */
  0x0000,   /* U+018B */
  0x0000,   /* U+018C */
  0x0004,   /* U+018D */
  0x0000,   /* U+018E */
  0x0000,   /* U+018F */
  0x0000,   /* U+0190 */
  0x0000,   /* U+0191 */
  0x0000,   /* U+0192 */
  0x0000,   /* U+0193 */
  0x0000,   /* U+0194 */
  0x0000,   /* U+0195 */
  0x0000,   /* U+0196 */
  0x0000,   /* U+0197 */
  0x0000,   /* U+0198 */
  0x0000,   /* U+0199 */
  0x0000,   /* U+019A */
  0x0000,   /* U+019B */
  0x0000,   /* U+019C */
  0x0000,   /* U+019D */
  0x0000,   /* U+019E */
  0x0000,   /* U+019F */
  0x0002,   /* U+01A0 */
  0x0002,   /* U+01A1 */
  0x0000,   /* U+01A2 */
  0x0000,   /* U+01A3 */
  0x0000,   /* U+01A4 */
  0x0000,   /* U+01A5 */
  0x0000,   /* U+01A6 */
  0x0000,   /* U+01A7 */
  0x0000,   /* U+01A8 */
  0x0000,   /* U+01A9 */
  0x0000,   /* U+01AA */
  0x0000,   /* U+01AB */
  0x0000,   /* U+01AC */
  0x0000,   /* U+01AD */
  0x0000,   /* U+01AE */
  0x0002,   /* U+01AF */
  0x0002,   /* U+01B0 */
  0x0000,   /* U+01B1 */
  0x0000,   /* U+01B2 */
  0x0000,   /* U+01B3 */
  0x0000,   /* U+01B4 */
  0x0000,   /* U+01B5 */
  0x0000,   /* U+01B6 */
  0x0000,   /* U+01B7 */
  0x0000,   /* U+01B8 */
  0x0000,   /* U+01B9 */
  0x0000,   /* U+01BA */
  0x0000,   /* U+01BB */
  0x0000,   /* U+01BC */
  0x0000,   /* U+01BD */
  0x0004,   /* U+01BE */
  0x0000,   /* U+01BF */
  0x0000,   /* U+01C0 */
  0x0000,   /* U+01C1 */
  0x0000,   /* U+01C2 */
  0x0000,   /* U+01C3 */
  0x000A,   /* U+01C4 */
  0x0004,   /* U+01C5 */
  0x0004,   /* U+01C6 */
  0x000A,   /* U+01C7 */
  0x0004,   /* U+01C8 */
  0x0004,   /* U+01C9 */
  0x000A,   /* U+01CA */
  0x0004,   /* U+01CB */
  0x0004,   /* U+01CC */
  0x0002,   /* U+01CD */
  0x0002,   /* U+01CE */
  0x0002,   /* U+01CF */
  0x0002,   /* U+01D0 */
  0x0002,   /* U+01D1 */
  0x0002,   /* U+01D2 */
  0x0002,   /* U+01D3 */
  0x0002,   /* U+01D4 */
  0x0002,   /* U+01D5 */
  0x0002,   /* U+01D6 */
  0x0002,   /* U+01D7 */
  0x0002,   /* U+01D8 */
  0x0002,   /* U+01D9 */
  0x0002,   /* U+01DA */
  0x0002,   /* U+01DB */
  0x0002,   /* U+01DC */
  0x0000,   /* U+01DD */
  0x0002,   /* U+01DE */
  0x0002,   /* U+01DF */
  0x0002,   /* U+01E0 */
  0x0002,   /* U+01E1 */
  0x0004,   /* U+01E2 */
  0x0004,   /* U+01E3 */
  0x0000,   /* U+01E4 */
  0x0000,   /* U+01E5 */
  0x0002,   /* U+01E6 */
  0x0002,   /* U+01E7 */
  0x0002,   /* U+01E8 */
  0x0002,   /* U+01E9 */
  0x0002,   /* U+01EA */
  0x0002,   /* U+01EB */
  0x0002,   /* U+01EC */
  0x0002,   /* U+01ED */
  0x0002,   /* U+01EE */
  0x0002,   /* U+01EF */
  0x0002,   /* U+01F0 */
  0x000A,   /* U+01F1 */
  0x0004,   /* U+01F2 */
  0x0004,   /* U+01F3 */
  0x0002,   /* U+01F4 */
  0x0002,   /* U+01F5 */
  0x0000,   /* U+01F6 */
  0x0000,   /* U+01F7 */
  0x0002,   /* U+01F8 */
  0x0002,   /* U+01F9 */
  0x0002,   /* U+01FA */
  0x0002,   /* U+01FB */
  0x0004,   /* U+01FC */
  0x0004,   /* U+01FD */
  0x0002,   /* U+01FE */
  0x0002,   /* U+01FF */

  /* Primary weight 3 for each character. */
  0x0000,   /* U+0100 */
  0x0000,   /* U+0101 */
  0x0000,   /* U+0102 */
  0x0000,   /* U+0103 */
  0x0000,   /* U+0104 */
  0x0000,   /* U+0105 */
  0x0000,   /* U+0106 */
  0x0000,   /* U+0107 */
  0x0000,   /* U+0108 */
  0x0000,   /* U+0109 */
  0x0000,   /* U+010A */
  0x0000,   /* U+010B */
  0x0000,   /* U+010C */
  0x0000,   /* U+010D */
  0x0000,   /* U+010E */
  0x0000,   /* U+010F */
  0x0000,   /* U+0110 */
  0x0000,   /* U+0111 */
  0x0000,   /* U+0112 */
  0x0000,   /* U+0113 */
  0x0000,   /* U+0114 */
  0x0000,   /* U+0115 */
  0x0000,   /* U+0116 */
  0x0000,   /* U+0117 */
  0x0000,   /* U+0118 */
  0x0000,   /* U+0119 */
  0x0000,   /* U+011A */
  0x0000,   /* U+011B */
  0x0000,   /* U+011C */
  0x0000,   /* U+011D */
  0x0000,   /* U+011E */
  0x0000,   /* U+011F */
  0x0000,   /* U+0120 */
  0x0000,   /* U+0121 */
  0x0000,   /* U+0122 */
  0x0000,   /* U+0123 */
  0x0000,   /* U+0124 */
  0x0000,   /* U+0125 */
  0x0000,   /* U+0126 */
  0x0000,   /* U+0127 */
  0x0000,   /* U+0128 */
  0x0000,   /* U+0129 */
  0x0000,   /* U+012A */
  0x0000,   /* U+012B */
  0x0000,   /* U+012C */
  0x0000,   /* U+012D */
  0x0000,   /* U+012E */
  0x0000,   /* U+012F */
  0x0000,   /* U+0130 */
  0x0000,   /* U+0131 */
  0x0000,   /* U+0132 */
  0x0000,   /* U+0133 */
  0x0000,   /* U+0134 */
  0x0000,   /* U+0135 */
  0x0000,   /* U+0136 */
  0x0000,   /* U+0137 */
  0x0000,   /* U+0138 */
  0x0000,   /* U+0139 */
  0x0000,   /* U+013A */
  0x0000,   /* U+013B */
  0x0000,   /* U+013C */
  0x0000,   /* U+013D */
  0x0000,   /* U+013E */
  0x0000,   /* U+013F */
  0x0000,   /* U+0140 */
  0x0000,   /* U+0141 */
  0x0000,   /* U+0142 */
  0x0000,   /* U+0143 */
  0x0000,   /* U+0144 */
  0x0000,   /* U+0145 */
  0x0000,   /* U+0146 */
  0x0000,   /* U+0147 */
  0x0000,   /* U+0148 */
  0x0000,   /* U+0149 */
  0x0000,   /* U+014A */
  0x0000,   /* U+014B */
  0x0000,   /* U+014C */
  0x0000,   /* U+014D */
  0x0000,   /* U+014E */
  0x0000,   /* U+014F */
  0x0000,   /* U+0150 */
  0x0000,   /* U+0151 */
  0x1CAA,   /* U+0152 */
  0x1CAA,   /* U+0153 */
  0x0000,   /* U+0154 */
  0x0000,   /* U+0155 */
  0x0000,   /* U+0156 */
  0x0000,   /* U+0157 */
  0x0000,   /* U+0158 */
  0x0000,   /* U+0159 */
  0x0000,   /* U+015A */
  0x0000,   /* U+015B */
  0x0000,   /* U+015C */
  0x0000,   /* U+015D */
  0x0000,   /* U+015E */
  0x0000,   /* U+015F */
  0x0000,   /* U+0160 */
  0x0000,   /* U+0161 */
  0x0000,   /* U+0162 */
  0x0000,   /* U+0163 */
  0x0000,   /* U+0164 */
  0x0000,   /* U+0165 */
  0x0000,   /* U+0166 */
  0x0000,   /* U+0167 */
  0x0000,   /* U+0168 */
  0x0000,   /* U+0169 */
  0x0000,   /* U+016A */
  0x0000,   /* U+016B */
  0x0000,   /* U+016C */
  0x0000,   /* U+016D */
  0x0000,   /* U+016E */
  0x0000,   /* U+016F */
  0x0000,   /* U+0170 */
  0x0000,   /* U+0171 */
  0x0000,   /* U+0172 */
  0x0000,   /* U+0173 */
  0x0000,   /* U+0174 */
  0x0000,   /* U+0175 */
  0x0000,   /* U+0176 */
  0x0000,   /* U+0177 */
  0x0000,   /* U+0178 */
  0x0000,   /* U+0179 */
  0x0000,   /* U+017A */
  0x0000,   /* U+017B */
  0x0000,   /* U+017C */
  0x0000,   /* U+017D */
  0x0000,   /* U+017E */
  0x0000,   /* U+017F */
  0x0000,   /* U+0180 */
  0x0000,   /* U+0181 */
  0x0000,   /* U+0182 */
  0x0000,   /* U+0183 */
  0x0000,   /* U+0184 */
  0x0000,   /* U+0185 */
  0x0000,   /* U+0186 */
  0x0000,   /* U+0187 */
  0x0000,   /* U+0188 */
  0x0000,   /* U+0189 */
  0x0000,   /* U+018A */
  0x0000,   /* U+018B */
  0x0000,   /* U+018C */
  0x0000,   /* U+018D */
  0x0000,   /* U+018E */
  0x0000,   /* U+018F */
  0x0000,   /* U+0190 */
  0x0000,   /* U+0191 */
  0x0000,   /* U+0192 */
  0x0000,   /* U+0193 */
  0x0000,   /* U+0194 */
  0x0000,   /* U+0195 */
  0x0000,   /* U+0196 */
  0x0000,   /* U+0197 */
  0x0000,   /* U+0198 */
  0x0000,   /* U+0199 */
  0x0000,   /* U+019A */
  0x0000,   /* U+019B */
  0x0000,   /* U+019C */
  0x0000,   /* U+019D */
  0x0000,   /* U+019E */
  0x0000,   /* U+019F */
  0x0000,   /* U+01A0 */
  0x0000,   /* U+01A1 */
  0x0000,   /* U+01A2 */
  0x0000,   /* U+01A3 */
  0x0000,   /* U+01A4 */
  0x0000,   /* U+01A5 */
  0x0000,   /* U+01A6 */
  0x0000,   /* U+01A7 */
  0x0000,   /* U+01A8 */
  0x0000,   /* U+01A9 */
  0x0000,   /* U+01AA */
  0x0000,   /* U+01AB */
  0x0000,   /* U+01AC */
  0x0000,   /* U+01AD */
  0x0000,   /* U+01AE */
  0x0000,   /* U+01AF */
  0x0000,   /* U+01B0 */
  0x0000,   /* U+01B1 */
  0x0000,   /* U+01B2 */
  0x0000,   /* U+01B3 */
  0x0000,   /* U+01B4 */
  0x0000,   /* U+01B5 */
  0x0000,   /* U+01B6 */
  0x0000,   /* U+01B7 */
  0x0000,   /* U+01B8 */
  0x0000,   /* U+01B9 */
  0x0000,   /* U+01BA */
  0x0000,   /* U+01BB */
  0x0000,   /* U+01BC */
  0x0000,   /* U+01BD */
  0x0000,   /* U+01BE */
  0x0000,   /* U+01BF */
  0x0000,   /* U+01C0 */
  0x0000,   /* U+01C1 */
  0x0000,   /* U+01C2 */
  0x0000,   /* U+01C3 */
  0x0000,   /* U+01C4 */
  0x0000,   /* U+01C5 */
  0x0000,   /* U+01C6 */
  0x0000,   /* U+01C7 */
  0x0000,   /* U+01C8 */
  0x0000,   /* U+01C9 */
  0x0000,   /* U+01CA */
  0x0000,   /* U+01CB */
  0x0000,   /* U+01CC */
  0x0000,   /* U+01CD */
  0x0000,   /* U+01CE */
  0x0000,   /* U+01CF */
  0x0000,   /* U+01D0 */
  0x0000,   /* U+01D1 */
  0x0000,   /* U+01D2 */
  0x0000,   /* U+01D3 */
  0x0000,   /* U+01D4 */
  0x0000,   /* U+01D5 */
  0x0000,   /* U+01D6 */
  0x0000,   /* U+01D7 */
  0x0000,   /* U+01D8 */
  0x0000,   /* U+01D9 */
  0x0000,   /* U+01DA */
  0x0000,   /* U+01DB */
  0x0000,   /* U+01DC */
  0x0000,   /* U+01DD */
  0x0000,   /* U+01DE */
  0x0000,   /* U+01DF */
  0x0000,   /* U+01E0 */
  0x0000,   /* U+01E1 */
  0x1CAA,   /* U+01E2 */
  0x1CAA,   /* U+01E3 */
  0x0000,   /* U+01E4 */
  0x0000,   /* U+01E5 */
  0x0000,   /* U+01E6 */
  0x0000,   /* U+01E7 */
  0x0000,   /* U+01E8 */
  0x0000,   /* U+01E9 */
  0x0000,   /* U+01EA */
  0x0000,   /* U+01EB */
  0x0000,   /* U+01EC */
  0x0000,   /* U+01ED */
  0x0000,   /* U+01EE */
  0x0000,   /* U+01EF */
  0x0000,   /* U+01F0 */
  0x0000,   /* U+01F1 */
  0x0000,   /* U+01F2 */
  0x0000,   /* U+01F3 */
  0x0000,   /* U+01F4 */
  0x0000,   /* U+01F5 */
  0x0000,   /* U+01F6 */
  0x0000,   /* U+01F7 */
  0x0000,   /* U+01F8 */
  0x0000,   /* U+01F9 */
  0x0000,   /* U+01FA */
  0x0000,   /* U+01FB */
  0x1CAA,   /* U+01FC */
  0x1CAA,   /* U+01FD */
  0x0000,   /* U+01FE */
  0x0000,   /* U+01FF */

  /* Secondary weight 3 for each character. */
  0x0000,   /* U+0100 */
  0x0000,   /* U+0101 */
  0x0000,   /* U+0102 */
  0x0000,   /* U+0103 */
  0x0000,   /* U+0104 */
  0x0000,   /* U+0105 */
  0x0000,   /* U+0106 */
  0x0000,   /* U+0107 */
  0x0000,   /* U+0108 */
  0x0000,   /* U+0109 */
  0x0000,   /* U+010A */
  0x0000,   /* U+010B */
  0x0000,   /* U+010C */
  0x0000,   /* U+010D */
  0x0000,   /* U+010E */
  0x0000,   /* U+010F */
  0x0000,   /* U+0110 */
  0x0000,   /* U+0111 */
  0x0000,   /* U+0112 */
  0x0000,   /* U+0113 */
  0x0000,   /* U+0114 */
  0x0000,   /* U+0115 */
  0x0000,   /* U+0116 */
  0x0000,   /* U+0117 */
  0x0000,   /* U+0118 */
  0x0000,   /* U+0119 */
  0x0000,   /* U+011A */
  0x0000,   /* U+011B */
  0x0000,   /* U+011C */
  0x0000,   /* U+011D */
  0x0000,   /* U+011E */
  0x0000,   /* U+011F */
  0x0000,   /* U+0120 */
  0x0000,   /* U+0121 */
  0x0000,   /* U+0122 */
  0x0000,   /* U+0123 */
  0x0000,   /* U+0124 */
  0x0000,   /* U+0125 */
  0x0000,   /* U+0126 */
  0x0000,   /* U+0127 */
  0x0000,   /* U+0128 */
  0x0000,   /* U+0129 */
  0x0000,   /* U+012A */
  0x0000,   /* U+012B */
  0x0000,   /* U+012C */
  0x0000,   /* U+012D */
  0x0000,   /* U+012E */
  0x0000,   /* U+012F */
  0x0000,   /* U+0130 */
  0x0000,   /* U+0131 */
  0x0000,   /* U+0132 */
  0x0000,   /* U+0133 */
  0x0000,   /* U+0134 */
  0x0000,   /* U+0135 */
  0x0000,   /* U+0136 */
  0x0000,   /* U+0137 */
  0x0000,   /* U+0138 */
  0x0000,   /* U+0139 */
  0x0000,   /* U+013A */
  0x0000,   /* U+013B */
  0x0000,   /* U+013C */
  0x0000,   /* U+013D */
  0x0000,   /* U+013E */
  0x0000,   /* U+013F */
  0x0000,   /* U+0140 */
  0x0000,   /* U+0141 */
  0x0000,   /* U+0142 */
  0x0000,   /* U+0143 */
  0x0000,   /* U+0144 */
  0x0000,   /* U+0145 */
  0x0000,   /* U+0146 */
  0x0000,   /* U+0147 */
  0x0000,   /* U+0148 */
  0x0000,   /* U+0149 */
  0x0000,   /* U+014A */
  0x0000,   /* U+014B */
  0x0000,   /* U+014C */
  0x0000,   /* U+014D */
  0x0000,   /* U+014E */
  0x0000,   /* U+014F */
  0x0000,   /* U+0150 */
  0x0000,   /* U+0151 */
  0x0020,   /* U+0152 */
  0x0020,   /* U+0153 */
  0x0000,   /* U+0154 */
  0x0000,   /* U+0155 */
  0x0000,   /* U+0156 */
  0x0000,   /* U+0157 */
  0x0000,   /* U+0158 */
  0x0000,   /* U+0159 */
  0x0000,   /* U+015A */
  0x0000,   /* U+015B */
  0x0000,   /* U+015C */
  0x0000,   /* U+015D */
  0x0000,   /* U+015E */
  0x0000,   /* U+015F */
  0x0000,   /* U+0160 */
  0x0000,   /* U+0161 */
  0x0000,   /* U+0162 */
  0x0000,   /* U+0163 */
  0x0000,   /* U+0164 */
  0x0000,   /* U+0165 */
  0x0000,   /* U+0166 */
  0x0000,   /* U+0167 */
  0x0000,   /* U+0168 */
  0x0000,   /* U+0169 */
  0x0000,   /* U+016A */
  0x0000,   /* U+016B */
  0x0000,   /* U+016C */
  0x0000,   /* U+016D */
  0x0000,   /* U+016E */
  0x0000,   /* U+016F */
  0x0000,   /* U+0170 */
  0x0000,   /* U+0171 */
  0x0000,   /* U+0172 */
  0x0000,   /* U+0173 */
  0x0000,   /* U+0174 */
  0x0000,   /* U+0175 */
  0x0000,   /* U+0176 */
  0x0000,   /* U+0177 */
  0x0000,   /* U+0178 */
  0x0000,   /* U+0179 */
  0x0000,   /* U+017A */
  0x0000,   /* U+017B */
  0x0000,   /* U+017C */
  0x0000,   /* U+017D */
  0x0000,   /* U+017E */
  0x0000,   /* U+017F */
  0x0000,   /* U+0180 */
  0x0000,   /* U+0181 */
  0x0000,   /* U+0182 */
  0x0000,   /* U+0183 */
  0x0000,   /* U+0184 */
  0x0000,   /* U+0185 */
  0x0000,   /* U+0186 */
  0x0000,   /* U+0187 */
  0x0000,   /* U+0188 */
  0x0000,   /* U+0189 */
  0x0000,   /* U+018A */
  0x0000,   /* U+018B */
  0x0000,   /* U+018C */
  0x0000,   /* U+018D */
  0x0000,   /* U+018E */
  0x0000,   /* U+018F */
  0x0000,   /* U+0190 */
  0x0000,   /* U+0191 */
  0x0000,   /* U+0192 */
  0x0000,   /* U+0193 */
  0x0000,   /* U+0194 */
  0x0000,   /* U+0195 */
  0x0000,   /* U+0196 */
  0x0000,   /* U+0197 */
  0x0000,   /* U+0198 */
  0x0000,   /* U+0199 */
  0x0000,   /* U+019A */
  0x0000,   /* U+019B */
  0x0000,   /* U+019C */
  0x0000,   /* U+019D */
  0x0000,   /* U+019E */
  0x0000,   /* U+019F */
  0x0000,   /* U+01A0 */
  0x0000,   /* U+01A1 */
  0x0000,   /* U+01A2 */
  0x0000,   /* U+01A3 */
  0x0000,   /* U+01A4 */
  0x0000,   /* U+01A5 */
  0x0000,   /* U+01A6 */
  0x0000,   /* U+01A7 */
  0x0000,   /* U+01A8 */
  0x0000,   /* U+01A9 */
  0x0000,   /* U+01AA */
  0x0000,   /* U+01AB */
  0x0000,   /* U+01AC */
  0x0000,   /* U+01AD */
  0x0000,   /* U+01AE */
  0x0000,   /* U+01AF */
  0x0000,   /* U+01B0 */
  0x0000,   /* U+01B1 */
  0x0000,   /* U+01B2 */
  0x0000,   /* U+01B3 */
  0x0000,   /* U+01B4 */
  0x0000,   /* U+01B5 */
  0x0000,   /* U+01B6 */
  0x0000,   /* U+01B7 */
  0x0000,   /* U+01B8 */
  0x0000,   /* U+01B9 */
  0x0000,   /* U+01BA */
  0x0000,   /* U+01BB */
  0x0000,   /* U+01BC */
  0x0000,   /* U+01BD */
  0x0000,   /* U+01BE */
  0x0000,   /* U+01BF */
  0x0000,   /* U+01C0 */
  0x0000,   /* U+01C1 */
  0x0000,   /* U+01C2 */
  0x0000,   /* U+01C3 */
  0x0028,   /* U+01C4 */
  0x0028,   /* U+01C5 */
  0x0028,   /* U+01C6 */
  0x0000,   /* U+01C7 */
  0x0000,   /* U+01C8 */
  0x0000,   /* U+01C9 */
  0x0000,   /* U+01CA */
  0x0000,   /* U+01CB */
  0x0000,   /* U+01CC */
  0x0000,   /* U+01CD */
  0x0000,   /* U+01CE */
  0x0000,   /* U+01CF */
  0x0000,   /* U+01D0 */
  0x0000,   /* U+01D1 */
  0x0000,   /* U+01D2 */
  0x0000,   /* U+01D3 */
  0x0000,   /* U+01D4 */
  0x0032,   /* U+01D5 */
  0x0032,   /* U+01D6 */
  0x0024,   /* U+01D7 */
  0x0024,   /* U+01D8 */
  0x0028,   /* U+01D9 */
  0x0028,   /* U+01DA */
  0x0025,   /* U+01DB */
  0x0025,   /* U+01DC */
  0x0000,   /* U+01DD */
  0x0032,   /* U+01DE */
  0x0032,   /* U+01DF */
  0x0032,   /* U+01E0 */
  0x0032,   /* U+01E1 */
  0x0020,   /* U+01E2 */
  0x0020,   /* U+01E3 */
  0x0000,   /* U+01E4 */
  0x0000,   /* U+01E5 */
  0x0000,   /* U+01E6 */
  0x0000,   /* U+01E7 */
  0x0000,   /* U+01E8 */
  0x0000,   /* U+01E9 */
  0x0000,   /* U+01EA */
  0x0000,   /* U+01EB */
  0x0032,   /* U+01EC */
  0x0032,   /* U+01ED */
  0x0000,   /* U+01EE */
  0x0000,   /* U+01EF */
  0x0000,   /* U+01F0 */
  0x0000,   /* U+01F1 */
  0x0000,   /* U+01F2 */
  0x0000,   /* U+01F3 */
  0x0000,   /* U+01F4 */
  0x0000,   /* U+01F5 */
  0x0000,   /* U+01F6 */
  0x0000,   /* U+01F7 */
  0x0000,   /* U+01F8 */
  0x0000,   /* U+01F9 */
  0x0024,   /* U+01FA */
  0x0024,   /* U+01FB */
  0x0020,   /* U+01FC */
  0x0020,   /* U+01FD */
  0x0024,   /* U+01FE */
  0x0024,   /* U+01FF */

  /* Tertiary weight 3 for each character. */
  0x0000,   /* U+0100 */
  0x0000,   /* U+0101 */
  0x0000,   /* U+0102 */
  0x0000,   /* U+0103 */
  0x0000,   /* U+0104 */
  0x0000,   /* U+0105 */
  0x0000,   /* U+0106 */
  0x0000,   /* U+0107 */
  0x0000,   /* U+0108 */
  0x0000,   /* U+0109 */
  0x0000,   /* U+010A */
  0x0000,   /* U+010B */
  0x0000,   /* U+010C */
  0x0000,   /* U+010D */
  0x0000,   /* U+010E */
  0x0000,   /* U+010F */
  0x0000,   /* U+0110 */
  0x0000,   /* U+0111 */
  0x0000,   /* U+0112 */
  0x0000,   /* U+0113 */
  0x0000,   /* U+0114 */
  0x0000,   /* U+0115 */
  0x0000,   /* U+0116 */
  0x0000,   /* U+0117 */
  0x0000,   /* U+0118 */
  0x0000,   /* U+0119 */
  0x0000,   /* U+011A */
  0x0000,   /* U+011B */
  0x0000,   /* U+011C */
  0x0000,   /* U+011D */
  0x0000,   /* U+011E */
  0x0000,   /* U+011F */
  0x0000,   /* U+0120 */
  0x0000,   /* U+0121 */
  0x0000,   /* U+0122 */
  0x0000,   /* U+0123 */
  0x0000,   /* U+0124 */
  0x0000,   /* U+0125 */
  0x0000,   /* U+0126 */
  0x0000,   /* U+0127 */
  0x0000,   /* U+0128 */
  0x0000,   /* U+0129 */
  0x0000,   /* U+012A */
  0x0000,   /* U+012B */
  0x0000,   /* U+012C */
  0x0000,   /* U+012D */
  0x0000,   /* U+012E */
  0x0000,   /* U+012F */
  0x0000,   /* U+0130 */
  0x0000,   /* U+0131 */
  0x0000,   /* U+0132 */
  0x0000,   /* U+0133 */
  0x0000,   /* U+0134 */
  0x0000,   /* U+0135 */
  0x0000,   /* U+0136 */
  0x0000,   /* U+0137 */
  0x0000,   /* U+0138 */
  0x0000,   /* U+0139 */
  0x0000,   /* U+013A */
  0x0000,   /* U+013B */
  0x0000,   /* U+013C */
  0x0000,   /* U+013D */
  0x0000,   /* U+013E */
  0x0000,   /* U+013F */
  0x0000,   /* U+0140 */
  0x0000,   /* U+0141 */
  0x0000,   /* U+0142 */
  0x0000,   /* U+0143 */
  0x0000,   /* U+0144 */
  0x0000,   /* U+0145 */
  0x0000,   /* U+0146 */
  0x0000,   /* U+0147 */
  0x0000,   /* U+0148 */
  0x0000,   /* U+0149 */
  0x0000,   /* U+014A */
  0x0000,   /* U+014B */
  0x0000,   /* U+014C */
  0x0000,   /* U+014D */
  0x0000,   /* U+014E */
  0x0000,   /* U+014F */
  0x0000,   /* U+0150 */
  0x0000,   /* U+0151 */
  0x000A,   /* U+0152 */
  0x0004,   /* U+0153 */
  0x0000,   /* U+0154 */
  0x0000,   /* U+0155 */
  0x0000,   /* U+0156 */
  0x0000,   /* U+0157 */
  0x0000,   /* U+0158 */
  0x0000,   /* U+0159 */
  0x0000,   /* U+015A */
  0x0000,   /* U+015B */
  0x0000,   /* U+015C */
  0x0000,   /* U+015D */
  0x0000,   /* U+015E */
  0x0000,   /* U+015F */
  0x0000,   /* U+0160 */
  0x0000,   /* U+0161 */
  0x0000,   /* U+0162 */
  0x0000,   /* U+0163 */
  0x0000,   /* U+0164 */
  0x0000,   /* U+0165 */
  0x0000,   /* U+0166 */
  0x0000,   /* U+0167 */
  0x0000,   /* U+0168 */
  0x0000,   /* U+0169 */
  0x0000,   /* U+016A */
  0x0000,   /* U+016B */
  0x0000,   /* U+016C */
  0x0000,   /* U+016D */
  0x0000,   /* U+016E */
  0x0000,   /* U+016F */
  0x0000,   /* U+0170 */
  0x0000,   /* U+0171 */
  0x0000,   /* U+0172 */
  0x0000,   /* U+0173 */
  0x0000,   /* U+0174 */
  0x0000,   /* U+0175 */
  0x0000,   /* U+0176 */
  0x0000,   /* U+0177 */
  0x0000,   /* U+0178 */
  0x0000,   /* U+0179 */
  0x0000,   /* U+017A */
  0x0000,   /* U+017B */
  0x0000,   /* U+017C */
  0x0000,   /* U+017D */
  0x0000,   /* U+017E */
  0x0000,   /* U+017F */
  0x0000,   /* U+0180 */
  0x0000,   /* U+0181 */
  0x0000,   /* U+0182 */
  0x0000,   /* U+0183 */
  0x0000,   /* U+0184 */
  0x0000,   /* U+0185 */
  0x0000,   /* U+0186 */
  0x0000,   /* U+0187 */
  0x0000,   /* U+0188 */
  0x0000,   /* U+0189 */
  0x0000,   /* U+018A */
  0x0000,   /* U+018B */
  0x0000,   /* U+018C */
  0x0000,   /* U+018D */
  0x0000,   /* U+018E */
  0x0000,   /* U+018F */
  0x0000,   /* U+0190 */
  0x0000,   /* U+0191 */
  0x0000,   /* U+0192 */
  0x0000,   /* U+0193 */
  0x0000,   /* U+0194 */
  0x0000,   /* U+0195 */
  0x0000,   /* U+0196 */
  0x0000,   /* U+0197 */
  0x0000,   /* U+0198 */
  0x0000,   /* U+0199 */
  0x0000,   /* U+019A */
  0x0000,   /* U+019B */
  0x0000,   /* U+019C */
  0x0000,   /* U+019D */
  0x0000,   /* U+019E */
  0x0000,   /* U+019F */
  0x0000,   /* U+01A0 */
  0x0000,   /* U+01A1 */
  0x0000,   /* U+01A2 */
  0x0000,   /* U+01A3 */
  0x0000,   /* U+01A4 */
  0x0000,   /* U+01A5 */
  0x0000,   /* U+01A6 */
  0x0000,   /* U+01A7 */
  0x0000,   /* U+01A8 */
  0x0000,   /* U+01A9 */
  0x0000,   /* U+01AA */
  0x0000,   /* U+01AB */
  0x0000,   /* U+01AC */
  0x0000,   /* U+01AD */
  0x0000,   /* U+01AE */
  0x0000,   /* U+01AF */
  0x0000,   /* U+01B0 */
  0x0000,   /* U+01B1 */
  0x0000,   /* U+01B2 */
  0x0000,   /* U+01B3 */
  0x0000,   /* U+01B4 */
  0x0000,   /* U+01B5 */
  0x0000,   /* U+01B6 */
  0x0000,   /* U+01B7 */
  0x0000,   /* U+01B8 */
  0x0000,   /* U+01B9 */
  0x0000,   /* U+01BA */
  0x0000,   /* U+01BB */
  0x0000,   /* U+01BC */
  0x0000,   /* U+01BD */
  0x0000,   /* U+01BE */
  0x0000,   /* U+01BF */
  0x0000,   /* U+01C0 */
  0x0000,   /* U+01C1 */
  0x0000,   /* U+01C2 */
  0x0000,   /* U+01C3 */
  0x0004,   /* U+01C4 */
  0x0004,   /* U+01C5 */
  0x0004,   /* U+01C6 */
  0x0000,   /* U+01C7 */
  0x0000,   /* U+01C8 */
  0x0000,   /* U+01C9 */
  0x0000,   /* U+01CA */
  0x0000,   /* U+01CB */
  0x0000,   /* U+01CC */
  0x0000,   /* U+01CD */
  0x0000,   /* U+01CE */
  0x0000,   /* U+01CF */
  0x0000,   /* U+01D0 */
  0x0000,   /* U+01D1 */
  0x0000,   /* U+01D2 */
  0x0000,   /* U+01D3 */
  0x0000,   /* U+01D4 */
  0x0002,   /* U+01D5 */
  0x0002,   /* U+01D6 */
  0x0002,   /* U+01D7 */
  0x0002,   /* U+01D8 */
  0x0002,   /* U+01D9 */
  0x0002,   /* U+01DA */
  0x0002,   /* U+01DB */
  0x0002,   /* U+01DC */
  0x0000,   /* U+01DD */
  0x0002,   /* U+01DE */
  0x0002,   /* U+01DF */
  0x0002,   /* U+01E0 */
  0x0002,   /* U+01E1 */
  0x000A,   /* U+01E2 */
  0x0004,   /* U+01E3 */
  0x0000,   /* U+01E4 */
  0x0000,   /* U+01E5 */
  0x0000,   /* U+01E6 */
  0x0000,   /* U+01E7 */
  0x0000,   /* U+01E8 */
  0x0000,   /* U+01E9 */
  0x0000,   /* U+01EA */
  0x0000,   /* U+01EB */
  0x0002,   /* U+01EC */
  0x0002,   /* U+01ED */
  0x0000,   /* U+01EE */
  0x0000,   /* U+01EF */
  0x0000,   /* U+01F0 */
  0x0000,   /* U+01F1 */
  0x0000,   /* U+01F2 */
  0x0000,   /* U+01F3 */
  0x0000,   /* U+01F4 */
  0x0000,   /* U+01F5 */
  0x0000,   /* U+01F6 */
  0x0000,   /* U+01F7 */
  0x0000,   /* U+01F8 */
  0x0000,   /* U+01F9 */
  0x0002,   /* U+01FA */
  0x0002,   /* U+01FB */
  0x000A,   /* U+01FC */
  0x0004,   /* U+01FD */
  0x0002,   /* U+01FE */
  0x0002,   /* U+01FF */

  /* Primary weight 4 for each character. */
  0x0000,   /* U+0100 */
  0x0000,   /* U+0101 */
  0x0000,   /* U+0102 */
  0x0000,   /* U+0103 */
  0x0000,   /* U+0104 */
  0x0000,   /* U+0105 */
  0x0000,   /* U+0106 */
  0x0000,   /* U+0107 */
  0x0000,   /* U+0108 */
  0x0000,   /* U+0109 */
  0x0000,   /* U+010A */
  0x0000,   /* U+010B */
  0x0000,   /* U+010C */
  0x0000,   /* U+010D */
  0x0000,   /* U+010E */
  0x0000,   /* U+010F */
  0x0000,   /* U+0110 */
  0x0000,   /* U+0111 */
  0x0000,   /* U+0112 */
  0x0000,   /* U+0113 */
  0x0000,   /* U+0114 */
  0x0000,   /* U+0115 */
  0x0000,   /* U+0116 */
  0x0000,   /* U+0117 */
  0x0000,   /* U+0118 */
  0x0000,   /* U+0119 */
  0x0000,   /* U+011A */
  0x0000,   /* U+011B */
  0x0000,   /* U+011C */
  0x0000,   /* U+011D */
  0x0000,   /* U+011E */
  0x0000,   /* U+011F */
  0x0000,   /* U+0120 */
  0x0000,   /* U+0121 */
  0x0000,   /* U+0122 */
  0x0000,   /* U+0123 */
  0x0000,   /* U+0124 */
  0x0000,   /* U+0125 */
  0x0000,   /* U+0126 */
  0x0000,   /* U+0127 */
  0x0000,   /* U+0128 */
  0x0000,   /* U+0129 */
  0x0000,   /* U+012A */
  0x0000,   /* U+012B */
  0x0000,   /* U+012C */
  0x0000,   /* U+012D */
  0x0000,   /* U+012E */
  0x0000,   /* U+012F */
  0x0000,   /* U+0130 */
  0x0000,   /* U+0131 */
  0x0000,   /* U+0132 */
  0x0000,   /* U+0133 */
  0x0000,   /* U+0134 */
  0x0000,   /* U+0135 */
  0x0000,   /* U+0136 */
  0x0000,   /* U+0137 */
  0x0000,   /* U+0138 */
  0x0000,   /* U+0139 */
  0x0000,   /* U+013A */
  0x0000,   /* U+013B */
  0x0000,   /* U+013C */
  0x0000,   /* U+013D */
  0x0000,   /* U+013E */
  0x0000,   /* U+013F */
  0x0000,   /* U+0140 */
  0x0000,   /* U+0141 */
  0x0000,   /* U+0142 */
  0x0000,   /* U+0143 */
  0x0000,   /* U+0144 */
  0x0000,   /* U+0145 */
  0x0000,   /* U+0146 */
  0x0000,   /* U+0147 */
  0x0000,   /* U+0148 */
  0x0000,   /* U+0149 */
  0x0000,   /* U+014A */
  0x0000,   /* U+014B */
  0x0000,   /* U+014C */
  0x0000,   /* U+014D */
  0x0000,   /* U+014E */
  0x0000,   /* U+014F */
  0x0000,   /* U+0150 */
  0x0000,   /* U+0151 */
  0x0000,   /* U+0152 */
  0x0000,   /* U+0153 */
  0x0000,   /* U+0154 */
  0x0000,   /* U+0155 */
  0x0000,   /* U+0156 */
  0x0000,   /* U+0157 */
  0x0000,   /* U+0158 */
  0x0000,   /* U+0159 */
  0x0000,   /* U+015A */
  0x0000,   /* U+015B */
  0x0000,   /* U+015C */
  0x0000,   /* U+015D */
  0x0000,   /* U+015E */
  0x0000,   /* U+015F */
  0x0000,   /* U+0160 */
  0x0000,   /* U+0161 */
  0x0000,   /* U+0162 */
  0x0000,   /* U+0163 */
  0x0000,   /* U+0164 */
  0x0000,   /* U+0165 */
  0x0000,   /* U+0166 */
  0x0000,   /* U+0167 */
  0x0000,   /* U+0168 */
  0x0000,   /* U+0169 */
  0x0000,   /* U+016A */
  0x0000,   /* U+016B */
  0x0000,   /* U+016C */
  0x0000,   /* U+016D */
  0x0000,   /* U+016E */
  0x0000,   /* U+016F */
  0x0000,   /* U+0170 */
  0x0000,   /* U+0171 */
  0x0000,   /* U+0172 */
  0x0000,   /* U+0173 */
  0x0000,   /* U+0174 */
  0x0000,   /* U+0175 */
  0x0000,   /* U+0176 */
  0x0000,   /* U+0177 */
  0x0000,   /* U+0178 */
  0x0000,   /* U+0179 */
  0x0000,   /* U+017A */
  0x0000,   /* U+017B */
  0x0000,   /* U+017C */
  0x0000,   /* U+017D */
  0x0000,   /* U+017E */
  0x0000,   /* U+017F */
  0x0000,   /* U+0180 */
  0x0000,   /* U+0181 */
  0x0000,   /* U+0182 */
  0x0000,   /* U+0183 */
  0x0000,   /* U+0184 */
  0x0000,   /* U+0185 */
  0x0000,   /* U+0186 */
  0x0000,   /* U+0187 */
  0x0000,   /* U+0188 */
  0x0000,   /* U+0189 */
  0x0000,   /* U+018A */
  0x0000,   /* U+018B */
  0x0000,   /* U+018C */
  0x0000,   /* U+018D */
  0x0000,   /* U+018E */
  0x0000,   /* U+018F */
  0x0000,   /* U+0190 */
  0x0000,   /* U+0191 */
  0x0000,   /* U+0192 */
  0x0000,   /* U+0193 */
  0x0000,   /* U+0194 */
  0x0000,   /* U+0195 */
  0x0000,   /* U+0196 */
  0x0000,   /* U+0197 */
  0x0000,   /* U+0198 */
  0x0000,   /* U+0199 */
  0x0000,   /* U+019A */
  0x0000,   /* U+019B */
  0x0000,   /* U+019C */
  0x0000,   /* U+019D */
  0x0000,   /* U+019E */
  0x0000,   /* U+019F */
  0x0000,   /* U+01A0 */
  0x0000,   /* U+01A1 */
  0x0000,   /* U+01A2 */
  0x0000,   /* U+01A3 */
  0x0000,   /* U+01A4 */
  0x0000,   /* U+01A5 */
  0x0000,   /* U+01A6 */
  0x0000,   /* U+01A7 */
  0x0000,   /* U+01A8 */
  0x0000,   /* U+01A9 */
  0x0000,   /* U+01AA */
  0x0000,   /* U+01AB */
  0x0000,   /* U+01AC */
  0x0000,   /* U+01AD */
  0x0000,   /* U+01AE */
  0x0000,   /* U+01AF */
  0x0000,   /* U+01B0 */
  0x0000,   /* U+01B1 */
  0x0000,   /* U+01B2 */
  0x0000,   /* U+01B3 */
  0x0000,   /* U+01B4 */
  0x0000,   /* U+01B5 */
  0x0000,   /* U+01B6 */
  0x0000,   /* U+01B7 */
  0x0000,   /* U+01B8 */
  0x0000,   /* U+01B9 */
  0x0000,   /* U+01BA */
  0x0000,   /* U+01BB */
  0x0000,   /* U+01BC */
  0x0000,   /* U+01BD */
  0x0000,   /* U+01BE */
  0x0000,   /* U+01BF */
  0x0000,   /* U+01C0 */
  0x0000,   /* U+01C1 */
  0x0000,   /* U+01C2 */
  0x0000,   /* U+01C3 */
  0x0000,   /* U+01C4 */
  0x0000,   /* U+01C5 */
  0x0000,   /* U+01C6 */
  0x0000,   /* U+01C7 */
  0x0000,   /* U+01C8 */
  0x0000,   /* U+01C9 */
  0x0000,   /* U+01CA */
  0x0000,   /* U+01CB */
  0x0000,   /* U+01CC */
  0x0000,   /* U+01CD */
  0x0000,   /* U+01CE */
  0x0000,   /* U+01CF */
  0x0000,   /* U+01D0 */
  0x0000,   /* U+01D1 */
  0x0000,   /* U+01D2 */
  0x0000,   /* U+01D3 */
  0x0000,   /* U+01D4 */
  0x0000,   /* U+01D5 */
  0x0000,   /* U+01D6 */
  0x0000,   /* U+01D7 */
  0x0000,   /* U+01D8 */
  0x0000,   /* U+01D9 */
  0x0000,   /* U+01DA */
  0x0000,   /* U+01DB */
  0x0000,   /* U+01DC */
  0x0000,   /* U+01DD */
  0x0000,   /* U+01DE */
  0x0000,   /* U+01DF */
  0x0000,   /* U+01E0 */
  0x0000,   /* U+01E1 */
  0x0000,   /* U+01E2 */
  0x0000,   /* U+01E3 */
  0x0000,   /* U+01E4 */
  0x0000,   /* U+01E5 */
  0x0000,   /* U+01E6 */
  0x0000,   /* U+01E7 */
  0x0000,   /* U+01E8 */
  0x0000,   /* U+01E9 */
  0x0000,   /* U+01EA */
  0x0000,   /* U+01EB */
  0x0000,   /* U+01EC */
  0x0000,   /* U+01ED */
  0x0000,   /* U+01EE */
  0x0000,   /* U+01EF */
  0x0000,   /* U+01F0 */
  0x0000,   /* U+01F1 */
  0x0000,   /* U+01F2 */
  0x0000,   /* U+01F3 */
  0x0000,   /* U+01F4 */
  0x0000,   /* U+01F5 */
  0x0000,   /* U+01F6 */
  0x0000,   /* U+01F7 */
  0x0000,   /* U+01F8 */
  0x0000,   /* U+01F9 */
  0x0000,   /* U+01FA */
  0x0000,   /* U+01FB */
  0x0000,   /* U+01FC */
  0x0000,   /* U+01FD */
  0x0000,   /* U+01FE */
  0x0000,   /* U+01FF */

  /* Secondary weight 4 for each character. */
  0x0000,   /* U+0100 */
  0x0000,   /* U+0101 */
  0x0000,   /* U+0102 */
  0x0000,   /* U+0103 */
  0x0000,   /* U+0104 */
  0x0000,   /* U+0105 */
  0x0000,   /* U+0106 */
  0x0000,   /* U+0107 */
  0x0000,   /* U+0108 */
  0x0000,   /* U+0109 */
  0x0000,   /* U+010A */
  0x0000,   /* U+010B */
  0x0000,   /* U+010C */
  0x0000,   /* U+010D */
  0x0000,   /* U+010E */
  0x0000,   /* U+010F */
  0x0000,   /* U+0110 */
  0x0000,   /* U+0111 */
  0x0000,   /* U+0112 */
  0x0000,   /* U+0113 */
  0x0000,   /* U+0114 */
  0x0000,   /* U+0115 */
  0x0000,   /* U+0116 */
  0x0000,   /* U+0117 */
  0x0000,   /* U+0118 */
  0x0000,   /* U+0119 */
  0x0000,   /* U+011A */
  0x0000,   /* U+011B */
  0x0000,   /* U+011C */
  0x0000,   /* U+011D */
  0x0000,   /* U+011E */
  0x0000,   /* U+011F */
  0x0000,   /* U+0120 */
  0x0000,   /* U+0121 */
  0x0000,   /* U+0122 */
  0x0000,   /* U+0123 */
  0x0000,   /* U+0124 */
  0x0000,   /* U+0125 */
  0x0000,   /* U+0126 */
  0x0000,   /* U+0127 */
  0x0000,   /* U+0128 */
  0x0000,   /* U+0129 */
  0x0000,   /* U+012A */
  0x0000,   /* U+012B */
  0x0000,   /* U+012C */
  0x0000,   /* U+012D */
  0x0000,   /* U+012E */
  0x0000,   /* U+012F */
  0x0000,   /* U+0130 */
  0x0000,   /* U+0131 */
  0x0000,   /* U+0132 */
  0x0000,   /* U+0133 */
  0x0000,   /* U+0134 */
  0x0000,   /* U+0135 */
  0x0000,   /* U+0136 */
  0x0000,   /* U+0137 */
  0x0000,   /* U+0138 */
  0x0000,   /* U+0139 */
  0x0000,   /* U+013A */
  0x0000,   /* U+013B */
  0x0000,   /* U+013C */
  0x0000,   /* U+013D */
  0x0000,   /* U+013E */
  0x0000,   /* U+013F */
  0x0000,   /* U+0140 */
  0x0000,   /* U+0141 */
  0x0000,   /* U+0142 */
  0x0000,   /* U+0143 */
  0x0000,   /* U+0144 */
  0x0000,   /* U+0145 */
  0x0000,   /* U+0146 */
  0x0000,   /* U+0147 */
  0x0000,   /* U+0148 */
  0x0000,   /* U+0149 */
  0x0000,   /* U+014A */
  0x0000,   /* U+014B */
  0x0000,   /* U+014C */
  0x0000,   /* U+014D */
  0x0000,   /* U+014E */
  0x0000,   /* U+014F */
  0x0000,   /* U+0150 */
  0x0000,   /* U+0151 */
  0x0000,   /* U+0152 */
  0x0000,   /* U+0153 */
  0x0000,   /* U+0154 */
  0x0000,   /* U+0155 */
  0x0000,   /* U+0156 */
  0x0000,   /* U+0157 */
  0x0000,   /* U+0158 */
  0x0000,   /* U+0159 */
  0x0000,   /* U+015A */
  0x0000,   /* U+015B */
  0x0000,   /* U+015C */
  0x0000,   /* U+015D */
  0x0000,   /* U+015E */
  0x0000,   /* U+015F */
  0x0000,   /* U+0160 */
  0x0000,   /* U+0161 */
  0x0000,   /* U+0162 */
  0x0000,   /* U+0163 */
  0x0000,   /* U+0164 */
  0x0000,   /* U+0165 */
  0x0000,   /* U+0166 */
  0x0000,   /* U+0167 */
  0x0000,   /* U+0168 */
  0x0000,   /* U+0169 */
  0x0000,   /* U+016A */
  0x0000,   /* U+016B */
  0x0000,   /* U+016C */
  0x0000,   /* U+016D */
  0x0000,   /* U+016E */
  0x0000,   /* U+016F */
  0x0000,   /* U+0170 */
  0x0000,   /* U+0171 */
  0x0000,   /* U+0172 */
  0x0000,   /* U+0173 */
  0x0000,   /* U+0174 */
  0x0000,   /* U+0175 */
  0x0000,   /* U+0176 */
  0x0000,   /* U+0177 */
  0x0000,   /* U+0178 */
  0x0000,   /* U+0179 */
  0x0000,   /* U+017A */
  0x0000,   /* U+017B */
  0x0000,   /* U+017C */
  0x0000,   /* U+017D */
  0x0000,   /* U+017E */
  0x0000,   /* U+017F */
  0x0000,   /* U+0180 */
  0x0000,   /* U+0181 */
  0x0000,   /* U+0182 */
  0x0000,   /* U+0183 */
  0x0000,   /* U+0184 */
  0x0000,   /* U+0185 */
  0x0000,   /* U+0186 */
  0x0000,   /* U+0187 */
  0x0000,   /* U+0188 */
  0x0000,   /* U+0189 */
  0x0000,   /* U+018A */
  0x0000,   /* U+018B */
  0x0000,   /* U+018C */
  0x0000,   /* U+018D */
  0x0000,   /* U+018E */
  0x0000,   /* U+018F */
  0x0000,   /* U+0190 */
  0x0000,   /* U+0191 */
  0x0000,   /* U+0192 */
  0x0000,   /* U+0193 */
  0x0000,   /* U+0194 */
  0x0000,   /* U+0195 */
  0x0000,   /* U+0196 */
  0x0000,   /* U+0197 */
  0x0000,   /* U+0198 */
  0x0000,   /* U+0199 */
  0x0000,   /* U+019A */
  0x0000,   /* U+019B */
  0x0000,   /* U+019C */
  0x0000,   /* U+019D */
  0x0000,   /* U+019E */
  0x0000,   /* U+019F */
  0x0000,   /* U+01A0 */
  0x0000,   /* U+01A1 */
  0x0000,   /* U+01A2 */
  0x0000,   /* U+01A3 */
  0x0000,   /* U+01A4 */
  0x0000,   /* U+01A5 */
  0x0000,   /* U+01A6 */
  0x0000,   /* U+01A7 */
  0x0000,   /* U+01A8 */
  0x0000,   /* U+01A9 */
  0x0000,   /* U+01AA */
  0x0000,   /* U+01AB */
  0x0000,   /* U+01AC */
  0x0000,   /* U+01AD */
  0x0000,   /* U+01AE */
  0x0000,   /* U+01AF */
  0x0000,   /* U+01B0 */
  0x0000,   /* U+01B1 */
  0x0000,   /* U+01B2 */
  0x0000,   /* U+01B3 */
  0x0000,   /* U+01B4 */
  0x0000,   /* U+01B5 */
  0x0000,   /* U+01B6 */
  0x0000,   /* U+01B7 */
  0x0000,   /* U+01B8 */
  0x0000,   /* U+01B9 */
  0x0000,   /* U+01BA */
  0x0000,   /* U+01BB */
  0x0000,   /* U+01BC */
  0x0000,   /* U+01BD */
  0x0000,   /* U+01BE */
  0x0000,   /* U+01BF */
  0x0000,   /* U+01C0 */
  0x0000,   /* U+01C1 */
  0x0000,   /* U+01C2 */
  0x0000,   /* U+01C3 */
  0x0000,   /* U+01C4 */
  0x0000,   /* U+01C5 */
  0x0000,   /* U+01C6 */
  0x0000,   /* U+01C7 */
  0x0000,   /* U+01C8 */
  0x0000,   /* U+01C9 */
  0x0000,   /* U+01CA */
  0x0000,   /* U+01CB */
  0x0000,   /* U+01CC */
  0x0000,   /* U+01CD */
  0x0000,   /* U+01CE */
  0x0000,   /* U+01CF */
  0x0000,   /* U+01D0 */
  0x0000,   /* U+01D1 */
  0x0000,   /* U+01D2 */
  0x0000,   /* U+01D3 */
  0x0000,   /* U+01D4 */
  0x0000,   /* U+01D5 */
  0x0000,   /* U+01D6 */
  0x0000,   /* U+01D7 */
  0x0000,   /* U+01D8 */
  0x0000,   /* U+01D9 */
  0x0000,   /* U+01DA */
  0x0000,   /* U+01DB */
  0x0000,   /* U+01DC */
  0x0000,   /* U+01DD */
  0x0000,   /* U+01DE */
  0x0000,   /* U+01DF */
  0x0000,   /* U+01E0 */
  0x0000,   /* U+01E1 */
  0x0032,   /* U+01E2 */
  0x0032,   /* U+01E3 */
  0x0000,   /* U+01E4 */
  0x0000,   /* U+01E5 */
  0x0000,   /* U+01E6 */
  0x0000,   /* U+01E7 */
  0x0000,   /* U+01E8 */
  0x0000,   /* U+01E9 */
  0x0000,   /* U+01EA */
  0x0000,   /* U+01EB */
  0x0000,   /* U+01EC */
  0x0000,   /* U+01ED */
  0x0000,   /* U+01EE */
  0x0000,   /* U+01EF */
  0x0000,   /* U+01F0 */
  0x0000,   /* U+01F1 */
  0x0000,   /* U+01F2 */
  0x0000,   /* U+01F3 */
  0x0000,   /* U+01F4 */
  0x0000,   /* U+01F5 */
  0x0000,   /* U+01F6 */
  0x0000,   /* U+01F7 */
  0x0000,   /* U+01F8 */
  0x0000,   /* U+01F9 */
  0x0000,   /* U+01FA */
  0x0000,   /* U+01FB */
  0x0024,   /* U+01FC */
  0x0024,   /* U+01FD */
  0x0000,   /* U+01FE */
  0x0000,   /* U+01FF */

  /* Tertiary weight 4 for each character. */
  0x0000,   /* U+0100 */
  0x0000,   /* U+0101 */
  0x0000,   /* U+0102 */
  0x0000,   /* U+0103 */
  0x0000,   /* U+0104 */
  0x0000,   /* U+0105 */
  0x0000,   /* U+0106 */
  0x0000,   /* U+0107 */
  0x0000,   /* U+0108 */
  0x0000,   /* U+0109 */
  0x0000,   /* U+010A */
  0x0000,   /* U+010B */
  0x0000,   /* U+010C */
  0x0000,   /* U+010D */
  0x0000,   /* U+010E */
  0x0000,   /* U+010F */
  0x0000,   /* U+0110 */
  0x0000,   /* U+0111 */
  0x0000,   /* U+0112 */
  0x0000,   /* U+0113 */
  0x0000,   /* U+0114 */
  0x0000,   /* U+0115 */
  0x0000,   /* U+0116 */
  0x0000,   /* U+0117 */
  0x0000,   /* U+0118 */
  0x0000,   /* U+0119 */
  0x0000,   /* U+011A */
  0x0000,   /* U+011B */
  0x0000,   /* U+011C */
  0x0000,   /* U+011D */
  0x0000,   /* U+011E */
  0x0000,   /* U+011F */
  0x0000,   /* U+0120 */
  0x0000,   /* U+0121 */
  0x0000,   /* U+0122 */
  0x0000,   /* U+0123 */
  0x0000,   /* U+0124 */
  0x0000,   /* U+0125 */
  0x0000,   /* U+0126 */
  0x0000,   /* U+0127 */
  0x0000,   /* U+0128 */
  0x0000,   /* U+0129 */
  0x0000,   /* U+012A */
  0x0000,   /* U+012B */
  0x0000,   /* U+012C */
  0x0000,   /* U+012D */
  0x0000,   /* U+012E */
  0x0000,   /* U+012F */
  0x0000,   /* U+0130 */
  0x0000,   /* U+0131 */
  0x0000,   /* U+0132 */
  0x0000,   /* U+0133 */
  0x0000,   /* U+0134 */
  0x0000,   /* U+0135 */
  0x0000,   /* U+0136 */
  0x0000,   /* U+0137 */
  0x0000,   /* U+0138 */
  0x0000,   /* U+0139 */
  0x0000,   /* U+013A */
  0x0000,   /* U+013B */
  0x0000,   /* U+013C */
  0x0000,   /* U+013D */
  0x0000,   /* U+013E */
  0x0000,   /* U+013F */
  0x0000,   /* U+0140 */
  0x0000,   /* U+0141 */
  0x0000,   /* U+0142 */
  0x0000,   /* U+0143 */
  0x0000,   /* U+0144 */
  0x0000,   /* U+0145 */
  0x0000,   /* U+0146 */
  0x0000,   /* U+0147 */
  0x0000,   /* U+0148 */
  0x0000,   /* U+0149 */
  0x0000,   /* U+014A */
  0x0000,   /* U+014B */
  0x0000,   /* U+014C */
  0x0000,   /* U+014D */
  0x0000,   /* U+014E */
  0x0000,   /* U+014F */
  0x0000,   /* U+0150 */
  0x0000,   /* U+0151 */
  0x0000,   /* U+0152 */
  0x0000,   /* U+0153 */
  0x0000,   /* U+0154 */
  0x0000,   /* U+0155 */
  0x0000,   /* U+0156 */
  0x0000,   /* U+0157 */
  0x0000,   /* U+0158 */
  0x0000,   /* U+0159 */
  0x0000,   /* U+015A */
  0x0000,   /* U+015B */
  0x0000,   /* U+015C */
  0x0000,   /* U+015D */
  0x0000,   /* U+015E */
  0x0000,   /* U+015F */
  0x0000,   /* U+0160 */
  0x0000,   /* U+0161 */
  0x0000,   /* U+0162 */
  0x0000,   /* U+0163 */
  0x0000,   /* U+0164 */
  0x0000,   /* U+0165 */
  0x0000,   /* U+0166 */
  0x0000,   /* U+0167 */
  0x0000,   /* U+0168 */
  0x0000,   /* U+0169 */
  0x0000,   /* U+016A */
  0x0000,   /* U+016B */
  0x0000,   /* U+016C */
  0x0000,   /* U+016D */
  0x0000,   /* U+016E */
  0x0000,   /* U+016F */
  0x0000,   /* U+0170 */
  0x0000,   /* U+0171 */
  0x0000,   /* U+0172 */
  0x0000,   /* U+0173 */
  0x0000,   /* U+0174 */
  0x0000,   /* U+0175 */
  0x0000,   /* U+0176 */
  0x0000,   /* U+0177 */
  0x0000,   /* U+0178 */
  0x0000,   /* U+0179 */
  0x0000,   /* U+017A */
  0x0000,   /* U+017B */
  0x0000,   /* U+017C */
  0x0000,   /* U+017D */
  0x0000,   /* U+017E */
  0x0000,   /* U+017F */
  0x0000,   /* U+0180 */
  0x0000,   /* U+0181 */
  0x0000,   /* U+0182 */
  0x0000,   /* U+0183 */
  0x0000,   /* U+0184 */
  0x0000,   /* U+0185 */
  0x0000,   /* U+0186 */
  0x0000,   /* U+0187 */
  0x0000,   /* U+0188 */
  0x0000,   /* U+0189 */
  0x0000,   /* U+018A */
  0x0000,   /* U+018B */
  0x0000,   /* U+018C */
  0x0000,   /* U+018D */
  0x0000,   /* U+018E */
  0x0000,   /* U+018F */
  0x0000,   /* U+0190 */
  0x0000,   /* U+0191 */
  0x0000,   /* U+0192 */
  0x0000,   /* U+0193 */
  0x0000,   /* U+0194 */
  0x0000,   /* U+0195 */
  0x0000,   /* U+0196 */
  0x0000,   /* U+0197 */
  0x0000,   /* U+0198 */
  0x0000,   /* U+0199 */
  0x0000,   /* U+019A */
  0x0000,   /* U+019B */
  0x0000,   /* U+019C */
  0x0000,   /* U+019D */
  0x0000,   /* U+019E */
  0x0000,   /* U+019F */
  0x0000,   /* U+01A0 */
  0x0000,   /* U+01A1 */
  0x0000,   /* U+01A2 */
  0x0000,   /* U+01A3 */
  0x0000,   /* U+01A4 */
  0x0000,   /* U+01A5 */
  0x0000,   /* U+01A6 */
  0x0000,   /* U+01A7 */
  0x0000,   /* U+01A8 */
  0x0000,   /* U+01A9 */
  0x0000,   /* U+01AA */
  0x0000,   /* U+01AB */
  0x0000,   /* U+01AC */
  0x0000,   /* U+01AD */
  0x0000,   /* U+01AE */
  0x0000,   /* U+01AF */
  0x0000,   /* U+01B0 */
  0x0000,   /* U+01B1 */
  0x0000,   /* U+01B2 */
  0x0000,   /* U+01B3 */
  0x0000,   /* U+01B4 */
  0x0000,   /* U+01B5 */
  0x0000,   /* U+01B6 */
  0x0000,   /* U+01B7 */
  0x0000,   /* U+01B8 */
  0x0000,   /* U+01B9 */
  0x0000,   /* U+01BA */
  0x0000,   /* U+01BB */
  0x0000,   /* U+01BC */
  0x0000,   /* U+01BD */
  0x0000,   /* U+01BE */
  0x0000,   /* U+01BF */
  0x0000,   /* U+01C0 */
  0x0000,   /* U+01C1 */
  0x0000,   /* U+01C2 */
  0x0000,   /* U+01C3 */
  0x0000,   /* U+01C4 */
  0x0000,   /* U+01C5 */
  0x0000,   /* U+01C6 */
  0x0000,   /* U+01C7 */
  0x0000,   /* U+01C8 */
  0x0000,   /* U+01C9 */
  0x0000,   /* U+01CA */
  0x0000,   /* U+01CB */
  0x0000,   /* U+01CC */
  0x0000,   /* U+01CD */
  0x0000,   /* U+01CE */
  0x0000,   /* U+01CF */
  0x0000,   /* U+01D0 */
  0x0000,   /* U+01D1 */
  0x0000,   /* U+01D2 */
  0x0000,   /* U+01D3 */
  0x0000,   /* U+01D4 */
  0x0000,   /* U+01D5 */
  0x0000,   /* U+01D6 */
  0x0000,   /* U+01D7 */
  0x0000,   /* U+01D8 */
  0x0000,   /* U+01D9 */
  0x0000,   /* U+01DA */
  0x0000,   /* U+01DB */
  0x0000,   /* U+01DC */
  0x0000,   /* U+01DD */
  0x0000,   /* U+01DE */
  0x0000,   /* U+01DF */
  0x0000,   /* U+01E0 */
  0x0000,   /* U+01E1 */
  0x0002,   /* U+01E2 */
  0x0002,   /* U+01E3 */
  0x0000,   /* U+01E4 */
  0x0000,   /* U+01E5 */
  0x0000,   /* U+01E6 */
  0x0000,   /* U+01E7 */
  0x0000,   /* U+01E8 */
  0x0000,   /* U+01E9 */
  0x0000,   /* U+01EA */
  0x0000,   /* U+01EB */
  0x0000,   /* U+01EC */
  0x0000,   /* U+01ED */
  0x0000,   /* U+01EE */
  0x0000,   /* U+01EF */
  0x0000,   /* U+01F0 */
  0x0000,   /* U+01F1 */
  0x0000,   /* U+01F2 */
  0x0000,   /* U+01F3 */
  0x0000,   /* U+01F4 */
  0x0000,   /* U+01F5 */
  0x0000,   /* U+01F6 */
  0x0000,   /* U+01F7 */
  0x0000,   /* U+01F8 */
  0x0000,   /* U+01F9 */
  0x0000,   /* U+01FA */
  0x0000,   /* U+01FB */
  0x0002,   /* U+01FC */
  0x0002,   /* U+01FD */
  0x0000,   /* U+01FE */
  0x0000,   /* U+01FF */
};

uint16 uca900_p002[]= {
  /* Number of CEs for each character. */
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 2, 2,
  1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 2, 2,
  3, 3, 2, 2, 1, 1, 1, 1, 2, 2, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,

  /* Primary weight 1 for each character. */
  0x1C47,   /* U+0200 */
  0x1C47,   /* U+0201 */
  0x1C47,   /* U+0202 */
  0x1C47,   /* U+0203 */
  0x1CAA,   /* U+0204 */
  0x1CAA,   /* U+0205 */
  0x1CAA,   /* U+0206 */
  0x1CAA,   /* U+0207 */
  0x1D32,   /* U+0208 */
  0x1D32,   /* U+0209 */
  0x1D32,   /* U+020A */
  0x1D32,   /* U+020B */
  0x1DDD,   /* U+020C */
  0x1DDD,   /* U+020D */
  0x1DDD,   /* U+020E */
  0x1DDD,   /* U+020F */
  0x1E33,   /* U+0210 */
  0x1E33,   /* U+0211 */
  0x1E33,   /* U+0212 */
  0x1E33,   /* U+0213 */
  0x1EB5,   /* U+0214 */
  0x1EB5,   /* U+0215 */
  0x1EB5,   /* U+0216 */
  0x1EB5,   /* U+0217 */
  0x1E71,   /* U+0218 */
  0x1E71,   /* U+0219 */
  0x1E95,   /* U+021A */
  0x1E95,   /* U+021B */
  0x1F1D,   /* U+021C */
  0x1F1D,   /* U+021D */
  0x1D18,   /* U+021E */
  0x1D18,   /* U+021F */
  0x1DC8,   /* U+0220 */
  0x1CA4,   /* U+0221 */
  0x1E07,   /* U+0222 */
  0x1E07,   /* U+0223 */
  0x1F2C,   /* U+0224 */
  0x1F2C,   /* U+0225 */
  0x1C47,   /* U+0226 */
  0x1C47,   /* U+0227 */
  0x1CAA,   /* U+0228 */
  0x1CAA,   /* U+0229 */
  0x1DDD,   /* U+022A */
  0x1DDD,   /* U+022B */
  0x1DDD,   /* U+022C */
  0x1DDD,   /* U+022D */
  0x1DDD,   /* U+022E */
  0x1DDD,   /* U+022F */
  0x1DDD,   /* U+0230 */
  0x1DDD,   /* U+0231 */
  0x1F0B,   /* U+0232 */
  0x1F0B,   /* U+0233 */
  0x1D98,   /* U+0234 */
  0x1DD2,   /* U+0235 */
  0x1EAC,   /* U+0236 */
  0x1D50,   /* U+0237 */
  0x1C8F,   /* U+0238 */
  0x1E21,   /* U+0239 */
  0x1C4C,   /* U+023A */
  0x1C7F,   /* U+023B */
  0x1C7F,   /* U+023C */
  0x1D82,   /* U+023D */
  0x1E9E,   /* U+023E */
  0x1E7C,   /* U+023F */
  0x1F38,   /* U+0240 */
  0x1F79,   /* U+0241 */
  0x1F79,   /* U+0242 */
  0x1C68,   /* U+0243 */
  0x1EC0,   /* U+0244 */
  0x1EF1,   /* U+0245 */
  0x1CB1,   /* U+0246 */
  0x1CB1,   /* U+0247 */
  0x1D55,   /* U+0248 */
  0x1D55,   /* U+0249 */
  0x1E2B,   /* U+024A */
  0x1E2B,   /* U+024B */
  0x1E3F,   /* U+024C */
  0x1E3F,   /* U+024D */
  0x1F13,   /* U+024E */
  0x1F13,   /* U+024F */
  0x1C51,   /* U+0250 */
  0x1C55,   /* U+0251 */
  0x1C5B,   /* U+0252 */
  0x1C71,   /* U+0253 */
  0x1DF0,   /* U+0254 */
  0x1C89,   /* U+0255 */
  0x1C97,   /* U+0256 */
  0x1C9B,   /* U+0257 */
  0x1CC7,   /* U+0258 */
  0x1CBD,   /* U+0259 */
  0x1CCB,   /* U+025A */
  0x1CC2,   /* U+025B */
  0x1CCF,   /* U+025C */
  0x1CD5,   /* U+025D */
  0x1CD9,   /* U+025E */
  0x1D5D,   /* U+025F */
  0x1D06,   /* U+0260 */
  0x1CF8,   /* U+0261 */
  0x1CFD,   /* U+0262 */
  0x1D10,   /* U+0263 */
  0x1CE1,   /* U+0264 */
  0x1EC8,   /* U+0265 */
  0x1D25,   /* U+0266 */
  0x1D2C,   /* U+0267 */
  0x1D41,   /* U+0268 */
  0x1D47,   /* U+0269 */
  0x1D3A,   /* U+026A */
  0x1D87,   /* U+026B */
  0x1D8D,   /* U+026C */
  0x1D93,   /* U+026D */
  0x1D9D,   /* U+026E */
  0x1ED4,   /* U+026F */
  0x1EDA,   /* U+0270 */
  0x1DB1,   /* U+0271 */
  0x1DC4,   /* U+0272 */
  0x1DCE,   /* U+0273 */
  0x1DBD,   /* U+0274 */
  0x1DFD,   /* U+0275 */
  0x1DE4,   /* U+0276 */
  0x1E02,   /* U+0277 */
  0x1E1C,   /* U+0278 */
  0x1E44,   /* U+0279 */
  0x1E49,   /* U+027A */
  0x1E4E,   /* U+027B */
  0x1E53,   /* U+027C */
  0x1E57,   /* U+027D */
  0x1E5C,   /* U+027E */
  0x1E61,   /* U+027F */
  0x1E38,   /* U+0280 */
  0x1E6A,   /* U+0281 */
  0x1E78,   /* U+0282 */
  0x1E82,   /* U+0283 */
  0x1D61,   /* U+0284 */
  0x1E8C,   /* U+0285 */
  0x1E91,   /* U+0286 */
  0x1EB1,   /* U+0287 */
  0x1EA8,   /* U+0288 */
  0x1EC0,   /* U+0289 */
  0x1EDE,   /* U+028A */
  0x1EEA,   /* U+028B */
  0x1EF1,   /* U+028C */
  0x1EFB,   /* U+028D */
  0x1DA6,   /* U+028E */
  0x1F0F,   /* U+028F */
  0x1F30,   /* U+0290 */
  0x1F34,   /* U+0291 */
  0x1F3E,   /* U+0292 */
  0x1F4C,   /* U+0293 */
  0x1F75,   /* U+0294 */
  0x1F84,   /* U+0295 */
  0x1F95,   /* U+0296 */
  0x1FA9,   /* U+0297 */
  0x1FAD,   /* U+0298 */
  0x1C64,   /* U+0299 */
  0x1CDD,   /* U+029A */
  0x1D0A,   /* U+029B */
  0x1D1C,   /* U+029C */
  0x1D59,   /* U+029D */
  0x1D73,   /* U+029E */
  0x1D7B,   /* U+029F */
  0x1E27,   /* U+02A0 */
  0x1F8D,   /* U+02A1 */
  0x1F91,   /* U+02A2 */
  0x1C8F,   /* U+02A3 */
  0x1C8F,   /* U+02A4 */
  0x1C8F,   /* U+02A5 */
  0x1E95,   /* U+02A6 */
  0x1E95,   /* U+02A7 */
  0x1E95,   /* U+02A8 */
  0x1CE5,   /* U+02A9 */
  0x1D77,   /* U+02AA */
  0x1D77,   /* U+02AB */
  0x1FB1,   /* U+02AC */
  0x1FB5,   /* U+02AD */
  0x1ECC,   /* U+02AE */
  0x1ED0,   /* U+02AF */
  0x1D18,   /* U+02B0 */
  0x1D25,   /* U+02B1 */
  0x1D4C,   /* U+02B2 */
  0x1E33,   /* U+02B3 */
  0x1E44,   /* U+02B4 */
  0x1E4E,   /* U+02B5 */
  0x1E6A,   /* U+02B6 */
  0x1EF5,   /* U+02B7 */
  0x1F0B,   /* U+02B8 */
  0x0493,   /* U+02B9 */
  0x0495,   /* U+02BA */
  0x1D30,   /* U+02BB */
  0x1F7E,   /* U+02BC */
  0x1D31,   /* U+02BD */
  0x1F80,   /* U+02BE */
  0x1F88,   /* U+02BF */
  0x1F7D,   /* U+02C0 */
  0x1F89,   /* U+02C1 */
  0x0496,   /* U+02C2 */
  0x0497,   /* U+02C3 */
  0x0498,   /* U+02C4 */
  0x0499,   /* U+02C5 */
  0x049A,   /* U+02C6 */
  0x049B,   /* U+02C7 */
  0x049C,   /* U+02C8 */
  0x049D,   /* U+02C9 */
  0x049E,   /* U+02CA */
  0x049F,   /* U+02CB */
  0x04A0,   /* U+02CC */
  0x04A1,   /* U+02CD */
  0x04A2,   /* U+02CE */
  0x04A3,   /* U+02CF */
  0x1BF8,   /* U+02D0 */
  0x1BF9,   /* U+02D1 */
  0x04A4,   /* U+02D2 */
  0x04A5,   /* U+02D3 */
  0x04A6,   /* U+02D4 */
  0x04A7,   /* U+02D5 */
  0x04A8,   /* U+02D6 */
  0x04A9,   /* U+02D7 */
  0x0487,   /* U+02D8 */
  0x0488,   /* U+02D9 */
  0x048A,   /* U+02DA */
  0x048D,   /* U+02DB */
  0x0484,   /* U+02DC */
  0x048B,   /* U+02DD */
  0x04AA,   /* U+02DE */
  0x04AB,   /* U+02DF */
  0x1D10,   /* U+02E0 */
  0x1D77,   /* U+02E1 */
  0x1E71,   /* U+02E2 */
  0x1EFF,   /* U+02E3 */
  0x1F84,   /* U+02E4 */
  0x04AC,   /* U+02E5 */
  0x04AD,   /* U+02E6 */
  0x04AE,   /* U+02E7 */
  0x04AF,   /* U+02E8 */
  0x04B0,   /* U+02E9 */
  0x04B1,   /* U+02EA */
  0x04B2,   /* U+02EB */
  0x04B3,   /* U+02EC */
  0x04B4,   /* U+02ED */
  0x1F7F,   /* U+02EE */
  0x04B5,   /* U+02EF */
  0x04B6,   /* U+02F0 */
  0x04B7,   /* U+02F1 */
  0x04B8,   /* U+02F2 */
  0x04B9,   /* U+02F3 */
  0x04BA,   /* U+02F4 */
  0x04BB,   /* U+02F5 */
  0x04BC,   /* U+02F6 */
  0x04BD,   /* U+02F7 */
  0x04BE,   /* U+02F8 */
  0x04BF,   /* U+02F9 */
  0x04C0,   /* U+02FA */
  0x04C1,   /* U+02FB */
  0x04C2,   /* U+02FC */
  0x04C3,   /* U+02FD */
  0x04C4,   /* U+02FE */
  0x04C5,   /* U+02FF */

  /* Secondary weight 1 for each character. */
  0x0020,   /* U+0200 */
  0x0020,   /* U+0201 */
  0x0020,   /* U+0202 */
  0x0020,   /* U+0203 */
  0x0020,   /* U+0204 */
  0x0020,   /* U+0205 */
  0x0020,   /* U+0206 */
  0x0020,   /* U+0207 */
  0x0020,   /* U+0208 */
  0x0020,   /* U+0209 */
  0x0020,   /* U+020A */
  0x0020,   /* U+020B */
  0x0020,   /* U+020C */
  0x0020,   /* U+020D */
  0x0020,   /* U+020E */
  0x0020,   /* U+020F */
  0x0020,   /* U+0210 */
  0x0020,   /* U+0211 */
  0x0020,   /* U+0212 */
  0x0020,   /* U+0213 */
  0x0020,   /* U+0214 */
  0x0020,   /* U+0215 */
  0x0020,   /* U+0216 */
  0x0020,   /* U+0217 */
  0x0020,   /* U+0218 */
  0x0020,   /* U+0219 */
  0x0020,   /* U+021A */
  0x0020,   /* U+021B */
  0x0020,   /* U+021C */
  0x0020,   /* U+021D */
  0x0020,   /* U+021E */
  0x0020,   /* U+021F */
  0x0020,   /* U+0220 */
  0x0020,   /* U+0221 */
  0x0020,   /* U+0222 */
  0x0020,   /* U+0223 */
  0x0020,   /* U+0224 */
  0x0020,   /* U+0225 */
  0x0020,   /* U+0226 */
  0x0020,   /* U+0227 */
  0x0020,   /* U+0228 */
  0x0020,   /* U+0229 */
  0x0020,   /* U+022A */
  0x0020,   /* U+022B */
  0x0020,   /* U+022C */
  0x0020,   /* U+022D */
  0x0020,   /* U+022E */
  0x0020,   /* U+022F */
  0x0020,   /* U+0230 */
  0x0020,   /* U+0231 */
  0x0020,   /* U+0232 */
  0x0020,   /* U+0233 */
  0x0020,   /* U+0234 */
  0x0020,   /* U+0235 */
  0x0020,   /* U+0236 */
  0x0020,   /* U+0237 */
  0x0020,   /* U+0238 */
  0x0020,   /* U+0239 */
  0x0020,   /* U+023A */
  0x0020,   /* U+023B */
  0x0020,   /* U+023C */
  0x0020,   /* U+023D */
  0x0020,   /* U+023E */
  0x0020,   /* U+023F */
  0x0020,   /* U+0240 */
  0x0020,   /* U+0241 */
  0x0020,   /* U+0242 */
  0x0020,   /* U+0243 */
  0x0020,   /* U+0244 */
  0x0020,   /* U+0245 */
  0x0020,   /* U+0246 */
  0x0020,   /* U+0247 */
  0x0020,   /* U+0248 */
  0x0020,   /* U+0249 */
  0x0020,   /* U+024A */
  0x0020,   /* U+024B */
  0x0020,   /* U+024C */
  0x0020,   /* U+024D */
  0x0020,   /* U+024E */
  0x0020,   /* U+024F */
  0x0020,   /* U+0250 */
  0x0020,   /* U+0251 */
  0x0020,   /* U+0252 */
  0x0020,   /* U+0253 */
  0x0020,   /* U+0254 */
  0x0020,   /* U+0255 */
  0x0020,   /* U+0256 */
  0x0020,   /* U+0257 */
  0x0020,   /* U+0258 */
  0x0020,   /* U+0259 */
  0x0020,   /* U+025A */
  0x0020,   /* U+025B */
  0x0020,   /* U+025C */
  0x0020,   /* U+025D */
  0x0020,   /* U+025E */
  0x0020,   /* U+025F */
  0x0020,   /* U+0260 */
  0x0020,   /* U+0261 */
  0x0020,   /* U+0262 */
  0x0020,   /* U+0263 */
  0x0020,   /* U+0264 */
  0x0020,   /* U+0265 */
  0x0020,   /* U+0266 */
  0x0020,   /* U+0267 */
  0x0020,   /* U+0268 */
  0x0020,   /* U+0269 */
  0x0020,   /* U+026A */
  0x0020,   /* U+026B */
  0x0020,   /* U+026C */
  0x0020,   /* U+026D */
  0x0020,   /* U+026E */
  0x0020,   /* U+026F */
  0x0020,   /* U+0270 */
  0x0020,   /* U+0271 */
  0x0020,   /* U+0272 */
  0x0020,   /* U+0273 */
  0x0020,   /* U+0274 */
  0x0020,   /* U+0275 */
  0x0020,   /* U+0276 */
  0x0020,   /* U+0277 */
  0x0020,   /* U+0278 */
  0x0020,   /* U+0279 */
  0x0020,   /* U+027A */
  0x0020,   /* U+027B */
  0x0020,   /* U+027C */
  0x0020,   /* U+027D */
  0x0020,   /* U+027E */
  0x0020,   /* U+027F */
  0x0020,   /* U+0280 */
  0x0020,   /* U+0281 */
  0x0020,   /* U+0282 */
  0x0020,   /* U+0283 */
  0x0020,   /* U+0284 */
  0x0020,   /* U+0285 */
  0x0020,   /* U+0286 */
  0x0020,   /* U+0287 */
  0x0020,   /* U+0288 */
  0x0020,   /* U+0289 */
  0x0020,   /* U+028A */
  0x0020,   /* U+028B */
  0x0020,   /* U+028C */
  0x0020,   /* U+028D */
  0x0020,   /* U+028E */
  0x0020,   /* U+028F */
  0x0020,   /* U+0290 */
  0x0020,   /* U+0291 */
  0x0020,   /* U+0292 */
  0x0020,   /* U+0293 */
  0x0020,   /* U+0294 */
  0x0020,   /* U+0295 */
  0x0020,   /* U+0296 */
  0x0020,   /* U+0297 */
  0x0020,   /* U+0298 */
  0x0020,   /* U+0299 */
  0x0020,   /* U+029A */
  0x0020,   /* U+029B */
  0x0020,   /* U+029C */
  0x0020,   /* U+029D */
  0x0020,   /* U+029E */
  0x0020,   /* U+029F */
  0x0020,   /* U+02A0 */
  0x0020,   /* U+02A1 */
  0x0020,   /* U+02A2 */
  0x0020,   /* U+02A3 */
  0x0020,   /* U+02A4 */
  0x0020,   /* U+02A5 */
  0x0020,   /* U+02A6 */
  0x0020,   /* U+02A7 */
  0x0020,   /* U+02A8 */
  0x0020,   /* U+02A9 */
  0x0020,   /* U+02AA */
  0x0020,   /* U+02AB */
  0x0020,   /* U+02AC */
  0x0020,   /* U+02AD */
  0x0020,   /* U+02AE */
  0x0020,   /* U+02AF */
  0x0020,   /* U+02B0 */
  0x0020,   /* U+02B1 */
  0x0020,   /* U+02B2 */
  0x0020,   /* U+02B3 */
  0x0020,   /* U+02B4 */
  0x0020,   /* U+02B5 */
  0x0020,   /* U+02B6 */
  0x0020,   /* U+02B7 */
  0x0020,   /* U+02B8 */
  0x0020,   /* U+02B9 */
  0x0020,   /* U+02BA */
  0x0020,   /* U+02BB */
  0x0020,   /* U+02BC */
  0x0020,   /* U+02BD */
  0x0020,   /* U+02BE */
  0x0020,   /* U+02BF */
  0x0020,   /* U+02C0 */
  0x0020,   /* U+02C1 */
  0x0020,   /* U+02C2 */
  0x0020,   /* U+02C3 */
  0x0020,   /* U+02C4 */
  0x0020,   /* U+02C5 */
  0x0020,   /* U+02C6 */
  0x0020,   /* U+02C7 */
  0x0020,   /* U+02C8 */
  0x0020,   /* U+02C9 */
  0x0020,   /* U+02CA */
  0x0020,   /* U+02CB */
  0x0020,   /* U+02CC */
  0x0020,   /* U+02CD */
  0x0020,   /* U+02CE */
  0x0020,   /* U+02CF */
  0x0020,   /* U+02D0 */
  0x0020,   /* U+02D1 */
  0x0020,   /* U+02D2 */
  0x0020,   /* U+02D3 */
  0x0020,   /* U+02D4 */
  0x0020,   /* U+02D5 */
  0x0020,   /* U+02D6 */
  0x0020,   /* U+02D7 */
  0x0020,   /* U+02D8 */
  0x0020,   /* U+02D9 */
  0x0020,   /* U+02DA */
  0x0020,   /* U+02DB */
  0x0020,   /* U+02DC */
  0x0020,   /* U+02DD */
  0x0020,   /* U+02DE */
  0x0020,   /* U+02DF */
  0x0020,   /* U+02E0 */
  0x0020,   /* U+02E1 */
  0x0020,   /* U+02E2 */
  0x0020,   /* U+02E3 */
  0x0020,   /* U+02E4 */
  0x0020,   /* U+02E5 */
  0x0020,   /* U+02E6 */
  0x0020,   /* U+02E7 */
  0x0020,   /* U+02E8 */
  0x0020,   /* U+02E9 */
  0x0020,   /* U+02EA */
  0x0020,   /* U+02EB */
  0x0020,   /* U+02EC */
  0x0020,   /* U+02ED */
  0x0020,   /* U+02EE */
  0x0020,   /* U+02EF */
  0x0020,   /* U+02F0 */
  0x0020,   /* U+02F1 */
  0x0020,   /* U+02F2 */
  0x0020,   /* U+02F3 */
  0x0020,   /* U+02F4 */
  0x0020,   /* U+02F5 */
  0x0020,   /* U+02F6 */
  0x0020,   /* U+02F7 */
  0x0020,   /* U+02F8 */
  0x0020,   /* U+02F9 */
  0x0020,   /* U+02FA */
  0x0020,   /* U+02FB */
  0x0020,   /* U+02FC */
  0x0020,   /* U+02FD */
  0x0020,   /* U+02FE */
  0x0020,   /* U+02FF */

  /* Tertiary weight 1 for each character. */
  0x0008,   /* U+0200 */
  0x0002,   /* U+0201 */
  0x0008,   /* U+0202 */
  0x0002,   /* U+0203 */
  0x0008,   /* U+0204 */
  0x0002,   /* U+0205 */
  0x0008,   /* U+0206 */
  0x0002,   /* U+0207 */
  0x0008,   /* U+0208 */
  0x0002,   /* U+0209 */
  0x0008,   /* U+020A */
  0x0002,   /* U+020B */
  0x0008,   /* U+020C */
  0x0002,   /* U+020D */
  0x0008,   /* U+020E */
  0x0002,   /* U+020F */
  0x0008,   /* U+0210 */
  0x0002,   /* U+0211 */
  0x0008,   /* U+0212 */
  0x0002,   /* U+0213 */
  0x0008,   /* U+0214 */
  0x0002,   /* U+0215 */
  0x0008,   /* U+0216 */
  0x0002,   /* U+0217 */
  0x0008,   /* U+0218 */
  0x0002,   /* U+0219 */
  0x0008,   /* U+021A */
  0x0002,   /* U+021B */
  0x0008,   /* U+021C */
  0x0002,   /* U+021D */
  0x0008,   /* U+021E */
  0x0002,   /* U+021F */
  0x0008,   /* U+0220 */
  0x0002,   /* U+0221 */
  0x0008,   /* U+0222 */
  0x0002,   /* U+0223 */
  0x0008,   /* U+0224 */
  0x0002,   /* U+0225 */
  0x0008,   /* U+0226 */
  0x0002,   /* U+0227 */
  0x0008,   /* U+0228 */
  0x0002,   /* U+0229 */
  0x0008,   /* U+022A */
  0x0002,   /* U+022B */
  0x0008,   /* U+022C */
  0x0002,   /* U+022D */
  0x0008,   /* U+022E */
  0x0002,   /* U+022F */
  0x0008,   /* U+0230 */
  0x0002,   /* U+0231 */
  0x0008,   /* U+0232 */
  0x0002,   /* U+0233 */
  0x0002,   /* U+0234 */
  0x0002,   /* U+0235 */
  0x0002,   /* U+0236 */
  0x0002,   /* U+0237 */
  0x0004,   /* U+0238 */
  0x0004,   /* U+0239 */
  0x0008,   /* U+023A */
  0x0008,   /* U+023B */
  0x0002,   /* U+023C */
  0x0008,   /* U+023D */
  0x0008,   /* U+023E */
  0x0002,   /* U+023F */
  0x0002,   /* U+0240 */
  0x0008,   /* U+0241 */
  0x0002,   /* U+0242 */
  0x0008,   /* U+0243 */
  0x0008,   /* U+0244 */
  0x0008,   /* U+0245 */
  0x0008,   /* U+0246 */
  0x0002,   /* U+0247 */
  0x0008,   /* U+0248 */
  0x0002,   /* U+0249 */
  0x0008,   /* U+024A */
  0x0002,   /* U+024B */
  0x0008,   /* U+024C */
  0x0002,   /* U+024D */
  0x0008,   /* U+024E */
  0x0002,   /* U+024F */
  0x0002,   /* U+0250 */
  0x0002,   /* U+0251 */
  0x0002,   /* U+0252 */
  0x0002,   /* U+0253 */
  0x0002,   /* U+0254 */
  0x0002,   /* U+0255 */
  0x0002,   /* U+0256 */
  0x0002,   /* U+0257 */
  0x0002,   /* U+0258 */
  0x0002,   /* U+0259 */
  0x0002,   /* U+025A */
  0x0002,   /* U+025B */
  0x0002,   /* U+025C */
  0x0002,   /* U+025D */
  0x0002,   /* U+025E */
  0x0002,   /* U+025F */
  0x0002,   /* U+0260 */
  0x0002,   /* U+0261 */
  0x0002,   /* U+0262 */
  0x0002,   /* U+0263 */
  0x0002,   /* U+0264 */
  0x0002,   /* U+0265 */
  0x0002,   /* U+0266 */
  0x0002,   /* U+0267 */
  0x0002,   /* U+0268 */
  0x0002,   /* U+0269 */
  0x0002,   /* U+026A */
  0x0002,   /* U+026B */
  0x0002,   /* U+026C */
  0x0002,   /* U+026D */
  0x0002,   /* U+026E */
  0x0002,   /* U+026F */
  0x0002,   /* U+0270 */
  0x0002,   /* U+0271 */
  0x0002,   /* U+0272 */
  0x0002,   /* U+0273 */
  0x0002,   /* U+0274 */
  0x0002,   /* U+0275 */
  0x0002,   /* U+0276 */
  0x0002,   /* U+0277 */
  0x0002,   /* U+0278 */
  0x0002,   /* U+0279 */
  0x0002,   /* U+027A */
  0x0002,   /* U+027B */
  0x0002,   /* U+027C */
  0x0002,   /* U+027D */
  0x0002,   /* U+027E */
  0x0002,   /* U+027F */
  0x0002,   /* U+0280 */
  0x0002,   /* U+0281 */
  0x0002,   /* U+0282 */
  0x0002,   /* U+0283 */
  0x0002,   /* U+0284 */
  0x0002,   /* U+0285 */
  0x0002,   /* U+0286 */
  0x0002,   /* U+0287 */
  0x0002,   /* U+0288 */
  0x0002,   /* U+0289 */
  0x0002,   /* U+028A */
  0x0002,   /* U+028B */
  0x0002,   /* U+028C */
  0x0002,   /* U+028D */
  0x0002,   /* U+028E */
  0x0002,   /* U+028F */
  0x0002,   /* U+0290 */
  0x0002,   /* U+0291 */
  0x0002,   /* U+0292 */
  0x0002,   /* U+0293 */
  0x0002,   /* U+0294 */
  0x0002,   /* U+0295 */
  0x0002,   /* U+0296 */
  0x0002,   /* U+0297 */
  0x0002,   /* U+0298 */
  0x0002,   /* U+0299 */
  0x0002,   /* U+029A */
  0x0002,   /* U+029B */
  0x0002,   /* U+029C */
  0x0002,   /* U+029D */
  0x0002,   /* U+029E */
  0x0002,   /* U+029F */
  0x0002,   /* U+02A0 */
  0x0002,   /* U+02A1 */
  0x0002,   /* U+02A2 */
  0x0004,   /* U+02A3 */
  0x0004,   /* U+02A4 */
  0x0004,   /* U+02A5 */
  0x0004,   /* U+02A6 */
  0x0004,   /* U+02A7 */
  0x0004,   /* U+02A8 */
  0x0004,   /* U+02A9 */
  0x0004,   /* U+02AA */
  0x0004,   /* U+02AB */
  0x0002,   /* U+02AC */
  0x0002,   /* U+02AD */
  0x0002,   /* U+02AE */
  0x0002,   /* U+02AF */
  0x0014,   /* U+02B0 */
  0x0014,   /* U+02B1 */
  0x0014,   /* U+02B2 */
  0x0014,   /* U+02B3 */
  0x0014,   /* U+02B4 */
  0x0014,   /* U+02B5 */
  0x0014,   /* U+02B6 */
  0x0014,   /* U+02B7 */
  0x0014,   /* U+02B8 */
  0x0002,   /* U+02B9 */
  0x0002,   /* U+02BA */
  0x0002,   /* U+02BB */
  0x0002,   /* U+02BC */
  0x0002,   /* U+02BD */
  0x0002,   /* U+02BE */
  0x0002,   /* U+02BF */
  0x0002,   /* U+02C0 */
  0x0002,   /* U+02C1 */
  0x0002,   /* U+02C2 */
  0x0002,   /* U+02C3 */
  0x0002,   /* U+02C4 */
  0x0002,   /* U+02C5 */
  0x0002,   /* U+02C6 */
  0x0002,   /* U+02C7 */
  0x0002,   /* U+02C8 */
  0x0002,   /* U+02C9 */
  0x0002,   /* U+02CA */
  0x0002,   /* U+02CB */
  0x0002,   /* U+02CC */
  0x0002,   /* U+02CD */
  0x0002,   /* U+02CE */
  0x0002,   /* U+02CF */
  0x0002,   /* U+02D0 */
  0x0002,   /* U+02D1 */
  0x0002,   /* U+02D2 */
  0x0002,   /* U+02D3 */
  0x0002,   /* U+02D4 */
  0x0002,   /* U+02D5 */
  0x0002,   /* U+02D6 */
  0x0002,   /* U+02D7 */
  0x0002,   /* U+02D8 */
  0x0002,   /* U+02D9 */
  0x0002,   /* U+02DA */
  0x0002,   /* U+02DB */
  0x0002,   /* U+02DC */
  0x0002,   /* U+02DD */
  0x0002,   /* U+02DE */
  0x0002,   /* U+02DF */
  0x0014,   /* U+02E0 */
  0x0014,   /* U+02E1 */
  0x0014,   /* U+02E2 */
  0x0014,   /* U+02E3 */
  0x0014,   /* U+02E4 */
  0x0002,   /* U+02E5 */
  0x0002,   /* U+02E6 */
  0x0002,   /* U+02E7 */
  0x0002,   /* U+02E8 */
  0x0002,   /* U+02E9 */
  0x0002,   /* U+02EA */
  0x0002,   /* U+02EB */
  0x0002,   /* U+02EC */
  0x0002,   /* U+02ED */
  0x0002,   /* U+02EE */
  0x0002,   /* U+02EF */
  0x0002,   /* U+02F0 */
  0x0002,   /* U+02F1 */
  0x0002,   /* U+02F2 */
  0x0002,   /* U+02F3 */
  0x0002,   /* U+02F4 */
  0x0002,   /* U+02F5 */
  0x0002,   /* U+02F6 */
  0x0002,   /* U+02F7 */
  0x0002,   /* U+02F8 */
  0x0002,   /* U+02F9 */
  0x0002,   /* U+02FA */
  0x0002,   /* U+02FB */
  0x0002,   /* U+02FC */
  0x0002,   /* U+02FD */
  0x0002,   /* U+02FE */
  0x0002,   /* U+02FF */

  /* Primary weight 2 for each character. */
  0x0000,   /* U+0200 */
  0x0000,   /* U+0201 */
  0x0000,   /* U+0202 */
  0x0000,   /* U+0203 */
  0x0000,   /* U+0204 */
  0x0000,   /* U+0205 */
  0x0000,   /* U+0206 */
  0x0000,   /* U+0207 */
  0x0000,   /* U+0208 */
  0x0000,   /* U+0209 */
  0x0000,   /* U+020A */
  0x0000,   /* U+020B */
  0x0000,   /* U+020C */
  0x0000,   /* U+020D */
  0x0000,   /* U+020E */
  0x0000,   /* U+020F */
  0x0000,   /* U+0210 */
  0x0000,   /* U+0211 */
  0x0000,   /* U+0212 */
  0x0000,   /* U+0213 */
  0x0000,   /* U+0214 */
  0x0000,   /* U+0215 */
  0x0000,   /* U+0216 */
  0x0000,   /* U+0217 */
  0x0000,   /* U+0218 */
  0x0000,   /* U+0219 */
  0x0000,   /* U+021A */
  0x0000,   /* U+021B */
  0x0000,   /* U+021C */
  0x0000,   /* U+021D */
  0x0000,   /* U+021E */
  0x0000,   /* U+021F */
  0x0000,   /* U+0220 */
  0x0000,   /* U+0221 */
  0x0000,   /* U+0222 */
  0x0000,   /* U+0223 */
  0x0000,   /* U+0224 */
  0x0000,   /* U+0225 */
  0x0000,   /* U+0226 */
  0x0000,   /* U+0227 */
  0x0000,   /* U+0228 */
  0x0000,   /* U+0229 */
  0x0000,   /* U+022A */
  0x0000,   /* U+022B */
  0x0000,   /* U+022C */
  0x0000,   /* U+022D */
  0x0000,   /* U+022E */
  0x0000,   /* U+022F */
  0x0000,   /* U+0230 */
  0x0000,   /* U+0231 */
  0x0000,   /* U+0232 */
  0x0000,   /* U+0233 */
  0x0000,   /* U+0234 */
  0x0000,   /* U+0235 */
  0x0000,   /* U+0236 */
  0x0000,   /* U+0237 */
  0x1C60,   /* U+0238 */
  0x1E0C,   /* U+0239 */
  0x0000,   /* U+023A */
  0x0000,   /* U+023B */
  0x0000,   /* U+023C */
  0x0000,   /* U+023D */
  0x0000,   /* U+023E */
  0x0000,   /* U+023F */
  0x0000,   /* U+0240 */
  0x0000,   /* U+0241 */
  0x0000,   /* U+0242 */
  0x0000,   /* U+0243 */
  0x0000,   /* U+0244 */
  0x0000,   /* U+0245 */
  0x0000,   /* U+0246 */
  0x0000,   /* U+0247 */
  0x0000,   /* U+0248 */
  0x0000,   /* U+0249 */
  0x0000,   /* U+024A */
  0x0000,   /* U+024B */
  0x0000,   /* U+024C */
  0x0000,   /* U+024D */
  0x0000,   /* U+024E */
  0x0000,   /* U+024F */
  0x0000,   /* U+0250 */
  0x0000,   /* U+0251 */
  0x0000,   /* U+0252 */
  0x0000,   /* U+0253 */
  0x0000,   /* U+0254 */
  0x0000,   /* U+0255 */
  0x0000,   /* U+0256 */
  0x0000,   /* U+0257 */
  0x0000,   /* U+0258 */
  0x0000,   /* U+0259 */
  0x0000,   /* U+025A */
  0x0000,   /* U+025B */
  0x0000,   /* U+025C */
  0x0000,   /* U+025D */
  0x0000,   /* U+025E */
  0x0000,   /* U+025F */
  0x0000,   /* U+0260 */
  0x0000,   /* U+0261 */
  0x0000,   /* U+0262 */
  0x0000,   /* U+0263 */
  0x0000,   /* U+0264 */
  0x0000,   /* U+0265 */
  0x0000,   /* U+0266 */
  0x0000,   /* U+0267 */
  0x0000,   /* U+0268 */
  0x0000,   /* U+0269 */
  0x0000,   /* U+026A */
  0x0000,   /* U+026B */
  0x0000,   /* U+026C */
  0x0000,   /* U+026D */
  0x0000,   /* U+026E */
  0x0000,   /* U+026F */
  0x0000,   /* U+0270 */
  0x0000,   /* U+0271 */
  0x0000,   /* U+0272 */
  0x0000,   /* U+0273 */
  0x0000,   /* U+0274 */
  0x0000,   /* U+0275 */
  0x0000,   /* U+0276 */
  0x0000,   /* U+0277 */
  0x0000,   /* U+0278 */
  0x0000,   /* U+0279 */
  0x0000,   /* U+027A */
  0x0000,   /* U+027B */
  0x0000,   /* U+027C */
  0x0000,   /* U+027D */
  0x0000,   /* U+027E */
  0x0000,   /* U+027F */
  0x0000,   /* U+0280 */
  0x0000,   /* U+0281 */
  0x0000,   /* U+0282 */
  0x0000,   /* U+0283 */
  0x0000,   /* U+0284 */
  0x0000,   /* U+0285 */
  0x0000,   /* U+0286 */
  0x0000,   /* U+0287 */
  0x0000,   /* U+0288 */
  0x0000,   /* U+0289 */
  0x0000,   /* U+028A */
  0x0000,   /* U+028B */
  0x0000,   /* U+028C */
  0x0000,   /* U+028D */
  0x0000,   /* U+028E */
  0x0000,   /* U+028F */
  0x0000,   /* U+0290 */
  0x0000,   /* U+0291 */
  0x0000,   /* U+0292 */
  0x0000,   /* U+0293 */
  0x0000,   /* U+0294 */
  0x0000,   /* U+0295 */
  0x0000,   /* U+0296 */
  0x0000,   /* U+0297 */
  0x0000,   /* U+0298 */
  0x0000,   /* U+0299 */
  0x0000,   /* U+029A */
  0x0000,   /* U+029B */
  0x0000,   /* U+029C */
  0x0000,   /* U+029D */
  0x0000,   /* U+029E */
  0x0000,   /* U+029F */
  0x0000,   /* U+02A0 */
  0x0000,   /* U+02A1 */
  0x0000,   /* U+02A2 */
  0x1F21,   /* U+02A3 */
  0x1F3E,   /* U+02A4 */
  0x1F34,   /* U+02A5 */
  0x1E71,   /* U+02A6 */
  0x1E82,   /* U+02A7 */
  0x1C89,   /* U+02A8 */
  0x1DD8,   /* U+02A9 */
  0x1E71,   /* U+02AA */
  0x1F21,   /* U+02AB */
  0x0000,   /* U+02AC */
  0x0000,   /* U+02AD */
  0x0000,   /* U+02AE */
  0x0000,   /* U+02AF */
  0x0000,   /* U+02B0 */
  0x0000,   /* U+02B1 */
  0x0000,   /* U+02B2 */
  0x0000,   /* U+02B3 */
  0x0000,   /* U+02B4 */
  0x0000,   /* U+02B5 */
  0x0000,   /* U+02B6 */
  0x0000,   /* U+02B7 */
  0x0000,   /* U+02B8 */
  0x0000,   /* U+02B9 */
  0x0000,   /* U+02BA */
  0x0000,   /* U+02BB */
  0x0000,   /* U+02BC */
  0x0000,   /* U+02BD */
  0x0000,   /* U+02BE */
  0x0000,   /* U+02BF */
  0x0000,   /* U+02C0 */
  0x0000,   /* U+02C1 */
  0x0000,   /* U+02C2 */
  0x0000,   /* U+02C3 */
  0x0000,   /* U+02C4 */
  0x0000,   /* U+02C5 */
  0x0000,   /* U+02C6 */
  0x0000,   /* U+02C7 */
  0x0000,   /* U+02C8 */
  0x0000,   /* U+02C9 */
  0x0000,   /* U+02CA */
  0x0000,   /* U+02CB */
  0x0000,   /* U+02CC */
  0x0000,   /* U+02CD */
  0x0000,   /* U+02CE */
  0x0000,   /* U+02CF */
  0x0000,   /* U+02D0 */
  0x0000,   /* U+02D1 */
  0x0000,   /* U+02D2 */
  0x0000,   /* U+02D3 */
  0x0000,   /* U+02D4 */
  0x0000,   /* U+02D5 */
  0x0000,   /* U+02D6 */
  0x0000,   /* U+02D7 */
  0x0000,   /* U+02D8 */
  0x0000,   /* U+02D9 */
  0x0000,   /* U+02DA */
  0x0000,   /* U+02DB */
  0x0000,   /* U+02DC */
  0x0000,   /* U+02DD */
  0x0000,   /* U+02DE */
  0x0000,   /* U+02DF */
  0x0000,   /* U+02E0 */
  0x0000,   /* U+02E1 */
  0x0000,   /* U+02E2 */
  0x0000,   /* U+02E3 */
  0x0000,   /* U+02E4 */
  0x0000,   /* U+02E5 */
  0x0000,   /* U+02E6 */
  0x0000,   /* U+02E7 */
  0x0000,   /* U+02E8 */
  0x0000,   /* U+02E9 */
  0x0000,   /* U+02EA */
  0x0000,   /* U+02EB */
  0x0000,   /* U+02EC */
  0x0000,   /* U+02ED */
  0x0000,   /* U+02EE */
  0x0000,   /* U+02EF */
  0x0000,   /* U+02F0 */
  0x0000,   /* U+02F1 */
  0x0000,   /* U+02F2 */
  0x0000,   /* U+02F3 */
  0x0000,   /* U+02F4 */
  0x0000,   /* U+02F5 */
  0x0000,   /* U+02F6 */
  0x0000,   /* U+02F7 */
  0x0000,   /* U+02F8 */
  0x0000,   /* U+02F9 */
  0x0000,   /* U+02FA */
  0x0000,   /* U+02FB */
  0x0000,   /* U+02FC */
  0x0000,   /* U+02FD */
  0x0000,   /* U+02FE */
  0x0000,   /* U+02FF */

  /* Secondary weight 2 for each character. */
  0x003C,   /* U+0200 */
  0x003C,   /* U+0201 */
  0x003E,   /* U+0202 */
  0x003E,   /* U+0203 */
  0x003C,   /* U+0204 */
  0x003C,   /* U+0205 */
  0x003E,   /* U+0206 */
  0x003E,   /* U+0207 */
  0x003C,   /* U+0208 */
  0x003C,   /* U+0209 */
  0x003E,   /* U+020A */
  0x003E,   /* U+020B */
  0x003C,   /* U+020C */
  0x003C,   /* U+020D */
  0x003E,   /* U+020E */
  0x003E,   /* U+020F */
  0x003C,   /* U+0210 */
  0x003C,   /* U+0211 */
  0x003E,   /* U+0212 */
  0x003E,   /* U+0213 */
  0x003C,   /* U+0214 */
  0x003C,   /* U+0215 */
  0x003E,   /* U+0216 */
  0x003E,   /* U+0217 */
  0x0045,   /* U+0218 */
  0x0045,   /* U+0219 */
  0x0045,   /* U+021A */
  0x0045,   /* U+021B */
  0x0000,   /* U+021C */
  0x0000,   /* U+021D */
  0x0028,   /* U+021E */
  0x0028,   /* U+021F */
  0x0000,   /* U+0220 */
  0x0000,   /* U+0221 */
  0x0000,   /* U+0222 */
  0x0000,   /* U+0223 */
  0x0000,   /* U+0224 */
  0x0000,   /* U+0225 */
  0x002E,   /* U+0226 */
  0x002E,   /* U+0227 */
  0x0030,   /* U+0228 */
  0x0030,   /* U+0229 */
  0x002B,   /* U+022A */
  0x002B,   /* U+022B */
  0x002D,   /* U+022C */
  0x002D,   /* U+022D */
  0x002E,   /* U+022E */
  0x002E,   /* U+022F */
  0x002E,   /* U+0230 */
  0x002E,   /* U+0231 */
  0x0032,   /* U+0232 */
  0x0032,   /* U+0233 */
  0x0000,   /* U+0234 */
  0x0000,   /* U+0235 */
  0x0000,   /* U+0236 */
  0x0000,   /* U+0237 */
  0x0020,   /* U+0238 */
  0x0020,   /* U+0239 */
  0x0000,   /* U+023A */
  0x0000,   /* U+023B */
  0x0000,   /* U+023C */
  0x0000,   /* U+023D */
  0x0000,   /* U+023E */
  0x0000,   /* U+023F */
  0x0000,   /* U+0240 */
  0x0000,   /* U+0241 */
  0x0000,   /* U+0242 */
  0x0000,   /* U+0243 */
  0x0000,   /* U+0244 */
  0x0000,   /* U+0245 */
  0x0000,   /* U+0246 */
  0x0000,   /* U+0247 */
  0x0000,   /* U+0248 */
  0x0000,   /* U+0249 */
  0x0000,   /* U+024A */
  0x0000,   /* U+024B */
  0x0000,   /* U+024C */
  0x0000,   /* U+024D */
  0x0000,   /* U+024E */
  0x0000,   /* U+024F */
  0x0000,   /* U+0250 */
  0x0000,   /* U+0251 */
  0x0000,   /* U+0252 */
  0x0000,   /* U+0253 */
  0x0000,   /* U+0254 */
  0x0000,   /* U+0255 */
  0x0000,   /* U+0256 */
  0x0000,   /* U+0257 */
  0x0000,   /* U+0258 */
  0x0000,   /* U+0259 */
  0x0000,   /* U+025A */
  0x0000,   /* U+025B */
  0x0000,   /* U+025C */
  0x0000,   /* U+025D */
  0x0000,   /* U+025E */
  0x0000,   /* U+025F */
  0x0000,   /* U+0260 */
  0x0000,   /* U+0261 */
  0x0000,   /* U+0262 */
  0x0000,   /* U+0263 */
  0x0000,   /* U+0264 */
  0x0000,   /* U+0265 */
  0x0000,   /* U+0266 */
  0x0000,   /* U+0267 */
  0x0000,   /* U+0268 */
  0x0000,   /* U+0269 */
  0x0000,   /* U+026A */
  0x0000,   /* U+026B */
  0x0000,   /* U+026C */
  0x0000,   /* U+026D */
  0x0000,   /* U+026E */
  0x0000,   /* U+026F */
  0x0000,   /* U+0270 */
  0x0000,   /* U+0271 */
  0x0000,   /* U+0272 */
  0x0000,   /* U+0273 */
  0x0000,   /* U+0274 */
  0x0000,   /* U+0275 */
  0x0000,   /* U+0276 */
  0x0000,   /* U+0277 */
  0x0000,   /* U+0278 */
  0x0000,   /* U+0279 */
  0x0000,   /* U+027A */
  0x0000,   /* U+027B */
  0x0000,   /* U+027C */
  0x0000,   /* U+027D */
  0x0000,   /* U+027E */
  0x0000,   /* U+027F */
  0x0000,   /* U+0280 */
  0x0000,   /* U+0281 */
  0x0000,   /* U+0282 */
  0x0000,   /* U+0283 */
  0x0000,   /* U+0284 */
  0x0000,   /* U+0285 */
  0x0000,   /* U+0286 */
  0x0000,   /* U+0287 */
  0x0000,   /* U+0288 */
  0x0000,   /* U+0289 */
  0x0000,   /* U+028A */
  0x0000,   /* U+028B */
  0x0000,   /* U+028C */
  0x0000,   /* U+028D */
  0x0000,   /* U+028E */
  0x0000,   /* U+028F */
  0x0000,   /* U+0290 */
  0x0000,   /* U+0291 */
  0x0000,   /* U+0292 */
  0x0000,   /* U+0293 */
  0x0000,   /* U+0294 */
  0x0000,   /* U+0295 */
  0x0000,   /* U+0296 */
  0x0000,   /* U+0297 */
  0x0000,   /* U+0298 */
  0x0000,   /* U+0299 */
  0x0000,   /* U+029A */
  0x0000,   /* U+029B */
  0x0000,   /* U+029C */
  0x0000,   /* U+029D */
  0x0000,   /* U+029E */
  0x0000,   /* U+029F */
  0x0000,   /* U+02A0 */
  0x0000,   /* U+02A1 */
  0x0000,   /* U+02A2 */
  0x0020,   /* U+02A3 */
  0x0020,   /* U+02A4 */
  0x0020,   /* U+02A5 */
  0x0020,   /* U+02A6 */
  0x0020,   /* U+02A7 */
  0x0020,   /* U+02A8 */
  0x0020,   /* U+02A9 */
  0x0020,   /* U+02AA */
  0x0020,   /* U+02AB */
  0x0000,   /* U+02AC */
  0x0000,   /* U+02AD */
  0x0000,   /* U+02AE */
  0x0000,   /* U+02AF */
  0x0000,   /* U+02B0 */
  0x0000,   /* U+02B1 */
  0x0000,   /* U+02B2 */
  0x0000,   /* U+02B3 */
  0x0000,   /* U+02B4 */
  0x0000,   /* U+02B5 */
  0x0000,   /* U+02B6 */
  0x0000,   /* U+02B7 */
  0x0000,   /* U+02B8 */
  0x0000,   /* U+02B9 */
  0x0000,   /* U+02BA */
  0x0000,   /* U+02BB */
  0x0000,   /* U+02BC */
  0x0000,   /* U+02BD */
  0x0000,   /* U+02BE */
  0x0000,   /* U+02BF */
  0x0000,   /* U+02C0 */
  0x0000,   /* U+02C1 */
  0x0000,   /* U+02C2 */
  0x0000,   /* U+02C3 */
  0x0000,   /* U+02C4 */
  0x0000,   /* U+02C5 */
  0x0000,   /* U+02C6 */
  0x0000,   /* U+02C7 */
  0x0000,   /* U+02C8 */
  0x0000,   /* U+02C9 */
  0x0000,   /* U+02CA */
  0x0000,   /* U+02CB */
  0x0000,   /* U+02CC */
  0x0000,   /* U+02CD */
  0x0000,   /* U+02CE */
  0x0000,   /* U+02CF */
  0x0000,   /* U+02D0 */
  0x0000,   /* U+02D1 */
  0x0000,   /* U+02D2 */
  0x0000,   /* U+02D3 */
  0x0000,   /* U+02D4 */
  0x0000,   /* U+02D5 */
  0x0000,   /* U+02D6 */
  0x0000,   /* U+02D7 */
  0x0000,   /* U+02D8 */
  0x0000,   /* U+02D9 */
  0x0000,   /* U+02DA */
  0x0000,   /* U+02DB */
  0x0000,   /* U+02DC */
  0x0000,   /* U+02DD */
  0x0000,   /* U+02DE */
  0x0000,   /* U+02DF */
  0x0000,   /* U+02E0 */
  0x0000,   /* U+02E1 */
  0x0000,   /* U+02E2 */
  0x0000,   /* U+02E3 */
  0x0000,   /* U+02E4 */
  0x0000,   /* U+02E5 */
  0x0000,   /* U+02E6 */
  0x0000,   /* U+02E7 */
  0x0000,   /* U+02E8 */
  0x0000,   /* U+02E9 */
  0x0000,   /* U+02EA */
  0x0000,   /* U+02EB */
  0x0000,   /* U+02EC */
  0x0000,   /* U+02ED */
  0x0000,   /* U+02EE */
  0x0000,   /* U+02EF */
  0x0000,   /* U+02F0 */
  0x0000,   /* U+02F1 */
  0x0000,   /* U+02F2 */
  0x0000,   /* U+02F3 */
  0x0000,   /* U+02F4 */
  0x0000,   /* U+02F5 */
  0x0000,   /* U+02F6 */
  0x0000,   /* U+02F7 */
  0x0000,   /* U+02F8 */
  0x0000,   /* U+02F9 */
  0x0000,   /* U+02FA */
  0x0000,   /* U+02FB */
  0x0000,   /* U+02FC */
  0x0000,   /* U+02FD */
  0x0000,   /* U+02FE */
  0x0000,   /* U+02FF */

  /* Tertiary weight 2 for each character. */
  0x0002,   /* U+0200 */
  0x0002,   /* U+0201 */
  0x0002,   /* U+0202 */
  0x0002,   /* U+0203 */
  0x0002,   /* U+0204 */
  0x0002,   /* U+0205 */
  0x0002,   /* U+0206 */
  0x0002,   /* U+0207 */
  0x0002,   /* U+0208 */
  0x0002,   /* U+0209 */
  0x0002,   /* U+020A */
  0x0002,   /* U+020B */
  0x0002,   /* U+020C */
  0x0002,   /* U+020D */
  0x0002,   /* U+020E */
  0x0002,   /* U+020F */
  0x0002,   /* U+0210 */
  0x0002,   /* U+0211 */
  0x0002,   /* U+0212 */
  0x0002,   /* U+0213 */
  0x0002,   /* U+0214 */
  0x0002,   /* U+0215 */
  0x0002,   /* U+0216 */
  0x0002,   /* U+0217 */
  0x0002,   /* U+0218 */
  0x0002,   /* U+0219 */
  0x0002,   /* U+021A */
  0x0002,   /* U+021B */
  0x0000,   /* U+021C */
  0x0000,   /* U+021D */
  0x0002,   /* U+021E */
  0x0002,   /* U+021F */
  0x0000,   /* U+0220 */
  0x0000,   /* U+0221 */
  0x0000,   /* U+0222 */
  0x0000,   /* U+0223 */
  0x0000,   /* U+0224 */
  0x0000,   /* U+0225 */
  0x0002,   /* U+0226 */
  0x0002,   /* U+0227 */
  0x0002,   /* U+0228 */
  0x0002,   /* U+0229 */
  0x0002,   /* U+022A */
  0x0002,   /* U+022B */
  0x0002,   /* U+022C */
  0x0002,   /* U+022D */
  0x0002,   /* U+022E */
  0x0002,   /* U+022F */
  0x0002,   /* U+0230 */
  0x0002,   /* U+0231 */
  0x0002,   /* U+0232 */
  0x0002,   /* U+0233 */
  0x0000,   /* U+0234 */
  0x0000,   /* U+0235 */
  0x0000,   /* U+0236 */
  0x0000,   /* U+0237 */
  0x0004,   /* U+0238 */
  0x0004,   /* U+0239 */
  0x0000,   /* U+023A */
  0x0000,   /* U+023B */
  0x0000,   /* U+023C */
  0x0000,   /* U+023D */
  0x0000,   /* U+023E */
  0x0000,   /* U+023F */
  0x0000,   /* U+0240 */
  0x0000,   /* U+0241 */
  0x0000,   /* U+0242 */
  0x0000,   /* U+0243 */
  0x0000,   /* U+0244 */
  0x0000,   /* U+0245 */
  0x0000,   /* U+0246 */
  0x0000,   /* U+0247 */
  0x0000,   /* U+0248 */
  0x0000,   /* U+0249 */
  0x0000,   /* U+024A */
  0x0000,   /* U+024B */
  0x0000,   /* U+024C */
  0x0000,   /* U+024D */
  0x0000,   /* U+024E */
  0x0000,   /* U+024F */
  0x0000,   /* U+0250 */
  0x0000,   /* U+0251 */
  0x0000,   /* U+0252 */
  0x0000,   /* U+0253 */
  0x0000,   /* U+0254 */
  0x0000,   /* U+0255 */
  0x0000,   /* U+0256 */
  0x0000,   /* U+0257 */
  0x0000,   /* U+0258 */
  0x0000,   /* U+0259 */
  0x0000,   /* U+025A */
  0x0000,   /* U+025B */
  0x0000,   /* U+025C */
  0x0000,   /* U+025D */
  0x0000,   /* U+025E */
  0x0000,   /* U+025F */
  0x0000,   /* U+0260 */
  0x0000,   /* U+0261 */
  0x0000,   /* U+0262 */
  0x0000,   /* U+0263 */
  0x0000,   /* U+0264 */
  0x0000,   /* U+0265 */
  0x0000,   /* U+0266 */
  0x0000,   /* U+0267 */
  0x0000,   /* U+0268 */
  0x0000,   /* U+0269 */
  0x0000,   /* U+026A */
  0x0000,   /* U+026B */
  0x0000,   /* U+026C */
  0x0000,   /* U+026D */
  0x0000,   /* U+026E */
  0x0000,   /* U+026F */
  0x0000,   /* U+0270 */
  0x0000,   /* U+0271 */
  0x0000,   /* U+0272 */
  0x0000,   /* U+0273 */
  0x0000,   /* U+0274 */
  0x0000,   /* U+0275 */
  0x0000,   /* U+0276 */
  0x0000,   /* U+0277 */
  0x0000,   /* U+0278 */
  0x0000,   /* U+0279 */
  0x0000,   /* U+027A */
  0x0000,   /* U+027B */
  0x0000,   /* U+027C */
  0x0000,   /* U+027D */
  0x0000,   /* U+027E */
  0x0000,   /* U+027F */
  0x0000,   /* U+0280 */
  0x0000,   /* U+0281 */
  0x0000,   /* U+0282 */
  0x0000,   /* U+0283 */
  0x0000,   /* U+0284 */
  0x0000,   /* U+0285 */
  0x0000,   /* U+0286 */
  0x0000,   /* U+0287 */
  0x0000,   /* U+0288 */
  0x0000,   /* U+0289 */
  0x0000,   /* U+028A */
  0x0000,   /* U+028B */
  0x0000,   /* U+028C */
  0x0000,   /* U+028D */
  0x0000,   /* U+028E */
  0x0000,   /* U+028F */
  0x0000,   /* U+0290 */
  0x0000,   /* U+0291 */
  0x0000,   /* U+0292 */
  0x0000,   /* U+0293 */
  0x0000,   /* U+0294 */
  0x0000,   /* U+0295 */
  0x0000,   /* U+0296 */
  0x0000,   /* U+0297 */
  0x0000,   /* U+0298 */
  0x0000,   /* U+0299 */
  0x0000,   /* U+029A */
  0x0000,   /* U+029B */
  0x0000,   /* U+029C */
  0x0000,   /* U+029D */
  0x0000,   /* U+029E */
  0x0000,   /* U+029F */
  0x0000,   /* U+02A0 */
  0x0000,   /* U+02A1 */
  0x0000,   /* U+02A2 */
  0x0004,   /* U+02A3 */
  0x0004,   /* U+02A4 */
  0x0004,   /* U+02A5 */
  0x0004,   /* U+02A6 */
  0x0004,   /* U+02A7 */
  0x0004,   /* U+02A8 */
  0x0004,   /* U+02A9 */
  0x0004,   /* U+02AA */
  0x0004,   /* U+02AB */
  0x0000,   /* U+02AC */
  0x0000,   /* U+02AD */
  0x0000,   /* U+02AE */
  0x0000,   /* U+02AF */
  0x0000,   /* U+02B0 */
  0x0000,   /* U+02B1 */
  0x0000,   /* U+02B2 */
  0x0000,   /* U+02B3 */
  0x0000,   /* U+02B4 */
  0x0000,   /* U+02B5 */
  0x0000,   /* U+02B6 */
  0x0000,   /* U+02B7 */
  0x0000,   /* U+02B8 */
  0x0000,   /* U+02B9 */
  0x0000,   /* U+02BA */
  0x0000,   /* U+02BB */
  0x0000,   /* U+02BC */
  0x0000,   /* U+02BD */
  0x0000,   /* U+02BE */
  0x0000,   /* U+02BF */
  0x0000,   /* U+02C0 */
  0x0000,   /* U+02C1 */
  0x0000,   /* U+02C2 */
  0x0000,   /* U+02C3 */
  0x0000,   /* U+02C4 */
  0x0000,   /* U+02C5 */
  0x0000,   /* U+02C6 */
  0x0000,   /* U+02C7 */
  0x0000,   /* U+02C8 */
  0x0000,   /* U+02C9 */
  0x0000,   /* U+02CA */
  0x0000,   /* U+02CB */
  0x0000,   /* U+02CC */
  0x0000,   /* U+02CD */
  0x0000,   /* U+02CE */
  0x0000,   /* U+02CF */
  0x0000,   /* U+02D0 */
  0x0000,   /* U+02D1 */
  0x0000,   /* U+02D2 */
  0x0000,   /* U+02D3 */
  0x0000,   /* U+02D4 */
  0x0000,   /* U+02D5 */
  0x0000,   /* U+02D6 */
  0x0000,   /* U+02D7 */
  0x0000,   /* U+02D8 */
  0x0000,   /* U+02D9 */
  0x0000,   /* U+02DA */
  0x0000,   /* U+02DB */
  0x0000,   /* U+02DC */
  0x0000,   /* U+02DD */
  0x0000,   /* U+02DE */
  0x0000,   /* U+02DF */
  0x0000,   /* U+02E0 */
  0x0000,   /* U+02E1 */
  0x0000,   /* U+02E2 */
  0x0000,   /* U+02E3 */
  0x0000,   /* U+02E4 */
  0x0000,   /* U+02E5 */
  0x0000,   /* U+02E6 */
  0x0000,   /* U+02E7 */
  0x0000,   /* U+02E8 */
  0x0000,   /* U+02E9 */
  0x0000,   /* U+02EA */
  0x0000,   /* U+02EB */
  0x0000,   /* U+02EC */
  0x0000,   /* U+02ED */
  0x0000,   /* U+02EE */
  0x0000,   /* U+02EF */
  0x0000,   /* U+02F0 */
  0x0000,   /* U+02F1 */
  0x0000,   /* U+02F2 */
  0x0000,   /* U+02F3 */
  0x0000,   /* U+02F4 */
  0x0000,   /* U+02F5 */
  0x0000,   /* U+02F6 */
  0x0000,   /* U+02F7 */
  0x0000,   /* U+02F8 */
  0x0000,   /* U+02F9 */
  0x0000,   /* U+02FA */
  0x0000,   /* U+02FB */
  0x0000,   /* U+02FC */
  0x0000,   /* U+02FD */
  0x0000,   /* U+02FE */
  0x0000,   /* U+02FF */

  /* Primary weight 3 for each character. */
  0x0000,   /* U+0200 */
  0x0000,   /* U+0201 */
  0x0000,   /* U+0202 */
  0x0000,   /* U+0203 */
  0x0000,   /* U+0204 */
  0x0000,   /* U+0205 */
  0x0000,   /* U+0206 */
  0x0000,   /* U+0207 */
  0x0000,   /* U+0208 */
  0x0000,   /* U+0209 */
  0x0000,   /* U+020A */
  0x0000,   /* U+020B */
  0x0000,   /* U+020C */
  0x0000,   /* U+020D */
  0x0000,   /* U+020E */
  0x0000,   /* U+020F */
  0x0000,   /* U+0210 */
  0x0000,   /* U+0211 */
  0x0000,   /* U+0212 */
  0x0000,   /* U+0213 */
  0x0000,   /* U+0214 */
  0x0000,   /* U+0215 */
  0x0000,   /* U+0216 */
  0x0000,   /* U+0217 */
  0x0000,   /* U+0218 */
  0x0000,   /* U+0219 */
  0x0000,   /* U+021A */
  0x0000,   /* U+021B */
  0x0000,   /* U+021C */
  0x0000,   /* U+021D */
  0x0000,   /* U+021E */
  0x0000,   /* U+021F */
  0x0000,   /* U+0220 */
  0x0000,   /* U+0221 */
  0x0000,   /* U+0222 */
  0x0000,   /* U+0223 */
  0x0000,   /* U+0224 */
  0x0000,   /* U+0225 */
  0x0000,   /* U+0226 */
  0x0000,   /* U+0227 */
  0x0000,   /* U+0228 */
  0x0000,   /* U+0229 */
  0x0000,   /* U+022A */
  0x0000,   /* U+022B */
  0x0000,   /* U+022C */
  0x0000,   /* U+022D */
  0x0000,   /* U+022E */
  0x0000,   /* U+022F */
  0x0000,   /* U+0230 */
  0x0000,   /* U+0231 */
  0x0000,   /* U+0232 */
  0x0000,   /* U+0233 */
  0x0000,   /* U+0234 */
  0x0000,   /* U+0235 */
  0x0000,   /* U+0236 */
  0x0000,   /* U+0237 */
  0x0000,   /* U+0238 */
  0x0000,   /* U+0239 */
  0x0000,   /* U+023A */
  0x0000,   /* U+023B */
  0x0000,   /* U+023C */
  0x0000,   /* U+023D */
  0x0000,   /* U+023E */
  0x0000,   /* U+023F */
  0x0000,   /* U+0240 */
  0x0000,   /* U+0241 */
  0x0000,   /* U+0242 */
  0x0000,   /* U+0243 */
  0x0000,   /* U+0244 */
  0x0000,   /* U+0245 */
  0x0000,   /* U+0246 */
  0x0000,   /* U+0247 */
  0x0000,   /* U+0248 */
  0x0000,   /* U+0249 */
  0x0000,   /* U+024A */
  0x0000,   /* U+024B */
  0x0000,   /* U+024C */
  0x0000,   /* U+024D */
  0x0000,   /* U+024E */
  0x0000,   /* U+024F */
  0x0000,   /* U+0250 */
  0x0000,   /* U+0251 */
  0x0000,   /* U+0252 */
  0x0000,   /* U+0253 */
  0x0000,   /* U+0254 */
  0x0000,   /* U+0255 */
  0x0000,   /* U+0256 */
  0x0000,   /* U+0257 */
  0x0000,   /* U+0258 */
  0x0000,   /* U+0259 */
  0x0000,   /* U+025A */
  0x0000,   /* U+025B */
  0x0000,   /* U+025C */
  0x0000,   /* U+025D */
  0x0000,   /* U+025E */
  0x0000,   /* U+025F */
  0x0000,   /* U+0260 */
  0x0000,   /* U+0261 */
  0x0000,   /* U+0262 */
  0x0000,   /* U+0263 */
  0x0000,   /* U+0264 */
  0x0000,   /* U+0265 */
  0x0000,   /* U+0266 */
  0x0000,   /* U+0267 */
  0x0000,   /* U+0268 */
  0x0000,   /* U+0269 */
  0x0000,   /* U+026A */
  0x0000,   /* U+026B */
  0x0000,   /* U+026C */
  0x0000,   /* U+026D */
  0x0000,   /* U+026E */
  0x0000,   /* U+026F */
  0x0000,   /* U+0270 */
  0x0000,   /* U+0271 */
  0x0000,   /* U+0272 */
  0x0000,   /* U+0273 */
  0x0000,   /* U+0274 */
  0x0000,   /* U+0275 */
  0x0000,   /* U+0276 */
  0x0000,   /* U+0277 */
  0x0000,   /* U+0278 */
  0x0000,   /* U+0279 */
  0x0000,   /* U+027A */
  0x0000,   /* U+027B */
  0x0000,   /* U+027C */
  0x0000,   /* U+027D */
  0x0000,   /* U+027E */
  0x0000,   /* U+027F */
  0x0000,   /* U+0280 */
  0x0000,   /* U+0281 */
  0x0000,   /* U+0282 */
  0x0000,   /* U+0283 */
  0x0000,   /* U+0284 */
  0x0000,   /* U+0285 */
  0x0000,   /* U+0286 */
  0x0000,   /* U+0287 */
  0x0000,   /* U+0288 */
  0x0000,   /* U+0289 */
  0x0000,   /* U+028A */
  0x0000,   /* U+028B */
  0x0000,   /* U+028C */
  0x0000,   /* U+028D */
  0x0000,   /* U+028E */
  0x0000,   /* U+028F */
  0x0000,   /* U+0290 */
  0x0000,   /* U+0291 */
  0x0000,   /* U+0292 */
  0x0000,   /* U+0293 */
  0x0000,   /* U+0294 */
  0x0000,   /* U+0295 */
  0x0000,   /* U+0296 */
  0x0000,   /* U+0297 */
  0x0000,   /* U+0298 */
  0x0000,   /* U+0299 */
  0x0000,   /* U+029A */
  0x0000,   /* U+029B */
  0x0000,   /* U+029C */
  0x0000,   /* U+029D */
  0x0000,   /* U+029E */
  0x0000,   /* U+029F */
  0x0000,   /* U+02A0 */
  0x0000,   /* U+02A1 */
  0x0000,   /* U+02A2 */
  0x0000,   /* U+02A3 */
  0x0000,   /* U+02A4 */
  0x0000,   /* U+02A5 */
  0x0000,   /* U+02A6 */
  0x0000,   /* U+02A7 */
  0x0000,   /* U+02A8 */
  0x0000,   /* U+02A9 */
  0x0000,   /* U+02AA */
  0x0000,   /* U+02AB */
  0x0000,   /* U+02AC */
  0x0000,   /* U+02AD */
  0x0000,   /* U+02AE */
  0x0000,   /* U+02AF */
  0x0000,   /* U+02B0 */
  0x0000,   /* U+02B1 */
  0x0000,   /* U+02B2 */
  0x0000,   /* U+02B3 */
  0x0000,   /* U+02B4 */
  0x0000,   /* U+02B5 */
  0x0000,   /* U+02B6 */
  0x0000,   /* U+02B7 */
  0x0000,   /* U+02B8 */
  0x0000,   /* U+02B9 */
  0x0000,   /* U+02BA */
  0x0000,   /* U+02BB */
  0x0000,   /* U+02BC */
  0x0000,   /* U+02BD */
  0x0000,   /* U+02BE */
  0x0000,   /* U+02BF */
  0x0000,   /* U+02C0 */
  0x0000,   /* U+02C1 */
  0x0000,   /* U+02C2 */
  0x0000,   /* U+02C3 */
  0x0000,   /* U+02C4 */
  0x0000,   /* U+02C5 */
  0x0000,   /* U+02C6 */
  0x0000,   /* U+02C7 */
  0x0000,   /* U+02C8 */
  0x0000,   /* U+02C9 */
  0x0000,   /* U+02CA */
  0x0000,   /* U+02CB */
  0x0000,   /* U+02CC */
  0x0000,   /* U+02CD */
  0x0000,   /* U+02CE */
  0x0000,   /* U+02CF */
  0x0000,   /* U+02D0 */
  0x0000,   /* U+02D1 */
  0x0000,   /* U+02D2 */
  0x0000,   /* U+02D3 */
  0x0000,   /* U+02D4 */
  0x0000,   /* U+02D5 */
  0x0000,   /* U+02D6 */
  0x0000,   /* U+02D7 */
  0x0000,   /* U+02D8 */
  0x0000,   /* U+02D9 */
  0x0000,   /* U+02DA */
  0x0000,   /* U+02DB */
  0x0000,   /* U+02DC */
  0x0000,   /* U+02DD */
  0x0000,   /* U+02DE */
  0x0000,   /* U+02DF */
  0x0000,   /* U+02E0 */
  0x0000,   /* U+02E1 */
  0x0000,   /* U+02E2 */
  0x0000,   /* U+02E3 */
  0x0000,   /* U+02E4 */
  0x0000,   /* U+02E5 */
  0x0000,   /* U+02E6 */
  0x0000,   /* U+02E7 */
  0x0000,   /* U+02E8 */
  0x0000,   /* U+02E9 */
  0x0000,   /* U+02EA */
  0x0000,   /* U+02EB */
  0x0000,   /* U+02EC */
  0x0000,   /* U+02ED */
  0x0000,   /* U+02EE */
  0x0000,   /* U+02EF */
  0x0000,   /* U+02F0 */
  0x0000,   /* U+02F1 */
  0x0000,   /* U+02F2 */
  0x0000,   /* U+02F3 */
  0x0000,   /* U+02F4 */
  0x0000,   /* U+02F5 */
  0x0000,   /* U+02F6 */
  0x0000,   /* U+02F7 */
  0x0000,   /* U+02F8 */
  0x0000,   /* U+02F9 */
  0x0000,   /* U+02FA */
  0x0000,   /* U+02FB */
  0x0000,   /* U+02FC */
  0x0000,   /* U+02FD */
  0x0000,   /* U+02FE */
  0x0000,   /* U+02FF */

  /* Secondary weight 3 for each character. */
  0x0000,   /* U+0200 */
  0x0000,   /* U+0201 */
  0x0000,   /* U+0202 */
  0x0000,   /* U+0203 */
  0x0000,   /* U+0204 */
  0x0000,   /* U+0205 */
  0x0000,   /* U+0206 */
  0x0000,   /* U+0207 */
  0x0000,   /* U+0208 */
  0x0000,   /* U+0209 */
  0x0000,   /* U+020A */
  0x0000,   /* U+020B */
  0x0000,   /* U+020C */
  0x0000,   /* U+020D */
  0x0000,   /* U+020E */
  0x0000,   /* U+020F */
  0x0000,   /* U+0210 */
  0x0000,   /* U+0211 */
  0x0000,   /* U+0212 */
  0x0000,   /* U+0213 */
  0x0000,   /* U+0214 */
  0x0000,   /* U+0215 */
  0x0000,   /* U+0216 */
  0x0000,   /* U+0217 */
  0x0000,   /* U+0218 */
  0x0000,   /* U+0219 */
  0x0000,   /* U+021A */
  0x0000,   /* U+021B */
  0x0000,   /* U+021C */
  0x0000,   /* U+021D */
  0x0000,   /* U+021E */
  0x0000,   /* U+021F */
  0x0000,   /* U+0220 */
  0x0000,   /* U+0221 */
  0x0000,   /* U+0222 */
  0x0000,   /* U+0223 */
  0x0000,   /* U+0224 */
  0x0000,   /* U+0225 */
  0x0000,   /* U+0226 */
  0x0000,   /* U+0227 */
  0x0000,   /* U+0228 */
  0x0000,   /* U+0229 */
  0x0032,   /* U+022A */
  0x0032,   /* U+022B */
  0x0032,   /* U+022C */
  0x0032,   /* U+022D */
  0x0000,   /* U+022E */
  0x0000,   /* U+022F */
  0x0032,   /* U+0230 */
  0x0032,   /* U+0231 */
  0x0000,   /* U+0232 */
  0x0000,   /* U+0233 */
  0x0000,   /* U+0234 */
  0x0000,   /* U+0235 */
  0x0000,   /* U+0236 */
  0x0000,   /* U+0237 */
  0x0000,   /* U+0238 */
  0x0000,   /* U+0239 */
  0x0000,   /* U+023A */
  0x0000,   /* U+023B */
  0x0000,   /* U+023C */
  0x0000,   /* U+023D */
  0x0000,   /* U+023E */
  0x0000,   /* U+023F */
  0x0000,   /* U+0240 */
  0x0000,   /* U+0241 */
  0x0000,   /* U+0242 */
  0x0000,   /* U+0243 */
  0x0000,   /* U+0244 */
  0x0000,   /* U+0245 */
  0x0000,   /* U+0246 */
  0x0000,   /* U+0247 */
  0x0000,   /* U+0248 */
  0x0000,   /* U+0249 */
  0x0000,   /* U+024A */
  0x0000,   /* U+024B */
  0x0000,   /* U+024C */
  0x0000,   /* U+024D */
  0x0000,   /* U+024E */
  0x0000,   /* U+024F */
  0x0000,   /* U+0250 */
  0x0000,   /* U+0251 */
  0x0000,   /* U+0252 */
  0x0000,   /* U+0253 */
  0x0000,   /* U+0254 */
  0x0000,   /* U+0255 */
  0x0000,   /* U+0256 */
  0x0000,   /* U+0257 */
  0x0000,   /* U+0258 */
  0x0000,   /* U+0259 */
  0x0000,   /* U+025A */
  0x0000,   /* U+025B */
  0x0000,   /* U+025C */
  0x0000,   /* U+025D */
  0x0000,   /* U+025E */
  0x0000,   /* U+025F */
  0x0000,   /* U+0260 */
  0x0000,   /* U+0261 */
  0x0000,   /* U+0262 */
  0x0000,   /* U+0263 */
  0x0000,   /* U+0264 */
  0x0000,   /* U+0265 */
  0x0000,   /* U+0266 */
  0x0000,   /* U+0267 */
  0x0000,   /* U+0268 */
  0x0000,   /* U+0269 */
  0x0000,   /* U+026A */
  0x0000,   /* U+026B */
  0x0000,   /* U+026C */
  0x0000,   /* U+026D */
  0x0000,   /* U+026E */
  0x0000,   /* U+026F */
  0x0000,   /* U+0270 */
  0x0000,   /* U+0271 */
  0x0000,   /* U+0272 */
  0x0000,   /* U+0273 */
  0x0000,   /* U+0274 */
  0x0000,   /* U+0275 */
  0x0000,   /* U+0276 */
  0x0000,   /* U+0277 */
  0x0000,   /* U+0278 */
  0x0000,   /* U+0279 */
  0x0000,   /* U+027A */
  0x0000,   /* U+027B */
  0x0000,   /* U+027C */
  0x0000,   /* U+027D */
  0x0000,   /* U+027E */
  0x0000,   /* U+027F */
  0x0000,   /* U+0280 */
  0x0000,   /* U+0281 */
  0x0000,   /* U+0282 */
  0x0000,   /* U+0283 */
  0x0000,   /* U+0284 */
  0x0000,   /* U+0285 */
  0x0000,   /* U+0286 */
  0x0000,   /* U+0287 */
  0x0000,   /* U+0288 */
  0x0000,   /* U+0289 */
  0x0000,   /* U+028A */
  0x0000,   /* U+028B */
  0x0000,   /* U+028C */
  0x0000,   /* U+028D */
  0x0000,   /* U+028E */
  0x0000,   /* U+028F */
  0x0000,   /* U+0290 */
  0x0000,   /* U+0291 */
  0x0000,   /* U+0292 */
  0x0000,   /* U+0293 */
  0x0000,   /* U+0294 */
  0x0000,   /* U+0295 */
  0x0000,   /* U+0296 */
  0x0000,   /* U+0297 */
  0x0000,   /* U+0298 */
  0x0000,   /* U+0299 */
  0x0000,   /* U+029A */
  0x0000,   /* U+029B */
  0x0000,   /* U+029C */
  0x0000,   /* U+029D */
  0x0000,   /* U+029E */
  0x0000,   /* U+029F */
  0x0000,   /* U+02A0 */
  0x0000,   /* U+02A1 */
  0x0000,   /* U+02A2 */
  0x0000,   /* U+02A3 */
  0x0000,   /* U+02A4 */
  0x0000,   /* U+02A5 */
  0x0000,   /* U+02A6 */
  0x0000,   /* U+02A7 */
  0x0000,   /* U+02A8 */
  0x0000,   /* U+02A9 */
  0x0000,   /* U+02AA */
  0x0000,   /* U+02AB */
  0x0000,   /* U+02AC */
  0x0000,   /* U+02AD */
  0x0000,   /* U+02AE */
  0x0000,   /* U+02AF */
  0x0000,   /* U+02B0 */
  0x0000,   /* U+02B1 */
  0x0000,   /* U+02B2 */
  0x0000,   /* U+02B3 */
  0x0000,   /* U+02B4 */
  0x0000,   /* U+02B5 */
  0x0000,   /* U+02B6 */
  0x0000,   /* U+02B7 */
  0x0000,   /* U+02B8 */
  0x0000,   /* U+02B9 */
  0x0000,   /* U+02BA */
  0x0000,   /* U+02BB */
  0x0000,   /* U+02BC */
  0x0000,   /* U+02BD */
  0x0000,   /* U+02BE */
  0x0000,   /* U+02BF */
  0x0000,   /* U+02C0 */
  0x0000,   /* U+02C1 */
  0x0000,   /* U+02C2 */
  0x0000,   /* U+02C3 */
  0x0000,   /* U+02C4 */
  0x0000,   /* U+02C5 */
  0x0000,   /* U+02C6 */
  0x0000,   /* U+02C7 */
  0x0000,   /* U+02C8 */
  0x0000,   /* U+02C9 */
  0x0000,   /* U+02CA */
  0x0000,   /* U+02CB */
  0x0000,   /* U+02CC */
  0x0000,   /* U+02CD */
  0x0000,   /* U+02CE */
  0x0000,   /* U+02CF */
  0x0000,   /* U+02D0 */
  0x0000,   /* U+02D1 */
  0x0000,   /* U+02D2 */
  0x0000,   /* U+02D3 */
  0x0000,   /* U+02D4 */
  0x0000,   /* U+02D5 */
  0x0000,   /* U+02D6 */
  0x0000,   /* U+02D7 */
  0x0000,   /* U+02D8 */
  0x0000,   /* U+02D9 */
  0x0000,   /* U+02DA */
  0x0000,   /* U+02DB */
  0x0000,   /* U+02DC */
  0x0000,   /* U+02DD */
  0x0000,   /* U+02DE */
  0x0000,   /* U+02DF */
  0x0000,   /* U+02E0 */
  0x0000,   /* U+02E1 */
  0x0000,   /* U+02E2 */
  0x0000,   /* U+02E3 */
  0x0000,   /* U+02E4 */
  0x0000,   /* U+02E5 */
  0x0000,   /* U+02E6 */
  0x0000,   /* U+02E7 */
  0x0000,   /* U+02E8 */
  0x0000,   /* U+02E9 */
  0x0000,   /* U+02EA */
  0x0000,   /* U+02EB */
  0x0000,   /* U+02EC */
  0x0000,   /* U+02ED */
  0x0000,   /* U+02EE */
  0x0000,   /* U+02EF */
  0x0000,   /* U+02F0 */
  0x0000,   /* U+02F1 */
  0x0000,   /* U+02F2 */
  0x0000,   /* U+02F3 */
  0x0000,   /* U+02F4 */
  0x0000,   /* U+02F5 */
  0x0000,   /* U+02F6 */
  0x0000,   /* U+02F7 */
  0x0000,   /* U+02F8 */
  0x0000,   /* U+02F9 */
  0x0000,   /* U+02FA */
  0x0000,   /* U+02FB */
  0x0000,   /* U+02FC */
  0x0000,   /* U+02FD */
  0x0000,   /* U+02FE */
  0x0000,   /* U+02FF */

  /* Tertiary weight 3 for each character. */
  0x0000,   /* U+0200 */
  0x0000,   /* U+0201 */
  0x0000,   /* U+0202 */
  0x0000,   /* U+0203 */
  0x0000,   /* U+0204 */
  0x0000,   /* U+0205 */
  0x0000,   /* U+0206 */
  0x0000,   /* U+0207 */
  0x0000,   /* U+0208 */
  0x0000,   /* U+0209 */
  0x0000,   /* U+020A */
  0x0000,   /* U+020B */
  0x0000,   /* U+020C */
  0x0000,   /* U+020D */
  0x0000,   /* U+020E */
  0x0000,   /* U+020F */
  0x0000,   /* U+0210 */
  0x0000,   /* U+0211 */
  0x0000,   /* U+0212 */
  0x0000,   /* U+0213 */
  0x0000,   /* U+0214 */
  0x0000,   /* U+0215 */
  0x0000,   /* U+0216 */
  0x0000,   /* U+0217 */
  0x0000,   /* U+0218 */
  0x0000,   /* U+0219 */
  0x0000,   /* U+021A */
  0x0000,   /* U+021B */
  0x0000,   /* U+021C */
  0x0000,   /* U+021D */
  0x0000,   /* U+021E */
  0x0000,   /* U+021F */
  0x0000,   /* U+0220 */
  0x0000,   /* U+0221 */
  0x0000,   /* U+0222 */
  0x0000,   /* U+0223 */
  0x0000,   /* U+0224 */
  0x0000,   /* U+0225 */
  0x0000,   /* U+0226 */
  0x0000,   /* U+0227 */
  0x0000,   /* U+0228 */
  0x0000,   /* U+0229 */
  0x0002,   /* U+022A */
  0x0002,   /* U+022B */
  0x0002,   /* U+022C */
  0x0002,   /* U+022D */
  0x0000,   /* U+022E */
  0x0000,   /* U+022F */
  0x0002,   /* U+0230 */
  0x0002,   /* U+0231 */
  0x0000,   /* U+0232 */
  0x0000,   /* U+0233 */
  0x0000,   /* U+0234 */
  0x0000,   /* U+0235 */
  0x0000,   /* U+0236 */
  0x0000,   /* U+0237 */
  0x0000,   /* U+0238 */
  0x0000,   /* U+0239 */
  0x0000,   /* U+023A */
  0x0000,   /* U+023B */
  0x0000,   /* U+023C */
  0x0000,   /* U+023D */
  0x0000,   /* U+023E */
  0x0000,   /* U+023F */
  0x0000,   /* U+0240 */
  0x0000,   /* U+0241 */
  0x0000,   /* U+0242 */
  0x0000,   /* U+0243 */
  0x0000,   /* U+0244 */
  0x0000,   /* U+0245 */
  0x0000,   /* U+0246 */
  0x0000,   /* U+0247 */
  0x0000,   /* U+0248 */
  0x0000,   /* U+0249 */
  0x0000,   /* U+024A */
  0x0000,   /* U+024B */
  0x0000,   /* U+024C */
  0x0000,   /* U+024D */
  0x0000,   /* U+024E */
  0x0000,   /* U+024F */
  0x0000,   /* U+0250 */
  0x0000,   /* U+0251 */
  0x0000,   /* U+0252 */
  0x0000,   /* U+0253 */
  0x0000,   /* U+0254 */
  0x0000,   /* U+0255 */
  0x0000,   /* U+0256 */
  0x0000,   /* U+0257 */
  0x0000,   /* U+0258 */
  0x0000,   /* U+0259 */
  0x0000,   /* U+025A */
  0x0000,   /* U+025B */
  0x0000,   /* U+025C */
  0x0000,   /* U+025D */
  0x0000,   /* U+025E */
  0x0000,   /* U+025F */
  0x0000,   /* U+0260 */
  0x0000,   /* U+0261 */
  0x0000,   /* U+0262 */
  0x0000,   /* U+0263 */
  0x0000,   /* U+0264 */
  0x0000,   /* U+0265 */
  0x0000,   /* U+0266 */
  0x0000,   /* U+0267 */
  0x0000,   /* U+0268 */
  0x0000,   /* U+0269 */
  0x0000,   /* U+026A */
  0x0000,   /* U+026B */
  0x0000,   /* U+026C */
  0x0000,   /* U+026D */
  0x0000,   /* U+026E */
  0x0000,   /* U+026F */
  0x0000,   /* U+0270 */
  0x0000,   /* U+0271 */
  0x0000,   /* U+0272 */
  0x0000,   /* U+0273 */
  0x0000,   /* U+0274 */
  0x0000,   /* U+0275 */
  0x0000,   /* U+0276 */
  0x0000,   /* U+0277 */
  0x0000,   /* U+0278 */
  0x0000,   /* U+0279 */
  0x0000,   /* U+027A */
  0x0000,   /* U+027B */
  0x0000,   /* U+027C */
  0x0000,   /* U+027D */
  0x0000,   /* U+027E */
  0x0000,   /* U+027F */
  0x0000,   /* U+0280 */
  0x0000,   /* U+0281 */
  0x0000,   /* U+0282 */
  0x0000,   /* U+0283 */
  0x0000,   /* U+0284 */
  0x0000,   /* U+0285 */
  0x0000,   /* U+0286 */
  0x0000,   /* U+0287 */
  0x0000,   /* U+0288 */
  0x0000,   /* U+0289 */
  0x0000,   /* U+028A */
  0x0000,   /* U+028B */
  0x0000,   /* U+028C */
  0x0000,   /* U+028D */
  0x0000,   /* U+028E */
  0x0000,   /* U+028F */
  0x0000,   /* U+0290 */
  0x0000,   /* U+0291 */
  0x0000,   /* U+0292 */
  0x0000,   /* U+0293 */
  0x0000,   /* U+0294 */
  0x0000,   /* U+0295 */
  0x0000,   /* U+0296 */
  0x0000,   /* U+0297 */
  0x0000,   /* U+0298 */
  0x0000,   /* U+0299 */
  0x0000,   /* U+029A */
  0x0000,   /* U+029B */
  0x0000,   /* U+029C */
  0x0000,   /* U+029D */
  0x0000,   /* U+029E */
  0x0000,   /* U+029F */
  0x0000,   /* U+02A0 */
  0x0000,   /* U+02A1 */
  0x0000,   /* U+02A2 */
  0x0000,   /* U+02A3 */
  0x0000,   /* U+02A4 */
  0x0000,   /* U+02A5 */
  0x0000,   /* U+02A6 */
  0x0000,   /* U+02A7 */
  0x0000,   /* U+02A8 */
  0x0000,   /* U+02A9 */
  0x0000,   /* U+02AA */
  0x0000,   /* U+02AB */
  0x0000,   /* U+02AC */
  0x0000,   /* U+02AD */
  0x0000,   /* U+02AE */
  0x0000,   /* U+02AF */
  0x0000,   /* U+02B0 */
  0x0000,   /* U+02B1 */
  0x0000,   /* U+02B2 */
  0x0000,   /* U+02B3 */
  0x0000,   /* U+02B4 */
  0x0000,   /* U+02B5 */
  0x0000,   /* U+02B6 */
  0x0000,   /* U+02B7 */
  0x0000,   /* U+02B8 */
  0x0000,   /* U+02B9 */
  0x0000,   /* U+02BA */
  0x0000,   /* U+02BB */
  0x0000,   /* U+02BC */
  0x0000,   /* U+02BD */
  0x0000,   /* U+02BE */
  0x0000,   /* U+02BF */
  0x0000,   /* U+02C0 */
  0x0000,   /* U+02C1 */
  0x0000,   /* U+02C2 */
  0x0000,   /* U+02C3 */
  0x0000,   /* U+02C4 */
  0x0000,   /* U+02C5 */
  0x0000,   /* U+02C6 */
  0x0000,   /* U+02C7 */
  0x0000,   /* U+02C8 */
  0x0000,   /* U+02C9 */
  0x0000,   /* U+02CA */
  0x0000,   /* U+02CB */
  0x0000,   /* U+02CC */
  0x0000,   /* U+02CD */
  0x0000,   /* U+02CE */
  0x0000,   /* U+02CF */
  0x0000,   /* U+02D0 */
  0x0000,   /* U+02D1 */
  0x0000,   /* U+02D2 */
  0x0000,   /* U+02D3 */
  0x0000,   /* U+02D4 */
  0x0000,   /* U+02D5 */
  0x0000,   /* U+02D6 */
  0x0000,   /* U+02D7 */
  0x0000,   /* U+02D8 */
  0x0000,   /* U+02D9 */
  0x0000,   /* U+02DA */
  0x0000,   /* U+02DB */
  0x0000,   /* U+02DC */
  0x0000,   /* U+02DD */
  0x0000,   /* U+02DE */
  0x0000,   /* U+02DF */
  0x0000,   /* U+02E0 */
  0x0000,   /* U+02E1 */
  0x0000,   /* U+02E2 */
  0x0000,   /* U+02E3 */
  0x0000,   /* U+02E4 */
  0x0000,   /* U+02E5 */
  0x0000,   /* U+02E6 */
  0x0000,   /* U+02E7 */
  0x0000,   /* U+02E8 */
  0x0000,   /* U+02E9 */
  0x0000,   /* U+02EA */
  0x0000,   /* U+02EB */
  0x0000,   /* U+02EC */
  0x0000,   /* U+02ED */
  0x0000,   /* U+02EE */
  0x0000,   /* U+02EF */
  0x0000,   /* U+02F0 */
  0x0000,   /* U+02F1 */
  0x0000,   /* U+02F2 */
  0x0000,   /* U+02F3 */
  0x0000,   /* U+02F4 */
  0x0000,   /* U+02F5 */
  0x0000,   /* U+02F6 */
  0x0000,   /* U+02F7 */
  0x0000,   /* U+02F8 */
  0x0000,   /* U+02F9 */
  0x0000,   /* U+02FA */
  0x0000,   /* U+02FB */
  0x0000,   /* U+02FC */
  0x0000,   /* U+02FD */
  0x0000,   /* U+02FE */
  0x0000,   /* U+02FF */
};

uint16 uca900_p003[]= {
  /* Number of CEs for each character. */
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 1, 1, 1, 1, 1, 1,
  2, 2, 2, 2, 1, 2, 2, 1, 2, 2, 2, 2, 2, 2, 2, 2,
  3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2,
  3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 3,
  1, 1, 1, 2, 2, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,

  /* Primary weight 1 for each character. */
  0x0000,   /* U+0300 */
  0x0000,   /* U+0301 */
  0x0000,   /* U+0302 */
  0x0000,   /* U+0303 */
  0x0000,   /* U+0304 */
  0x0000,   /* U+0305 */
  0x0000,   /* U+0306 */
  0x0000,   /* U+0307 */
  0x0000,   /* U+0308 */
  0x0000,   /* U+0309 */
  0x0000,   /* U+030A */
  0x0000,   /* U+030B */
  0x0000,   /* U+030C */
  0x0000,   /* U+030D */
  0x0000,   /* U+030E */
  0x0000,   /* U+030F */
  0x0000,   /* U+0310 */
  0x0000,   /* U+0311 */
  0x0000,   /* U+0312 */
  0x0000,   /* U+0313 */
  0x0000,   /* U+0314 */
  0x0000,   /* U+0315 */
  0x0000,   /* U+0316 */
  0x0000,   /* U+0317 */
  0x0000,   /* U+0318 */
  0x0000,   /* U+0319 */
  0x0000,   /* U+031A */
  0x0000,   /* U+031B */
  0x0000,   /* U+031C */
  0x0000,   /* U+031D */
  0x0000,   /* U+031E */
  0x0000,   /* U+031F */
  0x0000,   /* U+0320 */
  0x0000,   /* U+0321 */
  0x0000,   /* U+0322 */
  0x0000,   /* U+0323 */
  0x0000,   /* U+0324 */
  0x0000,   /* U+0325 */
  0x0000,   /* U+0326 */
  0x0000,   /* U+0327 */
  0x0000,   /* U+0328 */
  0x0000,   /* U+0329 */
  0x0000,   /* U+032A */
  0x0000,   /* U+032B */
  0x0000,   /* U+032C */
  0x0000,   /* U+032D */
  0x0000,   /* U+032E */
  0x0000,   /* U+032F */
  0x0000,   /* U+0330 */
  0x0000,   /* U+0331 */
  0x0000,   /* U+0332 */
  0x0000,   /* U+0333 */
  0x0000,   /* U+0334 */
  0x0000,   /* U+0335 */
  0x0000,   /* U+0336 */
  0x0000,   /* U+0337 */
  0x0000,   /* U+0338 */
  0x0000,   /* U+0339 */
  0x0000,   /* U+033A */
  0x0000,   /* U+033B */
  0x0000,   /* U+033C */
  0x0000,   /* U+033D */
  0x0000,   /* U+033E */
  0x0000,   /* U+033F */
  0x0000,   /* U+0340 */
  0x0000,   /* U+0341 */
  0x0000,   /* U+0342 */
  0x0000,   /* U+0343 */
  0x0000,   /* U+0344 */
  0x0000,   /* U+0345 */
  0x0000,   /* U+0346 */
  0x0000,   /* U+0347 */
  0x0000,   /* U+0348 */
  0x0000,   /* U+0349 */
  0x0000,   /* U+034A */
  0x0000,   /* U+034B */
  0x0000,   /* U+034C */
  0x0000,   /* U+034D */
  0x0000,   /* U+034E */
  0x0000,   /* U+034F */
  0x0000,   /* U+0350 */
  0x0000,   /* U+0351 */
  0x0000,   /* U+0352 */
  0x0000,   /* U+0353 */
  0x0000,   /* U+0354 */
  0x0000,   /* U+0355 */
  0x0000,   /* U+0356 */
  0x0000,   /* U+0357 */
  0x0000,   /* U+0358 */
  0x0000,   /* U+0359 */
  0x0000,   /* U+035A */
  0x0000,   /* U+035B */
  0x0000,   /* U+035C */
  0x0000,   /* U+035D */
  0x0000,   /* U+035E */
  0x0000,   /* U+035F */
  0x0000,   /* U+0360 */
  0x0000,   /* U+0361 */
  0x0000,   /* U+0362 */
  0x1C47,   /* U+0363 */
  0x1CAA,   /* U+0364 */
  0x1D32,   /* U+0365 */
  0x1DDD,   /* U+0366 */
  0x1EB5,   /* U+0367 */
  0x1C7A,   /* U+0368 */
  0x1C8F,   /* U+0369 */
  0x1D18,   /* U+036A */
  0x1DAA,   /* U+036B */
  0x1E33,   /* U+036C */
  0x1E95,   /* U+036D */
  0x1EE3,   /* U+036E */
  0x1EFF,   /* U+036F */
  0x1FC3,   /* U+0370 */
  0x1FC3,   /* U+0371 */
  0x1FE4,   /* U+0372 */
  0x1FE4,   /* U+0373 */
  0x0493,   /* U+0374 */
  0x0494,   /* U+0375 */
  0x1FC0,   /* U+0376 */
  0x1FC0,   /* U+0377 */
  0xFBC0,   /* U+0378 */
  0xFBC0,   /* U+0379 */
  0x1FC6,   /* U+037A */
  0x1FD9,   /* U+037B */
  0x1FD8,   /* U+037C */
  0x1FDA,   /* U+037D */
  0x0234,   /* U+037E */
  0x1FC7,   /* U+037F */
  0xFBC0,   /* U+0380 */
  0xFBC0,   /* U+0381 */
  0xFBC0,   /* U+0382 */
  0xFBC0,   /* U+0383 */
  0x0483,   /* U+0384 */
  0x0489,   /* U+0385 */
  0x1FB9,   /* U+0386 */
  0x028B,   /* U+0387 */
  0x1FBE,   /* U+0388 */
  0x1FC4,   /* U+0389 */
  0x1FC6,   /* U+038A */
  0xFBC0,   /* U+038B */
  0x1FCE,   /* U+038C */
  0xFBC0,   /* U+038D */
  0x1FDC,   /* U+038E */
  0x1FE1,   /* U+038F */
  0x1FC6,   /* U+0390 */
  0x1FB9,   /* U+0391 */
  0x1FBA,   /* U+0392 */
  0x1FBB,   /* U+0393 */
  0x1FBD,   /* U+0394 */
  0x1FBE,   /* U+0395 */
  0x1FC2,   /* U+0396 */
  0x1FC4,   /* U+0397 */
  0x1FC5,   /* U+0398 */
  0x1FC6,   /* U+0399 */
  0x1FC8,   /* U+039A */
  0x1FC9,   /* U+039B */
  0x1FCB,   /* U+039C */
  0x1FCC,   /* U+039D */
  0x1FCD,   /* U+039E */
  0x1FCE,   /* U+039F */
  0x1FCF,   /* U+03A0 */
  0x1FD4,   /* U+03A1 */
  0xFBC0,   /* U+03A2 */
  0x1FD7,   /* U+03A3 */
  0x1FDB,   /* U+03A4 */
  0x1FDC,   /* U+03A5 */
  0x1FDD,   /* U+03A6 */
  0x1FDE,   /* U+03A7 */
  0x1FDF,   /* U+03A8 */
  0x1FE1,   /* U+03A9 */
  0x1FC6,   /* U+03AA */
  0x1FDC,   /* U+03AB */
  0x1FB9,   /* U+03AC */
  0x1FBE,   /* U+03AD */
  0x1FC4,   /* U+03AE */
  0x1FC6,   /* U+03AF */
  0x1FDC,   /* U+03B0 */
  0x1FB9,   /* U+03B1 */
  0x1FBA,   /* U+03B2 */
  0x1FBB,   /* U+03B3 */
  0x1FBD,   /* U+03B4 */
  0x1FBE,   /* U+03B5 */
  0x1FC2,   /* U+03B6 */
  0x1FC4,   /* U+03B7 */
  0x1FC5,   /* U+03B8 */
  0x1FC6,   /* U+03B9 */
  0x1FC8,   /* U+03BA */
  0x1FC9,   /* U+03BB */
  0x1FCB,   /* U+03BC */
  0x1FCC,   /* U+03BD */
  0x1FCD,   /* U+03BE */
  0x1FCE,   /* U+03BF */
  0x1FCF,   /* U+03C0 */
  0x1FD4,   /* U+03C1 */
  0x1FD7,   /* U+03C2 */
  0x1FD7,   /* U+03C3 */
  0x1FDB,   /* U+03C4 */
  0x1FDC,   /* U+03C5 */
  0x1FDD,   /* U+03C6 */
  0x1FDE,   /* U+03C7 */
  0x1FDF,   /* U+03C8 */
  0x1FE1,   /* U+03C9 */
  0x1FC6,   /* U+03CA */
  0x1FDC,   /* U+03CB */
  0x1FCE,   /* U+03CC */
  0x1FDC,   /* U+03CD */
  0x1FE1,   /* U+03CE */
  0x1FC8,   /* U+03CF */
  0x1FBA,   /* U+03D0 */
  0x1FC5,   /* U+03D1 */
  0x1FDC,   /* U+03D2 */
  0x1FDC,   /* U+03D3 */
  0x1FDC,   /* U+03D4 */
  0x1FDD,   /* U+03D5 */
  0x1FCF,   /* U+03D6 */
  0x1FC8,   /* U+03D7 */
  0x1FD3,   /* U+03D8 */
  0x1FD3,   /* U+03D9 */
  0x1FC1,   /* U+03DA */
  0x1FC1,   /* U+03DB */
  0x1FBF,   /* U+03DC */
  0x1FBF,   /* U+03DD */
  0x1FD2,   /* U+03DE */
  0x1FD2,   /* U+03DF */
  0x1FE3,   /* U+03E0 */
  0x1FE3,   /* U+03E1 */
  0x2005,   /* U+03E2 */
  0x2005,   /* U+03E3 */
  0x200A,   /* U+03E4 */
  0x200A,   /* U+03E5 */
  0x200B,   /* U+03E6 */
  0x200B,   /* U+03E7 */
  0x200E,   /* U+03E8 */
  0x200E,   /* U+03E9 */
  0x2015,   /* U+03EA */
  0x2015,   /* U+03EB */
  0x2018,   /* U+03EC */
  0x2018,   /* U+03ED */
  0x201C,   /* U+03EE */
  0x201C,   /* U+03EF */
  0x1FC8,   /* U+03F0 */
  0x1FD4,   /* U+03F1 */
  0x1FD7,   /* U+03F2 */
  0x1FC7,   /* U+03F3 */
  0x1FC5,   /* U+03F4 */
  0x1FBE,   /* U+03F5 */
  0x0611,   /* U+03F6 */
  0x1FE5,   /* U+03F7 */
  0x1FE5,   /* U+03F8 */
  0x1FD7,   /* U+03F9 */
  0x1FD1,   /* U+03FA */
  0x1FD1,   /* U+03FB */
  0x1FD6,   /* U+03FC */
  0x1FD9,   /* U+03FD */
  0x1FD8,   /* U+03FE */
  0x1FDA,   /* U+03FF */

  /* Secondary weight 1 for each character. */
  0x0025,   /* U+0300 */
  0x0024,   /* U+0301 */
  0x0027,   /* U+0302 */
  0x002D,   /* U+0303 */
  0x0032,   /* U+0304 */
  0x003A,   /* U+0305 */
  0x0026,   /* U+0306 */
  0x002E,   /* U+0307 */
  0x002B,   /* U+0308 */
  0x003B,   /* U+0309 */
  0x0029,   /* U+030A */
  0x002C,   /* U+030B */
  0x0028,   /* U+030C */
  0x0033,   /* U+030D */
  0x0033,   /* U+030E */
  0x003C,   /* U+030F */
  0x003D,   /* U+0310 */
  0x003E,   /* U+0311 */
  0x0033,   /* U+0312 */
  0x0022,   /* U+0313 */
  0x0023,   /* U+0314 */
  0x0033,   /* U+0315 */
  0x0034,   /* U+0316 */
  0x0034,   /* U+0317 */
  0x0034,   /* U+0318 */
  0x0034,   /* U+0319 */
  0x0033,   /* U+031A */
  0x003F,   /* U+031B */
  0x0034,   /* U+031C */
  0x0034,   /* U+031D */
  0x0034,   /* U+031E */
  0x0034,   /* U+031F */
  0x0034,   /* U+0320 */
  0x0040,   /* U+0321 */
  0x0041,   /* U+0322 */
  0x0042,   /* U+0323 */
  0x0043,   /* U+0324 */
  0x0044,   /* U+0325 */
  0x0045,   /* U+0326 */
  0x0030,   /* U+0327 */
  0x0031,   /* U+0328 */
  0x0034,   /* U+0329 */
  0x0034,   /* U+032A */
  0x0034,   /* U+032B */
  0x0034,   /* U+032C */
  0x0046,   /* U+032D */
  0x0047,   /* U+032E */
  0x0034,   /* U+032F */
  0x0048,   /* U+0330 */
  0x0049,   /* U+0331 */
  0x0021,   /* U+0332 */
  0x0034,   /* U+0333 */
  0x004A,   /* U+0334 */
  0x0039,   /* U+0335 */
  0x0035,   /* U+0336 */
  0x0035,   /* U+0337 */
  0x002F,   /* U+0338 */
  0x004B,   /* U+0339 */
  0x0034,   /* U+033A */
  0x0034,   /* U+033B */
  0x0034,   /* U+033C */
  0x0033,   /* U+033D */
  0x0033,   /* U+033E */
  0x0033,   /* U+033F */
  0x0025,   /* U+0340 */
  0x0024,   /* U+0341 */
  0x002A,   /* U+0342 */
  0x0022,   /* U+0343 */
  0x002B,   /* U+0344 */
  0x004C,   /* U+0345 */
  0x0033,   /* U+0346 */
  0x0034,   /* U+0347 */
  0x0034,   /* U+0348 */
  0x0034,   /* U+0349 */
  0x0033,   /* U+034A */
  0x0033,   /* U+034B */
  0x0033,   /* U+034C */
  0x0034,   /* U+034D */
  0x0034,   /* U+034E */
  0x0000,   /* U+034F */
  0x0033,   /* U+0350 */
  0x0033,   /* U+0351 */
  0x0033,   /* U+0352 */
  0x0034,   /* U+0353 */
  0x0034,   /* U+0354 */
  0x0034,   /* U+0355 */
  0x0034,   /* U+0356 */
  0x0033,   /* U+0357 */
  0x004D,   /* U+0358 */
  0x0034,   /* U+0359 */
  0x0034,   /* U+035A */
  0x0033,   /* U+035B */
  0x0034,   /* U+035C */
  0x0033,   /* U+035D */
  0x0033,   /* U+035E */
  0x0034,   /* U+035F */
  0x004E,   /* U+0360 */
  0x004F,   /* U+0361 */
  0x0034,   /* U+0362 */
  0x0020,   /* U+0363 */
  0x0020,   /* U+0364 */
  0x0020,   /* U+0365 */
  0x0020,   /* U+0366 */
  0x0020,   /* U+0367 */
  0x0020,   /* U+0368 */
  0x0020,   /* U+0369 */
  0x0020,   /* U+036A */
  0x0020,   /* U+036B */
  0x0020,   /* U+036C */
  0x0020,   /* U+036D */
  0x0020,   /* U+036E */
  0x0020,   /* U+036F */
  0x0020,   /* U+0370 */
  0x0020,   /* U+0371 */
  0x0020,   /* U+0372 */
  0x0020,   /* U+0373 */
  0x0020,   /* U+0374 */
  0x0020,   /* U+0375 */
  0x0020,   /* U+0376 */
  0x0020,   /* U+0377 */
  0x0020,   /* U+0378 */
  0x0020,   /* U+0379 */
  0x0020,   /* U+037A */
  0x0020,   /* U+037B */
  0x0020,   /* U+037C */
  0x0020,   /* U+037D */
  0x0020,   /* U+037E */
  0x0020,   /* U+037F */
  0x0020,   /* U+0380 */
  0x0020,   /* U+0381 */
  0x0020,   /* U+0382 */
  0x0020,   /* U+0383 */
  0x0020,   /* U+0384 */
  0x0020,   /* U+0385 */
  0x0020,   /* U+0386 */
  0x0020,   /* U+0387 */
  0x0020,   /* U+0388 */
  0x0020,   /* U+0389 */
  0x0020,   /* U+038A */
  0x0020,   /* U+038B */
  0x0020,   /* U+038C */
  0x0020,   /* U+038D */
  0x0020,   /* U+038E */
  0x0020,   /* U+038F */
  0x0020,   /* U+0390 */
  0x0020,   /* U+0391 */
  0x0020,   /* U+0392 */
  0x0020,   /* U+0393 */
  0x0020,   /* U+0394 */
  0x0020,   /* U+0395 */
  0x0020,   /* U+0396 */
  0x0020,   /* U+0397 */
  0x0020,   /* U+0398 */
  0x0020,   /* U+0399 */
  0x0020,   /* U+039A */
  0x0020,   /* U+039B */
  0x0020,   /* U+039C */
  0x0020,   /* U+039D */
  0x0020,   /* U+039E */
  0x0020,   /* U+039F */
  0x0020,   /* U+03A0 */
  0x0020,   /* U+03A1 */
  0x0020,   /* U+03A2 */
  0x0020,   /* U+03A3 */
  0x0020,   /* U+03A4 */
  0x0020,   /* U+03A5 */
  0x0020,   /* U+03A6 */
  0x0020,   /* U+03A7 */
  0x0020,   /* U+03A8 */
  0x0020,   /* U+03A9 */
  0x0020,   /* U+03AA */
  0x0020,   /* U+03AB */
  0x0020,   /* U+03AC */
  0x0020,   /* U+03AD */
  0x0020,   /* U+03AE */
  0x0020,   /* U+03AF */
  0x0020,   /* U+03B0 */
  0x0020,   /* U+03B1 */
  0x0020,   /* U+03B2 */
  0x0020,   /* U+03B3 */
  0x0020,   /* U+03B4 */
  0x0020,   /* U+03B5 */
  0x0020,   /* U+03B6 */
  0x0020,   /* U+03B7 */
  0x0020,   /* U+03B8 */
  0x0020,   /* U+03B9 */
  0x0020,   /* U+03BA */
  0x0020,   /* U+03BB */
  0x0020,   /* U+03BC */
  0x0020,   /* U+03BD */
  0x0020,   /* U+03BE */
  0x0020,   /* U+03BF */
  0x0020,   /* U+03C0 */
  0x0020,   /* U+03C1 */
  0x0020,   /* U+03C2 */
  0x0020,   /* U+03C3 */
  0x0020,   /* U+03C4 */
  0x0020,   /* U+03C5 */
  0x0020,   /* U+03C6 */
  0x0020,   /* U+03C7 */
  0x0020,   /* U+03C8 */
  0x0020,   /* U+03C9 */
  0x0020,   /* U+03CA */
  0x0020,   /* U+03CB */
  0x0020,   /* U+03CC */
  0x0020,   /* U+03CD */
  0x0020,   /* U+03CE */
  0x0020,   /* U+03CF */
  0x0020,   /* U+03D0 */
  0x0020,   /* U+03D1 */
  0x0020,   /* U+03D2 */
  0x0020,   /* U+03D3 */
  0x0020,   /* U+03D4 */
  0x0020,   /* U+03D5 */
  0x0020,   /* U+03D6 */
  0x0020,   /* U+03D7 */
  0x0020,   /* U+03D8 */
  0x0020,   /* U+03D9 */
  0x0020,   /* U+03DA */
  0x0020,   /* U+03DB */
  0x0020,   /* U+03DC */
  0x0020,   /* U+03DD */
  0x0020,   /* U+03DE */
  0x0020,   /* U+03DF */
  0x0020,   /* U+03E0 */
  0x0020,   /* U+03E1 */
  0x0020,   /* U+03E2 */
  0x0020,   /* U+03E3 */
  0x0020,   /* U+03E4 */
  0x0020,   /* U+03E5 */
  0x0020,   /* U+03E6 */
  0x0020,   /* U+03E7 */
  0x0020,   /* U+03E8 */
  0x0020,   /* U+03E9 */
  0x0020,   /* U+03EA */
  0x0020,   /* U+03EB */
  0x0020,   /* U+03EC */
  0x0020,   /* U+03ED */
  0x0020,   /* U+03EE */
  0x0020,   /* U+03EF */
  0x0020,   /* U+03F0 */
  0x0020,   /* U+03F1 */
  0x0020,   /* U+03F2 */
  0x0020,   /* U+03F3 */
  0x0020,   /* U+03F4 */
  0x0020,   /* U+03F5 */
  0x0020,   /* U+03F6 */
  0x0020,   /* U+03F7 */
  0x0020,   /* U+03F8 */
  0x0020,   /* U+03F9 */
  0x0020,   /* U+03FA */
  0x0020,   /* U+03FB */
  0x0020,   /* U+03FC */
  0x0020,   /* U+03FD */
  0x0020,   /* U+03FE */
  0x0020,   /* U+03FF */

  /* Tertiary weight 1 for each character. */
  0x0002,   /* U+0300 */
  0x0002,   /* U+0301 */
  0x0002,   /* U+0302 */
  0x0002,   /* U+0303 */
  0x0002,   /* U+0304 */
  0x0002,   /* U+0305 */
  0x0002,   /* U+0306 */
  0x0002,   /* U+0307 */
  0x0002,   /* U+0308 */
  0x0002,   /* U+0309 */
  0x0002,   /* U+030A */
  0x0002,   /* U+030B */
  0x0002,   /* U+030C */
  0x0002,   /* U+030D */
  0x0002,   /* U+030E */
  0x0002,   /* U+030F */
  0x0002,   /* U+0310 */
  0x0002,   /* U+0311 */
  0x0002,   /* U+0312 */
  0x0002,   /* U+0313 */
  0x0002,   /* U+0314 */
  0x0002,   /* U+0315 */
  0x0002,   /* U+0316 */
  0x0002,   /* U+0317 */
  0x0002,   /* U+0318 */
  0x0002,   /* U+0319 */
  0x0002,   /* U+031A */
  0x0002,   /* U+031B */
  0x0002,   /* U+031C */
  0x0002,   /* U+031D */
  0x0002,   /* U+031E */
  0x0002,   /* U+031F */
  0x0002,   /* U+0320 */
  0x0002,   /* U+0321 */
  0x0002,   /* U+0322 */
  0x0002,   /* U+0323 */
  0x0002,   /* U+0324 */
  0x0002,   /* U+0325 */
  0x0002,   /* U+0326 */
  0x0002,   /* U+0327 */
  0x0002,   /* U+0328 */
  0x0002,   /* U+0329 */
  0x0002,   /* U+032A */
  0x0002,   /* U+032B */
  0x0002,   /* U+032C */
  0x0002,   /* U+032D */
  0x0002,   /* U+032E */
  0x0002,   /* U+032F */
  0x0002,   /* U+0330 */
  0x0002,   /* U+0331 */
  0x0002,   /* U+0332 */
  0x0002,   /* U+0333 */
  0x0002,   /* U+0334 */
  0x0002,   /* U+0335 */
  0x0002,   /* U+0336 */
  0x0002,   /* U+0337 */
  0x0002,   /* U+0338 */
  0x0002,   /* U+0339 */
  0x0002,   /* U+033A */
  0x0002,   /* U+033B */
  0x0002,   /* U+033C */
  0x0002,   /* U+033D */
  0x0002,   /* U+033E */
  0x0002,   /* U+033F */
  0x0002,   /* U+0340 */
  0x0002,   /* U+0341 */
  0x0002,   /* U+0342 */
  0x0002,   /* U+0343 */
  0x0002,   /* U+0344 */
  0x0002,   /* U+0345 */
  0x0002,   /* U+0346 */
  0x0002,   /* U+0347 */
  0x0002,   /* U+0348 */
  0x0002,   /* U+0349 */
  0x0002,   /* U+034A */
  0x0002,   /* U+034B */
  0x0002,   /* U+034C */
  0x0002,   /* U+034D */
  0x0002,   /* U+034E */
  0x0000,   /* U+034F */
  0x0002,   /* U+0350 */
  0x0002,   /* U+0351 */
  0x0002,   /* U+0352 */
  0x0002,   /* U+0353 */
  0x0002,   /* U+0354 */
  0x0002,   /* U+0355 */
  0x0002,   /* U+0356 */
  0x0002,   /* U+0357 */
  0x0002,   /* U+0358 */
  0x0002,   /* U+0359 */
  0x0002,   /* U+035A */
  0x0002,   /* U+035B */
  0x0002,   /* U+035C */
  0x0002,   /* U+035D */
  0x0002,   /* U+035E */
  0x0002,   /* U+035F */
  0x0002,   /* U+0360 */
  0x0002,   /* U+0361 */
  0x0002,   /* U+0362 */
  0x0004,   /* U+0363 */
  0x0004,   /* U+0364 */
  0x0004,   /* U+0365 */
  0x0004,   /* U+0366 */
  0x0004,   /* U+0367 */
  0x0004,   /* U+0368 */
  0x0004,   /* U+0369 */
  0x0004,   /* U+036A */
  0x0004,   /* U+036B */
  0x0004,   /* U+036C */
  0x0004,   /* U+036D */
  0x0004,   /* U+036E */
  0x0004,   /* U+036F */
  0x0008,   /* U+0370 */
  0x0002,   /* U+0371 */
  0x0008,   /* U+0372 */
  0x0002,   /* U+0373 */
  0x0002,   /* U+0374 */
  0x0002,   /* U+0375 */
  0x0008,   /* U+0376 */
  0x0002,   /* U+0377 */
  0x0002,   /* U+0378 */
  0x0002,   /* U+0379 */
  0x0004,   /* U+037A */
  0x0002,   /* U+037B */
  0x0002,   /* U+037C */
  0x0002,   /* U+037D */
  0x0002,   /* U+037E */
  0x0008,   /* U+037F */
  0x0002,   /* U+0380 */
  0x0002,   /* U+0381 */
  0x0002,   /* U+0382 */
  0x0002,   /* U+0383 */
  0x0002,   /* U+0384 */
  0x0002,   /* U+0385 */
  0x0008,   /* U+0386 */
  0x0002,   /* U+0387 */
  0x0008,   /* U+0388 */
  0x0008,   /* U+0389 */
  0x0008,   /* U+038A */
  0x0002,   /* U+038B */
  0x0008,   /* U+038C */
  0x0002,   /* U+038D */
  0x0008,   /* U+038E */
  0x0008,   /* U+038F */
  0x0002,   /* U+0390 */
  0x0008,   /* U+0391 */
  0x0008,   /* U+0392 */
  0x0008,   /* U+0393 */
  0x0008,   /* U+0394 */
  0x0008,   /* U+0395 */
  0x0008,   /* U+0396 */
  0x0008,   /* U+0397 */
  0x0008,   /* U+0398 */
  0x0008,   /* U+0399 */
  0x0008,   /* U+039A */
  0x0008,   /* U+039B */
  0x0008,   /* U+039C */
  0x0008,   /* U+039D */
  0x0008,   /* U+039E */
  0x0008,   /* U+039F */
  0x0008,   /* U+03A0 */
  0x0008,   /* U+03A1 */
  0x0002,   /* U+03A2 */
  0x0008,   /* U+03A3 */
  0x0008,   /* U+03A4 */
  0x0008,   /* U+03A5 */
  0x0008,   /* U+03A6 */
  0x0008,   /* U+03A7 */
  0x0008,   /* U+03A8 */
  0x0008,   /* U+03A9 */
  0x0008,   /* U+03AA */
  0x0008,   /* U+03AB */
  0x0002,   /* U+03AC */
  0x0002,   /* U+03AD */
  0x0002,   /* U+03AE */
  0x0002,   /* U+03AF */
  0x0002,   /* U+03B0 */
  0x0002,   /* U+03B1 */
  0x0002,   /* U+03B2 */
  0x0002,   /* U+03B3 */
  0x0002,   /* U+03B4 */
  0x0002,   /* U+03B5 */
  0x0002,   /* U+03B6 */
  0x0002,   /* U+03B7 */
  0x0002,   /* U+03B8 */
  0x0002,   /* U+03B9 */
  0x0002,   /* U+03BA */
  0x0002,   /* U+03BB */
  0x0002,   /* U+03BC */
  0x0002,   /* U+03BD */
  0x0002,   /* U+03BE */
  0x0002,   /* U+03BF */
  0x0002,   /* U+03C0 */
  0x0002,   /* U+03C1 */
  0x0019,   /* U+03C2 */
  0x0002,   /* U+03C3 */
  0x0002,   /* U+03C4 */
  0x0002,   /* U+03C5 */
  0x0002,   /* U+03C6 */
  0x0002,   /* U+03C7 */
  0x0002,   /* U+03C8 */
  0x0002,   /* U+03C9 */
  0x0002,   /* U+03CA */
  0x0002,   /* U+03CB */
  0x0002,   /* U+03CC */
  0x0002,   /* U+03CD */
  0x0002,   /* U+03CE */
  0x000A,   /* U+03CF */
  0x0004,   /* U+03D0 */
  0x0004,   /* U+03D1 */
  0x000A,   /* U+03D2 */
  0x000A,   /* U+03D3 */
  0x000A,   /* U+03D4 */
  0x0004,   /* U+03D5 */
  0x0004,   /* U+03D6 */
  0x0004,   /* U+03D7 */
  0x0008,   /* U+03D8 */
  0x0002,   /* U+03D9 */
  0x0008,   /* U+03DA */
  0x0002,   /* U+03DB */
  0x0008,   /* U+03DC */
  0x0002,   /* U+03DD */
  0x0008,   /* U+03DE */
  0x0002,   /* U+03DF */
  0x0008,   /* U+03E0 */
  0x0002,   /* U+03E1 */
  0x0008,   /* U+03E2 */
  0x0002,   /* U+03E3 */
  0x0008,   /* U+03E4 */
  0x0002,   /* U+03E5 */
  0x0008,   /* U+03E6 */
  0x0002,   /* U+03E7 */
  0x0008,   /* U+03E8 */
  0x0002,   /* U+03E9 */
  0x0008,   /* U+03EA */
  0x0002,   /* U+03EB */
  0x0008,   /* U+03EC */
  0x0002,   /* U+03ED */
  0x0008,   /* U+03EE */
  0x0002,   /* U+03EF */
  0x0004,   /* U+03F0 */
  0x0004,   /* U+03F1 */
  0x0004,   /* U+03F2 */
  0x0002,   /* U+03F3 */
  0x000A,   /* U+03F4 */
  0x0004,   /* U+03F5 */
  0x0002,   /* U+03F6 */
  0x0008,   /* U+03F7 */
  0x0002,   /* U+03F8 */
  0x000A,   /* U+03F9 */
  0x0008,   /* U+03FA */
  0x0002,   /* U+03FB */
  0x0002,   /* U+03FC */
  0x0008,   /* U+03FD */
  0x0008,   /* U+03FE */
  0x0008,   /* U+03FF */

  /* Primary weight 2 for each character. */
  0x0000,   /* U+0300 */
  0x0000,   /* U+0301 */
  0x0000,   /* U+0302 */
  0x0000,   /* U+0303 */
  0x0000,   /* U+0304 */
  0x0000,   /* U+0305 */
  0x0000,   /* U+0306 */
  0x0000,   /* U+0307 */
  0x0000,   /* U+0308 */
  0x0000,   /* U+0309 */
  0x0000,   /* U+030A */
  0x0000,   /* U+030B */
  0x0000,   /* U+030C */
  0x0000,   /* U+030D */
  0x0000,   /* U+030E */
  0x0000,   /* U+030F */
  0x0000,   /* U+0310 */
  0x0000,   /* U+0311 */
  0x0000,   /* U+0312 */
  0x0000,   /* U+0313 */
  0x0000,   /* U+0314 */
  0x0000,   /* U+0315 */
  0x0000,   /* U+0316 */
  0x0000,   /* U+0317 */
  0x0000,   /* U+0318 */
  0x0000,   /* U+0319 */
  0x0000,   /* U+031A */
  0x0000,   /* U+031B */
  0x0000,   /* U+031C */
  0x0000,   /* U+031D */
  0x0000,   /* U+031E */
  0x0000,   /* U+031F */
  0x0000,   /* U+0320 */
  0x0000,   /* U+0321 */
  0x0000,   /* U+0322 */
  0x0000,   /* U+0323 */
  0x0000,   /* U+0324 */
  0x0000,   /* U+0325 */
  0x0000,   /* U+0326 */
  0x0000,   /* U+0327 */
  0x0000,   /* U+0328 */
  0x0000,   /* U+0329 */
  0x0000,   /* U+032A */
  0x0000,   /* U+032B */
  0x0000,   /* U+032C */
  0x0000,   /* U+032D */
  0x0000,   /* U+032E */
  0x0000,   /* U+032F */
  0x0000,   /* U+0330 */
  0x0000,   /* U+0331 */
  0x0000,   /* U+0332 */
  0x0000,   /* U+0333 */
  0x0000,   /* U+0334 */
  0x0000,   /* U+0335 */
  0x0000,   /* U+0336 */
  0x0000,   /* U+0337 */
  0x0000,   /* U+0338 */
  0x0000,   /* U+0339 */
  0x0000,   /* U+033A */
  0x0000,   /* U+033B */
  0x0000,   /* U+033C */
  0x0000,   /* U+033D */
  0x0000,   /* U+033E */
  0x0000,   /* U+033F */
  0x0000,   /* U+0340 */
  0x0000,   /* U+0341 */
  0x0000,   /* U+0342 */
  0x0000,   /* U+0343 */
  0x0000,   /* U+0344 */
  0x0000,   /* U+0345 */
  0x0000,   /* U+0346 */
  0x0000,   /* U+0347 */
  0x0000,   /* U+0348 */
  0x0000,   /* U+0349 */
  0x0000,   /* U+034A */
  0x0000,   /* U+034B */
  0x0000,   /* U+034C */
  0x0000,   /* U+034D */
  0x0000,   /* U+034E */
  0x0000,   /* U+034F */
  0x0000,   /* U+0350 */
  0x0000,   /* U+0351 */
  0x0000,   /* U+0352 */
  0x0000,   /* U+0353 */
  0x0000,   /* U+0354 */
  0x0000,   /* U+0355 */
  0x0000,   /* U+0356 */
  0x0000,   /* U+0357 */
  0x0000,   /* U+0358 */
  0x0000,   /* U+0359 */
  0x0000,   /* U+035A */
  0x0000,   /* U+035B */
  0x0000,   /* U+035C */
  0x0000,   /* U+035D */
  0x0000,   /* U+035E */
  0x0000,   /* U+035F */
  0x0000,   /* U+0360 */
  0x0000,   /* U+0361 */
  0x0000,   /* U+0362 */
  0x0000,   /* U+0363 */
  0x0000,   /* U+0364 */
  0x0000,   /* U+0365 */
  0x0000,   /* U+0366 */
  0x0000,   /* U+0367 */
  0x0000,   /* U+0368 */
  0x0000,   /* U+0369 */
  0x0000,   /* U+036A */
  0x0000,   /* U+036B */
  0x0000,   /* U+036C */
  0x0000,   /* U+036D */
  0x0000,   /* U+036E */
  0x0000,   /* U+036F */
  0x0000,   /* U+0370 */
  0x0000,   /* U+0371 */
  0x0000,   /* U+0372 */
  0x0000,   /* U+0373 */
  0x0000,   /* U+0374 */
  0x0000,   /* U+0375 */
  0x0000,   /* U+0376 */
  0x0000,   /* U+0377 */
  0x8378,   /* U+0378 */
  0x8379,   /* U+0379 */
  0x0000,   /* U+037A */
  0x0000,   /* U+037B */
  0x0000,   /* U+037C */
  0x0000,   /* U+037D */
  0x0000,   /* U+037E */
  0x0000,   /* U+037F */
  0x8380,   /* U+0380 */
  0x8381,   /* U+0381 */
  0x8382,   /* U+0382 */
  0x8383,   /* U+0383 */
  0x0000,   /* U+0384 */
  0x0000,   /* U+0385 */
  0x0000,   /* U+0386 */
  0x0000,   /* U+0387 */
  0x0000,   /* U+0388 */
  0x0000,   /* U+0389 */
  0x0000,   /* U+038A */
  0x838B,   /* U+038B */
  0x0000,   /* U+038C */
  0x838D,   /* U+038D */
  0x0000,   /* U+038E */
  0x0000,   /* U+038F */
  0x0000,   /* U+0390 */
  0x0000,   /* U+0391 */
  0x0000,   /* U+0392 */
  0x0000,   /* U+0393 */
  0x0000,   /* U+0394 */
  0x0000,   /* U+0395 */
  0x0000,   /* U+0396 */
  0x0000,   /* U+0397 */
  0x0000,   /* U+0398 */
  0x0000,   /* U+0399 */
  0x0000,   /* U+039A */
  0x0000,   /* U+039B */
  0x0000,   /* U+039C */
  0x0000,   /* U+039D */
  0x0000,   /* U+039E */
  0x0000,   /* U+039F */
  0x0000,   /* U+03A0 */
  0x0000,   /* U+03A1 */
  0x83A2,   /* U+03A2 */
  0x0000,   /* U+03A3 */
  0x0000,   /* U+03A4 */
  0x0000,   /* U+03A5 */
  0x0000,   /* U+03A6 */
  0x0000,   /* U+03A7 */
  0x0000,   /* U+03A8 */
  0x0000,   /* U+03A9 */
  0x0000,   /* U+03AA */
  0x0000,   /* U+03AB */
  0x0000,   /* U+03AC */
  0x0000,   /* U+03AD */
  0x0000,   /* U+03AE */
  0x0000,   /* U+03AF */
  0x0000,   /* U+03B0 */
  0x0000,   /* U+03B1 */
  0x0000,   /* U+03B2 */
  0x0000,   /* U+03B3 */
  0x0000,   /* U+03B4 */
  0x0000,   /* U+03B5 */
  0x0000,   /* U+03B6 */
  0x0000,   /* U+03B7 */
  0x0000,   /* U+03B8 */
  0x0000,   /* U+03B9 */
  0x0000,   /* U+03BA */
  0x0000,   /* U+03BB */
  0x0000,   /* U+03BC */
  0x0000,   /* U+03BD */
  0x0000,   /* U+03BE */
  0x0000,   /* U+03BF */
  0x0000,   /* U+03C0 */
  0x0000,   /* U+03C1 */
  0x0000,   /* U+03C2 */
  0x0000,   /* U+03C3 */
  0x0000,   /* U+03C4 */
  0x0000,   /* U+03C5 */
  0x0000,   /* U+03C6 */
  0x0000,   /* U+03C7 */
  0x0000,   /* U+03C8 */
  0x0000,   /* U+03C9 */
  0x0000,   /* U+03CA */
  0x0000,   /* U+03CB */
  0x0000,   /* U+03CC */
  0x0000,   /* U+03CD */
  0x0000,   /* U+03CE */
  0x1FB9,   /* U+03CF */
  0x0000,   /* U+03D0 */
  0x0000,   /* U+03D1 */
  0x0000,   /* U+03D2 */
  0x0000,   /* U+03D3 */
  0x0000,   /* U+03D4 */
  0x0000,   /* U+03D5 */
  0x0000,   /* U+03D6 */
  0x1FB9,   /* U+03D7 */
  0x0000,   /* U+03D8 */
  0x0000,   /* U+03D9 */
  0x0000,   /* U+03DA */
  0x0000,   /* U+03DB */
  0x0000,   /* U+03DC */
  0x0000,   /* U+03DD */
  0x0000,   /* U+03DE */
  0x0000,   /* U+03DF */
  0x0000,   /* U+03E0 */
  0x0000,   /* U+03E1 */
  0x0000,   /* U+03E2 */
  0x0000,   /* U+03E3 */
  0x0000,   /* U+03E4 */
  0x0000,   /* U+03E5 */
  0x0000,   /* U+03E6 */
  0x0000,   /* U+03E7 */
  0x0000,   /* U+03E8 */
  0x0000,   /* U+03E9 */
  0x0000,   /* U+03EA */
  0x0000,   /* U+03EB */
  0x0000,   /* U+03EC */
  0x0000,   /* U+03ED */
  0x0000,   /* U+03EE */
  0x0000,   /* U+03EF */
  0x0000,   /* U+03F0 */
  0x0000,   /* U+03F1 */
  0x0000,   /* U+03F2 */
  0x0000,   /* U+03F3 */
  0x0000,   /* U+03F4 */
  0x0000,   /* U+03F5 */
  0x0000,   /* U+03F6 */
  0x0000,   /* U+03F7 */
  0x0000,   /* U+03F8 */
  0x0000,   /* U+03F9 */
  0x0000,   /* U+03FA */
  0x0000,   /* U+03FB */
  0x0000,   /* U+03FC */
  0x0000,   /* U+03FD */
  0x0000,   /* U+03FE */
  0x0000,   /* U+03FF */

  /* Secondary weight 2 for each character. */
  0x0000,   /* U+0300 */
  0x0000,   /* U+0301 */
  0x0000,   /* U+0302 */
  0x0000,   /* U+0303 */
  0x0000,   /* U+0304 */
  0x0000,   /* U+0305 */
  0x0000,   /* U+0306 */
  0x0000,   /* U+0307 */
  0x0000,   /* U+0308 */
  0x0000,   /* U+0309 */
  0x0000,   /* U+030A */
  0x0000,   /* U+030B */
  0x0000,   /* U+030C */
  0x0000,   /* U+030D */
  0x0000,   /* U+030E */
  0x0000,   /* U+030F */
  0x0000,   /* U+0310 */
  0x0000,   /* U+0311 */
  0x0000,   /* U+0312 */
  0x0000,   /* U+0313 */
  0x0000,   /* U+0314 */
  0x0000,   /* U+0315 */
  0x0000,   /* U+0316 */
  0x0000,   /* U+0317 */
  0x0000,   /* U+0318 */
  0x0000,   /* U+0319 */
  0x0000,   /* U+031A */
  0x0000,   /* U+031B */
  0x0000,   /* U+031C */
  0x0000,   /* U+031D */
  0x0000,   /* U+031E */
  0x0000,   /* U+031F */
  0x0000,   /* U+0320 */
  0x0000,   /* U+0321 */
  0x0000,   /* U+0322 */
  0x0000,   /* U+0323 */
  0x0000,   /* U+0324 */
  0x0000,   /* U+0325 */
  0x0000,   /* U+0326 */
  0x0000,   /* U+0327 */
  0x0000,   /* U+0328 */
  0x0000,   /* U+0329 */
  0x0000,   /* U+032A */
  0x0000,   /* U+032B */
  0x0000,   /* U+032C */
  0x0000,   /* U+032D */
  0x0000,   /* U+032E */
  0x0000,   /* U+032F */
  0x0000,   /* U+0330 */
  0x0000,   /* U+0331 */
  0x0000,   /* U+0332 */
  0x0000,   /* U+0333 */
  0x0000,   /* U+0334 */
  0x0000,   /* U+0335 */
  0x0000,   /* U+0336 */
  0x0000,   /* U+0337 */
  0x0000,   /* U+0338 */
  0x0000,   /* U+0339 */
  0x0000,   /* U+033A */
  0x0000,   /* U+033B */
  0x0000,   /* U+033C */
  0x0000,   /* U+033D */
  0x0000,   /* U+033E */
  0x0000,   /* U+033F */
  0x0000,   /* U+0340 */
  0x0000,   /* U+0341 */
  0x0000,   /* U+0342 */
  0x0000,   /* U+0343 */
  0x0024,   /* U+0344 */
  0x0000,   /* U+0345 */
  0x0000,   /* U+0346 */
  0x0000,   /* U+0347 */
  0x0000,   /* U+0348 */
  0x0000,   /* U+0349 */
  0x0000,   /* U+034A */
  0x0000,   /* U+034B */
  0x0000,   /* U+034C */
  0x0000,   /* U+034D */
  0x0000,   /* U+034E */
  0x0000,   /* U+034F */
  0x0000,   /* U+0350 */
  0x0000,   /* U+0351 */
  0x0000,   /* U+0352 */
  0x0000,   /* U+0353 */
  0x0000,   /* U+0354 */
  0x0000,   /* U+0355 */
  0x0000,   /* U+0356 */
  0x0000,   /* U+0357 */
  0x0000,   /* U+0358 */
  0x0000,   /* U+0359 */
  0x0000,   /* U+035A */
  0x0000,   /* U+035B */
  0x0000,   /* U+035C */
  0x0000,   /* U+035D */
  0x0000,   /* U+035E */
  0x0000,   /* U+035F */
  0x0000,   /* U+0360 */
  0x0000,   /* U+0361 */
  0x0000,   /* U+0362 */
  0x0000,   /* U+0363 */
  0x0000,   /* U+0364 */
  0x0000,   /* U+0365 */
  0x0000,   /* U+0366 */
  0x0000,   /* U+0367 */
  0x0000,   /* U+0368 */
  0x0000,   /* U+0369 */
  0x0000,   /* U+036A */
  0x0000,   /* U+036B */
  0x0000,   /* U+036C */
  0x0000,   /* U+036D */
  0x0000,   /* U+036E */
  0x0000,   /* U+036F */
  0x0000,   /* U+0370 */
  0x0000,   /* U+0371 */
  0x0000,   /* U+0372 */
  0x0000,   /* U+0373 */
  0x0000,   /* U+0374 */
  0x0000,   /* U+0375 */
  0x0000,   /* U+0376 */
  0x0000,   /* U+0377 */
  0x0000,   /* U+0378 */
  0x0000,   /* U+0379 */
  0x0000,   /* U+037A */
  0x0000,   /* U+037B */
  0x0000,   /* U+037C */
  0x0000,   /* U+037D */
  0x0000,   /* U+037E */
  0x0000,   /* U+037F */
  0x0000,   /* U+0380 */
  0x0000,   /* U+0381 */
  0x0000,   /* U+0382 */
  0x0000,   /* U+0383 */
  0x0000,   /* U+0384 */
  0x0024,   /* U+0385 */
  0x0024,   /* U+0386 */
  0x0000,   /* U+0387 */
  0x0024,   /* U+0388 */
  0x0024,   /* U+0389 */
  0x0024,   /* U+038A */
  0x0000,   /* U+038B */
  0x0024,   /* U+038C */
  0x0000,   /* U+038D */
  0x0024,   /* U+038E */
  0x0024,   /* U+038F */
  0x002B,   /* U+0390 */
  0x0000,   /* U+0391 */
  0x0000,   /* U+0392 */
  0x0000,   /* U+0393 */
  0x0000,   /* U+0394 */
  0x0000,   /* U+0395 */
  0x0000,   /* U+0396 */
  0x0000,   /* U+0397 */
  0x0000,   /* U+0398 */
  0x0000,   /* U+0399 */
  0x0000,   /* U+039A */
  0x0000,   /* U+039B */
  0x0000,   /* U+039C */
  0x0000,   /* U+039D */
  0x0000,   /* U+039E */
  0x0000,   /* U+039F */
  0x0000,   /* U+03A0 */
  0x0000,   /* U+03A1 */
  0x0000,   /* U+03A2 */
  0x0000,   /* U+03A3 */
  0x0000,   /* U+03A4 */
  0x0000,   /* U+03A5 */
  0x0000,   /* U+03A6 */
  0x0000,   /* U+03A7 */
  0x0000,   /* U+03A8 */
  0x0000,   /* U+03A9 */
  0x002B,   /* U+03AA */
  0x002B,   /* U+03AB */
  0x0024,   /* U+03AC */
  0x0024,   /* U+03AD */
  0x0024,   /* U+03AE */
  0x0024,   /* U+03AF */
  0x002B,   /* U+03B0 */
  0x0000,   /* U+03B1 */
  0x0000,   /* U+03B2 */
  0x0000,   /* U+03B3 */
  0x0000,   /* U+03B4 */
  0x0000,   /* U+03B5 */
  0x0000,   /* U+03B6 */
  0x0000,   /* U+03B7 */
  0x0000,   /* U+03B8 */
  0x0000,   /* U+03B9 */
  0x0000,   /* U+03BA */
  0x0000,   /* U+03BB */
  0x0000,   /* U+03BC */
  0x0000,   /* U+03BD */
  0x0000,   /* U+03BE */
  0x0000,   /* U+03BF */
  0x0000,   /* U+03C0 */
  0x0000,   /* U+03C1 */
  0x0000,   /* U+03C2 */
  0x0000,   /* U+03C3 */
  0x0000,   /* U+03C4 */
  0x0000,   /* U+03C5 */
  0x0000,   /* U+03C6 */
  0x0000,   /* U+03C7 */
  0x0000,   /* U+03C8 */
  0x0000,   /* U+03C9 */
  0x002B,   /* U+03CA */
  0x002B,   /* U+03CB */
  0x0024,   /* U+03CC */
  0x0024,   /* U+03CD */
  0x0024,   /* U+03CE */
  0x0020,   /* U+03CF */
  0x0000,   /* U+03D0 */
  0x0000,   /* U+03D1 */
  0x0000,   /* U+03D2 */
  0x0024,   /* U+03D3 */
  0x002B,   /* U+03D4 */
  0x0000,   /* U+03D5 */
  0x0000,   /* U+03D6 */
  0x0020,   /* U+03D7 */
  0x0000,   /* U+03D8 */
  0x0000,   /* U+03D9 */
  0x0000,   /* U+03DA */
  0x0000,   /* U+03DB */
  0x0000,   /* U+03DC */
  0x0000,   /* U+03DD */
  0x0000,   /* U+03DE */
  0x0000,   /* U+03DF */
  0x0000,   /* U+03E0 */
  0x0000,   /* U+03E1 */
  0x0000,   /* U+03E2 */
  0x0000,   /* U+03E3 */
  0x0000,   /* U+03E4 */
  0x0000,   /* U+03E5 */
  0x0000,   /* U+03E6 */
  0x0000,   /* U+03E7 */
  0x0000,   /* U+03E8 */
  0x0000,   /* U+03E9 */
  0x0000,   /* U+03EA */
  0x0000,   /* U+03EB */
  0x0000,   /* U+03EC */
  0x0000,   /* U+03ED */
  0x0000,   /* U+03EE */
  0x0000,   /* U+03EF */
  0x0000,   /* U+03F0 */
  0x0000,   /* U+03F1 */
  0x0000,   /* U+03F2 */
  0x0000,   /* U+03F3 */
  0x0000,   /* U+03F4 */
  0x0000,   /* U+03F5 */
  0x0000,   /* U+03F6 */
  0x0000,   /* U+03F7 */
  0x0000,   /* U+03F8 */
  0x0000,   /* U+03F9 */
  0x0000,   /* U+03FA */
  0x0000,   /* U+03FB */
  0x0000,   /* U+03FC */
  0x0000,   /* U+03FD */
  0x0000,   /* U+03FE */
  0x0000,   /* U+03FF */

  /* Tertiary weight 2 for each character. */
  0x0000,   /* U+0300 */
  0x0000,   /* U+0301 */
  0x0000,   /* U+0302 */
  0x0000,   /* U+0303 */
  0x0000,   /* U+0304 */
  0x0000,   /* U+0305 */
  0x0000,   /* U+0306 */
  0x0000,   /* U+0307 */
  0x0000,   /* U+0308 */
  0x0000,   /* U+0309 */
  0x0000,   /* U+030A */
  0x0000,   /* U+030B */
  0x0000,   /* U+030C */
  0x0000,   /* U+030D */
  0x0000,   /* U+030E */
  0x0000,   /* U+030F */
  0x0000,   /* U+0310 */
  0x0000,   /* U+0311 */
  0x0000,   /* U+0312 */
  0x0000,   /* U+0313 */
  0x0000,   /* U+0314 */
  0x0000,   /* U+0315 */
  0x0000,   /* U+0316 */
  0x0000,   /* U+0317 */
  0x0000,   /* U+0318 */
  0x0000,   /* U+0319 */
  0x0000,   /* U+031A */
  0x0000,   /* U+031B */
  0x0000,   /* U+031C */
  0x0000,   /* U+031D */
  0x0000,   /* U+031E */
  0x0000,   /* U+031F */
  0x0000,   /* U+0320 */
  0x0000,   /* U+0321 */
  0x0000,   /* U+0322 */
  0x0000,   /* U+0323 */
  0x0000,   /* U+0324 */
  0x0000,   /* U+0325 */
  0x0000,   /* U+0326 */
  0x0000,   /* U+0327 */
  0x0000,   /* U+0328 */
  0x0000,   /* U+0329 */
  0x0000,   /* U+032A */
  0x0000,   /* U+032B */
  0x0000,   /* U+032C */
  0x0000,   /* U+032D */
  0x0000,   /* U+032E */
  0x0000,   /* U+032F */
  0x0000,   /* U+0330 */
  0x0000,   /* U+0331 */
  0x0000,   /* U+0332 */
  0x0000,   /* U+0333 */
  0x0000,   /* U+0334 */
  0x0000,   /* U+0335 */
  0x0000,   /* U+0336 */
  0x0000,   /* U+0337 */
  0x0000,   /* U+0338 */
  0x0000,   /* U+0339 */
  0x0000,   /* U+033A */
  0x0000,   /* U+033B */
  0x0000,   /* U+033C */
  0x0000,   /* U+033D */
  0x0000,   /* U+033E */
  0x0000,   /* U+033F */
  0x0000,   /* U+0340 */
  0x0000,   /* U+0341 */
  0x0000,   /* U+0342 */
  0x0000,   /* U+0343 */
  0x0002,   /* U+0344 */
  0x0000,   /* U+0345 */
  0x0000,   /* U+0346 */
  0x0000,   /* U+0347 */
  0x0000,   /* U+0348 */
  0x0000,   /* U+0349 */
  0x0000,   /* U+034A */
  0x0000,   /* U+034B */
  0x0000,   /* U+034C */
  0x0000,   /* U+034D */
  0x0000,   /* U+034E */
  0x0000,   /* U+034F */
  0x0000,   /* U+0350 */
  0x0000,   /* U+0351 */
  0x0000,   /* U+0352 */
  0x0000,   /* U+0353 */
  0x0000,   /* U+0354 */
  0x0000,   /* U+0355 */
  0x0000,   /* U+0356 */
  0x0000,   /* U+0357 */
  0x0000,   /* U+0358 */
  0x0000,   /* U+0359 */
  0x0000,   /* U+035A */
  0x0000,   /* U+035B */
  0x0000,   /* U+035C */
  0x0000,   /* U+035D */
  0x0000,   /* U+035E */
  0x0000,   /* U+035F */
  0x0000,   /* U+0360 */
  0x0000,   /* U+0361 */
  0x0000,   /* U+0362 */
  0x0000,   /* U+0363 */
  0x0000,   /* U+0364 */
  0x0000,   /* U+0365 */
  0x0000,   /* U+0366 */
  0x0000,   /* U+0367 */
  0x0000,   /* U+0368 */
  0x0000,   /* U+0369 */
  0x0000,   /* U+036A */
  0x0000,   /* U+036B */
  0x0000,   /* U+036C */
  0x0000,   /* U+036D */
  0x0000,   /* U+036E */
  0x0000,   /* U+036F */
  0x0000,   /* U+0370 */
  0x0000,   /* U+0371 */
  0x0000,   /* U+0372 */
  0x0000,   /* U+0373 */
  0x0000,   /* U+0374 */
  0x0000,   /* U+0375 */
  0x0000,   /* U+0376 */
  0x0000,   /* U+0377 */
  0x0000,   /* U+0378 */
  0x0000,   /* U+0379 */
  0x0000,   /* U+037A */
  0x0000,   /* U+037B */
  0x0000,   /* U+037C */
  0x0000,   /* U+037D */
  0x0000,   /* U+037E */
  0x0000,   /* U+037F */
  0x0000,   /* U+0380 */
  0x0000,   /* U+0381 */
  0x0000,   /* U+0382 */
  0x0000,   /* U+0383 */
  0x0000,   /* U+0384 */
  0x0002,   /* U+0385 */
  0x0002,   /* U+0386 */
  0x0000,   /* U+0387 */
  0x0002,   /* U+0388 */
  0x0002,   /* U+0389 */
  0x0002,   /* U+038A */
  0x0000,   /* U+038B */
  0x0002,   /* U+038C */
  0x0000,   /* U+038D */
  0x0002,   /* U+038E */
  0x0002,   /* U+038F */
  0x0002,   /* U+0390 */
  0x0000,   /* U+0391 */
  0x0000,   /* U+0392 */
  0x0000,   /* U+0393 */
  0x0000,   /* U+0394 */
  0x0000,   /* U+0395 */
  0x0000,   /* U+0396 */
  0x0000,   /* U+0397 */
  0x0000,   /* U+0398 */
  0x0000,   /* U+0399 */
  0x0000,   /* U+039A */
  0x0000,   /* U+039B */
  0x0000,   /* U+039C */
  0x0000,   /* U+039D */
  0x0000,   /* U+039E */
  0x0000,   /* U+039F */
  0x0000,   /* U+03A0 */
  0x0000,   /* U+03A1 */
  0x0000,   /* U+03A2 */
  0x0000,   /* U+03A3 */
  0x0000,   /* U+03A4 */
  0x0000,   /* U+03A5 */
  0x0000,   /* U+03A6 */
  0x0000,   /* U+03A7 */
  0x0000,   /* U+03A8 */
  0x0000,   /* U+03A9 */
  0x0002,   /* U+03AA */
  0x0002,   /* U+03AB */
  0x0002,   /* U+03AC */
  0x0002,   /* U+03AD */
  0x0002,   /* U+03AE */
  0x0002,   /* U+03AF */
  0x0002,   /* U+03B0 */
  0x0000,   /* U+03B1 */
  0x0000,   /* U+03B2 */
  0x0000,   /* U+03B3 */
  0x0000,   /* U+03B4 */
  0x0000,   /* U+03B5 */
  0x0000,   /* U+03B6 */
  0x0000,   /* U+03B7 */
  0x0000,   /* U+03B8 */
  0x0000,   /* U+03B9 */
  0x0000,   /* U+03BA */
  0x0000,   /* U+03BB */
  0x0000,   /* U+03BC */
  0x0000,   /* U+03BD */
  0x0000,   /* U+03BE */
  0x0000,   /* U+03BF */
  0x0000,   /* U+03C0 */
  0x0000,   /* U+03C1 */
  0x0000,   /* U+03C2 */
  0x0000,   /* U+03C3 */
  0x0000,   /* U+03C4 */
  0x0000,   /* U+03C5 */
  0x0000,   /* U+03C6 */
  0x0000,   /* U+03C7 */
  0x0000,   /* U+03C8 */
  0x0000,   /* U+03C9 */
  0x0002,   /* U+03CA */
  0x0002,   /* U+03CB */
  0x0002,   /* U+03CC */
  0x0002,   /* U+03CD */
  0x0002,   /* U+03CE */
  0x0004,   /* U+03CF */
  0x0000,   /* U+03D0 */
  0x0000,   /* U+03D1 */
  0x0000,   /* U+03D2 */
  0x0002,   /* U+03D3 */
  0x0002,   /* U+03D4 */
  0x0000,   /* U+03D5 */
  0x0000,   /* U+03D6 */
  0x0004,   /* U+03D7 */
  0x0000,   /* U+03D8 */
  0x0000,   /* U+03D9 */
  0x0000,   /* U+03DA */
  0x0000,   /* U+03DB */
  0x0000,   /* U+03DC */
  0x0000,   /* U+03DD */
  0x0000,   /* U+03DE */
  0x0000,   /* U+03DF */
  0x0000,   /* U+03E0 */
  0x0000,   /* U+03E1 */
  0x0000,   /* U+03E2 */
  0x0000,   /* U+03E3 */
  0x0000,   /* U+03E4 */
  0x0000,   /* U+03E5 */
  0x0000,   /* U+03E6 */
  0x0000,   /* U+03E7 */
  0x0000,   /* U+03E8 */
  0x0000,   /* U+03E9 */
  0x0000,   /* U+03EA */
  0x0000,   /* U+03EB */
  0x0000,   /* U+03EC */
  0x0000,   /* U+03ED */
  0x0000,   /* U+03EE */
  0x0000,   /* U+03EF */
  0x0000,   /* U+03F0 */
  0x0000,   /* U+03F1 */
  0x0000,   /* U+03F2 */
  0x0000,   /* U+03F3 */
  0x0000,   /* U+03F4 */
  0x0000,   /* U+03F5 */
  0x0000,   /* U+03F6 */
  0x0000,   /* U+03F7 */
  0x0000,   /* U+03F8 */
  0x0000,   /* U+03F9 */
  0x0000,   /* U+03FA */
  0x0000,   /* U+03FB */
  0x0000,   /* U+03FC */
  0x0000,   /* U+03FD */
  0x0000,   /* U+03FE */
  0x0000,   /* U+03FF */

  /* Primary weight 3 for each character. */
  0x0000,   /* U+0300 */
  0x0000,   /* U+0301 */
  0x0000,   /* U+0302 */
  0x0000,   /* U+0303 */
  0x0000,   /* U+0304 */
  0x0000,   /* U+0305 */
  0x0000,   /* U+0306 */
  0x0000,   /* U+0307 */
  0x0000,   /* U+0308 */
  0x0000,   /* U+0309 */
  0x0000,   /* U+030A */
  0x0000,   /* U+030B */
  0x0000,   /* U+030C */
  0x0000,   /* U+030D */
  0x0000,   /* U+030E */
  0x0000,   /* U+030F */
  0x0000,   /* U+0310 */
  0x0000,   /* U+0311 */
  0x0000,   /* U+0312 */
  0x0000,   /* U+0313 */
  0x0000,   /* U+0314 */
  0x0000,   /* U+0315 */
  0x0000,   /* U+0316 */
  0x0000,   /* U+0317 */
  0x0000,   /* U+0318 */
  0x0000,   /* U+0319 */
  0x0000,   /* U+031A */
  0x0000,   /* U+031B */
  0x0000,   /* U+031C */
  0x0000,   /* U+031D */
  0x0000,   /* U+031E */
  0x0000,   /* U+031F */
  0x0000,   /* U+0320 */
  0x0000,   /* U+0321 */
  0x0000,   /* U+0322 */
  0x0000,   /* U+0323 */
  0x0000,   /* U+0324 */
  0x0000,   /* U+0325 */
  0x0000,   /* U+0326 */
  0x0000,   /* U+0327 */
  0x0000,   /* U+0328 */
  0x0000,   /* U+0329 */
  0x0000,   /* U+032A */
  0x0000,   /* U+032B */
  0x0000,   /* U+032C */
  0x0000,   /* U+032D */
  0x0000,   /* U+032E */
  0x0000,   /* U+032F */
  0x0000,   /* U+0330 */
  0x0000,   /* U+0331 */
  0x0000,   /* U+0332 */
  0x0000,   /* U+0333 */
  0x0000,   /* U+0334 */
  0x0000,   /* U+0335 */
  0x0000,   /* U+0336 */
  0x0000,   /* U+0337 */
  0x0000,   /* U+0338 */
  0x0000,   /* U+0339 */
  0x0000,   /* U+033A */
  0x0000,   /* U+033B */
  0x0000,   /* U+033C */
  0x0000,   /* U+033D */
  0x0000,   /* U+033E */
  0x0000,   /* U+033F */
  0x0000,   /* U+0340 */
  0x0000,   /* U+0341 */
  0x0000,   /* U+0342 */
  0x0000,   /* U+0343 */
  0x0000,   /* U+0344 */
  0x0000,   /* U+0345 */
  0x0000,   /* U+0346 */
  0x0000,   /* U+0347 */
  0x0000,   /* U+0348 */
  0x0000,   /* U+0349 */
  0x0000,   /* U+034A */
  0x0000,   /* U+034B */
  0x0000,   /* U+034C */
  0x0000,   /* U+034D */
  0x0000,   /* U+034E */
  0x0000,   /* U+034F */
  0x0000,   /* U+0350 */
  0x0000,   /* U+0351 */
  0x0000,   /* U+0352 */
  0x0000,   /* U+0353 */
  0x0000,   /* U+0354 */
  0x0000,   /* U+0355 */
  0x0000,   /* U+0356 */
  0x0000,   /* U+0357 */
  0x0000,   /* U+0358 */
  0x0000,   /* U+0359 */
  0x0000,   /* U+035A */
  0x0000,   /* U+035B */
  0x0000,   /* U+035C */
  0x0000,   /* U+035D */
  0x0000,   /* U+035E */
  0x0000,   /* U+035F */
  0x0000,   /* U+0360 */
  0x0000,   /* U+0361 */
  0x0000,   /* U+0362 */
  0x0000,   /* U+0363 */
  0x0000,   /* U+0364 */
  0x0000,   /* U+0365 */
  0x0000,   /* U+0366 */
  0x0000,   /* U+0367 */
  0x0000,   /* U+0368 */
  0x0000,   /* U+0369 */
  0x0000,   /* U+036A */
  0x0000,   /* U+036B */
  0x0000,   /* U+036C */
  0x0000,   /* U+036D */
  0x0000,   /* U+036E */
  0x0000,   /* U+036F */
  0x0000,   /* U+0370 */
  0x0000,   /* U+0371 */
  0x0000,   /* U+0372 */
  0x0000,   /* U+0373 */
  0x0000,   /* U+0374 */
  0x0000,   /* U+0375 */
  0x0000,   /* U+0376 */
  0x0000,   /* U+0377 */
  0x0000,   /* U+0378 */
  0x0000,   /* U+0379 */
  0x0000,   /* U+037A */
  0x0000,   /* U+037B */
  0x0000,   /* U+037C */
  0x0000,   /* U+037D */
  0x0000,   /* U+037E */
  0x0000,   /* U+037F */
  0x0000,   /* U+0380 */
  0x0000,   /* U+0381 */
  0x0000,   /* U+0382 */
  0x0000,   /* U+0383 */
  0x0000,   /* U+0384 */
  0x0000,   /* U+0385 */
  0x0000,   /* U+0386 */
  0x0000,   /* U+0387 */
  0x0000,   /* U+0388 */
  0x0000,   /* U+0389 */
  0x0000,   /* U+038A */
  0x0000,   /* U+038B */
  0x0000,   /* U+038C */
  0x0000,   /* U+038D */
  0x0000,   /* U+038E */
  0x0000,   /* U+038F */
  0x0000,   /* U+0390 */
  0x0000,   /* U+0391 */
  0x0000,   /* U+0392 */
  0x0000,   /* U+0393 */
  0x0000,   /* U+0394 */
  0x0000,   /* U+0395 */
  0x0000,   /* U+0396 */
  0x0000,   /* U+0397 */
  0x0000,   /* U+0398 */
  0x0000,   /* U+0399 */
  0x0000,   /* U+039A */
  0x0000,   /* U+039B */
  0x0000,   /* U+039C */
  0x0000,   /* U+039D */
  0x0000,   /* U+039E */
  0x0000,   /* U+039F */
  0x0000,   /* U+03A0 */
  0x0000,   /* U+03A1 */
  0x0000,   /* U+03A2 */
  0x0000,   /* U+03A3 */
  0x0000,   /* U+03A4 */
  0x0000,   /* U+03A5 */
  0x0000,   /* U+03A6 */
  0x0000,   /* U+03A7 */
  0x0000,   /* U+03A8 */
  0x0000,   /* U+03A9 */
  0x0000,   /* U+03AA */
  0x0000,   /* U+03AB */
  0x0000,   /* U+03AC */
  0x0000,   /* U+03AD */
  0x0000,   /* U+03AE */
  0x0000,   /* U+03AF */
  0x0000,   /* U+03B0 */
  0x0000,   /* U+03B1 */
  0x0000,   /* U+03B2 */
  0x0000,   /* U+03B3 */
  0x0000,   /* U+03B4 */
  0x0000,   /* U+03B5 */
  0x0000,   /* U+03B6 */
  0x0000,   /* U+03B7 */
  0x0000,   /* U+03B8 */
  0x0000,   /* U+03B9 */
  0x0000,   /* U+03BA */
  0x0000,   /* U+03BB */
  0x0000,   /* U+03BC */
  0x0000,   /* U+03BD */
  0x0000,   /* U+03BE */
  0x0000,   /* U+03BF */
  0x0000,   /* U+03C0 */
  0x0000,   /* U+03C1 */
  0x0000,   /* U+03C2 */
  0x0000,   /* U+03C3 */
  0x0000,   /* U+03C4 */
  0x0000,   /* U+03C5 */
  0x0000,   /* U+03C6 */
  0x0000,   /* U+03C7 */
  0x0000,   /* U+03C8 */
  0x0000,   /* U+03C9 */
  0x0000,   /* U+03CA */
  0x0000,   /* U+03CB */
  0x0000,   /* U+03CC */
  0x0000,   /* U+03CD */
  0x0000,   /* U+03CE */
  0x1FC6,   /* U+03CF */
  0x0000,   /* U+03D0 */
  0x0000,   /* U+03D1 */
  0x0000,   /* U+03D2 */
  0x0000,   /* U+03D3 */
  0x0000,   /* U+03D4 */
  0x0000,   /* U+03D5 */
  0x0000,   /* U+03D6 */
  0x1FC6,   /* U+03D7 */
  0x0000,   /* U+03D8 */
  0x0000,   /* U+03D9 */
  0x0000,   /* U+03DA */
  0x0000,   /* U+03DB */
  0x0000,   /* U+03DC */
  0x0000,   /* U+03DD */
  0x0000,   /* U+03DE */
  0x0000,   /* U+03DF */
  0x0000,   /* U+03E0 */
  0x0000,   /* U+03E1 */
  0x0000,   /* U+03E2 */
  0x0000,   /* U+03E3 */
  0x0000,   /* U+03E4 */
  0x0000,   /* U+03E5 */
  0x0000,   /* U+03E6 */
  0x0000,   /* U+03E7 */
  0x0000,   /* U+03E8 */
  0x0000,   /* U+03E9 */
  0x0000,   /* U+03EA */
  0x0000,   /* U+03EB */
  0x0000,   /* U+03EC */
  0x0000,   /* U+03ED */
  0x0000,   /* U+03EE */
  0x0000,   /* U+03EF */
  0x0000,   /* U+03F0 */
  0x0000,   /* U+03F1 */
  0x0000,   /* U+03F2 */
  0x0000,   /* U+03F3 */
  0x0000,   /* U+03F4 */
  0x0000,   /* U+03F5 */
  0x0000,   /* U+03F6 */
  0x0000,   /* U+03F7 */
  0x0000,   /* U+03F8 */
  0x0000,   /* U+03F9 */
  0x0000,   /* U+03FA */
  0x0000,   /* U+03FB */
  0x0000,   /* U+03FC */
  0x0000,   /* U+03FD */
  0x0000,   /* U+03FE */
  0x0000,   /* U+03FF */

  /* Secondary weight 3 for each character. */
  0x0000,   /* U+0300 */
  0x0000,   /* U+0301 */
  0x0000,   /* U+0302 */
  0x0000,   /* U+0303 */
  0x0000,   /* U+0304 */
  0x0000,   /* U+0305 */
  0x0000,   /* U+0306 */
  0x0000,   /* U+0307 */
  0x0000,   /* U+0308 */
  0x0000,   /* U+0309 */
  0x0000,   /* U+030A */
  0x0000,   /* U+030B */
  0x0000,   /* U+030C */
  0x0000,   /* U+030D */
  0x0000,   /* U+030E */
  0x0000,   /* U+030F */
  0x0000,   /* U+0310 */
  0x0000,   /* U+0311 */
  0x0000,   /* U+0312 */
  0x0000,   /* U+0313 */
  0x0000,   /* U+0314 */
  0x0000,   /* U+0315 */
  0x0000,   /* U+0316 */
  0x0000,   /* U+0317 */
  0x0000,   /* U+0318 */
  0x0000,   /* U+0319 */
  0x0000,   /* U+031A */
  0x0000,   /* U+031B */
  0x0000,   /* U+031C */
  0x0000,   /* U+031D */
  0x0000,   /* U+031E */
  0x0000,   /* U+031F */
  0x0000,   /* U+0320 */
  0x0000,   /* U+0321 */
  0x0000,   /* U+0322 */
  0x0000,   /* U+0323 */
  0x0000,   /* U+0324 */
  0x0000,   /* U+0325 */
  0x0000,   /* U+0326 */
  0x0000,   /* U+0327 */
  0x0000,   /* U+0328 */
  0x0000,   /* U+0329 */
  0x0000,   /* U+032A */
  0x0000,   /* U+032B */
  0x0000,   /* U+032C */
  0x0000,   /* U+032D */
  0x0000,   /* U+032E */
  0x0000,   /* U+032F */
  0x0000,   /* U+0330 */
  0x0000,   /* U+0331 */
  0x0000,   /* U+0332 */
  0x0000,   /* U+0333 */
  0x0000,   /* U+0334 */
  0x0000,   /* U+0335 */
  0x0000,   /* U+0336 */
  0x0000,   /* U+0337 */
  0x0000,   /* U+0338 */
  0x0000,   /* U+0339 */
  0x0000,   /* U+033A */
  0x0000,   /* U+033B */
  0x0000,   /* U+033C */
  0x0000,   /* U+033D */
  0x0000,   /* U+033E */
  0x0000,   /* U+033F */
  0x0000,   /* U+0340 */
  0x0000,   /* U+0341 */
  0x0000,   /* U+0342 */
  0x0000,   /* U+0343 */
  0x0000,   /* U+0344 */
  0x0000,   /* U+0345 */
  0x0000,   /* U+0346 */
  0x0000,   /* U+0347 */
  0x0000,   /* U+0348 */
  0x0000,   /* U+0349 */
  0x0000,   /* U+034A */
  0x0000,   /* U+034B */
  0x0000,   /* U+034C */
  0x0000,   /* U+034D */
  0x0000,   /* U+034E */
  0x0000,   /* U+034F */
  0x0000,   /* U+0350 */
  0x0000,   /* U+0351 */
  0x0000,   /* U+0352 */
  0x0000,   /* U+0353 */
  0x0000,   /* U+0354 */
  0x0000,   /* U+0355 */
  0x0000,   /* U+0356 */
  0x0000,   /* U+0357 */
  0x0000,   /* U+0358 */
  0x0000,   /* U+0359 */
  0x0000,   /* U+035A */
  0x0000,   /* U+035B */
  0x0000,   /* U+035C */
  0x0000,   /* U+035D */
  0x0000,   /* U+035E */
  0x0000,   /* U+035F */
  0x0000,   /* U+0360 */
  0x0000,   /* U+0361 */
  0x0000,   /* U+0362 */
  0x0000,   /* U+0363 */
  0x0000,   /* U+0364 */
  0x0000,   /* U+0365 */
  0x0000,   /* U+0366 */
  0x0000,   /* U+0367 */
  0x0000,   /* U+0368 */
  0x0000,   /* U+0369 */
  0x0000,   /* U+036A */
  0x0000,   /* U+036B */
  0x0000,   /* U+036C */
  0x0000,   /* U+036D */
  0x0000,   /* U+036E */
  0x0000,   /* U+036F */
  0x0000,   /* U+0370 */
  0x0000,   /* U+0371 */
  0x0000,   /* U+0372 */
  0x0000,   /* U+0373 */
  0x0000,   /* U+0374 */
  0x0000,   /* U+0375 */
  0x0000,   /* U+0376 */
  0x0000,   /* U+0377 */
  0x0000,   /* U+0378 */
  0x0000,   /* U+0379 */
  0x0000,   /* U+037A */
  0x0000,   /* U+037B */
  0x0000,   /* U+037C */
  0x0000,   /* U+037D */
  0x0000,   /* U+037E */
  0x0000,   /* U+037F */
  0x0000,   /* U+0380 */
  0x0000,   /* U+0381 */
  0x0000,   /* U+0382 */
  0x0000,   /* U+0383 */
  0x0000,   /* U+0384 */
  0x0000,   /* U+0385 */
  0x0000,   /* U+0386 */
  0x0000,   /* U+0387 */
  0x0000,   /* U+0388 */
  0x0000,   /* U+0389 */
  0x0000,   /* U+038A */
  0x0000,   /* U+038B */
  0x0000,   /* U+038C */
  0x0000,   /* U+038D */
  0x0000,   /* U+038E */
  0x0000,   /* U+038F */
  0x0024,   /* U+0390 */
  0x0000,   /* U+0391 */
  0x0000,   /* U+0392 */
  0x0000,   /* U+0393 */
  0x0000,   /* U+0394 */
  0x0000,   /* U+0395 */
  0x0000,   /* U+0396 */
  0x0000,   /* U+0397 */
  0x0000,   /* U+0398 */
  0x0000,   /* U+0399 */
  0x0000,   /* U+039A */
  0x0000,   /* U+039B */
  0x0000,   /* U+039C */
  0x0000,   /* U+039D */
  0x0000,   /* U+039E */
  0x0000,   /* U+039F */
  0x0000,   /* U+03A0 */
  0x0000,   /* U+03A1 */
  0x0000,   /* U+03A2 */
  0x0000,   /* U+03A3 */
  0x0000,   /* U+03A4 */
  0x0000,   /* U+03A5 */
  0x0000,   /* U+03A6 */
  0x0000,   /* U+03A7 */
  0x0000,   /* U+03A8 */
  0x0000,   /* U+03A9 */
  0x0000,   /* U+03AA */
  0x0000,   /* U+03AB */
  0x0000,   /* U+03AC */
  0x0000,   /* U+03AD */
  0x0000,   /* U+03AE */
  0x0000,   /* U+03AF */
  0x0024,   /* U+03B0 */
  0x0000,   /* U+03B1 */
  0x0000,   /* U+03B2 */
  0x0000,   /* U+03B3 */
  0x0000,   /* U+03B4 */
  0x0000,   /* U+03B5 */
  0x0000,   /* U+03B6 */
  0x0000,   /* U+03B7 */
  0x0000,   /* U+03B8 */
  0x0000,   /* U+03B9 */
  0x0000,   /* U+03BA */
  0x0000,   /* U+03BB */
  0x0000,   /* U+03BC */
  0x0000,   /* U+03BD */
  0x0000,   /* U+03BE */
  0x0000,   /* U+03BF */
  0x0000,   /* U+03C0 */
  0x0000,   /* U+03C1 */
  0x0000,   /* U+03C2 */
  0x0000,   /* U+03C3 */
  0x0000,   /* U+03C4 */
  0x0000,   /* U+03C5 */
  0x0000,   /* U+03C6 */
  0x0000,   /* U+03C7 */
  0x0000,   /* U+03C8 */
  0x0000,   /* U+03C9 */
  0x0000,   /* U+03CA */
  0x0000,   /* U+03CB */
  0x0000,   /* U+03CC */
  0x0000,   /* U+03CD */
  0x0000,   /* U+03CE */
  0x0020,   /* U+03CF */
  0x0000,   /* U+03D0 */
  0x0000,   /* U+03D1 */
  0x0000,   /* U+03D2 */
  0x0000,   /* U+03D3 */
  0x0000,   /* U+03D4 */
  0x0000,   /* U+03D5 */
  0x0000,   /* U+03D6 */
  0x0020,   /* U+03D7 */
  0x0000,   /* U+03D8 */
  0x0000,   /* U+03D9 */
  0x0000,   /* U+03DA */
  0x0000,   /* U+03DB */
  0x0000,   /* U+03DC */
  0x0000,   /* U+03DD */
  0x0000,   /* U+03DE */
  0x0000,   /* U+03DF */
  0x0000,   /* U+03E0 */
  0x0000,   /* U+03E1 */
  0x0000,   /* U+03E2 */
  0x0000,   /* U+03E3 */
  0x0000,   /* U+03E4 */
  0x0000,   /* U+03E5 */
  0x0000,   /* U+03E6 */
  0x0000,   /* U+03E7 */
  0x0000,   /* U+03E8 */
  0x0000,   /* U+03E9 */
  0x0000,   /* U+03EA */
  0x0000,   /* U+03EB */
  0x0000,   /* U+03EC */
  0x0000,   /* U+03ED */
  0x0000,   /* U+03EE */
  0x0000,   /* U+03EF */
  0x0000,   /* U+03F0 */
  0x0000,   /* U+03F1 */
  0x0000,   /* U+03F2 */
  0x0000,   /* U+03F3 */
  0x0000,   /* U+03F4 */
  0x0000,   /* U+03F5 */
  0x0000,   /* U+03F6 */
  0x0000,   /* U+03F7 */
  0x0000,   /* U+03F8 */
  0x0000,   /* U+03F9 */
  0x0000,   /* U+03FA */
  0x0000,   /* U+03FB */
  0x0000,   /* U+03FC */
  0x0000,   /* U+03FD */
  0x0000,   /* U+03FE */
  0x0000,   /* U+03FF */

  /* Tertiary weight 3 for each character. */
  0x0000,   /* U+0300 */
  0x0000,   /* U+0301 */
  0x0000,   /* U+0302 */
  0x0000,   /* U+0303 */
  0x0000,   /* U+0304 */
  0x0000,   /* U+0305 */
  0x0000,   /* U+0306 */
  0x0000,   /* U+0307 */
  0x0000,   /* U+0308 */
  0x0000,   /* U+0309 */
  0x0000,   /* U+030A */
  0x0000,   /* U+030B */
  0x0000,   /* U+030C */
  0x0000,   /* U+030D */
  0x0000,   /* U+030E */
  0x0000,   /* U+030F */
  0x0000,   /* U+0310 */
  0x0000,   /* U+0311 */
  0x0000,   /* U+0312 */
  0x0000,   /* U+0313 */
  0x0000,   /* U+0314 */
  0x0000,   /* U+0315 */
  0x0000,   /* U+0316 */
  0x0000,   /* U+0317 */
  0x0000,   /* U+0318 */
  0x0000,   /* U+0319 */
  0x0000,   /* U+031A */
  0x0000,   /* U+031B */
  0x0000,   /* U+031C */
  0x0000,   /* U+031D */
  0x0000,   /* U+031E */
  0x0000,   /* U+031F */
  0x0000,   /* U+0320 */
  0x0000,   /* U+0321 */
  0x0000,   /* U+0322 */
  0x0000,   /* U+0323 */
  0x0000,   /* U+0324 */
  0x0000,   /* U+0325 */
  0x0000,   /* U+0326 */
  0x0000,   /* U+0327 */
  0x0000,   /* U+0328 */
  0x0000,   /* U+0329 */
  0x0000,   /* U+032A */
  0x0000,   /* U+032B */
  0x0000,   /* U+032C */
  0x0000,   /* U+032D */
  0x0000,   /* U+032E */
  0x0000,   /* U+032F */
  0x0000,   /* U+0330 */
  0x0000,   /* U+0331 */
  0x0000,   /* U+0332 */
  0x0000,   /* U+0333 */
  0x0000,   /* U+0334 */
  0x0000,   /* U+0335 */
  0x0000,   /* U+0336 */
  0x0000,   /* U+0337 */
  0x0000,   /* U+0338 */
  0x0000,   /* U+0339 */
  0x0000,   /* U+033A */
  0x0000,   /* U+033B */
  0x0000,   /* U+033C */
  0x0000,   /* U+033D */
  0x0000,   /* U+033E */
  0x0000,   /* U+033F */
  0x0000,   /* U+0340 */
  0x0000,   /* U+0341 */
  0x0000,   /* U+0342 */
  0x0000,   /* U+0343 */
  0x0000,   /* U+0344 */
  0x0000,   /* U+0345 */
  0x0000,   /* U+0346 */
  0x0000,   /* U+0347 */
  0x0000,   /* U+0348 */
  0x0000,   /* U+0349 */
  0x0000,   /* U+034A */
  0x0000,   /* U+034B */
  0x0000,   /* U+034C */
  0x0000,   /* U+034D */
  0x0000,   /* U+034E */
  0x0000,   /* U+034F */
  0x0000,   /* U+0350 */
  0x0000,   /* U+0351 */
  0x0000,   /* U+0352 */
  0x0000,   /* U+0353 */
  0x0000,   /* U+0354 */
  0x0000,   /* U+0355 */
  0x0000,   /* U+0356 */
  0x0000,   /* U+0357 */
  0x0000,   /* U+0358 */
  0x0000,   /* U+0359 */
  0x0000,   /* U+035A */
  0x0000,   /* U+035B */
  0x0000,   /* U+035C */
  0x0000,   /* U+035D */
  0x0000,   /* U+035E */
  0x0000,   /* U+035F */
  0x0000,   /* U+0360 */
  0x0000,   /* U+0361 */
  0x0000,   /* U+0362 */
  0x0000,   /* U+0363 */
  0x0000,   /* U+0364 */
  0x0000,   /* U+0365 */
  0x0000,   /* U+0366 */
  0x0000,   /* U+0367 */
  0x0000,   /* U+0368 */
  0x0000,   /* U+0369 */
  0x0000,   /* U+036A */
  0x0000,   /* U+036B */
  0x0000,   /* U+036C */
  0x0000,   /* U+036D */
  0x0000,   /* U+036E */
  0x0000,   /* U+036F */
  0x0000,   /* U+0370 */
  0x0000,   /* U+0371 */
  0x0000,   /* U+0372 */
  0x0000,   /* U+0373 */
  0x0000,   /* U+0374 */
  0x0000,   /* U+0375 */
  0x0000,   /* U+0376 */
  0x0000,   /* U+0377 */
  0x0000,   /* U+0378 */
  0x0000,   /* U+0379 */
  0x0000,   /* U+037A */
  0x0000,   /* U+037B */
  0x0000,   /* U+037C */
  0x0000,   /* U+037D */
  0x0000,   /* U+037E */
  0x0000,   /* U+037F */
  0x0000,   /* U+0380 */
  0x0000,   /* U+0381 */
  0x0000,   /* U+0382 */
  0x0000,   /* U+0383 */
  0x0000,   /* U+0384 */
  0x0000,   /* U+0385 */
  0x0000,   /* U+0386 */
  0x0000,   /* U+0387 */
  0x0000,   /* U+0388 */
  0x0000,   /* U+0389 */
  0x0000,   /* U+038A */
  0x0000,   /* U+038B */
  0x0000,   /* U+038C */
  0x0000,   /* U+038D */
  0x0000,   /* U+038E */
  0x0000,   /* U+038F */
  0x0002,   /* U+0390 */
  0x0000,   /* U+0391 */
  0x0000,   /* U+0392 */
  0x0000,   /* U+0393 */
  0x0000,   /* U+0394 */
  0x0000,   /* U+0395 */
  0x0000,   /* U+0396 */
  0x0000,   /* U+0397 */
  0x0000,   /* U+0398 */
  0x0000,   /* U+0399 */
  0x0000,   /* U+039A */
  0x0000,   /* U+039B */
  0x0000,   /* U+039C */
  0x0000,   /* U+039D */
  0x0000,   /* U+039E */
  0x0000,   /* U+039F */
  0x0000,   /* U+03A0 */
  0x0000,   /* U+03A1 */
  0x0000,   /* U+03A2 */
  0x0000,   /* U+03A3 */
  0x0000,   /* U+03A4 */
  0x0000,   /* U+03A5 */
  0x0000,   /* U+03A6 */
  0x0000,   /* U+03A7 */
  0x0000,   /* U+03A8 */
  0x0000,   /* U+03A9 */
  0x0000,   /* U+03AA */
  0x0000,   /* U+03AB */
  0x0000,   /* U+03AC */
  0x0000,   /* U+03AD */
  0x0000,   /* U+03AE */
  0x0000,   /* U+03AF */
  0x0002,   /* U+03B0 */
  0x0000,   /* U+03B1 */
  0x0000,   /* U+03B2 */
  0x0000,   /* U+03B3 */
  0x0000,   /* U+03B4 */
  0x0000,   /* U+03B5 */
  0x0000,   /* U+03B6 */
  0x0000,   /* U+03B7 */
  0x0000,   /* U+03B8 */
  0x0000,   /* U+03B9 */
  0x0000,   /* U+03BA */
  0x0000,   /* U+03BB */
  0x0000,   /* U+03BC */
  0x0000,   /* U+03BD */
  0x0000,   /* U+03BE */
  0x0000,   /* U+03BF */
  0x0000,   /* U+03C0 */
  0x0000,   /* U+03C1 */
  0x0000,   /* U+03C2 */
  0x0000,   /* U+03C3 */
  0x0000,   /* U+03C4 */
  0x0000,   /* U+03C5 */
  0x0000,   /* U+03C6 */
  0x0000,   /* U+03C7 */
  0x0000,   /* U+03C8 */
  0x0000,   /* U+03C9 */
  0x0000,   /* U+03CA */
  0x0000,   /* U+03CB */
  0x0000,   /* U+03CC */
  0x0000,   /* U+03CD */
  0x0000,   /* U+03CE */
  0x0004,   /* U+03CF */
  0x0000,   /* U+03D0 */
  0x0000,   /* U+03D1 */
  0x0000,   /* U+03D2 */
  0x0000,   /* U+03D3 */
  0x0000,   /* U+03D4 */
  0x0000,   /* U+03D5 */
  0x0000,   /* U+03D6 */
  0x0004,   /* U+03D7 */
  0x0000,   /* U+03D8 */
  0x0000,   /* U+03D9 */
  0x0000,   /* U+03DA */
  0x0000,   /* U+03DB */
  0x0000,   /* U+03DC */
  0x0000,   /* U+03DD */
  0x0000,   /* U+03DE */
  0x0000,   /* U+03DF */
  0x0000,   /* U+03E0 */
  0x0000,   /* U+03E1 */
  0x0000,   /* U+03E2 */
  0x0000,   /* U+03E3 */
  0x0000,   /* U+03E4 */
  0x0000,   /* U+03E5 */
  0x0000,   /* U+03E6 */
  0x0000,   /* U+03E7 */
  0x0000,   /* U+03E8 */
  0x0000,   /* U+03E9 */
  0x0000,   /* U+03EA */
  0x0000,   /* U+03EB */
  0x0000,   /* U+03EC */
  0x0000,   /* U+03ED */
  0x0000,   /* U+03EE */
  0x0000,   /* U+03EF */
  0x0000,   /* U+03F0 */
  0x0000,   /* U+03F1 */
  0x0000,   /* U+03F2 */
  0x0000,   /* U+03F3 */
  0x0000,   /* U+03F4 */
  0x0000,   /* U+03F5 */
  0x0000,   /* U+03F6 */
  0x0000,   /* U+03F7 */
  0x0000,   /* U+03F8 */
  0x0000,   /* U+03F9 */
  0x0000,   /* U+03FA */
  0x0000,   /* U+03FB */
  0x0000,   /* U+03FC */
  0x0000,   /* U+03FD */
  0x0000,   /* U+03FE */
  0x0000,   /* U+03FF */
};

uint16 uca900_p004[]= {
  /* Number of CEs for each character. */
  2, 2, 1, 2, 1, 1, 1, 2, 1, 1, 1, 1, 2, 2, 2, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  2, 2, 1, 2, 1, 1, 1, 2, 1, 1, 1, 1, 2, 2, 2, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  2, 2, 2, 2, 1, 1, 2, 2, 1, 1, 2, 2, 2, 2, 2, 2,
  1, 1, 2, 2, 2, 2, 2, 2, 1, 1, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 1, 1, 2, 2, 1, 1, 1, 1, 1, 1,

  /* Primary weight 1 for each character. */
  0x205A,   /* U+0400 */
  0x205A,   /* U+0401 */
  0x2050,   /* U+0402 */
  0x2036,   /* U+0403 */
  0x205E,   /* U+0404 */
  0x2074,   /* U+0405 */
  0x2088,   /* U+0406 */
  0x2088,   /* U+0407 */
  0x2091,   /* U+0408 */
  0x20BC,   /* U+0409 */
  0x20E2,   /* U+040A */
  0x2119,   /* U+040B */
  0x2096,   /* U+040C */
  0x2080,   /* U+040D */
  0x211D,   /* U+040E */
  0x217F,   /* U+040F */
  0x2022,   /* U+0410 */
  0x202E,   /* U+0411 */
  0x2032,   /* U+0412 */
  0x2036,   /* U+0413 */
  0x204A,   /* U+0414 */
  0x205A,   /* U+0415 */
  0x2062,   /* U+0416 */
  0x206C,   /* U+0417 */
  0x2080,   /* U+0418 */
  0x208D,   /* U+0419 */
  0x2096,   /* U+041A */
  0x20B0,   /* U+041B */
  0x20C3,   /* U+041C */
  0x20CC,   /* U+041D */
  0x20E7,   /* U+041E */
  0x20EF,   /* U+041F */
  0x20FC,   /* U+0420 */
  0x2105,   /* U+0421 */
  0x210E,   /* U+0422 */
  0x211D,   /* U+0423 */
  0x212E,   /* U+0424 */
  0x2132,   /* U+0425 */
  0x2159,   /* U+0426 */
  0x2164,   /* U+0427 */
  0x2183,   /* U+0428 */
  0x2188,   /* U+0429 */
  0x218F,   /* U+042A */
  0x2194,   /* U+042B */
  0x2198,   /* U+042C */
  0x21A5,   /* U+042D */
  0x21A9,   /* U+042E */
  0x21AF,   /* U+042F */
  0x2022,   /* U+0430 */
  0x202E,   /* U+0431 */
  0x2032,   /* U+0432 */
  0x2036,   /* U+0433 */
  0x204A,   /* U+0434 */
  0x205A,   /* U+0435 */
  0x2062,   /* U+0436 */
  0x206C,   /* U+0437 */
  0x2080,   /* U+0438 */
  0x208D,   /* U+0439 */
  0x2096,   /* U+043A */
  0x20B0,   /* U+043B */
  0x20C3,   /* U+043C */
  0x20CC,   /* U+043D */
  0x20E7,   /* U+043E */
  0x20EF,   /* U+043F */
  0x20FC,   /* U+0440 */
  0x2105,   /* U+0441 */
  0x210E,   /* U+0442 */
  0x211D,   /* U+0443 */
  0x212E,   /* U+0444 */
  0x2132,   /* U+0445 */
  0x2159,   /* U+0446 */
  0x2164,   /* U+0447 */
  0x2183,   /* U+0448 */
  0x2188,   /* U+0449 */
  0x218F,   /* U+044A */
  0x2194,   /* U+044B */
  0x2198,   /* U+044C */
  0x21A5,   /* U+044D */
  0x21A9,   /* U+044E */
  0x21AF,   /* U+044F */
  0x205A,   /* U+0450 */
  0x205A,   /* U+0451 */
  0x2050,   /* U+0452 */
  0x2036,   /* U+0453 */
  0x205E,   /* U+0454 */
  0x2074,   /* U+0455 */
  0x2088,   /* U+0456 */
  0x2088,   /* U+0457 */
  0x2091,   /* U+0458 */
  0x20BC,   /* U+0459 */
  0x20E2,   /* U+045A */
  0x2119,   /* U+045B */
  0x2096,   /* U+045C */
  0x2080,   /* U+045D */
  0x211D,   /* U+045E */
  0x217F,   /* U+045F */
  0x2148,   /* U+0460 */
  0x2148,   /* U+0461 */
  0x21A0,   /* U+0462 */
  0x21A0,   /* U+0463 */
  0x21B4,   /* U+0464 */
  0x21B4,   /* U+0465 */
  0x21B8,   /* U+0466 */
  0x21B8,   /* U+0467 */
  0x21C2,   /* U+0468 */
  0x21C2,   /* U+0469 */
  0x21BD,   /* U+046A */
  0x21BD,   /* U+046B */
  0x21C7,   /* U+046C */
  0x21C7,   /* U+046D */
  0x21CB,   /* U+046E */
  0x21CB,   /* U+046F */
  0x21CF,   /* U+0470 */
  0x21CF,   /* U+0471 */
  0x21D3,   /* U+0472 */
  0x21D3,   /* U+0473 */
  0x21D7,   /* U+0474 */
  0x21D7,   /* U+0475 */
  0x21D7,   /* U+0476 */
  0x21D7,   /* U+0477 */
  0x212A,   /* U+0478 */
  0x212A,   /* U+0479 */
  0x2155,   /* U+047A */
  0x2155,   /* U+047B */
  0x2151,   /* U+047C */
  0x2151,   /* U+047D */
  0x214C,   /* U+047E */
  0x214C,   /* U+047F */
  0x20F8,   /* U+0480 */
  0x20F8,   /* U+0481 */
  0x04F7,   /* U+0482 */
  0x0000,   /* U+0483 */
  0x0000,   /* U+0484 */
  0x0000,   /* U+0485 */
  0x0000,   /* U+0486 */
  0x0000,   /* U+0487 */
  0x0000,   /* U+0488 */
  0x0000,   /* U+0489 */
  0x2084,   /* U+048A */
  0x2084,   /* U+048B */
  0x219C,   /* U+048C */
  0x219C,   /* U+048D */
  0x2100,   /* U+048E */
  0x2100,   /* U+048F */
  0x2036,   /* U+0490 */
  0x2036,   /* U+0491 */
  0x203A,   /* U+0492 */
  0x203A,   /* U+0493 */
  0x2042,   /* U+0494 */
  0x2042,   /* U+0495 */
  0x2068,   /* U+0496 */
  0x2068,   /* U+0497 */
  0x2056,   /* U+0498 */
  0x2056,   /* U+0499 */
  0x209A,   /* U+049A */
  0x209A,   /* U+049B */
  0x20AA,   /* U+049C */
  0x20AA,   /* U+049D */
  0x20A6,   /* U+049E */
  0x20A6,   /* U+049F */
  0x20A2,   /* U+04A0 */
  0x20A2,   /* U+04A1 */
  0x20D5,   /* U+04A2 */
  0x20D5,   /* U+04A3 */
  0x20DE,   /* U+04A4 */
  0x20DE,   /* U+04A5 */
  0x20F4,   /* U+04A6 */
  0x20F4,   /* U+04A7 */
  0x21DC,   /* U+04A8 */
  0x21DC,   /* U+04A9 */
  0x210A,   /* U+04AA */
  0x210A,   /* U+04AB */
  0x2114,   /* U+04AC */
  0x2114,   /* U+04AD */
  0x2121,   /* U+04AE */
  0x2121,   /* U+04AF */
  0x2125,   /* U+04B0 */
  0x2125,   /* U+04B1 */
  0x213E,   /* U+04B2 */
  0x213E,   /* U+04B3 */
  0x215F,   /* U+04B4 */
  0x215F,   /* U+04B5 */
  0x216A,   /* U+04B6 */
  0x216A,   /* U+04B7 */
  0x2172,   /* U+04B8 */
  0x2172,   /* U+04B9 */
  0x2142,   /* U+04BA */
  0x2142,   /* U+04BB */
  0x2177,   /* U+04BC */
  0x2177,   /* U+04BD */
  0x217B,   /* U+04BE */
  0x217B,   /* U+04BF */
  0x21E1,   /* U+04C0 */
  0x2062,   /* U+04C1 */
  0x2062,   /* U+04C2 */
  0x209E,   /* U+04C3 */
  0x209E,   /* U+04C4 */
  0x20B5,   /* U+04C5 */
  0x20B5,   /* U+04C6 */
  0x20D9,   /* U+04C7 */
  0x20D9,   /* U+04C8 */
  0x20D1,   /* U+04C9 */
  0x20D1,   /* U+04CA */
  0x216E,   /* U+04CB */
  0x216E,   /* U+04CC */
  0x20C7,   /* U+04CD */
  0x20C7,   /* U+04CE */
  0x21E1,   /* U+04CF */
  0x2022,   /* U+04D0 */
  0x2022,   /* U+04D1 */
  0x2022,   /* U+04D2 */
  0x2022,   /* U+04D3 */
  0x202A,   /* U+04D4 */
  0x202A,   /* U+04D5 */
  0x205A,   /* U+04D6 */
  0x205A,   /* U+04D7 */
  0x2026,   /* U+04D8 */
  0x2026,   /* U+04D9 */
  0x2026,   /* U+04DA */
  0x2026,   /* U+04DB */
  0x2062,   /* U+04DC */
  0x2062,   /* U+04DD */
  0x206C,   /* U+04DE */
  0x206C,   /* U+04DF */
  0x2079,   /* U+04E0 */
  0x2079,   /* U+04E1 */
  0x2080,   /* U+04E2 */
  0x2080,   /* U+04E3 */
  0x2080,   /* U+04E4 */
  0x2080,   /* U+04E5 */
  0x20E7,   /* U+04E6 */
  0x20E7,   /* U+04E7 */
  0x20EB,   /* U+04E8 */
  0x20EB,   /* U+04E9 */
  0x20EB,   /* U+04EA */
  0x20EB,   /* U+04EB */
  0x21A5,   /* U+04EC */
  0x21A5,   /* U+04ED */
  0x211D,   /* U+04EE */
  0x211D,   /* U+04EF */
  0x211D,   /* U+04F0 */
  0x211D,   /* U+04F1 */
  0x211D,   /* U+04F2 */
  0x211D,   /* U+04F3 */
  0x2164,   /* U+04F4 */
  0x2164,   /* U+04F5 */
  0x2046,   /* U+04F6 */
  0x2046,   /* U+04F7 */
  0x2194,   /* U+04F8 */
  0x2194,   /* U+04F9 */
  0x203E,   /* U+04FA */
  0x203E,   /* U+04FB */
  0x2136,   /* U+04FC */
  0x2136,   /* U+04FD */
  0x213A,   /* U+04FE */
  0x213A,   /* U+04FF */

  /* Secondary weight 1 for each character. */
  0x0020,   /* U+0400 */
  0x0020,   /* U+0401 */
  0x0020,   /* U+0402 */
  0x0020,   /* U+0403 */
  0x0020,   /* U+0404 */
  0x0020,   /* U+0405 */
  0x0020,   /* U+0406 */
  0x0020,   /* U+0407 */
  0x0020,   /* U+0408 */
  0x0020,   /* U+0409 */
  0x0020,   /* U+040A */
  0x0020,   /* U+040B */
  0x0020,   /* U+040C */
  0x0020,   /* U+040D */
  0x0020,   /* U+040E */
  0x0020,   /* U+040F */
  0x0020,   /* U+0410 */
  0x0020,   /* U+0411 */
  0x0020,   /* U+0412 */
  0x0020,   /* U+0413 */
  0x0020,   /* U+0414 */
  0x0020,   /* U+0415 */
  0x0020,   /* U+0416 */
  0x0020,   /* U+0417 */
  0x0020,   /* U+0418 */
  0x0020,   /* U+0419 */
  0x0020,   /* U+041A */
  0x0020,   /* U+041B */
  0x0020,   /* U+041C */
  0x0020,   /* U+041D */
  0x0020,   /* U+041E */
  0x0020,   /* U+041F */
  0x0020,   /* U+0420 */
  0x0020,   /* U+0421 */
  0x0020,   /* U+0422 */
  0x0020,   /* U+0423 */
  0x0020,   /* U+0424 */
  0x0020,   /* U+0425 */
  0x0020,   /* U+0426 */
  0x0020,   /* U+0427 */
  0x0020,   /* U+0428 */
  0x0020,   /* U+0429 */
  0x0020,   /* U+042A */
  0x0020,   /* U+042B */
  0x0020,   /* U+042C */
  0x0020,   /* U+042D */
  0x0020,   /* U+042E */
  0x0020,   /* U+042F */
  0x0020,   /* U+0430 */
  0x0020,   /* U+0431 */
  0x0020,   /* U+0432 */
  0x0020,   /* U+0433 */
  0x0020,   /* U+0434 */
  0x0020,   /* U+0435 */
  0x0020,   /* U+0436 */
  0x0020,   /* U+0437 */
  0x0020,   /* U+0438 */
  0x0020,   /* U+0439 */
  0x0020,   /* U+043A */
  0x0020,   /* U+043B */
  0x0020,   /* U+043C */
  0x0020,   /* U+043D */
  0x0020,   /* U+043E */
  0x0020,   /* U+043F */
  0x0020,   /* U+0440 */
  0x0020,   /* U+0441 */
  0x0020,   /* U+0442 */
  0x0020,   /* U+0443 */
  0x0020,   /* U+0444 */
  0x0020,   /* U+0445 */
  0x0020,   /* U+0446 */
  0x0020,   /* U+0447 */
  0x0020,   /* U+0448 */
  0x0020,   /* U+0449 */
  0x0020,   /* U+044A */
  0x0020,   /* U+044B */
  0x0020,   /* U+044C */
  0x0020,   /* U+044D */
  0x0020,   /* U+044E */
  0x0020,   /* U+044F */
  0x0020,   /* U+0450 */
  0x0020,   /* U+0451 */
  0x0020,   /* U+0452 */
  0x0020,   /* U+0453 */
  0x0020,   /* U+0454 */
  0x0020,   /* U+0455 */
  0x0020,   /* U+0456 */
  0x0020,   /* U+0457 */
  0x0020,   /* U+0458 */
  0x0020,   /* U+0459 */
  0x0020,   /* U+045A */
  0x0020,   /* U+045B */
  0x0020,   /* U+045C */
  0x0020,   /* U+045D */
  0x0020,   /* U+045E */
  0x0020,   /* U+045F */
  0x0020,   /* U+0460 */
  0x0020,   /* U+0461 */
  0x0020,   /* U+0462 */
  0x0020,   /* U+0463 */
  0x0020,   /* U+0464 */
  0x0020,   /* U+0465 */
  0x0020,   /* U+0466 */
  0x0020,   /* U+0467 */
  0x0020,   /* U+0468 */
  0x0020,   /* U+0469 */
  0x0020,   /* U+046A */
  0x0020,   /* U+046B */
  0x0020,   /* U+046C */
  0x0020,   /* U+046D */
  0x0020,   /* U+046E */
  0x0020,   /* U+046F */
  0x0020,   /* U+0470 */
  0x0020,   /* U+0471 */
  0x0020,   /* U+0472 */
  0x0020,   /* U+0473 */
  0x0020,   /* U+0474 */
  0x0020,   /* U+0475 */
  0x0020,   /* U+0476 */
  0x0020,   /* U+0477 */
  0x0020,   /* U+0478 */
  0x0020,   /* U+0479 */
  0x0020,   /* U+047A */
  0x0020,   /* U+047B */
  0x0020,   /* U+047C */
  0x0020,   /* U+047D */
  0x0020,   /* U+047E */
  0x0020,   /* U+047F */
  0x0020,   /* U+0480 */
  0x0020,   /* U+0481 */
  0x0020,   /* U+0482 */
  0x0050,   /* U+0483 */
  0x0033,   /* U+0484 */
  0x0023,   /* U+0485 */
  0x0022,   /* U+0486 */
  0x0033,   /* U+0487 */
  0x0000,   /* U+0488 */
  0x0000,   /* U+0489 */
  0x0020,   /* U+048A */
  0x0020,   /* U+048B */
  0x0020,   /* U+048C */
  0x0020,   /* U+048D */
  0x0020,   /* U+048E */
  0x0020,   /* U+048F */
  0x0020,   /* U+0490 */
  0x0020,   /* U+0491 */
  0x0020,   /* U+0492 */
  0x0020,   /* U+0493 */
  0x0020,   /* U+0494 */
  0x0020,   /* U+0495 */
  0x0020,   /* U+0496 */
  0x0020,   /* U+0497 */
  0x0020,   /* U+0498 */
  0x0020,   /* U+0499 */
  0x0020,   /* U+049A */
  0x0020,   /* U+049B */
  0x0020,   /* U+049C */
  0x0020,   /* U+049D */
  0x0020,   /* U+049E */
  0x0020,   /* U+049F */
  0x0020,   /* U+04A0 */
  0x0020,   /* U+04A1 */
  0x0020,   /* U+04A2 */
  0x0020,   /* U+04A3 */
  0x0020,   /* U+04A4 */
  0x0020,   /* U+04A5 */
  0x0020,   /* U+04A6 */
  0x0020,   /* U+04A7 */
  0x0020,   /* U+04A8 */
  0x0020,   /* U+04A9 */
  0x0020,   /* U+04AA */
  0x0020,   /* U+04AB */
  0x0020,   /* U+04AC */
  0x0020,   /* U+04AD */
  0x0020,   /* U+04AE */
  0x0020,   /* U+04AF */
  0x0020,   /* U+04B0 */
  0x0020,   /* U+04B1 */
  0x0020,   /* U+04B2 */
  0x0020,   /* U+04B3 */
  0x0020,   /* U+04B4 */
  0x0020,   /* U+04B5 */
  0x0020,   /* U+04B6 */
  0x0020,   /* U+04B7 */
  0x0020,   /* U+04B8 */
  0x0020,   /* U+04B9 */
  0x0020,   /* U+04BA */
  0x0020,   /* U+04BB */
  0x0020,   /* U+04BC */
  0x0020,   /* U+04BD */
  0x0020,   /* U+04BE */
  0x0020,   /* U+04BF */
  0x0020,   /* U+04C0 */
  0x0020,   /* U+04C1 */
  0x0020,   /* U+04C2 */
  0x0020,   /* U+04C3 */
  0x0020,   /* U+04C4 */
  0x0020,   /* U+04C5 */
  0x0020,   /* U+04C6 */
  0x0020,   /* U+04C7 */
  0x0020,   /* U+04C8 */
  0x0020,   /* U+04C9 */
  0x0020,   /* U+04CA */
  0x0020,   /* U+04CB */
  0x0020,   /* U+04CC */
  0x0020,   /* U+04CD */
  0x0020,   /* U+04CE */
  0x0020,   /* U+04CF */
  0x0020,   /* U+04D0 */
  0x0020,   /* U+04D1 */
  0x0020,   /* U+04D2 */
  0x0020,   /* U+04D3 */
  0x0020,   /* U+04D4 */
  0x0020,   /* U+04D5 */
  0x0020,   /* U+04D6 */
  0x0020,   /* U+04D7 */
  0x0020,   /* U+04D8 */
  0x0020,   /* U+04D9 */
  0x0020,   /* U+04DA */
  0x0020,   /* U+04DB */
  0x0020,   /* U+04DC */
  0x0020,   /* U+04DD */
  0x0020,   /* U+04DE */
  0x0020,   /* U+04DF */
  0x0020,   /* U+04E0 */
  0x0020,   /* U+04E1 */
  0x0020,   /* U+04E2 */
  0x0020,   /* U+04E3 */
  0x0020,   /* U+04E4 */
  0x0020,   /* U+04E5 */
  0x0020,   /* U+04E6 */
  0x0020,   /* U+04E7 */
  0x0020,   /* U+04E8 */
  0x0020,   /* U+04E9 */
  0x0020,   /* U+04EA */
  0x0020,   /* U+04EB */
  0x0020,   /* U+04EC */
  0x0020,   /* U+04ED */
  0x0020,   /* U+04EE */
  0x0020,   /* U+04EF */
  0x0020,   /* U+04F0 */
  0x0020,   /* U+04F1 */
  0x0020,   /* U+04F2 */
  0x0020,   /* U+04F3 */
  0x0020,   /* U+04F4 */
  0x0020,   /* U+04F5 */
  0x0020,   /* U+04F6 */
  0x0020,   /* U+04F7 */
  0x0020,   /* U+04F8 */
  0x0020,   /* U+04F9 */
  0x0020,   /* U+04FA */
  0x0020,   /* U+04FB */
  0x0020,   /* U+04FC */
  0x0020,   /* U+04FD */
  0x0020,   /* U+04FE */
  0x0020,   /* U+04FF */

  /* Tertiary weight 1 for each character. */
  0x0008,   /* U+0400 */
  0x0008,   /* U+0401 */
  0x0008,   /* U+0402 */
  0x0008,   /* U+0403 */
  0x0008,   /* U+0404 */
  0x0008,   /* U+0405 */
  0x0008,   /* U+0406 */
  0x0008,   /* U+0407 */
  0x0008,   /* U+0408 */
  0x0008,   /* U+0409 */
  0x0008,   /* U+040A */
  0x0008,   /* U+040B */
  0x0008,   /* U+040C */
  0x0008,   /* U+040D */
  0x0008,   /* U+040E */
  0x0008,   /* U+040F */
  0x0008,   /* U+0410 */
  0x0008,   /* U+0411 */
  0x0008,   /* U+0412 */
  0x0008,   /* U+0413 */
  0x0008,   /* U+0414 */
  0x0008,   /* U+0415 */
  0x0008,   /* U+0416 */
  0x0008,   /* U+0417 */
  0x0008,   /* U+0418 */
  0x0008,   /* U+0419 */
  0x0008,   /* U+041A */
  0x0008,   /* U+041B */
  0x0008,   /* U+041C */
  0x0008,   /* U+041D */
  0x0008,   /* U+041E */
  0x0008,   /* U+041F */
  0x0008,   /* U+0420 */
  0x0008,   /* U+0421 */
  0x0008,   /* U+0422 */
  0x0008,   /* U+0423 */
  0x0008,   /* U+0424 */
  0x0008,   /* U+0425 */
  0x0008,   /* U+0426 */
  0x0008,   /* U+0427 */
  0x0008,   /* U+0428 */
  0x0008,   /* U+0429 */
  0x0008,   /* U+042A */
  0x0008,   /* U+042B */
  0x0008,   /* U+042C */
  0x0008,   /* U+042D */
  0x0008,   /* U+042E */
  0x0008,   /* U+042F */
  0x0002,   /* U+0430 */
  0x0002,   /* U+0431 */
  0x0002,   /* U+0432 */
  0x0002,   /* U+0433 */
  0x0002,   /* U+0434 */
  0x0002,   /* U+0435 */
  0x0002,   /* U+0436 */
  0x0002,   /* U+0437 */
  0x0002,   /* U+0438 */
  0x0002,   /* U+0439 */
  0x0002,   /* U+043A */
  0x0002,   /* U+043B */
  0x0002,   /* U+043C */
  0x0002,   /* U+043D */
  0x0002,   /* U+043E */
  0x0002,   /* U+043F */
  0x0002,   /* U+0440 */
  0x0002,   /* U+0441 */
  0x0002,   /* U+0442 */
  0x0002,   /* U+0443 */
  0x0002,   /* U+0444 */
  0x0002,   /* U+0445 */
  0x0002,   /* U+0446 */
  0x0002,   /* U+0447 */
  0x0002,   /* U+0448 */
  0x0002,   /* U+0449 */
  0x0002,   /* U+044A */
  0x0002,   /* U+044B */
  0x0002,   /* U+044C */
  0x0002,   /* U+044D */
  0x0002,   /* U+044E */
  0x0002,   /* U+044F */
  0x0002,   /* U+0450 */
  0x0002,   /* U+0451 */
  0x0002,   /* U+0452 */
  0x0002,   /* U+0453 */
  0x0002,   /* U+0454 */
  0x0002,   /* U+0455 */
  0x0002,   /* U+0456 */
  0x0002,   /* U+0457 */
  0x0002,   /* U+0458 */
  0x0002,   /* U+0459 */
  0x0002,   /* U+045A */
  0x0002,   /* U+045B */
  0x0002,   /* U+045C */
  0x0002,   /* U+045D */
  0x0002,   /* U+045E */
  0x0002,   /* U+045F */
  0x0008,   /* U+0460 */
  0x0002,   /* U+0461 */
  0x0008,   /* U+0462 */
  0x0002,   /* U+0463 */
  0x0008,   /* U+0464 */
  0x0002,   /* U+0465 */
  0x0008,   /* U+0466 */
  0x0002,   /* U+0467 */
  0x0008,   /* U+0468 */
  0x0002,   /* U+0469 */
  0x0008,   /* U+046A */
  0x0002,   /* U+046B */
  0x0008,   /* U+046C */
  0x0002,   /* U+046D */
  0x0008,   /* U+046E */
  0x0002,   /* U+046F */
  0x0008,   /* U+0470 */
  0x0002,   /* U+0471 */
  0x0008,   /* U+0472 */
  0x0002,   /* U+0473 */
  0x0008,   /* U+0474 */
  0x0002,   /* U+0475 */
  0x0008,   /* U+0476 */
  0x0002,   /* U+0477 */
  0x0008,   /* U+0478 */
  0x0002,   /* U+0479 */
  0x0008,   /* U+047A */
  0x0002,   /* U+047B */
  0x0008,   /* U+047C */
  0x0002,   /* U+047D */
  0x0008,   /* U+047E */
  0x0002,   /* U+047F */
  0x0008,   /* U+0480 */
  0x0002,   /* U+0481 */
  0x0002,   /* U+0482 */
  0x0002,   /* U+0483 */
  0x0002,   /* U+0484 */
  0x0002,   /* U+0485 */
  0x0002,   /* U+0486 */
  0x0002,   /* U+0487 */
  0x0000,   /* U+0488 */
  0x0000,   /* U+0489 */
  0x0008,   /* U+048A */
  0x0002,   /* U+048B */
  0x0008,   /* U+048C */
  0x0002,   /* U+048D */
  0x0008,   /* U+048E */
  0x0002,   /* U+048F */
  0x000A,   /* U+0490 */
  0x0004,   /* U+0491 */
  0x0008,   /* U+0492 */
  0x0002,   /* U+0493 */
  0x0008,   /* U+0494 */
  0x0002,   /* U+0495 */
  0x0008,   /* U+0496 */
  0x0002,   /* U+0497 */
  0x0008,   /* U+0498 */
  0x0002,   /* U+0499 */
  0x0008,   /* U+049A */
  0x0002,   /* U+049B */
  0x0008,   /* U+049C */
  0x0002,   /* U+049D */
  0x0008,   /* U+049E */
  0x0002,   /* U+049F */
  0x0008,   /* U+04A0 */
  0x0002,   /* U+04A1 */
  0x0008,   /* U+04A2 */
  0x0002,   /* U+04A3 */
  0x0008,   /* U+04A4 */
  0x0002,   /* U+04A5 */
  0x0008,   /* U+04A6 */
  0x0002,   /* U+04A7 */
  0x0008,   /* U+04A8 */
  0x0002,   /* U+04A9 */
  0x0008,   /* U+04AA */
  0x0002,   /* U+04AB */
  0x0008,   /* U+04AC */
  0x0002,   /* U+04AD */
  0x0008,   /* U+04AE */
  0x0002,   /* U+04AF */
  0x0008,   /* U+04B0 */
  0x0002,   /* U+04B1 */
  0x0008,   /* U+04B2 */
  0x0002,   /* U+04B3 */
  0x0008,   /* U+04B4 */
  0x0002,   /* U+04B5 */
  0x0008,   /* U+04B6 */
  0x0002,   /* U+04B7 */
  0x0008,   /* U+04B8 */
  0x0002,   /* U+04B9 */
  0x0008,   /* U+04BA */
  0x0002,   /* U+04BB */
  0x0008,   /* U+04BC */
  0x0002,   /* U+04BD */
  0x0008,   /* U+04BE */
  0x0002,   /* U+04BF */
  0x0008,   /* U+04C0 */
  0x0008,   /* U+04C1 */
  0x0002,   /* U+04C2 */
  0x0008,   /* U+04C3 */
  0x0002,   /* U+04C4 */
  0x0008,   /* U+04C5 */
  0x0002,   /* U+04C6 */
  0x0008,   /* U+04C7 */
  0x0002,   /* U+04C8 */
  0x0008,   /* U+04C9 */
  0x0002,   /* U+04CA */
  0x0008,   /* U+04CB */
  0x0002,   /* U+04CC */
  0x0008,   /* U+04CD */
  0x0002,   /* U+04CE */
  0x0002,   /* U+04CF */
  0x0008,   /* U+04D0 */
  0x0002,   /* U+04D1 */
  0x0008,   /* U+04D2 */
  0x0002,   /* U+04D3 */
  0x0008,   /* U+04D4 */
  0x0002,   /* U+04D5 */
  0x0008,   /* U+04D6 */
  0x0002,   /* U+04D7 */
  0x0008,   /* U+04D8 */
  0x0002,   /* U+04D9 */
  0x0008,   /* U+04DA */
  0x0002,   /* U+04DB */
  0x0008,   /* U+04DC */
  0x0002,   /* U+04DD */
  0x0008,   /* U+04DE */
  0x0002,   /* U+04DF */
  0x0008,   /* U+04E0 */
  0x0002,   /* U+04E1 */
  0x0008,   /* U+04E2 */
  0x0002,   /* U+04E3 */
  0x0008,   /* U+04E4 */
  0x0002,   /* U+04E5 */
  0x0008,   /* U+04E6 */
  0x0002,   /* U+04E7 */
  0x0008,   /* U+04E8 */
  0x0002,   /* U+04E9 */
  0x0008,   /* U+04EA */
  0x0002,   /* U+04EB */
  0x0008,   /* U+04EC */
  0x0002,   /* U+04ED */
  0x0008,   /* U+04EE */
  0x0002,   /* U+04EF */
  0x0008,   /* U+04F0 */
  0x0002,   /* U+04F1 */
  0x0008,   /* U+04F2 */
  0x0002,   /* U+04F3 */
  0x0008,   /* U+04F4 */
  0x0002,   /* U+04F5 */
  0x0008,   /* U+04F6 */
  0x0002,   /* U+04F7 */
  0x0008,   /* U+04F8 */
  0x0002,   /* U+04F9 */
  0x0008,   /* U+04FA */
  0x0002,   /* U+04FB */
  0x0008,   /* U+04FC */
  0x0002,   /* U+04FD */
  0x0008,   /* U+04FE */
  0x0002,   /* U+04FF */

  /* Primary weight 2 for each character. */
  0x0000,   /* U+0400 */
  0x0000,   /* U+0401 */
  0x0000,   /* U+0402 */
  0x0000,   /* U+0403 */
  0x0000,   /* U+0404 */
  0x0000,   /* U+0405 */
  0x0000,   /* U+0406 */
  0x0000,   /* U+0407 */
  0x0000,   /* U+0408 */
  0x0000,   /* U+0409 */
  0x0000,   /* U+040A */
  0x0000,   /* U+040B */
  0x0000,   /* U+040C */
  0x0000,   /* U+040D */
  0x0000,   /* U+040E */
  0x0000,   /* U+040F */
  0x0000,   /* U+0410 */
  0x0000,   /* U+0411 */
  0x0000,   /* U+0412 */
  0x0000,   /* U+0413 */
  0x0000,   /* U+0414 */
  0x0000,   /* U+0415 */
  0x0000,   /* U+0416 */
  0x0000,   /* U+0417 */
  0x0000,   /* U+0418 */
  0x0000,   /* U+0419 */
  0x0000,   /* U+041A */
  0x0000,   /* U+041B */
  0x0000,   /* U+041C */
  0x0000,   /* U+041D */
  0x0000,   /* U+041E */
  0x0000,   /* U+041F */
  0x0000,   /* U+0420 */
  0x0000,   /* U+0421 */
  0x0000,   /* U+0422 */
  0x0000,   /* U+0423 */
  0x0000,   /* U+0424 */
  0x0000,   /* U+0425 */
  0x0000,   /* U+0426 */
  0x0000,   /* U+0427 */
  0x0000,   /* U+0428 */
  0x0000,   /* U+0429 */
  0x0000,   /* U+042A */
  0x0000,   /* U+042B */
  0x0000,   /* U+042C */
  0x0000,   /* U+042D */
  0x0000,   /* U+042E */
  0x0000,   /* U+042F */
  0x0000,   /* U+0430 */
  0x0000,   /* U+0431 */
  0x0000,   /* U+0432 */
  0x0000,   /* U+0433 */
  0x0000,   /* U+0434 */
  0x0000,   /* U+0435 */
  0x0000,   /* U+0436 */
  0x0000,   /* U+0437 */
  0x0000,   /* U+0438 */
  0x0000,   /* U+0439 */
  0x0000,   /* U+043A */
  0x0000,   /* U+043B */
  0x0000,   /* U+043C */
  0x0000,   /* U+043D */
  0x0000,   /* U+043E */
  0x0000,   /* U+043F */
  0x0000,   /* U+0440 */
  0x0000,   /* U+0441 */
  0x0000,   /* U+0442 */
  0x0000,   /* U+0443 */
  0x0000,   /* U+0444 */
  0x0000,   /* U+0445 */
  0x0000,   /* U+0446 */
  0x0000,   /* U+0447 */
  0x0000,   /* U+0448 */
  0x0000,   /* U+0449 */
  0x0000,   /* U+044A */
  0x0000,   /* U+044B */
  0x0000,   /* U+044C */
  0x0000,   /* U+044D */
  0x0000,   /* U+044E */
  0x0000,   /* U+044F */
  0x0000,   /* U+0450 */
  0x0000,   /* U+0451 */
  0x0000,   /* U+0452 */
  0x0000,   /* U+0453 */
  0x0000,   /* U+0454 */
  0x0000,   /* U+0455 */
  0x0000,   /* U+0456 */
  0x0000,   /* U+0457 */
  0x0000,   /* U+0458 */
  0x0000,   /* U+0459 */
  0x0000,   /* U+045A */
  0x0000,   /* U+045B */
  0x0000,   /* U+045C */
  0x0000,   /* U+045D */
  0x0000,   /* U+045E */
  0x0000,   /* U+045F */
  0x0000,   /* U+0460 */
  0x0000,   /* U+0461 */
  0x0000,   /* U+0462 */
  0x0000,   /* U+0463 */
  0x0000,   /* U+0464 */
  0x0000,   /* U+0465 */
  0x0000,   /* U+0466 */
  0x0000,   /* U+0467 */
  0x0000,   /* U+0468 */
  0x0000,   /* U+0469 */
  0x0000,   /* U+046A */
  0x0000,   /* U+046B */
  0x0000,   /* U+046C */
  0x0000,   /* U+046D */
  0x0000,   /* U+046E */
  0x0000,   /* U+046F */
  0x0000,   /* U+0470 */
  0x0000,   /* U+0471 */
  0x0000,   /* U+0472 */
  0x0000,   /* U+0473 */
  0x0000,   /* U+0474 */
  0x0000,   /* U+0475 */
  0x0000,   /* U+0476 */
  0x0000,   /* U+0477 */
  0x0000,   /* U+0478 */
  0x0000,   /* U+0479 */
  0x0000,   /* U+047A */
  0x0000,   /* U+047B */
  0x0000,   /* U+047C */
  0x0000,   /* U+047D */
  0x0000,   /* U+047E */
  0x0000,   /* U+047F */
  0x0000,   /* U+0480 */
  0x0000,   /* U+0481 */
  0x0000,   /* U+0482 */
  0x0000,   /* U+0483 */
  0x0000,   /* U+0484 */
  0x0000,   /* U+0485 */
  0x0000,   /* U+0486 */
  0x0000,   /* U+0487 */
  0x0000,   /* U+0488 */
  0x0000,   /* U+0489 */
  0x0000,   /* U+048A */
  0x0000,   /* U+048B */
  0x0000,   /* U+048C */
  0x0000,   /* U+048D */
  0x0000,   /* U+048E */
  0x0000,   /* U+048F */
  0x0000,   /* U+0490 */
  0x0000,   /* U+0491 */
  0x0000,   /* U+0492 */
  0x0000,   /* U+0493 */
  0x0000,   /* U+0494 */
  0x0000,   /* U+0495 */
  0x0000,   /* U+0496 */
  0x0000,   /* U+0497 */
  0x0000,   /* U+0498 */
  0x0000,   /* U+0499 */
  0x0000,   /* U+049A */
  0x0000,   /* U+049B */
  0x0000,   /* U+049C */
  0x0000,   /* U+049D */
  0x0000,   /* U+049E */
  0x0000,   /* U+049F */
  0x0000,   /* U+04A0 */
  0x0000,   /* U+04A1 */
  0x0000,   /* U+04A2 */
  0x0000,   /* U+04A3 */
  0x0000,   /* U+04A4 */
  0x0000,   /* U+04A5 */
  0x0000,   /* U+04A6 */
  0x0000,   /* U+04A7 */
  0x0000,   /* U+04A8 */
  0x0000,   /* U+04A9 */
  0x0000,   /* U+04AA */
  0x0000,   /* U+04AB */
  0x0000,   /* U+04AC */
  0x0000,   /* U+04AD */
  0x0000,   /* U+04AE */
  0x0000,   /* U+04AF */
  0x0000,   /* U+04B0 */
  0x0000,   /* U+04B1 */
  0x0000,   /* U+04B2 */
  0x0000,   /* U+04B3 */
  0x0000,   /* U+04B4 */
  0x0000,   /* U+04B5 */
  0x0000,   /* U+04B6 */
  0x0000,   /* U+04B7 */
  0x0000,   /* U+04B8 */
  0x0000,   /* U+04B9 */
  0x0000,   /* U+04BA */
  0x0000,   /* U+04BB */
  0x0000,   /* U+04BC */
  0x0000,   /* U+04BD */
  0x0000,   /* U+04BE */
  0x0000,   /* U+04BF */
  0x0000,   /* U+04C0 */
  0x0000,   /* U+04C1 */
  0x0000,   /* U+04C2 */
  0x0000,   /* U+04C3 */
  0x0000,   /* U+04C4 */
  0x0000,   /* U+04C5 */
  0x0000,   /* U+04C6 */
  0x0000,   /* U+04C7 */
  0x0000,   /* U+04C8 */
  0x0000,   /* U+04C9 */
  0x0000,   /* U+04CA */
  0x0000,   /* U+04CB */
  0x0000,   /* U+04CC */
  0x0000,   /* U+04CD */
  0x0000,   /* U+04CE */
  0x0000,   /* U+04CF */
  0x0000,   /* U+04D0 */
  0x0000,   /* U+04D1 */
  0x0000,   /* U+04D2 */
  0x0000,   /* U+04D3 */
  0x0000,   /* U+04D4 */
  0x0000,   /* U+04D5 */
  0x0000,   /* U+04D6 */
  0x0000,   /* U+04D7 */
  0x0000,   /* U+04D8 */
  0x0000,   /* U+04D9 */
  0x0000,   /* U+04DA */
  0x0000,   /* U+04DB */
  0x0000,   /* U+04DC */
  0x0000,   /* U+04DD */
  0x0000,   /* U+04DE */
  0x0000,   /* U+04DF */
  0x0000,   /* U+04E0 */
  0x0000,   /* U+04E1 */
  0x0000,   /* U+04E2 */
  0x0000,   /* U+04E3 */
  0x0000,   /* U+04E4 */
  0x0000,   /* U+04E5 */
  0x0000,   /* U+04E6 */
  0x0000,   /* U+04E7 */
  0x0000,   /* U+04E8 */
  0x0000,   /* U+04E9 */
  0x0000,   /* U+04EA */
  0x0000,   /* U+04EB */
  0x0000,   /* U+04EC */
  0x0000,   /* U+04ED */
  0x0000,   /* U+04EE */
  0x0000,   /* U+04EF */
  0x0000,   /* U+04F0 */
  0x0000,   /* U+04F1 */
  0x0000,   /* U+04F2 */
  0x0000,   /* U+04F3 */
  0x0000,   /* U+04F4 */
  0x0000,   /* U+04F5 */
  0x0000,   /* U+04F6 */
  0x0000,   /* U+04F7 */
  0x0000,   /* U+04F8 */
  0x0000,   /* U+04F9 */
  0x0000,   /* U+04FA */
  0x0000,   /* U+04FB */
  0x0000,   /* U+04FC */
  0x0000,   /* U+04FD */
  0x0000,   /* U+04FE */
  0x0000,   /* U+04FF */

  /* Secondary weight 2 for each character. */
  0x0025,   /* U+0400 */
  0x002B,   /* U+0401 */
  0x0000,   /* U+0402 */
  0x0024,   /* U+0403 */
  0x0000,   /* U+0404 */
  0x0000,   /* U+0405 */
  0x0000,   /* U+0406 */
  0x002B,   /* U+0407 */
  0x0000,   /* U+0408 */
  0x0000,   /* U+0409 */
  0x0000,   /* U+040A */
  0x0000,   /* U+040B */
  0x0024,   /* U+040C */
  0x0025,   /* U+040D */
  0x0026,   /* U+040E */
  0x0000,   /* U+040F */
  0x0000,   /* U+0410 */
  0x0000,   /* U+0411 */
  0x0000,   /* U+0412 */
  0x0000,   /* U+0413 */
  0x0000,   /* U+0414 */
  0x0000,   /* U+0415 */
  0x0000,   /* U+0416 */
  0x0000,   /* U+0417 */
  0x0000,   /* U+0418 */
  0x0000,   /* U+0419 */
  0x0000,   /* U+041A */
  0x0000,   /* U+041B */
  0x0000,   /* U+041C */
  0x0000,   /* U+041D */
  0x0000,   /* U+041E */
  0x0000,   /* U+041F */
  0x0000,   /* U+0420 */
  0x0000,   /* U+0421 */
  0x0000,   /* U+0422 */
  0x0000,   /* U+0423 */
  0x0000,   /* U+0424 */
  0x0000,   /* U+0425 */
  0x0000,   /* U+0426 */
  0x0000,   /* U+0427 */
  0x0000,   /* U+0428 */
  0x0000,   /* U+0429 */
  0x0000,   /* U+042A */
  0x0000,   /* U+042B */
  0x0000,   /* U+042C */
  0x0000,   /* U+042D */
  0x0000,   /* U+042E */
  0x0000,   /* U+042F */
  0x0000,   /* U+0430 */
  0x0000,   /* U+0431 */
  0x0000,   /* U+0432 */
  0x0000,   /* U+0433 */
  0x0000,   /* U+0434 */
  0x0000,   /* U+0435 */
  0x0000,   /* U+0436 */
  0x0000,   /* U+0437 */
  0x0000,   /* U+0438 */
  0x0000,   /* U+0439 */
  0x0000,   /* U+043A */
  0x0000,   /* U+043B */
  0x0000,   /* U+043C */
  0x0000,   /* U+043D */
  0x0000,   /* U+043E */
  0x0000,   /* U+043F */
  0x0000,   /* U+0440 */
  0x0000,   /* U+0441 */
  0x0000,   /* U+0442 */
  0x0000,   /* U+0443 */
  0x0000,   /* U+0444 */
  0x0000,   /* U+0445 */
  0x0000,   /* U+0446 */
  0x0000,   /* U+0447 */
  0x0000,   /* U+0448 */
  0x0000,   /* U+0449 */
  0x0000,   /* U+044A */
  0x0000,   /* U+044B */
  0x0000,   /* U+044C */
  0x0000,   /* U+044D */
  0x0000,   /* U+044E */
  0x0000,   /* U+044F */
  0x0025,   /* U+0450 */
  0x002B,   /* U+0451 */
  0x0000,   /* U+0452 */
  0x0024,   /* U+0453 */
  0x0000,   /* U+0454 */
  0x0000,   /* U+0455 */
  0x0000,   /* U+0456 */
  0x002B,   /* U+0457 */
  0x0000,   /* U+0458 */
  0x0000,   /* U+0459 */
  0x0000,   /* U+045A */
  0x0000,   /* U+045B */
  0x0024,   /* U+045C */
  0x0025,   /* U+045D */
  0x0026,   /* U+045E */
  0x0000,   /* U+045F */
  0x0000,   /* U+0460 */
  0x0000,   /* U+0461 */
  0x0000,   /* U+0462 */
  0x0000,   /* U+0463 */
  0x0000,   /* U+0464 */
  0x0000,   /* U+0465 */
  0x0000,   /* U+0466 */
  0x0000,   /* U+0467 */
  0x0000,   /* U+0468 */
  0x0000,   /* U+0469 */
  0x0000,   /* U+046A */
  0x0000,   /* U+046B */
  0x0000,   /* U+046C */
  0x0000,   /* U+046D */
  0x0000,   /* U+046E */
  0x0000,   /* U+046F */
  0x0000,   /* U+0470 */
  0x0000,   /* U+0471 */
  0x0000,   /* U+0472 */
  0x0000,   /* U+0473 */
  0x0000,   /* U+0474 */
  0x0000,   /* U+0475 */
  0x003C,   /* U+0476 */
  0x003C,   /* U+0477 */
  0x0000,   /* U+0478 */
  0x0000,   /* U+0479 */
  0x0000,   /* U+047A */
  0x0000,   /* U+047B */
  0x0000,   /* U+047C */
  0x0000,   /* U+047D */
  0x0000,   /* U+047E */
  0x0000,   /* U+047F */
  0x0000,   /* U+0480 */
  0x0000,   /* U+0481 */
  0x0000,   /* U+0482 */
  0x0000,   /* U+0483 */
  0x0000,   /* U+0484 */
  0x0000,   /* U+0485 */
  0x0000,   /* U+0486 */
  0x0000,   /* U+0487 */
  0x0000,   /* U+0488 */
  0x0000,   /* U+0489 */
  0x0000,   /* U+048A */
  0x0000,   /* U+048B */
  0x0000,   /* U+048C */
  0x0000,   /* U+048D */
  0x0000,   /* U+048E */
  0x0000,   /* U+048F */
  0x0111,   /* U+0490 */
  0x0111,   /* U+0491 */
  0x0000,   /* U+0492 */
  0x0000,   /* U+0493 */
  0x0000,   /* U+0494 */
  0x0000,   /* U+0495 */
  0x0000,   /* U+0496 */
  0x0000,   /* U+0497 */
  0x0000,   /* U+0498 */
  0x0000,   /* U+0499 */
  0x0000,   /* U+049A */
  0x0000,   /* U+049B */
  0x0000,   /* U+049C */
  0x0000,   /* U+049D */
  0x0000,   /* U+049E */
  0x0000,   /* U+049F */
  0x0000,   /* U+04A0 */
  0x0000,   /* U+04A1 */
  0x0000,   /* U+04A2 */
  0x0000,   /* U+04A3 */
  0x0000,   /* U+04A4 */
  0x0000,   /* U+04A5 */
  0x0000,   /* U+04A6 */
  0x0000,   /* U+04A7 */
  0x0000,   /* U+04A8 */
  0x0000,   /* U+04A9 */
  0x0000,   /* U+04AA */
  0x0000,   /* U+04AB */
  0x0000,   /* U+04AC */
  0x0000,   /* U+04AD */
  0x0000,   /* U+04AE */
  0x0000,   /* U+04AF */
  0x0000,   /* U+04B0 */
  0x0000,   /* U+04B1 */
  0x0000,   /* U+04B2 */
  0x0000,   /* U+04B3 */
  0x0000,   /* U+04B4 */
  0x0000,   /* U+04B5 */
  0x0000,   /* U+04B6 */
  0x0000,   /* U+04B7 */
  0x0000,   /* U+04B8 */
  0x0000,   /* U+04B9 */
  0x0000,   /* U+04BA */
  0x0000,   /* U+04BB */
  0x0000,   /* U+04BC */
  0x0000,   /* U+04BD */
  0x0000,   /* U+04BE */
  0x0000,   /* U+04BF */
  0x0000,   /* U+04C0 */
  0x0026,   /* U+04C1 */
  0x0026,   /* U+04C2 */
  0x0000,   /* U+04C3 */
  0x0000,   /* U+04C4 */
  0x0000,   /* U+04C5 */
  0x0000,   /* U+04C6 */
  0x0000,   /* U+04C7 */
  0x0000,   /* U+04C8 */
  0x0000,   /* U+04C9 */
  0x0000,   /* U+04CA */
  0x0000,   /* U+04CB */
  0x0000,   /* U+04CC */
  0x0000,   /* U+04CD */
  0x0000,   /* U+04CE */
  0x0000,   /* U+04CF */
  0x0026,   /* U+04D0 */
  0x0026,   /* U+04D1 */
  0x002B,   /* U+04D2 */
  0x002B,   /* U+04D3 */
  0x0000,   /* U+04D4 */
  0x0000,   /* U+04D5 */
  0x0026,   /* U+04D6 */
  0x0026,   /* U+04D7 */
  0x0000,   /* U+04D8 */
  0x0000,   /* U+04D9 */
  0x002B,   /* U+04DA */
  0x002B,   /* U+04DB */
  0x002B,   /* U+04DC */
  0x002B,   /* U+04DD */
  0x002B,   /* U+04DE */
  0x002B,   /* U+04DF */
  0x0000,   /* U+04E0 */
  0x0000,   /* U+04E1 */
  0x0032,   /* U+04E2 */
  0x0032,   /* U+04E3 */
  0x002B,   /* U+04E4 */
  0x002B,   /* U+04E5 */
  0x002B,   /* U+04E6 */
  0x002B,   /* U+04E7 */
  0x0000,   /* U+04E8 */
  0x0000,   /* U+04E9 */
  0x002B,   /* U+04EA */
  0x002B,   /* U+04EB */
  0x002B,   /* U+04EC */
  0x002B,   /* U+04ED */
  0x0032,   /* U+04EE */
  0x0032,   /* U+04EF */
  0x002B,   /* U+04F0 */
  0x002B,   /* U+04F1 */
  0x002C,   /* U+04F2 */
  0x002C,   /* U+04F3 */
  0x002B,   /* U+04F4 */
  0x002B,   /* U+04F5 */
  0x0000,   /* U+04F6 */
  0x0000,   /* U+04F7 */
  0x002B,   /* U+04F8 */
  0x002B,   /* U+04F9 */
  0x0000,   /* U+04FA */
  0x0000,   /* U+04FB */
  0x0000,   /* U+04FC */
  0x0000,   /* U+04FD */
  0x0000,   /* U+04FE */
  0x0000,   /* U+04FF */

  /* Tertiary weight 2 for each character. */
  0x0002,   /* U+0400 */
  0x0002,   /* U+0401 */
  0x0000,   /* U+0402 */
  0x0002,   /* U+0403 */
  0x0000,   /* U+0404 */
  0x0000,   /* U+0405 */
  0x0000,   /* U+0406 */
  0x0002,   /* U+0407 */
  0x0000,   /* U+0408 */
  0x0000,   /* U+0409 */
  0x0000,   /* U+040A */
  0x0000,   /* U+040B */
  0x0002,   /* U+040C */
  0x0002,   /* U+040D */
  0x0002,   /* U+040E */
  0x0000,   /* U+040F */
  0x0000,   /* U+0410 */
  0x0000,   /* U+0411 */
  0x0000,   /* U+0412 */
  0x0000,   /* U+0413 */
  0x0000,   /* U+0414 */
  0x0000,   /* U+0415 */
  0x0000,   /* U+0416 */
  0x0000,   /* U+0417 */
  0x0000,   /* U+0418 */
  0x0000,   /* U+0419 */
  0x0000,   /* U+041A */
  0x0000,   /* U+041B */
  0x0000,   /* U+041C */
  0x0000,   /* U+041D */
  0x0000,   /* U+041E */
  0x0000,   /* U+041F */
  0x0000,   /* U+0420 */
  0x0000,   /* U+0421 */
  0x0000,   /* U+0422 */
  0x0000,   /* U+0423 */
  0x0000,   /* U+0424 */
  0x0000,   /* U+0425 */
  0x0000,   /* U+0426 */
  0x0000,   /* U+0427 */
  0x0000,   /* U+0428 */
  0x0000,   /* U+0429 */
  0x0000,   /* U+042A */
  0x0000,   /* U+042B */
  0x0000,   /* U+042C */
  0x0000,   /* U+042D */
  0x0000,   /* U+042E */
  0x0000,   /* U+042F */
  0x0000,   /* U+0430 */
  0x0000,   /* U+0431 */
  0x0000,   /* U+0432 */
  0x0000,   /* U+0433 */
  0x0000,   /* U+0434 */
  0x0000,   /* U+0435 */
  0x0000,   /* U+0436 */
  0x0000,   /* U+0437 */
  0x0000,   /* U+0438 */
  0x0000,   /* U+0439 */
  0x0000,   /* U+043A */
  0x0000,   /* U+043B */
  0x0000,   /* U+043C */
  0x0000,   /* U+043D */
  0x0000,   /* U+043E */
  0x0000,   /* U+043F */
  0x0000,   /* U+0440 */
  0x0000,   /* U+0441 */
  0x0000,   /* U+0442 */
  0x0000,   /* U+0443 */
  0x0000,   /* U+0444 */
  0x0000,   /* U+0445 */
  0x0000,   /* U+0446 */
  0x0000,   /* U+0447 */
  0x0000,   /* U+0448 */
  0x0000,   /* U+0449 */
  0x0000,   /* U+044A */
  0x0000,   /* U+044B */
  0x0000,   /* U+044C */
  0x0000,   /* U+044D */
  0x0000,   /* U+044E */
  0x0000,   /* U+044F */
  0x0002,   /* U+0450 */
  0x0002,   /* U+0451 */
  0x0000,   /* U+0452 */
  0x0002,   /* U+0453 */
  0x0000,   /* U+0454 */
  0x0000,   /* U+0455 */
  0x0000,   /* U+0456 */
  0x0002,   /* U+0457 */
  0x0000,   /* U+0458 */
  0x0000,   /* U+0459 */
  0x0000,   /* U+045A */
  0x0000,   /* U+045B */
  0x0002,   /* U+045C */
  0x0002,   /* U+045D */
  0x0002,   /* U+045E */
  0x0000,   /* U+045F */
  0x0000,   /* U+0460 */
  0x0000,   /* U+0461 */
  0x0000,   /* U+0462 */
  0x0000,   /* U+0463 */
  0x0000,   /* U+0464 */
  0x0000,   /* U+0465 */
  0x0000,   /* U+0466 */
  0x0000,   /* U+0467 */
  0x0000,   /* U+0468 */
  0x0000,   /* U+0469 */
  0x0000,   /* U+046A */
  0x0000,   /* U+046B */
  0x0000,   /* U+046C */
  0x0000,   /* U+046D */
  0x0000,   /* U+046E */
  0x0000,   /* U+046F */
  0x0000,   /* U+0470 */
  0x0000,   /* U+0471 */
  0x0000,   /* U+0472 */
  0x0000,   /* U+0473 */
  0x0000,   /* U+0474 */
  0x0000,   /* U+0475 */
  0x0002,   /* U+0476 */
  0x0002,   /* U+0477 */
  0x0000,   /* U+0478 */
  0x0000,   /* U+0479 */
  0x0000,   /* U+047A */
  0x0000,   /* U+047B */
  0x0000,   /* U+047C */
  0x0000,   /* U+047D */
  0x0000,   /* U+047E */
  0x0000,   /* U+047F */
  0x0000,   /* U+0480 */
  0x0000,   /* U+0481 */
  0x0000,   /* U+0482 */
  0x0000,   /* U+0483 */
  0x0000,   /* U+0484 */
  0x0000,   /* U+0485 */
  0x0000,   /* U+0486 */
  0x0000,   /* U+0487 */
  0x0000,   /* U+0488 */
  0x0000,   /* U+0489 */
  0x0000,   /* U+048A */
  0x0000,   /* U+048B */
  0x0000,   /* U+048C */
  0x0000,   /* U+048D */
  0x0000,   /* U+048E */
  0x0000,   /* U+048F */
  0x0004,   /* U+0490 */
  0x0004,   /* U+0491 */
  0x0000,   /* U+0492 */
  0x0000,   /* U+0493 */
  0x0000,   /* U+0494 */
  0x0000,   /* U+0495 */
  0x0000,   /* U+0496 */
  0x0000,   /* U+0497 */
  0x0000,   /* U+0498 */
  0x0000,   /* U+0499 */
  0x0000,   /* U+049A */
  0x0000,   /* U+049B */
  0x0000,   /* U+049C */
  0x0000,   /* U+049D */
  0x0000,   /* U+049E */
  0x0000,   /* U+049F */
  0x0000,   /* U+04A0 */
  0x0000,   /* U+04A1 */
  0x0000,   /* U+04A2 */
  0x0000,   /* U+04A3 */
  0x0000,   /* U+04A4 */
  0x0000,   /* U+04A5 */
  0x0000,   /* U+04A6 */
  0x0000,   /* U+04A7 */
  0x0000,   /* U+04A8 */
  0x0000,   /* U+04A9 */
  0x0000,   /* U+04AA */
  0x0000,   /* U+04AB */
  0x0000,   /* U+04AC */
  0x0000,   /* U+04AD */
  0x0000,   /* U+04AE */
  0x0000,   /* U+04AF */
  0x0000,   /* U+04B0 */
  0x0000,   /* U+04B1 */
  0x0000,   /* U+04B2 */
  0x0000,   /* U+04B3 */
  0x0000,   /* U+04B4 */
  0x0000,   /* U+04B5 */
  0x0000,   /* U+04B6 */
  0x0000,   /* U+04B7 */
  0x0000,   /* U+04B8 */
  0x0000,   /* U+04B9 */
  0x0000,   /* U+04BA */
  0x0000,   /* U+04BB */
  0x0000,   /* U+04BC */
  0x0000,   /* U+04BD */
  0x0000,   /* U+04BE */
  0x0000,   /* U+04BF */
  0x0000,   /* U+04C0 */
  0x0002,   /* U+04C1 */
  0x0002,   /* U+04C2 */
  0x0000,   /* U+04C3 */
  0x0000,   /* U+04C4 */
  0x0000,   /* U+04C5 */
  0x0000,   /* U+04C6 */
  0x0000,   /* U+04C7 */
  0x0000,   /* U+04C8 */
  0x0000,   /* U+04C9 */
  0x0000,   /* U+04CA */
  0x0000,   /* U+04CB */
  0x0000,   /* U+04CC */
  0x0000,   /* U+04CD */
  0x0000,   /* U+04CE */
  0x0000,   /* U+04CF */
  0x0002,   /* U+04D0 */
  0x0002,   /* U+04D1 */
  0x0002,   /* U+04D2 */
  0x0002,   /* U+04D3 */
  0x0000,   /* U+04D4 */
  0x0000,   /* U+04D5 */
  0x0002,   /* U+04D6 */
  0x0002,   /* U+04D7 */
  0x0000,   /* U+04D8 */
  0x0000,   /* U+04D9 */
  0x0002,   /* U+04DA */
  0x0002,   /* U+04DB */
  0x0002,   /* U+04DC */
  0x0002,   /* U+04DD */
  0x0002,   /* U+04DE */
  0x0002,   /* U+04DF */
  0x0000,   /* U+04E0 */
  0x0000,   /* U+04E1 */
  0x0002,   /* U+04E2 */
  0x0002,   /* U+04E3 */
  0x0002,   /* U+04E4 */
  0x0002,   /* U+04E5 */
  0x0002,   /* U+04E6 */
  0x0002,   /* U+04E7 */
  0x0000,   /* U+04E8 */
  0x0000,   /* U+04E9 */
  0x0002,   /* U+04EA */
  0x0002,   /* U+04EB */
  0x0002,   /* U+04EC */
  0x0002,   /* U+04ED */
  0x0002,   /* U+04EE */
  0x0002,   /* U+04EF */
  0x0002,   /* U+04F0 */
  0x0002,   /* U+04F1 */
  0x0002,   /* U+04F2 */
  0x0002,   /* U+04F3 */
  0x0002,   /* U+04F4 */
  0x0002,   /* U+04F5 */
  0x0000,   /* U+04F6 */
  0x0000,   /* U+04F7 */
  0x0002,   /* U+04F8 */
  0x0002,   /* U+04F9 */
  0x0000,   /* U+04FA */
  0x0000,   /* U+04FB */
  0x0000,   /* U+04FC */
  0x0000,   /* U+04FD */
  0x0000,   /* U+04FE */
  0x0000,   /* U+04FF */
};

uint16 uca900_p005[]= {
  /* Number of CEs for each character. */
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 2, 2, 1, 1, 1, 1, 1, 1, 1,
  2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 2, 2, 1, 1, 2, 2, 1, 1, 1,
  2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2,
  2, 2, 2, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,

  /* Primary weight 1 for each character. */
  0x204E,   /* U+0500 */
  0x204E,   /* U+0501 */
  0x2055,   /* U+0502 */
  0x2055,   /* U+0503 */
  0x2071,   /* U+0504 */
  0x2071,   /* U+0505 */
  0x207E,   /* U+0506 */
  0x207E,   /* U+0507 */
  0x20C1,   /* U+0508 */
  0x20C1,   /* U+0509 */
  0x20E6,   /* U+050A */
  0x20E6,   /* U+050B */
  0x2109,   /* U+050C */
  0x2109,   /* U+050D */
  0x2113,   /* U+050E */
  0x2113,   /* U+050F */
  0x2072,   /* U+0510 */
  0x2072,   /* U+0511 */
  0x20BA,   /* U+0512 */
  0x20BA,   /* U+0513 */
  0x20C2,   /* U+0514 */
  0x20C2,   /* U+0515 */
  0x2104,   /* U+0516 */
  0x2104,   /* U+0517 */
  0x21B3,   /* U+0518 */
  0x21B3,   /* U+0519 */
  0x20AF,   /* U+051A */
  0x20AF,   /* U+051B */
  0x21E0,   /* U+051C */
  0x21E0,   /* U+051D */
  0x20AE,   /* U+051E */
  0x20AE,   /* U+051F */
  0x20BB,   /* U+0520 */
  0x20BB,   /* U+0521 */
  0x20DD,   /* U+0522 */
  0x20DD,   /* U+0523 */
  0x20F3,   /* U+0524 */
  0x20F3,   /* U+0525 */
  0x2146,   /* U+0526 */
  0x2146,   /* U+0527 */
  0x20D0,   /* U+0528 */
  0x20D0,   /* U+0529 */
  0x2066,   /* U+052A */
  0x2066,   /* U+052B */
  0x2168,   /* U+052C */
  0x2168,   /* U+052D */
  0x20B9,   /* U+052E */
  0x20B9,   /* U+052F */
  0xFBC0,   /* U+0530 */
  0x2290,   /* U+0531 */
  0x2291,   /* U+0532 */
  0x2292,   /* U+0533 */
  0x2293,   /* U+0534 */
  0x2294,   /* U+0535 */
  0x2295,   /* U+0536 */
  0x2296,   /* U+0537 */
  0x2297,   /* U+0538 */
  0x2298,   /* U+0539 */
  0x2299,   /* U+053A */
  0x229A,   /* U+053B */
  0x229B,   /* U+053C */
  0x229C,   /* U+053D */
  0x229D,   /* U+053E */
  0x229E,   /* U+053F */
  0x229F,   /* U+0540 */
  0x22A0,   /* U+0541 */
  0x22A1,   /* U+0542 */
  0x22A2,   /* U+0543 */
  0x22A3,   /* U+0544 */
  0x22A4,   /* U+0545 */
  0x22A5,   /* U+0546 */
  0x22A6,   /* U+0547 */
  0x22A7,   /* U+0548 */
  0x22A8,   /* U+0549 */
  0x22A9,   /* U+054A */
  0x22AA,   /* U+054B */
  0x22AB,   /* U+054C */
  0x22AC,   /* U+054D */
  0x22AD,   /* U+054E */
  0x22AE,   /* U+054F */
  0x22AF,   /* U+0550 */
  0x22B0,   /* U+0551 */
  0x22B1,   /* U+0552 */
  0x22B2,   /* U+0553 */
  0x22B3,   /* U+0554 */
  0x22B4,   /* U+0555 */
  0x22B5,   /* U+0556 */
  0xFBC0,   /* U+0557 */
  0xFBC0,   /* U+0558 */
  0x22B6,   /* U+0559 */
  0x03CB,   /* U+055A */
  0x03CC,   /* U+055B */
  0x0262,   /* U+055C */
  0x0226,   /* U+055D */
  0x0269,   /* U+055E */
  0x03CD,   /* U+055F */
  0xFBC0,   /* U+0560 */
  0x2290,   /* U+0561 */
  0x2291,   /* U+0562 */
  0x2292,   /* U+0563 */
  0x2293,   /* U+0564 */
  0x2294,   /* U+0565 */
  0x2295,   /* U+0566 */
  0x2296,   /* U+0567 */
  0x2297,   /* U+0568 */
  0x2298,   /* U+0569 */
  0x2299,   /* U+056A */
  0x229A,   /* U+056B */
  0x229B,   /* U+056C */
  0x229C,   /* U+056D */
  0x229D,   /* U+056E */
  0x229E,   /* U+056F */
  0x229F,   /* U+0570 */
  0x22A0,   /* U+0571 */
  0x22A1,   /* U+0572 */
  0x22A2,   /* U+0573 */
  0x22A3,   /* U+0574 */
  0x22A4,   /* U+0575 */
  0x22A5,   /* U+0576 */
  0x22A6,   /* U+0577 */
  0x22A7,   /* U+0578 */
  0x22A8,   /* U+0579 */
  0x22A9,   /* U+057A */
  0x22AA,   /* U+057B */
  0x22AB,   /* U+057C */
  0x22AC,   /* U+057D */
  0x22AD,   /* U+057E */
  0x22AE,   /* U+057F */
  0x22AF,   /* U+0580 */
  0x22B0,   /* U+0581 */
  0x22B1,   /* U+0582 */
  0x22B2,   /* U+0583 */
  0x22B3,   /* U+0584 */
  0x22B4,   /* U+0585 */
  0x22B5,   /* U+0586 */
  0x2294,   /* U+0587 */
  0xFBC0,   /* U+0588 */
  0x023A,   /* U+0589 */
  0x020E,   /* U+058A */
  0xFBC0,   /* U+058B */
  0xFBC0,   /* U+058C */
  0x04F8,   /* U+058D */
  0x04F9,   /* U+058E */
  0x1C15,   /* U+058F */
  0xFBC0,   /* U+0590 */
  0x0000,   /* U+0591 */
  0x0000,   /* U+0592 */
  0x0000,   /* U+0593 */
  0x0000,   /* U+0594 */
  0x0000,   /* U+0595 */
  0x0000,   /* U+0596 */
  0x0000,   /* U+0597 */
  0x0000,   /* U+0598 */
  0x0000,   /* U+0599 */
  0x0000,   /* U+059A */
  0x0000,   /* U+059B */
  0x0000,   /* U+059C */
  0x0000,   /* U+059D */
  0x0000,   /* U+059E */
  0x0000,   /* U+059F */
  0x0000,   /* U+05A0 */
  0x0000,   /* U+05A1 */
  0x0000,   /* U+05A2 */
  0x0000,   /* U+05A3 */
  0x0000,   /* U+05A4 */
  0x0000,   /* U+05A5 */
  0x0000,   /* U+05A6 */
  0x0000,   /* U+05A7 */
  0x0000,   /* U+05A8 */
  0x0000,   /* U+05A9 */
  0x0000,   /* U+05AA */
  0x0000,   /* U+05AB */
  0x0000,   /* U+05AC */
  0x0000,   /* U+05AD */
  0x0000,   /* U+05AE */
  0x0000,   /* U+05AF */
  0x0000,   /* U+05B0 */
  0x0000,   /* U+05B1 */
  0x0000,   /* U+05B2 */
  0x0000,   /* U+05B3 */
  0x0000,   /* U+05B4 */
  0x0000,   /* U+05B5 */
  0x0000,   /* U+05B6 */
  0x0000,   /* U+05B7 */
  0x0000,   /* U+05B8 */
  0x0000,   /* U+05B9 */
  0x0000,   /* U+05BA */
  0x0000,   /* U+05BB */
  0x0000,   /* U+05BC */
  0x0000,   /* U+05BD */
  0x03CE,   /* U+05BE */
  0x0000,   /* U+05BF */
  0x03CF,   /* U+05C0 */
  0x0000,   /* U+05C1 */
  0x0000,   /* U+05C2 */
  0x03D0,   /* U+05C3 */
  0x0000,   /* U+05C4 */
  0x0000,   /* U+05C5 */
  0x03D1,   /* U+05C6 */
  0x0000,   /* U+05C7 */
  0xFBC0,   /* U+05C8 */
  0xFBC0,   /* U+05C9 */
  0xFBC0,   /* U+05CA */
  0xFBC0,   /* U+05CB */
  0xFBC0,   /* U+05CC */
  0xFBC0,   /* U+05CD */
  0xFBC0,   /* U+05CE */
  0xFBC0,   /* U+05CF */
  0x22B7,   /* U+05D0 */
  0x22B8,   /* U+05D1 */
  0x22B9,   /* U+05D2 */
  0x22BA,   /* U+05D3 */
  0x22BB,   /* U+05D4 */
  0x22BC,   /* U+05D5 */
  0x22BD,   /* U+05D6 */
  0x22BE,   /* U+05D7 */
  0x22BF,   /* U+05D8 */
  0x22C0,   /* U+05D9 */
  0x22C1,   /* U+05DA */
  0x22C1,   /* U+05DB */
  0x22C2,   /* U+05DC */
  0x22C3,   /* U+05DD */
  0x22C3,   /* U+05DE */
  0x22C4,   /* U+05DF */
  0x22C4,   /* U+05E0 */
  0x22C5,   /* U+05E1 */
  0x22C6,   /* U+05E2 */
  0x22C7,   /* U+05E3 */
  0x22C7,   /* U+05E4 */
  0x22C8,   /* U+05E5 */
  0x22C8,   /* U+05E6 */
  0x22C9,   /* U+05E7 */
  0x22CA,   /* U+05E8 */
  0x22CB,   /* U+05E9 */
  0x22CC,   /* U+05EA */
  0xFBC0,   /* U+05EB */
  0xFBC0,   /* U+05EC */
  0xFBC0,   /* U+05ED */
  0xFBC0,   /* U+05EE */
  0xFBC0,   /* U+05EF */
  0x22BC,   /* U+05F0 */
  0x22BC,   /* U+05F1 */
  0x22C0,   /* U+05F2 */
  0x03D2,   /* U+05F3 */
  0x03D3,   /* U+05F4 */
  0xFBC0,   /* U+05F5 */
  0xFBC0,   /* U+05F6 */
  0xFBC0,   /* U+05F7 */
  0xFBC0,   /* U+05F8 */
  0xFBC0,   /* U+05F9 */
  0xFBC0,   /* U+05FA */
  0xFBC0,   /* U+05FB */
  0xFBC0,   /* U+05FC */
  0xFBC0,   /* U+05FD */
  0xFBC0,   /* U+05FE */
  0xFBC0,   /* U+05FF */

  /* Secondary weight 1 for each character. */
  0x0020,   /* U+0500 */
  0x0020,   /* U+0501 */
  0x0020,   /* U+0502 */
  0x0020,   /* U+0503 */
  0x0020,   /* U+0504 */
  0x0020,   /* U+0505 */
  0x0020,   /* U+0506 */
  0x0020,   /* U+0507 */
  0x0020,   /* U+0508 */
  0x0020,   /* U+0509 */
  0x0020,   /* U+050A */
  0x0020,   /* U+050B */
  0x0020,   /* U+050C */
  0x0020,   /* U+050D */
  0x0020,   /* U+050E */
  0x0020,   /* U+050F */
  0x0020,   /* U+0510 */
  0x0020,   /* U+0511 */
  0x0020,   /* U+0512 */
  0x0020,   /* U+0513 */
  0x0020,   /* U+0514 */
  0x0020,   /* U+0515 */
  0x0020,   /* U+0516 */
  0x0020,   /* U+0517 */
  0x0020,   /* U+0518 */
  0x0020,   /* U+0519 */
  0x0020,   /* U+051A */
  0x0020,   /* U+051B */
  0x0020,   /* U+051C */
  0x0020,   /* U+051D */
  0x0020,   /* U+051E */
  0x0020,   /* U+051F */
  0x0020,   /* U+0520 */
  0x0020,   /* U+0521 */
  0x0020,   /* U+0522 */
  0x0020,   /* U+0523 */
  0x0020,   /* U+0524 */
  0x0020,   /* U+0525 */
  0x0020,   /* U+0526 */
  0x0020,   /* U+0527 */
  0x0020,   /* U+0528 */
  0x0020,   /* U+0529 */
  0x0020,   /* U+052A */
  0x0020,   /* U+052B */
  0x0020,   /* U+052C */
  0x0020,   /* U+052D */
  0x0020,   /* U+052E */
  0x0020,   /* U+052F */
  0x0020,   /* U+0530 */
  0x0020,   /* U+0531 */
  0x0020,   /* U+0532 */
  0x0020,   /* U+0533 */
  0x0020,   /* U+0534 */
  0x0020,   /* U+0535 */
  0x0020,   /* U+0536 */
  0x0020,   /* U+0537 */
  0x0020,   /* U+0538 */
  0x0020,   /* U+0539 */
  0x0020,   /* U+053A */
  0x0020,   /* U+053B */
  0x0020,   /* U+053C */
  0x0020,   /* U+053D */
  0x0020,   /* U+053E */
  0x0020,   /* U+053F */
  0x0020,   /* U+0540 */
  0x0020,   /* U+0541 */
  0x0020,   /* U+0542 */
  0x0020,   /* U+0543 */
  0x0020,   /* U+0544 */
  0x0020,   /* U+0545 */
  0x0020,   /* U+0546 */
  0x0020,   /* U+0547 */
  0x0020,   /* U+0548 */
  0x0020,   /* U+0549 */
  0x0020,   /* U+054A */
  0x0020,   /* U+054B */
  0x0020,   /* U+054C */
  0x0020,   /* U+054D */
  0x0020,   /* U+054E */
  0x0020,   /* U+054F */
  0x0020,   /* U+0550 */
  0x0020,   /* U+0551 */
  0x0020,   /* U+0552 */
  0x0020,   /* U+0553 */
  0x0020,   /* U+0554 */
  0x0020,   /* U+0555 */
  0x0020,   /* U+0556 */
  0x0020,   /* U+0557 */
  0x0020,   /* U+0558 */
  0x0020,   /* U+0559 */
  0x0020,   /* U+055A */
  0x0020,   /* U+055B */
  0x0020,   /* U+055C */
  0x0020,   /* U+055D */
  0x0020,   /* U+055E */
  0x0020,   /* U+055F */
  0x0020,   /* U+0560 */
  0x0020,   /* U+0561 */
  0x0020,   /* U+0562 */
  0x0020,   /* U+0563 */
  0x0020,   /* U+0564 */
  0x0020,   /* U+0565 */
  0x0020,   /* U+0566 */
  0x0020,   /* U+0567 */
  0x0020,   /* U+0568 */
  0x0020,   /* U+0569 */
  0x0020,   /* U+056A */
  0x0020,   /* U+056B */
  0x0020,   /* U+056C */
  0x0020,   /* U+056D */
  0x0020,   /* U+056E */
  0x0020,   /* U+056F */
  0x0020,   /* U+0570 */
  0x0020,   /* U+0571 */
  0x0020,   /* U+0572 */
  0x0020,   /* U+0573 */
  0x0020,   /* U+0574 */
  0x0020,   /* U+0575 */
  0x0020,   /* U+0576 */
  0x0020,   /* U+0577 */
  0x0020,   /* U+0578 */
  0x0020,   /* U+0579 */
  0x0020,   /* U+057A */
  0x0020,   /* U+057B */
  0x0020,   /* U+057C */
  0x0020,   /* U+057D */
  0x0020,   /* U+057E */
  0x0020,   /* U+057F */
  0x0020,   /* U+0580 */
  0x0020,   /* U+0581 */
  0x0020,   /* U+0582 */
  0x0020,   /* U+0583 */
  0x0020,   /* U+0584 */
  0x0020,   /* U+0585 */
  0x0020,   /* U+0586 */
  0x0020,   /* U+0587 */
  0x0020,   /* U+0588 */
  0x0020,   /* U+0589 */
  0x0020,   /* U+058A */
  0x0020,   /* U+058B */
  0x0020,   /* U+058C */
  0x0020,   /* U+058D */
  0x0020,   /* U+058E */
  0x0020,   /* U+058F */
  0x0020,   /* U+0590 */
  0x0000,   /* U+0591 */
  0x0000,   /* U+0592 */
  0x0000,   /* U+0593 */
  0x0000,   /* U+0594 */
  0x0000,   /* U+0595 */
  0x0000,   /* U+0596 */
  0x0000,   /* U+0597 */
  0x0000,   /* U+0598 */
  0x0000,   /* U+0599 */
  0x0000,   /* U+059A */
  0x0000,   /* U+059B */
  0x0000,   /* U+059C */
  0x0000,   /* U+059D */
  0x0000,   /* U+059E */
  0x0000,   /* U+059F */
  0x0000,   /* U+05A0 */
  0x0000,   /* U+05A1 */
  0x0000,   /* U+05A2 */
  0x0000,   /* U+05A3 */
  0x0000,   /* U+05A4 */
  0x0000,   /* U+05A5 */
  0x0000,   /* U+05A6 */
  0x0000,   /* U+05A7 */
  0x0000,   /* U+05A8 */
  0x0000,   /* U+05A9 */
  0x0000,   /* U+05AA */
  0x0000,   /* U+05AB */
  0x0000,   /* U+05AC */
  0x0000,   /* U+05AD */
  0x0000,   /* U+05AE */
  0x0000,   /* U+05AF */
  0x0052,   /* U+05B0 */
  0x0053,   /* U+05B1 */
  0x0054,   /* U+05B2 */
  0x0055,   /* U+05B3 */
  0x0056,   /* U+05B4 */
  0x0057,   /* U+05B5 */
  0x0058,   /* U+05B6 */
  0x0059,   /* U+05B7 */
  0x005A,   /* U+05B8 */
  0x005B,   /* U+05B9 */
  0x005B,   /* U+05BA */
  0x005C,   /* U+05BB */
  0x005F,   /* U+05BC */
  0x0000,   /* U+05BD */
  0x0020,   /* U+05BE */
  0x0060,   /* U+05BF */
  0x0020,   /* U+05C0 */
  0x005E,   /* U+05C1 */
  0x005D,   /* U+05C2 */
  0x0020,   /* U+05C3 */
  0x0000,   /* U+05C4 */
  0x0000,   /* U+05C5 */
  0x0020,   /* U+05C6 */
  0x005A,   /* U+05C7 */
  0x0020,   /* U+05C8 */
  0x0020,   /* U+05C9 */
  0x0020,   /* U+05CA */
  0x0020,   /* U+05CB */
  0x0020,   /* U+05CC */
  0x0020,   /* U+05CD */
  0x0020,   /* U+05CE */
  0x0020,   /* U+05CF */
  0x0020,   /* U+05D0 */
  0x0020,   /* U+05D1 */
  0x0020,   /* U+05D2 */
  0x0020,   /* U+05D3 */
  0x0020,   /* U+05D4 */
  0x0020,   /* U+05D5 */
  0x0020,   /* U+05D6 */
  0x0020,   /* U+05D7 */
  0x0020,   /* U+05D8 */
  0x0020,   /* U+05D9 */
  0x0020,   /* U+05DA */
  0x0020,   /* U+05DB */
  0x0020,   /* U+05DC */
  0x0020,   /* U+05DD */
  0x0020,   /* U+05DE */
  0x0020,   /* U+05DF */
  0x0020,   /* U+05E0 */
  0x0020,   /* U+05E1 */
  0x0020,   /* U+05E2 */
  0x0020,   /* U+05E3 */
  0x0020,   /* U+05E4 */
  0x0020,   /* U+05E5 */
  0x0020,   /* U+05E6 */
  0x0020,   /* U+05E7 */
  0x0020,   /* U+05E8 */
  0x0020,   /* U+05E9 */
  0x0020,   /* U+05EA */
  0x0020,   /* U+05EB */
  0x0020,   /* U+05EC */
  0x0020,   /* U+05ED */
  0x0020,   /* U+05EE */
  0x0020,   /* U+05EF */
  0x0020,   /* U+05F0 */
  0x0020,   /* U+05F1 */
  0x0020,   /* U+05F2 */
  0x0020,   /* U+05F3 */
  0x0020,   /* U+05F4 */
  0x0020,   /* U+05F5 */
  0x0020,   /* U+05F6 */
  0x0020,   /* U+05F7 */
  0x0020,   /* U+05F8 */
  0x0020,   /* U+05F9 */
  0x0020,   /* U+05FA */
  0x0020,   /* U+05FB */
  0x0020,   /* U+05FC */
  0x0020,   /* U+05FD */
  0x0020,   /* U+05FE */
  0x0020,   /* U+05FF */

  /* Tertiary weight 1 for each character. */
  0x0008,   /* U+0500 */
  0x0002,   /* U+0501 */
  0x0008,   /* U+0502 */
  0x0002,   /* U+0503 */
  0x0008,   /* U+0504 */
  0x0002,   /* U+0505 */
  0x0008,   /* U+0506 */
  0x0002,   /* U+0507 */
  0x0008,   /* U+0508 */
  0x0002,   /* U+0509 */
  0x0008,   /* U+050A */
  0x0002,   /* U+050B */
  0x0008,   /* U+050C */
  0x0002,   /* U+050D */
  0x0008,   /* U+050E */
  0x0002,   /* U+050F */
  0x0008,   /* U+0510 */
  0x0002,   /* U+0511 */
  0x0008,   /* U+0512 */
  0x0002,   /* U+0513 */
  0x0008,   /* U+0514 */
  0x0002,   /* U+0515 */
  0x0008,   /* U+0516 */
  0x0002,   /* U+0517 */
  0x0008,   /* U+0518 */
  0x0002,   /* U+0519 */
  0x0008,   /* U+051A */
  0x0002,   /* U+051B */
  0x0008,   /* U+051C */
  0x0002,   /* U+051D */
  0x0008,   /* U+051E */
  0x0002,   /* U+051F */
  0x0008,   /* U+0520 */
  0x0002,   /* U+0521 */
  0x0008,   /* U+0522 */
  0x0002,   /* U+0523 */
  0x0008,   /* U+0524 */
  0x0002,   /* U+0525 */
  0x0008,   /* U+0526 */
  0x0002,   /* U+0527 */
  0x0008,   /* U+0528 */
  0x0002,   /* U+0529 */
  0x0008,   /* U+052A */
  0x0002,   /* U+052B */
  0x0008,   /* U+052C */
  0x0002,   /* U+052D */
  0x0008,   /* U+052E */
  0x0002,   /* U+052F */
  0x0002,   /* U+0530 */
  0x0008,   /* U+0531 */
  0x0008,   /* U+0532 */
  0x0008,   /* U+0533 */
  0x0008,   /* U+0534 */
  0x0008,   /* U+0535 */
  0x0008,   /* U+0536 */
  0x0008,   /* U+0537 */
  0x0008,   /* U+0538 */
  0x0008,   /* U+0539 */
  0x0008,   /* U+053A */
  0x0008,   /* U+053B */
  0x0008,   /* U+053C */
  0x0008,   /* U+053D */
  0x0008,   /* U+053E */
  0x0008,   /* U+053F */
  0x0008,   /* U+0540 */
  0x0008,   /* U+0541 */
  0x0008,   /* U+0542 */
  0x0008,   /* U+0543 */
  0x0008,   /* U+0544 */
  0x0008,   /* U+0545 */
  0x0008,   /* U+0546 */
  0x0008,   /* U+0547 */
  0x0008,   /* U+0548 */
  0x0008,   /* U+0549 */
  0x0008,   /* U+054A */
  0x0008,   /* U+054B */
  0x0008,   /* U+054C */
  0x0008,   /* U+054D */
  0x0008,   /* U+054E */
  0x0008,   /* U+054F */
  0x0008,   /* U+0550 */
  0x0008,   /* U+0551 */
  0x0008,   /* U+0552 */
  0x0008,   /* U+0553 */
  0x0008,   /* U+0554 */
  0x0008,   /* U+0555 */
  0x0008,   /* U+0556 */
  0x0002,   /* U+0557 */
  0x0002,   /* U+0558 */
  0x0002,   /* U+0559 */
  0x0002,   /* U+055A */
  0x0002,   /* U+055B */
  0x0002,   /* U+055C */
  0x0002,   /* U+055D */
  0x0002,   /* U+055E */
  0x0002,   /* U+055F */
  0x0002,   /* U+0560 */
  0x0002,   /* U+0561 */
  0x0002,   /* U+0562 */
  0x0002,   /* U+0563 */
  0x0002,   /* U+0564 */
  0x0002,   /* U+0565 */
  0x0002,   /* U+0566 */
  0x0002,   /* U+0567 */
  0x0002,   /* U+0568 */
  0x0002,   /* U+0569 */
  0x0002,   /* U+056A */
  0x0002,   /* U+056B */
  0x0002,   /* U+056C */
  0x0002,   /* U+056D */
  0x0002,   /* U+056E */
  0x0002,   /* U+056F */
  0x0002,   /* U+0570 */
  0x0002,   /* U+0571 */
  0x0002,   /* U+0572 */
  0x0002,   /* U+0573 */
  0x0002,   /* U+0574 */
  0x0002,   /* U+0575 */
  0x0002,   /* U+0576 */
  0x0002,   /* U+0577 */
  0x0002,   /* U+0578 */
  0x0002,   /* U+0579 */
  0x0002,   /* U+057A */
  0x0002,   /* U+057B */
  0x0002,   /* U+057C */
  0x0002,   /* U+057D */
  0x0002,   /* U+057E */
  0x0002,   /* U+057F */
  0x0002,   /* U+0580 */
  0x0002,   /* U+0581 */
  0x0002,   /* U+0582 */
  0x0002,   /* U+0583 */
  0x0002,   /* U+0584 */
  0x0002,   /* U+0585 */
  0x0002,   /* U+0586 */
  0x0004,   /* U+0587 */
  0x0002,   /* U+0588 */
  0x0002,   /* U+0589 */
  0x0002,   /* U+058A */
  0x0002,   /* U+058B */
  0x0002,   /* U+058C */
  0x0002,   /* U+058D */
  0x0002,   /* U+058E */
  0x0002,   /* U+058F */
  0x0002,   /* U+0590 */
  0x0000,   /* U+0591 */
  0x0000,   /* U+0592 */
  0x0000,   /* U+0593 */
  0x0000,   /* U+0594 */
  0x0000,   /* U+0595 */
  0x0000,   /* U+0596 */
  0x0000,   /* U+0597 */
  0x0000,   /* U+0598 */
  0x0000,   /* U+0599 */
  0x0000,   /* U+059A */
  0x0000,   /* U+059B */
  0x0000,   /* U+059C */
  0x0000,   /* U+059D */
  0x0000,   /* U+059E */
  0x0000,   /* U+059F */
  0x0000,   /* U+05A0 */
  0x0000,   /* U+05A1 */
  0x0000,   /* U+05A2 */
  0x0000,   /* U+05A3 */
  0x0000,   /* U+05A4 */
  0x0000,   /* U+05A5 */
  0x0000,   /* U+05A6 */
  0x0000,   /* U+05A7 */
  0x0000,   /* U+05A8 */
  0x0000,   /* U+05A9 */
  0x0000,   /* U+05AA */
  0x0000,   /* U+05AB */
  0x0000,   /* U+05AC */
  0x0000,   /* U+05AD */
  0x0000,   /* U+05AE */
  0x0000,   /* U+05AF */
  0x0002,   /* U+05B0 */
  0x0002,   /* U+05B1 */
  0x0002,   /* U+05B2 */
  0x0002,   /* U+05B3 */
  0x0002,   /* U+05B4 */
  0x0002,   /* U+05B5 */
  0x0002,   /* U+05B6 */
  0x0002,   /* U+05B7 */
  0x0002,   /* U+05B8 */
  0x0002,   /* U+05B9 */
  0x0002,   /* U+05BA */
  0x0002,   /* U+05BB */
  0x0002,   /* U+05BC */
  0x0000,   /* U+05BD */
  0x0002,   /* U+05BE */
  0x0002,   /* U+05BF */
  0x0002,   /* U+05C0 */
  0x0002,   /* U+05C1 */
  0x0002,   /* U+05C2 */
  0x0002,   /* U+05C3 */
  0x0000,   /* U+05C4 */
  0x0000,   /* U+05C5 */
  0x0002,   /* U+05C6 */
  0x0002,   /* U+05C7 */
  0x0002,   /* U+05C8 */
  0x0002,   /* U+05C9 */
  0x0002,   /* U+05CA */
  0x0002,   /* U+05CB */
  0x0002,   /* U+05CC */
  0x0002,   /* U+05CD */
  0x0002,   /* U+05CE */
  0x0002,   /* U+05CF */
  0x0002,   /* U+05D0 */
  0x0002,   /* U+05D1 */
  0x0002,   /* U+05D2 */
  0x0002,   /* U+05D3 */
  0x0002,   /* U+05D4 */
  0x0002,   /* U+05D5 */
  0x0002,   /* U+05D6 */
  0x0002,   /* U+05D7 */
  0x0002,   /* U+05D8 */
  0x0002,   /* U+05D9 */
  0x0019,   /* U+05DA */
  0x0002,   /* U+05DB */
  0x0002,   /* U+05DC */
  0x0019,   /* U+05DD */
  0x0002,   /* U+05DE */
  0x0019,   /* U+05DF */
  0x0002,   /* U+05E0 */
  0x0002,   /* U+05E1 */
  0x0002,   /* U+05E2 */
  0x0019,   /* U+05E3 */
  0x0002,   /* U+05E4 */
  0x0019,   /* U+05E5 */
  0x0002,   /* U+05E6 */
  0x0002,   /* U+05E7 */
  0x0002,   /* U+05E8 */
  0x0002,   /* U+05E9 */
  0x0002,   /* U+05EA */
  0x0002,   /* U+05EB */
  0x0002,   /* U+05EC */
  0x0002,   /* U+05ED */
  0x0002,   /* U+05EE */
  0x0002,   /* U+05EF */
  0x0004,   /* U+05F0 */
  0x0004,   /* U+05F1 */
  0x0004,   /* U+05F2 */
  0x0002,   /* U+05F3 */
  0x0002,   /* U+05F4 */
  0x0002,   /* U+05F5 */
  0x0002,   /* U+05F6 */
  0x0002,   /* U+05F7 */
  0x0002,   /* U+05F8 */
  0x0002,   /* U+05F9 */
  0x0002,   /* U+05FA */
  0x0002,   /* U+05FB */
  0x0002,   /* U+05FC */
  0x0002,   /* U+05FD */
  0x0002,   /* U+05FE */
  0x0002,   /* U+05FF */

  /* Primary weight 2 for each character. */
  0x0000,   /* U+0500 */
  0x0000,   /* U+0501 */
  0x0000,   /* U+0502 */
  0x0000,   /* U+0503 */
  0x0000,   /* U+0504 */
  0x0000,   /* U+0505 */
  0x0000,   /* U+0506 */
  0x0000,   /* U+0507 */
  0x0000,   /* U+0508 */
  0x0000,   /* U+0509 */
  0x0000,   /* U+050A */
  0x0000,   /* U+050B */
  0x0000,   /* U+050C */
  0x0000,   /* U+050D */
  0x0000,   /* U+050E */
  0x0000,   /* U+050F */
  0x0000,   /* U+0510 */
  0x0000,   /* U+0511 */
  0x0000,   /* U+0512 */
  0x0000,   /* U+0513 */
  0x0000,   /* U+0514 */
  0x0000,   /* U+0515 */
  0x0000,   /* U+0516 */
  0x0000,   /* U+0517 */
  0x0000,   /* U+0518 */
  0x0000,   /* U+0519 */
  0x0000,   /* U+051A */
  0x0000,   /* U+051B */
  0x0000,   /* U+051C */
  0x0000,   /* U+051D */
  0x0000,   /* U+051E */
  0x0000,   /* U+051F */
  0x0000,   /* U+0520 */
  0x0000,   /* U+0521 */
  0x0000,   /* U+0522 */
  0x0000,   /* U+0523 */
  0x0000,   /* U+0524 */
  0x0000,   /* U+0525 */
  0x0000,   /* U+0526 */
  0x0000,   /* U+0527 */
  0x0000,   /* U+0528 */
  0x0000,   /* U+0529 */
  0x0000,   /* U+052A */
  0x0000,   /* U+052B */
  0x0000,   /* U+052C */
  0x0000,   /* U+052D */
  0x0000,   /* U+052E */
  0x0000,   /* U+052F */
  0x8530,   /* U+0530 */
  0x0000,   /* U+0531 */
  0x0000,   /* U+0532 */
  0x0000,   /* U+0533 */
  0x0000,   /* U+0534 */
  0x0000,   /* U+0535 */
  0x0000,   /* U+0536 */
  0x0000,   /* U+0537 */
  0x0000,   /* U+0538 */
  0x0000,   /* U+0539 */
  0x0000,   /* U+053A */
  0x0000,   /* U+053B */
  0x0000,   /* U+053C */
  0x0000,   /* U+053D */
  0x0000,   /* U+053E */
  0x0000,   /* U+053F */
  0x0000,   /* U+0540 */
  0x0000,   /* U+0541 */
  0x0000,   /* U+0542 */
  0x0000,   /* U+0543 */
  0x0000,   /* U+0544 */
  0x0000,   /* U+0545 */
  0x0000,   /* U+0546 */
  0x0000,   /* U+0547 */
  0x0000,   /* U+0548 */
  0x0000,   /* U+0549 */
  0x0000,   /* U+054A */
  0x0000,   /* U+054B */
  0x0000,   /* U+054C */
  0x0000,   /* U+054D */
  0x0000,   /* U+054E */
  0x0000,   /* U+054F */
  0x0000,   /* U+0550 */
  0x0000,   /* U+0551 */
  0x0000,   /* U+0552 */
  0x0000,   /* U+0553 */
  0x0000,   /* U+0554 */
  0x0000,   /* U+0555 */
  0x0000,   /* U+0556 */
  0x8557,   /* U+0557 */
  0x8558,   /* U+0558 */
  0x0000,   /* U+0559 */
  0x0000,   /* U+055A */
  0x0000,   /* U+055B */
  0x0000,   /* U+055C */
  0x0000,   /* U+055D */
  0x0000,   /* U+055E */
  0x0000,   /* U+055F */
  0x8560,   /* U+0560 */
  0x0000,   /* U+0561 */
  0x0000,   /* U+0562 */
  0x0000,   /* U+0563 */
  0x0000,   /* U+0564 */
  0x0000,   /* U+0565 */
  0x0000,   /* U+0566 */
  0x0000,   /* U+0567 */
  0x0000,   /* U+0568 */
  0x0000,   /* U+0569 */
  0x0000,   /* U+056A */
  0x0000,   /* U+056B */
  0x0000,   /* U+056C */
  0x0000,   /* U+056D */
  0x0000,   /* U+056E */
  0x0000,   /* U+056F */
  0x0000,   /* U+0570 */
  0x0000,   /* U+0571 */
  0x0000,   /* U+0572 */
  0x0000,   /* U+0573 */
  0x0000,   /* U+0574 */
  0x0000,   /* U+0575 */
  0x0000,   /* U+0576 */
  0x0000,   /* U+0577 */
  0x0000,   /* U+0578 */
  0x0000,   /* U+0579 */
  0x0000,   /* U+057A */
  0x0000,   /* U+057B */
  0x0000,   /* U+057C */
  0x0000,   /* U+057D */
  0x0000,   /* U+057E */
  0x0000,   /* U+057F */
  0x0000,   /* U+0580 */
  0x0000,   /* U+0581 */
  0x0000,   /* U+0582 */
  0x0000,   /* U+0583 */
  0x0000,   /* U+0584 */
  0x0000,   /* U+0585 */
  0x0000,   /* U+0586 */
  0x22B1,   /* U+0587 */
  0x8588,   /* U+0588 */
  0x0000,   /* U+0589 */
  0x0000,   /* U+058A */
  0x858B,   /* U+058B */
  0x858C,   /* U+058C */
  0x0000,   /* U+058D */
  0x0000,   /* U+058E */
  0x0000,   /* U+058F */
  0x8590,   /* U+0590 */
  0x0000,   /* U+0591 */
  0x0000,   /* U+0592 */
  0x0000,   /* U+0593 */
  0x0000,   /* U+0594 */
  0x0000,   /* U+0595 */
  0x0000,   /* U+0596 */
  0x0000,   /* U+0597 */
  0x0000,   /* U+0598 */
  0x0000,   /* U+0599 */
  0x0000,   /* U+059A */
  0x0000,   /* U+059B */
  0x0000,   /* U+059C */
  0x0000,   /* U+059D */
  0x0000,   /* U+059E */
  0x0000,   /* U+059F */
  0x0000,   /* U+05A0 */
  0x0000,   /* U+05A1 */
  0x0000,   /* U+05A2 */
  0x0000,   /* U+05A3 */
  0x0000,   /* U+05A4 */
  0x0000,   /* U+05A5 */
  0x0000,   /* U+05A6 */
  0x0000,   /* U+05A7 */
  0x0000,   /* U+05A8 */
  0x0000,   /* U+05A9 */
  0x0000,   /* U+05AA */
  0x0000,   /* U+05AB */
  0x0000,   /* U+05AC */
  0x0000,   /* U+05AD */
  0x0000,   /* U+05AE */
  0x0000,   /* U+05AF */
  0x0000,   /* U+05B0 */
  0x0000,   /* U+05B1 */
  0x0000,   /* U+05B2 */
  0x0000,   /* U+05B3 */
  0x0000,   /* U+05B4 */
  0x0000,   /* U+05B5 */
  0x0000,   /* U+05B6 */
  0x0000,   /* U+05B7 */
  0x0000,   /* U+05B8 */
  0x0000,   /* U+05B9 */
  0x0000,   /* U+05BA */
  0x0000,   /* U+05BB */
  0x0000,   /* U+05BC */
  0x0000,   /* U+05BD */
  0x0000,   /* U+05BE */
  0x0000,   /* U+05BF */
  0x0000,   /* U+05C0 */
  0x0000,   /* U+05C1 */
  0x0000,   /* U+05C2 */
  0x0000,   /* U+05C3 */
  0x0000,   /* U+05C4 */
  0x0000,   /* U+05C5 */
  0x0000,   /* U+05C6 */
  0x0000,   /* U+05C7 */
  0x85C8,   /* U+05C8 */
  0x85C9,   /* U+05C9 */
  0x85CA,   /* U+05CA */
  0x85CB,   /* U+05CB */
  0x85CC,   /* U+05CC */
  0x85CD,   /* U+05CD */
  0x85CE,   /* U+05CE */
  0x85CF,   /* U+05CF */
  0x0000,   /* U+05D0 */
  0x0000,   /* U+05D1 */
  0x0000,   /* U+05D2 */
  0x0000,   /* U+05D3 */
  0x0000,   /* U+05D4 */
  0x0000,   /* U+05D5 */
  0x0000,   /* U+05D6 */
  0x0000,   /* U+05D7 */
  0x0000,   /* U+05D8 */
  0x0000,   /* U+05D9 */
  0x0000,   /* U+05DA */
  0x0000,   /* U+05DB */
  0x0000,   /* U+05DC */
  0x0000,   /* U+05DD */
  0x0000,   /* U+05DE */
  0x0000,   /* U+05DF */
  0x0000,   /* U+05E0 */
  0x0000,   /* U+05E1 */
  0x0000,   /* U+05E2 */
  0x0000,   /* U+05E3 */
  0x0000,   /* U+05E4 */
  0x0000,   /* U+05E5 */
  0x0000,   /* U+05E6 */
  0x0000,   /* U+05E7 */
  0x0000,   /* U+05E8 */
  0x0000,   /* U+05E9 */
  0x0000,   /* U+05EA */
  0x85EB,   /* U+05EB */
  0x85EC,   /* U+05EC */
  0x85ED,   /* U+05ED */
  0x85EE,   /* U+05EE */
  0x85EF,   /* U+05EF */
  0x22BC,   /* U+05F0 */
  0x22C0,   /* U+05F1 */
  0x22C0,   /* U+05F2 */
  0x0000,   /* U+05F3 */
  0x0000,   /* U+05F4 */
  0x85F5,   /* U+05F5 */
  0x85F6,   /* U+05F6 */
  0x85F7,   /* U+05F7 */
  0x85F8,   /* U+05F8 */
  0x85F9,   /* U+05F9 */
  0x85FA,   /* U+05FA */
  0x85FB,   /* U+05FB */
  0x85FC,   /* U+05FC */
  0x85FD,   /* U+05FD */
  0x85FE,   /* U+05FE */
  0x85FF,   /* U+05FF */

  /* Secondary weight 2 for each character. */
  0x0000,   /* U+0500 */
  0x0000,   /* U+0501 */
  0x0000,   /* U+0502 */
  0x0000,   /* U+0503 */
  0x0000,   /* U+0504 */
  0x0000,   /* U+0505 */
  0x0000,   /* U+0506 */
  0x0000,   /* U+0507 */
  0x0000,   /* U+0508 */
  0x0000,   /* U+0509 */
  0x0000,   /* U+050A */
  0x0000,   /* U+050B */
  0x0000,   /* U+050C */
  0x0000,   /* U+050D */
  0x0000,   /* U+050E */
  0x0000,   /* U+050F */
  0x0000,   /* U+0510 */
  0x0000,   /* U+0511 */
  0x0000,   /* U+0512 */
  0x0000,   /* U+0513 */
  0x0000,   /* U+0514 */
  0x0000,   /* U+0515 */
  0x0000,   /* U+0516 */
  0x0000,   /* U+0517 */
  0x0000,   /* U+0518 */
  0x0000,   /* U+0519 */
  0x0000,   /* U+051A */
  0x0000,   /* U+051B */
  0x0000,   /* U+051C */
  0x0000,   /* U+051D */
  0x0000,   /* U+051E */
  0x0000,   /* U+051F */
  0x0000,   /* U+0520 */
  0x0000,   /* U+0521 */
  0x0000,   /* U+0522 */
  0x0000,   /* U+0523 */
  0x0000,   /* U+0524 */
  0x0000,   /* U+0525 */
  0x0000,   /* U+0526 */
  0x0000,   /* U+0527 */
  0x0000,   /* U+0528 */
  0x0000,   /* U+0529 */
  0x0000,   /* U+052A */
  0x0000,   /* U+052B */
  0x0000,   /* U+052C */
  0x0000,   /* U+052D */
  0x0000,   /* U+052E */
  0x0000,   /* U+052F */
  0x0000,   /* U+0530 */
  0x0000,   /* U+0531 */
  0x0000,   /* U+0532 */
  0x0000,   /* U+0533 */
  0x0000,   /* U+0534 */
  0x0000,   /* U+0535 */
  0x0000,   /* U+0536 */
  0x0000,   /* U+0537 */
  0x0000,   /* U+0538 */
  0x0000,   /* U+0539 */
  0x0000,   /* U+053A */
  0x0000,   /* U+053B */
  0x0000,   /* U+053C */
  0x0000,   /* U+053D */
  0x0000,   /* U+053E */
  0x0000,   /* U+053F */
  0x0000,   /* U+0540 */
  0x0000,   /* U+0541 */
  0x0000,   /* U+0542 */
  0x0000,   /* U+0543 */
  0x0000,   /* U+0544 */
  0x0000,   /* U+0545 */
  0x0000,   /* U+0546 */
  0x0000,   /* U+0547 */
  0x0000,   /* U+0548 */
  0x0000,   /* U+0549 */
  0x0000,   /* U+054A */
  0x0000,   /* U+054B */
  0x0000,   /* U+054C */
  0x0000,   /* U+054D */
  0x0000,   /* U+054E */
  0x0000,   /* U+054F */
  0x0000,   /* U+0550 */
  0x0000,   /* U+0551 */
  0x0000,   /* U+0552 */
  0x0000,   /* U+0553 */
  0x0000,   /* U+0554 */
  0x0000,   /* U+0555 */
  0x0000,   /* U+0556 */
  0x0000,   /* U+0557 */
  0x0000,   /* U+0558 */
  0x0000,   /* U+0559 */
  0x0000,   /* U+055A */
  0x0000,   /* U+055B */
  0x0000,   /* U+055C */
  0x0000,   /* U+055D */
  0x0000,   /* U+055E */
  0x0000,   /* U+055F */
  0x0000,   /* U+0560 */
  0x0000,   /* U+0561 */
  0x0000,   /* U+0562 */
  0x0000,   /* U+0563 */
  0x0000,   /* U+0564 */
  0x0000,   /* U+0565 */
  0x0000,   /* U+0566 */
  0x0000,   /* U+0567 */
  0x0000,   /* U+0568 */
  0x0000,   /* U+0569 */
  0x0000,   /* U+056A */
  0x0000,   /* U+056B */
  0x0000,   /* U+056C */
  0x0000,   /* U+056D */
  0x0000,   /* U+056E */
  0x0000,   /* U+056F */
  0x0000,   /* U+0570 */
  0x0000,   /* U+0571 */
  0x0000,   /* U+0572 */
  0x0000,   /* U+0573 */
  0x0000,   /* U+0574 */
  0x0000,   /* U+0575 */
  0x0000,   /* U+0576 */
  0x0000,   /* U+0577 */
  0x0000,   /* U+0578 */
  0x0000,   /* U+0579 */
  0x0000,   /* U+057A */
  0x0000,   /* U+057B */
  0x0000,   /* U+057C */
  0x0000,   /* U+057D */
  0x0000,   /* U+057E */
  0x0000,   /* U+057F */
  0x0000,   /* U+0580 */
  0x0000,   /* U+0581 */
  0x0000,   /* U+0582 */
  0x0000,   /* U+0583 */
  0x0000,   /* U+0584 */
  0x0000,   /* U+0585 */
  0x0000,   /* U+0586 */
  0x0020,   /* U+0587 */
  0x0000,   /* U+0588 */
  0x0000,   /* U+0589 */
  0x0000,   /* U+058A */
  0x0000,   /* U+058B */
  0x0000,   /* U+058C */
  0x0000,   /* U+058D */
  0x0000,   /* U+058E */
  0x0000,   /* U+058F */
  0x0000,   /* U+0590 */
  0x0000,   /* U+0591 */
  0x0000,   /* U+0592 */
  0x0000,   /* U+0593 */
  0x0000,   /* U+0594 */
  0x0000,   /* U+0595 */
  0x0000,   /* U+0596 */
  0x0000,   /* U+0597 */
  0x0000,   /* U+0598 */
  0x0000,   /* U+0599 */
  0x0000,   /* U+059A */
  0x0000,   /* U+059B */
  0x0000,   /* U+059C */
  0x0000,   /* U+059D */
  0x0000,   /* U+059E */
  0x0000,   /* U+059F */
  0x0000,   /* U+05A0 */
  0x0000,   /* U+05A1 */
  0x0000,   /* U+05A2 */
  0x0000,   /* U+05A3 */
  0x0000,   /* U+05A4 */
  0x0000,   /* U+05A5 */
  0x0000,   /* U+05A6 */
  0x0000,   /* U+05A7 */
  0x0000,   /* U+05A8 */
  0x0000,   /* U+05A9 */
  0x0000,   /* U+05AA */
  0x0000,   /* U+05AB */
  0x0000,   /* U+05AC */
  0x0000,   /* U+05AD */
  0x0000,   /* U+05AE */
  0x0000,   /* U+05AF */
  0x0000,   /* U+05B0 */
  0x0000,   /* U+05B1 */
  0x0000,   /* U+05B2 */
  0x0000,   /* U+05B3 */
  0x0000,   /* U+05B4 */
  0x0000,   /* U+05B5 */
  0x0000,   /* U+05B6 */
  0x0000,   /* U+05B7 */
  0x0000,   /* U+05B8 */
  0x0000,   /* U+05B9 */
  0x0000,   /* U+05BA */
  0x0000,   /* U+05BB */
  0x0000,   /* U+05BC */
  0x0000,   /* U+05BD */
  0x0000,   /* U+05BE */
  0x0000,   /* U+05BF */
  0x0000,   /* U+05C0 */
  0x0000,   /* U+05C1 */
  0x0000,   /* U+05C2 */
  0x0000,   /* U+05C3 */
  0x0000,   /* U+05C4 */
  0x0000,   /* U+05C5 */
  0x0000,   /* U+05C6 */
  0x0000,   /* U+05C7 */
  0x0000,   /* U+05C8 */
  0x0000,   /* U+05C9 */
  0x0000,   /* U+05CA */
  0x0000,   /* U+05CB */
  0x0000,   /* U+05CC */
  0x0000,   /* U+05CD */
  0x0000,   /* U+05CE */
  0x0000,   /* U+05CF */
  0x0000,   /* U+05D0 */
  0x0000,   /* U+05D1 */
  0x0000,   /* U+05D2 */
  0x0000,   /* U+05D3 */
  0x0000,   /* U+05D4 */
  0x0000,   /* U+05D5 */
  0x0000,   /* U+05D6 */
  0x0000,   /* U+05D7 */
  0x0000,   /* U+05D8 */
  0x0000,   /* U+05D9 */
  0x0000,   /* U+05DA */
  0x0000,   /* U+05DB */
  0x0000,   /* U+05DC */
  0x0000,   /* U+05DD */
  0x0000,   /* U+05DE */
  0x0000,   /* U+05DF */
  0x0000,   /* U+05E0 */
  0x0000,   /* U+05E1 */
  0x0000,   /* U+05E2 */
  0x0000,   /* U+05E3 */
  0x0000,   /* U+05E4 */
  0x0000,   /* U+05E5 */
  0x0000,   /* U+05E6 */
  0x0000,   /* U+05E7 */
  0x0000,   /* U+05E8 */
  0x0000,   /* U+05E9 */
  0x0000,   /* U+05EA */
  0x0000,   /* U+05EB */
  0x0000,   /* U+05EC */
  0x0000,   /* U+05ED */
  0x0000,   /* U+05EE */
  0x0000,   /* U+05EF */
  0x0020,   /* U+05F0 */
  0x0020,   /* U+05F1 */
  0x0020,   /* U+05F2 */
  0x0000,   /* U+05F3 */
  0x0000,   /* U+05F4 */
  0x0000,   /* U+05F5 */
  0x0000,   /* U+05F6 */
  0x0000,   /* U+05F7 */
  0x0000,   /* U+05F8 */
  0x0000,   /* U+05F9 */
  0x0000,   /* U+05FA */
  0x0000,   /* U+05FB */
  0x0000,   /* U+05FC */
  0x0000,   /* U+05FD */
  0x0000,   /* U+05FE */
  0x0000,   /* U+05FF */

  /* Tertiary weight 2 for each character. */
  0x0000,   /* U+0500 */
  0x0000,   /* U+0501 */
  0x0000,   /* U+0502 */
  0x0000,   /* U+0503 */
  0x0000,   /* U+0504 */
  0x0000,   /* U+0505 */
  0x0000,   /* U+0506 */
  0x0000,   /* U+0507 */
  0x0000,   /* U+0508 */
  0x0000,   /* U+0509 */
  0x0000,   /* U+050A */
  0x0000,   /* U+050B */
  0x0000,   /* U+050C */
  0x0000,   /* U+050D */
  0x0000,   /* U+050E */
  0x0000,   /* U+050F */
  0x0000,   /* U+0510 */
  0x0000,   /* U+0511 */
  0x0000,   /* U+0512 */
  0x0000,   /* U+0513 */
  0x0000,   /* U+0514 */
  0x0000,   /* U+0515 */
  0x0000,   /* U+0516 */
  0x0000,   /* U+0517 */
  0x0000,   /* U+0518 */
  0x0000,   /* U+0519 */
  0x0000,   /* U+051A */
  0x0000,   /* U+051B */
  0x0000,   /* U+051C */
  0x0000,   /* U+051D */
  0x0000,   /* U+051E */
  0x0000,   /* U+051F */
  0x0000,   /* U+0520 */
  0x0000,   /* U+0521 */
  0x0000,   /* U+0522 */
  0x0000,   /* U+0523 */
  0x0000,   /* U+0524 */
  0x0000,   /* U+0525 */
  0x0000,   /* U+0526 */
  0x0000,   /* U+0527 */
  0x0000,   /* U+0528 */
  0x0000,   /* U+0529 */
  0x0000,   /* U+052A */
  0x0000,   /* U+052B */
  0x0000,   /* U+052C */
  0x0000,   /* U+052D */
  0x0000,   /* U+052E */
  0x0000,   /* U+052F */
  0x0000,   /* U+0530 */
  0x0000,   /* U+0531 */
  0x0000,   /* U+0532 */
  0x0000,   /* U+0533 */
  0x0000,   /* U+0534 */
  0x0000,   /* U+0535 */
  0x0000,   /* U+0536 */
  0x0000,   /* U+0537 */
  0x0000,   /* U+0538 */
  0x0000,   /* U+0539 */
  0x0000,   /* U+053A */
  0x0000,   /* U+053B */
  0x0000,   /* U+053C */
  0x0000,   /* U+053D */
  0x0000,   /* U+053E */
  0x0000,   /* U+053F */
  0x0000,   /* U+0540 */
  0x0000,   /* U+0541 */
  0x0000,   /* U+0542 */
  0x0000,   /* U+0543 */
  0x0000,   /* U+0544 */
  0x0000,   /* U+0545 */
  0x0000,   /* U+0546 */
  0x0000,   /* U+0547 */
  0x0000,   /* U+0548 */
  0x0000,   /* U+0549 */
  0x0000,   /* U+054A */
  0x0000,   /* U+054B */
  0x0000,   /* U+054C */
  0x0000,   /* U+054D */
  0x0000,   /* U+054E */
  0x0000,   /* U+054F */
  0x0000,   /* U+0550 */
  0x0000,   /* U+0551 */
  0x0000,   /* U+0552 */
  0x0000,   /* U+0553 */
  0x0000,   /* U+0554 */
  0x0000,   /* U+0555 */
  0x0000,   /* U+0556 */
  0x0000,   /* U+0557 */
  0x0000,   /* U+0558 */
  0x0000,   /* U+0559 */
  0x0000,   /* U+055A */
  0x0000,   /* U+055B */
  0x0000,   /* U+055C */
  0x0000,   /* U+055D */
  0x0000,   /* U+055E */
  0x0000,   /* U+055F */
  0x0000,   /* U+0560 */
  0x0000,   /* U+0561 */
  0x0000,   /* U+0562 */
  0x0000,   /* U+0563 */
  0x0000,   /* U+0564 */
  0x0000,   /* U+0565 */
  0x0000,   /* U+0566 */
  0x0000,   /* U+0567 */
  0x0000,   /* U+0568 */
  0x0000,   /* U+0569 */
  0x0000,   /* U+056A */
  0x0000,   /* U+056B */
  0x0000,   /* U+056C */
  0x0000,   /* U+056D */
  0x0000,   /* U+056E */
  0x0000,   /* U+056F */
  0x0000,   /* U+0570 */
  0x0000,   /* U+0571 */
  0x0000,   /* U+0572 */
  0x0000,   /* U+0573 */
  0x0000,   /* U+0574 */
  0x0000,   /* U+0575 */
  0x0000,   /* U+0576 */
  0x0000,   /* U+0577 */
  0x0000,   /* U+0578 */
  0x0000,   /* U+0579 */
  0x0000,   /* U+057A */
  0x0000,   /* U+057B */
  0x0000,   /* U+057C */
  0x0000,   /* U+057D */
  0x0000,   /* U+057E */
  0x0000,   /* U+057F */
  0x0000,   /* U+0580 */
  0x0000,   /* U+0581 */
  0x0000,   /* U+0582 */
  0x0000,   /* U+0583 */
  0x0000,   /* U+0584 */
  0x0000,   /* U+0585 */
  0x0000,   /* U+0586 */
  0x0004,   /* U+0587 */
  0x0000,   /* U+0588 */
  0x0000,   /* U+0589 */
  0x0000,   /* U+058A */
  0x0000,   /* U+058B */
  0x0000,   /* U+058C */
  0x0000,   /* U+058D */
  0x0000,   /* U+058E */
  0x0000,   /* U+058F */
  0x0000,   /* U+0590 */
  0x0000,   /* U+0591 */
  0x0000,   /* U+0592 */
  0x0000,   /* U+0593 */
  0x0000,   /* U+0594 */
  0x0000,   /* U+0595 */
  0x0000,   /* U+0596 */
  0x0000,   /* U+0597 */
  0x0000,   /* U+0598 */
  0x0000,   /* U+0599 */
  0x0000,   /* U+059A */
  0x0000,   /* U+059B */
  0x0000,   /* U+059C */
  0x0000,   /* U+059D */
  0x0000,   /* U+059E */
  0x0000,   /* U+059F */
  0x0000,   /* U+05A0 */
  0x0000,   /* U+05A1 */
  0x0000,   /* U+05A2 */
  0x0000,   /* U+05A3 */
  0x0000,   /* U+05A4 */
  0x0000,   /* U+05A5 */
  0x0000,   /* U+05A6 */
  0x0000,   /* U+05A7 */
  0x0000,   /* U+05A8 */
  0x0000,   /* U+05A9 */
  0x0000,   /* U+05AA */
  0x0000,   /* U+05AB */
  0x0000,   /* U+05AC */
  0x0000,   /* U+05AD */
  0x0000,   /* U+05AE */
  0x0000,   /* U+05AF */
  0x0000,   /* U+05B0 */
  0x0000,   /* U+05B1 */
  0x0000,   /* U+05B2 */
  0x0000,   /* U+05B3 */
  0x0000,   /* U+05B4 */
  0x0000,   /* U+05B5 */
  0x0000,   /* U+05B6 */
  0x0000,   /* U+05B7 */
  0x0000,   /* U+05B8 */
  0x0000,   /* U+05B9 */
  0x0000,   /* U+05BA */
  0x0000,   /* U+05BB */
  0x0000,   /* U+05BC */
  0x0000,   /* U+05BD */
  0x0000,   /* U+05BE */
  0x0000,   /* U+05BF */
  0x0000,   /* U+05C0 */
  0x0000,   /* U+05C1 */
  0x0000,   /* U+05C2 */
  0x0000,   /* U+05C3 */
  0x0000,   /* U+05C4 */
  0x0000,   /* U+05C5 */
  0x0000,   /* U+05C6 */
  0x0000,   /* U+05C7 */
  0x0000,   /* U+05C8 */
  0x0000,   /* U+05C9 */
  0x0000,   /* U+05CA */
  0x0000,   /* U+05CB */
  0x0000,   /* U+05CC */
  0x0000,   /* U+05CD */
  0x0000,   /* U+05CE */
  0x0000,   /* U+05CF */
  0x0000,   /* U+05D0 */
  0x0000,   /* U+05D1 */
  0x0000,   /* U+05D2 */
  0x0000,   /* U+05D3 */
  0x0000,   /* U+05D4 */
  0x0000,   /* U+05D5 */
  0x0000,   /* U+05D6 */
  0x0000,   /* U+05D7 */
  0x0000,   /* U+05D8 */
  0x0000,   /* U+05D9 */
  0x0000,   /* U+05DA */
  0x0000,   /* U+05DB */
  0x0000,   /* U+05DC */
  0x0000,   /* U+05DD */
  0x0000,   /* U+05DE */
  0x0000,   /* U+05DF */
  0x0000,   /* U+05E0 */
  0x0000,   /* U+05E1 */
  0x0000,   /* U+05E2 */
  0x0000,   /* U+05E3 */
  0x0000,   /* U+05E4 */
  0x0000,   /* U+05E5 */
  0x0000,   /* U+05E6 */
  0x0000,   /* U+05E7 */
  0x0000,   /* U+05E8 */
  0x0000,   /* U+05E9 */
  0x0000,   /* U+05EA */
  0x0000,   /* U+05EB */
  0x0000,   /* U+05EC */
  0x0000,   /* U+05ED */
  0x0000,   /* U+05EE */
  0x0000,   /* U+05EF */
  0x0004,   /* U+05F0 */
  0x0004,   /* U+05F1 */
  0x0004,   /* U+05F2 */
  0x0000,   /* U+05F3 */
  0x0000,   /* U+05F4 */
  0x0000,   /* U+05F5 */
  0x0000,   /* U+05F6 */
  0x0000,   /* U+05F7 */
  0x0000,   /* U+05F8 */
  0x0000,   /* U+05F9 */
  0x0000,   /* U+05FA */
  0x0000,   /* U+05FB */
  0x0000,   /* U+05FC */
  0x0000,   /* U+05FD */
  0x0000,   /* U+05FE */
  0x0000,   /* U+05FF */
};

uint16 uca900_p006[]= {
  /* Number of CEs for each character. */
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  2, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 1,

  /* Primary weight 1 for each character. */
  0x0000,   /* U+0600 */
  0x0000,   /* U+0601 */
  0x0000,   /* U+0602 */
  0x0000,   /* U+0603 */
  0x0000,   /* U+0604 */
  0x0000,   /* U+0605 */
  0x062D,   /* U+0606 */
  0x062F,   /* U+0607 */
  0x04FA,   /* U+0608 */
  0x039C,   /* U+0609 */
  0x039E,   /* U+060A */
  0x1C16,   /* U+060B */
  0x0227,   /* U+060C */
  0x0228,   /* U+060D */
  0x04FD,   /* U+060E */
  0x04FE,   /* U+060F */
  0x0000,   /* U+0610 */
  0x0000,   /* U+0611 */
  0x0000,   /* U+0612 */
  0x0000,   /* U+0613 */
  0x0000,   /* U+0614 */
  0x0000,   /* U+0615 */
  0x0000,   /* U+0616 */
  0x0000,   /* U+0617 */
  0x0000,   /* U+0618 */
  0x0000,   /* U+0619 */
  0x0000,   /* U+061A */
  0x0235,   /* U+061B */
  0x0000,   /* U+061C */
  0xFBC0,   /* U+061D */
  0x023B,   /* U+061E */
  0x026A,   /* U+061F */
  0x23CF,   /* U+0620 */
  0x22FD,   /* U+0621 */
  0x22FE,   /* U+0622 */
  0x22FF,   /* U+0623 */
  0x2302,   /* U+0624 */
  0x2303,   /* U+0625 */
  0x2307,   /* U+0626 */
  0x230B,   /* U+0627 */
  0x230D,   /* U+0628 */
  0x231C,   /* U+0629 */
  0x231D,   /* U+062A */
  0x231E,   /* U+062B */
  0x2325,   /* U+062C */
  0x232C,   /* U+062D */
  0x232D,   /* U+062E */
  0x2337,   /* U+062F */
  0x2338,   /* U+0630 */
  0x2346,   /* U+0631 */
  0x2347,   /* U+0632 */
  0x2359,   /* U+0633 */
  0x235A,   /* U+0634 */
  0x2364,   /* U+0635 */
  0x2365,   /* U+0636 */
  0x236A,   /* U+0637 */
  0x236B,   /* U+0638 */
  0x236E,   /* U+0639 */
  0x236F,   /* U+063A */
  0x2398,   /* U+063B */
  0x2399,   /* U+063C */
  0x23CC,   /* U+063D */
  0x23CD,   /* U+063E */
  0x23CE,   /* U+063F */
  0x0000,   /* U+0640 */
  0x2376,   /* U+0641 */
  0x2382,   /* U+0642 */
  0x2387,   /* U+0643 */
  0x239C,   /* U+0644 */
  0x23A3,   /* U+0645 */
  0x23A7,   /* U+0646 */
  0x23B1,   /* U+0647 */
  0x23B7,   /* U+0648 */
  0x23C5,   /* U+0649 */
  0x23C6,   /* U+064A */
  0x0000,   /* U+064B */
  0x0000,   /* U+064C */
  0x0000,   /* U+064D */
  0x0000,   /* U+064E */
  0x0000,   /* U+064F */
  0x0000,   /* U+0650 */
  0x0000,   /* U+0651 */
  0x0000,   /* U+0652 */
  0x0000,   /* U+0653 */
  0x0000,   /* U+0654 */
  0x0000,   /* U+0655 */
  0x0000,   /* U+0656 */
  0x0000,   /* U+0657 */
  0x0000,   /* U+0658 */
  0x0000,   /* U+0659 */
  0x0000,   /* U+065A */
  0x0000,   /* U+065B */
  0x0000,   /* U+065C */
  0x0000,   /* U+065D */
  0x0000,   /* U+065E */
  0x0000,   /* U+065F */
  0x1C3D,   /* U+0660 */
  0x1C3E,   /* U+0661 */
  0x1C3F,   /* U+0662 */
  0x1C40,   /* U+0663 */
  0x1C41,   /* U+0664 */
  0x1C42,   /* U+0665 */
  0x1C43,   /* U+0666 */
  0x1C44,   /* U+0667 */
  0x1C45,   /* U+0668 */
  0x1C46,   /* U+0669 */
  0x039A,   /* U+066A */
  0x0229,   /* U+066B */
  0x022A,   /* U+066C */
  0x0392,   /* U+066D */
  0x230C,   /* U+066E */
  0x2381,   /* U+066F */
  0x0000,   /* U+0670 */
  0x2301,   /* U+0671 */
  0x2300,   /* U+0672 */
  0x2304,   /* U+0673 */
  0x22FD,   /* U+0674 */
  0x230B,   /* U+0675 */
  0x23B7,   /* U+0676 */
  0x23BB,   /* U+0677 */
  0x23C6,   /* U+0678 */
  0x231F,   /* U+0679 */
  0x2320,   /* U+067A */
  0x230E,   /* U+067B */
  0x2321,   /* U+067C */
  0x2322,   /* U+067D */
  0x230F,   /* U+067E */
  0x2323,   /* U+067F */
  0x2310,   /* U+0680 */
  0x232E,   /* U+0681 */
  0x232F,   /* U+0682 */
  0x2326,   /* U+0683 */
  0x2327,   /* U+0684 */
  0x2330,   /* U+0685 */
  0x2328,   /* U+0686 */
  0x232A,   /* U+0687 */
  0x2339,   /* U+0688 */
  0x233A,   /* U+0689 */
  0x233B,   /* U+068A */
  0x233C,   /* U+068B */
  0x233D,   /* U+068C */
  0x233E,   /* U+068D */
  0x2340,   /* U+068E */
  0x2341,   /* U+068F */
  0x2342,   /* U+0690 */
  0x2348,   /* U+0691 */
  0x2349,   /* U+0692 */
  0x234A,   /* U+0693 */
  0x234B,   /* U+0694 */
  0x234C,   /* U+0695 */
  0x234D,   /* U+0696 */
  0x234E,   /* U+0697 */
  0x234F,   /* U+0698 */
  0x2350,   /* U+0699 */
  0x235B,   /* U+069A */
  0x235C,   /* U+069B */
  0x235D,   /* U+069C */
  0x2366,   /* U+069D */
  0x2368,   /* U+069E */
  0x236C,   /* U+069F */
  0x2370,   /* U+06A0 */
  0x2377,   /* U+06A1 */
  0x2378,   /* U+06A2 */
  0x237A,   /* U+06A3 */
  0x237B,   /* U+06A4 */
  0x237D,   /* U+06A5 */
  0x237E,   /* U+06A6 */
  0x2383,   /* U+06A7 */
  0x2385,   /* U+06A8 */
  0x2388,   /* U+06A9 */
  0x2389,   /* U+06AA */
  0x238A,   /* U+06AB */
  0x238B,   /* U+06AC */
  0x238D,   /* U+06AD */
  0x238E,   /* U+06AE */
  0x2390,   /* U+06AF */
  0x2392,   /* U+06B0 */
  0x2393,   /* U+06B1 */
  0x2394,   /* U+06B2 */
  0x2395,   /* U+06B3 */
  0x2396,   /* U+06B4 */
  0x239D,   /* U+06B5 */
  0x239E,   /* U+06B6 */
  0x239F,   /* U+06B7 */
  0x23A0,   /* U+06B8 */
  0x23AD,   /* U+06B9 */
  0x23A8,   /* U+06BA */
  0x23AA,   /* U+06BB */
  0x23AB,   /* U+06BC */
  0x23AC,   /* U+06BD */
  0x23B2,   /* U+06BE */
  0x2329,   /* U+06BF */
  0x23B6,   /* U+06C0 */
  0x23B3,   /* U+06C1 */
  0x23B3,   /* U+06C2 */
  0x23B4,   /* U+06C3 */
  0x23B8,   /* U+06C4 */
  0x23B9,   /* U+06C5 */
  0x23BA,   /* U+06C6 */
  0x23BB,   /* U+06C7 */
  0x23BC,   /* U+06C8 */
  0x23BD,   /* U+06C9 */
  0x23BE,   /* U+06CA */
  0x23BF,   /* U+06CB */
  0x23C7,   /* U+06CC */
  0x23C8,   /* U+06CD */
  0x23C9,   /* U+06CE */
  0x23C1,   /* U+06CF */
  0x23CA,   /* U+06D0 */
  0x23CB,   /* U+06D1 */
  0x23D4,   /* U+06D2 */
  0x23D4,   /* U+06D3 */
  0x0279,   /* U+06D4 */
  0x23B6,   /* U+06D5 */
  0x0000,   /* U+06D6 */
  0x0000,   /* U+06D7 */
  0x0000,   /* U+06D8 */
  0x0000,   /* U+06D9 */
  0x0000,   /* U+06DA */
  0x0000,   /* U+06DB */
  0x0000,   /* U+06DC */
  0x0000,   /* U+06DD */
  0x04FF,   /* U+06DE */
  0x0000,   /* U+06DF */
  0x0000,   /* U+06E0 */
  0x0000,   /* U+06E1 */
  0x0000,   /* U+06E2 */
  0x0000,   /* U+06E3 */
  0x0000,   /* U+06E4 */
  0x23B7,   /* U+06E5 */
  0x23C6,   /* U+06E6 */
  0x0000,   /* U+06E7 */
  0x0000,   /* U+06E8 */
  0x0500,   /* U+06E9 */
  0x0000,   /* U+06EA */
  0x0000,   /* U+06EB */
  0x0000,   /* U+06EC */
  0x0000,   /* U+06ED */
  0x2343,   /* U+06EE */
  0x2351,   /* U+06EF */
  0x1C3D,   /* U+06F0 */
  0x1C3E,   /* U+06F1 */
  0x1C3F,   /* U+06F2 */
  0x1C40,   /* U+06F3 */
  0x1C41,   /* U+06F4 */
  0x1C42,   /* U+06F5 */
  0x1C43,   /* U+06F6 */
  0x1C44,   /* U+06F7 */
  0x1C45,   /* U+06F8 */
  0x1C46,   /* U+06F9 */
  0x235E,   /* U+06FA */
  0x2369,   /* U+06FB */
  0x2371,   /* U+06FC */
  0x22FD,   /* U+06FD */
  0x23A3,   /* U+06FE */
  0x23B5,   /* U+06FF */

  /* Secondary weight 1 for each character. */
  0x0000,   /* U+0600 */
  0x0000,   /* U+0601 */
  0x0000,   /* U+0602 */
  0x0000,   /* U+0603 */
  0x0000,   /* U+0604 */
  0x0000,   /* U+0605 */
  0x0020,   /* U+0606 */
  0x0020,   /* U+0607 */
  0x0020,   /* U+0608 */
  0x0020,   /* U+0609 */
  0x0020,   /* U+060A */
  0x0020,   /* U+060B */
  0x0020,   /* U+060C */
  0x0020,   /* U+060D */
  0x0020,   /* U+060E */
  0x0020,   /* U+060F */
  0x0000,   /* U+0610 */
  0x0000,   /* U+0611 */
  0x0000,   /* U+0612 */
  0x0000,   /* U+0613 */
  0x0000,   /* U+0614 */
  0x0000,   /* U+0615 */
  0x0000,   /* U+0616 */
  0x0000,   /* U+0617 */
  0x0000,   /* U+0618 */
  0x0000,   /* U+0619 */
  0x0000,   /* U+061A */
  0x0020,   /* U+061B */
  0x0000,   /* U+061C */
  0x0020,   /* U+061D */
  0x0020,   /* U+061E */
  0x0020,   /* U+061F */
  0x0020,   /* U+0620 */
  0x0020,   /* U+0621 */
  0x0020,   /* U+0622 */
  0x0020,   /* U+0623 */
  0x0020,   /* U+0624 */
  0x0020,   /* U+0625 */
  0x0020,   /* U+0626 */
  0x0020,   /* U+0627 */
  0x0020,   /* U+0628 */
  0x0020,   /* U+0629 */
  0x0020,   /* U+062A */
  0x0020,   /* U+062B */
  0x0020,   /* U+062C */
  0x0020,   /* U+062D */
  0x0020,   /* U+062E */
  0x0020,   /* U+062F */
  0x0020,   /* U+0630 */
  0x0020,   /* U+0631 */
  0x0020,   /* U+0632 */
  0x0020,   /* U+0633 */
  0x0020,   /* U+0634 */
  0x0020,   /* U+0635 */
  0x0020,   /* U+0636 */
  0x0020,   /* U+0637 */
  0x0020,   /* U+0638 */
  0x0020,   /* U+0639 */
  0x0020,   /* U+063A */
  0x0020,   /* U+063B */
  0x0020,   /* U+063C */
  0x0020,   /* U+063D */
  0x0020,   /* U+063E */
  0x0020,   /* U+063F */
  0x0000,   /* U+0640 */
  0x0020,   /* U+0641 */
  0x0020,   /* U+0642 */
  0x0020,   /* U+0643 */
  0x0020,   /* U+0644 */
  0x0020,   /* U+0645 */
  0x0020,   /* U+0646 */
  0x0020,   /* U+0647 */
  0x0020,   /* U+0648 */
  0x0020,   /* U+0649 */
  0x0020,   /* U+064A */
  0x006D,   /* U+064B */
  0x0070,   /* U+064C */
  0x0073,   /* U+064D */
  0x0076,   /* U+064E */
  0x007A,   /* U+064F */
  0x007D,   /* U+0650 */
  0x0080,   /* U+0651 */
  0x0081,   /* U+0652 */
  0x0082,   /* U+0653 */
  0x0083,   /* U+0654 */
  0x0084,   /* U+0655 */
  0x0086,   /* U+0656 */
  0x0087,   /* U+0657 */
  0x0088,   /* U+0658 */
  0x008A,   /* U+0659 */
  0x008B,   /* U+065A */
  0x008C,   /* U+065B */
  0x008D,   /* U+065C */
  0x008E,   /* U+065D */
  0x008F,   /* U+065E */
  0x0085,   /* U+065F */
  0x0020,   /* U+0660 */
  0x0020,   /* U+0661 */
  0x0020,   /* U+0662 */
  0x0020,   /* U+0663 */
  0x0020,   /* U+0664 */
  0x0020,   /* U+0665 */
  0x0020,   /* U+0666 */
  0x0020,   /* U+0667 */
  0x0020,   /* U+0668 */
  0x0020,   /* U+0669 */
  0x0020,   /* U+066A */
  0x0020,   /* U+066B */
  0x0020,   /* U+066C */
  0x0020,   /* U+066D */
  0x0020,   /* U+066E */
  0x0020,   /* U+066F */
  0x0098,   /* U+0670 */
  0x0020,   /* U+0671 */
  0x0020,   /* U+0672 */
  0x0020,   /* U+0673 */
  0x0020,   /* U+0674 */
  0x0020,   /* U+0675 */
  0x0020,   /* U+0676 */
  0x0020,   /* U+0677 */
  0x0020,   /* U+0678 */
  0x0020,   /* U+0679 */
  0x0020,   /* U+067A */
  0x0020,   /* U+067B */
  0x0020,   /* U+067C */
  0x0020,   /* U+067D */
  0x0020,   /* U+067E */
  0x0020,   /* U+067F */
  0x0020,   /* U+0680 */
  0x0020,   /* U+0681 */
  0x0020,   /* U+0682 */
  0x0020,   /* U+0683 */
  0x0020,   /* U+0684 */
  0x0020,   /* U+0685 */
  0x0020,   /* U+0686 */
  0x0020,   /* U+0687 */
  0x0020,   /* U+0688 */
  0x0020,   /* U+0689 */
  0x0020,   /* U+068A */
  0x0020,   /* U+068B */
  0x0020,   /* U+068C */
  0x0020,   /* U+068D */
  0x0020,   /* U+068E */
  0x0020,   /* U+068F */
  0x0020,   /* U+0690 */
  0x0020,   /* U+0691 */
  0x0020,   /* U+0692 */
  0x0020,   /* U+0693 */
  0x0020,   /* U+0694 */
  0x0020,   /* U+0695 */
  0x0020,   /* U+0696 */
  0x0020,   /* U+0697 */
  0x0020,   /* U+0698 */
  0x0020,   /* U+0699 */
  0x0020,   /* U+069A */
  0x0020,   /* U+069B */
  0x0020,   /* U+069C */
  0x0020,   /* U+069D */
  0x0020,   /* U+069E */
  0x0020,   /* U+069F */
  0x0020,   /* U+06A0 */
  0x0020,   /* U+06A1 */
  0x0020,   /* U+06A2 */
  0x0020,   /* U+06A3 */
  0x0020,   /* U+06A4 */
  0x0020,   /* U+06A5 */
  0x0020,   /* U+06A6 */
  0x0020,   /* U+06A7 */
  0x0020,   /* U+06A8 */
  0x0020,   /* U+06A9 */
  0x0020,   /* U+06AA */
  0x0020,   /* U+06AB */
  0x0020,   /* U+06AC */
  0x0020,   /* U+06AD */
  0x0020,   /* U+06AE */
  0x0020,   /* U+06AF */
  0x0020,   /* U+06B0 */
  0x0020,   /* U+06B1 */
  0x0020,   /* U+06B2 */
  0x0020,   /* U+06B3 */
  0x0020,   /* U+06B4 */
  0x0020,   /* U+06B5 */
  0x0020,   /* U+06B6 */
  0x0020,   /* U+06B7 */
  0x0020,   /* U+06B8 */
  0x0020,   /* U+06B9 */
  0x0020,   /* U+06BA */
  0x0020,   /* U+06BB */
  0x0020,   /* U+06BC */
  0x0020,   /* U+06BD */
  0x0020,   /* U+06BE */
  0x0020,   /* U+06BF */
  0x0020,   /* U+06C0 */
  0x0020,   /* U+06C1 */
  0x0020,   /* U+06C2 */
  0x0020,   /* U+06C3 */
  0x0020,   /* U+06C4 */
  0x0020,   /* U+06C5 */
  0x0020,   /* U+06C6 */
  0x0020,   /* U+06C7 */
  0x0020,   /* U+06C8 */
  0x0020,   /* U+06C9 */
  0x0020,   /* U+06CA */
  0x0020,   /* U+06CB */
  0x0020,   /* U+06CC */
  0x0020,   /* U+06CD */
  0x0020,   /* U+06CE */
  0x0020,   /* U+06CF */
  0x0020,   /* U+06D0 */
  0x0020,   /* U+06D1 */
  0x0020,   /* U+06D2 */
  0x0020,   /* U+06D3 */
  0x0020,   /* U+06D4 */
  0x0020,   /* U+06D5 */
  0x0000,   /* U+06D6 */
  0x0000,   /* U+06D7 */
  0x0000,   /* U+06D8 */
  0x0000,   /* U+06D9 */
  0x0000,   /* U+06DA */
  0x0000,   /* U+06DB */
  0x0000,   /* U+06DC */
  0x0000,   /* U+06DD */
  0x0020,   /* U+06DE */
  0x0000,   /* U+06DF */
  0x0000,   /* U+06E0 */
  0x0000,   /* U+06E1 */
  0x0000,   /* U+06E2 */
  0x0000,   /* U+06E3 */
  0x0000,   /* U+06E4 */
  0x0020,   /* U+06E5 */
  0x0020,   /* U+06E6 */
  0x0000,   /* U+06E7 */
  0x0000,   /* U+06E8 */
  0x0020,   /* U+06E9 */
  0x0000,   /* U+06EA */
  0x0000,   /* U+06EB */
  0x0000,   /* U+06EC */
  0x0000,   /* U+06ED */
  0x0020,   /* U+06EE */
  0x0020,   /* U+06EF */
  0x0020,   /* U+06F0 */
  0x0020,   /* U+06F1 */
  0x0020,   /* U+06F2 */
  0x0020,   /* U+06F3 */
  0x0020,   /* U+06F4 */
  0x0020,   /* U+06F5 */
  0x0020,   /* U+06F6 */
  0x0020,   /* U+06F7 */
  0x0020,   /* U+06F8 */
  0x0020,   /* U+06F9 */
  0x0020,   /* U+06FA */
  0x0020,   /* U+06FB */
  0x0020,   /* U+06FC */
  0x0020,   /* U+06FD */
  0x0020,   /* U+06FE */
  0x0020,   /* U+06FF */

  /* Tertiary weight 1 for each character. */
  0x0000,   /* U+0600 */
  0x0000,   /* U+0601 */
  0x0000,   /* U+0602 */
  0x0000,   /* U+0603 */
  0x0000,   /* U+0604 */
  0x0000,   /* U+0605 */
  0x0002,   /* U+0606 */
  0x0002,   /* U+0607 */
  0x0002,   /* U+0608 */
  0x0002,   /* U+0609 */
  0x0002,   /* U+060A */
  0x0002,   /* U+060B */
  0x0002,   /* U+060C */
  0x0002,   /* U+060D */
  0x0002,   /* U+060E */
  0x0002,   /* U+060F */
  0x0000,   /* U+0610 */
  0x0000,   /* U+0611 */
  0x0000,   /* U+0612 */
  0x0000,   /* U+0613 */
  0x0000,   /* U+0614 */
  0x0000,   /* U+0615 */
  0x0000,   /* U+0616 */
  0x0000,   /* U+0617 */
  0x0000,   /* U+0618 */
  0x0000,   /* U+0619 */
  0x0000,   /* U+061A */
  0x0002,   /* U+061B */
  0x0000,   /* U+061C */
  0x0002,   /* U+061D */
  0x0002,   /* U+061E */
  0x0002,   /* U+061F */
  0x0002,   /* U+0620 */
  0x0002,   /* U+0621 */
  0x0002,   /* U+0622 */
  0x0002,   /* U+0623 */
  0x0002,   /* U+0624 */
  0x0002,   /* U+0625 */
  0x0002,   /* U+0626 */
  0x0002,   /* U+0627 */
  0x0002,   /* U+0628 */
  0x0002,   /* U+0629 */
  0x0002,   /* U+062A */
  0x0002,   /* U+062B */
  0x0002,   /* U+062C */
  0x0002,   /* U+062D */
  0x0002,   /* U+062E */
  0x0002,   /* U+062F */
  0x0002,   /* U+0630 */
  0x0002,   /* U+0631 */
  0x0002,   /* U+0632 */
  0x0002,   /* U+0633 */
  0x0002,   /* U+0634 */
  0x0002,   /* U+0635 */
  0x0002,   /* U+0636 */
  0x0002,   /* U+0637 */
  0x0002,   /* U+0638 */
  0x0002,   /* U+0639 */
  0x0002,   /* U+063A */
  0x0002,   /* U+063B */
  0x0002,   /* U+063C */
  0x0002,   /* U+063D */
  0x0002,   /* U+063E */
  0x0002,   /* U+063F */
  0x0000,   /* U+0640 */
  0x0002,   /* U+0641 */
  0x0002,   /* U+0642 */
  0x0002,   /* U+0643 */
  0x0002,   /* U+0644 */
  0x0002,   /* U+0645 */
  0x0002,   /* U+0646 */
  0x0002,   /* U+0647 */
  0x0002,   /* U+0648 */
  0x0002,   /* U+0649 */
  0x0002,   /* U+064A */
  0x0002,   /* U+064B */
  0x0002,   /* U+064C */
  0x0002,   /* U+064D */
  0x0002,   /* U+064E */
  0x0002,   /* U+064F */
  0x0002,   /* U+0650 */
  0x0002,   /* U+0651 */
  0x0002,   /* U+0652 */
  0x0002,   /* U+0653 */
  0x0002,   /* U+0654 */
  0x0002,   /* U+0655 */
  0x0002,   /* U+0656 */
  0x0002,   /* U+0657 */
  0x0002,   /* U+0658 */
  0x0002,   /* U+0659 */
  0x0002,   /* U+065A */
  0x0002,   /* U+065B */
  0x0002,   /* U+065C */
  0x0002,   /* U+065D */
  0x0002,   /* U+065E */
  0x0002,   /* U+065F */
  0x0002,   /* U+0660 */
  0x0002,   /* U+0661 */
  0x0002,   /* U+0662 */
  0x0002,   /* U+0663 */
  0x0002,   /* U+0664 */
  0x0002,   /* U+0665 */
  0x0002,   /* U+0666 */
  0x0002,   /* U+0667 */
  0x0002,   /* U+0668 */
  0x0002,   /* U+0669 */
  0x0002,   /* U+066A */
  0x0002,   /* U+066B */
  0x0002,   /* U+066C */
  0x0002,   /* U+066D */
  0x0002,   /* U+066E */
  0x0002,   /* U+066F */
  0x0002,   /* U+0670 */
  0x0002,   /* U+0671 */
  0x0002,   /* U+0672 */
  0x0002,   /* U+0673 */
  0x0004,   /* U+0674 */
  0x0004,   /* U+0675 */
  0x0004,   /* U+0676 */
  0x0004,   /* U+0677 */
  0x0004,   /* U+0678 */
  0x0002,   /* U+0679 */
  0x0002,   /* U+067A */
  0x0002,   /* U+067B */
  0x0002,   /* U+067C */
  0x0002,   /* U+067D */
  0x0002,   /* U+067E */
  0x0002,   /* U+067F */
  0x0002,   /* U+0680 */
  0x0002,   /* U+0681 */
  0x0002,   /* U+0682 */
  0x0002,   /* U+0683 */
  0x0002,   /* U+0684 */
  0x0002,   /* U+0685 */
  0x0002,   /* U+0686 */
  0x0002,   /* U+0687 */
  0x0002,   /* U+0688 */
  0x0002,   /* U+0689 */
  0x0002,   /* U+068A */
  0x0002,   /* U+068B */
  0x0002,   /* U+068C */
  0x0002,   /* U+068D */
  0x0002,   /* U+068E */
  0x0002,   /* U+068F */
  0x0002,   /* U+0690 */
  0x0002,   /* U+0691 */
  0x0002,   /* U+0692 */
  0x0002,   /* U+0693 */
  0x0002,   /* U+0694 */
  0x0002,   /* U+0695 */
  0x0002,   /* U+0696 */
  0x0002,   /* U+0697 */
  0x0002,   /* U+0698 */
  0x0002,   /* U+0699 */
  0x0002,   /* U+069A */
  0x0002,   /* U+069B */
  0x0002,   /* U+069C */
  0x0002,   /* U+069D */
  0x0002,   /* U+069E */
  0x0002,   /* U+069F */
  0x0002,   /* U+06A0 */
  0x0002,   /* U+06A1 */
  0x0002,   /* U+06A2 */
  0x0002,   /* U+06A3 */
  0x0002,   /* U+06A4 */
  0x0002,   /* U+06A5 */
  0x0002,   /* U+06A6 */
  0x0002,   /* U+06A7 */
  0x0002,   /* U+06A8 */
  0x0002,   /* U+06A9 */
  0x0002,   /* U+06AA */
  0x0002,   /* U+06AB */
  0x0002,   /* U+06AC */
  0x0002,   /* U+06AD */
  0x0002,   /* U+06AE */
  0x0002,   /* U+06AF */
  0x0002,   /* U+06B0 */
  0x0002,   /* U+06B1 */
  0x0002,   /* U+06B2 */
  0x0002,   /* U+06B3 */
  0x0002,   /* U+06B4 */
  0x0002,   /* U+06B5 */
  0x0002,   /* U+06B6 */
  0x0002,   /* U+06B7 */
  0x0002,   /* U+06B8 */
  0x0002,   /* U+06B9 */
  0x0002,   /* U+06BA */
  0x0002,   /* U+06BB */
  0x0002,   /* U+06BC */
  0x0002,   /* U+06BD */
  0x0002,   /* U+06BE */
  0x0002,   /* U+06BF */
  0x0002,   /* U+06C0 */
  0x0002,   /* U+06C1 */
  0x0002,   /* U+06C2 */
  0x0002,   /* U+06C3 */
  0x0002,   /* U+06C4 */
  0x0002,   /* U+06C5 */
  0x0002,   /* U+06C6 */
  0x0002,   /* U+06C7 */
  0x0002,   /* U+06C8 */
  0x0002,   /* U+06C9 */
  0x0002,   /* U+06CA */
  0x0002,   /* U+06CB */
  0x0002,   /* U+06CC */
  0x0002,   /* U+06CD */
  0x0002,   /* U+06CE */
  0x0002,   /* U+06CF */
  0x0002,   /* U+06D0 */
  0x0002,   /* U+06D1 */
  0x0002,   /* U+06D2 */
  0x0002,   /* U+06D3 */
  0x0002,   /* U+06D4 */
  0x0002,   /* U+06D5 */
  0x0000,   /* U+06D6 */
  0x0000,   /* U+06D7 */
  0x0000,   /* U+06D8 */
  0x0000,   /* U+06D9 */
  0x0000,   /* U+06DA */
  0x0000,   /* U+06DB */
  0x0000,   /* U+06DC */
  0x0000,   /* U+06DD */
  0x0002,   /* U+06DE */
  0x0000,   /* U+06DF */
  0x0000,   /* U+06E0 */
  0x0000,   /* U+06E1 */
  0x0000,   /* U+06E2 */
  0x0000,   /* U+06E3 */
  0x0000,   /* U+06E4 */
  0x0004,   /* U+06E5 */
  0x0004,   /* U+06E6 */
  0x0000,   /* U+06E7 */
  0x0000,   /* U+06E8 */
  0x0002,   /* U+06E9 */
  0x0000,   /* U+06EA */
  0x0000,   /* U+06EB */
  0x0000,   /* U+06EC */
  0x0000,   /* U+06ED */
  0x0002,   /* U+06EE */
  0x0002,   /* U+06EF */
  0x0002,   /* U+06F0 */
  0x0002,   /* U+06F1 */
  0x0002,   /* U+06F2 */
  0x0002,   /* U+06F3 */
  0x0002,   /* U+06F4 */
  0x0002,   /* U+06F5 */
  0x0002,   /* U+06F6 */
  0x0002,   /* U+06F7 */
  0x0002,   /* U+06F8 */
  0x0002,   /* U+06F9 */
  0x0002,   /* U+06FA */
  0x0002,   /* U+06FB */
  0x0002,   /* U+06FC */
  0x0004,   /* U+06FD */
  0x0004,   /* U+06FE */
  0x0002,   /* U+06FF */

  /* Primary weight 2 for each character. */
  0x0000,   /* U+0600 */
  0x0000,   /* U+0601 */
  0x0000,   /* U+0602 */
  0x0000,   /* U+0603 */
  0x0000,   /* U+0604 */
  0x0000,   /* U+0605 */
  0x0000,   /* U+0606 */
  0x0000,   /* U+0607 */
  0x0000,   /* U+0608 */
  0x0000,   /* U+0609 */
  0x0000,   /* U+060A */
  0x0000,   /* U+060B */
  0x0000,   /* U+060C */
  0x0000,   /* U+060D */
  0x0000,   /* U+060E */
  0x0000,   /* U+060F */
  0x0000,   /* U+0610 */
  0x0000,   /* U+0611 */
  0x0000,   /* U+0612 */
  0x0000,   /* U+0613 */
  0x0000,   /* U+0614 */
  0x0000,   /* U+0615 */
  0x0000,   /* U+0616 */
  0x0000,   /* U+0617 */
  0x0000,   /* U+0618 */
  0x0000,   /* U+0619 */
  0x0000,   /* U+061A */
  0x0000,   /* U+061B */
  0x0000,   /* U+061C */
  0x861D,   /* U+061D */
  0x0000,   /* U+061E */
  0x0000,   /* U+061F */
  0x0000,   /* U+0620 */
  0x0000,   /* U+0621 */
  0x0000,   /* U+0622 */
  0x0000,   /* U+0623 */
  0x0000,   /* U+0624 */
  0x0000,   /* U+0625 */
  0x0000,   /* U+0626 */
  0x0000,   /* U+0627 */
  0x0000,   /* U+0628 */
  0x0000,   /* U+0629 */
  0x0000,   /* U+062A */
  0x0000,   /* U+062B */
  0x0000,   /* U+062C */
  0x0000,   /* U+062D */
  0x0000,   /* U+062E */
  0x0000,   /* U+062F */
  0x0000,   /* U+0630 */
  0x0000,   /* U+0631 */
  0x0000,   /* U+0632 */
  0x0000,   /* U+0633 */
  0x0000,   /* U+0634 */
  0x0000,   /* U+0635 */
  0x0000,   /* U+0636 */
  0x0000,   /* U+0637 */
  0x0000,   /* U+0638 */
  0x0000,   /* U+0639 */
  0x0000,   /* U+063A */
  0x0000,   /* U+063B */
  0x0000,   /* U+063C */
  0x0000,   /* U+063D */
  0x0000,   /* U+063E */
  0x0000,   /* U+063F */
  0x0000,   /* U+0640 */
  0x0000,   /* U+0641 */
  0x0000,   /* U+0642 */
  0x0000,   /* U+0643 */
  0x0000,   /* U+0644 */
  0x0000,   /* U+0645 */
  0x0000,   /* U+0646 */
  0x0000,   /* U+0647 */
  0x0000,   /* U+0648 */
  0x0000,   /* U+0649 */
  0x0000,   /* U+064A */
  0x0000,   /* U+064B */
  0x0000,   /* U+064C */
  0x0000,   /* U+064D */
  0x0000,   /* U+064E */
  0x0000,   /* U+064F */
  0x0000,   /* U+0650 */
  0x0000,   /* U+0651 */
  0x0000,   /* U+0652 */
  0x0000,   /* U+0653 */
  0x0000,   /* U+0654 */
  0x0000,   /* U+0655 */
  0x0000,   /* U+0656 */
  0x0000,   /* U+0657 */
  0x0000,   /* U+0658 */
  0x0000,   /* U+0659 */
  0x0000,   /* U+065A */
  0x0000,   /* U+065B */
  0x0000,   /* U+065C */
  0x0000,   /* U+065D */
  0x0000,   /* U+065E */
  0x0000,   /* U+065F */
  0x0000,   /* U+0660 */
  0x0000,   /* U+0661 */
  0x0000,   /* U+0662 */
  0x0000,   /* U+0663 */
  0x0000,   /* U+0664 */
  0x0000,   /* U+0665 */
  0x0000,   /* U+0666 */
  0x0000,   /* U+0667 */
  0x0000,   /* U+0668 */
  0x0000,   /* U+0669 */
  0x0000,   /* U+066A */
  0x0000,   /* U+066B */
  0x0000,   /* U+066C */
  0x0000,   /* U+066D */
  0x0000,   /* U+066E */
  0x0000,   /* U+066F */
  0x0000,   /* U+0670 */
  0x0000,   /* U+0671 */
  0x0000,   /* U+0672 */
  0x0000,   /* U+0673 */
  0x0000,   /* U+0674 */
  0x22FD,   /* U+0675 */
  0x22FD,   /* U+0676 */
  0x22FD,   /* U+0677 */
  0x22FD,   /* U+0678 */
  0x0000,   /* U+0679 */
  0x0000,   /* U+067A */
  0x0000,   /* U+067B */
  0x0000,   /* U+067C */
  0x0000,   /* U+067D */
  0x0000,   /* U+067E */
  0x0000,   /* U+067F */
  0x0000,   /* U+0680 */
  0x0000,   /* U+0681 */
  0x0000,   /* U+0682 */
  0x0000,   /* U+0683 */
  0x0000,   /* U+0684 */
  0x0000,   /* U+0685 */
  0x0000,   /* U+0686 */
  0x0000,   /* U+0687 */
  0x0000,   /* U+0688 */
  0x0000,   /* U+0689 */
  0x0000,   /* U+068A */
  0x0000,   /* U+068B */
  0x0000,   /* U+068C */
  0x0000,   /* U+068D */
  0x0000,   /* U+068E */
  0x0000,   /* U+068F */
  0x0000,   /* U+0690 */
  0x0000,   /* U+0691 */
  0x0000,   /* U+0692 */
  0x0000,   /* U+0693 */
  0x0000,   /* U+0694 */
  0x0000,   /* U+0695 */
  0x0000,   /* U+0696 */
  0x0000,   /* U+0697 */
  0x0000,   /* U+0698 */
  0x0000,   /* U+0699 */
  0x0000,   /* U+069A */
  0x0000,   /* U+069B */
  0x0000,   /* U+069C */
  0x0000,   /* U+069D */
  0x0000,   /* U+069E */
  0x0000,   /* U+069F */
  0x0000,   /* U+06A0 */
  0x0000,   /* U+06A1 */
  0x0000,   /* U+06A2 */
  0x0000,   /* U+06A3 */
  0x0000,   /* U+06A4 */
  0x0000,   /* U+06A5 */
  0x0000,   /* U+06A6 */
  0x0000,   /* U+06A7 */
  0x0000,   /* U+06A8 */
  0x0000,   /* U+06A9 */
  0x0000,   /* U+06AA */
  0x0000,   /* U+06AB */
  0x0000,   /* U+06AC */
  0x0000,   /* U+06AD */
  0x0000,   /* U+06AE */
  0x0000,   /* U+06AF */
  0x0000,   /* U+06B0 */
  0x0000,   /* U+06B1 */
  0x0000,   /* U+06B2 */
  0x0000,   /* U+06B3 */
  0x0000,   /* U+06B4 */
  0x0000,   /* U+06B5 */
  0x0000,   /* U+06B6 */
  0x0000,   /* U+06B7 */
  0x0000,   /* U+06B8 */
  0x0000,   /* U+06B9 */
  0x0000,   /* U+06BA */
  0x0000,   /* U+06BB */
  0x0000,   /* U+06BC */
  0x0000,   /* U+06BD */
  0x0000,   /* U+06BE */
  0x0000,   /* U+06BF */
  0x0000,   /* U+06C0 */
  0x0000,   /* U+06C1 */
  0x0000,   /* U+06C2 */
  0x0000,   /* U+06C3 */
  0x0000,   /* U+06C4 */
  0x0000,   /* U+06C5 */
  0x0000,   /* U+06C6 */
  0x0000,   /* U+06C7 */
  0x0000,   /* U+06C8 */
  0x0000,   /* U+06C9 */
  0x0000,   /* U+06CA */
  0x0000,   /* U+06CB */
  0x0000,   /* U+06CC */
  0x0000,   /* U+06CD */
  0x0000,   /* U+06CE */
  0x0000,   /* U+06CF */
  0x0000,   /* U+06D0 */
  0x0000,   /* U+06D1 */
  0x0000,   /* U+06D2 */
  0x0000,   /* U+06D3 */
  0x0000,   /* U+06D4 */
  0x0000,   /* U+06D5 */
  0x0000,   /* U+06D6 */
  0x0000,   /* U+06D7 */
  0x0000,   /* U+06D8 */
  0x0000,   /* U+06D9 */
  0x0000,   /* U+06DA */
  0x0000,   /* U+06DB */
  0x0000,   /* U+06DC */
  0x0000,   /* U+06DD */
  0x0000,   /* U+06DE */
  0x0000,   /* U+06DF */
  0x0000,   /* U+06E0 */
  0x0000,   /* U+06E1 */
  0x0000,   /* U+06E2 */
  0x0000,   /* U+06E3 */
  0x0000,   /* U+06E4 */
  0x0000,   /* U+06E5 */
  0x0000,   /* U+06E6 */
  0x0000,   /* U+06E7 */
  0x0000,   /* U+06E8 */
  0x0000,   /* U+06E9 */
  0x0000,   /* U+06EA */
  0x0000,   /* U+06EB */
  0x0000,   /* U+06EC */
  0x0000,   /* U+06ED */
  0x0000,   /* U+06EE */
  0x0000,   /* U+06EF */
  0x0000,   /* U+06F0 */
  0x0000,   /* U+06F1 */
  0x0000,   /* U+06F2 */
  0x0000,   /* U+06F3 */
  0x0000,   /* U+06F4 */
  0x0000,   /* U+06F5 */
  0x0000,   /* U+06F6 */
  0x0000,   /* U+06F7 */
  0x0000,   /* U+06F8 */
  0x0000,   /* U+06F9 */
  0x0000,   /* U+06FA */
  0x0000,   /* U+06FB */
  0x0000,   /* U+06FC */
  0x0000,   /* U+06FD */
  0x0000,   /* U+06FE */
  0x0000,   /* U+06FF */

  /* Secondary weight 2 for each character. */
  0x0000,   /* U+0600 */
  0x0000,   /* U+0601 */
  0x0000,   /* U+0602 */
  0x0000,   /* U+0603 */
  0x0000,   /* U+0604 */
  0x0000,   /* U+0605 */
  0x0000,   /* U+0606 */
  0x0000,   /* U+0607 */
  0x0000,   /* U+0608 */
  0x0000,   /* U+0609 */
  0x0000,   /* U+060A */
  0x0000,   /* U+060B */
  0x0000,   /* U+060C */
  0x0000,   /* U+060D */
  0x0000,   /* U+060E */
  0x0000,   /* U+060F */
  0x0000,   /* U+0610 */
  0x0000,   /* U+0611 */
  0x0000,   /* U+0612 */
  0x0000,   /* U+0613 */
  0x0000,   /* U+0614 */
  0x0000,   /* U+0615 */
  0x0000,   /* U+0616 */
  0x0000,   /* U+0617 */
  0x0000,   /* U+0618 */
  0x0000,   /* U+0619 */
  0x0000,   /* U+061A */
  0x0000,   /* U+061B */
  0x0000,   /* U+061C */
  0x0000,   /* U+061D */
  0x0000,   /* U+061E */
  0x0000,   /* U+061F */
  0x0000,   /* U+0620 */
  0x0000,   /* U+0621 */
  0x0000,   /* U+0622 */
  0x0000,   /* U+0623 */
  0x0000,   /* U+0624 */
  0x0000,   /* U+0625 */
  0x0000,   /* U+0626 */
  0x0000,   /* U+0627 */
  0x0000,   /* U+0628 */
  0x0000,   /* U+0629 */
  0x0000,   /* U+062A */
  0x0000,   /* U+062B */
  0x0000,   /* U+062C */
  0x0000,   /* U+062D */
  0x0000,   /* U+062E */
  0x0000,   /* U+062F */
  0x0000,   /* U+0630 */
  0x0000,   /* U+0631 */
  0x0000,   /* U+0632 */
  0x0000,   /* U+0633 */
  0x0000,   /* U+0634 */
  0x0000,   /* U+0635 */
  0x0000,   /* U+0636 */
  0x0000,   /* U+0637 */
  0x0000,   /* U+0638 */
  0x0000,   /* U+0639 */
  0x0000,   /* U+063A */
  0x0000,   /* U+063B */
  0x0000,   /* U+063C */
  0x0000,   /* U+063D */
  0x0000,   /* U+063E */
  0x0000,   /* U+063F */
  0x0000,   /* U+0640 */
  0x0000,   /* U+0641 */
  0x0000,   /* U+0642 */
  0x0000,   /* U+0643 */
  0x0000,   /* U+0644 */
  0x0000,   /* U+0645 */
  0x0000,   /* U+0646 */
  0x0000,   /* U+0647 */
  0x0000,   /* U+0648 */
  0x0000,   /* U+0649 */
  0x0000,   /* U+064A */
  0x0000,   /* U+064B */
  0x0000,   /* U+064C */
  0x0000,   /* U+064D */
  0x0000,   /* U+064E */
  0x0000,   /* U+064F */
  0x0000,   /* U+0650 */
  0x0000,   /* U+0651 */
  0x0000,   /* U+0652 */
  0x0000,   /* U+0653 */
  0x0000,   /* U+0654 */
  0x0000,   /* U+0655 */
  0x0000,   /* U+0656 */
  0x0000,   /* U+0657 */
  0x0000,   /* U+0658 */
  0x0000,   /* U+0659 */
  0x0000,   /* U+065A */
  0x0000,   /* U+065B */
  0x0000,   /* U+065C */
  0x0000,   /* U+065D */
  0x0000,   /* U+065E */
  0x0000,   /* U+065F */
  0x0000,   /* U+0660 */
  0x0000,   /* U+0661 */
  0x0000,   /* U+0662 */
  0x0000,   /* U+0663 */
  0x0000,   /* U+0664 */
  0x0000,   /* U+0665 */
  0x0000,   /* U+0666 */
  0x0000,   /* U+0667 */
  0x0000,   /* U+0668 */
  0x0000,   /* U+0669 */
  0x0000,   /* U+066A */
  0x0000,   /* U+066B */
  0x0000,   /* U+066C */
  0x0000,   /* U+066D */
  0x0000,   /* U+066E */
  0x0000,   /* U+066F */
  0x0000,   /* U+0670 */
  0x0000,   /* U+0671 */
  0x0000,   /* U+0672 */
  0x0000,   /* U+0673 */
  0x0000,   /* U+0674 */
  0x0020,   /* U+0675 */
  0x0020,   /* U+0676 */
  0x0020,   /* U+0677 */
  0x0020,   /* U+0678 */
  0x0000,   /* U+0679 */
  0x0000,   /* U+067A */
  0x0000,   /* U+067B */
  0x0000,   /* U+067C */
  0x0000,   /* U+067D */
  0x0000,   /* U+067E */
  0x0000,   /* U+067F */
  0x0000,   /* U+0680 */
  0x0000,   /* U+0681 */
  0x0000,   /* U+0682 */
  0x0000,   /* U+0683 */
  0x0000,   /* U+0684 */
  0x0000,   /* U+0685 */
  0x0000,   /* U+0686 */
  0x0000,   /* U+0687 */
  0x0000,   /* U+0688 */
  0x0000,   /* U+0689 */
  0x0000,   /* U+068A */
  0x0000,   /* U+068B */
  0x0000,   /* U+068C */
  0x0000,   /* U+068D */
  0x0000,   /* U+068E */
  0x0000,   /* U+068F */
  0x0000,   /* U+0690 */
  0x0000,   /* U+0691 */
  0x0000,   /* U+0692 */
  0x0000,   /* U+0693 */
  0x0000,   /* U+0694 */
  0x0000,   /* U+0695 */
  0x0000,   /* U+0696 */
  0x0000,   /* U+0697 */
  0x0000,   /* U+0698 */
  0x0000,   /* U+0699 */
  0x0000,   /* U+069A */
  0x0000,   /* U+069B */
  0x0000,   /* U+069C */
  0x0000,   /* U+069D */
  0x0000,   /* U+069E */
  0x0000,   /* U+069F */
  0x0000,   /* U+06A0 */
  0x0000,   /* U+06A1 */
  0x0000,   /* U+06A2 */
  0x0000,   /* U+06A3 */
  0x0000,   /* U+06A4 */
  0x0000,   /* U+06A5 */
  0x0000,   /* U+06A6 */
  0x0000,   /* U+06A7 */
  0x0000,   /* U+06A8 */
  0x0000,   /* U+06A9 */
  0x0000,   /* U+06AA */
  0x0000,   /* U+06AB */
  0x0000,   /* U+06AC */
  0x0000,   /* U+06AD */
  0x0000,   /* U+06AE */
  0x0000,   /* U+06AF */
  0x0000,   /* U+06B0 */
  0x0000,   /* U+06B1 */
  0x0000,   /* U+06B2 */
  0x0000,   /* U+06B3 */
  0x0000,   /* U+06B4 */
  0x0000,   /* U+06B5 */
  0x0000,   /* U+06B6 */
  0x0000,   /* U+06B7 */
  0x0000,   /* U+06B8 */
  0x0000,   /* U+06B9 */
  0x0000,   /* U+06BA */
  0x0000,   /* U+06BB */
  0x0000,   /* U+06BC */
  0x0000,   /* U+06BD */
  0x0000,   /* U+06BE */
  0x0000,   /* U+06BF */
  0x0083,   /* U+06C0 */
  0x0000,   /* U+06C1 */
  0x0083,   /* U+06C2 */
  0x0000,   /* U+06C3 */
  0x0000,   /* U+06C4 */
  0x0000,   /* U+06C5 */
  0x0000,   /* U+06C6 */
  0x0000,   /* U+06C7 */
  0x0000,   /* U+06C8 */
  0x0000,   /* U+06C9 */
  0x0000,   /* U+06CA */
  0x0000,   /* U+06CB */
  0x0000,   /* U+06CC */
  0x0000,   /* U+06CD */
  0x0000,   /* U+06CE */
  0x0000,   /* U+06CF */
  0x0000,   /* U+06D0 */
  0x0000,   /* U+06D1 */
  0x0000,   /* U+06D2 */
  0x0083,   /* U+06D3 */
  0x0000,   /* U+06D4 */
  0x0000,   /* U+06D5 */
  0x0000,   /* U+06D6 */
  0x0000,   /* U+06D7 */
  0x0000,   /* U+06D8 */
  0x0000,   /* U+06D9 */
  0x0000,   /* U+06DA */
  0x0000,   /* U+06DB */
  0x0000,   /* U+06DC */
  0x0000,   /* U+06DD */
  0x0000,   /* U+06DE */
  0x0000,   /* U+06DF */
  0x0000,   /* U+06E0 */
  0x0000,   /* U+06E1 */
  0x0000,   /* U+06E2 */
  0x0000,   /* U+06E3 */
  0x0000,   /* U+06E4 */
  0x0000,   /* U+06E5 */
  0x0000,   /* U+06E6 */
  0x0000,   /* U+06E7 */
  0x0000,   /* U+06E8 */
  0x0000,   /* U+06E9 */
  0x0000,   /* U+06EA */
  0x0000,   /* U+06EB */
  0x0000,   /* U+06EC */
  0x0000,   /* U+06ED */
  0x0000,   /* U+06EE */
  0x0000,   /* U+06EF */
  0x0000,   /* U+06F0 */
  0x0000,   /* U+06F1 */
  0x0000,   /* U+06F2 */
  0x0000,   /* U+06F3 */
  0x0000,   /* U+06F4 */
  0x0000,   /* U+06F5 */
  0x0000,   /* U+06F6 */
  0x0000,   /* U+06F7 */
  0x0000,   /* U+06F8 */
  0x0000,   /* U+06F9 */
  0x0000,   /* U+06FA */
  0x0000,   /* U+06FB */
  0x0000,   /* U+06FC */
  0x0111,   /* U+06FD */
  0x0111,   /* U+06FE */
  0x0000,   /* U+06FF */

  /* Tertiary weight 2 for each character. */
  0x0000,   /* U+0600 */
  0x0000,   /* U+0601 */
  0x0000,   /* U+0602 */
  0x0000,   /* U+0603 */
  0x0000,   /* U+0604 */
  0x0000,   /* U+0605 */
  0x0000,   /* U+0606 */
  0x0000,   /* U+0607 */
  0x0000,   /* U+0608 */
  0x0000,   /* U+0609 */
  0x0000,   /* U+060A */
  0x0000,   /* U+060B */
  0x0000,   /* U+060C */
  0x0000,   /* U+060D */
  0x0000,   /* U+060E */
  0x0000,   /* U+060F */
  0x0000,   /* U+0610 */
  0x0000,   /* U+0611 */
  0x0000,   /* U+0612 */
  0x0000,   /* U+0613 */
  0x0000,   /* U+0614 */
  0x0000,   /* U+0615 */
  0x0000,   /* U+0616 */
  0x0000,   /* U+0617 */
  0x0000,   /* U+0618 */
  0x0000,   /* U+0619 */
  0x0000,   /* U+061A */
  0x0000,   /* U+061B */
  0x0000,   /* U+061C */
  0x0000,   /* U+061D */
  0x0000,   /* U+061E */
  0x0000,   /* U+061F */
  0x0000,   /* U+0620 */
  0x0000,   /* U+0621 */
  0x0000,   /* U+0622 */
  0x0000,   /* U+0623 */
  0x0000,   /* U+0624 */
  0x0000,   /* U+0625 */
  0x0000,   /* U+0626 */
  0x0000,   /* U+0627 */
  0x0000,   /* U+0628 */
  0x0000,   /* U+0629 */
  0x0000,   /* U+062A */
  0x0000,   /* U+062B */
  0x0000,   /* U+062C */
  0x0000,   /* U+062D */
  0x0000,   /* U+062E */
  0x0000,   /* U+062F */
  0x0000,   /* U+0630 */
  0x0000,   /* U+0631 */
  0x0000,   /* U+0632 */
  0x0000,   /* U+0633 */
  0x0000,   /* U+0634 */
  0x0000,   /* U+0635 */
  0x0000,   /* U+0636 */
  0x0000,   /* U+0637 */
  0x0000,   /* U+0638 */
  0x0000,   /* U+0639 */
  0x0000,   /* U+063A */
  0x0000,   /* U+063B */
  0x0000,   /* U+063C */
  0x0000,   /* U+063D */
  0x0000,   /* U+063E */
  0x0000,   /* U+063F */
  0x0000,   /* U+0640 */
  0x0000,   /* U+0641 */
  0x0000,   /* U+0642 */
  0x0000,   /* U+0643 */
  0x0000,   /* U+0644 */
  0x0000,   /* U+0645 */
  0x0000,   /* U+0646 */
  0x0000,   /* U+0647 */
  0x0000,   /* U+0648 */
  0x0000,   /* U+0649 */
  0x0000,   /* U+064A */
  0x0000,   /* U+064B */
  0x0000,   /* U+064C */
  0x0000,   /* U+064D */
  0x0000,   /* U+064E */
  0x0000,   /* U+064F */
  0x0000,   /* U+0650 */
  0x0000,   /* U+0651 */
  0x0000,   /* U+0652 */
  0x0000,   /* U+0653 */
  0x0000,   /* U+0654 */
  0x0000,   /* U+0655 */
  0x0000,   /* U+0656 */
  0x0000,   /* U+0657 */
  0x0000,   /* U+0658 */
  0x0000,   /* U+0659 */
  0x0000,   /* U+065A */
  0x0000,   /* U+065B */
  0x0000,   /* U+065C */
  0x0000,   /* U+065D */
  0x0000,   /* U+065E */
  0x0000,   /* U+065F */
  0x0000,   /* U+0660 */
  0x0000,   /* U+0661 */
  0x0000,   /* U+0662 */
  0x0000,   /* U+0663 */
  0x0000,   /* U+0664 */
  0x0000,   /* U+0665 */
  0x0000,   /* U+0666 */
  0x0000,   /* U+0667 */
  0x0000,   /* U+0668 */
  0x0000,   /* U+0669 */
  0x0000,   /* U+066A */
  0x0000,   /* U+066B */
  0x0000,   /* U+066C */
  0x0000,   /* U+066D */
  0x0000,   /* U+066E */
  0x0000,   /* U+066F */
  0x0000,   /* U+0670 */
  0x0000,   /* U+0671 */
  0x0000,   /* U+0672 */
  0x0000,   /* U+0673 */
  0x0000,   /* U+0674 */
  0x0004,   /* U+0675 */
  0x0004,   /* U+0676 */
  0x0004,   /* U+0677 */
  0x0004,   /* U+0678 */
  0x0000,   /* U+0679 */
  0x0000,   /* U+067A */
  0x0000,   /* U+067B */
  0x0000,   /* U+067C */
  0x0000,   /* U+067D */
  0x0000,   /* U+067E */
  0x0000,   /* U+067F */
  0x0000,   /* U+0680 */
  0x0000,   /* U+0681 */
  0x0000,   /* U+0682 */
  0x0000,   /* U+0683 */
  0x0000,   /* U+0684 */
  0x0000,   /* U+0685 */
  0x0000,   /* U+0686 */
  0x0000,   /* U+0687 */
  0x0000,   /* U+0688 */
  0x0000,   /* U+0689 */
  0x0000,   /* U+068A */
  0x0000,   /* U+068B */
  0x0000,   /* U+068C */
  0x0000,   /* U+068D */
  0x0000,   /* U+068E */
  0x0000,   /* U+068F */
  0x0000,   /* U+0690 */
  0x0000,   /* U+0691 */
  0x0000,   /* U+0692 */
  0x0000,   /* U+0693 */
  0x0000,   /* U+0694 */
  0x0000,   /* U+0695 */
  0x0000,   /* U+0696 */
  0x0000,   /* U+0697 */
  0x0000,   /* U+0698 */
  0x0000,   /* U+0699 */
  0x0000,   /* U+069A */
  0x0000,   /* U+069B */
  0x0000,   /* U+069C */
  0x0000,   /* U+069D */
  0x0000,   /* U+069E */
  0x0000,   /* U+069F */
  0x0000,   /* U+06A0 */
  0x0000,   /* U+06A1 */
  0x0000,   /* U+06A2 */
  0x0000,   /* U+06A3 */
  0x0000,   /* U+06A4 */
  0x0000,   /* U+06A5 */
  0x0000,   /* U+06A6 */
  0x0000,   /* U+06A7 */
  0x0000,   /* U+06A8 */
  0x0000,   /* U+06A9 */
  0x0000,   /* U+06AA */
  0x0000,   /* U+06AB */
  0x0000,   /* U+06AC */
  0x0000,   /* U+06AD */
  0x0000,   /* U+06AE */
  0x0000,   /* U+06AF */
  0x0000,   /* U+06B0 */
  0x0000,   /* U+06B1 */
  0x0000,   /* U+06B2 */
  0x0000,   /* U+06B3 */
  0x0000,   /* U+06B4 */
  0x0000,   /* U+06B5 */
  0x0000,   /* U+06B6 */
  0x0000,   /* U+06B7 */
  0x0000,   /* U+06B8 */
  0x0000,   /* U+06B9 */
  0x0000,   /* U+06BA */
  0x0000,   /* U+06BB */
  0x0000,   /* U+06BC */
  0x0000,   /* U+06BD */
  0x0000,   /* U+06BE */
  0x0000,   /* U+06BF */
  0x0002,   /* U+06C0 */
  0x0000,   /* U+06C1 */
  0x0002,   /* U+06C2 */
  0x0000,   /* U+06C3 */
  0x0000,   /* U+06C4 */
  0x0000,   /* U+06C5 */
  0x0000,   /* U+06C6 */
  0x0000,   /* U+06C7 */
  0x0000,   /* U+06C8 */
  0x0000,   /* U+06C9 */
  0x0000,   /* U+06CA */
  0x0000,   /* U+06CB */
  0x0000,   /* U+06CC */
  0x0000,   /* U+06CD */
  0x0000,   /* U+06CE */
  0x0000,   /* U+06CF */
  0x0000,   /* U+06D0 */
  0x0000,   /* U+06D1 */
  0x0000,   /* U+06D2 */
  0x0002,   /* U+06D3 */
  0x0000,   /* U+06D4 */
  0x0000,   /* U+06D5 */
  0x0000,   /* U+06D6 */
  0x0000,   /* U+06D7 */
  0x0000,   /* U+06D8 */
  0x0000,   /* U+06D9 */
  0x0000,   /* U+06DA */
  0x0000,   /* U+06DB */
  0x0000,   /* U+06DC */
  0x0000,   /* U+06DD */
  0x0000,   /* U+06DE */
  0x0000,   /* U+06DF */
  0x0000,   /* U+06E0 */
  0x0000,   /* U+06E1 */
  0x0000,   /* U+06E2 */
  0x0000,   /* U+06E3 */
  0x0000,   /* U+06E4 */
  0x0000,   /* U+06E5 */
  0x0000,   /* U+06E6 */
  0x0000,   /* U+06E7 */
  0x0000,   /* U+06E8 */
  0x0000,   /* U+06E9 */
  0x0000,   /* U+06EA */
  0x0000,   /* U+06EB */
  0x0000,   /* U+06EC */
  0x0000,   /* U+06ED */
  0x0000,   /* U+06EE */
  0x0000,   /* U+06EF */
  0x0000,   /* U+06F0 */
  0x0000,   /* U+06F1 */
  0x0000,   /* U+06F2 */
  0x0000,   /* U+06F3 */
  0x0000,   /* U+06F4 */
  0x0000,   /* U+06F5 */
  0x0000,   /* U+06F6 */
  0x0000,   /* U+06F7 */
  0x0000,   /* U+06F8 */
  0x0000,   /* U+06F9 */
  0x0000,   /* U+06FA */
  0x0000,   /* U+06FB */
  0x0000,   /* U+06FC */
  0x0004,   /* U+06FD */
  0x0004,   /* U+06FE */
  0x0000,   /* U+06FF */
};

uint16 uca900_p007[]= {
  /* Number of CEs for each character. */
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1,
  1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 2, 2, 2,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2,

  /* Primary weight 1 for each character. */
  0x02C4,   /* U+0700 */
  0x027A,   /* U+0701 */
  0x027B,   /* U+0702 */
  0x023C,   /* U+0703 */
  0x023D,   /* U+0704 */
  0x023E,   /* U+0705 */
  0x023F,   /* U+0706 */
  0x0240,   /* U+0707 */
  0x0241,   /* U+0708 */
  0x026B,   /* U+0709 */
  0x03D4,   /* U+070A */
  0x03D5,   /* U+070B */
  0x03D6,   /* U+070C */
  0x03D7,   /* U+070D */
  0xFBC0,   /* U+070E */
  0x0000,   /* U+070F */
  0x23D7,   /* U+0710 */
  0x0000,   /* U+0711 */
  0x23D8,   /* U+0712 */
  0x23D9,   /* U+0713 */
  0x23D9,   /* U+0714 */
  0x23DB,   /* U+0715 */
  0x23DA,   /* U+0716 */
  0x23DC,   /* U+0717 */
  0x23DD,   /* U+0718 */
  0x23DE,   /* U+0719 */
  0x23E0,   /* U+071A */
  0x23E1,   /* U+071B */
  0x23E1,   /* U+071C */
  0x23E2,   /* U+071D */
  0x23E3,   /* U+071E */
  0x23E4,   /* U+071F */
  0x23E6,   /* U+0720 */
  0x23E7,   /* U+0721 */
  0x23E8,   /* U+0722 */
  0x23E9,   /* U+0723 */
  0x23E9,   /* U+0724 */
  0x23EA,   /* U+0725 */
  0x23EB,   /* U+0726 */
  0x23EB,   /* U+0727 */
  0x23ED,   /* U+0728 */
  0x23EE,   /* U+0729 */
  0x23EF,   /* U+072A */
  0x23F0,   /* U+072B */
  0x23F1,   /* U+072C */
  0x23D8,   /* U+072D */
  0x23D9,   /* U+072E */
  0x23DB,   /* U+072F */
  0x0000,   /* U+0730 */
  0x0000,   /* U+0731 */
  0x0000,   /* U+0732 */
  0x0000,   /* U+0733 */
  0x0000,   /* U+0734 */
  0x0000,   /* U+0735 */
  0x0000,   /* U+0736 */
  0x0000,   /* U+0737 */
  0x0000,   /* U+0738 */
  0x0000,   /* U+0739 */
  0x0000,   /* U+073A */
  0x0000,   /* U+073B */
  0x0000,   /* U+073C */
  0x0000,   /* U+073D */
  0x0000,   /* U+073E */
  0x0000,   /* U+073F */
  0x0000,   /* U+0740 */
  0x0000,   /* U+0741 */
  0x0000,   /* U+0742 */
  0x0000,   /* U+0743 */
  0x0000,   /* U+0744 */
  0x0000,   /* U+0745 */
  0x0000,   /* U+0746 */
  0x0000,   /* U+0747 */
  0x0000,   /* U+0748 */
  0x0000,   /* U+0749 */
  0x0000,   /* U+074A */
  0xFBC0,   /* U+074B */
  0xFBC0,   /* U+074C */
  0x23DF,   /* U+074D */
  0x23E5,   /* U+074E */
  0x23EC,   /* U+074F */
  0x2311,   /* U+0750 */
  0x2312,   /* U+0751 */
  0x2313,   /* U+0752 */
  0x2314,   /* U+0753 */
  0x2315,   /* U+0754 */
  0x2316,   /* U+0755 */
  0x2318,   /* U+0756 */
  0x2331,   /* U+0757 */
  0x2332,   /* U+0758 */
  0x2344,   /* U+0759 */
  0x2345,   /* U+075A */
  0x2352,   /* U+075B */
  0x235F,   /* U+075C */
  0x2372,   /* U+075D */
  0x2373,   /* U+075E */
  0x2374,   /* U+075F */
  0x237F,   /* U+0760 */
  0x2380,   /* U+0761 */
  0x2397,   /* U+0762 */
  0x239A,   /* U+0763 */
  0x239B,   /* U+0764 */
  0x23A4,   /* U+0765 */
  0x23A5,   /* U+0766 */
  0x23AE,   /* U+0767 */
  0x23AF,   /* U+0768 */
  0x23B0,   /* U+0769 */
  0x23A1,   /* U+076A */
  0x2353,   /* U+076B */
  0x2354,   /* U+076C */
  0x2360,   /* U+076D */
  0x2333,   /* U+076E */
  0x2334,   /* U+076F */
  0x2361,   /* U+0770 */
  0x2355,   /* U+0771 */
  0x2335,   /* U+0772 */
  0x2305,   /* U+0773 */
  0x2306,   /* U+0774 */
  0x23D0,   /* U+0775 */
  0x23D1,   /* U+0776 */
  0x23D2,   /* U+0777 */
  0x23C2,   /* U+0778 */
  0x23C3,   /* U+0779 */
  0x23D5,   /* U+077A */
  0x23D6,   /* U+077B */
  0x2336,   /* U+077C */
  0x2362,   /* U+077D */
  0x2363,   /* U+077E */
  0x238C,   /* U+077F */
  0x240B,   /* U+0780 */
  0x240E,   /* U+0781 */
  0x240F,   /* U+0782 */
  0x2410,   /* U+0783 */
  0x2412,   /* U+0784 */
  0x2413,   /* U+0785 */
  0x2414,   /* U+0786 */
  0x2415,   /* U+0787 */
  0x2418,   /* U+0788 */
  0x241A,   /* U+0789 */
  0x241B,   /* U+078A */
  0x241C,   /* U+078B */
  0x241E,   /* U+078C */
  0x2422,   /* U+078D */
  0x2423,   /* U+078E */
  0x2425,   /* U+078F */
  0x2426,   /* U+0790 */
  0x242A,   /* U+0791 */
  0x242B,   /* U+0792 */
  0x242C,   /* U+0793 */
  0x242D,   /* U+0794 */
  0x242E,   /* U+0795 */
  0x242F,   /* U+0796 */
  0x2430,   /* U+0797 */
  0x241F,   /* U+0798 */
  0x240C,   /* U+0799 */
  0x240D,   /* U+079A */
  0x241D,   /* U+079B */
  0x2411,   /* U+079C */
  0x2427,   /* U+079D */
  0x2428,   /* U+079E */
  0x2429,   /* U+079F */
  0x2420,   /* U+07A0 */
  0x2421,   /* U+07A1 */
  0x2416,   /* U+07A2 */
  0x2417,   /* U+07A3 */
  0x2424,   /* U+07A4 */
  0x2419,   /* U+07A5 */
  0x2432,   /* U+07A6 */
  0x2433,   /* U+07A7 */
  0x2434,   /* U+07A8 */
  0x2435,   /* U+07A9 */
  0x2436,   /* U+07AA */
  0x2437,   /* U+07AB */
  0x2438,   /* U+07AC */
  0x2439,   /* U+07AD */
  0x243A,   /* U+07AE */
  0x243B,   /* U+07AF */
  0x243C,   /* U+07B0 */
  0x2431,   /* U+07B1 */
  0xFBC0,   /* U+07B2 */
  0xFBC0,   /* U+07B3 */
  0xFBC0,   /* U+07B4 */
  0xFBC0,   /* U+07B5 */
  0xFBC0,   /* U+07B6 */
  0xFBC0,   /* U+07B7 */
  0xFBC0,   /* U+07B8 */
  0xFBC0,   /* U+07B9 */
  0xFBC0,   /* U+07BA */
  0xFBC0,   /* U+07BB */
  0xFBC0,   /* U+07BC */
  0xFBC0,   /* U+07BD */
  0xFBC0,   /* U+07BE */
  0xFBC0,   /* U+07BF */
  0x1C3D,   /* U+07C0 */
  0x1C3E,   /* U+07C1 */
  0x1C3F,   /* U+07C2 */
  0x1C40,   /* U+07C3 */
  0x1C41,   /* U+07C4 */
  0x1C42,   /* U+07C5 */
  0x1C43,   /* U+07C6 */
  0x1C44,   /* U+07C7 */
  0x1C45,   /* U+07C8 */
  0x1C46,   /* U+07C9 */
  0x243D,   /* U+07CA */
  0x243E,   /* U+07CB */
  0x243F,   /* U+07CC */
  0x2440,   /* U+07CD */
  0x2441,   /* U+07CE */
  0x2442,   /* U+07CF */
  0x2443,   /* U+07D0 */
  0x2444,   /* U+07D1 */
  0x2445,   /* U+07D2 */
  0x2446,   /* U+07D3 */
  0x2447,   /* U+07D4 */
  0x2448,   /* U+07D5 */
  0x2449,   /* U+07D6 */
  0x244A,   /* U+07D7 */
  0x244B,   /* U+07D8 */
  0x244C,   /* U+07D9 */
  0x244D,   /* U+07DA */
  0x244E,   /* U+07DB */
  0x244F,   /* U+07DC */
  0x2450,   /* U+07DD */
  0x2451,   /* U+07DE */
  0x2452,   /* U+07DF */
  0x2453,   /* U+07E0 */
  0x2454,   /* U+07E1 */
  0x2455,   /* U+07E2 */
  0x2456,   /* U+07E3 */
  0x2457,   /* U+07E4 */
  0x2458,   /* U+07E5 */
  0x2459,   /* U+07E6 */
  0x245A,   /* U+07E7 */
  0x2449,   /* U+07E8 */
  0x244A,   /* U+07E9 */
  0x244C,   /* U+07EA */
  0x0000,   /* U+07EB */
  0x0000,   /* U+07EC */
  0x0000,   /* U+07ED */
  0x0000,   /* U+07EE */
  0x0000,   /* U+07EF */
  0x0000,   /* U+07F0 */
  0x0000,   /* U+07F1 */
  0x0000,   /* U+07F2 */
  0x0000,   /* U+07F3 */
  0x245B,   /* U+07F4 */
  0x245C,   /* U+07F5 */
  0x0512,   /* U+07F6 */
  0x02C5,   /* U+07F7 */
  0x022B,   /* U+07F8 */
  0x0263,   /* U+07F9 */
  0x0000,   /* U+07FA */
  0xFBC0,   /* U+07FB */
  0xFBC0,   /* U+07FC */
  0xFBC0,   /* U+07FD */
  0xFBC0,   /* U+07FE */
  0xFBC0,   /* U+07FF */

  /* Secondary weight 1 for each character. */
  0x0020,   /* U+0700 */
  0x0020,   /* U+0701 */
  0x0020,   /* U+0702 */
  0x0020,   /* U+0703 */
  0x0020,   /* U+0704 */
  0x0020,   /* U+0705 */
  0x0020,   /* U+0706 */
  0x0020,   /* U+0707 */
  0x0020,   /* U+0708 */
  0x0020,   /* U+0709 */
  0x0020,   /* U+070A */
  0x0020,   /* U+070B */
  0x0020,   /* U+070C */
  0x0020,   /* U+070D */
  0x0020,   /* U+070E */
  0x0000,   /* U+070F */
  0x0020,   /* U+0710 */
  0x0099,   /* U+0711 */
  0x0020,   /* U+0712 */
  0x0020,   /* U+0713 */
  0x0020,   /* U+0714 */
  0x0020,   /* U+0715 */
  0x0020,   /* U+0716 */
  0x0020,   /* U+0717 */
  0x0020,   /* U+0718 */
  0x0020,   /* U+0719 */
  0x0020,   /* U+071A */
  0x0020,   /* U+071B */
  0x0020,   /* U+071C */
  0x0020,   /* U+071D */
  0x0020,   /* U+071E */
  0x0020,   /* U+071F */
  0x0020,   /* U+0720 */
  0x0020,   /* U+0721 */
  0x0020,   /* U+0722 */
  0x0020,   /* U+0723 */
  0x0020,   /* U+0724 */
  0x0020,   /* U+0725 */
  0x0020,   /* U+0726 */
  0x0020,   /* U+0727 */
  0x0020,   /* U+0728 */
  0x0020,   /* U+0729 */
  0x0020,   /* U+072A */
  0x0020,   /* U+072B */
  0x0020,   /* U+072C */
  0x0020,   /* U+072D */
  0x0020,   /* U+072E */
  0x0020,   /* U+072F */
  0x009A,   /* U+0730 */
  0x009B,   /* U+0731 */
  0x009C,   /* U+0732 */
  0x009D,   /* U+0733 */
  0x009E,   /* U+0734 */
  0x009F,   /* U+0735 */
  0x00A0,   /* U+0736 */
  0x00A1,   /* U+0737 */
  0x00A2,   /* U+0738 */
  0x00A3,   /* U+0739 */
  0x00A4,   /* U+073A */
  0x00A5,   /* U+073B */
  0x00A6,   /* U+073C */
  0x00A7,   /* U+073D */
  0x00A8,   /* U+073E */
  0x00A9,   /* U+073F */
  0x0000,   /* U+0740 */
  0x0033,   /* U+0741 */
  0x0034,   /* U+0742 */
  0x0000,   /* U+0743 */
  0x0000,   /* U+0744 */
  0x0033,   /* U+0745 */
  0x0034,   /* U+0746 */
  0x0000,   /* U+0747 */
  0x0000,   /* U+0748 */
  0x0000,   /* U+0749 */
  0x0000,   /* U+074A */
  0x0020,   /* U+074B */
  0x0020,   /* U+074C */
  0x0020,   /* U+074D */
  0x0020,   /* U+074E */
  0x0020,   /* U+074F */
  0x0020,   /* U+0750 */
  0x0020,   /* U+0751 */
  0x0020,   /* U+0752 */
  0x0020,   /* U+0753 */
  0x0020,   /* U+0754 */
  0x0020,   /* U+0755 */
  0x0020,   /* U+0756 */
  0x0020,   /* U+0757 */
  0x0020,   /* U+0758 */
  0x0020,   /* U+0759 */
  0x0020,   /* U+075A */
  0x0020,   /* U+075B */
  0x0020,   /* U+075C */
  0x0020,   /* U+075D */
  0x0020,   /* U+075E */
  0x0020,   /* U+075F */
  0x0020,   /* U+0760 */
  0x0020,   /* U+0761 */
  0x0020,   /* U+0762 */
  0x0020,   /* U+0763 */
  0x0020,   /* U+0764 */
  0x0020,   /* U+0765 */
  0x0020,   /* U+0766 */
  0x0020,   /* U+0767 */
  0x0020,   /* U+0768 */
  0x0020,   /* U+0769 */
  0x0020,   /* U+076A */
  0x0020,   /* U+076B */
  0x0020,   /* U+076C */
  0x0020,   /* U+076D */
  0x0020,   /* U+076E */
  0x0020,   /* U+076F */
  0x0020,   /* U+0770 */
  0x0020,   /* U+0771 */
  0x0020,   /* U+0772 */
  0x0020,   /* U+0773 */
  0x0020,   /* U+0774 */
  0x0020,   /* U+0775 */
  0x0020,   /* U+0776 */
  0x0020,   /* U+0777 */
  0x0020,   /* U+0778 */
  0x0020,   /* U+0779 */
  0x0020,   /* U+077A */
  0x0020,   /* U+077B */
  0x0020,   /* U+077C */
  0x0020,   /* U+077D */
  0x0020,   /* U+077E */
  0x0020,   /* U+077F */
  0x0020,   /* U+0780 */
  0x0020,   /* U+0781 */
  0x0020,   /* U+0782 */
  0x0020,   /* U+0783 */
  0x0020,   /* U+0784 */
  0x0020,   /* U+0785 */
  0x0020,   /* U+0786 */
  0x0020,   /* U+0787 */
  0x0020,   /* U+0788 */
  0x0020,   /* U+0789 */
  0x0020,   /* U+078A */
  0x0020,   /* U+078B */
  0x0020,   /* U+078C */
  0x0020,   /* U+078D */
  0x0020,   /* U+078E */
  0x0020,   /* U+078F */
  0x0020,   /* U+0790 */
  0x0020,   /* U+0791 */
  0x0020,   /* U+0792 */
  0x0020,   /* U+0793 */
  0x0020,   /* U+0794 */
  0x0020,   /* U+0795 */
  0x0020,   /* U+0796 */
  0x0020,   /* U+0797 */
  0x0020,   /* U+0798 */
  0x0020,   /* U+0799 */
  0x0020,   /* U+079A */
  0x0020,   /* U+079B */
  0x0020,   /* U+079C */
  0x0020,   /* U+079D */
  0x0020,   /* U+079E */
  0x0020,   /* U+079F */
  0x0020,   /* U+07A0 */
  0x0020,   /* U+07A1 */
  0x0020,   /* U+07A2 */
  0x0020,   /* U+07A3 */
  0x0020,   /* U+07A4 */
  0x0020,   /* U+07A5 */
  0x0020,   /* U+07A6 */
  0x0020,   /* U+07A7 */
  0x0020,   /* U+07A8 */
  0x0020,   /* U+07A9 */
  0x0020,   /* U+07AA */
  0x0020,   /* U+07AB */
  0x0020,   /* U+07AC */
  0x0020,   /* U+07AD */
  0x0020,   /* U+07AE */
  0x0020,   /* U+07AF */
  0x0020,   /* U+07B0 */
  0x0020,   /* U+07B1 */
  0x0020,   /* U+07B2 */
  0x0020,   /* U+07B3 */
  0x0020,   /* U+07B4 */
  0x0020,   /* U+07B5 */
  0x0020,   /* U+07B6 */
  0x0020,   /* U+07B7 */
  0x0020,   /* U+07B8 */
  0x0020,   /* U+07B9 */
  0x0020,   /* U+07BA */
  0x0020,   /* U+07BB */
  0x0020,   /* U+07BC */
  0x0020,   /* U+07BD */
  0x0020,   /* U+07BE */
  0x0020,   /* U+07BF */
  0x0020,   /* U+07C0 */
  0x0020,   /* U+07C1 */
  0x0020,   /* U+07C2 */
  0x0020,   /* U+07C3 */
  0x0020,   /* U+07C4 */
  0x0020,   /* U+07C5 */
  0x0020,   /* U+07C6 */
  0x0020,   /* U+07C7 */
  0x0020,   /* U+07C8 */
  0x0020,   /* U+07C9 */
  0x0020,   /* U+07CA */
  0x0020,   /* U+07CB */
  0x0020,   /* U+07CC */
  0x0020,   /* U+07CD */
  0x0020,   /* U+07CE */
  0x0020,   /* U+07CF */
  0x0020,   /* U+07D0 */
  0x0020,   /* U+07D1 */
  0x0020,   /* U+07D2 */
  0x0020,   /* U+07D3 */
  0x0020,   /* U+07D4 */
  0x0020,   /* U+07D5 */
  0x0020,   /* U+07D6 */
  0x0020,   /* U+07D7 */
  0x0020,   /* U+07D8 */
  0x0020,   /* U+07D9 */
  0x0020,   /* U+07DA */
  0x0020,   /* U+07DB */
  0x0020,   /* U+07DC */
  0x0020,   /* U+07DD */
  0x0020,   /* U+07DE */
  0x0020,   /* U+07DF */
  0x0020,   /* U+07E0 */
  0x0020,   /* U+07E1 */
  0x0020,   /* U+07E2 */
  0x0020,   /* U+07E3 */
  0x0020,   /* U+07E4 */
  0x0020,   /* U+07E5 */
  0x0020,   /* U+07E6 */
  0x0020,   /* U+07E7 */
  0x0020,   /* U+07E8 */
  0x0020,   /* U+07E9 */
  0x0020,   /* U+07EA */
  0x00AA,   /* U+07EB */
  0x00AB,   /* U+07EC */
  0x00AC,   /* U+07ED */
  0x00AD,   /* U+07EE */
  0x00AE,   /* U+07EF */
  0x00AF,   /* U+07F0 */
  0x00B0,   /* U+07F1 */
  0x00B1,   /* U+07F2 */
  0x00B2,   /* U+07F3 */
  0x0020,   /* U+07F4 */
  0x0020,   /* U+07F5 */
  0x0020,   /* U+07F6 */
  0x0020,   /* U+07F7 */
  0x0020,   /* U+07F8 */
  0x0020,   /* U+07F9 */
  0x0000,   /* U+07FA */
  0x0020,   /* U+07FB */
  0x0020,   /* U+07FC */
  0x0020,   /* U+07FD */
  0x0020,   /* U+07FE */
  0x0020,   /* U+07FF */

  /* Tertiary weight 1 for each character. */
  0x0002,   /* U+0700 */
  0x0002,   /* U+0701 */
  0x0002,   /* U+0702 */
  0x0002,   /* U+0703 */
  0x0002,   /* U+0704 */
  0x0002,   /* U+0705 */
  0x0002,   /* U+0706 */
  0x0002,   /* U+0707 */
  0x0002,   /* U+0708 */
  0x0002,   /* U+0709 */
  0x0002,   /* U+070A */
  0x0002,   /* U+070B */
  0x0002,   /* U+070C */
  0x0002,   /* U+070D */
  0x0002,   /* U+070E */
  0x0000,   /* U+070F */
  0x0002,   /* U+0710 */
  0x0002,   /* U+0711 */
  0x0002,   /* U+0712 */
  0x0002,   /* U+0713 */
  0x0004,   /* U+0714 */
  0x0002,   /* U+0715 */
  0x0002,   /* U+0716 */
  0x0002,   /* U+0717 */
  0x0002,   /* U+0718 */
  0x0002,   /* U+0719 */
  0x0002,   /* U+071A */
  0x0002,   /* U+071B */
  0x0004,   /* U+071C */
  0x0002,   /* U+071D */
  0x0002,   /* U+071E */
  0x0002,   /* U+071F */
  0x0002,   /* U+0720 */
  0x0002,   /* U+0721 */
  0x0002,   /* U+0722 */
  0x0002,   /* U+0723 */
  0x0019,   /* U+0724 */
  0x0002,   /* U+0725 */
  0x0002,   /* U+0726 */
  0x0004,   /* U+0727 */
  0x0002,   /* U+0728 */
  0x0002,   /* U+0729 */
  0x0002,   /* U+072A */
  0x0002,   /* U+072B */
  0x0002,   /* U+072C */
  0x0004,   /* U+072D */
  0x0004,   /* U+072E */
  0x0004,   /* U+072F */
  0x0002,   /* U+0730 */
  0x0002,   /* U+0731 */
  0x0002,   /* U+0732 */
  0x0002,   /* U+0733 */
  0x0002,   /* U+0734 */
  0x0002,   /* U+0735 */
  0x0002,   /* U+0736 */
  0x0002,   /* U+0737 */
  0x0002,   /* U+0738 */
  0x0002,   /* U+0739 */
  0x0002,   /* U+073A */
  0x0002,   /* U+073B */
  0x0002,   /* U+073C */
  0x0002,   /* U+073D */
  0x0002,   /* U+073E */
  0x0002,   /* U+073F */
  0x0000,   /* U+0740 */
  0x0002,   /* U+0741 */
  0x0002,   /* U+0742 */
  0x0000,   /* U+0743 */
  0x0000,   /* U+0744 */
  0x0002,   /* U+0745 */
  0x0002,   /* U+0746 */
  0x0000,   /* U+0747 */
  0x0000,   /* U+0748 */
  0x0000,   /* U+0749 */
  0x0000,   /* U+074A */
  0x0002,   /* U+074B */
  0x0002,   /* U+074C */
  0x0002,   /* U+074D */
  0x0002,   /* U+074E */
  0x0002,   /* U+074F */
  0x0002,   /* U+0750 */
  0x0002,   /* U+0751 */
  0x0002,   /* U+0752 */
  0x0002,   /* U+0753 */
  0x0002,   /* U+0754 */
  0x0002,   /* U+0755 */
  0x0002,   /* U+0756 */
  0x0002,   /* U+0757 */
  0x0002,   /* U+0758 */
  0x0002,   /* U+0759 */
  0x0002,   /* U+075A */
  0x0002,   /* U+075B */
  0x0002,   /* U+075C */
  0x0002,   /* U+075D */
  0x0002,   /* U+075E */
  0x0002,   /* U+075F */
  0x0002,   /* U+0760 */
  0x0002,   /* U+0761 */
  0x0002,   /* U+0762 */
  0x0002,   /* U+0763 */
  0x0002,   /* U+0764 */
  0x0002,   /* U+0765 */
  0x0002,   /* U+0766 */
  0x0002,   /* U+0767 */
  0x0002,   /* U+0768 */
  0x0002,   /* U+0769 */
  0x0002,   /* U+076A */
  0x0002,   /* U+076B */
  0x0002,   /* U+076C */
  0x0002,   /* U+076D */
  0x0002,   /* U+076E */
  0x0002,   /* U+076F */
  0x0002,   /* U+0770 */
  0x0002,   /* U+0771 */
  0x0002,   /* U+0772 */
  0x0002,   /* U+0773 */
  0x0002,   /* U+0774 */
  0x0002,   /* U+0775 */
  0x0002,   /* U+0776 */
  0x0002,   /* U+0777 */
  0x0002,   /* U+0778 */
  0x0002,   /* U+0779 */
  0x0002,   /* U+077A */
  0x0002,   /* U+077B */
  0x0002,   /* U+077C */
  0x0002,   /* U+077D */
  0x0002,   /* U+077E */
  0x0002,   /* U+077F */
  0x0002,   /* U+0780 */
  0x0002,   /* U+0781 */
  0x0002,   /* U+0782 */
  0x0002,   /* U+0783 */
  0x0002,   /* U+0784 */
  0x0002,   /* U+0785 */
  0x0002,   /* U+0786 */
  0x0002,   /* U+0787 */
  0x0002,   /* U+0788 */
  0x0002,   /* U+0789 */
  0x0002,   /* U+078A */
  0x0002,   /* U+078B */
  0x0002,   /* U+078C */
  0x0002,   /* U+078D */
  0x0002,   /* U+078E */
  0x0002,   /* U+078F */
  0x0002,   /* U+0790 */
  0x0002,   /* U+0791 */
  0x0002,   /* U+0792 */
  0x0002,   /* U+0793 */
  0x0002,   /* U+0794 */
  0x0002,   /* U+0795 */
  0x0002,   /* U+0796 */
  0x0002,   /* U+0797 */
  0x0002,   /* U+0798 */
  0x0002,   /* U+0799 */
  0x0002,   /* U+079A */
  0x0002,   /* U+079B */
  0x0002,   /* U+079C */
  0x0002,   /* U+079D */
  0x0002,   /* U+079E */
  0x0002,   /* U+079F */
  0x0002,   /* U+07A0 */
  0x0002,   /* U+07A1 */
  0x0002,   /* U+07A2 */
  0x0002,   /* U+07A3 */
  0x0002,   /* U+07A4 */
  0x0002,   /* U+07A5 */
  0x0002,   /* U+07A6 */
  0x0002,   /* U+07A7 */
  0x0002,   /* U+07A8 */
  0x0002,   /* U+07A9 */
  0x0002,   /* U+07AA */
  0x0002,   /* U+07AB */
  0x0002,   /* U+07AC */
  0x0002,   /* U+07AD */
  0x0002,   /* U+07AE */
  0x0002,   /* U+07AF */
  0x0002,   /* U+07B0 */
  0x0002,   /* U+07B1 */
  0x0002,   /* U+07B2 */
  0x0002,   /* U+07B3 */
  0x0002,   /* U+07B4 */
  0x0002,   /* U+07B5 */
  0x0002,   /* U+07B6 */
  0x0002,   /* U+07B7 */
  0x0002,   /* U+07B8 */
  0x0002,   /* U+07B9 */
  0x0002,   /* U+07BA */
  0x0002,   /* U+07BB */
  0x0002,   /* U+07BC */
  0x0002,   /* U+07BD */
  0x0002,   /* U+07BE */
  0x0002,   /* U+07BF */
  0x0002,   /* U+07C0 */
  0x0002,   /* U+07C1 */
  0x0002,   /* U+07C2 */
  0x0002,   /* U+07C3 */
  0x0002,   /* U+07C4 */
  0x0002,   /* U+07C5 */
  0x0002,   /* U+07C6 */
  0x0002,   /* U+07C7 */
  0x0002,   /* U+07C8 */
  0x0002,   /* U+07C9 */
  0x0002,   /* U+07CA */
  0x0002,   /* U+07CB */
  0x0002,   /* U+07CC */
  0x0002,   /* U+07CD */
  0x0002,   /* U+07CE */
  0x0002,   /* U+07CF */
  0x0002,   /* U+07D0 */
  0x0002,   /* U+07D1 */
  0x0002,   /* U+07D2 */
  0x0002,   /* U+07D3 */
  0x0002,   /* U+07D4 */
  0x0002,   /* U+07D5 */
  0x0002,   /* U+07D6 */
  0x0002,   /* U+07D7 */
  0x0002,   /* U+07D8 */
  0x0002,   /* U+07D9 */
  0x0002,   /* U+07DA */
  0x0002,   /* U+07DB */
  0x0002,   /* U+07DC */
  0x0002,   /* U+07DD */
  0x0002,   /* U+07DE */
  0x0002,   /* U+07DF */
  0x0002,   /* U+07E0 */
  0x0002,   /* U+07E1 */
  0x0002,   /* U+07E2 */
  0x0002,   /* U+07E3 */
  0x0002,   /* U+07E4 */
  0x0002,   /* U+07E5 */
  0x0002,   /* U+07E6 */
  0x0002,   /* U+07E7 */
  0x0004,   /* U+07E8 */
  0x0004,   /* U+07E9 */
  0x0004,   /* U+07EA */
  0x0002,   /* U+07EB */
  0x0002,   /* U+07EC */
  0x0002,   /* U+07ED */
  0x0002,   /* U+07EE */
  0x0002,   /* U+07EF */
  0x0002,   /* U+07F0 */
  0x0002,   /* U+07F1 */
  0x0002,   /* U+07F2 */
  0x0002,   /* U+07F3 */
  0x0002,   /* U+07F4 */
  0x0002,   /* U+07F5 */
  0x0002,   /* U+07F6 */
  0x0002,   /* U+07F7 */
  0x0002,   /* U+07F8 */
  0x0002,   /* U+07F9 */
  0x0000,   /* U+07FA */
  0x0002,   /* U+07FB */
  0x0002,   /* U+07FC */
  0x0002,   /* U+07FD */
  0x0002,   /* U+07FE */
  0x0002,   /* U+07FF */

  /* Primary weight 2 for each character. */
  0x0000,   /* U+0700 */
  0x0000,   /* U+0701 */
  0x0000,   /* U+0702 */
  0x0000,   /* U+0703 */
  0x0000,   /* U+0704 */
  0x0000,   /* U+0705 */
  0x0000,   /* U+0706 */
  0x0000,   /* U+0707 */
  0x0000,   /* U+0708 */
  0x0000,   /* U+0709 */
  0x0000,   /* U+070A */
  0x0000,   /* U+070B */
  0x0000,   /* U+070C */
  0x0000,   /* U+070D */
  0x870E,   /* U+070E */
  0x0000,   /* U+070F */
  0x0000,   /* U+0710 */
  0x0000,   /* U+0711 */
  0x0000,   /* U+0712 */
  0x0000,   /* U+0713 */
  0x0000,   /* U+0714 */
  0x0000,   /* U+0715 */
  0x0000,   /* U+0716 */
  0x0000,   /* U+0717 */
  0x0000,   /* U+0718 */
  0x0000,   /* U+0719 */
  0x0000,   /* U+071A */
  0x0000,   /* U+071B */
  0x0000,   /* U+071C */
  0x0000,   /* U+071D */
  0x0000,   /* U+071E */
  0x0000,   /* U+071F */
  0x0000,   /* U+0720 */
  0x0000,   /* U+0721 */
  0x0000,   /* U+0722 */
  0x0000,   /* U+0723 */
  0x0000,   /* U+0724 */
  0x0000,   /* U+0725 */
  0x0000,   /* U+0726 */
  0x0000,   /* U+0727 */
  0x0000,   /* U+0728 */
  0x0000,   /* U+0729 */
  0x0000,   /* U+072A */
  0x0000,   /* U+072B */
  0x0000,   /* U+072C */
  0x0000,   /* U+072D */
  0x0000,   /* U+072E */
  0x0000,   /* U+072F */
  0x0000,   /* U+0730 */
  0x0000,   /* U+0731 */
  0x0000,   /* U+0732 */
  0x0000,   /* U+0733 */
  0x0000,   /* U+0734 */
  0x0000,   /* U+0735 */
  0x0000,   /* U+0736 */
  0x0000,   /* U+0737 */
  0x0000,   /* U+0738 */
  0x0000,   /* U+0739 */
  0x0000,   /* U+073A */
  0x0000,   /* U+073B */
  0x0000,   /* U+073C */
  0x0000,   /* U+073D */
  0x0000,   /* U+073E */
  0x0000,   /* U+073F */
  0x0000,   /* U+0740 */
  0x0000,   /* U+0741 */
  0x0000,   /* U+0742 */
  0x0000,   /* U+0743 */
  0x0000,   /* U+0744 */
  0x0000,   /* U+0745 */
  0x0000,   /* U+0746 */
  0x0000,   /* U+0747 */
  0x0000,   /* U+0748 */
  0x0000,   /* U+0749 */
  0x0000,   /* U+074A */
  0x874B,   /* U+074B */
  0x874C,   /* U+074C */
  0x0000,   /* U+074D */
  0x0000,   /* U+074E */
  0x0000,   /* U+074F */
  0x0000,   /* U+0750 */
  0x0000,   /* U+0751 */
  0x0000,   /* U+0752 */
  0x0000,   /* U+0753 */
  0x0000,   /* U+0754 */
  0x0000,   /* U+0755 */
  0x0000,   /* U+0756 */
  0x0000,   /* U+0757 */
  0x0000,   /* U+0758 */
  0x0000,   /* U+0759 */
  0x0000,   /* U+075A */
  0x0000,   /* U+075B */
  0x0000,   /* U+075C */
  0x0000,   /* U+075D */
  0x0000,   /* U+075E */
  0x0000,   /* U+075F */
  0x0000,   /* U+0760 */
  0x0000,   /* U+0761 */
  0x0000,   /* U+0762 */
  0x0000,   /* U+0763 */
  0x0000,   /* U+0764 */
  0x0000,   /* U+0765 */
  0x0000,   /* U+0766 */
  0x0000,   /* U+0767 */
  0x0000,   /* U+0768 */
  0x0000,   /* U+0769 */
  0x0000,   /* U+076A */
  0x0000,   /* U+076B */
  0x0000,   /* U+076C */
  0x0000,   /* U+076D */
  0x0000,   /* U+076E */
  0x0000,   /* U+076F */
  0x0000,   /* U+0770 */
  0x0000,   /* U+0771 */
  0x0000,   /* U+0772 */
  0x0000,   /* U+0773 */
  0x0000,   /* U+0774 */
  0x0000,   /* U+0775 */
  0x0000,   /* U+0776 */
  0x0000,   /* U+0777 */
  0x0000,   /* U+0778 */
  0x0000,   /* U+0779 */
  0x0000,   /* U+077A */
  0x0000,   /* U+077B */
  0x0000,   /* U+077C */
  0x0000,   /* U+077D */
  0x0000,   /* U+077E */
  0x0000,   /* U+077F */
  0x0000,   /* U+0780 */
  0x0000,   /* U+0781 */
  0x0000,   /* U+0782 */
  0x0000,   /* U+0783 */
  0x0000,   /* U+0784 */
  0x0000,   /* U+0785 */
  0x0000,   /* U+0786 */
  0x0000,   /* U+0787 */
  0x0000,   /* U+0788 */
  0x0000,   /* U+0789 */
  0x0000,   /* U+078A */
  0x0000,   /* U+078B */
  0x0000,   /* U+078C */
  0x0000,   /* U+078D */
  0x0000,   /* U+078E */
  0x0000,   /* U+078F */
  0x0000,   /* U+0790 */
  0x0000,   /* U+0791 */
  0x0000,   /* U+0792 */
  0x0000,   /* U+0793 */
  0x0000,   /* U+0794 */
  0x0000,   /* U+0795 */
  0x0000,   /* U+0796 */
  0x0000,   /* U+0797 */
  0x0000,   /* U+0798 */
  0x0000,   /* U+0799 */
  0x0000,   /* U+079A */
  0x0000,   /* U+079B */
  0x0000,   /* U+079C */
  0x0000,   /* U+079D */
  0x0000,   /* U+079E */
  0x0000,   /* U+079F */
  0x0000,   /* U+07A0 */
  0x0000,   /* U+07A1 */
  0x0000,   /* U+07A2 */
  0x0000,   /* U+07A3 */
  0x0000,   /* U+07A4 */
  0x0000,   /* U+07A5 */
  0x0000,   /* U+07A6 */
  0x0000,   /* U+07A7 */
  0x0000,   /* U+07A8 */
  0x0000,   /* U+07A9 */
  0x0000,   /* U+07AA */
  0x0000,   /* U+07AB */
  0x0000,   /* U+07AC */
  0x0000,   /* U+07AD */
  0x0000,   /* U+07AE */
  0x0000,   /* U+07AF */
  0x0000,   /* U+07B0 */
  0x0000,   /* U+07B1 */
  0x87B2,   /* U+07B2 */
  0x87B3,   /* U+07B3 */
  0x87B4,   /* U+07B4 */
  0x87B5,   /* U+07B5 */
  0x87B6,   /* U+07B6 */
  0x87B7,   /* U+07B7 */
  0x87B8,   /* U+07B8 */
  0x87B9,   /* U+07B9 */
  0x87BA,   /* U+07BA */
  0x87BB,   /* U+07BB */
  0x87BC,   /* U+07BC */
  0x87BD,   /* U+07BD */
  0x87BE,   /* U+07BE */
  0x87BF,   /* U+07BF */
  0x0000,   /* U+07C0 */
  0x0000,   /* U+07C1 */
  0x0000,   /* U+07C2 */
  0x0000,   /* U+07C3 */
  0x0000,   /* U+07C4 */
  0x0000,   /* U+07C5 */
  0x0000,   /* U+07C6 */
  0x0000,   /* U+07C7 */
  0x0000,   /* U+07C8 */
  0x0000,   /* U+07C9 */
  0x0000,   /* U+07CA */
  0x0000,   /* U+07CB */
  0x0000,   /* U+07CC */
  0x0000,   /* U+07CD */
  0x0000,   /* U+07CE */
  0x0000,   /* U+07CF */
  0x0000,   /* U+07D0 */
  0x0000,   /* U+07D1 */
  0x0000,   /* U+07D2 */
  0x0000,   /* U+07D3 */
  0x0000,   /* U+07D4 */
  0x0000,   /* U+07D5 */
  0x0000,   /* U+07D6 */
  0x0000,   /* U+07D7 */
  0x0000,   /* U+07D8 */
  0x0000,   /* U+07D9 */
  0x0000,   /* U+07DA */
  0x0000,   /* U+07DB */
  0x0000,   /* U+07DC */
  0x0000,   /* U+07DD */
  0x0000,   /* U+07DE */
  0x0000,   /* U+07DF */
  0x0000,   /* U+07E0 */
  0x0000,   /* U+07E1 */
  0x0000,   /* U+07E2 */
  0x0000,   /* U+07E3 */
  0x0000,   /* U+07E4 */
  0x0000,   /* U+07E5 */
  0x0000,   /* U+07E6 */
  0x0000,   /* U+07E7 */
  0x0000,   /* U+07E8 */
  0x0000,   /* U+07E9 */
  0x0000,   /* U+07EA */
  0x0000,   /* U+07EB */
  0x0000,   /* U+07EC */
  0x0000,   /* U+07ED */
  0x0000,   /* U+07EE */
  0x0000,   /* U+07EF */
  0x0000,   /* U+07F0 */
  0x0000,   /* U+07F1 */
  0x0000,   /* U+07F2 */
  0x0000,   /* U+07F3 */
  0x0000,   /* U+07F4 */
  0x0000,   /* U+07F5 */
  0x0000,   /* U+07F6 */
  0x0000,   /* U+07F7 */
  0x0000,   /* U+07F8 */
  0x0000,   /* U+07F9 */
  0x0000,   /* U+07FA */
  0x87FB,   /* U+07FB */
  0x87FC,   /* U+07FC */
  0x87FD,   /* U+07FD */
  0x87FE,   /* U+07FE */
  0x87FF,   /* U+07FF */

  /* Secondary weight 2 for each character. */
  0x0000,   /* U+0700 */
  0x0000,   /* U+0701 */
  0x0000,   /* U+0702 */
  0x0000,   /* U+0703 */
  0x0000,   /* U+0704 */
  0x0000,   /* U+0705 */
  0x0000,   /* U+0706 */
  0x0000,   /* U+0707 */
  0x0000,   /* U+0708 */
  0x0000,   /* U+0709 */
  0x0000,   /* U+070A */
  0x0000,   /* U+070B */
  0x0000,   /* U+070C */
  0x0000,   /* U+070D */
  0x0000,   /* U+070E */
  0x0000,   /* U+070F */
  0x0000,   /* U+0710 */
  0x0000,   /* U+0711 */
  0x0000,   /* U+0712 */
  0x0000,   /* U+0713 */
  0x0111,   /* U+0714 */
  0x0000,   /* U+0715 */
  0x0000,   /* U+0716 */
  0x0000,   /* U+0717 */
  0x0000,   /* U+0718 */
  0x0000,   /* U+0719 */
  0x0000,   /* U+071A */
  0x0000,   /* U+071B */
  0x0111,   /* U+071C */
  0x0000,   /* U+071D */
  0x0000,   /* U+071E */
  0x0000,   /* U+071F */
  0x0000,   /* U+0720 */
  0x0000,   /* U+0721 */
  0x0000,   /* U+0722 */
  0x0000,   /* U+0723 */
  0x0000,   /* U+0724 */
  0x0000,   /* U+0725 */
  0x0000,   /* U+0726 */
  0x0111,   /* U+0727 */
  0x0000,   /* U+0728 */
  0x0000,   /* U+0729 */
  0x0000,   /* U+072A */
  0x0000,   /* U+072B */
  0x0000,   /* U+072C */
  0x0112,   /* U+072D */
  0x0112,   /* U+072E */
  0x0112,   /* U+072F */
  0x0000,   /* U+0730 */
  0x0000,   /* U+0731 */
  0x0000,   /* U+0732 */
  0x0000,   /* U+0733 */
  0x0000,   /* U+0734 */
  0x0000,   /* U+0735 */
  0x0000,   /* U+0736 */
  0x0000,   /* U+0737 */
  0x0000,   /* U+0738 */
  0x0000,   /* U+0739 */
  0x0000,   /* U+073A */
  0x0000,   /* U+073B */
  0x0000,   /* U+073C */
  0x0000,   /* U+073D */
  0x0000,   /* U+073E */
  0x0000,   /* U+073F */
  0x0000,   /* U+0740 */
  0x0000,   /* U+0741 */
  0x0000,   /* U+0742 */
  0x0000,   /* U+0743 */
  0x0000,   /* U+0744 */
  0x0000,   /* U+0745 */
  0x0000,   /* U+0746 */
  0x0000,   /* U+0747 */
  0x0000,   /* U+0748 */
  0x0000,   /* U+0749 */
  0x0000,   /* U+074A */
  0x0000,   /* U+074B */
  0x0000,   /* U+074C */
  0x0000,   /* U+074D */
  0x0000,   /* U+074E */
  0x0000,   /* U+074F */
  0x0000,   /* U+0750 */
  0x0000,   /* U+0751 */
  0x0000,   /* U+0752 */
  0x0000,   /* U+0753 */
  0x0000,   /* U+0754 */
  0x0000,   /* U+0755 */
  0x0000,   /* U+0756 */
  0x0000,   /* U+0757 */
  0x0000,   /* U+0758 */
  0x0000,   /* U+0759 */
  0x0000,   /* U+075A */
  0x0000,   /* U+075B */
  0x0000,   /* U+075C */
  0x0000,   /* U+075D */
  0x0000,   /* U+075E */
  0x0000,   /* U+075F */
  0x0000,   /* U+0760 */
  0x0000,   /* U+0761 */
  0x0000,   /* U+0762 */
  0x0000,   /* U+0763 */
  0x0000,   /* U+0764 */
  0x0000,   /* U+0765 */
  0x0000,   /* U+0766 */
  0x0000,   /* U+0767 */
  0x0000,   /* U+0768 */
  0x0000,   /* U+0769 */
  0x0000,   /* U+076A */
  0x0000,   /* U+076B */
  0x0000,   /* U+076C */
  0x0000,   /* U+076D */
  0x0000,   /* U+076E */
  0x0000,   /* U+076F */
  0x0000,   /* U+0770 */
  0x0000,   /* U+0771 */
  0x0000,   /* U+0772 */
  0x0000,   /* U+0773 */
  0x0000,   /* U+0774 */
  0x0000,   /* U+0775 */
  0x0000,   /* U+0776 */
  0x0000,   /* U+0777 */
  0x0000,   /* U+0778 */
  0x0000,   /* U+0779 */
  0x0000,   /* U+077A */
  0x0000,   /* U+077B */
  0x0000,   /* U+077C */
  0x0000,   /* U+077D */
  0x0000,   /* U+077E */
  0x0000,   /* U+077F */
  0x0000,   /* U+0780 */
  0x0000,   /* U+0781 */
  0x0000,   /* U+0782 */
  0x0000,   /* U+0783 */
  0x0000,   /* U+0784 */
  0x0000,   /* U+0785 */
  0x0000,   /* U+0786 */
  0x0000,   /* U+0787 */
  0x0000,   /* U+0788 */
  0x0000,   /* U+0789 */
  0x0000,   /* U+078A */
  0x0000,   /* U+078B */
  0x0000,   /* U+078C */
  0x0000,   /* U+078D */
  0x0000,   /* U+078E */
  0x0000,   /* U+078F */
  0x0000,   /* U+0790 */
  0x0000,   /* U+0791 */
  0x0000,   /* U+0792 */
  0x0000,   /* U+0793 */
  0x0000,   /* U+0794 */
  0x0000,   /* U+0795 */
  0x0000,   /* U+0796 *