'use strict';

// This main script is used by --prof-process to process logs generated by --prof.
// The tick processor implementation is vendor-in from V8, placed in deps/v8/tools,
// and they have different resolution rules compared to normal Node.js internal builtins,
// despite being embedded into the binary as a built-in as well.

// TODO(joyeecheung): put the context locals in import.meta.
const {
  ObjectAssign,
  PromisePrototypeThen,
  globalThis,
} = primordials;

const {
  prepareMainThreadExecution,
  markBootstrapComplete,
} = require('internal/process/pre_execution');

const { importBuiltinSourceTextModule } = internalBinding('builtins');
const { triggerUncaughtException } = internalBinding('errors');

prepareMainThreadExecution();
markBootstrapComplete();

// Polyfill the context with globals needed by the tick processor.
const { globals, openFile } = require('internal/v8_prof_polyfill');
ObjectAssign(globalThis, globals);
openFile(process.argv[process.argv.length - 1]);

// Load and evaluate the V8 tick processor as a source text module.
const { promise } = importBuiltinSourceTextModule('internal/deps/v8/tools/tickprocessor-driver');
// We must catch the rejection asynchronously to print it out properly since
// the tick processor contains top level await.
PromisePrototypeThen(promise, undefined, (err) => {
  triggerUncaughtException(err, true /* fromPromise */);
});
