//
// nono
// Copyright (C) 2021 nono project
// Licensed under nono-license.txt
//

//
// 色構造体
//

#pragma once

#include "header.h"

//
// 自前の色構造体。
// メモリ上 { R, G, B, X } になる順。
// uint32 で読むと LE では 0xXXBBGGRR、BE では 0xRRGGBBXX と読める。
//
union Color
{
	uint32 u32 {};
	struct {
		uint8 r;
		uint8 g;
		uint8 b;
		uint8 x;
	};

	Color() { }
	Color(uint32 u32_) {
		u32 = u32_;
	}
	Color(int r_, int g_, int b_) {
		r = r_;
		g = g_;
		b = b_;
		x = 0;
	}
};
