//
// nono
// Copyright (C) 2020 nono project
// Licensed under nono-license.txt
//

//
// CRTC-II (HD6445)
//

#pragma once

#include "device.h"
#include "event.h"

class LunafbDevice;
class Renderer;

class CRTC2Device : public IODevice
{
	using inherited = IODevice;
 public:
	CRTC2Device();
	~CRTC2Device() override;

	bool Init() override;
	void ResetHard(bool poweron) override;

 protected:
	// BusIO インタフェース
	static const uint32 NPORT = 2;
	busdata ReadPort(uint32 offset);
	busdata WritePort(uint32 offset, uint32 data);
	busdata PeekPort(uint32 offset);
	bool PokePort(uint32 offset, uint32 data);

 private:
	// 垂直表示期間イベント
	void VDispCallback(Event& ev);

	// アドレスレジスタ
	uint ar {};

	// レジスタ
	uint8 reg[40] {};

	LunafbDevice *lunafb {};
	Renderer *renderer {};

	Event vdisp_event { this };
};
