//
// nono
// Copyright (C) 2021 nono project
// Licensed under nono-license.txt
//

//
// ABORT/INTERRUPT スイッチによる NMI 機構デバイス
//

#include "nmi.h"
#include "interrupt.h"
#include "mainapp.h"
#include "scheduler.h"

// コンストラクタ
NMIDevice::NMIDevice()
	: inherited(OBJ_NMI)
{
}

// デストラクタ
NMIDevice::~NMIDevice()
{
}

// 初期化
bool
NMIDevice::Init()
{
	interrupt = GetInterruptDevice();

	scheduler->ConnectMessage(MessageID::NMI, this,
		ToMessageCallback(&NMIDevice::AssertMessage));

	event.func = ToEventCallback(&NMIDevice::NegateCallback);
	event.time = 100_msec;
	event.SetName("NMI");
	scheduler->RegistEvent(event);

	return true;
}

// NMI ボタンを押す (GUI から呼ばれる)
void
NMIDevice::PressNMI()
{
	scheduler->SendMessage(MessageID::NMI);
}

// NMI 信号線をアサートする
void
NMIDevice::AssertNMI()
{
	interrupt->AssertINT(this);
}

// NMI 信号線をネゲートする
void
NMIDevice::NegateNMI()
{
	interrupt->NegateINT(this);
}

// NMI アサートのメッセージコールバック
void
NMIDevice::AssertMessage(MessageID msgid, uint32 arg)
{
	AssertNMI();

	if (gMainApp.Has(VMCap::LUNA)) {
		// LUNA(-I) は誰がいつどうネゲートしているのか分からないが
		// コードが能動的にネゲートしているようには見えないので、
		// とりあえず適当な時間経過後に自動的にネゲートしておいてみる。
		scheduler->RestartEvent(event);
	}
}

// NMI ネゲートのイベントコールバック
void
NMIDevice::NegateCallback(Event& ev)
{
	NegateNMI();
}
