//
// nono
// Copyright (C) 2021 nono project
// Licensed under nono-license.txt
//

//
// スレッドを持つデバイス
//

#pragma once

#include "device.h"
#include <mutex>
#include <thread>

class ThreadDevice : public Device
{
	using inherited = Device;
 public:
	enum class AffinityClass {
		Light,	// 処理の軽いスレッド
		Heavy,	// 処理の重いスレッド
	};

 public:
	explicit ThreadDevice(uint objid_);
	~ThreadDevice() override;

	// スレッド名を設定する
	void SetThreadName(const char *threadname_);

	// スレッドを開始する
	virtual bool StartThread();

	// スレッドに終了を要求し、その終了を待つ
	void TerminateThread();

 protected:
	// スレッドエントリポイント
	virtual void ThreadRun() = 0;

	// スレッドに終了を指示する
	virtual void Terminate() = 0;

	// このスレッドのアフィニティを示唆する
	void SetThreadAffinityHint(AffinityClass hint);

	std::unique_ptr<std::thread> thread {};

	// スレッド開始同期用
	std::mutex thread_starter {};

	// スレッド名
	const char *threadname {};
};
