//
// nono
// Copyright (C) 2022 nono project
// Licensed under nono-license.txt
//

//
// パレットモニターウィンドウ
//

#pragma once

#include "wxtextpanel.h"
#include "wxsubwindow.h"
#include "color.h"

class BT45xDevice;
class VideoCtlrDevice;

// パレットパネル
class WXPalettePanel : public WXTextPanel
{
	using inherited = WXTextPanel;
 public:
	explicit WXPalettePanel(wxWindow *parent);
	~WXPalettePanel() override;

	void FontChanged() override;
	void Draw() override;

 private:
	void PaletteChanged();
	void OnMouse(wxMouseEvent& event);
	void OnPaletteChanged(wxCommandEvent& event);

	// ホストパレット
	std::vector<Color> pal {};

	// ゲストパレットを uint32 形式にしたもの。
	// Bt454 なら $0000'0RGB、
	// Bt458 なら $00RR'GGBB、
	// X68030 なら $0000'WWWW (テキストパレット生データ)
	std::vector<uint32> ipal {};

	// パレット欄の行数
	int rows {};

	// パレット領域の開始オフセット [px]
	int pal0x {};
	int pal0y {};

	// 現在指しているパレット
	int cursor {};

	BT45xDevice *bt45x {};
	VideoCtlrDevice *videoctlr {};

	wxDECLARE_EVENT_TABLE();
};

// パレットウィンドウ
class WXPaletteWindow : public WXSubWindow
{
	using inherited = WXSubWindow;
 public:
	WXPaletteWindow(wxWindow *parent, const wxString& name);
	~WXPaletteWindow() override;
};
