//
// nono
// Copyright (C) 2021 nono project
// Licensed under nono-license.txt
//

//
// UI スレッドへのメッセージ機構 (GUI 側)
//

#include "wxuimessage.h"

// イベントタイプの定義
wxDEFINE_EVENT(NONO_EVT_UIMESSAGE, wxCommandEvent);

/*static*/
std::array<std::vector<wxEvtHandler *>, UIMessage::ID_MAX>
	WXUIMessage::dest_table;

// UIMessage を wxWidgets のイベントハンドラに接続する
/*static*/ void
WXUIMessage::Connect(UIMessage::ID id, wxEvtHandler *dest,
		wxObjectEventFunction function)
{
	dest->Connect(id, NONO_EVT_UIMESSAGE, function);
	dest_table[id].push_back(dest);
}

// イベントハンドラの接続を解除する
/*static*/ void
WXUIMessage::Disconnect(UIMessage::ID id, wxEvtHandler *dest,
		wxObjectEventFunction function)
{
	dest->Disconnect(NONO_EVT_UIMESSAGE, function);
	for (auto it = dest_table[id].begin(); it != dest_table[id].end(); ++it) {
		if (*it == dest) {
			dest_table[id].erase(it);
			break;
		}
	}
}

// UIMessage を処理する
/*static*/ void
WXUIMessage::Process(UIMessage::Queue& queue)
{
	UIMessage m;

	while (queue.Dequeue(&m)) {
		UIMessage::ID id = m.GetID();
		if (id >= UIMessage::ID_MAX) {
			PANIC("Invalid UIMessage %u", id);
		}
		for (auto dest : dest_table[id]) {
			wxCommandEvent ev(NONO_EVT_UIMESSAGE, id);
			ev.SetInt(m.GetArg());
			wxPostEvent(dest, ev);
		}
	}
}

// すべてのハンドラが解除されているかチェックする (開発用)
/*static*/ void
WXUIMessage::AssertAllDisconnected()
{
	for (int i = 0; i < dest_table.size(); i++) {
		if (dest_table[i].empty() == false) {
			warnx("UIMessage ID=%d not disconnected", i);
		}
	}
}
