//
// nono
// Copyright (C) 2020 nono project
// Licensed under nono-license.txt
//

//
// ホストネットワークの BPF ドライバ
//

#pragma once

#include "netdriver.h"
#include "hostnet.h"

class NetDriverBPF : public NetDriver
{
	using inherited = NetDriver;
 public:
	NetDriverBPF(HostDevice *hostdev_, const std::string& ifname_);
	~NetDriverBPF() override;

	bool InitDriver(bool startup) override;

	int Read(NetPacket *p) override;
	void Write(const void *buf, int buflen) override;

	void MonitorUpdateMD(TextScreen&, int y) override;

 private:
	void Close();

	std::string FindInterface() const;

	// デバイスファイルパス
	std::string devpath {};

	std::vector<uint8> bpfbuf {};
	uint8 *bpfptr {};
	ssize_t bpflen {};
};
