//
// nono
// Copyright (C) 2025 nono project
// Licensed under nono-license.txt
//

//
// GVRAM モニタ
//

#pragma once

#include "wxscreenmonitor.h"

class GVRAMDevice;
class VideoCtlrDevice;

// グラフィック画面パネル
class WXGVRAMPanel : public WXScreenPanel
{
	using inherited = WXScreenPanel;

 public:
	explicit WXGVRAMPanel(wxWindow *parent);
	~WXGVRAMPanel() override;

 private:
	void Draw() override;

	GVRAMDevice *gvram {};
	VideoCtlrDevice *videoctlr {};
};

// グラフィック画面ウィンドウ
class WXGVRAMWindow : public WXScreenWindow
{
	using inherited = WXScreenWindow;

 public:
	WXGVRAMWindow(wxWindow *parent, const wxString& name);
	~WXGVRAMWindow() override;

 private:
	void UpdateInfo(TextScreen&, int px, int py) override;

	GVRAMDevice *gvram {};
	VideoCtlrDevice *videoctlr {};

	// イベントテーブル
	wxDECLARE_EVENT_TABLE();
};
