//
// nono
// Copyright (C) 2020 nono project
// Licensed under nono-license.txt
//

#pragma once

#include "device.h"

class X68kIODevice;

class AreaSetDevice : public IODevice
{
	using inherited = IODevice;

	static const uint32 baseaddr = 0xe86000;

 public:
	AreaSetDevice();
	~AreaSetDevice() override;

	bool Init() override;
	void ResetHard(bool poweron) override;

 protected:
	// BusIO インタフェース
	static const uint32 NPORT = 1;
	busdata ReadPort(uint32 offset);
	busdata WritePort(uint32 offset, uint32 data);
	busdata PeekPort(uint32 offset);
	bool PokePort(uint32 offset, uint32 data);

 private:
	X68kIODevice *x68kio {};
};
