//
// nono
// Copyright (C) 2022 nono project
// Licensed under nono-license.txt
//

//
// NEWS のフレームバッファ(予定地)
//

#pragma once

#include "device.h"
#include "textscreen.h"

class NewsfbDevice : public Device
{
	using inherited = Device;
 public:
	NewsfbDevice();
	~NewsfbDevice() override;

	void ResetHard(bool poweron) override;

	void Putc(int ch);

 private:
	DECLARE_MONITOR_SCREEN(MonitorScreen);

	TextScreen console {};

	Monitor *monitor {};
};

static inline NewsfbDevice *GetNewsfbDevice() {
	return Object::GetObject<NewsfbDevice>(OBJ_NEWSFB);
}
