//
// nono
// Copyright (C) 2022 nono project
// Licensed under nono-license.txt
//

//
// NEWS の I/O 空間担当
//

#pragma once

#include "device.h"
#include "textscreen.h"
#include <array>

class NewsCtlrDevice;

class NewsIODevice : public IODevice
{
	using inherited = IODevice;
 public:
	NewsIODevice();
	~NewsIODevice() override;

	bool Init() override;

	busdata Read(busaddr addr) override;
	busdata Write(busaddr addr, uint32 data) override;
	busdata Peek1(uint32 addr) override;
	bool Poke1(uint32 addr, uint32 data) override;

 private:
	inline IODevice *SearchDevice(uint32 addr) const;

	void InitMonitor();
	DECLARE_MONITOR_SCREEN(MonitorScreen);

	std::unique_ptr<IODevice> pKBC {};
	std::unique_ptr<IODevice> pLance {};
	std::unique_ptr<IODevice> pRTC {};
	std::unique_ptr<IODevice> pSCC {};
	std::unique_ptr<IODevice> pSubRAM {};

	// デバイステーブル
	std::array<IODevice *, 64> table {};

	NewsCtlrDevice *newsctlr {};

	Monitor *monitor {};

	// 裏バッファ
	TextScreen src_screen {};
};

static inline NewsIODevice *GetNewsIODevice() {
	return Object::GetObject<NewsIODevice>(OBJ_NEWSIO);
}
