//
// nono
// Copyright (C) 2020 nono project
// Licensed under nono-license.txt
//

//
// X680x0 の各種 ROM
//

#pragma once

#include "rom.h"

class IPLROM1Device;

class IPLROM0Device : public IODevice
{
	using inherited = IODevice;
 public:
	IPLROM0Device();
	~IPLROM0Device() override;

	bool Init() override;
	void ResetHard(bool poweron) override;

	busdata Read(busaddr addr) override;
	busdata Peek1(uint32 addr) override;

 private:
	uint32 ReadDecoder(uint32 addr);

	IPLROM1Device *iplrom1 {};
};

class IPLROM1Device : public ROMDevice
{
	using inherited = ROMDevice;
 public:
	IPLROM1Device();
	~IPLROM1Device() override;

	bool Init() override;
};

class IPLROM2Device : public ROMDevice
{
	using inherited = ROMDevice;
 public:
	IPLROM2Device();
	~IPLROM2Device() override;

	bool Init() override;
};

class CGROMDevice : public ROMDevice
{
	using inherited = ROMDevice;
 public:
	CGROMDevice();
	~CGROMDevice() override;

	bool Init() override;
};

static inline CGROMDevice *GetCGROMDevice() {
	return Object::GetObject<CGROMDevice>(OBJ_CGROM);
}
static inline IPLROM0Device *GetIPLROM0Device() {
	return Object::GetObject<IPLROM0Device>(OBJ_IPLROM_BOOT);
}
static inline IPLROM1Device *GetIPLROM1Device() {
	return Object::GetObject<IPLROM1Device>(OBJ_IPLROM1);
}
static inline ROMDevice *GetIPLROM2Device() {
	return Object::GetObject<ROMDevice>(OBJ_IPLROM2);
}
