//
// nono
// Copyright (C) 2020 nono project
// Licensed under nono-license.txt
//

//
// システムポート
//

#pragma once

#include "device.h"

class CGROMDevice;
class IPLROM1Device;
class Keyboard;
class MainRAMDevice;
class NMIDevice;
class ROMDevice;
class SRAMDevice;
class VideoCtlrDevice;

struct SYSPORT
{
	static const uint CONTRAST	= 0;	// $E8E001
	static const uint SCOPE3D	= 1;	// $E8E003
	static const uint IMAGEUNIT	= 2;	// $E8E005
	static const uint KEY		= 3;	// $E8E007
	static const uint WAIT		= 4;	// $E8E009
	static const uint MPU		= 5;	// $E8E00B
	static const uint SRAMWP	= 6;	// $E8E00D
	static const uint POWEROFF	= 7;	// $E8E00F

	int rom_wait;	// システムポートへの書き込み値ではなく ROM への指示値。
	int ram_wait;	// システムポートへの書き込み値ではなく RAM への指示値。
	bool key_ctrl;
	uint pwoff_count;
};

class SysportDevice : public IODevice
{
	using inherited = IODevice;

	static const uint32 baseaddr = 0xe8e000;

 public:
	SysportDevice();
	~SysportDevice() override;

	bool Init() override;
	void ResetHard(bool poweron) override;

	// KEYCTRL の状態を取得する
	bool GetKeyCtrl() const {
		return sysport.key_ctrl;
	}

 protected:
	// BusIO インタフェース
	static const uint32 NPORT = 8;
	busdata ReadPort(uint32 offset);
	busdata WritePort(uint32 offset, uint32 data);
	busdata PeekPort(uint32 offset);
	bool PokePort(uint32 offset, uint32 data);

 private:
	DECLARE_MONITOR_SCREEN(MonitorScreen);

	struct SYSPORT sysport {};

	Monitor *monitor {};

	CGROMDevice *cgrom {};
	IPLROM1Device *iplrom1 {};
	ROMDevice *iplrom2 {};
	Keyboard *keyboard {};
	MainRAMDevice *mainram {};
	NMIDevice *nmi {};
	SRAMDevice *sram {};
	VideoCtlrDevice *videoctlr {};
};

static inline SysportDevice *GetSysportDevice() {
	return Object::GetObject<SysportDevice>(OBJ_SYSPORT);
}
