# Documentation

Ntopng documentation uses read the docs and `.rst` file format.

## Requirements

On ubuntu (this will install sphinx 8.x or newer):

````
apt-get install doxygen
pip install breathe sphinx sphinx-rtd-theme mock rst2pdf sphinxcontrib.swaggerdoc

````

Or to install sphinx 1.8.6

```
apt-get install doxygen
pip install breathe sphinx==1.8.6 sphinx-rtd-theme==0.4.3 mock rst2pdf sphinxcontrib.swaggerdoc
````

*Note*: newer sphinx versions (e.g. 1.8.0) have a bug with search: https://github.com/sphinx-doc/sphinx/issues/5460

## Build html doc

The ntopng documentation can be generated by executing:

```
make html
```

It can be easily tested locally by running a python webserver:

```
pushd _build/html; python3 -m http.server 8080; popd
```

## Build html doc with sphinx 8.x

When using sphinx 8.x, the conf.py needs to be patched:

- conf.py (doc/src/conf.py): 
  - replace line 303 from app.add_stylesheet to app.add_css_file (function changed the name);
  - change line 293 from `intersphinx_mapping = {'https://docs.python.org/': None}` to `intersphinx_mapping = {'python': ('https://docs.python.org/3', None)}`

## Build pdf doc

Requirements:

```
sudo apt-get install texlive-latex-recommended texlive-latex-extra texlive-fonts-recommended latexmk
```

Generate pdf:

```
make latexpdf
```

## Lua C API

The Lua C API documentation can be found inside the `api/lua_c` directory.

The functions documentation is written in `.lua` file (e.g. `api/lua_c/ntop/ntop_users.lua`).
These are the files to modify to update the API documentation.

Functions are organized in a directory structure in the form `api/lua_c/{object}/{api_group}.lua`,
where `{object}` is a C API reg (eg. `interface`) and `{api_group}` is a group of API functions
relevant to the same topic (e.g. `interface_hosts` is for API functions that work with hosts).

Only a subset of the functions defined in `src/LuaEngine.cpp` are documented as API.
They are marked with the `// ***API***` comment. Whenever an API function is modified,
the corresponding documentation file should be updated.

Here is how to perform some recurrent operations on the documentation:

  - Add/modify a function documentation: e.g. to update the `ntop.setCache` documentation,
    the file `api/lua_c/ntop/ntop_cache.lua` should be modified.

  - Add a new group of API functions for an existing C API reg: e.g. to group together all the
    host pools functions, the following modifications should be performed:
      - create `api/lua_c/interface/interface_host_pools.lua`.
      - create `api/lua_c/interface/interface_host_pools.rst`. Adapt this from an existing `.rst`.
      - edit `api/lua_c/interface/index.rst` and add `interface_host_pools` to the `toctree` section.

  - Add a new C API reg: e.g. to add a new `db` reg so that we can call `db.some_function` functions,
    it's necessary to:
      - create `api/lua_c/db/index.rst`. Adapt this from an existing `.rst`.
      - edit `api/lua_c/index.rst` and add `db/index` to the `toctree` section.

### Fixing API prefixes

Lua C API usually have a prefix which indicates the Lua table under which the API is present,
e.g. `ntop.isAdministrator` has the `ntop` prefix, whereas `interface.getid()` has the interface `interface`
prefix. In order to correctly show such prefix in the documentation its necessary to edit the `_static/css/ntop.css`
file and add a CSS `content` definition.
