/*
 *
 * (C) 2020-25 - ntop.org
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 */

#include "ntop_includes.h"

/* *************************************** */

ViewScoreStats::ViewScoreStats() : ScoreStats() {
  if(trace_new_delete) ntop->getTrace()->traceEvent(TRACE_NORMAL, "[new] %s", __FILE__);
  memset(&cli_dec, 0, sizeof(cli_dec)), memset(&srv_dec, 0, sizeof(srv_dec));
}

/* *************************************** */

/* For scores of the viewed hosts, the decrement is done on a separate counter
 * to avoid races. Necessary to lock as score decrements can be performed on the
 * same hosts in parallel by multiple threads */
u_int16_t ViewScoreStats::decValue(u_int16_t score,
                                   ScoreCategory score_category,
                                   bool as_client) {
  u_int16_t res = 0;

  m.lock(__FILE__, __LINE__);

  /* The decValue is actually an INCREMENT on the {cli,srv}_dec counter */

  res = as_client ? ScoreStats::incValue(cli_dec, score, score_category)
                  : ScoreStats::incValue(srv_dec, score, score_category);

  m.unlock(__FILE__, __LINE__);

  return res;
}
