/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.border;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.beans.ConstructorProperties;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;

public class LineBorder
extends AbstractBorder {
    private static Border blackLine;
    private static Border grayLine;
    protected int thickness;
    protected Color lineColor;
    protected boolean roundedCorners;

    public static Border createBlackLineBorder() {
        if (blackLine == null) {
            blackLine = new LineBorder(Color.black, 1);
        }
        return blackLine;
    }

    public static Border createGrayLineBorder() {
        if (grayLine == null) {
            grayLine = new LineBorder(Color.gray, 1);
        }
        return grayLine;
    }

    public LineBorder(Color color) {
        this(color, 1, false);
    }

    public LineBorder(Color color, int n) {
        this(color, n, false);
    }

    @ConstructorProperties(value={"lineColor", "thickness", "roundedCorners"})
    public LineBorder(Color color, int n, boolean bl) {
        this.lineColor = color;
        this.thickness = n;
        this.roundedCorners = bl;
    }

    @Override
    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        if (this.thickness > 0 && graphics instanceof Graphics2D) {
            RectangularShape rectangularShape;
            RectangularShape rectangularShape2;
            Graphics2D graphics2D = (Graphics2D)graphics;
            Color color = graphics2D.getColor();
            graphics2D.setColor(this.lineColor);
            int n5 = this.thickness;
            int n6 = n5 + n5;
            if (this.roundedCorners) {
                int n7 = n5 + n6;
                rectangularShape2 = new RoundRectangle2D.Float(n, n2, n3, n4, n7, n7);
                rectangularShape = new RoundRectangle2D.Float(n + n5, n2 + n5, n3 - n6, n4 - n6, n7, n7);
            } else {
                rectangularShape2 = new Rectangle2D.Float(n, n2, n3, n4);
                rectangularShape = new Rectangle2D.Float(n + n5, n2 + n5, n3 - n6, n4 - n6);
            }
            Path2D.Float float_ = new Path2D.Float(0);
            float_.append(rectangularShape2, false);
            float_.append(rectangularShape, false);
            graphics2D.fill(float_);
            graphics2D.setColor(color);
        }
    }

    @Override
    public Insets getBorderInsets(Component component, Insets insets) {
        insets.set(this.thickness, this.thickness, this.thickness, this.thickness);
        return insets;
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public int getThickness() {
        return this.thickness;
    }

    public boolean getRoundedCorners() {
        return this.roundedCorners;
    }

    @Override
    public boolean isBorderOpaque() {
        return !this.roundedCorners;
    }
}

