/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.asm.x86;

import sun.jvm.hotspot.asm.x86.X86XMMRegister;
import sun.jvm.hotspot.utilities.Assert;

public class X86XMMRegisters {
    public static final int NUM_XMM_REGISTERS = 8;
    public static final X86XMMRegister XMM0 = new X86XMMRegister(0, "%xmm0");
    public static final X86XMMRegister XMM1 = new X86XMMRegister(1, "%xmm1");
    public static final X86XMMRegister XMM2 = new X86XMMRegister(2, "%xmm2");
    public static final X86XMMRegister XMM3 = new X86XMMRegister(3, "%xmm3");
    public static final X86XMMRegister XMM4 = new X86XMMRegister(4, "%xmm4");
    public static final X86XMMRegister XMM5 = new X86XMMRegister(5, "%xmm5");
    public static final X86XMMRegister XMM6 = new X86XMMRegister(6, "%xmm6");
    public static final X86XMMRegister XMM7 = new X86XMMRegister(7, "%xmm7");
    private static X86XMMRegister[] xmmRegisters = new X86XMMRegister[]{XMM0, XMM1, XMM2, XMM3, XMM4, XMM5, XMM6, XMM7};

    public static int getNumberOfRegisters() {
        return 8;
    }

    public static String getRegisterName(int regNum) {
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(regNum > -1 && regNum < 8, "invalid XMM register number!");
        }
        return xmmRegisters[regNum].toString();
    }

    public static X86XMMRegister getRegister(int regNum) {
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(regNum > -1 && regNum < 8, "invalid XMM register number!");
        }
        return xmmRegisters[regNum];
    }
}

