/*****************************************************************************
 * Copyright (c) 2014-2025 OpenRCT2 developers
 *
 * For a complete list of all authors, please refer to contributors.md
 * Interested in contributing? Visit https://github.com/OpenRCT2/OpenRCT2
 *
 * OpenRCT2 is licensed under the GNU General Public License version 3.
 *****************************************************************************/

#pragma once

#include <openrct2/localisation/StringIdType.h>

namespace OpenRCT2
{
    enum : StringId
    {
        // General
        STR_ADJUST_LARGER_LAND_TIP = 2379,
        STR_ADJUST_SMALLER_LAND_TIP = 2378,
        STR_BROKEN = 3124,
        STR_BROWSE = 6705,
        STR_CANCEL = 972,
        STR_CANT_INCREASE_FURTHER = 3264,
        STR_CANT_REDUCE_FURTHER = 3265,
        STR_CHANGE_BASE_LAND_TIP = 2294,
        STR_CHANGE_VERTICAL_LAND_TIP = 2295,
        STR_CHAT = 5913,
        STR_CLEAR_BUTTON = 6766,
        STR_CLOSE_WINDOW_TIP = 828,
        STR_COMMA16 = 5919,
        STR_CONSOLE_HELPER_TEXT = 6623,
        STR_CURRENCY_FORMAT_LABEL = 3246,
        STR_COPY_INPUT_TO_CLIPBOARD = 6363,
        STR_COST_AMOUNT = 986,
        STR_COST_LABEL = 1408,
        STR_ENTER_NEW_VALUE = 6000,
        STR_ENTER_PARK_NAME = 1719,
        STR_ENTER_SELECTION_SIZE = 5129,
        STR_ERROR_INVALID_CHARACTERS = 5243,
        STR_FORMAT_COMMA2DP32 = 6704,
        STR_FORMAT_INTEGER = 5182,
        STR_GRAPH_LABEL = 2222,
        STR_LIGHTPINK_STRINGID = 5299,
        STR_ENTER_MAP_SIZE = 5131,
        STR_MAINTAIN_SQUARE_MAP_TOOLTIP = 6498,
        STR_MAP_TOOLTIP_BANNER_STRINGID_STRINGID = 6308,
        STR_MAP_TOOLTIP_STRINGID_CLICK_TO_MODIFY = 1163,
        STR_MAP_TOOLTIP_STRINGID_CLICK_TO_REMOVE = 1164,
        STR_MISSING_DIALOG_APPLICATION_ERROR = 6155,
        STR_OK = 973,
        STR_OPTIONS_DROPDOWN_ITEM = 2777,
        STR_OPTIONS_DROPDOWN_ITEM_SELECTED = 2778,
        STR_PICKUP_TIP = 1706,
        STR_POP16_COMMA16 = 3212,
        STR_RED_OUTLINED_STRING = 1192,
        STR_RED_STRINGID = 5298,
        STR_SAVE_PROMPT_CANCEL = 946,
        STR_SELECTION_SIZE = 5128,
        STR_STRING_DEFINED_TOOLTIP = 1812,
        STR_WINDOW_COLOUR_2_COMMA2DP32 = 3311,
        STR_WINDOW_COLOUR_2_COMMA32 = 3309,
        STR_WINDOW_TITLE_TIP = 829,
        STR_WHITE_STRING = 5139,

        // Colour dropdown tooltips
        STR_COLOUR_AQUAMARINE_TIP = 5526,
        STR_COLOUR_AQUA_DARK_TIP = 6569,
        STR_COLOUR_BLACK_TIP = 5516,
        STR_COLOUR_BORDEAUX_RED_DARK_TIP = 6554,
        STR_COLOUR_BORDEAUX_RED_LIGHT_TIP = 6555,
        STR_COLOUR_BORDEAUX_RED_TIP = 5542,
        STR_COLOUR_BRIGHT_GREEN_TIP = 5530,
        STR_COLOUR_BRIGHT_PINK_TIP = 5546,
        STR_COLOUR_BRIGHT_PURPLE_TIP = 5521,
        STR_COLOUR_BRIGHT_RED_TIP = 5544,
        STR_COLOUR_BRIGHT_YELLOW_TIP = 5533,
        STR_COLOUR_DARK_BLUE_TIP = 5522,
        STR_COLOUR_DARK_BROWN_TIP = 5540,
        STR_COLOUR_DARK_GREEN_TIP = 5528,
        STR_COLOUR_DARK_OLIVE_DARK_TIP = 6551,
        STR_COLOUR_DARK_OLIVE_GREEN_TIP = 5532,
        STR_COLOUR_DARK_OLIVE_LIGHT_TIP = 6552,
        STR_COLOUR_DARK_ORANGE_TIP = 5537,
        STR_COLOUR_DARK_PINK_TIP = 5545,
        STR_COLOUR_DARK_PURPLE_TIP = 5519,
        STR_COLOUR_DARK_YELLOW_TIP = 5535,
        STR_COLOUR_DULL_BROWN_DARK_TIP = 6571,
        STR_COLOUR_DULL_BROWN_LIGHT_TIP = 6572,
        STR_COLOUR_DULL_GREEN_DARK_TIP = 6564,
        STR_COLOUR_DULL_GREEN_LIGHT_TIP = 6565,
        STR_COLOUR_DULL_PURPLE_LIGHT_TIP = 6563,
        STR_COLOUR_GRASS_GREEN_DARK_TIP = 6556,
        STR_COLOUR_GRASS_GREEN_LIGHT_TIP = 6557,
        STR_COLOUR_GREY_TIP = 5517,
        STR_COLOUR_ICY_BLUE_TIP = 5524,
        STR_COLOUR_INVISIBLE_TIP = 6573,
        STR_COLOUR_LIGHT_BLUE_TIP = 5523,
        STR_COLOUR_LIGHT_BROWN_TIP = 5538,
        STR_COLOUR_LIGHT_ORANGE_TIP = 5536,
        STR_COLOUR_LIGHT_PINK_TIP = 5547,
        STR_COLOUR_LIGHT_PURPLE_TIP = 5520,
        STR_COLOUR_MAGENTA_LIGHT_TIP = 6570,
        STR_COLOUR_MOSS_GREEN_TIP = 5529,
        STR_COLOUR_OLIVE_DARK_TIP = 6558,
        STR_COLOUR_OLIVE_GREEN_TIP = 5531,
        STR_COLOUR_OLIVE_LIGHT_TIP = 6559,
        STR_COLOUR_ORANGE_LIGHT_TIP = 6568,
        STR_COLOUR_SALMON_PINK_TIP = 5541,
        STR_COLOUR_SATURATED_BROWN_LIGHT_TIP = 6553,
        STR_COLOUR_SATURATED_BROWN_TIP = 5539,
        STR_COLOUR_SATURATED_GREEN_LIGHT_TIP = 6560,
        STR_COLOUR_SATURATED_GREEN_TIP = 5527,
        STR_COLOUR_SATURATED_PURPLE_DARK_TIP = 6566,
        STR_COLOUR_SATURATED_PURPLE_LIGHT_TIP = 6567,
        STR_COLOUR_SATURATED_RED_TIP = 5543,
        STR_COLOUR_TAN_DARK_TIP = 6561,
        STR_COLOUR_TAN_LIGHT_TIP = 6562,
        STR_COLOUR_TEAL_TIP = 5525,
        STR_COLOUR_VOID_TIP = 6574,
        STR_COLOUR_WHITE_TIP = 5518,
        STR_COLOUR_YELLOW_TIP = 5534,

        // Shortcuts
        STR_SHORTCUT_ADJUST_LAND = 2511,
        STR_SHORTCUT_ADJUST_WATER = 2512,
        STR_SHORTCUT_ADVANCE_TO_NEXT_TICK = 6268,
        STR_SHORTCUT_ALT = 2543,
        STR_SHORTCUT_BACKSPACE = 2533,
        STR_SHORTCUT_BUILD_NEW_RIDE = 2515,
        STR_SHORTCUT_BUILD_PATHS = 2514,
        STR_SHORTCUT_BUILD_SCENERY = 2513,
        STR_SHORTCUT_CANCEL_CONSTRUCTION_MODE = 2495,
        STR_SHORTCUT_CAPSLOCK = 2671,
        STR_SHORTCUT_CLEAR = 2537,
        STR_SHORTCUT_CLEAR_SCENERY = 6134,
        STR_SHORTCUT_CLOSE_ALL_FLOATING_WINDOWS = 2494,
        STR_SHORTCUT_CLOSE_TOP_MOST_WINDOW = 2493,
        STR_SHORTCUT_CONSTRUCTION_BANK_LEFT = 6024,
        STR_SHORTCUT_CONSTRUCTION_BANK_RIGHT = 6025,
        STR_SHORTCUT_CONSTRUCTION_BUILD_CURRENT = 6028,
        STR_SHORTCUT_CONSTRUCTION_CHAIN_LIFT_TOGGLE = 6023,
        STR_SHORTCUT_CONSTRUCTION_DEMOLISH_CURRENT = 6029,
        STR_SHORTCUT_CONSTRUCTION_NEXT_TRACK = 6027,
        STR_SHORTCUT_CONSTRUCTION_PREVIOUS_TRACK = 6026,
        STR_SHORTCUT_CONSTRUCTION_SLOPE_DOWN = 6021,
        STR_SHORTCUT_CONSTRUCTION_SLOPE_UP = 6022,
        STR_SHORTCUT_CONSTRUCTION_TURN_LEFT = 6018,
        STR_SHORTCUT_CONSTRUCTION_TURN_RIGHT = 6019,
        STR_SHORTCUT_CONSTRUCTION_USE_TRACK_DEFAULT = 6020,
        STR_SHORTCUT_COPY_ELEMENT = 6336,
        STR_SHORTCUT_DEBUG_PAINT_TOGGLE = 5899,
        STR_SHORTCUT_DECREASE_ELEM_HEIGHT = 6346,
        STR_SHORTCUT_DECREASE_X_COORD = 6342,
        STR_SHORTCUT_DECREASE_Y_COORD = 6344,
        STR_SHORTCUT_DELETE = 2571,
        STR_SHORTCUT_DOWN = 2565,
        STR_SHORTCUT_END = 2560,
        STR_SHORTCUT_ESCAPE = 2552,
        STR_SHORTCUT_EXECUTE = 2568,
        STR_SHORTCUT_GIANT_SCREENSHOT = 6456,
        STR_SHORTCUT_GRIDLINES_DISPLAY_TOGGLE = 6161,
        STR_SHORTCUT_HEIGHT_MARKS_ON_LAND_TOGGLE = 2508,
        STR_SHORTCUT_HEIGHT_MARKS_ON_PATHS_TOGGLE = 2510,
        STR_SHORTCUT_HEIGHT_MARKS_ON_RIDE_TRACKS_TOGGLE = 2509,
        STR_SHORTCUT_HELP = 2572,
        STR_SHORTCUT_HIGHLIGHT_PATH_ISSUES_TOGGLE = 6234,
        STR_SHORTCUT_HOME = 2561,
        STR_SHORTCUT_INCREASE_ELEM_HEIGHT = 6345,
        STR_SHORTCUT_INCREASE_GAME_SPEED = 5450,
        STR_SHORTCUT_INCREASE_X_COORD = 6341,
        STR_SHORTCUT_INCREASE_Y_COORD = 6343,
        STR_SHORTCUT_INSERT = 2570,
        STR_SHORTCUT_INVISIBLE_SUPPORTS_TOGGLE = 2506,
        STR_SHORTCUT_JOY_DOWN = 6428,
        STR_SHORTCUT_JOY_LEFT = 6425,
        STR_SHORTCUT_JOY_NUMBER = 6429,
        STR_SHORTCUT_JOY_RIGHT = 6426,
        STR_SHORTCUT_JOY_UP = 6427,
        STR_SHORTCUT_LEFT = 2562,
        STR_SHORTCUT_MENU = 2618,
        STR_SHORTCUT_MOD_ALT = 6419,
        STR_SHORTCUT_MOD_CTRL = 6416,
        STR_SHORTCUT_MOD_GUI = 6422,
        STR_SHORTCUT_MOD_LALT = 6420,
        STR_SHORTCUT_MOD_LCTRL = 6417,
        STR_SHORTCUT_MOD_LGUI = 6423,
        STR_SHORTCUT_MOD_LSHIFT = 6414,
        STR_SHORTCUT_MOD_RALT = 6421,
        STR_SHORTCUT_MOD_RCTRL = 6418,
        STR_SHORTCUT_MOD_RGUI = 6424,
        STR_SHORTCUT_MOD_RSHIFT = 6415,
        STR_SHORTCUT_MOD_SHIFT = 6413,
        STR_SHORTCUT_MOUSE_LEFT = 6430,
        STR_SHORTCUT_MOUSE_NUMBER = 6432,
        STR_SHORTCUT_MOUSE_RIGHT = 6431,
        STR_SHORTCUT_MOVE_ELEMENT_DOWN = 6340,
        STR_SHORTCUT_MOVE_ELEMENT_UP = 6339,
        STR_SHORTCUT_MUTE_SOUND = 5804,
        STR_SHORTCUT_NUMLOCK = 2669,
        STR_SHORTCUT_NUMPAD_0 = 2621,
        STR_SHORTCUT_NUMPAD_1 = 2622,
        STR_SHORTCUT_NUMPAD_2 = 2623,
        STR_SHORTCUT_NUMPAD_3 = 2624,
        STR_SHORTCUT_NUMPAD_4 = 2625,
        STR_SHORTCUT_NUMPAD_5 = 2626,
        STR_SHORTCUT_NUMPAD_6 = 2627,
        STR_SHORTCUT_NUMPAD_7 = 2628,
        STR_SHORTCUT_NUMPAD_8 = 2629,
        STR_SHORTCUT_NUMPAD_9 = 2630,
        STR_SHORTCUT_NUMPAD_DIVIDE = 2636,
        STR_SHORTCUT_NUMPAD_MINUS = 2634,
        STR_SHORTCUT_NUMPAD_MULTIPLY = 2631,
        STR_SHORTCUT_NUMPAD_PERIOD = 2635,
        STR_SHORTCUT_NUMPAD_PLUS = 2632,
        STR_SHORTCUT_NUMPAD_RETURN = 6412,
        STR_SHORTCUT_OPEN_CHEATS_WINDOW = 5451,
        STR_SHORTCUT_OPEN_KEYBOARD_SHORTCUTS_WINDOW = 6582,
        STR_SHORTCUT_OPEN_SCENERY_PICKER = 6304,
        STR_SHORTCUT_OPEN_TILE_INSPECTOR = 6267,
        STR_SHORTCUT_OPEN_TRANSPARENCY_OPTIONS = 6483,
        STR_SHORTCUT_PASTE_ELEMENT = 6337,
        STR_SHORTCUT_PAUSE = 2544,
        STR_SHORTCUT_PAUSE_GAME = 2496,
        STR_SHORTCUT_PGDN = 2559,
        STR_SHORTCUT_PGUP = 2558,
        STR_SHORTCUT_PRINT = 2567,
        STR_SHORTCUT_REDUCE_GAME_SPEED = 5449,
        STR_SHORTCUT_REMOVE_BASE_LAND_TOGGLE = 2502,
        STR_SHORTCUT_REMOVE_ELEMENT = 6338,
        STR_SHORTCUT_REMOVE_VERTICAL_LAND_TOGGLE = 2503,
        STR_SHORTCUT_RETURN = 2538,
        STR_SHORTCUT_RIGHT = 2564,
        STR_SHORTCUT_ROTATE_CONSTRUCTION_OBJECT = 2500,
        STR_SHORTCUT_ROTATE_VIEW_ANTICLOCKWISE = 5460,
        STR_SHORTCUT_ROTATE_VIEW_CLOCKWISE = 2499,
        STR_SHORTCUT_SCALE_DOWN = 6334,
        STR_SHORTCUT_SCALE_UP = 6333,
        STR_SHORTCUT_SCREENSHOT = 2524,
        STR_SHORTCUT_SCROLL = 2670,
        STR_SHORTCUT_SCROLL_MAP_DOWN = 5471,
        STR_SHORTCUT_SCROLL_MAP_LEFT = 5470,
        STR_SHORTCUT_SCROLL_MAP_RIGHT = 5472,
        STR_SHORTCUT_SCROLL_MAP_UP = 5469,
        STR_SHORTCUT_SEE_THROUGH_GUESTS_TOGGLE = 6486,
        STR_SHORTCUT_SEE_THROUGH_PATHS_TOGGLE = 5912,
        STR_SHORTCUT_SEE_THROUGH_RIDES_TOGGLE = 2504,
        STR_SHORTCUT_SEE_THROUGH_SCENERY_TOGGLE = 2505,
        STR_SHORTCUT_SEE_THROUGH_STAFF_TOGGLE = 6487,
        STR_SHORTCUT_SEE_THROUGH_VEGETATION_TOGGLE = 6484,
        STR_SHORTCUT_SEE_THROUGH_VEHICLES_TOGGLE = 6485,
        STR_SHORTCUT_SELECT = 2566,
        STR_SHORTCUT_SEND_MESSAGE = 5493,
        STR_SHORTCUT_SHOW_FINANCIAL_INFORMATION = 2516,
        STR_SHORTCUT_SHOW_GUEST_LIST = 2520,
        STR_SHORTCUT_SHOW_MULTIPLAYER = 5812,
        STR_SHORTCUT_SHOW_OPTIONS = 5714,
        STR_SHORTCUT_SHOW_PARK_INFORMATION = 2519,
        STR_SHORTCUT_SHOW_RECENT_MESSAGES = 2522,
        STR_SHORTCUT_SHOW_RESEARCH_INFORMATION = 2517,
        STR_SHORTCUT_SHOW_RIDES_LIST = 2518,
        STR_SHORTCUT_SHOW_STAFF_LIST = 2521,
        STR_SHORTCUT_SNAPSHOT = 2569,
        STR_SHORTCUT_SORT_ELEMENTS = 6624,
        STR_SHORTCUT_SPACEBAR = 2557,
        STR_SHORTCUT_TAB = 2534,
        STR_SHORTCUT_TOGGLE_CLEARANCE_CHECKS = 6373,
        STR_SHORTCUT_TOGGLE_INVISIBILITY = 6439,
        STR_SHORTCUT_TOGGLE_VISIBILITY_OF_TOOLBARS = 5452,
        STR_SHORTCUT_TOGGLE_WALL_SLOPE = 6594,
        STR_SHORTCUT_UNDERGROUND_VIEW_TOGGLE = 2501,
        STR_SHORTCUT_UP = 2563,
        STR_SHORTCUT_VIEW_CLIPPING = 6233,
        STR_SHORTCUT_WINDOWED_MODE_TOGGLE = 5806,
        STR_SHORTCUT_ZOOM_VIEW_IN = 2498,
        STR_SHORTCUT_ZOOM_VIEW_OUT = 2497,
        STR_OR = 7000,

        // Widgets
        STR_CLOSE_X = 824,
        STR_CLOSE_X_WHITE = 6164,
        STR_DROPDOWN_BULLET_OPTION = 6795,
        STR_DROPDOWN_BULLET_OPTION_CHECKED = 6796, // Used as STR_DROPDOWN_BULLET_OPTION + 1
        STR_DROPDOWN_GLYPH = 876,
        STR_NUMERIC_DOWN = 1219,
        STR_NUMERIC_UP = 1218,
        STR_TOGGLE_OPTION = 1156,
        STR_TOGGLE_OPTION_CHECKED = 1157, // Used as STR_TOGGLE_OPTION + 1

        // Window: About.cpp
        STR_ABOUT = 847,
        STR_ABOUT_FAIRGROUND_ORGAN = 6588,
        STR_ABOUT_OPENRCT2_DESCRIPTION = 6137,
        STR_ABOUT_OPENRCT2_DESCRIPTION_2 = 6138,
        STR_ABOUT_OPENRCT2_DESCRIPTION_3 = 6139,
        STR_ABOUT_OPENRCT2_TITLE = 6587,
        STR_ABOUT_SPECIAL_THANKS_1 = 6540,
        STR_ABOUT_SPECIAL_THANKS_2 = 6541,
        STR_ADDITIONAL_SOUNDS_RECORDED_BY_DE = 854,
        STR_CHANGELOG_ELLIPSIS = 6140,
        STR_CONTRIBUTORS_WINDOW_BUTTON = 6543,
        STR_COPYRIGHT_CS = 850,
        STR_COPY_BUILD_HASH = 6453,
        STR_DESIGNED_AND_PROGRAMMED_BY_CS = 851,
        STR_GRAPHICS_BY_SF = 852,
        STR_JOIN_DISCORD = 6381,
        STR_LICENSED_TO_INFOGRAMES_INTERACTIVE_INC = 2861,
        STR_REPRESENTATION_BY_JL = 855,
        STR_SOUND_AND_MUSIC_BY_AB = 853,
        STR_THANKS_TO = 856,
        STR_THANKS_TO_PEOPLE = 857,

        // Window: AssetPacks
        STR_ASSET_PACKS = 6520,
        STR_BASE_GRAPHICS_MUSIC_SOUND = 6526,
        STR_DECREASE_PRIOTITY_TIP = 6523,
        STR_HIGH_PRIORITY = 6522,
        STR_INCREASE_PRIOTITY_TIP = 6524,
        STR_LOW_PRIORITY = 6521,
        STR_RELOAD_ASSET_PACKS_TIP = 6525,

        // Window: Banner
        STR_BANNER_TEXT = 2982,
        STR_BANNER_WINDOW_TITLE = 2985,
        STR_CHANGE_BANNER_TEXT_TIP = 2986,
        STR_DEMOLISH_BANNER_TIP = 2988,
        STR_ENTER_BANNER_TEXT = 2983,
        STR_SELECT_MAIN_SIGN_COLOUR_TIP = 2989,
        STR_SELECT_TEXT_COLOUR_TIP = 2990,
        STR_SET_AS_NO_ENTRY_BANNER_TIP = 2987,
        STR_TEXT_COLOUR_BABYBLUE = 3004,
        STR_TEXT_COLOUR_BLACK = 2996,
        STR_TEXT_COLOUR_CELADON = 3003,
        STR_TEXT_COLOUR_GREEN = 3000,
        STR_TEXT_COLOUR_GREY = 2997,
        STR_TEXT_COLOUR_LIGHTPINK = 3007,
        STR_TEXT_COLOUR_PALEGOLD = 3006,
        STR_TEXT_COLOUR_PALELAVENDER = 3005,
        STR_TEXT_COLOUR_PALESILVER = 3009,
        STR_TEXT_COLOUR_PEARLAQUA = 3008,
        STR_TEXT_COLOUR_RED = 2999,
        STR_TEXT_COLOUR_TOPAZ = 3002,
        STR_TEXT_COLOUR_WHITE = 2998,
        STR_TEXT_COLOUR_YELLOW = 3001,

        // Window: Changelog
        STR_CHANGELOG_TITLE = 5344,
        STR_CONTRIBUTORS_WINDOW = 6542,
        STR_NEW_RELEASE_DOWNLOAD_PAGE = 6383,
        STR_NEW_RELEASE_VERSION_INFO = 6382,

        // Window: Cheats
        STR_ADD_MONEY = 5998,
        STR_ADD_SET_MONEY = 5997,
        STR_CHANGE_WEATHER_TOOLTIP = 5726,
        STR_CHEAT_10_MINUTE_INSPECTIONS_TIP = 5560,
        STR_CHEAT_ALLOW_ARBITRARY_RIDE_TYPE_CHANGES_TIP = 5909,
        STR_CHEAT_ALLOW_PATH_AS_QUEUE_TIP = 6538,
        STR_CHEAT_ALLOW_SPECIAL_COLOUR_SCHEMES_TIP = 6576,
        STR_CHEAT_ALLOW_TRACK_PLACE_INVALID_HEIGHTS_TIP = 6370,
        STR_CHEAT_BUILD_IN_PAUSE_MODE_TIP = 5798,
        STR_CHEAT_CLOSE_PARK = 2770,
        STR_CHEAT_DISABLE_BRAKES_FAILURE_TIP = 5799,
        STR_CHEAT_DISABLE_BREAKDOWNS_TIP = 5800,
        STR_CHEAT_DISABLE_LITTERING_TIP = 5802,
        STR_CHEAT_DISABLE_PLANT_AGING_TIP = 5872,
        STR_CHEAT_DISABLE_RIDE_VALUE_AGING_TIP = 6102,
        STR_CHEAT_DISABLE_TRAIN_LENGTH_LIMIT_TIP = 5811,
        STR_CHEAT_DISABLE_VANDALISM_TIP = 5515,
        STR_CHEAT_ENABLE_ALL_DRAWABLE_TRACK_PIECES_TIP = 6147,
        STR_CHEAT_ENABLE_CHAIN_LIFT_ON_ALL_TRACK_TIP = 5874,
        STR_CHEAT_FIX_ALL_RIDES_TIP = 5792,
        STR_CHEAT_FREEZE_WEATHER_TIP = 5797,
        STR_CHEAT_GENERAL_GROUP = 5464,
        STR_CHEAT_GROUP_AVAILABILITY = 6217,
        STR_CHEAT_GROUP_CONSTRUCTION = 6215,
        STR_CHEAT_GROUP_OPERATION = 6216,
        STR_CHEAT_GUEST_ENERGY = 5353,
        STR_CHEAT_GUEST_HAPPINESS = 5352,
        STR_CHEAT_GUEST_HUNGER = 5354,
        STR_CHEAT_GUEST_NAUSEA = 5356,
        STR_CHEAT_GUEST_NAUSEA_TOLERANCE = 5357,
        STR_CHEAT_GUEST_PREFERRED_INTENSITY = 5362,
        STR_CHEAT_GUEST_THIRST = 5355,
        STR_CHEAT_GUEST_TOILET = 5358,
        STR_CHEAT_IGNORE_INTENSITY_TIP = 5795,
        STR_CHEAT_IGNORE_RESEARCH_STATUS_TIP = 6133,
        STR_CHEAT_LARGE_TRAM_GUESTS_TIP = 2684,
        STR_CHEAT_LESS_THAN_15 = 5364,
        STR_CHEAT_MAINTENANCE_GROUP = 6395,
        STR_CHEAT_MAKE_DESTRUCTABLE_TIP = 5794,
        STR_CHEAT_MORE_THAN_1 = 5363,
        STR_CHEAT_MOWED_GRASS = 2753,
        STR_CHEAT_NEVERENDING_MARKETING_TIP = 5741,
        STR_CHEAT_OBJECTIVE_GROUP = 6394,
        STR_CHEAT_OPEN_PARK_TIP = 5796,
        STR_CHEAT_REMOVE_PARK_FENCES_TIP = 6656,
        STR_CHEAT_OWN_ALL_LAND_TIP = 6121,
        STR_CHEAT_REMOVE_ALL_GUESTS_TIP = 5360,
        STR_CHEAT_RENEW_RIDES_TIP = 5791,
        STR_CHEAT_RESET_CRASH_STATUS_TIP = 5793,
        STR_CHEAT_STAFF_GROUP = 5466,
        STR_CHEAT_TITLE_DATE = 6663,
        STR_CHEAT_TITLE_FINANCIAL = 5345,
        STR_CHEAT_TITLE_GUEST = 5346,
        STR_CHEAT_TITLE_PARK = 5347,
        STR_CHEAT_TITLE_RIDE = 5348,
        STR_CHEAT_TITLE_STAFF = 6668,
        STR_CHEAT_TITLE_WEATHER = 6665,
        STR_CHEAT_UNLOCK_OPERATING_LIMITS_TIP = 5585,
        STR_CHEAT_WEATHER_GROUP = 5465,
        STR_CREATE_DUCKS = 6331,
        STR_CREATE_DUCKS_TIP = 6356,
        STR_DATE_CHEATS_TIP = 6664,
        STR_DATE_RESET = 6200,
        STR_DATE_SET = 6199,
        STR_DAY = 6198,
        STR_FAST = 5367,
        STR_FAUNA = 6667,
        STR_FINANCIAL_CHEATS_TIP = 5178,
        STR_FORMAT_MONTH = 6201,
        STR_FROZEN = 6232,
        STR_GUEST_CHEATS_TIP = 5179,
        STR_GUEST_BEHAVIOUR = 6670,
        STR_MAX = 5350,
        STR_MIN = 5351,
        STR_MONTH = 6197,
        STR_NORMAL = 5366,
        STR_PARK_CHEATS_TIP = 5180,
        STR_REMOVE_DUCKS = 6332,
        STR_REMOVE_DUCKS_TIP = 6357,
        STR_RIDE_CHEATS_TIP = 5181,
        STR_STAFF_CHEATS_TIP = 6669,
        STR_THIS_FEATURE_IS_CURRENTLY_UNSTABLE = 5563,
        STR_WARNING_IN_CAPS = 5562,
        STR_WEATHER_NATURE_CHEATS_TIP = 6666,
        STR_YEAR = 6196,
        STR_CHEAT_IGNORE_PRICE_TIP = 6660,

        // Window: Cheats -- weather
        STR_SUNNY = 5719,
        STR_PARTIALLY_CLOUDY = STR_SUNNY + 1,
        STR_CLOUDY = STR_SUNNY + 2,
        STR_RAIN = STR_SUNNY + 3,
        STR_HEAVY_RAIN = STR_SUNNY + 4,
        STR_THUNDERSTORM = STR_SUNNY + 5,
        STR_SNOW = 6384,
        STR_HEAVY_SNOW = 6385,
        STR_BLIZZARD = 6386,

        // Window: ClearScenery
        STR_CLEAR_SCENERY = 3439,
        STR_CLEAR_SCENERY_REMOVE_FOOTPATHS_TIP = 5274,
        STR_CLEAR_SCENERY_REMOVE_LARGE_SCENERY_TIP = 5273,
        STR_CLEAR_SCENERY_REMOVE_SMALL_SCENERY_TIP = 5272,

        // Window: CustomCurrency
        STR_CURRENCY_FORMAT = 5462,
        STR_CURRENCY_SYMBOL_TEXT = 5886,
        STR_CUSTOM_CURRENCY_EQUIVALENCY = 5885,
        STR_CUSTOM_CURRENCY_SYMBOL_INPUT_DESC = 5890,
        STR_CUSTOM_CURRENCY_SYMBOL_INPUT_TITLE = 5889,
        STR_CUSTOM_CURRENCY_WINDOW_TITLE = 5883,
        STR_PREFIX = 5887,
        STR_RATE = 5884,
        STR_RATE_INPUT_DESC = 5894,
        STR_RATE_INPUT_TITLE = 5893,
        STR_SUFFIX = 5888,

        // Window: DebugPaint
        STR_DEBUG_PAINT_SHOW_BLOCKED_TILES = 6260,
        STR_DEBUG_PAINT_SHOW_BOUND_BOXES = 5902,
        STR_DEBUG_PAINT_SHOW_DIRTY_VISUALS = 6144,
        STR_DEBUG_PAINT_SHOW_SEGMENT_HEIGHTS = 5901,
        STR_DEBUG_PAINT_SHOW_WIDE_PATHS = 6261,
        STR_DEBUG_PAINT_STABLE_SORT = 6710,
        STR_DEBUG_PAINT_FORCE_REDRAW = 7004,

        // Window: DemolishRidePrompt
        STR_DEMOLISH = 994,
        STR_DEMOLISH_RIDE = 993,
        STR_DEMOLISH_RIDE_ID = 995,
        STR_DEMOLISH_RIDE_ID_MONEY = 6250,

        // Window: EditorBottomToolbar
        STR_BACK_TO_PREVIOUS_STEP = 3209,
        STR_CANT_ADVANCE_TO_NEXT_EDITOR_STAGE = 3328,
        STR_EDITOR_STEP_INVENTIONS_LIST_SET_UP = 3203,
        STR_EDITOR_STEP_LANDSCAPE_EDITOR = 3202,
        STR_EDITOR_STEP_OBJECTIVE_SELECTION = 3205,
        STR_EDITOR_STEP_OBJECT_SELECTION = 3201,
        STR_EDITOR_STEP_OPTIONS_SELECTION = 3204,
        STR_EDITOR_STEP_ROLLERCOASTER_DESIGNER = 3207,
        STR_EDITOR_STEP_SAVE_SCENARIO = 3206,
        STR_EDITOR_STEP_SCENARIO_DETAILS = 6761,
        STR_EDITOR_STEP_TRACK_DESIGNS_MANAGER = 3208,
        STR_FORWARD_TO_NEXT_STEP = 3210,
        STR_UNABLE_TO_SAVE_SCENARIO_FILE = 3320,

        // Window: EditorInventionsList
        STR_INVENTION_LIST = 3195,
        STR_INVENTION_PREINVENTED_ITEMS = 3197,
        STR_INVENTION_RESEARCH_GROUP = 3196,
        STR_INVENTION_TO_BE_INVENTED_ITEMS = 3198,
        STR_MOVE_ALL_BOTTOM = 2751,
        STR_MOVE_ALL_TOP = 2750,
        STR_RANDOM_SHUFFLE = 3199,
        STR_RANDOM_SHUFFLE_TIP = 3200,
        STR_WINDOW_COLOUR_2_STRINGID_STRINGID = 6229,

        // Window: EditorObjectSelection
        STR_INCLUDES_X_OBJECTS = 3167,
        STR_INSTALL_NEW_TRACK_DESIGN = 3376,
        STR_INSTALL_NEW_TRACK_DESIGN_TIP = 3377,
        STR_MUSIC_OBJECT_TRACK_HEADER = 6449,
        STR_MUSIC_OBJECT_TRACK_LIST_ITEM = 6450,
        STR_MUSIC_OBJECT_TRACK_LIST_ITEM_WITH_COMPOSER = 6451,
        STR_NON_SELECTED_ONLY = 5881,
        STR_NOT_ALL_OBJECTS_IN_THIS_SCENERY_GROUP_COULD_BE_SELECTED = 3375,
        STR_OBJECTS_SORT_RIDE = 5448,
        STR_OBJECTS_SORT_TYPE = 5447,
        STR_OBJECT_FILTER = 5261,
        STR_OBJECT_FILTER_ALL_RIDES_TIP = 5349,
        STR_OBJECT_FILTER_TIP = 5265,
        STR_OBJECT_SEARCH_CLEAR = 5277,
        STR_OBJECT_SELECTION = 3181,
        STR_OBJECT_SELECTION_ADVANCED = 3364,
        STR_OBJECT_SELECTION_ADVANCED_TIP = 3365,
        STR_OBJECT_SELECTION_ALL_SOURCES_SHOWN = 6653,
        STR_OBJECT_SELECTION_COMPAT_OBJECT_DESCRIPTION = 6550,
        STR_OBJECT_SELECTION_ENTRANCE_BUILDINGS = 6792,
        STR_OBJECT_SELECTION_FALLBACK_IMAGES_WARNING = 6516,
        STR_OBJECT_SELECTION_GUESTS_AND_STAFF = 6793,
        STR_OBJECT_SELECTION_ONLY_STRINGID = 6655,
        STR_OBJECT_SELECTION_SCENERY_AND_THEMES = 6794,
        STR_OBJECT_SELECTION_SELECTION_SIZE = 3164,
        STR_OBJECT_SELECTION_SHOWING_N_SOURCES = 6654,
        STR_OBJECT_USES_FALLBACK_IMAGES = 6515,
        STR_RELOAD_OBJECT_TIP = 6613,
        STR_RIDE_OBJECT_SHOP_SELLS = 6452,
        STR_ROLLER_COASTER_DESIGNER_SELECT_RIDE_TYPES_VEHICLES = 3335,
        STR_SELECTED_ONLY = 5880,
        STR_TRACK_DESIGNS_MANAGER_SELECT_RIDE_TYPE = 3336,
        STR_UNABLE_TO_DE_SELECT_THIS_OBJECT = 3177,
        STR_UNABLE_TO_SELECT_THIS_OBJECT = 3176,
        STR_WARNING_TOO_MANY_OBJECTS_SELECTED = 3374,

        // Window: EditorScenarioOptions
        STR_CANT_INCREASE_CASH = 3248,
        STR_CANT_INCREASE_INIT_LOAN = 3250,
        STR_CANT_INCREASE_INTEREST_RATE = 3254,
        STR_CANT_INCREASE_MAX_LOAN = 3252,
        STR_CANT_REDUCE_CASH = 3249,
        STR_CANT_REDUCE_INIT_LOAN = 3251,
        STR_CANT_REDUCE_INTEREST_RATE = 3255,
        STR_CANT_REDUCE_MAX_LOAN = 3253,
        STR_CASH_PER_GUEST_LABEL = 3260,
        STR_CHANGE = 3294,
        STR_CHANGE_DETAIL_NOTES_ABOUT_PARK_SCENARIO_TIP = 3297,
        STR_CHANGE_NAME_OF_PARK_TIP = 3295,
        STR_CHANGE_NAME_OF_SCENARIO_TIP = 3296,
        STR_EARNINGS_LABEL = 6760,
        STR_ENTER_SCENARIO_DESCRIPTION = 3316,
        STR_ENTER_SCENARIO_NAME = 3314,
        STR_ENTRY_PRICE_LABEL = 3281,
        STR_FORBID_HIGH_CONSTRUCTION = 3271,
        STR_FORBID_HIGH_CONSTRUCTION_TIP = 3272,
        STR_FORBID_LANDSCAPE_CHANGES = 3269,
        STR_FORBID_LANDSCAPE_CHANGES_TIP = 3270,
        STR_FORBID_MARKETING = 3244,
        STR_FORBID_MARKETING_TIP = 3245,
        STR_FORBID_TREE_REMOVAL = 3267,
        STR_FORBID_TREE_REMOVAL_TIP = 3268,
        STR_FREE_PARK_ENTER = 3279,
        STR_GROUP_BUSINESS_MODEL = 6759,
        STR_GROUP_LOAN_OPTIONS = 6758,
        STR_GUEST_INIT_HAPPINESS = 3261,
        STR_GUEST_INIT_HUNGER = 3262,
        STR_GUEST_INIT_THIRST = 3263,
        STR_GUESTS_PREFER_INTENSITY_BALANCED = 6747,
        STR_GUESTS_PREFER_INTENSITY_LABEL = 6745,
        STR_GUESTS_PREFER_INTENSITY_LESS_INTENSE_RIDES = 6748,
        STR_GUESTS_PREFER_INTENSITY_MORE_INTENSE_RIDES = 6749,
        STR_GUESTS_PREFER_INTENSITY_NONE = 6746,
        STR_GUESTS_PREFER_INTENSITY_TIP = 6750,
        STR_HARD_GUEST_GENERATION = 3275,
        STR_HARD_GUEST_GENERATION_TIP = 3276,
        STR_HARD_PARK_RATING = 3273,
        STR_HARD_PARK_RATING_TIP = 3274,
        STR_INIT_CASH_LABEL = 3240,
        STR_INIT_LOAN_LABEL = 3241,
        STR_INTEREST_RATE_LABEL = 3243,
        STR_LAND_COST_LABEL = 3277,
        STR_MAKE_PARK_NO_MONEY_TIP = 3239,
        STR_MAX_LOAN_LABEL = 3242,
        STR_OBJECTIVE_DROPDOWN_NONE = 2397,
        STR_OBJECTIVE_DROPDOWN_BUILD_10_ROLLER_COASTERS = STR_OBJECTIVE_DROPDOWN_NONE + 5,
        STR_OBJECTIVE_DROPDOWN_BUILD_10_ROLLER_COASTERS_OF_A_GIVEN_LENGTH = STR_OBJECTIVE_DROPDOWN_NONE + 8,
        STR_OBJECTIVE_DROPDOWN_BUILD_THE_BEST_RIDE_YOU_CAN = STR_OBJECTIVE_DROPDOWN_NONE + 4,
        STR_OBJECTIVE_DROPDOWN_FINISH_BUILDING_5_ROLLER_COASTERS = STR_OBJECTIVE_DROPDOWN_NONE + 9,
        STR_OBJECTIVE_DROPDOWN_HAVE_FUN = STR_OBJECTIVE_DROPDOWN_NONE + 3,
        STR_OBJECTIVE_DROPDOWN_LABEL = 3287,
        STR_OBJECTIVE_DROPDOWN_MONTHLY_INCOME_FROM_RIDE_TICKETS = STR_OBJECTIVE_DROPDOWN_NONE + 7,
        STR_OBJECTIVE_DROPDOWN_MONTHLY_PROFIT_FROM_FOOD_MERCHANDISE = STR_OBJECTIVE_DROPDOWN_NONE + 11,
        STR_OBJECTIVE_DROPDOWN_NUMBER_OF_GUESTS_AT_A_GIVEN_DATE = STR_OBJECTIVE_DROPDOWN_NONE + 1,
        STR_OBJECTIVE_DROPDOWN_NUMBER_OF_GUESTS_IN_PARK = STR_OBJECTIVE_DROPDOWN_NONE + 6,
        STR_OBJECTIVE_DROPDOWN_PARK_VALUE_AT_A_GIVEN_DATE = STR_OBJECTIVE_DROPDOWN_NONE + 2,
        STR_OBJECTIVE_DROPDOWN_REPAY_LOAN_AND_ACHIEVE_A_GIVEN_PARK_VALUE = STR_OBJECTIVE_DROPDOWN_NONE + 10,
        STR_PAID_ENTRY_PAID_RIDES = 6153,
        STR_PARK_SCENARIO_DETAILS = 3315,
        STR_PAY_FOR_PARK_PAY_FOR_RIDES_TIP = 3266,
        STR_PAY_PARK_ENTER = 3280,
        STR_PERCENT_FORMAT_LABEL = 3247,
        STR_RCT1_INTEREST = 6545,
        STR_RCT1_INTEREST_TIP = 6546,
        STR_RIGHTS_COST_LABEL = 3278,
        STR_SCENARIO_NAME = 3313,
        STR_SCENARIO_OPTIONS_FINANCIAL = 3232,
        STR_SCENARIO_OPTIONS_FINANCIAL_TIP = 3235,
        STR_SCENARIO_OPTIONS_GUESTS = 3233,
        STR_SCENARIO_OPTIONS_GUESTS_TIP = 3236,
        STR_SCENARIO_OPTIONS_LAND_RESTRICTIONS = 6754,
        STR_SCENARIO_OPTIONS_LAND_RESTRICTIONS_TIP = 6757,
        STR_SCENARIO_OPTIONS_OBJECTIVE = 6752,
        STR_SCENARIO_OPTIONS_OBJECTIVE_TIP = 6755,
        STR_SCENARIO_OPTIONS_PRESERVED_RIDES = 3285,
        STR_SCENARIO_OPTIONS_PRESERVED_RIDES_TIP = 3285,
        STR_SCENARIO_OPTIONS_SCENARIO_DETAILS = 6753,
        STR_SCENARIO_OPTIONS_SCENARIO_DETAILS_TIP = 6756,
        STR_SELECT_OBJECTIVE_FOR_THIS_SCENARIO_TIP = 3286,
        STR_SELECT_WHICH_GROUP_THIS_SCENARIO_APPEARS_IN = 3318,
        STR_WINDOW_COLOUR_2_LENGTH = 3310,
        STR_WINDOW_OBJECTIVE_DATE = 3301,
        STR_WINDOW_OBJECTIVE_EXCITEMENT_RATING = 3308,
        STR_WINDOW_OBJECTIVE_GUEST_COUNT = 3303,
        STR_WINDOW_OBJECTIVE_MINIMUM_LENGTH = 3307,
        STR_WINDOW_OBJECTIVE_MONTHLY_INCOME = 3305,
        STR_WINDOW_OBJECTIVE_MONTHLY_PROFIT = 3306,
        STR_WINDOW_OBJECTIVE_PARK_VALUE = 3304,
        STR_WINDOW_OBJECTIVE_VALUE_DATE = 3302,
        STR_WINDOW_PARK_DETAILS = 3299,
        STR_WINDOW_PARK_NAME = 3298,
        STR_WINDOW_PRESERVATION_ORDER = 3312,
        STR_WINDOW_SCENARIO_GROUP = 3319,
        STR_WINDOW_SCENARIO_NAME = 3300,

        // Window: Finances
        STR_1_WEEK_REMAINING = 5484,
        STR_CASH_LABEL = 2224,
        STR_CASH_NEGATIVE_LABEL = 2225,
        STR_COMPANY_VALUE_LABEL = 2227,
        STR_FINANCES_FINANCIAL_GRAPH_CASH_LESS_LOAN_NEGATIVE = 2453,
        STR_FINANCES_FINANCIAL_GRAPH_CASH_LESS_LOAN_POSITIVE = 2452,
        STR_FINANCES_PARK_VALUE = 2787,
        STR_FINANCES_RESEARCH_TIP = 2275,
        STR_FINANCES_SHOW_CASH_TAB_TIP = 2458,
        STR_FINANCES_SHOW_MARKETING_TAB_TIP = 2461,
        STR_FINANCES_SHOW_PARK_VALUE_TAB_TIP = 2459,
        STR_FINANCES_SHOW_SUMMARY_TAB_TIP = 2457,
        STR_FINANCES_SHOW_WEEKLY_PROFIT_TAB_TIP = 2460,
        STR_FINANCES_SUMMARY_AT_X_PER_YEAR = 1911,
        STR_FINANCES_SUMMARY_EXPENDITURE_INCOME = 1896,
        STR_FINANCES_SUMMARY_EXPENDITURE_VALUE = 1914,
        STR_FINANCES_SUMMARY_FOOD_DRINK_SALES = 1905,
        STR_FINANCES_SUMMARY_FOOD_DRINK_STOCK = 1906,
        STR_FINANCES_SUMMARY_INCOME_VALUE = 1913,
        STR_FINANCES_SUMMARY_LANDSCAPING = 1900,
        STR_FINANCES_SUMMARY_LAND_PURCHASE = 1899,
        STR_FINANCES_SUMMARY_LOAN = 1916,
        STR_FINANCES_SUMMARY_LOAN_INTEREST = 1910,
        STR_FINANCES_SUMMARY_LOAN_VALUE = 1917,
        STR_FINANCES_SUMMARY_LOSS_VALUE = 1915,
        STR_FINANCES_SUMMARY_MARKETING = 1908,
        STR_FINANCES_SUMMARY_MONTH_HEADING = 1912,
        STR_FINANCES_SUMMARY_PARK_ENTRANCE_TICKETS = 1901,
        STR_FINANCES_SUMMARY_RESEARCH = 1909,
        STR_FINANCES_SUMMARY_RIDE_CONSTRUCTION = 1897,
        STR_FINANCES_SUMMARY_RIDE_RUNNING_COSTS = 1898,
        STR_FINANCES_SUMMARY_RIDE_TICKETS = 1902,
        STR_FINANCES_SUMMARY_SHOP_SALES = 1903,
        STR_FINANCES_SUMMARY_SHOP_STOCK = 1904,
        STR_FINANCES_SUMMARY_STAFF_WAGES = 1907,
        STR_FINANCES_WEEKLY_PROFIT_LOSS = 2484,
        STR_FINANCES_WEEKLY_PROFIT_POSITIVE = 2483,
        STR_FINANCIAL_GRAPH = 1950,
        STR_FINANCIAL_SUMMARY = 1949,
        STR_LAST_MONTH_PROFIT_FROM_FOOD_DRINK_MERCHANDISE_SALES_LABEL = 2228,
        STR_MARKETING = 1953,
        STR_MARKETING_CAMPAIGNS_AVAILABLE = 2411,
        STR_MARKETING_CAMPAIGNS_IN_OPERATION = 2409,
        STR_MARKETING_CAMPAIGNS_NONE = 2410,
        STR_MARKETING_PER_WEEK = 2413,
        STR_PARK_VALUE_GRAPH = 1951,
        STR_PARK_VALUE_LABEL = 2226,
        STR_PROFIT_GRAPH = 1952,
        STR_START_THIS_MARKETING_CAMPAIGN = 2412,
        STR_X_WEEKS_REMAINING = 5483,

        // Window: Footpath
        STR_BUILD_THIS = 1407,
        STR_CONSTRUCT_BRIDGE_OR_TUNNEL_FOOTPATH_TIP = 1656,
        STR_CONSTRUCT_FOOTPATH_ON_LAND_TIP = 1655,
        STR_CONSTRUCT_THE_SELECTED_FOOTPATH_SECTION_TIP = 1189,
        STR_DIRECTION = 1183,
        STR_DIRECTION_TIP = 1185,
        STR_DRAG_AREA_OF_FOOTPATH_TIP = 7005,
        STR_FOOTPATHS = 1181,
        STR_FOOTPATH_TIP = 1424,
        STR_LEVEL_TIP = 1187,
        STR_QUEUE_LINE_PATH_TIP = 1423,
        STR_REMOVE_PREVIOUS_FOOTPATH_SECTION_TIP = 1190,
        STR_SLOPE = 1184,
        STR_SLOPE_DOWN_TIP = 1186,
        STR_SLOPE_UP_TIP = 1188,
        STR_TYPE = 1182,

        // Window: GameBottomToolbar
        STR_BOTTOM_TOOLBAR_CASH = 1390,
        STR_BOTTOM_TOOLBAR_CASH_NEGATIVE = 1391,
        STR_BOTTOM_TOOLBAR_NEWS_TEXT = 5485,
        STR_BOTTOM_TOOLBAR_NUM_GUESTS_DECREASE = 1847,
        STR_BOTTOM_TOOLBAR_NUM_GUESTS_DECREASE_SINGULAR = 6194,
        STR_BOTTOM_TOOLBAR_NUM_GUESTS_INCREASE = 1848,
        STR_BOTTOM_TOOLBAR_NUM_GUESTS_INCREASE_SINGULAR = 6195,
        STR_BOTTOM_TOOLBAR_NUM_GUESTS_STABLE = 1846,
        STR_BOTTOM_TOOLBAR_NUM_GUESTS_STABLE_SINGULAR = 6193,
        STR_CELSIUS_VALUE = 2216,
        STR_FAHRENHEIT_VALUE = 2217,
        STR_PARK_RATING_TIP = 2221,
        STR_PROFIT_PER_WEEK_AND_PARK_VALUE_TIP = 2482,
        STR_SHOW_SUBJECT_TIP = 1937,
        STR_FOLLOW_SUBJECT_TIP = 6458,

        // Window: Guest
        STR_CARRYING = 1810,
        STR_FAVOURITE_RIDE = 3093,
        STR_GUEST_EXPENSES_DRINK = 2301,
        STR_GUEST_EXPENSES_DRINK_PLURAL = 2302,
        STR_GUEST_EXPENSES_ENTRANCE_FEE = 2296,
        STR_GUEST_EXPENSES_FOOD = 2299,
        STR_GUEST_EXPENSES_FOOD_PLURAL = 2300,
        STR_GUEST_EXPENSES_RIDE = 2297,
        STR_GUEST_EXPENSES_RIDE_PLURAL = 2298,
        STR_GUEST_EXPENSES_SOUVENIR = 2303,
        STR_GUEST_EXPENSES_SOUVENIR_PLURAL = 2304,
        STR_GUEST_LABEL_RIDES_BEEN_ON = 2292,
        STR_GUEST_RECENT_THOUGHTS_LABEL = 1654,
        STR_GUEST_RENAME_PROMPT = 1453,
        STR_GUEST_RENAME_TITLE = 1452,
        STR_GUEST_STAT_CASH_IN_POCKET = 1457,
        STR_GUEST_STAT_CASH_SPENT = 1456,
        STR_GUEST_STAT_ENERGY_LABEL = 1664,
        STR_GUEST_STAT_HAPPINESS_LABEL = 1662,
        STR_GUEST_STAT_HUNGER_LABEL = 1665,
        STR_GUEST_STAT_NAUSEA_LABEL = 1663,
        STR_GUEST_STAT_NAUSEA_TOLERANCE = 1661,
        STR_GUEST_STAT_PREFERRED_INTESITY_ABOVE = 1660,
        STR_GUEST_STAT_PREFERRED_INTESITY_BELOW = 1658,
        STR_GUEST_STAT_PREFERRED_INTESITY_BETWEEN = 1659,
        STR_GUEST_STAT_PREFERRED_RIDE = 1657,
        STR_GUEST_STAT_THIRST_LABEL = 1666,
        STR_GUEST_STAT_TIME_IN_PARK = 1458,
        STR_GUEST_STAT_TOILET_LABEL = 1667,
        STR_NAME_GUEST_TIP = 1055,
        STR_NOTHING = 2293,
        STR_PEEP_DEBUG_DEST = 6314,
        STR_PEEP_DEBUG_NEXT = 6311,
        STR_PEEP_DEBUG_NEXT_SLOPE = 6313,
        STR_PEEP_DEBUG_NEXT_SURFACE = 6312,
        STR_PEEP_DEBUG_PATHFIND_GOAL = 6315,
        STR_PEEP_DEBUG_PATHFIND_HISTORY = 6316,
        STR_PEEP_DEBUG_PATHFIND_HISTORY_ITEM = 6317,
        STR_PEEP_DEBUG_POSITION = 6310,
        STR_PEEP_DEBUG_SPRITE_INDEX = 6322,
        STR_PEEP_FAVOURITE_RIDE_NOT_AVAILABLE = 3094,
        STR_PEEP_INVENTORY_VOUCHER_FOOD_OR_DRINK_FREE = 2421,
        STR_PEEP_INVENTORY_VOUCHER_PARK_ENTRY_FREE = 2418,
        STR_PEEP_INVENTORY_VOUCHER_PARK_ENTRY_HALF_PRICE = 2420,
        STR_PEEP_INVENTORY_VOUCHER_RIDE_FREE = 2419,
        STR_PEEP_STAT_NAUSEA_TOLERANCE_AVERAGE = 2370,
        STR_PEEP_STAT_NAUSEA_TOLERANCE_HIGH = 2371,
        STR_PEEP_STAT_NAUSEA_TOLERANCE_LOW = 2369,
        STR_PEEP_STAT_NAUSEA_TOLERANCE_NONE = 2368,
        STR_SHOW_GUEST_FINANCE_TIP = 1942,
        STR_SHOW_GUEST_ITEMS_TIP = 1944,
        STR_SHOW_GUEST_NEEDS_TIP = 1940,
        STR_SHOW_GUEST_THOUGHTS_TIP = 1943,
        STR_SHOW_GUEST_VIEW_TIP = 1938,
        STR_SHOW_GUEST_VISITED_RIDES_TIP = 1941,
        STR_TOGGLE_GUEST_TRACKING_TIP = 1930,

        // Window: GuestList
        STR_ACTIONS = 1814,
        STR_ALL_GUESTS = 1818,
        STR_ALL_GUESTS_SUMMARISED = 1819,
        STR_ARG_4_PAGE_X = 6359,
        STR_FORMAT_NUM_GUESTS_PLURAL = 1754,
        STR_FORMAT_NUM_GUESTS_SINGULAR = 1755,
        STR_GUESTS = 1463,
        STR_GUESTS_COUNT_COMMA_SEP = 1817,
        STR_GUESTS_ENTER_NAME_TO_SEARCH = 6173,
        STR_GUESTS_FILTER = 1820,
        STR_GUESTS_FILTER_BY_NAME = 6171,
        STR_GUESTS_FILTER_BY_NAME_TIP = 6172,
        STR_GUESTS_FILTER_THINKING = 1821,
        STR_GUESTS_FILTER_THINKING_ABOUT = 1822,
        STR_INDIVIDUAL_GUESTS_TIP = 1752,
        STR_INFORMATION_TYPE_TIP = 1816,
        STR_PAGE_X = 6358,
        STR_SHOW_GUESTS_ON_MAP_TIP = 2803,
        STR_SUMMARISED_GUESTS_TIP = 1753,
        STR_THOUGHTS = 1815,
        STR_TRACKED_GUESTS_ONLY_TIP = 5489,

        // Window: InstallTrack
        STR_AN_EXISTING_TRACK_DESIGN_ALREADY_HAS_THIS_NAME = 3384,
        STR_DESIGN_INCLUDES_SCENERY_WHICH_IS_UNAVAILABLE = 3134,
        STR_INSTALL_NEW_TRACK_DESIGN_CANCEL = 3379,
        STR_INSTALL_NEW_TRACK_DESIGN_INSTALL = 3378,
        STR_SELECT_NEW_NAME_FOR_TRACK_DESIGN = 3383,
        STR_TOGGLE_SCENERY_TIP = 1406,
        STR_TRACK_DESIGN_INSTALL_WINDOW_TITLE = 2309,
        STR_TRACK_DESIGN_NAME = 6142,
        STR_TRACK_DESIGN_TYPE = 6143,
        STR_UNABLE_TO_INSTALL_THIS_TRACK_DESIGN = 3380,
        STR_UNABLE_TO_LOAD_FILE = 3010,

        // Window: Land
        STR_DISABLE_ELEVATION = 5127,
        STR_ENABLE_MOUNTAIN_TOOL_TIP = 5554,
        STR_LAND = 2382,
        STR_LAND_TOOL_SIZE_VALUE = 5486,
        STR_LOWER_COST_AMOUNT = 985,
        STR_RAISE_COST_AMOUNT = 984,

        // Window: LandRights
        STR_ADJUST_LARGER_LAND_RIGHTS_TIP = 5134,
        STR_ADJUST_SMALLER_LAND_RIGHTS_TIP = 5133,
        STR_BUY_CONSTRUCTION_RIGHTS_TIP = 2326,
        STR_BUY_LAND_RIGHTS_TIP = 2325,
        STR_CONSTRUCTION_RIGHTS_OWNED = 3218,
        STR_CONSTRUCTION_RIGHTS_SALE = 3220,
        STR_LAND_NOT_OWNED = 6657,
        STR_LAND_OWNED = 3217,
        STR_LAND_RIGHTS = 5136,
        STR_LAND_SALE = 3219,
        STR_NO_CONSTRUCTION_RIGHTS_FOR_SALE_TIP = 5989,
        STR_NO_LAND_RIGHTS_FOR_SALE_TIP = 5988,
        STR_SET_CONSTRUCTION_RIGHTS_TO_BE_AVAILABLE_TIP = 3224,
        STR_SET_CONSTRUCTION_RIGHTS_TO_BE_OWNED_TIP = 3222,
        STR_SET_LAND_TO_BE_AVAILABLE_TIP = 3223,
        STR_SET_LAND_TO_BE_NOT_OWNED_TIP = 6658,
        STR_SET_LAND_TO_BE_OWNED_TIP = 3221,

        // Window: LoadSave
        STR_DATE_COLUMN = 5374,
        STR_FILEBROWSER_ACTION_NEW_FOLDER = 5985,
        STR_FILEBROWSER_CUSTOMISE_DATE = 6715,
        STR_FILEBROWSER_CUSTOMISE_FILENAME = 6714,
        STR_FILEBROWSER_CUSTOMISE_SIZE = 6716,
        STR_FILEBROWSER_CUSTOMISE_PREVIEW = 6736,
        STR_FILEBROWSER_PREVIEW_DISABLED = 6797,
        STR_FILEBROWSER_PREVIEW_MINIMAP = 6799,
        STR_FILEBROWSER_PREVIEW_SCREENSHOT = 6798,
        STR_FILEBROWSER_FILE_SIZE_VALUE = 6713,
        STR_FILEBROWSER_FOLDER_NAME_PROMPT = 5986,
        STR_FILEBROWSER_OVERWRITE_PROMPT = 2708,
        STR_FILEBROWSER_OVERWRITE_TITLE = 2709,
        STR_FILEBROWSER_SAVE_BUTTON = 6712,
        STR_FILEBROWSER_SIZE_COLUMN = 6717,
        STR_FILEBROWSER_USE_SYSTEM_WINDOW = 2707,
        STR_FILENAME_LABEL = 6711,
        STR_FILE_DIALOG_TITLE_INSTALL_NEW_TRACK_DESIGN = 1039,
        STR_FILE_DIALOG_TITLE_LOAD_GAME = 1036,
        STR_FILE_DIALOG_TITLE_LOAD_HEIGHTMAP = 6042,
        STR_FILE_DIALOG_TITLE_LOAD_LANDSCAPE = 1037,
        STR_FILE_DIALOG_TITLE_SAVE_GAME = 1040,
        STR_FILE_DIALOG_TITLE_SAVE_LANDSCAPE = 1042,
        STR_FILE_DIALOG_TITLE_SAVE_TRACK = 5895,
        STR_GAME_SAVE_FAILED = 1047,
        STR_LANDSCAPE_SAVE_FAILED = 1049,
        STR_LOADSAVE_DEFAULT_TIP = 5892,
        STR_NAME_COLUMN = 5373,
        STR_NO_PREVIEW_AVAILABLE = 6737,
        STR_OPENRCT2_HEIGHTMAP_FILE = 6055,
        STR_OPENRCT2_LANDSCAPE_FILE = 1045,
        STR_OPENRCT2_SAVED_GAME = 1043,
        STR_OPENRCT2_SCENARIO_FILE = 1044,
        STR_OPENRCT2_TRACK_DESIGN_FILE = 1046,
        STR_PARENT_FOLDER_TIP = 6735,
        STR_RIGHTGUILLEMET = 6059,
        STR_SCENARIO_SAVE_FAILED = 1048,
        STR_SUMMARY_CASH = 6740,
        STR_SUMMARY_DATE = 6739,
        STR_SUMMARY_NUM_GUESTS = 6742,
        STR_SUMMARY_NUM_RIDES = 6741,
        STR_SUMMARY_PARK_RATING = 6738,
        STR_TRACK_SAVE_FAILED = 5896,
        STR_UNABLE_TO_CREATE_FOLDER = 5987,

        // Window: Main

        // Window: Map
        STR_BUILD_PARK_ENTRANCE_TIP = 3226,
        STR_MAP_CASH_MACHINE = 3372,
        STR_MAP_DRINK_STALL = 3368,
        STR_MAP_FIRST_AID = 3371,
        STR_MAP_FOOD_STALL = 3367,
        STR_MAP_GENERATOR_TIP = 5905,
        STR_MAP_INFO_KIOSK = 3370,
        STR_MAP_LABEL = 2802,
        STR_MAP_RIDE = 3366,
        STR_MAP_SIZE = 3211,
        STR_MAP_SIZE_2 = 5130,
        STR_MAP_SOUVENIR_STALL = 3369,
        STR_MAP_TOILET = 3373,
        STR_SELECT_PARK_OWNED_LAND_TIP = 3216,
        STR_SET_STARTING_POSITIONS_TIP = 3228,
        STR_SHOW_PEOPLE_ON_MAP_TIP = 3143,
        STR_SHOW_RIDES_STALLS_ON_MAP_TIP = 3144,

        // Window: MapGen
        STR_BASE_HEIGHT = 5183,       // unused
        STR_BASE_HEIGHT_LABEL = 2691, // unused
        STR_BEACHES_WATER_BODIES = 6677,
        STR_ENTER_BASE_FREQUENCY = 6701,
        STR_ENTER_BASE_HEIGHT = 5184, // unused
        STR_ENTER_MAX_LAND = 6693,
        STR_ENTER_MAX_TREE_ALTITUDE = 6697,
        STR_ENTER_MIN_LAND = 6691,
        STR_ENTER_MIN_TREE_ALTITUDE = 6695,
        STR_ENTER_OCTAVES = 6703,
        STR_ENTER_SMOOTH_STRENGTH = 6709,
        STR_ENTER_TREE_TO_LAND_RATIO = 6699,
        STR_ENTER_WATER_LEVEL = 5186,
        STR_HEIGHTMAP_FILE = 6681,
        STR_HEIGHTMAP_FLATLAND = 6679,
        STR_HEIGHTMAP_SIMPLEX_NOISE = 6680,
        STR_HEIGHTMAP_SOURCE = 6678,
        STR_MAPGEN_ACTION_GENERATE = 2694,
        STR_MAPGEN_CAPTION_FORESTS = 6685,
        STR_MAPGEN_CAPTION_GENERATOR = 6682,
        STR_MAPGEN_CAPTION_TERRAIN = 6683,
        STR_MAPGEN_CAPTION_WATER = 6684,
        STR_MAPGEN_CURRENT_HEIGHTMAP_FILE = 6706,
        STR_MAPGEN_MAX_LAND_HEIGHT = 2687,
        STR_MAPGEN_MIN_LAND_HEIGHT = 2686,
        STR_MAPGEN_NONE_SELECTED = 6707,
        STR_MAPGEN_NORMALIZE = 6046,
        STR_MAPGEN_OPTION_PLACE_TREES = 2696,
        STR_MAPGEN_OPTION_RANDOM_TERRAIN = 2695,
        STR_MAPGEN_SELECT_HEIGHTMAP = 6043,
        STR_MAPGEN_SIMPLEX_NOISE = 2685,
        STR_MAPGEN_SIMPLEX_NOISE_BASE_FREQUENCY = 2688,
        STR_MAPGEN_SIMPLEX_NOISE_OCTAVES = 2689,
        STR_MAPGEN_SMOOTH_HEIGHTMAP = 6044,
        STR_MAPGEN_SMOOTH_STRENGTH = 6045,
        STR_MAPGEN_SMOOTH_TILE = 6047,
        STR_MAPGEN_TREE_MAX_ALTITUDE = 6688,
        STR_MAPGEN_TREE_MIN_ALTITUDE = 6687,
        STR_MAPGEN_TREE_TO_LAND_RATIO = 6686,
        STR_MAPGEN_TREE_TO_LAND_RATIO_PCT = 6689,
        STR_MAX_LAND_HEIGHT = 6692,
        STR_MAX_TREE_ALTITUDE = 6696,
        STR_MIN_LAND_HEIGHT = 6690,
        STR_MIN_TREE_ALTITUDE = 6694,
        STR_SIMPLEX_BASE_FREQUENCY = 6700,
        STR_SIMPLEX_OCTAVES = 6702,
        STR_SMOOTH_STRENGTH = 6708,
        STR_TERRAIN_LABEL = 2693,
        STR_TREE_TO_LAND_RATIO = 6698,
        STR_WATER_LEVEL = 5185,
        STR_WATER_LEVEL_LABEL = 2692,

        // Window: MapTooltip
        STR_MAP_TOOLTIP_STRINGID = 1162,

        // Window: MazeConstruction
        STR_RIDE_CONSTRUCTION_BUILD = 1732,
        STR_RIDE_CONSTRUCTION_BUILD_MAZE_IN_THIS_DIRECTION_TIP = 1761,
        STR_RIDE_CONSTRUCTION_BUILD_MODE = 1758,
        STR_RIDE_CONSTRUCTION_FILL_IN_MODE = 1760,
        STR_RIDE_CONSTRUCTION_MODE = 1733,
        STR_RIDE_CONSTRUCTION_MOVE_MODE = 1759,

        // Window: Multiplayer
        STR_ADD_GROUP = 5643,
        STR_ALLOW_KNOWN_KEYS_ONLY = 5862,
        STR_ALLOW_KNOWN_KEYS_ONLY_TIP = 5863,
        STR_DEFAULT_GROUP = 5641,
        STR_ENTER_NEW_NAME_FOR_THIS_GROUP = 5711,
        STR_GROUP = 5642,
        STR_GROUPS_TIP = 5640,
        STR_GROUP_NAME = 5710,
        STR_LAST_ACTION = 5704,
        STR_LOG_CHAT = 5865,
        STR_LOG_CHAT_TIP = 5866,
        STR_LOG_SERVER_ACTIONS = 6065,
        STR_LOG_SERVER_ACTIONS_TIP = 6066,
        STR_MULTIPLAYER_GROUPS_TITLE = 6237,
        STR_MULTIPLAYER_INFORMATION_TITLE = 6235,
        STR_MULTIPLAYER_OPTIONS_TITLE = 6238,
        STR_MULTIPLAYER_PLAYERS_TITLE = 6236,
        STR_MULTIPLAYER_PLAYER_COUNT = 5916,
        STR_MULTIPLAYER_PLAYER_COUNT_PLURAL = 5917,
        STR_PLAYER = 5496,
        STR_PLAYERS_TIP = 5639,
        STR_PROVIDER_EMAIL = 5868,
        STR_PROVIDER_NAME = 5867,
        STR_PROVIDER_WEBSITE = 5869,
        STR_REMOVE_GROUP = 5644,
        STR_RENAME_GROUP = 5709,
        STR_SHOW_SERVER_INFO_TIP = 5870,

        // Window: NetworkStatus
        STR_PASSWORD_REQUIRED = 5568,
        STR_PASSWORD_REQUIRED_DESC = 5569,

        // Window: NewCampaign
        STR_LENGTH_OF_TIME = 2417,
        STR_MARKETING_1_WEEK = 2436,
        STR_MARKETING_COST_PER_WEEK = 2443,
        STR_MARKETING_ITEM = 2416,
        STR_MARKETING_NOT_SELECTED = 2414,
        STR_MARKETING_RIDE = 2415,
        STR_MARKETING_START_THIS_MARKETING_CAMPAIGN = 2445,
        STR_MARKETING_TOTAL_COST = 2444,
        STR_X_WEEKS = 5475,

        // Window: NewRide
        STR_1_DESIGN_AVAILABLE = 3339,
        STR_AVAILABLE_VEHICLES = 6160,
        STR_CUSTOM_DESIGNED_LAYOUT = 3338,
        STR_GENTLE_RIDES_TIP = 1224,
        STR_GROUP_BY_TRACK_TYPE = 6494,
        STR_GROUP_BY_TRACK_TYPE_TIP = 6495,
        STR_NEW_GENTLE_RIDES = 978,
        STR_NEW_RIDE_COST = 1691,
        STR_NEW_RIDE_COST_FROM = 1692,
        STR_NEW_RIDE_NAME_AND_DESCRIPTION = 1690,
        STR_NEW_RIDE_VEHICLE_NAME = 6496,
        STR_NEW_ROLLER_COASTERS = 979,
        STR_NEW_SHOPS_STALLS = 982,
        STR_NEW_THRILL_RIDES = 980,
        STR_NEW_TRANSPORT_RIDES = 977,
        STR_NEW_WATER_RIDES = 981,
        STR_ROLLER_COASTERS_TIP = 1225,
        STR_SHOPS_STALLS_TIP = 1228,
        STR_THRILL_RIDES_TIP = 1226,
        STR_TRANSPORT_RIDES_TIP = 1223,
        STR_WATER_RIDES_TIP = 1227,
        STR_X_DESIGNS_AVAILABLE = 3340,

        // Window: News
        STR_NEWS_DATE_FORMAT = 2235,
        STR_NEWS_GROUP_GUEST = 6784,
        STR_NEWS_GROUP_PARK = 6782,
        STR_NEWS_GROUP_RIDE = 6783,
        STR_NOTIFICATION_GUEST_BOUGHT_ITEM = 5604,
        STR_NOTIFICATION_GUEST_DIED = 5606,
        STR_NOTIFICATION_GUEST_LEFT_PARK = 5600,
        STR_NOTIFICATION_GUEST_LEFT_RIDE = 5603,
        STR_NOTIFICATION_GUEST_ON_RIDE = 5602,
        STR_NOTIFICATION_GUEST_QUEUING_FOR_RIDE = 5601,
        STR_NOTIFICATION_GUEST_USED_FACILITY = 5605,
        STR_NOTIFICATION_GUEST_WARNINGS = 5598,
        STR_NOTIFICATION_PARK_AWARD = 5590,
        STR_NOTIFICATION_PARK_MARKETING_CAMPAIGN_FINISHED = 5591,
        STR_NOTIFICATION_PARK_RATING_WARNINGS = 5593,
        STR_NOTIFICATION_PARK_WARNINGS = 5592,
        STR_NOTIFICATION_RIDE_BROKEN_DOWN = 5594,
        STR_NOTIFICATION_RIDE_CASUALTIES = 6365,
        STR_NOTIFICATION_RIDE_CRASHED = 5595,
        STR_NOTIFICATION_RIDE_RESEARCHED = 5597,
        STR_NOTIFICATION_RIDE_VEHICLE_STALLED = 6366,
        STR_NOTIFICATION_RIDE_WARNINGS = 5596,
        STR_NOTIFICATION_SETTINGS = 5589,
        STR_RECENT_MESSAGES = 2234,

        // Window: ObjectLoadError
        STR_COPY_ALL = 6130,
        STR_COPY_ALL_TIP = 6302,
        STR_COPY_SELECTED = 6129,
        STR_COPY_SELECTED_TIP = 6301,
        STR_DOWNLOADING_OBJECTS = 6303,
        STR_DOWNLOADING_OBJECTS_FROM = 6330,
        STR_DOWNLOAD_ALL = 6299,
        STR_DOWNLOAD_ALL_TIP = 6300,
        STR_OBJECT_ERROR_WINDOW_EXPLANATION = 6128,
        STR_OBJECT_ERROR_WINDOW_FILE = 6127,
        STR_OBJECT_LOAD_ERROR_TITLE = 6123,
        STR_OBJECT_NAME = 6124,
        STR_OBJECT_SOURCE = 6131,
        STR_OBJECT_TYPE = 6125,

        // Window: Options
        STR_ALLOW_EARLY_COMPLETION = 6226,
        STR_ALWAYS_NATIVE_LOADSAVE = 6264,
        STR_ALWAYS_NATIVE_LOADSAVE_TIP = 6265,
        STR_ARG_16_RESOLUTION_X_BY_Y = 840,
        STR_AUDIO_DEVICE_TIP = 5834,
        STR_AUDIO_FOCUS = 5490,
        STR_AUDIO_FOCUS_TIP = 5835,
        STR_AUTOSAVE_AMOUNT = 6278,
        STR_AUTOSAVE_AMOUNT_TIP = 6279,
        STR_AUTOSAVE_FREQUENCY_TIP = 5846,
        STR_AUTO_OPEN_SHOPS = 5586,
        STR_AUTO_OPEN_SHOPS_TIP = 5587,
        STR_AUTO_STAFF_PLACEMENT = 5343,
        STR_AUTO_STAFF_PLACEMENT_TIP = 5849,
        STR_CELSIUS = 2366,
        STR_CHAT_BUTTON_ON_TOOLBAR = 6282,
        STR_CHAT_BUTTON_ON_TOOLBAR_TIP = 6281,
        STR_CHEATS_BUTTON_ON_TOOLBAR = 5147,
        STR_CHEATS_BUTTON_ON_TOOLBAR_TIP = 5840,
        STR_CONTROLS_GROUP = 5478,
        STR_CURRENCY = 2328,
        STR_CURRENCY_TIP = 5829,
        STR_CURRENT_THEME_TIP = 5827,
        STR_CYCLE_DAY_NIGHT = 5473,
        STR_CYCLE_DAY_NIGHT_TIP = 5822,
        STR_DATE_FORMAT = 5161,
        STR_DATE_FORMAT_TIP = 5833,
        STR_DEFAULT_INSPECTION_INTERVAL = 5788,
        STR_DEFAULT_INSPECTION_INTERVAL_TIP = 5851,
        STR_DISABLE_LIGHTNING_EFFECT = 5789,
        STR_DISABLE_LIGHTNING_EFFECT_TIP = 5824,
        STR_DISABLE_SCREENSAVER = 6396,
        STR_DISABLE_SCREENSAVER_TIP = 6397,
        STR_DISPLAY_RESOLUTION = 2360,
        STR_DISPLAY_RESOLUTION_TIP = 5856,
        STR_DISTANCE_AND_SPEED = 2329,
        STR_DISTANCE_AND_SPEED_TIP = 5828,
        STR_DRAWING_ENGINE = 5875,
        STR_DRAWING_ENGINE_TIP = 5876,
        STR_EARLY_COMPLETION_TIP = 6227,
        STR_EDIT_ASSET_PACKS_BUTTON = 6640,
        STR_EXPORT_EMSCRIPTEN = 6730,
        STR_IMPORT_EMSCRIPTEN = 6731,
        STR_EDIT_THEMES_BUTTON = 5153,
        STR_EDIT_THEMES_BUTTON_TIP = 5837,
        STR_EFFECTS_GROUP = 6256,
        STR_ENABLE_DEBUGGING_TOOLS = 5150,
        STR_ENABLE_DEBUGGING_TOOLS_TIP = 5845,
        STR_ENABLE_LIGHTING_EFFECTS = 6001,
        STR_ENABLE_LIGHTING_EFFECTS_TIP = 6002,
        STR_ENABLE_LIGHTING_VEHICLES = 6361,
        STR_ENABLE_LIGHTING_VEHICLES_TIP = 6362,
        STR_ENLARGED_UI = 6638,
        STR_ENLARGED_UI_TIP = 6645,
        STR_FAHRENHEIT = 2367,
        STR_FINANCES_BUTTON_ON_TOOLBAR = 5120,
        STR_FINANCES_BUTTON_ON_TOOLBAR_TIP = 5838,
        STR_FRAME_RATE_LIMIT_DEFAULT = 6771,
        STR_FRAME_RATE_LIMIT_LABEL = 6770,
        STR_FRAME_RATE_LIMIT_UNRESTRICTED = 6773,
        STR_FRAME_RATE_LIMIT_VSYNC = 6772,
        STR_FULLSCREEN_MODE = 5177,
        STR_FULLSCREEN_MODE_TIP = 5855,
        STR_GRIDLINES = 2363,
        STR_GRIDLINES_TIP = 2364,
        STR_GROUP_ADVANCED = 6765,
        STR_GROUP_BEHAVIOUR = 6769,
        STR_GROUP_RCT1 = 6763,
        STR_GROUP_RENDERING = 6768,
        STR_GROUP_SAVING = 6764,
        STR_GROUP_WINDOW = 6767,
        STR_HARDWARE_GROUP = 5476,
        STR_HEIGHT_IN_UNITS = 2358,
        STR_HEIGHT_LABELS = 2331,
        STR_HEIGHT_LABELS_UNITS_TIP = 5832,
        STR_HOTKEY = 2489,
        STR_HOTKEY_TIP = 2799,
        STR_IMPERIAL = 2344,
        STR_INVERT_RIGHT_MOUSE_DRAG = 5372,
        STR_INVERT_RIGHT_MOUSE_DRAG_TIP = 5826,
        STR_LANGUAGE_LOAD_FAILED = 5561,
        STR_LANGUAGE_TIP = 5830,
        STR_MASTER_VOLUME = 6262,
        STR_MASTER_VOLUME_TIP = 6263,
        STR_METRIC = 2345,
        STR_MINIMISE_FULLSCREEN_ON_FOCUS_LOSS = 5440,
        STR_MINIMISE_FULLSCREEN_ON_FOCUS_LOSS_TIP = 5820,
        STR_MULTITHREADING = 6305,
        STR_MULTITHREADING_TIP = 6306,
        STR_MUTE_BUTTON_ON_TOOLBAR = 6058,
        STR_MUTE_BUTTON_ON_TOOLBAR_TIP = 6057,
        STR_OPENRCT2_DROPDOWN = 6586,
        STR_OPTIONS_ADVANCED = 6167,
        STR_OPTIONS_AUDIO_TIP = 5268,
        STR_OPTIONS_AUTOSAVE_FREQUENCY_LABEL = 2700,
        STR_OPTIONS_CONTROLS_TIP = 5269,
        STR_OPTIONS_CULTURE_TIP = 5267,
        STR_OPTIONS_DISPLAY_FULLSCREEN = 2774,
        STR_OPTIONS_DISPLAY_FULLSCREEN_BORDERLESS = 2775,
        STR_OPTIONS_DISPLAY_TIP = 5266,
        STR_OPTIONS_DISPLAY_WINDOWED = 2773,
        STR_OPTIONS_INTERFACE_TIP = 6762,
        STR_OPTIONS_LANGUAGE = 2776,
        STR_OPTIONS_MISCELLANEOUS_TIP = 5270,
        STR_OPTIONS_MUSIC_LABEL = 2738,
        STR_OPTIONS_MUSIC_VALUE_NONE = 2739,
        STR_OPTIONS_MUSIC_VALUE_RANDOM = 5126,
        STR_OPTIONS_RENDERING_TIP = 5734,
        STR_OPTIONS_SCENARIO_UNLOCKING = 5630,
        STR_OPTIONS_TITLE = 1168,
        STR_OPTIONS_TITLE_SEQUENCE = 6168,
        STR_OPTIONS_TOOLBAR_BUTTONS_CENTRED = 6629,
        STR_OPTIONS_TOOLBAR_BUTTONS_CENTRED_TIP = 6630,
        STR_OPTIONS_TWEAKS = 6170,
        STR_OPTION_DISABLED_DURING_NETWORK_PLAY = 6103,
        STR_PATH_TO_RCT1 = 6033,
        STR_PATH_TO_RCT1_BROWSER = 6035,
        STR_PATH_TO_RCT1_CLEAR_TIP = 6036,
        STR_PATH_TO_RCT1_DOES_NOT_CONTAIN_CSG1I_DAT = 6371,
        STR_PATH_TO_RCT1_IS_WRONG_VERSION = 6372,
        STR_PATH_TO_RCT1_TIP = 6038,
        STR_PATH_TO_RCT1_WRONG_ERROR = 6037,
        STR_REAL_NAME_GUESTS = 2487,
        STR_REAL_NAME_GUESTS_TIP = 2488,
        STR_REAL_NAME_STAFF = 6671,
        STR_REAL_NAME_STAFF_TIP = 6672,
        STR_REAL_VALUES = 2359,
        STR_RENDERING_GROUP = 5477,
        STR_RENDER_WEATHER_EFFECTS = 5920,
        STR_RENDER_WEATHER_EFFECTS_TIP = 5921,
        STR_RESEARCH_BUTTON_ON_TOOLBAR = 5121,
        STR_RESEARCH_BUTTON_ON_TOOLBAR_TIP = 5839,
        STR_RESOLUTION_X_BY_Y = 839,
        STR_RESTART_REQUIRED = 5558,
        STR_RIDE_MUSIC = 1777,
        STR_RIDE_MUSIC_TIP = 5854,
        STR_ROLLERCOASTER_TYCOON_1_DROPDOWN = 2740,
        STR_ROTATE_VIEW_ANTI_CLOCKWISE_IN_TOOLBAR_TIP = 6732,
        STR_SAVE_EVERY_15MINUTES = 2703,
        STR_SAVE_EVERY_30MINUTES = 2704,
        STR_SAVE_EVERY_5MINUTES = 2702,
        STR_SAVE_EVERY_HOUR = 2705,
        STR_SAVE_EVERY_MINUTE = 2701,
        STR_SAVE_NEVER = 2706,
        STR_SAVE_PLUGIN_DATA = 3333,
        STR_SAVE_PLUGIN_DATA_TIP = 3334,
        STR_SCENARIO_GROUPING_TIP = 5842,
        STR_SCENARIO_OPTIONS = 6228,
        STR_SCENARIO_PREVIEWS_LABEL = 6778,
        STR_SCENARIO_PREVIEWS_MINIMAPS = 6780,
        STR_SCENARIO_PREVIEWS_SCREENSHOTS = 6781,
        STR_SCENARIO_PREVIEWS_TIP = 6779,
        STR_SCENARIO_UNLOCKING_TIP = 5843,
        STR_SCREEN_EDGE_SCROLLING = 2797,
        STR_SCREEN_EDGE_SCROLLING_TIP = 2798,
        STR_SHOW_FPS = 5581,
        STR_SHOW_FPS_TIP = 5815,
        STR_SHOW_GUEST_PURCHASES = 6060,
        STR_SHOW_GUEST_PURCHASES_TIP = 6061,
        STR_SHOW_RECENT_MESSAGES_ON_TOOLBAR = 5468,
        STR_SHOW_RECENT_MESSAGES_ON_TOOLBAR_TIP = 5841,
        STR_SHOW_TOOLBAR_BUTTONS_FOR = 5480,
        STR_SI = 5584,
        STR_SOUND_EFFECTS = 2333,
        STR_SOUND_EFFECTS_TIP = 5853,
        STR_SOUND_NONE = 1169,
        STR_STAY_CONNECTED_AFTER_DESYNC = 5557,
        STR_STAY_CONNECTED_AFTER_DESYNC_TIP = 5844,
        STR_TEMPERATURE = 2330,
        STR_TEMPERATURE_FORMAT_TIP = 5831,
        STR_THEMES_GROUP = 5481,
        STR_THEMES_LABEL_CURRENT_THEME = 5238,
        STR_TILE_SMOOTHING = 2361,
        STR_TILE_SMOOTHING_TIP = 2362,
        STR_TITLE_MUSIC_TIP = 5836,
        STR_TITLE_SEQUENCE_RANDOM = 5310,
        STR_TITLE_SEQUENCE_TIP = 5847,
        STR_TOOLBAR_BUTTONS_GROUP = 5479,
        STR_TOUCH_ENHANCEMENTS = 6644,
        STR_TOUCH_ENHANCEMENTS_TIP = 6639,
        STR_TRANSPARENT_SCREENSHOT = 6327,
        STR_TRANSPARENT_SCREENSHOT_TIP = 6328,
        STR_TRAP_MOUSE = 5582,
        STR_TRAP_MOUSE_TIP = 5825,
        STR_UI_SCALING_DESC = 5579,
        STR_UNCAP_FPS = 5454,
        STR_UNCAP_FPS_TIP = 5859,
        STR_UPPERCASE_BANNERS = 5474,
        STR_UPPERCASE_BANNERS_TIP = 5823,
        STR_USE_VSYNC = 6165,
        STR_USE_VSYNC_TIP = 6166,
        STR_VIRTUAL_FLOOR_STYLE = 6202,
        STR_VIRTUAL_FLOOR_STYLE_DISABLED = 6259,
        STR_VIRTUAL_FLOOR_STYLE_GLASSY = 6257,
        STR_VIRTUAL_FLOOR_STYLE_TIP = 6203,
        STR_VIRTUAL_FLOOR_STYLE_TRANSPARENT = 6258,
        STR_WINDOW_BUTTONS_ON_THE_LEFT = 6589,
        STR_WINDOW_BUTTONS_ON_THE_LEFT_TIP = 6590,
        STR_WINDOW_SCALE_TIP = 5816,
        STR_ZOOM_BUTTON_ON_TOOLBAR = 6410,
        STR_ZOOM_BUTTON_ON_TOOLBAR_TIP = 6411,
        STR_ZOOM_TO_CURSOR = 5906,
        STR_ZOOM_TO_CURSOR_TIP = 5907,

        // Window: Park
        STR_ADMISSION_PRICE = 1756,
        STR_ADMISSION_PRICE_PAY_PER_RIDE_TIP = 6014,
        STR_BUY_LAND_AND_CONSTRUCTION_RIGHTS_TIP = 5135,
        STR_CLOSE_PARK = 1013,
        STR_CLOSE_PARK_TIP = 5296,
        STR_ENTER_NAME = 2791,
        STR_ENTER_NAME_INTO_SCENARIO_CHART = 2790,
        STR_GUESTS_IN_PARK_LABEL = 2223,
        STR_INCOME_FROM_ADMISSIONS = 2801,
        STR_NAME_PARK_TIP = 1720,
        STR_NO_RECENT_AWARDS = 2848,
        STR_NUMBER_OF_RIDES_LABEL = 2321,
        STR_OBJECTIVE_ACHIEVED = 2788,
        STR_OBJECTIVE_FAILED = 2789,
        STR_OBJECTIVE_LABEL = 2384,
        STR_OPEN_OR_CLOSE_PARK_TIP = 1010,
        STR_OPEN_PARK = 1014,
        STR_OPEN_PARK_TIP = 5297,
        STR_PARK_AWARDS_TAB_TIP = 2468,
        STR_PARK_CLOSED = 1721,
        STR_PARK_ENTRANCE_TAB_TIP = 2462,
        STR_PARK_GUESTS_TAB_TIP = 2464,
        STR_PARK_NAME = 1718,
        STR_PARK_OBJECTIVE_TAB_TIP = 2467,
        STR_PARK_OPEN = 1722,
        STR_PARK_PRICE_TAB_TIP = 2465,
        STR_PARK_RATING_LABEL = 2220,
        STR_PARK_RATING_TAB_TIP = 2463,
        STR_PARK_SIZE_IMPERIAL_LABEL = 2324,
        STR_PARK_SIZE_METRIC_LABEL = 2323,
        STR_PARK_STATS_TAB_TIP = 2466,
        STR_PLEASE_ENTER_YOUR_NAME_FOR_THE_SCENARIO_CHART = 2792,
        STR_STAFF_LABEL = 2322,
        STR_TOTAL_ADMISSIONS = 2800,

        // Window: PatrolArea
        STR_ADJUST_LARGER_PATROL_AREA_TIP = 6470,
        STR_ADJUST_SMALLER_PATROL_AREA_TIP = 6469,

        // Window: Player
        STR_ACTION_NA = 5662,
        STR_COMMANDS_RAN = 5636,
        STR_KICK_PLAYER_TIP = 5556,
        STR_LAST_ACTION_RAN = 5701,
        STR_LOCATE_PLAYER_TIP = 5702,
        STR_MONEY_SPENT = 5635,
        STR_PING = 5497,

        // Window: RefurbishRidePrompt
        STR_REFURBISH = 6246,
        STR_REFURBISH_RIDE = 6247,
        STR_REFURBISH_RIDE_ID_MONEY = 6248,
        STR_REFURBISH_RIDE_ID_NO_MONEY = 6249,

        // Window: Research
        STR_CURRENTLY_IN_DEVELOPMENT = 2267,
        STR_LAST_DEVELOPMENT = 2268,
        STR_RESEARCH_AND_DEVELOPMENT = 983,
        STR_RESEARCH_AND_DEVELOPMENT_TIP = 2276,
        STR_RESEARCH_COMPLETED_AL = 2680,
        STR_RESEARCH_COST_PER_MONTH = 2265,
        STR_RESEARCH_EXPECTED_FORMAT = 2289,
        STR_RESEARCH_EXPECTED_LABEL = 2271,
        STR_RESEARCH_FUNDING = 1954,
        STR_RESEARCH_FUNDING_ = 2264,
        STR_RESEARCH_NEW_GENTLE_RIDES_TIP = 2471,
        STR_RESEARCH_NEW_ROLLER_COASTERS_TIP = 2472,
        STR_RESEARCH_NEW_SCENERY_AND_THEMING_TIP = 2476,
        STR_RESEARCH_NEW_SHOPS_AND_STALLS_TIP = 2475,
        STR_RESEARCH_NEW_THRILL_RIDES_TIP = 2473,
        STR_RESEARCH_NEW_TRANSPORT_RIDES_TIP = 2470,
        STR_RESEARCH_NEW_WATER_RIDES_TIP = 2474,
        STR_RESEARCH_PRIORITIES = 2266,
        STR_RESEARCH_PROGRESS_LABEL = 2270,
        STR_RESEARCH_RIDE_LABEL = 2272,
        STR_RESEARCH_SCENERY_LABEL = 2273,
        STR_RESEARCH_SHOW_DETAILS_TIP = 2274,
        STR_RESEARCH_STAGE_COMPLETING_DESIGN = 2287,
        STR_RESEARCH_STAGE_DESIGNING = 2286,
        STR_RESEARCH_STAGE_INITIAL_RESEARCH = 2285,
        STR_RESEARCH_STAGE_UNKNOWN = 2288,
        STR_RESEARCH_TYPE_LABEL = 2269,
        STR_RESEARCH_TYPE_LABEL_VEHICLE = 6377,
        STR_RESEARCH_UNKNOWN = 2277,
        STR_RESEARCH_VEHICLE_LABEL = 6376,
        STR_SELECT_LEVEL_OF_RESEARCH_AND_DEVELOPMENT = 2469,

        // Window: Ride
        STR_1_CAR_PER_TRAIN = 1022,
        STR_ALL_VEHICLES_IN_SAME_COLOURS = 1129,
        STR_ALTERNATIVE_COLOUR_SCHEME_1 = 2972,
        STR_ALTERNATIVE_COLOUR_SCHEME_2 = 2973,
        STR_ALTERNATIVE_COLOUR_SCHEME_3 = 2974,
        STR_ANY_LOAD = 1152,
        STR_ARG_10_STRINGID = 870,
        STR_ARG_14_STRINGID = 872,
        STR_ARG_16_STRINGID = 873,
        STR_ARG_18_STRINGID = 874,
        STR_ARG_20_STRINGID = 875,
        STR_ARG_6_CURRENCY2DP = 1429,
        STR_ARG_6_STRINGID = 868,
        STR_ARRIVING_AT = 1103,
        STR_AVERAGE_SPEED = 1347,
        STR_AUTHOR_STRING = 6646,
        STR_AUTHORS_STRING = 6647,
        STR_BLOCK_SECTIONS = 3110,
        STR_BUILT_LAST_YEAR = 1854,
        STR_BUILT_THIS_YEAR = 1853,
        STR_BUILT_YEARS_AGO = 1855,
        STR_CALLING_MECHANIC = 3117,
        STR_CAPACITY = 3142,
        STR_CLICK_ITEMS_OF_SCENERY_TO_SELECT = 3132,
        STR_CLOSE_RIDE = 3107,
        STR_CLOSE_RIDE_TIP = 5293,
        STR_COLOUR_SCHEME_OPTIONS_TIP = 1396,
        STR_COLOUR_SCHEME_TO_CHANGE_TIP = 2975,
        STR_CONSTRUCTION = 990,
        STR_CRASHED_0 = 1107,
        STR_CRASHING = 1106,
        STR_CURRENT_BREAKDOWN = 1809,
        STR_CUSTOMERS_ON_RIDE = 5739,
        STR_CUSTOMERS_PER_HOUR = 1427,
        STR_CUSTOMER_INFORMATION_TIP = 1696,
        STR_DEBUG_CANT_FORCE_BREAKDOWN = 5291,
        STR_DEBUG_FIX_RIDE = 5290,
        STR_DEBUG_FORCE_BREAKDOWN_TIP = 5292,
        STR_DEBUG_NO_BREAKDOWNS_AVAILABLE = 5289,
        STR_DEBUG_RIDE_ALREADY_BROKEN = 5287,
        STR_DEBUG_RIDE_IS_CLOSED = 5288,
        STR_DEMOLISH_RIDE_TIP = 992,
        STR_DEPARTING = 1101,
        STR_DESIGN_CANCEL = 3131,
        STR_DESIGN_SAVE = 3130,
        STR_DIFFERENT_COLOURS_PER = 1130,
        STR_DIFFERENT_COLOURS_PER_VEHICLE = 1131,
        STR_DOING_CIRCUS_SHOW = 1117,
        STR_DOWN_TIME_LABEL_1889 = 1889,
        STR_DROPDOWN_MENU_LABEL = 1142,
        STR_DROPDOWN_MENU_LABEL_SELECTED = 1143,
        STR_DROPS = 1355,
        STR_ENTER_NEW_NAME_FOR_THIS_RIDE_ATTRACTION = 1058,
        STR_ENTER_VALUE = 6502,
        STR_EXCITEMENT_FACTOR = 3125,
        STR_EXCITEMENT_FACTOR_NEGATIVE = 6533,
        STR_EXCITEMENT_RATING = 1473,
        STR_EXCITEMENT_RATING_NOT_YET_AVAILABLE = 1474,
        STR_EXIT_ONLY = 1220,
        STR_FAVOURITE_RIDE_OF_GUEST = 3122,
        STR_FAVOURITE_RIDE_OF_GUESTS = 3123,
        STR_FORMAT_SECONDS = 1217,
        STR_FULL_LOAD = 1151,
        STR_GRAPHS_TIP = 1399,
        STR_HALF_LOAD = 1149,
        STR_HIGHEST_DROP_HEIGHT = 1354,
        STR_HOLES = 1357,
        STR_INCOME_AND_COSTS_TIP = 1695,
        STR_INCOME_PER_HOUR = 1873,
        STR_INSPECTION = 1878,
        STR_INTENSITY_FACTOR = 3126,
        STR_INTENSITY_FACTOR_NEGATIVE = 6534,
        STR_INTENSITY_RATING = 1475,
        STR_INTENSITY_RATING_NOT_YET_AVAILABLE = 1476,
        STR_INTENSITY_RATING_RED = 1477,
        STR_INVERSIONS = 1356,
        STR_ITEMS_SOLD = 1894,
        STR_LAST_BREAKDOWN = 1808,
        STR_LAUNCH_SPEED = 1329,
        STR_LAUNCH_SPEED_TIP = 1330,
        STR_LEAVE_IF_ANOTHER_BOAT_ARRIVES = 1208,
        STR_LEAVE_IF_ANOTHER_TRAIN_ARRIVES = 1207,
        STR_LEAVE_IF_ANOTHER_VEHICLE_ARRIVES_TIP = 1210,
        STR_LIFT_HILL_CHAIN_SPEED = 3095,
        STR_LIFT_HILL_CHAIN_SPEED_VALUE = 3096,
        STR_LOCATE_NEAREST_AVAILABLE_MECHANIC_TIP = 3120,
        STR_LOGGING_DATA_FROM_TIP = 1422,
        STR_LOSS_PER_ITEM_SOLD = 1857,
        STR_MAINTENANCE_OPTIONS_TIP = 1395,
        STR_MAIN_COLOUR_SCHEME = 2971,
        STR_MAXIMUM_LENGTH_BEFORE_DEPARTING_TIP = 1214,
        STR_MAXIMUM_WAITING_TIME = 1212,
        STR_MAX_CARS_PER_TRAIN_TIP = 5923,
        STR_MAX_LATERAL_G = 1352,
        STR_MAX_LATERAL_G_RED = 1353,
        STR_MAX_NEGATIVE_VERTICAL_G = 1350,
        STR_MAX_NEGATIVE_VERTICAL_G_RED = 1351,
        STR_MAX_PEOPLE_ON_RIDE = 1742,
        STR_MAX_PEOPLE_ON_RIDE_TIP = 1743,
        STR_MAX_PEOPLE_ON_RIDE_VALUE = 1744,
        STR_MAX_POSITIVE_VERTICAL_G = 1348,
        STR_MAX_SPEED = 1340,
        STR_MAX_VEHICLES_TIP = 5922,
        STR_MEASUREMENTS_AND_TEST_DATA_TIP = 1398,
        STR_MECHANIC_IS_FIXING_THE_RIDE = 3119,
        STR_MECHANIC_IS_HEADING_FOR_THE_RIDE = 3118,
        STR_MINIMUM_LENGTH_BEFORE_DEPARTING_TIP = 1213,
        STR_MINIMUM_WAITING_TIME = 1211,
        STR_MOVING_TO_END_OF = 1098,
        STR_NAME_RIDE_TIP = 1054,
        STR_NAUSEA_FACTOR = 3127,
        STR_NAUSEA_FACTOR_NEGATIVE = 6535,
        STR_NAUSEA_RATING = 1478,
        STR_NAUSEA_RATING_NOT_YET_AVAILABLE = 1479,
        STR_NO_ENTRANCE = 1221,
        STR_NO_EXIT = 1222,
        STR_NO_MECHANICS_ARE_HIRED_MESSAGE = 6041,
        STR_NO_TEST_RESULTS_YET = 1339,
        STR_NUMBER_OF_CIRCUITS = 1955,
        STR_NUMBER_OF_CIRCUITS_TIP = 1956,
        STR_NUMBER_OF_CIRCUITS_VALUE = 1957,
        STR_NUMBER_OF_LAPS = 1734,
        STR_NUMBER_OF_LAPS_TIP = 1735,
        STR_NUMBER_OF_LAPS_VALUE = 1736,
        STR_NUMBER_OF_ROTATIONS = 1869,
        STR_NUMBER_OF_ROTATIONS_TIP = 1870,
        STR_NUMBER_OF_ROTATIONS_VALUE = 1871,
        STR_NUMBER_OF_SWINGS = 1769,
        STR_NUMBER_OF_SWINGS_TIP = 1770,
        STR_OPEN_CLOSE_OR_TEST_RIDE = 1008,
        STR_OPEN_RIDE = 3109,
        STR_OPEN_RIDE_TIP = 5295,
        STR_OPERATING = 1125,
        STR_OPERATING_0 = 1112,
        STR_OPERATING_1 = 1115,
        STR_OPERATING_2 = 1116,
        STR_OPERATING_3 = 1118,
        STR_OPERATING_OPTIONS_TIP = 1394,
        STR_OPTION_REVERSE_TRAINS = 6583,
        STR_OPTION_REVERSE_TRAINS_TIP = 6584,
        STR_OVERALL_VIEW = 996,
        STR_PAINT_INDIVIDUAL_AREA_TIP = 2976,
        STR_PLAY_MUSIC = 1849,
        STR_POPULARITY_PERCENT = 1678,
        STR_POPULARITY_UNKNOWN = 1677,
        STR_PROFIT_PER_HOUR = 1874,
        STR_PROFIT_PER_ITEM_SOLD = 1856,
        STR_QUARTER_LOAD = 1148,
        STR_QUEUE_TIME_MINUTE = 1359,
        STR_QUEUE_TIME_MINUTES = 1360,
        STR_RANDOM_COLOUR = 6501,
        STR_RANDOMISE_VEHICLE_COLOURS = 6661,
        STR_RANDOMISE_VEHICLE_COLOURS_TIP = 6662,
        STR_RATING_EXTREME = 2376,
        STR_RATING_HIGH = 2374,
        STR_RATING_LOW = 2372,
        STR_RATING_MEDIUM = 2373,
        STR_RATING_ULTRA_EXTREME = 2377,
        STR_RATING_VERY_HIGH = 2375,
        STR_REFURBISH_RIDE_TIP = 6243,
        STR_RELIABILITY_LABEL_1757 = 1757,
        STR_RESET_SELECTION = 3138,
        STR_RIDE_ATTRACTION_NAME = 1057,
        STR_RIDE_BREAKDOWN_BRAKES_FAILURE = 1806,
        STR_RIDE_BREAKDOWN_CONTROL_FAILURE = 1807,
        STR_RIDE_BREAKDOWN_DOORS_STUCK_CLOSED = 1803,
        STR_RIDE_BREAKDOWN_DOORS_STUCK_OPEN = 1804,
        STR_RIDE_BREAKDOWN_RESTRAINTS_STUCK_CLOSED = 1801,
        STR_RIDE_BREAKDOWN_RESTRAINTS_STUCK_OPEN = 1802,
        STR_RIDE_BREAKDOWN_SAFETY_CUT_OUT = 1800,
        STR_RIDE_BREAKDOWN_VEHICLE_MALFUNCTION = 1805,
        STR_RIDE_COLOUR_TRAIN_OPTION = 1135,
        STR_RIDE_COLOUR_TRAIN_VALUE = 1134,
        STR_RIDE_COLOUR_VEHICLE_OPTION = 1133,
        STR_RIDE_COLOUR_VEHICLE_VALUE = 1132,
        STR_RIDE_DESIGN_MAZE_BRICK_WALLS = 3058,
        STR_RIDE_DESIGN_MAZE_HEDGES = 3059,
        STR_RIDE_DESIGN_MAZE_ICE_BLOCKS = 3060,
        STR_RIDE_DESIGN_MAZE_WOODEN_FENCES = 3061,
        STR_RIDE_INCOME_ADMISSION_PAY_FOR_ENTRY_TIP = 6013,
        STR_RIDE_INCOME_ADMISSION_PRICE = 1428,
        STR_RIDE_LENGTH = 1344,
        STR_RIDE_LENGTH_ENTRY = 1345,
        STR_RIDE_LENGTH_ENTRY_WITH_SEPARATOR = 1346,
        STR_RIDE_MODE_NUMBER_OF_SWINGS_VALUE = 1771,
        STR_RIDE_MODE_SPEED_VALUE = 1331,
        STR_RIDE_MODE_TIME_LIMIT_VALUE = 1749,
        STR_RIDE_NAME_1D = 31,
        STR_RIDE_NAME_1F = 33,
        STR_RIDE_NAME_22 = 36,
        STR_RIDE_NAME_50 = 82,
        STR_RIDE_NAME_52 = 84,
        STR_RIDE_NAME_53 = 85,
        STR_RIDE_NAME_54 = 86,
        STR_RIDE_NAME_55 = 87,
        STR_RIDE_NAME_59 = 91,
        STR_RIDE_SECONDARY_PRICE_VALUE = 1799,
        STR_RIDE_STATS_ALTITUDE = 1416,
        STR_RIDE_STATS_ALTITUDE_FORMAT = 1420,
        STR_RIDE_STATS_G_FORCE_FORMAT = 1421,
        STR_RIDE_STATS_LAT_G = 1418,
        STR_RIDE_STATS_TIME = 1414,
        STR_RIDE_STATS_VELOCITY = 1415,
        STR_RIDE_STATS_VELOCITY_FORMAT = 1419,
        STR_RIDE_STATS_VERT_G = 1417,
        STR_RIDE_TIME = 1341,
        STR_RIDE_TIME_ENTRY = 1342,
        STR_RIDE_TIME_ENTRY_WITH_SEPARATOR = 1343,
        STR_RIDE_VEHICLE_COUNT = 1021,
        STR_RIDE_WINDOW_TITLE = 989,
        STR_ROTATING_0 = 1110,
        STR_ROTATING_1 = 1111,
        STR_ROTATING_2 = 1114,
        STR_RUNNING_COST_PER_HOUR = 1851,
        STR_RUNNING_COST_UNKNOWN = 1852,
        STR_SAME_PRICE_THROUGHOUT_PARK = 3071,
        STR_SAME_PRICE_THROUGHOUT_PARK_TIP = 3072,
        STR_SATISFACTION_PERCENT = 1669,
        STR_SATISFACTION_UNKNOWN = 1668,
        STR_SAVE_TRACK_DESIGN = 3115,
        STR_SAVE_TRACK_DESIGN_ITEM = 3128,
        STR_SAVE_TRACK_DESIGN_NOT_POSSIBLE = 3116,
        STR_SAVE_TRACK_DESIGN_WITH_SCENERY_ITEM = 3129,
        STR_SELECT_ADDITIONAL_COLOUR_1_TIP = 1137,
        STR_SELECT_ADDITIONAL_COLOUR_2_TIP = 1138,
        STR_SELECT_HOW_OFTEN_A_MECHANIC_SHOULD_CHECK_THIS_RIDE = 1890,
        STR_SELECT_MAIN_COLOUR_TIP = 1136,
        STR_SELECT_MUSIC_STYLE_TIP = 3045,
        STR_SELECT_MUSIC_TIP = 1850,
        STR_SELECT_NEARBY_SCENERY = 3137,
        STR_SELECT_OPERATING_MODE = 2477,
        STR_SELECT_STYLE_OF_ENTRANCE_EXIT_STATION_TIP = 3090,
        STR_SELECT_SUPPORT_STRUCTURE_COLOUR_TIP = 1139,
        STR_SELECT_VEHICLE_COLOUR_SCHEME_TIP = 1140,
        STR_SELECT_VEHICLE_TO_MODIFY_TIP = 1141,
        STR_SHOWING_FILM = 1113,
        STR_SHOW_GRAPH_OF_ALTITUDE_AGAINST_TIME_TIP = 2479,
        STR_SHOW_GRAPH_OF_LATERAL_ACCELERATION_AGAINST_TIME_TIP = 2481,
        STR_SHOW_GRAPH_OF_VELOCITY_AGAINST_TIME_TIP = 2478,
        STR_SHOW_GRAPH_OF_VERTICAL_ACCELERATION_AGAINST_TIME_TIP = 2480,
        STR_SHOW_GUESTS_ON_THIS_RIDE_ATTRACTION_TIP = 1824,
        STR_SHOW_GUESTS_QUEUING_FOR_THIS_RIDE_ATTRACTION_TIP = 1825,
        STR_SHOW_GUESTS_THOUGHTS_ABOUT_THIS_RIDE_ATTRACTION_TIP = 1823,
        STR_SIMULATE_RIDE = 6324,
        STR_SIMULATE_RIDE_TIP = 6325,
        STR_SOUND_AND_MUSIC_OPTIONS_TIP = 1397,
        STR_SPEED = 1471,
        STR_SPEED_TIP = 1472,
        STR_STARTING = 1124,
        STR_STATION_STYLE = 6275,
        STR_STOPPED_BY_BLOCK_BRAKES = 1128,
        STR_STOPPING_0 = 1121,
        STR_STOPPING_1 = 1126,
        STR_SWINGING = 1109,
        STR_SYNCHRONISE_WITH_ADJACENT_STATIONS = 1215,
        STR_SYNCHRONISE_WITH_ADJACENT_STATIONS_TIP = 1216,
        STR_TEST_RIDE = 3108,
        STR_TEST_RIDE_TIP = 5294,
        STR_THREE_QUARTER_LOAD = 1150,
        STR_TIME_LIMIT = 1747,
        STR_TIME_LIMIT_TIP = 1748,
        STR_TIME_SINCE_LAST_INSPECTION_MINUTE = 5482,
        STR_TIME_SINCE_LAST_INSPECTION_MINUTES = 1887,
        STR_TIME_SINCE_LAST_INSPECTION_MORE_THAN_4_HOURS = 1888,
        STR_TOTAL_AIR_TIME = 1358,
        STR_TOTAL_CUSTOMERS = 1670,
        STR_TOTAL_PROFIT = 1671,
        STR_TRAVELLING_AT_0 = 1102,
        STR_TRAVELLING_AT_1 = 1105,
        STR_TRAVELLING_AT_2 = 1108,
        STR_TRAVELLING_AT_3 = 1120,
        STR_UNABLE_TO_LOCATE_MECHANIC = 3121,
        STR_UNLOADING_PASSENGERS = 1127,
        STR_UNLOADING_PASSENGERS_AT = 1104,
        STR_VEHICLE_DETAILS_AND_OPTIONS_TIP = 1393,
        STR_VIEW_OF_RIDE_ATTRACTION_TIP = 1392,
        STR_VIEW_SELECTION = 997,
        STR_WAITING_FOR_CABLE_LIFT = 1119,
        STR_WAITING_FOR_PASSENGERS = 1122,
        STR_WAITING_FOR_PASSENGERS_AT = 1099,
        STR_WAITING_TO_DEPART = 1100,
        STR_WAITING_TO_START = 1123,
        STR_WAIT_FOR = 1206,
        STR_WAIT_FOR_PASSENGERS_BEFORE_DEPARTING_TIP = 1209,
        STR_X_CARS_PER_TRAIN = 1023,

        // Window: RideConstruction
        STR_LOG_BUMPS = 1764,
        STR_RIDE_CONSTRUCTION_BOOSTER_SPEED = 5996,
        STR_RIDE_CONSTRUCTION_BOOSTER_SPEED_LIMIT_TIP = 6145,
        STR_RIDE_CONSTRUCTION_BRAKE_SPEED = 1674,
        STR_RIDE_CONSTRUCTION_BRAKE_SPEED_LIMIT_TIP = 1676,
        STR_RIDE_CONSTRUCTION_BRAKE_SPEED_VELOCITY = 1675,
        STR_RIDE_CONSTRUCTION_CHAIN_LIFT_TIP = 928,
        STR_RIDE_CONSTRUCTION_CONSTRUCT_SELECTED_SECTION_TIP = 915,
        STR_RIDE_CONSTRUCTION_DIRECTION = 897,
        STR_RIDE_CONSTRUCTION_ENTRANCE = 1400,
        STR_RIDE_CONSTRUCTION_ENTRANCE_TIP = 1402,
        STR_RIDE_CONSTRUCTION_EXIT = 1401,
        STR_RIDE_CONSTRUCTION_EXIT_TIP = 1403,
        STR_RIDE_CONSTRUCTION_HELIX_DOWN_TIP = 924,
        STR_RIDE_CONSTRUCTION_HELIX_UP_TIP = 925,
        STR_RIDE_CONSTRUCTION_LEFT_CURVE_LARGE_TIP = 904,
        STR_RIDE_CONSTRUCTION_LEFT_CURVE_SMALL_TIP = 900,
        STR_RIDE_CONSTRUCTION_LEFT_CURVE_TIP = 898,
        STR_RIDE_CONSTRUCTION_LEFT_CURVE_VERY_SMALL_TIP = 902,
        STR_RIDE_CONSTRUCTION_LEVEL_TIP = 920,
        STR_RIDE_CONSTRUCTION_MOVE_TO_NEXT_SECTION_TIP = 914,
        STR_RIDE_CONSTRUCTION_MOVE_TO_PREVIOUS_SECTION_TIP = 913,
        STR_RIDE_CONSTRUCTION_NO_ROLL_TIP = 912,
        STR_RIDE_CONSTRUCTION_OTHER_TRACK_CONFIGURATIONS_TIP = 1385,
        STR_RIDE_CONSTRUCTION_REMOVE_HIGHLIGHTED_SECTION_TIP = 916,
        STR_RIDE_CONSTRUCTION_RIGHT_CURVE_LARGE_TIP = 905,
        STR_RIDE_CONSTRUCTION_RIGHT_CURVE_SMALL_TIP = 901,
        STR_RIDE_CONSTRUCTION_RIGHT_CURVE_TIP = 899,
        STR_RIDE_CONSTRUCTION_RIGHT_CURVE_VERY_SMALL_TIP = 903,
        STR_RIDE_CONSTRUCTION_ROLL_BANKING = 908,
        STR_RIDE_CONSTRUCTION_ROLL_FOR_LEFT_CURVE_TIP = 910,
        STR_RIDE_CONSTRUCTION_ROLL_FOR_RIGHT_CURVE_TIP = 911,
        STR_RIDE_CONSTRUCTION_SEAT_ROT = 909,
        STR_RIDE_CONSTRUCTION_SEAT_ROTATION_ANGLE_0 = 960,
        STR_RIDE_CONSTRUCTION_SEAT_ROTATION_ANGLE_135 = 963,
        STR_RIDE_CONSTRUCTION_SEAT_ROTATION_ANGLE_180 = 964,
        STR_RIDE_CONSTRUCTION_SEAT_ROTATION_ANGLE_225 = 965,
        STR_RIDE_CONSTRUCTION_SEAT_ROTATION_ANGLE_270 = 966,
        STR_RIDE_CONSTRUCTION_SEAT_ROTATION_ANGLE_315 = 967,
        STR_RIDE_CONSTRUCTION_SEAT_ROTATION_ANGLE_360 = 968,
        STR_RIDE_CONSTRUCTION_SEAT_ROTATION_ANGLE_405 = 969,
        STR_RIDE_CONSTRUCTION_SEAT_ROTATION_ANGLE_45 = 961,
        STR_RIDE_CONSTRUCTION_SEAT_ROTATION_ANGLE_450 = 970,
        STR_RIDE_CONSTRUCTION_SEAT_ROTATION_ANGLE_495 = 971,
        STR_RIDE_CONSTRUCTION_SEAT_ROTATION_ANGLE_90 = 962,
        STR_RIDE_CONSTRUCTION_SEAT_ROTATION_ANGLE_NEG_135 = 957,
        STR_RIDE_CONSTRUCTION_SEAT_ROTATION_ANGLE_NEG_180 = 956,
        STR_RIDE_CONSTRUCTION_SEAT_ROTATION_ANGLE_NEG_45 = 959,
        STR_RIDE_CONSTRUCTION_SEAT_ROTATION_ANGLE_NEG_90 = 958,
        STR_RIDE_CONSTRUCTION_SELECT_SEAT_ROTATION_ANGLE_TIP = 955,
        STR_RIDE_CONSTRUCTION_SLOPE = 907,
        STR_RIDE_CONSTRUCTION_SLOPE_DOWN_TIP = 919,
        STR_RIDE_CONSTRUCTION_SLOPE_UP_TIP = 921,
        STR_RIDE_CONSTRUCTION_SPECIAL = 1386,
        STR_RIDE_CONSTRUCTION_STEEP_SLOPE_DOWN_TIP = 918,
        STR_RIDE_CONSTRUCTION_STEEP_SLOPE_UP_TIP = 922,
        STR_RIDE_CONSTRUCTION_STRAIGHT_TIP = 906,
        STR_RIDE_CONSTRUCTION_TRACK_STYLE = 1459,
        STR_RIDE_CONSTRUCTION_VERTICAL_DROP_TIP = 917,
        STR_RIDE_CONSTRUCTION_VERTICAL_RISE_TIP = 923,
        STR_RIDE_CONSTRUCTION_WINDOW_TITLE = 896,
        STR_YELLOW_STRING = 1384,

        // Window: RideList
        STR_CLOSE_ALL = 1011,
        STR_DOWN_TIME = 1833,
        STR_DOWN_TIME_LABEL = 1840,
        STR_LAST_INSPECTION = 6774,
        STR_LAST_INSPECTION_LABEL_MINUTE = 6775,
        STR_LAST_INSPECTION_LABEL_MINUTES = 6776,
        STR_LAST_INSPECTION_LABEL_MORE_THAN_FOUR_HOURS = 6777,
        STR_EXCITEMENT_LABEL = 6463,
        STR_GUESTS_FAVOURITE = 1834,
        STR_GUESTS_FAVOURITE_LABEL = 1842,
        STR_GUESTS_FAVOURITE_PLURAL_LABEL = 1843,
        STR_INTENSITY_LABEL = 6465,
        STR_LIST_KIOSKS_AND_FACILITIES_TIP = 3106,
        STR_LIST_RIDES_TIP = 3104,
        STR_LIST_SHOPS_AND_STALLS_TIP = 3105,
        STR_NAUSEA_LABEL = 6467,
        STR_NUMBER_RIDES = 5807,
        STR_NUMBER_SHOPS_AND_STALLS = 5808,
        STR_NUMBER_TOILETS_AND_INFORMATION_KIOSKS = 5809,
        STR_OPEN_ALL = 1012,
        STR_OPEN_OR_CLOSE_ALL_RIDES = 1009,
        STR_POPULARITY = 1827,
        STR_POPULARITY_LABEL = 1836,
        STR_POPULARITY_UNKNOWN_LABEL = 1835,
        STR_PROFIT = 1829,
        STR_PROFIT_LABEL = 1841,
        STR_QUEUE_LENGTH = 1830,
        STR_QUEUE_TIME = 1831,
        STR_QUEUE_TIME_LABEL = 1204,
        STR_QUEUE_TIME_PLURAL_LABEL = 1205,
        STR_QUICK_DEMOLISH_RIDE = 6039,
        STR_RATING_UKNOWN_LABEL = 6468,
        STR_RELIABILITY = 1832,
        STR_RELIABILITY_LABEL = 1839,
        STR_RIDES = 974,
        STR_RIDE_LIST_HEADER_FORMAT = 7002,
        STR_RIDE_LIST_NAME = 7001,
        STR_RIDE_LIST_AGE = 5772,
        STR_RIDE_LIST_BUILT_LAST_YEAR_LABEL = 5777,
        STR_RIDE_LIST_BUILT_THIS_YEAR_LABEL = 5776,
        STR_RIDE_LIST_BUILT_X_YEARS_AGO_LABEL = 5778,
        STR_RIDE_LIST_CUSTOMERS_PER_HOUR = 5770,
        STR_RIDE_LIST_CUSTOMERS_PER_HOUR_LABEL = 5775,
        STR_RIDE_LIST_EXCITEMENT = 6462,
        STR_RIDE_LIST_INCOME = 5767,
        STR_RIDE_LIST_INCOME_LABEL = 5779,
        STR_RIDE_LIST_INFORMATION_TYPE_TIP = 1844,
        STR_RIDE_LIST_INTENSITY = 6464,
        STR_RIDE_LIST_NAUSEA = 6466,
        STR_RIDE_LIST_RIDETYPE = 7007,
        STR_RIDE_LIST_RUNNING_COST = 5771,
        STR_RIDE_LIST_RUNNING_COST_LABEL = 5780,
        STR_RIDE_LIST_RUNNING_COST_UNKNOWN = 5781,
        STR_RIDE_LIST_SORT_TIP = 2796,
        STR_RIDE_LIST_TOTAL_CUSTOMERS = 5768,
        STR_RIDE_LIST_TOTAL_CUSTOMERS_LABEL = 5773,
        STR_RIDE_LIST_TOTAL_PROFIT = 5769,
        STR_RIDE_LIST_TOTAL_PROFIT_LABEL = 5774,
        STR_SATISFACTION = 1828,
        STR_SATISFACTION_LABEL = 1838,
        STR_SATISFACTION_UNKNOWN_LABEL = 1837,
        STR_SHOPS_AND_STALLS = 975,
        STR_SORT = 2795,
        STR_STATUS = 1826,
        STR_TOILETS_AND_INFORMATION_KIOSKS = 976,

        // Window: SavePrompt
        STR_LOAD_GAME_PROMPT_TITLE = 950,
        STR_LOAD_LANDSCAPE_PROMPT_TITLE = 953,
        STR_QUIT_GAME_2_PROMPT_TITLE = 952,
        STR_QUIT_GAME_PROMPT_TITLE = 951,
        STR_SAVE_BEFORE_LOADING = 947,
        STR_SAVE_BEFORE_QUITTING = 948,
        STR_SAVE_BEFORE_QUITTING_2 = 949,
        STR_SAVE_PROMPT_DONT_SAVE = 945,
        STR_SAVE_PROMPT_SAVE = 944,

        // Window: ScenarioSelect
        STR_COMPLETED_BY = 2793,
        STR_COMPLETED_BY_WITH_COMPANY_VALUE = 2794,
        STR_OBJECTIVE = 3322,
        STR_SCENARIO_CATEGORY_EXTRAS_PARKS = 6519,
        STR_SCENARIO_CATEGORY_OTHER_PARKS = 5626,
        STR_SCENARIO_CATEGORY_RCT2 = 5622,
        STR_SCENARIO_CATEGORY_RCT2_TT = 5624,
        STR_SCENARIO_CATEGORY_RCT2_WW = 5623,
        STR_SCENARIO_CATEGORY_REAL_PARKS = 5625,
        STR_SCENARIO_CATEGORY_UCES = 6530,
        STR_SCENARIO_HOVER_HINT = 6518,
        STR_SCENARIO_LOCKED = 5783,
        STR_SCENARIO_LOCKED_DESC = 5784,
        STR_SELECT_SCENARIO = 2291,
        STR_SMALL_WINDOW_COLOUR_2_STRINGID = 5138,

        // Window: Scenery
        STR_ALL_SCENERY = 6547,
        STR_MISCELLANEOUS = 1813,
        STR_RESTRICT_SCENERY = 6621,
        STR_RESTRICT_SCENERY_TIP = 6622,
        STR_ROTATE_OBJECTS_90 = 1327,
        STR_SCENERY_AUTHOR = 6595,
        STR_SCENERY_AUTHOR_PLURAL = 6596,
        STR_SCENERY_CLUSTER_TIP = 3225,
        STR_SCENERY_EYEDROPPER_TIP = 6030,
        STR_SCENERY_PAINTBRUSH_TIP = 3102,
        STR_SELECT_COLOUR = 3099,
        STR_SELECT_SECONDARY_COLOUR = 3100,
        STR_SELECT_TERTIARY_COLOUR = 3101,

        // Window: SceneryScatter
        STR_SCATTER_TOOL_DENSITY = 6352,
        STR_SCATTER_TOOL_DENSITY_HIGH = 6355,
        STR_SCATTER_TOOL_DENSITY_LOW = 6353,
        STR_SCATTER_TOOL_DENSITY_MEDIUM = 6354,
        STR_SCENERY_SCATTER = 6350,

        // Window: ServerList
        STR_ADD_SERVER = 5500,
        STR_ADD_TO_FAVOURITES = 5572,
        STR_ENTER_HOSTNAME_OR_IP_ADDRESS = 5503,
        STR_FETCH_SERVERS = 5570,
        STR_JOIN_GAME = 5571,
        STR_NETWORK_VERSION = 5717,
        STR_NETWORK_VERSION_TIP = 5718,
        STR_PLAYER_NAME = 5499,
        STR_REMOVE_FROM_FAVOURITES = 5573,
        STR_SERVER_LIST_CONNECTING = 6148,
        STR_X_PLAYERS_ONLINE = 5787,

        // Window: ServerStart
        STR_ADVERTISE = 5567,
        STR_ADVERTISE_SERVER_TIP = 5805,
        STR_MAX_PLAYERS = 5575,
        STR_PASSWORD = 5566,
        STR_PORT = 5576,
        STR_SERVER_DESCRIPTION = 6031,
        STR_SERVER_GREETING = 6032,
        STR_SERVER_MAX_PLAYERS_VALUE = 5918,
        STR_SERVER_NAME = 5574,
        STR_START_SERVER = 5501,

        // Window: ShortcutKeys
        STR_RESET = 6580,
        STR_RESET_SHORTCUT_KEYS_PROMPT = 6581,
        STR_SHORTCUTS_TITLE = 2490,
        STR_SHORTCUT_ACTION_RESET_TIP = 2492,
        STR_SHORTCUT_CHANGE_PROMPT = 2785,
        STR_SHORTCUT_CHANGE_TITLE = 2784,
        STR_SHORTCUT_ENTRY_FORMAT = 2781,
        STR_SHORTCUT_LIST_TIP = 2786,
        STR_SHORTCUT_REMOVE = 6433,
        STR_SHORTCUT_REMOVE_TIP = 6434,

        // Window: Sign
        STR_CHANGE_SIGN_TEXT_TIP = 2994,
        STR_DEMOLISH_SIGN_TIP = 2995,
        STR_SIGN = 2991,
        STR_SIGN_TEXT_PROMPT = 2993,
        STR_SIGN_TEXT_TITLE = 2992,

        // Window: Staff
        STR_CLEAR_PATROL_AREA = 3446,
        STR_FIRE_STAFF_TIP = 1705,
        STR_FIX_RIDES = 1877,
        STR_INSPECT_RIDES = 1876,
        STR_NAME_STAFF_TIP = 1056,
        STR_SELECT_COSTUME_TIP = 1946,
        STR_SET_PATROL_TIP = 1708,
        STR_STAFF_OPTIONS_TIP = 1945,
        STR_STAFF_OPTION_EMPTY_LITTER = 1714,
        STR_STAFF_OPTION_MOW_GRASS = 1715,
        STR_STAFF_OPTION_SWEEP_FOOTPATHS = 1712,
        STR_STAFF_OPTION_WATER_GARDENS = 1713,
        STR_STAFF_OVERVIEW_TIP = 1939,
        STR_STAFF_PROMPT_ENTER_NAME = 2978,
        STR_STAFF_STATS_TIP = 2348,
        STR_STAFF_STAT_BINS_EMPTIED = 2354,
        STR_STAFF_STAT_EMPLOYED_FOR = 2350,
        STR_STAFF_STAT_GARDENS_WATERED = 2352,
        STR_STAFF_STAT_LAWNS_MOWN = 2351,
        STR_STAFF_STAT_LITTER_SWEPT = 2353,
        STR_STAFF_STAT_RIDES_FIXED = 2355,
        STR_STAFF_STAT_RIDES_INSPECTED = 2356,
        STR_STAFF_STAT_VANDALS_STOPPED = 6435,
        STR_STAFF_STAT_WAGES = 2349,
        STR_STAFF_TITLE_STAFF_MEMBER_NAME = 2977,

        // Window: StaffFirePrompt
        STR_FIRE_STAFF_ID = 1711,
        STR_SACK_STAFF = 1709,
        STR_YES = 1710,

        // Window: StaffList
        STR_COST_PER_MONTH = 1858,
        STR_ENTERTAINER_PLURAL = 1862,
        STR_ENTERTAINER_SINGULAR = 1866,
        STR_HANDYMAN_PLURAL = 1859,
        STR_HANDYMAN_SINGULAR = 1863,
        STR_HIRE_ENTERTAINER = 1703,
        STR_HIRE_HANDYMAN = 1700,
        STR_HIRE_MECHANIC = 1701,
        STR_HIRE_SECURITY_GUARD = 1702,
        STR_HIRE_STAFF_TIP = 1948,
        STR_MECHANIC_PLURAL = 1860,
        STR_MECHANIC_SINGULAR = 1864,
        STR_NO_THING_IN_PARK_YET = 1891,
        STR_QUICK_FIRE_STAFF = 5300,
        STR_SECURITY_GUARD_PLURAL = 1861,
        STR_SECURITY_GUARD_SINGULAR = 1865,
        STR_SHOW_PATROL_AREA_TIP = 1947,
        STR_SHOW_STAFF_ON_MAP_TIP = 2804,
        STR_STAFF = 1468,
        STR_STAFF_ENTERTAINERS_TAB_TIP = 2213,
        STR_STAFF_HANDYMEN_TAB_TIP = 2210,
        STR_STAFF_LIST_COUNTER = 1867,
        STR_STAFF_MECHANICS_TAB_TIP = 2211,
        STR_STAFF_SECURITY_TAB_TIP = 2212,
        STR_UNIFORM_COLOUR = 1791,
        STR_UNIFORM_COLOUR_TIP = 1790,

        // Window: Themes
        STR_THEMES_ACTION_DELETE_TIP = 5258,
        STR_THEMES_ACTION_DUPLICATE = 5239,
        STR_THEMES_ACTION_DUPLICATE_TIP = 5257,
        STR_THEMES_ACTION_RENAME_TIP = 5259,
        STR_THEMES_DESC_CANT_CHANGE_THIS_THEME = 5256,
        STR_THEMES_ERR_CANT_CHANGE_THIS_THEME = 5241,
        STR_THEMES_ERR_NAME_ALREADY_EXISTS = 5242,
        STR_THEMES_HEADER_PALETTE = 5237,
        STR_THEMES_HEADER_WINDOW = 5236,
        STR_THEMES_HEADER_TRANSPARENCY = 6673,
        STR_THEMES_OPTION_RCT1_BOTTOM_TOOLBAR = 6141,
        STR_THEMES_OPTION_RCT1_PARK_CONTROLS = 5283,
        STR_THEMES_OPTION_RCT1_RIDE_CONTROLS = 5282,
        STR_THEMES_OPTION_RCT1_SCENARIO_SELECTION_FONT = 5284,
        STR_THEMES_OPTION_USE_3D_IMAGE_BUTTONS = 7006,
        STR_THEMES_PROMPT_ENTER_THEME_NAME = 5240,
        STR_THEMES_TAB_EDITORS_TIP = 5232,
        STR_THEMES_TAB_FEATURES_TIP = 5281,
        STR_THEMES_TAB_MAIN_TIP = 5228,
        STR_THEMES_TAB_MISC_TIP = 5233,
        STR_THEMES_TAB_PARK_TIP = 5229,
        STR_THEMES_TAB_PROMPTS_TIP = 5234,
        STR_THEMES_TAB_RIDES_AND_GUESTS_TIP = 5231,
        STR_THEMES_TAB_SETTINGS_TIP = 5235,
        STR_THEMES_TAB_TOOLS_TIP = 5230,
        STR_THEMES_TITLE = 5244,
        STR_THEMES_WINDOW_BANNER = 5209,
        STR_THEMES_WINDOW_BOTTOM_TOOLBAR = 5246,
        STR_THEMES_WINDOW_BOTTOM_TOOLBAR_SCENARIO_EDITOR = 5248,
        STR_THEMES_WINDOW_BOTTOM_TOOLBAR_TRACK_EDITOR = 5247,
        STR_THEMES_WINDOW_CHANGE_KEYBOARD_SHORTCUT = 5221,
        STR_THEMES_WINDOW_CLEAR_SCENERY = 5195,
        STR_THEMES_WINDOW_CONSTRUCT_RIDE = 5201,
        STR_THEMES_WINDOW_DEMOLISH_RIDE_PROMPT = 5224,
        STR_THEMES_WINDOW_EDITOR_INVENTION_LIST = 5211,
        STR_THEMES_WINDOW_EDITOR_OBJECT_SELECTION = 5210,
        STR_THEMES_WINDOW_EDITOR_SCENARIO_OPTIONS = 5212,
        STR_THEMES_WINDOW_EDITOR_OBJECTIVE_OPTIONS = 5213,
        STR_THEMES_WINDOW_ERROR = 6652,
        STR_THEMES_WINDOW_FINANCES = 5187,
        STR_THEMES_WINDOW_FIRE_PROMPT = 5225,
        STR_THEMES_WINDOW_FOOTPATH = 5198,
        STR_THEMES_WINDOW_GUEST_LIST = 5206,
        STR_THEMES_WINDOW_INSTALL_TRACK = 5216,
        STR_THEMES_WINDOW_KEYBOARD_SHORTCUT_LIST = 5220,
        STR_THEMES_WINDOW_LAND = 5193,
        STR_THEMES_WINDOW_LAND_RIGHTS = 5196,
        STR_THEMES_WINDOW_LOADSAVE = 5222,
        STR_THEMES_WINDOW_LOADSAVE_OVERWRITE_PROMPT = 5227,
        STR_THEMES_WINDOW_MANAGE_TRACK_DESIGN = 5215,
        STR_THEMES_WINDOW_MAP = 5190,
        STR_THEMES_WINDOW_MAPGEN = 5214,
        STR_THEMES_WINDOW_NETWORK_STATUS = 5735,
        STR_THEMES_WINDOW_NEW_CAMPAIGN = 5188,
        STR_THEMES_WINDOW_OPTIONS = 5219,
        STR_THEMES_WINDOW_PARK_INFORMATION = 5253,
        STR_THEMES_WINDOW_PEEP = 5205,
        STR_THEMES_WINDOW_PLAYER = 5736,
        STR_THEMES_WINDOW_RECENT_NEWS = 5192,
        STR_THEMES_WINDOW_RESEARCH = 5189,
        STR_THEMES_WINDOW_RIDE = 5203,
        STR_THEMES_WINDOW_RIDE_CONSTRUCTION = 5199,
        STR_THEMES_WINDOW_RIDE_LIST = 5204,
        STR_THEMES_WINDOW_SAVE_PROMPT = 5223,
        STR_THEMES_WINDOW_SCENERY = 5197,
        STR_THEMES_WINDOW_SCENERY_SCATTER = 6351,
        STR_THEMES_WINDOW_STAFF = 5207,
        STR_THEMES_WINDOW_STAFF_LIST = 5208,
        STR_THEMES_WINDOW_THEMES = 5218,
        STR_THEMES_WINDOW_TITLE_MENU_BUTTONS = 5249,
        STR_THEMES_WINDOW_TITLE_MENU_EXIT = 5250,
        STR_THEMES_WINDOW_TITLE_MENU_OPTIONS = 5251,
        STR_THEMES_WINDOW_TITLE_MENU_SCENARIO_SELECTION = 5252,
        STR_THEMES_WINDOW_TOP_TOOLBAR = 5245,
        STR_THEMES_WINDOW_TRACK_DELETE_PROMPT = 5226,
        STR_THEMES_WINDOW_TRACK_DESIGN_LIST = 5202,
        STR_THEMES_WINDOW_TRACK_DESIGN_PLACE = 5200,
        STR_THEMES_WINDOW_VIEWPORT = 5191,
        STR_THEMES_WINDOW_WATER = 5194,

        // Window: TileInspector
        STR_MOVE_SELECTED_ELEMENT_DOWN_TIP = 5618,
        STR_MOVE_SELECTED_ELEMENT_UP_TIP = 5617,
        STR_REMOVE_SELECTED_ELEMENT_TIP = 5610,
        STR_ROTATE_SELECTED_ELEMENT_TIP = 5803,
        STR_TILE_INSPECTOR_BANNER_BLOCKED_PATHS = 5984,
        STR_TILE_INSPECTOR_BASE_HEIGHT = 5339,
        STR_TILE_INSPECTOR_BASE_HEIGHT_FULL = 5941,
        STR_TILE_INSPECTOR_BASE_HEIGHT_SHORT = 5608,
        STR_TILE_INSPECTOR_CLEARANCE_HEIGHT = 5340,
        STR_TILE_INSPECTOR_CLEARANGE_HEIGHT_SHORT = 5609,
        STR_TILE_INSPECTOR_COLLISSION = 5962,
        STR_TILE_INSPECTOR_COLOUR_SCHEME = 6307,
        STR_TILE_INSPECTOR_COPY_TIP = 5993,
        STR_TILE_INSPECTOR_DIRECTION = 6461,
        STR_TILE_INSPECTOR_DIRECTION_SHORT = 6460,
        STR_TILE_INSPECTOR_ELEMENT_TYPE = 5338,
        STR_TILE_INSPECTOR_ENTRANCE_ENTRANCE_ID = 5970,
        STR_TILE_INSPECTOR_ENTRANCE_EXIT_ID = 5971,
        STR_TILE_INSPECTOR_ENTRANCE_LEFT = 5968,
        STR_TILE_INSPECTOR_ENTRANCE_MAKE_USABLE = 6220,
        STR_TILE_INSPECTOR_ENTRANCE_MAKE_USABLE_TIP = 6221,
        STR_TILE_INSPECTOR_ENTRANCE_MIDDLE = 5967,
        STR_TILE_INSPECTOR_ENTRANCE_PART = 5966,
        STR_TILE_INSPECTOR_ENTRANCE_RIDE_ID = 5972,
        STR_TILE_INSPECTOR_ENTRANCE_RIGHT = 5969,
        STR_TILE_INSPECTOR_ENTRANCE_TYPE = 5965,
        STR_TILE_INSPECTOR_ENTRANCE_TYPE_PARK_ENTRANC = 5337,
        STR_TILE_INSPECTOR_ENTRANCE_TYPE_RIDE_ENTRANCE = 5335,
        STR_TILE_INSPECTOR_ENTRANCE_TYPE_RIDE_EXIT = 5336,
        STR_TILE_INSPECTOR_ENTRY_BANNER_NONE = 5981,
        STR_TILE_INSPECTOR_ENTRY_BANNER_TEXT = 5980,
        STR_TILE_INSPECTOR_FLAG_GHOST = 5612,
        STR_TILE_INSPECTOR_FLAG_GHOST_SHORT = 5611,
        STR_TILE_INSPECTOR_FLAG_INVISIBLE = 6437,
        STR_TILE_INSPECTOR_FLAG_LAST = 5616,
        STR_TILE_INSPECTOR_FLAG_LAST_SHORT = 5615,
        STR_TILE_INSPECTOR_FOOTPATH_RAILINGS_NAME = 6447,
        STR_TILE_INSPECTOR_FOOTPATH_SURFACE_NAME = 6446,
        STR_TILE_INSPECTOR_GROUPBOX_BANNER_INFO = 5931,
        STR_TILE_INSPECTOR_GROUPBOX_ENTRANCE_INFO = 5928,
        STR_TILE_INSPECTOR_GROUPBOX_PATH_INFO = 5925,
        STR_TILE_INSPECTOR_GROUPBOX_PROPERTIES = 5933,
        STR_TILE_INSPECTOR_GROUPBOX_SCENERY_INFO = 5927,
        STR_TILE_INSPECTOR_GROUPBOX_SURFACE_INFO = 5924,
        STR_TILE_INSPECTOR_GROUPBOX_TRACK_INFO = 5926,
        STR_TILE_INSPECTOR_GROUPBOX_WALL_INFO = 5929,
        STR_TILE_INSPECTOR_INVISIBLE_SHORT = 6438,
        STR_TILE_INSPECTOR_LAND_NOT_OWNED_AND_NOT_AVAILABLE = 5937,
        STR_TILE_INSPECTOR_LARGE_SCENERY_PIECE_ID = 5983,
        STR_TILE_INSPECTOR_LARGE_SCENERY_TYPE = 5982,
        STR_TILE_INSPECTOR_PASTE_TIP = 5994,
        STR_TILE_INSPECTOR_PATH_ADDITIONS = 5943,
        STR_TILE_INSPECTOR_PATH_ADDITIONS_NONE = 5944,
        STR_TILE_INSPECTOR_PATH_BROKEN = 6321,
        STR_TILE_INSPECTOR_PATH_CONNECTED_EDGES = 5945,
        STR_TILE_INSPECTOR_PATH_JUNCTION_RAILINGS = 6548,
        STR_TILE_INSPECTOR_PATH_NAME = 5942,
        STR_TILE_INSPECTOR_PATH_SLOPED = 6015,
        STR_TILE_INSPECTOR_SCENERY_AGE = 5954,
        STR_TILE_INSPECTOR_SCENERY_ENTRY_IDX = 5961,
        STR_TILE_INSPECTOR_SCENERY_QUADRANT = 5955,
        STR_TILE_INSPECTOR_SCENERY_QUADRANT_LABEL = 5960,
        STR_TILE_INSPECTOR_SCENERY_QUADRANT_NE = 5958,
        STR_TILE_INSPECTOR_SCENERY_QUADRANT_NW = 5957,
        STR_TILE_INSPECTOR_SCENERY_QUADRANT_SE = 5959,
        STR_TILE_INSPECTOR_SCENERY_QUADRANT_SW = 5956,
        STR_TILE_INSPECTOR_SELECT_TILE_HINT = 6497,
        STR_TILE_INSPECTOR_SORT_TIP = 5953,
        STR_TILE_INSPECTOR_STATION_INDEX = 6277,
        STR_TILE_INSPECTOR_SURFACE = 6191,
        STR_TILE_INSPECTOR_SURFACE_CORNERS = 5963,
        STR_TILE_INSPECTOR_SURFACE_DIAGONAL = 5964,
        STR_TILE_INSPECTOR_SURFACE_EDGE = 5935,
        STR_TILE_INSPECTOR_SURFACE_OWNERSHIP = 5936,
        STR_TILE_INSPECTOR_SURFACE_REMOVE_FENCES = 5939,
        STR_TILE_INSPECTOR_SURFACE_RESTORE_FENCES = 5940,
        STR_TILE_INSPECTOR_SURFACE_TERAIN = 5934,
        STR_TILE_INSPECTOR_SURFACE_WATER_LEVEL = 5938,
        STR_TILE_INSPECTOR_TITLE = 5314,
        STR_TILE_INSPECTOR_TRACK_BLOCK_BRAKE = 6319,
        STR_TILE_INSPECTOR_TRACK_BRAKE_CLOSED = 6539,
        STR_TILE_INSPECTOR_TRACK_CHAIN_LIFT = 5949,
        STR_TILE_INSPECTOR_TRACK_ENTIRE_TRACK_PIECE = 5950,
        STR_TILE_INSPECTOR_TRACK_IS_INDESTRUCTIBLE = 6320,
        STR_TILE_INSPECTOR_TRACK_PIECE_ID = 5951,
        STR_TILE_INSPECTOR_TRACK_RIDE_ID = 5947,
        STR_TILE_INSPECTOR_TRACK_RIDE_NAME = 5948,
        STR_TILE_INSPECTOR_TRACK_RIDE_TYPE = 5946,
        STR_TILE_INSPECTOR_TRACK_SEQUENCE = 5952,
        STR_TILE_INSPECTOR_WALL = 6192,
        STR_TILE_INSPECTOR_WALL_ANIMATION_FRAME = 6367,
        STR_TILE_INSPECTOR_WALL_ANIMATION_IS_BACKWARDS = 6626,
        STR_TILE_INSPECTOR_WALL_FLAT = 5976,
        STR_TILE_INSPECTOR_WALL_SLOPE = 5975,
        STR_TILE_INSPECTOR_WALL_SLOPED_LEFT = 5977,
        STR_TILE_INSPECTOR_WALL_SLOPED_RIGHT = 5978,
        STR_TILE_INSPECTOR_WALL_TYPE = 5979,
        STR_TILE_INSPECTOR_X_LABEL = 6725,
        STR_TILE_INSPECTOR_Y_LABEL = 6726,

        // Window: TitleExit
        STR_EXIT = 1924,

        // Window: TitleMenu
        STR_CONTINUE_SAVED_GAME_TIP = 1922,
        STR_CONVERT_SAVED_GAME_TO_SCENARIO = 3343,
        STR_GAME_TOOLS_TIP = 3341,
        STR_OPEN_USER_CONTENT_FOLDER = 6266,
        STR_ROLLER_COASTER_DESIGNER = 3344,
        STR_SCENARIO_EDITOR = 3342,
        STR_SHOW_MULTIPLAYER_TIP = 5588,
        STR_START_NEW_GAME_TIP = 1921,
        STR_TRACK_DESIGNS_MANAGER = 3345,
        STR_UPDATE_AVAILABLE = 6380,

        // Window: TitleOptions
        STR_OPTIONS = 2327,
        STR_OPTIONS_TIP = 5857,

        // Window: Tooltip
        STR_STRING_TOOLTIP = 6034,

        // Window: TopToolbar
        STR_ADJUST_LAND_TIP = 938,
        STR_ADJUST_WATER_TIP = 1160,
        STR_BUILD_FOOTPATH_TIP = 1173,
        STR_BUILD_RIDE_TIP = 1895,
        STR_CHAT_UNAVAILABLE = 6283,
        STR_CHEATS_MENU_OBJECTIVE_OPTIONS = 6393,
        STR_CHEATS_TIP = 5149,
        STR_CLEAR_SCENERY_TIP = 3437,
        STR_DEBUG_DROPDOWN_CONSOLE = 5312,
        STR_DEBUG_DROPDOWN_DEBUG_PAINT = 5903,
        STR_DEBUG_DROPDOWN_INVENTIONS_LIST = 5491,
        STR_DEBUG_DROPDOWN_OBJECT_SELECTION = 5371,
        STR_DEBUG_DROPDOWN_SCENARIO_OPTIONS = 5492,
        STR_DEBUG_DROPDOWN_TILE_INSPECTOR = 5313,
        STR_DEBUG_TIP = 5311,
        STR_DISC_AND_GAME_OPTIONS_TIP = 834,
        STR_ENABLE_SANDBOX_MODE = 5455,
        STR_EXIT_OPENRCT2 = 5159,
        STR_EXTRA_VIEWPORT = 2780,
        STR_FILE_BUG_ON_GITHUB = 6457,
        STR_GAME_SPEED_TIP = 5148,
        STR_GIANT_SCREENSHOT = 5260,
        STR_GUESTS_TIP = 1693,
        STR_HEIGHT_MARKS_ON_LAND = 1154,
        STR_HEIGHT_MARKS_ON_PATHS = 1155,
        STR_HEIGHT_MARKS_ON_RIDE_TRACKS = 1153,
        STR_HIGHLIGHT_PATH_ISSUES_MENU = 6219,
        STR_LOAD_LANDSCAPE = 884,
        STR_MAPGEN_MENU_ITEM = 2690,
        STR_MULTIPLAYER_RECONNECT = 6309,
        STR_NEW_GAME = 5715,
        STR_OVERLAY_CLEARANCE_CHECKS_DISABLED = 6374,
        STR_PARK_INFORMATION_TIP = 2233,
        STR_PAUSE_GAME_TIP = 833,
        STR_PLACE_SCENERY_TIP = 1159,
        STR_QUIT_ROLLERCOASTER_DESIGNER = 888,
        STR_QUIT_SCENARIO_EDITOR = 887,
        STR_QUIT_TO_MENU = 5158,
        STR_QUIT_TRACK_DESIGNS_MANAGER = 889,
        STR_REMOVE_BASE_LAND = 940,
        STR_REMOVE_VERTICAL_FACES = 941,
        STR_RIDES_IN_PARK_TIP = 1053,
        STR_ROTATE_ANTI_CLOCKWISE = 5459,
        STR_ROTATE_CLOCKWISE = 5458,
        STR_ROTATE_90_TIP = 1404,
        STR_ROTATE_TIP = 832,
        STR_SAVE_GAME_AS = 5512,
        STR_SAVE_LANDSCAPE = 885,
        STR_SCREENSHOT = 891,
        STR_SEE_THROUGH_GUESTS = 6474,
        STR_SEE_THROUGH_PATHS = 5911,
        STR_SEE_THROUGH_RIDES = 942,
        STR_SEE_THROUGH_SCENERY = 943,
        STR_SEE_THROUGH_STAFF = 6475,
        STR_SEE_THROUGH_SUPPORTS = 6473,
        STR_SEE_THROUGH_VEGETATION = 6471,
        STR_SEE_THROUGH_VEHICLES = 6472,
        STR_SHOW_MAP_TIP = 2805,
        STR_SHOW_MULTIPLAYER_STATUS_TIP = 5504,
        STR_SHOW_RECENT_MESSAGES_TIP = 5487,
        STR_SPEED_FAST = 5144,
        STR_SPEED_HYPER = 5146,
        STR_SPEED_NORMAL = 5142,
        STR_SPEED_QUICK = 5143,
        STR_SPEED_TURBO = 5145,
        STR_STAFF_TIP = 1694,
        STR_TOOLBAR_CHAT_TIP = 6280,
        STR_TOOLBAR_MUTE_TIP = 6056,
        STR_TRANSPARENCY_OPTIONS = 6481,
        STR_UNDERGROUND_VIEW = 939,
        STR_VIEW_CLIPPING_MENU = 6003,
        STR_VIEW_OPTIONS_TIP = 937,

        // Window: TrackDesignManage
        STR_ANOTHER_FILE_EXISTS_WITH_NAME_OR_FILE_IS_WRITE_PROTECTED = 3354,
        STR_ARE_YOU_SURE_YOU_WANT_TO_PERMANENTLY_DELETE_TRACK = 3357,
        STR_CANT_DELETE_TRACK_DESIGN = 3358,
        STR_CANT_RENAME_TRACK_DESIGN = 3352,
        STR_DELETE_FILE = 3356,
        STR_FILE_IS_WRITE_PROTECTED_OR_LOCKED = 3355,
        STR_NEW_NAME_CONTAINS_INVALID_CHARACTERS = 3353,
        STR_TRACK_DESIGN_RENAME_DESC = 3351,
        STR_TRACK_DESIGN_RENAME_TITLE = 3350,
        STR_TRACK_MANAGE_DELETE = 3349,
        STR_TRACK_MANAGE_RENAME = 3348,

        // Window: TrackDesignPlace
        STR_GO_BACK_TO_DESIGN_SELECTION_WINDOW_TIP = 3114,
        STR_MIRROR_IMAGE_TIP = 1405,
        STR_SELECT_A_DIFFERENT_DESIGN = 3113,

        // Window: TrackList
        STR_BUILD_CUSTOM_DESIGN = 2310,
        STR_CLICK_ON_DESIGN_TO_BUILD_IT_TIP = 3111,
        STR_CLICK_ON_DESIGN_TO_RENAME_OR_DELETE_IT = 3112,
        STR_NO_TRACK_DESIGNS_OF_THIS_TYPE = 3359,
        STR_SELECT_DESIGN = 2307,
        STR_SELECT_OTHER_RIDE = 5453,
        STR_THIS_DESIGN_WILL_BE_BUILT_WITH_AN_ALTERNATIVE_VEHICLE_TYPE = 3136,
        STR_TRACK_DESIGNS = 2308,
        STR_TRACK_LIST_COST_AROUND = 2315,
        STR_TRACK_LIST_EXCITEMENT_RATING = 2311,
        STR_TRACK_LIST_INTENSITY_RATING = 2312,
        STR_TRACK_LIST_NAME_FORMAT = 5813,
        STR_TRACK_LIST_NAUSEA_RATING = 2313,
        STR_TRACK_LIST_RIDE_LENGTH = 2314,
        STR_TRACK_LIST_SPACE_REQUIRED = 2316,
        STR_TRACK_LOAD_FAILED_ERROR = 5898,
        STR_TRACK_PREVIEW_NAME_FORMAT = 5814,
        STR_VEHICLE_DESIGN_UNAVAILABLE = 3135,

        // Window: Transparency
        STR_INVISIBLE_PATHS = 6478,
        STR_INVISIBLE_RIDES = 6479,
        STR_INVISIBLE_SCENERY = 6477,
        STR_INVISIBLE_SUPPORTS = 1051,
        STR_INVISIBLE_VEGETATION = 6476,
        STR_INVISIBLE_VEHICLES = 6480,

        // Window: ViewClipping
        STR_UNIT1DP_NO_SUFFIX = 6012,
        STR_UNIT1DP_SUFFIX_FEET = 6011,
        STR_UNIT2DP_SUFFIX_METRES = 6010,
        STR_VIEW_CLIPPING_CLEAR_SELECTION = 6242,
        STR_VIEW_CLIPPING_HEIGHT_ENABLE = 6005,
        STR_VIEW_CLIPPING_HEIGHT_ENABLE_TIP = 6006,
        STR_VIEW_CLIPPING_HEIGHT_SCROLL_TIP = 6009,
        STR_VIEW_CLIPPING_HEIGHT_VALUE = 6007,
        STR_VIEW_CLIPPING_HEIGHT_VALUE_TOGGLE = 6008,
        STR_VIEW_CLIPPING_HORIZONTAL_CLIPPING = 6240,
        STR_VIEW_CLIPPING_SELECT_AREA = 6241,
        STR_VIEW_CLIPPING_VERTICAL_CLIPPING = 6239,
        STR_VIEW_CLIPPING_VERTICAL_CLIPPING_SEE_THROUGH = 6733,
        STR_VIEW_CLIPPING_VERTICAL_CLIPPING_SEE_THROUGH_TIP = 6734,

        // Window: Viewport
        STR_LOCATE_SUBJECT_TIP = 1027,
        STR_VIEWPORT_NO = 2779,
        STR_ZOOM_IN_TIP = 830,
        STR_ZOOM_OUT_TIP = 831,

        // Window: Water
        STR_ADJUST_LARGER_WATER_TIP = 2381,
        STR_ADJUST_SMALLER_WATER_TIP = 2380,
        STR_WATER = 2383,
    };
} // namespace OpenRCT2
