# Prettier Website

https://prettier.io/

## Getting started

1. Build the Prettier browser libs for the Playground by running the following in the project root directory:

   ```sh
   cd your/path/to/prettier
   yarn build:website
   ```

   To build for the current branch, use `yarn build:website:pr`. Otherwise, a release version of Prettier from `node_modules` is used.

2. Switch to the `website` directory and start the development server:

   ```sh
   cd website
   yarn start
   ```

   This starts a server hosting the website locally at `http://localhost:3000/`. Any changes to the site's source files are reflected after refreshing the page, i.e. the server does not need to be restarted to show changes.

   When working on the docs, you need to go to `http://localhost:3000/docs/next/index.html` (note “next”) to see your changes.

## Docusaurus

The site is built on [Docusaurus](https://docusaurus.io/), a static site generator for documentation sites.

Its main configuration file is `docusaurus.config.js` ([docs](https://docusaurus.io/docs/configuration)).

Pages can be added to the site by putting `.jsx` files with React components in `src/pages/`. It’s also possible to include `.md` files directly. ([docs](https://docusaurus.io/docs/creating-pages))

Images and other static assets are placed inside the `static` directory: `static/img/your-image.png` is mapped to `http://prettier.io/img/your-image.png`. Any `.css` files in `static/` are concatenated to the standard styles provided by Docusaurus and used site-wide.

## Playground

The Playground is not integrated with the Docusaurus infrastructure. Its UI (`website/playground/`) is built separately with webpack configured to put the resulting bundle in Docusaurus’s `static` directory. The `yarn start` command (in `website/`) concurrently starts both Docusaurus’s local server and webpack in the watch mode for the Playground.

The entry point of the playground is at `static/playground/index.html`.

Another part of the Playground is a web worker where formatting happens. It’s not managed by webpack and resides directly in `static/worker.mjs`. It expects to find the [UMD bundles of Prettier](https://prettier.io/docs/browser) in `static/lib/`. That’s why running `yarn build:website` or `PULL_REQUEST=true yarn build:website` in the project root is a required step.

Finally, there is a service worker that caches Prettier’s relatively heavy bundles (`static/service-worker.mjs`).

## Documentation

In the project repo, the `docs` directory is used to hold documentation written in Markdown.
The front matter of documentation files should follow this example:

```yaml
id: doc1 # used for docs to find each other and to map links
title: Document Title
layout: docs1 # used to determine different sidebar groupings
category: Sidebar Category 1 # Category on the sidebar under which this doc goes
permalink: docs/doc1.html # link to the document that is used for site
previous: doc0 # previous doc on sidebar for navigation
next: doc2 # next doc on the sidebar for navigation
# don’t include next if this is the last doc; don’t include previous if first doc
---
```

The docs from `docs/` are published to `https://prettier.io/docs/next/` and are considered to be the docs of the next (not yet released) version of Prettier. When a release happens, the docs from `docs/` are copied to the `website/versioned_docs/version-stable` directory, whose content is published to `https://prettier.io/docs/`.

## Blog

The `website/blog` directory contains blog posts written in Markdown. Their front matter should follow this example:

```yaml
title: Blog Post Title
authors: author declared in `blog/authors.yml`
---
```

In the blog post, you should include a line `<!-- truncate -->`. This determines under which point text will be ignored when generating the preview of your blog post. Blog posts should have the file name format: `yyyy-mm-dd-your-file-name.md`.

## Static Build

To create a static build of the website, run `yarn build` (in `website/`). The result will be put in `website/build/`.
