---
authors: "sosukesuzuki"
title: "Prettier 2.5: TypeScript 4.5 and MDX v2 comment syntax!"
---

This release adds support for [TypeScript 4.5](https://devblogs.microsoft.com/typescript/announcing-typescript-4-5/)'s new syntax and [MDX v2](https://mdxjs.com/blog/v2/) comment syntax!

If you enjoy Prettier and would like to support our work, consider sponsoring us directly via [our OpenCollective](https://opencollective.com/prettier) or by sponsoring the projects we depend on, including [typescript-eslint](https://opencollective.com/typescript-eslint), [remark](https://opencollective.com/unified), and [Babel](https://opencollective.com/babel).

<!-- truncate -->

## Highlights

### TypeScript

#### Avoid extra offset in arrow function body when using long types ([#11515](https://github.com/prettier/prettier/pull/11515) by [@kachkaev](https://github.com/kachkaev) and [@thorn0](https://github.com/thorn0))

Starting with Prettier 2.3.0, type declarations in arrow functions could affect function body indentation. Changing the length of the type annotation could produce large diffs and thus increased the chance of git conflicts. To prevent this, function body offset was stabilized.<br />
**Note**: This change may affect a large number of lines in your codebase.

<!-- prettier-ignore -->
```tsx
// Input
const MyComponentWithLongName: React.VoidFunctionComponent<MyComponentWithLongNameProps> = ({ x, y }) => {
  const a = useA();
  return <div>{x + y + a}</div>;
};

// Prettier 2.2 and below
const MyComponentWithLongName: React.VoidFunctionComponent<MyComponentWithLongNameProps> = ({
  x,
  y,
}) => {
  const a = useA();
  return <div>{x + y + a}</div>;
};

// Prettier 2.4
const MyComponentWithLongName: React.VoidFunctionComponent<MyComponentWithLongNameProps> =
  ({ x, y }) => {
    const a = useA();
    return <div>{x + y + a}</div>;
  };

// Prettier 2.5
const MyComponentWithLongName: React.VoidFunctionComponent<
  MyComponentWithLongNameProps
> = ({ x, y }) => {
  const a = useA();
  return <div>{x + y + a}</div>;
};
```

#### Support TypeScript 4.5 ([#11721](https://github.com/prettier/prettier/pull/11721), [#11723](https://github.com/prettier/prettier/pull/11723), [#11813](https://github.com/prettier/prettier/pull/11813) by [@sosukesuzuki](https://github.com/sosukesuzuki))

We’ve added support for TypeScript 4.5’s new syntax features:

##### [`type` Modifiers on Import Names](https://devblogs.microsoft.com/typescript/announcing-typescript-4-5/#type-on-import-names)

<!-- prettier-ignore -->
```ts
// Example
import { type A } from "mod";

```

##### [Private Field Presence Checks](https://devblogs.microsoft.com/typescript/announcing-typescript-4-5/#private-field-presence-checks)

<!-- prettier-ignore -->
```ts
// Example
class Foo {
  #prop1;
  method() {
    return #prop1 in this;
  }
}

```

##### [Import Assertions](https://devblogs.microsoft.com/typescript/announcing-typescript-4-5/#import-assertions)

<!-- prettier-ignore -->
```ts
// Example
import obj from "./something.json" assert { type: "json" };

```

##### Handle `.mts` and `.cts`

Prettier will now format files with `.mts` and `.cts` extensions as TypeScript.

### HTML

#### Collapse HTML `class` attributes onto one line ([#11827](https://github.com/prettier/prettier/pull/11827) by [@jlongster](https://github.com/jlongster))

Reverts [#7865](https://github.com/prettier/prettier/pull/7865).

While this was intended to be useful for users of CSS libraries like Tailwind that tend to result in large numbers of classes on elements, it became clear that our heuristics for where to split the class list on to multiple lines were unable to consistently produce good results. We’re still considering better ways to format HTML with lots of classes — consider [discussing with us](https://github.com/prettier/prettier/issues/7863).

<!-- prettier-ignore -->
```html
<!-- Input -->
<div
  class="SomeComponent__heading-row d-flex flex-column flex-lg-row justify-content-start justify-content-lg-between align-items-start align-items-lg-center"
></div>

<!-- Prettier 2.4 -->
<div
  class="
    SomeComponent__heading-row
    d-flex
    flex-column flex-lg-row
    justify-content-start justify-content-lg-between
    align-items-start align-items-lg-center
  "
></div>

<!-- Prettier 2.5 -->
<div
  class="SomeComponent__heading-row d-flex flex-column flex-lg-row justify-content-start justify-content-lg-between align-items-start align-items-lg-center"
></div>

```

### MDX

#### Add support for MDX v2 comment syntax ([#11563](https://github.com/prettier/prettier/pull/11563) by [@wooorm](https://github.com/wooorm))

This adds basic support for MDX v2 comment syntax (JavaScript-style comments) in addition to the existing support MDX v1 comment syntax (HTML-style comments).

**Note**: Prettier currently only supports the new comment syntax for single-line comments (so that `{/* prettier-ignore */}` can be used), and doesn’t support the rest of MDX v2.

<!-- prettier-ignore -->
```mdx
Input:
{/*A comment*/}

Prettier 2.4:
{/_A comment_/}

Prettier 2.5:
{/*A comment*/}
```

## Other Changes

### JavaScript

#### Fix parentheses around sequence expression as body of arrow chain ([#11593](https://github.com/prettier/prettier/pull/11593) by [@bakkot](https://github.com/bakkot))

The required parentheses around sequence expressions as the body of arrow functions are now preserved for chained arrows. Previously, Prettier removed them, which resulted in invalid syntax.

<!-- prettier-ignore -->
```jsx
// Input
const f = () => () => (0, 1);

// Prettier 2.4
const f = () => () => 0, 1;

// Prettier 2.5
const f = () => () => (0, 1);
```

#### Ignore errors for sloppy mode syntax ([#11750](https://github.com/prettier/prettier/pull/11750) by [@fisker](https://github.com/fisker), [#11778](https://github.com/prettier/prettier/pull/11778) by [@sosukesuzuki](https://github.com/sosukesuzuki))

JavaScript’s [strict mode](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Strict_mode) adds several useful errors to prevent mistakes. Some of these errors are syntax errors that occur at parse time. Since Prettier’s goal is to format all syntactically valid JavaScript code regardless of whether it will actually run, we’ve opted to leave this error checking to linters, compilers, and the runtime.

<!-- prettier-ignore -->
```jsx
// Input
function foo() { var bar = 1; delete bar; }

// Prettier 2.4
SyntaxError: Deleting local variable in strict mode. (1:31)
> 1 | function foo() { var bar = 1; delete bar; }
    |                               ^

// Prettier 2.5
function foo() {
  var bar = 1;
  delete bar;
}
```

#### Respect spacing for between expressions and parentheses in embedded CSS ([#11800](https://github.com/prettier/prettier/pull/11800) by [@sosukesuzuki](https://github.com/sosukesuzuki))

<!-- prettier-ignore -->
```jsx
// Input
const paragraph2 = css`
  transform1: ${expr}(30px);
  transform2: ${expr} (30px);
`;

// Prettier 2.4
const paragraph2 = css`
  transform1: ${expr} (30px);
  transform2: ${expr} (30px);
`;

// Prettier 2.5
const paragraph2 = css`
  transform1: ${expr}(30px);
  transform2: ${expr} (30px);
`;

```

#### Support ES2022 class-private-fields-in syntax in `espree` parser ([#11835](https://github.com/prettier/prettier/pull/11835) by [@fisker](https://github.com/fisker))

<!-- prettier-ignore -->
```jsx
// Example
class Foo {
  #brand;
  static isC(obj) {
    return #brand in Foo;
  }
}

```

### TypeScript

#### Remove unnecessary parentheses for decorators ([#11717](https://github.com/prettier/prettier/pull/11717), [#11849](https://github.com/prettier/prettier/pull/11849) by [@sosukesuzuki](https://github.com/sosukesuzuki))

<!-- prettier-ignore -->
```tsx
// Input
class Test {
  @foo`bar`
  test1: string = "test"

  @test().x("global").y()
  test2: string = "test";
}

// Prettier 2.4
class Test {
  @(foo`bar`)
  test: string = "test"

  @(test().x("global").y())
  test2: string = "test";
}

// Prettier 2.5
class Test {
  @foo`bar`
  test: string = "test"

  @test().x("global").y()
  test2: string = "test";
}
```

### SCSS

#### Improve `@use with` formatting ([#11637](https://github.com/prettier/prettier/pull/11637) by [@sosukesuzuki](https://github.com/sosukesuzuki))

<!-- prettier-ignore -->
```scss
// Input
@use 'library' with (
  $black: #222,
  $border-radius: 0.1rem,
  $font-family: 'Helvetica, sans-serif'
);

// Prettier 2.4
@use "library" with
  ($black: #222, $border-radius: 0.1rem, $font-family: "Helvetica, sans-serif");

// Prettier 2.5
@use 'library' with (
  $black: #222,
  $border-radius: 0.1rem,
  $font-family: 'Helvetica, sans-serif'
);

```

#### Fix `@forward with` formatting error ([#11683](https://github.com/prettier/prettier/pull/11683) by [@sriramarul](https://github.com/sriramarul), [@sosukesuzuki](https://github.com/sosukesuzuki))

<!-- prettier-ignore -->
```scss
// Input
@forward 'foo.scss' with ($components: red);

// Prettier 2.4
TypeError: Cannot read properties of undefined (reading 'type')

// Prettier 2.5
@forward "foo.scss" with (
  $components: red
);

```

### Ember / Handlebars

#### Uses the opposite quote type for quotes inside mustache statements in attributes ([#11524](https://github.com/prettier/prettier/pull/11524) by [@bmaehr](https://github.com/bmaehr))

<!-- prettier-ignore -->
```hbs
{{!-- Input --}}
<div title="{{t 'login.username.description'}}" />

{{!-- Prettier 2.5 --}}
<div title="{{t 'login.username.description'}}" />

{{!-- Prettier 2.4 --}}
<div title="{{t "login.username.description"}}" />

```

### Markdown

#### Keep trailing commas for type parameters in embedded TSX ([#11685](https://github.com/prettier/prettier/pull/11685) by [@sosukesuzuki](https://github.com/sosukesuzuki))

The trailing comma is necessary to prevent TypeScript from treating the `<T>` as the beginning of a JSX expression.

<!-- prettier-ignore -->
````md
<!-- Input  -->
```tsx
const test = <T,>(value: T) => {};
```

<!-- Prettier 2.4 -->
```tsx
const test = <T>(value: T) => {};
```

<!-- Prettier 2.5 -->
```tsx
const test = <T,>(value: T) => {};
```
````
