import CoreServices
from PyObjCTools.TestSupport import TestCase


class TestGestalt(TestCase):
    def assert_not_wrapped(self, name):
        self.assertTrue(
            not hasattr(CoreServices, name), f"{name!r} exposed in bindings"
        )

    def test_not_wrapped(self):
        self.assert_not_wrapped("Gestalt")
        self.assert_not_wrapped("ReplaceGestalt")
        self.assert_not_wrapped("NewGestalt")
        self.assert_not_wrapped("NewGestaltValue")
        self.assert_not_wrapped("ReplaceGestaltValue")
        self.assert_not_wrapped("SetGestaltValue")
        self.assert_not_wrapped("DeleteGestaltValue")
        self.assert_not_wrapped("NewSelectorFunctionUPP")
        self.assert_not_wrapped("DisposeSelectorFunctionUPP")
        self.assert_not_wrapped("InvokeSelectorFunctionUPP")
        self.assert_not_wrapped("gestaltAddressingModeAttr")
        self.assert_not_wrapped("gestalt32BitAddressing")
        self.assert_not_wrapped("gestalt32BitSysZone")
        self.assert_not_wrapped("gestalt32BitCapable")
        self.assert_not_wrapped("gestaltAFPClient")
        self.assert_not_wrapped("gestaltAFPClientVersionMask")
        self.assert_not_wrapped("gestaltAFPClient3_5")
        self.assert_not_wrapped("gestaltAFPClient3_6")
        self.assert_not_wrapped("gestaltAFPClient3_6_1")
        self.assert_not_wrapped("gestaltAFPClient3_6_2")
        self.assert_not_wrapped("gestaltAFPClient3_6_3")
        self.assert_not_wrapped("gestaltAFPClient3_7")
        self.assert_not_wrapped("gestaltAFPClient3_7_2")
        self.assert_not_wrapped("gestaltAFPClient3_8")
        self.assert_not_wrapped("gestaltAFPClient3_8_1")
        self.assert_not_wrapped("gestaltAFPClient3_8_3")
        self.assert_not_wrapped("gestaltAFPClient3_8_4")
        self.assert_not_wrapped("gestaltAFPClientAttributeMask")
        self.assert_not_wrapped("gestaltAFPClientCfgRsrc")
        self.assert_not_wrapped("gestaltAFPClientSupportsIP")
        self.assert_not_wrapped("gestaltAFPClientVMUI")
        self.assert_not_wrapped("gestaltAFPClientMultiReq")
        self.assert_not_wrapped("gestaltAliasMgrAttr")
        self.assert_not_wrapped("gestaltAliasMgrPresent")
        self.assert_not_wrapped("gestaltAliasMgrSupportsRemoteAppletalk")
        self.assert_not_wrapped("gestaltAliasMgrSupportsAOCEKeychain")
        self.assert_not_wrapped("gestaltAliasMgrResolveAliasFileWithMountOptions")
        self.assert_not_wrapped("gestaltAliasMgrFollowsAliasesWhenResolving")
        self.assert_not_wrapped("gestaltAliasMgrSupportsExtendedCalls")
        self.assert_not_wrapped("gestaltAliasMgrSupportsFSCalls")
        self.assert_not_wrapped("gestaltAliasMgrPrefersPath")
        self.assert_not_wrapped("gestaltAliasMgrRequiresAccessors")
        self.assert_not_wrapped("gestaltAppearanceAttr")
        self.assert_not_wrapped("gestaltAppearanceExists")
        self.assert_not_wrapped("gestaltAppearanceCompatMode")
        self.assert_not_wrapped("gestaltAppearanceVersion")
        self.assert_not_wrapped("gestaltArbitorAttr")
        self.assert_not_wrapped("gestaltSerialArbitrationExists")
        self.assert_not_wrapped("gestaltAppleScriptVersion")
        self.assert_not_wrapped("gestaltAppleScriptAttr")
        self.assert_not_wrapped("gestaltAppleScriptPresent")
        self.assert_not_wrapped("gestaltAppleScriptPowerPCSupport")
        self.assert_not_wrapped("gestaltATAAttr")
        self.assert_not_wrapped("gestaltATAPresent")
        self.assert_not_wrapped("gestaltATalkVersion")
        self.assert_not_wrapped("gestaltAppleTalkVersion")
        self.assert_not_wrapped("gestaltAUXVersion")
        self.assert_not_wrapped("gestaltMacOSCompatibilityBoxAttr")
        self.assert_not_wrapped("gestaltMacOSCompatibilityBoxPresent")
        self.assert_not_wrapped("gestaltMacOSCompatibilityBoxHasSerial")
        self.assert_not_wrapped("gestaltMacOSCompatibilityBoxless")
        self.assert_not_wrapped("gestaltBusClkSpeed")
        self.assert_not_wrapped("gestaltBusClkSpeedMHz")
        self.assert_not_wrapped("gestaltCloseViewAttr")
        self.assert_not_wrapped("gestaltCloseViewEnabled")
        self.assert_not_wrapped("gestaltCloseViewDisplayMgrFriendly")
        self.assert_not_wrapped("gestaltCarbonVersion")
        self.assert_not_wrapped("gestaltCFMAttr")
        self.assert_not_wrapped("gestaltCFMPresent")
        self.assert_not_wrapped("gestaltCFMPresentMask")
        self.assert_not_wrapped("gestaltCFM99Present")
        self.assert_not_wrapped("gestaltCFM99PresentMask")
        self.assert_not_wrapped("gestaltProcessorCacheLineSize")
        self.assert_not_wrapped("gestaltCollectionMgrVersion")
        self.assert_not_wrapped("gestaltColorMatchingAttr")
        self.assert_not_wrapped("gestaltHighLevelMatching")
        self.assert_not_wrapped("gestaltColorMatchingLibLoaded")
        self.assert_not_wrapped("gestaltColorMatchingVersion")
        self.assert_not_wrapped("gestaltColorSync10")
        self.assert_not_wrapped("gestaltColorSync11")
        self.assert_not_wrapped("gestaltColorSync104")
        self.assert_not_wrapped("gestaltColorSync105")
        self.assert_not_wrapped("gestaltColorSync20")
        self.assert_not_wrapped("gestaltColorSync21")
        self.assert_not_wrapped("gestaltColorSync211")
        self.assert_not_wrapped("gestaltColorSync212")
        self.assert_not_wrapped("gestaltColorSync213")
        self.assert_not_wrapped("gestaltColorSync25")
        self.assert_not_wrapped("gestaltColorSync26")
        self.assert_not_wrapped("gestaltColorSync261")
        self.assert_not_wrapped("gestaltColorSync30")
        self.assert_not_wrapped("gestaltControlMgrVersion")
        self.assert_not_wrapped("gestaltControlMgrAttr")
        self.assert_not_wrapped("gestaltControlMgrPresent")
        self.assert_not_wrapped("gestaltControlMgrPresentBit")
        self.assert_not_wrapped("gestaltControlMsgPresentMask")
        self.assert_not_wrapped("gestaltConnMgrAttr")
        self.assert_not_wrapped("gestaltConnMgrPresent")
        self.assert_not_wrapped("gestaltConnMgrCMSearchFix")
        self.assert_not_wrapped("gestaltConnMgrErrorString")
        self.assert_not_wrapped("gestaltConnMgrMultiAsyncIO")
        self.assert_not_wrapped("gestaltColorPickerVersion")
        self.assert_not_wrapped("gestaltColorPicker")
        self.assert_not_wrapped("gestaltComponentMgr")
        self.assert_not_wrapped("gestaltComponentPlatform")
        self.assert_not_wrapped("gestaltNativeCPUtype")
        self.assert_not_wrapped("gestaltNativeCPUfamily")
        self.assert_not_wrapped("gestaltCPU68000")
        self.assert_not_wrapped("gestaltCPU68010")
        self.assert_not_wrapped("gestaltCPU68020")
        self.assert_not_wrapped("gestaltCPU68030")
        self.assert_not_wrapped("gestaltCPU68040")
        self.assert_not_wrapped("gestaltCPU601")
        self.assert_not_wrapped("gestaltCPU603")
        self.assert_not_wrapped("gestaltCPU604")
        self.assert_not_wrapped("gestaltCPU603e")
        self.assert_not_wrapped("gestaltCPU603ev")
        self.assert_not_wrapped("gestaltCPU750")
        self.assert_not_wrapped("gestaltCPU604e")
        self.assert_not_wrapped("gestaltCPU604ev")
        self.assert_not_wrapped("gestaltCPUG4")
        self.assert_not_wrapped("gestaltCPUG47450")
        self.assert_not_wrapped("gestaltCPUApollo")
        self.assert_not_wrapped("gestaltCPUG47447")
        self.assert_not_wrapped("gestaltCPU750FX")
        self.assert_not_wrapped("gestaltCPU970")
        self.assert_not_wrapped("gestaltCPU970FX")
        self.assert_not_wrapped("gestaltCPU970MP")
        self.assert_not_wrapped("gestaltCPU486")
        self.assert_not_wrapped("gestaltCPUPentium")
        self.assert_not_wrapped("gestaltCPUPentiumPro")
        self.assert_not_wrapped("gestaltCPUPentiumII")
        self.assert_not_wrapped("gestaltCPUX86")
        self.assert_not_wrapped("gestaltCPUPentium4")
        self.assert_not_wrapped("gestaltCPUARMFamily")
        self.assert_not_wrapped("gestaltCPUARM64")
        self.assert_not_wrapped("gestaltCRMAttr")
        self.assert_not_wrapped("gestaltCRMPresent")
        self.assert_not_wrapped("gestaltCRMPersistentFix")
        self.assert_not_wrapped("gestaltCRMToolRsrcCalls")
        self.assert_not_wrapped("gestaltControlStripVersion")
        self.assert_not_wrapped("gestaltCountOfCPUs")
        self.assert_not_wrapped("gestaltCTBVersion")
        self.assert_not_wrapped("gestaltDBAccessMgrAttr")
        self.assert_not_wrapped("gestaltDBAccessMgrPresent")
        self.assert_not_wrapped("gestaltDiskCacheSize")
        self.assert_not_wrapped("gestaltSDPFindVersion")
        self.assert_not_wrapped("gestaltDictionaryMgrAttr")
        self.assert_not_wrapped("gestaltDictionaryMgrPresent")
        self.assert_not_wrapped("gestaltDITLExtAttr")
        self.assert_not_wrapped("gestaltDITLExtPresent")
        self.assert_not_wrapped("gestaltDITLExtSupportsIctb")
        self.assert_not_wrapped("gestaltDialogMgrAttr")
        self.assert_not_wrapped("gestaltDialogMgrPresent")
        self.assert_not_wrapped("gestaltDialogMgrPresentBit")
        self.assert_not_wrapped("gestaltDialogMgrHasAquaAlertBit")
        self.assert_not_wrapped("gestaltDialogMgrPresentMask")
        self.assert_not_wrapped("gestaltDialogMgrHasAquaAlertMask")
        self.assert_not_wrapped("gestaltDialogMsgPresentMask")
        self.assert_not_wrapped("gestaltDesktopPicturesAttr")
        self.assert_not_wrapped("gestaltDesktopPicturesInstalled")
        self.assert_not_wrapped("gestaltDesktopPicturesDisplayed")
        self.assert_not_wrapped("gestaltDisplayMgrVers")
        self.assert_not_wrapped("gestaltDisplayMgrAttr")
        self.assert_not_wrapped("gestaltDisplayMgrPresent")
        self.assert_not_wrapped("gestaltDisplayMgrCanSwitchMirrored")
        self.assert_not_wrapped("gestaltDisplayMgrSetDepthNotifies")
        self.assert_not_wrapped("gestaltDisplayMgrCanConfirm")
        self.assert_not_wrapped("gestaltDisplayMgrColorSyncAware")
        self.assert_not_wrapped("gestaltDisplayMgrGeneratesProfiles")
        self.assert_not_wrapped("gestaltDisplayMgrSleepNotifies")
        self.assert_not_wrapped("gestaltDragMgrAttr")
        self.assert_not_wrapped("gestaltDragMgrPresent")
        self.assert_not_wrapped("gestaltDragMgrFloatingWind")
        self.assert_not_wrapped("gestaltPPCDragLibPresent")
        self.assert_not_wrapped("gestaltDragMgrHasImageSupport")
        self.assert_not_wrapped("gestaltCanStartDragInFloatWindow")
        self.assert_not_wrapped("gestaltSetDragImageUpdates")
        self.assert_not_wrapped("gestaltDrawSprocketVersion")
        self.assert_not_wrapped("gestaltDigitalSignatureVersion")
        self.assert_not_wrapped("gestaltDTPFeatures")
        self.assert_not_wrapped("kDTPThirdPartySupported")
        self.assert_not_wrapped("gestaltDTPInfo")
        self.assert_not_wrapped("gestaltEasyAccessAttr")
        self.assert_not_wrapped("gestaltEasyAccessOff")
        self.assert_not_wrapped("gestaltEasyAccessOn")
        self.assert_not_wrapped("gestaltEasyAccessSticky")
        self.assert_not_wrapped("gestaltEasyAccessLocked")
        self.assert_not_wrapped("gestaltEditionMgrAttr")
        self.assert_not_wrapped("gestaltEditionMgrPresent")
        self.assert_not_wrapped("gestaltEditionMgrTranslationAware")
        self.assert_not_wrapped("gestaltAppleEventsAttr")
        self.assert_not_wrapped("gestaltAppleEventsPresent")
        self.assert_not_wrapped("gestaltScriptingSupport")
        self.assert_not_wrapped("gestaltOSLInSystem")
        self.assert_not_wrapped("gestaltSupportsApplicationURL")
        self.assert_not_wrapped("gestaltExtensionTableVersion")
        self.assert_not_wrapped("gestaltFBCIndexingState")
        self.assert_not_wrapped("gestaltFBCindexingSafe")
        self.assert_not_wrapped("gestaltFBCindexingCritical")
        self.assert_not_wrapped("gestaltFBCVersion")
        self.assert_not_wrapped("gestaltFBCCurrentVersion")
        self.assert_not_wrapped("gestaltOSXFBCCurrentVersion")
        self.assert_not_wrapped("gestaltFileMappingAttr")
        self.assert_not_wrapped("gestaltFileMappingPresent")
        self.assert_not_wrapped("gestaltFileMappingMultipleFilesFix")
        self.assert_not_wrapped("gestaltFloppyAttr")
        self.assert_not_wrapped("gestaltFloppyIsMFMOnly")
        self.assert_not_wrapped("gestaltFloppyIsManualEject")
        self.assert_not_wrapped("gestaltFloppyUsesDiskInPlace")
        self.assert_not_wrapped("gestaltFinderAttr")
        self.assert_not_wrapped("gestaltFinderDropEvent")
        self.assert_not_wrapped("gestaltFinderMagicPlacement")
        self.assert_not_wrapped("gestaltFinderCallsAEProcess")
        self.assert_not_wrapped("gestaltOSLCompliantFinder")
        self.assert_not_wrapped("gestaltFinderSupports4GBVolumes")
        self.assert_not_wrapped("gestaltFinderHasClippings")
        self.assert_not_wrapped("gestaltFinderFullDragManagerSupport")
        self.assert_not_wrapped("gestaltFinderFloppyRootComments")
        self.assert_not_wrapped("gestaltFinderLargeAndNotSavedFlavorsOK")
        self.assert_not_wrapped("gestaltFinderUsesExtensibleFolderManager")
        self.assert_not_wrapped("gestaltFinderUnderstandsRedirectedDesktopFolder")
        self.assert_not_wrapped("gestaltFindFolderAttr")
        self.assert_not_wrapped("gestaltFindFolderPresent")
        self.assert_not_wrapped("gestaltFolderDescSupport")
        self.assert_not_wrapped("gestaltFolderMgrFollowsAliasesWhenResolving")
        self.assert_not_wrapped("gestaltFolderMgrSupportsExtendedCalls")
        self.assert_not_wrapped("gestaltFolderMgrSupportsDomains")
        self.assert_not_wrapped("gestaltFolderMgrSupportsFSCalls")
        self.assert_not_wrapped("gestaltFindFolderRedirectionAttr")
        self.assert_not_wrapped("gestaltFontMgrAttr")
        self.assert_not_wrapped("gestaltOutlineFonts")
        self.assert_not_wrapped("gestaltFPUType")
        self.assert_not_wrapped("gestaltNoFPU")
        self.assert_not_wrapped("gestalt68881")
        self.assert_not_wrapped("gestalt68882")
        self.assert_not_wrapped("gestalt68040FPU")
        self.assert_not_wrapped("gestaltFSAttr")
        self.assert_not_wrapped("gestaltFullExtFSDispatching")
        self.assert_not_wrapped("gestaltHasFSSpecCalls")
        self.assert_not_wrapped("gestaltHasFileSystemManager")
        self.assert_not_wrapped("gestaltFSMDoesDynamicLoad")
        self.assert_not_wrapped("gestaltFSSupports4GBVols")
        self.assert_not_wrapped("gestaltFSSupports2TBVols")
        self.assert_not_wrapped("gestaltHasExtendedDiskInit")
        self.assert_not_wrapped("gestaltDTMgrSupportsFSM")
        self.assert_not_wrapped("gestaltFSNoMFSVols")
        self.assert_not_wrapped("gestaltFSSupportsHFSPlusVols")
        self.assert_not_wrapped("gestaltFSIncompatibleDFA82")
        self.assert_not_wrapped("gestaltFSSupportsDirectIO")
        self.assert_not_wrapped("gestaltHasHFSPlusAPIs")
        self.assert_not_wrapped("gestaltMustUseFCBAccessors")
        self.assert_not_wrapped("gestaltFSUsesPOSIXPathsForConversion")
        self.assert_not_wrapped("gestaltFSSupportsExclusiveLocks")
        self.assert_not_wrapped("gestaltFSSupportsHardLinkDetection")
        self.assert_not_wrapped("gestaltFSAllowsConcurrentAsyncIO")
        self.assert_not_wrapped("gestaltAdminFeaturesFlagsAttr")
        self.assert_not_wrapped("gestaltFinderUsesSpecialOpenFoldersFile")
        self.assert_not_wrapped("gestaltFSMVersion")
        self.assert_not_wrapped("gestaltFXfrMgrAttr")
        self.assert_not_wrapped("gestaltFXfrMgrPresent")
        self.assert_not_wrapped("gestaltFXfrMgrMultiFile")
        self.assert_not_wrapped("gestaltFXfrMgrErrorString")
        self.assert_not_wrapped("gestaltFXfrMgrAsync")
        self.assert_not_wrapped("gestaltGraphicsAttr")
        self.assert_not_wrapped("gestaltGraphicsIsDebugging")
        self.assert_not_wrapped("gestaltGraphicsIsLoaded")
        self.assert_not_wrapped("gestaltGraphicsIsPowerPC")
        self.assert_not_wrapped("gestaltGraphicsVersion")
        self.assert_not_wrapped("gestaltCurrentGraphicsVersion")
        self.assert_not_wrapped("gestaltHardwareAttr")
        self.assert_not_wrapped("gestaltHasVIA1")
        self.assert_not_wrapped("gestaltHasVIA2")
        self.assert_not_wrapped("gestaltHasASC")
        self.assert_not_wrapped("gestaltHasSCC")
        self.assert_not_wrapped("gestaltHasSCSI")
        self.assert_not_wrapped("gestaltHasSoftPowerOff")
        self.assert_not_wrapped("gestaltHasSCSI961")
        self.assert_not_wrapped("gestaltHasSCSI962")
        self.assert_not_wrapped("gestaltHasUniversalROM")
        self.assert_not_wrapped("gestaltHasEnhancedLtalk")
        self.assert_not_wrapped("gestaltHelpMgrAttr")
        self.assert_not_wrapped("gestaltHelpMgrPresent")
        self.assert_not_wrapped("gestaltHelpMgrExtensions")
        self.assert_not_wrapped("gestaltAppleGuideIsDebug")
        self.assert_not_wrapped("gestaltAppleGuidePresent")
        self.assert_not_wrapped("gestaltHardwareVendorCode")
        self.assert_not_wrapped("gestaltHardwareVendorApple")
        self.assert_not_wrapped("gestaltCompressionMgr")
        self.assert_not_wrapped("gestaltIconUtilitiesAttr")
        self.assert_not_wrapped("gestaltIconUtilitiesPresent")
        self.assert_not_wrapped("gestaltIconUtilitiesHas48PixelIcons")
        self.assert_not_wrapped("gestaltIconUtilitiesHas32BitIcons")
        self.assert_not_wrapped("gestaltIconUtilitiesHas8BitDeepMasks")
        self.assert_not_wrapped("gestaltIconUtilitiesHasIconServices")
        self.assert_not_wrapped("gestaltInternalDisplay")
        self.assert_not_wrapped("gestaltKeyboardType")
        self.assert_not_wrapped("gestaltMacKbd")
        self.assert_not_wrapped("gestaltMacAndPad")
        self.assert_not_wrapped("gestaltMacPlusKbd")
        self.assert_not_wrapped("gestaltUnknownThirdPartyKbd")
        self.assert_not_wrapped("gestaltExtADBKbd")
        self.assert_not_wrapped("gestaltStdADBKbd")
        self.assert_not_wrapped("gestaltPrtblADBKbd")
        self.assert_not_wrapped("gestaltPrtblISOKbd")
        self.assert_not_wrapped("gestaltStdISOADBKbd")
        self.assert_not_wrapped("gestaltExtISOADBKbd")
        self.assert_not_wrapped("gestaltADBKbdII")
        self.assert_not_wrapped("gestaltADBISOKbdII")
        self.assert_not_wrapped("gestaltPwrBookADBKbd")
        self.assert_not_wrapped("gestaltPwrBookISOADBKbd")
        self.assert_not_wrapped("gestaltAppleAdjustKeypad")
        self.assert_not_wrapped("gestaltAppleAdjustADBKbd")
        self.assert_not_wrapped("gestaltAppleAdjustISOKbd")
        self.assert_not_wrapped("gestaltJapanAdjustADBKbd")
        self.assert_not_wrapped("gestaltPwrBkExtISOKbd")
        self.assert_not_wrapped("gestaltPwrBkExtJISKbd")
        self.assert_not_wrapped("gestaltPwrBkExtADBKbd")
        self.assert_not_wrapped("gestaltPS2Keyboard")
        self.assert_not_wrapped("gestaltPwrBkSubDomKbd")
        self.assert_not_wrapped("gestaltPwrBkSubISOKbd")
        self.assert_not_wrapped("gestaltPwrBkSubJISKbd")
        self.assert_not_wrapped("gestaltPortableUSBANSIKbd")
        self.assert_not_wrapped("gestaltPortableUSBISOKbd")
        self.assert_not_wrapped("gestaltPortableUSBJISKbd")
        self.assert_not_wrapped("gestaltThirdPartyANSIKbd")
        self.assert_not_wrapped("gestaltThirdPartyISOKbd")
        self.assert_not_wrapped("gestaltThirdPartyJISKbd")
        self.assert_not_wrapped("gestaltPwrBkEKDomKbd")
        self.assert_not_wrapped("gestaltPwrBkEKISOKbd")
        self.assert_not_wrapped("gestaltPwrBkEKJISKbd")
        self.assert_not_wrapped("gestaltUSBCosmoANSIKbd")
        self.assert_not_wrapped("gestaltUSBCosmoISOKbd")
        self.assert_not_wrapped("gestaltUSBCosmoJISKbd")
        self.assert_not_wrapped("gestaltPwrBk99JISKbd")
        self.assert_not_wrapped("gestaltUSBAndyANSIKbd")
        self.assert_not_wrapped("gestaltUSBAndyISOKbd")
        self.assert_not_wrapped("gestaltUSBAndyJISKbd")
        self.assert_not_wrapped("gestaltPortable2001ANSIKbd")
        self.assert_not_wrapped("gestaltPortable2001ISOKbd")
        self.assert_not_wrapped("gestaltPortable2001JISKbd")
        self.assert_not_wrapped("gestaltUSBProF16ANSIKbd")
        self.assert_not_wrapped("gestaltUSBProF16ISOKbd")
        self.assert_not_wrapped("gestaltUSBProF16JISKbd")
        self.assert_not_wrapped("gestaltProF16ANSIKbd")
        self.assert_not_wrapped("gestaltProF16ISOKbd")
        self.assert_not_wrapped("gestaltProF16JISKbd")
        self.assert_not_wrapped("gestaltUDFSupport")
        self.assert_not_wrapped("gestaltLowMemorySize")
        self.assert_not_wrapped("gestaltLogicalRAMSize")
        self.assert_not_wrapped("gestaltMachineType")
        self.assert_not_wrapped("gestaltClassic")
        self.assert_not_wrapped("gestaltMacXL")
        self.assert_not_wrapped("gestaltMac512KE")
        self.assert_not_wrapped("gestaltMacPlus")
        self.assert_not_wrapped("gestaltMacSE")
        self.assert_not_wrapped("gestaltMacII")
        self.assert_not_wrapped("gestaltMacIIx")
        self.assert_not_wrapped("gestaltMacIIcx")
        self.assert_not_wrapped("gestaltMacSE030")
        self.assert_not_wrapped("gestaltPortable")
        self.assert_not_wrapped("gestaltMacIIci")
        self.assert_not_wrapped("gestaltPowerMac8100_120")
        self.assert_not_wrapped("gestaltMacIIfx")
        self.assert_not_wrapped("gestaltMacClassic")
        self.assert_not_wrapped("gestaltMacIIsi")
        self.assert_not_wrapped("gestaltMacLC")
        self.assert_not_wrapped("gestaltMacQuadra900")
        self.assert_not_wrapped("gestaltPowerBook170")
        self.assert_not_wrapped("gestaltMacQuadra700")
        self.assert_not_wrapped("gestaltClassicII")
        self.assert_not_wrapped("gestaltPowerBook100")
        self.assert_not_wrapped("gestaltPowerBook140")
        self.assert_not_wrapped("gestaltMacQuadra950")
        self.assert_not_wrapped("gestaltMacLCIII")
        self.assert_not_wrapped("gestaltPerforma450")
        self.assert_not_wrapped("gestaltPowerBookDuo210")
        self.assert_not_wrapped("gestaltMacCentris650")
        self.assert_not_wrapped("gestaltPowerBookDuo230")
        self.assert_not_wrapped("gestaltPowerBook180")
        self.assert_not_wrapped("gestaltPowerBook160")
        self.assert_not_wrapped("gestaltMacQuadra800")
        self.assert_not_wrapped("gestaltMacQuadra650")
        self.assert_not_wrapped("gestaltMacLCII")
        self.assert_not_wrapped("gestaltPowerBookDuo250")
        self.assert_not_wrapped("gestaltAWS9150_80")
        self.assert_not_wrapped("gestaltPowerMac8100_110")
        self.assert_not_wrapped("gestaltAWS8150_110")
        self.assert_not_wrapped("gestaltPowerMac5200")
        self.assert_not_wrapped("gestaltPowerMac5260")
        self.assert_not_wrapped("gestaltPerforma5300")
        self.assert_not_wrapped("gestaltPowerMac6200")
        self.assert_not_wrapped("gestaltPerforma6300")
        self.assert_not_wrapped("gestaltMacIIvi")
        self.assert_not_wrapped("gestaltMacIIvm")
        self.assert_not_wrapped("gestaltPerforma600")
        self.assert_not_wrapped("gestaltPowerMac7100_80")
        self.assert_not_wrapped("gestaltMacIIvx")
        self.assert_not_wrapped("gestaltMacColorClassic")
        self.assert_not_wrapped("gestaltPerforma250")
        self.assert_not_wrapped("gestaltPowerBook165c")
        self.assert_not_wrapped("gestaltMacCentris610")
        self.assert_not_wrapped("gestaltMacQuadra610")
        self.assert_not_wrapped("gestaltPowerBook145")
        self.assert_not_wrapped("gestaltPowerMac8100_100")
        self.assert_not_wrapped("gestaltMacLC520")
        self.assert_not_wrapped("gestaltAWS9150_120")
        self.assert_not_wrapped("gestaltPowerMac6400")
        self.assert_not_wrapped("gestaltPerforma6400")
        self.assert_not_wrapped("gestaltPerforma6360")
        self.assert_not_wrapped("gestaltMacCentris660AV")
        self.assert_not_wrapped("gestaltMacQuadra660AV")
        self.assert_not_wrapped("gestaltPerforma46x")
        self.assert_not_wrapped("gestaltPowerMac8100_80")
        self.assert_not_wrapped("gestaltAWS8150_80")
        self.assert_not_wrapped("gestaltPowerMac9500")
        self.assert_not_wrapped("gestaltPowerMac9600")
        self.assert_not_wrapped("gestaltPowerMac7500")
        self.assert_not_wrapped("gestaltPowerMac7600")
        self.assert_not_wrapped("gestaltPowerMac8500")
        self.assert_not_wrapped("gestaltPowerMac8600")
        self.assert_not_wrapped("gestaltAWS8550")
        self.assert_not_wrapped("gestaltPowerBook180c")
        self.assert_not_wrapped("gestaltPowerBook520")
        self.assert_not_wrapped("gestaltPowerBook520c")
        self.assert_not_wrapped("gestaltPowerBook540")
        self.assert_not_wrapped("gestaltPowerBook540c")
        self.assert_not_wrapped("gestaltPowerMac5400")
        self.assert_not_wrapped("gestaltPowerMac6100_60")
        self.assert_not_wrapped("gestaltAWS6150_60")
        self.assert_not_wrapped("gestaltPowerBookDuo270c")
        self.assert_not_wrapped("gestaltMacQuadra840AV")
        self.assert_not_wrapped("gestaltPerforma550")
        self.assert_not_wrapped("gestaltPowerBook165")
        self.assert_not_wrapped("gestaltPowerBook190")
        self.assert_not_wrapped("gestaltMacTV")
        self.assert_not_wrapped("gestaltMacLC475")
        self.assert_not_wrapped("gestaltPerforma47x")
        self.assert_not_wrapped("gestaltMacLC575")
        self.assert_not_wrapped("gestaltMacQuadra605")
        self.assert_not_wrapped("gestaltMacQuadra630")
        self.assert_not_wrapped("gestaltMacLC580")
        self.assert_not_wrapped("gestaltPerforma580")
        self.assert_not_wrapped("gestaltPowerMac6100_66")
        self.assert_not_wrapped("gestaltAWS6150_66")
        self.assert_not_wrapped("gestaltPowerBookDuo280")
        self.assert_not_wrapped("gestaltPowerBookDuo280c")
        self.assert_not_wrapped("gestaltPowerMacLC475")
        self.assert_not_wrapped("gestaltPowerMacPerforma47x")
        self.assert_not_wrapped("gestaltPowerMacLC575")
        self.assert_not_wrapped("gestaltPowerMacPerforma57x")
        self.assert_not_wrapped("gestaltPowerMacQuadra630")
        self.assert_not_wrapped("gestaltPowerMacLC630")
        self.assert_not_wrapped("gestaltPowerMacPerforma63x")
        self.assert_not_wrapped("gestaltPowerMac7200")
        self.assert_not_wrapped("gestaltPowerMac7300")
        self.assert_not_wrapped("gestaltPowerMac7100_66")
        self.assert_not_wrapped("gestaltPowerBook150")
        self.assert_not_wrapped("gestaltPowerMacQuadra700")
        self.assert_not_wrapped("gestaltPowerMacQuadra900")
        self.assert_not_wrapped("gestaltPowerMacQuadra950")
        self.assert_not_wrapped("gestaltPowerMacCentris610")
        self.assert_not_wrapped("gestaltPowerMacCentris650")
        self.assert_not_wrapped("gestaltPowerMacQuadra610")
        self.assert_not_wrapped("gestaltPowerMacQuadra650")
        self.assert_not_wrapped("gestaltPowerMacQuadra800")
        self.assert_not_wrapped("gestaltPowerBookDuo2300")
        self.assert_not_wrapped("gestaltPowerBook500PPCUpgrade")
        self.assert_not_wrapped("gestaltPowerBook5300")
        self.assert_not_wrapped("gestaltPowerBook1400")
        self.assert_not_wrapped("gestaltPowerBook3400")
        self.assert_not_wrapped("gestaltPowerBook2400")
        self.assert_not_wrapped("gestaltPowerBookG3Series")
        self.assert_not_wrapped("gestaltPowerBookG3")
        self.assert_not_wrapped("gestaltPowerBookG3Series2")
        self.assert_not_wrapped("gestaltPowerMacNewWorld")
        self.assert_not_wrapped("gestaltPowerMacG3")
        self.assert_not_wrapped("gestaltPowerMac5500")
        self.assert_not_wrapped("gestalt20thAnniversary")
        self.assert_not_wrapped("gestaltPowerMac6500")
        self.assert_not_wrapped("gestaltPowerMac4400_160")
        self.assert_not_wrapped("gestaltPowerMac4400")
        self.assert_not_wrapped("gestaltMacOSCompatibility")
        self.assert_not_wrapped("gestaltQuadra605")
        self.assert_not_wrapped("gestaltQuadra610")
        self.assert_not_wrapped("gestaltQuadra630")
        self.assert_not_wrapped("gestaltQuadra650")
        self.assert_not_wrapped("gestaltQuadra660AV")
        self.assert_not_wrapped("gestaltQuadra700")
        self.assert_not_wrapped("gestaltQuadra800")
        self.assert_not_wrapped("gestaltQuadra840AV")
        self.assert_not_wrapped("gestaltQuadra900")
        self.assert_not_wrapped("gestaltQuadra950")
        self.assert_not_wrapped("kMachineNameStrID")
        self.assert_not_wrapped("gestaltSMPMailerVersion")
        self.assert_not_wrapped("gestaltMediaBay")
        self.assert_not_wrapped("gestaltMBLegacy")
        self.assert_not_wrapped("gestaltMBSingleBay")
        self.assert_not_wrapped("gestaltMBMultipleBays")
        self.assert_not_wrapped("gestaltMessageMgrVersion")
        self.assert_not_wrapped("gestaltMenuMgrAttr")
        self.assert_not_wrapped("gestaltMenuMgrPresent")
        self.assert_not_wrapped("gestaltMenuMgrPresentBit")
        self.assert_not_wrapped("gestaltMenuMgrAquaLayoutBit")
        self.assert_not_wrapped("gestaltMenuMgrMultipleItemsWithCommandIDBit")
        self.assert_not_wrapped("gestaltMenuMgrRetainsIconRefBit")
        self.assert_not_wrapped("gestaltMenuMgrSendsMenuBoundsToDefProcBit")
        self.assert_not_wrapped("gestaltMenuMgrMoreThanFiveMenusDeepBit")
        self.assert_not_wrapped("gestaltMenuMgrCGImageMenuTitleBit")
        self.assert_not_wrapped("gestaltMenuMgrPresentMask")
        self.assert_not_wrapped("gestaltMenuMgrAquaLayoutMask")
        self.assert_not_wrapped("gestaltMenuMgrMultipleItemsWithCommandIDMask")
        self.assert_not_wrapped("gestaltMenuMgrRetainsIconRefMask")
        self.assert_not_wrapped("gestaltMenuMgrSendsMenuBoundsToDefProcMask")
        self.assert_not_wrapped("gestaltMenuMgrMoreThanFiveMenusDeepMask")
        self.assert_not_wrapped("gestaltMenuMgrCGImageMenuTitleMask")
        self.assert_not_wrapped("gestaltMultipleUsersState")
        self.assert_not_wrapped("gestaltMachineIcon")
        self.assert_not_wrapped("gestaltMiscAttr")
        self.assert_not_wrapped("gestaltScrollingThrottle")
        self.assert_not_wrapped("gestaltSquareMenuBar")
        self.assert_not_wrapped("gestaltMixedModeVersion")
        self.assert_not_wrapped("gestaltMixedModeAttr")
        self.assert_not_wrapped("gestaltMixedModePowerPC")
        self.assert_not_wrapped("gestaltPowerPCAware")
        self.assert_not_wrapped("gestaltMixedModeCFM68K")
        self.assert_not_wrapped("gestaltMixedModeCFM68KHasTrap")
        self.assert_not_wrapped("gestaltMixedModeCFM68KHasState")
        self.assert_not_wrapped("gestaltQuickTimeConferencing")
        self.assert_not_wrapped("gestaltMemoryMapAttr")
        self.assert_not_wrapped("gestaltMemoryMapSparse")
        self.assert_not_wrapped("gestaltMMUType")
        self.assert_not_wrapped("gestaltNoMMU")
        self.assert_not_wrapped("gestaltAMU")
        self.assert_not_wrapped("gestalt68851")
        self.assert_not_wrapped("gestalt68030MMU")
        self.assert_not_wrapped("gestalt68040MMU")
        self.assert_not_wrapped("gestaltEMMU1")
        self.assert_not_wrapped("gestaltUserVisibleMachineName")
        self.assert_not_wrapped("gestaltMPCallableAPIsAttr")
        self.assert_not_wrapped("gestaltMPFileManager")
        self.assert_not_wrapped("gestaltMPDeviceManager")
        self.assert_not_wrapped("gestaltMPTrapCalls")
        self.assert_not_wrapped("gestaltStdNBPAttr")
        self.assert_not_wrapped("gestaltStdNBPPresent")
        self.assert_not_wrapped("gestaltStdNBPSupportsAutoPosition")
        self.assert_not_wrapped("gestaltNotificationMgrAttr")
        self.assert_not_wrapped("gestaltNotificationPresent")
        self.assert_not_wrapped("gestaltNameRegistryVersion")
        self.assert_not_wrapped("gestaltNuBusSlotCount")
        self.assert_not_wrapped("gestaltOCEToolboxVersion")
        self.assert_not_wrapped("gestaltOCETB")
        self.assert_not_wrapped("gestaltSFServer")
        self.assert_not_wrapped("gestaltOCEToolboxAttr")
        self.assert_not_wrapped("gestaltOCETBPresent")
        self.assert_not_wrapped("gestaltOCETBAvailable")
        self.assert_not_wrapped("gestaltOCESFServerAvailable")
        self.assert_not_wrapped("gestaltOCETBNativeGlueAvailable")
        self.assert_not_wrapped("gestaltOpenFirmwareInfo")
        self.assert_not_wrapped("gestaltOSAttr")
        self.assert_not_wrapped("gestaltSysZoneGrowable")
        self.assert_not_wrapped("gestaltLaunchCanReturn")
        self.assert_not_wrapped("gestaltLaunchFullFileSpec")
        self.assert_not_wrapped("gestaltLaunchControl")
        self.assert_not_wrapped("gestaltTempMemSupport")
        self.assert_not_wrapped("gestaltRealTempMemory")
        self.assert_not_wrapped("gestaltTempMemTracked")
        self.assert_not_wrapped("gestaltIPCSupport")
        self.assert_not_wrapped("gestaltSysDebuggerSupport")
        self.assert_not_wrapped("gestaltNativeProcessMgrBit")
        self.assert_not_wrapped("gestaltAltivecRegistersSwappedCorrectlyBit")
        self.assert_not_wrapped("gestaltOSTable")
        self.assert_not_wrapped("gestaltOpenTptNetworkSetup")
        self.assert_not_wrapped("gestaltOpenTptNetworkSetupLegacyImport")
        self.assert_not_wrapped("gestaltOpenTptNetworkSetupLegacyExport")
        self.assert_not_wrapped("gestaltOpenTptNetworkSetupSupportsMultihoming")
        self.assert_not_wrapped("gestaltOpenTptNetworkSetupVersion")
        self.assert_not_wrapped("gestaltOpenTptRemoteAccess")
        self.assert_not_wrapped("gestaltOpenTptRemoteAccessPresent")
        self.assert_not_wrapped("gestaltOpenTptRemoteAccessLoaded")
        self.assert_not_wrapped("gestaltOpenTptRemoteAccessClientOnly")
        self.assert_not_wrapped("gestaltOpenTptRemoteAccessPServer")
        self.assert_not_wrapped("gestaltOpenTptRemoteAccessMPServer")
        self.assert_not_wrapped("gestaltOpenTptPPPPresent")
        self.assert_not_wrapped("gestaltOpenTptARAPPresent")
        self.assert_not_wrapped("gestaltOpenTptRemoteAccessVersion")
        self.assert_not_wrapped("gestaltOpenTptVersions")
        self.assert_not_wrapped("gestaltOpenTpt")
        self.assert_not_wrapped("gestaltOpenTptPresentMask")
        self.assert_not_wrapped("gestaltOpenTptLoadedMask")
        self.assert_not_wrapped("gestaltOpenTptAppleTalkPresentMask")
        self.assert_not_wrapped("gestaltOpenTptAppleTalkLoadedMask")
        self.assert_not_wrapped("gestaltOpenTptTCPPresentMask")
        self.assert_not_wrapped("gestaltOpenTptTCPLoadedMask")
        self.assert_not_wrapped("gestaltOpenTptIPXSPXPresentMask")
        self.assert_not_wrapped("gestaltOpenTptIPXSPXLoadedMask")
        self.assert_not_wrapped("gestaltOpenTptPresentBit")
        self.assert_not_wrapped("gestaltOpenTptLoadedBit")
        self.assert_not_wrapped("gestaltOpenTptAppleTalkPresentBit")
        self.assert_not_wrapped("gestaltOpenTptAppleTalkLoadedBit")
        self.assert_not_wrapped("gestaltOpenTptTCPPresentBit")
        self.assert_not_wrapped("gestaltOpenTptTCPLoadedBit")
        self.assert_not_wrapped("gestaltOpenTptIPXSPXPresentBit")
        self.assert_not_wrapped("gestaltOpenTptIPXSPXLoadedBit")
        self.assert_not_wrapped("gestaltPCCard")
        self.assert_not_wrapped("gestaltCardServicesPresent")
        self.assert_not_wrapped("gestaltPCCardFamilyPresent")
        self.assert_not_wrapped("gestaltPCCardHasPowerControl")
        self.assert_not_wrapped("gestaltPCCardSupportsCardBus")
        self.assert_not_wrapped("gestaltProcClkSpeed")
        self.assert_not_wrapped("gestaltProcClkSpeedMHz")
        self.assert_not_wrapped("gestaltPCXAttr")
        self.assert_not_wrapped("gestaltPCXHas8and16BitFAT")
        self.assert_not_wrapped("gestaltPCXHasProDOS")
        self.assert_not_wrapped("gestaltPCXNewUI")
        self.assert_not_wrapped("gestaltPCXUseICMapping")
        self.assert_not_wrapped("gestaltLogicalPageSize")
        self.assert_not_wrapped("gestaltScreenCaptureMain")
        self.assert_not_wrapped("gestaltScreenCaptureDir")
        self.assert_not_wrapped("gestaltGXPrintingMgrVersion")
        self.assert_not_wrapped("gestaltPopupAttr")
        self.assert_not_wrapped("gestaltPopupPresent")
        self.assert_not_wrapped("gestaltPowerMgrAttr")
        self.assert_not_wrapped("gestaltPMgrExists")
        self.assert_not_wrapped("gestaltPMgrCPUIdle")
        self.assert_not_wrapped("gestaltPMgrSCC")
        self.assert_not_wrapped("gestaltPMgrSound")
        self.assert_not_wrapped("gestaltPMgrDispatchExists")
        self.assert_not_wrapped("gestaltPMgrSupportsAVPowerStateAtSleepWake")
        self.assert_not_wrapped("gestaltPowerMgrVers")
        self.assert_not_wrapped("gestaltPPCToolboxAttr")
        self.assert_not_wrapped("gestaltPPCToolboxPresent")
        self.assert_not_wrapped("gestaltPPCSupportsRealTime")
        self.assert_not_wrapped("gestaltPPCSupportsIncoming")
        self.assert_not_wrapped("gestaltPPCSupportsOutGoing")
        self.assert_not_wrapped("gestaltPPCSupportsTCP_IP")
        self.assert_not_wrapped("gestaltPPCSupportsIncomingAppleTalk")
        self.assert_not_wrapped("gestaltPPCSupportsIncomingTCP_IP")
        self.assert_not_wrapped("gestaltPPCSupportsOutgoingAppleTalk")
        self.assert_not_wrapped("gestaltPPCSupportsOutgoingTCP_IP")
        self.assert_not_wrapped("gestaltPowerPCProcessorFeatures")
        self.assert_not_wrapped("gestaltPowerPCHasGraphicsInstructions")
        self.assert_not_wrapped("gestaltPowerPCHasSTFIWXInstruction")
        self.assert_not_wrapped("gestaltPowerPCHasSquareRootInstructions")
        self.assert_not_wrapped("gestaltPowerPCHasDCBAInstruction")
        self.assert_not_wrapped("gestaltPowerPCHasVectorInstructions")
        self.assert_not_wrapped("gestaltPowerPCHasDataStreams")
        self.assert_not_wrapped("gestaltPowerPCHas64BitSupport")
        self.assert_not_wrapped("gestaltPowerPCHasDCBTStreams")
        self.assert_not_wrapped("gestaltPowerPCASArchitecture")
        self.assert_not_wrapped("gestaltPowerPCIgnoresDCBST")
        self.assert_not_wrapped("gestaltProcessorType")
        self.assert_not_wrapped("gestalt68000")
        self.assert_not_wrapped("gestalt68010")
        self.assert_not_wrapped("gestalt68020")
        self.assert_not_wrapped("gestalt68030")
        self.assert_not_wrapped("gestalt68040")
        self.assert_not_wrapped("gestaltSDPPromptVersion")
        self.assert_not_wrapped("gestaltParityAttr")
        self.assert_not_wrapped("gestaltHasParityCapability")
        self.assert_not_wrapped("gestaltParityEnabled")
        self.assert_not_wrapped("gestaltQD3DVersion")
        self.assert_not_wrapped("gestaltQD3DViewer")
        self.assert_not_wrapped("gestaltQD3DViewerPresent")
        self.assert_not_wrapped("gestaltQD3DViewerNotPresent")
        self.assert_not_wrapped("gestaltQuickdrawVersion")
        self.assert_not_wrapped("gestaltOriginalQD")
        self.assert_not_wrapped("gestalt8BitQD")
        self.assert_not_wrapped("gestalt32BitQD")
        self.assert_not_wrapped("gestalt32BitQD11")
        self.assert_not_wrapped("gestalt32BitQD12")
        self.assert_not_wrapped("gestalt32BitQD13")
        self.assert_not_wrapped("gestaltAllegroQD")
        self.assert_not_wrapped("gestaltMacOSXQD")
        self.assert_not_wrapped("gestaltQD3D")
        self.assert_not_wrapped("gestaltQD3DPresent")
        self.assert_not_wrapped("gestaltQD3DNotPresent")
        self.assert_not_wrapped("gestaltQD3DAvailable")
        self.assert_not_wrapped("gestaltGXVersion")
        self.assert_not_wrapped("gestaltQuickdrawFeatures")
        self.assert_not_wrapped("gestaltHasColor")
        self.assert_not_wrapped("gestaltHasDeepGWorlds")
        self.assert_not_wrapped("gestaltHasDirectPixMaps")
        self.assert_not_wrapped("gestaltHasGrayishTextOr")
        self.assert_not_wrapped("gestaltSupportsMirroring")
        self.assert_not_wrapped("gestaltQDHasLongRowBytes")
        self.assert_not_wrapped("gestaltQDTextVersion")
        self.assert_not_wrapped("gestaltOriginalQDText")
        self.assert_not_wrapped("gestaltAllegroQDText")
        self.assert_not_wrapped("gestaltMacOSXQDText")
        self.assert_not_wrapped("gestaltQDTextFeatures")
        self.assert_not_wrapped("gestaltWSIISupport")
        self.assert_not_wrapped("gestaltSbitFontSupport")
        self.assert_not_wrapped("gestaltAntiAliasedTextAvailable")
        self.assert_not_wrapped("gestaltOFA2available")
        self.assert_not_wrapped("gestaltCreatesAliasFontRsrc")
        self.assert_not_wrapped("gestaltNativeType1FontSupport")
        self.assert_not_wrapped("gestaltCanUseCGTextRendering")
        self.assert_not_wrapped("gestaltQuickTimeConferencingInfo")
        self.assert_not_wrapped("gestaltQuickTimeVersion")
        self.assert_not_wrapped("gestaltQuickTime")
        self.assert_not_wrapped("gestaltQuickTimeFeatures")
        self.assert_not_wrapped("gestaltPPCQuickTimeLibPresent")
        self.assert_not_wrapped("gestaltQuickTimeStreamingFeatures")
        self.assert_not_wrapped("gestaltQuickTimeStreamingVersion")
        self.assert_not_wrapped("gestaltQuickTimeThreadSafeFeaturesAttr")
        self.assert_not_wrapped("gestaltQuickTimeThreadSafeICM")
        self.assert_not_wrapped("gestaltQuickTimeThreadSafeMovieToolbox")
        self.assert_not_wrapped("gestaltQuickTimeThreadSafeMovieImport")
        self.assert_not_wrapped("gestaltQuickTimeThreadSafeMovieExport")
        self.assert_not_wrapped("gestaltQuickTimeThreadSafeGraphicsImport")
        self.assert_not_wrapped("gestaltQuickTimeThreadSafeGraphicsExport")
        self.assert_not_wrapped("gestaltQuickTimeThreadSafeMoviePlayback")
        self.assert_not_wrapped("gestaltQTVRMgrAttr")
        self.assert_not_wrapped("gestaltQTVRMgrPresent")
        self.assert_not_wrapped("gestaltQTVRObjMoviesPresent")
        self.assert_not_wrapped("gestaltQTVRCylinderPanosPresent")
        self.assert_not_wrapped("gestaltQTVRCubicPanosPresent")
        self.assert_not_wrapped("gestaltQTVRMgrVers")
        self.assert_not_wrapped("gestaltPhysicalRAMSize")
        self.assert_not_wrapped("gestaltPhysicalRAMSizeInMegabytes")
        self.assert_not_wrapped("gestaltRBVAddr")
        self.assert_not_wrapped("gestaltROMSize")
        self.assert_not_wrapped("gestaltROMVersion")
        self.assert_not_wrapped("gestaltResourceMgrAttr")
        self.assert_not_wrapped("gestaltPartialRsrcs")
        self.assert_not_wrapped("gestaltHasResourceOverrides")
        self.assert_not_wrapped("gestaltResourceMgrBugFixesAttrs")
        self.assert_not_wrapped("gestaltRMForceSysHeapRolledIn")
        self.assert_not_wrapped("gestaltRMFakeAppleMenuItemsRolledIn")
        self.assert_not_wrapped("gestaltSanityCheckResourceFiles")
        self.assert_not_wrapped("gestaltSupportsFSpResourceFileAlreadyOpenBit")
        self.assert_not_wrapped("gestaltRMSupportsFSCalls")
        self.assert_not_wrapped("gestaltRMTypeIndexOrderingReverse")
        self.assert_not_wrapped("gestaltRealtimeMgrAttr")
        self.assert_not_wrapped("gestaltRealtimeMgrPresent")
        self.assert_not_wrapped("gestaltSafeOFAttr")
        self.assert_not_wrapped("gestaltVMZerosPagesBit")
        self.assert_not_wrapped("gestaltInitHeapZerosOutHeapsBit")
        self.assert_not_wrapped("gestaltNewHandleReturnsZeroedMemoryBit")
        self.assert_not_wrapped("gestaltNewPtrReturnsZeroedMemoryBit")
        self.assert_not_wrapped("gestaltFileAllocationZeroedBlocksBit")
        self.assert_not_wrapped("gestaltSCCReadAddr")
        self.assert_not_wrapped("gestaltSCCWriteAddr")
        self.assert_not_wrapped("gestaltScrapMgrAttr")
        self.assert_not_wrapped("gestaltScrapMgrTranslationAware")
        self.assert_not_wrapped("gestaltScriptMgrVersion")
        self.assert_not_wrapped("gestaltScriptCount")
        self.assert_not_wrapped("gestaltSCSI")
        self.assert_not_wrapped("gestaltAsyncSCSI")
        self.assert_not_wrapped("gestaltAsyncSCSIINROM")
        self.assert_not_wrapped("gestaltSCSISlotBoot")
        self.assert_not_wrapped("gestaltSCSIPollSIH")
        self.assert_not_wrapped("gestaltControlStripAttr")
        self.assert_not_wrapped("gestaltControlStripExists")
        self.assert_not_wrapped("gestaltControlStripVersionFixed")
        self.assert_not_wrapped("gestaltControlStripUserFont")
        self.assert_not_wrapped("gestaltControlStripUserHotKey")
        self.assert_not_wrapped("gestaltSDPStandardDirectoryVersion")
        self.assert_not_wrapped("gestaltSerialAttr")
        self.assert_not_wrapped("gestaltHasGPIaToDCDa")
        self.assert_not_wrapped("gestaltHasGPIaToRTxCa")
        self.assert_not_wrapped("gestaltHasGPIbToDCDb")
        self.assert_not_wrapped("gestaltHidePortA")
        self.assert_not_wrapped("gestaltHidePortB")
        self.assert_not_wrapped("gestaltPortADisabled")
        self.assert_not_wrapped("gestaltPortBDisabled")
        self.assert_not_wrapped("gestaltShutdownAttributes")
        self.assert_not_wrapped("gestaltShutdownHassdOnBootVolUnmount")
        self.assert_not_wrapped("gestaltNuBusConnectors")
        self.assert_not_wrapped("gestaltSlotAttr")
        self.assert_not_wrapped("gestaltSlotMgrExists")
        self.assert_not_wrapped("gestaltNuBusPresent")
        self.assert_not_wrapped("gestaltSESlotPresent")
        self.assert_not_wrapped("gestaltSE30SlotPresent")
        self.assert_not_wrapped("gestaltPortableSlotPresent")
        self.assert_not_wrapped("gestaltFirstSlotNumber")
        self.assert_not_wrapped("gestaltSoundAttr")
        self.assert_not_wrapped("gestaltStereoCapability")
        self.assert_not_wrapped("gestaltStereoMixing")
        self.assert_not_wrapped("gestaltSoundIOMgrPresent")
        self.assert_not_wrapped("gestaltBuiltInSoundInput")
        self.assert_not_wrapped("gestaltHasSoundInputDevice")
        self.assert_not_wrapped("gestaltPlayAndRecord")
        self.assert_not_wrapped("gestalt16BitSoundIO")
        self.assert_not_wrapped("gestaltStereoInput")
        self.assert_not_wrapped("gestaltLineLevelInput")
        self.assert_not_wrapped("gestaltSndPlayDoubleBuffer")
        self.assert_not_wrapped("gestaltMultiChannels")
        self.assert_not_wrapped("gestalt16BitAudioSupport")
        self.assert_not_wrapped("gestaltSplitOSAttr")
        self.assert_not_wrapped("gestaltSplitOSBootDriveIsNetworkVolume")
        self.assert_not_wrapped("gestaltSplitOSAware")
        self.assert_not_wrapped("gestaltSplitOSEnablerVolumeIsDifferentFromBootVolume")
        self.assert_not_wrapped("gestaltSplitOSMachineNameSetToNetworkNameTemp")
        self.assert_not_wrapped("gestaltSplitOSMachineNameStartupDiskIsNonPersistent")
        self.assert_not_wrapped("gestaltSMPSPSendLetterVersion")
        self.assert_not_wrapped("gestaltSpeechRecognitionAttr")
        self.assert_not_wrapped("gestaltDesktopSpeechRecognition")
        self.assert_not_wrapped("gestaltTelephoneSpeechRecognition")
        self.assert_not_wrapped("gestaltSpeechRecognitionVersion")
        self.assert_not_wrapped("gestaltSoftwareVendorCode")
        self.assert_not_wrapped("gestaltSoftwareVendorApple")
        self.assert_not_wrapped("gestaltSoftwareVendorLicensee")
        self.assert_not_wrapped("gestaltStandardFileAttr")
        self.assert_not_wrapped("gestaltStandardFile58")
        self.assert_not_wrapped("gestaltStandardFileTranslationAware")
        self.assert_not_wrapped("gestaltStandardFileHasColorIcons")
        self.assert_not_wrapped("gestaltStandardFileUseGenericIcons")
        self.assert_not_wrapped("gestaltStandardFileHasDynamicVolumeAllocation")
        self.assert_not_wrapped("gestaltSysArchitecture")
        self.assert_not_wrapped("gestalt68k")
        self.assert_not_wrapped("gestaltPowerPC")
        self.assert_not_wrapped("gestaltIntel")
        self.assert_not_wrapped("gestaltSystemUpdateVersion")
        self.assert_not_wrapped("gestaltSystemVersion")
        self.assert_not_wrapped("gestaltSystemVersionMajor")
        self.assert_not_wrapped("gestaltSystemVersionMinor")
        self.assert_not_wrapped("gestaltSystemVersionBugFix")
        self.assert_not_wrapped("gestaltToolboxTable")
        self.assert_not_wrapped("gestaltTextEditVersion")
        self.assert_not_wrapped("gestaltTE1")
        self.assert_not_wrapped("gestaltTE2")
        self.assert_not_wrapped("gestaltTE3")
        self.assert_not_wrapped("gestaltTE4")
        self.assert_not_wrapped("gestaltTE5")
        self.assert_not_wrapped("gestaltTE6")
        self.assert_not_wrapped("gestaltTEAttr")
        self.assert_not_wrapped("gestaltTEHasGetHiliteRgn")
        self.assert_not_wrapped("gestaltTESupportsInlineInput")
        self.assert_not_wrapped("gestaltTESupportsTextObjects")
        self.assert_not_wrapped("gestaltTEHasWhiteBackground")
        self.assert_not_wrapped("gestaltTeleMgrAttr")
        self.assert_not_wrapped("gestaltTeleMgrPresent")
        self.assert_not_wrapped("gestaltTeleMgrPowerPCSupport")
        self.assert_not_wrapped("gestaltTeleMgrSoundStreams")
        self.assert_not_wrapped("gestaltTeleMgrAutoAnswer")
        self.assert_not_wrapped("gestaltTeleMgrIndHandset")
        self.assert_not_wrapped("gestaltTeleMgrSilenceDetect")
        self.assert_not_wrapped("gestaltTeleMgrNewTELNewSupport")
        self.assert_not_wrapped("gestaltTermMgrAttr")
        self.assert_not_wrapped("gestaltTermMgrPresent")
        self.assert_not_wrapped("gestaltTermMgrErrorString")
        self.assert_not_wrapped("gestaltThreadMgrAttr")
        self.assert_not_wrapped("gestaltThreadMgrPresent")
        self.assert_not_wrapped("gestaltSpecificMatchSupport")
        self.assert_not_wrapped("gestaltThreadsLibraryPresent")
        self.assert_not_wrapped("gestaltTimeMgrVersion")
        self.assert_not_wrapped("gestaltStandardTimeMgr")
        self.assert_not_wrapped("gestaltRevisedTimeMgr")
        self.assert_not_wrapped("gestaltExtendedTimeMgr")
        self.assert_not_wrapped("gestaltNativeTimeMgr")
        self.assert_not_wrapped("gestaltTSMTEVersion")
        self.assert_not_wrapped("gestaltTSMTE1")
        self.assert_not_wrapped("gestaltTSMTE15")
        self.assert_not_wrapped("gestaltTSMTE152")
        self.assert_not_wrapped("gestaltTSMTEAttr")
        self.assert_not_wrapped("gestaltTSMTEPresent")
        self.assert_not_wrapped("gestaltTSMTE")
        self.assert_not_wrapped("gestaltAVLTreeAttr")
        self.assert_not_wrapped("gestaltAVLTreePresentBit")
        self.assert_not_wrapped("gestaltAVLTreeSupportsHandleBasedTreeBit")
        self.assert_not_wrapped("gestaltAVLTreeSupportsTreeLockingBit")
        self.assert_not_wrapped("gestaltALMAttr")
        self.assert_not_wrapped("gestaltALMPresent")
        self.assert_not_wrapped("gestaltALMHasSFGroup")
        self.assert_not_wrapped("gestaltALMHasCFMSupport")
        self.assert_not_wrapped("gestaltALMHasRescanNotifiers")
        self.assert_not_wrapped("gestaltALMHasSFLocation")
        self.assert_not_wrapped("gestaltTSMgrVersion")
        self.assert_not_wrapped("gestaltTSMgr15")
        self.assert_not_wrapped("gestaltTSMgr20")
        self.assert_not_wrapped("gestaltTSMgr22")
        self.assert_not_wrapped("gestaltTSMgr23")
        self.assert_not_wrapped("gestaltTSMgrAttr")
        self.assert_not_wrapped("gestaltTSMDisplayMgrAwareBit")
        self.assert_not_wrapped("gestaltTSMdoesTSMTEBit")
        self.assert_not_wrapped("gestaltSpeechAttr")
        self.assert_not_wrapped("gestaltSpeechMgrPresent")
        self.assert_not_wrapped("gestaltSpeechHasPPCGlue")
        self.assert_not_wrapped("gestaltTVAttr")
        self.assert_not_wrapped("gestaltHasTVTuner")
        self.assert_not_wrapped("gestaltHasSoundFader")
        self.assert_not_wrapped("gestaltHasHWClosedCaptioning")
        self.assert_not_wrapped("gestaltHasIRRemote")
        self.assert_not_wrapped("gestaltHasVidDecoderScaler")
        self.assert_not_wrapped("gestaltHasStereoDecoder")
        self.assert_not_wrapped("gestaltHasSerialFader")
        self.assert_not_wrapped("gestaltHasFMTuner")
        self.assert_not_wrapped("gestaltHasSystemIRFunction")
        self.assert_not_wrapped("gestaltIRDisabled")
        self.assert_not_wrapped("gestaltINeedIRPowerOffConfirm")
        self.assert_not_wrapped("gestaltHasZoomedVideo")
        self.assert_not_wrapped("gestaltATSUVersion")
        self.assert_not_wrapped("gestaltOriginalATSUVersion")
        self.assert_not_wrapped("gestaltATSUUpdate1")
        self.assert_not_wrapped("gestaltATSUUpdate2")
        self.assert_not_wrapped("gestaltATSUUpdate3")
        self.assert_not_wrapped("gestaltATSUUpdate4")
        self.assert_not_wrapped("gestaltATSUUpdate5")
        self.assert_not_wrapped("gestaltATSUUpdate6")
        self.assert_not_wrapped("gestaltATSUUpdate7")
        self.assert_not_wrapped("gestaltATSUFeatures")
        self.assert_not_wrapped("gestaltATSUTrackingFeature")
        self.assert_not_wrapped("gestaltATSUMemoryFeature")
        self.assert_not_wrapped("gestaltATSUFallbacksFeature")
        self.assert_not_wrapped("gestaltATSUGlyphBoundsFeature")
        self.assert_not_wrapped("gestaltATSULineControlFeature")
        self.assert_not_wrapped("gestaltATSULayoutCreateAndCopyFeature")
        self.assert_not_wrapped("gestaltATSULayoutCacheClearFeature")
        self.assert_not_wrapped("gestaltATSUTextLocatorUsageFeature")
        self.assert_not_wrapped("gestaltATSULowLevelOrigFeatures")
        self.assert_not_wrapped("gestaltATSUFallbacksObjFeatures")
        self.assert_not_wrapped("gestaltATSUIgnoreLeadingFeature")
        self.assert_not_wrapped("gestaltATSUByCharacterClusterFeature")
        self.assert_not_wrapped("gestaltATSUAscentDescentControlsFeature")
        self.assert_not_wrapped("gestaltATSUHighlightInactiveTextFeature")
        self.assert_not_wrapped("gestaltATSUPositionToCursorFeature")
        self.assert_not_wrapped("gestaltATSUBatchBreakLinesFeature")
        self.assert_not_wrapped("gestaltATSUTabSupportFeature")
        self.assert_not_wrapped("gestaltATSUDirectAccess")
        self.assert_not_wrapped("gestaltATSUDecimalTabFeature")
        self.assert_not_wrapped("gestaltATSUBiDiCursorPositionFeature")
        self.assert_not_wrapped("gestaltATSUNearestCharLineBreakFeature")
        self.assert_not_wrapped("gestaltATSUHighlightColorControlFeature")
        self.assert_not_wrapped("gestaltATSUUnderlineOptionsStyleFeature")
        self.assert_not_wrapped("gestaltATSUStrikeThroughStyleFeature")
        self.assert_not_wrapped("gestaltATSUDropShadowStyleFeature")
        self.assert_not_wrapped("gestaltUSBAttr")
        self.assert_not_wrapped("gestaltUSBPresent")
        self.assert_not_wrapped("gestaltUSBHasIsoch")
        self.assert_not_wrapped("gestaltUSBVersion")
        self.assert_not_wrapped("gestaltVersion")
        self.assert_not_wrapped("gestaltValueImplementedVers")
        self.assert_not_wrapped("gestaltVIA1Addr")
        self.assert_not_wrapped("gestaltVIA2Addr")
        self.assert_not_wrapped("gestaltVMAttr")
        self.assert_not_wrapped("gestaltVMPresent")
        self.assert_not_wrapped("gestaltVMHasLockMemoryForOutput")
        self.assert_not_wrapped("gestaltVMFilemappingOn")
        self.assert_not_wrapped("gestaltVMHasPagingControl")
        self.assert_not_wrapped("gestaltVMInfoType")
        self.assert_not_wrapped("gestaltVMInfoSizeStorageType")
        self.assert_not_wrapped("gestaltVMInfoSizeType")
        self.assert_not_wrapped("gestaltVMInfoSimpleType")
        self.assert_not_wrapped("gestaltVMInfoNoneType")
        self.assert_not_wrapped("gestaltVMBackingStoreFileRefNum")
        self.assert_not_wrapped("gestaltALMVers")
        self.assert_not_wrapped("gestaltWindowMgrAttr")
        self.assert_not_wrapped("gestaltWindowMgrPresent")
        self.assert_not_wrapped("gestaltWindowMgrPresentBit")
        self.assert_not_wrapped("gestaltExtendedWindowAttributes")
        self.assert_not_wrapped("gestaltExtendedWindowAttributesBit")
        self.assert_not_wrapped("gestaltHasFloatingWindows")
        self.assert_not_wrapped("gestaltHasFloatingWindowsBit")
        self.assert_not_wrapped("gestaltHasWindowBuffering")
        self.assert_not_wrapped("gestaltHasWindowBufferingBit")
        self.assert_not_wrapped("gestaltWindowLiveResizeBit")
        self.assert_not_wrapped("gestaltWindowMinimizeToDockBit")
        self.assert_not_wrapped("gestaltHasWindowShadowsBit")
        self.assert_not_wrapped("gestaltSheetsAreWindowModalBit")
        self.assert_not_wrapped("gestaltFrontWindowMayBeHiddenBit")
        self.assert_not_wrapped("gestaltWindowMgrPresentMask")
        self.assert_not_wrapped("gestaltExtendedWindowAttributesMask")
        self.assert_not_wrapped("gestaltHasFloatingWindowsMask")
        self.assert_not_wrapped("gestaltHasWindowBufferingMask")
        self.assert_not_wrapped("gestaltWindowLiveResizeMask")
        self.assert_not_wrapped("gestaltWindowMinimizeToDockMask")
        self.assert_not_wrapped("gestaltHasWindowShadowsMask")
        self.assert_not_wrapped("gestaltSheetsAreWindowModalMask")
        self.assert_not_wrapped("gestaltFrontWindowMayBeHiddenMask")
        self.assert_not_wrapped("gestaltHasSingleWindowModeBit")
        self.assert_not_wrapped("gestaltHasSingleWindowModeMask")
        self.assert_not_wrapped("gestaltX86Features")
        self.assert_not_wrapped("gestaltX86HasFPU")
        self.assert_not_wrapped("gestaltX86HasVME")
        self.assert_not_wrapped("gestaltX86HasDE")
        self.assert_not_wrapped("gestaltX86HasPSE")
        self.assert_not_wrapped("gestaltX86HasTSC")
        self.assert_not_wrapped("gestaltX86HasMSR")
        self.assert_not_wrapped("gestaltX86HasPAE")
        self.assert_not_wrapped("gestaltX86HasMCE")
        self.assert_not_wrapped("gestaltX86HasCX8")
        self.assert_not_wrapped("gestaltX86HasAPIC")
        self.assert_not_wrapped("gestaltX86HasSEP")
        self.assert_not_wrapped("gestaltX86HasMTRR")
        self.assert_not_wrapped("gestaltX86HasPGE")
        self.assert_not_wrapped("gestaltX86HasMCA")
        self.assert_not_wrapped("gestaltX86HasCMOV")
        self.assert_not_wrapped("gestaltX86HasPAT")
        self.assert_not_wrapped("gestaltX86HasPSE36")
        self.assert_not_wrapped("gestaltX86HasPSN")
        self.assert_not_wrapped("gestaltX86HasCLFSH")
        self.assert_not_wrapped("gestaltX86Serviced20")
        self.assert_not_wrapped("gestaltX86HasDS")
        self.assert_not_wrapped("gestaltX86ResACPI")
        self.assert_not_wrapped("gestaltX86HasMMX")
        self.assert_not_wrapped("gestaltX86HasFXSR")
        self.assert_not_wrapped("gestaltX86HasSSE")
        self.assert_not_wrapped("gestaltX86HasSSE2")
        self.assert_not_wrapped("gestaltX86HasSS")
        self.assert_not_wrapped("gestaltX86HasHTT")
        self.assert_not_wrapped("gestaltX86HasTM")
        self.assert_not_wrapped("gestaltX86AdditionalFeatures")
        self.assert_not_wrapped("gestaltX86HasSSE3")
        self.assert_not_wrapped("gestaltX86HasMONITOR")
        self.assert_not_wrapped("gestaltX86HasDSCPL")
        self.assert_not_wrapped("gestaltX86HasVMX")
        self.assert_not_wrapped("gestaltX86HasSMX")
        self.assert_not_wrapped("gestaltX86HasEST")
        self.assert_not_wrapped("gestaltX86HasTM2")
        self.assert_not_wrapped("gestaltX86HasSupplementalSSE3")
        self.assert_not_wrapped("gestaltX86HasCID")
        self.assert_not_wrapped("gestaltX86HasCX16")
        self.assert_not_wrapped("gestaltX86HasxTPR")
        self.assert_not_wrapped("gestaltTranslationAttr")
        self.assert_not_wrapped("gestaltTranslationMgrExists")
        self.assert_not_wrapped("gestaltTranslationMgrHintOrder")
        self.assert_not_wrapped("gestaltTranslationPPCAvail")
        self.assert_not_wrapped("gestaltTranslationGetPathAPIAvail")
        self.assert_not_wrapped("gestaltExtToolboxTable")
        self.assert_not_wrapped("gestaltUSBPrinterSharingVersion")
        self.assert_not_wrapped("gestaltUSBPrinterSharingVersionMask")
        self.assert_not_wrapped("gestaltUSBPrinterSharingAttr")
        self.assert_not_wrapped("gestaltUSBPrinterSharingAttrMask")
        self.assert_not_wrapped("gestaltUSBPrinterSharingAttrRunning")
        self.assert_not_wrapped("gestaltUSBPrinterSharingAttrBooted")
        self.assert_not_wrapped("gestaltWorldScriptIIVersion")
        self.assert_not_wrapped("gestaltWorldScriptIIAttr")
        self.assert_not_wrapped("gestaltWSIICanPrintWithoutPrGeneralBit")
        self.assert_not_wrapped("")
