/*  $Id: Intersection.h,v 1.1 2012/07/08 09:35:53 sarrazip Exp $
    Intersection.h - Point in the snake where a loop is closed.

    quadrupleback - A video game where intruders must be circled.
    Copyright (C) 2012 Pierre Sarrazin <http://sarrazip.com/>

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
    02110-1301, USA.
*/

#ifndef _H_Intersection
#define _H_Intersection

#include <flatzebra/RCouple.h>

#include "util.h"

#include <stddef.h>
#include <assert.h>


class Intersection
{
public:
    Intersection(const flatzebra::RCouple &_point,
                 size_t _indexOfFirstSegment,
                 size_t _indexOfSecondSegment)
    :   point(_point),
        indexOfFirstSegment(_indexOfFirstSegment),
        indexOfSecondSegment(_indexOfSecondSegment),
        loops()
    {
    }

    ~Intersection()
    {
        deleteVectorElements(loops);
    }

    std::vector<flatzebra::RCouple> *addLoop()
    {
        loops.push_back(new std::vector<flatzebra::RCouple>());
        return loops.back();
    }

    bool operator == (const Intersection &rhs) const
    {
        return point == rhs.point
            && indexOfFirstSegment == rhs.indexOfFirstSegment
            && indexOfSecondSegment == rhs.indexOfSecondSegment;
    }

    const std::vector<std::vector<flatzebra::RCouple> *> &getLoops() const
    {
        return loops;
    }

    flatzebra::RCouple point;  // coordinates of the intersection point, relative to game area
    size_t indexOfFirstSegment;   // physical index of point that starts 1st intersecting segment
    size_t indexOfSecondSegment;  // physical index of point that starts 2nd intersecting segment

private:

    // Forbidden operations:
    Intersection(const Intersection &);
    Intersection &operator = (const Intersection &);

private:
    std::vector<std::vector<flatzebra::RCouple> *> loops;  // elements must come from 'new'

};


#endif  /* _H_Intersection */
