pub mod terminal;

mod context;

pub use context::CommandContext;

// Trait-based command system
pub mod builtin;
pub mod id;
pub mod macros;
pub mod registry;
pub mod traits;

pub use {
    id::CommandId,
    registry::{CommandRegistry, RegistryError},
    traits::{
        CommandLineAction, CommandResult, CommandTrait, DeferredAction, DeferredActionHandler,
        ExecutionContext, FileAction, OperatorContext,
    },
};
